(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     73049,       3370]*)
(*NotebookOutlinePosition[     73693,       3392]*)
(*  CellTagsIndexPosition[     73649,       3388]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", " ", Cell["\<\
I15PLANIDS
Normal incidence. Plane parallel plate, reflected and transmitted intensity \
depending on wavelength for fixed thickness.
      
The reflection coefficients are calculated from Fresnels formulas for \
\[Theta] = 0. Refractive indices n1, n2 and n3 may all be different and the \
reflection coefficient for both surfaces are calculated.
    
The calculation of the fringe pattern is done depending on \[Lambda] for \
fixed D.
\[CapitalDelta] = 2\[Pi]/\[Lambda] 2dn2\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n2\  = \ 1.5;\), "\[IndentingNewLine]",
   
    RowBox[{\(n3\  = \ 1;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(r12\  = \ \((n2 - n1)\)/\((n2 + n1)\);\), \( (*\ 
        r12\  = \ 0.2\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(r23\  = \ \((n3 - n2)\)/\((n3 + n2)\);\), \( (*\ 
        r23\  = \ \(-0.2\)\ *) \), 
      "\[IndentingNewLine]", \( (*\ \[CapitalDelta] = 
          2  \[Pi]/\[Lambda]\ 2  dn2\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        Range[0.021, 1, 0.001];\), "\[IndentingNewLine]", \(DD\  = \ 
        0.2;\), "\[IndentingNewLine]", \(IT[\[Lambda]_] = \ \((\((1 - 
                  r12^2)\)*\((1 - 
                  r23^2)\))\)/\((1 + \((r12*r23)\)^2 - \((2*r12*r23)\)*
                Cos[4*Pi*\((DD/\[Lambda])\)*n2])\);\), "\[IndentingNewLine]", 
  
    RowBox[{\(IR[\[Lambda]_]\  = \ 1 - IT[\[Lambda]];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Transmitted\ pattern\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Lambda], N[IT[\[Lambda]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Lambda]\>", "\<IT[\[Lambda]]\>"}, 
            PlotRange \[Rule] {{0, 1}, {0, 1}}], {{{Hue[
                  1], "\<IT[\[Lambda]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Reflected\ pattern\ *) \)}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Lambda], N[IR[\[Lambda]]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Lambda]\>", "\<IR[\[Lambda]]\>"}, 
          PlotRange \[Rule] {{0, 1}, {0, 1}}], {{{Hue[
                1], "\<IR[\[Lambda]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .41901 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.346651 0.322841 0.209503 0.322841 [
[ 0 0 0 0 ]
[ 1 .41901 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00997634 0.669492 0.40903 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[.2 -0.0125 -9 -9 ]
[.2 -0.0125 9 0 ]
[.4 -0.0125 -9 -9 ]
[.4 -0.0125 9 0 ]
[.6 -0.0125 -9 -9 ]
[.6 -0.0125 9 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -3 -9 ]
[1 -0.0125 3 0 ]
[1.025 0 0 -6.28125 ]
[1.025 0 10 6.28125 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[0 .64303 -17 0 ]
[0 .64303 17 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2 0 m
.2 .00625 L
s
[(0.2)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(0.4)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(0.6)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(0.8)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(1)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(l) show
69.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(IT) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.000 12.813 moveto
(@) show
81.000 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(l) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.000 12.813 moveto
(D) show
93.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.021 .61277 m
.022 .57521 L
.023 .53234 L
.024 .52661 L
.025 .52661 L
.026 .53111 L
.027 .56089 L
.028 .61277 L
.029 .58599 L
.03 .52661 L
.031 .5979 L
.032 .56867 L
.033 .55041 L
.034 .59743 L
.035 .54169 L
.036 .59233 L
.037 .55926 L
.038 .55773 L
.039 .60483 L
.04 .52661 L
.041 .60059 L
.042 .57896 L
.043 .52827 L
.044 .60006 L
.045 .59233 L
.046 .52806 L
.047 .56416 L
.048 .61803 L
.049 .56722 L
.05 .52661 L
.051 .56451 L
.052 .61648 L
.053 .5889 L
.054 .53588 L
.055 .53287 L
.056 .57896 L
.057 .6173 L
.058 .59536 L
.059 .54748 L
.06 .52661 L
.061 .54621 L
.062 .5894 L
.063 .61744 L
.064 .60271 L
.065 .56325 L
.066 .53287 L
.067 .52814 L
.068 .54912 L
.069 .5843 L
.07 .61277 L
Mistroke
.071 .61549 L
.072 .59233 L
.073 .56006 L
.074 .5354 L
.075 .52661 L
.076 .53495 L
.077 .55701 L
.078 .58525 L
.079 .60891 L
.08 .61803 L
.081 .60933 L
.082 .58788 L
.083 .56273 L
.084 .54169 L
.085 .52925 L
.086 .52702 L
.087 .53467 L
.088 .55041 L
.089 .57108 L
.09 .59233 L
.091 .60919 L
.092 .61753 L
.093 .61558 L
.094 .60448 L
.095 .58752 L
.096 .56867 L
.097 .55133 L
.098 .53781 L
.099 .52941 L
.1 .52661 L
.101 .5293 L
.102 .53697 L
.103 .54871 L
.104 .56325 L
.105 .57896 L
.106 .594 L
.107 .60648 L
.108 .61482 L
.109 .61801 L
.11 .61587 L
.111 .60897 L
.112 .59847 L
.113 .58582 L
.114 .57245 L
.115 .55958 L
.116 .54816 L
.117 .53886 L
.118 .53206 L
.119 .52796 L
.12 .52661 L
Mistroke
.121 .52792 L
.122 .53171 L
.123 .53772 L
.124 .54562 L
.125 .55497 L
.126 .5653 L
.127 .57604 L
.128 .5866 L
.129 .59639 L
.13 .60483 L
.131 .61144 L
.132 .61587 L
.133 .6179 L
.134 .6175 L
.135 .61482 L
.136 .6101 L
.137 .60373 L
.138 .59613 L
.139 .58773 L
.14 .57896 L
.141 .57019 L
.142 .56175 L
.143 .55389 L
.144 .54683 L
.145 .54071 L
.146 .53564 L
.147 .53167 L
.148 .52884 L
.149 .52716 L
.15 .52661 L
.151 .52715 L
.152 .52873 L
.153 .53128 L
.154 .53474 L
.155 .53901 L
.156 .54399 L
.157 .54957 L
.158 .55563 L
.159 .56204 L
.16 .56867 L
.161 .57537 L
.162 .582 L
.163 .58842 L
.164 .59448 L
.165 .60006 L
.166 .60503 L
.167 .60929 L
.168 .61277 L
.169 .61539 L
.17 .61712 L
Mistroke
.171 .61795 L
.172 .61789 L
.173 .61697 L
.174 .61524 L
.175 .61277 L
.176 .60963 L
.177 .60593 L
.178 .60174 L
.179 .59718 L
.18 .59233 L
.181 .58728 L
.182 .58212 L
.183 .57693 L
.184 .57179 L
.185 .56675 L
.186 .56187 L
.187 .55721 L
.188 .5528 L
.189 .54868 L
.19 .54487 L
.191 .54139 L
.192 .53827 L
.193 .53551 L
.194 .53312 L
.195 .53111 L
.196 .52947 L
.197 .52821 L
.198 .52731 L
.199 .52678 L
.2 .52661 L
.201 .52678 L
.202 .52729 L
.203 .52811 L
.204 .52925 L
.205 .53068 L
.206 .5324 L
.207 .53437 L
.208 .53659 L
.209 .53904 L
.21 .54169 L
.211 .54454 L
.212 .54756 L
.213 .55072 L
.214 .55401 L
.215 .55741 L
.216 .56089 L
.217 .56443 L
.218 .56802 L
.219 .57162 L
.22 .57521 L
Mistroke
.221 .57877 L
.222 .58229 L
.223 .58573 L
.224 .58909 L
.225 .59233 L
.226 .59544 L
.227 .5984 L
.228 .60119 L
.229 .60381 L
.23 .60623 L
.231 .60845 L
.232 .61045 L
.233 .61223 L
.234 .61377 L
.235 .61508 L
.236 .61615 L
.237 .61698 L
.238 .61757 L
.239 .61792 L
.24 .61803 L
.241 .61792 L
.242 .61758 L
.243 .61703 L
.244 .61627 L
.245 .61531 L
.246 .61417 L
.247 .61285 L
.248 .61137 L
.249 .60973 L
.25 .60796 L
.251 .60605 L
.252 .60404 L
.253 .60192 L
.254 .59971 L
.255 .59743 L
.256 .59508 L
.257 .59267 L
.258 .59023 L
.259 .58775 L
.26 .58525 L
.261 .58273 L
.262 .58022 L
.263 .57771 L
.264 .57521 L
.265 .57273 L
.266 .57028 L
.267 .56787 L
.268 .5655 L
.269 .56317 L
.27 .56089 L
Mistroke
.271 .55867 L
.272 .55651 L
.273 .55441 L
.274 .55237 L
.275 .55041 L
.276 .54851 L
.277 .54669 L
.278 .54495 L
.279 .54328 L
.28 .54169 L
.281 .54018 L
.282 .53876 L
.283 .53741 L
.284 .53614 L
.285 .53495 L
.286 .53385 L
.287 .53282 L
.288 .53188 L
.289 .53102 L
.29 .53023 L
.291 .52953 L
.292 .5289 L
.293 .52836 L
.294 .52789 L
.295 .52749 L
.296 .52717 L
.297 .52692 L
.298 .52675 L
.299 .52664 L
.3 .52661 L
.301 .52664 L
.302 .52674 L
.303 .52691 L
.304 .52714 L
.305 .52743 L
.306 .52779 L
.307 .5282 L
.308 .52867 L
.309 .5292 L
.31 .52978 L
.311 .53042 L
.312 .53111 L
.313 .53185 L
.314 .53263 L
.315 .53347 L
.316 .53434 L
.317 .53526 L
.318 .53623 L
.319 .53723 L
.32 .53827 L
Mistroke
.321 .53935 L
.322 .54046 L
.323 .5416 L
.324 .54278 L
.325 .54399 L
.326 .54522 L
.327 .54648 L
.328 .54777 L
.329 .54908 L
.33 .55041 L
.331 .55176 L
.332 .55312 L
.333 .55451 L
.334 .55591 L
.335 .55732 L
.336 .55874 L
.337 .56017 L
.338 .56161 L
.339 .56306 L
.34 .56451 L
.341 .56596 L
.342 .56742 L
.343 .56888 L
.344 .57033 L
.345 .57179 L
.346 .57324 L
.347 .57468 L
.348 .57611 L
.349 .57754 L
.35 .57896 L
.351 .58037 L
.352 .58176 L
.353 .58314 L
.354 .58451 L
.355 .58586 L
.356 .58719 L
.357 .5885 L
.358 .5898 L
.359 .59107 L
.36 .59233 L
.361 .59356 L
.362 .59476 L
.363 .59594 L
.364 .5971 L
.365 .59823 L
.366 .59934 L
.367 .60041 L
.368 .60146 L
.369 .60248 L
.37 .60347 L
Mistroke
.371 .60443 L
.372 .60536 L
.373 .60625 L
.374 .60712 L
.375 .60796 L
.376 .60876 L
.377 .60953 L
.378 .61026 L
.379 .61097 L
.38 .61163 L
.381 .61227 L
.382 .61287 L
.383 .61344 L
.384 .61398 L
.385 .61448 L
.386 .61495 L
.387 .61538 L
.388 .61578 L
.389 .61615 L
.39 .61648 L
.391 .61678 L
.392 .61705 L
.393 .61728 L
.394 .61748 L
.395 .61765 L
.396 .61779 L
.397 .6179 L
.398 .61797 L
.399 .61802 L
.4 .61803 L
.401 .61802 L
.402 .61798 L
.403 .6179 L
.404 .6178 L
.405 .61767 L
.406 .61751 L
.407 .61733 L
.408 .61712 L
.409 .61689 L
.41 .61663 L
.411 .61634 L
.412 .61603 L
.413 .6157 L
.414 .61534 L
.415 .61497 L
.416 .61457 L
.417 .61415 L
.418 .61371 L
.419 .61325 L
.42 .61277 L
Mistroke
.421 .61227 L
.422 .61175 L
.423 .61122 L
.424 .61067 L
.425 .6101 L
.426 .60952 L
.427 .60892 L
.428 .60831 L
.429 .60769 L
.43 .60705 L
.431 .6064 L
.432 .60573 L
.433 .60506 L
.434 .60437 L
.435 .60368 L
.436 .60297 L
.437 .60225 L
.438 .60153 L
.439 .6008 L
.44 .60006 L
.441 .59931 L
.442 .59855 L
.443 .59779 L
.444 .59703 L
.445 .59625 L
.446 .59548 L
.447 .59469 L
.448 .59391 L
.449 .59312 L
.45 .59233 L
.451 .59153 L
.452 .59073 L
.453 .58993 L
.454 .58913 L
.455 .58832 L
.456 .58752 L
.457 .58672 L
.458 .58591 L
.459 .5851 L
.46 .5843 L
.461 .58349 L
.462 .58269 L
.463 .58189 L
.464 .58109 L
.465 .58029 L
.466 .57949 L
.467 .5787 L
.468 .5779 L
.469 .57711 L
.47 .57633 L
Mistroke
.471 .57554 L
.472 .57476 L
.473 .57399 L
.474 .57321 L
.475 .57245 L
.476 .57168 L
.477 .57092 L
.478 .57017 L
.479 .56942 L
.48 .56867 L
.481 .56793 L
.482 .56719 L
.483 .56646 L
.484 .56574 L
.485 .56502 L
.486 .56431 L
.487 .5636 L
.488 .5629 L
.489 .5622 L
.49 .56151 L
.491 .56083 L
.492 .56015 L
.493 .55948 L
.494 .55882 L
.495 .55816 L
.496 .55751 L
.497 .55686 L
.498 .55623 L
.499 .5556 L
.5 .55497 L
.501 .55436 L
.502 .55375 L
.503 .55314 L
.504 .55255 L
.505 .55196 L
.506 .55138 L
.507 .5508 L
.508 .55023 L
.509 .54967 L
.51 .54912 L
.511 .54857 L
.512 .54804 L
.513 .5475 L
.514 .54698 L
.515 .54646 L
.516 .54595 L
.517 .54545 L
.518 .54496 L
.519 .54447 L
.52 .54399 L
Mistroke
.521 .54351 L
.522 .54305 L
.523 .54259 L
.524 .54214 L
.525 .54169 L
.526 .54126 L
.527 .54083 L
.528 .5404 L
.529 .53999 L
.53 .53958 L
.531 .53918 L
.532 .53878 L
.533 .5384 L
.534 .53802 L
.535 .53764 L
.536 .53728 L
.537 .53692 L
.538 .53657 L
.539 .53622 L
.54 .53588 L
.541 .53555 L
.542 .53523 L
.543 .53491 L
.544 .5346 L
.545 .53429 L
.546 .53399 L
.547 .5337 L
.548 .53342 L
.549 .53314 L
.55 .53287 L
.551 .5326 L
.552 .53234 L
.553 .53209 L
.554 .53184 L
.555 .5316 L
.556 .53137 L
.557 .53114 L
.558 .53092 L
.559 .5307 L
.56 .53049 L
.561 .53029 L
.562 .53009 L
.563 .5299 L
.564 .52972 L
.565 .52954 L
.566 .52936 L
.567 .5292 L
.568 .52903 L
.569 .52888 L
.57 .52873 L
Mistroke
.571 .52858 L
.572 .52844 L
.573 .52831 L
.574 .52818 L
.575 .52806 L
.576 .52794 L
.577 .52783 L
.578 .52772 L
.579 .52762 L
.58 .52752 L
.581 .52743 L
.582 .52734 L
.583 .52726 L
.584 .52719 L
.585 .52711 L
.586 .52705 L
.587 .52699 L
.588 .52693 L
.589 .52688 L
.59 .52683 L
.591 .52679 L
.592 .52675 L
.593 .52672 L
.594 .52669 L
.595 .52666 L
.596 .52664 L
.597 .52663 L
.598 .52662 L
.599 .52661 L
.6 .52661 L
.601 .52661 L
.602 .52662 L
.603 .52663 L
.604 .52664 L
.605 .52666 L
.606 .52668 L
.607 .52671 L
.608 .52674 L
.609 .52678 L
.61 .52682 L
.611 .52686 L
.612 .5269 L
.613 .52695 L
.614 .52701 L
.615 .52707 L
.616 .52713 L
.617 .52719 L
.618 .52726 L
.619 .52733 L
.62 .52741 L
Mistroke
.621 .52749 L
.622 .52757 L
.623 .52765 L
.624 .52774 L
.625 .52784 L
.626 .52793 L
.627 .52803 L
.628 .52813 L
.629 .52824 L
.63 .52835 L
.631 .52846 L
.632 .52857 L
.633 .52869 L
.634 .52881 L
.635 .52893 L
.636 .52906 L
.637 .52919 L
.638 .52932 L
.639 .52945 L
.64 .52959 L
.641 .52973 L
.642 .52987 L
.643 .53002 L
.644 .53017 L
.645 .53032 L
.646 .53047 L
.647 .53063 L
.648 .53078 L
.649 .53095 L
.65 .53111 L
.651 .53127 L
.652 .53144 L
.653 .53161 L
.654 .53178 L
.655 .53196 L
.656 .53214 L
.657 .53232 L
.658 .5325 L
.659 .53268 L
.66 .53287 L
.661 .53305 L
.662 .53324 L
.663 .53343 L
.664 .53363 L
.665 .53382 L
.666 .53402 L
.667 .53422 L
.668 .53442 L
.669 .53463 L
.67 .53483 L
Mistroke
.671 .53504 L
.672 .53525 L
.673 .53546 L
.674 .53567 L
.675 .53588 L
.676 .5361 L
.677 .53631 L
.678 .53653 L
.679 .53675 L
.68 .53697 L
.681 .5372 L
.682 .53742 L
.683 .53765 L
.684 .53788 L
.685 .53811 L
.686 .53834 L
.687 .53857 L
.688 .5388 L
.689 .53904 L
.69 .53927 L
.691 .53951 L
.692 .53975 L
.693 .53999 L
.694 .54023 L
.695 .54047 L
.696 .54071 L
.697 .54096 L
.698 .5412 L
.699 .54145 L
.7 .54169 L
.701 .54194 L
.702 .54219 L
.703 .54244 L
.704 .54269 L
.705 .54295 L
.706 .5432 L
.707 .54345 L
.708 .54371 L
.709 .54396 L
.71 .54422 L
.711 .54448 L
.712 .54474 L
.713 .545 L
.714 .54526 L
.715 .54552 L
.716 .54578 L
.717 .54604 L
.718 .5463 L
.719 .54657 L
.72 .54683 L
Mistroke
.721 .5471 L
.722 .54736 L
.723 .54763 L
.724 .54789 L
.725 .54816 L
.726 .54843 L
.727 .5487 L
.728 .54897 L
.729 .54924 L
.73 .54951 L
.731 .54978 L
.732 .55005 L
.733 .55032 L
.734 .55059 L
.735 .55086 L
.736 .55113 L
.737 .55141 L
.738 .55168 L
.739 .55195 L
.74 .55222 L
.741 .5525 L
.742 .55277 L
.743 .55305 L
.744 .55332 L
.745 .5536 L
.746 .55387 L
.747 .55415 L
.748 .55442 L
.749 .5547 L
.75 .55497 L
.751 .55525 L
.752 .55552 L
.753 .5558 L
.754 .55608 L
.755 .55635 L
.756 .55663 L
.757 .55691 L
.758 .55718 L
.759 .55746 L
.76 .55773 L
.761 .55801 L
.762 .55829 L
.763 .55856 L
.764 .55884 L
.765 .55912 L
.766 .55939 L
.767 .55967 L
.768 .55995 L
.769 .56022 L
.77 .5605 L
Mistroke
.771 .56077 L
.772 .56105 L
.773 .56132 L
.774 .5616 L
.775 .56187 L
.776 .56215 L
.777 .56242 L
.778 .5627 L
.779 .56297 L
.78 .56325 L
.781 .56352 L
.782 .5638 L
.783 .56407 L
.784 .56434 L
.785 .56461 L
.786 .56489 L
.787 .56516 L
.788 .56543 L
.789 .5657 L
.79 .56598 L
.791 .56625 L
.792 .56652 L
.793 .56679 L
.794 .56706 L
.795 .56733 L
.796 .5676 L
.797 .56787 L
.798 .56813 L
.799 .5684 L
.8 .56867 L
.801 .56894 L
.802 .5692 L
.803 .56947 L
.804 .56974 L
.805 .57 L
.806 .57027 L
.807 .57053 L
.808 .5708 L
.809 .57106 L
.81 .57132 L
.811 .57159 L
.812 .57185 L
.813 .57211 L
.814 .57237 L
.815 .57263 L
.816 .57289 L
.817 .57315 L
.818 .57341 L
.819 .57367 L
.82 .57393 L
Mistroke
.821 .57418 L
.822 .57444 L
.823 .5747 L
.824 .57495 L
.825 .57521 L
.826 .57546 L
.827 .57572 L
.828 .57597 L
.829 .57622 L
.83 .57647 L
.831 .57673 L
.832 .57698 L
.833 .57723 L
.834 .57748 L
.835 .57773 L
.836 .57797 L
.837 .57822 L
.838 .57847 L
.839 .57871 L
.84 .57896 L
.841 .57921 L
.842 .57945 L
.843 .57969 L
.844 .57994 L
.845 .58018 L
.846 .58042 L
.847 .58066 L
.848 .5809 L
.849 .58114 L
.85 .58138 L
.851 .58162 L
.852 .58185 L
.853 .58209 L
.854 .58233 L
.855 .58256 L
.856 .58279 L
.857 .58303 L
.858 .58326 L
.859 .58349 L
.86 .58372 L
.861 .58395 L
.862 .58418 L
.863 .58441 L
.864 .58464 L
.865 .58487 L
.866 .5851 L
.867 .58532 L
.868 .58555 L
.869 .58577 L
.87 .58599 L
Mistroke
.871 .58622 L
.872 .58644 L
.873 .58666 L
.874 .58688 L
.875 .5871 L
.876 .58732 L
.877 .58754 L
.878 .58775 L
.879 .58797 L
.88 .58819 L
.881 .5884 L
.882 .58862 L
.883 .58883 L
.884 .58904 L
.885 .58925 L
.886 .58946 L
.887 .58967 L
.888 .58988 L
.889 .59009 L
.89 .5903 L
.891 .5905 L
.892 .59071 L
.893 .59091 L
.894 .59112 L
.895 .59132 L
.896 .59152 L
.897 .59173 L
.898 .59193 L
.899 .59213 L
.9 .59233 L
.901 .59252 L
.902 .59272 L
.903 .59292 L
.904 .59311 L
.905 .59331 L
.906 .5935 L
.907 .5937 L
.908 .59389 L
.909 .59408 L
.91 .59427 L
.911 .59446 L
.912 .59465 L
.913 .59484 L
.914 .59502 L
.915 .59521 L
.916 .5954 L
.917 .59558 L
.918 .59576 L
.919 .59595 L
.92 .59613 L
Mistroke
.921 .59631 L
.922 .59649 L
.923 .59667 L
.924 .59685 L
.925 .59703 L
.926 .5972 L
.927 .59738 L
.928 .59755 L
.929 .59773 L
.93 .5979 L
.931 .59807 L
.932 .59825 L
.933 .59842 L
.934 .59859 L
.935 .59876 L
.936 .59892 L
.937 .59909 L
.938 .59926 L
.939 .59942 L
.94 .59959 L
.941 .59975 L
.942 .59992 L
.943 .60008 L
.944 .60024 L
.945 .6004 L
.946 .60056 L
.947 .60072 L
.948 .60088 L
.949 .60104 L
.95 .60119 L
.951 .60135 L
.952 .6015 L
.953 .60166 L
.954 .60181 L
.955 .60196 L
.956 .60211 L
.957 .60226 L
.958 .60241 L
.959 .60256 L
.96 .60271 L
.961 .60286 L
.962 .603 L
.963 .60315 L
.964 .60329 L
.965 .60344 L
.966 .60358 L
.967 .60372 L
.968 .60386 L
.969 .604 L
.97 .60414 L
Mistroke
.971 .60428 L
.972 .60442 L
.973 .60456 L
.974 .60469 L
.975 .60483 L
.976 .60496 L
.977 .6051 L
.978 .60523 L
.979 .60536 L
.98 .6055 L
.981 .60563 L
.982 .60576 L
.983 .60588 L
.984 .60601 L
.985 .60614 L
.986 .60627 L
.987 .60639 L
.988 .60652 L
.989 .60664 L
.99 .60677 L
.991 .60689 L
.992 .60701 L
.993 .60713 L
.994 .60725 L
.995 .60737 L
.996 .60749 L
.997 .60761 L
.998 .60772 L
.999 .60784 L
1 .60796 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
0 g
.71792 .19336 m
.71792 .2979 L
.97619 .2979 L
.97619 .19336 L
F
1 g
.70178 .2095 m
.70178 .31404 L
.96005 .31404 L
.96005 .2095 L
F
0 g
.001 w
[ ] 0 setdash
.70178 .2095 m
.96005 .2095 L
.96005 .31404 L
.70178 .31404 L
.70178 .2095 L
s
% Start of sub-graphic
p
0.701776 0.209503 0.960048 0.314042 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .40476 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .40476 L
0 .40476 L
closepath
clip
newpath
1 0 0 r
.05357 .05357 m
.05357 .35119 L
.35119 .35119 L
.35119 .05357 L
F
0 g
gsave
.38988 .20238 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(IT) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.000 12.813 moveto
(@) show
81.000 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(l) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.000 12.813 moveto
(D) show
93.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .41901 L
0 .41901 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 120.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00=@3oool2000000@0oooo0P00
00030?ooo`@000003@3oool2000000@0oooo0P0000050?ooo`<00000303oool2000000@0oooo0P00
00030?ooo`<000003`3oool2000000@0oooo0P0000040?ooo`8000004`3oool500000700oooo000d
0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool03@3oool010000000oooo0?oo
o`00000;0?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`00000=0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000503o
ool00`000000oooo0?ooo`1`0?ooo`00=03oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo00`0oooo00@000000?ooo`3oool00000203oool5000000/0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`00000=0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool00000503oool00`000000oooo0?ooo`1`0?ooo`00=03oool010000000oooo0?ooo`00
000:0?ooo`030000003oool0oooo00/0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`00000<0?ooo`040000003oool0oooo000000P0oooo0`00000>0?ooo`040000003oool0oooo
000000T0oooo0P00000E0?ooo`030000003oool0oooo0700oooo000d0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool00000303oool010000000oooo0?ooo`0000090?ooo`030000
003oool0000000`0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0=0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool00000503oool00`000000oooo0?ooo`1`
0?ooo`00=@3oool2000000X0oooo0P00000>0?ooo`8000002`3oool2000000d0oooo0P00000:0?oo
o`<000003P3oool2000000X0oooo0P00000D0?ooo`800000LP3oool00?l0oooo8@3oool00?l0oooo
8@3oool00;40oooo0`0000020?ooo`030000003oool0oooo06L0oooo002c0?ooo`030000003oool0
000006X0oooo000P0?ooohh000001P3oool2000006X0oooo000P0?ooo`030000003oool0oooo0980
oooo00<000000?ooo`3oool0J03oool00200oooo00<000000?ooo`3oool0TP3oool00`000000oooo
0?ooo`1X0?ooo`00803oool00`000000oooo0?ooo`2@0?ooo`800000J`3oool00200oooo00<00000
0?ooo`3oool0o@3oool00200oooo00<000000?ooo`3oool0o@3oool00200oooo00<000000?ooo`3o
ool0o@3oool00200oooo00<000000?ooo`3oool0o@3oool00200oooo00<000000?ooo`3oool0o@3o
ool00200oooo00<000000?ooo`3oool0o@3oool00200oooo00<000000?ooo`3oool0o@3oool00200
oooo00<000000?ooo`3oool0o@3oool00200oooo00<000000?ooo`3oool0o@3oool00200oooo00<0
00000?ooo`3oool0o@3oool00200oooo00<000000?ooo`3oool0o@3oool000h0oooo0P0000040?oo
o`8000000`3oool4000000<0oooo00<000000?ooo`3oool0o@3oool000d0oooo00@000000?ooo`3o
ool00000203oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?d0oooo000=0?ooo`04
0000003oool0oooo000000T0oooo00<000000?ooo`3oool00`3oool200000?h0oooo000=0?ooo`04
0000003oool0oooo000000X0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3m0?oo
o`003@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<00000
0?ooo`3oool0o@3oool000h0oooo0P00000:0?ooo`800000103oool00`000000oooo0?ooo`3m0?oo
o`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803o
ool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`00
0000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo
0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m
0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00
3P3oool2000000@0oooo0P0000050?ooo`<000000P3oool00`000000oooo0?ooo`3m0?ooo`003@3o
ool010000000oooo0?ooo`00000;0?ooo`050000003oool0oooo0?ooo`000000o`3oool000d0oooo
00@000000?ooo`3oool00000203oool500000080oooo0P00003n0?ooo`003@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0o@3oool000d0
oooo00@000000?ooo`3oool000002@3oool00`000000oooo000000030?ooo`030000003oool0oooo
0?d0oooo000>0?ooo`8000002`3oool2000000<0oooo00<000000?ooo`3oool0o@3oool00200oooo
00<000000?ooo`3oool0o@3oool00200oooo00<000000?ooo`3oool0o@3oool00200oooo00<00000
0?ooo`3oool0o@3oool00200oooo00<000000?ooo`3oool0o@3oool00200oooo00<000000?ooo`3o
ool0ZP3ooom:000000T0oooo000P0?ooo`030000003oool0oooo0:X0ooooBP0000090?ooo`00803o
ool00`000000oooo0?ooo`2Z0?ooodX000002@3oool00200oooo00<000000?ooo`3oool0ZP3ooom:
000000T0oooo000P0?ooo`030000003oool0oooo0:H0ooooCP0000090?ooo`00803oool00`000000
oooo0?ooo`2V0?ooo`030000003oool0oooo04H0oooo1@0000090?ooo`00803oool00`000000oooo
0?ooo`2V0?ooo`030000003oool0oooo04H0oooo1@0000090?ooo`00803oool00`000000oooo0?oo
o`2V0?ooo`030000003oool0oooo04H0oooo1@0000090?ooo`003P3oool2000000@0oooo0P000003
0?ooo`<00000103oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo04H0oooo1@000009
0?ooo`003@3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<0
00000?ooo`3oool0YP3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`003@3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo0P00002W0?ooo`04
0000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000=0?ooo`040000003oool0oooo0000
00P0oooo0`0000040?ooo`030000003oool0oooo0:H0oooo00@000000?ooo`3oool0oooo5@3o000`
0?ooo`D000002@3oool000d0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0:H0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3o
ool000h0oooo0P00000:0?ooo`<000000`3oool00`000000oooo0?ooo`2V0?ooo`040000003oool0
oooo0?oooaD0o`00<03oool5000000T0oooo000P0?ooo`030000003oool0oooo0:H0oooo00@00000
0?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool00200oooo00<000000?ooo`3oool0YP3oool0
10000000oooo0?ooo`3ooolE0?l001@0oooo0P0000080?ooo`800000403oool5000000T0oooo000P
0?ooo`030000003oool0oooo0:H0oooo00@000000?ooo`3oool0oooo5@3o000D0?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool03P3oool5000000T0oooo000P0?ooo`030000003oool0
oooo0:H0oooo00@000000?ooo`3oool0oooo5@3o00070?ooo`<000000P3oool3000000D0oooo00<0
00000?ooo`0000000P0000020?ooo`050000003oool0oooo0?ooo`000000403oool5000000T0oooo
000P0?ooo`030000003oool0oooo0:H0oooo00@000000?ooo`3oool0oooo5@3o00080?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool0103oool01`000000oooo0?ooo`3oool000000?oo
o`000000103oool00`000000oooo0?ooo`0>0?ooo`D000002@3oool00200oooo00<000000?ooo`3o
ool0YP3oool010000000oooo0?ooo`3ooolE0?l000P0oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo0P0000040?ooo`030000003oool0oooo
00h0oooo1@0000090?ooo`00803oool00`000000oooo0?ooo`2V0?ooo`040000003oool0oooo0?oo
oaD0o`00203oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00h0oooo1@0000090?oo
o`00803oool00`000000oooo0?ooo`2V0?ooo`040000003oool0oooo0?oooaD0o`00203oool02000
0000oooo0?ooo`000000oooo0000003oool00000103oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo0080oooo00<000000?ooo`3oool03P3oool5000000T0oooo000P0?ooo`030000003o
ool0oooo0:H0oooo00@000000?ooo`3oool0oooo5@3o00070?ooo`<0000000<0oooo000000000000
0`0000040?ooo`8000000P3oool2000000@0oooo0P00000@0?ooo`D000002@3oool00200oooo00<0
00000?ooo`3oool0YP3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00803o
ool00`000000oooo0?ooo`2V0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo
000>0?ooo`800000103oool2000000@0oooo0P0000040?ooo`030000003oool0oooo0:H0oooo00@0
00000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool000d0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0:H0oooo00@000000?ooo`3o
ool0oooo5@3o000`0?ooo`D000002@3oool000d0oooo00@000000?ooo`3oool00000203oool01000
0000oooo0?ooo`0000030?ooo`800000Y`3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@00
00090?ooo`003@3oool010000000oooo0?ooo`0000090?ooo`800000103oool00`000000oooo0?oo
o`2V0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000=0?ooo`040000003o
ool0oooo000000P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`2V0?ooo`04
0000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000>0?ooo`8000002P3oool2000000@0
oooo00<000000?ooo`3oool0YP3oool010000000oooo0?ooo`3ooolE0?l00300oooo00<000000?oo
o`3oool02`3oool00200oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`160?ooo`03
0000003oool0oooo00/0oooo000P0?ooo`030000003oool0oooo00P0o`0000D0oooo0?l0003oool0
o`000?ooo`020?l000<0oooo00<0o`000?ooo`3oool00`3oool30?l000X0oooo1@3o000Q0?ooo`l0
o`00C03oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00/0oooo000P0?ooo`030000
003oool0oooo00X0o`0000<0oooo0?l0003oool00P3o00020?ooo`030?l0003oool0o`0000@0oooo
00<0o`000?ooo`3o00002P3oool0103o0000oooo0?ooo`3oool20?l001d0oooo103o000=0?ooo`H0
o`00A`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00/0oooo000P0?ooo`030000
003oool0oooo00X0o`0000<0oooo0?l0003oool00P3o00020?ooo`030?l0003oool0o`0000@0oooo
00@0o`000?ooo`3o0000o`00203oool00`3o0000oooo0?ooo`030?ooo`80o`006P3oool30?l001D0
oooo1@3o00130?ooodX000003@3oool00200oooo00<000000?ooo`3oool02P3o00000`3oool0o`00
0?ooo`020?l00080oooo00<0o`000?ooo`3o00000`3oool01@3o0000oooo0?ooo`3oool0o`0000L0
oooo0P3o00060?ooo`80o`005`3oool20?l001`0oooo1@3o002F0?ooo`00803oool00`000000oooo
0?ooo`0:0?l000030?ooo`3o0000oooo0080o`000P3oool00`3o0000oooo0?l000030?ooo`050?l0
003oool0oooo0?ooo`3o00001`3oool00`3o0000oooo0?ooo`060?ooo`030?l0003oool0oooo01<0
oooo0`3o000Q0?ooo`@0o`00T`3oool00200oooo00<000000?ooo`3oool02`3o00002@3oool0o`00
0?l0003oool0o`000?ooo`3o0000oooo0?l000030?ooo`050?l0003oool0oooo0?ooo`3o00001`3o
ool00`3o0000oooo0?ooo`060?ooo`80o`004`3oool20?l002H0oooo1@3o002?0?ooo`00803oool0
0`000000oooo0?ooo`0;0?l000090?ooo`3o0000o`000?ooo`3o0000oooo0?l0003oool0o`0000<0
oooo00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`030?ooo`030?l0003oool0oooo00P0
oooo0P3o000A0?ooo`80o`00:`3oool50?l008/0oooo000P0?ooo`030000003oool0oooo00/0o`00
00L0oooo0?l0003o0000oooo0?l0003oool0o`000080oooo00@0o`000?ooo`3oool0o`00103oool0
0`3o0000oooo0?ooo`030?ooo`030?l0003oool0oooo00T0oooo00<0o`000?ooo`3oool03@3oool2
0?l00340oooo1@3o00270?ooo`00803oool00`000000oooo0?ooo`090?l000030?ooo`3o0000oooo
0080o`0000<0oooo0?l0003o00000`3oool00`3o0000oooo0?l000050?ooo`030?l0003oool0oooo
0080oooo0P3o000<0?ooo`030?l0003oool0oooo00/0oooo0P3o000f0?ooo`D0o`00P`3oool00200
oooo00<000000?ooo`3oool02@3o00000`3oool0o`000?ooo`020?l000030?ooo`3o0000o`0000<0
oooo00<0o`000?ooo`3o00001@3oool20?l000<0oooo00<0o`000?ooo`3oool02`3oool20?l000/0
oooo0P3o000k0?ooo`H0o`00OP3oool00200oooo00<000000?ooo`3oool02@3o00000`3oool0o`00
0?ooo`020?l000030?ooo`3o0000o`0000<0oooo00<0o`000?ooo`3o00001P3oool01@3o0000oooo
0?ooo`3oool0o`0000h0oooo0P3o00080?ooo`<0o`00@@3oool70?l007P0oooo000I0?ooo`D00000
0P3oool00`000000oooo0?ooo`030?l000030?ooo`3o0000o`0000<0o`0000@0oooo0?l0003oool0
o`000P3oool20?l000<0oooo00<0o`000?ooo`3o00001P3oool0103o0000oooo0?ooo`3o000@0?oo
o`80o`001P3oool20?l004X0oooo1P3o001b0?ooo`006`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080o`000P3oool50?l000040?ooo`3o0000oooo0?l00080oooo0P3o00040?oo
o`80o`001`3oool30?l00140oooo0`3o00000`3oool0o`000?l000020?l00<<0oooo000K0?ooo`03
0000003oool0oooo0080oooo0P0000050?ooo`090?l0003oool0o`000?ooo`3o0000oooo0?l0003o
ool0o`0000<0oooo00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`060?ooo`80o`00503o
ool30?l00<H0oooo000K0?ooo`030000003oool0oooo0?l0oooo0`3oool001/0oooo00<000000?oo
o`3oool0o`3oool30?ooo`006P3oool200000?l0oooo1@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00200oooo0P0000080?ooo`800000m03oool00200oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`3b0?ooo`004`3oool300000080oooo0`0000050?ooo`030000003oool000000080
00000P3oool01@000000oooo0?ooo`3oool000000?@0oooo000D0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0103oool01`000000oooo0?ooo`3oool000000?ooo`000000103oool0
0`000000oooo0?ooo`3b0?ooo`00503oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
00@0oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<000000?ooo`3oool0lP3oool001@0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3b0?ooo`00503oool020000000oooo
0?ooo`000000oooo0000003oool00000103oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0lP3oool001<0oooo0`0000000`3oool00000000000030000
00@0oooo0P0000020?ooo`800000103oool200000?@0oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {119.625, 0}} -> {-1.08192, -0.648936, \
0.0108496, 0.0108496}, {{7.5, 191.875}, {116.75, 2.8125}} -> {-0.229565, \
-0.156583, 0.00709647, 0.0114823}, {{201.063, 274.813}, {59.8125, 29.9375}} -> \
{-9.26038, -2.8256, 0.0455598, 0.0455598}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .41901 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.346651 0.322841 0.209503 0.322841 [
[ 0 0 0 0 ]
[ 1 .41901 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00997634 0.669492 0.40903 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 0.618034 [
[.2 -0.0125 -9 -9 ]
[.2 -0.0125 9 0 ]
[.4 -0.0125 -9 -9 ]
[.4 -0.0125 9 0 ]
[.6 -0.0125 -9 -9 ]
[.6 -0.0125 9 0 ]
[.8 -0.0125 -9 -9 ]
[.8 -0.0125 9 0 ]
[1 -0.0125 -3 -9 ]
[1 -0.0125 3 0 ]
[1.025 0 0 -6.28125 ]
[1.025 0 10 6.28125 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[0 .64303 -17 0 ]
[0 .64303 17 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2 0 m
.2 .00625 L
s
[(0.2)] .2 -0.0125 0 1 Mshowa
.4 0 m
.4 .00625 L
s
[(0.4)] .4 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(0.6)] .6 -0.0125 0 1 Mshowa
.8 0 m
.8 .00625 L
s
[(0.8)] .8 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(1)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.05 0 m
.05 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.25 0 m
.25 .00375 L
s
.3 0 m
.3 .00375 L
s
.35 0 m
.35 .00375 L
s
.45 0 m
.45 .00375 L
s
.5 0 m
.5 .00375 L
s
.55 0 m
.55 .00375 L
s
.65 0 m
.65 .00375 L
s
.7 0 m
.7 .00375 L
s
.75 0 m
.75 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.95 0 m
.95 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(l) show
69.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
0 .64303 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(IR) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.000 12.813 moveto
(@) show
81.000 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(l) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.000 12.813 moveto
(D) show
93.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.021 .00527 m
.022 .04283 L
.023 .08569 L
.024 .09143 L
.025 .09143 L
.026 .08693 L
.027 .05714 L
.028 .00527 L
.029 .03204 L
.03 .09143 L
.031 .02013 L
.032 .04936 L
.033 .06763 L
.034 .02061 L
.035 .07634 L
.036 .02571 L
.037 .05877 L
.038 .0603 L
.039 .0132 L
.04 .09143 L
.041 .01745 L
.042 .03907 L
.043 .08977 L
.044 .01798 L
.045 .02571 L
.046 .08998 L
.047 .05387 L
.048 0 L
.049 .05082 L
.05 .09143 L
.051 .05352 L
.052 .00156 L
.053 .02913 L
.054 .08215 L
.055 .08517 L
.056 .03907 L
.057 .00073 L
.058 .02268 L
.059 .07055 L
.06 .09143 L
.061 .07182 L
.062 .02863 L
.063 .0006 L
.064 .01532 L
.065 .05479 L
.066 .08517 L
.067 .08989 L
.068 .06891 L
.069 .03374 L
.07 .00527 L
Mistroke
.071 .00254 L
.072 .02571 L
.073 .05797 L
.074 .08264 L
.075 .09143 L
.076 .08308 L
.077 .06102 L
.078 .03279 L
.079 .00913 L
.08 0 L
.081 .0087 L
.082 .03016 L
.083 .0553 L
.084 .07634 L
.085 .08878 L
.086 .09101 L
.087 .08336 L
.088 .06763 L
.089 .04695 L
.09 .02571 L
.091 .00885 L
.092 .0005 L
.093 .00245 L
.094 .01356 L
.095 .03051 L
.096 .04936 L
.097 .06671 L
.098 .08022 L
.099 .08862 L
.1 .09143 L
.101 .08873 L
.102 .08106 L
.103 .06932 L
.104 .05479 L
.105 .03907 L
.106 .02404 L
.107 .01155 L
.108 .00322 L
.109 2e-005 L
.11 .00217 L
.111 .00907 L
.112 .01956 L
.113 .03221 L
.114 .04559 L
.115 .05846 L
.116 .06987 L
.117 .07918 L
.118 .08598 L
.119 .09007 L
.12 .09143 L
Mistroke
.121 .09012 L
.122 .08632 L
.123 .08031 L
.124 .07242 L
.125 .06306 L
.126 .05274 L
.127 .042 L
.128 .03143 L
.129 .02165 L
.13 .0132 L
.131 .00659 L
.132 .00217 L
.133 .00013 L
.134 .00053 L
.135 .00322 L
.136 .00793 L
.137 .0143 L
.138 .02191 L
.139 .0303 L
.14 .03907 L
.141 .04784 L
.142 .05628 L
.143 .06414 L
.144 .0712 L
.145 .07732 L
.146 .0824 L
.147 .08636 L
.148 .08919 L
.149 .09087 L
.15 .09143 L
.151 .09089 L
.152 .08931 L
.153 .08675 L
.154 .08329 L
.155 .07903 L
.156 .07405 L
.157 .06847 L
.158 .0624 L
.159 .05599 L
.16 .04936 L
.161 .04266 L
.162 .03603 L
.163 .02962 L
.164 .02355 L
.165 .01798 L
.166 .01301 L
.167 .00874 L
.168 .00527 L
.169 .00265 L
.17 .00091 L
Mistroke
.171 8e-005 L
.172 .00014 L
.173 .00106 L
.174 .0028 L
.175 .00527 L
.176 .0084 L
.177 .01211 L
.178 .01629 L
.179 .02086 L
.18 .02571 L
.181 .03076 L
.182 .03591 L
.183 .0411 L
.184 .04625 L
.185 .05128 L
.186 .05616 L
.187 .06082 L
.188 .06523 L
.189 .06936 L
.19 .07317 L
.191 .07664 L
.192 .07976 L
.193 .08252 L
.194 .08491 L
.195 .08693 L
.196 .08856 L
.197 .08983 L
.198 .09072 L
.199 .09125 L
.2 .09143 L
.201 .09125 L
.202 .09075 L
.203 .08992 L
.204 .08878 L
.205 .08735 L
.206 .08564 L
.207 .08366 L
.208 .08144 L
.209 .079 L
.21 .07634 L
.211 .07349 L
.212 .07048 L
.213 .06731 L
.214 .06402 L
.215 .06062 L
.216 .05714 L
.217 .0536 L
.218 .05002 L
.219 .04642 L
.22 .04283 L
Mistroke
.221 .03926 L
.222 .03574 L
.223 .0323 L
.224 .02895 L
.225 .02571 L
.226 .0226 L
.227 .01964 L
.228 .01684 L
.229 .01423 L
.23 .0118 L
.231 .00959 L
.232 .00759 L
.233 .00581 L
.234 .00426 L
.235 .00295 L
.236 .00188 L
.237 .00106 L
.238 .00047 L
.239 .00012 L
.24 0 L
.241 .00011 L
.242 .00045 L
.243 .001 L
.244 .00176 L
.245 .00272 L
.246 .00387 L
.247 .00518 L
.248 .00667 L
.249 .0083 L
.25 .01008 L
.251 .01198 L
.252 .014 L
.253 .01612 L
.254 .01832 L
.255 .02061 L
.256 .02296 L
.257 .02536 L
.258 .02781 L
.259 .03029 L
.26 .03279 L
.261 .0353 L
.262 .03782 L
.263 .04033 L
.264 .04283 L
.265 .0453 L
.266 .04775 L
.267 .05016 L
.268 .05254 L
.269 .05487 L
.27 .05714 L
Mistroke
.271 .05937 L
.272 .06153 L
.273 .06363 L
.274 .06566 L
.275 .06763 L
.276 .06952 L
.277 .07134 L
.278 .07308 L
.279 .07475 L
.28 .07634 L
.281 .07785 L
.282 .07928 L
.283 .08063 L
.284 .0819 L
.285 .08308 L
.286 .08419 L
.287 .08521 L
.288 .08615 L
.289 .08702 L
.29 .0878 L
.291 .0885 L
.292 .08913 L
.293 .08968 L
.294 .09015 L
.295 .09054 L
.296 .09086 L
.297 .09111 L
.298 .09129 L
.299 .09139 L
.3 .09143 L
.301 .09139 L
.302 .09129 L
.303 .09112 L
.304 .09089 L
.305 .0906 L
.306 .09025 L
.307 .08983 L
.308 .08936 L
.309 .08883 L
.31 .08825 L
.311 .08761 L
.312 .08693 L
.313 .08619 L
.314 .0854 L
.315 .08457 L
.316 .08369 L
.317 .08277 L
.318 .08181 L
.319 .08081 L
.32 .07976 L
Mistroke
.321 .07869 L
.322 .07757 L
.323 .07643 L
.324 .07525 L
.325 .07405 L
.326 .07281 L
.327 .07155 L
.328 .07026 L
.329 .06896 L
.33 .06763 L
.331 .06628 L
.332 .06491 L
.333 .06353 L
.334 .06213 L
.335 .06072 L
.336 .05929 L
.337 .05786 L
.338 .05642 L
.339 .05498 L
.34 .05352 L
.341 .05207 L
.342 .05061 L
.343 .04916 L
.344 .0477 L
.345 .04625 L
.346 .0448 L
.347 .04336 L
.348 .04192 L
.349 .04049 L
.35 .03907 L
.351 .03767 L
.352 .03627 L
.353 .03489 L
.354 .03353 L
.355 .03218 L
.356 .03084 L
.357 .02953 L
.358 .02824 L
.359 .02696 L
.36 .02571 L
.361 .02448 L
.362 .02327 L
.363 .02209 L
.364 .02093 L
.365 .0198 L
.366 .0187 L
.367 .01762 L
.368 .01657 L
.369 .01555 L
.37 .01457 L
Mistroke
.371 .01361 L
.372 .01268 L
.373 .01178 L
.374 .01091 L
.375 .01008 L
.376 .00928 L
.377 .00851 L
.378 .00777 L
.379 .00707 L
.38 .0064 L
.381 .00576 L
.382 .00516 L
.383 .00459 L
.384 .00406 L
.385 .00356 L
.386 .00309 L
.387 .00265 L
.388 .00225 L
.389 .00189 L
.39 .00156 L
.391 .00125 L
.392 .00099 L
.393 .00075 L
.394 .00055 L
.395 .00038 L
.396 .00024 L
.397 .00014 L
.398 6e-005 L
.399 1e-005 L
.4 0 L
.401 1e-005 L
.402 6e-005 L
.403 .00013 L
.404 .00023 L
.405 .00036 L
.406 .00052 L
.407 .0007 L
.408 .00091 L
.409 .00115 L
.41 .00141 L
.411 .00169 L
.412 .002 L
.413 .00233 L
.414 .00269 L
.415 .00307 L
.416 .00347 L
.417 .00389 L
.418 .00433 L
.419 .00479 L
.42 .00527 L
Mistroke
.421 .00577 L
.422 .00628 L
.423 .00682 L
.424 .00737 L
.425 .00793 L
.426 .00851 L
.427 .00911 L
.428 .00972 L
.429 .01035 L
.43 .01099 L
.431 .01164 L
.432 .0123 L
.433 .01298 L
.434 .01366 L
.435 .01436 L
.436 .01506 L
.437 .01578 L
.438 .0165 L
.439 .01724 L
.44 .01798 L
.441 .01873 L
.442 .01948 L
.443 .02024 L
.444 .02101 L
.445 .02178 L
.446 .02256 L
.447 .02334 L
.448 .02413 L
.449 .02492 L
.45 .02571 L
.451 .0265 L
.452 .0273 L
.453 .0281 L
.454 .02891 L
.455 .02971 L
.456 .03051 L
.457 .03132 L
.458 .03212 L
.459 .03293 L
.46 .03374 L
.461 .03454 L
.462 .03534 L
.463 .03615 L
.464 .03695 L
.465 .03775 L
.466 .03854 L
.467 .03934 L
.468 .04013 L
.469 .04092 L
.47 .04171 L
Mistroke
.471 .04249 L
.472 .04327 L
.473 .04405 L
.474 .04482 L
.475 .04559 L
.476 .04635 L
.477 .04711 L
.478 .04787 L
.479 .04862 L
.48 .04936 L
.481 .0501 L
.482 .05084 L
.483 .05157 L
.484 .05229 L
.485 .05301 L
.486 .05373 L
.487 .05443 L
.488 .05514 L
.489 .05583 L
.49 .05652 L
.491 .0572 L
.492 .05788 L
.493 .05855 L
.494 .05922 L
.495 .05987 L
.496 .06053 L
.497 .06117 L
.498 .06181 L
.499 .06244 L
.5 .06306 L
.501 .06368 L
.502 .06429 L
.503 .06489 L
.504 .06549 L
.505 .06608 L
.506 .06666 L
.507 .06723 L
.508 .0678 L
.509 .06836 L
.51 .06891 L
.511 .06946 L
.512 .07 L
.513 .07053 L
.514 .07105 L
.515 .07157 L
.516 .07208 L
.517 .07258 L
.518 .07308 L
.519 .07357 L
.52 .07405 L
Mistroke
.521 .07452 L
.522 .07499 L
.523 .07544 L
.524 .0759 L
.525 .07634 L
.526 .07678 L
.527 .07721 L
.528 .07763 L
.529 .07805 L
.53 .07845 L
.531 .07886 L
.532 .07925 L
.533 .07964 L
.534 .08002 L
.535 .08039 L
.536 .08076 L
.537 .08112 L
.538 .08147 L
.539 .08181 L
.54 .08215 L
.541 .08248 L
.542 .08281 L
.543 .08313 L
.544 .08344 L
.545 .08374 L
.546 .08404 L
.547 .08433 L
.548 .08462 L
.549 .0849 L
.55 .08517 L
.551 .08543 L
.552 .08569 L
.553 .08595 L
.554 .08619 L
.555 .08643 L
.556 .08667 L
.557 .08689 L
.558 .08711 L
.559 .08733 L
.56 .08754 L
.561 .08774 L
.562 .08794 L
.563 .08813 L
.564 .08832 L
.565 .0885 L
.566 .08867 L
.567 .08884 L
.568 .089 L
.569 .08916 L
.57 .08931 L
Mistroke
.571 .08945 L
.572 .08959 L
.573 .08973 L
.574 .08985 L
.575 .08998 L
.576 .09009 L
.577 .09021 L
.578 .09031 L
.579 .09042 L
.58 .09051 L
.581 .0906 L
.582 .09069 L
.583 .09077 L
.584 .09085 L
.585 .09092 L
.586 .09099 L
.587 .09105 L
.588 .09111 L
.589 .09116 L
.59 .0912 L
.591 .09125 L
.592 .09128 L
.593 .09132 L
.594 .09135 L
.595 .09137 L
.596 .09139 L
.597 .09141 L
.598 .09142 L
.599 .09142 L
.6 .09143 L
.601 .09142 L
.602 .09142 L
.603 .09141 L
.604 .09139 L
.605 .09137 L
.606 .09135 L
.607 .09132 L
.608 .09129 L
.609 .09126 L
.61 .09122 L
.611 .09118 L
.612 .09113 L
.613 .09108 L
.614 .09103 L
.615 .09097 L
.616 .09091 L
.617 .09084 L
.618 .09077 L
.619 .0907 L
.62 .09063 L
Mistroke
.621 .09055 L
.622 .09047 L
.623 .09038 L
.624 .09029 L
.625 .0902 L
.626 .0901 L
.627 .09 L
.628 .0899 L
.629 .0898 L
.63 .08969 L
.631 .08958 L
.632 .08946 L
.633 .08935 L
.634 .08923 L
.635 .0891 L
.636 .08898 L
.637 .08885 L
.638 .08872 L
.639 .08858 L
.64 .08844 L
.641 .0883 L
.642 .08816 L
.643 .08802 L
.644 .08787 L
.645 .08772 L
.646 .08756 L
.647 .08741 L
.648 .08725 L
.649 .08709 L
.65 .08693 L
.651 .08676 L
.652 .08659 L
.653 .08642 L
.654 .08625 L
.655 .08607 L
.656 .0859 L
.657 .08572 L
.658 .08554 L
.659 .08535 L
.66 .08517 L
.661 .08498 L
.662 .08479 L
.663 .0846 L
.664 .08441 L
.665 .08421 L
.666 .08401 L
.667 .08381 L
.668 .08361 L
.669 .08341 L
.67 .0832 L
Mistroke
.671 .083 L
.672 .08279 L
.673 .08258 L
.674 .08237 L
.675 .08215 L
.676 .08194 L
.677 .08172 L
.678 .0815 L
.679 .08128 L
.68 .08106 L
.681 .08084 L
.682 .08061 L
.683 .08039 L
.684 .08016 L
.685 .07993 L
.686 .0797 L
.687 .07947 L
.688 .07923 L
.689 .079 L
.69 .07876 L
.691 .07853 L
.692 .07829 L
.693 .07805 L
.694 .07781 L
.695 .07757 L
.696 .07732 L
.697 .07708 L
.698 .07683 L
.699 .07659 L
.7 .07634 L
.701 .07609 L
.702 .07584 L
.703 .07559 L
.704 .07534 L
.705 .07509 L
.706 .07483 L
.707 .07458 L
.708 .07433 L
.709 .07407 L
.71 .07381 L
.711 .07355 L
.712 .0733 L
.713 .07304 L
.714 .07278 L
.715 .07252 L
.716 .07225 L
.717 .07199 L
.718 .07173 L
.719 .07147 L
.72 .0712 L
Mistroke
.721 .07094 L
.722 .07067 L
.723 .07041 L
.724 .07014 L
.725 .06987 L
.726 .0696 L
.727 .06934 L
.728 .06907 L
.729 .0688 L
.73 .06853 L
.731 .06826 L
.732 .06799 L
.733 .06772 L
.734 .06745 L
.735 .06717 L
.736 .0669 L
.737 .06663 L
.738 .06636 L
.739 .06608 L
.74 .06581 L
.741 .06554 L
.742 .06526 L
.743 .06499 L
.744 .06471 L
.745 .06444 L
.746 .06416 L
.747 .06389 L
.748 .06361 L
.749 .06334 L
.75 .06306 L
.751 .06279 L
.752 .06251 L
.753 .06223 L
.754 .06196 L
.755 .06168 L
.756 .06141 L
.757 .06113 L
.758 .06085 L
.759 .06058 L
.76 .0603 L
.761 .06002 L
.762 .05975 L
.763 .05947 L
.764 .05919 L
.765 .05892 L
.766 .05864 L
.767 .05837 L
.768 .05809 L
.769 .05781 L
.77 .05754 L
Mistroke
.771 .05726 L
.772 .05699 L
.773 .05671 L
.774 .05643 L
.775 .05616 L
.776 .05588 L
.777 .05561 L
.778 .05534 L
.779 .05506 L
.78 .05479 L
.781 .05451 L
.782 .05424 L
.783 .05397 L
.784 .05369 L
.785 .05342 L
.786 .05315 L
.787 .05287 L
.788 .0526 L
.789 .05233 L
.79 .05206 L
.791 .05179 L
.792 .05152 L
.793 .05125 L
.794 .05098 L
.795 .05071 L
.796 .05044 L
.797 .05017 L
.798 .0499 L
.799 .04963 L
.8 .04936 L
.801 .0491 L
.802 .04883 L
.803 .04856 L
.804 .0483 L
.805 .04803 L
.806 .04777 L
.807 .0475 L
.808 .04724 L
.809 .04697 L
.81 .04671 L
.811 .04645 L
.812 .04619 L
.813 .04592 L
.814 .04566 L
.815 .0454 L
.816 .04514 L
.817 .04488 L
.818 .04462 L
.819 .04436 L
.82 .04411 L
Mistroke
.821 .04385 L
.822 .04359 L
.823 .04334 L
.824 .04308 L
.825 .04283 L
.826 .04257 L
.827 .04232 L
.828 .04206 L
.829 .04181 L
.83 .04156 L
.831 .04131 L
.832 .04106 L
.833 .04081 L
.834 .04056 L
.835 .04031 L
.836 .04006 L
.837 .03981 L
.838 .03957 L
.839 .03932 L
.84 .03907 L
.841 .03883 L
.842 .03858 L
.843 .03834 L
.844 .0381 L
.845 .03786 L
.846 .03761 L
.847 .03737 L
.848 .03713 L
.849 .03689 L
.85 .03666 L
.851 .03642 L
.852 .03618 L
.853 .03594 L
.854 .03571 L
.855 .03547 L
.856 .03524 L
.857 .03501 L
.858 .03477 L
.859 .03454 L
.86 .03431 L
.861 .03408 L
.862 .03385 L
.863 .03362 L
.864 .03339 L
.865 .03317 L
.866 .03294 L
.867 .03271 L
.868 .03249 L
.869 .03226 L
.87 .03204 L
Mistroke
.871 .03182 L
.872 .03159 L
.873 .03137 L
.874 .03115 L
.875 .03093 L
.876 .03071 L
.877 .0305 L
.878 .03028 L
.879 .03006 L
.88 .02985 L
.881 .02963 L
.882 .02942 L
.883 .02921 L
.884 .02899 L
.885 .02878 L
.886 .02857 L
.887 .02836 L
.888 .02815 L
.889 .02794 L
.89 .02774 L
.891 .02753 L
.892 .02732 L
.893 .02712 L
.894 .02692 L
.895 .02671 L
.896 .02651 L
.897 .02631 L
.898 .02611 L
.899 .02591 L
.9 .02571 L
.901 .02551 L
.902 .02531 L
.903 .02512 L
.904 .02492 L
.905 .02473 L
.906 .02453 L
.907 .02434 L
.908 .02415 L
.909 .02396 L
.91 .02376 L
.911 .02357 L
.912 .02339 L
.913 .0232 L
.914 .02301 L
.915 .02282 L
.916 .02264 L
.917 .02245 L
.918 .02227 L
.919 .02209 L
.92 .02191 L
Mistroke
.921 .02172 L
.922 .02154 L
.923 .02136 L
.924 .02119 L
.925 .02101 L
.926 .02083 L
.927 .02066 L
.928 .02048 L
.929 .02031 L
.93 .02013 L
.931 .01996 L
.932 .01979 L
.933 .01962 L
.934 .01945 L
.935 .01928 L
.936 .01911 L
.937 .01894 L
.938 .01878 L
.939 .01861 L
.94 .01844 L
.941 .01828 L
.942 .01812 L
.943 .01795 L
.944 .01779 L
.945 .01763 L
.946 .01747 L
.947 .01731 L
.948 .01716 L
.949 .017 L
.95 .01684 L
.951 .01669 L
.952 .01653 L
.953 .01638 L
.954 .01622 L
.955 .01607 L
.956 .01592 L
.957 .01577 L
.958 .01562 L
.959 .01547 L
.96 .01532 L
.961 .01518 L
.962 .01503 L
.963 .01488 L
.964 .01474 L
.965 .0146 L
.966 .01445 L
.967 .01431 L
.968 .01417 L
.969 .01403 L
.97 .01389 L
Mistroke
.971 .01375 L
.972 .01361 L
.973 .01348 L
.974 .01334 L
.975 .0132 L
.976 .01307 L
.977 .01294 L
.978 .0128 L
.979 .01267 L
.98 .01254 L
.981 .01241 L
.982 .01228 L
.983 .01215 L
.984 .01202 L
.985 .01189 L
.986 .01177 L
.987 .01164 L
.988 .01152 L
.989 .01139 L
.99 .01127 L
.991 .01115 L
.992 .01102 L
.993 .0109 L
.994 .01078 L
.995 .01066 L
.996 .01055 L
.997 .01043 L
.998 .01031 L
.999 .01019 L
1 .01008 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
0 g
.71792 .19336 m
.71792 .2979 L
.97619 .2979 L
.97619 .19336 L
F
1 g
.70178 .2095 m
.70178 .31404 L
.96005 .31404 L
.96005 .2095 L
F
0 g
.001 w
[ ] 0 setdash
.70178 .2095 m
.96005 .2095 L
.96005 .31404 L
.70178 .31404 L
.70178 .2095 L
s
% Start of sub-graphic
p
0.701776 0.209503 0.960048 0.314042 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .40476 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .40476 L
0 .40476 L
closepath
clip
newpath
1 0 0 r
.05357 .05357 m
.05357 .35119 L
.35119 .35119 L
.35119 .05357 L
F
0 g
gsave
.38988 .20238 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(IR) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.000 12.813 moveto
(@) show
81.000 12.813 moveto
%%IncludeResource: font Math1Mono
%%IncludeFont: Math1Mono
/Math1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(l) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.000 12.813 moveto
(D) show
93.000 12.813 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .41901 L
0 .41901 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 120.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00=@3oool2000000@0oooo0P00
00030?ooo`@000003@3oool2000000@0oooo0P0000050?ooo`<00000303oool2000000@0oooo0P00
00030?ooo`<000003`3oool2000000@0oooo0P0000040?ooo`8000004`3oool500000700oooo000d
0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool03@3oool010000000oooo0?oo
o`00000;0?ooo`030000003oool0oooo00X0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`00000=0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000503o
ool00`000000oooo0?ooo`1`0?ooo`00=03oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo00`0oooo00@000000?ooo`3oool00000203oool5000000/0oooo00@000000?ooo`3oool0
0000203oool010000000oooo0?ooo`00000=0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool00000503oool00`000000oooo0?ooo`1`0?ooo`00=03oool010000000oooo0?ooo`00
000:0?ooo`030000003oool0oooo00/0oooo00@000000?ooo`3oool00000203oool010000000oooo
0?ooo`00000<0?ooo`040000003oool0oooo000000P0oooo0`00000>0?ooo`040000003oool0oooo
000000T0oooo0P00000E0?ooo`030000003oool0oooo0700oooo000d0?ooo`040000003oool0oooo
000000P0oooo00@000000?ooo`3oool00000303oool010000000oooo0?ooo`0000090?ooo`030000
003oool0000000`0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0=0?ooo`04
0000003oool0oooo000000P0oooo00@000000?ooo`3oool00000503oool00`000000oooo0?ooo`1`
0?ooo`00=@3oool2000000X0oooo0P00000>0?ooo`8000002`3oool2000000d0oooo0P00000:0?oo
o`<000003P3oool2000000X0oooo0P00000D0?ooo`800000LP3oool00?l0oooo8@3oool00?l0oooo
8@3oool00;40oooo0`0000020?ooo`030000003oool0oooo06L0oooo002c0?ooo`030000003oool0
000006X0oooo000P0?ooo`<000000P3o0002000000D0o`0000@000000?l000000000o`000P000002
0?l000@000000P3o0007000000<0o`004@0000070?l0058000001P3oool2000006X0oooo000P0?oo
o`030000003oool0oooo00<0o`0000<0oooo0?l0003o00000`3o0000103oool0o`000?ooo`3o0002
0?ooo`80o`000`3oool00`3o0000oooo0?l000060?ooo`80o`0000<0oooo0?l0003oool03`3oool2
0?l000H0oooo0P3o001:0?ooo`H0o`001`3oool00`000000oooo0?ooo`1X0?ooo`00803oool00`00
0000oooo0?ooo`090?l000030?ooo`3o0000oooo0080o`0000<0oooo0?l0003o00000`3oool00`3o
0000oooo0?l000060?ooo`050?l0003oool0oooo0?ooo`3o00003P3oool20?l000P0oooo0P3o0013
0?ooo`L0o`00303oool00`000000oooo0?ooo`1X0?ooo`00803oool00`000000oooo0?ooo`090?l0
00030?ooo`3o0000oooo0080o`0000<0oooo0?l0003o00000`3oool00`3o0000oooo0?l000060?oo
o`050?l0003oool0oooo0?ooo`3o00003@3oool20?l000/0oooo0P3o000l0?ooo`H0o`00403oool2
000006/0oooo000P0?ooo`030000003oool0oooo00T0o`0000<0oooo0?l0003oool00P3o00000`3o
ool0o`000?l000030?ooo`030?l0003oool0o`0000D0oooo00<0o`000?ooo`3oool00P3oool20?l0
00`0oooo00<0o`000?ooo`3oool02`3oool20?l003H0oooo1P3o00220?ooo`00803oool00`000000
oooo0?ooo`0;0?l000070?ooo`3o0000o`000?ooo`3o0000oooo0?l000020?ooo`040?l0003oool0
o`000?l000@0oooo00<0o`000?ooo`3oool00`3oool00`3o0000oooo0?ooo`090?ooo`030?l0003o
ool0oooo00d0oooo0P3o000a0?ooo`D0o`00Q`3oool00200oooo00<000000?ooo`3oool02`3o0000
203oool0o`000?l0003oool0o`000?ooo`3o0000oooo0P3o00020?ooo`030?l0003oool0oooo0080
oooo00<0o`000?ooo`3oool00`3oool00`3o0000oooo0?ooo`080?ooo`80o`00403oool20?l002d0
oooo103o002;0?ooo`00803oool00`000000oooo0?ooo`0;0?l000090?ooo`3o0000o`000?ooo`3o
0000oooo0?l0003oool0o`0000<0oooo00@0o`000?ooo`3oool0oooo0P3o00050?ooo`80o`00203o
ool20?l001<0oooo0P3o000W0?ooo`@0o`00S`3oool00200oooo00<000000?ooo`3oool02P3o0000
0`3oool0o`000?ooo`020?l00080oooo00<0o`000?ooo`3o00000`3oool01@3o0000oooo0?ooo`3o
ool0o`0000L0oooo00<0o`000?ooo`3oool01P3oool00`3o0000oooo0?ooo`0C0?ooo`80o`008P3o
ool50?l00980oooo000P0?ooo`030000003oool0oooo00X0o`0000<0oooo0?l0003oool00P3o0002
0?ooo`030?l0003oool0o`0000<0oooo00D0o`000?ooo`3oool0oooo0?l000070?ooo`80o`001P3o
ool20?l001L0oooo0P3o000M0?ooo`@0o`00UP3oool00200oooo00<000000?ooo`3oool02P3o0000
0`3oool0o`000?ooo`020?l00080oooo00<0o`000?ooo`3o0000103oool0103o0000oooo0?l0003o
00080?ooo`030?l0003oool0oooo00<0oooo0P3o000I0?ooo`<0o`005`3oool40?l009X0oooo000P
0?ooo`030000003oool0oooo00X0o`0000<0oooo0?l0003oool00P3o00020?ooo`030?l0003oool0
o`0000@0oooo00<0o`000?ooo`3o00002P3oool0103o0000oooo0?ooo`3oool20?l001`0oooo103o
000?0?ooo`H0o`00W@3oool00200oooo00<000000?ooo`3oool0203o00001@3oool0o`000?ooo`3o
0000oooo0080o`000`3oool00`3o0000oooo0?ooo`030?ooo`<0o`002P3oool50?l00200oooo4@3o
002R0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?oo
o`003P3oool2000000@0oooo0P0000030?ooo`@000000`3oool00`000000oooo0?ooo`3m0?ooo`00
3@3oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0o@3oool000d0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`030?ooo`80
0000oP3oool000d0oooo00@000000?ooo`3oool000002P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0?d0oooo000=0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3o
ool000000`3oool00`000000oooo0?ooo`3m0?ooo`003P3oool2000000X0oooo0P0000040?ooo`03
0000003oool0oooo0?d0oooo000P0?ooo`030000003oool0oooo0?d0oooo000P0?ooo`030000003o
ool0oooo0?d0oooo000P0?ooo`030000003oool0oooo0?d0oooo000P0?ooo`030000003oool0oooo
0?d0oooo000P0?ooo`030000003oool0oooo0?d0oooo000P0?ooo`030000003oool0oooo0?d0oooo
000P0?ooo`030000003oool0oooo0?d0oooo000P0?ooo`030000003oool0oooo0?d0oooo000P0?oo
o`030000003oool0oooo0?d0oooo000P0?ooo`030000003oool0oooo0?d0oooo000P0?ooo`030000
003oool0oooo0?d0oooo000>0?ooo`800000103oool2000000D0oooo0`0000020?ooo`030000003o
ool0oooo0?d0oooo000=0?ooo`040000003oool0oooo000000/0oooo00D000000?ooo`3oool0oooo
0000003o0?ooo`003@3oool010000000oooo0?ooo`0000080?ooo`D000000P3oool200000?h0oooo
000=0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000`3oool00`000000
oooo0?ooo`3m0?ooo`003@3oool010000000oooo0?ooo`0000090?ooo`030000003oool0000000<0
oooo00<000000?ooo`3oool0o@3oool000h0oooo0P00000;0?ooo`8000000`3oool00`000000oooo
0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m
0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00
803oool00`000000oooo0?ooo`2Z0?ooodX000002@3oool00200oooo00<000000?ooo`3oool0ZP3o
oom:000000T0oooo000P0?ooo`030000003oool0oooo0:X0ooooBP0000090?ooo`00803oool00`00
0000oooo0?ooo`2Z0?ooodX000002@3oool00200oooo00<000000?ooo`3oool0YP3ooom>000000T0
oooo000P0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool0AP3oool5000000T0oooo
000P0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool0AP3oool5000000T0oooo000P
0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool0AP3oool5000000T0oooo000>0?oo
o`800000103oool2000000<0oooo0`0000040?ooo`030000003oool0oooo0:H0oooo00<000000?oo
o`3oool0AP3oool5000000T0oooo000=0?ooo`040000003oool0oooo000000P0oooo00@000000?oo
o`3oool000000`3oool00`000000oooo0?ooo`2V0?ooo`040000003oool0oooo0?oooaD0o`00<03o
ool5000000T0oooo000=0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool00000
0`3oool200000:L0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool000d0oooo
00@000000?ooo`3oool00000203oool3000000@0oooo00<000000?ooo`3oool0YP3oool010000000
oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`003@3oool010000000oooo0?ooo`0000090?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0YP3oool010000000oooo0?ooo`3ooolE
0?l00300oooo1@0000090?ooo`003P3oool2000000X0oooo0`0000030?ooo`030000003oool0oooo
0:H0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool00200oooo00<000000?oo
o`3oool0YP3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00803oool00`00
0000oooo0?ooo`2V0?ooo`040000003oool0oooo0?oooaD0o`00503oool2000000P0oooo0P00000@
0?ooo`D000002@3oool00200oooo00<000000?ooo`3oool0YP3oool010000000oooo0?ooo`3ooolE
0?l001@0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0>0?ooo`D000002@3oool0
0200oooo00<000000?ooo`3oool0YP3oool010000000oooo0?ooo`3ooolE0?l000L0oooo0`000000
103oool000000000000000020?ooo`060000003oool0oooo0?ooo`000000oooo0`0000020?ooo`05
0000003oool0oooo0?ooo`000000403oool5000000T0oooo000P0?ooo`030000003oool0oooo0:H0
oooo00@000000?ooo`3oool0oooo5@3o00080?ooo`050000003oool0oooo0?ooo`0000000P3oool0
0`000000oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`030000
003oool0oooo00h0oooo1@0000090?ooo`00803oool00`000000oooo0?ooo`2V0?ooo`040000003o
ool0oooo0?oooaD0o`00203oool010000000oooo0?ooo`3oool3000000D0oooo00<000000?ooo`3o
ool00P3oool2000000@0oooo00<000000?ooo`3oool03P3oool5000000T0oooo000P0?ooo`030000
003oool0oooo0:H0oooo00@000000?ooo`3oool0oooo5@3o00080?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00P3oool00`000000oooo0?ooo`0>0?ooo`D000002@3oool00200oooo00<000000?ooo`3o
ool0YP3oool010000000oooo0?ooo`3ooolE0?l000P0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo00h0oooo1@0000090?ooo`00803oool00`000000oooo0?ooo`2V0?oo
o`040000003oool0oooo0?oooaD0o`001`3oool3000000030?ooo`0000000000008000001@3oool2
00000080oooo0P0000040?ooo`800000403oool5000000T0oooo000P0?ooo`030000003oool0oooo
0:H0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool00200oooo00<000000?oo
o`3oool0YP3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`003P3oool20000
00@0oooo0P0000040?ooo`800000103oool00`000000oooo0?ooo`2V0?ooo`040000003oool0oooo
0?oooaD0o`00<03oool5000000T0oooo000=0?ooo`040000003oool0oooo000000P0oooo00@00000
0?ooo`3oool000000`3oool00`000000oooo0?ooo`2V0?ooo`040000003oool0oooo0?oooaD0o`00
<03oool5000000T0oooo000=0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000`3oool200000:L0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool000d0
oooo00@000000?ooo`3oool000002@3oool2000000@0oooo00<000000?ooo`3oool0YP3oool01000
0000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`003@3oool010000000oooo0?ooo`000008
0?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0YP3oool010000000oooo0?oo
o`3ooolE0?l00300oooo1@0000090?ooo`003P3oool2000000X0oooo0P0000040?ooo`030000003o
ool0oooo0:H0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`030000003oool0oooo00/0oooo
000P0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?oo
o`0;0?ooo`00803oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo04H0oooo00<00000
0?ooo`3oool02`3oool00200oooo00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`160?oo
o`030000003oool0oooo00/0oooo000P0?ooo`030000003oool0oooo0:H0ooooBP00000=0?ooo`00
803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool0
0`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000
oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`00803oool00`000000oooo0?oo
o`3m0?ooo`00803oool00`000000oooo0?ooo`3m0?ooo`006@3oool500000080oooo00<000000?oo
o`3oool0o@3oool001/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3m0?ooo`00
6`3oool00`000000oooo0?ooo`020?ooo`800000oP3oool001/0oooo00<000000?ooo`3oool0o`3o
ool30?ooo`006`3oool00`000000oooo0?ooo`3o0?ooo`<0oooo000J0?ooo`800000o`3oool50?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00803oool2000000P0oooo0P00003d0?ooo`00803oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo0?80oooo000C0?ooo`<0000000@0oooo0000
0000000000000P3oool01P000000oooo0?ooo`3oool000000?ooo`<000000P3oool01@000000oooo
0?ooo`3oool000000?@0oooo000D0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`020?ooo`070000003oool0oooo0?ooo`000000oooo000000040?ooo`030000003oool0
oooo0?80oooo000D0?ooo`040000003oool0oooo0?ooo`<000001@3oool00`000000oooo0?ooo`02
0?ooo`800000103oool00`000000oooo0?ooo`3b0?ooo`00503oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0lP3oool001@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0?80oooo000C0?ooo`<0000000<0oooo0000000000000P0000050?oo
o`8000000P3oool2000000@0oooo0P00003d0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3o
oolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {119.625, 0}} -> {-1.08192, -0.648936, \
0.0108496, 0.0108496}, {{7.5, 191.875}, {116.75, 2.8125}} -> {-0.229565, \
-0.156583, 0.00709647, 0.0114823}, {{201.063, 274.813}, {59.8125, 29.9375}} -> \
{-9.26038, -2.8256, 0.0455598, 0.0455598}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
WindowSize->{1272, 924},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 2761, 53, 690, "Input"],

Cell[CellGroupData[{
Cell[4513, 109, 34307, 1628, 129, 22172, 1474, "GraphicsData", "PostScript", \
"Graphics"],
Cell[38823, 1739, 34198, 1627, 129, 22152, 1474, "GraphicsData", \
"PostScript", "Graphics"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

