(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3761,         92]*)
(*NotebookOutlinePosition[      4405,        114]*)
(*  CellTagsIndexPosition[      4361,        110]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I16FABRYS
Fabry-Perot Transmission depending on D.

Normal incidence. Parameters: reflection coefficient, wavelength \[Lambda], \
refractive index. 
See for global definition. The finess  \[Pi]g/2 is \[Lambda]/ \
\[CapitalDelta]l. All length in mm.

\[CapitalDelta] = 2\[Pi]/\[Lambda] 2D (n2) cos \[Theta]2    \
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(n2\  = \ 
        1;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.1;\), "\[IndentingNewLine]", \(DD\  = 
        Range[0, 0.11, 0.001];\), "\[IndentingNewLine]", \(r1\  = \ 0.7; \ 
    g1\  = \ \((2*r1)\)/\((1 - r1^2)\);\), "\[IndentingNewLine]", \(r2\  = \ 
      0.9; \ g2\  = \ \((2*r2)\)/\((1 - r2^2)\);\), "\[IndentingNewLine]", 
    RowBox[{\(r3\  = \ 0.97; g3\  = \ \((2*r3)\)/\((1 - r3^2)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(IT1[DD_]\  = \ 
        1/\((1 + \((g1^2)\)*
                Sin[2*\((Pi/\[Lambda])\)*DD*
                      n2]^2)\);\), "\[IndentingNewLine]", \(IT2[DD_]\  = \ 
        1/\((1 + \((g2^2)\)*
                Sin[2*\((Pi/\[Lambda])\)*DD*
                      n2]^2)\);\), "\[IndentingNewLine]", 
    RowBox[{\(IT3[DD_]\  = \ 
          1/\((1 + \((g3^2)\)*Sin[2*\((Pi/\[Lambda])\)*DD*n2]^2)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{DD, IT1[DD]}], Transpose[{DD, IT2[DD]}], 
          Transpose[{DD, IT3[DD]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<DD\>", "\<IT\>"}, 
          PlotRange \[Rule] {{0, 0.12}, {0, 1}}], {{{Hue[
                1], "\<IT1[DD]\>"}, {Hue[0.5], "\<IT2[DD]\>"}, {Hue[
                0.25], "\<IT3[DD]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{64, Automatic}, {Automatic, 1}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2052, 40, 676, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

