(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3647,         90]*)
(*NotebookOutlinePosition[      4312,        113]*)
(*  CellTagsIndexPosition[      4268,        109]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I18FABRYRDS
Fabry-Perot Ring pattern in Transmission and Reflection depending on angle. 

Near normal incidence. Parameters: reflection coefficient, thickness d, \
refractive index and range of angles in Rad. All length in mm.
\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(n2\  = \ 
        1;\), "\[IndentingNewLine]", \(\[Lambda]1\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(\[Lambda]2\  = \ 
        0.0005025;\), "\[IndentingNewLine]", \(r\  = \ 
        0.9;\), "\[IndentingNewLine]", \(g\  = \ \((2*r)\)/\((1 - 
              r^2)\);\), "\[IndentingNewLine]", \(DD\  = 
        0.01;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]\  = \ Range[0, 40, 0.05];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(IT[\[Theta]_]\  = \ 
        1/\((1 + \((g^2)\)*
                Sin[2*\((Pi/\[Lambda]1)\)*DD*n2*
                      Cos[2*\((Pi/
                              360)\)*\[Theta]]]^2)\);\), \
"\[IndentingNewLine]", 
    RowBox[{\(IIT[\[Theta]_]\  = \ 
          1/\((1 + \((g^2)\)*
                  Sin[2*\((Pi/\[Lambda]2)\)*DD*n2*
                        Cos[2*\((Pi/360)\)*\[Theta]]]^2)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], IT[\[Theta]]}], 
          Transpose[{\[Theta], IIT[\[Theta]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<IT[\[Theta]]\>"}, 
          PlotRange \[Rule] {{0, 40}, {0, 1}}], {{{Hue[
                1], "\<IT[\[Theta]]\>"}, {Hue[0.5], "\<IIT[DD]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowToolbars->{},
WindowSize->{507, 599},
WindowMargins->{{19, Automatic}, {Automatic, -3}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1938, 38, 770, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

