(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4504,        103]*)
(*NotebookOutlinePosition[      5149,        125]*)
(*  CellTagsIndexPosition[      5105,        121]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I20ARRAYS
Interference pattern of N sources
  
Parameters:Opening a,Wavelength \[Lambda],Number of lines N. Graph as \
function of \[Theta],because of small angle \[Theta]=Y/X.Normalization to 1.
For comparison of maxima,the numerator is plotted separately.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(n\  = \ 5; \ 
    nn\  = \ 5;\), "\[IndentingNewLine]", \(a\  = \ 0.1; \ 
    aa\  = \ 0.2;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]\  = \ Range[0.00000001, \ 0.5, \ 0.0075];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(IA1[\[Theta]_]\  = \ \
\((Sin[Pi*n*\((a/\[Lambda])\)*Sin[2*\((Pi/360)\)*\[Theta]]]/\((n*
                  Sin[Pi*\((a/\[Lambda])\)*
                      Sin[2*\((Pi/
                              360)\)*\[Theta]]])\))\)^2;\), "\
\[IndentingNewLine]", \(IA2[\[Theta]_]\  = \ \((Sin[
                Pi*nn*\((aa/\[Lambda])\)*Sin[2*\((Pi/360)\)*\[Theta]]]/\((n*
                  Sin[Pi*\((aa/\[Lambda])\)*
                      Sin[2*\((Pi/
                              360)\)*\[Theta]]])\))\)^2;\), "\
\[IndentingNewLine]", \(y[\[Theta]_]\  = \ 
        Sin[Pi*n*\((a/\[Lambda])\)*
              Sin[2*\((Pi/360)\)*\[Theta]]]^2;\), "\[IndentingNewLine]", 
    RowBox[{\(y1[\[Theta]_]\  = \ 
          Sin[Pi*\((a/\[Lambda])\)*Sin[2*\((Pi/360)\)*\[Theta]]]^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], IA1[\[Theta]]}], 
            Transpose[{\[Theta], y[\[Theta]]}], 
            Transpose[{\[Theta], y1[\[Theta]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 0.5}, {0, 1}}], {{{Hue[
                  1], "\<IA1[\[Theta]]\>"}, {Hue[
                  0.5], "\<y[\[Theta]]\>"}, {Hue[0.25], "\<y1[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta], IA2[\[Theta]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<IA2[\[Theta]]\>"}, 
          PlotRange \[Rule] {{0, 0.5}, {0, 1}}], {{{Hue[
                1], "\<IA2[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{586, 599},
WindowMargins->{{Automatic, 61}, {26, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2795, 51, 780, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

