(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4078,         98]*)
(*NotebookOutlinePosition[      4721,        120]*)
(*  CellTagsIndexPosition[      4677,        116]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I3COSGRA

Superposition of two cosine waves,one having an optical path differnce \
\[Delta] with respect to the other.The sum is squared to result in the \
intensity.We are looking at the time dependence,the graphs are plots in space \
x and time t. 

Period T,path difference \[Delta],wavelength \[Lambda].

1. Graph for optical path difference corresponding to a maximum\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Graphics3D`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.5;\), "\[IndentingNewLine]", \(A\  = \ 
        1;\), "\[IndentingNewLine]", \(n\  = \ 
        15;\), "\[IndentingNewLine]", \(T\  = \ 1;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Delta]1\  = \ 1;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(uc[x_, 
          t1_] := \ \((2*A*Cos[2*Pi*\((\[Delta]1/\((2*\[Lambda])\))\)]*
              Cos[2*Pi*\((x/\[Lambda] - t1/T)\) - 
                  2*Pi*\((\[Delta]1/\((2*\[Lambda])\))\)])\)^2;\), "\
\[IndentingNewLine]", 
    RowBox[{\(M\  = \ 
          Table[uc[\(-0.4\) + 0.025*i, \(-0.4\) + 0.025*j], {i, 0, n, 1}, {j, 
              0, n, 1}];\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ListPlot3D[M, PlotLabel \[Rule] "\<M\>"];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Graph\ for\ optical\ path\ difference\ corresponding\ to\ a\ \
\(\(minimum\)\(.\)\)\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(n\  = \ 
        40;\), "\[IndentingNewLine]", \(\[Delta]2\  = \ 
        0.5;\), "\[IndentingNewLine]", \(t1\  = \ 
        0.1;\), "\[IndentingNewLine]", 
    RowBox[{\(T\  = 1;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ud[xx_, 
            t1_]\  = \ \((2*A*Cos[2*Pi*\((\[Delta]2/\((2*\[Lambda])\))\)]*
                Cos[2*Pi*\((xx/\[Lambda] - t1/T)\) - 
                    2*Pi*\((\[Delta]2/\((2*\[Lambda])\))\)])\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(MM\  = 
        Table[ud[\(-0.2\) + 0.04*i, \(-0.2\) + 0.02*j], {i, 0, n, 1}, {j, 0, 
            n, 1}];\), "\[IndentingNewLine]", \(ListPlot3D[MM, 
        PlotLabel \[Rule] "\<MM\>"];\), "\[IndentingNewLine]", }], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{876, 599},
WindowMargins->{{2, Automatic}, {Automatic, 9}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2369, 46, 816, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

