(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4355,        109]*)
(*NotebookOutlinePosition[      4999,        131]*)
(*  CellTagsIndexPosition[      4955,        127]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
I8FRYOLOS
  Fresnel's mirrors, Young's double slit, and Lloyd's mirror,

1. Fresnel's Mirrors 
Y, c, f, b, and \[Lambda] in mm, \[Beta] in Rad
c is about b for calculation of X = c + f
All length in mm\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(Con\  = \ 
        1;\), "\[IndentingNewLine]", \(b\  = \ 
        1000;\), "\[IndentingNewLine]", \(f\  = \ 
        5000;\), "\[IndentingNewLine]", \(\[Beta]\  = \ 
        0.0002;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(c\  = \ 
        b*Cos[\[Beta]];\), "\[IndentingNewLine]", \(Y\  = \ 
        Range[\(-10\), 10, 0.1];\), "\[IndentingNewLine]", 
    RowBox[{\(IF[Y_]\  = \ 
          Con*Cos[Pi*\((Y*2*\((b/\((c + f)\))\)*
                        Sin[\[Beta]])\)/\[Lambda]]^2;\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ Young' s\ Experiment\ *) \)}], "\[IndentingNewLine]", \(a\  = \ 
        0.4;\), "\[IndentingNewLine]", \(X\  = \ 
        4000;\), "\[IndentingNewLine]", 
    RowBox[{\(IY[Y_]\  = \ Con*Cos[Pi*\((Y*a)\)/\((\[Lambda]*X)\)]^2;\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        3. \ Lloyd' 
          s\ Mirror\ \(\((\)\(same\ as\ Young, \ 
            phase\ term\ is\ added\)\(\ \)\)*) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(IL[Y_]\  = \ 
          Con*Cos[Pi*\((Y*a)\)/\((\[Lambda]*X)\) + Pi/2]^2;\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{Y, IF[Y]}], Transpose[{Y, IY[Y]}], 
          Transpose[{Y, IL[Y]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<Y\>", "\<I\>"}, 
          PlotRange \[Rule] {{\(-10\), 10}, {0, 1}}], {{{Hue[
                1], "\<IF[Y]\>"}, {Hue[0.5], "\<IY[Y]\>"}, {Hue[
                0.25], "\<IL[Y]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
    RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
We see that at Y=0 Young has a maximum, Lloyd a minimum. For Young and \
Lloyd:The position of maxima are changed by changing d and \[Lambda],X is \
considered fixed.

For Fresnel, a,b are fixed, position of fringes changes with \[Beta] and \
\[Lambda].     
\
\>"], "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{829, 633},
WindowMargins->{{-2, Automatic}, {Automatic, 2}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2646, 57, 892, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

