(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4737,        111]*)
(*NotebookOutlinePosition[      5380,        133]*)
(*  CellTagsIndexPosition[      5336,        129]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D11FAGRANGS
  
Diffraction on an amplitude grating. Non normal incidence
with angle \[CurlyPhi] with respect to the normal.
    
Width of grating openings d, center to center distance of strips a, 
wavelength \[Lambda], distance from grating to screen X and coordinate on \
Screen Y.

DD(A) is the diffraction factor
II(A) is the interference factor, normalized to 1. The numerator is plotted
separately to show where the main maxima are located (0/0).
P(A) is the product of interference and diffraction factor.

All distances and wavelength in mm, number of lines N.
All parameters are globally defined above the graph.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(d\  = \ 
        0.001;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(a\  = \ 
        0.002;\), "\[IndentingNewLine]", \(n\  = \ 
        6;\), "\[IndentingNewLine]", \(X\  = \ 
        4000;\), "\[IndentingNewLine]", \(\[CurlyPhi]\  = \ \(-0.2\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(\[Theta]\  = \ Range[\(-0.5001\), 0.5, 0.0007];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(DD[\[Theta]_] := \
\((Sin[\((Pi*\((d/\[Lambda])\)*\((Sin[\[Theta]] + 
                        Sin[\[CurlyPhi]])\))\)]/\((Pi*\((d/\[Lambda])\)*\((\
Sin[\[Theta]] + Sin[\[CurlyPhi]])\))\))\)^2;\), "\[IndentingNewLine]", 
    RowBox[{\(DD\[Theta]\  = \ DD[\[Theta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(II[\[Theta]_] := \
\((Sin[\((Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]] + Sin[\[CurlyPhi]])\)*
                    n)\)]/\((n*
                  Sin[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]] + 
                          Sin[\[CurlyPhi]])\)])\))\)^2;\), "\
\[IndentingNewLine]", 
    RowBox[{\(II\[Theta] = II[\[Theta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(P[\[Theta]_] := \ 
        DD[\[Theta]]*II[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(P\[Theta] = \ P[\[Theta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], II\[Theta]}], 
            Transpose[{\[Theta], DD\[Theta]}], 
            Transpose[{\[Theta], P\[Theta]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-0.6\), 0.6}, {0, 1}}], {{{Hue[
                  1], "\<II\[Theta]\>"}, {Hue[0.5], "\<DD\[Theta]\>"}, {Hue[
                  0.25], "\<P\[Theta]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \( (*\ 
      The\ angle\ \[CurlyPhi]\ shifts\ the\ zeroth\ order\ from\ 0\ for\ y = \
\(0\ to\  .2\ for\ y = \(- .2\)\)\ *) \)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{510, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3028, 59, 1160, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

