(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5479,        130]*)
(*NotebookOutlinePosition[      6124,        152]*)
(*  CellTagsIndexPosition[      6080,        148]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D14FAGRRES3DS
Determination of the wavelength difference for two peaks, resolved according \
to the Rayleigh criterion
  
We call the distance between the maxima b. Radius of apertures a, distance \
between the apertures d, coordinate on the observation screen R, 
wavelength \[Lambda], and distance from aperture to screen X. 
    
    
 1. Determination of Rayleigh distance.\
\>"], " ", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(a\  = \ 
        0.05;\), "\[IndentingNewLine]", \(X\  = \ 
        4000;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(b\  = \ 
        24.5;\), "\[IndentingNewLine]", \(n\  = \ 
        40;\), "\[IndentingNewLine]", \(R\  = \ 
        Range[0.0000000001, 50, 0.1000000000001];\), "\[IndentingNewLine]", 
    RowBox[{\(g1[
            R_] := \ \((BesselJ[
                  1, \((2*Pi*a*\((R/\((X*\[Lambda])\))\))\)]/\((2*Pi*
                    a*\((R/\((X*\[Lambda])\))\))\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(gg1[
            R_] := \ \((BesselJ[
                  1, \((2*Pi*a*\((\((R - b)\)/\((X*\[Lambda])\))\))\)]/\((2*
                    Pi*a*\((\((R - b)\)/\((X*\[Lambda])\))\))\))\)^2;\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{R, g1[R]}], Transpose[{R, gg1[R]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<R\>", "\<g\>"}, 
            PlotRange \[Rule] {{0, 50}, {0, 0.3}}], {{{Hue[
                  1], "\<g1[R]\>"}, {Hue[0.5], "\<gg1[R]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ 3  D\ Graph\ of\ pattern\ of\ two\ round\ apertures\ at\ \
distance\ \(\(b\)\(.\)\)\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(RR[x_, y_] := \ Sqrt[x^2 + y^2];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(g2[x_, 
          y_] := \ \((BesselJ[
                1, \((2*Pi*a*\((RR[x, y]/\((X*\[Lambda])\))\))\)]/\((2*Pi*
                  a*\((RR[x, 
                        y]/\((X*\[Lambda])\))\))\))\)^2;\), "\
\[IndentingNewLine]", \(gg2[x_, 
          y_] := \ \((BesselJ[
                1, \((2*Pi*a*\((RR[x, y - b]/\((X*\[Lambda])\))\))\)]/\((2*Pi*
                  a*\((RR[x, 
                        y - b]/\((X*\[Lambda])\))\))\))\)^2;\), "\
\[IndentingNewLine]", \(M = \ 
        Table[g2[\(-30\)\  + \ 2.0001*i, \(-30\)\  + \ 2.0001*j]\  + \ 
            gg2[\(-30\)\  + \ 2.0001*i, \(-30\)\  + \ 2.0001*j], {i, 0, n, 
            1}, {j, 0, n, 1}];\), "\[IndentingNewLine]", 
    RowBox[{\(ListPlot3D[M, \ PlotRange \[Rule] {{0, n}, {0, n}, {0, 0.25}}, 
          PlotLabel -> "\<M\>"];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{
    "(*", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", Cell["\<\
3. Calculation of wavelength difference corresponding to b

The diffraction angle is calculated from b/x=\[CapitalDelta]\[Theta].

The grating is made of round apertures of diameter a and spaced at distance \
d.
From the grating formula we have for the wavelength difference \
\[CapitalDelta]\[Lambda]=d\[CapitalDelta]\[Theta] or \
\[CapitalDelta]\[Lambda]= (d/X)b.

For d:=0.1, \[CapitalDelta]\[Theta]:=d*(b/x), \
\[CapitalDelta]\[Theta]=6.125*10e-4
\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}]}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{856, 599},
WindowMargins->{{39, Automatic}, {25, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3770, 78, 1102, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

