(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4469,        105]*)
(*NotebookOutlinePosition[      5114,        127]*)
(*  CellTagsIndexPosition[      5070,        123]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D16FAGGRANS
  
One dimensional periodic and random arrangement
for interference and diffraction
  
Diffraction on an amplitude grating with width of openings d, center to \
center distance of strips a, wavelength \[Lambda], distance from grating to \
screen X and coordinate on screen Y. All distances and wavelength in mm, \
number of lines N. Normal incidence.
All parameters are globally defined above the graph.
    
DD(\[Theta]) is the diffraction factor
II(\[Theta]) is the interference factor, normalized to 1.
P1(\[Theta]) is the product of interference and diffraction factor.
P2(\[Theta]) is for the case that the lines are not periodic and the \
interfernce factor averages to a constant.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< "\<Graphics`Legend`\>"\)}], "\
\[IndentingNewLine]", \(d\  = \ 
        0.002;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(a\  = \ 
        0.008;\), "\[IndentingNewLine]", \(n\  = \ 
        20;\), "\[IndentingNewLine]", \(CC\  = \ 
        0.5;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[\(-1.001\), 1.001, 
          0.002];\), "\[IndentingNewLine]", \(DD[\[Theta]_] := \ \((Sin[
                Pi*\((d/\[Lambda])\)*Sin[\[Theta]]]/\((Pi*\((d/\[Lambda])\)*
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", \(II[\
\[Theta]_] := \ \((Sin[
                Pi*\((a/\[Lambda])\)*Sin[\[Theta]]*n]/\((n*
                  Sin[Pi*\((a/\[Lambda])\)*
                      Sin[\[Theta]]])\))\)^2;\), "\[IndentingNewLine]", \(P1[\
\[Theta]_] := \ DD[\[Theta]]*II[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(P2[\[Theta]_] := \ DD[\[Theta]]*CC;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], P1[\[Theta]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<P1[\[Theta]]\>"}, 
            PlotRange \[Rule] {{\(-1.5\), 1.5}, {0, 1}}], {{{Hue[
                  1], "\<P1[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta], P2[\[Theta]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<P2[\[Theta]]\>"}, 
          PlotRange \[Rule] {{\(-1.5\), 1.5}, {0, 0.5}}], {{{Hue[
                1], "\<P2[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{498, 599},
WindowMargins->{{44, Automatic}, {Automatic, 14}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2760, 53, 1040, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

