(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4218,        101]*)
(*NotebookOutlinePosition[      4862,        123]*)
(*  CellTagsIndexPosition[      4818,        119]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D17ARAYRA3DS
  
3D Graph of diffraction pattern of a periodic array of
rectangular apertures.
In comparison the diffraction pattern of rectangular apertures in random \
array.
    
1.Periodic array\
\>"], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \(\[Lambda]\  = \ 
          4;\)}], "\[IndentingNewLine]", \(d\  = \ 
        2;\), "\[IndentingNewLine]", \(d1\  = \ 
        2;\), "\[IndentingNewLine]", \(a1\  = \ 
        4;\), "\[IndentingNewLine]", \(a\  = \ 
        4;\), "\[IndentingNewLine]", \(n\  = \ 
        30;\), "\[IndentingNewLine]", \(p\  = \ 6;\), "\[IndentingNewLine]", 
    RowBox[{\(f[x_, 
            y_] := \ \((\((Sin[
                      2*Pi*d*\((x/\((2*\[Lambda])\))\)]/\((2*Pi*
                        d*\((x/\((2*\[Lambda])\))\))\))\)^2)\)*\((\((Sin[
                      2*Pi*d1*\((y/\((2*\[Lambda])\))\)]/\((2*Pi*
                        d1*\((y/\((2*\[Lambda])\))\))\))\)^2)\)*\
\[IndentingNewLine]\((\((Sin[
                      2*Pi*a*\((\((x*p)\)/\((2*\[Lambda])\))\)]/\((p*
                        Sin[2*Pi*
                            a*\((x/\((2*\[Lambda])\))\)])\))\)^2)\)*\((\((Sin[
                      2*Pi*a1*\((\((y*p)\)/\((2*\[Lambda])\))\)]/\((p*
                        Sin[2*Pi*a1*\((y/\((2*\[Lambda])\))\)])\))\)^2)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(M\  = \ 
        Table[f[\(-2\)\  + \ 0.20001*i, \(-3\)\  + \ 0.20001*j], {i, 0.00001, 
            n, 1}, {j, 0.00001, n, 1}];\), "\[IndentingNewLine]", 
    RowBox[{\(ListPlot3D[M, PlotRange \[Rule] {{0, n}, {0, n}, {0, 0.9}}, 
          PlotLabel \[Rule] "\<M\>"];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 2.  Random\ Array\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(f1[x_, 
          y_] := \ \((\((Sin[
                    2*Pi*d*\((x/\((2*\[Lambda])\))\)]/\((2*Pi*
                      d*\((x/\((2*\[Lambda])\))\))\))\)^2)\)*\((\((Sin[
                    2*Pi*a*\((y/\((2*\[Lambda])\))\)]/\((2*Pi*
                      a*\((y/\((2*\[Lambda])\))\))\))\)^2)\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(MM\  = \ 
          Table[f1[\(-2\)\  + \ 0.20001*i, \(-3\)\  + \ 0.20001*j], {i, 0, n, 
              1}, {j, 0, n, 1}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ListPlot3D[MM, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 0.9}}, 
        PlotLabel -> "\<MM\>"];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{520, 599},
WindowMargins->{{-6, Automatic}, {Automatic, 4}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2509, 49, 870, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

