(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3741,         90]*)
(*NotebookOutlinePosition[      4385,        112]*)
(*  CellTagsIndexPosition[      4341,        108]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D19FESLITS

Fresnel's Integrals for the calculation of the diffraction on a slit.
    
All units in mm, globally definition of paramaters.   \
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(Y\  = \ 
        Range[0, 10, 0.1];\), "\[IndentingNewLine]", \(\[Lambda] = 
        5*10^\(-4\);\), "\[IndentingNewLine]", \(X\  = \ 
        4000;\), "\[IndentingNewLine]", 
    RowBox[{\(d\  = \ 1.5;\), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        We\ call\ \[Eta]1\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(q[Y_] := \ \((Y + d/2)\)*Sqrt[2/\((\[Lambda]*X)\)];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        We\ call\ \[Eta]2\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(p[Y_] := \ \((Y - d/2)\)*Sqrt[2/\((\[Lambda]*X)\)];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(CqY\  = \ \[Integral]\
\_0\%\(q[Y]\)Cos[\((Pi/
                    2)\)*\[Eta]^2] \[DifferentialD]\[Eta];\), "\
\[IndentingNewLine]", \(SqY\  = \ \[Integral]\_0\%\(q[Y]\)Sin[\((Pi/
                    2)\)*\[Eta]^2] \[DifferentialD]\[Eta];\), "\
\[IndentingNewLine]", \(CpY\  = \ \[Integral]\_0\%\(p[Y]\)Cos[\((Pi/
                    2)\)*\[Eta]^2] \[DifferentialD]\[Eta];\), "\
\[IndentingNewLine]", \(SpY\  = \ \[Integral]\_0\%\(p[Y]\)Sin[\((Pi/
                    2)\)*\[Eta]^2] \[DifferentialD]\[Eta];\), "\
\[IndentingNewLine]", 
    RowBox[{\(IY\  = \ \((CpY\  - \ CqY)\)^2\  + \ \((SpY - SqY)\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{Y, IY}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<Y\>", "\<IY[Y]\>"}, 
          PlotRange \[Rule] {{0, 8}, {0, 2.5}}], {{{Hue[1], "\<IY[Y]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{7, Automatic}, {Automatic, 32}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2032, 38, 736, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

