(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     62704,       2135]*)
(*NotebookOutlinePosition[     63348,       2157]*)
(*  CellTagsIndexPosition[     63304,       2153]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D20FEEDGES

Fresnel's Integrals for the calculation of the diffraction on an edge.
    
All units in mm, global definition of the parameters.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(Y\  = \ Range[\(-4\), 15, 0.075];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
We treat the diffraction at an edge like diffraction on a large slit. One \
side is set at d = 0, the other at d =-\[Infinity]. This translates into for \
p(Y) = -infinite we we have Cp(Y)=Sp(Y) = -0.5\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{\(Sqrt[2/\((\[Lambda]*X)\)] = 1\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Lambda] = 
        5*10^\(-4\);\), "\[IndentingNewLine]", 
    RowBox[{\(X\  = \ 4000;\), "\[IndentingNewLine]"}], "\[IndentingNewLine]",
   
    RowBox[{\(qY = \ Y*Sqrt[2/\((\[Lambda]*X)\)];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\( (*\ We\ take\ q \((Y)\)\ equal\ Y, 
        square\ root\ is\ for\ scaling\ *) \), \(qY = \ Y;\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(CqY\  = \ 
        N[\[Integral]\_0\%qY 
                Cos[\((Pi/
                      2)\)*\[Eta]^2] \[DifferentialD]\[Eta]];\), "\
\[IndentingNewLine]", 
    RowBox[{\(SqY\  = 
          N[\ \[Integral]\_0\%qY 
                  Sin[\((Pi/2)\)*\[Eta]^2] \[DifferentialD]\[Eta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(IY\  = \ \((\ 
                CqY - \((\(-0.5\))\))\)^2\  + \ \((SqY - \((\(-0.5\))\))\)^2;\
\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{Y, IY}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<Y\>", "\<IY[Y]\>"}, 
            PlotRange \[Rule] {{\(-5\), 15}, {0, 3}}], {{{Hue[
                  1], "\<IY[Y]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
To see that we derived this actually from a large slit,we treat a large slit
with positions at 0 and 10.\
\>"], " ", "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{\(pY = \ Y - 10;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(CpY\  = \ \[Integral]\
\_0\%pY Cos[\((Pi/
                    2)\)*\[Eta]^2] \[DifferentialD]\[Eta];\), "\
\[IndentingNewLine]", 
    RowBox[{\(SpY\  = \ \[Integral]\_0\%pY 
                Sin[\((Pi/2)\)*\[Eta]^2] \[DifferentialD]\[Eta];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(IIY\  = \ \ \((\ 
              CqY - CpY)\)^2\  + \ \((SqY - 
                SpY)\)^2;\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{Y, IIY}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<Y\>", "\<IIY[Y]\>"}, 
          PlotRange \[Rule] {{\(-5\), 15}, {0, 4}}], {{{Hue[
                1], "\<IIY[Y]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"],

Cell[BoxData[
    \(Set::"write" \(\(:\)\(\ \)\) 
      "Tag \!\(Sqrt\) in \!\(\@\({95.23809523809523`\/X, \
90.9090909090909`\/X, \(\(\[LeftSkeleton] 976 \[RightSkeleton]\)\), \
2.002002002002002`\/X, 2.`\/X}\)\) is Protected."\)], "Message"],

Cell[BoxData[
    \(1\)], "Output"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .41901 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.346651 0.322841 0.209503 0.322841 [
[ 0 0 0 0 ]
[ 1 .41901 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00997634 0.669492 0.40903 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.25 0.05 0 0.206011 [
[0 -0.0125 -6 -9 ]
[0 -0.0125 6 0 ]
[.125 -0.0125 -12 -9 ]
[.125 -0.0125 12 0 ]
[.375 -0.0125 -9 -9 ]
[.375 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.625 -0.0125 -9 -9 ]
[.625 -0.0125 9 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[.875 -0.0125 -12 -9 ]
[.875 -0.0125 12 0 ]
[1 -0.0125 -6 -9 ]
[1 -0.0125 6 0 ]
[1.025 0 0 -6.28125 ]
[1.025 0 10 6.28125 ]
[.2375 .10301 -18 -4.5 ]
[.2375 .10301 0 4.5 ]
[.2375 .20601 -6 -4.5 ]
[.2375 .20601 0 4.5 ]
[.2375 .30902 -18 -4.5 ]
[.2375 .30902 0 4.5 ]
[.2375 .41202 -6 -4.5 ]
[.2375 .41202 0 4.5 ]
[.2375 .51503 -18 -4.5 ]
[.2375 .51503 0 4.5 ]
[.2375 .61803 -6 -4.5 ]
[.2375 .61803 0 4.5 ]
[.25 .64303 -17 0 ]
[.25 .64303 17 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
0 .00625 L
s
[(-5)] 0 -0.0125 0 1 Mshowa
.125 0 m
.125 .00625 L
s
[(-2.5)] .125 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(2.5)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(5)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(7.5)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(10)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(12.5)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(15)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 .10301 m
.25625 .10301 L
s
[(0.5)] .2375 .10301 1 0 Mshowa
.25 .20601 m
.25625 .20601 L
s
[(1)] .2375 .20601 1 0 Mshowa
.25 .30902 m
.25625 .30902 L
s
[(1.5)] .2375 .30902 1 0 Mshowa
.25 .41202 m
.25625 .41202 L
s
[(2)] .2375 .41202 1 0 Mshowa
.25 .51503 m
.25625 .51503 L
s
[(2.5)] .2375 .51503 1 0 Mshowa
.25 .61803 m
.25625 .61803 L
s
[(3)] .2375 .61803 1 0 Mshowa
.125 Mabswid
.25 .0206 m
.25375 .0206 L
s
.25 .0412 m
.25375 .0412 L
s
.25 .0618 m
.25375 .0618 L
s
.25 .0824 m
.25375 .0824 L
s
.25 .12361 m
.25375 .12361 L
s
.25 .14421 m
.25375 .14421 L
s
.25 .16481 m
.25375 .16481 L
s
.25 .18541 m
.25375 .18541 L
s
.25 .22661 m
.25375 .22661 L
s
.25 .24721 m
.25375 .24721 L
s
.25 .26781 m
.25375 .26781 L
s
.25 .28842 m
.25375 .28842 L
s
.25 .32962 m
.25375 .32962 L
s
.25 .35022 m
.25375 .35022 L
s
.25 .37082 m
.25375 .37082 L
s
.25 .39142 m
.25375 .39142 L
s
.25 .43262 m
.25375 .43262 L
s
.25 .45322 m
.25375 .45322 L
s
.25 .47383 m
.25375 .47383 L
s
.25 .49443 m
.25375 .49443 L
s
.25 .53563 m
.25375 .53563 L
s
.25 .55623 m
.25375 .55623 L
s
.25 .57683 m
.25375 .57683 L
s
.25 .59743 m
.25375 .59743 L
s
.25 Mabswid
.25 0 m
.25 .61803 L
s
gsave
.25 .64303 -78 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(IY) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.000 12.813 moveto
(@) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.000 12.813 moveto
(D) show
93.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.05 .0013 m
.05375 .00135 L
.0575 .00141 L
.06125 .00146 L
.065 .00152 L
.06875 .00158 L
.0725 .00165 L
.07625 .00172 L
.08 .0018 L
.08375 .00188 L
.0875 .00197 L
.09125 .00206 L
.095 .00216 L
.09875 .00227 L
.1025 .00238 L
.10625 .00251 L
.11 .00264 L
.11375 .00279 L
.1175 .00294 L
.12125 .00311 L
.125 .0033 L
.12875 .0035 L
.1325 .00372 L
.13625 .00397 L
.14 .00423 L
.14375 .00452 L
.1475 .00485 L
.15125 .0052 L
.155 .0056 L
.15875 .00604 L
.1625 .00653 L
.16625 .00708 L
.17 .0077 L
.17375 .0084 L
.1775 .00919 L
.18125 .01009 L
.185 .01111 L
.18875 .01227 L
.1925 .01361 L
.19625 .01515 L
.2 .01692 L
.20375 .01898 L
.2075 .02137 L
.21125 .02415 L
.215 .0274 L
.21875 .0312 L
.2225 .03565 L
.22625 .04088 L
.23 .04702 L
.23375 .05425 L
Mistroke
.2375 .06273 L
.24125 .07269 L
.245 .08436 L
.24875 .09798 L
.2525 .11383 L
.25625 .13218 L
.26 .15329 L
.26375 .17738 L
.2675 .20461 L
.27125 .23504 L
.275 .26857 L
.27875 .30492 L
.2825 .34353 L
.28625 .38354 L
.29 .42374 L
.29375 .46255 L
.2975 .49806 L
.30125 .52809 L
.305 .55037 L
.30875 .56273 L
.3125 .56346 L
.31625 .55164 L
.32 .52753 L
.32375 .49286 L
.3275 .45102 L
.33125 .40693 L
.335 .3666 L
.33875 .33633 L
.3425 .32152 L
.34625 .32539 L
.35 .34775 L
.35375 .38437 L
.3575 .42724 L
.36125 .4659 L
.365 .48995 L
.36875 .49213 L
.3725 .47111 L
.37625 .4329 L
.38 .38992 L
.38375 .35735 L
.3875 .3477 L
.39125 .36526 L
.395 .40316 L
.39875 .445 L
.4025 .47134 L
.40625 .46901 L
.41 .43864 L
.41375 .39591 L
.4175 .36446 L
.42125 .36275 L
Mistroke
.425 .39222 L
.42875 .43459 L
.4325 .46202 L
.43625 .45546 L
.44 .41912 L
.44375 .37948 L
.4475 .36691 L
.45125 .39165 L
.455 .43365 L
.45875 .45725 L
.4625 .44143 L
.46625 .40023 L
.47 .37214 L
.47375 .3845 L
.4775 .42518 L
.48125 .45238 L
.485 .4371 L
.48875 .39576 L
.4925 .37469 L
.49625 .39833 L
.5 .43874 L
.50375 .44663 L
.5075 .41197 L
.51125 .37916 L
.515 .39144 L
.51875 .4323 L
.5225 .44515 L
.52625 .4117 L
.53 .38045 L
.53375 .39781 L
.5375 .43738 L
.54125 .43765 L
.545 .39817 L
.54875 .38302 L
.5525 .41724 L
.55625 .44285 L
.56 .41563 L
.56375 .38361 L
.5675 .40428 L
.57125 .43962 L
.575 .42363 L
.57875 .38687 L
.5825 .40054 L
.58625 .43746 L
.59 .42348 L
.59375 .38736 L
.5975 .40414 L
.60125 .43808 L
.605 .41628 L
.60875 .3866 L
Mistroke
.6125 .41477 L
.61625 .43701 L
.62 .40258 L
.62375 .3917 L
.6275 .42973 L
.63125 .42551 L
.635 .38963 L
.63875 .41039 L
.6425 .43557 L
.64625 .40165 L
.65 .39587 L
.65375 .43285 L
.6575 .41521 L
.66125 .39039 L
.665 .42509 L
.66875 .42425 L
.6725 .39064 L
.67625 .41814 L
.68 .42854 L
.68375 .39251 L
.6875 .41429 L
.69125 .42971 L
.695 .39361 L
.69875 .41384 L
.7025 .42886 L
.70625 .39334 L
.71 .41659 L
.71375 .42588 L
.7175 .39258 L
.72125 .42196 L
.725 .41979 L
.72875 .39364 L
.7325 .42815 L
.73625 .41005 L
.74 .39968 L
.74375 .43101 L
.7475 .39904 L
.75125 .41219 L
.755 .42505 L
.75875 .39401 L
.7625 .42617 L
.76625 .4093 L
.77 .40309 L
.77375 .42884 L
.7775 .39548 L
.78125 .42222 L
.785 .41253 L
.78875 .40206 L
.7925 .42828 L
.79625 .39567 L
Mistroke
.8 .42409 L
.80375 .40818 L
.8075 .40757 L
.81125 .42389 L
.815 .39649 L
.81875 .42824 L
.8225 .39906 L
.82625 .42002 L
.83 .41071 L
.83375 .40736 L
.8375 .42222 L
.84125 .39854 L
.845 .42753 L
.84875 .39687 L
.8525 .42589 L
.85625 .40111 L
.86 .41987 L
.86375 .40808 L
.8675 .41266 L
.87125 .41497 L
.875 .40645 L
.87875 .42027 L
.8825 .40214 L
.88625 .42361 L
.89 .39966 L
.89375 .42533 L
.8975 .39853 L
.90125 .426 L
.905 .39819 L
.90875 .42611 L
.9125 .39821 L
.91625 .42601 L
.92 .39836 L
.92375 .42581 L
.9275 .39862 L
.93125 .42542 L
.935 .39919 L
.93875 .42458 L
.9425 .40041 L
.94625 .42285 L
.95 .40275 L
.95375 .4198 L
.9575 .40657 L
.96125 .41518 L
.965 .4119 L
.96875 .40932 L
.9725 .41798 L
.97625 .40346 L
.98 .42305 L
.98375 .39981 L
Mistroke
.9875 .42463 L
.99125 .40079 L
.995 .42079 L
.99875 .40737 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
0 g
.71792 .19336 m
.71792 .2979 L
.97619 .2979 L
.97619 .19336 L
F
1 g
.70178 .2095 m
.70178 .31404 L
.96005 .31404 L
.96005 .2095 L
F
0 g
.001 w
[ ] 0 setdash
.70178 .2095 m
.96005 .2095 L
.96005 .31404 L
.70178 .31404 L
.70178 .2095 L
s
% Start of sub-graphic
p
0.701776 0.209503 0.960048 0.314042 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .40476 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .40476 L
0 .40476 L
closepath
clip
newpath
1 0 0 r
.05357 .05357 m
.05357 .35119 L
.35119 .35119 L
.35119 .05357 L
F
0 g
gsave
.38988 .20238 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(IY) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
75.000 12.813 moveto
(@) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
87.000 12.813 moveto
(D) show
93.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .41901 L
0 .41901 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 120.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`006`3oool2000000T0oooo1000
00030?ooo`800000103oool200000140oooo100000030?ooo`800000103oool2000000T0oooo0P00
000;0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`8000001P3oool500000080oooo0P00
00020?ooo`D0000000<0oooo0000000000000P0000030?ooo`800000103oool2000000<0oooo1@00
00020?ooo`800000MP3oool001X0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?oo
o`090?ooo`040000003oool0oooo00000100oooo00<000000?ooo`3oool02@3oool010000000oooo
0?ooo`0000070?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool01`3oool01000
0000oooo0?ooo`0000070?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000040?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1c0?ooo`007@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1c0?ooo`00503oool40000
00<0oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`080?ooo`8000004`3oool00`00
0000oooo0?ooo`080?ooo`8000002@3oool2000000`0oooo00<000000?ooo`3oool01`3oool20000
00P0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`800000MP3o
ool001/0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo0100oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`070?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0M@3oool001/0oooo0`0000090?ooo`8000002P3oool300000140oooo0P00000:
0?ooo`<00000203oool3000000P0oooo100000090?ooo`<000001P3oool2000000@0oooo0P000003
0?ooo`800000103oool2000000X0oooo0`0000030?ooo`800000103oool3000007D0oooo003o0?oo
ob40oooo003o0?ooob40oooo002]0?ooo`<00000L03oool00:h0oooo00<000000?ooo`3oool0K`3o
ool001T0oooo1`00000A0?l007H000001`3oool00`000000oooo0?ooo`1_0?ooo`00<03oool50?l0
00L0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0000001`0?ooo`00=@3oool20?l000D0
oooo0P00001^0?ooo`050000003oool0oooo0?ooo`000000K`3oool003H0oooo0P3o00040?ooo`03
0000003oool0oooo06`0oooo0`0000000`3oool000000000001_0?ooo`00>03oool01@3o0000oooo
0?ooo`3oool000000><0oooo000h0?ooo`80o`000P3oool200000>80oooo000i0?ooo`040?l0003o
ool0oooo00000><0oooo000j0?ooo`030?l0003oool000000><0oooo000j0?ooo`040?l0003oool0
000000000>80oooo000j0?ooo`030?l0003oool000000><0oooo000k0?ooo`030?l000000000oooo
0>80oooo000k0?ooo`030?l00000000000000>80oooo000Z0?ooo`800000103oool2000000@0oooo
0P0000030?ooo`030?l000000000oooo0>80oooo000Y0?ooo`040000003oool0oooo000000P0oooo
00@000000?ooo`3oool000000`3oool00`3o0000oooo0?ooo`3Q0?ooo`00:@3oool010000000oooo
0?ooo`00000;0?ooo`060000003oool0oooo0?ooo`3o00000000hP3oool002T0oooo00@000000?oo
o`3oool000002@3oool2000000@0oooo00<000000?l0003oool0h@3oool002T0oooo00@000000?oo
o`3oool000002@3oool00`000000oooo0?ooo`030?ooo`030000003o0000oooo0>40oooo000Z0?oo
o`8000002P3oool3000000<0oooo00<000000?l0003oool0h@3oool003`0oooo00<000000?l0003o
ool0h@3oool003`0oooo00<000000?l0003oool0h@3oool003`0oooo0P0000000`3o0000oooo0?oo
o`3O0?ooo`00?03oool00`000000oooo0?l0003Q0?ooo`00?03oool00`000000oooo0?l0003Q0?oo
o`00?03oool2000000030?l0003oool0oooo0=l0oooo000l0?ooo`030000003oool0o`000>40oooo
000l0?ooo`030000003oool0o`000>40oooo000l0?ooo`80000000<0o`000?ooo`3oool0g`3oool0
03D0oooo1@0000020?ooo`040000003oool0oooo0?l00>00oooo000g0?ooo`030000003oool0oooo
0080oooo00@000000?ooo`3oool0o`00h03oool003L0oooo00<000000?ooo`3oool00P3oool20000
00030?ooo`3o0000oooo0=l0oooo000g0?ooo`030000003oool0oooo0080oooo00@000000?ooo`3o
ool0o`00h03oool003L0oooo00<000000?ooo`3oool00P3oool2000000030?ooo`3o0000oooo0=l0
oooo000f0?ooo`800000103oool010000000oooo0?ooo`3o003P0?ooo`00?03oool010000000oooo
0?ooo`3o003P0?ooo`00?03oool2000000030?ooo`3o0000oooo0=l0oooo000l0?ooo`040000003o
ool0oooo0?l00>00oooo000l0?ooo`050000003oool0oooo0?ooo`3o0000g`3oool003`0oooo0P00
00020?ooo`030?l0003oool0oooo0=d0oooo000l0?ooo`050000003oool0oooo0?ooo`3o0000g`3o
ool003`0oooo00D000000?ooo`3oool0oooo0?l0003O0?ooo`00?03oool200000080oooo00<0o`00
0?ooo`3oool0g@3oool002T0oooo1@0000020?ooo`800000103oool2000000@0oooo00D000000?oo
o`3oool0oooo0?l0003O0?ooo`00:`3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo
000000<0oooo00D000000?ooo`3oool0oooo0?l0002<0?ooodX000002@3oool002/0oooo00<00000
0?ooo`3oool02P3oool010000000oooo0?ooo`3oool200000080oooo00<0o`000?ooo`3oool0RP3o
oom:000000T0oooo000[0?ooo`030000003oool0oooo00P0oooo0P0000040?ooo`050000003oool0
oooo0?ooo`3o0000S03ooom:000000T0oooo000[0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool00`3oool01@000000oooo0?ooo`3oool0o`0000P0oooo0P3o00220?ooodX000002@3o
ool002X0oooo0P00000:0?ooo`<000000`3oool2000000<0oooo00<0o`000?ooo`3oool01@3oool2
0?l007h0ooooCP0000090?ooo`00?03oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo
00D0oooo0P3o001n0?ooo`030000003oool0oooo04H0oooo1@0000090?ooo`00?03oool00`000000
oooo0?ooo`020?ooo`030?l0003oool0oooo00D0oooo0P3o001n0?ooo`030000003oool0oooo04H0
oooo1@0000090?ooo`00?03oool2000000<0oooo00<0o`000?ooo`3oool0103oool00`3o0000oooo
0?l000050?ooo`030?l0003oool0oooo07H0oooo00<000000?ooo`3oool0AP3oool5000000T0oooo
000l0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0103oool00`3o0000oooo0?l0
00040?ooo`80o`00N03oool00`000000oooo0?ooo`160?ooo`D000002@3oool003`0oooo00<00000
0?ooo`3oool00P3oool00`3o0000oooo0?ooo`040?ooo`030?l0003oool0o`0000@0oooo0P3o0003
0?ooo`050?l0003oool0oooo0?ooo`3o0000L03oool010000000oooo0?ooo`3ooolE0?l00300oooo
1@0000090?ooo`00?03oool2000000<0oooo00<0o`000?ooo`3oool0103oool0103o0000oooo0?oo
o`3o00030?ooo`80o`000`3oool01@3o0000oooo0?ooo`3oool0o`000080oooo00@0o`000?ooo`3o
ool0o`00JP3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00?03oool00`00
0000oooo0?ooo`020?ooo`030?l0003oool0oooo00@0oooo00@0o`000?ooo`3oool0o`000`3oool2
0?l00080oooo0P3o00030?ooo`040?l0003oool0oooo0?l00080oooo00@0o`000?ooo`3oool0o`00
0P3oool00`3o0000oooo0?l0001R0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0
oooo000l0?ooo`030000003oool0oooo0080oooo00<0o`000?ooo`3oool0103oool0103o0000oooo
0?ooo`3o00030?ooo`070?l0003oool0o`000?ooo`3o0000oooo0?l000020?ooo`80o`0000D0oooo
0?l0003o0000oooo0?l000020?ooo`080?l0003oool0oooo0?l0003oool0o`000?ooo`3o00020?oo
o`050?l0003oool0o`000?ooo`3o00000P3oool00`3o0000oooo0?ooo`1D0?ooo`040000003oool0
oooo0?oooaD0o`00<03oool5000000T0oooo000l0?ooo`8000000`3oool00`3o0000oooo0?ooo`04
0?ooo`040?l0003oool0oooo0?l000<0oooo00L0o`000?ooo`3o0000oooo0?l0003oool0o`000080
oooo0P3o0000103oool0o`000?l0003oool20?l000090?ooo`3o0000o`000?ooo`3o0000oooo0?l0
003oool0o`000080oooo00H0o`000?ooo`3o0000oooo0?l0003oool20?l00080oooo0P3o0000103o
ool0o`000?l0003oool20?l000040?ooo`3o0000oooo0?l000<0oooo00H0o`000?ooo`3oool0o`00
0?ooo`3o00020?ooo`030?l0003oool0oooo0080oooo00<0o`000?ooo`3oool0=@3oool010000000
oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00=@3oool4000000<0oooo00<000000?ooo`3o
ool00P3oool00`3o0000oooo0?ooo`040?ooo`040?l0003oool0oooo0?l000<0oooo00`0o`000?oo
o`3o0000oooo0?l0003oool0o`000?ooo`3o0000oooo0?l0003oool20?l000050?ooo`3o0000o`00
0?l0003oool00`3o00000`3oool0o`000?l000020?l000030?ooo`3o0000oooo00X0o`0000@0oooo
0?l0003o0000oooo0P3o00000`3oool0o`000?ooo`030?l000040?ooo`3o0000o`000?ooo`<0o`00
0P3oool20?l00080oooo0`3o00020?ooo`@0o`0000<0oooo0?l0003o0000103o00030?ooo`<0o`00
8`3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00=@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00<0oooo00<0o`000?ooo`3oool00`3oool0103o0000oooo
0?ooo`3o00030?ooo`0<0?l0003oool0o`000?ooo`3o0000oooo0?l0003oool0o`000?ooo`3o0000
oooo0P3o00001@3oool0o`000?l0003o0000oooo00<0o`0000<0oooo0?l0003o00007P3o00000`3o
ool0o`000?l000060?l000030?ooo`3o0000o`0000L0o`0000<0oooo0?l0003o00002`3o000R0?oo
o`040000003oool0oooo0?oooaD0o`00503oool2000000P0oooo0P00000@0?ooo`D000002@3oool0
03H0oooo00<000000?ooo`3oool00`3oool2000000@0oooo00<0o`000?ooo`3oool00`3oool0103o
0000oooo0?ooo`3o00020?ooo`0=0?l0003oool0oooo0?l0003oool0o`000?ooo`3o0000oooo0?l0
003oool0o`000?ooo`030?l000040?ooo`3o0000o`000?ooo`<0o`0000<0oooo0?l0003o0000?P3o
000S0?ooo`040000003oool0oooo0?oooaD0o`00503oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00h0oooo1@0000090?ooo`00=`3oool00`000000oooo0?ooo`020?ooo`030000003o
ool0oooo00<0oooo00<0o`000?ooo`3oool00`3oool0103o0000oooo0?ooo`3o00020?ooo`0;0?l0
003oool0oooo0?l0003oool0o`000?ooo`3o0000oooo0?l0003oool00P3o0000103oool0o`000?l0
003oool20?l000060?ooo`3o0000o`000?ooo`3o0000oooo103o00000`3oool0o`000?ooo`0C0?l0
00050?ooo`3o0000o`000?l0003oool00P3o00000`3oool0o`000?l000030?l000030?ooo`3o0000
o`000080o`000P3oool;0?l000<0oooo0`3o000S0?ooo`040000003oool0oooo0?oooaD0o`001`3o
ool3000000<0oooo0`0000040?ooo`030000003oool0oooo0080oooo0`0000030?ooo`030000003o
ool0oooo00h0oooo1@0000090?ooo`00=@3oool010000000oooo0?ooo`0000030?ooo`800000103o
ool00`3o0000oooo0?ooo`020?ooo`050?l0003oool0oooo0?ooo`3o00000P3oool02`3o0000oooo
0?ooo`3o0000oooo0?l0003oool0o`000?ooo`3o0000oooo0080o`0000@0oooo0?l0003o0000oooo
0P3o00002@3oool0o`000?l0003oool0o`000?ooo`3o0000oooo0?l000020?ooo`040?l0003oool0
o`000?ooo`80o`000P3oool20?l000<0oooo0P3o0000303oool0o`000?ooo`3o0000oooo0?l0003o
ool0o`000?ooo`3o0000oooo0?l00080oooo00@0o`000?ooo`3oool0o`000`3oool20?l000H0oooo
103o000]0?ooo`040000003oool0oooo0?oooaD0o`00203oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo00h0oooo1@0000090?ooo`00=P3oool2000000@0oooo00<000000?ooo`3oool0
0`3oool00`3o0000oooo0?ooo`020?ooo`050?l0003oool0oooo0?ooo`3o00000P3oool02`3o0000
oooo0?ooo`3o0000oooo0?l0003oool0o`000?ooo`3o0000oooo0080o`0000@0oooo0?l0003o0000
oooo0P3o00002@3oool0o`000?l0003oool0o`000?ooo`3o0000oooo0?l000020?ooo`050?l0003o
ool0o`000?ooo`3o00000`3oool20?l005<0oooo00@000000?ooo`3oool0oooo5@3o00080?ooo`03
0000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool03P3oool5000000T0oooo000l0?ooo`030000
003oool0oooo00<0oooo00<0o`000?ooo`3oool00P3oool01@3o0000oooo0?ooo`3oool0o`000080
oooo00L0o`000?ooo`3oool0o`000?ooo`3o0000oooo0080o`000P3oool20?l00080oooo00@0o`00
0?ooo`3oool0o`000P3oool01@3o0000oooo0?ooo`3oool0o`000640oooo00@000000?ooo`3oool0
oooo5@3o00080?ooo`030000003oool0oooo0080oooo00<000000?ooo`000000103oool00`000000
oooo0?ooo`020?ooo`030000003oool0000000<0oooo00<000000?ooo`3oool03P3oool5000000T0
oooo000l0?ooo`800000103oool00`3o0000oooo0?ooo`020?ooo`030?l0003oool0oooo0080oooo
00<0o`000?ooo`3o00000P3oool0103o0000oooo0?l0003oool20?l000<0oooo00@0o`000?ooo`3o
ool0o`00J`3oool010000000oooo0?ooo`3ooolE0?l000P0oooo00D000000?ooo`3oool0oooo0000
00030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool03P3oool5000000T0oooo000l0?ooo`030000003oool0oooo00<0oooo
00<0o`000?ooo`3oool00P3oool00`3o0000oooo0?ooo`020?ooo`80o`000`3oool20?l000<0oooo
00D0o`000?ooo`3oool0oooo0?l0001^0?ooo`040000003oool0oooo0?oooaD0o`001`3oool30000
00050?ooo`00000000000000003oool00P0000030?ooo`80000000D0oooo00000000000000000?oo
o`02000000030?ooo`00000000000100oooo1@0000090?ooo`00?03oool00`000000oooo0?ooo`03
0?ooo`030?l0003oool0oooo0080oooo00<0o`000?ooo`3oool00P3oool20?l000@0oooo00D0o`00
0?ooo`3oool0oooo0?l0001b0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo
000l0?ooo`800000103oool00`3o0000oooo0?ooo`020?ooo`030?l0003oool0oooo0080oooo0P3o
00040?ooo`030?l0003oool0oooo07@0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D00000
2@3oool003`0oooo00<000000?ooo`3oool00`3oool00`3o0000oooo0?ooo`020?ooo`030?l0003o
ool0oooo0080oooo0P3o001k0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo
000l0?ooo`030000003oool0oooo00@0oooo00D0o`000?ooo`3oool0oooo0?l000040?ooo`80o`00
N`3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00?03oool2000000D0oooo
00D0o`000?ooo`3oool0oooo0?l000040?ooo`80o`00N`3oool010000000oooo0?ooo`3ooolE0?l0
0300oooo1@0000090?ooo`00:@3oool4000000<0oooo0P0000040?ooo`800000103oool00`000000
oooo0?ooo`040?ooo`050?l0003oool0oooo0?ooo`3o0000P@3oool010000000oooo0?ooo`3ooolE
0?l00300oooo1@0000090?ooo`00:@3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo
000000<0oooo00<000000?ooo`3oool0103oool01@3o0000oooo0?ooo`3oool0o`000840oooo00@0
00000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3oool002X0oooo00<000000?ooo`3oool02`3o
ool010000000oooo0?ooo`3oool2000000D0oooo00@0o`000?ooo`3oool0o`00PP3oool010000000
oooo0?ooo`3ooolE0?l00300oooo00<000000?ooo`3oool02`3oool002/0oooo00<000000?ooo`3o
ool0203oool2000000@0oooo00<000000?ooo`3oool0103oool0103o0000oooo0?ooo`3o00220?oo
o`030000003oool0oooo04H0oooo00<000000?ooo`3oool02`3oool002T0oooo00@000000?ooo`3o
ool000002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00@0oooo00@0o`000?oo
o`3oool0o`00PP3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00/0oooo000Z0?oo
o`8000002P3oool3000000<0oooo0P0000050?ooo`040?l0003oool0oooo0?l00880oooo00<00000
0?ooo`3oool0AP3oool00`000000oooo0?ooo`0;0?ooo`00?03oool00`000000oooo0?ooo`050?oo
o`030?l0003oool0o`000880ooooBP00000=0?ooo`00?03oool00`000000oooo0?ooo`050?ooo`03
0?l0003oool0o`000=T0oooo000l0?ooo`8000001P3oool20?l00=X0oooo000l0?ooo`030000003o
ool0oooo00D0oooo0P3o003J0?ooo`00?03oool00`000000oooo0?ooo`3Q0?ooo`00?03oool20000
0>80oooo000l0?ooo`030000003oool0oooo0>40oooo000l0?ooo`030000003oool0oooo0>40oooo
000l0?ooo`800000hP3oool003H0oooo0P0000040?ooo`030000003oool0oooo0>40oooo000e0?oo
o`040000003oool0oooo000000<0oooo00<000000?ooo`3oool0h@3oool003L0oooo00<000000?oo
o`3oool00P3oool200000>80oooo000h0?ooo`030000003oool0oooo0>D0oooo000e0?ooo`040000
003oool0oooo00000>L0oooo000f0?ooo`800000j03oool00?l0oooo8@3oool00?l0oooo8@3oool0
03`0oooo0P0000080?ooo`800000f03oool003`0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`3F0?ooo`00;`3oool3000000<0oooo0`0000040?ooo`030000003oool0oooo0080oooo
0`0000030?ooo`030000003oool0oooo0=H0oooo000`0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0eP3oool00300oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3F
0?ooo`00<03oool00`000000oooo0?ooo`020?ooo`030000003oool0000000@0oooo00<000000?oo
o`3oool00P3oool00`000000oooo000000030?ooo`030000003oool0oooo0=H0oooo000`0?ooo`05
0000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0000000<0oooo00D00000
0?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0=H0oooo000_0?ooo`<0000000D0oooo
00000000000000000?ooo`02000000<0oooo0P0000001@3oool00000000000000000oooo00800000
00<0oooo000000000000f03oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {119.625, 0}} -> {-1.08192, -0.648936, \
0.0108496, 0.0108496}, {{7.5, 191.875}, {116.75, 2.8125}} -> {-8.61473, \
-0.469751, 0.141929, 0.0344471}, {{201.063, 274.813}, {59.8125, 29.9375}} -> \
{-9.26038, -2.8256, 0.0455598, 0.0455598}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .41901 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.346651 0.322841 0.209503 0.322841 [
[ 0 0 0 0 ]
[ 1 .41901 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
% Start of sub-graphic
p
0.0238095 0.00997634 0.669492 0.40903 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.25 0.05 0 0.154508 [
[0 -0.0125 -6 -9 ]
[0 -0.0125 6 0 ]
[.125 -0.0125 -12 -9 ]
[.125 -0.0125 12 0 ]
[.375 -0.0125 -9 -9 ]
[.375 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.625 -0.0125 -9 -9 ]
[.625 -0.0125 9 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[.875 -0.0125 -12 -9 ]
[.875 -0.0125 12 0 ]
[1 -0.0125 -6 -9 ]
[1 -0.0125 6 0 ]
[1.025 0 0 -6.28125 ]
[1.025 0 10 6.28125 ]
[.2375 .07725 -18 -4.5 ]
[.2375 .07725 0 4.5 ]
[.2375 .15451 -6 -4.5 ]
[.2375 .15451 0 4.5 ]
[.2375 .23176 -18 -4.5 ]
[.2375 .23176 0 4.5 ]
[.2375 .30902 -6 -4.5 ]
[.2375 .30902 0 4.5 ]
[.2375 .38627 -18 -4.5 ]
[.2375 .38627 0 4.5 ]
[.2375 .46353 -6 -4.5 ]
[.2375 .46353 0 4.5 ]
[.2375 .54078 -18 -4.5 ]
[.2375 .54078 0 4.5 ]
[.2375 .61803 -6 -4.5 ]
[.2375 .61803 0 4.5 ]
[.25 .64303 -20 0 ]
[.25 .64303 20 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 0 m
0 .00625 L
s
[(-5)] 0 -0.0125 0 1 Mshowa
.125 0 m
.125 .00625 L
s
[(-2.5)] .125 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(2.5)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(5)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(7.5)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(10)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(12.5)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(15)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
69.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 .07725 m
.25625 .07725 L
s
[(0.5)] .2375 .07725 1 0 Mshowa
.25 .15451 m
.25625 .15451 L
s
[(1)] .2375 .15451 1 0 Mshowa
.25 .23176 m
.25625 .23176 L
s
[(1.5)] .2375 .23176 1 0 Mshowa
.25 .30902 m
.25625 .30902 L
s
[(2)] .2375 .30902 1 0 Mshowa
.25 .38627 m
.25625 .38627 L
s
[(2.5)] .2375 .38627 1 0 Mshowa
.25 .46353 m
.25625 .46353 L
s
[(3)] .2375 .46353 1 0 Mshowa
.25 .54078 m
.25625 .54078 L
s
[(3.5)] .2375 .54078 1 0 Mshowa
.25 .61803 m
.25625 .61803 L
s
[(4)] .2375 .61803 1 0 Mshowa
.125 Mabswid
.25 .01545 m
.25375 .01545 L
s
.25 .0309 m
.25375 .0309 L
s
.25 .04635 m
.25375 .04635 L
s
.25 .0618 m
.25375 .0618 L
s
.25 .09271 m
.25375 .09271 L
s
.25 .10816 m
.25375 .10816 L
s
.25 .12361 m
.25375 .12361 L
s
.25 .13906 m
.25375 .13906 L
s
.25 .16996 m
.25375 .16996 L
s
.25 .18541 m
.25375 .18541 L
s
.25 .20086 m
.25375 .20086 L
s
.25 .21631 m
.25375 .21631 L
s
.25 .24721 m
.25375 .24721 L
s
.25 .26266 m
.25375 .26266 L
s
.25 .27812 m
.25375 .27812 L
s
.25 .29357 m
.25375 .29357 L
s
.25 .32447 m
.25375 .32447 L
s
.25 .33992 m
.25375 .33992 L
s
.25 .35537 m
.25375 .35537 L
s
.25 .37082 m
.25375 .37082 L
s
.25 .40172 m
.25375 .40172 L
s
.25 .41717 m
.25375 .41717 L
s
.25 .43262 m
.25375 .43262 L
s
.25 .44807 m
.25375 .44807 L
s
.25 .47898 m
.25375 .47898 L
s
.25 .49443 m
.25375 .49443 L
s
.25 .50988 m
.25375 .50988 L
s
.25 .52533 m
.25375 .52533 L
s
.25 .55623 m
.25375 .55623 L
s
.25 .57168 m
.25375 .57168 L
s
.25 .58713 m
.25375 .58713 L
s
.25 .60258 m
.25375 .60258 L
s
.25 Mabswid
.25 0 m
.25 .61803 L
s
gsave
.25 .64303 -81 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(IIY) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
81.000 12.813 moveto
(@) show
87.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 12.813 moveto
(D) show
99.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.05 .0005 m
.05375 .00149 L
.0575 .00115 L
.06125 .00074 L
.065 .00184 L
.06875 .00083 L
.0725 .00131 L
.07625 .00186 L
.08 .00075 L
.08375 .00198 L
.0875 .00159 L
.09125 .00109 L
.095 .00248 L
.09875 .00125 L
.1025 .00185 L
.10625 .00259 L
.11 .00121 L
.11375 .0028 L
.1175 .00235 L
.12125 .00172 L
.125 .00357 L
.12875 .00204 L
.1325 .00284 L
.13625 .00391 L
.14 .00212 L
.14375 .00429 L
.1475 .00383 L
.15125 .00302 L
.155 .00567 L
.15875 .00372 L
.1625 .00487 L
.16625 .00664 L
.17 .00426 L
.17375 .00749 L
.1775 .00724 L
.18125 .00616 L
.185 .01045 L
.18875 .00808 L
.1925 .00993 L
.19625 .01349 L
.2 .01032 L
.20375 .01579 L
.2075 .01691 L
.21125 .0155 L
.215 .02387 L
.21875 .022 L
.2225 .02543 L
.22625 .03471 L
.23 .03137 L
.23375 .04215 L
Mistroke
.2375 .05004 L
.24125 .049 L
.245 .06824 L
.24875 .07345 L
.2525 .08009 L
.25625 .10721 L
.26 .1105 L
.26375 .13027 L
.2675 .16312 L
.27125 .16701 L
.275 .20311 L
.27875 .23786 L
.2825 .24438 L
.28625 .29469 L
.29 .32468 L
.29375 .33116 L
.2975 .38544 L
.30125 .40001 L
.305 .39607 L
.30875 .43693 L
.3125 .42471 L
.31625 .39702 L
.32 .41051 L
.32375 .37276 L
.3275 .32197 L
.33125 .3161 L
.335 .28259 L
.33875 .23737 L
.3425 .2437 L
.34625 .25816 L
.35 .25062 L
.35375 .27926 L
.3575 .33798 L
.36125 .34954 L
.365 .34892 L
.36875 .38036 L
.3725 .36669 L
.37625 .30822 L
.38 .28697 L
.38375 .28568 L
.3875 .26279 L
.39125 .256 L
.395 .30405 L
.39875 .35432 L
.4025 .34764 L
.40625 .33221 L
.41 .339 L
.41375 .31503 L
.4175 .2647 L
.42125 .2542 L
Mistroke
.425 .3015 L
.42875 .34758 L
.4325 .34073 L
.43625 .31933 L
.44 .31837 L
.44375 .30682 L
.4475 .27909 L
.45125 .27291 L
.455 .31356 L
.45875 .36306 L
.4625 .3501 L
.46625 .2886 L
.47 .2567 L
.47375 .28725 L
.4775 .34372 L
.48125 .35539 L
.485 .31114 L
.48875 .27306 L
.4925 .28098 L
.49625 .32382 L
.5 .35035 L
.50375 .32382 L
.5075 .28098 L
.51125 .27306 L
.515 .31114 L
.51875 .35539 L
.5225 .34372 L
.52625 .28725 L
.53 .2567 L
.53375 .2886 L
.5375 .3501 L
.54125 .36306 L
.545 .31356 L
.54875 .27291 L
.5525 .27909 L
.55625 .30682 L
.56 .31837 L
.56375 .31933 L
.5675 .34073 L
.57125 .34758 L
.575 .3015 L
.57875 .2542 L
.5825 .2647 L
.58625 .31503 L
.59 .339 L
.59375 .33221 L
.5975 .34764 L
.60125 .35432 L
.605 .30405 L
.60875 .256 L
Mistroke
.6125 .26279 L
.61625 .28568 L
.62 .28697 L
.62375 .30822 L
.6275 .36669 L
.63125 .38036 L
.635 .34892 L
.63875 .34954 L
.6425 .33798 L
.64625 .27926 L
.65 .25062 L
.65375 .25816 L
.6575 .2437 L
.66125 .23737 L
.665 .28259 L
.66875 .3161 L
.6725 .32197 L
.67625 .37276 L
.68 .41051 L
.68375 .39702 L
.6875 .42471 L
.69125 .43693 L
.695 .39607 L
.69875 .40001 L
.7025 .38544 L
.70625 .33116 L
.71 .32468 L
.71375 .29469 L
.7175 .24438 L
.72125 .23786 L
.725 .20311 L
.72875 .16701 L
.7325 .16312 L
.73625 .13027 L
.74 .1105 L
.74375 .10721 L
.7475 .08009 L
.75125 .07345 L
.755 .06824 L
.75875 .049 L
.7625 .05004 L
.76625 .04215 L
.77 .03137 L
.77375 .03471 L
.7775 .02543 L
.78125 .022 L
.785 .02387 L
.78875 .0155 L
.7925 .01691 L
.79625 .01579 L
Mistroke
.8 .01032 L
.80375 .01349 L
.8075 .00993 L
.81125 .00808 L
.815 .01045 L
.81875 .00616 L
.8225 .00724 L
.82625 .00749 L
.83 .00426 L
.83375 .00664 L
.8375 .00487 L
.84125 .00372 L
.845 .00567 L
.84875 .00302 L
.8525 .00383 L
.85625 .00429 L
.86 .00212 L
.86375 .00391 L
.8675 .00284 L
.87125 .00204 L
.875 .00357 L
.87875 .00172 L
.8825 .00235 L
.88625 .0028 L
.89 .00121 L
.89375 .00259 L
.8975 .00185 L
.90125 .00125 L
.905 .00248 L
.90875 .00109 L
.9125 .00159 L
.91625 .00198 L
.92 .00075 L
.92375 .00186 L
.9275 .00131 L
.93125 .00083 L
.935 .00184 L
.93875 .00074 L
.9425 .00115 L
.94625 .00149 L
.95 .0005 L
.95375 .00141 L
.9575 .00098 L
.96125 .00059 L
.965 .00143 L
.96875 .00054 L
.9725 .00087 L
.97625 .00117 L
.98 .00035 L
.98375 .00111 L
Mistroke
.9875 .00076 L
.99125 .00044 L
.995 .00115 L
.99875 .0004 L
Mfstroke
MathSubEnd
P
% End of sub-graphic
0 g
.71792 .19336 m
.71792 .2979 L
.97619 .2979 L
.97619 .19336 L
F
1 g
.70178 .2095 m
.70178 .31404 L
.96005 .31404 L
.96005 .2095 L
F
0 g
.001 w
[ ] 0 setdash
.70178 .2095 m
.96005 .2095 L
.96005 .31404 L
.70178 .31404 L
.70178 .2095 L
s
% Start of sub-graphic
p
0.701776 0.209503 0.960048 0.314042 MathSubStart
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0297619 0.297619 0.0297619 0.297619 [
[ 0 0 0 0 ]
[ 1 .40476 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .40476 L
0 .40476 L
closepath
clip
newpath
1 0 0 r
.05357 .05357 m
.05357 .35119 L
.35119 .35119 L
.35119 .05357 L
F
0 g
gsave
.38988 .20238 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(IIY) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
81.000 12.813 moveto
(@) show
87.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Y) show
%%IncludeResource: font Math2Mono
%%IncludeFont: Math2Mono
/Math2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 12.813 moveto
(D) show
99.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
MathSubEnd
P
% End of sub-graphic
0 0 m
1 0 L
1 .41901 L
0 .41901 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 120.625},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000N2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`006`3oool2000000T0oooo1000
00030?ooo`800000103oool200000140oooo100000030?ooo`800000103oool2000000T0oooo0P00
000;0?ooo`030000003oool0oooo0080oooo0P0000040?ooo`8000001P3oool500000080oooo0P00
00020?ooo`D0000000<0oooo0000000000000P0000030?ooo`800000103oool2000000<0oooo1@00
00020?ooo`800000MP3oool001X0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?oo
o`090?ooo`040000003oool0oooo00000100oooo00<000000?ooo`3oool02@3oool010000000oooo
0?ooo`0000070?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool01`3oool01000
0000oooo0?ooo`0000070?ooo`050000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?oo
o`3oool0000000<0oooo00<000000?ooo`3oool02@3oool010000000oooo0?ooo`0000040?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1c0?ooo`007@3oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00D000000?ooo`3oool0oooo000000020?oo
o`050000003oool0oooo0?ooo`000000103oool00`000000oooo0?ooo`0;0?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1c0?ooo`00503oool40000
00<0oooo0P0000030?ooo`@00000103oool00`000000oooo0?ooo`080?ooo`8000004`3oool00`00
0000oooo0?ooo`080?ooo`8000002@3oool2000000`0oooo00<000000?ooo`3oool01`3oool20000
00P0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0oooo0?ooo`0000001@3o
ool00`000000oooo0?ooo`080?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`800000MP3o
ool001/0oooo00<000000?ooo`3oool0203oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo0100oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00P0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`070?ooo`05
0000003oool0oooo0?ooo`0000000P3oool01@000000oooo0?ooo`3oool0000000<0oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool0M@3oool001/0oooo0`0000090?ooo`8000002P3oool300000140oooo0P00000:
0?ooo`<00000203oool3000000P0oooo100000090?ooo`<000001P3oool2000000@0oooo0P000003
0?ooo`800000103oool2000000X0oooo0`0000030?ooo`800000103oool3000007D0oooo003o0?oo
ob40oooo003o0?ooob40oooo002]0?ooo`<00000L03oool00:h0oooo00<000000?ooo`3oool0K`3o
ool001T0oooo1`00000B0?l000030000003o0000000005L0000000<0o`000000003o0000603o0007
0?ooo`030000003oool0oooo06l0oooo000a0?ooo`D0o`001P3oool00`000000oooo0?ooo`1;0?oo
o`@0o`007`3oool00`000000oooo0000001`0?ooo`00=P3oool20?l000@0oooo0P00001:0?ooo`80
o`008P3oool01@000000oooo0?ooo`3oool0000006l0oooo000g0?ooo`80o`000`3oool00`000000
oooo0?ooo`180?ooo`80o`008P3oool3000000030?ooo`000000000006l0oooo000i0?ooo`030?l0
003oool0oooo00800000A`3oool20?l009T0oooo000j0?ooo`030?l0003oool0000004P0oooo00<0
o`000?ooo`3oool0V03oool003X0oooo0P3o0002000004H0oooo00<0o`000?ooo`3oool0V@3oool0
03X0oooo0P3o00000`000000oooo0?ooo`150?ooo`030?l0003oool0oooo09T0oooo000Z0?ooo`80
0000103oool2000000@0oooo0P0000030?ooo`030?l000000000000004D0oooo00<0o`000?ooo`3o
ool0VP3oool002T0oooo00@000000?ooo`3oool00000203oool010000000oooo0?ooo`0000020?oo
o`030?l000000000oooo04D0oooo00<0o`000?ooo`3oool0VP3oool002T0oooo00@000000?ooo`3o
ool000002`3oool01P000000oooo0?ooo`3oool0o`00000004D0oooo00<0o`000?ooo`3oool0VP3o
ool002T0oooo00@000000?ooo`3oool000002@3oool2000000@0oooo00<000000?l0003oool0@`3o
ool00`3o0000oooo0?ooo`2K0?ooo`00:@3oool010000000oooo0?ooo`0000090?ooo`030000003o
ool0oooo00<0oooo00<000000?l0003oool0@`3oool00`3o0000oooo0?ooo`2K0?ooo`00:P3oool2
000000X0oooo0`0000030?ooo`030000003o0000oooo04<0oooo00<0o`000?ooo`3oool0V`3oool0
03`0oooo00<000000?l0003oool0@`3oool00`3o0000oooo0?ooo`2K0?ooo`00?03oool00`000000
o`000?l000120?ooo`80o`00W@3oool003`0oooo00<000000?ooo`3o0000@P3oool00`3o0000oooo
0?ooo`2L0?ooo`00?03oool2000000030?l0003oool0oooo0400oooo00<0o`000?ooo`3oool0W03o
ool003`0oooo00<000000?ooo`3o0000@P3oool00`3o0000oooo0?ooo`2L0?ooo`00=@3oool50000
0080oooo0P0000000`3o0000oooo0?ooo`100?ooo`030?l0003oool0oooo09`0oooo000g0?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3o0000@@3oool00`3o0000oooo0?ooo`2M0?ooo`00
=`3oool00`000000oooo0?ooo`020?ooo`80000000<0oooo0?l0003oool0?`3oool00`3o0000oooo
0?ooo`2M0?ooo`00=`3oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo0?l00400oooo
00<0o`000?ooo`3oool0W@3oool003L0oooo00<000000?ooo`3oool00P3oool2000000030?ooo`3o
0000oooo03l0oooo00<0o`000?ooo`3oool0W@3oool003H0oooo0P0000040?ooo`040000003oool0
oooo0?l00400oooo00<0o`000?ooo`3oool0W@3oool003`0oooo00@000000?ooo`3oool0o`00@03o
ool00`3o0000oooo0?ooo`2M0?ooo`00?03oool200000080oooo00<0o`000?ooo`3oool0?03oool0
0`3o0000oooo0?ooo`2N0?ooo`00?03oool01@000000oooo0?ooo`3oool0o`0003h0oooo00<0o`00
0?ooo`3oool0WP3oool003`0oooo0P0000020?ooo`030?l0003oool0oooo03`0oooo00<0o`000?oo
o`3oool0WP3oool003`0oooo00D000000?ooo`3oool0oooo0?l0000n0?ooo`030?l0003oool0oooo
09h0oooo000Y0?ooo`D000000P3oool2000000@0oooo0P0000040?ooo`8000000P3oool00`3o0000
oooo0?ooo`0l0?ooo`030?l0003oool0oooo09h0oooo000[0?ooo`030000003oool0oooo00L0oooo
00@000000?ooo`3oool000000`3oool01@000000oooo0?ooo`3oool0o`0003h0oooo00<0o`000?oo
o`3oool0WP3oool002/0oooo00<000000?ooo`3oool02P3oool010000000oooo0?ooo`3oool20000
0080oooo00<0o`000?ooo`3oool0?03oool00`3o0000oooo0?ooo`2N0?ooo`00:`3oool00`000000
oooo0?ooo`080?ooo`800000103oool01@000000oooo0?ooo`3oool0o`0000P0oooo00<0o`000?oo
o`3oool0:P3oool00`3o0000oooo0?ooo`060?ooo`030?l0003oool0oooo09h0oooo000[0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool00`3oool2000000<0oooo00<0o`000?ooo`3o
ool01@3oool00`3o0000oooo0?ooo`0Z0?ooo`030?l0003oool0oooo00D0oooo00<0o`000?ooo`3o
ool0W`3oool002X0oooo0P00000:0?ooo`<000000`3oool00`000000oooo0?ooo`020?ooo`030?l0
003oool0oooo00D0oooo0P3o00090?ooo`030?l0003oool0oooo01@0oooo00<0o`000?ooo`3oool0
1`3oool20?l000L0oooo00<0o`000?ooo`3oool0W`3oool003`0oooo00<000000?ooo`3oool00P3o
ool00`3o0000oooo0?ooo`040?ooo`030?l0003oool0o`0000D0oooo00D0o`000?ooo`3oool0oooo
0?l000060?ooo`030?l0003oool0oooo00H0oooo00<0o`000?ooo`3oool0103oool01@3o0000oooo
0?ooo`3oool0o`0000D0oooo0P3o00070?ooo`030?l0003oool0oooo09l0oooo000l0?ooo`800000
0`3oool00`3o0000oooo0?ooo`040?ooo`030?l0003oool0o`0000D0oooo00D0o`000?ooo`3oool0
oooo0?l000060?ooo`030?l0003oool0oooo00H0oooo00<0o`000?ooo`3oool0103oool01@3o0000
oooo0?ooo`3oool0o`0000@0oooo00@0o`000?ooo`3oool0o`001P3oool00`3o0000oooo0?ooo`2O
0?ooo`00?03oool00`000000oooo0?ooo`020?ooo`030?l0003oool0oooo00@0oooo00@0o`000?oo
o`3oool0o`00103oool01@3o0000oooo0?ooo`3oool0o`0000@0oooo00<0o`000?ooo`3o00000P3o
ool01@3o0000oooo0?ooo`3o0000oooo0080o`0000<0oooo0?l0003oool00`3oool01@3o0000oooo
0?ooo`3oool0o`0000@0oooo00@0o`000?ooo`3oool0o`001P3oool00`3o0000oooo0?ooo`2O0?oo
o`00?03oool2000000<0oooo00<0o`000?ooo`3oool0103oool0103o0000oooo0?ooo`3o00030?oo
o`80o`000`3oool20?l00080oooo0P3o00001P3oool0o`000?l0003oool0o`000?ooo`80o`0000@0
oooo0?l0003o0000oooo0P3o00020?ooo`80o`000P3oool00`3o0000oooo0?l000030?ooo`040?l0
003oool0oooo0?l000H0oooo00<0o`000?ooo`3oool0W`3oool003`0oooo00<000000?ooo`3oool0
0P3oool00`3o0000oooo0?ooo`040?ooo`040?l0003oool0oooo0?l000<0oooo00<0o`000?ooo`3o
00000P3oool20?l00080oooo0P3o00001P3oool0o`000?l0003oool0o`000?ooo`80o`0000@0oooo
0?l0003o0000oooo0P3o00020?ooo`80o`000P3oool00`3o0000oooo0?l000030?ooo`040?l0003o
ool0oooo0?l000H0oooo00<0o`000?ooo`3oool0W`3oool003D0oooo100000030?ooo`8000000`3o
ool00`3o0000oooo0?ooo`040?ooo`040?l0003oool0oooo0?l000<0oooo00L0o`000?ooo`3o0000
oooo0?l0003oool0o`000080oooo0P3o00000`3oool0o`000?l000020?l000030?ooo`3o0000oooo
00<0o`0000<0oooo0?l0003o00000P3oool01`3o0000oooo0?l0003oool0o`000?ooo`3o00000`3o
ool0103o0000oooo0?ooo`3o00060?ooo`030?l0003oool0oooo09l0oooo000e0?ooo`030000003o
ool0oooo00@0oooo00<000000?ooo`3oool00P3oool00`3o0000oooo0?ooo`040?ooo`040?l0003o
ool0oooo0?l00080oooo00P0o`000?ooo`3oool0o`000?ooo`3o0000oooo0?l00080oooo0P3o0000
0`3oool0o`000?l000020?l000030?ooo`3o0000oooo00<0o`0000<0oooo0?l0003o00000P3oool0
1@3o0000oooo0?l0003oool0o`000080oooo00@0o`000?ooo`3oool0o`000P3oool00`3o0000oooo
0?ooo`040?ooo`030?l0003oool0oooo04`0ooooBP0000090?ooo`00=P3oool00`000000oooo0?oo
o`030?ooo`8000000`3oool00`3o0000oooo0?ooo`040?ooo`040?l0003oool0oooo0?l00080oooo
00P0o`000?ooo`3oool0o`000?ooo`3o0000oooo0?l00080oooo0P3o00001@3oool0o`000?l0003o
0000oooo0080o`0000D0oooo0?l0003o0000o`000?ooo`020?l00080oooo00D0o`000?ooo`3o0000
oooo0?l000020?ooo`040?l0003oool0oooo0?l00080oooo00<0o`000?ooo`3oool00`3oool00`3o
0000oooo0?ooo`1=0?ooodX000002@3oool003L0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`030?ooo`030?l0003oool0oooo00<0oooo00@0o`000?ooo`3oool0o`000P3oool03@3o
0000oooo0?ooo`3o0000oooo0?l0003oool0o`000?ooo`3o0000oooo0?l0003oool00`3o0000103o
ool0o`000?l0003oool30?l0000:0?ooo`3o0000oooo0?l0003oool0o`000?ooo`3o0000oooo0?l0
0080oooo00@0o`000?ooo`3oool0o`000P3oool00`3o0000oooo0?ooo`030?ooo`030?l0003oool0
oooo04d0ooooBP0000090?ooo`00=@3oool010000000oooo0?ooo`0000030?ooo`800000103oool0
0`3o0000oooo0?ooo`020?ooo`050?l0003oool0oooo0?ooo`3o00000P3oool01`3o0000oooo0?oo
o`3o0000oooo0?l0003oool00P3o00020?ooo`80o`0000@0oooo0?l0003o0000oooo0P3o0000103o
ool0o`000?l0003oool20?l000030?ooo`3o0000o`000080oooo00<0o`000?ooo`3o00000P3oool0
103o0000oooo0?ooo`3o00030?ooo`030?l0003oool0oooo0080oooo00<0o`000?ooo`3oool0C@3o
oom:000000T0oooo000f0?ooo`800000103oool00`000000oooo0?ooo`030?ooo`030?l0003oool0
oooo0080oooo00D0o`000?ooo`3oool0oooo0?l000020?ooo`030?l0003oool0oooo00<0o`0000<0
oooo0?l0003o00000P3oool20?l000040?ooo`3o0000o`000?ooo`80o`0000@0oooo0?l0003o0000
oooo0P3o00000`3oool0o`000?l000020?ooo`<0o`000P3oool0103o0000oooo0?ooo`3o00030?oo
o`050?l0003oool0oooo0?ooo`3o0000C03ooom>000000T0oooo000l0?ooo`800000103oool00`3o
0000oooo0?ooo`020?ooo`070?l0003oool0oooo0?ooo`3o0000oooo0?l000030?ooo`<0o`0000<0
oooo0?l0003o00000P3oool20?l000050?ooo`3o0000o`000?ooo`3o00000P3oool20?l000030?oo
o`3o0000o`000080oooo00<0o`000?ooo`3oool00`3o00020?ooo`040?l0003oool0oooo0?l000<0
oooo00D0o`000?ooo`3oool0oooo0?l0001<0?ooo`030000003oool0oooo04H0oooo1@0000090?oo
o`00?03oool00`000000oooo0?ooo`030?ooo`030?l0003oool0oooo0080oooo00L0o`000?ooo`3o
ool0oooo0?l0003oool0o`0000<0oooo0P3o00020?ooo`80o`000`3oool01P3o0000oooo0?l0003o
0000oooo0?l00080oooo0P3o00000`3oool0o`000?ooo`020?ooo`040?l0003oool0oooo0?ooo`80
o`000P3oool00`3o0000oooo0?l000040?ooo`050?l0003oool0oooo0?ooo`3o0000C03oool00`00
0000oooo0?ooo`160?ooo`D000002@3oool003`0oooo00<000000?ooo`3oool00`3oool00`3o0000
oooo0?ooo`020?ooo`030?l0003oool0oooo0080oooo0P3o00030?ooo`030?l0003oool0oooo00H0
oooo00H0o`000?ooo`3o0000o`000?ooo`3o00020?ooo`040?l0003oool0oooo0?l000P0oooo00<0
o`000?ooo`3oool00`3o00040?ooo`050?l0003oool0oooo0?ooo`3o0000C03oool00`000000oooo
0?ooo`160?ooo`D000002@3oool003`0oooo0P0000040?ooo`030?l0003oool0oooo0080oooo00<0
o`000?ooo`3oool00P3oool20?l000`0oooo00@0o`000?ooo`3oool0o`00103oool0103o0000oooo
0?ooo`3o000;0?ooo`80o`001@3oool01@3o0000oooo0?ooo`3oool0o`0004`0oooo00<000000?oo
o`3oool0AP3oool5000000T0oooo000l0?ooo`030000003oool0oooo00@0oooo00D0o`000?ooo`3o
ool0oooo0?l000040?ooo`80o`00303oool00`3o0000oooo0?ooo`080?ooo`030?l0003oool0oooo
00T0oooo0P3o00050?ooo`050?l0003oool0oooo0?ooo`3o0000C03oool010000000oooo0?ooo`3o
oolE0?l00300oooo1@0000090?ooo`00:@3oool4000000<0oooo0P0000040?ooo`800000103oool2
000000D0oooo00D0o`000?ooo`3oool0oooo0?l000050?ooo`030?l0003oool0oooo0240oooo0P3o
00050?ooo`050?l0003oool0oooo0?ooo`3o0000C03oool010000000oooo0?ooo`3ooolE0?l00300
oooo1@0000090?ooo`00:@3oool00`000000oooo0?ooo`090?ooo`040000003oool0oooo000000<0
oooo00<000000?ooo`3oool0103oool01@3o0000oooo0?ooo`3oool0o`0000D0oooo00<0o`000?oo
o`3oool08P3oool00`3o0000oooo0?ooo`030?ooo`050?l0003oool0oooo0?ooo`3o0000C03oool0
10000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00:P3oool00`000000oooo0?ooo`0;
0?ooo`040000003oool0oooo0?ooo`8000001@3oool01@3o0000oooo0?ooo`3oool0o`000300oooo
00D0o`000?ooo`3oool0oooo0?l0001<0?ooo`040000003oool0oooo0?oooaD0o`00<03oool50000
00T0oooo000[0?ooo`030000003oool0oooo00P0oooo0P0000040?ooo`030000003oool0oooo00@0
oooo0P3o00000`3oool0o`000?ooo`0a0?ooo`030?l0003oool0o`0004d0oooo00@000000?ooo`3o
ool0oooo5@3o000`0?ooo`D000002@3oool002T0oooo00@000000?ooo`3oool000002@3oool00`00
0000oooo0?ooo`030?ooo`8000001@3oool20?l000030?ooo`3o0000oooo0340oooo00<0o`000?oo
o`3o0000C@3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00:P3oool20000
00X0oooo0`0000030?ooo`030000003oool0oooo00D0oooo0`3o000b0?ooo`030?l0003oool0o`00
04d0oooo00@000000?ooo`3oool0oooo5@3o000J0?ooo`800000203oool2000000X0oooo1@000009
0?ooo`00?03oool2000000H0oooo0P3o000d0?ooo`030?l0003oool0oooo04`0oooo00@000000?oo
o`3oool0oooo5@3o000J0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool5
000000T0oooo000l0?ooo`030000003oool0oooo00D0oooo0P3o000d0?ooo`030?l0003oool0oooo
04`0oooo00@000000?ooo`3oool0oooo5@3o00070?ooo`<000000`3oool3000000<0oooo0`000004
0?ooo`030000003oool0oooo0080oooo0`0000030?ooo`030000003oool0oooo00P0oooo1@000009
0?ooo`00?03oool2000000H0oooo00<0o`000?ooo`3oool0<`3oool00`3o0000oooo0?ooo`1<0?oo
o`040000003oool0oooo0?oooaD0o`00203oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0080oooo00<000000?ooo`3oool0203oool5000000T0oooo000l0?ooo`030000003oool0oooo
00D0oooo00<0o`000?ooo`3oool0<`3oool00`3o0000oooo0?ooo`1<0?ooo`040000003oool0oooo
0?oooaD0o`00203oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool0203oool5000000T0oooo000l0?ooo`030000003oool0oooo08X0oooo00@000000?oo
o`3oool0oooo5@3o00080?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool0
0`000000oooo000000040?ooo`030000003oool0oooo0080oooo00<000000?ooo`0000000`3oool0
0`000000oooo0?ooo`080?ooo`D000002@3oool003H0oooo0P0000040?ooo`800000R`3oool01000
0000oooo0?ooo`3ooolE0?l000P0oooo00<000000?ooo`3oool00`3oool01@000000oooo0?ooo`3o
ool0000000<0oooo00D000000?ooo`3oool0oooo000000030?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`080?ooo`D000002@3oool003D0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`2:0?ooo`040000003oool0oooo0?oooaD0o`001`3oool30000
00<0oooo0`0000001@3oool00000000000000000oooo008000000`3oool2000000050?ooo`000000
00000000003oool00P0000000`3oool000000000000:0?ooo`D000002@3oool003L0oooo00<00000
0?ooo`3oool00P3oool2000008/0oooo00@000000?ooo`3oool0oooo5@3o000`0?ooo`D000002@3o
ool003P0oooo00D000000?ooo`3oool0oooo0000002<0?ooo`040000003oool0oooo0?oooaD0o`00
<03oool5000000T0oooo000e0?ooo`040000003oool0oooo000000<0oooo0P00002;0?ooo`040000
003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000f0?ooo`800000103oool00`000000oooo
0?ooo`2:0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000l0?ooo`800000
R`3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00?03oool00`000000oooo
0?ooo`2:0?ooo`040000003oool0oooo0?oooaD0o`00<03oool5000000T0oooo000l0?ooo`800000
R`3oool010000000oooo0?ooo`3ooolE0?l00300oooo1@0000090?ooo`00?03oool00`000000oooo
0?ooo`2:0?ooo`040000003oool0oooo0?oooaD0o`00<03oool00`000000oooo0?ooo`0;0?ooo`00
?03oool00`000000oooo0?ooo`2:0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0
2`3oool002X0oooo0P0000040?ooo`800000103oool2000000@0oooo0P00002;0?ooo`030000003o
ool0oooo04H0oooo00<000000?ooo`3oool02`3oool002T0oooo00@000000?ooo`3oool00000203o
ool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool0
AP3oool00`000000oooo0?ooo`0;0?ooo`00:`3oool00`000000oooo0?ooo`0:0?ooo`040000003o
ool0oooo0?ooo`800000R`3ooom:000000d0oooo000/0?ooo`030000003oool0oooo00L0oooo0P00
00040?ooo`030000003oool0oooo0>40oooo000Y0?ooo`040000003oool0oooo000000T0oooo00<0
00000?ooo`3oool00`3oool200000>80oooo000Z0?ooo`8000002P3oool3000000<0oooo00<00000
0?ooo`3oool0h@3oool003`0oooo0P00003R0?ooo`00?03oool00`000000oooo0?ooo`3Q0?ooo`00
?03oool200000>80oooo000l0?ooo`030000003oool0oooo0>40oooo000l0?ooo`800000hP3oool0
03L0oooo0`0000020?ooo`030000003oool0oooo0>40oooo000h0?ooo`050000003oool0oooo0?oo
o`000000h`3oool003D0oooo1@0000020?ooo`800000hP3oool003D0oooo00@000000?ooo`3oool0
0000i`3oool003H0oooo00<000000?ooo`000000i`3oool003L0oooo0P00003W0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00?`3oool2000000P0oooo0P00003E0?ooo`00?`3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo0=<0oooo000/0?ooo`<000000`3oool3000000<0oooo0`00
00040?ooo`030000003oool0oooo0080oooo0`0000030?ooo`030000003oool0oooo0=<0oooo000]
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`3C
0?ooo`00;@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool0d`3oool002d0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0000000@0oooo00<000000?ooo`3oool00P3oool00`000000oooo000000030?ooo`03
0000003oool0oooo0=<0oooo000]0?ooo`030000003oool0oooo00<0oooo00D000000?ooo`3oool0
oooo000000030?ooo`050000003oool0oooo0?ooo`0000000`3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool0d`3oool002`0oooo0`0000030?ooo`<0000000D0oooo0000
0000000000000?ooo`02000000<0oooo0P0000001@3oool00000000000000000oooo0080000000<0
oooo000000000000e@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {119.625, 0}} -> {-1.08192, -0.648936, \
0.0108496, 0.0108496}, {{7.5, 191.875}, {116.75, 2.8125}} -> {-8.61473, \
-0.626336, 0.141929, 0.0459295}, {{201.063, 274.813}, {59.8125, 29.9375}} -> \
{-9.26038, -2.8256, 0.0455598, 0.0455598}}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1280}, {0, 951}},
WindowSize->{1272, 924},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 3491, 69, 1092, "Input"],
Cell[5221, 123, 243, 4, 43, "Message"],
Cell[5467, 129, 35, 1, 29, "Output"],

Cell[CellGroupData[{
Cell[5527, 134, 27253, 966, 129, 11982, 773, "GraphicsData", "PostScript", \
"Graphics"],
Cell[32783, 1102, 29893, 1029, 129, 12439, 809, "GraphicsData", "PostScript", \
"Graphics"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

