(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4902,        113]*)
(*NotebookOutlinePosition[      5548,        135]*)
(*  CellTagsIndexPosition[      5504,        131]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
D9FAGRAMPS
  
Diffraction on an amplitude grating at normal incidence.
Width of openings d, center to center distance of strips a, wavelength \
\[Lambda], distance from grating to screen X and coordinate on Screen Y
    
DD(A) is the diffraction factor
II(A) is the interference factor, normalized to 1. The numerator is plotted \
separately to
show where the main maxima are located (0/0).
P(A) is the product of Interference and diffraction factor.

All distances and wavelength in mm, number of lines N.
All parameters are globally defined above the graph.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(<< Graphics`MultipleListPlot`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(d\  = \ 
        0.001;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(a\  = \ 
        0.002;\), "\[IndentingNewLine]", \(n\  = \ 
        6;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[\(-0.5001\), 0.5, 
          0.0009];\), "\[IndentingNewLine]", \(DD[\[Theta]_] := \((Sin[\((Pi*\
\((d/\[Lambda])\)*Sin[\[Theta]])\)]/\((Pi*\((d/\[Lambda])\)*
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", \(DD\
\[Theta]\  = \ 
        DD[\[Theta]];\), "\[IndentingNewLine]", \(II[\[Theta]_] := \
\((Sin[\((Pi*\((a/\[Lambda])\)*Sin[\[Theta]]*n)\)]/\((n*
                  Sin[Pi*\((a/\[Lambda])\)*
                      Sin[\[Theta]]])\))\)^2;\), "\[IndentingNewLine]", \(II\
\[Theta]\  = \ II[\[Theta]];\), "\[IndentingNewLine]", \(y[\[Theta]_] := 
        Sin[\((Pi*\((a/\[Lambda])\)*Sin[\[Theta]]*
                n)\)]^2;\), "\[IndentingNewLine]", \(y\[Theta]\  = \ 
        y[\[Theta]];\), "\[IndentingNewLine]", \(P[\[Theta]_] := \ 
        DD[\[Theta]]*II[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(P\[Theta]\  = \ P[\[Theta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], II\[Theta]}], 
            Transpose[{\[Theta], y\[Theta]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-0.6\), 0.6}, {0, 1}}], {{{Hue[
                  1], "\<II\[Theta]\>"}, {Hue[0.5], "\<y\[Theta]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], II\[Theta]}], 
          Transpose[{\[Theta], DD\[Theta]}], 
          Transpose[{\[Theta], P\[Theta]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-0.6\), 0.6}, {0, 1}}], {{{Hue[
                1], "\<II\[Theta]\>"}, {Hue[0.5], "\<DD\[Theta]\>"}, {Hue[
                0.25], "\<P\[Theta]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{665, 498},
WindowMargins->{{35, Automatic}, {Automatic, -39}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3193, 61, 960, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

