(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7880,        165]*)
(*NotebookOutlinePosition[      8526,        187]*)
(*  CellTagsIndexPosition[      8482,        183]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
DA2FAGRSTEP2S
  
Diffraction on a step grating with width d, center to center distance of \
steps a,
height H, two wavelength \[Lambda]1 and \[Lambda]2 for 0th and first order, \
distance from grating to screen X and coordinate on screen Y. 
    
D(\[Theta]) is the diffraction factor, I(\[Theta]) is the interference \
factor, normalized to 1.
II(\[Theta]) is the interference factor of the gratings with respect to the \
two planes.
P(A) is the product of Interference and diffraction factors.
    
The intensity changes of the zeroth order and of the first order depend on \
the height H.
If H is a multiple of \[Lambda], all light is in the zeroth  order, if H is a \
multiple of \[Lambda]/2, all light is in the first order.
    
All distances and wavelength in mm, number of lines N. Normal incidence.
All parameters are globally defined above the graph.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(d\  = \ 
        0.001;\), "\[IndentingNewLine]", \(a\  = \ 
        0.002;\), "\[IndentingNewLine]", \(n\  = \ 
        6;\), "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n2\  = \ 
        0.5;\), "\[IndentingNewLine]", \(H\  = \ 
        0.00035;\), "\[IndentingNewLine]", \(\[Lambda]1\  = \ 
        0.0007;\), "\[IndentingNewLine]", \(\[Lambda]2\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(H1\  = \ 
        n1*\[Lambda]1;\), "\[IndentingNewLine]", \(H2\  = \ 
        n1*\[Lambda]2;\), "\[IndentingNewLine]", \(H3\  = \ 
        n2*\[Lambda]1;\), "\[IndentingNewLine]", 
    RowBox[{\(H4\  = \ n2*\[Lambda]2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[\(-0.7001\), 0.7, 
          0.0009];\), "\[IndentingNewLine]", \(D1[\[Theta]_] := \ \((Sin[
                Pi*\((d/\[Lambda]1)\)*Sin[\[Theta]]]/\((Pi*\((d/\[Lambda]1)\)*
                  
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", \(D2[\
\[Theta]_] := \ \((Sin[
                Pi*\((d/\[Lambda]2)\)*Sin[\[Theta]]]/\((Pi*\((d/\[Lambda]2)\)*
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", \(D3[\
\[Theta]_] := \ \((Sin[
                Pi*\((d/\[Lambda]1)\)*Sin[\[Theta]]]/\((Pi*\((d/\[Lambda]1)\)*
                  Sin[\[Theta]])\))\)^2;\), "\[IndentingNewLine]", 
    RowBox[{\(D4[\[Theta]_] := \ \((Sin[
                  Pi*\((d/\[Lambda]2)\)*
                    Sin[\[Theta]]]/\((Pi*\((d/\[Lambda]2)\)*
                    Sin[\[Theta]])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(I1[\[Theta]_] := \ \((Sin[
                  Pi*\((a/\[Lambda]1)\)*Sin[\[Theta]]*n]/\((n*
                    Sin[Pi*\((a/\[Lambda]1)\)*Sin[\[Theta]]])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(I2[\[Theta]_] := \ \((Sin[
                  Pi*\((a/\[Lambda]2)\)*Sin[\[Theta]]*n]/\((n*
                    Sin[Pi*\((a/\[Lambda]2)\)*Sin[\[Theta]]])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(I3[\[Theta]_] := \ \((Sin[
                  Pi*\((a/\[Lambda]1)\)*Sin[\[Theta]]*n]/\((n*
                    Sin[Pi*\((a/\[Lambda]1)\)*Sin[\[Theta]]])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(I4[\[Theta]_] := \ \((Sin[
                  Pi*\((a/\[Lambda]2)\)*Sin[\[Theta]]*n]/\((n*
                    Sin[Pi*\((a/\[Lambda]2)\)*Sin[\[Theta]]])\))\)^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(II1[\[Theta]_] := \ 
        Cos[\((Pi/\[Lambda]1)\)*\((d*Sin[\[Theta]] + 
                  H1)\)]^2;\), "\[IndentingNewLine]", \(II2[\[Theta]_] := \ 
        Cos[\((Pi/\[Lambda]2)\)*\((d*Sin[\[Theta]] + 
                  H2)\)]^2;\), "\[IndentingNewLine]", \(II3[\[Theta]_] := \ 
        Cos[\((Pi/\[Lambda]1)\)*\((d*Sin[\[Theta]] + 
                  H3)\)]^2;\), "\[IndentingNewLine]", 
    RowBox[{\(II4[\[Theta]_] := \ 
          Cos[\((Pi/\[Lambda]2)\)*\((d*Sin[\[Theta]] + H4)\)]^2;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(P1[\[Theta]_] := \ 
        D1[\[Theta]]*I1[\[Theta]]*
          II1[\[Theta]];\), "\[IndentingNewLine]", \(P2[\[Theta]_] := \ 
        D2[\[Theta]]*I2[\[Theta]]*
          II2[\[Theta]];\), "\[IndentingNewLine]", \(P3[\[Theta]_] := \ 
        D1[\[Theta]]*I1[\[Theta]]*II3[\[Theta]];\), "\[IndentingNewLine]", 
    RowBox[{\(P4[\[Theta]_] := \ D2[\[Theta]]*I2[\[Theta]]*II4[\[Theta]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], P1[\[Theta]]}], 
            Transpose[{\[Theta], P2[\[Theta]]}], 
            Transpose[{\[Theta], D1[\[Theta]]}], 
            Transpose[{\[Theta], D2[\[Theta]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-0.8\), 0.8}, {0, 1}}], {{{Hue[
                  1], "\<P1[\[Theta]]\>"}, {Hue[
                  0.5], "\<P2[\[Theta]]\>"}, {Hue[
                  0.25], "\<D1[\[Theta]]\>"}, {Hue[
                  0.1], "\<D2[\[Theta]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], P3[\[Theta]]}], 
          Transpose[{\[Theta], P4[\[Theta]]}], 
          Transpose[{\[Theta], D3[\[Theta]]}], 
          Transpose[{\[Theta], D4[\[Theta]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-0.8\), 0.8}, {0, 1}}], {{{Hue[
                1], "\<P3[\[Theta]]\>"}, {Hue[0.5], "\<P4[\[Theta]]\>"}, {Hue[
                0.25], "\<D3[\[Theta]]\>"}, {Hue[0.1], "\<D4[\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{645, 534},
WindowMargins->{{163, Automatic}, {Automatic, 24}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 6171, 113, 1626, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

