(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6836,        147]*)
(*NotebookOutlinePosition[      7481,        169]*)
(*  CellTagsIndexPosition[      7437,        165]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
C2COHEX
  
Intensity of an extended source of width s and interfernce diffraction on a \
double slit.
    
Slit openings d and separation a. Distance from source to slit Z, from slit \
to screen  X, coordinate on screen is Y, small angle approximation Y/X = \
\[Theta].\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(a = 
        1;\), "\[IndentingNewLine]", 
    RowBox[{\(d\  = \ 0.05;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        0.0005;\), "\[IndentingNewLine]", \(Z\  = \ 
        9000;\), "\[IndentingNewLine]", \(s1\  = \ 
        1;\), "\[IndentingNewLine]", \(s2\  = \ 
        1.5;\), "\[IndentingNewLine]", \(s3\  = \ 
        4.5;\), "\[IndentingNewLine]", 
    RowBox[{\(s4\  = \ 5;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[CurlyPhi]1\  = \ 
        s1/Z;\), "\[IndentingNewLine]", \(\[CurlyPhi]2\  = \ 
        s2/Z;\), "\[IndentingNewLine]", \(\[CurlyPhi]3\  = \ 
        s3/Z;\), "\[IndentingNewLine]", 
    RowBox[{\(\[CurlyPhi]4\  = \ s4/Z;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(k = 
        Range[0, 200, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]\_k = \ 0.01 - k*0.0001;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(I1\_k = 
        NIntegrate[
          Evaluate[\((Sin[
                      Pi*\((d/\[Lambda])\)*\((Sin[\[Theta]\_k] + 
                            Sin[\[CurlyPhi]])\)]^2/\((\((Pi*\((d/\[Lambda])\)*\
\((Sin[\[Theta]\_k] + Sin[\[CurlyPhi]])\))\)^2)\))\)*
              Cos[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]\_k] + 
                        Sin[\[CurlyPhi]])\)]^2], {\[CurlyPhi], 
            0, \[CurlyPhi]1}];\), "\[IndentingNewLine]", \(I2\_k = 
        NIntegrate[
          Evaluate[\((Sin[
                      Pi*\((d/\[Lambda])\)*\((Sin[\[Theta]\_k] + 
                            Sin[\[CurlyPhi]])\)]^2/\((\((Pi*\((d/\[Lambda])\)*\
\((Sin[\[Theta]\_k] + Sin[\[CurlyPhi]])\))\)^2)\))\)*
              Cos[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]\_k] + 
                        Sin[\[CurlyPhi]])\)]^2], {\[CurlyPhi], 
            0, \[CurlyPhi]2}];\), "\[IndentingNewLine]", \(I3\_k = 
        NIntegrate[
          Evaluate[\((Sin[
                      Pi*\((d/\[Lambda])\)*\((Sin[\[Theta]\_k] + 
                            Sin[\[CurlyPhi]])\)]^2/\((\((Pi*\((d/\[Lambda])\)*\
\((Sin[\[Theta]\_k] + Sin[\[CurlyPhi]])\))\)^2)\))\)*
              Cos[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]\_k] + 
                        Sin[\[CurlyPhi]])\)]^2], {\[CurlyPhi], 
            0, \[CurlyPhi]3}];\), "\[IndentingNewLine]", 
    RowBox[{\(I4\_k = 
          NIntegrate[
            Evaluate[\((Sin[
                        Pi*\((d/\[Lambda])\)*\((Sin[\[Theta]\_k] + 
                              Sin[\[CurlyPhi]])\)]^2/\((\((Pi*\((d/\[Lambda])\
\)*\((Sin[\[Theta]\_k] + Sin[\[CurlyPhi]])\))\)^2)\))\)*
                Cos[Pi*\((a/\[Lambda])\)*\((Sin[\[Theta]\_k] + 
                          Sin[\[CurlyPhi]])\)]^2], {\[CurlyPhi], 
              0, \[CurlyPhi]4}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta]\_k, I1\_k}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {\*"\"\<\!\(\[Theta]\_k\)\>\"", "\<\>"}, 
            PlotRange \[Rule] \ {{\(-0.01\), 0.01}, {0, 
                  3*10^\(-4\)}}], {{{Hue[1], \*"\"\<\!\(I1\_k\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta]\_k, I2\_k}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {\*"\"\<\!\(\[Theta]\_k\)\>\"", "\<\>"}, 
            PlotRange \[Rule] \ {{\(-0.01\), 0.01}, {0, 
                  3*10^\(-4\)}}], {{{Hue[1], \*"\"\<\!\(I2\_k\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta]\_k, I3\_k}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {\*"\"\<\!\(\[Theta]\_k\)\>\"", "\<\>"}, 
            PlotRange \[Rule] \ {{\(-0.01\), 0.01}, {0, 
                  3*10^\(-4\)}}], {{{Hue[1], \*"\"\<\!\(I3\_k\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta]\_k, I4\_k}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {\*"\"\<\!\(\[Theta]\_k\)\>\"", "\<\>"}, 
          PlotRange \[Rule] \ {{\(-0.01\), 0.01}, {0, 3*10^\(-4\)}}], {{{Hue[
                1], \*"\"\<\!\(I4\_k\)\>\""}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{472, 599},
WindowMargins->{{77, Automatic}, {Automatic, 21}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 5127, 95, 1510, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

