(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3990,         99]*)
(*NotebookOutlinePosition[      4635,        121]*)
(*  CellTagsIndexPosition[      4591,        117]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
C6SUPERS
Demonstration of the superposition of waves.
      
The medium wavelength is \[Lambda]m = 2
    
    
1. Summation over four waves\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(x\  = \ 
        Range[\(-200\), 200, 
          0.1];\), "\[IndentingNewLine]", \(\[Lambda]1\  = \ 
      1.85; \ \[Lambda]2\  = \ 1.95; \ \[Lambda]3\  = \ 
      2.05; \ \[Lambda]4\  = \ 
      2.15;\), "\[IndentingNewLine]", \(y11[x_] := \ 
        Cos[2*Pi*\((x/\[Lambda]1)\)];\), "\[IndentingNewLine]", \(y12[
          x_] := \ Cos[
          2*Pi*\((x/\[Lambda]2)\)];\), "\[IndentingNewLine]", \(y13[x_] := \ 
        Cos[2*Pi*\((x/\[Lambda]3)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(y14[x_] := \ Cos[2*Pi*\((x/\[Lambda]4)\)];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y1[x_] := 
        y11[x] + y12[x] + y13[x] + y14[x];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, y1[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-200\), 200}, {\(-5\), 5}}], {{{Hue[
                  1], "\<y1[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ Integration\ over\ the\ wavelength\ interval\ for\ the\ \
\(\(superposition\)\(.\)\)\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y41[x_] := \ 
        NIntegrate[
          Evaluate[
            Cos[2*Pi*\((x/\[Lambda]\[Lambda])\)]], {\[Lambda]\[Lambda], 1.85, 
            2.15}, AccuracyGoal \[Rule] \ 
            5];\), "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{x, y41[x]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-200\), 200}, {\(-0.5\), 0.5}}], {{{Hue[
                1], "\<y41[x]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{492, 597},
WindowMargins->{{62, Automatic}, {Automatic, 23}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2281, 47, 766, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

