(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6030,        131]*)
(*NotebookOutlinePosition[      6675,        153]*)
(*  CellTagsIndexPosition[      6631,        149]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
C8COHINTS
Demonstration of the INTENSITY of the superposition of two waves when \
integrating over a wavelength interval.

The medium wavelength is \[Lambda]m=2. A phase difference of \[Delta] in the \
x coordinate is studied for 0,1/2 and 1 medium wavelength.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(\[Lambda]m\  = \ 
        2;\), "\[IndentingNewLine]", \(a1\  = \ 0; \ a2\  = \ 0.5; \ 
    a3\  = \ 1;\), "\[IndentingNewLine]", \(\[Delta]1\  := \ \[Lambda]m*
          a1;\), "\[IndentingNewLine]", \(\[Delta]2\  := \ \[Lambda]m*
          a2;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Delta]3\  := \ \[Lambda]m*a3;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(x\  = \ Range[\(-200\), 200, 0.1];\), "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
1. Integration over the wavelength interval from 1.85 to 2.15 for the \
intensity superposition of two waves. There is no phase difference using \
\[Delta]1=\[Lambda]m*a1,where \[Lambda]m is the medium wavelength.\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", \(y41[x_] := \ 
        NIntegrate[
          Evaluate[
            Cos[2*Pi*\((\((x - \[Delta]1)\)/\[Lambda]\[Lambda])\)] + 
              Cos[2*Pi*\((x/\[Lambda]\[Lambda])\)], {\[Lambda]\[Lambda], 
              1.85, 2.15}, 
            AccuracyGoal \[Rule] \ 5]];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, y41[x]^2}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-200\), 200}, {0, 0.4}}], {{{Hue[
                  1], \*"\"\<y41[x\!\(\(]\^2\)\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
2. Integration over the wavelength interval from 1.85 to 2.15 for the \
intensity superposition of two waves. The Phase difference using \[Delta]2=\
\[Lambda]m*a2 is 1/2 \[Lambda]m.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(y51[x_] := \ 
          NIntegrate[
            Evaluate[
              Cos[2*Pi*\((\((x - \[Delta]2)\)/\[Lambda]\[Lambda])\)] + 
                Cos[2*Pi*\((x/\[Lambda]\[Lambda])\)], {\[Lambda]\[Lambda], 
                1.85, 2.15}, AccuracyGoal \[Rule] \ 5]];\), 
      "\[IndentingNewLine]", \( (*\ 
        We\ have\ to\ \ use\ an\ expanded\ scale\ to\ see\ the\ result\ *) \),
       "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{x, y51[x]^2}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-200\), 200}, {0, 0.01}}], {{{Hue[
                  1], \*"\"\<y51[x\!\(\(]\^2\)\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
3. Integration over the wavelength interval from 1.85 to 2.15 for the \
intensity superposition of two waves. The Phase difference using \[Delta]3=\
\[Lambda]m*a3 is 1 \[Lambda]m.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(y61[x_] := \ 
          NIntegrate[
            Evaluate[
              Cos[2*Pi*\((\((x - \[Delta]3)\)/\[Lambda]\[Lambda])\)] + 
                Cos[2*Pi*\((x/\[Lambda]\[Lambda])\)], {\[Lambda]\[Lambda], 
                1.85, 2.15}, AccuracyGoal \[Rule] \ 5]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{x, y61[x]^2}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-200\), 200}, {0, 0.4}}], {{{Hue[
                1], \*"\"\<y61[x\!\(\(]\^2\)\)\>\""}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{504, 599},
WindowMargins->{{Automatic, 117}, {Automatic, 6}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4321, 79, 1464, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

