(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8109,        176]*)
(*NotebookOutlinePosition[      8754,        198]*)
(*  CellTagsIndexPosition[      8710,        194]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
M2FRN2L
Amplitudes
    
Fresnel's formulas as function of angle of incidence for first medium 1 and \
second medium 2 and  n1<n2  
      
1. Reflection coefficients.
Absolute value and imaginary parts for p-case (parallel) and   s-case \
(perpendicular).\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", 
    RowBox[{\(n2\  = \ 1.5;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[0.1, 90, 0.1];\), "\[IndentingNewLine]", 
    RowBox[{\(rp[\[Theta]_] := \((\((n2/n1)\)*Cos[2*\((Pi/360)\)*\[Theta]] - 
                Sqrt[1 - \((\((n1/n2)\)*
                          Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\)/\((\((n2/
                      n1)\)*Cos[2*\((Pi/360)\)*\[Theta]] + 
                Sqrt[1 - \((\((n1/n2)\)*
                          Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(rs[\[Theta]_] := \((Cos[2*\((Pi/360)\)*\[Theta]] - \((n2/n1)\)*
                  Sqrt[1 - \((\((n1/n2)\)*
                            Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\)/\((Cos[
                  2*\((Pi/360)\)*\[Theta]] + \((n2/n1)\)*
                  Sqrt[1 - \((\((n1/n2)\)*
                            Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ p - case\ *) \)}], "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Abs[rp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 1}}], {{{Hue[
                  1], "\<Abs[rp[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Arg[rp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {\(-3\), 4}}], {{{Hue[
                  1], "\<Arg[rp[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ s - case\ *) \)}], "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Abs[rs[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 1}}], {{{Hue[
                  1], "\<Abs[rs[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Arg[rs[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {\(-3\), 4}}], {{{Hue[
                  1], "\<Arg[rs[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
2. Transmission coefficient.
Absolute value and imaginary part for p-case and s-case.\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", 
    RowBox[{\(tp[\[Theta]_] := \((2*
                Cos[2*\((Pi/360)\)*\[Theta]])\)/\((\((n2/n1)\)*
                  Cos[2*\((Pi/360)\)*\[Theta]] + 
                Sqrt[1 - \((\((n1/n2)\)*
                          Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ts[\[Theta]_] := \((2*
                Cos[2*\((Pi/360)\)*\[Theta]])\)/\((Cos[
                  2*\((Pi/360)\)*\[Theta]] + \((n2/n1)\)*
                  Sqrt[1 - \((\((n1/n2)\)*
                            Sin[2*\((Pi/360)\)*\[Theta]])\)^2])\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ p - case\ *) \)}], "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Abs[tp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 1}}], {{{Hue[
                  1], "\<Abs[tp[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Arg[tp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {\(-2\), 3}}], {{{Hue[
                  1], "\<Arg[tp[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ s - case\ *) \)}], "\[IndentingNewLine]", 
  
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Theta], Abs[ts[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 1}}], {{{Hue[
                  1], "\<Abs[ts[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta], Arg[ts[\[Theta]]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 100}, {\(-2\), 3}}], {{{Hue[
                1], "\<Arg[ts[\[Theta]]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{763, 569},
WindowMargins->{{-28, Automatic}, {Automatic, 4}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 6400, 124, 1440, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

