(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5304,        121]*)
(*NotebookOutlinePosition[      5949,        143]*)
(*  CellTagsIndexPosition[      5905,        139]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
M8POLIN

Linearly polarized light.
Graph of cos(2\[Pi]x/360) on x-axis and cos(2\[Pi]x/360+\[CapitalPhi]) on \
y-axis.
\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
          Graphics`Legend`;\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", 
    RowBox[{\(x\  = \ Range[1, 360, 3];\), 
      "\[IndentingNewLine]", \( (*\ 
        1. \ Before\ entering\ the\ birifringent\ plate\ X = 0\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[CapitalPhi]1\  = \ 
        0;\), "\[IndentingNewLine]", \(y1[x_] := 
        Cos[2*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(z1[x_] := 
          Cos[2*Pi*\((x/360)\) + \((\((2*Pi*\[CapitalPhi]1)\)/360)\)];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Each\ Seperate\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{x, y1[x]}], Transpose[{x, z1[x]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 400}, {\(-1\), 1}}], {{{Hue[
                  1], "\<y1[x]\>"}, {Hue[0.5], "\<z1[x]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        One\ plotted\ against\ the\ other\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y1[x], z1[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y1[x]\>", "\<z1[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<z1[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 2. \ At\ the\ plane\ X = L\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[CapitalPhi]2\  = \ 
        180;\), "\[IndentingNewLine]", \(y1[x_] := 
        Cos[2*Pi*\((x/360)\)];\), "\[IndentingNewLine]", 
    RowBox[{\(z1[x_] := 
          Cos[2*Pi*\((x/360)\) + \((\((2*Pi*\[CapitalPhi]2)\)/360)\)];\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Each\ Seperate\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{x, y1[x]}], Transpose[{x, z1[x]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<x\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 400}, {\(-1\), 1}}], {{{Hue[
                  1], "\<y1[x]\>"}, {Hue[0.5], "\<z1[x]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        One\ plotted\ against\ the\ other\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{y1[x], z1[x]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<y1[x]\>", "\<z1[x]\>"}, 
            PlotRange \[Rule] {{\(-1\), 1}, {\(-1\), 1}}], {{{Hue[
                  1], "\<z1[x]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \( (*\ 
      The\ resulting\ vibration\ is\ along\ the\ diagonal\ *) \)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 537},
WindowMargins->{{Automatic, 73}, {39, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3595, 69, 1180, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

