(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3349,         87]*)
(*NotebookOutlinePosition[      3992,        109]*)
(*  CellTagsIndexPosition[      3948,        105]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
MA3DIFINTRO
    
Fresnel's formulas as function of angle of incidence for n2<n1 Graph of \
arg(zr)-arg(zrr).
        
        
Complex zr for parallel and zrr for perpendicular case.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(n1\  = \ 
        1.9;\), "\[IndentingNewLine]", \(n2\  = \ 1;\), "\[IndentingNewLine]",
   
    RowBox[{\(\[Theta]\  = \ Range[0, 90, 1];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(rp[\[Theta]_] := \
\(\((n2\/n1)\)*Cos[2*Pi\/360*\[Theta]] - \@\(1 - \
\((\((n1\/n2)\)*Sin[2*Pi\/360*\[Theta]])\)\^2\)\)\/\(n2\/n1*Cos[2*Pi\/360*\
\[Theta]] + \@\(1 - \((\((n1\/n2)\)*Sin[2*Pi\/360*\[Theta]])\)\^2\)\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(rs[\[Theta]_] := \ \(Cos[2*\((Pi\/360)\)*\[Theta]] - \((n2\/n1)\
\)*\@\(1 - \
\((\((n1\/n2)\)*Sin[2*Pi\/360*\[Theta]])\)\^2\)\)\/\(Cos[2*\((Pi\/360)\)*\
\[Theta]] + \((n2\/n1)\)*\@\(1 - \
\((\((n1\/n2)\)*Sin[2*Pi\/360*\[Theta]])\)\^2\)\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[
          Transpose[{\[Theta], Arg[rp[\[Theta]]] - Arg[rs[\[Theta]]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 100}, {\(-3.5\), 3.5}}], {{{Hue[
                1], "\<Arg[rp[\[Theta]]]-Arg[rs[\[Theta]]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", \
}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{521, 599},
WindowMargins->{{7, Automatic}, {Automatic, 2}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1640, 35, 704, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

