(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5985,        127]*)
(*NotebookOutlinePosition[      6630,        149]*)
(*  CellTagsIndexPosition[      6586,        145]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
N7PLPPS
Wave traveling with total internal reflection through a planar waveguide.
Resonance condition for p-polarization.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(n1\  = \ 
        1.5;\), "\[IndentingNewLine]", \(n2\  = \ 
        1;\), "\[IndentingNewLine]", \(n3\  = \ 
        1;\), "\[IndentingNewLine]", \(d\  = \ 
        6;\), "\[IndentingNewLine]", \(\[Lambda]\  = \ 
        4.3;\), "\[IndentingNewLine]", 
    RowBox[{\(\[Lambda]\[Lambda]\  = \ \[Lambda]/n1;\), 
      " ", \( (*\ \[Lambda]\[Lambda]\  = \ 2.867\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[0.00001, 90, 1];\), "\[IndentingNewLine]", \(y[\[Theta]_] := \ 
        2*Pi*n1*\((d/\[Lambda])\)*
          Cos[2*Pi*\((\[Theta]/
                  360)\)];\), "\[IndentingNewLine]", \(zp1[\[Theta]_] := \ \(\
\((\@\(n1\^2*Sin[2*Pi*\((\[Theta]\/360)\)]\^2 - \
n2\^2\))\)*n1\)\/\(n2\^2*Cos[2*Pi*\[Theta]\/360]\);\), "\[IndentingNewLine]", \
\(zp3[\[Theta]_] := \ \(\((\@\(n1\^2*Sin[2*Pi*\((\[Theta]\/360)\)]\^2 - n3\^2\
\))\)*n1\)\/\(n3\^2*Cos[2*Pi*\[Theta]\/360]\);\), "\[IndentingNewLine]", \
\(yp1[\[Theta]_] := \(-ArcTan[zp1[\[Theta]]]\);\), "\[IndentingNewLine]", 
    RowBox[{\(yp3[\[Theta]_] := \(-ArcTan[zp3[\[Theta]]]\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Theta]c\  = \ 
        ASin[n2/n1];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]\[Theta]c\  = \ 
          360*\[Theta]c\/\(2*Pi\);\), \( (*\ \[Theta]\[Theta]c\  = \ 
          41.81\ *) \), "\[IndentingNewLine]", 
      RowBox[{
      "(*", "\[IndentingNewLine]", Cell[
        "For the graph we use yp for m=1,yyp for m=2,and yyyp for m=3"], 
        "\[IndentingNewLine]", 
        "*)"}]}], "\[IndentingNewLine]", \(yp[\[Theta]_] := \
\(-yp1[\[Theta]]\) - yp3[\[Theta]] + 
          Pi;\), "\[IndentingNewLine]", \(yyp[\[Theta]_] := \
\(-yp1[\[Theta]]\) - yp3[\[Theta]] + Pi*2;\), "\[IndentingNewLine]", 
    RowBox[{\(yyyp[\[Theta]_] := \(-yp1[\[Theta]]\) - yp3[\[Theta]] + Pi*3;\),
       "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], Re[y[\[Theta]]]}], 
            Transpose[{\[Theta], Re[yp[\[Theta]]]}], 
            Transpose[{\[Theta], Re[yyp[\[Theta]]]}], 
            Transpose[{\[Theta], Re[yyyp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 90}, {0, 15}}], {{{Hue[
                  1], "\<Re[y[\[Theta]]]\>"}, {Hue[
                  0.5], "\<Re[yp[\[Theta]]]\>"}, {Hue[
                  0.25], "\<Re[yyp[\[Theta]]]\>"}, {Hue[
                  0.1], "\<Re[yyyp[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
At the cross-over point of y with yp,yyp,or yyyp respectively,the resonance \
condition is fulfilled.The functions yp,yyp and yyyp are complex in the \
region from their horizontal appearance to zero.This is shown in the next \
graph where the argument is plotted.The complex region has to be disregarded \
for the determination of the cross-over point.\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], Arg[yp[\[Theta]]]}], 
          Transpose[{\[Theta], Arg[yyp[\[Theta]]]}], 
          Transpose[{\[Theta], Arg[yyyp[\[Theta]]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 100}, {0, 1}}], {{{Hue[
                1], "\<Arg[yp[\[Theta]]]\>"}, {Hue[
                0.5], "\<Arg[yyp[\[Theta]]]\>"}, {Hue[
                0.25], "\<Arg[yyyp[\[Theta]]]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 537},
WindowMargins->{{Automatic, 30}, {Automatic, 53}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 4276, 75, 1430, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

