(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4649,        110]*)
(*NotebookOutlinePosition[      5293,        132]*)
(*  CellTagsIndexPosition[      5249,        128]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
L10WRS
Radius of curvature and Beam waist.
    
1. Radius of curvature
Beam waist normalized to 1, that is we plot (w(z)=w0 SQR(1+(z/zR)^2) and set \
w0=.1 in cm, and zR=\[Pi](\[Omega]0)2/\[Lambda]-.01\[Pi]/\[Lambda], \[Lambda] \
in cm.
Radius of curvature R(z)=z+(zR)^2/z\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(<< Graphics`MultipleListPlot`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(zR\  = \ 
        100;\), "\[IndentingNewLine]", \(z\  = \ 
        Range[\(-100\), 100, 0.47];\), "\[IndentingNewLine]", \(R[z_] := 
        Abs[z + zR\^2\/z];\), "\[IndentingNewLine]", 
    RowBox[{\(Rm\  = \ 2  zR;\), "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
At z=1/2 of distance of mirrors,that is
for distance 200 at 100, the radius of curvature must be
equal to the distance of the mirrors.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{z, R[z]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<z\>", "\<\>"}, 
            PlotRange \[Rule] {{\(-100\), 100}, {0, 1000}}], {{{Hue[
                  1], "\<R[z]\>"}}, LegendPosition \[Rule] {1.1, \(-0\)}}];\),
       "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", 
        RowBox[{
        "2.", " ", "Beam", " ", "waist", "\[IndentingNewLine]", 
          "\[IndentingNewLine]", Cell["\<\
Plots of two branches of the beam waist and the Asymptote to w(z), that is \
y=z/zR
If z is in cm, we have set for w0=.1, \[Lambda]=3.14*.01/zR in cm (about 3 \
microns for zR=100)\
\>"]}], "\[IndentingNewLine]", 
        "*)"}]}], "\[IndentingNewLine]", \(y[
          z_] := \(z*0.1\)\/zR;\), "\[IndentingNewLine]", 
    RowBox[{\(w[z_] := 0.1*\@\(1 + \((z\/zR)\)\^2\);\), 
      "\[IndentingNewLine]", \( (*\ 
        and\ for\ the\ asymptote\ *) \)}], "\[IndentingNewLine]", \(yy[
          z_] := \(-y[z]\);\), "\[IndentingNewLine]", 
    RowBox[{\(ww[z_] := \(-0.1\)*\@\(1 + \((z\/zR)\)\^2\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{z, w[z]}], Transpose[{z, ww[z]}], 
          Transpose[{z, y[z]}], Transpose[{z, yy[z]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
          AxesLabel \[Rule] {"\<z\>", "\<\>"}, 
          PlotRange \[Rule] {{\(-100\), 100}, {\(-0.2\), 0.3}}], {{{Hue[
                1], "\<w[z]\>"}, {Hue[0.5], "\<ww[z]\>"}, {Hue[
                0.25], "\<y[z]\>"}, {Hue[0.1], "\<yy[z]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{500, 599},
WindowMargins->{{10, Automatic}, {Automatic, 7}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2940, 58, 1227, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

