(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1299989,      40557]*)
(*NotebookOutlinePosition[   1300637,      40579]*)
(*  CellTagsIndexPosition[   1300593,      40575]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \( (*\[IndentingNewLine]L11MOCONFCS\[IndentingNewLine]\[IndentingNewLine]\
Cartesian\ Coordinates\ for\ rectangular\ mirrors\ in\ confocal\ resonator . 
          Field\ distribution\ as\ contour\ plot . \[IndentingNewLine]\
\[IndentingNewLine]The\ mode\ numbers\ m\ and\ n\ are\ for\ Hermitian\ \
Polynomials . The\ constant\ in\ the\ exponential\ is\ simulated\ by\ X . 
          Small\ X\ correspond\ to\ small\ \(\("\<waist width\>"\)\(.\)\)\
\[IndentingNewLine]\[IndentingNewLine]*) \[IndentingNewLine]\(n\  = \ 
        40;\)\), "\[IndentingNewLine]", 
    \(\(X\  = \ 100;\)\), "\[IndentingNewLine]", 
    \(\(Y\  = \ 100;\)\), "\[IndentingNewLine]", 
    \(\(xi[i_] := \ \(-20\)\  + \ 1*i;\)\), "\[IndentingNewLine]", 
    \(\(\(yj[j_] := \ \(-20\)\  + \ 1*j;\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(H0x[x_] := \ 1;\)\), "\[IndentingNewLine]", 
    \(\(H0y[y_] := \ 1;\)\), "\[IndentingNewLine]", 
    \(\(H1x[x_] := \ x*\@\(2\/X\);\)\), "\[IndentingNewLine]", 
    \(\(H1y[y_] := \ y*\@\(2\/Y\);\)\), "\[IndentingNewLine]", 
    \(\(H2y[y_] := \ 
        4*\((\@\(2\/Y\)*y)\)\^2 - 2;\)\), "\[IndentingNewLine]", 
    \(\(\(H2x[x_] := 4*\((\@\(2\/X\)*x)\)\^2 - 2;\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(H00[x_, y_] := H0x[x]*H0y[y];\)\), "\[IndentingNewLine]", 
    \(\(H01[x_, y_] := H0x[x]*H1y[y];\)\), "\[IndentingNewLine]", 
    \(\(H02[x_, y_] := H0x[x]*H2y[y];\)\), "\[IndentingNewLine]", 
    \(\(H10[x_, y_] := H1x[x]*H0y[y];\)\), "\[IndentingNewLine]", 
    \(\(H11[x_, y_] := H1x[x]*H1y[y];\)\), "\[IndentingNewLine]", 
    \(\(H12[x_, y_] := H1x[x]*H2y[y];\)\), "\[IndentingNewLine]", 
    \(\(H20[x_, y_] := H2x[x]*H0y[y];\)\), "\[IndentingNewLine]", 
    \(\(H21[x_, y_] := H2x[x]*H1y[y];\)\), "\[IndentingNewLine]", 
    \(\(H22[x_, y_] := 
        H2x[x]*H2y[
            y];\)\[IndentingNewLine]\[IndentingNewLine]\), "\
\[IndentingNewLine]", 
    \(\(R[x_, y_] := x\^2 + y\^2;\)\), "\[IndentingNewLine]", 
    \(\(g[x_, 
          y_] := \ \((\[ExponentialE]\^\(\(-R[x, y]\)\/X\))\);\)\
\[IndentingNewLine]\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\(M00\  = \ 
        Table[\((g[xi[i], yj[j]]*H00[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\), "\[IndentingNewLine]", 
    \(\(M10\  = \ 
        Table[\((g[xi[i], yj[j]]*H10[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\), "\[IndentingNewLine]", 
    \(\(M01\  = \ 
        Table[\((g[xi[i], yj[j]]*H01[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\), "\[IndentingNewLine]", 
    \(\(M11\  = \ 
        Table[\((g[xi[i], yj[j]]*H11[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\), "\[IndentingNewLine]", 
    \(\(M20\  = \ 
        Table[\((g[xi[i], yj[j]]*H20[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\), "\[IndentingNewLine]", 
    \(\(M21\  = \ 
        Table[\((g[xi[i], yj[j]]*H21[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\), "\[IndentingNewLine]", 
    \(\(M02\  = \ 
        Table[\((g[xi[i], yj[j]]*H02[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\), "\[IndentingNewLine]", 
    \(\(M12\  = \ 
        Table[\((g[xi[i], yj[j]]*H12[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\), "\[IndentingNewLine]", 
    \(\(\(M22\  = \ 
        Table[\((g[xi[i], yj[j]]*H22[xi[i], yj[j]])\)\^2, {i, 0, n}, {j, 0, 
            n}];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M00, 
        PlotLabel -> "\<M00\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M10, 
        PlotLabel -> "\<M10\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M01, 
        PlotLabel -> "\<M01\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M11, 
        PlotLabel -> "\<M11\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M20, 
        PlotLabel -> "\<M20\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M21, 
        PlotLabel -> "\<M21\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M02, 
        PlotLabel -> "\<M02\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M12, 
        PlotLabel -> "\<M12\>"];\)\), "\[IndentingNewLine]", 
    \(\(ListContourPlot[M22, PlotLabel -> "\<M22\>"];\)\)}], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00480769 0.0240385 -0.00480769 0.0240385 [
[.23558 -0.0125 -6 -9 ]
[.23558 -0.0125 6 0 ]
[.47596 -0.0125 -6 -9 ]
[.47596 -0.0125 6 0 ]
[.71635 -0.0125 -6 -9 ]
[.71635 -0.0125 6 0 ]
[.95673 -0.0125 -6 -9 ]
[.95673 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .23558 -12 -4.5 ]
[-0.0125 .23558 0 4.5 ]
[-0.0125 .47596 -12 -4.5 ]
[-0.0125 .47596 0 4.5 ]
[-0.0125 .71635 -12 -4.5 ]
[-0.0125 .71635 0 4.5 ]
[-0.0125 .95673 -12 -4.5 ]
[-0.0125 .95673 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -11 0 ]
[.5 1.0125 11 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23558 0 m
.23558 .00625 L
s
[(10)] .23558 -0.0125 0 1 Mshowa
.47596 0 m
.47596 .00625 L
s
[(20)] .47596 -0.0125 0 1 Mshowa
.71635 0 m
.71635 .00625 L
s
[(30)] .71635 -0.0125 0 1 Mshowa
.95673 0 m
.95673 .00625 L
s
[(40)] .95673 -0.0125 0 1 Mshowa
.125 Mabswid
.04327 0 m
.04327 .00375 L
s
.09135 0 m
.09135 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.1875 0 m
.1875 .00375 L
s
.28365 0 m
.28365 .00375 L
s
.33173 0 m
.33173 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.42788 0 m
.42788 .00375 L
s
.52404 0 m
.52404 .00375 L
s
.57212 0 m
.57212 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.66827 0 m
.66827 .00375 L
s
.76442 0 m
.76442 .00375 L
s
.8125 0 m
.8125 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.90865 0 m
.90865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .23558 m
.00625 .23558 L
s
[(10)] -0.0125 .23558 1 0 Mshowa
0 .47596 m
.00625 .47596 L
s
[(20)] -0.0125 .47596 1 0 Mshowa
0 .71635 m
.00625 .71635 L
s
[(30)] -0.0125 .71635 1 0 Mshowa
0 .95673 m
.00625 .95673 L
s
[(40)] -0.0125 .95673 1 0 Mshowa
.125 Mabswid
0 .04327 m
.00375 .04327 L
s
0 .09135 m
.00375 .09135 L
s
0 .13942 m
.00375 .13942 L
s
0 .1875 m
.00375 .1875 L
s
0 .28365 m
.00375 .28365 L
s
0 .33173 m
.00375 .33173 L
s
0 .37981 m
.00375 .37981 L
s
0 .42788 m
.00375 .42788 L
s
0 .52404 m
.00375 .52404 L
s
0 .57212 m
.00375 .57212 L
s
0 .62019 m
.00375 .62019 L
s
0 .66827 m
.00375 .66827 L
s
0 .76442 m
.00375 .76442 L
s
0 .8125 m
.00375 .8125 L
s
0 .86058 m
.00375 .86058 L
s
0 .90865 m
.00375 .90865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.23558 .99375 m
.23558 1 L
s
.47596 .99375 m
.47596 1 L
s
.71635 .99375 m
.71635 1 L
s
.95673 .99375 m
.95673 1 L
s
.125 Mabswid
.04327 .99625 m
.04327 1 L
s
.09135 .99625 m
.09135 1 L
s
.13942 .99625 m
.13942 1 L
s
.1875 .99625 m
.1875 1 L
s
.28365 .99625 m
.28365 1 L
s
.33173 .99625 m
.33173 1 L
s
.37981 .99625 m
.37981 1 L
s
.42788 .99625 m
.42788 1 L
s
.52404 .99625 m
.52404 1 L
s
.57212 .99625 m
.57212 1 L
s
.62019 .99625 m
.62019 1 L
s
.66827 .99625 m
.66827 1 L
s
.76442 .99625 m
.76442 1 L
s
.8125 .99625 m
.8125 1 L
s
.86058 .99625 m
.86058 1 L
s
.90865 .99625 m
.90865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .23558 m
1 .23558 L
s
.99375 .47596 m
1 .47596 L
s
.99375 .71635 m
1 .71635 L
s
.99375 .95673 m
1 .95673 L
s
.125 Mabswid
.99625 .04327 m
1 .04327 L
s
.99625 .09135 m
1 .09135 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .1875 m
1 .1875 L
s
.99625 .28365 m
1 .28365 L
s
.99625 .33173 m
1 .33173 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .42788 m
1 .42788 L
s
.99625 .52404 m
1 .52404 L
s
.99625 .57212 m
1 .57212 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .66827 m
1 .66827 L
s
.99625 .76442 m
1 .76442 L
s
.99625 .8125 m
1 .8125 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .90865 m
1 .90865 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M00) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.5 Mabswid
.1 g
.42788 .18246 m
.45192 .17805 L
.47596 .17536 L
.5 .17446 L
.52404 .17536 L
.54808 .17805 L
.57212 .18246 L
.59269 .1875 L
.59615 .1886 L
.62019 .19732 L
.64423 .2079 L
.65173 .21154 L
.66827 .22107 L
.69056 .23558 L
.69231 .23686 L
.71635 .2563 L
.72005 .25962 L
.74038 .27995 L
.7437 .28365 L
.76314 .30769 L
.76442 .30944 L
.77893 .33173 L
.78846 .34827 L
.7921 .35577 L
.80268 .37981 L
.8114 .40385 L
.8125 .40731 L
.81754 .42788 L
.82195 .45192 L
.82464 .47596 L
.82554 .5 L
.82464 .52404 L
.82195 .54808 L
.81754 .57212 L
.8125 .59269 L
.8114 .59615 L
.80268 .62019 L
.7921 .64423 L
.78846 .65173 L
.77893 .66827 L
.76442 .69056 L
.76314 .69231 L
.7437 .71635 L
.74038 .72005 L
.72005 .74038 L
.71635 .7437 L
.69231 .76314 L
.69056 .76442 L
.66827 .77893 L
.65173 .78846 L
.64423 .7921 L
.62019 .80268 L
.59615 .8114 L
.59269 .8125 L
.57212 .81754 L
.54808 .82195 L
.52404 .82464 L
.5 .82554 L
.47596 .82464 L
.45192 .82195 L
.42788 .81754 L
.40731 .8125 L
.40385 .8114 L
.37981 .80268 L
.35577 .7921 L
.34827 .78846 L
.33173 .77893 L
.30944 .76442 L
.30769 .76314 L
.28365 .7437 L
.27995 .74038 L
.25962 .72005 L
.2563 .71635 L
.23686 .69231 L
.23558 .69056 L
.22107 .66827 L
.21154 .65173 L
.2079 .64423 L
.19732 .62019 L
.1886 .59615 L
.1875 .59269 L
.18246 .57212 L
.17805 .54808 L
.17536 .52404 L
.17446 .5 L
.17536 .47596 L
.17805 .45192 L
.18246 .42788 L
.1875 .40731 L
.1886 .40385 L
.19732 .37981 L
.2079 .35577 L
.21154 .34827 L
.22107 .33173 L
.23558 .30944 L
.23686 .30769 L
.2563 .28365 L
.25962 .27995 L
.27995 .25962 L
.28365 .2563 L
.30769 .23686 L
.30944 .23558 L
.33173 .22107 L
.34827 .21154 L
.35577 .2079 L
.37981 .19732 L
.40385 .1886 L
.40731 .1875 L
F
0 g
.42788 .18246 m
.45192 .17805 L
.47596 .17536 L
.5 .17446 L
.52404 .17536 L
.54808 .17805 L
.57212 .18246 L
.59269 .1875 L
.59615 .1886 L
.62019 .19732 L
.64423 .2079 L
.65173 .21154 L
.66827 .22107 L
.69056 .23558 L
.69231 .23686 L
.71635 .2563 L
.72005 .25962 L
.74038 .27995 L
.7437 .28365 L
.76314 .30769 L
.76442 .30944 L
.77893 .33173 L
.78846 .34827 L
.7921 .35577 L
.80268 .37981 L
.8114 .40385 L
.8125 .40731 L
.81754 .42788 L
.82195 .45192 L
.82464 .47596 L
.82554 .5 L
.82464 .52404 L
.82195 .54808 L
.81754 .57212 L
.8125 .59269 L
.8114 .59615 L
.80268 .62019 L
.7921 .64423 L
.78846 .65173 L
.77893 .66827 L
.76442 .69056 L
.76314 .69231 L
.7437 .71635 L
.74038 .72005 L
.72005 .74038 L
.71635 .7437 L
.69231 .76314 L
.69056 .76442 L
.66827 .77893 L
.65173 .78846 L
Mistroke
.64423 .7921 L
.62019 .80268 L
.59615 .8114 L
.59269 .8125 L
.57212 .81754 L
.54808 .82195 L
.52404 .82464 L
.5 .82554 L
.47596 .82464 L
.45192 .82195 L
.42788 .81754 L
.40731 .8125 L
.40385 .8114 L
.37981 .80268 L
.35577 .7921 L
.34827 .78846 L
.33173 .77893 L
.30944 .76442 L
.30769 .76314 L
.28365 .7437 L
.27995 .74038 L
.25962 .72005 L
.2563 .71635 L
.23686 .69231 L
.23558 .69056 L
.22107 .66827 L
.21154 .65173 L
.2079 .64423 L
.19732 .62019 L
.1886 .59615 L
.1875 .59269 L
.18246 .57212 L
.17805 .54808 L
.17536 .52404 L
.17446 .5 L
.17536 .47596 L
.17805 .45192 L
.18246 .42788 L
.1875 .40731 L
.1886 .40385 L
.19732 .37981 L
.2079 .35577 L
.21154 .34827 L
.22107 .33173 L
.23558 .30944 L
.23686 .30769 L
.2563 .28365 L
.25962 .27995 L
.27995 .25962 L
.28365 .2563 L
Mistroke
.30769 .23686 L
.30944 .23558 L
.33173 .22107 L
.34827 .21154 L
.35577 .2079 L
.37981 .19732 L
.40385 .1886 L
.40731 .1875 L
.42788 .18246 L
Mfstroke
.2 g
.40385 .23137 m
.42788 .22403 L
.45192 .21879 L
.47596 .21566 L
.5 .21462 L
.52404 .21566 L
.54808 .21879 L
.57212 .22403 L
.59615 .23137 L
.60761 .23558 L
.62019 .24118 L
.64423 .25379 L
.65395 .25962 L
.66827 .26951 L
.68621 .28365 L
.69231 .28908 L
.71092 .30769 L
.71635 .31379 L
.73049 .33173 L
.74038 .34605 L
.74621 .35577 L
.75882 .37981 L
.76442 .39239 L
.76863 .40385 L
.77597 .42788 L
.78121 .45192 L
.78434 .47596 L
.78538 .5 L
.78434 .52404 L
.78121 .54808 L
.77597 .57212 L
.76863 .59615 L
.76442 .60761 L
.75882 .62019 L
.74621 .64423 L
.74038 .65395 L
.73049 .66827 L
.71635 .68621 L
.71092 .69231 L
.69231 .71092 L
.68621 .71635 L
.66827 .73049 L
.65395 .74038 L
.64423 .74621 L
.62019 .75882 L
.60761 .76442 L
.59615 .76863 L
.57212 .77597 L
.54808 .78121 L
.52404 .78434 L
.5 .78538 L
.47596 .78434 L
.45192 .78121 L
.42788 .77597 L
.40385 .76863 L
.39239 .76442 L
.37981 .75882 L
.35577 .74621 L
.34605 .74038 L
.33173 .73049 L
.31379 .71635 L
.30769 .71092 L
.28908 .69231 L
.28365 .68621 L
.26951 .66827 L
.25962 .65395 L
.25379 .64423 L
.24118 .62019 L
.23558 .60761 L
.23137 .59615 L
.22403 .57212 L
.21879 .54808 L
.21566 .52404 L
.21462 .5 L
.21566 .47596 L
.21879 .45192 L
.22403 .42788 L
.23137 .40385 L
.23558 .39239 L
.24118 .37981 L
.25379 .35577 L
.25962 .34605 L
.26951 .33173 L
.28365 .31379 L
.28908 .30769 L
.30769 .28908 L
.31379 .28365 L
.33173 .26951 L
.34605 .25962 L
.35577 .25379 L
.37981 .24118 L
.39239 .23558 L
F
0 g
.40385 .23137 m
.42788 .22403 L
.45192 .21879 L
.47596 .21566 L
.5 .21462 L
.52404 .21566 L
.54808 .21879 L
.57212 .22403 L
.59615 .23137 L
.60761 .23558 L
.62019 .24118 L
.64423 .25379 L
.65395 .25962 L
.66827 .26951 L
.68621 .28365 L
.69231 .28908 L
.71092 .30769 L
.71635 .31379 L
.73049 .33173 L
.74038 .34605 L
.74621 .35577 L
.75882 .37981 L
.76442 .39239 L
.76863 .40385 L
.77597 .42788 L
.78121 .45192 L
.78434 .47596 L
.78538 .5 L
.78434 .52404 L
.78121 .54808 L
.77597 .57212 L
.76863 .59615 L
.76442 .60761 L
.75882 .62019 L
.74621 .64423 L
.74038 .65395 L
.73049 .66827 L
.71635 .68621 L
.71092 .69231 L
.69231 .71092 L
.68621 .71635 L
.66827 .73049 L
.65395 .74038 L
.64423 .74621 L
.62019 .75882 L
.60761 .76442 L
.59615 .76863 L
.57212 .77597 L
.54808 .78121 L
.52404 .78434 L
Mistroke
.5 .78538 L
.47596 .78434 L
.45192 .78121 L
.42788 .77597 L
.40385 .76863 L
.39239 .76442 L
.37981 .75882 L
.35577 .74621 L
.34605 .74038 L
.33173 .73049 L
.31379 .71635 L
.30769 .71092 L
.28908 .69231 L
.28365 .68621 L
.26951 .66827 L
.25962 .65395 L
.25379 .64423 L
.24118 .62019 L
.23558 .60761 L
.23137 .59615 L
.22403 .57212 L
.21879 .54808 L
.21566 .52404 L
.21462 .5 L
.21566 .47596 L
.21879 .45192 L
.22403 .42788 L
.23137 .40385 L
.23558 .39239 L
.24118 .37981 L
.25379 .35577 L
.25962 .34605 L
.26951 .33173 L
.28365 .31379 L
.28908 .30769 L
.30769 .28908 L
.31379 .28365 L
.33173 .26951 L
.34605 .25962 L
.35577 .25379 L
.37981 .24118 L
.39239 .23558 L
.40385 .23137 L
Mfstroke
.3 g
.40385 .25694 m
.42788 .24886 L
.45192 .24314 L
.47596 .23973 L
.5 .2386 L
.52404 .23973 L
.54808 .24314 L
.57212 .24886 L
.59615 .25694 L
.60287 .25962 L
.62019 .26791 L
.64423 .28195 L
.64681 .28365 L
.66827 .29996 L
.67709 .30769 L
.69231 .32291 L
.70004 .33173 L
.71635 .35319 L
.71805 .35577 L
.73209 .37981 L
.74038 .39713 L
.74306 .40385 L
.75114 .42788 L
.75686 .45192 L
.76027 .47596 L
.7614 .5 L
.76027 .52404 L
.75686 .54808 L
.75114 .57212 L
.74306 .59615 L
.74038 .60287 L
.73209 .62019 L
.71805 .64423 L
.71635 .64681 L
.70004 .66827 L
.69231 .67709 L
.67709 .69231 L
.66827 .70004 L
.64681 .71635 L
.64423 .71805 L
.62019 .73209 L
.60287 .74038 L
.59615 .74306 L
.57212 .75114 L
.54808 .75686 L
.52404 .76027 L
.5 .7614 L
.47596 .76027 L
.45192 .75686 L
.42788 .75114 L
.40385 .74306 L
.39713 .74038 L
.37981 .73209 L
.35577 .71805 L
.35319 .71635 L
.33173 .70004 L
.32291 .69231 L
.30769 .67709 L
.29996 .66827 L
.28365 .64681 L
.28195 .64423 L
.26791 .62019 L
.25962 .60287 L
.25694 .59615 L
.24886 .57212 L
.24314 .54808 L
.23973 .52404 L
.2386 .5 L
.23973 .47596 L
.24314 .45192 L
.24886 .42788 L
.25694 .40385 L
.25962 .39713 L
.26791 .37981 L
.28195 .35577 L
.28365 .35319 L
.29996 .33173 L
.30769 .32291 L
.32291 .30769 L
.33173 .29996 L
.35319 .28365 L
.35577 .28195 L
.37981 .26791 L
.39713 .25962 L
F
0 g
.40385 .25694 m
.42788 .24886 L
.45192 .24314 L
.47596 .23973 L
.5 .2386 L
.52404 .23973 L
.54808 .24314 L
.57212 .24886 L
.59615 .25694 L
.60287 .25962 L
.62019 .26791 L
.64423 .28195 L
.64681 .28365 L
.66827 .29996 L
.67709 .30769 L
.69231 .32291 L
.70004 .33173 L
.71635 .35319 L
.71805 .35577 L
.73209 .37981 L
.74038 .39713 L
.74306 .40385 L
.75114 .42788 L
.75686 .45192 L
.76027 .47596 L
.7614 .5 L
.76027 .52404 L
.75686 .54808 L
.75114 .57212 L
.74306 .59615 L
.74038 .60287 L
.73209 .62019 L
.71805 .64423 L
.71635 .64681 L
.70004 .66827 L
.69231 .67709 L
.67709 .69231 L
.66827 .70004 L
.64681 .71635 L
.64423 .71805 L
.62019 .73209 L
.60287 .74038 L
.59615 .74306 L
.57212 .75114 L
.54808 .75686 L
.52404 .76027 L
.5 .7614 L
.47596 .76027 L
.45192 .75686 L
.42788 .75114 L
Mistroke
.40385 .74306 L
.39713 .74038 L
.37981 .73209 L
.35577 .71805 L
.35319 .71635 L
.33173 .70004 L
.32291 .69231 L
.30769 .67709 L
.29996 .66827 L
.28365 .64681 L
.28195 .64423 L
.26791 .62019 L
.25962 .60287 L
.25694 .59615 L
.24886 .57212 L
.24314 .54808 L
.23973 .52404 L
.2386 .5 L
.23973 .47596 L
.24314 .45192 L
.24886 .42788 L
.25694 .40385 L
.25962 .39713 L
.26791 .37981 L
.28195 .35577 L
.28365 .35319 L
.29996 .33173 L
.30769 .32291 L
.32291 .30769 L
.33173 .29996 L
.35319 .28365 L
.35577 .28195 L
.37981 .26791 L
.39713 .25962 L
.40385 .25694 L
Mfstroke
.4 g
.47596 .25759 m
.5 .25643 L
.52404 .25759 L
.54391 .25962 L
.54808 .26116 L
.57212 .26736 L
.59615 .27623 L
.6121 .28365 L
.62019 .2881 L
.64423 .30367 L
.6496 .30769 L
.66827 .32383 L
.67617 .33173 L
.69231 .3504 L
.69633 .35577 L
.7119 .37981 L
.71635 .3879 L
.72377 .40385 L
.73264 .42788 L
.73884 .45192 L
.74038 .45609 L
.74241 .47596 L
.74357 .5 L
.74241 .52404 L
.74038 .54391 L
.73884 .54808 L
.73264 .57212 L
.72377 .59615 L
.71635 .6121 L
.7119 .62019 L
.69633 .64423 L
.69231 .6496 L
.67617 .66827 L
.66827 .67617 L
.6496 .69231 L
.64423 .69633 L
.62019 .7119 L
.6121 .71635 L
.59615 .72377 L
.57212 .73264 L
.54808 .73884 L
.54391 .74038 L
.52404 .74241 L
.5 .74357 L
.47596 .74241 L
.45609 .74038 L
.45192 .73884 L
.42788 .73264 L
.40385 .72377 L
.3879 .71635 L
.37981 .7119 L
.35577 .69633 L
.3504 .69231 L
.33173 .67617 L
.32383 .66827 L
.30769 .6496 L
.30367 .64423 L
.2881 .62019 L
.28365 .6121 L
.27623 .59615 L
.26736 .57212 L
.26116 .54808 L
.25962 .54391 L
.25759 .52404 L
.25643 .5 L
.25759 .47596 L
.25962 .45609 L
.26116 .45192 L
.26736 .42788 L
.27623 .40385 L
.28365 .3879 L
.2881 .37981 L
.30367 .35577 L
.30769 .3504 L
.32383 .33173 L
.33173 .32383 L
.3504 .30769 L
.35577 .30367 L
.37981 .2881 L
.3879 .28365 L
.40385 .27623 L
.42788 .26736 L
.45192 .26116 L
.45609 .25962 L
F
0 g
.47596 .25759 m
.5 .25643 L
.52404 .25759 L
.54391 .25962 L
.54808 .26116 L
.57212 .26736 L
.59615 .27623 L
.6121 .28365 L
.62019 .2881 L
.64423 .30367 L
.6496 .30769 L
.66827 .32383 L
.67617 .33173 L
.69231 .3504 L
.69633 .35577 L
.7119 .37981 L
.71635 .3879 L
.72377 .40385 L
.73264 .42788 L
.73884 .45192 L
.74038 .45609 L
.74241 .47596 L
.74357 .5 L
.74241 .52404 L
.74038 .54391 L
.73884 .54808 L
.73264 .57212 L
.72377 .59615 L
.71635 .6121 L
.7119 .62019 L
.69633 .64423 L
.69231 .6496 L
.67617 .66827 L
.66827 .67617 L
.6496 .69231 L
.64423 .69633 L
.62019 .7119 L
.6121 .71635 L
.59615 .72377 L
.57212 .73264 L
.54808 .73884 L
.54391 .74038 L
.52404 .74241 L
.5 .74357 L
.47596 .74241 L
.45609 .74038 L
.45192 .73884 L
.42788 .73264 L
.40385 .72377 L
.3879 .71635 L
Mistroke
.37981 .7119 L
.35577 .69633 L
.3504 .69231 L
.33173 .67617 L
.32383 .66827 L
.30769 .6496 L
.30367 .64423 L
.2881 .62019 L
.28365 .6121 L
.27623 .59615 L
.26736 .57212 L
.26116 .54808 L
.25962 .54391 L
.25759 .52404 L
.25643 .5 L
.25759 .47596 L
.25962 .45609 L
.26116 .45192 L
.26736 .42788 L
.27623 .40385 L
.28365 .3879 L
.2881 .37981 L
.30367 .35577 L
.30769 .3504 L
.32383 .33173 L
.33173 .32383 L
.3504 .30769 L
.35577 .30367 L
.37981 .2881 L
.3879 .28365 L
.40385 .27623 L
.42788 .26736 L
.45192 .26116 L
.45609 .25962 L
.47596 .25759 L
Mfstroke
.5 g
.42788 .2825 m
.45192 .27604 L
.47596 .27222 L
.5 .27095 L
.52404 .27222 L
.54808 .27604 L
.57212 .2825 L
.57564 .28365 L
.59615 .29205 L
.62019 .30491 L
.62464 .30769 L
.64423 .32196 L
.65555 .33173 L
.66827 .34445 L
.67804 .35577 L
.69231 .37536 L
.69509 .37981 L
.70795 .40385 L
.71635 .42436 L
.7175 .42788 L
.72396 .45192 L
.72778 .47596 L
.72905 .5 L
.72778 .52404 L
.72396 .54808 L
.7175 .57212 L
.71635 .57564 L
.70795 .59615 L
.69509 .62019 L
.69231 .62464 L
.67804 .64423 L
.66827 .65555 L
.65555 .66827 L
.64423 .67804 L
.62464 .69231 L
.62019 .69509 L
.59615 .70795 L
.57564 .71635 L
.57212 .7175 L
.54808 .72396 L
.52404 .72778 L
.5 .72905 L
.47596 .72778 L
.45192 .72396 L
.42788 .7175 L
.42436 .71635 L
.40385 .70795 L
.37981 .69509 L
.37536 .69231 L
.35577 .67804 L
.34445 .66827 L
.33173 .65555 L
.32196 .64423 L
.30769 .62464 L
.30491 .62019 L
.29205 .59615 L
.28365 .57564 L
.2825 .57212 L
.27604 .54808 L
.27222 .52404 L
.27095 .5 L
.27222 .47596 L
.27604 .45192 L
.2825 .42788 L
.28365 .42436 L
.29205 .40385 L
.30491 .37981 L
.30769 .37536 L
.32196 .35577 L
.33173 .34445 L
.34445 .33173 L
.35577 .32196 L
.37536 .30769 L
.37981 .30491 L
.40385 .29205 L
.42436 .28365 L
F
0 g
.42788 .2825 m
.45192 .27604 L
.47596 .27222 L
.5 .27095 L
.52404 .27222 L
.54808 .27604 L
.57212 .2825 L
.57564 .28365 L
.59615 .29205 L
.62019 .30491 L
.62464 .30769 L
.64423 .32196 L
.65555 .33173 L
.66827 .34445 L
.67804 .35577 L
.69231 .37536 L
.69509 .37981 L
.70795 .40385 L
.71635 .42436 L
.7175 .42788 L
.72396 .45192 L
.72778 .47596 L
.72905 .5 L
.72778 .52404 L
.72396 .54808 L
.7175 .57212 L
.71635 .57564 L
.70795 .59615 L
.69509 .62019 L
.69231 .62464 L
.67804 .64423 L
.66827 .65555 L
.65555 .66827 L
.64423 .67804 L
.62464 .69231 L
.62019 .69509 L
.59615 .70795 L
.57564 .71635 L
.57212 .7175 L
.54808 .72396 L
.52404 .72778 L
.5 .72905 L
.47596 .72778 L
.45192 .72396 L
.42788 .7175 L
.42436 .71635 L
.40385 .70795 L
.37981 .69509 L
.37536 .69231 L
.35577 .67804 L
Mistroke
.34445 .66827 L
.33173 .65555 L
.32196 .64423 L
.30769 .62464 L
.30491 .62019 L
.29205 .59615 L
.28365 .57564 L
.2825 .57212 L
.27604 .54808 L
.27222 .52404 L
.27095 .5 L
.27222 .47596 L
.27604 .45192 L
.2825 .42788 L
.28365 .42436 L
.29205 .40385 L
.30491 .37981 L
.30769 .37536 L
.32196 .35577 L
.33173 .34445 L
.34445 .33173 L
.35577 .32196 L
.37536 .30769 L
.37981 .30491 L
.40385 .29205 L
.42436 .28365 L
.42788 .2825 L
Mfstroke
.6 g
.5 .28325 m
.51328 .28365 L
.52404 .28459 L
.54808 .28869 L
.57212 .29567 L
.59615 .30576 L
.60003 .30769 L
.62019 .31967 L
.63664 .33173 L
.64423 .33821 L
.66179 .35577 L
.66827 .36336 L
.68033 .37981 L
.69231 .39997 L
.69424 .40385 L
.70433 .42788 L
.71131 .45192 L
.71541 .47596 L
.71635 .48672 L
.71675 .5 L
.71635 .51328 L
.71541 .52404 L
.71131 .54808 L
.70433 .57212 L
.69424 .59615 L
.69231 .60003 L
.68033 .62019 L
.66827 .63664 L
.66179 .64423 L
.64423 .66179 L
.63664 .66827 L
.62019 .68033 L
.60003 .69231 L
.59615 .69424 L
.57212 .70433 L
.54808 .71131 L
.52404 .71541 L
.51328 .71635 L
.5 .71675 L
.48672 .71635 L
.47596 .71541 L
.45192 .71131 L
.42788 .70433 L
.40385 .69424 L
.39997 .69231 L
.37981 .68033 L
.36336 .66827 L
.35577 .66179 L
.33821 .64423 L
.33173 .63664 L
.31967 .62019 L
.30769 .60003 L
.30576 .59615 L
.29567 .57212 L
.28869 .54808 L
.28459 .52404 L
.28365 .51328 L
.28325 .5 L
.28365 .48672 L
.28459 .47596 L
.28869 .45192 L
.29567 .42788 L
.30576 .40385 L
.30769 .39997 L
.31967 .37981 L
.33173 .36336 L
.33821 .35577 L
.35577 .33821 L
.36336 .33173 L
.37981 .31967 L
.39997 .30769 L
.40385 .30576 L
.42788 .29567 L
.45192 .28869 L
.47596 .28459 L
.48672 .28365 L
F
0 g
.5 .28325 m
.51328 .28365 L
.52404 .28459 L
.54808 .28869 L
.57212 .29567 L
.59615 .30576 L
.60003 .30769 L
.62019 .31967 L
.63664 .33173 L
.64423 .33821 L
.66179 .35577 L
.66827 .36336 L
.68033 .37981 L
.69231 .39997 L
.69424 .40385 L
.70433 .42788 L
.71131 .45192 L
.71541 .47596 L
.71635 .48672 L
.71675 .5 L
.71635 .51328 L
.71541 .52404 L
.71131 .54808 L
.70433 .57212 L
.69424 .59615 L
.69231 .60003 L
.68033 .62019 L
.66827 .63664 L
.66179 .64423 L
.64423 .66179 L
.63664 .66827 L
.62019 .68033 L
.60003 .69231 L
.59615 .69424 L
.57212 .70433 L
.54808 .71131 L
.52404 .71541 L
.51328 .71635 L
.5 .71675 L
.48672 .71635 L
.47596 .71541 L
.45192 .71131 L
.42788 .70433 L
.40385 .69424 L
.39997 .69231 L
.37981 .68033 L
.36336 .66827 L
.35577 .66179 L
.33821 .64423 L
.33173 .63664 L
Mistroke
.31967 .62019 L
.30769 .60003 L
.30576 .59615 L
.29567 .57212 L
.28869 .54808 L
.28459 .52404 L
.28365 .51328 L
.28325 .5 L
.28365 .48672 L
.28459 .47596 L
.28869 .45192 L
.29567 .42788 L
.30576 .40385 L
.30769 .39997 L
.31967 .37981 L
.33173 .36336 L
.33821 .35577 L
.35577 .33821 L
.36336 .33173 L
.37981 .31967 L
.39997 .30769 L
.40385 .30576 L
.42788 .29567 L
.45192 .28869 L
.47596 .28459 L
.48672 .28365 L
.5 .28325 L
Mfstroke
.7 g
.42788 .30728 m
.45192 .29999 L
.47596 .29572 L
.5 .2943 L
.52404 .29572 L
.54808 .29999 L
.57212 .30728 L
.57324 .30769 L
.59615 .31812 L
.61845 .33173 L
.62019 .33298 L
.64423 .35324 L
.64676 .35577 L
.66702 .37981 L
.66827 .38155 L
.68188 .40385 L
.69231 .42676 L
.69272 .42788 L
.70001 .45192 L
.70428 .47596 L
.7057 .5 L
.70428 .52404 L
.70001 .54808 L
.69272 .57212 L
.69231 .57324 L
.68188 .59615 L
.66827 .61845 L
.66702 .62019 L
.64676 .64423 L
.64423 .64676 L
.62019 .66702 L
.61845 .66827 L
.59615 .68188 L
.57324 .69231 L
.57212 .69272 L
.54808 .70001 L
.52404 .70428 L
.5 .7057 L
.47596 .70428 L
.45192 .70001 L
.42788 .69272 L
.42676 .69231 L
.40385 .68188 L
.38155 .66827 L
.37981 .66702 L
.35577 .64676 L
.35324 .64423 L
.33298 .62019 L
.33173 .61845 L
.31812 .59615 L
.30769 .57324 L
.30728 .57212 L
.29999 .54808 L
.29572 .52404 L
.2943 .5 L
.29572 .47596 L
.29999 .45192 L
.30728 .42788 L
.30769 .42676 L
.31812 .40385 L
.33173 .38155 L
.33298 .37981 L
.35324 .35577 L
.35577 .35324 L
.37981 .33298 L
.38155 .33173 L
.40385 .31812 L
.42676 .30769 L
F
0 g
.42788 .30728 m
.45192 .29999 L
.47596 .29572 L
.5 .2943 L
.52404 .29572 L
.54808 .29999 L
.57212 .30728 L
.57324 .30769 L
.59615 .31812 L
.61845 .33173 L
.62019 .33298 L
.64423 .35324 L
.64676 .35577 L
.66702 .37981 L
.66827 .38155 L
.68188 .40385 L
.69231 .42676 L
.69272 .42788 L
.70001 .45192 L
.70428 .47596 L
.7057 .5 L
.70428 .52404 L
.70001 .54808 L
.69272 .57212 L
.69231 .57324 L
.68188 .59615 L
.66827 .61845 L
.66702 .62019 L
.64676 .64423 L
.64423 .64676 L
.62019 .66702 L
.61845 .66827 L
.59615 .68188 L
.57324 .69231 L
.57212 .69272 L
.54808 .70001 L
.52404 .70428 L
.5 .7057 L
.47596 .70428 L
.45192 .70001 L
.42788 .69272 L
.42676 .69231 L
.40385 .68188 L
.38155 .66827 L
.37981 .66702 L
.35577 .64676 L
.35324 .64423 L
.33298 .62019 L
.33173 .61845 L
.31812 .59615 L
Mistroke
.30769 .57324 L
.30728 .57212 L
.29999 .54808 L
.29572 .52404 L
.2943 .5 L
.29572 .47596 L
.29999 .45192 L
.30728 .42788 L
.30769 .42676 L
.31812 .40385 L
.33173 .38155 L
.33298 .37981 L
.35324 .35577 L
.35577 .35324 L
.37981 .33298 L
.38155 .33173 L
.40385 .31812 L
.42676 .30769 L
.42788 .30728 L
Mfstroke
.8 g
.47596 .30569 m
.5 .30422 L
.52404 .30569 L
.54135 .30769 L
.54808 .31019 L
.57212 .31799 L
.59615 .32943 L
.60017 .33173 L
.62019 .34543 L
.63245 .35577 L
.64423 .36755 L
.65457 .37981 L
.66827 .39983 L
.67057 .40385 L
.68201 .42788 L
.68981 .45192 L
.69231 .45865 L
.69431 .47596 L
.69578 .5 L
.69431 .52404 L
.69231 .54135 L
.68981 .54808 L
.68201 .57212 L
.67057 .59615 L
.66827 .60017 L
.65457 .62019 L
.64423 .63245 L
.63245 .64423 L
.62019 .65457 L
.60017 .66827 L
.59615 .67057 L
.57212 .68201 L
.54808 .68981 L
.54135 .69231 L
.52404 .69431 L
.5 .69578 L
.47596 .69431 L
.45865 .69231 L
.45192 .68981 L
.42788 .68201 L
.40385 .67057 L
.39983 .66827 L
.37981 .65457 L
.36755 .64423 L
.35577 .63245 L
.34543 .62019 L
.33173 .60017 L
.32943 .59615 L
.31799 .57212 L
.31019 .54808 L
.30769 .54135 L
.30569 .52404 L
.30422 .5 L
.30569 .47596 L
.30769 .45865 L
.31019 .45192 L
.31799 .42788 L
.32943 .40385 L
.33173 .39983 L
.34543 .37981 L
.35577 .36755 L
.36755 .35577 L
.37981 .34543 L
.39983 .33173 L
.40385 .32943 L
.42788 .31799 L
.45192 .31019 L
.45865 .30769 L
F
0 g
.47596 .30569 m
.5 .30422 L
.52404 .30569 L
.54135 .30769 L
.54808 .31019 L
.57212 .31799 L
.59615 .32943 L
.60017 .33173 L
.62019 .34543 L
.63245 .35577 L
.64423 .36755 L
.65457 .37981 L
.66827 .39983 L
.67057 .40385 L
.68201 .42788 L
.68981 .45192 L
.69231 .45865 L
.69431 .47596 L
.69578 .5 L
.69431 .52404 L
.69231 .54135 L
.68981 .54808 L
.68201 .57212 L
.67057 .59615 L
.66827 .60017 L
.65457 .62019 L
.64423 .63245 L
.63245 .64423 L
.62019 .65457 L
.60017 .66827 L
.59615 .67057 L
.57212 .68201 L
.54808 .68981 L
.54135 .69231 L
.52404 .69431 L
.5 .69578 L
.47596 .69431 L
.45865 .69231 L
.45192 .68981 L
.42788 .68201 L
.40385 .67057 L
.39983 .66827 L
.37981 .65457 L
.36755 .64423 L
.35577 .63245 L
.34543 .62019 L
.33173 .60017 L
.32943 .59615 L
.31799 .57212 L
.31019 .54808 L
Mistroke
.30769 .54135 L
.30569 .52404 L
.30422 .5 L
.30569 .47596 L
.30769 .45865 L
.31019 .45192 L
.31799 .42788 L
.32943 .40385 L
.33173 .39983 L
.34543 .37981 L
.35577 .36755 L
.36755 .35577 L
.37981 .34543 L
.39983 .33173 L
.40385 .32943 L
.42788 .31799 L
.45192 .31019 L
.45865 .30769 L
.47596 .30569 L
Mfstroke
.9 g
.42788 .32788 m
.45192 .31971 L
.47596 .31496 L
.5 .3134 L
.52404 .31496 L
.54808 .31971 L
.57212 .32788 L
.58085 .33173 L
.59615 .34006 L
.61846 .35577 L
.62019 .35722 L
.64278 .37981 L
.64423 .38154 L
.65994 .40385 L
.66827 .41915 L
.67212 .42788 L
.68029 .45192 L
.68504 .47596 L
.6866 .5 L
.68504 .52404 L
.68029 .54808 L
.67212 .57212 L
.66827 .58085 L
.65994 .59615 L
.64423 .61846 L
.64278 .62019 L
.62019 .64278 L
.61846 .64423 L
.59615 .65994 L
.58085 .66827 L
.57212 .67212 L
.54808 .68029 L
.52404 .68504 L
.5 .6866 L
.47596 .68504 L
.45192 .68029 L
.42788 .67212 L
.41915 .66827 L
.40385 .65994 L
.38154 .64423 L
.37981 .64278 L
.35722 .62019 L
.35577 .61846 L
.34006 .59615 L
.33173 .58085 L
.32788 .57212 L
.31971 .54808 L
.31496 .52404 L
.3134 .5 L
.31496 .47596 L
.31971 .45192 L
.32788 .42788 L
.33173 .41915 L
.34006 .40385 L
.35577 .38154 L
.35722 .37981 L
.37981 .35722 L
.38154 .35577 L
.40385 .34006 L
.41915 .33173 L
F
0 g
.42788 .32788 m
.45192 .31971 L
.47596 .31496 L
.5 .3134 L
.52404 .31496 L
.54808 .31971 L
.57212 .32788 L
.58085 .33173 L
.59615 .34006 L
.61846 .35577 L
.62019 .35722 L
.64278 .37981 L
.64423 .38154 L
.65994 .40385 L
.66827 .41915 L
.67212 .42788 L
.68029 .45192 L
.68504 .47596 L
.6866 .5 L
.68504 .52404 L
.68029 .54808 L
.67212 .57212 L
.66827 .58085 L
.65994 .59615 L
.64423 .61846 L
.64278 .62019 L
.62019 .64278 L
.61846 .64423 L
.59615 .65994 L
.58085 .66827 L
.57212 .67212 L
.54808 .68029 L
.52404 .68504 L
.5 .6866 L
.47596 .68504 L
.45192 .68029 L
.42788 .67212 L
.41915 .66827 L
.40385 .65994 L
.38154 .64423 L
.37981 .64278 L
.35722 .62019 L
.35577 .61846 L
.34006 .59615 L
.33173 .58085 L
.32788 .57212 L
.31971 .54808 L
.31496 .52404 L
.3134 .5 L
.31496 .47596 L
Mistroke
.31971 .45192 L
.32788 .42788 L
.33173 .41915 L
.34006 .40385 L
.35577 .38154 L
.35722 .37981 L
.37981 .35722 L
.38154 .35577 L
.40385 .34006 L
.41915 .33173 L
.42788 .32788 L
Mfstroke
1 g
.45192 .32858 m
.47596 .32362 L
.5 .32199 L
.52404 .32362 L
.54808 .32858 L
.5587 .33173 L
.57212 .33722 L
.59615 .35016 L
.60444 .35577 L
.62019 .36864 L
.63136 .37981 L
.64423 .39556 L
.64984 .40385 L
.66278 .42788 L
.66827 .4413 L
.67142 .45192 L
.67638 .47596 L
.67801 .5 L
.67638 .52404 L
.67142 .54808 L
.66827 .5587 L
.66278 .57212 L
.64984 .59615 L
.64423 .60444 L
.63136 .62019 L
.62019 .63136 L
.60444 .64423 L
.59615 .64984 L
.57212 .66278 L
.5587 .66827 L
.54808 .67142 L
.52404 .67638 L
.5 .67801 L
.47596 .67638 L
.45192 .67142 L
.4413 .66827 L
.42788 .66278 L
.40385 .64984 L
.39556 .64423 L
.37981 .63136 L
.36864 .62019 L
.35577 .60444 L
.35016 .59615 L
.33722 .57212 L
.33173 .5587 L
.32858 .54808 L
.32362 .52404 L
.32199 .5 L
.32362 .47596 L
.32858 .45192 L
.33173 .4413 L
.33722 .42788 L
.35016 .40385 L
.35577 .39556 L
.36864 .37981 L
.37981 .36864 L
.39556 .35577 L
.40385 .35016 L
.42788 .33722 L
.4413 .33173 L
F
0 g
.45192 .32858 m
.47596 .32362 L
.5 .32199 L
.52404 .32362 L
.54808 .32858 L
.5587 .33173 L
.57212 .33722 L
.59615 .35016 L
.60444 .35577 L
.62019 .36864 L
.63136 .37981 L
.64423 .39556 L
.64984 .40385 L
.66278 .42788 L
.66827 .4413 L
.67142 .45192 L
.67638 .47596 L
.67801 .5 L
.67638 .52404 L
.67142 .54808 L
.66827 .5587 L
.66278 .57212 L
.64984 .59615 L
.64423 .60444 L
.63136 .62019 L
.62019 .63136 L
.60444 .64423 L
.59615 .64984 L
.57212 .66278 L
.5587 .66827 L
.54808 .67142 L
.52404 .67638 L
.5 .67801 L
.47596 .67638 L
.45192 .67142 L
.4413 .66827 L
.42788 .66278 L
.40385 .64984 L
.39556 .64423 L
.37981 .63136 L
.36864 .62019 L
.35577 .60444 L
.35016 .59615 L
.33722 .57212 L
.33173 .5587 L
.32858 .54808 L
.32362 .52404 L
.32199 .5 L
.32362 .47596 L
.32858 .45192 L
Mistroke
.33173 .4413 L
.33722 .42788 L
.35016 .40385 L
.35577 .39556 L
.36864 .37981 L
.37981 .36864 L
.39556 .35577 L
.40385 .35016 L
.42788 .33722 L
.4413 .33173 L
.45192 .32858 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00C@3oool500000080oooo0P00000e0?ooo`@000000`3oool2000003L0oooo0P0000040?oo
o`800000=`3oool300000080oooo0P00000?0?ooo`00C`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000003D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000g0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0303oool004l0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0b
0?ooo`D0000000D0oooo0000003oool0oooo0000000>0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0380
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000>0?ooo`00C`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0<P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000003D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000e0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003P3oool0
04h0oooo0P0000040?ooo`800000=P3oool2000000@0oooo0P00000g0?ooo`800000103oool20000
03L0oooo0P0000030?ooo`8000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`000005000000L0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooon@00
00040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oo
ooT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3o
oooi000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooog@000004P0I6AUc000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooom^000001h06ATIK@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`8000000`3ooomX000002X06ATII`0000040?ooo`8000001`3oool001D0
oooo00<000000?ooo`3oool00P3ooomU000003006ATII00000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080ooooH`00000d01TI6F8000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooel00000?00I6AUN000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomM000004006ATIG0000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooF`00001401TI
6EX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooeT0
0000B00I6AUH000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooomG000002<06ATI1P00000S01TI6EH000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooeD000006P0I6AT;000000H0<c<c2`00000J01TI6E@000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooe<000006@0I6AT3
000001`0<c<c0`00000I01TI6E8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?oooe400000600I6AT300000280<c<c0`00000H01TI6E0000001@3oool00`00
0000oooo0?ooo`050?ooo`001`3oool500000080oooo0P0000050?ooo`030000003oool0oooo0080
ooooC`00000G01TI6@<00000:00c<c<3000001L06ATICP0000050?ooo`030000003oool0oooo00D0
oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo0080ooooCP00000E01TI6@<00000;P0c<c<3000001D06ATIC@0000050?ooo`03
0000003oool0oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`020?ooo`<000000P3ooom<000001@06ATI0`00000d03<c<`<00000500I6AU;000000<0
oooo0`0000070?ooo`002@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3o
ool00P3oool00`000000oooo0?ooo`020?oood/000004P0I6AT3000001@0<c<c4P00000D03<c<`<0
00004P0I6AU:000000D0oooo00<000000?ooo`3oool01@3oool000T0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooom:00000140
6ATI0P00000A03<c<`H000004P1<C4`600000140<c<c0P00000B01TI6DP000001@3oool00`000000
oooo0?ooo`050?ooo`00203oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo
B@00000@01TI6@8000003P0c<c<5000001h0C4a<1@00000>03<c<`8000004@0I6AU7000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom7000001006ATI0P00
000=03<c<`<00000:01<C4`3000000d0<c<c0P00000@01TI6DH000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodH00000400I6AT00`000000<c<c03<c<`0;
03<c<`8000003P1<C4`B000000h0C4a<0P00000=03<c<`030000000I6AT06ATI00l06ATIA0000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooA@00000@01TI
6@030000000c<c<0<c<c00T0<c<c0`00000;04a<C0D000004P1VIVH5000000/0C4a<0`00000;03<c
<`030000000I6AT06ATI00l06ATI@`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080ooooA000000@01TI6@030000000c<c<0<c<c00P0<c<c0P00000;04a<C0<0
0000701VIVH3000000/0C4a<0P00000:03<c<`030000000I6AT06ATI00l06ATI@P0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo@`00000?01TI6@800000
2@0c<c<2000000X0C4a<0`00000R06IVIP<000002P1<C4`2000000T0<c<c0P00000@01TI6D400000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oood8000003`0I
6AT00`000000<c<c03<c<`0703<c<`8000002@1<C4`3000000/0IVIV4P00000;06IVIP<000002@1<
C4`2000000T0<c<c00<0000001TI6@0I6AT03P0I6AU0000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooom0000000l06ATI0P00000903<c<`030000001<C4`0
C4a<00L0C4a<0P00000906IVIPD000004P1oOgl5000000T0IVIV0`00000804a<C0030000000c<c<0
<c<c00L0<c<c0P00000?01TI6Cl000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooocl000003P0I6AT2000000T0<c<c0P00000804a<C0800000201VIVH30000
01`0Ogmo0`00000906IVIP8000001`1<C4`2000000T0<c<c0P00000>01TI6Ch000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool2000000<0oooo?P00000>01TI6@030000000c<c<0<c<c00P0
<c<c00<0000004a<C01<C4`01@1<C4`3000000H0IVIV1000000807moOa800000201oOgl4000000L0
IVIV0P00000704a<C08000002@0c<c<00`0000006ATI01TI6@0<01TI6Cd00000103oool2000000L0
oooo000E0?ooo`030000003oool0oooo0080oooo?@00000>01TI6@030000000c<c<0<c<c00L0<c<c
0P00000604a<C08000001`1VIVH2000000L0Ogmo1@00000B09VIV@D000001`1oOgl2000000L0IVIV
0P00000704a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT03@0I6ATl000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oooll000000l06ATI00<0
000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00404a<C08000001`1VIVH2000000H0Ogmo0`00
000L09VIV@<000001P1oOgl2000000L0IVIV0P00000604a<C08000001`0c<c<00`0000006ATI01TI
6@0=01TI6C/000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?oooc/000003`0I6AT00`000000<c<c03<c<`0503<c<`8000001P1<C4`00`000000IVIV06IVIP05
06IVIP8000001P1oOgl2000000P0VIVI4P00000809VIV@8000001P1oOgl2000000L0IVIV00<00000
04a<C01<C4`01@1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00`06ATI>`000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo>`00000=01TI
6@8000001`0c<c<00`000000C4a<04a<C00404a<C08000001P1VIVH2000000H0Ogmo0P00000509VI
V@D000004P2c/k<5000000D0VIVI0P00000607moO`8000001P1VIVH2000000H0C4a<00<0000003<c
<`0c<c<01@0c<c<2000000d06ATI>P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo>P00000=01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<
C4`0101<C4`00`000000IVIV06IVIP0406IVIP8000001P1oOgl2000000@0VIVI0`00000L0;>c/`<0
0000102IVIT2000000H0Ogmo0P00000606IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c
<c<01P0c<c<00`0000006ATI01TI6@0;01TI6CT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooocT000003@0I6AT00`000000<c<c03<c<`0603<c<`030000
001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00`1VIVH2000000D0Ogmo0`00000409VIV@800000
1P2c/k<F000000H0/k>c0`00000309VIV@<000001@1oOgl2000000D0IVIV00<0000004a<C01<C4`0
101<C4`00`000000<c<c03<c<`0603<c<`030000000I6AT06ATI00/06ATI>00000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo>@00000<01TI6@030000000c
<c<0<c<c00H0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP0306IVIP030000001o
Ogl0Ogmo00<0Ogmo0P00000509VIV@8000001@2c/k<3000001H0c<c<0`0000060;>c/`800000102I
VIT2000000D0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00404a<C0030000000c
<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATh000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolh000000d06ATI00<0000003<c<`0c<c<01@0c<c<0
0`000000C4a<04a<C00404a<C0030000001VIVH0IVIV0080IVIV0P00000507moO`030000002IVIT0
VIVI00<0VIVI0P0000040;>c/`<000001P3<c<`@000000H0c<c<0`0000050;>c/`800000102IVIT0
0`000000Ogmo07moO`0307moO`800000101VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0
<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATg000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolh000000`06ATI00<0000003<c<`0c<c<01@0c<c<00`00
0000C4a<04a<C00404a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00`1oOgl20000
00@0VIVI0P0000040;>c/`8000001P3<c<`300000100i^KV0`0000060<c<c08000001@2c/k<00`00
0000VIVI09VIV@0209VIV@8000001@1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<
00@0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0901TI6CL000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocL00000300I6AT00`000000
<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000
Ogmo07moO`0307moO`030000002IVIT0VIVI0080VIVI0P0000040;>c/`8000001@3<c<`3000000P0
i^KV1P0000080>KViP<000001@3<c<`2000000@0/k>c0P00000409VIV@030000001oOgl0Ogmo00<0
Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00D0
<c<c00<0000001TI6@0I6AT02P0I6ATf000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooolf000000d06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<
04a<C00404a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00`1oOgl00`000000VIVI
09VIV@0209VIV@030000002c/k<0/k>c0080/k>c0P0000040<c<c0<000001@3Vi^H6000000H0oooo
1P0000050>KViP<00000103<c<`2000000@0/k>c00<0000009VIV@2IVIT00P2IVIT00`000000Ogmo
07moO`0307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c
03<c<`0503<c<`030000000I6AT06ATI00X06ATI=@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo=P00000<01TI6@030000000c<c<0<c<c00D0<c<c00<0
000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo0P00
000309VIV@8000000`2c/k<2000000@0c<c<0P0000030>KViPD000004P3oool5000000<0i^KV0P00
00040<c<c08000000`2c/k<2000000<0VIVI0P00000407moO`030000001VIVH0IVIV0080IVIV00<0
000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI=@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooole000000`06ATI00<00000
03<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<00000
07moO`1oOgl00P1oOgl010000000VIVI09VIV@2IVIT2000000@0/k>c00<000000<c<c03<c<`00P3<
c<`200000080i^KV0`00000L0?ooo`<000000P3Vi^H2000000@0c<c<00<000000;>c/`2c/k<00P2c
/k<2000000<0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP030000001<
C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0:01TI6C@00000103o
ool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo=000000<01TI6@030000000c<c<0
<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP040000001oOgl0
Ogmo07moO`8000000`2IVIT00`000000/k>c0;>c/`020;>c/`8000000`3<c<`200000080i^KV0P00
000R0?ooo`8000000P3Vi^H2000000<0c<c<0P0000040;>c/`040000002IVIT0VIVI09VIV@800000
0`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0
1@0c<c<00`0000006ATI01TI6@0901TI6C@000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooc@000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<
C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000@0VIVI
00@000000;>c/`2c/k<0/k>c0P0000030<c<c08000000P3Vi^H2000002H0oooo0P0000020>KViP80
00000`3<c<`2000000<0/k>c00<0000009VIV@2IVIT00P2IVIT01@000000Ogmo07moO`1oOgl00000
00@0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI
00T06ATI<`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo<`00000;01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT200000080/k>c0P0000030<c<
c08000000P3Vi^H2000002X0oooo0P0000020>KViP8000000`3<c<`200000080/k>c0P00000309VI
V@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0
<c<c00D0<c<c00<0000001TI6@0I6AT0200I6ATc000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolc000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`00
0000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl01000
0000VIVI09VIV@0000030;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H00P00000^
0?ooo`8000000P3Vi^H00`000000c<c<0<c<c0020<c<c0050000002c/k<0/k>c0;>c/`0000000P2I
VIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<
C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<P0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<P00000;01TI6@030000000c<c<0
<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0
Ogmo0080Ogmo00@0000009VIV@2IVIT000000`2c/k<010000000c<c<0<c<c03<c<`200000080i^KV
00<000000?ooo`3oool0<03oool2000000030>KViP000000000000<0c<c<00D000000;>c/`2c/k<0
/k>c0000000209VIV@030000001oOgl0Ogmo0080Ogmo00D0000006IVIP1VIVH0IVIV0000000604a<
C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATb000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolb000000/06ATI00<0000003<c<`0c
<c<0100c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP000000101oOgl01@00
0000VIVI09VIV@2IVIT000000080/k>c00<000000<c<c03<c<`00P0000030>KViP030000003oool0
oooo03<0oooo00<000000>KViP3Vi^H00P0000020<c<c0050000002c/k<0/k>c0;>c/`0000000P2I
VIT00`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c
03<c<`0403<c<`030000000I6AT06ATI00T06ATI<@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo<@00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0
000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00D0000009VIV@2IVIT0
VIVI000000020;>c/`040000003<c<`0c<c<000000<0i^KV0P00000g0?ooo`050000003Vi^H0i^KV
0>KViP0000000P3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00<0000007moO`1oOgl00P1o
Ogl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI
01TI6@0801TI6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooc4000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00D0
000006IVIP1VIVH0IVIV0000000307moO`050000002IVIT0VIVI09VIV@0000000P2c/k<010000000
c<c<0<c<c00000020>KViP800000>P3oool200000080i^KV00@000000<c<c03<c<`000000`2c/k<0
10000000VIVI09VIV@00000307moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c
03<c<`0403<c<`030000000I6AT06ATI00T06ATI<00000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo<000000;01TI6@030000000c<c<0<c<c00@0<c<c00<0
000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VIV@2IVIT0
VIVI000000020;>c/`040000003<c<`0c<c<00000080i^KV00<000000?ooo`3oool0?03oool01000
0000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c000000<0VIVI00D0000007moO`1oOgl0Ogmo
0000000306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI
01TI6@0801TI6C0000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooc0000002`0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00<0C4a<00<0
000006IVIP1VIVH00P1VIVH010000000Ogmo07moO`00000309VIV@040000002c/k<0/k>c000000<0
c<c<00<000000>KViP000000@03oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c
00000080VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<00<0C4a<00<0
000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6Bl000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobl000002`0I6AT00`000000<c<c03<c<`04
03<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`040000002I
VIT0VIVI000000<0/k>c00@000000<c<c03<c<`000000P3Vi^H00`000000oooo0?ooo`0o0?ooo`04
0000003Vi^H0i^KV00000080c<c<00@000000;>c/`2c/k<000000P2IVIT01@000000Ogmo07moO`1o
Ogl0000000<0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I
6AT06ATI00P06ATI;`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3oool_
000000/06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0
IVIV06IVIP0000000`1oOgl010000000VIVI09VIV@0000030;>c/`040000003<c<`0c<c<00000080
i^KV00<000000?ooo`3oool0@@3oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c
00000080VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0C4a<00<0C4a<00<0
000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6Bh00000103oool2000000L0oooo000E
0?ooo`030000003oool0oooo0080oooo;`00000:01TI6@030000000c<c<0<c<c00@0<c<c00<00000
04a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VIV@2IVIT0VIVI
000000020;>c/`040000003<c<`0c<c<00000080i^KV00<000000?ooo`3oool0@`3oool00`000000
i^KV000000030<c<c0030000002c/k<0000000<0VIVI00@0000007moO`1oOgl00000101VIVH00`00
0000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6AT^0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool^000000/0
6ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0IVIV06IV
IP0000000`1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<00000080i^KV00<0
00000?ooo`3oool0A03oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080
VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6Bd000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooobh000002P0I6AT00`000000<c<c03<c<`0403<c<`03
0000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`040000002IVIT0VIVI
000000<0/k>c00<000000<c<c00000000P3Vi^H00`000000oooo0?ooo`160?ooo`040000003Vi^H0
i^KV00000080c<c<00@000000;>c/`2c/k<000000P2IVIT010000000Ogmo07moO`00000406IVIP03
0000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6Bd0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobh00000
2P0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0
IVIV0000000307moO`040000002IVIT0VIVI00000080/k>c00H000000<c<c03<c<`000000>KViP00
001:0?ooo`030000003Vi^H000000080c<c<00@000000;>c/`2c/k<000000P2IVIT01@000000Ogmo
07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`03
0000000I6AT06ATI00P06ATI;@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo;@00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`0
0P1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00@0000009VIV@2IVIT000000P2c/k<01P00
0000c<c<0<c<c0000000i^KV000004/0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c
0;>c/`00000209VIV@040000001oOgl0Ogmo000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI;00000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo;@00000:01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@0000009VI
V@2IVIT000000P2c/k<010000000c<c<0<c<c00000020>KViP030000003oool0oooo04X0oooo00@0
00000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c/`00000209VIV@040000001oOgl0Ogmo0000
00@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI
00P06ATI;00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo;@00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`01@000000
IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<00`000000c<c<00000002
0>KViP030000003oool0oooo04`0oooo00<000000>KViP0000000P3<c<`010000000/k>c0;>c/`00
000209VIV@040000001oOgl0Ogmo000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c
03<c<`0303<c<`030000000I6AT06ATI00P06ATI;00000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo;@00000901TI6@030000000c<c<0<c<c00@0<c<c00<0
000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT0
00000P2c/k<010000000c<c<0<c<c00000020>KViP030000003oool0oooo04`0oooo00@000000>KV
iP3Vi^H000000P3<c<`010000000/k>c0;>c/`00000209VIV@040000001oOgl0Ogmo000000@0IVIV
00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI
;00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;000
000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IV
IP1VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<00`000000c<c<000000020>KViP03
0000003oool0oooo04h0oooo00<000000>KViP0000000P3<c<`010000000/k>c0;>c/`00000209VI
V@040000001oOgl0Ogmo000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`03
03<c<`030000000I6AT06ATI00P06ATI:`0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo;000000:01TI6@030000000c<c<0<c<c00@0<c<c00D0000004a<
C01<C4`0C4a<0000000406IVIP040000001oOgl0Ogmo00000080VIVI00<000000;>c/`0000000P3<
c<`010000000i^KV0>KViP00001@0?ooo`040000003Vi^H0i^KV00000080c<c<00<000000;>c/`00
00000P2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0303<c<`030000000I6AT06ATI00P06ATI:`0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo;000000:01TI6@030000000c<c<0<c<c00@0
<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP070000001oOgl0Ogmo07moO`000000VIVI0000
00020;>c/`060000003<c<`0c<c<0000003Vi^H00000DP3oool00`000000i^KV000000020<c<c006
0000002c/k<0/k>c0000002IVIT000000`1oOgl01@000000IVIV06IVIP1VIVH0000000@0C4a<00<0
000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6B/000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob/000002P0I6AT00`000000<c<c03<c<`04
03<c<`050000001<C4`0C4a<04a<C0000000101VIVH010000000Ogmo07moO`00000209VIV@030000
002c/k<000000080c<c<00@000000>KViP3Vi^H00000DP3oool010000000i^KV0>KViP0000020<c<
c0030000002c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0
C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6BX000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo:`00000:01TI6@030000000c<c<0<c<c
00@0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP050000001oOgl0Ogmo07moO`0000000P2I
VIT00`000000/k>c000000020<c<c0030000003Vi^H0000005@0oooo00<000000>KViP0000000P3<
c<`00`000000/k>c0000000209VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<
04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6ATZ000000@0oooo
0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooob/000002P0I6AT00`000000<c<c03<c
<`0403<c<`050000001<C4`0C4a<04a<C00000000`1VIVH01@000000Ogmo07moO`1oOgl000000080
VIVI00<000000;>c/`0000000P3<c<`00`000000i^KV0000001D0?ooo`030000003Vi^H000000080
c<c<00<000000;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<
C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00P06ATI:P0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo:`00000:01TI6@03
0000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH00000
0080Ogmo00H0000009VIV@2IVIT000000;>c/`0000020<c<c0030000003Vi^H0000005H0oooo00<0
00000>KViP0000000P3<c<`00`000000/k>c0000000209VIV@050000001oOgl0Ogmo07moO`000000
0P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0
200I6ATZ000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolZ000000X06ATI00<0000003<c<`0c<c<0100c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV
00D0000007moO`1oOgl0Ogmo0000000209VIV@030000002c/k<000000080c<c<00<000000>KViP00
0000EP3oool00`000000i^KV000000020<c<c0030000002c/k<000000080VIVI00D0000007moO`1o
Ogl0Ogmo0000000206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`00
00006ATI01TI6@0801TI6BX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooobX000002P0I6AT00`000000<c<c03<c<`0403<c<`050000001<C4`0C4a<04a<
C00000000`1VIVH01@000000Ogmo07moO`1oOgl000000080VIVI00<000000;>c/`0000000P3<c<`0
0`000000i^KV0000001F0?ooo`030000003Vi^H000000080c<c<00<000000;>c/`0000000P2IVIT0
1@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c
<`0303<c<`030000000I6AT06ATI00P06ATI:@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo:P00000:01TI6@030000000c<c<0<c<c00<0<c<c00<00000
04a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00H0000009VIV@2IVIT00000
0;>c/`0000020<c<c0030000003Vi^H0000005P0oooo00<000000>KViP0000000P3<c<`00`000000
/k>c0000000209VIV@050000001oOgl0Ogmo07moO`0000000P1VIVH00`000000C4a<04a<C00204a<
C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6ATY000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolZ000000X06ATI00<0000003<c<`0c
<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl01P00
0000VIVI09VIV@000000/k>c00000080c<c<00<000000>KViP000000F03oool00`000000i^KV0000
00020<c<c0030000002c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000206IVIP030000
001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6BT00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobX000002P0I
6AT00`000000<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C0000000101VIVH010000000Ogmo
07moO`00000209VIV@030000002c/k<000000080c<c<00<000000>KViP000000F03oool00`000000
i^KV000000020<c<c0030000002c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000306IV
IP050000001<C4`0C4a<04a<C00000001@0c<c<00`0000006ATI01TI6@0801TI6BT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobX000002P0I6AT00`00
0000<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C0000000101VIVH010000000Ogmo07moO`00
000209VIV@030000002c/k<000000080c<c<00<000000>KViP000000F03oool00`000000i^KV0000
00020<c<c0030000002c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP050000
001<C4`0C4a<04a<C00000001@0c<c<00`0000006ATI01TI6@0801TI6BT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobT000002P0I6AT00`000000<c<c
03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`04
0000002IVIT0VIVI00000080/k>c00D000000<c<c0000000i^KV0000001I0?ooo`030000003Vi^H0
00000080c<c<00<000000;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00D0
000004a<C01<C4`0C4a<0000000503<c<`030000000I6AT06ATI00P06ATI:@0000050?ooo`030000
003oool0oooo00D0oooo00070?ooo`@000000`3oool2000000D0oooo00<000000?ooo`3oool00P3o
oolY000000X06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001V
IVH0IVIV06IVIP0000000P1oOgl01P000000VIVI09VIV@000000/k>c00000080c<c<00<000000>KV
iP000000FP3oool01@000000i^KV0000003<c<`000000080/k>c00@0000009VIV@2IVIT000000`1o
Ogl010000000IVIV06IVIP00000404a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0
200I6ATX000000D0oooo00<000000?ooo`3oool01@3oool000L0oooo00<000000?ooo`3oool00`3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo:@00000:01TI6@030000
000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080
Ogmo00H0000009VIV@2IVIT000000;>c/`0000020<c<c0030000003Vi^H0000005X0oooo00<00000
0>KViP0000000P3<c<`00`000000/k>c0000000209VIV@050000001oOgl0Ogmo07moO`0000000P1V
IVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I
6ATX000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo00<000000?ooo`3oool00P3oool0
10000000oooo0?ooo`0000040?ooo`<000000P3ooolY000000X06ATI00<0000003<c<`0c<c<00`0c
<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl01P000000VIVI
09VIV@000000/k>c00000080c<c<00<000000>KViP000000FP3oool00`000000i^KV000000020<c<
c0030000002c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000206IVIP030000001<C4`0
C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6BP000000`3oool3
000000L0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo:@00000:01TI6@030000000c<c<0<c<c00<0<c<c00<00000
04a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00H0000009VIV@2IVIT00000
0;>c/`0000020<c<c0030000003Vi^H0000005X0oooo00<000000>KViP0000000P3<c<`00`000000
/k>c0000000209VIV@050000001oOgl0Ogmo07moO`0000000P1VIVH00`000000C4a<04a<C00204a<
C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6ATX000000D0oooo00<000000?oo
o`3oool01@3oool000L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000004
0?ooo`030000003oool0oooo0080oooo:@00000:01TI6@030000000c<c<0<c<c00<0<c<c00<00000
04a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00H0000009VIV@2IVIT00000
0;>c/`0000020<c<c0030000003Vi^H0000005X0oooo00<000000>KViP0000000P3<c<`00`000000
/k>c0000000309VIV@040000001oOgl0Ogmo00000080IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0303<c<`030000000I6AT06ATI00P06ATI:00000050?ooo`030000003oool0oooo
00D0oooo00080?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool00P3ooolY000000X0
6ATI00<0000003<c<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00L0000007mo
O`1oOgl0Ogmo0000002IVIT000000080/k>c00D000000<c<c0000000i^KV0000001K0?ooo`030000
003Vi^H000000080c<c<00<000000;>c/`0000000`2IVIT010000000Ogmo07moO`00000206IVIP03
0000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6BP0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobT00000
2P0I6AT00`000000<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH01`000000
Ogmo07moO`1oOgl0000009VIV@0000000P2c/k<01@000000c<c<0000003Vi^H0000005`0oooo00D0
00000>KViP000000c<c<000000020;>c/`040000002IVIT0VIVI00000080Ogmo00D0000006IVIP1V
IVH0IVIV0000000304a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6ATX0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolY000000X0
6ATI00<0000003<c<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@0000007mo
O`1oOgl000000P2IVIT020000000/k>c0;>c/`000000c<c<0000003Vi^H00000G03oool01@000000
i^KV0000003<c<`000000080/k>c00@0000009VIV@2IVIT000000P1oOgl01@000000IVIV06IVIP1V
IVH0000000<0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6BP000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobT000002P0I6AT0
0`000000<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07mo
O`00000209VIV@080000002c/k<0/k>c0000003<c<`000000>KViP00001L0?ooo`050000003Vi^H0
00000<c<c00000000P2c/k<010000000VIVI09VIV@00000207moO`050000001VIVH0IVIV06IVIP00
00000`1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00P06ATI:00000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo:@00000:01TI6@030000
000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo0000
0080VIVI00P000000;>c/`2c/k<000000<c<c0000000i^KV000005`0oooo00D000000>KViP000000
c<c<000000020;>c/`040000002IVIT0VIVI00000080Ogmo00D0000006IVIP1VIVH0IVIV00000003
04a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6ATX000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolY000000X06ATI00<0000003<c
<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@0000007moO`1oOgl000000P2I
VIT020000000/k>c0;>c/`000000c<c<0000003Vi^H00000G03oool01@000000i^KV0000003<c<`0
00000080/k>c00@0000009VIV@2IVIT000000P1oOgl01@000000IVIV06IVIP1VIVH0000000<0C4a<
00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6BP000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobT000002P0I6AT00`000000<c<c03<c
<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH01`000000Ogmo07moO`1oOgl0000009VI
V@0000000P2c/k<01@000000c<c<0000003Vi^H0000005/0oooo00<000000>KViP0000000P3<c<`0
0`000000/k>c0000000309VIV@040000001oOgl0Ogmo00000080IVIV00<0000004a<C01<C4`00P1<
C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00P06ATI:00000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo:@00000:01TI6@030000000c<c<0
<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00H0
000009VIV@2IVIT000000;>c/`0000020<c<c0030000003Vi^H0000005X0oooo00<000000>KViP00
00000P3<c<`00`000000/k>c0000000309VIV@040000001oOgl0Ogmo00000080IVIV00<0000004a<
C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00P06ATI:00000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo:@00000:01TI6@03
0000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH00000
0080Ogmo00H0000009VIV@2IVIT000000;>c/`0000020<c<c0030000003Vi^H0000005X0oooo00<0
00000>KViP0000000P3<c<`00`000000/k>c0000000209VIV@050000001oOgl0Ogmo07moO`000000
0P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0
200I6ATX000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?ooobT000002P0I
6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV
0000000207moO`060000002IVIT0VIVI0000002c/k<000000P3<c<`00`000000i^KV0000001J0?oo
o`030000003Vi^H000000080c<c<00<000000;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl0
00000080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT0
6ATI00P06ATI:00000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooolY0000
00X06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV
06IVIP0000000P1oOgl01P000000VIVI09VIV@000000/k>c00000080c<c<00<000000>KViP000000
FP3oool00`000000i^KV000000020<c<c0030000002c/k<000000080VIVI00D0000007moO`1oOgl0
Ogmo0000000206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`000000
6ATI01TI6@0801TI6BP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooobT000002P0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<
00D0000006IVIP1VIVH0IVIV0000000207moO`060000002IVIT0VIVI0000002c/k<000000P3<c<`0
0`000000i^KV0000001J0?ooo`030000003Vi^H000000080c<c<00<000000;>c/`0000000P2IVIT0
1@000000Ogmo07moO`1oOgl000000080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c
<`0303<c<`030000000I6AT06ATI00P06ATI:00000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo:@00000:01TI6@030000000c<c<0<c<c00<0<c<c00<00000
04a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT00000
0P2c/k<01@000000c<c<0000003Vi^H0000005X0oooo00D000000>KViP000000c<c<000000020;>c
/`040000002IVIT0VIVI000000<0Ogmo00@0000006IVIP1VIVH00000101<C4`00`000000<c<c03<c
<`0303<c<`030000000I6AT06ATI00P06ATI:00000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo:P00000:01TI6@030000000c<c<0<c<c00<0<c<c00D00000
04a<C01<C4`0C4a<0000000406IVIP040000001oOgl0Ogmo00000080VIVI00<000000;>c/`000000
0P3<c<`00`000000i^KV0000001H0?ooo`030000003Vi^H000000080c<c<00<000000;>c/`000000
0P2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00D0000004a<C01<C4`0C4a<0000000503<c
<`030000000I6AT06ATI00P06ATI:@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo:P00000:01TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<
C4`0C4a<0000000406IVIP040000001oOgl0Ogmo00000080VIVI00<000000;>c/`0000000P3<c<`0
0`000000i^KV0000001H0?ooo`030000003Vi^H000000080c<c<00<000000;>c/`0000000P2IVIT0
1@000000Ogmo07moO`1oOgl0000000<0IVIV00D0000004a<C01<C4`0C4a<0000000503<c<`030000
000I6AT06ATI00P06ATI:@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo:P00000:01TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<
0000000406IVIP040000001oOgl0Ogmo00000080VIVI00<000000;>c/`0000000P3<c<`00`000000
i^KV0000001H0?ooo`030000003Vi^H000000080c<c<00<000000;>c/`0000000P2IVIT01@000000
Ogmo07moO`1oOgl0000000<0IVIV00D0000004a<C01<C4`0C4a<0000000503<c<`030000000I6AT0
6ATI00P06ATI:@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo:P00000:01TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@00
0000IVIV06IVIP1VIVH000000080Ogmo00H0000009VIV@2IVIT000000;>c/`0000020<c<c0030000
003Vi^H0000005P0oooo00<000000>KViP0000000P3<c<`00`000000/k>c0000000209VIV@050000
001oOgl0Ogmo07moO`0000000P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0
<c<c00<0000001TI6@0I6AT0200I6ATY000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooolZ000000X06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<
04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl01P000000VIVI09VIV@000000/k>c
00000080c<c<00<000000>KViP000000E`3oool010000000i^KV0>KViP0000020<c<c0030000002c
/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000206IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6BT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobX000002P0I6AT00`000000<c<c03<c
<`0403<c<`050000001<C4`0C4a<04a<C00000000`1VIVH01@000000Ogmo07moO`1oOgl000000080
VIVI00<000000;>c/`0000000P3<c<`00`000000i^KV0000001F0?ooo`030000003Vi^H000000080
c<c<00<000000;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<
C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00P06ATI:@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo:P00000:01TI6@03
0000000c<c<0<c<c00@0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP050000001oOgl0Ogmo
07moO`0000000P2IVIT00`000000/k>c000000020<c<c0030000003Vi^H0000005H0oooo00<00000
0>KViP0000000P3<c<`00`000000/k>c0000000209VIV@050000001oOgl0Ogmo07moO`0000000P1V
IVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I
6ATZ000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool[
000000X06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0
IVIV06IVIP0000000P1oOgl01P000000VIVI09VIV@000000/k>c00000080c<c<00<000000>KViP00
0000E@3oool010000000i^KV0>KViP0000020<c<c0030000002c/k<000000080VIVI00D0000007mo
O`1oOgl0Ogmo0000000206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<0
0`0000006ATI01TI6@0801TI6BX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooob/000002P0I6AT00`000000<c<c03<c<`0403<c<`050000001<C4`0C4a<
04a<C00000000`1VIVH01@000000Ogmo07moO`1oOgl000000080VIVI00<000000;>c/`0000000P3<
c<`00`000000i^KV0000001D0?ooo`030000003Vi^H000000080c<c<00<000000;>c/`0000000P2I
VIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c
03<c<`0303<c<`030000000I6AT06ATI00P06ATI:P0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`8000000`3oool[000000X06ATI00<0000003<c<`0c<c<0100c<c<01@000000C4a<04a<
C01<C4`0000000<0IVIV00D0000007moO`1oOgl0Ogmo0000000209VIV@030000002c/k<000000080
c<c<00<000000>KViP000000E03oool00`000000i^KV000000020<c<c0030000002c/k<000000080
VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c
<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6BX00000103oool2000000L0oooo000E0?ooo`03
0000003oool0oooo0080oooo:`00000:01TI6@030000000c<c<0<c<c00@0<c<c00D0000004a<C01<
C4`0C4a<0000000406IVIP040000001oOgl0Ogmo00000080VIVI00<000000;>c/`0000000P3<c<`0
10000000i^KV0>KViP00001B0?ooo`030000003Vi^H000000080c<c<00@000000;>c/`2c/k<00000
0P2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000
<c<c03<c<`0303<c<`030000000I6AT06ATI00P06ATI:P0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo;000000:01TI6@030000000c<c<0<c<c00@0<c<c
00D0000004a<C01<C4`0C4a<0000000306IVIP050000001oOgl0Ogmo07moO`0000000P2IVIT00`00
0000/k>c000000020<c<c0030000003Vi^H000000580oooo00<000000>KViP0000000P3<c<`00`00
0000/k>c0000000209VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C002
04a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6AT[000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool/000000X06ATI00<0000003<c
<`0c<c<0100c<c<01@000000C4a<04a<C01<C4`0000000@0IVIV00@0000007moO`1oOgl000000P2I
VIT00`000000/k>c000000020<c<c0040000003Vi^H0i^KV00000500oooo00<000000>KViP000000
0P3<c<`010000000/k>c0;>c/`00000209VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`00
0000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6AT[0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool]000000T0
6ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IV
IP0000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<00000080i^KV00<0
00000?ooo`3oool0C03oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080
VIVI00@0000007moO`1oOgl00000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00<0<c<c00<0000001TI6@0I6AT01`0I6AT/000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3oool]000000X06ATI00<0000003<c<`0c<c<0100c<c<01@000000
C4a<04a<C01<C4`0000000@0IVIV00@0000007moO`1oOgl000000P2IVIT00`000000/k>c00000002
0<c<c0040000003Vi^H0i^KV000004h0oooo00<000000>KViP0000000P3<c<`010000000/k>c0;>c
/`00000209VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C00204a<C003
0000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6AT/000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3oool]000000X06ATI00<0000003<c<`0c<c<0
100c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl010000000
VIVI09VIV@0000020;>c/`040000003<c<`0c<c<00000080i^KV00<000000?ooo`3oool0BP3oool0
10000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080VIVI00@0000007moO`1oOgl0
0000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I
6AT0200I6AT/000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3oool]000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0050000
001VIVH0IVIV06IVIP0000000`1oOgl010000000VIVI09VIV@0000020;>c/`060000003<c<`0c<c<
0000003Vi^H00000B`3oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080
VIVI00@0000007moO`1oOgl00000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT0200I6AT/000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3oool^000000X06ATI00<0000003<c<`0c<c<00`0c<c<00`000000
C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl00`000000VIVI000000030;>c
/`030000003<c<`000000080i^KV00<000000?ooo`3oool0B03oool01P000000i^KV0>KViP000000
c<c<000000<0/k>c00<0000009VIV@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<
C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6Bd000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobh000002P0I6AT0
0`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000
000307moO`040000002IVIT0VIVI000000<0/k>c00<000000<c<c00000000P3Vi^H00`000000oooo
0?ooo`160?ooo`040000003Vi^H0i^KV00000080c<c<00@000000;>c/`2c/k<000000P2IVIT01000
0000Ogmo07moO`00000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<0
0`0000006ATI01TI6@0801TI6Bd000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooobh000002`0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<
00<0C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`040000002IVIT0VIVI00000080/k>c00@0
00000<c<c03<c<`000000P3Vi^H00`000000oooo0?ooo`140?ooo`040000003Vi^H0i^KV00000080
c<c<00@000000;>c/`2c/k<000000P2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<00000
04a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI;@000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;`00000:01TI
6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0
000000<0Ogmo00@0000009VIV@2IVIT000000`2c/k<00`000000c<c<000000030>KViP030000003o
ool0oooo04<0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c/`00000209VIV@04
0000001oOgl0Ogmo000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c
<`030000000I6AT06ATI00P06ATI;P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`80
00000`3oool_000000/06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00304a<C005
0000001VIVH0IVIV06IVIP0000000`1oOgl010000000VIVI09VIV@0000030;>c/`040000003<c<`0
000000000080i^KV00<000000?ooo`3oool0@@3oool010000000i^KV0>KViP0000020<c<c0040000
002c/k<0/k>c00000080VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0C4a<
00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6Bh00000103oool20000
00L0oooo000E0?ooo`030000003oool0oooo0080oooo;`00000;01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00@0000009VI
V@2IVIT000000P2c/k<01@000000c<c<0<c<c03<c<`000000080i^KV00<000000?ooo`3oool0?`3o
ool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080VIVI00D0000007moO`1o
Ogl0Ogmo0000000306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0901TI6Bh000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooc0000002`0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00<0
C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`050000002IVIT0VIVI09VIV@0000000P2c/k<0
1`000000c<c<0<c<c03<c<`000000>KViP000000@03oool010000000i^KV0>KViP0000020<c<c005
0000002c/k<0/k>c0;>c/`0000000P2IVIT010000000Ogmo07moO`00000406IVIP030000001<C4`0
C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6Bl000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc0000002`0I6AT00`00
0000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV00000003
07moO`070000002IVIT0VIVI09VIV@000000/k>c000000030<c<c0040000003Vi^H0i^KV000003h0
oooo00@000000>KViP3Vi^H000000`3<c<`010000000/k>c0;>c/`00000209VIV@050000001oOgl0
Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0
000001TI6@0I6AT02@0I6AT_000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooola000000/06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C003
04a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl01@000000VIVI09VIV@2IVIT000000080/k>c
00D000000<c<c03<c<`0c<c<000000020>KViP030000003oool0oooo03X0oooo00@000000>KViP3V
i^H000000`3<c<`010000000/k>c0;>c/`00000309VIV@040000001oOgl0Ogmo000000@0IVIV00<0
000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI<000
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<@00000;
01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1V
IVH0000000<0Ogmo00D0000009VIV@2IVIT0VIVI000000020;>c/`050000003<c<`0c<c<0<c<c000
00000P3Vi^H2000003T0oooo00@000000>KViP3Vi^H000000`3<c<`010000000/k>c0;>c/`000003
09VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C00304a<C0030000000c
<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT`000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolb000000/06ATI00<0000003<c<`0c<c<00`0c<c<0
0`000000C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP000000101oOgl01@000000VIVI09VI
V@2IVIT000000080/k>c00D000000<c<c03<c<`0c<c<000000030>KViP030000003oool0oooo03D0
oooo00@000000>KViP3Vi^H000000`3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00D00000
07moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c
<c<00`0000006ATI01TI6@0801TI6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oooc8000002`0I6AT00`000000<c<c03<c<`0403<c<`800000101<C4`0
1@000000IVIV06IVIP1VIVH0000000@0Ogmo00D0000009VIV@2IVIT0VIVI000000020;>c/`050000
003<c<`0c<c<0<c<c00000000`3Vi^H00`000000oooo0?ooo`0b0?ooo`8000000P3Vi^H01@000000
c<c<0<c<c03<c<`000000080/k>c0P00000209VIV@030000001oOgl0Ogmo0080Ogmo00D0000006IV
IP1VIVH0IVIV0000000504a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATa
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolb0000
00/06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00204a<C0040000001VIVH0IVIV
06IVIP8000000`1oOgl01@000000VIVI09VIV@2IVIT000000080/k>c0P0000020<c<c08000000P3V
i^H200000300oooo0P0000020>KViP8000000P3<c<`200000080/k>c00D0000009VIV@2IVIT0VIVI
0000000307moO`8000000`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT02@0I6ATb000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooolc000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<
C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@050000
002c/k<0/k>c0;>c/`0000000`3<c<`010000000i^KV0>KViP3Vi^H2000002`0oooo0P0000030>KV
iP050000003<c<`0c<c<0<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00<0
000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0
000001TI6@0I6AT02@0I6ATb000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolc000000`06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C003
04a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@8000000P2c
/k<200000080c<c<0P0000030>KViP800000:03oool2000000<0i^KV0P0000020<c<c08000000P2c
/k<2000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<00<0C4a<
00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6C<000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc@000002`0I6AT00`000000<c<c03<c
<`0603<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07mo
O`0207moO`030000002IVIT0VIVI0080VIVI00D000000;>c/`2c/k<0/k>c000000030<c<c0030000
003Vi^H0i^KV0080i^KV0P00000T0?ooo`800000103Vi^H01@000000c<c<0<c<c03<c<`0000000<0
/k>c00<0000009VIV@2IVIT00P2IVIT01@000000Ogmo07moO`1oOgl0000000D0IVIV00<0000004a<
C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00X06ATI<`0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=000000<01TI6@03
0000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP03
0000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00P2IVIT010000000/k>c0;>c/`2c/k<20000
0080c<c<0P0000040>KViP800000803oool2000000@0i^KV0P0000020<c<c08000000`2c/k<00`00
0000VIVI09VIV@0209VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH00P1VIVH00`00
0000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATd0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?ooocD00000300I6AT00`000000
<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000
Ogmo07moO`0207moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<00P2c/k<200000080
c<c<0P0000040>KViP800000703oool2000000@0i^KV0P0000020<c<c0800000102c/k<00`000000
VIVI09VIV@0209VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000
C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02P0I6ATd000000@0
oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooocH00000300I6AT00`000000<c<c
03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH2000000<0Ogmo
00<0000009VIV@2IVIT00P2IVIT2000000@0/k>c0P0000020<c<c0<000000`3Vi^H4000001@0oooo
100000030>KViP<000000P3<c<`2000000@0/k>c0P00000409VIV@040000001oOgl0Ogmo07moO`80
0000101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I
6AT02P0I6ATe000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolf000000d06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000
001VIVH0IVIV00<0IVIV00@0000007moO`1oOgl0Ogmo0P00000409VIV@800000102c/k<2000000<0
c<c<0`0000040>KViQ@00000103Vi^H3000000<0c<c<0P0000040;>c/`800000102IVIT2000000<0
Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0
<c<c00<0000001TI6@0I6AT02`0I6ATe000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooolg000000d06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<
04a<C00304a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00P1oOgl00`000000VIVI
09VIV@0309VIV@800000102c/k<3000000<0c<c<1000000D0>KViP@000000`3<c<`3000000@0/k>c
0P00000509VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<
04a<C00304a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATf000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolh000000d06ATI00<0
000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0800000101VIVH2000000<0Ogmo0P00
000509VIV@8000001@2c/k<3000000@0c<c<1`0000070>KViPH00000103<c<`3000000D0/k>c0P00
000509VIV@8000000`1oOgl2000000@0IVIV0P00000504a<C0030000000c<c<0<c<c00H0<c<c00<0
000001TI6@0I6AT02P0I6ATg000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolh000000d06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C004
04a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00P1oOgl2000000D0VIVI0P000006
0;>c/`8000002@3<c<`7000000P0c<c<0P0000060;>c/`8000001@2IVIT2000000@0Ogmo00<00000
06IVIP1VIVH00`1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00H0<c<c00<00000
01TI6@0I6AT02`0I6ATg000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3oooli000000d06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00404a<
C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00`1oOgl2000000D0VIVI0`0000050;>c
/`<000004P3<c<`3000000D0/k>c0`00000509VIV@8000001@1oOgl00`000000IVIV06IVIP0306IV
IP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0;01TI
6CP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocX0
00003@0I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1V
IVH00`1VIVH2000000D0Ogmo0P00000609VIV@<000001@2c/k<B000000D0/k>c0`00000609VIV@80
00001@1oOgl2000000D0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0603<c<`03
0000000I6AT06ATI00/06ATI>@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo>`00000=01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`0
101<C4`2000000D0IVIV0P00000507moO`<000001P2IVIT4000001@0/k>c1000000609VIV@<00000
1@1oOgl2000000D0IVIV0P00000604a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT0
2`0I6ATj000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolk000000h06ATI00<0000003<c<`0c<c<01P0c<c<2000000H0C4a<00<0000006IVIP1VIVH0101V
IVH2000000H0Ogmo0`00000709VIVA@000001`2IVIT3000000H0Ogmo0P00000606IVIP030000001<
C4`0C4a<00D0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0;01TI6C/000001@3o
ool00`000000oooo0?ooo`050?ooo`00203oool2000000@0oooo0P0000050?ooo`030000003oool0
oooo0080oooo?000000>01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`0101<C4`2
000000H0IVIV0`00000607moO`<00000702IVIT3000000H0Ogmo0`00000606IVIP8000001P1<C4`2
000000P0<c<c00<0000001TI6@0I6AT0300I6ATk000000D0oooo00<000000?ooo`3oool01@3oool0
00L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0080oooo?@00000>01TI6@030000000c<c<0<c<c00L0<c<c0P00000604a<C08000001`1V
IVH2000000L0Ogmo1000000D09VIV@@000001`1oOgl2000000P0IVIV00<0000004a<C01<C4`01@1<
C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00`06ATI?00000050?ooo`030000003o
ool0oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`020?ooo`<000000P3oooln000000h06ATI00<0000003<c<`0c<c<0200c<c<00`000000C4a<04a<
C00504a<C08000001`1VIVH2000000T0Ogmo5000000907moO`8000001`1VIVH3000000L0C4a<00<0
000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0<01TI6Cd000000`3oool3000000L0oooo000:
0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`020?ooocl000003P0I6AT00`000000<c<c03<c<`0703<c<`030000001<C4`0C4a<00L0C4a<0P00
000706IVIP<00000801oOgl3000000L0IVIV0P00000904a<C0030000000c<c<0<c<c00L0<c<c00<0
000001TI6@0I6AT0300I6ATn000000D0oooo00<000000?ooo`3oool01@3oool000L0oooo00@00000
0?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo
@000000>01TI6@800000200c<c<2000000T0C4a<0`00000706IVIPH00000501oOgl6000000L0IVIV
0`00000904a<C0800000200c<c<2000000h06ATI?`0000050?ooo`030000003oool0oooo00D0oooo
00080?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool00P3ooom1000000l06ATI00<0
000003<c<`0c<c<01`0c<c<2000000X0C4a<0`00000:06IVIPL000001`1oOgl6000000X0IVIV0`00
000:04a<C08000002@0c<c<00`0000006ATI01TI6@0=01TI6D0000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?oood<000003P0I6AT00`000000<c<c03<c<`08
03<c<`<000002P1<C4`3000000h0IVIV1`00000=06IVIP<000002P1<C4`3000000X0<c<c00<00000
01TI6@0I6AT03@0I6AU1000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooom4000000h06ATI0P00000;03<c<`8000002`1<C4`3000001`0IVIV0`00000;04a<
C08000002`0c<c<2000000l06ATI@P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080ooooA@00000?01TI6@8000002`0c<c<2000000`0C4a<1@00000B06IVIPD0
0000301<C4`2000000/0<c<c0P00000@01TI6D<000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooodH00000400I6AT00`000000<c<c03<c<`0:03<c<`<00000
3P1<C4`B000000h0C4a<0`00000<03<c<`030000000I6AT06ATI00l06ATIA00000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooA`00000@01TI6@030000000c
<c<0<c<c00`0<c<c0`00000X04a<C0<000003P0c<c<00`0000006ATI01TI6@0>01TI6DH000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodP00000400I6AT2
000000l0<c<c0`00000R04a<C0<000003`0c<c<2000001006ATIA`0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooBP00000@01TI6@800000400c<c<30000
01`0C4a<0`00000@03<c<`8000004@0I6AU8000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooom;000001406ATI0P00000A03<c<`@00000501<C4`400000140
<c<c0P00000A01TI6DX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?oood`000004P0I6AT2000001<0<c<c5000000C03<c<`8000004P0I6AU;000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oood`00000500I6AT3000003@0<c<c0`00
000D01TI6D/00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080ooooCP00000E
01TI6@<00000;P0c<c<3000001D06ATIC@0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080ooooD000000F01TI6@<00000:00c<c<3000001H06ATIC`0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooDP00000G01TI6@@0
0000800c<c<4000001L06ATID@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080ooooD`00000J01TI6@H00000500c<c<6000001X06ATIDP0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooE@00000N01TI6A@000007P0I
6AUD000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomF
000004h06ATIE@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080ooooF000001:01TI6EL000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooeX00000AP0I6AUI000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooomL000004806ATIF`0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080ooooG`00000l01TI6Eh000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooof<00000=00I6AUR000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo0P0000030?ooofP00000:`0I6AUV000000@0oooo0P0000070?oo
o`005@3oool00`000000oooo0?ooo`020?ooof`000008P0I6AU[000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom_000001`06ATIKP0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooNP00000701TI6GP000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool2000000<0oooon@0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo0P0000030?ooooT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080
oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
n@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo00090?ooo`<000000P3oool2000000D0oooo00<000000?ooo`3oool00P3ooooi0000
00D0oooo00<000000?ooo`3oool01@3oool000X0oooo00@000000?ooo`3oool000000P3oool00`00
0000oooo0?ooo`020?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo
00D0oooo00070?ooo`D0000000D0oooo0000003oool0oooo000000040?ooo`<000000P3ooooi0000
00<0oooo0`0000070?ooo`001`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo
000000@0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
00P0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0
oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo00090?ooo`8000000`3oool20000
00D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool0o`3oool10?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0
oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0k0?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0203o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3o
ool001D0ooooo`000005000000L0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo
003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo002>0?ooo`800000
00@0oooo00000000000000000P3oool2000000@0oooo0P0000220?ooo`00SP3oool01@000000oooo
0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`000021
0?ooo`00SP3oool01@000000oooo0000003oool000000080oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000210?ooo`00SP3oool2000000030?ooo`00000000000080oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000210?ooo`00SP3oool2000000030?oo
o`00000000000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000210?oo
o`00SP3oool2000000040?ooo`000000000000000080oooo0P0000040?ooo`800000PP3oool00?l0
oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-3.26594, -1.76599, 0.160642, \
0.160642}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00480769 0.0240385 -0.00480769 0.0240385 [
[.23558 -0.0125 -6 -9 ]
[.23558 -0.0125 6 0 ]
[.47596 -0.0125 -6 -9 ]
[.47596 -0.0125 6 0 ]
[.71635 -0.0125 -6 -9 ]
[.71635 -0.0125 6 0 ]
[.95673 -0.0125 -6 -9 ]
[.95673 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .23558 -12 -4.5 ]
[-0.0125 .23558 0 4.5 ]
[-0.0125 .47596 -12 -4.5 ]
[-0.0125 .47596 0 4.5 ]
[-0.0125 .71635 -12 -4.5 ]
[-0.0125 .71635 0 4.5 ]
[-0.0125 .95673 -12 -4.5 ]
[-0.0125 .95673 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -11 0 ]
[.5 1.0125 11 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23558 0 m
.23558 .00625 L
s
[(10)] .23558 -0.0125 0 1 Mshowa
.47596 0 m
.47596 .00625 L
s
[(20)] .47596 -0.0125 0 1 Mshowa
.71635 0 m
.71635 .00625 L
s
[(30)] .71635 -0.0125 0 1 Mshowa
.95673 0 m
.95673 .00625 L
s
[(40)] .95673 -0.0125 0 1 Mshowa
.125 Mabswid
.04327 0 m
.04327 .00375 L
s
.09135 0 m
.09135 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.1875 0 m
.1875 .00375 L
s
.28365 0 m
.28365 .00375 L
s
.33173 0 m
.33173 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.42788 0 m
.42788 .00375 L
s
.52404 0 m
.52404 .00375 L
s
.57212 0 m
.57212 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.66827 0 m
.66827 .00375 L
s
.76442 0 m
.76442 .00375 L
s
.8125 0 m
.8125 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.90865 0 m
.90865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .23558 m
.00625 .23558 L
s
[(10)] -0.0125 .23558 1 0 Mshowa
0 .47596 m
.00625 .47596 L
s
[(20)] -0.0125 .47596 1 0 Mshowa
0 .71635 m
.00625 .71635 L
s
[(30)] -0.0125 .71635 1 0 Mshowa
0 .95673 m
.00625 .95673 L
s
[(40)] -0.0125 .95673 1 0 Mshowa
.125 Mabswid
0 .04327 m
.00375 .04327 L
s
0 .09135 m
.00375 .09135 L
s
0 .13942 m
.00375 .13942 L
s
0 .1875 m
.00375 .1875 L
s
0 .28365 m
.00375 .28365 L
s
0 .33173 m
.00375 .33173 L
s
0 .37981 m
.00375 .37981 L
s
0 .42788 m
.00375 .42788 L
s
0 .52404 m
.00375 .52404 L
s
0 .57212 m
.00375 .57212 L
s
0 .62019 m
.00375 .62019 L
s
0 .66827 m
.00375 .66827 L
s
0 .76442 m
.00375 .76442 L
s
0 .8125 m
.00375 .8125 L
s
0 .86058 m
.00375 .86058 L
s
0 .90865 m
.00375 .90865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.23558 .99375 m
.23558 1 L
s
.47596 .99375 m
.47596 1 L
s
.71635 .99375 m
.71635 1 L
s
.95673 .99375 m
.95673 1 L
s
.125 Mabswid
.04327 .99625 m
.04327 1 L
s
.09135 .99625 m
.09135 1 L
s
.13942 .99625 m
.13942 1 L
s
.1875 .99625 m
.1875 1 L
s
.28365 .99625 m
.28365 1 L
s
.33173 .99625 m
.33173 1 L
s
.37981 .99625 m
.37981 1 L
s
.42788 .99625 m
.42788 1 L
s
.52404 .99625 m
.52404 1 L
s
.57212 .99625 m
.57212 1 L
s
.62019 .99625 m
.62019 1 L
s
.66827 .99625 m
.66827 1 L
s
.76442 .99625 m
.76442 1 L
s
.8125 .99625 m
.8125 1 L
s
.86058 .99625 m
.86058 1 L
s
.90865 .99625 m
.90865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .23558 m
1 .23558 L
s
.99375 .47596 m
1 .47596 L
s
.99375 .71635 m
1 .71635 L
s
.99375 .95673 m
1 .95673 L
s
.125 Mabswid
.99625 .04327 m
1 .04327 L
s
.99625 .09135 m
1 .09135 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .1875 m
1 .1875 L
s
.99625 .28365 m
1 .28365 L
s
.99625 .33173 m
1 .33173 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .42788 m
1 .42788 L
s
.99625 .52404 m
1 .52404 L
s
.99625 .57212 m
1 .57212 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .66827 m
1 .66827 L
s
.99625 .76442 m
1 .76442 L
s
.99625 .8125 m
1 .8125 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .90865 m
1 .90865 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M10) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.5 Mabswid
.1 g
.47596 .09003 m
.5 .08926 L
.52404 .09003 L
.54373 .09135 L
.54808 .09251 L
.57212 .09702 L
.59615 .10334 L
.62019 .11135 L
.63088 .11538 L
.64423 .12158 L
.66827 .13435 L
.67691 .13942 L
.69231 .14996 L
.7099 .16346 L
.71635 .16905 L
.73531 .1875 L
.74038 .19305 L
.75523 .21154 L
.76442 .22464 L
.77088 .23558 L
.7829 .25962 L
.78846 .2734 L
.7914 .28365 L
.79638 .30769 L
.79796 .33173 L
.79564 .35577 L
.78877 .37981 L
.78846 .38064 L
.7749 .40385 L
.76442 .41635 L
.75108 .42788 L
.74038 .43513 L
.71635 .44773 L
.70629 .45192 L
.69231 .45409 L
.66827 .45902 L
.64423 .46429 L
.62019 .46894 L
.59615 .47263 L
.57212 .47536 L
.56573 .47596 L
.54808 .47679 L
.52404 .47751 L
.5 .47774 L
.47596 .47751 L
.45192 .47679 L
.43427 .47596 L
.42788 .47536 L
.40385 .47263 L
.37981 .46894 L
.35577 .46429 L
.33173 .45902 L
.30769 .45409 L
.29371 .45192 L
.28365 .44773 L
.25962 .43513 L
.24892 .42788 L
.23558 .41635 L
.2251 .40385 L
.21154 .38064 L
.21123 .37981 L
.20436 .35577 L
.20204 .33173 L
.20362 .30769 L
.2086 .28365 L
.21154 .2734 L
.2171 .25962 L
.22912 .23558 L
.23558 .22464 L
.24477 .21154 L
.25962 .19305 L
.26469 .1875 L
.28365 .16905 L
.2901 .16346 L
.30769 .14996 L
.32309 .13942 L
.33173 .13435 L
.35577 .12158 L
.36912 .11538 L
.37981 .11135 L
.40385 .10334 L
.42788 .09702 L
.45192 .09251 L
.45627 .09135 L
F
0 g
.47596 .09003 m
.5 .08926 L
.52404 .09003 L
.54373 .09135 L
.54808 .09251 L
.57212 .09702 L
.59615 .10334 L
.62019 .11135 L
.63088 .11538 L
.64423 .12158 L
.66827 .13435 L
.67691 .13942 L
.69231 .14996 L
.7099 .16346 L
.71635 .16905 L
.73531 .1875 L
.74038 .19305 L
.75523 .21154 L
.76442 .22464 L
.77088 .23558 L
.7829 .25962 L
.78846 .2734 L
.7914 .28365 L
.79638 .30769 L
.79796 .33173 L
.79564 .35577 L
.78877 .37981 L
.78846 .38064 L
.7749 .40385 L
.76442 .41635 L
.75108 .42788 L
.74038 .43513 L
.71635 .44773 L
.70629 .45192 L
.69231 .45409 L
.66827 .45902 L
.64423 .46429 L
.62019 .46894 L
.59615 .47263 L
.57212 .47536 L
.56573 .47596 L
.54808 .47679 L
.52404 .47751 L
.5 .47774 L
.47596 .47751 L
.45192 .47679 L
.43427 .47596 L
.42788 .47536 L
.40385 .47263 L
.37981 .46894 L
Mistroke
.35577 .46429 L
.33173 .45902 L
.30769 .45409 L
.29371 .45192 L
.28365 .44773 L
.25962 .43513 L
.24892 .42788 L
.23558 .41635 L
.2251 .40385 L
.21154 .38064 L
.21123 .37981 L
.20436 .35577 L
.20204 .33173 L
.20362 .30769 L
.2086 .28365 L
.21154 .2734 L
.2171 .25962 L
.22912 .23558 L
.23558 .22464 L
.24477 .21154 L
.25962 .19305 L
.26469 .1875 L
.28365 .16905 L
.2901 .16346 L
.30769 .14996 L
.32309 .13942 L
.33173 .13435 L
.35577 .12158 L
.36912 .11538 L
.37981 .11135 L
.40385 .10334 L
.42788 .09702 L
.45192 .09251 L
.45627 .09135 L
.47596 .09003 L
Mfstroke
.1 g
.45192 .52321 m
.47596 .52249 L
.5 .52226 L
.52404 .52249 L
.54808 .52321 L
.56573 .52404 L
.57212 .52464 L
.59615 .52737 L
.62019 .53106 L
.64423 .53571 L
.66827 .54098 L
.69231 .54591 L
.70629 .54808 L
.71635 .55227 L
.74038 .56487 L
.75108 .57212 L
.76442 .58365 L
.7749 .59615 L
.78846 .61936 L
.78877 .62019 L
.79564 .64423 L
.79796 .66827 L
.79638 .69231 L
.7914 .71635 L
.78846 .7266 L
.7829 .74038 L
.77088 .76442 L
.76442 .77536 L
.75523 .78846 L
.74038 .80695 L
.73531 .8125 L
.71635 .83095 L
.7099 .83654 L
.69231 .85004 L
.67691 .86058 L
.66827 .86565 L
.64423 .87842 L
.63088 .88462 L
.62019 .88865 L
.59615 .89666 L
.57212 .90298 L
.54808 .90749 L
.54373 .90865 L
.52404 .90997 L
.5 .91074 L
.47596 .90997 L
.45627 .90865 L
.45192 .90749 L
.42788 .90298 L
.40385 .89666 L
.37981 .88865 L
.36912 .88462 L
.35577 .87842 L
.33173 .86565 L
.32309 .86058 L
.30769 .85004 L
.2901 .83654 L
.28365 .83095 L
.26469 .8125 L
.25962 .80695 L
.24477 .78846 L
.23558 .77536 L
.22912 .76442 L
.2171 .74038 L
.21154 .7266 L
.2086 .71635 L
.20362 .69231 L
.20204 .66827 L
.20436 .64423 L
.21123 .62019 L
.21154 .61936 L
.2251 .59615 L
.23558 .58365 L
.24892 .57212 L
.25962 .56487 L
.28365 .55227 L
.29371 .54808 L
.30769 .54591 L
.33173 .54098 L
.35577 .53571 L
.37981 .53106 L
.40385 .52737 L
.42788 .52464 L
.43427 .52404 L
F
0 g
.45192 .52321 m
.47596 .52249 L
.5 .52226 L
.52404 .52249 L
.54808 .52321 L
.56573 .52404 L
.57212 .52464 L
.59615 .52737 L
.62019 .53106 L
.64423 .53571 L
.66827 .54098 L
.69231 .54591 L
.70629 .54808 L
.71635 .55227 L
.74038 .56487 L
.75108 .57212 L
.76442 .58365 L
.7749 .59615 L
.78846 .61936 L
.78877 .62019 L
.79564 .64423 L
.79796 .66827 L
.79638 .69231 L
.7914 .71635 L
.78846 .7266 L
.7829 .74038 L
.77088 .76442 L
.76442 .77536 L
.75523 .78846 L
.74038 .80695 L
.73531 .8125 L
.71635 .83095 L
.7099 .83654 L
.69231 .85004 L
.67691 .86058 L
.66827 .86565 L
.64423 .87842 L
.63088 .88462 L
.62019 .88865 L
.59615 .89666 L
.57212 .90298 L
.54808 .90749 L
.54373 .90865 L
.52404 .90997 L
.5 .91074 L
.47596 .90997 L
.45627 .90865 L
.45192 .90749 L
.42788 .90298 L
.40385 .89666 L
Mistroke
.37981 .88865 L
.36912 .88462 L
.35577 .87842 L
.33173 .86565 L
.32309 .86058 L
.30769 .85004 L
.2901 .83654 L
.28365 .83095 L
.26469 .8125 L
.25962 .80695 L
.24477 .78846 L
.23558 .77536 L
.22912 .76442 L
.2171 .74038 L
.21154 .7266 L
.2086 .71635 L
.20362 .69231 L
.20204 .66827 L
.20436 .64423 L
.21123 .62019 L
.21154 .61936 L
.2251 .59615 L
.23558 .58365 L
.24892 .57212 L
.25962 .56487 L
.28365 .55227 L
.29371 .54808 L
.30769 .54591 L
.33173 .54098 L
.35577 .53571 L
.37981 .53106 L
.40385 .52737 L
.42788 .52464 L
.43427 .52404 L
.45192 .52321 L
Mfstroke
.2 g
.42788 .13711 m
.45192 .13222 L
.47596 .12927 L
.5 .12829 L
.52404 .12927 L
.54808 .13222 L
.57212 .13711 L
.58116 .13942 L
.59615 .14436 L
.62019 .15413 L
.63906 .16346 L
.64423 .16645 L
.66827 .18234 L
.67506 .1875 L
.69231 .20261 L
.70112 .21154 L
.71635 .22952 L
.7207 .23558 L
.73523 .25962 L
.74038 .27003 L
.74536 .28365 L
.75137 .30769 L
.75326 .33173 L
.75049 .35577 L
.74214 .37981 L
.74038 .38348 L
.72563 .40385 L
.71635 .41314 L
.69587 .42788 L
.69231 .42988 L
.66827 .44087 L
.64423 .44902 L
.63357 .45192 L
.62019 .45314 L
.59615 .45559 L
.57212 .45797 L
.54808 .45986 L
.52404 .46105 L
.5 .46146 L
.47596 .46105 L
.45192 .45986 L
.42788 .45797 L
.40385 .45559 L
.37981 .45314 L
.36643 .45192 L
.35577 .44902 L
.33173 .44087 L
.30769 .42988 L
.30413 .42788 L
.28365 .41314 L
.27437 .40385 L
.25962 .38348 L
.25786 .37981 L
.24951 .35577 L
.24674 .33173 L
.24863 .30769 L
.25464 .28365 L
.25962 .27003 L
.26477 .25962 L
.2793 .23558 L
.28365 .22952 L
.29888 .21154 L
.30769 .20261 L
.32494 .1875 L
.33173 .18234 L
.35577 .16645 L
.36094 .16346 L
.37981 .15413 L
.40385 .14436 L
.41884 .13942 L
F
0 g
.42788 .13711 m
.45192 .13222 L
.47596 .12927 L
.5 .12829 L
.52404 .12927 L
.54808 .13222 L
.57212 .13711 L
.58116 .13942 L
.59615 .14436 L
.62019 .15413 L
.63906 .16346 L
.64423 .16645 L
.66827 .18234 L
.67506 .1875 L
.69231 .20261 L
.70112 .21154 L
.71635 .22952 L
.7207 .23558 L
.73523 .25962 L
.74038 .27003 L
.74536 .28365 L
.75137 .30769 L
.75326 .33173 L
.75049 .35577 L
.74214 .37981 L
.74038 .38348 L
.72563 .40385 L
.71635 .41314 L
.69587 .42788 L
.69231 .42988 L
.66827 .44087 L
.64423 .44902 L
.63357 .45192 L
.62019 .45314 L
.59615 .45559 L
.57212 .45797 L
.54808 .45986 L
.52404 .46105 L
.5 .46146 L
.47596 .46105 L
.45192 .45986 L
.42788 .45797 L
.40385 .45559 L
.37981 .45314 L
.36643 .45192 L
.35577 .44902 L
.33173 .44087 L
.30769 .42988 L
.30413 .42788 L
.28365 .41314 L
Mistroke
.27437 .40385 L
.25962 .38348 L
.25786 .37981 L
.24951 .35577 L
.24674 .33173 L
.24863 .30769 L
.25464 .28365 L
.25962 .27003 L
.26477 .25962 L
.2793 .23558 L
.28365 .22952 L
.29888 .21154 L
.30769 .20261 L
.32494 .1875 L
.33173 .18234 L
.35577 .16645 L
.36094 .16346 L
.37981 .15413 L
.40385 .14436 L
.41884 .13942 L
.42788 .13711 L
Mfstroke
.2 g
.37981 .54686 m
.40385 .54441 L
.42788 .54203 L
.45192 .54014 L
.47596 .53895 L
.5 .53854 L
.52404 .53895 L
.54808 .54014 L
.57212 .54203 L
.59615 .54441 L
.62019 .54686 L
.63357 .54808 L
.64423 .55098 L
.66827 .55913 L
.69231 .57012 L
.69587 .57212 L
.71635 .58686 L
.72563 .59615 L
.74038 .61652 L
.74214 .62019 L
.75049 .64423 L
.75326 .66827 L
.75137 .69231 L
.74536 .71635 L
.74038 .72997 L
.73523 .74038 L
.7207 .76442 L
.71635 .77048 L
.70112 .78846 L
.69231 .79739 L
.67506 .8125 L
.66827 .81766 L
.64423 .83355 L
.63906 .83654 L
.62019 .84587 L
.59615 .85564 L
.58116 .86058 L
.57212 .86289 L
.54808 .86778 L
.52404 .87073 L
.5 .87171 L
.47596 .87073 L
.45192 .86778 L
.42788 .86289 L
.41884 .86058 L
.40385 .85564 L
.37981 .84587 L
.36094 .83654 L
.35577 .83355 L
.33173 .81766 L
.32494 .8125 L
.30769 .79739 L
.29888 .78846 L
.28365 .77048 L
.2793 .76442 L
.26477 .74038 L
.25962 .72997 L
.25464 .71635 L
.24863 .69231 L
.24674 .66827 L
.24951 .64423 L
.25786 .62019 L
.25962 .61652 L
.27437 .59615 L
.28365 .58686 L
.30413 .57212 L
.30769 .57012 L
.33173 .55913 L
.35577 .55098 L
.36643 .54808 L
F
0 g
.37981 .54686 m
.40385 .54441 L
.42788 .54203 L
.45192 .54014 L
.47596 .53895 L
.5 .53854 L
.52404 .53895 L
.54808 .54014 L
.57212 .54203 L
.59615 .54441 L
.62019 .54686 L
.63357 .54808 L
.64423 .55098 L
.66827 .55913 L
.69231 .57012 L
.69587 .57212 L
.71635 .58686 L
.72563 .59615 L
.74038 .61652 L
.74214 .62019 L
.75049 .64423 L
.75326 .66827 L
.75137 .69231 L
.74536 .71635 L
.74038 .72997 L
.73523 .74038 L
.7207 .76442 L
.71635 .77048 L
.70112 .78846 L
.69231 .79739 L
.67506 .8125 L
.66827 .81766 L
.64423 .83355 L
.63906 .83654 L
.62019 .84587 L
.59615 .85564 L
.58116 .86058 L
.57212 .86289 L
.54808 .86778 L
.52404 .87073 L
.5 .87171 L
.47596 .87073 L
.45192 .86778 L
.42788 .86289 L
.41884 .86058 L
.40385 .85564 L
.37981 .84587 L
.36094 .83654 L
.35577 .83355 L
.33173 .81766 L
Mistroke
.32494 .8125 L
.30769 .79739 L
.29888 .78846 L
.28365 .77048 L
.2793 .76442 L
.26477 .74038 L
.25962 .72997 L
.25464 .71635 L
.24863 .69231 L
.24674 .66827 L
.24951 .64423 L
.25786 .62019 L
.25962 .61652 L
.27437 .59615 L
.28365 .58686 L
.30413 .57212 L
.30769 .57012 L
.33173 .55913 L
.35577 .55098 L
.36643 .54808 L
.37981 .54686 L
Mfstroke
.3 g
.42788 .16153 m
.45192 .15602 L
.47596 .15273 L
.5 .15164 L
.52404 .15273 L
.54808 .15602 L
.57212 .16153 L
.57889 .16346 L
.59615 .1697 L
.62019 .18074 L
.63239 .1875 L
.64423 .19517 L
.66537 .21154 L
.66827 .21414 L
.68869 .23558 L
.69231 .24006 L
.70544 .25962 L
.71635 .28163 L
.71708 .28365 L
.72383 .30769 L
.72593 .33173 L
.72284 .35577 L
.71635 .37696 L
.71333 .37981 L
.69447 .40385 L
.69231 .40589 L
.66827 .423 L
.65888 .42788 L
.64423 .43398 L
.62019 .44172 L
.59615 .4474 L
.57212 .45145 L
.56888 .45192 L
.54808 .45275 L
.52404 .45344 L
.5 .45369 L
.47596 .45344 L
.45192 .45275 L
.43112 .45192 L
.42788 .45145 L
.40385 .4474 L
.37981 .44172 L
.35577 .43398 L
.34112 .42788 L
.33173 .423 L
.30769 .40589 L
.30553 .40385 L
.28667 .37981 L
.28365 .37696 L
.27716 .35577 L
.27407 .33173 L
.27617 .30769 L
.28292 .28365 L
.28365 .28163 L
.29456 .25962 L
.30769 .24006 L
.31131 .23558 L
.33173 .21414 L
.33463 .21154 L
.35577 .19517 L
.36761 .1875 L
.37981 .18074 L
.40385 .1697 L
.42111 .16346 L
F
0 g
.42788 .16153 m
.45192 .15602 L
.47596 .15273 L
.5 .15164 L
.52404 .15273 L
.54808 .15602 L
.57212 .16153 L
.57889 .16346 L
.59615 .1697 L
.62019 .18074 L
.63239 .1875 L
.64423 .19517 L
.66537 .21154 L
.66827 .21414 L
.68869 .23558 L
.69231 .24006 L
.70544 .25962 L
.71635 .28163 L
.71708 .28365 L
.72383 .30769 L
.72593 .33173 L
.72284 .35577 L
.71635 .37696 L
.71333 .37981 L
.69447 .40385 L
.69231 .40589 L
.66827 .423 L
.65888 .42788 L
.64423 .43398 L
.62019 .44172 L
.59615 .4474 L
.57212 .45145 L
.56888 .45192 L
.54808 .45275 L
.52404 .45344 L
.5 .45369 L
.47596 .45344 L
.45192 .45275 L
.43112 .45192 L
.42788 .45145 L
.40385 .4474 L
.37981 .44172 L
.35577 .43398 L
.34112 .42788 L
.33173 .423 L
.30769 .40589 L
.30553 .40385 L
.28667 .37981 L
.28365 .37696 L
.27716 .35577 L
Mistroke
.27407 .33173 L
.27617 .30769 L
.28292 .28365 L
.28365 .28163 L
.29456 .25962 L
.30769 .24006 L
.31131 .23558 L
.33173 .21414 L
.33463 .21154 L
.35577 .19517 L
.36761 .1875 L
.37981 .18074 L
.40385 .1697 L
.42111 .16346 L
.42788 .16153 L
Mfstroke
.3 g
.45192 .54725 m
.47596 .54656 L
.5 .54631 L
.52404 .54656 L
.54808 .54725 L
.56888 .54808 L
.57212 .54855 L
.59615 .5526 L
.62019 .55828 L
.64423 .56602 L
.65888 .57212 L
.66827 .577 L
.69231 .59411 L
.69447 .59615 L
.71333 .62019 L
.71635 .62304 L
.72284 .64423 L
.72593 .66827 L
.72383 .69231 L
.71708 .71635 L
.71635 .71837 L
.70544 .74038 L
.69231 .75994 L
.68869 .76442 L
.66827 .78586 L
.66537 .78846 L
.64423 .80483 L
.63239 .8125 L
.62019 .81926 L
.59615 .8303 L
.57889 .83654 L
.57212 .83847 L
.54808 .84398 L
.52404 .84727 L
.5 .84836 L
.47596 .84727 L
.45192 .84398 L
.42788 .83847 L
.42111 .83654 L
.40385 .8303 L
.37981 .81926 L
.36761 .8125 L
.35577 .80483 L
.33463 .78846 L
.33173 .78586 L
.31131 .76442 L
.30769 .75994 L
.29456 .74038 L
.28365 .71837 L
.28292 .71635 L
.27617 .69231 L
.27407 .66827 L
.27716 .64423 L
.28365 .62304 L
.28667 .62019 L
.30553 .59615 L
.30769 .59411 L
.33173 .577 L
.34112 .57212 L
.35577 .56602 L
.37981 .55828 L
.40385 .5526 L
.42788 .54855 L
.43112 .54808 L
F
0 g
.45192 .54725 m
.47596 .54656 L
.5 .54631 L
.52404 .54656 L
.54808 .54725 L
.56888 .54808 L
.57212 .54855 L
.59615 .5526 L
.62019 .55828 L
.64423 .56602 L
.65888 .57212 L
.66827 .577 L
.69231 .59411 L
.69447 .59615 L
.71333 .62019 L
.71635 .62304 L
.72284 .64423 L
.72593 .66827 L
.72383 .69231 L
.71708 .71635 L
.71635 .71837 L
.70544 .74038 L
.69231 .75994 L
.68869 .76442 L
.66827 .78586 L
.66537 .78846 L
.64423 .80483 L
.63239 .8125 L
.62019 .81926 L
.59615 .8303 L
.57889 .83654 L
.57212 .83847 L
.54808 .84398 L
.52404 .84727 L
.5 .84836 L
.47596 .84727 L
.45192 .84398 L
.42788 .83847 L
.42111 .83654 L
.40385 .8303 L
.37981 .81926 L
.36761 .8125 L
.35577 .80483 L
.33463 .78846 L
.33173 .78586 L
.31131 .76442 L
.30769 .75994 L
.29456 .74038 L
.28365 .71837 L
.28292 .71635 L
Mistroke
.27617 .69231 L
.27407 .66827 L
.27716 .64423 L
.28365 .62304 L
.28667 .62019 L
.30553 .59615 L
.30769 .59411 L
.33173 .577 L
.34112 .57212 L
.35577 .56602 L
.37981 .55828 L
.40385 .5526 L
.42788 .54855 L
.43112 .54808 L
.45192 .54725 L
Mfstroke
.4 g
.42788 .1802 m
.45192 .17403 L
.47596 .17039 L
.5 .16918 L
.52404 .17039 L
.54808 .17403 L
.57212 .1802 L
.59244 .1875 L
.59615 .18914 L
.62019 .20159 L
.63548 .21154 L
.64423 .21822 L
.66313 .23558 L
.66827 .24116 L
.68228 .25962 L
.69231 .27682 L
.69525 .28365 L
.70278 .30769 L
.70511 .33173 L
.70168 .35577 L
.69231 .37904 L
.69112 .37981 L
.6698 .40385 L
.66827 .40512 L
.64423 .42046 L
.6275 .42788 L
.62019 .43045 L
.59615 .43722 L
.57212 .44201 L
.54808 .44522 L
.52404 .44706 L
.5 .44766 L
.47596 .44706 L
.45192 .44522 L
.42788 .44201 L
.40385 .43722 L
.37981 .43045 L
.3725 .42788 L
.35577 .42046 L
.33173 .40512 L
.3302 .40385 L
.30888 .37981 L
.30769 .37904 L
.29832 .35577 L
.29489 .33173 L
.29722 .30769 L
.30475 .28365 L
.30769 .27682 L
.31772 .25962 L
.33173 .24116 L
.33687 .23558 L
.35577 .21822 L
.36452 .21154 L
.37981 .20159 L
.40385 .18914 L
.40756 .1875 L
F
0 g
.42788 .1802 m
.45192 .17403 L
.47596 .17039 L
.5 .16918 L
.52404 .17039 L
.54808 .17403 L
.57212 .1802 L
.59244 .1875 L
.59615 .18914 L
.62019 .20159 L
.63548 .21154 L
.64423 .21822 L
.66313 .23558 L
.66827 .24116 L
.68228 .25962 L
.69231 .27682 L
.69525 .28365 L
.70278 .30769 L
.70511 .33173 L
.70168 .35577 L
.69231 .37904 L
.69112 .37981 L
.6698 .40385 L
.66827 .40512 L
.64423 .42046 L
.6275 .42788 L
.62019 .43045 L
.59615 .43722 L
.57212 .44201 L
.54808 .44522 L
.52404 .44706 L
.5 .44766 L
.47596 .44706 L
.45192 .44522 L
.42788 .44201 L
.40385 .43722 L
.37981 .43045 L
.3725 .42788 L
.35577 .42046 L
.33173 .40512 L
.3302 .40385 L
.30888 .37981 L
.30769 .37904 L
.29832 .35577 L
.29489 .33173 L
.29722 .30769 L
.30475 .28365 L
.30769 .27682 L
.31772 .25962 L
.33173 .24116 L
Mistroke
.33687 .23558 L
.35577 .21822 L
.36452 .21154 L
.37981 .20159 L
.40385 .18914 L
.40756 .1875 L
.42788 .1802 L
Mfstroke
.4 g
.37981 .56955 m
.40385 .56278 L
.42788 .55799 L
.45192 .55478 L
.47596 .55294 L
.5 .55234 L
.52404 .55294 L
.54808 .55478 L
.57212 .55799 L
.59615 .56278 L
.62019 .56955 L
.6275 .57212 L
.64423 .57954 L
.66827 .59488 L
.6698 .59615 L
.69112 .62019 L
.69231 .62096 L
.70168 .64423 L
.70511 .66827 L
.70278 .69231 L
.69525 .71635 L
.69231 .72318 L
.68228 .74038 L
.66827 .75884 L
.66313 .76442 L
.64423 .78178 L
.63548 .78846 L
.62019 .79841 L
.59615 .81086 L
.59244 .8125 L
.57212 .8198 L
.54808 .82597 L
.52404 .82961 L
.5 .83082 L
.47596 .82961 L
.45192 .82597 L
.42788 .8198 L
.40756 .8125 L
.40385 .81086 L
.37981 .79841 L
.36452 .78846 L
.35577 .78178 L
.33687 .76442 L
.33173 .75884 L
.31772 .74038 L
.30769 .72318 L
.30475 .71635 L
.29722 .69231 L
.29489 .66827 L
.29832 .64423 L
.30769 .62096 L
.30888 .62019 L
.3302 .59615 L
.33173 .59488 L
.35577 .57954 L
.3725 .57212 L
F
0 g
.37981 .56955 m
.40385 .56278 L
.42788 .55799 L
.45192 .55478 L
.47596 .55294 L
.5 .55234 L
.52404 .55294 L
.54808 .55478 L
.57212 .55799 L
.59615 .56278 L
.62019 .56955 L
.6275 .57212 L
.64423 .57954 L
.66827 .59488 L
.6698 .59615 L
.69112 .62019 L
.69231 .62096 L
.70168 .64423 L
.70511 .66827 L
.70278 .69231 L
.69525 .71635 L
.69231 .72318 L
.68228 .74038 L
.66827 .75884 L
.66313 .76442 L
.64423 .78178 L
.63548 .78846 L
.62019 .79841 L
.59615 .81086 L
.59244 .8125 L
.57212 .8198 L
.54808 .82597 L
.52404 .82961 L
.5 .83082 L
.47596 .82961 L
.45192 .82597 L
.42788 .8198 L
.40756 .8125 L
.40385 .81086 L
.37981 .79841 L
.36452 .78846 L
.35577 .78178 L
.33687 .76442 L
.33173 .75884 L
.31772 .74038 L
.30769 .72318 L
.30475 .71635 L
.29722 .69231 L
.29489 .66827 L
.29832 .64423 L
Mistroke
.30769 .62096 L
.30888 .62019 L
.3302 .59615 L
.33173 .59488 L
.35577 .57954 L
.3725 .57212 L
.37981 .56955 L
Mfstroke
.5 g
.47596 .18505 m
.5 .18378 L
.52404 .18505 L
.54486 .1875 L
.54808 .18894 L
.57212 .19575 L
.59615 .20571 L
.60729 .21154 L
.62019 .2196 L
.6406 .23558 L
.64423 .23894 L
.66245 .25962 L
.66827 .26772 L
.67683 .28365 L
.68517 .30769 L
.68773 .33173 L
.68396 .35577 L
.67225 .37981 L
.66827 .38543 L
.64827 .40385 L
.64423 .40668 L
.62019 .41959 L
.597 .42788 L
.59615 .42812 L
.57212 .43367 L
.54808 .43732 L
.52404 .43942 L
.5 .4401 L
.47596 .43942 L
.45192 .43732 L
.42788 .43367 L
.40385 .42812 L
.403 .42788 L
.37981 .41959 L
.35577 .40668 L
.35173 .40385 L
.33173 .38543 L
.32775 .37981 L
.31604 .35577 L
.31227 .33173 L
.31483 .30769 L
.32317 .28365 L
.33173 .26772 L
.33755 .25962 L
.35577 .23894 L
.3594 .23558 L
.37981 .2196 L
.39271 .21154 L
.40385 .20571 L
.42788 .19575 L
.45192 .18894 L
.45514 .1875 L
F
0 g
.47596 .18505 m
.5 .18378 L
.52404 .18505 L
.54486 .1875 L
.54808 .18894 L
.57212 .19575 L
.59615 .20571 L
.60729 .21154 L
.62019 .2196 L
.6406 .23558 L
.64423 .23894 L
.66245 .25962 L
.66827 .26772 L
.67683 .28365 L
.68517 .30769 L
.68773 .33173 L
.68396 .35577 L
.67225 .37981 L
.66827 .38543 L
.64827 .40385 L
.64423 .40668 L
.62019 .41959 L
.597 .42788 L
.59615 .42812 L
.57212 .43367 L
.54808 .43732 L
.52404 .43942 L
.5 .4401 L
.47596 .43942 L
.45192 .43732 L
.42788 .43367 L
.40385 .42812 L
.403 .42788 L
.37981 .41959 L
.35577 .40668 L
.35173 .40385 L
.33173 .38543 L
.32775 .37981 L
.31604 .35577 L
.31227 .33173 L
.31483 .30769 L
.32317 .28365 L
.33173 .26772 L
.33755 .25962 L
.35577 .23894 L
.3594 .23558 L
.37981 .2196 L
.39271 .21154 L
.40385 .20571 L
.42788 .19575 L
Mistroke
.45192 .18894 L
.45514 .1875 L
.47596 .18505 L
Mfstroke
.5 g
.40385 .57188 m
.42788 .56633 L
.45192 .56268 L
.47596 .56058 L
.5 .5599 L
.52404 .56058 L
.54808 .56268 L
.57212 .56633 L
.59615 .57188 L
.597 .57212 L
.62019 .58041 L
.64423 .59332 L
.64827 .59615 L
.66827 .61457 L
.67225 .62019 L
.68396 .64423 L
.68773 .66827 L
.68517 .69231 L
.67683 .71635 L
.66827 .73228 L
.66245 .74038 L
.64423 .76106 L
.6406 .76442 L
.62019 .7804 L
.60729 .78846 L
.59615 .79429 L
.57212 .80425 L
.54808 .81106 L
.54486 .8125 L
.52404 .81495 L
.5 .81622 L
.47596 .81495 L
.45514 .8125 L
.45192 .81106 L
.42788 .80425 L
.40385 .79429 L
.39271 .78846 L
.37981 .7804 L
.3594 .76442 L
.35577 .76106 L
.33755 .74038 L
.33173 .73228 L
.32317 .71635 L
.31483 .69231 L
.31227 .66827 L
.31604 .64423 L
.32775 .62019 L
.33173 .61457 L
.35173 .59615 L
.35577 .59332 L
.37981 .58041 L
.403 .57212 L
F
0 g
.40385 .57188 m
.42788 .56633 L
.45192 .56268 L
.47596 .56058 L
.5 .5599 L
.52404 .56058 L
.54808 .56268 L
.57212 .56633 L
.59615 .57188 L
.597 .57212 L
.62019 .58041 L
.64423 .59332 L
.64827 .59615 L
.66827 .61457 L
.67225 .62019 L
.68396 .64423 L
.68773 .66827 L
.68517 .69231 L
.67683 .71635 L
.66827 .73228 L
.66245 .74038 L
.64423 .76106 L
.6406 .76442 L
.62019 .7804 L
.60729 .78846 L
.59615 .79429 L
.57212 .80425 L
.54808 .81106 L
.54486 .8125 L
.52404 .81495 L
.5 .81622 L
.47596 .81495 L
.45514 .8125 L
.45192 .81106 L
.42788 .80425 L
.40385 .79429 L
.39271 .78846 L
.37981 .7804 L
.3594 .76442 L
.35577 .76106 L
.33755 .74038 L
.33173 .73228 L
.32317 .71635 L
.31483 .69231 L
.31227 .66827 L
.31604 .64423 L
.32775 .62019 L
.33173 .61457 L
.35173 .59615 L
.35577 .59332 L
Mistroke
.37981 .58041 L
.403 .57212 L
.40385 .57188 L
Mfstroke
.6 g
.42788 .20952 m
.45192 .2022 L
.47596 .19795 L
.5 .19655 L
.52404 .19795 L
.54808 .2022 L
.57212 .20952 L
.57736 .21154 L
.59615 .22054 L
.61932 .23558 L
.62019 .23625 L
.64423 .25936 L
.64444 .25962 L
.66046 .28365 L
.66827 .29998 L
.66961 .30769 L
.67237 .33173 L
.66831 .35577 L
.66827 .35593 L
.65537 .37981 L
.64423 .39228 L
.62827 .40385 L
.62019 .40856 L
.59615 .41899 L
.57212 .42583 L
.56274 .42788 L
.54808 .43011 L
.52404 .43247 L
.5 .43323 L
.47596 .43247 L
.45192 .43011 L
.43726 .42788 L
.42788 .42583 L
.40385 .41899 L
.37981 .40856 L
.37173 .40385 L
.35577 .39228 L
.34463 .37981 L
.33173 .35593 L
.33169 .35577 L
.32763 .33173 L
.33039 .30769 L
.33173 .29998 L
.33954 .28365 L
.35556 .25962 L
.35577 .25936 L
.37981 .23625 L
.38068 .23558 L
.40385 .22054 L
.42264 .21154 L
F
0 g
.42788 .20952 m
.45192 .2022 L
.47596 .19795 L
.5 .19655 L
.52404 .19795 L
.54808 .2022 L
.57212 .20952 L
.57736 .21154 L
.59615 .22054 L
.61932 .23558 L
.62019 .23625 L
.64423 .25936 L
.64444 .25962 L
.66046 .28365 L
.66827 .29998 L
.66961 .30769 L
.67237 .33173 L
.66831 .35577 L
.66827 .35593 L
.65537 .37981 L
.64423 .39228 L
.62827 .40385 L
.62019 .40856 L
.59615 .41899 L
.57212 .42583 L
.56274 .42788 L
.54808 .43011 L
.52404 .43247 L
.5 .43323 L
.47596 .43247 L
.45192 .43011 L
.43726 .42788 L
.42788 .42583 L
.40385 .41899 L
.37981 .40856 L
.37173 .40385 L
.35577 .39228 L
.34463 .37981 L
.33173 .35593 L
.33169 .35577 L
.32763 .33173 L
.33039 .30769 L
.33173 .29998 L
.33954 .28365 L
.35556 .25962 L
.35577 .25936 L
.37981 .23625 L
.38068 .23558 L
.40385 .22054 L
.42264 .21154 L
Mistroke
.42788 .20952 L
Mfstroke
.6 g
.45192 .56989 m
.47596 .56753 L
.5 .56677 L
.52404 .56753 L
.54808 .56989 L
.56274 .57212 L
.57212 .57417 L
.59615 .58101 L
.62019 .59144 L
.62827 .59615 L
.64423 .60772 L
.65537 .62019 L
.66827 .64407 L
.66831 .64423 L
.67237 .66827 L
.66961 .69231 L
.66827 .70002 L
.66046 .71635 L
.64444 .74038 L
.64423 .74064 L
.62019 .76375 L
.61932 .76442 L
.59615 .77946 L
.57736 .78846 L
.57212 .79048 L
.54808 .7978 L
.52404 .80205 L
.5 .80345 L
.47596 .80205 L
.45192 .7978 L
.42788 .79048 L
.42264 .78846 L
.40385 .77946 L
.38068 .76442 L
.37981 .76375 L
.35577 .74064 L
.35556 .74038 L
.33954 .71635 L
.33173 .70002 L
.33039 .69231 L
.32763 .66827 L
.33169 .64423 L
.33173 .64407 L
.34463 .62019 L
.35577 .60772 L
.37173 .59615 L
.37981 .59144 L
.40385 .58101 L
.42788 .57417 L
.43726 .57212 L
F
0 g
.45192 .56989 m
.47596 .56753 L
.5 .56677 L
.52404 .56753 L
.54808 .56989 L
.56274 .57212 L
.57212 .57417 L
.59615 .58101 L
.62019 .59144 L
.62827 .59615 L
.64423 .60772 L
.65537 .62019 L
.66827 .64407 L
.66831 .64423 L
.67237 .66827 L
.66961 .69231 L
.66827 .70002 L
.66046 .71635 L
.64444 .74038 L
.64423 .74064 L
.62019 .76375 L
.61932 .76442 L
.59615 .77946 L
.57736 .78846 L
.57212 .79048 L
.54808 .7978 L
.52404 .80205 L
.5 .80345 L
.47596 .80205 L
.45192 .7978 L
.42788 .79048 L
.42264 .78846 L
.40385 .77946 L
.38068 .76442 L
.37981 .76375 L
.35577 .74064 L
.35556 .74038 L
.33954 .71635 L
.33173 .70002 L
.33039 .69231 L
.32763 .66827 L
.33169 .64423 L
.33173 .64407 L
.34463 .62019 L
.35577 .60772 L
.37173 .59615 L
.37981 .59144 L
.40385 .58101 L
.42788 .57417 L
.43726 .57212 L
Mistroke
.45192 .56989 L
Mfstroke
.7 g
.47596 .20957 m
.5 .20808 L
.52404 .20957 L
.54091 .21154 L
.54808 .21418 L
.57212 .22225 L
.59615 .23446 L
.59796 .23558 L
.62019 .2525 L
.62736 .25962 L
.64423 .28172 L
.6453 .28365 L
.65531 .30769 L
.65834 .33173 L
.65388 .35577 L
.64423 .37691 L
.63966 .37981 L
.62019 .39729 L
.60872 .40385 L
.59615 .40979 L
.57212 .4179 L
.54808 .42298 L
.52404 .4258 L
.5 .42671 L
.47596 .4258 L
.45192 .42298 L
.42788 .4179 L
.40385 .40979 L
.39128 .40385 L
.37981 .39729 L
.36034 .37981 L
.35577 .37691 L
.34612 .35577 L
.34166 .33173 L
.34469 .30769 L
.3547 .28365 L
.35577 .28172 L
.37264 .25962 L
.37981 .2525 L
.40204 .23558 L
.40385 .23446 L
.42788 .22225 L
.45192 .21418 L
.45909 .21154 L
F
0 g
.47596 .20957 m
.5 .20808 L
.52404 .20957 L
.54091 .21154 L
.54808 .21418 L
.57212 .22225 L
.59615 .23446 L
.59796 .23558 L
.62019 .2525 L
.62736 .25962 L
.64423 .28172 L
.6453 .28365 L
.65531 .30769 L
.65834 .33173 L
.65388 .35577 L
.64423 .37691 L
.63966 .37981 L
.62019 .39729 L
.60872 .40385 L
.59615 .40979 L
.57212 .4179 L
.54808 .42298 L
.52404 .4258 L
.5 .42671 L
.47596 .4258 L
.45192 .42298 L
.42788 .4179 L
.40385 .40979 L
.39128 .40385 L
.37981 .39729 L
.36034 .37981 L
.35577 .37691 L
.34612 .35577 L
.34166 .33173 L
.34469 .30769 L
.3547 .28365 L
.35577 .28172 L
.37264 .25962 L
.37981 .2525 L
.40204 .23558 L
.40385 .23446 L
.42788 .22225 L
.45192 .21418 L
.45909 .21154 L
.47596 .20957 L
s
.7 g
.40385 .59021 m
.42788 .5821 L
.45192 .57702 L
.47596 .5742 L
.5 .57329 L
.52404 .5742 L
.54808 .57702 L
.57212 .5821 L
.59615 .59021 L
.60872 .59615 L
.62019 .60271 L
.63966 .62019 L
.64423 .62309 L
.65388 .64423 L
.65834 .66827 L
.65531 .69231 L
.6453 .71635 L
.64423 .71828 L
.62736 .74038 L
.62019 .7475 L
.59796 .76442 L
.59615 .76554 L
.57212 .77775 L
.54808 .78582 L
.54091 .78846 L
.52404 .79043 L
.5 .79192 L
.47596 .79043 L
.45909 .78846 L
.45192 .78582 L
.42788 .77775 L
.40385 .76554 L
.40204 .76442 L
.37981 .7475 L
.37264 .74038 L
.35577 .71828 L
.3547 .71635 L
.34469 .69231 L
.34166 .66827 L
.34612 .64423 L
.35577 .62309 L
.36034 .62019 L
.37981 .60271 L
.39128 .59615 L
F
0 g
.40385 .59021 m
.42788 .5821 L
.45192 .57702 L
.47596 .5742 L
.5 .57329 L
.52404 .5742 L
.54808 .57702 L
.57212 .5821 L
.59615 .59021 L
.60872 .59615 L
.62019 .60271 L
.63966 .62019 L
.64423 .62309 L
.65388 .64423 L
.65834 .66827 L
.65531 .69231 L
.6453 .71635 L
.64423 .71828 L
.62736 .74038 L
.62019 .7475 L
.59796 .76442 L
.59615 .76554 L
.57212 .77775 L
.54808 .78582 L
.54091 .78846 L
.52404 .79043 L
.5 .79192 L
.47596 .79043 L
.45909 .78846 L
.45192 .78582 L
.42788 .77775 L
.40385 .76554 L
.40204 .76442 L
.37981 .7475 L
.37264 .74038 L
.35577 .71828 L
.3547 .71635 L
.34469 .69231 L
.34166 .66827 L
.34612 .64423 L
.35577 .62309 L
.36034 .62019 L
.37981 .60271 L
.39128 .59615 L
.40385 .59021 L
s
.8 g
.42788 .23431 m
.45192 .22548 L
.47596 .22046 L
.5 .21883 L
.52404 .22046 L
.54808 .22548 L
.57212 .23431 L
.57485 .23558 L
.59615 .248 L
.61059 .25962 L
.62019 .26913 L
.63082 .28365 L
.64188 .30769 L
.64423 .31808 L
.6452 .33173 L
.64423 .34161 L
.64031 .35577 L
.62453 .37981 L
.62019 .38425 L
.59615 .40043 L
.5885 .40385 L
.57212 .4099 L
.54808 .41581 L
.52404 .41904 L
.5 .42008 L
.47596 .41904 L
.45192 .41581 L
.42788 .4099 L
.4115 .40385 L
.40385 .40043 L
.37981 .38425 L
.37547 .37981 L
.35969 .35577 L
.35577 .34161 L
.3548 .33173 L
.35577 .31808 L
.35812 .30769 L
.36918 .28365 L
.37981 .26913 L
.38941 .25962 L
.40385 .248 L
.42515 .23558 L
F
0 g
.42788 .23431 m
.45192 .22548 L
.47596 .22046 L
.5 .21883 L
.52404 .22046 L
.54808 .22548 L
.57212 .23431 L
.57485 .23558 L
.59615 .248 L
.61059 .25962 L
.62019 .26913 L
.63082 .28365 L
.64188 .30769 L
.64423 .31808 L
.6452 .33173 L
.64423 .34161 L
.64031 .35577 L
.62453 .37981 L
.62019 .38425 L
.59615 .40043 L
.5885 .40385 L
.57212 .4099 L
.54808 .41581 L
.52404 .41904 L
.5 .42008 L
.47596 .41904 L
.45192 .41581 L
.42788 .4099 L
.4115 .40385 L
.40385 .40043 L
.37981 .38425 L
.37547 .37981 L
.35969 .35577 L
.35577 .34161 L
.3548 .33173 L
.35577 .31808 L
.35812 .30769 L
.36918 .28365 L
.37981 .26913 L
.38941 .25962 L
.40385 .248 L
.42515 .23558 L
.42788 .23431 L
s
.8 g
.42788 .5901 m
.45192 .58419 L
.47596 .58096 L
.5 .57992 L
.52404 .58096 L
.54808 .58419 L
.57212 .5901 L
.5885 .59615 L
.59615 .59957 L
.62019 .61575 L
.62453 .62019 L
.64031 .64423 L
.64423 .65839 L
.6452 .66827 L
.64423 .68192 L
.64188 .69231 L
.63082 .71635 L
.62019 .73087 L
.61059 .74038 L
.59615 .752 L
.57485 .76442 L
.57212 .76569 L
.54808 .77452 L
.52404 .77954 L
.5 .78117 L
.47596 .77954 L
.45192 .77452 L
.42788 .76569 L
.42515 .76442 L
.40385 .752 L
.38941 .74038 L
.37981 .73087 L
.36918 .71635 L
.35812 .69231 L
.35577 .68192 L
.3548 .66827 L
.35577 .65839 L
.35969 .64423 L
.37547 .62019 L
.37981 .61575 L
.40385 .59957 L
.4115 .59615 L
F
0 g
.42788 .5901 m
.45192 .58419 L
.47596 .58096 L
.5 .57992 L
.52404 .58096 L
.54808 .58419 L
.57212 .5901 L
.5885 .59615 L
.59615 .59957 L
.62019 .61575 L
.62453 .62019 L
.64031 .64423 L
.64423 .65839 L
.6452 .66827 L
.64423 .68192 L
.64188 .69231 L
.63082 .71635 L
.62019 .73087 L
.61059 .74038 L
.59615 .752 L
.57485 .76442 L
.57212 .76569 L
.54808 .77452 L
.52404 .77954 L
.5 .78117 L
.47596 .77954 L
.45192 .77452 L
.42788 .76569 L
.42515 .76442 L
.40385 .752 L
.38941 .74038 L
.37981 .73087 L
.36918 .71635 L
.35812 .69231 L
.35577 .68192 L
.3548 .66827 L
.35577 .65839 L
.35969 .64423 L
.37547 .62019 L
.37981 .61575 L
.40385 .59957 L
.4115 .59615 L
.42788 .5901 L
s
.9 g
.47596 .23084 m
.5 .22907 L
.52404 .23084 L
.54733 .23558 L
.54808 .23631 L
.57212 .24608 L
.59338 .25962 L
.59615 .26176 L
.61664 .28365 L
.62019 .28566 L
.62891 .30769 L
.63255 .33173 L
.62718 .35577 L
.62019 .37172 L
.60956 .37981 L
.59615 .39036 L
.57212 .40174 L
.56599 .40385 L
.54808 .40852 L
.52404 .41226 L
.5 .41344 L
.47596 .41226 L
.45192 .40852 L
.43401 .40385 L
.42788 .40174 L
.40385 .39036 L
.39044 .37981 L
.37981 .37172 L
.37282 .35577 L
.36745 .33173 L
.37109 .30769 L
.37981 .28566 L
.38336 .28365 L
.40385 .26176 L
.40662 .25962 L
.42788 .24608 L
.45192 .23631 L
.45267 .23558 L
F
0 g
.47596 .23084 m
.5 .22907 L
.52404 .23084 L
.54733 .23558 L
.54808 .23631 L
.57212 .24608 L
.59338 .25962 L
.59615 .26176 L
.61664 .28365 L
.62019 .28566 L
.62891 .30769 L
.63255 .33173 L
.62718 .35577 L
.62019 .37172 L
.60956 .37981 L
.59615 .39036 L
.57212 .40174 L
.56599 .40385 L
.54808 .40852 L
.52404 .41226 L
.5 .41344 L
.47596 .41226 L
.45192 .40852 L
.43401 .40385 L
.42788 .40174 L
.40385 .39036 L
.39044 .37981 L
.37981 .37172 L
.37282 .35577 L
.36745 .33173 L
.37109 .30769 L
.37981 .28566 L
.38336 .28365 L
.40385 .26176 L
.40662 .25962 L
.42788 .24608 L
.45192 .23631 L
.45267 .23558 L
.47596 .23084 L
s
.9 g
.45192 .59148 m
.47596 .58774 L
.5 .58656 L
.52404 .58774 L
.54808 .59148 L
.56599 .59615 L
.57212 .59826 L
.59615 .60964 L
.60956 .62019 L
.62019 .62828 L
.62718 .64423 L
.63255 .66827 L
.62891 .69231 L
.62019 .71434 L
.61664 .71635 L
.59615 .73824 L
.59338 .74038 L
.57212 .75392 L
.54808 .76369 L
.54733 .76442 L
.52404 .76916 L
.5 .77093 L
.47596 .76916 L
.45267 .76442 L
.45192 .76369 L
.42788 .75392 L
.40662 .74038 L
.40385 .73824 L
.38336 .71635 L
.37981 .71434 L
.37109 .69231 L
.36745 .66827 L
.37282 .64423 L
.37981 .62828 L
.39044 .62019 L
.40385 .60964 L
.42788 .59826 L
.43401 .59615 L
F
0 g
.45192 .59148 m
.47596 .58774 L
.5 .58656 L
.52404 .58774 L
.54808 .59148 L
.56599 .59615 L
.57212 .59826 L
.59615 .60964 L
.60956 .62019 L
.62019 .62828 L
.62718 .64423 L
.63255 .66827 L
.62891 .69231 L
.62019 .71434 L
.61664 .71635 L
.59615 .73824 L
.59338 .74038 L
.57212 .75392 L
.54808 .76369 L
.54733 .76442 L
.52404 .76916 L
.5 .77093 L
.47596 .76916 L
.45267 .76442 L
.45192 .76369 L
.42788 .75392 L
.40662 .74038 L
.40385 .73824 L
.38336 .71635 L
.37981 .71434 L
.37109 .69231 L
.36745 .66827 L
.37282 .64423 L
.37981 .62828 L
.39044 .62019 L
.40385 .60964 L
.42788 .59826 L
.43401 .59615 L
.45192 .59148 L
s
1 g
.42788 .25803 m
.45192 .24695 L
.47596 .24091 L
.5 .23898 L
.52404 .24091 L
.54808 .24695 L
.57212 .25803 L
.57475 .25962 L
.59615 .27641 L
.60236 .28365 L
.61616 .30769 L
.62017 .33173 L
.61424 .35577 L
.59615 .37918 L
.59419 .37981 L
.57212 .39327 L
.54808 .40115 L
.53843 .40385 L
.52404 .40529 L
.5 .40665 L
.47596 .40529 L
.46157 .40385 L
.45192 .40115 L
.42788 .39327 L
.40581 .37981 L
.40385 .37918 L
.38576 .35577 L
.37983 .33173 L
.38384 .30769 L
.39764 .28365 L
.40385 .27641 L
.42525 .25962 L
F
0 g
.42788 .25803 m
.45192 .24695 L
.47596 .24091 L
.5 .23898 L
.52404 .24091 L
.54808 .24695 L
.57212 .25803 L
.57475 .25962 L
.59615 .27641 L
.60236 .28365 L
.61616 .30769 L
.62017 .33173 L
.61424 .35577 L
.59615 .37918 L
.59419 .37981 L
.57212 .39327 L
.54808 .40115 L
.53843 .40385 L
.52404 .40529 L
.5 .40665 L
.47596 .40529 L
.46157 .40385 L
.45192 .40115 L
.42788 .39327 L
.40581 .37981 L
.40385 .37918 L
.38576 .35577 L
.37983 .33173 L
.38384 .30769 L
.39764 .28365 L
.40385 .27641 L
.42525 .25962 L
.42788 .25803 L
s
1 g
.47596 .59471 m
.5 .59335 L
.52404 .59471 L
.53843 .59615 L
.54808 .59885 L
.57212 .60673 L
.59419 .62019 L
.59615 .62082 L
.61424 .64423 L
.62017 .66827 L
.61616 .69231 L
.60236 .71635 L
.59615 .72359 L
.57475 .74038 L
.57212 .74197 L
.54808 .75305 L
.52404 .75909 L
.5 .76102 L
.47596 .75909 L
.45192 .75305 L
.42788 .74197 L
.42525 .74038 L
.40385 .72359 L
.39764 .71635 L
.38384 .69231 L
.37983 .66827 L
.38576 .64423 L
.40385 .62082 L
.40581 .62019 L
.42788 .60673 L
.45192 .59885 L
.46157 .59615 L
F
0 g
.47596 .59471 m
.5 .59335 L
.52404 .59471 L
.53843 .59615 L
.54808 .59885 L
.57212 .60673 L
.59419 .62019 L
.59615 .62082 L
.61424 .64423 L
.62017 .66827 L
.61616 .69231 L
.60236 .71635 L
.59615 .72359 L
.57475 .74038 L
.57212 .74197 L
.54808 .75305 L
.52404 .75909 L
.5 .76102 L
.47596 .75909 L
.45192 .75305 L
.42788 .74197 L
.42525 .74038 L
.40385 .72359 L
.39764 .71635 L
.38384 .69231 L
.37983 .66827 L
.38576 .64423 L
.40385 .62082 L
.40581 .62019 L
.42788 .60673 L
.45192 .59885 L
.46157 .59615 L
.47596 .59471 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00C@3oool500000080oooo0P00000e0?ooo`@000000`3oool2000003L0oooo0P0000040?oo
o`800000=`3oool300000080oooo0P00000?0?ooo`00C`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000003D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000g0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0303oool004l0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0b
0?ooo`D0000000D0oooo0000003oool0oooo0000000>0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0380
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000>0?ooo`00C`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0<P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000003D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000e0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003P3oool0
04h0oooo0P0000040?ooo`800000=P3oool2000000@0oooo0P00000g0?ooo`800000103oool20000
03L0oooo0P0000030?ooo`8000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`000005000000L0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooon@00
00040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oo
ooT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080ooooL@00000H01TI6G00
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooofh00000
7P0I6AU]000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oomX000002X06ATII`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080ooooH`00000d01TI6F8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooof400000>00I6AUP000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooomO000003`06ATIGP0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080ooooG@00001001TI6E`000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooeX00000AP0I6AUI000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomG000004`06ATIEP000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooE@00000O01TI
6A8000007`0I6AUD000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooomD000001X06ATI1P00000B03<c<`H000006P0I6AUC000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomB000001P06ATI1000000N03<c<`D00000
5`0I6AUA000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oooe4000005P0I
6AT3000002L0<c<c0`00000E01TI6E000000103oool2000000L0oooo000E0?ooo`030000003oool0
oooo0080ooooC`00000D01TI6@@00000;@0c<c<3000001@06ATICP0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooCP00000C01TI6@800000=00c<c<20000
01<06ATIC@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
ooooC000000C01TI6@8000004`0c<c<B000001<0<c<c0P00000C01TI6D/000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oood/000004P0I6AT200000100<c<c
1@00000B04a<C0D00000400c<c<3000001406ATIBP0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080ooooB@00000B01TI6@8000003`0c<c<3000001`0C4a<0`00
000@03<c<`8000004@0I6AU8000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooom7000001806ATI0P00000=03<c<`@000008P1<C4`4000000h0<c<c0P00000A
01TI6DH000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
odH000004@0I6AT2000000d0<c<c0P00000Z04a<C08000003P0c<c<00`0000006ATI01TI6@0?01TI
6DD000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodH0
00003`0I6AT2000000`0<c<c0`00000>04a<C18000003P1<C4`3000000`0<c<c0P00000@01TI6D@0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodD00000
3`0I6AT00`000000<c<c03<c<`0:03<c<`8000002`1<C4`600000180IVIV1P00000;04a<C0800000
300c<c<00`0000006ATI01TI6@0>01TI6D<000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oood@000003P0I6AT2000000/0<c<c0P00000804a<C0D000007P1V
IVH5000000P0C4a<0P00000;03<c<`8000003`0I6AU2000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooom2000000l06ATI00<0000003<c<`0c<c<0200c<c<3
000000P0C4a<0P00000A06IVIPH000004@1VIVH2000000P0C4a<0`00000:03<c<`030000000I6AT0
6ATI00d06ATI@@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooom10000
00h06ATI0P00000903<c<`8000002@1<C4`2000000X0IVIV2@00000607moO`T000002P1VIVH20000
00T0C4a<0P00000903<c<`8000003P0I6AU0000000@0oooo0P0000070?ooo`005@3oool00`000000
oooo0?ooo`020?oood0000003P0I6AT00`000000<c<c03<c<`0703<c<`8000002@1<C4`2000000T0
IVIV0`00000H07moO`<000002@1VIVH2000000T0C4a<0P00000903<c<`030000000I6AT06ATI00`0
6ATI?`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
?`00000>01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`01`1<C4`2000000L0IVIV
1000000N07moO`@000001`1VIVH2000000T0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI
01TI6@0<01TI6Ch000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooch000003P0I6AT00`000000<c<c03<c<`0703<c<`030000001<C4`0C4a<00H0C4a<0P00
000706IVIP8000002P1oOglB000000X0Ogmo0P00000706IVIP800000201<C4`00`000000<c<c03<c
<`0703<c<`030000000I6AT06ATI00`06ATI?@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo?@00000>01TI6@030000000c<c<0<c<c00L0<c<c00<00000
04a<C01<C4`01@1<C4`2000000L0IVIV0P00000707moO`D000004P2IVIT5000000L0Ogmo0P000007
06IVIP8000001`1<C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00`06ATI?0000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo?@00000=01TI
6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`01@1<C4`00`000000IVIV06IVIP0506IV
IP8000001P1oOgl3000001`0VIVI0`00000607moO`8000001`1VIVH00`000000C4a<04a<C00504a<
C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02`0I6ATl000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oooll000000d06ATI00<0000003<c<`0c
<c<01`0c<c<00`000000C4a<04a<C00404a<C08000001P1VIVH2000000H0Ogmo0P00000909VIVA00
00002@2IVIT2000000H0Ogmo0P00000606IVIP8000001P1<C4`00`000000<c<c03<c<`0703<c<`03
0000000I6AT06ATI00/06ATI>`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo>`00000=01TI6@030000000c<c<0<c<c00H0<c<c0P00000604a<C0030000
001VIVH0IVIV00D0IVIV00<0000007moO`1oOgl0101oOgl2000000D0VIVI1P00000@0;>c/`H00000
1@2IVIT2000000H0Ogmo00<0000006IVIP1VIVH01@1VIVH00`000000C4a<04a<C00404a<C0800000
200c<c<00`0000006ATI01TI6@0;01TI6CX000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooocX000003@0I6AT00`000000<c<c03<c<`0603<c<`030000001<
C4`0C4a<00@0C4a<0P00000606IVIP8000001@1oOgl2000000@0VIVI0`00000;0;>c/`H000002`2c
/k<3000000@0VIVI0P00000507moO`8000001P1VIVH2000000H0C4a<00<0000003<c<`0c<c<01P0c
<c<00`0000006ATI01TI6@0;01TI6CT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooocX00000300I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0
C4a<00@0C4a<00<0000006IVIP1VIVH0101VIVH2000000D0Ogmo0P00000409VIV@800000202c/k<6
000000H0c<c<1P0000080;>c/`800000102IVIT2000000D0Ogmo0P00000606IVIP030000001<C4`0
C4a<00@0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0:01TI6CT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocT000003@0I6AT00`00
0000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH0101VIVH00`00
0000Ogmo07moO`0307moO`800000102IVIT2000000D0/k>c1@00000B0<c<c0D000001@2c/k<20000
00@0VIVI0P00000507moO`030000001VIVH0IVIV00@0IVIV00<0000004a<C01<C4`00`1<C4`00`00
0000<c<c03<c<`0703<c<`030000000I6AT06ATI00X06ATI>00000050?ooo`030000003oool0oooo
00D0oooo00070?ooo`D000000P3oool2000000D0oooo00<000000?ooo`3oool00P3ooolh000000d0
6ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00<0
IVIV0P00000507moO`030000002IVIT0VIVI0080VIVI0P0000040;>c/`<000002`3<c<`6000000/0
c<c<0`0000040;>c/`800000102IVIT00`000000Ogmo07moO`0307moO`8000001@1VIVH00`000000
C4a<04a<C00304a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02P0I6ATg000000D0
oooo00<000000?ooo`3oool01@3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooolh000000`06ATI00<0000003<c<`0c
<c<01P0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1o
Ogl00`1oOgl2000000<0VIVI0P0000040;>c/`800000203<c<`6000000H0i^KV1P0000080<c<c080
0000102c/k<2000000<0VIVI0P00000507moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<
C4`00`1<C4`00`000000<c<c03<c<`0603<c<`030000000I6AT06ATI00X06ATI=`0000050?ooo`03
0000003oool0oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`020?ooo`<000000P3ooolg000000`06ATI00<0000003<c<`0c<c<01P0c<c<00`000000
C4a<04a<C00304a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00P1oOgl2000000@0
VIVI00<000000;>c/`2c/k<00`2c/k<00`000000c<c<0<c<c0030<c<c0D000004P3Vi^H5000000D0
c<c<00<000000;>c/`2c/k<00`2c/k<00`000000VIVI09VIV@0209VIV@800000101oOgl00`000000
IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01P0c<c<00`000000
6ATI01TI6@0:01TI6CH000000`3oool3000000L0oooo00090?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo=P00000<01TI6@03
0000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP03
0000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00P2IVIT2000000@0/k>c0P0000030<c<c0<0
00001P3Vi^H@000000H0i^KV0`0000030<c<c0800000102c/k<2000000@0VIVI00<0000007moO`1o
Ogl00P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c
<c<01@0c<c<00`0000006ATI01TI6@0:01TI6CH000001@3oool00`000000oooo0?ooo`050?ooo`00
2@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?ooocH00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0
C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI0080
VIVI00<000000;>c/`2c/k<00P2c/k<2000000<0c<c<0P0000060>KViP<00000403oool3000000H0
i^KV0P0000030<c<c0800000102c/k<00`000000VIVI09VIV@0209VIV@030000001oOgl0Ogmo0080
Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0
<c<c00<0000001TI6@0I6AT02P0I6ATe000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo
0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`020?ooocD00000300I6AT00`000000<c<c
03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo
07moO`0207moO`040000002IVIT0VIVI09VIV@800000102c/k<010000000c<c<0<c<c03<c<`20000
00H0i^KV0P00000F0?ooo`8000001P3Vi^H2000000<0c<c<00<000000;>c/`2c/k<00P2c/k<20000
00<0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<
00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0:01TI6CD000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocD00000300I6AT00`000000
<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000
Ogmo07moO`0207moO`050000002IVIT0VIVI09VIV@0000001@2c/k<01@000000c<c<0<c<c03<c<`0
000000H0i^KV0P00000J0?ooo`8000001P3Vi^H01@000000c<c<0<c<c03<c<`0000000D0/k>c00D0
000009VIV@2IVIT0VIVI0000000407moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0
0`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI=00000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=000000<01TI6@030000000c
<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001o
Ogl0Ogmo0080Ogmo00D0000009VIV@2IVIT0VIVI000000040;>c/`8000000P3<c<`2000000D0i^KV
0P00000N0?ooo`8000001@3Vi^H200000080c<c<0P0000040;>c/`050000002IVIT0VIVI09VIV@00
0000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c
<c<0100c<c<00`0000006ATI01TI6@0:01TI6C@000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooc@00000300I6AT00`000000<c<c03<c<`0403<c<`030000
001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000
002IVIT0VIVI0080VIVI00D000000;>c/`2c/k<0/k>c000000030<c<c0030000003Vi^H0i^KV0080
i^KV0`00000R0?ooo`<00000103Vi^H01@000000c<c<0<c<c03<c<`0000000@0/k>c00D0000009VI
V@2IVIT0VIVI0000000407moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`0
0`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00X06ATI<`0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=000000;01TI6@030000000c<c<0<c<c
00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo
0080Ogmo00<0000009VIV@2IVIT00P2IVIT00`000000/k>c0;>c/`02000000@0c<c<00D000000>KV
iP3Vi^H0i^KV0000000X0?ooo`050000003Vi^H0i^KV0>KViP000000103<c<`2000000<0/k>c00D0
000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0
0`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI<`0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<`00000<01TI6@030000000c
<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001o
Ogl0Ogmo0080Ogmo00D0000009VIV@2IVIT0VIVI000000020;>c/`030000003<c<`0c<c<00<0c<c<
00<000000>KViP3Vi^H00P00000Z0?ooo`8000000P3Vi^H00`000000c<c<0<c<c0030<c<c0040000
002c/k<0/k>c000000<0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP03
0000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6C<0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc<00000
2`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH0
0P1VIVH00`000000Ogmo07moO`0207moO`050000002IVIT0VIVI09VIV@0000000P2c/k<00`000000
c<c<0<c<c0030<c<c0040000003Vi^H0i^KV000002h0oooo00@000000>KViP3Vi^H00000103<c<`0
1@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000
001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6C800000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc<000002`0I
6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1V
IVH01@000000Ogmo07moO`1oOgl0000000@0VIVI00@000000;>c/`2c/k<000000`3<c<`200000080
i^KV00<000000?ooo`3oool0;P3oool00`000000i^KV0>KViP02000000<0c<c<00D000000;>c/`2c
/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C003
04a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATb000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolb000000/06ATI00<0000003<c
<`0c<c<01@0c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00<0000007mo
O`1oOgl00P1oOgl01@000000VIVI09VIV@2IVIT000000080/k>c00D000000<c<c03<c<`0c<c<0000
00030>KViP030000003oool0oooo0300oooo00D000000>KViP3Vi^H0i^KV000000020<c<c0050000
002c/k<0/k>c0;>c/`0000000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<
C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI<P0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolb000000/06ATI00<0000003<c<`0c
<c<0100c<c<2000000@0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl00000
00<0VIVI00D000000;>c/`2c/k<0/k>c000000020<c<c0050000003Vi^H0i^KV0>KViP000000=03o
ool01@000000i^KV0>KViP3Vi^H000000080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@05
0000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT02@0I6ATa000000@0oooo0P0000070?ooo`005@3oool00`000000
oooo0?ooo`020?oooc8000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0
C4a<00<0000006IVIP1VIVH00P1VIVH010000000Ogmo07moO`00000309VIV@050000002c/k<0/k>c
0;>c/`0000000P3<c<`01@000000i^KV0>KViP3Vi^H0000003H0oooo00L000000>KViP3Vi^H0i^KV
0000003<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV
0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00T06ATI<@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo<P00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0
00000080c<c<00D000000>KViP3Vi^H0i^KV0000000f0?ooo`050000003Vi^H0i^KV0>KViP000000
0P3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IV
IP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI
6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc40
00002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1V
IVH00P1VIVH010000000Ogmo07moO`00000309VIV@050000002c/k<0/k>c0;>c/`0000000P3<c<`0
1@000000i^KV0>KViP3Vi^H0000003P0oooo00L000000>KViP3Vi^H0i^KV0000003<c<`0000000<0
/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<
C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI<@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<@00000;01TI6@03
0000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP04
0000001oOgl0Ogmo000000<0VIVI00D000000;>c/`2c/k<0/k>c000000020<c<c0040000003Vi^H0
i^KV000003X0oooo00@000000>KViP3Vi^H000000P3<c<`01@000000/k>c0;>c/`2c/k<0000000<0
VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6C0000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooc4000002P0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl00000
0080VIVI00D000000;>c/`2c/k<0/k>c000000020<c<c0050000003Vi^H0i^KV0>KViP000000>P3o
ool01`000000i^KV0>KViP3Vi^H000000<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT00000
00<0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT0200I6AT`000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooola000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`000000
C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000209VI
V@050000002c/k<0/k>c0;>c/`0000000P3<c<`010000000i^KV0>KViP00000l0?ooo`040000003V
i^H0i^KV00000080c<c<00D000000;>c/`2c/k<0/k>c0000000209VIV@030000001oOgl0Ogmo0080
Ogmo00D0000006IVIP1VIVH0IVIV0000000504a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI
6@0I6AT0200I6AT`000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooola000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00204a<C003
0000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000209VIV@050000002c/k<0/k>c
0;>c/`0000000P3<c<`010000000i^KV0>KViP00000l0?ooo`040000003Vi^H0i^KV00000080c<c<
00D000000;>c/`2c/k<0/k>c0000000209VIV@030000001oOgl0Ogmo0080Ogmo00D0000006IVIP1V
IVH0IVIV0000000504a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6AT`0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooola000000X0
6ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080
IVIV00D0000007moO`1oOgl0Ogmo0000000209VIV@040000002c/k<0/k>c000000<0c<c<00@00000
0>KViP3Vi^H00000?03oool010000000i^KV0>KViP0000030<c<c0040000002c/k<0/k>c00000080
VIVI00<0000007moO`1oOgl00P1oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6C0000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooc4000002P0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl00000
0080VIVI00@000000;>c/`2c/k<000000`3<c<`010000000i^KV0>KViP00000l0?ooo`040000003V
i^H0i^KV000000<0c<c<00@000000;>c/`2c/k<000000P2IVIT00`000000Ogmo07moO`0207moO`05
0000001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00P06ATI<00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo<000000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT010000000/k>c0;>c/`000002
0<c<c0040000003Vi^H0i^KV000003h0oooo00@000000>KViP3Vi^H000000P3<c<`01@000000/k>c
0;>c/`2c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<
0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6Bl000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc0000002`0I6AT00`000000
<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000
Ogmo07moO`1oOgl0000000<0VIVI00@000000;>c/`2c/k<000000P3<c<`010000000i^KV0>KViP00
000n0?ooo`040000003Vi^H0i^KV00000080c<c<00D000000;>c/`2c/k<0/k>c0000000209VIV@05
0000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT02@0I6AT_000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3oool`000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VI
V@040000002c/k<0/k>c00000080c<c<00@000000>KViP3Vi^H00000?P3oool010000000i^KV0>KV
iP0000020<c<c0050000002c/k<0/k>c0;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl00000
00@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00T06ATI;`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3oool`000000/0
6ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080
IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@040000002c/k<0/k>c00000080c<c<00@00000
0>KViP3Vi^H00000?P3oool010000000i^KV0>KViP0000020<c<c0050000002c/k<0/k>c0;>c/`00
00000P2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI;`0000040?ooo`8000001`3oool001D0
oooo00<000000?ooo`3oool00P3oool`000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VI
V@040000002c/k<0/k>c00000080c<c<00@000000>KViP3Vi^H00000?P3oool010000000i^KV0>KV
iP0000020<c<c0050000002c/k<0/k>c0;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl00000
00@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00T06ATI;`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo<000000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT010000000/k>c0;>c/`000003
0<c<c0040000003Vi^H0i^KV000003`0oooo00@000000>KViP3Vi^H000000`3<c<`010000000/k>c
0;>c/`00000309VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<
C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT_000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool`000000/06ATI00<0000003<c<`0c
<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1o
Ogl0Ogmo0000000309VIV@040000002c/k<0/k>c000000<0c<c<00@000000>KViP3Vi^H00000?03o
ool010000000i^KV0>KViP0000030<c<c0040000002c/k<0/k>c00000080VIVI00D0000007moO`1o
Ogl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0901TI6C0000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooc4000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080
C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c
/`0000000`3<c<`010000000i^KV0>KViP00000l0?ooo`040000003Vi^H0i^KV00000080c<c<00D0
00000;>c/`2c/k<0/k>c0000000209VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000
C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT`000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooola000000/06ATI
00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV
00D0000007moO`1oOgl0Ogmo0000000309VIV@040000002c/k<0/k>c000000<0c<c<00@000000>KV
iP3Vi^H00000>P3oool010000000i^KV0>KViP0000030<c<c0040000002c/k<0/k>c000000<0VIVI
00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c
<c<0100c<c<00`0000006ATI01TI6@0901TI6C0000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooc4000002`0I6AT00`000000<c<c03<c<`0403<c<`030000
001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0
VIVI00@000000;>c/`2c/k<000000`3<c<`010000000i^KV0>KViP00000j0?ooo`040000003Vi^H0
i^KV000000<0c<c<00@000000;>c/`2c/k<000000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0
IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T0
6ATI<00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
<@00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV
06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<00000
0080c<c<00D000000>KViP3Vi^H0i^KV0000000h0?ooo`050000003Vi^H0i^KV0>KViP0000000P3<
c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP03
0000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6C00
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc800000
2`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH0
0P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00@000000;>c/`2c/k<000000P3<c<`00`00
0000i^KV0>KViP020>KViP030000003oool0oooo03@0oooo00D000000>KViP3Vi^H0i^KV00000003
0<c<c0040000002c/k<0/k>c000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000
001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0901TI6C400000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc8000002`0I
6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1V
IVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00D000000;>c/`2c/k<0/k>c000000020<c<c005
0000003Vi^H0i^KV0>KViP000000=@3oool00`000000i^KV0>KViP020>KViP040000003<c<`0c<c<
000000<0/k>c00@0000009VIV@2IVIT000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<
C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6C4000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc8000002`0I6AT0
0`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH0
1@000000Ogmo07moO`1oOgl0000000<0VIVI00L000000;>c/`2c/k<0/k>c0000003<c<`0000000@0
i^KV00<000000?ooo`3oool0<P3oool00`000000i^KV0>KViP020>KViP030000003<c<`0000000<0
/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<
C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<`00000;01TI6@03
0000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP05
0000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<000000080c<c<0P000003
0>KViP030000003oool0oooo0300oooo00@000000>KViP3Vi^H0i^KV0P0000020<c<c0050000002c
/k<0/k>c0;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<
C4`0101<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00T06ATI<P0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolc000000/06ATI00<0000003<c<`0c<c<0
100c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0
Ogmo0000000309VIV@050000002c/k<0/k>c0;>c/`0000000`3<c<`01@000000i^KV0>KViP3Vi^H0
00000300oooo00D000000>KViP3Vi^H0i^KV000000030<c<c0050000002c/k<0/k>c0;>c/`000000
0`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00`1<C4`00`000000
<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<P0000040?ooo`8000001`3oool001D0oooo
00<000000?ooo`3oool00P3ooolc000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<
04a<C00304a<C0050000001VIVH0IVIV06IVIP000000101oOgl01@000000VIVI09VIV@2IVIT00000
00<0/k>c00D000000<c<c03<c<`0c<c<000000030>KViP800000;03oool2000000<0i^KV00D00000
0<c<c03<c<`0c<c<000000030;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`000000IVIV
06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI
01TI6@0801TI6C<000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooc@000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00D0
000006IVIP1VIVH0IVIV0000000407moO`050000002IVIT0VIVI09VIV@0000000`2c/k<200000080
c<c<0P0000030>KViP030000003oool0oooo02P0oooo00@000000>KViP3Vi^H0i^KV0P0000020<c<
c08000000`2c/k<01@000000VIVI09VIV@2IVIT0000000@0Ogmo00D0000006IVIP1VIVH0IVIV0000
000504a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATc000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooold000000`06ATI00<00000
03<c<`0c<c<0100c<c<00`000000C4a<04a<C00404a<C0050000001VIVH0IVIV06IVIP000000101o
Ogl01@000000VIVI09VIV@2IVIT0000000@0/k>c0P0000020<c<c0040000003Vi^H0i^KV0>KViP80
00009P3oool2000000<0i^KV00<000000<c<c03<c<`00P0000040;>c/`050000002IVIT0VIVI09VI
V@000000101oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<01@0c<c<0
0`0000006ATI01TI6@0901TI6C@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooocD000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<
00@0C4a<00@0000006IVIP1VIVH0IVIV0P00000307moO`050000002IVIT0VIVI09VIV@0000001@2c
/k<2000000030<c<c0000000000000<0i^KV0P00000R0?ooo`8000000`3Vi^H2000000030<c<c000
0000000000D0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`800000101VIVH00`000000C4a<
04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATd000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooole000000`06ATI00<0
000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV0080IVIV00@0
000007moO`1oOgl0Ogmo0P00000209VIV@8000001@2c/k<00`000000c<c<0<c<c002000000<0i^KV
0`00000L0?ooo`<000000`3Vi^H200000080c<c<00<000000;>c/`2c/k<00`2c/k<200000080VIVI
0P00000307moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c
03<c<`0503<c<`030000000I6AT06ATI00T06ATI=@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo=P00000<01TI6@030000000c<c<0<c<c00D0<c<c00<0
000004a<C01<C4`0101<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00@0
000009VIV@2IVIT0VIVI0P0000040;>c/`8000000P3<c<`400000080i^KV1P00000A0?ooo`D00000
0P3Vi^H400000080c<c<0P0000040;>c/`8000000`2IVIT00`000000Ogmo07moO`0207moO`030000
001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000
000I6AT06ATI00X06ATI=@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo=`00000<01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<
C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00P2I
VIT2000000@0/k>c0P0000040<c<c08000001P3Vi^HA000000D0i^KV0P0000040<c<c0800000102c
/k<2000000@0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0306IVIP030000001<
C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0:01TI6CH000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocL000003@0I6AT0
0`000000<c<c03<c<`0503<c<`800000101<C4`2000000@0IVIV0P00000307moO`800000102IVIT3
000000<0/k>c100000020<c<c0/000001`3Vi^H:00000080c<c<100000030;>c/`<00000102IVIT2
000000<0Ogmo0P00000406IVIP800000101<C4`2000000P0<c<c00<0000001TI6@0I6AT02@0I6ATg
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolh0000
00d06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV
00<0IVIV0P00000307moO`@000000`2IVIT3000000@0/k>c1P0000070<c<c0L000001P3<c<`60000
00@0/k>c0`00000309VIV@@000000`1oOgl2000000D0IVIV00<0000004a<C01<C4`00`1<C4`00`00
0000<c<c03<c<`0703<c<`030000000I6AT06ATI00X06ATI=`0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo>@00000=01TI6@030000000c<c<0<c<c00H0
<c<c0P00000404a<C08000001@1VIVH2000000D0Ogmo0`00000309VIV@@000001P2c/k<7000000L0
c<c<1P0000060;>c/`@000000`2IVIT3000000D0Ogmo0P00000506IVIP800000101<C4`2000000P0
<c<c0P00000<01TI6CP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooocX000003@0I6AT2000000P0<c<c00<0000004a<C01<C4`00`1<C4`2000000D0IVIV
0P00000607moO`<00000102IVIT6000000L0/k>c1`0000060;>c/`H00000102IVIT3000000H0Ogmo
0P00000606IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI
01TI6@0;01TI6CT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooc`000003@0I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00@0C4a<0P00
000506IVIP8000001`1oOgl2000000P0VIVI5000000809VIV@8000001`1oOgl2000000H0IVIV0P00
000504a<C0030000000c<c<0<c<c00H0<c<c0P00000=01TI6CX000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool2000000<0oooo?@00000=01TI6@8000001`0c<c<2000000H0C4a<10000003
06IVIPD00000101oOgl8000001@0VIVI2000000407moO`D000000`1VIVH5000000D0C4a<0P000007
03<c<`8000003@0I6ATl000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?oo
ocl000003@0I6AT2000000L0<c<c1000000604a<C0@00000101VIVH6000000H0Ogmo5000000607mo
O`H00000101VIVH4000000H0C4a<1000000703<c<`8000003@0I6ATn000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom1000000d06ATI0P00000903<c<`<0
00001`1<C4`4000000H0IVIV1P00000D07moO`H000001P1VIVH4000000L0C4a<0`00000903<c<`80
00003@0I6AU0000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooom3000000d06ATI0`00000903<c<`<00000201<C4`6000000H0IVIV5000000606IVIPH00000
201<C4`3000000T0<c<c0`00000>01TI6D4000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooodD000003P0I6AT3000000T0<c<c1000000:04a<C0H00000501V
IVH6000000X0C4a<1000000903<c<`<000003`0I6AU3000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooom6000001006ATI0`00000:03<c<`@00000301<C4`D
000000`0C4a<1000000:03<c<`<00000400I6AU5000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooom=000000`06ATI2000000603<c<b`000001P0c<c<80000
00`06ATIC00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
ooooD000000A01TI6@`00000800c<c<<000001406ATIC`0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080ooooE000000I01TI6B0000006@0I6AUC000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomJ000004H06ATIF@00
00050?ooo`030000003oool0oooo00D0oooo00070?ooo`@000000`3oool2000000D0oooo00<00000
0?ooo`3oool00P3ooomQ000003P06ATIH00000050?ooo`030000003oool0oooo00D0oooo00070?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`02
0?ooofL00000;00I6AUV000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo00<000000?oo
o`3oool00P3oool010000000oooo0?ooo`0000040?ooo`<000000P3ooooi000000<0oooo0`000007
0?ooo`002@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`001`3oool01000
0000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3o
oooi000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo0P0000040?ooo`8000001@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooon@0000040?ooo`8000001`3o
ool001D0oooo00<000000?ooo`3oool00P3ooom/000002<06ATIJP0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooH@00000h01TI6F0000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooe/00000A00I6AUJ000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomF000001h06ATI
4P00000N01TI6ED000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooe<000005@0I6AT<00000180<c<c3000000E01TI6E8000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodl000003@0I6AT<000000H0<c<c7P000006
03<c<``000003@0I6AU>000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooom:000000d06ATI1@00000<03<c<`H000007P1<C4`6000000`0<c<c1@00000=01TI
6DT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodL0
00003P0I6AT2000000X0<c<c1`00000604a<C1h000001P1<C4`7000000X0<c<c0P00000?01TI6DD0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oood@00000
3`0I6AT2000000L0<c<c1@00000704a<C0H000007P1VIVH6000000L0C4a<1@00000703<c<`800000
3`0I6AU3000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oom2000000h06ATI0`00000603<c<`<000001`1<C4`5000000H0IVIV7P00000606IVIPD000001`1<
C4`3000000H0<c<c0`00000>01TI6D4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oood0000003@0I6AT3000000L0<c<c0P00000604a<C0@000001P1VIVH5
000001h0Ogmo1@00000606IVIP@000001P1<C4`2000000L0<c<c0`00000=01TI6Cl000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooch000003@0I6AT20000
00P0<c<c0P00000604a<C08000001`1VIVH3000000H0Ogmo7000000607moO`<000001`1VIVH20000
00H0C4a<0P00000803<c<`8000003@0I6ATm000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo0P0000030?ooocd000003@0I6AT00`000000<c<c03<c<`0603<c<`8000001P1<C4`2000000D0
IVIV1000000307moO`H000001@2IVITB000000D0VIVI1P00000307moO`@000001@1VIVH2000000H0
C4a<0P00000803<c<`030000000I6AT06ATI00`06ATI>`0000040?ooo`8000001`3oool001D0oooo
00<000000?ooo`3oool00P3oooll000000d06ATI00<0000003<c<`0c<c<01@0c<c<2000000H0C4a<
0P00000406IVIP<00000101oOgl3000000D0VIVI1P00000B0;>c/`H000001@2IVIT3000000@0Ogmo
0`00000406IVIP8000001P1<C4`2000000L0<c<c0P00000=01TI6CX000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc/00000300I6AT2000000L0<c<c00<0
000004a<C01<C4`0101<C4`2000000@0IVIV0P00000407moO`<00000102IVIT4000000H0/k>c4P00
00060;>c/`@00000102IVIT3000000@0Ogmo0P00000406IVIP8000001P1<C4`00`000000<c<c03<c
<`0603<c<`030000000I6AT06ATI00/06ATI>@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo>@00000=01TI6@030000000c<c<0<c<c00H0<c<c00<00000
04a<C01<C4`00`1<C4`2000000@0IVIV0P00000407moO`8000001@2IVIT2000000D0/k>c1@00000B
0<c<c0D000001@2c/k<2000000D0VIVI0P00000407moO`800000101VIVH2000000D0C4a<00<00000
03<c<`0c<c<01P0c<c<2000000`06ATI>00000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo>000000=01TI6@030000000c<c<0<c<c00D0<c<c0P00000504a<
C0030000001VIVH0IVIV0080IVIV0P00000407moO`8000001@2IVIT2000000@0/k>c0`0000050<c<
c18000001@3<c<`3000000@0/k>c0P00000509VIV@800000101oOgl2000000@0IVIV00<0000004a<
C01<C4`00`1<C4`2000000P0<c<c00<0000001TI6@0I6AT02P0I6ATg000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolg000000`06ATI0P00000703<c<`03
0000001<C4`0C4a<00<0C4a<0P00000306IVIP800000101oOgl2000000@0VIVI0`0000030;>c/`<0
00000P3<c<`6000000H0i^KV1P0000060>KViPH000000P3<c<`3000000<0/k>c0`00000409VIV@80
0000101oOgl2000000<0IVIV0P00000504a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I
6AT02P0I6ATf000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolf000000`06ATI00<0000003<c<`0c<c<01@0c<c<2000000D0C4a<00<0000006IVIP1VIVH0
0P1VIVH00`000000Ogmo07moO`0207moO`8000000`2IVIT3000000<0/k>c0`0000020<c<c0<00000
103Vi^H8000000H0oooo200000040>KViP<000000P3<c<`3000000<0/k>c0`00000309VIV@800000
101oOgl00`000000IVIV06IVIP0206IVIP800000101<C4`2000000L0<c<c00<0000001TI6@0I6AT0
2P0I6ATe000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oole000000`06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00404a<C0030000001V
IVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl010000000VIVI09VIV@2IVIT2000000@0/k>c
0P0000040<c<c0030000003Vi^H0i^KV0080i^KV0`00000F0?ooo`<00000103Vi^H00`000000c<c<
0<c<c0020<c<c0800000102c/k<2000000<0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV
06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI
01TI6@0901TI6CD000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooocD000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0
000006IVIP1VIVH00P1VIVH010000000Ogmo07moO`1oOgl2000000<0VIVI00<000000;>c/`2c/k<0
0P2c/k<2000000@0c<c<0P0000020>KViP<00000703oool300000080i^KV0P0000040<c<c0800000
102c/k<010000000VIVI09VIV@2IVIT2000000<0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000
C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATd000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooold000000`06ATI
00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV0080IVIV
00D0000007moO`1oOgl0Ogmo0000000409VIV@040000002c/k<0/k>c0;>c/`800000103<c<`20000
0080i^KV0P00000R0?ooo`8000000P3Vi^H2000000@0c<c<0P0000030;>c/`030000002IVIT0VIVI
0080VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<00<0C4a<00<00000
03<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6C@000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooc@000002`0I6AT00`000000<c<c03<c<`0503<c
<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0
000000<0VIVI0P0000020;>c/`800000103<c<`200000080i^KV0P00000V0?ooo`8000000P3Vi^H2
000000@0c<c<0P0000020;>c/`8000000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0
000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI<`00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<`00000;
01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP02
06IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0000000@0c<c<
0P0000020>KViP800000:P3oool200000080i^KV0P0000040<c<c0050000002c/k<0/k>c0;>c/`00
00000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00`1<C4`00`00
0000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI<`0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`8000000`3ooolc000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VI
V@050000002c/k<0/k>c0;>c/`0000000`3<c<`200000080i^KV0P00000^0?ooo`8000000P3Vi^H2
000000<0c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07moO`000000
101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0
2@0I6ATb000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?oooc<000002`0I
6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1V
IVH01@000000Ogmo07moO`1oOgl000000080VIVI00D000000;>c/`2c/k<0/k>c000000020<c<c080
0000103Vi^H00`000000oooo0?ooo`0^0?ooo`030000003Vi^H0i^KV0080i^KV0P0000020<c<c005
0000002c/k<0/k>c0;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<00000
04a<C01<C4`0101<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00T06ATI<P000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<P00000;01TI
6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IV
IP050000001oOgl0Ogmo07moO`0000000`2IVIT01`000000/k>c0;>c/`2c/k<000000<c<c0000000
1@3Vi^H00`000000oooo0?ooo`0`0?ooo`030000003Vi^H0i^KV00<0i^KV00<000000<c<c0000000
0`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00D0000006IVIP1VIVH0IVIV0000000604a<
C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATa000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolb000000/06ATI00<0000003<c<`0c
<c<0100c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1o
Ogl0Ogmo0000000209VIV@050000002c/k<0/k>c0;>c/`0000000P3<c<`00`000000i^KV0>KViP02
0>KViP030000003oool0oooo0380oooo00<000000>KViP3Vi^H00P3Vi^H010000000c<c<0<c<c000
00030;>c/`040000002IVIT0VIVI000000<0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<
04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATa000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolb000000/06ATI00<0
000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0
000007moO`1oOgl0Ogmo0000000309VIV@050000002c/k<0/k>c0;>c/`0000000P3<c<`01@000000
i^KV0>KViP3Vi^H0000003D0oooo00<000000>KViP3Vi^H00P3Vi^H010000000c<c<0<c<c0000003
0;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<
00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6C4000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc8000002`0I6AT00`000000<c<c03<c
<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07mo
O`1oOgl0000000<0VIVI00@000000;>c/`2c/k<000000P3<c<`00`000000i^KV0>KViP020>KViP03
0000003oool0oooo03@0oooo00<000000>KViP3Vi^H00P3Vi^H010000000c<c<0<c<c00000020;>c
/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0
C4a<00<0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0901TI6C4000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc4000002`0I6AT00`00
0000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@00
0000Ogmo07moO`1oOgl0000000<0VIVI00D000000;>c/`2c/k<0/k>c000000020<c<c0050000003V
i^H0i^KV0>KViP000000>03oool01@000000i^KV0>KViP3Vi^H000000080c<c<00D000000;>c/`2c
/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C003
04a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT`000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooola000000/06ATI00<0000003<c
<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007mo
O`1oOgl0Ogmo0000000309VIV@040000002c/k<0/k>c000000<0c<c<00@000000>KViP3Vi^H00000
>P3oool010000000i^KV0>KViP0000030<c<c0040000002c/k<0/k>c000000<0VIVI00D0000007mo
O`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<0
0`0000006ATI01TI6@0901TI6C0000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?oooc4000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<
0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00@00000
0;>c/`2c/k<000000`3<c<`010000000i^KV0>KViP00000j0?ooo`040000003Vi^H0i^KV000000<0
c<c<00@000000;>c/`2c/k<000000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<00000
04a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<0000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<@00000;01TI
6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IV
IP050000001oOgl0Ogmo07moO`0000000`2IVIT00`000000/k>c000000030<c<c0040000003Vi^H0
i^KV000003`0oooo00@000000>KViP3Vi^H000000`3<c<`010000000/k>c0;>c/`00000209VIV@05
0000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT02@0I6AT`000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3oool`000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VI
V@040000002c/k<0/k>c000000<0c<c<00@000000>KViP3Vi^H00000?03oool010000000i^KV0>KV
iP0000030<c<c0040000002c/k<0/k>c00000080VIVI00D0000007moO`1oOgl0Ogmo0000000406IV
IP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI
6C0000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc00
00002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1V
IVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00@000000;>c/`2c/k<000000`3<c<`0
10000000i^KV0>KViP00000l0?ooo`040000003Vi^H0i^KV000000<0c<c<00@000000;>c/`2c/k<0
00000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI;`0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo<000000;01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07mo
O`0000000`2IVIT010000000/k>c0;>c/`0000020<c<c0040000003Vi^H0i^KV000003h0oooo00@0
00000>KViP3Vi^H000000P3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00D0000007moO`1o
Ogl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0901TI6Bl000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0
oooo<000000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT010000000/k>c0;>c/`000002
0<c<c0040000003Vi^H0i^KV000003h0oooo00@000000>KViP3Vi^H000000P3<c<`01@000000/k>c
0;>c/`2c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<
0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6Bl00000103oool20000
00L0oooo000E0?ooo`030000003oool0oooo0080oooo<000000;01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07mo
O`0000000`2IVIT010000000/k>c0;>c/`0000020<c<c0040000003Vi^H0i^KV000003h0oooo00@0
00000>KViP3Vi^H000000P3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00D0000007moO`1o
Ogl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0901TI6Bl000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooc0000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080
C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00@000000;>c
/`2c/k<000000P3<c<`010000000i^KV0>KViP00000n0?ooo`040000003Vi^H0i^KV00000080c<c<
00D000000;>c/`2c/k<0/k>c0000000209VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`00
0000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT_0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool`000000/0
6ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080
IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@040000002c/k<0/k>c00000080c<c<00@00000
0>KViP3Vi^H00000?@3oool010000000i^KV0>KViP0000030<c<c0040000002c/k<0/k>c00000080
VIVI00<0000007moO`1oOgl00P1oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6C0000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooc4000002P0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl00000
0080VIVI00@000000;>c/`2c/k<000000`3<c<`010000000i^KV0>KViP00000l0?ooo`040000003V
i^H0i^KV000000<0c<c<00@000000;>c/`2c/k<000000P2IVIT00`000000Ogmo07moO`0207moO`05
0000001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00P06ATI<00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo<@00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000P2IVIT01@000000/k>c0;>c/`2c/k<0
00000080c<c<00@000000>KViP3Vi^H00000?03oool010000000i^KV0>KViP0000020<c<c0050000
002c/k<0/k>c0;>c/`0000000P2IVIT00`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IV
IP0000001@1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI<00000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<@00000:01TI6@03
0000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP05
0000001oOgl0Ogmo07moO`0000000P2IVIT01@000000/k>c0;>c/`2c/k<000000080c<c<00@00000
0>KViP3Vi^H00000?03oool010000000i^KV0>KViP0000020<c<c0050000002c/k<0/k>c0;>c/`00
00000P2IVIT00`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI<00000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo<@00000:01TI6@030000000c<c<0<c<c00D0
<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07mo
O`0000000P2IVIT01@000000/k>c0;>c/`2c/k<000000080c<c<00D000000>KViP3Vi^H0i^KV0000
000j0?ooo`070000003Vi^H0i^KV0>KViP000000c<c<000000030;>c/`050000002IVIT0VIVI09VI
V@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6C0000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooc4000002`0I6AT00`000000<c<c03<c<`0403<c<`03
0000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH010000000Ogmo07moO`00000309VI
V@050000002c/k<0/k>c0;>c/`0000000P3<c<`010000000i^KV0>KViP00000j0?ooo`040000003V
i^H0i^KV00000080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07mo
O`0000000`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI
6@0I6AT02@0I6AT`000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooola000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C003
0000001VIVH0IVIV0080IVIV00@0000007moO`1oOgl000000`2IVIT01@000000/k>c0;>c/`2c/k<0
00000080c<c<00D000000>KViP3Vi^H0i^KV0000000h0?ooo`070000003Vi^H0i^KV0>KViP000000
c<c<000000030;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`000000IVIV06IVIP0206IV
IP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI
6C4000001@3oool00`000000oooo0?ooo`050?ooo`00203oool2000000@0oooo0P0000050?ooo`03
0000003oool0oooo0080oooo<P00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<
C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01`00
0000/k>c0;>c/`2c/k<000000<c<c0000000103Vi^H00`000000oooo0?ooo`0d0?ooo`030000003V
i^H0i^KV0080i^KV00<000000<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo
00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT0200I6ATa000000D0oooo00<000000?ooo`3oool01@3oool000L0oooo00@0
00000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080
oooo<P00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000
IVIV06IVIP0206IVIP040000001oOgl0Ogmo000000<0VIVI00D000000;>c/`2c/k<0/k>c00000002
0<c<c0050000003Vi^H0i^KV0>KViP000000=P3oool01`000000i^KV0>KViP3Vi^H000000<c<c000
00000`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00<0000006IVIP1VIVH00P1VIVH00`00
0000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATa0000
00D0oooo00<000000?ooo`3oool01@3oool000T0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo0080oooo0`0000020?oooc8000002`0I6AT00`000000<c<c03<c<`0403<c
<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0
000000<0VIVI00H000000;>c/`2c/k<0/k>c0000003<c<`2000000<0i^KV00<000000?ooo`3oool0
<P3oool010000000i^KV0>KViP3Vi^H2000000030<c<c0000000/k>c0080/k>c00D0000009VIV@2I
VIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<@0000030?ooo`<000001`3oool000X0
oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo<P00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`00
0000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00@0000009VIV@2IVIT000000`2c/k<0
1@000000c<c<0<c<c03<c<`0000000<0i^KV00<000000?ooo`3oool0<03oool01@000000i^KV0>KV
iP3Vi^H000000080c<c<00<000000;>c/`2c/k<00P2c/k<010000000VIVI09VIV@00000307moO`03
0000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0403<c<`03
0000000I6AT06ATI00T06ATI<@0000050?ooo`030000003oool0oooo00D0oooo00070?ooo`040000
003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?oo
oc<000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IV
IP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00D000000;>c/`2c/k<0/k>c0000
00030<c<c0050000003Vi^H0i^KV0>KViP000000<03oool01@000000i^KV0>KViP3Vi^H0000000<0
c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07moO`000000101VIVH0
0`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATb
000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`020?oooc<000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<
0080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`050000002IVIT0VIVI
09VIV@0000000P2c/k<00`000000c<c<0<c<c0020<c<c0050000003Vi^H0i^KV0>KViP000000;P3o
ool01@000000i^KV0>KViP3Vi^H0000000<0c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@05
0000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT02@0I6ATb000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolc000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000
C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl01@000000
VIVI09VIV@2IVIT000000080/k>c00<000000<c<c03<c<`00P3<c<`010000000i^KV0>KViP3Vi^H2
000002X0oooo0P0000030>KViP030000003<c<`0c<c<0080c<c<00D000000;>c/`2c/k<0/k>c0000
000209VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<
C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATb000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooold000000/06ATI00<00000
03<c<`0c<c<01@0c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00<00000
07moO`1oOgl00P1oOgl00`000000VIVI09VIV@0209VIV@030000002c/k<0/k>c008000000`3<c<`0
0`000000i^KV0>KViP020>KViP030000003oool0oooo02H0oooo00<000000>KViP3Vi^H00P3Vi^H0
10000000c<c<0<c<c03<c<`2000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000
001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0403<c<`030000
000I6AT06ATI00T06ATI<`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo=000000<01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<
C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00P2I
VIT01@000000/k>c0;>c/`2c/k<0000000<0c<c<00<000000>KViP3Vi^H00P3Vi^H00`000000oooo
0?ooo`0T0?ooo`030000003Vi^H0i^KV0080i^KV00D000000<c<c03<c<`0c<c<000000040;>c/`05
0000002IVIT0VIVI09VIV@000000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<
00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0:01TI6C<000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc@00000300I6AT00`000000
<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000
Ogmo07moO`1oOgl0000000@0VIVI00<000000;>c/`2c/k<00P2c/k<010000000c<c<0<c<c03<c<`2
000000<0i^KV00<000000?ooo`3oool08P3oool010000000i^KV0>KViP3Vi^H2000000<0c<c<00<0
00000;>c/`2c/k<00P2c/k<00`000000VIVI09VIV@0209VIV@050000001oOgl0Ogmo07moO`000000
101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT0
2P0I6ATc000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oole000000`06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00404a<C0030000001V
IVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000409VIV@030000002c/k<0/k>c0080/k>c
0P0000030<c<c0040000003Vi^H0i^KV0>KViP800000803oool2000000<0i^KV00@000000<c<c03<
c<`0c<c<0P0000040;>c/`030000002IVIT0VIVI0080VIVI00D0000007moO`1oOgl0Ogmo00000004
06IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0:
01TI6C@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ocD00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IV
IP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI0080VIVI00<000000;>c
/`2c/k<00`2c/k<010000000c<c<0<c<c03<c<`2000000<0i^KV0P00000L0?ooo`8000000`3Vi^H2
000000<0c<c<00<000000;>c/`2c/k<00`2c/k<00`000000VIVI09VIV@0209VIV@050000001oOgl0
Ogmo07moO`0000001@1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0
000001TI6@0I6AT02P0I6ATd000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolf000000`06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C003
04a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl00`000000VIVI09VIV@02
09VIV@030000002c/k<0/k>c00<0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP02
0>KViP@00000503oool4000000@0i^KV00<000000<c<c03<c<`00P3<c<`00`000000/k>c0;>c/`03
0;>c/`030000002IVIT0VIVI0080VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP02
06IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0:
01TI6CD000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ocH00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IV
IP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI0080VIVI0P0000040;>c
/`8000000`3<c<`2000000H0i^KV1`0000070?ooo`H000001P3Vi^H2000000<0c<c<0P0000040;>c
/`800000102IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<
C01<C4`0101<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI=@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=`00000<01TI6@03
0000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP03
0000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00`2IVIT00`000000/k>c0;>c/`030;>c/`03
0000003<c<`0c<c<0080c<c<0P00000;0>KViPL000002P3Vi^H2000000@0c<c<00<000000;>c/`2c
/k<00`2c/k<00`000000VIVI09VIV@0309VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1V
IVH00P1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I
6AT02P0I6ATf000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?ooocL00000
300I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH0
0`1VIVH00`000000Ogmo07moO`0207moO`800000102IVIT2000000@0/k>c0`0000030<c<c0@00000
503Vi^H4000000<0c<c<0`0000040;>c/`800000102IVIT2000000@0Ogmo00<0000006IVIP1VIVH0
0`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT0
2P0I6ATf000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooocP00000300I
6AT2000000L0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001o
Ogl0Ogmo00<0Ogmo0P00000409VIV@8000001@2c/k<3000000@0c<c<500000040<c<c0<000001@2c
/k<2000000@0VIVI0P00000507moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<
C4`00`000000<c<c03<c<`0603<c<`030000000I6AT06ATI00X06ATI=`0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo>000000>01TI6@030000000c<c<0
<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`2000000@0IVIV0P00000507moO`030000002IVIT0
VIVI00<0VIVI0P0000060;>c/`<000005P3<c<`3000000H0/k>c0P00000509VIV@030000001oOgl0
Ogmo00<0Ogmo0P00000406IVIP8000001@1<C4`00`000000<c<c03<c<`0603<c<`030000000I6AT0
6ATI00/06ATI=`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo>@00000=01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`0101<C4`00`00
0000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00<0Ogmo0P00000509VIV@<000001P2c/k<30000
0100c<c<0`0000060;>c/`<000001@2IVIT2000000D0Ogmo00<0000006IVIP1VIVH00`1VIVH00`00
0000C4a<04a<C00404a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02`0I6ATh0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolj000000d0
6ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV00<0
IVIV00<0000007moO`1oOgl0101oOgl2000000H0VIVI0`0000060;>c/a0000001P2c/k<3000000L0
VIVI00<0000007moO`1oOgl0101oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00@0
C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0:01TI6CT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocX000003@0I6AT00`000000<c<c
03<c<`0703<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00`1VIVH2000000H0Ogmo
0P00000709VIV@800000602c/k<2000000P0VIVI0P00000507moO`8000001@1VIVH00`000000C4a<
04a<C00404a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02`0I6ATi000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolk000000d06ATI00<0
000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV00@0IVIV0`00
000507moO`@000001@2IVIT9000000L0/k>c2000000509VIV@D00000101oOgl3000000H0IVIV00<0
000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00/06ATI>P00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo?000000=
01TI6@800000200c<c<00`000000C4a<04a<C00404a<C08000001`1VIVH2000000L0Ogmo0`00000;
09VIV@L000002P2IVIT3000000L0Ogmo0P00000706IVIP8000001P1<C4`00`000000<c<c03<c<`06
03<c<`8000003@0I6ATk000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolm000000h06ATI00<0000003<c<`0c<c<01P0c<c<2000000H0C4a<0P00000706IV
IP800000201oOgl4000001@0VIVI1000000807moO`8000001`1VIVH2000000H0C4a<0P00000803<c
<`030000000I6AT06ATI00`06ATI?00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo?@00000?01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<
C4`01@1<C4`2000000L0IVIV0P00000:07moO`L000001`2IVIT6000000X0Ogmo0P00000706IVIP80
00001`1<C4`00`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00d06ATI?00000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo?P00000?01TI6@030000
000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`01P1<C4`2000000L0IVIV0`00000>07moO`L00000
3@1oOgl3000000L0IVIV0P00000804a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT0
3@0I6ATm000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolo000000l06ATI00<0000003<c<`0c<c<01`0c<c<2000000P0C4a<0P00000806IVIP<00000701o
Ogl3000000P0IVIV0P00000804a<C08000002@0c<c<00`0000006ATI01TI6@0=01TI6Ch000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo@@00000>01TI6@030000000c<c<0
<c<c00P0<c<c00<0000004a<C01<C4`01`1<C4`3000000P0IVIV1@00000B07moO`D00000201VIVH3
000000T0C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI6@0<01TI6D000000103oool2
000000L0oooo000E0?ooo`030000003oool0oooo0080oooo@P00000>01TI6@8000002@0c<c<20000
00X0C4a<0P00000;06IVIQ8000002`1VIVH2000000X0C4a<0P00000903<c<`8000003P0I6AU10000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom3000000l0
6ATI00<0000003<c<`0c<c<0200c<c<2000000X0C4a<0`00000R06IVIP<000002P1<C4`2000000X0
<c<c00<0000001TI6@0I6AT03@0I6AU2000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooom4000000l06ATI00<0000003<c<`0c<c<02@0c<c<2000000/0C4a<
0`00000L06IVIP<000002`1<C4`2000000/0<c<c00<0000001TI6@0I6AT03P0I6AU2000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom5000000l06ATI0P00
000;03<c<`800000301<C4`4000001@0IVIV1000000<04a<C08000002`0c<c<2000001006ATI@`00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooAP00000@
01TI6@030000000c<c<0<c<c00X0<c<c0`00000=04a<C1@000003@1<C4`3000000`0<c<c00<00000
01TI6@0I6AT03`0I6AU4000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooom7000001006ATI0`00000<03<c<`<00000:01<C4`3000000d0<c<c0P00000@01TI
6DH000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodP0
00004P0I6AT00`000000<c<c03<c<`0<03<c<`@00000801<C4`4000000h0<c<c0P00000A01TI6DL0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodX00000
4@0I6AT200000100<c<c1P00000D04a<C0H00000400c<c<2000001406ATIB@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooB`00000B01TI6@800000500c
<c<D000001@0<c<c0P00000B01TI6DX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oood`000004`0I6AT4000003@0<c<c1000000C01TI6D/000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodd000005P0I6AT20000
0300<c<c0P00000F01TI6D`000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooodl000005P0I6AT2000002`0<c<c0P00000F01TI6Dh000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool2000000<0ooooD000000G01TI6@H00000800c<c<6000001L06ATI
C`0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooomB000001/06ATI1P00
000D03<c<`H000006`0I6AUA000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooomD000001l06ATI5000000O01TI6E<000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooeH00000CP0I6AUE000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomH000004X06ATIE`0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooFP00001601TI6ET00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooe`00000@P0I
6AUK000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomO
000003`06ATIGP0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080ooooH`00000d01TI6F8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooofH00000;P0I6AUU000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooomY000002P06ATIJ00000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080ooooK@00000P01TI6F`000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool2000000<0ooooNP00000701TI6GP00000103oool2000000L0oooo000E0?oo
o`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
n@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@00
00050?ooo`030000003oool0oooo00D0oooo00090?ooo`<000000P3oool2000000D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool000X0oooo00@000000?oo
o`3oool000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooon@000005
0?ooo`030000003oool0oooo00D0oooo00070?ooo`D0000000D0oooo0000003oool0oooo00000004
0?ooo`<000000P3ooooi000000<0oooo0`0000070?ooo`001`3oool010000000oooo0?ooo`000002
0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<0
00000?ooo`3oool01@3oool000P0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`00
00040?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo0009
0?ooo`8000000`3oool2000000D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`0j0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0?03oool00`000000
oooo0?ooo`0k0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool01@3oool001D0ooooo`000005000000L0oooo003o0?ooob40oooo003o0?oo
ob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?oo
ob40oooo002>0?ooo`80000000D0oooo00000000000000000?ooo`0500000080oooo0P0000220?oo
o`00SP3oool01@000000oooo0?ooo`3oool0000000@0oooo00D000000?ooo`3oool0oooo00000002
0?ooo`030000003oool0oooo07l0oooo002>0?ooo`050000003oool000000?ooo`000000103oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0O`3oool008h0oooo0P000000
0`3oool00000000000040?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`1o0?ooo`00SP3oool2000000030?ooo`000000000000@0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo07l0oooo002>0?ooo`80000000@0oooo00000000000000000P3o
ool2000000@0oooo0P0000220?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-3.26594, -1.76599, 0.160642, \
0.160642}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00480769 0.0240385 -0.00480769 0.0240385 [
[.23558 -0.0125 -6 -9 ]
[.23558 -0.0125 6 0 ]
[.47596 -0.0125 -6 -9 ]
[.47596 -0.0125 6 0 ]
[.71635 -0.0125 -6 -9 ]
[.71635 -0.0125 6 0 ]
[.95673 -0.0125 -6 -9 ]
[.95673 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .23558 -12 -4.5 ]
[-0.0125 .23558 0 4.5 ]
[-0.0125 .47596 -12 -4.5 ]
[-0.0125 .47596 0 4.5 ]
[-0.0125 .71635 -12 -4.5 ]
[-0.0125 .71635 0 4.5 ]
[-0.0125 .95673 -12 -4.5 ]
[-0.0125 .95673 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -11 0 ]
[.5 1.0125 11 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23558 0 m
.23558 .00625 L
s
[(10)] .23558 -0.0125 0 1 Mshowa
.47596 0 m
.47596 .00625 L
s
[(20)] .47596 -0.0125 0 1 Mshowa
.71635 0 m
.71635 .00625 L
s
[(30)] .71635 -0.0125 0 1 Mshowa
.95673 0 m
.95673 .00625 L
s
[(40)] .95673 -0.0125 0 1 Mshowa
.125 Mabswid
.04327 0 m
.04327 .00375 L
s
.09135 0 m
.09135 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.1875 0 m
.1875 .00375 L
s
.28365 0 m
.28365 .00375 L
s
.33173 0 m
.33173 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.42788 0 m
.42788 .00375 L
s
.52404 0 m
.52404 .00375 L
s
.57212 0 m
.57212 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.66827 0 m
.66827 .00375 L
s
.76442 0 m
.76442 .00375 L
s
.8125 0 m
.8125 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.90865 0 m
.90865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .23558 m
.00625 .23558 L
s
[(10)] -0.0125 .23558 1 0 Mshowa
0 .47596 m
.00625 .47596 L
s
[(20)] -0.0125 .47596 1 0 Mshowa
0 .71635 m
.00625 .71635 L
s
[(30)] -0.0125 .71635 1 0 Mshowa
0 .95673 m
.00625 .95673 L
s
[(40)] -0.0125 .95673 1 0 Mshowa
.125 Mabswid
0 .04327 m
.00375 .04327 L
s
0 .09135 m
.00375 .09135 L
s
0 .13942 m
.00375 .13942 L
s
0 .1875 m
.00375 .1875 L
s
0 .28365 m
.00375 .28365 L
s
0 .33173 m
.00375 .33173 L
s
0 .37981 m
.00375 .37981 L
s
0 .42788 m
.00375 .42788 L
s
0 .52404 m
.00375 .52404 L
s
0 .57212 m
.00375 .57212 L
s
0 .62019 m
.00375 .62019 L
s
0 .66827 m
.00375 .66827 L
s
0 .76442 m
.00375 .76442 L
s
0 .8125 m
.00375 .8125 L
s
0 .86058 m
.00375 .86058 L
s
0 .90865 m
.00375 .90865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.23558 .99375 m
.23558 1 L
s
.47596 .99375 m
.47596 1 L
s
.71635 .99375 m
.71635 1 L
s
.95673 .99375 m
.95673 1 L
s
.125 Mabswid
.04327 .99625 m
.04327 1 L
s
.09135 .99625 m
.09135 1 L
s
.13942 .99625 m
.13942 1 L
s
.1875 .99625 m
.1875 1 L
s
.28365 .99625 m
.28365 1 L
s
.33173 .99625 m
.33173 1 L
s
.37981 .99625 m
.37981 1 L
s
.42788 .99625 m
.42788 1 L
s
.52404 .99625 m
.52404 1 L
s
.57212 .99625 m
.57212 1 L
s
.62019 .99625 m
.62019 1 L
s
.66827 .99625 m
.66827 1 L
s
.76442 .99625 m
.76442 1 L
s
.8125 .99625 m
.8125 1 L
s
.86058 .99625 m
.86058 1 L
s
.90865 .99625 m
.90865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .23558 m
1 .23558 L
s
.99375 .47596 m
1 .47596 L
s
.99375 .71635 m
1 .71635 L
s
.99375 .95673 m
1 .95673 L
s
.125 Mabswid
.99625 .04327 m
1 .04327 L
s
.99625 .09135 m
1 .09135 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .1875 m
1 .1875 L
s
.99625 .28365 m
1 .28365 L
s
.99625 .33173 m
1 .33173 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .42788 m
1 .42788 L
s
.99625 .52404 m
1 .52404 L
s
.99625 .57212 m
1 .57212 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .66827 m
1 .66827 L
s
.99625 .76442 m
1 .76442 L
s
.99625 .8125 m
1 .8125 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .90865 m
1 .90865 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M01) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.5 Mabswid
.1 g
.28365 .2086 m
.30769 .20362 L
.33173 .20204 L
.35577 .20436 L
.37981 .21123 L
.38064 .21154 L
.40385 .2251 L
.41635 .23558 L
.42788 .24892 L
.43513 .25962 L
.44773 .28365 L
.45192 .29371 L
.45409 .30769 L
.45902 .33173 L
.46429 .35577 L
.46894 .37981 L
.47263 .40385 L
.47536 .42788 L
.47596 .43427 L
.47679 .45192 L
.47751 .47596 L
.47774 .5 L
.47751 .52404 L
.47679 .54808 L
.47596 .56573 L
.47536 .57212 L
.47263 .59615 L
.46894 .62019 L
.46429 .64423 L
.45902 .66827 L
.45409 .69231 L
.45192 .70629 L
.44773 .71635 L
.43513 .74038 L
.42788 .75108 L
.41635 .76442 L
.40385 .7749 L
.38064 .78846 L
.37981 .78877 L
.35577 .79564 L
.33173 .79796 L
.30769 .79638 L
.28365 .7914 L
.2734 .78846 L
.25962 .7829 L
.23558 .77088 L
.22464 .76442 L
.21154 .75523 L
.19305 .74038 L
.1875 .73531 L
.16905 .71635 L
.16346 .7099 L
.14996 .69231 L
.13942 .67691 L
.13435 .66827 L
.12158 .64423 L
.11538 .63088 L
.11135 .62019 L
.10334 .59615 L
.09702 .57212 L
.09251 .54808 L
.09135 .54373 L
.09003 .52404 L
.08926 .5 L
.09003 .47596 L
.09135 .45627 L
.09251 .45192 L
.09702 .42788 L
.10334 .40385 L
.11135 .37981 L
.11538 .36912 L
.12158 .35577 L
.13435 .33173 L
.13942 .32309 L
.14996 .30769 L
.16346 .2901 L
.16905 .28365 L
.1875 .26469 L
.19305 .25962 L
.21154 .24477 L
.22464 .23558 L
.23558 .22912 L
.25962 .2171 L
.2734 .21154 L
F
0 g
.28365 .2086 m
.30769 .20362 L
.33173 .20204 L
.35577 .20436 L
.37981 .21123 L
.38064 .21154 L
.40385 .2251 L
.41635 .23558 L
.42788 .24892 L
.43513 .25962 L
.44773 .28365 L
.45192 .29371 L
.45409 .30769 L
.45902 .33173 L
.46429 .35577 L
.46894 .37981 L
.47263 .40385 L
.47536 .42788 L
.47596 .43427 L
.47679 .45192 L
.47751 .47596 L
.47774 .5 L
.47751 .52404 L
.47679 .54808 L
.47596 .56573 L
.47536 .57212 L
.47263 .59615 L
.46894 .62019 L
.46429 .64423 L
.45902 .66827 L
.45409 .69231 L
.45192 .70629 L
.44773 .71635 L
.43513 .74038 L
.42788 .75108 L
.41635 .76442 L
.40385 .7749 L
.38064 .78846 L
.37981 .78877 L
.35577 .79564 L
.33173 .79796 L
.30769 .79638 L
.28365 .7914 L
.2734 .78846 L
.25962 .7829 L
.23558 .77088 L
.22464 .76442 L
.21154 .75523 L
.19305 .74038 L
.1875 .73531 L
Mistroke
.16905 .71635 L
.16346 .7099 L
.14996 .69231 L
.13942 .67691 L
.13435 .66827 L
.12158 .64423 L
.11538 .63088 L
.11135 .62019 L
.10334 .59615 L
.09702 .57212 L
.09251 .54808 L
.09135 .54373 L
.09003 .52404 L
.08926 .5 L
.09003 .47596 L
.09135 .45627 L
.09251 .45192 L
.09702 .42788 L
.10334 .40385 L
.11135 .37981 L
.11538 .36912 L
.12158 .35577 L
.13435 .33173 L
.13942 .32309 L
.14996 .30769 L
.16346 .2901 L
.16905 .28365 L
.1875 .26469 L
.19305 .25962 L
.21154 .24477 L
.22464 .23558 L
.23558 .22912 L
.25962 .2171 L
.2734 .21154 L
.28365 .2086 L
Mfstroke
.2 g
.28365 .25464 m
.30769 .24863 L
.33173 .24674 L
.35577 .24951 L
.37981 .25786 L
.38348 .25962 L
.40385 .27437 L
.41314 .28365 L
.42788 .30413 L
.42988 .30769 L
.44087 .33173 L
.44902 .35577 L
.45192 .36643 L
.45314 .37981 L
.45559 .40385 L
.45797 .42788 L
.45986 .45192 L
.46105 .47596 L
.46146 .5 L
.46105 .52404 L
.45986 .54808 L
.45797 .57212 L
.45559 .59615 L
.45314 .62019 L
.45192 .63357 L
.44902 .64423 L
.44087 .66827 L
.42988 .69231 L
.42788 .69587 L
.41314 .71635 L
.40385 .72563 L
.38348 .74038 L
.37981 .74214 L
.35577 .75049 L
.33173 .75326 L
.30769 .75137 L
.28365 .74536 L
.27003 .74038 L
.25962 .73523 L
.23558 .7207 L
.22952 .71635 L
.21154 .70112 L
.20261 .69231 L
.1875 .67506 L
.18234 .66827 L
.16645 .64423 L
.16346 .63906 L
.15413 .62019 L
.14436 .59615 L
.13942 .58116 L
.13711 .57212 L
.13222 .54808 L
.12927 .52404 L
.12829 .5 L
.12927 .47596 L
.13222 .45192 L
.13711 .42788 L
.13942 .41884 L
.14436 .40385 L
.15413 .37981 L
.16346 .36094 L
.16645 .35577 L
.18234 .33173 L
.1875 .32494 L
.20261 .30769 L
.21154 .29888 L
.22952 .28365 L
.23558 .2793 L
.25962 .26477 L
.27003 .25962 L
F
0 g
.28365 .25464 m
.30769 .24863 L
.33173 .24674 L
.35577 .24951 L
.37981 .25786 L
.38348 .25962 L
.40385 .27437 L
.41314 .28365 L
.42788 .30413 L
.42988 .30769 L
.44087 .33173 L
.44902 .35577 L
.45192 .36643 L
.45314 .37981 L
.45559 .40385 L
.45797 .42788 L
.45986 .45192 L
.46105 .47596 L
.46146 .5 L
.46105 .52404 L
.45986 .54808 L
.45797 .57212 L
.45559 .59615 L
.45314 .62019 L
.45192 .63357 L
.44902 .64423 L
.44087 .66827 L
.42988 .69231 L
.42788 .69587 L
.41314 .71635 L
.40385 .72563 L
.38348 .74038 L
.37981 .74214 L
.35577 .75049 L
.33173 .75326 L
.30769 .75137 L
.28365 .74536 L
.27003 .74038 L
.25962 .73523 L
.23558 .7207 L
.22952 .71635 L
.21154 .70112 L
.20261 .69231 L
.1875 .67506 L
.18234 .66827 L
.16645 .64423 L
.16346 .63906 L
.15413 .62019 L
.14436 .59615 L
.13942 .58116 L
Mistroke
.13711 .57212 L
.13222 .54808 L
.12927 .52404 L
.12829 .5 L
.12927 .47596 L
.13222 .45192 L
.13711 .42788 L
.13942 .41884 L
.14436 .40385 L
.15413 .37981 L
.16346 .36094 L
.16645 .35577 L
.18234 .33173 L
.1875 .32494 L
.20261 .30769 L
.21154 .29888 L
.22952 .28365 L
.23558 .2793 L
.25962 .26477 L
.27003 .25962 L
.28365 .25464 L
Mfstroke
.3 g
.28365 .28292 m
.30769 .27617 L
.33173 .27407 L
.35577 .27716 L
.37696 .28365 L
.37981 .28667 L
.40385 .30553 L
.40589 .30769 L
.423 .33173 L
.42788 .34112 L
.43398 .35577 L
.44172 .37981 L
.4474 .40385 L
.45145 .42788 L
.45192 .43112 L
.45275 .45192 L
.45344 .47596 L
.45369 .5 L
.45344 .52404 L
.45275 .54808 L
.45192 .56888 L
.45145 .57212 L
.4474 .59615 L
.44172 .62019 L
.43398 .64423 L
.42788 .65888 L
.423 .66827 L
.40589 .69231 L
.40385 .69447 L
.37981 .71333 L
.37696 .71635 L
.35577 .72284 L
.33173 .72593 L
.30769 .72383 L
.28365 .71708 L
.28163 .71635 L
.25962 .70544 L
.24006 .69231 L
.23558 .68869 L
.21414 .66827 L
.21154 .66537 L
.19517 .64423 L
.1875 .63239 L
.18074 .62019 L
.1697 .59615 L
.16346 .57889 L
.16153 .57212 L
.15602 .54808 L
.15273 .52404 L
.15164 .5 L
.15273 .47596 L
.15602 .45192 L
.16153 .42788 L
.16346 .42111 L
.1697 .40385 L
.18074 .37981 L
.1875 .36761 L
.19517 .35577 L
.21154 .33463 L
.21414 .33173 L
.23558 .31131 L
.24006 .30769 L
.25962 .29456 L
.28163 .28365 L
F
0 g
.28365 .28292 m
.30769 .27617 L
.33173 .27407 L
.35577 .27716 L
.37696 .28365 L
.37981 .28667 L
.40385 .30553 L
.40589 .30769 L
.423 .33173 L
.42788 .34112 L
.43398 .35577 L
.44172 .37981 L
.4474 .40385 L
.45145 .42788 L
.45192 .43112 L
.45275 .45192 L
.45344 .47596 L
.45369 .5 L
.45344 .52404 L
.45275 .54808 L
.45192 .56888 L
.45145 .57212 L
.4474 .59615 L
.44172 .62019 L
.43398 .64423 L
.42788 .65888 L
.423 .66827 L
.40589 .69231 L
.40385 .69447 L
.37981 .71333 L
.37696 .71635 L
.35577 .72284 L
.33173 .72593 L
.30769 .72383 L
.28365 .71708 L
.28163 .71635 L
.25962 .70544 L
.24006 .69231 L
.23558 .68869 L
.21414 .66827 L
.21154 .66537 L
.19517 .64423 L
.1875 .63239 L
.18074 .62019 L
.1697 .59615 L
.16346 .57889 L
.16153 .57212 L
.15602 .54808 L
.15273 .52404 L
.15164 .5 L
Mistroke
.15273 .47596 L
.15602 .45192 L
.16153 .42788 L
.16346 .42111 L
.1697 .40385 L
.18074 .37981 L
.1875 .36761 L
.19517 .35577 L
.21154 .33463 L
.21414 .33173 L
.23558 .31131 L
.24006 .30769 L
.25962 .29456 L
.28163 .28365 L
.28365 .28292 L
Mfstroke
.4 g
.28365 .30475 m
.30769 .29722 L
.33173 .29489 L
.35577 .29832 L
.37904 .30769 L
.37981 .30888 L
.40385 .3302 L
.40512 .33173 L
.42046 .35577 L
.42788 .3725 L
.43045 .37981 L
.43722 .40385 L
.44201 .42788 L
.44522 .45192 L
.44706 .47596 L
.44766 .5 L
.44706 .52404 L
.44522 .54808 L
.44201 .57212 L
.43722 .59615 L
.43045 .62019 L
.42788 .6275 L
.42046 .64423 L
.40512 .66827 L
.40385 .6698 L
.37981 .69112 L
.37904 .69231 L
.35577 .70168 L
.33173 .70511 L
.30769 .70278 L
.28365 .69525 L
.27682 .69231 L
.25962 .68228 L
.24116 .66827 L
.23558 .66313 L
.21822 .64423 L
.21154 .63548 L
.20159 .62019 L
.18914 .59615 L
.1875 .59244 L
.1802 .57212 L
.17403 .54808 L
.17039 .52404 L
.16918 .5 L
.17039 .47596 L
.17403 .45192 L
.1802 .42788 L
.1875 .40756 L
.18914 .40385 L
.20159 .37981 L
.21154 .36452 L
.21822 .35577 L
.23558 .33687 L
.24116 .33173 L
.25962 .31772 L
.27682 .30769 L
F
0 g
.28365 .30475 m
.30769 .29722 L
.33173 .29489 L
.35577 .29832 L
.37904 .30769 L
.37981 .30888 L
.40385 .3302 L
.40512 .33173 L
.42046 .35577 L
.42788 .3725 L
.43045 .37981 L
.43722 .40385 L
.44201 .42788 L
.44522 .45192 L
.44706 .47596 L
.44766 .5 L
.44706 .52404 L
.44522 .54808 L
.44201 .57212 L
.43722 .59615 L
.43045 .62019 L
.42788 .6275 L
.42046 .64423 L
.40512 .66827 L
.40385 .6698 L
.37981 .69112 L
.37904 .69231 L
.35577 .70168 L
.33173 .70511 L
.30769 .70278 L
.28365 .69525 L
.27682 .69231 L
.25962 .68228 L
.24116 .66827 L
.23558 .66313 L
.21822 .64423 L
.21154 .63548 L
.20159 .62019 L
.18914 .59615 L
.1875 .59244 L
.1802 .57212 L
.17403 .54808 L
.17039 .52404 L
.16918 .5 L
.17039 .47596 L
.17403 .45192 L
.1802 .42788 L
.1875 .40756 L
.18914 .40385 L
.20159 .37981 L
Mistroke
.21154 .36452 L
.21822 .35577 L
.23558 .33687 L
.24116 .33173 L
.25962 .31772 L
.27682 .30769 L
.28365 .30475 L
Mfstroke
.5 g
.28365 .32317 m
.30769 .31483 L
.33173 .31227 L
.35577 .31604 L
.37981 .32775 L
.38543 .33173 L
.40385 .35173 L
.40668 .35577 L
.41959 .37981 L
.42788 .403 L
.42812 .40385 L
.43367 .42788 L
.43732 .45192 L
.43942 .47596 L
.4401 .5 L
.43942 .52404 L
.43732 .54808 L
.43367 .57212 L
.42812 .59615 L
.42788 .597 L
.41959 .62019 L
.40668 .64423 L
.40385 .64827 L
.38543 .66827 L
.37981 .67225 L
.35577 .68396 L
.33173 .68773 L
.30769 .68517 L
.28365 .67683 L
.26772 .66827 L
.25962 .66245 L
.23894 .64423 L
.23558 .6406 L
.2196 .62019 L
.21154 .60729 L
.20571 .59615 L
.19575 .57212 L
.18894 .54808 L
.1875 .54486 L
.18505 .52404 L
.18378 .5 L
.18505 .47596 L
.1875 .45514 L
.18894 .45192 L
.19575 .42788 L
.20571 .40385 L
.21154 .39271 L
.2196 .37981 L
.23558 .3594 L
.23894 .35577 L
.25962 .33755 L
.26772 .33173 L
F
0 g
.28365 .32317 m
.30769 .31483 L
.33173 .31227 L
.35577 .31604 L
.37981 .32775 L
.38543 .33173 L
.40385 .35173 L
.40668 .35577 L
.41959 .37981 L
.42788 .403 L
.42812 .40385 L
.43367 .42788 L
.43732 .45192 L
.43942 .47596 L
.4401 .5 L
.43942 .52404 L
.43732 .54808 L
.43367 .57212 L
.42812 .59615 L
.42788 .597 L
.41959 .62019 L
.40668 .64423 L
.40385 .64827 L
.38543 .66827 L
.37981 .67225 L
.35577 .68396 L
.33173 .68773 L
.30769 .68517 L
.28365 .67683 L
.26772 .66827 L
.25962 .66245 L
.23894 .64423 L
.23558 .6406 L
.2196 .62019 L
.21154 .60729 L
.20571 .59615 L
.19575 .57212 L
.18894 .54808 L
.1875 .54486 L
.18505 .52404 L
.18378 .5 L
.18505 .47596 L
.1875 .45514 L
.18894 .45192 L
.19575 .42788 L
.20571 .40385 L
.21154 .39271 L
.2196 .37981 L
.23558 .3594 L
.23894 .35577 L
Mistroke
.25962 .33755 L
.26772 .33173 L
.28365 .32317 L
Mfstroke
.6 g
.30769 .33039 m
.33173 .32763 L
.35577 .33169 L
.35593 .33173 L
.37981 .34463 L
.39228 .35577 L
.40385 .37173 L
.40856 .37981 L
.41899 .40385 L
.42583 .42788 L
.42788 .43726 L
.43011 .45192 L
.43247 .47596 L
.43323 .5 L
.43247 .52404 L
.43011 .54808 L
.42788 .56274 L
.42583 .57212 L
.41899 .59615 L
.40856 .62019 L
.40385 .62827 L
.39228 .64423 L
.37981 .65537 L
.35593 .66827 L
.35577 .66831 L
.33173 .67237 L
.30769 .66961 L
.29998 .66827 L
.28365 .66046 L
.25962 .64444 L
.25936 .64423 L
.23625 .62019 L
.23558 .61932 L
.22054 .59615 L
.21154 .57736 L
.20952 .57212 L
.2022 .54808 L
.19795 .52404 L
.19655 .5 L
.19795 .47596 L
.2022 .45192 L
.20952 .42788 L
.21154 .42264 L
.22054 .40385 L
.23558 .38068 L
.23625 .37981 L
.25936 .35577 L
.25962 .35556 L
.28365 .33954 L
.29998 .33173 L
F
0 g
.30769 .33039 m
.33173 .32763 L
.35577 .33169 L
.35593 .33173 L
.37981 .34463 L
.39228 .35577 L
.40385 .37173 L
.40856 .37981 L
.41899 .40385 L
.42583 .42788 L
.42788 .43726 L
.43011 .45192 L
.43247 .47596 L
.43323 .5 L
.43247 .52404 L
.43011 .54808 L
.42788 .56274 L
.42583 .57212 L
.41899 .59615 L
.40856 .62019 L
.40385 .62827 L
.39228 .64423 L
.37981 .65537 L
.35593 .66827 L
.35577 .66831 L
.33173 .67237 L
.30769 .66961 L
.29998 .66827 L
.28365 .66046 L
.25962 .64444 L
.25936 .64423 L
.23625 .62019 L
.23558 .61932 L
.22054 .59615 L
.21154 .57736 L
.20952 .57212 L
.2022 .54808 L
.19795 .52404 L
.19655 .5 L
.19795 .47596 L
.2022 .45192 L
.20952 .42788 L
.21154 .42264 L
.22054 .40385 L
.23558 .38068 L
.23625 .37981 L
.25936 .35577 L
.25962 .35556 L
.28365 .33954 L
.29998 .33173 L
Mistroke
.30769 .33039 L
Mfstroke
.7 g
.28365 .3547 m
.30769 .34469 L
.33173 .34166 L
.35577 .34612 L
.37691 .35577 L
.37981 .36034 L
.39729 .37981 L
.40385 .39128 L
.40979 .40385 L
.4179 .42788 L
.42298 .45192 L
.4258 .47596 L
.42671 .5 L
.4258 .52404 L
.42298 .54808 L
.4179 .57212 L
.40979 .59615 L
.40385 .60872 L
.39729 .62019 L
.37981 .63966 L
.37691 .64423 L
.35577 .65388 L
.33173 .65834 L
.30769 .65531 L
.28365 .6453 L
.28172 .64423 L
.25962 .62736 L
.2525 .62019 L
.23558 .59796 L
.23446 .59615 L
.22225 .57212 L
.21418 .54808 L
.21154 .54091 L
.20957 .52404 L
.20808 .5 L
.20957 .47596 L
.21154 .45909 L
.21418 .45192 L
.22225 .42788 L
.23446 .40385 L
.23558 .40204 L
.2525 .37981 L
.25962 .37264 L
.28172 .35577 L
F
0 g
.28365 .3547 m
.30769 .34469 L
.33173 .34166 L
.35577 .34612 L
.37691 .35577 L
.37981 .36034 L
.39729 .37981 L
.40385 .39128 L
.40979 .40385 L
.4179 .42788 L
.42298 .45192 L
.4258 .47596 L
.42671 .5 L
.4258 .52404 L
.42298 .54808 L
.4179 .57212 L
.40979 .59615 L
.40385 .60872 L
.39729 .62019 L
.37981 .63966 L
.37691 .64423 L
.35577 .65388 L
.33173 .65834 L
.30769 .65531 L
.28365 .6453 L
.28172 .64423 L
.25962 .62736 L
.2525 .62019 L
.23558 .59796 L
.23446 .59615 L
.22225 .57212 L
.21418 .54808 L
.21154 .54091 L
.20957 .52404 L
.20808 .5 L
.20957 .47596 L
.21154 .45909 L
.21418 .45192 L
.22225 .42788 L
.23446 .40385 L
.23558 .40204 L
.2525 .37981 L
.25962 .37264 L
.28172 .35577 L
.28365 .3547 L
s
.8 g
.33173 .3548 m
.34161 .35577 L
.35577 .35969 L
.37981 .37547 L
.38425 .37981 L
.40043 .40385 L
.40385 .4115 L
.4099 .42788 L
.41581 .45192 L
.41904 .47596 L
.42008 .5 L
.41904 .52404 L
.41581 .54808 L
.4099 .57212 L
.40385 .5885 L
.40043 .59615 L
.38425 .62019 L
.37981 .62453 L
.35577 .64031 L
.34161 .64423 L
.33173 .6452 L
.31808 .64423 L
.30769 .64188 L
.28365 .63082 L
.26913 .62019 L
.25962 .61059 L
.248 .59615 L
.23558 .57485 L
.23431 .57212 L
.22548 .54808 L
.22046 .52404 L
.21883 .5 L
.22046 .47596 L
.22548 .45192 L
.23431 .42788 L
.23558 .42515 L
.248 .40385 L
.25962 .38941 L
.26913 .37981 L
.28365 .36918 L
.30769 .35812 L
.31808 .35577 L
F
0 g
.33173 .3548 m
.34161 .35577 L
.35577 .35969 L
.37981 .37547 L
.38425 .37981 L
.40043 .40385 L
.40385 .4115 L
.4099 .42788 L
.41581 .45192 L
.41904 .47596 L
.42008 .5 L
.41904 .52404 L
.41581 .54808 L
.4099 .57212 L
.40385 .5885 L
.40043 .59615 L
.38425 .62019 L
.37981 .62453 L
.35577 .64031 L
.34161 .64423 L
.33173 .6452 L
.31808 .64423 L
.30769 .64188 L
.28365 .63082 L
.26913 .62019 L
.25962 .61059 L
.248 .59615 L
.23558 .57485 L
.23431 .57212 L
.22548 .54808 L
.22046 .52404 L
.21883 .5 L
.22046 .47596 L
.22548 .45192 L
.23431 .42788 L
.23558 .42515 L
.248 .40385 L
.25962 .38941 L
.26913 .37981 L
.28365 .36918 L
.30769 .35812 L
.31808 .35577 L
.33173 .3548 L
s
.9 g
.30769 .37109 m
.33173 .36745 L
.35577 .37282 L
.37172 .37981 L
.37981 .39044 L
.39036 .40385 L
.40174 .42788 L
.40385 .43401 L
.40852 .45192 L
.41226 .47596 L
.41344 .5 L
.41226 .52404 L
.40852 .54808 L
.40385 .56599 L
.40174 .57212 L
.39036 .59615 L
.37981 .60956 L
.37172 .62019 L
.35577 .62718 L
.33173 .63255 L
.30769 .62891 L
.28566 .62019 L
.28365 .61664 L
.26176 .59615 L
.25962 .59338 L
.24608 .57212 L
.23631 .54808 L
.23558 .54733 L
.23084 .52404 L
.22907 .5 L
.23084 .47596 L
.23558 .45267 L
.23631 .45192 L
.24608 .42788 L
.25962 .40662 L
.26176 .40385 L
.28365 .38336 L
.28566 .37981 L
F
0 g
.30769 .37109 m
.33173 .36745 L
.35577 .37282 L
.37172 .37981 L
.37981 .39044 L
.39036 .40385 L
.40174 .42788 L
.40385 .43401 L
.40852 .45192 L
.41226 .47596 L
.41344 .5 L
.41226 .52404 L
.40852 .54808 L
.40385 .56599 L
.40174 .57212 L
.39036 .59615 L
.37981 .60956 L
.37172 .62019 L
.35577 .62718 L
.33173 .63255 L
.30769 .62891 L
.28566 .62019 L
.28365 .61664 L
.26176 .59615 L
.25962 .59338 L
.24608 .57212 L
.23631 .54808 L
.23558 .54733 L
.23084 .52404 L
.22907 .5 L
.23084 .47596 L
.23558 .45267 L
.23631 .45192 L
.24608 .42788 L
.25962 .40662 L
.26176 .40385 L
.28365 .38336 L
.28566 .37981 L
.30769 .37109 L
s
1 g
.28365 .39764 m
.30769 .38384 L
.33173 .37983 L
.35577 .38576 L
.37918 .40385 L
.37981 .40581 L
.39327 .42788 L
.40115 .45192 L
.40385 .46157 L
.40529 .47596 L
.40665 .5 L
.40529 .52404 L
.40385 .53843 L
.40115 .54808 L
.39327 .57212 L
.37981 .59419 L
.37918 .59615 L
.35577 .61424 L
.33173 .62017 L
.30769 .61616 L
.28365 .60236 L
.27641 .59615 L
.25962 .57475 L
.25803 .57212 L
.24695 .54808 L
.24091 .52404 L
.23898 .5 L
.24091 .47596 L
.24695 .45192 L
.25803 .42788 L
.25962 .42525 L
.27641 .40385 L
F
0 g
.28365 .39764 m
.30769 .38384 L
.33173 .37983 L
.35577 .38576 L
.37918 .40385 L
.37981 .40581 L
.39327 .42788 L
.40115 .45192 L
.40385 .46157 L
.40529 .47596 L
.40665 .5 L
.40529 .52404 L
.40385 .53843 L
.40115 .54808 L
.39327 .57212 L
.37981 .59419 L
.37918 .59615 L
.35577 .61424 L
.33173 .62017 L
.30769 .61616 L
.28365 .60236 L
.27641 .59615 L
.25962 .57475 L
.25803 .57212 L
.24695 .54808 L
.24091 .52404 L
.23898 .5 L
.24091 .47596 L
.24695 .45192 L
.25803 .42788 L
.25962 .42525 L
.27641 .40385 L
.28365 .39764 L
s
.1 g
.62019 .21123 m
.64423 .20436 L
.66827 .20204 L
.69231 .20362 L
.71635 .2086 L
.7266 .21154 L
.74038 .2171 L
.76442 .22912 L
.77536 .23558 L
.78846 .24477 L
.80695 .25962 L
.8125 .26469 L
.83095 .28365 L
.83654 .2901 L
.85004 .30769 L
.86058 .32309 L
.86565 .33173 L
.87842 .35577 L
.88462 .36912 L
.88865 .37981 L
.89666 .40385 L
.90298 .42788 L
.90749 .45192 L
.90865 .45627 L
.90997 .47596 L
.91074 .5 L
.90997 .52404 L
.90865 .54373 L
.90749 .54808 L
.90298 .57212 L
.89666 .59615 L
.88865 .62019 L
.88462 .63088 L
.87842 .64423 L
.86565 .66827 L
.86058 .67691 L
.85004 .69231 L
.83654 .7099 L
.83095 .71635 L
.8125 .73531 L
.80695 .74038 L
.78846 .75523 L
.77536 .76442 L
.76442 .77088 L
.74038 .7829 L
.7266 .78846 L
.71635 .7914 L
.69231 .79638 L
.66827 .79796 L
.64423 .79564 L
.62019 .78877 L
.61936 .78846 L
.59615 .7749 L
.58365 .76442 L
.57212 .75108 L
.56487 .74038 L
.55227 .71635 L
.54808 .70629 L
.54591 .69231 L
.54098 .66827 L
.53571 .64423 L
.53106 .62019 L
.52737 .59615 L
.52464 .57212 L
.52404 .56573 L
.52321 .54808 L
.52249 .52404 L
.52226 .5 L
.52249 .47596 L
.52321 .45192 L
.52404 .43427 L
.52464 .42788 L
.52737 .40385 L
.53106 .37981 L
.53571 .35577 L
.54098 .33173 L
.54591 .30769 L
.54808 .29371 L
.55227 .28365 L
.56487 .25962 L
.57212 .24892 L
.58365 .23558 L
.59615 .2251 L
.61936 .21154 L
F
0 g
.62019 .21123 m
.64423 .20436 L
.66827 .20204 L
.69231 .20362 L
.71635 .2086 L
.7266 .21154 L
.74038 .2171 L
.76442 .22912 L
.77536 .23558 L
.78846 .24477 L
.80695 .25962 L
.8125 .26469 L
.83095 .28365 L
.83654 .2901 L
.85004 .30769 L
.86058 .32309 L
.86565 .33173 L
.87842 .35577 L
.88462 .36912 L
.88865 .37981 L
.89666 .40385 L
.90298 .42788 L
.90749 .45192 L
.90865 .45627 L
.90997 .47596 L
.91074 .5 L
.90997 .52404 L
.90865 .54373 L
.90749 .54808 L
.90298 .57212 L
.89666 .59615 L
.88865 .62019 L
.88462 .63088 L
.87842 .64423 L
.86565 .66827 L
.86058 .67691 L
.85004 .69231 L
.83654 .7099 L
.83095 .71635 L
.8125 .73531 L
.80695 .74038 L
.78846 .75523 L
.77536 .76442 L
.76442 .77088 L
.74038 .7829 L
.7266 .78846 L
.71635 .7914 L
.69231 .79638 L
.66827 .79796 L
.64423 .79564 L
Mistroke
.62019 .78877 L
.61936 .78846 L
.59615 .7749 L
.58365 .76442 L
.57212 .75108 L
.56487 .74038 L
.55227 .71635 L
.54808 .70629 L
.54591 .69231 L
.54098 .66827 L
.53571 .64423 L
.53106 .62019 L
.52737 .59615 L
.52464 .57212 L
.52404 .56573 L
.52321 .54808 L
.52249 .52404 L
.52226 .5 L
.52249 .47596 L
.52321 .45192 L
.52404 .43427 L
.52464 .42788 L
.52737 .40385 L
.53106 .37981 L
.53571 .35577 L
.54098 .33173 L
.54591 .30769 L
.54808 .29371 L
.55227 .28365 L
.56487 .25962 L
.57212 .24892 L
.58365 .23558 L
.59615 .2251 L
.61936 .21154 L
.62019 .21123 L
Mfstroke
.2 g
.62019 .25786 m
.64423 .24951 L
.66827 .24674 L
.69231 .24863 L
.71635 .25464 L
.72997 .25962 L
.74038 .26477 L
.76442 .2793 L
.77048 .28365 L
.78846 .29888 L
.79739 .30769 L
.8125 .32494 L
.81766 .33173 L
.83355 .35577 L
.83654 .36094 L
.84587 .37981 L
.85564 .40385 L
.86058 .41884 L
.86289 .42788 L
.86778 .45192 L
.87073 .47596 L
.87171 .5 L
.87073 .52404 L
.86778 .54808 L
.86289 .57212 L
.86058 .58116 L
.85564 .59615 L
.84587 .62019 L
.83654 .63906 L
.83355 .64423 L
.81766 .66827 L
.8125 .67506 L
.79739 .69231 L
.78846 .70112 L
.77048 .71635 L
.76442 .7207 L
.74038 .73523 L
.72997 .74038 L
.71635 .74536 L
.69231 .75137 L
.66827 .75326 L
.64423 .75049 L
.62019 .74214 L
.61652 .74038 L
.59615 .72563 L
.58686 .71635 L
.57212 .69587 L
.57012 .69231 L
.55913 .66827 L
.55098 .64423 L
.54808 .63357 L
.54686 .62019 L
.54441 .59615 L
.54203 .57212 L
.54014 .54808 L
.53895 .52404 L
.53854 .5 L
.53895 .47596 L
.54014 .45192 L
.54203 .42788 L
.54441 .40385 L
.54686 .37981 L
.54808 .36643 L
.55098 .35577 L
.55913 .33173 L
.57012 .30769 L
.57212 .30413 L
.58686 .28365 L
.59615 .27437 L
.61652 .25962 L
F
0 g
.62019 .25786 m
.64423 .24951 L
.66827 .24674 L
.69231 .24863 L
.71635 .25464 L
.72997 .25962 L
.74038 .26477 L
.76442 .2793 L
.77048 .28365 L
.78846 .29888 L
.79739 .30769 L
.8125 .32494 L
.81766 .33173 L
.83355 .35577 L
.83654 .36094 L
.84587 .37981 L
.85564 .40385 L
.86058 .41884 L
.86289 .42788 L
.86778 .45192 L
.87073 .47596 L
.87171 .5 L
.87073 .52404 L
.86778 .54808 L
.86289 .57212 L
.86058 .58116 L
.85564 .59615 L
.84587 .62019 L
.83654 .63906 L
.83355 .64423 L
.81766 .66827 L
.8125 .67506 L
.79739 .69231 L
.78846 .70112 L
.77048 .71635 L
.76442 .7207 L
.74038 .73523 L
.72997 .74038 L
.71635 .74536 L
.69231 .75137 L
.66827 .75326 L
.64423 .75049 L
.62019 .74214 L
.61652 .74038 L
.59615 .72563 L
.58686 .71635 L
.57212 .69587 L
.57012 .69231 L
.55913 .66827 L
.55098 .64423 L
Mistroke
.54808 .63357 L
.54686 .62019 L
.54441 .59615 L
.54203 .57212 L
.54014 .54808 L
.53895 .52404 L
.53854 .5 L
.53895 .47596 L
.54014 .45192 L
.54203 .42788 L
.54441 .40385 L
.54686 .37981 L
.54808 .36643 L
.55098 .35577 L
.55913 .33173 L
.57012 .30769 L
.57212 .30413 L
.58686 .28365 L
.59615 .27437 L
.61652 .25962 L
.62019 .25786 L
Mfstroke
.3 g
.64423 .27716 m
.66827 .27407 L
.69231 .27617 L
.71635 .28292 L
.71837 .28365 L
.74038 .29456 L
.75994 .30769 L
.76442 .31131 L
.78586 .33173 L
.78846 .33463 L
.80483 .35577 L
.8125 .36761 L
.81926 .37981 L
.8303 .40385 L
.83654 .42111 L
.83847 .42788 L
.84398 .45192 L
.84727 .47596 L
.84836 .5 L
.84727 .52404 L
.84398 .54808 L
.83847 .57212 L
.83654 .57889 L
.8303 .59615 L
.81926 .62019 L
.8125 .63239 L
.80483 .64423 L
.78846 .66537 L
.78586 .66827 L
.76442 .68869 L
.75994 .69231 L
.74038 .70544 L
.71837 .71635 L
.71635 .71708 L
.69231 .72383 L
.66827 .72593 L
.64423 .72284 L
.62304 .71635 L
.62019 .71333 L
.59615 .69447 L
.59411 .69231 L
.577 .66827 L
.57212 .65888 L
.56602 .64423 L
.55828 .62019 L
.5526 .59615 L
.54855 .57212 L
.54808 .56888 L
.54725 .54808 L
.54656 .52404 L
.54631 .5 L
.54656 .47596 L
.54725 .45192 L
.54808 .43112 L
.54855 .42788 L
.5526 .40385 L
.55828 .37981 L
.56602 .35577 L
.57212 .34112 L
.577 .33173 L
.59411 .30769 L
.59615 .30553 L
.62019 .28667 L
.62304 .28365 L
F
0 g
.64423 .27716 m
.66827 .27407 L
.69231 .27617 L
.71635 .28292 L
.71837 .28365 L
.74038 .29456 L
.75994 .30769 L
.76442 .31131 L
.78586 .33173 L
.78846 .33463 L
.80483 .35577 L
.8125 .36761 L
.81926 .37981 L
.8303 .40385 L
.83654 .42111 L
.83847 .42788 L
.84398 .45192 L
.84727 .47596 L
.84836 .5 L
.84727 .52404 L
.84398 .54808 L
.83847 .57212 L
.83654 .57889 L
.8303 .59615 L
.81926 .62019 L
.8125 .63239 L
.80483 .64423 L
.78846 .66537 L
.78586 .66827 L
.76442 .68869 L
.75994 .69231 L
.74038 .70544 L
.71837 .71635 L
.71635 .71708 L
.69231 .72383 L
.66827 .72593 L
.64423 .72284 L
.62304 .71635 L
.62019 .71333 L
.59615 .69447 L
.59411 .69231 L
.577 .66827 L
.57212 .65888 L
.56602 .64423 L
.55828 .62019 L
.5526 .59615 L
.54855 .57212 L
.54808 .56888 L
.54725 .54808 L
.54656 .52404 L
Mistroke
.54631 .5 L
.54656 .47596 L
.54725 .45192 L
.54808 .43112 L
.54855 .42788 L
.5526 .40385 L
.55828 .37981 L
.56602 .35577 L
.57212 .34112 L
.577 .33173 L
.59411 .30769 L
.59615 .30553 L
.62019 .28667 L
.62304 .28365 L
.64423 .27716 L
Mfstroke
.4 g
.64423 .29832 m
.66827 .29489 L
.69231 .29722 L
.71635 .30475 L
.72318 .30769 L
.74038 .31772 L
.75884 .33173 L
.76442 .33687 L
.78178 .35577 L
.78846 .36452 L
.79841 .37981 L
.81086 .40385 L
.8125 .40756 L
.8198 .42788 L
.82597 .45192 L
.82961 .47596 L
.83082 .5 L
.82961 .52404 L
.82597 .54808 L
.8198 .57212 L
.8125 .59244 L
.81086 .59615 L
.79841 .62019 L
.78846 .63548 L
.78178 .64423 L
.76442 .66313 L
.75884 .66827 L
.74038 .68228 L
.72318 .69231 L
.71635 .69525 L
.69231 .70278 L
.66827 .70511 L
.64423 .70168 L
.62096 .69231 L
.62019 .69112 L
.59615 .6698 L
.59488 .66827 L
.57954 .64423 L
.57212 .6275 L
.56955 .62019 L
.56278 .59615 L
.55799 .57212 L
.55478 .54808 L
.55294 .52404 L
.55234 .5 L
.55294 .47596 L
.55478 .45192 L
.55799 .42788 L
.56278 .40385 L
.56955 .37981 L
.57212 .3725 L
.57954 .35577 L
.59488 .33173 L
.59615 .3302 L
.62019 .30888 L
.62096 .30769 L
F
0 g
.64423 .29832 m
.66827 .29489 L
.69231 .29722 L
.71635 .30475 L
.72318 .30769 L
.74038 .31772 L
.75884 .33173 L
.76442 .33687 L
.78178 .35577 L
.78846 .36452 L
.79841 .37981 L
.81086 .40385 L
.8125 .40756 L
.8198 .42788 L
.82597 .45192 L
.82961 .47596 L
.83082 .5 L
.82961 .52404 L
.82597 .54808 L
.8198 .57212 L
.8125 .59244 L
.81086 .59615 L
.79841 .62019 L
.78846 .63548 L
.78178 .64423 L
.76442 .66313 L
.75884 .66827 L
.74038 .68228 L
.72318 .69231 L
.71635 .69525 L
.69231 .70278 L
.66827 .70511 L
.64423 .70168 L
.62096 .69231 L
.62019 .69112 L
.59615 .6698 L
.59488 .66827 L
.57954 .64423 L
.57212 .6275 L
.56955 .62019 L
.56278 .59615 L
.55799 .57212 L
.55478 .54808 L
.55294 .52404 L
.55234 .5 L
.55294 .47596 L
.55478 .45192 L
.55799 .42788 L
.56278 .40385 L
.56955 .37981 L
Mistroke
.57212 .3725 L
.57954 .35577 L
.59488 .33173 L
.59615 .3302 L
.62019 .30888 L
.62096 .30769 L
.64423 .29832 L
Mfstroke
.5 g
.62019 .32775 m
.64423 .31604 L
.66827 .31227 L
.69231 .31483 L
.71635 .32317 L
.73228 .33173 L
.74038 .33755 L
.76106 .35577 L
.76442 .3594 L
.7804 .37981 L
.78846 .39271 L
.79429 .40385 L
.80425 .42788 L
.81106 .45192 L
.8125 .45514 L
.81495 .47596 L
.81622 .5 L
.81495 .52404 L
.8125 .54486 L
.81106 .54808 L
.80425 .57212 L
.79429 .59615 L
.78846 .60729 L
.7804 .62019 L
.76442 .6406 L
.76106 .64423 L
.74038 .66245 L
.73228 .66827 L
.71635 .67683 L
.69231 .68517 L
.66827 .68773 L
.64423 .68396 L
.62019 .67225 L
.61457 .66827 L
.59615 .64827 L
.59332 .64423 L
.58041 .62019 L
.57212 .597 L
.57188 .59615 L
.56633 .57212 L
.56268 .54808 L
.56058 .52404 L
.5599 .5 L
.56058 .47596 L
.56268 .45192 L
.56633 .42788 L
.57188 .40385 L
.57212 .403 L
.58041 .37981 L
.59332 .35577 L
.59615 .35173 L
.61457 .33173 L
F
0 g
.62019 .32775 m
.64423 .31604 L
.66827 .31227 L
.69231 .31483 L
.71635 .32317 L
.73228 .33173 L
.74038 .33755 L
.76106 .35577 L
.76442 .3594 L
.7804 .37981 L
.78846 .39271 L
.79429 .40385 L
.80425 .42788 L
.81106 .45192 L
.8125 .45514 L
.81495 .47596 L
.81622 .5 L
.81495 .52404 L
.8125 .54486 L
.81106 .54808 L
.80425 .57212 L
.79429 .59615 L
.78846 .60729 L
.7804 .62019 L
.76442 .6406 L
.76106 .64423 L
.74038 .66245 L
.73228 .66827 L
.71635 .67683 L
.69231 .68517 L
.66827 .68773 L
.64423 .68396 L
.62019 .67225 L
.61457 .66827 L
.59615 .64827 L
.59332 .64423 L
.58041 .62019 L
.57212 .597 L
.57188 .59615 L
.56633 .57212 L
.56268 .54808 L
.56058 .52404 L
.5599 .5 L
.56058 .47596 L
.56268 .45192 L
.56633 .42788 L
.57188 .40385 L
.57212 .403 L
.58041 .37981 L
.59332 .35577 L
Mistroke
.59615 .35173 L
.61457 .33173 L
.62019 .32775 L
Mfstroke
.6 g
.64423 .33169 m
.66827 .32763 L
.69231 .33039 L
.70002 .33173 L
.71635 .33954 L
.74038 .35556 L
.74064 .35577 L
.76375 .37981 L
.76442 .38068 L
.77946 .40385 L
.78846 .42264 L
.79048 .42788 L
.7978 .45192 L
.80205 .47596 L
.80345 .5 L
.80205 .52404 L
.7978 .54808 L
.79048 .57212 L
.78846 .57736 L
.77946 .59615 L
.76442 .61932 L
.76375 .62019 L
.74064 .64423 L
.74038 .64444 L
.71635 .66046 L
.70002 .66827 L
.69231 .66961 L
.66827 .67237 L
.64423 .66831 L
.64407 .66827 L
.62019 .65537 L
.60772 .64423 L
.59615 .62827 L
.59144 .62019 L
.58101 .59615 L
.57417 .57212 L
.57212 .56274 L
.56989 .54808 L
.56753 .52404 L
.56677 .5 L
.56753 .47596 L
.56989 .45192 L
.57212 .43726 L
.57417 .42788 L
.58101 .40385 L
.59144 .37981 L
.59615 .37173 L
.60772 .35577 L
.62019 .34463 L
.64407 .33173 L
F
0 g
.64423 .33169 m
.66827 .32763 L
.69231 .33039 L
.70002 .33173 L
.71635 .33954 L
.74038 .35556 L
.74064 .35577 L
.76375 .37981 L
.76442 .38068 L
.77946 .40385 L
.78846 .42264 L
.79048 .42788 L
.7978 .45192 L
.80205 .47596 L
.80345 .5 L
.80205 .52404 L
.7978 .54808 L
.79048 .57212 L
.78846 .57736 L
.77946 .59615 L
.76442 .61932 L
.76375 .62019 L
.74064 .64423 L
.74038 .64444 L
.71635 .66046 L
.70002 .66827 L
.69231 .66961 L
.66827 .67237 L
.64423 .66831 L
.64407 .66827 L
.62019 .65537 L
.60772 .64423 L
.59615 .62827 L
.59144 .62019 L
.58101 .59615 L
.57417 .57212 L
.57212 .56274 L
.56989 .54808 L
.56753 .52404 L
.56677 .5 L
.56753 .47596 L
.56989 .45192 L
.57212 .43726 L
.57417 .42788 L
.58101 .40385 L
.59144 .37981 L
.59615 .37173 L
.60772 .35577 L
.62019 .34463 L
.64407 .33173 L
Mistroke
.64423 .33169 L
Mfstroke
.7 g
.64423 .34612 m
.66827 .34166 L
.69231 .34469 L
.71635 .3547 L
.71828 .35577 L
.74038 .37264 L
.7475 .37981 L
.76442 .40204 L
.76554 .40385 L
.77775 .42788 L
.78582 .45192 L
.78846 .45909 L
.79043 .47596 L
.79192 .5 L
.79043 .52404 L
.78846 .54091 L
.78582 .54808 L
.77775 .57212 L
.76554 .59615 L
.76442 .59796 L
.7475 .62019 L
.74038 .62736 L
.71828 .64423 L
.71635 .6453 L
.69231 .65531 L
.66827 .65834 L
.64423 .65388 L
.62309 .64423 L
.62019 .63966 L
.60271 .62019 L
.59615 .60872 L
.59021 .59615 L
.5821 .57212 L
.57702 .54808 L
.5742 .52404 L
.57329 .5 L
.5742 .47596 L
.57702 .45192 L
.5821 .42788 L
.59021 .40385 L
.59615 .39128 L
.60271 .37981 L
.62019 .36034 L
.62309 .35577 L
F
0 g
.64423 .34612 m
.66827 .34166 L
.69231 .34469 L
.71635 .3547 L
.71828 .35577 L
.74038 .37264 L
.7475 .37981 L
.76442 .40204 L
.76554 .40385 L
.77775 .42788 L
.78582 .45192 L
.78846 .45909 L
.79043 .47596 L
.79192 .5 L
.79043 .52404 L
.78846 .54091 L
.78582 .54808 L
.77775 .57212 L
.76554 .59615 L
.76442 .59796 L
.7475 .62019 L
.74038 .62736 L
.71828 .64423 L
.71635 .6453 L
.69231 .65531 L
.66827 .65834 L
.64423 .65388 L
.62309 .64423 L
.62019 .63966 L
.60271 .62019 L
.59615 .60872 L
.59021 .59615 L
.5821 .57212 L
.57702 .54808 L
.5742 .52404 L
.57329 .5 L
.5742 .47596 L
.57702 .45192 L
.5821 .42788 L
.59021 .40385 L
.59615 .39128 L
.60271 .37981 L
.62019 .36034 L
.62309 .35577 L
.64423 .34612 L
s
.8 g
.66827 .3548 m
.68192 .35577 L
.69231 .35812 L
.71635 .36918 L
.73087 .37981 L
.74038 .38941 L
.752 .40385 L
.76442 .42515 L
.76569 .42788 L
.77452 .45192 L
.77954 .47596 L
.78117 .5 L
.77954 .52404 L
.77452 .54808 L
.76569 .57212 L
.76442 .57485 L
.752 .59615 L
.74038 .61059 L
.73087 .62019 L
.71635 .63082 L
.69231 .64188 L
.68192 .64423 L
.66827 .6452 L
.65839 .64423 L
.64423 .64031 L
.62019 .62453 L
.61575 .62019 L
.59957 .59615 L
.59615 .5885 L
.5901 .57212 L
.58419 .54808 L
.58096 .52404 L
.57992 .5 L
.58096 .47596 L
.58419 .45192 L
.5901 .42788 L
.59615 .4115 L
.59957 .40385 L
.61575 .37981 L
.62019 .37547 L
.64423 .35969 L
.65839 .35577 L
F
0 g
.66827 .3548 m
.68192 .35577 L
.69231 .35812 L
.71635 .36918 L
.73087 .37981 L
.74038 .38941 L
.752 .40385 L
.76442 .42515 L
.76569 .42788 L
.77452 .45192 L
.77954 .47596 L
.78117 .5 L
.77954 .52404 L
.77452 .54808 L
.76569 .57212 L
.76442 .57485 L
.752 .59615 L
.74038 .61059 L
.73087 .62019 L
.71635 .63082 L
.69231 .64188 L
.68192 .64423 L
.66827 .6452 L
.65839 .64423 L
.64423 .64031 L
.62019 .62453 L
.61575 .62019 L
.59957 .59615 L
.59615 .5885 L
.5901 .57212 L
.58419 .54808 L
.58096 .52404 L
.57992 .5 L
.58096 .47596 L
.58419 .45192 L
.5901 .42788 L
.59615 .4115 L
.59957 .40385 L
.61575 .37981 L
.62019 .37547 L
.64423 .35969 L
.65839 .35577 L
.66827 .3548 L
s
.9 g
.64423 .37282 m
.66827 .36745 L
.69231 .37109 L
.71434 .37981 L
.71635 .38336 L
.73824 .40385 L
.74038 .40662 L
.75392 .42788 L
.76369 .45192 L
.76442 .45267 L
.76916 .47596 L
.77093 .5 L
.76916 .52404 L
.76442 .54733 L
.76369 .54808 L
.75392 .57212 L
.74038 .59338 L
.73824 .59615 L
.71635 .61664 L
.71434 .62019 L
.69231 .62891 L
.66827 .63255 L
.64423 .62718 L
.62828 .62019 L
.62019 .60956 L
.60964 .59615 L
.59826 .57212 L
.59615 .56599 L
.59148 .54808 L
.58774 .52404 L
.58656 .5 L
.58774 .47596 L
.59148 .45192 L
.59615 .43401 L
.59826 .42788 L
.60964 .40385 L
.62019 .39044 L
.62828 .37981 L
F
0 g
.64423 .37282 m
.66827 .36745 L
.69231 .37109 L
.71434 .37981 L
.71635 .38336 L
.73824 .40385 L
.74038 .40662 L
.75392 .42788 L
.76369 .45192 L
.76442 .45267 L
.76916 .47596 L
.77093 .5 L
.76916 .52404 L
.76442 .54733 L
.76369 .54808 L
.75392 .57212 L
.74038 .59338 L
.73824 .59615 L
.71635 .61664 L
.71434 .62019 L
.69231 .62891 L
.66827 .63255 L
.64423 .62718 L
.62828 .62019 L
.62019 .60956 L
.60964 .59615 L
.59826 .57212 L
.59615 .56599 L
.59148 .54808 L
.58774 .52404 L
.58656 .5 L
.58774 .47596 L
.59148 .45192 L
.59615 .43401 L
.59826 .42788 L
.60964 .40385 L
.62019 .39044 L
.62828 .37981 L
.64423 .37282 L
s
1 g
.64423 .38576 m
.66827 .37983 L
.69231 .38384 L
.71635 .39764 L
.72359 .40385 L
.74038 .42525 L
.74197 .42788 L
.75305 .45192 L
.75909 .47596 L
.76102 .5 L
.75909 .52404 L
.75305 .54808 L
.74197 .57212 L
.74038 .57475 L
.72359 .59615 L
.71635 .60236 L
.69231 .61616 L
.66827 .62017 L
.64423 .61424 L
.62082 .59615 L
.62019 .59419 L
.60673 .57212 L
.59885 .54808 L
.59615 .53843 L
.59471 .52404 L
.59335 .5 L
.59471 .47596 L
.59615 .46157 L
.59885 .45192 L
.60673 .42788 L
.62019 .40581 L
.62082 .40385 L
F
0 g
.64423 .38576 m
.66827 .37983 L
.69231 .38384 L
.71635 .39764 L
.72359 .40385 L
.74038 .42525 L
.74197 .42788 L
.75305 .45192 L
.75909 .47596 L
.76102 .5 L
.75909 .52404 L
.75305 .54808 L
.74197 .57212 L
.74038 .57475 L
.72359 .59615 L
.71635 .60236 L
.69231 .61616 L
.66827 .62017 L
.64423 .61424 L
.62082 .59615 L
.62019 .59419 L
.60673 .57212 L
.59885 .54808 L
.59615 .53843 L
.59471 .52404 L
.59335 .5 L
.59471 .47596 L
.59615 .46157 L
.59885 .45192 L
.60673 .42788 L
.62019 .40581 L
.62082 .40385 L
.64423 .38576 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00C@3oool500000080oooo0P00000e0?ooo`@000000`3oool2000003L0oooo0P0000040?oo
o`800000=`3oool300000080oooo0P00000?0?ooo`00C`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000003D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000g0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0303oool004l0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0b
0?ooo`D0000000D0oooo0000003oool0oooo0000000>0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0380
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000>0?ooo`00C`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0<P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000003D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000e0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003P3oool0
04h0oooo0P0000040?ooo`800000=P3oool2000000@0oooo0P00000g0?ooo`800000103oool20000
03L0oooo0P0000030?ooo`8000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`000005000000L0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooon@00
00040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oo
ooT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3o
oooi000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool20000
00<0oooon@0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom:000000X06ATIDP00000:01TI
6DT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodL0
00004`0I6AU6000001@06ATIA@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080ooooA000000J01TI6Ch000006P0I6AU3000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooom1000001h06ATI?000000N01TI6D0000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooch000008`0I6ATh
000002<06ATI?@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo?000000W01TI6C@000009`0I6ATk000000D0oooo00<000000?ooo`3oool01@3oool000L0
oooo1@0000020?ooo`8000001@3oool00`000000oooo0?ooo`020?ooocX00000:`0I6AT`000002/0
6ATI>@0000050?ooo`030000003oool0oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo>000000^01TI6Bh0
0000;P0I6ATg000000D0oooo00<000000?ooo`3oool01@3oool000T0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo0080oooo0`0000020?ooocH00000<@0I6AT/00000340
6ATI=@0000030?ooo`<000001`3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`03
0000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooole000003<06ATI:P00000c01TI6C@0
00001@3oool00`000000oooo0?ooo`050?ooo`002@3oool01@000000oooo0?ooo`3oool000000080
oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oooc<00000=P0I6ATX000003H0
6ATI<P0000050?ooo`030000003oool0oooo00D0oooo00080?ooo`800000103oool2000000D0oooo
00<000000?ooo`3oool00P3ooolb000001P06ATI3P00000B01TI6BH000004P0I6AT>000001P06ATI
<@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<@00
000F01TI6@<000003P0c<c<2000001406ATI9000000A01TI6@8000003P0c<c<4000001D06ATI<000
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;`00000E
01TI6@<000004`0c<c<2000000l06ATI9000000?01TI6@800000500c<c<3000001@06ATI;P000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;P00000B01TI
6@@00000600c<c<3000000d06ATI8P00000=01TI6@<000006@0c<c<3000001806ATI;@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;@00000A01TI6@80
00007`0c<c<2000000/06ATI8@00000<01TI6@8000007`0c<c<2000001406ATI;00000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;000000@01TI6@800000
8`0c<c<00`0000006ATI01TI6@0901TI6B0000002`0I6AT00`000000<c<c03<c<`0Q03<c<`800000
400I6AT[000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
ool[000001006ATI00<0000003<c<`0c<c<0900c<c<2000000T06ATI7`00000:01TI6@8000009P0c
<c<00`0000006ATI01TI6@0>01TI6BX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooobX000003`0I6AT2000000l0<c<c2P00000@03<c<`030000000I6AT0
6ATI00L06ATI7P00000901TI6@030000000c<c<0<c<c00h0<c<c2P00000?03<c<`8000003`0I6ATY
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolY0000
00l06ATI00<0000003<c<`0c<c<0300c<c<3000000X0C4a<1P00000;03<c<`030000000I6AT06ATI
00H06ATI7@00000901TI6@030000000c<c<0<c<c00T0<c<c1P00000:04a<C0@000003@0c<c<00`00
00006ATI01TI6@0=01TI6BP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0
oooo:000000?01TI6@030000000c<c<0<c<c00X0<c<c0`00000C04a<C0@00000200c<c<00`000000
6ATI01TI6@0601TI6A`00000200I6AT00`000000<c<c03<c<`0603<c<`@00000501<C4`2000000`0
<c<c0P00000>01TI6BL00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo
9`00000?01TI6@030000000c<c<0<c<c00T0<c<c0P00000I04a<C0030000000c<c<0<c<c00L0<c<c
00<0000001TI6@0I6AT01@0I6ATL000000L06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<
04a<C00G04a<C0800000300c<c<00`0000006ATI01TI6@0<01TI6BH000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobH000003P0I6AT2000000X0<c<c0P00
000L04a<C0800000200c<c<00`0000006ATI01TI6@0501TI6AX000001`0I6AT00`000000<c<c03<c
<`0603<c<`800000701<C4`2000000/0<c<c00<0000001TI6@0I6AT0300I6ATU000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolU000000h06ATI00<00000
03<c<`0c<c<0200c<c<2000000l0C4a<1@00000<04a<C0030000000c<c<0<c<c00D0<c<c00<00000
01TI6@0I6AT01@0I6ATJ000000L06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00:
04a<C0D000003`1<C4`2000000X0<c<c00<0000001TI6@0I6AT0300I6ATT000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolT000000h06ATI00<0000003<c
<`0c<c<01`0c<c<2000000`0C4a<1@00000506IVIPD00000201<C4`00`000000<c<c03<c<`0503<c
<`030000000I6AT06ATI00@06ATI6P00000601TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<
C01<C4`01P1<C4`5000000D0IVIV1@00000<04a<C08000002@0c<c<00`0000006ATI01TI6@0;01TI
6B@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob@0
00003@0I6AT00`000000<c<c03<c<`0603<c<`8000002`1<C4`3000000l0IVIV0`00000604a<C080
00001P0c<c<00`0000006ATI01TI6@0401TI6AP000001P0I6AT00`000000<c<c03<c<`0403<c<`80
00001P1<C4`3000000l0IVIV1000000:04a<C0800000200c<c<2000000`06ATI8`0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo8`00000=01TI6@030000
000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`01`1<C4`4000001D0IVIV0P00000604a<C0030000
000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0100I6ATH000000H06ATI00<0000003<c<`0c<c<0
0`0c<c<00`000000C4a<04a<C00404a<C08000005P1VIVH3000000T0C4a<00<0000003<c<`0c<c<0
1`0c<c<00`0000006ATI01TI6@0:01TI6B8000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooob8000003@0I6AT00`000000<c<c03<c<`0603<c<`030000001<
C4`0C4a<00H0C4a<0P00000J06IVIP030000001<C4`0C4a<00D0C4a<00<0000003<c<`0c<c<00P0c
<c<00`0000006ATI01TI6@0401TI6AP000001P0I6AT00`000000<c<c03<c<`0203<c<`030000001<
C4`0C4a<00D0C4a<00<0000006IVIP1VIVH0601VIVH2000000P0C4a<00<0000003<c<`0c<c<01`0c
<c<00`0000006ATI01TI6@0:01TI6B4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooob4000003@0I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0
C4a<00D0C4a<0P00000906IVIPX000002P1VIVH2000000D0C4a<00<0000003<c<`0c<c<00`0c<c<0
0`0000006ATI01TI6@0301TI6AP000001@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0
C4a<00<0C4a<0P00000:06IVIPX000002@1VIVH2000000L0C4a<00<0000003<c<`0c<c<01P0c<c<0
0`0000006ATI01TI6@0:01TI6B4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooob4000003@0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<
00D0C4a<00<0000006IVIP1VIVH01P1VIVH3000000X0Ogmo1000000806IVIP030000001<C4`0C4a<
00<0C4a<00<0000003<c<`0c<c<00P0c<c<00`0000006ATI01TI6@0301TI6AP000001@0I6AT00`00
0000<c<c03<c<`0203<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH01P1VIVH40000
00X0Ogmo1000000706IVIP030000001<C4`0C4a<00D0C4a<00<0000003<c<`0c<c<01P0c<c<00`00
00006ATI01TI6@0:01TI6B0000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooob0000003@0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00D0
C4a<00<0000006IVIP1VIVH01@1VIVH200000140Ogmo0P00000706IVIP030000001<C4`0C4a<00<0
C4a<00<0000003<c<`0c<c<00P0c<c<00`0000006ATI01TI6@0301TI6AH000001@0I6AT00`000000
<c<c03<c<`0203<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH01@1VIVH200000180
Ogmo0P00000606IVIP030000001<C4`0C4a<00D0C4a<00<0000003<c<`0c<c<01@0c<c<00`000000
6ATI01TI6@0;01TI6Al000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooob000000300I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00@0C4a<
00<0000006IVIP1VIVH0101VIVH2000001D0Ogmo0P00000606IVIP800000101<C4`01@000000<c<c
03<c<`0c<c<0000000D06ATI5P00000501TI6@050000000c<c<0<c<c03<c<`000000101<C4`20000
00H0IVIV0P00000F07moO`030000001VIVH0IVIV00@0IVIV0P00000604a<C0030000000c<c<0<c<c
00D0<c<c00<0000001TI6@0I6AT02P0I6ATO000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolO000000`06ATI00<0000003<c<`0c<c<01P0c<c<00`000000
C4a<04a<C00404a<C0030000001VIVH0IVIV00<0IVIV0P00000807moO`T000000`1oOgl00`000000
Ogmo07moO`0207moO`8000001P1VIVH01@000000C4a<04a<C01<C4`0000000@0<c<c00<0000001TI
6@0I6AT00P0I6ATF000000@06ATI00<0000003<c<`0c<c<00P0c<c<01@000000C4a<04a<C01<C4`0
000000H0IVIV0P00000807moO`T00000201oOgl2000000H0IVIV00<0000004a<C01<C4`0101<C4`0
0`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI7P0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`8000000`3ooolO000000/06ATI00<0000003<c<`0c<c<01@0c<c<20000
00H0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0607moO`8000002@2IVIT40000
00H0Ogmo0P00000406IVIP030000001<C4`0C4a<0080C4a<00D0000003<c<`0c<c<0<c<c00000004
01TI6AH00000100I6AT01@000000<c<c03<c<`0c<c<0000000@0C4a<00<0000006IVIP1VIVH00P1V
IVH2000000H0Ogmo1000000909VIV@<000001`1oOgl00`000000IVIV06IVIP0406IVIP030000001<
C4`0C4a<00@0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6Ah00000103o
ool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo7P00000;01TI6@030000000c<c<0
<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`2000000@0IVIV0P00000707moO`8000003`2IVIT2
000000H0Ogmo00<0000006IVIP1VIVH00P1VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c00<0
000001TI6@0I6AT00P0I6ATF000000@06ATI00@0000003<c<`0c<c<00000101<C4`00`000000IVIV
06IVIP0206IVIP030000001oOgl0Ogmo00@0Ogmo0P00000@09VIV@8000001P1oOgl2000000D0IVIV
00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI
7@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo7P00
000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IV
IP0306IVIP030000001oOgl0Ogmo00D0Ogmo0P00000809VIV@D000001P2IVIT2000000D0Ogmo00D0
000006IVIP1VIVH0IVIV0000000404a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATF000000<0
6ATI00D0000003<c<`0c<c<0<c<c0000000404a<C0050000001VIVH0IVIV06IVIP0000001@1oOgl2
000000H0VIVI1@00000909VIV@8000001P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0
C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6Ad000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooad000002`0I6AT00`00
0000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH00`00
0000Ogmo07moO`0407moO`8000001P2IVIT4000000D0/k>c1000000409VIV@800000101oOgl01@00
0000IVIV06IVIP1VIVH0000000<0C4a<00D0000003<c<`0c<c<0<c<c0000000301TI6AD00000100I
6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`80
0000102IVIT4000000D0/k>c1@00000609VIV@8000001@1oOgl00`000000IVIV06IVIP0306IVIP03
0000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6A`0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooad00000
2P0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH0
0P1VIVH00`000000Ogmo07moO`0307moO`8000001P2IVIT2000000d0/k>c0P00000409VIV@030000
001oOgl0Ogmo0080Ogmo00D0000006IVIP1VIVH0IVIV0000000204a<C0050000000c<c<0<c<c03<c
<`000000100I6ATD000000@06ATI00@0000003<c<`0c<c<000000`1<C4`01@000000IVIV06IVIP1V
IVH0000000@0Ogmo00<0000009VIV@2IVIT00P2IVIT2000000h0/k>c0P00000609VIV@030000001o
Ogl0Ogmo00<0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00304a<C0030000000c
<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATK000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolL000000/06ATI00<0000003<c<`0c<c<01@0c<c<0
0`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl2
000000H0VIVI0P00000A0;>c/`8000000`2IVIT2000000<0Ogmo00@0000006IVIP1VIVH000000`1<
C4`01@000000<c<c03<c<`0c<c<0000000<06ATI5000000301TI6@050000000c<c<0<c<c03<c<`00
00000`1<C4`010000000IVIV06IVIP00000307moO`8000000`2IVIT200000180/k>c0P00000509VI
V@800000101oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c
<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6A/000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooa`000002P0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`03
0000002IVIT0VIVI00<0VIVI0`0000040;>c/`/000001P2c/k<2000000<0VIVI00@0000007moO`1o
Ogl000000`1VIVH010000000C4a<04a<C000000303<c<`040000000I6AT06ATI01TI6A@000000`0I
6AT01@000000<c<c03<c<`0c<c<000000080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`04
0000002IVIT0VIVI09VIV@8000001`2c/k<;000000@0/k>c0P00000509VIV@030000001oOgl0Ogmo
0080Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00D0<c<c00<0000001TI6@0I6AT02@0I6ATJ000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolK000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`000000
C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl00`000000
VIVI09VIV@0209VIV@8000001@2c/k<2000000/0c<c<0P0000050;>c/`030000002IVIT0VIVI0080
VIVI00@0000007moO`1oOgl000000P1VIVH010000000C4a<04a<C000000303<c<`040000000I6AT0
6ATI01TI6A@000000`0I6AT01`000000<c<c03<c<`0c<c<0000004a<C00000000`1VIVH010000000
Ogmo07moO`00000409VIV@030000002c/k<0/k>c00<0/k>c0`00000;0<c<c0800000102c/k<20000
00@0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<
00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI6AX000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa/000002P0I6AT00`000000
<c<c03<c<`0503<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000
Ogmo07moO`0207moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<00`2c/k<2000000l0
c<c<0P0000040;>c/`050000002IVIT0VIVI09VIV@0000000P1oOgl01@000000IVIV06IVIP1VIVH0
00000080C4a<00D0000003<c<`0c<c<0<c<c0000000301TI6A<000000P0I6AT01@000000<c<c03<c
<`0c<c<000000080C4a<00L0000006IVIP1VIVH0IVIV0000001oOgl0000000@0VIVI00<000000;>c
/`2c/k<00P2c/k<200000100c<c<0P0000040;>c/`030000002IVIT0VIVI0080VIVI00<0000007mo
O`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c
<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6AT000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooaX000002P0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`04
0000002IVIT0VIVI09VIV@800000102c/k<2000000P0c<c<1@0000060<c<c0030000002c/k<0/k>c
0080/k>c00D0000009VIV@2IVIT0VIVI0000000207moO`040000001VIVH0IVIV00000080C4a<00D0
000003<c<`0c<c<0<c<c0000000301TI6A8000000`0I6AT01`000000<c<c03<c<`0c<c<0000004a<
C00000000`1VIVH010000000Ogmo07moO`00000309VIV@030000002c/k<0/k>c0080/k>c00<00000
0<c<c03<c<`0103<c<`5000000T0c<c<0P0000030;>c/`8000000`2IVIT00`000000Ogmo07moO`02
07moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`05
03<c<`030000000I6AT06ATI00P06ATI6@0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo6P00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<
C01<C4`00P1<C4`00`000000IVIV06IVIP0306IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT0
0`000000/k>c0;>c/`030;>c/`030000003<c<`0c<c<00<0c<c<1@0000050>KViP@000000`3<c<`2
000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000207moO`060000001VIVH0IVIV0000001<C4`0
00000`0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00L0000003<c<`0c<c<0<c<c0000001<
C4`000000080IVIV00@0000007moO`1oOgl000000`2IVIT010000000/k>c0;>c/`2c/k<2000000<0
c<c<100000050>KViPD000001P3<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VI
V@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AT000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl00000
00<0VIVI00<000000;>c/`2c/k<00P2c/k<2000000<0c<c<0`00000>0>KViP8000000`3<c<`01@00
0000/k>c0;>c/`2c/k<000000080VIVI00@0000007moO`1oOgl000000P1VIVH010000000C4a<04a<
C000000203<c<`030000000I6AT06ATI00806ATI4@00000301TI6@040000000c<c<0<c<c00000080
C4a<00H0000006IVIP1VIVH0000007moO`00000309VIV@050000002c/k<0/k>c0;>c/`0000000`3<
c<`2000000h0i^KV0`0000040<c<c0030000002c/k<0/k>c0080/k>c00D0000009VIV@2IVIT0VIVI
0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c
03<c<`0503<c<`030000000I6AT06ATI00P06ATI600000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`8000000`3ooolI000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<
C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@030000
002c/k<0/k>c0080/k>c00@000000<c<c03<c<`0c<c<0P0000080>KViP@000001`3Vi^H200000080
c<c<0P0000020;>c/`040000002IVIT0VIVI00000080Ogmo00H0000006IVIP1VIVH0000004a<C000
000203<c<`030000000I6AT06ATI00806ATI4@00000301TI6@040000000c<c<0<c<c00000080C4a<
00<0000006IVIP0000000P1oOgl010000000VIVI09VIV@0000030;>c/`030000003<c<`0c<c<0080
00001`3Vi^H4000000P0i^KV0P0000030<c<c0030000002c/k<0/k>c0080/k>c00D0000009VIV@2I
VIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI600000040?ooo`8000001`3oool001D0
oooo00<000000?ooo`3oool00P3ooolI000000T06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VI
V@030000002c/k<0/k>c0080/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP030>KV
iP@00000103oool3000000H0i^KV00D000000<c<c03<c<`0c<c<000000020;>c/`030000002IVIT0
00000080Ogmo00H0000006IVIP1VIVH0000004a<C000000203<c<`030000000I6AT06ATI00806ATI
4@00000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl00`000000
VIVI000000030;>c/`040000003<c<`0c<c<000000H0i^KV0`0000040?ooo`@000001P3Vi^H01@00
0000c<c<0<c<c03<c<`0000000@0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001V
IVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI
600000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000
000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IV
IP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0000000@0
c<c<00<000000>KViP3Vi^H00P3Vi^H2000000/0oooo0P0000040>KViP050000003<c<`0c<c<0<c<
c00000000P2c/k<010000000VIVI09VIV@00000207moO`030000001VIVH000000080C4a<00<00000
03<c<`000000100I6ATA000000<06ATI00<0000003<c<`0000000P1<C4`00`000000IVIV00000002
07moO`040000002IVIT0VIVI00000080/k>c00D000000<c<c03<c<`0c<c<000000040>KViP800000
2`3oool2000000D0i^KV00D000000<c<c03<c<`0c<c<000000030;>c/`050000002IVIT0VIVI09VI
V@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AL000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooaP000002@0I6AT00`000000<c<c03<c<`0403<c<`03
0000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl00000
00<0VIVI00D000000;>c/`2c/k<0/k>c000000040<c<c0030000003Vi^H0i^KV0080i^KV00<00000
0?ooo`3oool03@3oool2000000<0i^KV00D000000<c<c03<c<`0c<c<000000020;>c/`030000002I
VIT000000080Ogmo00<0000006IVIP0000000P1<C4`00`000000<c<c0000000401TI6A0000000`0I
6AT010000000<c<c03<c<`00000204a<C0030000001VIVH000000080Ogmo00<0000009VIV@000000
0P2c/k<01@000000c<c<0<c<c03<c<`0000000<0i^KV0P00000?0?ooo`800000103Vi^H01@000000
c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0
IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo60000009
01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1V
IVH0000000<0Ogmo00D0000009VIV@2IVIT0VIVI000000030;>c/`040000003<c<`0c<c<0<c<c080
00000`3Vi^H200000180oooo00D000000>KViP3Vi^H0i^KV000000030<c<c0030000002c/k<00000
0080VIVI00<0000007moO`0000000P1VIVH00`000000C4a<0000000203<c<`040000000I6AT06ATI
01TI6A0000000`0I6AT010000000<c<c03<c<`00000204a<C0030000001VIVH000000080Ogmo00<0
000009VIV@0000000P2c/k<010000000c<c<0<c<c00000030>KViP030000003oool0oooo0140oooo
0P0000030>KViP050000003<c<`0c<c<0<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT00000
00<0Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c00@0<c<c00<00000
01TI6@0I6AT01`0I6ATG000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolG000000T06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<
C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@040000002c/k<0
/k>c000000<0c<c<00<000000>KViP3Vi^H00P3Vi^H00`000000oooo0?ooo`0C0?ooo`8000000P3V
i^H010000000c<c<0<c<c00000020;>c/`030000002IVIT000000080Ogmo00<0000006IVIP000000
0P1<C4`00`000000<c<c0000000301TI6A0000000`0I6AT00`000000<c<c0000000204a<C0030000
001VIVH000000080Ogmo00<0000009VIV@0000000P2c/k<010000000c<c<0<c<c00000020>KViP80
00005P3oool01@000000i^KV0>KViP3Vi^H0000000<0c<c<00@000000;>c/`2c/k<000000`2IVIT0
1@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c
<`0403<c<`030000000I6AT06ATI00P06ATI5P0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo5`00000901TI6@030000000c<c<0<c<c00@0<c<c00<00000
04a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VIV@2IVIT0VIVI
000000020;>c/`050000003<c<`0c<c<0<c<c00000000`3Vi^H2000001P0oooo00@000000>KViP3V
i^H000000P3<c<`00`000000/k>c0000000209VIV@050000001oOgl0000006IVIP0000000P1<C4`0
0`000000<c<c0000000301TI6A0000000`0I6AT00`000000<c<c0000000204a<C0030000001VIVH0
00000080Ogmo00D0000009VIV@000000/k>c000000020<c<c0040000003Vi^H0i^KV000001T0oooo
00D000000>KViP3Vi^H0i^KV000000030<c<c0040000002c/k<0/k>c000000<0VIVI00D0000007mo
O`1oOgl0Ogmo0000000306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<0
0`0000006ATI01TI6@0701TI6AH000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?oooaL000002@0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<
0080C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`070000002IVIT0VIVI09VIV@000000/k>c
000000030<c<c0050000003Vi^H0i^KV0>KViP0000006P3oool010000000i^KV0>KViP0000020<c<
c0030000002c/k<000000080VIVI00D0000007moO`000000IVIV0000000204a<C0030000000c<c<0
000000<06ATI4000000301TI6@030000000c<c<000000080C4a<00<0000006IVIP0000000P1oOgl0
10000000VIVI0000000000030<c<c0040000003Vi^H0i^KV000001X0oooo00D000000>KViP3Vi^H0
i^KV000000020<c<c0040000002c/k<0/k>c000000<0VIVI00D0000007moO`1oOgl0Ogmo00000003
06IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@07
01TI6AH000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
oaH000002@0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00@0000006IV
IP1VIVH000000`1oOgl01@000000VIVI09VIV@2IVIT000000080/k>c00@000000<c<c03<c<`00000
0`3Vi^H00`000000oooo0?ooo`0J0?ooo`040000003Vi^H0i^KV00000080c<c<00L000000;>c/`00
0000VIVI0000001oOgl000000080IVIV00D0000004a<C0000000<c<c0000000301TI6A0000000`0I
6AT00`000000<c<c0000000204a<C0090000001VIVH0000007moO`000000VIVI0000002c/k<00000
0080c<c<00@000000>KViP3Vi^H00000703oool010000000i^KV0>KViP0000030<c<c0040000002c
/k<0/k>c000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000206IVIP030000001<C4`0C4a<00<0
C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6AD000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaH000002@0I6AT00`000000<c<c
03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`07
0000002IVIT0VIVI09VIV@000000/k>c000000030<c<c0040000003Vi^H0i^KV000001d0oooo00@0
00000>KViP3Vi^H000000P3<c<`01`000000/k>c0000002IVIT0000007moO`0000000P1VIVH01@00
0000C4a<0000000c<c<0000000<06ATI4000000301TI6@030000000c<c<000000080C4a<00T00000
06IVIP000000Ogmo0000002IVIT000000;>c/`0000000P3<c<`010000000i^KV0>KViP00000L0?oo
o`050000003Vi^H0i^KV0>KViP0000000P3<c<`010000000/k>c0;>c/`00000309VIV@050000001o
Ogl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT01`0I6ATE000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooolF000000T06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<
C00304a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl01@000000VIVI09VIV@2IVIT000000080
/k>c00@000000<c<c03<c<`000000`3Vi^H00`000000oooo0?ooo`0L0?ooo`080000003Vi^H0i^KV
0000003<c<`000000;>c/`00000209VIV@050000001oOgl0000006IVIP0000000P1<C4`00`000000
<c<c0000000301TI6@h000000`0I6AT00`000000<c<c0000000204a<C0030000001VIVH000000080
Ogmo00L0000009VIV@000000/k>c0000003<c<`000000080i^KV00<000000?ooo`3oool0703oool0
10000000i^KV0>KViP0000030<c<c0040000002c/k<0/k>c000000<0VIVI00@0000007moO`1oOgl0
00000`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I
6AT01`0I6ATE000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolF000000T06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00304a<C0050000
001VIVH0IVIV06IVIP0000000P1oOgl01`000000VIVI09VIV@2IVIT000000;>c/`0000000`3<c<`0
10000000i^KV0>KViP00000P0?ooo`030000003Vi^H000000080c<c<0P00000209VIV@050000001o
Ogl0000006IVIP0000000P1<C4`00`000000<c<c0000000301TI6@h000000`0I6AT00`000000<c<c
0000000204a<C0030000001VIVH000000080Ogmo00@0000009VIV@00000000000P3<c<`00`000000
i^KV0000000P0?ooo`040000003Vi^H0i^KV00000080c<c<00@000000;>c/`2c/k<000000`2IVIT0
10000000Ogmo07moO`00000306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<00`0c
<c<00`0000006ATI01TI6@0701TI6AD000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oooaD000002P0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0
C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`050000002IVIT0VIVI09VIV@000000
0P2c/k<010000000c<c<0<c<c00000020>KViP030000003oool0oooo01l0oooo00`000000>KViP3V
i^H000000<c<c0000000/k>c0000002IVIT0000007moO`00000206IVIP050000001<C4`0000003<c
<`0000000`0I6AT>000000<06ATI00<0000003<c<`0000000P1<C4`02`000000IVIV0000001oOgl0
000009VIV@000000/k>c0000003<c<`000000080i^KV00<000000?ooo`3oool07`3oool00`000000
i^KV000000030<c<c0040000002c/k<0/k>c00000080VIVI00D0000007moO`1oOgl0Ogmo00000003
06IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@07
01TI6A@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo5@00000:01TI
6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH0
00000080Ogmo00D0000009VIV@2IVIT0VIVI000000020;>c/`040000003<c<`0c<c<00000080i^KV
00<000000?ooo`3oool0803oool02`000000i^KV0000003<c<`000000;>c/`000000VIVI0000001o
Ogl000000080IVIV00D0000004a<C0000000<c<c0000000301TI6@h000000`0I6AT00`000000<c<c
0000000204a<C00=0000001VIVH0000007moO`000000VIVI0000002c/k<000000<c<c0000000i^KV
0000000R0?ooo`040000003Vi^H0i^KV00000080c<c<00@000000;>c/`2c/k<000000`2IVIT01000
0000Ogmo07moO`00000306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<0
0`0000006ATI01TI6@0701TI6A@00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo
0080oooo5@00000:01TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@00
0000IVIV06IVIP1VIVH000000080Ogmo00L0000009VIV@2IVIT0VIVI0000002c/k<000000080c<c<
00@000000>KViP3Vi^H000008`3oool00`000000i^KV0>KViP02000000060;>c/`000000VIVI0000
001oOgl000000P1VIVH01@000000C4a<0000000c<c<0000000<06ATI3P00000301TI6@030000000c
<c<000000080C4a<00@0000006IVIP00000000000P2IVIT010000000/k>c0000000000020>KViP03
0000003oool0oooo0200oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c/`000003
09VIV@040000001oOgl0Ogmo000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c
<`0403<c<`030000000I6AT06ATI00L06ATI500000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo5@00000901TI6@030000000c<c<0<c<c00<0<c<c00<00000
04a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00D0000009VIV@2IVIT0VIVI
000000020;>c/`040000003<c<`0c<c<00000080i^KV00<000000?ooo`3oool08P3oool020000000
i^KV0000003<c<`000000;>c/`000000VIVI0P00000206IVIP050000001<C4`0000003<c<`000000
0`0I6AT>000000<06ATI00<0000003<c<`0000000P1<C4`010000000IVIV00000000000209VIV@80
000000@0c<c<0000003Vi^H00000903oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0
/k>c000000<0VIVI00@0000007moO`1oOgl000000`1VIVH00`000000C4a<04a<C00204a<C0030000
000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01`0I6ATD000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooolD000000X06ATI00<0000003<c<`0c<c<00`0c
<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl01`000000VIVI
09VIV@2IVIT000000;>c/`0000000P3<c<`010000000i^KV0>KViP00000U0?ooo`080000003Vi^H0
00000<c<c0000000/k>c0000002IVIT200000080IVIV00D0000004a<C0000000<c<c0000000301TI
6@h000000`0I6AT04@000000<c<c0000001<C4`0000006IVIP000000Ogmo0000002IVIT000000;>c
/`000000c<c<0000003Vi^H0000002@0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c
0;>c/`00000309VIV@040000001oOgl0Ogmo000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI500000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo5000000:01TI6@030000000c<c<0<c<c00<0
<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00L0000009VI
V@2IVIT0VIVI0000002c/k<000000080c<c<00@000000>KViP3Vi^H000009@3oool00`000000i^KV
0>KViP020000000<0;>c/`000000VIVI0000001oOgl0000006IVIP000000C4a<0000000c<c<00000
100I6AT=000000<06ATI00`0000003<c<`000000C4a<0000001VIVH0000007moO`000000VIVI0000
002c/k<200000080i^KV00<000000?ooo`3oool08`3oool010000000i^KV0>KViP0000020<c<c004
0000002c/k<0/k>c00000080VIVI00@0000007moO`1oOgl000000`1VIVH00`000000C4a<04a<C002
04a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT01`0I6ATC000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolD000000T06ATI00<0000003<c
<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl0
1`000000VIVI09VIV@2IVIT000000;>c/`0000000P3<c<`010000000i^KV0>KViP00000W0?ooo`06
0000003Vi^H000000<c<c0000000/k>c0P000000201oOgl0000006IVIP000000C4a<0000000c<c<0
0000100I6AT=000000<06ATI00X0000003<c<`000000C4a<0000001VIVH0000007moO`000000VIVI
0P000000103<c<`000000>KViP00000V0?ooo`040000003Vi^H0i^KV00000080c<c<00@000000;>c
/`2c/k<000000`2IVIT010000000Ogmo07moO`00000306IVIP030000001<C4`0C4a<0080C4a<00<0
000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0701TI6A<000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa@000002@0I6AT00`000000<c<c03<c<`03
03<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`070000002I
VIT0VIVI09VIV@000000/k>c000000020<c<c0040000003Vi^H0i^KV000002L0oooo00H000000>KV
iP000000c<c<0000002c/k<20000000807moO`000000IVIV0000001<C4`0000003<c<`00000401TI
6@d000000`0I6AT02P000000<c<c0000001<C4`0000006IVIP000000Ogmo0000002IVIT200000004
0<c<c0000000i^KV000002L0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c/`00
000209VIV@040000001oOgl0Ogmo000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c
03<c<`0303<c<`030000000I6AT06ATI00L06ATI4`0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo5000000901TI6@030000000c<c<0<c<c00<0<c<c00<0
000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT0
00000P2c/k<010000000c<c<0<c<c00000020>KViP030000003oool0oooo02D0oooo00H000000>KV
iP000000c<c<0000002c/k<20000000807moO`000000IVIV0000001<C4`0000003<c<`00000401TI
6@d000000`0I6AT02P000000<c<c0000001<C4`0000006IVIP000000Ogmo0000002IVIT200000003
0<c<c0000000000002P0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c/`000002
09VIV@040000001oOgl0Ogmo000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c
<`0303<c<`030000000I6AT06ATI00L06ATI4`0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo5000000901TI6@030000000c<c<0<c<c00<0<c<c00<00000
04a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT00000
0P2c/k<01P000000c<c<0<c<c0000000i^KV000002T0oooo0P0000000`3<c<`000000;>c/`020000
000807moO`000000IVIV0000001<C4`0000003<c<`00000401TI6@d000000`0I6AT02P000000<c<c
0000001<C4`0000006IVIP000000Ogmo0000002IVIT2000000030<c<c0000000000002T0oooo00<0
00000>KViP0000000P3<c<`010000000/k>c0;>c/`00000209VIV@040000001oOgl0Ogmo000000<0
IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00L0
6ATI4`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
5000000901TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000406IVIP03
0000001oOgl0000000<0VIVI00<000000;>c/`0000000P3<c<`010000000i^KV0>KViP00000Y0?oo
o`80000000<0c<c<0000002c/k<00P000000201oOgl0000006IVIP000000C4a<0000000c<c<00000
100I6AT<000000@06ATI00/0000003<c<`000000000006IVIP000000Ogmo0000002IVIT000000;>c
/`02000000030>KViP000000oooo02P0oooo00<000000>KViP0000000P3<c<`010000000/k>c0;>c
/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000
<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI4`0000050?ooo`030000003oool0oooo00D0
oooo00070?ooo`@000000`3oool2000000D0oooo00<000000?ooo`3oool00P3ooolC000000X06ATI
00<0000003<c<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@0000007moO`1o
Ogl000000P2IVIT010000000/k>c0;>c/`0000020<c<c0040000003Vi^H0i^KV000002T0oooo00@0
00000>KViP000000c<c<0P0000001`2IVIT0000007moO`000000IVIV0000001<C4`00P00000401TI
6@`00000100I6AT02`000000<c<c000000000000IVIV0000001oOgl0000009VIV@000000/k>c0080
000000<0i^KV0000003oool0:03oool010000000i^KV0>KViP0000020<c<c0030000002c/k<00000
00<0VIVI00@0000007moO`1oOgl000000`1VIVH01@000000C4a<04a<C01<C4`0000000H0<c<c00<0
000001TI6@0I6AT01`0I6ATB000000D0oooo00<000000?ooo`3oool01@3oool000L0oooo00<00000
0?ooo`3oool00`3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo4`00
000:01TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000
001oOgl0Ogmo00000080VIVI00@000000;>c/`2c/k<000000P3<c<`00`000000i^KV0000000Z0?oo
o`040000003Vi^H000000<c<c080000000L0VIVI0000001oOgl0000006IVIP000000C4a<00800000
100I6AT<000000@06ATI00/0000003<c<`000000000006IVIP000000Ogmo0000002IVIT000000;>c
/`02000000030>KViP000000oooo02T0oooo00<000000>KViP0000000P3<c<`010000000/k>c0;>c
/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00D0000004a<C01<C4`0C4a<0000000603<c
<`030000000I6AT06ATI00L06ATI4P0000050?ooo`030000003oool0oooo00D0oooo00080?ooo`03
0000003oool0oooo0080oooo00@000000?ooo`3oool00000103oool300000080oooo4`00000:01TI
6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0
Ogmo00000080VIVI00@000000;>c/`2c/k<000000P3<c<`00`000000i^KV0000000Z0?ooo`040000
003Vi^H000000<c<c080000000L0VIVI0000001oOgl0000006IVIP000000C4a<00800000100I6AT<
000000@06ATI00/0000003<c<`000000000006IVIP000000Ogmo0000002IVIT000000;>c/`020000
00030>KViP000000oooo02T0oooo00<000000>KViP0000000P3<c<`010000000/k>c0;>c/`000002
09VIV@040000001oOgl0Ogmo000000<0IVIV00D0000004a<C01<C4`0C4a<0000000603<c<`030000
000I6AT06ATI00L06ATI4P0000030?ooo`<000001`3oool000T0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooolC000000X06ATI
00<0000003<c<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@0000007moO`1o
Ogl000000P2IVIT010000000/k>c0;>c/`0000020<c<c0030000003Vi^H0000002X0oooo00@00000
0>KViP000000c<c<0P0000001`2IVIT0000007moO`000000IVIV0000001<C4`00P00000401TI6@`0
0000100I6AT02`000000<c<c000000000000IVIV0000001oOgl0000009VIV@000000/k>c00800000
00<0i^KV0000003oool0:@3oool00`000000i^KV000000020<c<c0040000002c/k<0/k>c00000080
VIVI00@0000007moO`1oOgl000000`1VIVH01@000000C4a<04a<C01<C4`0000000H0<c<c00<00000
01TI6@0I6AT01`0I6ATB000000D0oooo00<000000?ooo`3oool01@3oool000L0oooo00@000000?oo
o`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo4`00
000:01TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000
001oOgl0Ogmo00000080VIVI00@000000;>c/`2c/k<000000P3<c<`00`000000i^KV0000000Z0?oo
o`040000003Vi^H000000<c<c080000000L0VIVI0000001oOgl0000006IVIP000000C4a<00800000
100I6AT<000000@06ATI00/0000003<c<`000000000006IVIP000000Ogmo0000002IVIT000000;>c
/`02000000030>KViP000000oooo02T0oooo00<000000>KViP0000000P3<c<`010000000/k>c0;>c
/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00D0000004a<C01<C4`0C4a<0000000603<c
<`030000000I6AT06ATI00L06ATI4P0000050?ooo`030000003oool0oooo00D0oooo00080?ooo`80
0000103oool2000000D0oooo00<000000?ooo`3oool00P3ooolC000000T06ATI00<0000003<c<`0c
<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl01000
0000VIVI09VIV@0000020;>c/`030000003<c<`000000080i^KV00<000000?ooo`3oool0:03oool0
10000000i^KV0000003<c<`20000000709VIV@000000Ogmo0000001VIVH0000004a<C002000000@0
6ATI3000000401TI6@090000000c<c<000000000001VIVH0000007moO`000000VIVI0080000000@0
c<c<0000003Vi^H00000:P3oool00`000000i^KV000000020<c<c0040000002c/k<0/k>c00000080
VIVI00@0000007moO`1oOgl000000`1VIVH01@000000C4a<04a<C01<C4`0000000H0<c<c00<00000
01TI6@0I6AT01`0I6ATB000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolC000000T06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<
C0050000001VIVH0IVIV06IVIP0000000P1oOgl010000000VIVI09VIV@0000020;>c/`030000003<
c<`000000080i^KV00<000000?ooo`3oool0:03oool01P000000i^KV0000003<c<`000000;>c/`80
000000P0Ogmo0000001VIVH0000004a<C0000000<c<c000000<06ATI3000000401TI6@090000000c
<c<000000000001VIVH0000007moO`000000VIVI0080000000@0c<c<0000003Vi^H00000:P3oool0
1P000000i^KV0>KViP000000c<c<00000080/k>c00@0000009VIV@2IVIT000000P1oOgl01@000000
IVIV06IVIP1VIVH0000000@0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0701TI
6A8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa<0
00002@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1V
IVH0IVIV0000000207moO`040000002IVIT0VIVI00000080/k>c00<000000<c<c00000000P3Vi^H0
0`000000oooo0?ooo`0X0?ooo`060000003Vi^H000000<c<c0000000/k>c0P000000201oOgl00000
06IVIP000000C4a<0000000c<c<000000`0I6AT<000000@06ATI00T0000003<c<`000000000006IV
IP000000Ogmo0000002IVIT00P000000103<c<`000000>KViP00000Z0?ooo`060000003Vi^H0i^KV
0000003<c<`000000P2c/k<010000000VIVI09VIV@00000207moO`050000001VIVH0IVIV06IVIP00
0000101<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI4P0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo4`00000901TI6@030000
000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080
Ogmo00@0000009VIV@2IVIT000000P2c/k<00`000000c<c<000000020>KViP030000003oool0oooo
02P0oooo00H000000>KViP000000c<c<0000002c/k<20000000807moO`000000IVIV0000001<C4`0
000003<c<`00000301TI6@`00000100I6AT02@000000<c<c000000000000IVIV0000001oOgl00000
09VIV@02000000040<c<c0000000i^KV000002X0oooo00H000000>KViP3Vi^H000000<c<c0000002
0;>c/`040000002IVIT0VIVI00000080Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C0030000
000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01`0I6ATB000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooolC000000T06ATI00<0000003<c<`0c<c<00`0c
<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl010000000VIVI
09VIV@0000020;>c/`030000003<c<`000000080i^KV00<000000?ooo`3oool0:03oool01P000000
i^KV0000003<c<`000000;>c/`80000000P0Ogmo0000001VIVH0000004a<C0000000<c<c000000<0
6ATI3000000401TI6@090000000c<c<000000000001VIVH0000007moO`000000VIVI0080000000@0
c<c<0000003Vi^H00000:P3oool01P000000i^KV0>KViP000000c<c<00000080/k>c00@0000009VI
V@2IVIT000000P1oOgl01@000000IVIV06IVIP1VIVH0000000@0C4a<00<0000003<c<`0c<c<00`0c
<c<00`0000006ATI01TI6@0701TI6A8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oooa<000002@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0
C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`040000002IVIT0VIVI00000080/k>c
00<000000<c<c00000000P3Vi^H00`000000oooo0?ooo`0X0?ooo`060000003Vi^H000000<c<c000
0000/k>c0P000000201oOgl0000006IVIP000000C4a<0000000c<c<000000`0I6AT<000000@06ATI
00T0000003<c<`000000000006IVIP000000Ogmo0000002IVIT00P000000103<c<`000000>KViP00
000Z0?ooo`060000003Vi^H0i^KV0000003<c<`000000P2c/k<010000000VIVI09VIV@00000207mo
O`050000001VIVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT0
6ATI00L06ATI4P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo4`00000901TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@00
0000IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<00`000000c<c<0000
00020>KViP030000003oool0oooo02P0oooo00@000000>KViP000000c<c<0P0000001`2IVIT00000
07moO`000000IVIV0000001<C4`00P00000401TI6@`00000100I6AT02@000000<c<c000000000000
IVIV0000001oOgl0000009VIV@02000000040<c<c0000000i^KV000002X0oooo00<000000>KViP00
00000P3<c<`010000000/k>c0;>c/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00D00000
04a<C01<C4`0C4a<0000000603<c<`030000000I6AT06ATI00L06ATI4P0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo4`00000:01TI6@030000000c<c<0
<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI
00@000000;>c/`2c/k<000000P3<c<`00`000000i^KV0000000Z0?ooo`040000003Vi^H000000<c<
c080000000L0VIVI0000001oOgl0000006IVIP000000C4a<00800000100I6AT<000000@06ATI00/0
000003<c<`000000000006IVIP000000Ogmo0000002IVIT000000;>c/`02000000030>KViP000000
oooo02T0oooo00<000000>KViP0000000P3<c<`010000000/k>c0;>c/`00000209VIV@040000001o
Ogl0Ogmo000000<0IVIV00D0000004a<C01<C4`0C4a<0000000603<c<`030000000I6AT06ATI00L0
6ATI4P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
4`00000:01TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP04
0000001oOgl0Ogmo00000080VIVI00@000000;>c/`2c/k<000000P3<c<`00`000000i^KV0000000Z
0?ooo`040000003Vi^H000000<c<c080000000L0VIVI0000001oOgl0000006IVIP000000C4a<0080
0000100I6AT<000000@06ATI00/0000003<c<`000000000006IVIP000000Ogmo0000002IVIT00000
0;>c/`02000000030>KViP000000oooo02T0oooo00<000000>KViP0000000P3<c<`010000000/k>c
0;>c/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00D0000004a<C01<C4`0C4a<00000006
03<c<`030000000I6AT06ATI00L06ATI4P0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`8000000`3ooolC000000X06ATI00<0000003<c<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0
000000<0IVIV00@0000007moO`1oOgl000000P2IVIT010000000/k>c0;>c/`0000020<c<c0030000
003Vi^H0000002X0oooo00@000000>KViP000000c<c<0P0000001`2IVIT0000007moO`000000IVIV
0000001<C4`00P00000401TI6@`00000100I6AT02`000000<c<c000000000000IVIV0000001oOgl0
000009VIV@000000/k>c0080000000<0i^KV0000003oool0:@3oool00`000000i^KV000000020<c<
c0040000002c/k<0/k>c00000080VIVI00@0000007moO`1oOgl000000`1VIVH01@000000C4a<04a<
C01<C4`0000000H0<c<c00<0000001TI6@0I6AT01`0I6ATB000000@0oooo0P0000070?ooo`005@3o
ool00`000000oooo0?ooo`020?oooa<000002P0I6AT00`000000<c<c03<c<`0303<c<`050000001<
C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`00000209VIV@040000002c/k<0/k>c0000
0080c<c<00<000000>KViP000000:P3oool010000000i^KV0000003<c<`20000000709VIV@000000
Ogmo0000001VIVH0000004a<C002000000@06ATI3000000401TI6@0;0000000c<c<000000000001V
IVH0000007moO`000000VIVI0000002c/k<00P0000000`3Vi^H000000?ooo`0Y0?ooo`030000003V
i^H000000080c<c<00@000000;>c/`2c/k<000000P2IVIT010000000Ogmo07moO`00000306IVIP05
0000001<C4`0C4a<04a<C00000001P0c<c<00`0000006ATI01TI6@0701TI6A8000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa<000002P0I6AT00`000000
<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`000002
09VIV@040000002c/k<0/k>c00000080c<c<00@000000>KViP3Vi^H00000:@3oool010000000i^KV
0000003<c<`20000000709VIV@000000Ogmo0000001VIVH0000004a<C002000000@06ATI30000004
01TI6@0;0000000c<c<000000000001VIVH0000007moO`000000VIVI0000002c/k<00P0000000`3V
i^H000000?ooo`0X0?ooo`040000003Vi^H0i^KV00000080c<c<00@000000;>c/`2c/k<000000P2I
VIT010000000Ogmo07moO`00000306IVIP050000001<C4`0C4a<04a<C00000001P0c<c<00`000000
6ATI01TI6@0701TI6A8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?oooa<000002P0I6AT00`000000<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C000
00000`1VIVH010000000Ogmo07moO`00000309VIV@030000002c/k<000000080c<c<00@000000>KV
iP3Vi^H00000:@3oool010000000i^KV0000003<c<`20000000709VIV@000000Ogmo0000001VIVH0
000004a<C002000000@06ATI3000000401TI6@0;0000000c<c<000000000001VIVH0000007moO`00
0000VIVI0000002c/k<00P0000000`3Vi^H000000?ooo`0X0?ooo`030000003Vi^H0000000<0c<c<
00<000000;>c/`0000000`2IVIT00`000000Ogmo0000000406IVIP050000001<C4`0C4a<04a<C000
00001P0c<c<00`0000006ATI01TI6@0601TI6A<000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooa@000002@0I6AT00`000000<c<c03<c<`0303<c<`030000
001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`040000002IVIT0VIVI0000
0080/k>c00H000000<c<c03<c<`000000>KViP00000Y0?ooo`80000000<0c<c<0000002c/k<00P00
0000201oOgl0000006IVIP000000C4a<0000000c<c<00000100I6AT=000000<06ATI00X0000003<c
<`000000C4a<0000001VIVH0000007moO`000000VIVI0P0000000`3<c<`000000000000Y0?ooo`03
0000003Vi^H000000080c<c<00@000000;>c/`2c/k<000000P2IVIT010000000Ogmo07moO`000003
06IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@07
01TI6A<000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
oa@000002@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IV
IP1VIVH0IVIV0000000207moO`040000002IVIT0VIVI00000080/k>c00H000000<c<c03<c<`00000
0>KViP00000Y0?ooo`80000000<0c<c<0000002c/k<00P000000201oOgl0000006IVIP000000C4a<
0000000c<c<00000100I6AT=000000<06ATI00X0000003<c<`000000C4a<0000001VIVH0000007mo
O`000000VIVI0P0000000`3<c<`000000000000Y0?ooo`030000003Vi^H000000080c<c<00@00000
0;>c/`2c/k<000000P2IVIT010000000Ogmo07moO`00000306IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0701TI6A<000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa@000002@0I6AT00`000000<c<c03<c
<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`040000
002IVIT0VIVI00000080/k>c00@000000<c<c03<c<`000000P3Vi^H00`000000oooo0?ooo`0U0?oo
o`060000003Vi^H000000<c<c0000000/k>c0P000000201oOgl0000006IVIP000000C4a<0000000c
<c<00000100I6AT=000000<06ATI00X0000003<c<`000000C4a<0000001VIVH0000007moO`000000
VIVI0P000000103<c<`000000>KViP00000W0?ooo`040000003Vi^H0i^KV00000080c<c<00@00000
0;>c/`2c/k<000000P2IVIT010000000Ogmo07moO`00000306IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0701TI6A<000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa@000002@0I6AT00`000000<c<c03<c
<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`070000
002IVIT0VIVI09VIV@000000/k>c000000020<c<c0040000003Vi^H0i^KV000002L0oooo00H00000
0>KViP000000c<c<0000002c/k<20000000807moO`000000IVIV0000001<C4`0000003<c<`000004
01TI6@d000000`0I6AT02P000000<c<c0000001<C4`0000006IVIP000000Ogmo0000002IVIT20000
00040<c<c0000000i^KV000002L0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c
/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000
<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI4`0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo5000000901TI6@030000000c<c<0<c<c00<0<c<c
00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00L0000009VIV@2I
VIT0VIVI0000002c/k<000000080c<c<00@000000>KViP3Vi^H000009`3oool01P000000i^KV0000
003<c<`000000;>c/`80000000P0Ogmo0000001VIVH0000004a<C0000000<c<c000000@06ATI3@00
000301TI6@0:0000000c<c<0000004a<C0000000IVIV0000001oOgl0000009VIV@80000000@0c<c<
0000003Vi^H000009P3oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c000000<0
VIVI00@0000007moO`1oOgl000000`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00<0<c<c00<0000001TI6@0I6AT01`0I6ATC000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolD000000X06ATI00<0000003<c<`0c<c<00`0c<c<00`000000
C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl01`000000VIVI09VIV@2IVIT0
00000;>c/`0000000P3<c<`010000000i^KV0>KViP00000U0?ooo`0A0000003Vi^H000000<c<c000
0000/k>c0000002IVIT0000007moO`000000IVIV0000001<C4`0000003<c<`0000000`0I6AT>0000
00<06ATI00`0000003<c<`000000C4a<0000001VIVH0000007moO`000000VIVI0000002c/k<20000
0080i^KV00<000000?ooo`3oool08`3oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0
/k>c00000080VIVI00@0000007moO`1oOgl000000`1VIVH00`000000C4a<04a<C00204a<C0030000
000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT01`0I6ATC000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooolD000000X06ATI00<0000003<c<`0c<c<00`0c
<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl01`000000VIVI
09VIV@2IVIT000000;>c/`0000000P3<c<`010000000i^KV0>KViP00000U0?ooo`080000003Vi^H0
00000<c<c0000000/k>c0000002IVIT200000080IVIV00D0000004a<C0000000<c<c0000000301TI
6@h000000`0I6AT04@000000<c<c0000001<C4`0000006IVIP000000Ogmo0000002IVIT000000;>c
/`000000c<c<0000003Vi^H0000002@0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c
0;>c/`00000309VIV@040000001oOgl0Ogmo000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI500000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo5@00000901TI6@030000000c<c<0<c<c00<0
<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00D0000009VI
V@2IVIT0VIVI000000020;>c/`040000003<c<`0c<c<00000080i^KV00<000000?ooo`3oool08P3o
ool020000000i^KV0000003<c<`000000;>c/`000000VIVI0P00000206IVIP050000001<C4`00000
03<c<`0000000`0I6AT>000000<06ATI00<0000003<c<`0000000P1<C4`010000000IVIV00000000
000209VIV@80000000@0c<c<0000003Vi^H00000903oool010000000i^KV0>KViP0000020<c<c004
0000002c/k<0/k>c000000<0VIVI00@0000007moO`1oOgl000000`1VIVH00`000000C4a<04a<C002
04a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01`0I6ATD000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolE000000X06ATI00<0000003<c
<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl0
1`000000VIVI09VIV@2IVIT000000;>c/`0000000P3<c<`010000000i^KV0>KViP00000S0?ooo`0;
0000003Vi^H000000<c<c0000000/k>c0000002IVIT0000007moO`0000000P1VIVH01@000000C4a<
0000000c<c<0000000<06ATI3P00000301TI6@030000000c<c<000000080C4a<00P0000006IVIP00
0000Ogmo0000002IVIT000000;>c/`8000000P3Vi^H00`000000oooo0?ooo`0P0?ooo`040000003V
i^H0i^KV00000080c<c<00@000000;>c/`2c/k<000000`2IVIT010000000Ogmo07moO`00000306IV
IP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0701TI
6A@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo5@00000:01TI6@03
0000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH00000
0080Ogmo00D0000009VIV@2IVIT0VIVI000000020;>c/`040000003<c<`0c<c<00000080i^KV00<0
00000?ooo`3oool0803oool02`000000i^KV0000003<c<`000000;>c/`000000VIVI0000001oOgl0
00000080IVIV00D0000004a<C0000000<c<c0000000301TI6@h000000`0I6AT00`000000<c<c0000
000204a<C00=0000001VIVH0000007moO`000000VIVI0000002c/k<000000<c<c0000000i^KV0000
000R0?ooo`040000003Vi^H0i^KV00000080c<c<00@000000;>c/`2c/k<000000`2IVIT010000000
Ogmo07moO`00000306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0701TI6A@00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080
oooo5@00000:01TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000
IVIV06IVIP1VIVH0000000<0Ogmo00@0000009VIV@2IVIT000000P2c/k<01`000000c<c<0<c<c03<
c<`000000>KViP0000008@3oool00`000000i^KV000000020<c<c0070000002c/k<0000009VIV@00
0000Ogmo0000000206IVIP050000001<C4`0000003<c<`0000000`0I6AT>000000<06ATI00<00000
03<c<`0000000P1<C4`02`000000IVIV0000001oOgl0000009VIV@000000/k>c0000003<c<`00000
0080i^KV00<000000?ooo`3oool07`3oool00`000000i^KV000000030<c<c0030000002c/k<00000
00<0VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0C4a<0080C4a<00<00000
03<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6A@000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooaH000002@0I6AT00`000000<c<c03<c<`0303<c
<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`050000002IVIT0
VIVI09VIV@0000000P2c/k<010000000c<c<0<c<c00000020>KViP030000003oool0oooo01h0oooo
00L000000>KViP000000c<c<0000002c/k<000000080VIVI00D0000007moO`000000IVIV00000002
04a<C0030000000c<c<0000000<06ATI3P00000301TI6@030000000c<c<000000080C4a<00<00000
06IVIP0000000P1oOgl010000000VIVI0000000000020<c<c0030000003Vi^H000000200oooo00@0
00000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c/`00000309VIV@040000001oOgl0Ogmo0000
00<0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI
00L06ATI5@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo5P00000901TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00`1<C4`01@000000
IVIV06IVIP1VIVH0000000<0Ogmo00@0000009VIV@2IVIT000000P2c/k<01@000000c<c<0<c<c03<
c<`000000080i^KV00<000000?ooo`3oool0703oool00`000000i^KV000000020<c<c0070000002c
/k<0000009VIV@000000Ogmo0000000206IVIP050000001<C4`0000003<c<`0000000`0I6AT?0000
00<06ATI00<0000003<c<`0000000P1<C4`00`000000IVIV0000000207moO`070000002IVIT00000
0;>c/`000000c<c<000000020>KViP030000003oool0oooo01`0oooo00@000000>KViP3Vi^H00000
0`3<c<`00`000000/k>c0000000309VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000
C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT01`0I6ATE000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolF000000T06ATI
00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0040000001VIVH0IVIV000000<0
Ogmo00D0000009VIV@2IVIT0VIVI000000020;>c/`040000003<c<`0c<c<000000<0i^KV00<00000
0?ooo`3oool06P3oool010000000i^KV0>KViP0000020<c<c0070000002c/k<0000009VIV@000000
Ogmo0000000206IVIP050000001<C4`0000003<c<`0000000`0I6AT@000000<06ATI00<0000003<c
<`0000000P1<C4`02@000000IVIV0000001oOgl0000009VIV@000000/k>c000000020<c<c0040000
003Vi^H0i^KV000001`0oooo00D000000>KViP3Vi^H0i^KV000000020<c<c0040000002c/k<0/k>c
000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000206IVIP030000001<C4`0C4a<00<0C4a<00<0
000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6AD000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaL000002@0I6AT00`000000<c<c03<c<`03
03<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`040000002I
VIT0VIVI00000080/k>c00D000000<c<c03<c<`0c<c<000000030>KViP030000003oool0oooo01T0
oooo00<000000>KViP0000000P3<c<`00`000000/k>c0000000209VIV@050000001oOgl0000006IV
IP0000000P1<C4`00`000000<c<c0000000301TI6A0000000`0I6AT00`000000<c<c0000000204a<
C0030000001VIVH000000080Ogmo00@0000009VIV@00000000000P3<c<`010000000i^KV0>KViP00
000K0?ooo`050000003Vi^H0i^KV0>KViP0000000`3<c<`00`000000/k>c0000000309VIV@050000
001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0
<c<c00<0000001TI6@0I6AT01`0I6ATF000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooolG000000T06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<
04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl01@000000VIVI09VIV@2IVIT00000
0080/k>c00D000000<c<c03<c<`0c<c<000000030>KViP030000003oool0oooo01L0oooo00@00000
0>KViP3Vi^H000000P3<c<`00`000000/k>c0000000209VIV@050000001oOgl0000006IVIP000000
0P1<C4`00`000000<c<c0000000301TI6A0000000`0I6AT00`000000<c<c0000000204a<C0030000
001VIVH000000080Ogmo00D0000009VIV@000000/k>c000000020<c<c0040000003Vi^H0i^KV0000
01T0oooo00D000000>KViP3Vi^H0i^KV000000030<c<c0040000002c/k<0/k>c000000<0VIVI00D0
000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0
100c<c<00`0000006ATI01TI6@0701TI6AH000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooaL000002@0I6AT00`000000<c<c03<c<`0403<c<`030000001<
C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl000000080VIVI
00D000000;>c/`2c/k<0/k>c000000030<c<c0050000003Vi^H0i^KV0>KViP0000005`3oool01000
0000i^KV0>KViP0000020<c<c0060000002c/k<0/k>c0000002IVIT000000P1oOgl00`000000IVIV
0000000204a<C0030000000c<c<0000000<06ATI4000000301TI6@030000000c<c<000000080C4a<
00<0000006IVIP0000000P1oOgl00`000000VIVI000000020;>c/`040000003<c<`0c<c<00000080
i^KV00<000000?ooo`3oool05@3oool01@000000i^KV0>KViP3Vi^H0000000<0c<c<00D000000;>c
/`2c/k<0/k>c0000000209VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<
C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATF000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolH000000T06ATI00<00000
03<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000`1o
Ogl01@000000VIVI09VIV@2IVIT000000080/k>c00<000000<c<c03<c<`00P3<c<`01@000000i^KV
0>KViP3Vi^H0000001D0oooo00@000000>KViP3Vi^H000000`3<c<`00`000000/k>c0000000209VI
V@030000001oOgl000000080IVIV00<0000004a<C00000000P0c<c<0100000006ATI01TI6@0I6AT@
000000<06ATI00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`030000002I
VIT000000080/k>c00<000000<c<c00000000`3Vi^H00`000000oooo0?ooo`0C0?ooo`8000000P3V
i^H01@000000c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`05
0000001VIVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00L06ATI5`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo6000000901TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT010000000/k>c0;>c/`000004
0<c<c08000000P3Vi^H200000140oooo0P0000030>KViP040000003<c<`0c<c<00000080/k>c00<0
000009VIV@0000000P1oOgl00`000000IVIV0000000204a<C0030000000c<c<0000000@06ATI4000
000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl00`000000VIVI
000000020;>c/`040000003<c<`0c<c<000000<0i^KV0P00000A0?ooo`8000000`3Vi^H00`000000
c<c<0<c<c0020<c<c0040000002c/k<0/k>c000000<0VIVI00D0000007moO`1oOgl0Ogmo00000003
06IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@08
01TI6AL000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
oaP000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IV
IP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl000000080VIVI00D000000;>c/`2c/k<0/k>c0000
00050<c<c0040000003Vi^H0i^KV0>KViP8000003P3oool00`000000i^KV0>KViP020>KViP040000
003<c<`0c<c<00000080/k>c00@0000009VIV@2IVIT000000P1oOgl00`000000IVIV0000000204a<
C0030000000c<c<0000000@06ATI4@00000301TI6@030000000c<c<000000080C4a<00<0000006IV
IP0000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<000000@0i^KV00<0
00000?ooo`3oool0303oool2000000@0i^KV00<000000<c<c03<c<`00P3<c<`01@000000/k>c0;>c
/`2c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<0080
C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AL000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002@0I6AT00`000000<c<c
03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo
07moO`1oOgl0000000<0VIVI00@000000;>c/`2c/k<0/k>c0P0000040<c<c0030000003Vi^H0i^KV
0080i^KV100000070?ooo`<00000103Vi^H01@000000c<c<0<c<c03<c<`000000080/k>c00<00000
09VIV@0000000P1oOgl01P000000IVIV06IVIP000000C4a<00000080<c<c00<0000001TI6@0I6AT0
0P0I6ATA000000<06ATI00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`03
0000002IVIT0000000<0/k>c00@000000<c<c03<c<`00000103Vi^H3000000L0oooo100000050>KV
iP040000003<c<`0c<c<0<c<c08000000`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00D0
000006IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0
200I6ATH000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oooaT000002P0I
6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1V
IVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c/`2c/k<00P2c/k<01@000000c<c<
0<c<c03<c<`0000000P0i^KV1`0000060>KViP050000003<c<`0c<c<0<c<c00000000P2c/k<01000
0000VIVI09VIV@00000207moO`060000001VIVH0IVIV0000001<C4`000000P0c<c<00`0000006ATI
01TI6@0201TI6A4000000`0I6AT010000000<c<c03<c<`00000204a<C0030000001VIVH000000080
Ogmo00@0000009VIV@2IVIT000000`2c/k<010000000c<c<0<c<c00000060>KViPL00000203Vi^H0
1@000000c<c<0<c<c03<c<`0000000@0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000
001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000
000I6AT06ATI00P06ATI600000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3o
oolI000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0030000001V
IVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@030000002c/k<0/k>c0080/k>c
00@000000<c<c03<c<`0c<c<0P00000A0>KViP8000000P3<c<`200000080/k>c00@0000009VIV@2I
VIT000000P1oOgl010000000IVIV06IVIP00000204a<C0040000000c<c<0<c<c000000@06ATI4@00
000301TI6@040000000c<c<0<c<c00000080C4a<00H0000006IVIP1VIVH0000007moO`00000309VI
V@050000002c/k<0/k>c0;>c/`0000000P3<c<`200000140i^KV0P0000030<c<c0030000002c/k<0
/k>c0080/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0
000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI6000
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6P00000:
01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP02
06IVIP030000001oOgl0Ogmo0080Ogmo00D0000009VIV@2IVIT0VIVI000000040;>c/`8000000`3<
c<`2000000`0i^KV0`0000030<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT010000000Ogmo
07moO`00000206IVIP030000001<C4`0000000<0<c<c00@0000001TI6@0I6AT06ATI4P00000301TI
6@070000000c<c<0<c<c03<c<`000000C4a<0000000206IVIP040000001oOgl0Ogmo000000<0VIVI
00D000000;>c/`2c/k<0/k>c000000030<c<c0<00000303Vi^H2000000@0c<c<00<000000;>c/`2c
/k<00P2c/k<01@000000VIVI09VIV@2IVIT0000000@0Ogmo00D0000006IVIP1VIVH0IVIV00000005
04a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATI000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolJ000000X06ATI00<0000003<c
<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007mo
O`1oOgl00P1oOgl01@000000VIVI09VIV@2IVIT0000000D0/k>c00<000000<c<c03<c<`00P3<c<`4
000000D0i^KV0`0000050<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT010000000Ogmo07mo
O`00000306IVIP030000001<C4`0000000<0<c<c00@0000001TI6@0I6AT06ATI4P00000301TI6@07
0000000c<c<0<c<c03<c<`000000C4a<0000000306IVIP040000001oOgl0Ogmo000000<0VIVI00D0
00000;>c/`2c/k<0/k>c000000050<c<c0<000001@3Vi^H4000000@0c<c<0P0000040;>c/`050000
002IVIT0VIVI09VIV@000000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080
C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI6AT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaX000002`0I6AT00`000000<c<c
03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo
07moO`1oOgl0000000@0VIVI00<000000;>c/`2c/k<00`2c/k<2000000H0c<c<1@0000060<c<c080
00000`2c/k<00`000000VIVI09VIV@0209VIV@040000001oOgl0Ogmo00000080IVIV00@0000004a<
C01<C4`000000`0c<c<0100000006ATI01TI6@0I6ATC000000806ATI00D0000003<c<`0c<c<0<c<c
0000000204a<C0040000001VIVH0IVIV00000080Ogmo00<0000009VIV@2IVIT00P2IVIT010000000
/k>c0;>c/`2c/k<2000000H0c<c<1@0000060<c<c08000001@2c/k<00`000000VIVI09VIV@0209VI
V@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0
<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATI000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolK000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`00
0000C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP000000101oOgl00`000000VIVI09VIV@02
09VIV@8000001@2c/k<2000000h0c<c<00<000000;>c/`2c/k<00P2c/k<00`000000VIVI09VIV@02
09VIV@040000001oOgl0Ogmo000000<0IVIV00@0000004a<C01<C4`000000`0c<c<0100000006ATI
01TI6@0I6ATC000000806ATI00D0000003<c<`0c<c<0<c<c0000000204a<C0050000001VIVH0IVIV
06IVIP0000000P1oOgl00`000000VIVI09VIV@0209VIV@030000002c/k<0/k>c0080/k>c00<00000
0<c<c03<c<`0303<c<`2000000D0/k>c0P00000409VIV@030000001oOgl0Ogmo0080Ogmo00<00000
06IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00D0<c<c00<00000
01TI6@0I6AT0200I6ATJ000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolK000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<
C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl00`000000VIVI09VIV@0309VI
V@030000002c/k<0/k>c00@0/k>c0P00000:0<c<c08000001@2c/k<00`000000VIVI09VIV@0209VI
V@040000001oOgl0Ogmo00000080IVIV00@0000004a<C01<C4`000000`0c<c<0100000006ATI01TI
6@0I6ATD000000<06ATI00D0000003<c<`0c<c<0<c<c0000000204a<C0040000001VIVH0IVIV0000
0080Ogmo00<0000009VIV@2IVIT00P2IVIT00`000000/k>c0;>c/`030;>c/`8000002P3<c<`20000
00H0/k>c00<0000009VIV@2IVIT00`2IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV
0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00T06ATI6P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo7000000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000
IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00`2IVIT3000000D0
/k>c2P0000060;>c/`8000000`2IVIT010000000Ogmo07moO`00000306IVIP040000001<C4`0C4a<
000000<0<c<c00@0000001TI6@0I6AT06ATI5000000301TI6@050000000c<c<0<c<c03<c<`000000
0P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT0VIVI0P0000060;>c
/`X000001P2c/k<2000000D0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0306IV
IP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI
6AX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa`0
00002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1V
IVH00P1VIVH00`000000Ogmo07moO`0207moO`8000001P2IVIT3000000l0/k>c0`00000309VIV@80
00000`1oOgl010000000IVIV06IVIP00000304a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATD
000000<06ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0040000001VIVH0IVIV000000<0Ogmo
0P00000309VIV@<000003`2c/k<4000000D0VIVI0P00000407moO`030000001VIVH0IVIV00<0IVIV
00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI
6`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo7@00
000:01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IV
IP0206IVIP800000101oOgl2000000L0VIVI100000070;>c/`@00000102IVIT2000000@0Ogmo00D0
000006IVIP1VIVH0IVIV0000000204a<C0050000000c<c<0<c<c03<c<`000000100I6ATD000000@0
6ATI00D0000003<c<`0c<c<0<c<c0000000204a<C0050000001VIVH0IVIV06IVIP000000101oOgl2
000000@0VIVI100000070;>c/`@00000202IVIT00`000000Ogmo07moO`0207moO`800000101VIVH2
000000@0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0901TI6A/000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooad000002`0I6AT00`00
0000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00`1VIVH00`00
0000Ogmo07moO`0307moO`8000002@2IVIT7000000H0VIVI0P00000507moO`050000001VIVH0IVIV
06IVIP0000000`1<C4`01@000000<c<c03<c<`0c<c<0000000<06ATI5@00000401TI6@050000000c
<c<0<c<c03<c<`0000000`1<C4`01@000000IVIV06IVIP1VIVH0000000D0Ogmo0P00000609VIV@L0
00002P2IVIT2000000@0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00404a<C003
0000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATL000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolN000000/06ATI00<0000003<c<`0c<c<0
1@0c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl0
101oOgl00`000000VIVI09VIV@0B09VIV@030000001oOgl0Ogmo00@0Ogmo00D0000006IVIP1VIVH0
IVIV0000000404a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATF000000<06ATI00D0000003<c
<`0c<c<0<c<c0000000404a<C0050000001VIVH0IVIV06IVIP0000001P1oOgl00`000000VIVI09VI
V@0B09VIV@8000001@1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00@0C4a<00<0
000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6Ad000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?oooah000002`0I6AT00`000000<c<c03<c<`06
03<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`04
07moO`800000402IVIT2000000H0Ogmo00<0000006IVIP1VIVH00P1VIVH01@000000C4a<04a<C01<
C4`0000000<0<c<c00<0000001TI6@0I6AT00P0I6ATF000000@06ATI00D0000003<c<`0c<c<0<c<c
0000000304a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl0101oOgl200000100VIVI
0P00000607moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c
03<c<`0603<c<`030000000I6AT06ATI00T06ATI7@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`8000000`3ooolO000000/06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<
C00404a<C0030000001VIVH0IVIV00<0IVIV0P00000607moO`H000001`2IVIT3000000L0Ogmo00<0
000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0050000000c<c<0<c<c03<c<`000000
100I6ATF000000@06ATI00D0000003<c<`0c<c<0<c<c0000000404a<C0030000001VIVH0IVIV0080
IVIV00<0000007moO`1oOgl01@1oOgl3000000L0VIVI1P00000707moO`030000001VIVH0IVIV00@0
IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T0
6ATI7P0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooolO000000`06ATI
00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV00@0IVIV
0P00000:07moO`L00000201oOgl2000000@0IVIV00<0000004a<C01<C4`00P1<C4`01@000000<c<c
03<c<`0c<c<0000000D06ATI5P00000401TI6@030000000c<c<0<c<c0080<c<c00<0000004a<C01<
C4`00P1<C4`00`000000IVIV06IVIP0206IVIP800000201oOgl7000000/0Ogmo0P00000506IVIP80
00001P1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI7`0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo8000000<01TI6@030000
000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`0101<C4`2000000H0IVIV0`00000D07moO`800000
1@1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT0
0`0I6ATF000000D06ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<C00204a<C0030000
001VIVH0IVIV00<0IVIV0P00000E07moO`<000001@1VIVH2000000L0C4a<00<0000003<c<`0c<c<0
1@0c<c<00`0000006ATI01TI6@0:01TI6Al000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooob400000300I6AT00`000000<c<c03<c<`0603<c<`030000001<
C4`0C4a<00D0C4a<00<0000006IVIP1VIVH01P1VIVH3000000l0Ogmo0P00000506IVIP800000101<
C4`00`000000<c<c03<c<`0203<c<`030000000I6AT06ATI00<06ATI5`00000501TI6@030000000c
<c<0<c<c0080<c<c00<0000004a<C01<C4`00`1<C4`2000000D0IVIV0P00000?07moO`@000001`1V
IVH00`000000C4a<04a<C00504a<C08000001`0c<c<00`0000006ATI01TI6@0:01TI6B0000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob4000003@0I6AT0
0`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00D0C4a<0P00000906IVIP@000001`1oOgl4
000000H0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0203<c<`030000000I6AT0
6ATI00<06ATI6000000501TI6@030000000c<c<0<c<c0080<c<c00<0000004a<C01<C4`0101<C4`0
0`000000IVIV06IVIP0406IVIP@000001`1oOgl4000000T0IVIV0P00000704a<C0030000000c<c<0
<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATQ000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolR000000d06ATI00<0000003<c<`0c<c<01P0c<c<00`00
0000C4a<04a<C00604a<C08000002`1VIVH7000000T0IVIV00<0000004a<C01<C4`0101<C4`00`00
0000<c<c03<c<`0203<c<`030000000I6AT06ATI00@06ATI6000000501TI6@030000000c<c<0<c<c
00<0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP0706IVIPL000002`1VIVH20000
00P0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0:01TI6B4000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob<000003@0I6AT00`000000
<c<c03<c<`0603<c<`030000001<C4`0C4a<00L0C4a<00<0000006IVIP1VIVH05P1VIVH2000000H0
C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0401TI6AP000001P0I6AT00`000000
<c<c03<c<`0303<c<`030000001<C4`0C4a<00@0C4a<0P00000H06IVIP030000001<C4`0C4a<00L0
C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0:01TI6B8000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob@000003@0I6AT00`000000<c<c
03<c<`0603<c<`800000201<C4`300000180IVIV0`00000804a<C0030000000c<c<0<c<c00<0<c<c
00<0000001TI6@0I6AT0100I6ATH000000H06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<
04a<C00604a<C0<000004`1VIVH2000000P0C4a<0P00000803<c<`800000300I6ATS000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolT000000h06ATI00<0
000003<c<`0c<c<01`0c<c<2000000T0C4a<0`00000;06IVIP@000002@1<C4`2000000D0<c<c00<0
000001TI6@0I6AT0100I6ATI000000L06ATI00<0000003<c<`0c<c<00`0c<c<2000000T0C4a<1000
000;06IVIP@00000201<C4`2000000T0<c<c00<0000001TI6@0I6AT0300I6ATS000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolU000000h06ATI00<00000
03<c<`0c<c<0200c<c<00`000000C4a<04a<C00904a<C0/000002`1<C4`2000000H0<c<c00<00000
01TI6@0I6AT01@0I6ATJ000000L06ATI00<0000003<c<`0c<c<0100c<c<2000000/0C4a<2`00000;
04a<C0030000000c<c<0<c<c00P0<c<c00<0000001TI6@0I6AT0300I6ATT000000D0oooo00<00000
0?ooo`3oool01@3oool000P0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
obD000003`0I6AT2000000T0<c<c0P00000M04a<C0800000200c<c<00`0000006ATI01TI6@0501TI
6AX000001`0I6AT00`000000<c<c03<c<`0603<c<`8000007@1<C4`2000000X0<c<c00<0000001TI
6@0I6AT03@0I6ATT000000D0oooo00<000000?ooo`3oool01@3oool000L0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo9P00000@
01TI6@030000000c<c<0<c<c00P0<c<c0P00000J04a<C0030000000c<c<0<c<c00L0<c<c00<00000
01TI6@0I6AT01@0I6ATK000000P06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00H
04a<C08000002`0c<c<00`0000006ATI01TI6@0=01TI6BD000001@3oool00`000000oooo0?ooo`05
0?ooo`002@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool3
00000080oooo:000000?01TI6@030000000c<c<0<c<c00T0<c<c1000000E04a<C0800000200c<c<0
0`0000006ATI01TI6@0601TI6A`00000200I6AT00`000000<c<c03<c<`0603<c<`8000005P1<C4`3
000000`0<c<c00<0000001TI6@0I6AT0300I6ATW000000<0oooo0`0000070?ooo`002P3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooolY
000000l06ATI00<0000003<c<`0c<c<0300c<c<3000000l0C4a<0`00000903<c<`030000000I6AT0
6ATI00H06ATI7@00000901TI6@030000000c<c<0<c<c00L0<c<c0`00000?04a<C0@000003@0c<c<2
000000h06ATI:00000050?ooo`030000003oool0oooo00D0oooo00070?ooo`040000003oool0oooo
00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?ooobX000003`0I
6AT2000000l0<c<c1000000704a<C0@00000300c<c<00`0000006ATI01TI6@0601TI6Ah00000200I
6AT00`000000<c<c03<c<`0:03<c<`@000001`1<C4`4000000l0<c<c0P00000?01TI6BT000001@3o
ool00`000000oooo0?ooo`050?ooo`00203oool2000000@0oooo0P0000050?ooo`030000003oool0
oooo0080oooo:`00000@01TI6@030000000c<c<0<c<c0100<c<c1`00000?03<c<`030000000I6AT0
6ATI00H06ATI7`00000901TI6@030000000c<c<0<c<c00d0<c<c1`00000B03<c<`030000000I6AT0
6ATI00h06ATI:P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo;000000@01TI6@800000900c<c<2000000T06ATI8000000901TI6@800000900c<c<20000
01006ATI:`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo;@00000A01TI6@800000800c<c<2000000X06ATI8@00000;01TI6@800000800c<c<200000140
6ATI;00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
;P00000B01TI6@800000700c<c<2000000`06ATI8P00000<01TI6@800000700c<c<2000001806ATI
;@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;`00
000C01TI6@800000600c<c<2000000d06ATI9000000=01TI6@800000600c<c<2000001<06ATI;P00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<@00000C
01TI6@@000004@0c<c<3000000l06ATI9000000?01TI6@<000004@0c<c<4000001<06ATI<0000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<P00000F01TI
6@H000001`0c<c<4000001406ATI9P00000A01TI6@@000001`0c<c<6000001H06ATI<@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<`00000K01TI6@L0
0000500I6ATX000001@06ATI1`00000K01TI6C8000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooc@00000=00I6ATY000003D06ATI<`0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=@00000c01TI6BX00000<`0I
6ATd000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?ooocL00000<00I6AT/
000003006ATI=P0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3oooli0000
02`06ATI<000000/01TI6CP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooc/00000:@0I6ATb000002T06ATI>P0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo?@00000U01TI6CH000009@0I6ATl000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolo000002806ATI>000
000R01TI6Ch000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?oood4000007P0I6ATl000001h06ATI@00000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080ooooA000000H01TI6D8000006@0I6AU2000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom8000001406ATIB000000A01TI6DL0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool2000000<0oooon@0000040?ooo`8000001`3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo0P0000030?ooooT00000103oool2000000L0oooo000E0?oo
o`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
n@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooooi000000@0oooo0P0000070?ooo`00
5@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ooT000001@3oool00`000000oooo0?ooo`050?ooo`002@3oool300000080oooo0P0000050?ooo`03
0000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000:0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?ooooT0
00001@3oool00`000000oooo0?ooo`050?ooo`001`3oool5000000050?ooo`000000oooo0?ooo`00
0000103oool300000080oooon@0000030?ooo`<000001`3oool000L0oooo00@000000?ooo`3oool0
00000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooon@0000050?oo
o`030000003oool0oooo00D0oooo00080?ooo`030000003oool000000080oooo00@000000?ooo`3o
ool00000103oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?oo
o`002@3oool2000000<0oooo0P0000050?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03`0oooo00<0
00000?ooo`3oool0>`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00D0oooo000E0?ooool000001@0000070?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00
o`3ooolQ0?ooo`00SP3oool2000000040?ooo`000000000000000080oooo0P0000030?ooo`D00000
P03oool008h0oooo00D000000?ooo`3oool0oooo000000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool0P03oool008h0oooo00D000000?ooo`000000oooo000000020?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool0P03oool008h0oooo0P0000000`3oool0
0000000000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool0P03oool008h0
oooo0P0000000`3oool00000000000020?ooo`040000003oool0oooo000000@0oooo00<000000?oo
o`3oool0P03oool008h0oooo0P000000103oool000000000000000020?ooo`800000103oool20000
0880oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-3.26594, -1.76599, 0.160642, \
0.160642}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00480769 0.0240385 -0.00480769 0.0240385 [
[.23558 -0.0125 -6 -9 ]
[.23558 -0.0125 6 0 ]
[.47596 -0.0125 -6 -9 ]
[.47596 -0.0125 6 0 ]
[.71635 -0.0125 -6 -9 ]
[.71635 -0.0125 6 0 ]
[.95673 -0.0125 -6 -9 ]
[.95673 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .23558 -12 -4.5 ]
[-0.0125 .23558 0 4.5 ]
[-0.0125 .47596 -12 -4.5 ]
[-0.0125 .47596 0 4.5 ]
[-0.0125 .71635 -12 -4.5 ]
[-0.0125 .71635 0 4.5 ]
[-0.0125 .95673 -12 -4.5 ]
[-0.0125 .95673 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -11 0 ]
[.5 1.0125 11 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23558 0 m
.23558 .00625 L
s
[(10)] .23558 -0.0125 0 1 Mshowa
.47596 0 m
.47596 .00625 L
s
[(20)] .47596 -0.0125 0 1 Mshowa
.71635 0 m
.71635 .00625 L
s
[(30)] .71635 -0.0125 0 1 Mshowa
.95673 0 m
.95673 .00625 L
s
[(40)] .95673 -0.0125 0 1 Mshowa
.125 Mabswid
.04327 0 m
.04327 .00375 L
s
.09135 0 m
.09135 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.1875 0 m
.1875 .00375 L
s
.28365 0 m
.28365 .00375 L
s
.33173 0 m
.33173 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.42788 0 m
.42788 .00375 L
s
.52404 0 m
.52404 .00375 L
s
.57212 0 m
.57212 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.66827 0 m
.66827 .00375 L
s
.76442 0 m
.76442 .00375 L
s
.8125 0 m
.8125 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.90865 0 m
.90865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .23558 m
.00625 .23558 L
s
[(10)] -0.0125 .23558 1 0 Mshowa
0 .47596 m
.00625 .47596 L
s
[(20)] -0.0125 .47596 1 0 Mshowa
0 .71635 m
.00625 .71635 L
s
[(30)] -0.0125 .71635 1 0 Mshowa
0 .95673 m
.00625 .95673 L
s
[(40)] -0.0125 .95673 1 0 Mshowa
.125 Mabswid
0 .04327 m
.00375 .04327 L
s
0 .09135 m
.00375 .09135 L
s
0 .13942 m
.00375 .13942 L
s
0 .1875 m
.00375 .1875 L
s
0 .28365 m
.00375 .28365 L
s
0 .33173 m
.00375 .33173 L
s
0 .37981 m
.00375 .37981 L
s
0 .42788 m
.00375 .42788 L
s
0 .52404 m
.00375 .52404 L
s
0 .57212 m
.00375 .57212 L
s
0 .62019 m
.00375 .62019 L
s
0 .66827 m
.00375 .66827 L
s
0 .76442 m
.00375 .76442 L
s
0 .8125 m
.00375 .8125 L
s
0 .86058 m
.00375 .86058 L
s
0 .90865 m
.00375 .90865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.23558 .99375 m
.23558 1 L
s
.47596 .99375 m
.47596 1 L
s
.71635 .99375 m
.71635 1 L
s
.95673 .99375 m
.95673 1 L
s
.125 Mabswid
.04327 .99625 m
.04327 1 L
s
.09135 .99625 m
.09135 1 L
s
.13942 .99625 m
.13942 1 L
s
.1875 .99625 m
.1875 1 L
s
.28365 .99625 m
.28365 1 L
s
.33173 .99625 m
.33173 1 L
s
.37981 .99625 m
.37981 1 L
s
.42788 .99625 m
.42788 1 L
s
.52404 .99625 m
.52404 1 L
s
.57212 .99625 m
.57212 1 L
s
.62019 .99625 m
.62019 1 L
s
.66827 .99625 m
.66827 1 L
s
.76442 .99625 m
.76442 1 L
s
.8125 .99625 m
.8125 1 L
s
.86058 .99625 m
.86058 1 L
s
.90865 .99625 m
.90865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .23558 m
1 .23558 L
s
.99375 .47596 m
1 .47596 L
s
.99375 .71635 m
1 .71635 L
s
.99375 .95673 m
1 .95673 L
s
.125 Mabswid
.99625 .04327 m
1 .04327 L
s
.99625 .09135 m
1 .09135 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .1875 m
1 .1875 L
s
.99625 .28365 m
1 .28365 L
s
.99625 .33173 m
1 .33173 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .42788 m
1 .42788 L
s
.99625 .52404 m
1 .52404 L
s
.99625 .57212 m
1 .57212 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .66827 m
1 .66827 L
s
.99625 .76442 m
1 .76442 L
s
.99625 .8125 m
1 .8125 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .90865 m
1 .90865 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M11) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.5 Mabswid
.1 g
.28365 .11414 m
.30769 .10958 L
.33173 .10812 L
.35577 .11025 L
.37835 .11538 L
.37981 .11668 L
.40385 .12974 L
.41622 .13942 L
.42788 .15221 L
.43585 .16346 L
.44866 .1875 L
.45192 .19527 L
.45452 .21154 L
.45935 .23558 L
.46401 .25962 L
.46759 .28365 L
.46978 .30769 L
.47046 .33173 L
.46946 .35577 L
.46641 .37981 L
.46086 .40385 L
.45356 .42788 L
.45192 .43393 L
.43393 .45192 L
.42788 .45356 L
.40385 .46086 L
.37981 .46641 L
.35577 .46946 L
.33173 .47046 L
.30769 .46978 L
.28365 .46759 L
.25962 .46401 L
.23558 .45935 L
.21154 .45452 L
.19527 .45192 L
.1875 .44866 L
.16346 .43585 L
.15221 .42788 L
.13942 .41622 L
.12974 .40385 L
.11668 .37981 L
.11538 .37835 L
.11025 .35577 L
.10812 .33173 L
.10958 .30769 L
.11414 .28365 L
.11538 .27863 L
.12224 .25962 L
.13351 .23558 L
.13942 .22485 L
.14826 .21154 L
.16346 .19172 L
.16717 .1875 L
.1875 .16717 L
.19172 .16346 L
.21154 .14826 L
.22485 .13942 L
.23558 .13351 L
.25962 .12224 L
.27863 .11538 L
F
0 g
.28365 .11414 m
.30769 .10958 L
.33173 .10812 L
.35577 .11025 L
.37835 .11538 L
.37981 .11668 L
.40385 .12974 L
.41622 .13942 L
.42788 .15221 L
.43585 .16346 L
.44866 .1875 L
.45192 .19527 L
.45452 .21154 L
.45935 .23558 L
.46401 .25962 L
.46759 .28365 L
.46978 .30769 L
.47046 .33173 L
.46946 .35577 L
.46641 .37981 L
.46086 .40385 L
.45356 .42788 L
.45192 .43393 L
.43393 .45192 L
.42788 .45356 L
.40385 .46086 L
.37981 .46641 L
.35577 .46946 L
.33173 .47046 L
.30769 .46978 L
.28365 .46759 L
.25962 .46401 L
.23558 .45935 L
.21154 .45452 L
.19527 .45192 L
.1875 .44866 L
.16346 .43585 L
.15221 .42788 L
.13942 .41622 L
.12974 .40385 L
.11668 .37981 L
.11538 .37835 L
.11025 .35577 L
.10812 .33173 L
.10958 .30769 L
.11414 .28365 L
.11538 .27863 L
.12224 .25962 L
.13351 .23558 L
.13942 .22485 L
Mistroke
.14826 .21154 L
.16346 .19172 L
.16717 .1875 L
.1875 .16717 L
.19172 .16346 L
.21154 .14826 L
.22485 .13942 L
.23558 .13351 L
.25962 .12224 L
.27863 .11538 L
.28365 .11414 L
Mfstroke
.1 g
.21154 .54548 m
.23558 .54065 L
.25962 .53599 L
.28365 .53241 L
.30769 .53022 L
.33173 .52954 L
.35577 .53054 L
.37981 .53359 L
.40385 .53914 L
.42788 .54644 L
.43393 .54808 L
.45192 .56607 L
.45356 .57212 L
.46086 .59615 L
.46641 .62019 L
.46946 .64423 L
.47046 .66827 L
.46978 .69231 L
.46759 .71635 L
.46401 .74038 L
.45935 .76442 L
.45452 .78846 L
.45192 .80473 L
.44866 .8125 L
.43585 .83654 L
.42788 .84779 L
.41622 .86058 L
.40385 .87026 L
.37981 .88332 L
.37835 .88462 L
.35577 .88975 L
.33173 .89188 L
.30769 .89042 L
.28365 .88586 L
.27863 .88462 L
.25962 .87776 L
.23558 .86649 L
.22485 .86058 L
.21154 .85174 L
.19172 .83654 L
.1875 .83283 L
.16717 .8125 L
.16346 .80828 L
.14826 .78846 L
.13942 .77515 L
.13351 .76442 L
.12224 .74038 L
.11538 .72137 L
.11414 .71635 L
.10958 .69231 L
.10812 .66827 L
.11025 .64423 L
.11538 .62165 L
.11668 .62019 L
.12974 .59615 L
.13942 .58378 L
.15221 .57212 L
.16346 .56415 L
.1875 .55134 L
.19527 .54808 L
F
0 g
.21154 .54548 m
.23558 .54065 L
.25962 .53599 L
.28365 .53241 L
.30769 .53022 L
.33173 .52954 L
.35577 .53054 L
.37981 .53359 L
.40385 .53914 L
.42788 .54644 L
.43393 .54808 L
.45192 .56607 L
.45356 .57212 L
.46086 .59615 L
.46641 .62019 L
.46946 .64423 L
.47046 .66827 L
.46978 .69231 L
.46759 .71635 L
.46401 .74038 L
.45935 .76442 L
.45452 .78846 L
.45192 .80473 L
.44866 .8125 L
.43585 .83654 L
.42788 .84779 L
.41622 .86058 L
.40385 .87026 L
.37981 .88332 L
.37835 .88462 L
.35577 .88975 L
.33173 .89188 L
.30769 .89042 L
.28365 .88586 L
.27863 .88462 L
.25962 .87776 L
.23558 .86649 L
.22485 .86058 L
.21154 .85174 L
.19172 .83654 L
.1875 .83283 L
.16717 .8125 L
.16346 .80828 L
.14826 .78846 L
.13942 .77515 L
.13351 .76442 L
.12224 .74038 L
.11538 .72137 L
.11414 .71635 L
.10958 .69231 L
Mistroke
.10812 .66827 L
.11025 .64423 L
.11538 .62165 L
.11668 .62019 L
.12974 .59615 L
.13942 .58378 L
.15221 .57212 L
.16346 .56415 L
.1875 .55134 L
.19527 .54808 L
.21154 .54548 L
Mfstroke
.2 g
.28365 .15764 m
.30769 .15192 L
.33173 .15013 L
.35577 .15276 L
.37981 .16071 L
.38569 .16346 L
.40385 .17649 L
.41495 .1875 L
.42788 .20561 L
.43112 .21154 L
.44145 .23558 L
.44862 .25962 L
.45192 .27471 L
.45244 .28365 L
.45362 .30769 L
.45405 .33173 L
.45343 .35577 L
.45192 .37971 L
.45186 .37981 L
.44395 .40385 L
.42818 .42788 L
.42788 .42818 L
.40385 .44395 L
.37981 .45186 L
.37971 .45192 L
.35577 .45343 L
.33173 .45405 L
.30769 .45362 L
.28365 .45244 L
.27471 .45192 L
.25962 .44862 L
.23558 .44145 L
.21154 .43112 L
.20561 .42788 L
.1875 .41495 L
.17649 .40385 L
.16346 .38569 L
.16071 .37981 L
.15276 .35577 L
.15013 .33173 L
.15192 .30769 L
.15764 .28365 L
.16346 .26741 L
.16725 .25962 L
.18126 .23558 L
.1875 .22679 L
.20038 .21154 L
.21154 .20038 L
.22679 .1875 L
.23558 .18126 L
.25962 .16725 L
.26741 .16346 L
F
0 g
.28365 .15764 m
.30769 .15192 L
.33173 .15013 L
.35577 .15276 L
.37981 .16071 L
.38569 .16346 L
.40385 .17649 L
.41495 .1875 L
.42788 .20561 L
.43112 .21154 L
.44145 .23558 L
.44862 .25962 L
.45192 .27471 L
.45244 .28365 L
.45362 .30769 L
.45405 .33173 L
.45343 .35577 L
.45192 .37971 L
.45186 .37981 L
.44395 .40385 L
.42818 .42788 L
.42788 .42818 L
.40385 .44395 L
.37981 .45186 L
.37971 .45192 L
.35577 .45343 L
.33173 .45405 L
.30769 .45362 L
.28365 .45244 L
.27471 .45192 L
.25962 .44862 L
.23558 .44145 L
.21154 .43112 L
.20561 .42788 L
.1875 .41495 L
.17649 .40385 L
.16346 .38569 L
.16071 .37981 L
.15276 .35577 L
.15013 .33173 L
.15192 .30769 L
.15764 .28365 L
.16346 .26741 L
.16725 .25962 L
.18126 .23558 L
.1875 .22679 L
.20038 .21154 L
.21154 .20038 L
.22679 .1875 L
.23558 .18126 L
Mistroke
.25962 .16725 L
.26741 .16346 L
.28365 .15764 L
Mfstroke
.2 g
.28365 .54756 m
.30769 .54638 L
.33173 .54595 L
.35577 .54657 L
.37971 .54808 L
.37981 .54814 L
.40385 .55605 L
.42788 .57182 L
.42818 .57212 L
.44395 .59615 L
.45186 .62019 L
.45192 .62029 L
.45343 .64423 L
.45405 .66827 L
.45362 .69231 L
.45244 .71635 L
.45192 .72529 L
.44862 .74038 L
.44145 .76442 L
.43112 .78846 L
.42788 .79439 L
.41495 .8125 L
.40385 .82351 L
.38569 .83654 L
.37981 .83929 L
.35577 .84724 L
.33173 .84987 L
.30769 .84808 L
.28365 .84236 L
.26741 .83654 L
.25962 .83275 L
.23558 .81874 L
.22679 .8125 L
.21154 .79962 L
.20038 .78846 L
.1875 .77321 L
.18126 .76442 L
.16725 .74038 L
.16346 .73259 L
.15764 .71635 L
.15192 .69231 L
.15013 .66827 L
.15276 .64423 L
.16071 .62019 L
.16346 .61431 L
.17649 .59615 L
.1875 .58505 L
.20561 .57212 L
.21154 .56888 L
.23558 .55855 L
.25962 .55138 L
.27471 .54808 L
F
0 g
.28365 .54756 m
.30769 .54638 L
.33173 .54595 L
.35577 .54657 L
.37971 .54808 L
.37981 .54814 L
.40385 .55605 L
.42788 .57182 L
.42818 .57212 L
.44395 .59615 L
.45186 .62019 L
.45192 .62029 L
.45343 .64423 L
.45405 .66827 L
.45362 .69231 L
.45244 .71635 L
.45192 .72529 L
.44862 .74038 L
.44145 .76442 L
.43112 .78846 L
.42788 .79439 L
.41495 .8125 L
.40385 .82351 L
.38569 .83654 L
.37981 .83929 L
.35577 .84724 L
.33173 .84987 L
.30769 .84808 L
.28365 .84236 L
.26741 .83654 L
.25962 .83275 L
.23558 .81874 L
.22679 .8125 L
.21154 .79962 L
.20038 .78846 L
.1875 .77321 L
.18126 .76442 L
.16725 .74038 L
.16346 .73259 L
.15764 .71635 L
.15192 .69231 L
.15013 .66827 L
.15276 .64423 L
.16071 .62019 L
.16346 .61431 L
.17649 .59615 L
.1875 .58505 L
.20561 .57212 L
.21154 .56888 L
.23558 .55855 L
Mistroke
.25962 .55138 L
.27471 .54808 L
.28365 .54756 L
Mfstroke
.3 g
.28365 .18478 m
.30769 .17823 L
.33173 .1762 L
.35577 .17919 L
.37918 .1875 L
.37981 .18837 L
.40385 .20701 L
.40798 .21154 L
.42383 .23558 L
.42788 .24414 L
.43348 .25962 L
.43956 .28365 L
.44304 .30769 L
.4441 .33173 L
.44254 .35577 L
.43763 .37981 L
.42788 .40305 L
.42736 .40385 L
.40385 .42736 L
.40305 .42788 L
.37981 .43763 L
.35577 .44254 L
.33173 .4441 L
.30769 .44304 L
.28365 .43956 L
.25962 .43348 L
.24414 .42788 L
.23558 .42383 L
.21154 .40798 L
.20701 .40385 L
.18837 .37981 L
.1875 .37918 L
.17919 .35577 L
.1762 .33173 L
.17823 .30769 L
.18478 .28365 L
.1875 .2764 L
.1961 .25962 L
.21154 .23709 L
.21279 .23558 L
.23558 .21279 L
.23709 .21154 L
.25962 .1961 L
.2764 .1875 L
F
0 g
.28365 .18478 m
.30769 .17823 L
.33173 .1762 L
.35577 .17919 L
.37918 .1875 L
.37981 .18837 L
.40385 .20701 L
.40798 .21154 L
.42383 .23558 L
.42788 .24414 L
.43348 .25962 L
.43956 .28365 L
.44304 .30769 L
.4441 .33173 L
.44254 .35577 L
.43763 .37981 L
.42788 .40305 L
.42736 .40385 L
.40385 .42736 L
.40305 .42788 L
.37981 .43763 L
.35577 .44254 L
.33173 .4441 L
.30769 .44304 L
.28365 .43956 L
.25962 .43348 L
.24414 .42788 L
.23558 .42383 L
.21154 .40798 L
.20701 .40385 L
.18837 .37981 L
.1875 .37918 L
.17919 .35577 L
.1762 .33173 L
.17823 .30769 L
.18478 .28365 L
.1875 .2764 L
.1961 .25962 L
.21154 .23709 L
.21279 .23558 L
.23558 .21279 L
.23709 .21154 L
.25962 .1961 L
.2764 .1875 L
.28365 .18478 L
s
.3 g
.25962 .56652 m
.28365 .56044 L
.30769 .55696 L
.33173 .5559 L
.35577 .55746 L
.37981 .56237 L
.40305 .57212 L
.40385 .57264 L
.42736 .59615 L
.42788 .59695 L
.43763 .62019 L
.44254 .64423 L
.4441 .66827 L
.44304 .69231 L
.43956 .71635 L
.43348 .74038 L
.42788 .75586 L
.42383 .76442 L
.40798 .78846 L
.40385 .79299 L
.37981 .81163 L
.37918 .8125 L
.35577 .82081 L
.33173 .8238 L
.30769 .82177 L
.28365 .81522 L
.2764 .8125 L
.25962 .8039 L
.23709 .78846 L
.23558 .78721 L
.21279 .76442 L
.21154 .76291 L
.1961 .74038 L
.1875 .7236 L
.18478 .71635 L
.17823 .69231 L
.1762 .66827 L
.17919 .64423 L
.1875 .62082 L
.18837 .62019 L
.20701 .59615 L
.21154 .59202 L
.23558 .57617 L
.24414 .57212 L
F
0 g
.25962 .56652 m
.28365 .56044 L
.30769 .55696 L
.33173 .5559 L
.35577 .55746 L
.37981 .56237 L
.40305 .57212 L
.40385 .57264 L
.42736 .59615 L
.42788 .59695 L
.43763 .62019 L
.44254 .64423 L
.4441 .66827 L
.44304 .69231 L
.43956 .71635 L
.43348 .74038 L
.42788 .75586 L
.42383 .76442 L
.40798 .78846 L
.40385 .79299 L
.37981 .81163 L
.37918 .8125 L
.35577 .82081 L
.33173 .8238 L
.30769 .82177 L
.28365 .81522 L
.2764 .8125 L
.25962 .8039 L
.23709 .78846 L
.23558 .78721 L
.21279 .76442 L
.21154 .76291 L
.1961 .74038 L
.1875 .7236 L
.18478 .71635 L
.17823 .69231 L
.1762 .66827 L
.17919 .64423 L
.1875 .62082 L
.18837 .62019 L
.20701 .59615 L
.21154 .59202 L
.23558 .57617 L
.24414 .57212 L
.25962 .56652 L
s
.4 g
.28365 .20623 m
.30769 .19873 L
.33173 .19643 L
.35577 .19981 L
.37981 .21036 L
.38175 .21154 L
.40385 .23235 L
.4063 .23558 L
.41978 .25962 L
.42782 .28365 L
.42788 .28371 L
.43203 .30769 L
.4333 .33173 L
.43144 .35577 L
.42788 .37566 L
.42532 .37981 L
.41124 .40385 L
.40385 .41124 L
.37981 .42532 L
.37566 .42788 L
.35577 .43144 L
.33173 .4333 L
.30769 .43203 L
.28371 .42788 L
.28365 .42782 L
.25962 .41978 L
.23558 .4063 L
.23235 .40385 L
.21154 .38175 L
.21036 .37981 L
.19981 .35577 L
.19643 .33173 L
.19873 .30769 L
.20623 .28365 L
.21154 .27208 L
.2193 .25962 L
.23558 .23949 L
.23949 .23558 L
.25962 .2193 L
.27208 .21154 L
F
0 g
.28365 .20623 m
.30769 .19873 L
.33173 .19643 L
.35577 .19981 L
.37981 .21036 L
.38175 .21154 L
.40385 .23235 L
.4063 .23558 L
.41978 .25962 L
.42782 .28365 L
.42788 .28371 L
.43203 .30769 L
.4333 .33173 L
.43144 .35577 L
.42788 .37566 L
.42532 .37981 L
.41124 .40385 L
.40385 .41124 L
.37981 .42532 L
.37566 .42788 L
.35577 .43144 L
.33173 .4333 L
.30769 .43203 L
.28371 .42788 L
.28365 .42782 L
.25962 .41978 L
.23558 .4063 L
.23235 .40385 L
.21154 .38175 L
.21036 .37981 L
.19981 .35577 L
.19643 .33173 L
.19873 .30769 L
.20623 .28365 L
.21154 .27208 L
.2193 .25962 L
.23558 .23949 L
.23949 .23558 L
.25962 .2193 L
.27208 .21154 L
.28365 .20623 L
s
.4 g
.30769 .56797 m
.33173 .5667 L
.35577 .56856 L
.37566 .57212 L
.37981 .57468 L
.40385 .58876 L
.41124 .59615 L
.42532 .62019 L
.42788 .62434 L
.43144 .64423 L
.4333 .66827 L
.43203 .69231 L
.42788 .71629 L
.42782 .71635 L
.41978 .74038 L
.4063 .76442 L
.40385 .76765 L
.38175 .78846 L
.37981 .78964 L
.35577 .80019 L
.33173 .80357 L
.30769 .80127 L
.28365 .79377 L
.27208 .78846 L
.25962 .7807 L
.23949 .76442 L
.23558 .76051 L
.2193 .74038 L
.21154 .72792 L
.20623 .71635 L
.19873 .69231 L
.19643 .66827 L
.19981 .64423 L
.21036 .62019 L
.21154 .61825 L
.23235 .59615 L
.23558 .5937 L
.25962 .58022 L
.28365 .57218 L
.28371 .57212 L
F
0 g
.30769 .56797 m
.33173 .5667 L
.35577 .56856 L
.37566 .57212 L
.37981 .57468 L
.40385 .58876 L
.41124 .59615 L
.42532 .62019 L
.42788 .62434 L
.43144 .64423 L
.4333 .66827 L
.43203 .69231 L
.42788 .71629 L
.42782 .71635 L
.41978 .74038 L
.4063 .76442 L
.40385 .76765 L
.38175 .78846 L
.37981 .78964 L
.35577 .80019 L
.33173 .80357 L
.30769 .80127 L
.28365 .79377 L
.27208 .78846 L
.25962 .7807 L
.23949 .76442 L
.23558 .76051 L
.2193 .74038 L
.21154 .72792 L
.20623 .71635 L
.19873 .69231 L
.19643 .66827 L
.19981 .64423 L
.21036 .62019 L
.21154 .61825 L
.23235 .59615 L
.23558 .5937 L
.25962 .58022 L
.28365 .57218 L
.28371 .57212 L
.30769 .56797 L
s
.5 g
.28365 .22494 m
.30769 .21635 L
.33173 .21375 L
.35577 .21758 L
.37981 .22974 L
.38728 .23558 L
.40385 .25634 L
.40577 .25962 L
.41616 .28365 L
.42163 .30769 L
.42324 .33173 L
.42086 .35577 L
.41299 .37981 L
.40385 .39452 L
.39452 .40385 L
.37981 .41299 L
.35577 .42086 L
.33173 .42324 L
.30769 .42163 L
.28365 .41616 L
.25962 .40577 L
.25634 .40385 L
.23558 .38728 L
.22974 .37981 L
.21758 .35577 L
.21375 .33173 L
.21635 .30769 L
.22494 .28365 L
.23558 .2655 L
.24023 .25962 L
.25962 .24023 L
.2655 .23558 L
F
0 g
.28365 .22494 m
.30769 .21635 L
.33173 .21375 L
.35577 .21758 L
.37981 .22974 L
.38728 .23558 L
.40385 .25634 L
.40577 .25962 L
.41616 .28365 L
.42163 .30769 L
.42324 .33173 L
.42086 .35577 L
.41299 .37981 L
.40385 .39452 L
.39452 .40385 L
.37981 .41299 L
.35577 .42086 L
.33173 .42324 L
.30769 .42163 L
.28365 .41616 L
.25962 .40577 L
.25634 .40385 L
.23558 .38728 L
.22974 .37981 L
.21758 .35577 L
.21375 .33173 L
.21635 .30769 L
.22494 .28365 L
.23558 .2655 L
.24023 .25962 L
.25962 .24023 L
.2655 .23558 L
.28365 .22494 L
s
.5 g
.25962 .59423 m
.28365 .58384 L
.30769 .57837 L
.33173 .57676 L
.35577 .57914 L
.37981 .58701 L
.39452 .59615 L
.40385 .60548 L
.41299 .62019 L
.42086 .64423 L
.42324 .66827 L
.42163 .69231 L
.41616 .71635 L
.40577 .74038 L
.40385 .74366 L
.38728 .76442 L
.37981 .77026 L
.35577 .78242 L
.33173 .78625 L
.30769 .78365 L
.28365 .77506 L
.2655 .76442 L
.25962 .75977 L
.24023 .74038 L
.23558 .7345 L
.22494 .71635 L
.21635 .69231 L
.21375 .66827 L
.21758 .64423 L
.22974 .62019 L
.23558 .61272 L
.25634 .59615 L
F
0 g
.25962 .59423 m
.28365 .58384 L
.30769 .57837 L
.33173 .57676 L
.35577 .57914 L
.37981 .58701 L
.39452 .59615 L
.40385 .60548 L
.41299 .62019 L
.42086 .64423 L
.42324 .66827 L
.42163 .69231 L
.41616 .71635 L
.40577 .74038 L
.40385 .74366 L
.38728 .76442 L
.37981 .77026 L
.35577 .78242 L
.33173 .78625 L
.30769 .78365 L
.28365 .77506 L
.2655 .76442 L
.25962 .75977 L
.24023 .74038 L
.23558 .7345 L
.22494 .71635 L
.21635 .69231 L
.21375 .66827 L
.21758 .64423 L
.22974 .62019 L
.23558 .61272 L
.25634 .59615 L
.25962 .59423 L
s
.6 g
.30769 .23255 m
.33173 .22962 L
.35577 .23395 L
.36178 .23558 L
.37981 .24807 L
.39104 .25962 L
.40385 .28267 L
.40423 .28365 L
.4111 .30769 L
.41308 .33173 L
.41015 .35577 L
.40385 .37639 L
.40038 .37981 L
.37981 .40038 L
.37639 .40385 L
.35577 .41015 L
.33173 .41308 L
.30769 .4111 L
.28365 .40423 L
.28267 .40385 L
.25962 .39104 L
.24807 .37981 L
.23558 .36178 L
.23395 .35577 L
.22962 .33173 L
.23255 .30769 L
.23558 .29378 L
.24241 .28365 L
.25962 .26092 L
.26092 .25962 L
.28365 .24241 L
.29378 .23558 L
F
0 g
.30769 .23255 m
.33173 .22962 L
.35577 .23395 L
.36178 .23558 L
.37981 .24807 L
.39104 .25962 L
.40385 .28267 L
.40423 .28365 L
.4111 .30769 L
.41308 .33173 L
.41015 .35577 L
.40385 .37639 L
.40038 .37981 L
.37981 .40038 L
.37639 .40385 L
.35577 .41015 L
.33173 .41308 L
.30769 .4111 L
.28365 .40423 L
.28267 .40385 L
.25962 .39104 L
.24807 .37981 L
.23558 .36178 L
.23395 .35577 L
.22962 .33173 L
.23255 .30769 L
.23558 .29378 L
.24241 .28365 L
.25962 .26092 L
.26092 .25962 L
.28365 .24241 L
.29378 .23558 L
.30769 .23255 L
s
.6 g
.28365 .59577 m
.30769 .5889 L
.33173 .58692 L
.35577 .58985 L
.37639 .59615 L
.37981 .59962 L
.40038 .62019 L
.40385 .62361 L
.41015 .64423 L
.41308 .66827 L
.4111 .69231 L
.40423 .71635 L
.40385 .71733 L
.39104 .74038 L
.37981 .75193 L
.36178 .76442 L
.35577 .76605 L
.33173 .77038 L
.30769 .76745 L
.29378 .76442 L
.28365 .75759 L
.26092 .74038 L
.25962 .73908 L
.24241 .71635 L
.23558 .70622 L
.23255 .69231 L
.22962 .66827 L
.23395 .64423 L
.23558 .63822 L
.24807 .62019 L
.25962 .60896 L
.28267 .59615 L
F
0 g
.28365 .59577 m
.30769 .5889 L
.33173 .58692 L
.35577 .58985 L
.37639 .59615 L
.37981 .59962 L
.40038 .62019 L
.40385 .62361 L
.41015 .64423 L
.41308 .66827 L
.4111 .69231 L
.40423 .71635 L
.40385 .71733 L
.39104 .74038 L
.37981 .75193 L
.36178 .76442 L
.35577 .76605 L
.33173 .77038 L
.30769 .76745 L
.29378 .76442 L
.28365 .75759 L
.26092 .74038 L
.25962 .73908 L
.24241 .71635 L
.23558 .70622 L
.23255 .69231 L
.22962 .66827 L
.23395 .64423 L
.23558 .63822 L
.24807 .62019 L
.25962 .60896 L
.28267 .59615 L
.28365 .59577 L
s
.7 g
.30769 .24814 m
.33173 .24474 L
.35577 .24978 L
.37552 .25962 L
.37981 .26666 L
.39184 .28365 L
.40033 .30769 L
.40264 .33173 L
.3992 .35577 L
.38632 .37981 L
.37981 .38632 L
.35577 .3992 L
.33173 .40264 L
.30769 .40033 L
.28365 .39184 L
.26666 .37981 L
.25962 .37552 L
.24978 .35577 L
.24474 .33173 L
.24814 .30769 L
.25962 .28377 L
.25992 .28365 L
.28365 .25992 L
.28377 .25962 L
F
0 g
.30769 .24814 m
.33173 .24474 L
.35577 .24978 L
.37552 .25962 L
.37981 .26666 L
.39184 .28365 L
.40033 .30769 L
.40264 .33173 L
.3992 .35577 L
.38632 .37981 L
.37981 .38632 L
.35577 .3992 L
.33173 .40264 L
.30769 .40033 L
.28365 .39184 L
.26666 .37981 L
.25962 .37552 L
.24978 .35577 L
.24474 .33173 L
.24814 .30769 L
.25962 .28377 L
.25992 .28365 L
.28365 .25992 L
.28377 .25962 L
.30769 .24814 L
s
.7 g
.28365 .60816 m
.30769 .59967 L
.33173 .59736 L
.35577 .6008 L
.37981 .61368 L
.38632 .62019 L
.3992 .64423 L
.40264 .66827 L
.40033 .69231 L
.39184 .71635 L
.37981 .73334 L
.37552 .74038 L
.35577 .75022 L
.33173 .75526 L
.30769 .75186 L
.28377 .74038 L
.28365 .74008 L
.25992 .71635 L
.25962 .71623 L
.24814 .69231 L
.24474 .66827 L
.24978 .64423 L
.25962 .62448 L
.26666 .62019 L
F
0 g
.28365 .60816 m
.30769 .59967 L
.33173 .59736 L
.35577 .6008 L
.37981 .61368 L
.38632 .62019 L
.3992 .64423 L
.40264 .66827 L
.40033 .69231 L
.39184 .71635 L
.37981 .73334 L
.37552 .74038 L
.35577 .75022 L
.33173 .75526 L
.30769 .75186 L
.28377 .74038 L
.28365 .74008 L
.25992 .71635 L
.25962 .71623 L
.24814 .69231 L
.24474 .66827 L
.24978 .64423 L
.25962 .62448 L
.26666 .62019 L
.28365 .60816 L
s
.8 g
.28365 .27872 m
.30769 .26394 L
.33173 .26004 L
.35577 .26586 L
.37831 .28365 L
.37981 .28547 L
.38857 .30769 L
.39175 .33173 L
.38698 .35577 L
.37981 .37203 L
.37203 .37981 L
.35577 .38698 L
.33173 .39175 L
.30769 .38857 L
.28547 .37981 L
.28365 .37831 L
.26586 .35577 L
.26004 .33173 L
.26394 .30769 L
.27872 .28365 L
F
0 g
.28365 .27872 m
.30769 .26394 L
.33173 .26004 L
.35577 .26586 L
.37831 .28365 L
.37981 .28547 L
.38857 .30769 L
.39175 .33173 L
.38698 .35577 L
.37981 .37203 L
.37203 .37981 L
.35577 .38698 L
.33173 .39175 L
.30769 .38857 L
.28547 .37981 L
.28365 .37831 L
.26586 .35577 L
.26004 .33173 L
.26394 .30769 L
.27872 .28365 L
.28365 .27872 L
s
.8 g
.30769 .61143 m
.33173 .60825 L
.35577 .61302 L
.37203 .62019 L
.37981 .62797 L
.38698 .64423 L
.39175 .66827 L
.38857 .69231 L
.37981 .71453 L
.37831 .71635 L
.35577 .73414 L
.33173 .73996 L
.30769 .73606 L
.28365 .72128 L
.27872 .71635 L
.26394 .69231 L
.26004 .66827 L
.26586 .64423 L
.28365 .62169 L
.28547 .62019 L
F
0 g
.30769 .61143 m
.33173 .60825 L
.35577 .61302 L
.37203 .62019 L
.37981 .62797 L
.38698 .64423 L
.39175 .66827 L
.38857 .69231 L
.37981 .71453 L
.37831 .71635 L
.35577 .73414 L
.33173 .73996 L
.30769 .73606 L
.28365 .72128 L
.27872 .71635 L
.26394 .69231 L
.26004 .66827 L
.26586 .64423 L
.28365 .62169 L
.28547 .62019 L
.30769 .61143 L
s
.9 g
.30769 .28165 m
.33173 .27616 L
.35463 .28365 L
.35577 .28384 L
.37695 .30769 L
.37926 .33173 L
.37533 .35577 L
.35577 .37533 L
.33173 .37926 L
.30769 .37695 L
.28384 .35577 L
.28365 .35463 L
.27616 .33173 L
.28165 .30769 L
.28365 .30205 L
.30205 .28365 L
F
0 g
.30769 .28165 m
.33173 .27616 L
.35463 .28365 L
.35577 .28384 L
.37695 .30769 L
.37926 .33173 L
.37533 .35577 L
.35577 .37533 L
.33173 .37926 L
.30769 .37695 L
.28384 .35577 L
.28365 .35463 L
.27616 .33173 L
.28165 .30769 L
.28365 .30205 L
.30205 .28365 L
.30769 .28165 L
s
.9 g
.30769 .62305 m
.33173 .62074 L
.35577 .62467 L
.37533 .64423 L
.37926 .66827 L
.37695 .69231 L
.35577 .71616 L
.35463 .71635 L
.33173 .72384 L
.30769 .71835 L
.30205 .71635 L
.28365 .69795 L
.28165 .69231 L
.27616 .66827 L
.28365 .64537 L
.28384 .64423 L
F
0 g
.30769 .62305 m
.33173 .62074 L
.35577 .62467 L
.37533 .64423 L
.37926 .66827 L
.37695 .69231 L
.35577 .71616 L
.35463 .71635 L
.33173 .72384 L
.30769 .71835 L
.30205 .71635 L
.28365 .69795 L
.28165 .69231 L
.27616 .66827 L
.28365 .64537 L
.28384 .64423 L
.30769 .62305 L
s
1 g
.30769 .30392 m
.33173 .29179 L
.35352 .30769 L
.35577 .31074 L
.36386 .33173 L
.35577 .34852 L
.34852 .35577 L
.33173 .36386 L
.31074 .35577 L
.30769 .35352 L
.29179 .33173 L
.30392 .30769 L
F
0 g
.30769 .30392 m
.33173 .29179 L
.35352 .30769 L
.35577 .31074 L
.36386 .33173 L
.35577 .34852 L
.34852 .35577 L
.33173 .36386 L
.31074 .35577 L
.30769 .35352 L
.29179 .33173 L
.30392 .30769 L
.30769 .30392 L
s
1 g
.33173 .63614 m
.34852 .64423 L
.35577 .65148 L
.36386 .66827 L
.35577 .68926 L
.35352 .69231 L
.33173 .70821 L
.30769 .69608 L
.30392 .69231 L
.29179 .66827 L
.30769 .64648 L
.31074 .64423 L
F
0 g
.33173 .63614 m
.34852 .64423 L
.35577 .65148 L
.36386 .66827 L
.35577 .68926 L
.35352 .69231 L
.33173 .70821 L
.30769 .69608 L
.30392 .69231 L
.29179 .66827 L
.30769 .64648 L
.31074 .64423 L
.33173 .63614 L
s
.1 g
.64423 .11025 m
.66827 .10812 L
.69231 .10958 L
.71635 .11414 L
.72137 .11538 L
.74038 .12224 L
.76442 .13351 L
.77515 .13942 L
.78846 .14826 L
.80828 .16346 L
.8125 .16717 L
.83283 .1875 L
.83654 .19172 L
.85174 .21154 L
.86058 .22485 L
.86649 .23558 L
.87776 .25962 L
.88462 .27863 L
.88586 .28365 L
.89042 .30769 L
.89188 .33173 L
.88975 .35577 L
.88462 .37835 L
.88332 .37981 L
.87026 .40385 L
.86058 .41622 L
.84779 .42788 L
.83654 .43585 L
.8125 .44866 L
.80473 .45192 L
.78846 .45452 L
.76442 .45935 L
.74038 .46401 L
.71635 .46759 L
.69231 .46978 L
.66827 .47046 L
.64423 .46946 L
.62019 .46641 L
.59615 .46086 L
.57212 .45356 L
.56607 .45192 L
.54808 .43393 L
.54644 .42788 L
.53914 .40385 L
.53359 .37981 L
.53054 .35577 L
.52954 .33173 L
.53022 .30769 L
.53241 .28365 L
.53599 .25962 L
.54065 .23558 L
.54548 .21154 L
.54808 .19527 L
.55134 .1875 L
.56415 .16346 L
.57212 .15221 L
.58378 .13942 L
.59615 .12974 L
.62019 .11668 L
.62165 .11538 L
F
0 g
.64423 .11025 m
.66827 .10812 L
.69231 .10958 L
.71635 .11414 L
.72137 .11538 L
.74038 .12224 L
.76442 .13351 L
.77515 .13942 L
.78846 .14826 L
.80828 .16346 L
.8125 .16717 L
.83283 .1875 L
.83654 .19172 L
.85174 .21154 L
.86058 .22485 L
.86649 .23558 L
.87776 .25962 L
.88462 .27863 L
.88586 .28365 L
.89042 .30769 L
.89188 .33173 L
.88975 .35577 L
.88462 .37835 L
.88332 .37981 L
.87026 .40385 L
.86058 .41622 L
.84779 .42788 L
.83654 .43585 L
.8125 .44866 L
.80473 .45192 L
.78846 .45452 L
.76442 .45935 L
.74038 .46401 L
.71635 .46759 L
.69231 .46978 L
.66827 .47046 L
.64423 .46946 L
.62019 .46641 L
.59615 .46086 L
.57212 .45356 L
.56607 .45192 L
.54808 .43393 L
.54644 .42788 L
.53914 .40385 L
.53359 .37981 L
.53054 .35577 L
.52954 .33173 L
.53022 .30769 L
.53241 .28365 L
.53599 .25962 L
Mistroke
.54065 .23558 L
.54548 .21154 L
.54808 .19527 L
.55134 .1875 L
.56415 .16346 L
.57212 .15221 L
.58378 .13942 L
.59615 .12974 L
.62019 .11668 L
.62165 .11538 L
.64423 .11025 L
Mfstroke
.1 g
.57212 .54644 m
.59615 .53914 L
.62019 .53359 L
.64423 .53054 L
.66827 .52954 L
.69231 .53022 L
.71635 .53241 L
.74038 .53599 L
.76442 .54065 L
.78846 .54548 L
.80473 .54808 L
.8125 .55134 L
.83654 .56415 L
.84779 .57212 L
.86058 .58378 L
.87026 .59615 L
.88332 .62019 L
.88462 .62165 L
.88975 .64423 L
.89188 .66827 L
.89042 .69231 L
.88586 .71635 L
.88462 .72137 L
.87776 .74038 L
.86649 .76442 L
.86058 .77515 L
.85174 .78846 L
.83654 .80828 L
.83283 .8125 L
.8125 .83283 L
.80828 .83654 L
.78846 .85174 L
.77515 .86058 L
.76442 .86649 L
.74038 .87776 L
.72137 .88462 L
.71635 .88586 L
.69231 .89042 L
.66827 .89188 L
.64423 .88975 L
.62165 .88462 L
.62019 .88332 L
.59615 .87026 L
.58378 .86058 L
.57212 .84779 L
.56415 .83654 L
.55134 .8125 L
.54808 .80473 L
.54548 .78846 L
.54065 .76442 L
.53599 .74038 L
.53241 .71635 L
.53022 .69231 L
.52954 .66827 L
.53054 .64423 L
.53359 .62019 L
.53914 .59615 L
.54644 .57212 L
.54808 .56607 L
.56607 .54808 L
F
0 g
.57212 .54644 m
.59615 .53914 L
.62019 .53359 L
.64423 .53054 L
.66827 .52954 L
.69231 .53022 L
.71635 .53241 L
.74038 .53599 L
.76442 .54065 L
.78846 .54548 L
.80473 .54808 L
.8125 .55134 L
.83654 .56415 L
.84779 .57212 L
.86058 .58378 L
.87026 .59615 L
.88332 .62019 L
.88462 .62165 L
.88975 .64423 L
.89188 .66827 L
.89042 .69231 L
.88586 .71635 L
.88462 .72137 L
.87776 .74038 L
.86649 .76442 L
.86058 .77515 L
.85174 .78846 L
.83654 .80828 L
.83283 .8125 L
.8125 .83283 L
.80828 .83654 L
.78846 .85174 L
.77515 .86058 L
.76442 .86649 L
.74038 .87776 L
.72137 .88462 L
.71635 .88586 L
.69231 .89042 L
.66827 .89188 L
.64423 .88975 L
.62165 .88462 L
.62019 .88332 L
.59615 .87026 L
.58378 .86058 L
.57212 .84779 L
.56415 .83654 L
.55134 .8125 L
.54808 .80473 L
.54548 .78846 L
.54065 .76442 L
Mistroke
.53599 .74038 L
.53241 .71635 L
.53022 .69231 L
.52954 .66827 L
.53054 .64423 L
.53359 .62019 L
.53914 .59615 L
.54644 .57212 L
.54808 .56607 L
.56607 .54808 L
.57212 .54644 L
Mfstroke
.2 g
.62019 .16071 m
.64423 .15276 L
.66827 .15013 L
.69231 .15192 L
.71635 .15764 L
.73259 .16346 L
.74038 .16725 L
.76442 .18126 L
.77321 .1875 L
.78846 .20038 L
.79962 .21154 L
.8125 .22679 L
.81874 .23558 L
.83275 .25962 L
.83654 .26741 L
.84236 .28365 L
.84808 .30769 L
.84987 .33173 L
.84724 .35577 L
.83929 .37981 L
.83654 .38569 L
.82351 .40385 L
.8125 .41495 L
.79439 .42788 L
.78846 .43112 L
.76442 .44145 L
.74038 .44862 L
.72529 .45192 L
.71635 .45244 L
.69231 .45362 L
.66827 .45405 L
.64423 .45343 L
.62029 .45192 L
.62019 .45186 L
.59615 .44395 L
.57212 .42818 L
.57182 .42788 L
.55605 .40385 L
.54814 .37981 L
.54808 .37971 L
.54657 .35577 L
.54595 .33173 L
.54638 .30769 L
.54756 .28365 L
.54808 .27471 L
.55138 .25962 L
.55855 .23558 L
.56888 .21154 L
.57212 .20561 L
.58505 .1875 L
.59615 .17649 L
.61431 .16346 L
F
0 g
.62019 .16071 m
.64423 .15276 L
.66827 .15013 L
.69231 .15192 L
.71635 .15764 L
.73259 .16346 L
.74038 .16725 L
.76442 .18126 L
.77321 .1875 L
.78846 .20038 L
.79962 .21154 L
.8125 .22679 L
.81874 .23558 L
.83275 .25962 L
.83654 .26741 L
.84236 .28365 L
.84808 .30769 L
.84987 .33173 L
.84724 .35577 L
.83929 .37981 L
.83654 .38569 L
.82351 .40385 L
.8125 .41495 L
.79439 .42788 L
.78846 .43112 L
.76442 .44145 L
.74038 .44862 L
.72529 .45192 L
.71635 .45244 L
.69231 .45362 L
.66827 .45405 L
.64423 .45343 L
.62029 .45192 L
.62019 .45186 L
.59615 .44395 L
.57212 .42818 L
.57182 .42788 L
.55605 .40385 L
.54814 .37981 L
.54808 .37971 L
.54657 .35577 L
.54595 .33173 L
.54638 .30769 L
.54756 .28365 L
.54808 .27471 L
.55138 .25962 L
.55855 .23558 L
.56888 .21154 L
.57212 .20561 L
.58505 .1875 L
Mistroke
.59615 .17649 L
.61431 .16346 L
.62019 .16071 L
Mfstroke
.2 g
.64423 .54657 m
.66827 .54595 L
.69231 .54638 L
.71635 .54756 L
.72529 .54808 L
.74038 .55138 L
.76442 .55855 L
.78846 .56888 L
.79439 .57212 L
.8125 .58505 L
.82351 .59615 L
.83654 .61431 L
.83929 .62019 L
.84724 .64423 L
.84987 .66827 L
.84808 .69231 L
.84236 .71635 L
.83654 .73259 L
.83275 .74038 L
.81874 .76442 L
.8125 .77321 L
.79962 .78846 L
.78846 .79962 L
.77321 .8125 L
.76442 .81874 L
.74038 .83275 L
.73259 .83654 L
.71635 .84236 L
.69231 .84808 L
.66827 .84987 L
.64423 .84724 L
.62019 .83929 L
.61431 .83654 L
.59615 .82351 L
.58505 .8125 L
.57212 .79439 L
.56888 .78846 L
.55855 .76442 L
.55138 .74038 L
.54808 .72529 L
.54756 .71635 L
.54638 .69231 L
.54595 .66827 L
.54657 .64423 L
.54808 .62029 L
.54814 .62019 L
.55605 .59615 L
.57182 .57212 L
.57212 .57182 L
.59615 .55605 L
.62019 .54814 L
.62029 .54808 L
F
0 g
.64423 .54657 m
.66827 .54595 L
.69231 .54638 L
.71635 .54756 L
.72529 .54808 L
.74038 .55138 L
.76442 .55855 L
.78846 .56888 L
.79439 .57212 L
.8125 .58505 L
.82351 .59615 L
.83654 .61431 L
.83929 .62019 L
.84724 .64423 L
.84987 .66827 L
.84808 .69231 L
.84236 .71635 L
.83654 .73259 L
.83275 .74038 L
.81874 .76442 L
.8125 .77321 L
.79962 .78846 L
.78846 .79962 L
.77321 .8125 L
.76442 .81874 L
.74038 .83275 L
.73259 .83654 L
.71635 .84236 L
.69231 .84808 L
.66827 .84987 L
.64423 .84724 L
.62019 .83929 L
.61431 .83654 L
.59615 .82351 L
.58505 .8125 L
.57212 .79439 L
.56888 .78846 L
.55855 .76442 L
.55138 .74038 L
.54808 .72529 L
.54756 .71635 L
.54638 .69231 L
.54595 .66827 L
.54657 .64423 L
.54808 .62029 L
.54814 .62019 L
.55605 .59615 L
.57182 .57212 L
.57212 .57182 L
.59615 .55605 L
Mistroke
.62019 .54814 L
.62029 .54808 L
.64423 .54657 L
Mfstroke
.3 g
.64423 .17919 m
.66827 .1762 L
.69231 .17823 L
.71635 .18478 L
.7236 .1875 L
.74038 .1961 L
.76291 .21154 L
.76442 .21279 L
.78721 .23558 L
.78846 .23709 L
.8039 .25962 L
.8125 .2764 L
.81522 .28365 L
.82177 .30769 L
.8238 .33173 L
.82081 .35577 L
.8125 .37918 L
.81163 .37981 L
.79299 .40385 L
.78846 .40798 L
.76442 .42383 L
.75586 .42788 L
.74038 .43348 L
.71635 .43956 L
.69231 .44304 L
.66827 .4441 L
.64423 .44254 L
.62019 .43763 L
.59695 .42788 L
.59615 .42736 L
.57264 .40385 L
.57212 .40305 L
.56237 .37981 L
.55746 .35577 L
.5559 .33173 L
.55696 .30769 L
.56044 .28365 L
.56652 .25962 L
.57212 .24414 L
.57617 .23558 L
.59202 .21154 L
.59615 .20701 L
.62019 .18837 L
.62082 .1875 L
F
0 g
.64423 .17919 m
.66827 .1762 L
.69231 .17823 L
.71635 .18478 L
.7236 .1875 L
.74038 .1961 L
.76291 .21154 L
.76442 .21279 L
.78721 .23558 L
.78846 .23709 L
.8039 .25962 L
.8125 .2764 L
.81522 .28365 L
.82177 .30769 L
.8238 .33173 L
.82081 .35577 L
.8125 .37918 L
.81163 .37981 L
.79299 .40385 L
.78846 .40798 L
.76442 .42383 L
.75586 .42788 L
.74038 .43348 L
.71635 .43956 L
.69231 .44304 L
.66827 .4441 L
.64423 .44254 L
.62019 .43763 L
.59695 .42788 L
.59615 .42736 L
.57264 .40385 L
.57212 .40305 L
.56237 .37981 L
.55746 .35577 L
.5559 .33173 L
.55696 .30769 L
.56044 .28365 L
.56652 .25962 L
.57212 .24414 L
.57617 .23558 L
.59202 .21154 L
.59615 .20701 L
.62019 .18837 L
.62082 .1875 L
.64423 .17919 L
s
.3 g
.62019 .56237 m
.64423 .55746 L
.66827 .5559 L
.69231 .55696 L
.71635 .56044 L
.74038 .56652 L
.75586 .57212 L
.76442 .57617 L
.78846 .59202 L
.79299 .59615 L
.81163 .62019 L
.8125 .62082 L
.82081 .64423 L
.8238 .66827 L
.82177 .69231 L
.81522 .71635 L
.8125 .7236 L
.8039 .74038 L
.78846 .76291 L
.78721 .76442 L
.76442 .78721 L
.76291 .78846 L
.74038 .8039 L
.7236 .8125 L
.71635 .81522 L
.69231 .82177 L
.66827 .8238 L
.64423 .82081 L
.62082 .8125 L
.62019 .81163 L
.59615 .79299 L
.59202 .78846 L
.57617 .76442 L
.57212 .75586 L
.56652 .74038 L
.56044 .71635 L
.55696 .69231 L
.5559 .66827 L
.55746 .64423 L
.56237 .62019 L
.57212 .59695 L
.57264 .59615 L
.59615 .57264 L
.59695 .57212 L
F
0 g
.62019 .56237 m
.64423 .55746 L
.66827 .5559 L
.69231 .55696 L
.71635 .56044 L
.74038 .56652 L
.75586 .57212 L
.76442 .57617 L
.78846 .59202 L
.79299 .59615 L
.81163 .62019 L
.8125 .62082 L
.82081 .64423 L
.8238 .66827 L
.82177 .69231 L
.81522 .71635 L
.8125 .7236 L
.8039 .74038 L
.78846 .76291 L
.78721 .76442 L
.76442 .78721 L
.76291 .78846 L
.74038 .8039 L
.7236 .8125 L
.71635 .81522 L
.69231 .82177 L
.66827 .8238 L
.64423 .82081 L
.62082 .8125 L
.62019 .81163 L
.59615 .79299 L
.59202 .78846 L
.57617 .76442 L
.57212 .75586 L
.56652 .74038 L
.56044 .71635 L
.55696 .69231 L
.5559 .66827 L
.55746 .64423 L
.56237 .62019 L
.57212 .59695 L
.57264 .59615 L
.59615 .57264 L
.59695 .57212 L
.62019 .56237 L
s
.4 g
.62019 .21036 m
.64423 .19981 L
.66827 .19643 L
.69231 .19873 L
.71635 .20623 L
.72792 .21154 L
.74038 .2193 L
.76051 .23558 L
.76442 .23949 L
.7807 .25962 L
.78846 .27208 L
.79377 .28365 L
.80127 .30769 L
.80357 .33173 L
.80019 .35577 L
.78964 .37981 L
.78846 .38175 L
.76765 .40385 L
.76442 .4063 L
.74038 .41978 L
.71635 .42782 L
.71629 .42788 L
.69231 .43203 L
.66827 .4333 L
.64423 .43144 L
.62434 .42788 L
.62019 .42532 L
.59615 .41124 L
.58876 .40385 L
.57468 .37981 L
.57212 .37566 L
.56856 .35577 L
.5667 .33173 L
.56797 .30769 L
.57212 .28371 L
.57218 .28365 L
.58022 .25962 L
.5937 .23558 L
.59615 .23235 L
.61825 .21154 L
F
0 g
.62019 .21036 m
.64423 .19981 L
.66827 .19643 L
.69231 .19873 L
.71635 .20623 L
.72792 .21154 L
.74038 .2193 L
.76051 .23558 L
.76442 .23949 L
.7807 .25962 L
.78846 .27208 L
.79377 .28365 L
.80127 .30769 L
.80357 .33173 L
.80019 .35577 L
.78964 .37981 L
.78846 .38175 L
.76765 .40385 L
.76442 .4063 L
.74038 .41978 L
.71635 .42782 L
.71629 .42788 L
.69231 .43203 L
.66827 .4333 L
.64423 .43144 L
.62434 .42788 L
.62019 .42532 L
.59615 .41124 L
.58876 .40385 L
.57468 .37981 L
.57212 .37566 L
.56856 .35577 L
.5667 .33173 L
.56797 .30769 L
.57212 .28371 L
.57218 .28365 L
.58022 .25962 L
.5937 .23558 L
.59615 .23235 L
.61825 .21154 L
.62019 .21036 L
s
.4 g
.64423 .56856 m
.66827 .5667 L
.69231 .56797 L
.71629 .57212 L
.71635 .57218 L
.74038 .58022 L
.76442 .5937 L
.76765 .59615 L
.78846 .61825 L
.78964 .62019 L
.80019 .64423 L
.80357 .66827 L
.80127 .69231 L
.79377 .71635 L
.78846 .72792 L
.7807 .74038 L
.76442 .76051 L
.76051 .76442 L
.74038 .7807 L
.72792 .78846 L
.71635 .79377 L
.69231 .80127 L
.66827 .80357 L
.64423 .80019 L
.62019 .78964 L
.61825 .78846 L
.59615 .76765 L
.5937 .76442 L
.58022 .74038 L
.57218 .71635 L
.57212 .71629 L
.56797 .69231 L
.5667 .66827 L
.56856 .64423 L
.57212 .62434 L
.57468 .62019 L
.58876 .59615 L
.59615 .58876 L
.62019 .57468 L
.62434 .57212 L
F
0 g
.64423 .56856 m
.66827 .5667 L
.69231 .56797 L
.71629 .57212 L
.71635 .57218 L
.74038 .58022 L
.76442 .5937 L
.76765 .59615 L
.78846 .61825 L
.78964 .62019 L
.80019 .64423 L
.80357 .66827 L
.80127 .69231 L
.79377 .71635 L
.78846 .72792 L
.7807 .74038 L
.76442 .76051 L
.76051 .76442 L
.74038 .7807 L
.72792 .78846 L
.71635 .79377 L
.69231 .80127 L
.66827 .80357 L
.64423 .80019 L
.62019 .78964 L
.61825 .78846 L
.59615 .76765 L
.5937 .76442 L
.58022 .74038 L
.57218 .71635 L
.57212 .71629 L
.56797 .69231 L
.5667 .66827 L
.56856 .64423 L
.57212 .62434 L
.57468 .62019 L
.58876 .59615 L
.59615 .58876 L
.62019 .57468 L
.62434 .57212 L
.64423 .56856 L
s
.5 g
.62019 .22974 m
.64423 .21758 L
.66827 .21375 L
.69231 .21635 L
.71635 .22494 L
.7345 .23558 L
.74038 .24023 L
.75977 .25962 L
.76442 .2655 L
.77506 .28365 L
.78365 .30769 L
.78625 .33173 L
.78242 .35577 L
.77026 .37981 L
.76442 .38728 L
.74366 .40385 L
.74038 .40577 L
.71635 .41616 L
.69231 .42163 L
.66827 .42324 L
.64423 .42086 L
.62019 .41299 L
.60548 .40385 L
.59615 .39452 L
.58701 .37981 L
.57914 .35577 L
.57676 .33173 L
.57837 .30769 L
.58384 .28365 L
.59423 .25962 L
.59615 .25634 L
.61272 .23558 L
F
0 g
.62019 .22974 m
.64423 .21758 L
.66827 .21375 L
.69231 .21635 L
.71635 .22494 L
.7345 .23558 L
.74038 .24023 L
.75977 .25962 L
.76442 .2655 L
.77506 .28365 L
.78365 .30769 L
.78625 .33173 L
.78242 .35577 L
.77026 .37981 L
.76442 .38728 L
.74366 .40385 L
.74038 .40577 L
.71635 .41616 L
.69231 .42163 L
.66827 .42324 L
.64423 .42086 L
.62019 .41299 L
.60548 .40385 L
.59615 .39452 L
.58701 .37981 L
.57914 .35577 L
.57676 .33173 L
.57837 .30769 L
.58384 .28365 L
.59423 .25962 L
.59615 .25634 L
.61272 .23558 L
.62019 .22974 L
s
.5 g
.62019 .58701 m
.64423 .57914 L
.66827 .57676 L
.69231 .57837 L
.71635 .58384 L
.74038 .59423 L
.74366 .59615 L
.76442 .61272 L
.77026 .62019 L
.78242 .64423 L
.78625 .66827 L
.78365 .69231 L
.77506 .71635 L
.76442 .7345 L
.75977 .74038 L
.74038 .75977 L
.7345 .76442 L
.71635 .77506 L
.69231 .78365 L
.66827 .78625 L
.64423 .78242 L
.62019 .77026 L
.61272 .76442 L
.59615 .74366 L
.59423 .74038 L
.58384 .71635 L
.57837 .69231 L
.57676 .66827 L
.57914 .64423 L
.58701 .62019 L
.59615 .60548 L
.60548 .59615 L
F
0 g
.62019 .58701 m
.64423 .57914 L
.66827 .57676 L
.69231 .57837 L
.71635 .58384 L
.74038 .59423 L
.74366 .59615 L
.76442 .61272 L
.77026 .62019 L
.78242 .64423 L
.78625 .66827 L
.78365 .69231 L
.77506 .71635 L
.76442 .7345 L
.75977 .74038 L
.74038 .75977 L
.7345 .76442 L
.71635 .77506 L
.69231 .78365 L
.66827 .78625 L
.64423 .78242 L
.62019 .77026 L
.61272 .76442 L
.59615 .74366 L
.59423 .74038 L
.58384 .71635 L
.57837 .69231 L
.57676 .66827 L
.57914 .64423 L
.58701 .62019 L
.59615 .60548 L
.60548 .59615 L
.62019 .58701 L
s
.6 g
.64423 .23395 m
.66827 .22962 L
.69231 .23255 L
.70622 .23558 L
.71635 .24241 L
.73908 .25962 L
.74038 .26092 L
.75759 .28365 L
.76442 .29378 L
.76745 .30769 L
.77038 .33173 L
.76605 .35577 L
.76442 .36178 L
.75193 .37981 L
.74038 .39104 L
.71733 .40385 L
.71635 .40423 L
.69231 .4111 L
.66827 .41308 L
.64423 .41015 L
.62361 .40385 L
.62019 .40038 L
.59962 .37981 L
.59615 .37639 L
.58985 .35577 L
.58692 .33173 L
.5889 .30769 L
.59577 .28365 L
.59615 .28267 L
.60896 .25962 L
.62019 .24807 L
.63822 .23558 L
F
0 g
.64423 .23395 m
.66827 .22962 L
.69231 .23255 L
.70622 .23558 L
.71635 .24241 L
.73908 .25962 L
.74038 .26092 L
.75759 .28365 L
.76442 .29378 L
.76745 .30769 L
.77038 .33173 L
.76605 .35577 L
.76442 .36178 L
.75193 .37981 L
.74038 .39104 L
.71733 .40385 L
.71635 .40423 L
.69231 .4111 L
.66827 .41308 L
.64423 .41015 L
.62361 .40385 L
.62019 .40038 L
.59962 .37981 L
.59615 .37639 L
.58985 .35577 L
.58692 .33173 L
.5889 .30769 L
.59577 .28365 L
.59615 .28267 L
.60896 .25962 L
.62019 .24807 L
.63822 .23558 L
.64423 .23395 L
s
.6 g
.64423 .58985 m
.66827 .58692 L
.69231 .5889 L
.71635 .59577 L
.71733 .59615 L
.74038 .60896 L
.75193 .62019 L
.76442 .63822 L
.76605 .64423 L
.77038 .66827 L
.76745 .69231 L
.76442 .70622 L
.75759 .71635 L
.74038 .73908 L
.73908 .74038 L
.71635 .75759 L
.70622 .76442 L
.69231 .76745 L
.66827 .77038 L
.64423 .76605 L
.63822 .76442 L
.62019 .75193 L
.60896 .74038 L
.59615 .71733 L
.59577 .71635 L
.5889 .69231 L
.58692 .66827 L
.58985 .64423 L
.59615 .62361 L
.59962 .62019 L
.62019 .59962 L
.62361 .59615 L
F
0 g
.64423 .58985 m
.66827 .58692 L
.69231 .5889 L
.71635 .59577 L
.71733 .59615 L
.74038 .60896 L
.75193 .62019 L
.76442 .63822 L
.76605 .64423 L
.77038 .66827 L
.76745 .69231 L
.76442 .70622 L
.75759 .71635 L
.74038 .73908 L
.73908 .74038 L
.71635 .75759 L
.70622 .76442 L
.69231 .76745 L
.66827 .77038 L
.64423 .76605 L
.63822 .76442 L
.62019 .75193 L
.60896 .74038 L
.59615 .71733 L
.59577 .71635 L
.5889 .69231 L
.58692 .66827 L
.58985 .64423 L
.59615 .62361 L
.59962 .62019 L
.62019 .59962 L
.62361 .59615 L
.64423 .58985 L
s
.7 g
.64423 .24978 m
.66827 .24474 L
.69231 .24814 L
.71623 .25962 L
.71635 .25992 L
.74008 .28365 L
.74038 .28377 L
.75186 .30769 L
.75526 .33173 L
.75022 .35577 L
.74038 .37552 L
.73334 .37981 L
.71635 .39184 L
.69231 .40033 L
.66827 .40264 L
.64423 .3992 L
.62019 .38632 L
.61368 .37981 L
.6008 .35577 L
.59736 .33173 L
.59967 .30769 L
.60816 .28365 L
.62019 .26666 L
.62448 .25962 L
F
0 g
.64423 .24978 m
.66827 .24474 L
.69231 .24814 L
.71623 .25962 L
.71635 .25992 L
.74008 .28365 L
.74038 .28377 L
.75186 .30769 L
.75526 .33173 L
.75022 .35577 L
.74038 .37552 L
.73334 .37981 L
.71635 .39184 L
.69231 .40033 L
.66827 .40264 L
.64423 .3992 L
.62019 .38632 L
.61368 .37981 L
.6008 .35577 L
.59736 .33173 L
.59967 .30769 L
.60816 .28365 L
.62019 .26666 L
.62448 .25962 L
.64423 .24978 L
s
.7 g
.62019 .61368 m
.64423 .6008 L
.66827 .59736 L
.69231 .59967 L
.71635 .60816 L
.73334 .62019 L
.74038 .62448 L
.75022 .64423 L
.75526 .66827 L
.75186 .69231 L
.74038 .71623 L
.74008 .71635 L
.71635 .74008 L
.71623 .74038 L
.69231 .75186 L
.66827 .75526 L
.64423 .75022 L
.62448 .74038 L
.62019 .73334 L
.60816 .71635 L
.59967 .69231 L
.59736 .66827 L
.6008 .64423 L
.61368 .62019 L
F
0 g
.62019 .61368 m
.64423 .6008 L
.66827 .59736 L
.69231 .59967 L
.71635 .60816 L
.73334 .62019 L
.74038 .62448 L
.75022 .64423 L
.75526 .66827 L
.75186 .69231 L
.74038 .71623 L
.74008 .71635 L
.71635 .74008 L
.71623 .74038 L
.69231 .75186 L
.66827 .75526 L
.64423 .75022 L
.62448 .74038 L
.62019 .73334 L
.60816 .71635 L
.59967 .69231 L
.59736 .66827 L
.6008 .64423 L
.61368 .62019 L
.62019 .61368 L
s
.8 g
.64423 .26586 m
.66827 .26004 L
.69231 .26394 L
.71635 .27872 L
.72128 .28365 L
.73606 .30769 L
.73996 .33173 L
.73414 .35577 L
.71635 .37831 L
.71453 .37981 L
.69231 .38857 L
.66827 .39175 L
.64423 .38698 L
.62797 .37981 L
.62019 .37203 L
.61302 .35577 L
.60825 .33173 L
.61143 .30769 L
.62019 .28547 L
.62169 .28365 L
F
0 g
.64423 .26586 m
.66827 .26004 L
.69231 .26394 L
.71635 .27872 L
.72128 .28365 L
.73606 .30769 L
.73996 .33173 L
.73414 .35577 L
.71635 .37831 L
.71453 .37981 L
.69231 .38857 L
.66827 .39175 L
.64423 .38698 L
.62797 .37981 L
.62019 .37203 L
.61302 .35577 L
.60825 .33173 L
.61143 .30769 L
.62019 .28547 L
.62169 .28365 L
.64423 .26586 L
s
.8 g
.64423 .61302 m
.66827 .60825 L
.69231 .61143 L
.71453 .62019 L
.71635 .62169 L
.73414 .64423 L
.73996 .66827 L
.73606 .69231 L
.72128 .71635 L
.71635 .72128 L
.69231 .73606 L
.66827 .73996 L
.64423 .73414 L
.62169 .71635 L
.62019 .71453 L
.61143 .69231 L
.60825 .66827 L
.61302 .64423 L
.62019 .62797 L
.62797 .62019 L
F
0 g
.64423 .61302 m
.66827 .60825 L
.69231 .61143 L
.71453 .62019 L
.71635 .62169 L
.73414 .64423 L
.73996 .66827 L
.73606 .69231 L
.72128 .71635 L
.71635 .72128 L
.69231 .73606 L
.66827 .73996 L
.64423 .73414 L
.62169 .71635 L
.62019 .71453 L
.61143 .69231 L
.60825 .66827 L
.61302 .64423 L
.62019 .62797 L
.62797 .62019 L
.64423 .61302 L
s
.9 g
.66827 .27616 m
.69231 .28165 L
.69795 .28365 L
.71635 .30205 L
.71835 .30769 L
.72384 .33173 L
.71635 .35463 L
.71616 .35577 L
.69231 .37695 L
.66827 .37926 L
.64423 .37533 L
.62467 .35577 L
.62074 .33173 L
.62305 .30769 L
.64423 .28384 L
.64537 .28365 L
F
0 g
.66827 .27616 m
.69231 .28165 L
.69795 .28365 L
.71635 .30205 L
.71835 .30769 L
.72384 .33173 L
.71635 .35463 L
.71616 .35577 L
.69231 .37695 L
.66827 .37926 L
.64423 .37533 L
.62467 .35577 L
.62074 .33173 L
.62305 .30769 L
.64423 .28384 L
.64537 .28365 L
.66827 .27616 L
s
.9 g
.64423 .62467 m
.66827 .62074 L
.69231 .62305 L
.71616 .64423 L
.71635 .64537 L
.72384 .66827 L
.71835 .69231 L
.71635 .69795 L
.69795 .71635 L
.69231 .71835 L
.66827 .72384 L
.64537 .71635 L
.64423 .71616 L
.62305 .69231 L
.62074 .66827 L
.62467 .64423 L
F
0 g
.64423 .62467 m
.66827 .62074 L
.69231 .62305 L
.71616 .64423 L
.71635 .64537 L
.72384 .66827 L
.71835 .69231 L
.71635 .69795 L
.69795 .71635 L
.69231 .71835 L
.66827 .72384 L
.64537 .71635 L
.64423 .71616 L
.62305 .69231 L
.62074 .66827 L
.62467 .64423 L
.64423 .62467 L
s
1 g
.66827 .29179 m
.69231 .30392 L
.69608 .30769 L
.70821 .33173 L
.69231 .35352 L
.68926 .35577 L
.66827 .36386 L
.65148 .35577 L
.64423 .34852 L
.63614 .33173 L
.64423 .31074 L
.64648 .30769 L
F
0 g
.66827 .29179 m
.69231 .30392 L
.69608 .30769 L
.70821 .33173 L
.69231 .35352 L
.68926 .35577 L
.66827 .36386 L
.65148 .35577 L
.64423 .34852 L
.63614 .33173 L
.64423 .31074 L
.64648 .30769 L
.66827 .29179 L
s
1 g
.66827 .63614 m
.68926 .64423 L
.69231 .64648 L
.70821 .66827 L
.69608 .69231 L
.69231 .69608 L
.66827 .70821 L
.64648 .69231 L
.64423 .68926 L
.63614 .66827 L
.64423 .65148 L
.65148 .64423 L
F
0 g
.66827 .63614 m
.68926 .64423 L
.69231 .64648 L
.70821 .66827 L
.69608 .69231 L
.69231 .69608 L
.66827 .70821 L
.64648 .69231 L
.64423 .68926 L
.63614 .66827 L
.64423 .65148 L
.65148 .64423 L
.66827 .63614 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00C@3oool500000080oooo0P00000e0?ooo`@000000`3oool2000003L0oooo0P0000040?oo
o`800000=`3oool300000080oooo0P00000?0?ooo`00C`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000003D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000g0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0303oool004l0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0b
0?ooo`D0000000D0oooo0000003oool0oooo0000000>0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0380
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000>0?ooo`00C`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0<P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000003D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000e0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003P3oool0
04h0oooo0P0000040?ooo`800000=P3oool2000000@0oooo0P00000g0?ooo`800000103oool20000
03L0oooo0P0000030?ooo`8000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`000005000000L0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooon@00
00040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oo
ooT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080ooooB@00000@01TI6DP000004@0I6AU7000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom5000001L06ATI
@P00000H01TI6D<000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oood4000007P0I6ATl000001h06ATI@00000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo?P00000S01TI6CP000008`0I6ATm000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oooll000002L06ATI=000000W01TI
6C/000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocX0
0000:`0I6AT`000002/06ATI>@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo>000000^01TI6Bh00000;P0I6ATg000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo0P0000030?ooocH00000<@0I6AT/000003406ATI=@0000040?ooo`8000001`3o
ool001D0oooo00<000000?ooo`3oool00P3ooole000003<06ATI:P00000c01TI6C@000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc<00000=P0I6ATX0000
03H06ATI<P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo<P00000H01TI6@l000004@0I6ATV000001406ATI3`00000H01TI6C4000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc4000005P0I6AT3000000l0<c<c
0`00000?01TI6B@000003`0I6AT3000000l0<c<c1000000E01TI6C0000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobl00000500I6AT4000001D0<c<c0P00
000=01TI6B@000003@0I6AT2000001H0<c<c0`00000D01TI6Bh000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobh000004P0I6AT3000001/0<c<c0P00000<
01TI6B800000300I6AT2000001/0<c<c0`00000B01TI6Bd000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooobd000004@0I6AT200000200<c<c0P00000:01TI
6B4000002`0I6AT200000200<c<c0P00000A01TI6B`000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooob`00000400I6AT2000002@0<c<c0P00000901TI6B00
00002@0I6AT2000002@0<c<c0P00000@01TI6B/000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooob/00000400I6AT00`000000<c<c03<c<`0A03<c<`D00000
400c<c<00`0000006ATI01TI6@0601TI6Al000002@0I6AT00`000000<c<c03<c<`0>03<c<`D00000
4`0c<c<00`0000006ATI01TI6@0>01TI6BX000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooobX000003`0I6AT2000000l0<c<c1@00000504a<C0D00000300c
<c<00`0000006ATI01TI6@0601TI6Ah00000200I6AT00`000000<c<c03<c<`0:03<c<`D000001@1<
C4`5000000l0<c<c0P00000?01TI6BT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooobP00000400I6AT00`000000<c<c03<c<`0<03<c<`<000003`1<C4`3
000000X0<c<c00<0000001TI6@0I6AT01@0I6ATM000000T06ATI00<0000003<c<`0c<c<01`0c<c<3
000000l0C4a<1000000=03<c<`030000000I6AT06ATI00h06ATI9`0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`8000000`3ooolW000000l06ATI0P00000;03<c<`@000005@1<C4`20000
00T0<c<c00<0000001TI6@0I6AT01@0I6ATL000000P06ATI00<0000003<c<`0c<c<01P0c<c<20000
01H0C4a<0`00000;03<c<`8000003`0I6ATV000000@0oooo0P0000070?ooo`005@3oool00`000000
oooo0?ooo`020?ooobH000003`0I6AT00`000000<c<c03<c<`0903<c<`8000006P1<C4`00`000000
<c<c03<c<`0803<c<`030000000I6AT06ATI00@06ATI6`00000801TI6@030000000c<c<0<c<c00L0
<c<c00<0000004a<C01<C4`0601<C4`2000000/0<c<c00<0000001TI6@0I6AT03@0I6ATU000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolU000000l06ATI
00<0000003<c<`0c<c<0200c<c<2000001d0C4a<0P00000803<c<`030000000I6AT06ATI00D06ATI
6P00000701TI6@030000000c<c<0<c<c00H0<c<c0P00000M04a<C08000002P0c<c<00`0000006ATI
01TI6@0=01TI6B@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooobD000003P0I6AT00`000000<c<c03<c<`0803<c<`030000001<C4`0C4a<00T0C4a<3P00
000804a<C08000001`0c<c<00`0000006ATI01TI6@0401TI6AX000001`0I6AT00`000000<c<c03<c
<`0403<c<`800000201<C4`>000000/0C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI
6@0<01TI6B@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooob@000003P0I6AT00`000000<c<c03<c<`0703<c<`8000002@1<C4`3000000h0IVIV0P000008
04a<C08000001@0c<c<00`0000006ATI01TI6@0401TI6AX000001P0I6AT00`000000<c<c03<c<`03
03<c<`800000201<C4`2000000h0IVIV1000000804a<C08000002@0c<c<00`0000006ATI01TI6@0<
01TI6B<000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ob<000003P0I6AT00`000000<c<c03<c<`0703<c<`030000001<C4`0C4a<00L0C4a<0P00000C06IV
IP800000201<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00@06ATI6000000601TI
6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`01P1<C4`2000001@0IVIV0P00000804a<
C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT0300I6ATR000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolS000000d06ATI00<0000003<c<`0c
<c<01P0c<c<2000000P0C4a<0P00000G06IVIP8000001P1<C4`00`000000<c<c03<c<`0303<c<`03
0000000I6AT06ATI00@06ATI6000000501TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<
C4`01@1<C4`2000001P0IVIV0P00000704a<C0800000200c<c<00`0000006ATI01TI6@0;01TI6B80
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob800000
3@0I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00L0C4a<00<0000006IVIP1VIVH0
2P1VIVH5000000X0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0303<c<`030000
000I6AT06ATI00<06ATI6000000501TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`0
101<C4`00`000000IVIV06IVIP0806IVIPD000003@1VIVH00`000000C4a<04a<C00604a<C0030000
000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02`0I6ATQ000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ000000d06ATI00<0000003<c<`0c<c<01P0c
<c<00`000000C4a<04a<C00604a<C0800000201VIVH5000000D0Ogmo1000000706IVIP030000001<
C4`0C4a<00@0C4a<00<0000003<c<`0c<c<00P0c<c<00`0000006ATI01TI6@0301TI6AP000001@0I
6AT00`000000<c<c03<c<`0203<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH01@1V
IVH4000000D0Ogmo1@00000906IVIP8000001`1<C4`00`000000<c<c03<c<`0603<c<`030000000I
6AT06ATI00/06ATI800000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooo8@00000<01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`01@1<C4`2
000000L0IVIV0`00000>07moO`8000001P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0
<c<c00<0<c<c00<0000001TI6@0I6AT00P0I6ATH000000@06ATI00<0000003<c<`0c<c<00`0c<c<0
0`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00@0IVIV0P00000>07moO`@000001`1VIVH0
0`000000C4a<04a<C00504a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATP
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolP0000
00`06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00504a<C0030000001VIVH0IVIV
00D0IVIV0P00000C07moO`8000001@1VIVH2000000@0C4a<00<0000003<c<`0c<c<00P0c<c<00`00
00006ATI01TI6@0201TI6AL000001@0I6AT00`000000<c<c03<c<`0203<c<`030000001<C4`0C4a<
0080C4a<0P00000506IVIP800000501oOgl2000000H0IVIV00<0000004a<C01<C4`01@1<C4`00`00
0000<c<c03<c<`0603<c<`030000000I6AT06ATI00X06ATI7`0000050?ooo`030000003oool0oooo
00D0oooo00070?ooo`D000000P3oool2000000D0oooo00<000000?ooo`3oool00P3ooolP000000/0
6ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00404a<C08000001P1VIVH2000000X0
Ogmo1@00000807moO`8000001@1VIVH00`000000C4a<04a<C00204a<C0050000000c<c<0<c<c03<c
<`0000001@0I6ATF000000D06ATI00D0000003<c<`0c<c<0<c<c0000000404a<C0030000001VIVH0
IVIV00<0IVIV0P00000807moO`D000002`1oOgl00`000000IVIV06IVIP0406IVIP8000001P1<C4`0
0`000000<c<c03<c<`0603<c<`030000000I6AT06ATI00T06ATI7`0000050?ooo`030000003oool0
oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`02
0?ooo`030000003oool0oooo0080oooo7`00000<01TI6@030000000c<c<0<c<c00D0<c<c00<00000
04a<C01<C4`0101<C4`00`000000IVIV06IVIP0406IVIP8000001`1oOgl5000000D0VIVI10000006
07moO`030000001VIVH0IVIV00<0IVIV00D0000004a<C01<C4`0C4a<0000000403<c<`030000000I
6AT06ATI00806ATI5P00000401TI6@030000000c<c<0<c<c0080<c<c00D0000004a<C01<C4`0C4a<
0000000506IVIP030000001oOgl0Ogmo00@0Ogmo1000000509VIV@D000001`1oOgl2000000H0IVIV
00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI
7P0000050?ooo`030000003oool0oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`020?ooo`<000000P3ooolO000000/06ATI00<0000003<c<`0c<c<0
1@0c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV00@0IVIV00<0000007moO`1oOgl0
101oOgl3000000h0VIVI0P00000507moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0
0P1<C4`01@000000<c<c03<c<`0c<c<0000000@06ATI5P00000401TI6@050000000c<c<0<c<c03<c
<`000000101<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo00<0Ogmo0P00000>09VI
V@<000001P1oOgl00`000000IVIV06IVIP0406IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c
<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6Ah000000`3oool3000000L0oooo00090?ooo`05
0000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
0080oooo7P00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`00`00
0000IVIV06IVIP0306IVIP8000001P1oOgl00`000000VIVI09VIV@0A09VIV@030000001oOgl0Ogmo
00<0Ogmo00<0000006IVIP1VIVH00P1VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c00<00000
01TI6@0I6AT00P0I6ATF000000@06ATI00@0000003<c<`0c<c<00000101<C4`00`000000IVIV06IV
IP0206IVIP030000001oOgl0Ogmo00<0Ogmo00<0000009VIV@2IVIT04@2IVIT2000000D0Ogmo0P00
000506IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI
6@0801TI6Ah000001@3oool00`000000oooo0?ooo`050?ooo`002@3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oooah000002`0I
6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1V
IVH00`000000Ogmo07moO`0507moO`030000002IVIT0VIVI00L0VIVI1@00000709VIV@800000101o
Ogl01@000000IVIV06IVIP1VIVH0000000@0C4a<00D0000003<c<`0c<c<0<c<c0000000301TI6AH0
00000`0I6AT01@000000<c<c03<c<`0c<c<0000000@0C4a<00D0000006IVIP1VIVH0IVIV00000004
07moO`8000001`2IVIT5000000X0VIVI00<0000007moO`1oOgl0101oOgl00`000000IVIV06IVIP03
06IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@09
01TI6Ad000001@3oool00`000000oooo0?ooo`050?ooo`00203oool2000000@0oooo0P0000050?oo
o`030000003oool0oooo0080oooo7@00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<
C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00@0Ogmo0P00000609VI
V@@000001@2c/k<4000000D0VIVI00<0000007moO`1oOgl00P1oOgl01@000000IVIV06IVIP1VIVH0
000000<0C4a<00D0000003<c<`0c<c<0<c<c0000000301TI6AD00000100I6AT01@000000<c<c03<c
<`0c<c<0000000<0C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`030000002IVIT0VIVI00<0
VIVI100000050;>c/`D000001P2IVIT00`000000Ogmo07moO`0407moO`030000001VIVH0IVIV00<0
IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00P0
6ATI7@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
7@00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV
06IVIP0206IVIP030000001oOgl0Ogmo00@0Ogmo00<0000009VIV@2IVIT0102IVIT2000000d0/k>c
0P00000409VIV@030000001oOgl0Ogmo0080Ogmo00D0000006IVIP1VIVH0IVIV0000000204a<C005
0000000c<c<0<c<c03<c<`000000100I6ATD000000@06ATI00@0000003<c<`0c<c<000000`1<C4`0
1@000000IVIV06IVIP1VIVH0000000@0Ogmo00<0000009VIV@2IVIT00P2IVIT2000000h0/k>c0P00
000509VIV@8000001@1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00@0C4a<00<0
000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI6A`000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa`000002`0I6AT00`000000<c<c03<c<`05
03<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`03
07moO`8000001@2IVIT200000140/k>c0P00000309VIV@030000001oOgl0Ogmo0080Ogmo00@00000
06IVIP1VIVH000000`1<C4`01@000000<c<c03<c<`0c<c<0000000<06ATI5000000301TI6@050000
000c<c<0<c<c03<c<`0000000`1<C4`010000000IVIV06IVIP00000407moO`040000002IVIT0VIVI
09VIV@8000004P2c/k<2000000D0VIVI00<0000007moO`1oOgl00`1oOgl00`000000IVIV06IVIP02
06IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@08
01TI6A`000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
oa`000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IV
IP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`8000001@2IVIT2000000P0/k>c100000090;>c
/`050000002IVIT0VIVI09VIV@0000000`1oOgl01@000000IVIV06IVIP1VIVH000000080C4a<00D0
000003<c<`0c<c<0<c<c0000000301TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<000000080
C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`050000002IVIT0VIVI09VIV@0000002@2c/k<4
000000T0/k>c0P00000409VIV@800000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0
C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI6A/000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa`000002@0I6AT00`00
0000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`00
0000Ogmo07moO`0207moO`030000002IVIT0VIVI00@0VIVI00<000000;>c/`2c/k<0102c/k<40000
00@0c<c<0`0000060;>c/`030000002IVIT0VIVI0080VIVI00@0000007moO`1oOgl000000`1VIVH0
10000000C4a<04a<C000000303<c<`040000000I6AT06ATI01TI6A@000000`0I6AT01@000000<c<c
03<c<`0c<c<000000080C4a<00@0000006IVIP1VIVH000000`1oOgl01@000000VIVI09VIV@2IVIT0
000000L0/k>c0`0000040<c<c0@000001`2c/k<00`000000VIVI09VIV@0309VIV@030000001oOgl0
Ogmo0080Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0
<c<c00D0<c<c00<0000001TI6@0I6AT0200I6ATK000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolK000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`00
0000C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP0000001@1oOgl00`000000VIVI09VIV@03
09VIV@030000002c/k<0/k>c00<0/k>c0P00000;0<c<c08000001@2c/k<01@000000VIVI09VIV@2I
VIT0000000<0Ogmo00D0000006IVIP1VIVH0IVIV0000000204a<C0040000000c<c<0<c<c000000<0
6ATI5000000201TI6@050000000c<c<0<c<c03<c<`0000000P1<C4`01@000000IVIV06IVIP1VIVH0
000000<0Ogmo00D0000009VIV@2IVIT0VIVI000000050;>c/`8000002`3<c<`2000000H0/k>c00<0
000009VIV@2IVIT00P2IVIT00`000000Ogmo07moO`0307moO`050000001VIVH0IVIV06IVIP000000
1@1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI6P0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6`00000:01TI6@030000000c
<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001o
Ogl0Ogmo0080Ogmo00<0000009VIV@2IVIT00P2IVIT2000000D0/k>c00<000000<c<c03<c<`03@3<
c<`2000000@0/k>c00D0000009VIV@2IVIT0VIVI0000000207moO`050000001VIVH0IVIV06IVIP00
00000P1<C4`01@000000<c<c03<c<`0c<c<0000000806ATI4`00000301TI6@050000000c<c<0<c<c
03<c<`0000000P1<C4`010000000IVIV06IVIP00000307moO`050000002IVIT0VIVI09VIV@000000
102c/k<2000000l0c<c<0P0000050;>c/`030000002IVIT0VIVI0080VIVI00<0000007moO`1oOgl0
0P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0
1@0c<c<00`0000006ATI01TI6@0801TI6AX000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooaX000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<
C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002I
VIT0VIVI0080VIVI00<000000;>c/`2c/k<00`2c/k<2000000P0c<c<0`0000070<c<c0030000002c
/k<0/k>c0080/k>c00D0000009VIV@2IVIT0VIVI0000000207moO`040000001VIVH0IVIV00000080
C4a<00D0000003<c<`0c<c<0<c<c0000000301TI6A8000000`0I6AT01@000000<c<c03<c<`0c<c<0
00000080C4a<00@0000006IVIP1VIVH000000P1oOgl01@000000VIVI09VIV@2IVIT0000000@0/k>c
00<000000<c<c03<c<`01@3<c<`3000000T0c<c<0P0000040;>c/`030000002IVIT0VIVI0080VIVI
00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6AT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaX000002P0I6AT00`000000<c<c03<c
<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07mo
O`0207moO`050000002IVIT0VIVI09VIV@0000001@2c/k<00`000000c<c<0<c<c0050<c<c0<00000
0`3Vi^H3000000D0c<c<0P0000030;>c/`040000002IVIT0VIVI00000080Ogmo00D0000006IVIP1V
IVH0IVIV0000000204a<C0040000000c<c<0<c<c000000<06ATI4P00000301TI6@040000000c<c<0
<c<c00000080C4a<00@0000006IVIP1VIVH000000`1oOgl01@000000VIVI09VIV@2IVIT000000080
/k>c0P0000050<c<c0<000000`3Vi^H3000000P0c<c<00<000000;>c/`2c/k<00P2c/k<01@000000
VIVI09VIV@2IVIT0000000@0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<
C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT0200I6ATI000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo0P0000030?oooaX000002P0I6AT00`000000<c<c03<c<`0403<c<`03
0000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`05
0000002IVIT0VIVI09VIV@000000102c/k<2000000@0c<c<100000090>KViP8000001@3<c<`01@00
0000/k>c0;>c/`2c/k<000000080VIVI00@0000007moO`1oOgl000000P1VIVH010000000C4a<04a<
C000000203<c<`040000000I6AT06ATI01TI6A8000000`0I6AT010000000<c<c03<c<`00000204a<
C0040000001VIVH0IVIV00000080Ogmo00D0000009VIV@2IVIT0VIVI000000020;>c/`030000003<
c<`0c<c<00<0c<c<0P0000090>KViP@000001@3<c<`00`000000/k>c0;>c/`020;>c/`050000002I
VIT0VIVI09VIV@000000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AT00000103oool2000000L0oooo
000E0?ooo`030000003oool0oooo0080oooo6P00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0
000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`000000
0`2IVIT00`000000/k>c0;>c/`020;>c/`030000003<c<`0c<c<00<0c<c<00<000000>KViP3Vi^H0
3@3Vi^H00`000000c<c<0<c<c0020<c<c0050000002c/k<0/k>c0;>c/`0000000P2IVIT010000000
Ogmo07moO`00000206IVIP040000001<C4`0C4a<00000080<c<c00@0000001TI6@0I6AT06ATI4P00
000301TI6@040000000c<c<0<c<c00000080C4a<00@0000006IVIP1VIVH000000P1oOgl010000000
VIVI09VIV@0000030;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H03@3Vi^H00`00
0000c<c<0<c<c0030<c<c0050000002c/k<0/k>c0;>c/`000000102IVIT01@000000Ogmo07moO`1o
Ogl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I
6AT06ATI00P06ATI6@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooo6@00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`0
1@000000IVIV06IVIP1VIVH0000000@0Ogmo00D0000009VIV@2IVIT0VIVI000000040;>c/`030000
003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H01`3Vi^H00`000000i^KV0>KViP050>KViP030000
003<c<`0c<c<0080c<c<00D000000;>c/`2c/k<0/k>c0000000209VIV@030000001oOgl000000080
IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00@00000
03<c<`0c<c<000000P1<C4`010000000IVIV06IVIP00000207moO`040000002IVIT0VIVI00000080
/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP050>KViP030000003Vi^H0i^KV00L0
i^KV00<000000<c<c03<c<`00P3<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VI
V@000000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c<`0403<c<`03
0000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl00000
00<0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0030<c<c0030000003Vi^H0i^KV
00D0i^KV0P0000000`3oool00000000000060>KViP050000003<c<`0c<c<0<c<c00000000`2c/k<0
1P000000VIVI09VIV@000000Ogmo00000080IVIV00@0000004a<C01<C4`000000P0c<c<010000000
6ATI01TI6@0I6ATA000000@06ATI00<0000003<c<`0000000P1<C4`010000000IVIV06IVIP000002
07moO`040000002IVIT0VIVI000000<0/k>c00D000000<c<c03<c<`0c<c<000000060>KViP800000
00<0oooo000000000000203Vi^H00`000000c<c<0<c<c0020<c<c0050000002c/k<0/k>c0;>c/`00
0000102IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI600000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo6@00000:01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07mo
O`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0000000D0c<c<00<000000>KViP3Vi^H0103Vi^H2
000000D0oooo00<000000>KViP3Vi^H0103Vi^H01@000000c<c<0<c<c03<c<`000000080/k>c00@0
000009VIV@2IVIT000000P1oOgl010000000IVIV06IVIP00000204a<C0040000000c<c<0<c<c0000
00<06ATI4000000401TI6@030000000c<c<000000080C4a<00@0000006IVIP1VIVH000000P1oOgl0
10000000VIVI09VIV@0000020;>c/`050000003<c<`0c<c<0<c<c00000001P3Vi^H00`000000oooo
0?ooo`030?ooo`8000001`3Vi^H00`000000c<c<0<c<c0020<c<c0050000002c/k<0/k>c0;>c/`00
00000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI600000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000000:01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VI
V@2IVIT0VIVI000000040;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H00`3Vi^H2
000000P0oooo0P0000050>KViP040000003<c<`0c<c<000000<0/k>c00H0000009VIV@2IVIT00000
07moO`00000206IVIP040000001<C4`0C4a<00000080<c<c00@0000001TI6@0I6AT06ATI40000004
01TI6@030000000c<c<000000080C4a<00@0000006IVIP1VIVH000000P1oOgl00`000000VIVI0000
00030;>c/`040000003<c<`0c<c<000000D0i^KV0P0000080?ooo`8000001P3Vi^H01@000000c<c<
0<c<c03<c<`0000000<0/k>c00<0000009VIV@2IVIT00P2IVIT01@000000Ogmo07moO`1oOgl00000
00@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00P06ATI5`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo6000000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`01@000000
IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VIV@2IVIT0VIVI000000030;>c/`030000003<c<`0
c<c<0080c<c<00<000000>KViP3Vi^H00`3Vi^H00`000000oooo0?ooo`0:0?ooo`030000003Vi^H0
i^KV00<0i^KV00@000000<c<c03<c<`000000P2c/k<01P000000VIVI09VIV@000000Ogmo00000080
IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6AT@000000@06ATI00<00000
03<c<`0000000P1<C4`010000000IVIV06IVIP00000207moO`030000002IVIT000000080/k>c00@0
00000<c<c03<c<`000001@3Vi^H00`000000oooo0?ooo`0:0?ooo`030000003Vi^H0i^KV00<0i^KV
00<000000<c<c03<c<`00P3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1o
Ogl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0801TI6AL000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooaP000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0
C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`050000002IVIT0VIVI09VIV@0000000`2c/k<0
0`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV00<0i^KV00<000000?ooo`3oool02P3oool0
0`000000i^KV0>KViP030>KViP040000003<c<`0c<c<00000080/k>c00H0000009VIV@2IVIT00000
07moO`00000206IVIP040000001<C4`0C4a<00000080<c<c00@0000001TI6@0I6AT06ATI40000004
01TI6@030000000c<c<000000080C4a<00@0000006IVIP1VIVH000000P1oOgl00`000000VIVI0000
00020;>c/`040000003<c<`0c<c<000000D0i^KV00<000000?ooo`3oool02P3oool00`000000i^KV
0>KViP030>KViP030000003<c<`0c<c<0080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@05
0000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl01@000000VIVI09VIV@2IVIT0
000000<0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP020>KViP030000003oool0
oooo00/0oooo00<000000>KViP3Vi^H00`3Vi^H010000000c<c<0<c<c00000020;>c/`060000002I
VIT0VIVI0000001oOgl000000P1VIVH010000000C4a<04a<C000000203<c<`040000000I6AT06ATI
01TI6A000000100I6AT00`000000<c<c0000000204a<C0040000001VIVH0IVIV00000080Ogmo00<0
000009VIV@0000000P2c/k<010000000c<c<0<c<c00000050>KViP030000003oool0oooo00/0oooo
00<000000>KViP3Vi^H00`3Vi^H01@000000c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2I
VIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000000:01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VI
V@2IVIT0VIVI000000030;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H00P3Vi^H0
0`000000oooo0?ooo`0<0?ooo`030000003Vi^H0i^KV0080i^KV00@000000<c<c03<c<`000000P2c
/k<01P000000VIVI09VIV@000000Ogmo00000080IVIV00@0000004a<C01<C4`000000P0c<c<01000
00006ATI01TI6@0I6AT@000000@06ATI00<0000003<c<`0000000P1<C4`010000000IVIV06IVIP00
000207moO`030000002IVIT000000080/k>c00@000000<c<c03<c<`00000103Vi^H00`000000oooo
0?ooo`0<0?ooo`030000003Vi^H0i^KV00<0i^KV00D000000<c<c03<c<`0c<c<000000030;>c/`05
0000002IVIT0VIVI09VIV@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<
0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AL000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaP000002P0I6AT00`000000
<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000407mo
O`040000002IVIT0VIVI000000<0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP02
0>KViP030000003oool0oooo00d0oooo00<000000>KViP3Vi^H00P3Vi^H01`000000c<c<0<c<c03<
c<`000000;>c/`0000000P2IVIT01P000000Ogmo07moO`000000IVIV00000080C4a<00@0000003<c
<`0c<c<000000`0I6AT@000000<06ATI00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV0000
000207moO`040000002IVIT0VIVI00000080/k>c00@000000<c<c03<c<`00000103Vi^H00`000000
oooo0?ooo`0=0?ooo`030000003Vi^H0i^KV0080i^KV00<000000<c<c03<c<`00P3<c<`01@000000
/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0
C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AL000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaP000002P0I6AT00`00
0000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV00000004
07moO`040000002IVIT0VIVI000000<0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KV
iP020>KViP030000003oool0oooo00d0oooo00<000000>KViP3Vi^H00P3Vi^H01`000000c<c<0<c<
c03<c<`000000;>c/`0000000P2IVIT01P000000Ogmo07moO`000000IVIV00000080C4a<00@00000
03<c<`0c<c<000000`0I6AT@000000<06ATI00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV
0000000207moO`040000002IVIT0VIVI00000080/k>c00@000000<c<c03<c<`00000103Vi^H00`00
0000oooo0?ooo`0=0?ooo`030000003Vi^H0i^KV0080i^KV00<000000<c<c03<c<`00P3<c<`01@00
0000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<
C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AL000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaP000002P0I6AT0
0`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000
000407moO`040000002IVIT0VIVI000000<0/k>c00<000000<c<c03<c<`00P3<c<`01@000000i^KV
0>KViP3Vi^H000000140oooo00D000000>KViP3Vi^H0i^KV000000030<c<c0030000002c/k<00000
0080VIVI00H0000007moO`1oOgl0000006IVIP00000204a<C0040000000c<c<0<c<c000000<06ATI
4000000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl010000000
VIVI09VIV@0000020;>c/`040000003<c<`0c<c<000000<0i^KV00<000000?ooo`3oool03`3oool0
0`000000i^KV0>KViP020>KViP050000003<c<`0c<c<0<c<c00000000`2c/k<01@000000VIVI09VI
V@2IVIT0000000<0Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c00@0
<c<c00<0000001TI6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
0P0000030?oooaP000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<
00D0000006IVIP1VIVH0IVIV0000000407moO`040000002IVIT0VIVI000000<0/k>c00<000000<c<
c03<c<`00P3<c<`01@000000i^KV0>KViP3Vi^H000000140oooo00D000000>KViP3Vi^H0i^KV0000
00030<c<c0030000002c/k<000000080VIVI00H0000007moO`1oOgl0000006IVIP00000204a<C004
0000000c<c<0<c<c000000<06ATI4000000301TI6@040000000c<c<0<c<c00000080C4a<00<00000
06IVIP0000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<000000<0i^KV
00<000000?ooo`3oool03`3oool00`000000i^KV0>KViP020>KViP050000003<c<`0c<c<0<c<c000
00000`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00D0000006IVIP1VIVH0IVIV00000004
04a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATG000000@0oooo0P000007
0?ooo`005@3oool00`000000oooo0?ooo`020?oooaP000002P0I6AT00`000000<c<c03<c<`0403<c
<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`040000002IVIT0
VIVI000000<0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP020>KViP030000003o
ool0oooo00d0oooo00<000000>KViP3Vi^H00P3Vi^H01`000000c<c<0<c<c03<c<`000000;>c/`00
00000P2IVIT01P000000Ogmo07moO`000000IVIV00000080C4a<00@0000003<c<`0c<c<000000`0I
6AT@000000<06ATI00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`040000
002IVIT0VIVI00000080/k>c00@000000<c<c03<c<`000000`3Vi^H00`000000oooo0?ooo`0>0?oo
o`030000003Vi^H0i^KV00<0i^KV00D000000<c<c03<c<`0c<c<000000030;>c/`050000002IVIT0
VIVI09VIV@0000000`1oOgl01@000000IVIV06IVIP1VIVH0000000@0C4a<00<0000003<c<`0c<c<0
100c<c<00`0000006ATI01TI6@0801TI6AL000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooaP000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<
C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`050000002IVIT0VIVI09VIV@00
00000`2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV0080i^KV00<000000?ooo`3o
ool0303oool00`000000i^KV0>KViP020>KViP040000003<c<`0c<c<00000080/k>c00@0000009VI
V@2IVIT000000P1oOgl00`000000IVIV0000000204a<C0040000000c<c<0<c<c000000<06ATI4000
000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl010000000VIVI
09VIV@0000020;>c/`040000003<c<`0c<c<000000@0i^KV00<000000?ooo`3oool0303oool00`00
0000i^KV0>KViP030>KViP050000003<c<`0c<c<0<c<c00000000`2c/k<01@000000VIVI09VIV@2I
VIT0000000@0Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<
C00204a<C0050000001VIVH0IVIV06IVIP000000101oOgl01@000000VIVI09VIV@2IVIT0000000<0
/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP020>KViP030000003oool0oooo00/0
oooo00<000000>KViP3Vi^H00P3Vi^H01`000000c<c<0<c<c03<c<`000000;>c/`0000000P2IVIT0
10000000Ogmo07moO`00000206IVIP060000001<C4`0C4a<0000000c<c<00000100I6AT@000000<0
6ATI00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`040000002IVIT0VIVI
00000080/k>c00@000000<c<c03<c<`00000103Vi^H00`000000oooo0?ooo`0<0?ooo`030000003V
i^H0i^KV00<0i^KV00D000000<c<c03<c<`0c<c<000000030;>c/`050000002IVIT0VIVI09VIV@00
00000`1oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<00`0c<c<00`00
00006ATI01TI6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00<0
C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`040000002IVIT0VIVI000000<0/k>c00<00000
0<c<c03<c<`00P3<c<`00`000000i^KV0>KViP030>KViP030000003oool0oooo00X0oooo00<00000
0>KViP3Vi^H00P3Vi^H01`000000c<c<0<c<c03<c<`000000;>c/`0000000P2IVIT010000000Ogmo
07moO`00000206IVIP060000001<C4`0C4a<0000000c<c<00000100I6AT@000000@06ATI00<00000
03<c<`0000000P1<C4`010000000IVIV06IVIP00000207moO`040000002IVIT0VIVI00000080/k>c
00@000000<c<c03<c<`00000103Vi^H00`000000oooo0?ooo`0:0?ooo`030000003Vi^H0i^KV00@0
i^KV00D000000<c<c03<c<`0c<c<000000030;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl0
1@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI
6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?oooaT000002P0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00<0C4a<00D00000
06IVIP1VIVH0IVIV0000000407moO`050000002IVIT0VIVI09VIV@0000000`2c/k<00`000000c<c<
0<c<c0020<c<c0030000003Vi^H0i^KV00<0i^KV00<000000?ooo`3oool0203oool00`000000i^KV
0>KViP030>KViP040000003<c<`0c<c<00000080/k>c00@0000009VIV@2IVIT000000P1oOgl01000
0000IVIV06IVIP00000204a<C0030000000c<c<0000000@06ATI4000000401TI6@030000000c<c<0
00000080C4a<00@0000006IVIP1VIVH000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000
003<c<`0c<c<000000D0i^KV00<000000?ooo`3oool0203oool00`000000i^KV0>KViP040>KViP05
0000003<c<`0c<c<0<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT0000000@0Ogmo00D00000
06IVIP1VIVH0IVIV0000000504a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I
6ATH000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolI
000000X06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0
IVIV06IVIP000000101oOgl01@000000VIVI09VIV@2IVIT0000000<0/k>c00<000000<c<c03<c<`0
0P3<c<`00`000000i^KV0>KViP040>KViP8000001`3oool00`000000i^KV0>KViP040>KViP040000
003<c<`0c<c<00000080/k>c00@0000009VIV@2IVIT000000P1oOgl010000000IVIV06IVIP000002
04a<C0030000000c<c<0000000@06ATI4000000401TI6@030000000c<c<000000080C4a<00@00000
06IVIP1VIVH000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<000000H0
i^KV00<000000?ooo`3oool01P3oool2000000H0i^KV00D000000<c<c03<c<`0c<c<000000030;>c
/`050000002IVIT0VIVI09VIV@000000101oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0
000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0801TI6AP000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c<`03
03<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1o
Ogl0000000<0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0020<c<c0030000003V
i^H0i^KV00D0i^KV0P0000030?ooo`8000001P3Vi^H010000000c<c<0<c<c00000020;>c/`050000
002IVIT0VIVI09VIV@0000000P1oOgl010000000IVIV06IVIP00000204a<C0030000000c<c<00000
00@06ATI4000000401TI6@030000000c<c<000000080C4a<00@0000006IVIP1VIVH000000P1oOgl0
10000000VIVI09VIV@0000020;>c/`050000003<c<`0c<c<0<c<c00000001P3Vi^H2000000<0oooo
0`0000060>KViP8000000`3<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@00
00000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c
<c<0100c<c<00`0000006ATI01TI6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooaT000002`0I6AT00`000000<c<c03<c<`0303<c<`030000
001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`050000002IVIT0VIVI09VI
V@000000102c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV00H0i^KV0`0000070>KV
iP050000003<c<`0c<c<0<c<c00000000P2c/k<01`000000VIVI09VIV@2IVIT0000007moO`000000
0`1VIVH00`000000C4a<0000000203<c<`030000000I6AT06ATI00806ATI4000000401TI6@060000
000c<c<0<c<c0000001<C4`000000`1VIVH00`000000Ogmo0000000309VIV@040000002c/k<0/k>c
000000<0c<c<00<000000>KViP3Vi^H01@3Vi^H3000000P0i^KV00<000000<c<c03<c<`00`3<c<`0
1@000000/k>c0;>c/`2c/k<0000000<0VIVI00<0000007moO`1oOgl00P1oOgl01@000000IVIV06IV
IP1VIVH0000000D0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0901TI6AP00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002`0I
6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1V
IVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<
0<c<c0030<c<c08000003`3Vi^H01@000000c<c<0<c<c03<c<`000000080/k>c00D0000009VIV@2I
VIT0VIVI0000000207moO`040000001VIVH0IVIV00000080C4a<00@0000003<c<`0c<c<000000`0I
6ATA000000@06ATI00@0000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP00000207moO`04
0000002IVIT0VIVI00000080/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP0>0>KV
iP030000003<c<`0c<c<00<0c<c<00<000000;>c/`2c/k<00P2c/k<01@000000VIVI09VIV@2IVIT0
000000<0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0
<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATI000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolJ000000X06ATI00<0000003<c<`0c<c<0100c<c<00`00
0000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo00000003
09VIV@030000002c/k<0/k>c0080/k>c00<000000<c<c03<c<`0103<c<`00`000000i^KV0>KViP0;
0>KViP030000003<c<`0c<c<0080c<c<00@000000;>c/`2c/k<000000`2IVIT010000000Ogmo07mo
O`00000206IVIP040000001<C4`0C4a<00000080<c<c00@0000001TI6@0I6AT06ATI4P00000301TI
6@040000000c<c<0<c<c00000080C4a<00@0000006IVIP1VIVH000000P1oOgl01@000000VIVI09VI
V@2IVIT000000080/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP0;0>KViP800000
1@3<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@000000101oOgl00`000000
IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`000000
6ATI01TI6@0801TI6AT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?oooaX000002`0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00<0C4a<
00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c/`2c
/k<00`2c/k<00`000000c<c<0<c<c0040<c<c0<000001`3Vi^H3000000@0c<c<00@000000;>c/`2c
/k<00000102IVIT00`000000Ogmo0000000306IVIP030000001<C4`0000000<0<c<c00@0000001TI
6@0I6AT06ATI4P00000301TI6@070000000c<c<0<c<c03<c<`000000C4a<0000000306IVIP030000
001oOgl0000000<0VIVI00D000000;>c/`2c/k<0/k>c000000040<c<c0<000001`3Vi^H3000000L0
c<c<00<000000;>c/`2c/k<00P2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00<0000006IV
IP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI
6@0I6AT02@0I6ATI000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oooaX0
00002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1V
IVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI0P0000040;>c/`8000001`3<c<`70000
00H0c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@040000001oOgl0Ogmo00000080IVIV00@0
000004a<C01<C4`000000`0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00D0000003<c<`0c
<c<0<c<c0000000204a<C0040000001VIVH0IVIV00000080Ogmo00D0000009VIV@2IVIT0VIVI0000
00030;>c/`030000003<c<`0c<c<00@0c<c<1`0000070<c<c0<000000`2c/k<2000000<0VIVI00<0
000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0
000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6AT00000103oool2000000L0oooo000E
0?ooo`030000003oool0oooo0080oooo6`00000:01TI6@030000000c<c<0<c<c00D0<c<c00<00000
04a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00<00000
09VIV@2IVIT00P2IVIT2000000@0/k>c0`00000?0<c<c08000000`2c/k<01@000000VIVI09VIV@2I
VIT000000080Ogmo00@0000006IVIP1VIVH000000`1<C4`01@000000<c<c03<c<`0c<c<0000000<0
6ATI4P00000301TI6@050000000c<c<0<c<c03<c<`0000000`1<C4`00`000000IVIV0000000307mo
O`050000002IVIT0VIVI09VIV@0000000`2c/k<2000000l0c<c<0`0000050;>c/`030000002IVIT0
VIVI0080VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0
C4a<0080C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI6AX000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa/000002P0I6AT00`00
0000<c<c03<c<`0603<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH00`00
0000Ogmo07moO`0207moO`030000002IVIT0VIVI00<0VIVI0P0000050;>c/`@000001`3<c<`40000
00@0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`040000001VIVH0IVIV00000080C4a<00D0
000003<c<`0c<c<0<c<c0000000301TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<000000080
C4a<00@0000006IVIP1VIVH000000`1oOgl01@000000VIVI09VIV@2IVIT0000000@0/k>c10000007
0<c<c0@000001P2c/k<2000000@0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP02
06IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@08
01TI6AX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
oa`000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IV
IP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI00@0VIVI0P0000070;>c
/`L000001P2c/k<200000080VIVI0P00000307moO`040000001VIVH0IVIV000000<0C4a<00D00000
03<c<`0c<c<0<c<c0000000301TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<
00<0000006IVIP000000101oOgl200000080VIVI0P0000060;>c/`L00000202c/k<2000000D0VIVI
00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0801TI6A/000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooad000002P0I6AT00`000000<c<c03<c
<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH2000000<0Ogmo0P00
000609VIV@<000003`2c/k<2000000<0VIVI00<0000007moO`1oOgl00`1oOgl010000000IVIV06IV
IP00000304a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATD000000<06ATI00D0000003<c<`0c
<c<0<c<c0000000404a<C0030000001VIVH0000000D0Ogmo00@0000009VIV@2IVIT0VIVI0P00000?
0;>c/`@000001@2IVIT2000000<0Ogmo0P00000406IVIP030000001<C4`0C4a<00<0C4a<00<00000
03<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI6A`000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooad000002`0I6AT00`000000<c<c03<c<`0503<c
<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0207mo
O`8000001`2IVIT4000000L0/k>c1000000409VIV@030000001oOgl0Ogmo0080Ogmo0P00000206IV
IP050000001<C4`0C4a<04a<C00000000`0c<c<0100000006ATI01TI6@0I6ATF000000<06ATI00D0
000003<c<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV00800000101oOgl00`000000VIVI
09VIV@0209VIV@@000001`2c/k<4000000L0VIVI0P00000407moO`030000001VIVH0IVIV00<0IVIV
00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI
700000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo7P00
000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IV
IP0306IVIP030000001oOgl0Ogmo00<0Ogmo1000000709VIV@L000001`2IVIT2000000<0Ogmo00<0
000006IVIP1VIVH00P1VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c00@0000001TI6@0I6AT0
6ATI5P00000301TI6@050000000c<c<0<c<c03<c<`000000101<C4`01@000000IVIV06IVIP1VIVH0
000000@0Ogmo0P00000609VIV@L00000202IVIT3000000D0Ogmo00<0000006IVIP1VIVH00`1VIVH0
0`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATM
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolN0000
00`06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV
00<0IVIV0P00000707moO`<000003`2IVIT3000000@0Ogmo00<0000006IVIP1VIVH00P1VIVH01@00
0000C4a<04a<C01<C4`0000000<0<c<c00<0000001TI6@0I6AT00P0I6ATF000000@06ATI00D00000
03<c<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00`1o
Ogl2000000l0VIVI1000000707moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<
C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI7P0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo7`00000<01TI6@030000000c<c<0
<c<c00D0<c<c0P00000404a<C08000001@1VIVH2000000P0Ogmo1000000709VIV@@000001@1oOgl2
000000@0IVIV00D0000004a<C01<C4`0C4a<0000000403<c<`030000000I6AT06ATI00806ATI5`00
000301TI6@030000000c<c<0<c<c0080<c<c00D0000004a<C01<C4`0C4a<0000000406IVIP800000
1@1oOgl4000000L0VIVI1000000907moO`800000101VIVH2000000@0C4a<0P00000703<c<`030000
000I6AT06ATI00X06ATI7P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo7`00000=01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`00`1<
C4`2000000D0IVIV0P00000:07moO`L000001`1oOgl2000000@0IVIV0P00000304a<C0030000000c
<c<0<c<c0080<c<c00<0000001TI6@0I6AT00`0I6ATG000000@06ATI00<0000003<c<`0c<c<00P0c
<c<010000000C4a<04a<C01<C4`2000000@0IVIV0P00000707moO`L000002`1oOgl2000000@0IVIV
0P00000504a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATO000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolP000000d06ATI00<0
000003<c<`0c<c<01P0c<c<2000000D0C4a<0`00000406IVIP@000004@1oOgl3000000@0IVIV0P00
000404a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT00P0I6ATH000000@06ATI00<0
000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0800000101VIVH300000140Ogmo1@00
000406IVIP8000001@1<C4`2000000P0<c<c00<0000001TI6@0I6AT02`0I6ATO000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ000000d06ATI00<00000
03<c<`0c<c<01`0c<c<00`000000C4a<04a<C00504a<C08000001P1VIVHA000000D0IVIV0P000005
04a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT00`0I6ATH000000D06ATI00<00000
03<c<`0c<c<00`0c<c<00`000000C4a<04a<C00304a<C08000001@1VIVHA000000L0IVIV0P000006
04a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02`0I6ATP000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolR000000d06ATI00<0000003<c
<`0c<c<01`0c<c<00`000000C4a<04a<C00604a<C080000000<0IVIV0000001VIVH05P1VIVH00`00
0000C4a<04a<C00404a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT00`0I6ATI0000
00@06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV
01H0IVIV00@0000006IVIP00000000001`1<C4`00`000000<c<c03<c<`0703<c<`030000000I6AT0
6ATI00/06ATI8@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolS0000
00d06ATI0`00000703<c<`800000201<C4`4000000d0IVIV2000000504a<C08000001P0c<c<00`00
00006ATI01TI6@0401TI6AT000001@0I6AT00`000000<c<c03<c<`0403<c<`8000001@1<C4`80000
00d0IVIV1@00000704a<C08000001`0c<c<3000000d06ATI8P0000040?ooo`8000001`3oool001D0
oooo00<000000?ooo`3oool00P3ooolU000000h06ATI0P00000703<c<`@00000201<C4`=000000X0
C4a<0`00000603<c<`8000001P0I6ATJ000000H06ATI0P00000603<c<`<000002P1<C4`=000000P0
C4a<1000000703<c<`8000003P0I6ATT000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooolW000000h06ATI0P00000903<c<`@000005`1<C4`4000000P0<c<c
00<0000001TI6@0I6AT01@0I6ATL000000L06ATI00<0000003<c<`0c<c<01P0c<c<4000001P0C4a<
0`00000903<c<`8000003P0I6ATV000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooolY000000h06ATI0`00000:03<c<`X000001`1<C4`6000000X0<c<c0P00
000701TI6Ah000001`0I6AT2000000X0<c<c1P00000704a<C0/000002@0c<c<3000000h06ATI:000
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo:`00000?
01TI6@<000004@0c<c<7000000h0<c<c0P00000801TI6B000000200I6AT2000000h0<c<c1`00000A
03<c<`<000003`0I6ATZ000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3oool]000001006ATI0`00000O03<c<`@000002@0I6ATR000000T06ATI1000000O03<c
<`<00000400I6AT/000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooold000000`06ATI7`00000:01TI6BP000002P0I6ATO000000`06ATI<`0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=`00000_01TI6Bh00000
;`0I6ATf000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolk000002P06ATI=000000X01TI6CX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oood8000007@0I6ATl000001h06ATI@00000050?ooo`030000003oool0
oooo00D0oooo00070?ooo`@000000`3oool2000000D0oooo00<000000?ooo`3oool00P3ooom>0000
00L06ATID000000701TI6Dd000001@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000
oooo0?ooo`030?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3ooooi0000
00D0oooo00<000000?ooo`3oool01@3oool000P0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`0000040?ooo`<000000P3ooooi000000<0oooo0`0000070?ooo`002@3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
ooT000001@3oool00`000000oooo0?ooo`050?ooo`001`3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool000P0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
ooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool2000000<0oooon@0000040?ooo`8000001`3oool001D0oooo00<000000?oo
o`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooom9000001406ATIAP00000B01TI6DL000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oood8000007`0I6ATh000001l06ATI@@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo?000000Z01TI6Bh00000:P0I6ATk
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolf0000
01<06ATI4@00000401TI6@030000000I6AT06ATI00P06ATI:000000?01TI6A8000004P0I6ATe0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooola00000100
6ATI2000000A03<c<`D00000300I6ATT000000`06ATI1@00000B03<c<`L00000400I6AT`000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool^000000h06ATI
1@00000N03<c<`@000002@0I6ATR000000T06ATI1000000N03<c<`D000003P0I6AT]000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool[000000d06ATI1000
000=03<c<a4000002@0c<c<2000000P06ATI8000000801TI6@8000002@0c<c<B000000`0<c<c1000
000=01TI6BX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooobT000003@0I6AT2000000X0<c<c1`00000A04a<C0@000001`0c<c<2000000P06ATI70000008
01TI6@8000001`0c<c<400000180C4a<1P00000:03<c<`8000003@0I6ATX000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolW000000d06ATI0P00000803<c
<`@000003@1<C4`5000000X0C4a<0P00000703<c<`030000000I6AT06ATI00H06ATI6P00000801TI
6@030000000c<c<0<c<c00D0<c<c0P00000:04a<C0D000003@1<C4`4000000P0<c<c0P00000=01TI
6BH000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobD0
00003@0I6AT2000000P0<c<c0P00000;04a<C0H000001@1VIVH6000000H0C4a<0P00000603<c<`80
00001P0I6ATJ000000H06ATI0P00000603<c<`8000001P1<C4`6000000D0IVIV1`00000:04a<C080
0000200c<c<2000000d06ATI900000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`800000
0`3ooolS000000d06ATI0P00000803<c<`800000201<C4`500000140IVIV0`00000504a<C0<00000
1@0c<c<00`0000006ATI01TI6@0401TI6AT000001@0I6AT00`000000<c<c03<c<`0303<c<`<00000
1@1<C4`300000180IVIV1@00000704a<C0800000200c<c<2000000d06ATI8P0000040?ooo`800000
1`3oool001D0oooo00<000000?ooo`3oool00P3ooolR000000d06ATI00<0000003<c<`0c<c<01P0c
<c<2000000H0C4a<1000000;06IVIPD000002@1VIVH2000000H0C4a<00<0000003<c<`0c<c<00`0c
<c<00`0000006ATI01TI6@0301TI6AT00000100I6AT00`000000<c<c03<c<`0303<c<`030000001<
C4`0C4a<00@0C4a<0P00000906IVIPD00000301VIVH3000000H0C4a<0P00000803<c<`030000000I
6AT06ATI00/06ATI8@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooo8@00000<01TI6@8000001`0c<c<2000000H0C4a<0P00000906IVIPH000001@1oOgl5
000000H0IVIV0P00000504a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT00`0I6ATH
000000D06ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<C00304a<C08000001P1VIVH5
000000D0Ogmo1`00000806IVIP8000001P1<C4`2000000L0<c<c0P00000<01TI6B0000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob000000300I6AT00`00
0000<c<c03<c<`0603<c<`030000001<C4`0C4a<00@0C4a<0P00000606IVIPD00000401oOgl30000
00D0IVIV0P00000404a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT00P0I6ATH0000
00@06ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<C00204a<C08000001@1VIVH30000
0140Ogmo1000000606IVIP8000001P1<C4`00`000000<c<c03<c<`0603<c<`030000000I6AT06ATI
00X06ATI7`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo7`00000<01TI6@030000000c<c<0<c<c00D0<c<c0P00000504a<C08000001P1VIVH2000000H0
Ogmo3`00000307moO`8000001@1VIVH2000000<0C4a<00<0000003<c<`0c<c<00P0c<c<00`000000
6ATI01TI6@0201TI6AL000000`0I6AT00`000000<c<c03<c<`0203<c<`040000001<C4`0C4a<04a<
C08000001@1VIVH2000000<0Ogmo3`00000607moO`8000001P1VIVH2000000D0C4a<0P00000703<c
<`030000000I6AT06ATI00X06ATI7P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo7`00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<
C4`00`1<C4`2000000H0IVIV0P00000507moO`<000003`2IVIT300000080Ogmo0P00000506IVIP05
0000001<C4`0C4a<04a<C00000000`0c<c<00`0000006ATI01TI6@0201TI6AH00000100I6AT01@00
0000<c<c03<c<`0c<c<0000000<0C4a<00<0000006IVIP1VIVH00`1VIVH2000000<0Ogmo0P00000?
09VIV@@00000101oOgl2000000H0IVIV0P00000504a<C0030000000c<c<0<c<c00D0<c<c00<00000
01TI6@0I6AT02@0I6ATN000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolN000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<
C0030000001VIVH0IVIV00<0IVIV0`00000407moO`<00000202IVIT5000000P0VIVI0P00000207mo
O`800000101VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c00@0000001TI6@0I6AT06ATI5P00
000301TI6@050000000c<c<0<c<c03<c<`000000101<C4`010000000IVIV06IVIP1VIVH2000000<0
Ogmo0P00000709VIV@D000002@2IVIT2000000@0Ogmo0`00000506IVIP030000001<C4`0C4a<00<0
C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6Ad000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooad000002`0I6AT00`000000<c<c
03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo
07moO`0307moO`8000001P2IVIT5000000D0/k>c1000000509VIV@030000001oOgl0Ogmo0080Ogmo
00D0000006IVIP1VIVH0IVIV0000000304a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATF0000
00<06ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0050000001VIVH0IVIV06IVIP000000101o
Ogl00`000000VIVI09VIV@0309VIV@@000001@2c/k<5000000H0VIVI0P00000507moO`030000001V
IVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I
6AT06ATI00T06ATI700000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooo7@00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`0
0`000000IVIV06IVIP0206IVIP800000101oOgl2000000D0VIVI0`00000>0;>c/`800000102IVIT0
0`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IVIP0000000`1<C4`01@000000<c<c03<c
<`0c<c<0000000<06ATI5000000301TI6@050000000c<c<0<c<c03<c<`000000101<C4`010000000
IVIV06IVIP00000407moO`030000002IVIT0VIVI0080VIVI0P00000>0;>c/`@00000102IVIT20000
00@0Ogmo0P00000406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`00
00006ATI01TI6@0801TI6A`000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooa`000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0
C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`8000001@2IVIT2000000P0
/k>c1@0000060;>c/`030000002IVIT0VIVI0080VIVI00<0000007moO`1oOgl00P1oOgl010000000
IVIV06IVIP00000304a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATD000000<06ATI00D00000
03<c<`0c<c<0<c<c0000000304a<C0040000001VIVH0IVIV000000@0Ogmo00<0000009VIV@2IVIT0
0P2IVIT00`000000/k>c0;>c/`040;>c/`D000002@2c/k<2000000@0VIVI0P00000407moO`050000
001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T0
6ATI6`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
6`00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV
06IVIP1VIVH0000000@0Ogmo00<0000009VIV@2IVIT00`2IVIT2000000D0/k>c1@0000050<c<c0@0
00000`2c/k<2000000<0VIVI0P00000307moO`040000001VIVH0IVIV00000080C4a<00D0000003<c
<`0c<c<0<c<c0000000301TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<000000080C4a<00@0
000006IVIP1VIVH000000`1oOgl2000000<0VIVI0P0000030;>c/`@000001@3<c<`5000000H0/k>c
00<0000009VIV@2IVIT00`2IVIT00`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IVIP00
00001@1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI6P0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6`00000:01TI6@030000
000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000@0
Ogmo00<0000009VIV@2IVIT00P2IVIT2000000@0/k>c0`00000>0<c<c08000000`2c/k<00`000000
VIVI09VIV@0209VIV@040000001oOgl0Ogmo00000080IVIV00D0000004a<C01<C4`0C4a<00000003
03<c<`040000000I6AT06ATI01TI6A8000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<
00@0000006IVIP1VIVH000000P1oOgl00`000000VIVI09VIV@0209VIV@040000002c/k<0/k>c0;>c
/`8000003P3<c<`3000000@0/k>c0P00000409VIV@030000001oOgl0Ogmo0080Ogmo00D0000006IV
IP1VIVH0IVIV0000000504a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT0200I6ATJ
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oooaX000002`0I6AT00`00
0000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@00
0000Ogmo07moO`1oOgl0000000@0VIVI00<000000;>c/`2c/k<00P2c/k<2000000P0c<c<10000007
0<c<c08000000P2c/k<2000000<0VIVI00@0000007moO`1oOgl000000P1VIVH010000000C4a<04a<
C000000303<c<`040000000I6AT06ATI01TI6A8000000`0I6AT01@000000<c<c03<c<`0c<c<00000
0080C4a<00@0000006IVIP1VIVH000000P1oOgl010000000VIVI09VIV@2IVIT200000080/k>c0P00
00070<c<c0@00000203<c<`2000000@0/k>c00<0000009VIV@2IVIT00P2IVIT00`000000Ogmo07mo
O`0207moO`040000001VIVH0IVIV06IVIP800000101<C4`00`000000<c<c03<c<`0403<c<`030000
000I6AT06ATI00T06ATI6@0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3o
oolJ000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0050000001V
IVH0IVIV06IVIP0000000`1oOgl010000000VIVI09VIV@2IVIT2000000D0/k>c00<000000<c<c03<
c<`00`3<c<`4000000@0i^KV0`0000060<c<c0040000002c/k<0/k>c000000@0VIVI00<0000007mo
O`0000000`1VIVH00`000000C4a<0000000303<c<`040000000I6AT06ATI01TI6A8000000`0I6AT0
1`000000<c<c03<c<`0c<c<0000004a<C00000000`1VIVH00`000000Ogmo0000000409VIV@040000
002c/k<0/k>c000000H0c<c<0`0000040>KViP@000001P3<c<`00`000000/k>c0;>c/`020;>c/`80
00000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI6@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo6P00000:01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07mo
O`0000000`2IVIT00`000000/k>c0;>c/`030;>c/`030000003<c<`0c<c<00<0c<c<00<000000>KV
iP3Vi^H02@3Vi^H2000000D0c<c<00@000000;>c/`2c/k<000000`2IVIT010000000Ogmo07moO`00
000206IVIP040000001<C4`0C4a<00000080<c<c00@0000001TI6@0I6AT06ATI4P00000301TI6@04
0000000c<c<0<c<c00000080C4a<00@0000006IVIP1VIVH000000P1oOgl01@000000VIVI09VIV@2I
VIT000000080/k>c00<000000<c<c03<c<`00`3<c<`2000000/0i^KV00<000000<c<c03<c<`0103<
c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@000000101oOgl00`000000IVIV
06IVIP0206IVIP050000001<C4`0C4a<04a<C00000001`0c<c<00`0000006ATI01TI6@0801TI6AT0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaX00000
2P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0
IVIV0000000307moO`050000002IVIT0VIVI09VIV@0000001@2c/k<00`000000c<c<0<c<c0030<c<
c0030000003Vi^H0i^KV00`0i^KV00<000000<c<c03<c<`00P3<c<`010000000/k>c0;>c/`000003
09VIV@040000001oOgl0Ogmo00000080IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI
01TI6@0I6ATB000000<06ATI00@0000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP000002
07moO`050000002IVIT0VIVI09VIV@0000000P2c/k<00`000000c<c<0<c<c0020<c<c0030000003V
i^H0i^KV00`0i^KV00<000000<c<c03<c<`00`3<c<`00`000000/k>c0;>c/`030;>c/`050000002I
VIT0VIVI09VIV@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002`0I6AT00`000000<c<c03<c
<`0303<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07mo
O`1oOgl0000000<0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0030<c<c0030000
003Vi^H0i^KV00H0i^KV00<000000>KViP3Vi^H01@3Vi^H00`000000c<c<0<c<c0020<c<c0040000
002c/k<0/k>c00000080VIVI00@0000007moO`1oOgl000000P1VIVH010000000C4a<04a<C0000002
03<c<`030000000I6AT06ATI00806ATI4000000401TI6@060000000c<c<0<c<c0000001<C4`00000
0`1VIVH00`000000Ogmo0000000309VIV@040000002c/k<0/k>c000000@0c<c<00<000000>KViP3V
i^H01@3Vi^H00`000000i^KV0>KViP060>KViP800000103<c<`00`000000/k>c0;>c/`020;>c/`05
0000002IVIT0VIVI09VIV@000000101oOgl01@000000IVIV06IVIP1VIVH0000000@0C4a<00<00000
03<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AT000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002`0I6AT00`000000<c<c03<c<`0303<c
<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`030000002IVIT0
VIVI0080VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0
i^KV00D0i^KV0P0000000`3oool000000>KViP060>KViP050000003<c<`0c<c<0<c<c00000000P2c
/k<01`000000VIVI09VIV@2IVIT0000007moO`0000000`1VIVH00`000000C4a<0000000203<c<`03
0000000I6AT06ATI00806ATI4000000401TI6@060000000c<c<0<c<c0000001<C4`000000`1VIVH0
0`000000Ogmo0000000309VIV@040000002c/k<0/k>c000000<0c<c<00<000000>KViP3Vi^H01@3V
i^H010000000oooo0000000000080>KViP030000003<c<`0c<c<0080c<c<00D000000;>c/`2c/k<0
/k>c0000000409VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C00304a<
C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT02@0I6ATH000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolI000000X06ATI00<0000003<c<`0c
<c<00`0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1o
Ogl0Ogmo0000000309VIV@030000002c/k<0/k>c0080/k>c00<000000<c<c03<c<`00P3<c<`00`00
0000i^KV0>KViP040>KViP800000103oool2000000H0i^KV00D000000<c<c03<c<`0c<c<00000002
0;>c/`040000002IVIT0VIVI00000080Ogmo00@0000006IVIP1VIVH000000P1<C4`00`000000<c<c
0000000401TI6A000000100I6AT00`000000<c<c0000000204a<C0040000001VIVH0IVIV00000080
Ogmo00@0000009VIV@2IVIT000000P2c/k<01@000000c<c<0<c<c03<c<`0000000H0i^KV0P000004
0?ooo`8000001`3Vi^H01@000000c<c<0<c<c03<c<`0000000@0/k>c00D0000009VIV@2IVIT0VIVI
0000000407moO`050000001VIVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`03
0000000I6AT06ATI00P06ATI600000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo6@00000:01TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`0
0`1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00D0000009VIV@2IVIT0VIVI000000030;>c
/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H00`3Vi^H2000000P0oooo00<000000>KV
iP3Vi^H0103Vi^H010000000c<c<0<c<c00000020;>c/`040000002IVIT0VIVI00000080Ogmo00@0
000006IVIP1VIVH000000P1<C4`00`000000<c<c0000000401TI6A000000100I6AT00`000000<c<c
0000000204a<C0040000001VIVH0IVIV00000080Ogmo00@0000009VIV@2IVIT000000P2c/k<01000
0000c<c<0<c<c00000060>KViP030000003oool0oooo00H0oooo0P0000060>KViP050000003<c<`0
c<c<0<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT0000000@0Ogmo00D0000006IVIP1VIVH0
IVIV0000000504a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0200I6ATH000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolI000000X06ATI
00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP00
0000101oOgl01@000000VIVI09VIV@2IVIT0000000<0/k>c00<000000<c<c03<c<`00P3<c<`00`00
0000i^KV0>KViP020>KViP030000003oool0oooo00T0oooo0P0000040>KViP040000003<c<`0c<c<
00000080/k>c00@0000009VIV@2IVIT000000P1oOgl010000000IVIV06IVIP00000204a<C0030000
000c<c<0000000@06ATI4000000401TI6@030000000c<c<000000080C4a<00@0000006IVIP1VIVH0
00000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<000000@0i^KV0P00000;
0?ooo`030000003Vi^H0i^KV00<0i^KV00D000000<c<c03<c<`0c<c<000000030;>c/`050000002I
VIT0VIVI09VIV@000000101oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c
<c<00`0c<c<00`0000006ATI01TI6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c<`0303<c<`030000
001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`040000002IVIT0VIVI0000
00<0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP030>KViP030000003oool0oooo
00X0oooo00<000000>KViP3Vi^H00P3Vi^H01`000000c<c<0<c<c03<c<`000000;>c/`0000000P2I
VIT010000000Ogmo07moO`00000206IVIP060000001<C4`0C4a<0000000c<c<00000100I6AT@0000
00@06ATI00<0000003<c<`0000000P1<C4`010000000IVIV06IVIP00000207moO`040000002IVIT0
VIVI00000080/k>c00@000000<c<c03<c<`00000103Vi^H00`000000oooo0?ooo`0:0?ooo`030000
003Vi^H0i^KV00@0i^KV00D000000<c<c03<c<`0c<c<000000030;>c/`050000002IVIT0VIVI09VI
V@0000000`1oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<00`0c<c<0
0`0000006ATI01TI6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?oooaP000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<
0080C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`050000002IVIT0VIVI09VIV@0000000`2c
/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV0080i^KV00<000000?ooo`3oool0303o
ool01@000000i^KV0>KViP3Vi^H0000000<0c<c<00<000000;>c/`0000000P2IVIT010000000Ogmo
07moO`00000206IVIP060000001<C4`0C4a<0000000c<c<00000100I6AT@000000<06ATI00@00000
03<c<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`040000002IVIT0VIVI00000080/k>c
00@000000<c<c03<c<`00000103Vi^H00`000000oooo0?ooo`0<0?ooo`030000003Vi^H0i^KV00<0
i^KV00D000000<c<c03<c<`0c<c<000000030;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl0
1@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI
6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?oooaP000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00D00000
06IVIP1VIVH0IVIV0000000407moO`050000002IVIT0VIVI09VIV@0000000`2c/k<00`000000c<c<
0<c<c0020<c<c0050000003Vi^H0i^KV0>KViP0000003`3oool00`000000i^KV0>KViP020>KViP04
0000003<c<`0c<c<00000080/k>c00@0000009VIV@2IVIT000000P1oOgl00`000000IVIV00000002
04a<C0040000000c<c<0<c<c000000<06ATI4000000301TI6@040000000c<c<0<c<c00000080C4a<
00<0000006IVIP0000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<0000
00@0i^KV00<000000?ooo`3oool03@3oool00`000000i^KV0>KViP020>KViP050000003<c<`0c<c<
0<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT0000000@0Ogmo00D0000006IVIP1VIVH0IVIV
0000000404a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATG000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolH000000X06ATI00<0
000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP000000
101oOgl010000000VIVI09VIV@0000030;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3V
i^H00P3Vi^H00`000000oooo0?ooo`0>0?ooo`050000003Vi^H0i^KV0>KViP0000000`3<c<`00`00
0000/k>c0000000209VIV@060000001oOgl0Ogmo0000001VIVH000000P1<C4`010000000<c<c03<c
<`00000301TI6A0000000`0I6AT010000000<c<c03<c<`00000204a<C0030000001VIVH000000080
Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<0<c<c00000030>KViP030000003oool0
oooo00h0oooo00<000000>KViP3Vi^H00`3Vi^H01@000000c<c<0<c<c03<c<`0000000<0/k>c00D0
000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0IVIV06IVIP000000101<C4`00`000000
<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`8000000`3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<
04a<C00204a<C0050000001VIVH0IVIV06IVIP000000101oOgl010000000VIVI09VIV@0000030;>c
/`030000003<c<`0c<c<0080c<c<00D000000>KViP3Vi^H0i^KV0000000A0?ooo`050000003Vi^H0
i^KV0>KViP0000000`3<c<`00`000000/k>c0000000209VIV@060000001oOgl0Ogmo0000001VIVH0
00000P1<C4`010000000<c<c03<c<`00000301TI6A0000000`0I6AT010000000<c<c03<c<`000002
04a<C0030000001VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<0<c<
c00000030>KViP030000003oool0oooo00l0oooo00<000000>KViP3Vi^H00P3Vi^H01@000000c<c<
0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0IVIV
06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`000004
0?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooolH000000X06ATI00<0000003<c
<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP000000101oOgl0
10000000VIVI09VIV@0000030;>c/`030000003<c<`0c<c<0080c<c<00D000000>KViP3Vi^H0i^KV
0000000A0?ooo`050000003Vi^H0i^KV0>KViP0000000`3<c<`00`000000/k>c0000000209VIV@06
0000001oOgl0Ogmo0000001VIVH000000P1<C4`010000000<c<c03<c<`00000301TI6A0000000`0I
6AT010000000<c<c03<c<`00000204a<C0030000001VIVH000000080Ogmo00@0000009VIV@2IVIT0
00000P2c/k<010000000c<c<0<c<c00000030>KViP030000003oool0oooo00h0oooo00<000000>KV
iP3Vi^H00`3Vi^H01@000000c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000
000307moO`050000001VIVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000
000I6AT06ATI00P06ATI5`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo6000000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<
C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00@0000009VIV@2IVIT000000`2c/k<00`000000
c<c<0<c<c0020<c<c0030000003Vi^H0i^KV0080i^KV00<000000?ooo`3oool03@3oool00`000000
i^KV0>KViP020>KViP070000003<c<`0c<c<0<c<c0000000/k>c0000000209VIV@060000001oOgl0
Ogmo0000001VIVH000000P1<C4`010000000<c<c03<c<`00000301TI6A0000000`0I6AT010000000
<c<c03<c<`00000204a<C0030000001VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<0
10000000c<c<0<c<c00000040>KViP030000003oool0oooo00d0oooo00<000000>KViP3Vi^H00P3V
i^H00`000000c<c<0<c<c0020<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT01@000000Ogmo
07moO`1oOgl0000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`03
0000000I6AT06ATI00P06ATI5`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo6000000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`0
0P1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00@0000009VIV@2IVIT000000`2c/k<00`00
0000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV0080i^KV00<000000?ooo`3oool03@3oool00`00
0000i^KV0>KViP020>KViP040000003<c<`0c<c<00000080/k>c00H0000009VIV@2IVIT0000007mo
O`00000206IVIP040000001<C4`0C4a<00000080<c<c00@0000001TI6@0I6AT06ATI4000000301TI
6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl010000000VIVI09VIV@00
00020;>c/`040000003<c<`0c<c<000000@0i^KV00<000000?ooo`3oool0303oool00`000000i^KV
0>KViP030>KViP050000003<c<`0c<c<0<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT00000
00<0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl01@000000VIVI09VIV@2IVIT0
000000<0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP020>KViP030000003oool0
oooo00/0oooo00<000000>KViP3Vi^H00`3Vi^H010000000c<c<0<c<c00000020;>c/`060000002I
VIT0VIVI0000001oOgl000000P1VIVH010000000C4a<04a<C000000203<c<`040000000I6AT06ATI
01TI6A000000100I6AT00`000000<c<c0000000204a<C0040000001VIVH0IVIV00000080Ogmo00<0
000009VIV@0000000P2c/k<010000000c<c<0<c<c00000050>KViP030000003oool0oooo00/0oooo
00<000000>KViP3Vi^H00`3Vi^H01@000000c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2I
VIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000000:01TI6@030000000c<c<0<c<c00@0
<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VI
V@2IVIT0VIVI000000030;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H00P3Vi^H0
0`000000oooo0?ooo`0;0?ooo`030000003Vi^H0i^KV00<0i^KV00@000000<c<c03<c<`000000P2c
/k<01P000000VIVI09VIV@000000Ogmo00000080IVIV00@0000004a<C01<C4`000000P0c<c<01000
00006ATI01TI6@0I6AT@000000@06ATI00<0000003<c<`0000000P1<C4`010000000IVIV06IVIP00
000207moO`030000002IVIT000000080/k>c00@000000<c<c03<c<`000001@3Vi^H00`000000oooo
0?ooo`0:0?ooo`030000003Vi^H0i^KV00<0i^KV00<000000<c<c03<c<`00P3<c<`01@000000/k>c
0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<
0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AL000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaP000002P0I6AT00`000000
<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000307mo
O`050000002IVIT0VIVI09VIV@0000000`2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0
i^KV00<0i^KV00<000000?ooo`3oool02P3oool00`000000i^KV0>KViP030>KViP040000003<c<`0
c<c<00000080/k>c00H0000009VIV@2IVIT0000007moO`00000206IVIP040000001<C4`0C4a<0000
0080<c<c00@0000001TI6@0I6AT06ATI4000000401TI6@030000000c<c<000000080C4a<00@00000
06IVIP1VIVH000000P1oOgl00`000000VIVI000000020;>c/`040000003<c<`0c<c<000000D0i^KV
00<000000?ooo`3oool02P3oool00`000000i^KV0>KViP030>KViP030000003<c<`0c<c<0080c<c<
00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`00
0000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATG0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolH000000X0
6ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0IVIV06IV
IP0000000`1oOgl01@000000VIVI09VIV@2IVIT0000000@0/k>c00<000000<c<c03<c<`00P3<c<`0
0`000000i^KV0>KViP030>KViP030000003oool0oooo00L0oooo0P0000050>KViP040000003<c<`0
c<c<000000<0/k>c00H0000009VIV@2IVIT0000007moO`00000206IVIP040000001<C4`0C4a<0000
0080<c<c00@0000001TI6@0I6AT06ATI4000000401TI6@030000000c<c<000000080C4a<00@00000
06IVIP1VIVH000000P1oOgl00`000000VIVI000000020;>c/`050000003<c<`0c<c<0<c<c0000000
1@3Vi^H2000000T0oooo00<000000>KViP3Vi^H0103Vi^H01@000000c<c<0<c<c03<c<`0000000<0
/k>c00<0000009VIV@2IVIT00P2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<
C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6@00000:01TI6@03
0000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP04
0000001oOgl0Ogmo000000@0VIVI00D000000;>c/`2c/k<0/k>c000000050<c<c0030000003Vi^H0
i^KV00<0i^KV0P0000060?ooo`030000003Vi^H0i^KV00@0i^KV00D000000<c<c03<c<`0c<c<0000
00020;>c/`040000002IVIT0VIVI00000080Ogmo00@0000006IVIP1VIVH000000P1<C4`010000000
<c<c03<c<`00000301TI6A000000100I6AT00`000000<c<c0000000204a<C0040000001VIVH0IVIV
00000080Ogmo00@0000009VIV@2IVIT000000P2c/k<01@000000c<c<0<c<c03<c<`0000000H0i^KV
00<000000?ooo`3oool0103oool2000000H0i^KV00<000000<c<c03<c<`00P3<c<`01@000000/k>c
0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<
0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AP000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002P0I6AT00`000000
<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000
Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0030<c<
c0030000003Vi^H0i^KV00@0i^KV0P0000020?ooo`8000001P3Vi^H01@000000c<c<0<c<c03<c<`0
000000<0/k>c00H0000009VIV@2IVIT0000007moO`00000206IVIP040000001<C4`0C4a<00000080
<c<c00@0000001TI6@0I6AT06ATI4@00000401TI6@030000000c<c<000000080C4a<00@0000006IV
IP1VIVH000000P1oOgl010000000VIVI09VIV@0000020;>c/`030000003<c<`0c<c<0080c<c<00<0
00000>KViP3Vi^H0103Vi^H200000080oooo0P0000070>KViP030000003<c<`0c<c<0080c<c<00D0
00000;>c/`2c/k<0/k>c0000000409VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000
C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATH000000D0
oooo00<000000?ooo`3oool01@3oool000P0oooo0P0000040?ooo`8000001@3oool00`000000oooo
0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<
00D0000006IVIP1VIVH0IVIV0000000307moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c
/k<00P2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV00H0i^KV0P0000070>KViP03
0000003<c<`0c<c<0080c<c<00D000000;>c/`2c/k<0/k>c0000000209VIV@030000001oOgl00000
0080IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00@0
000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP00000207moO`040000002IVIT0VIVI0000
0080/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP050>KViP800000203Vi^H00`00
0000c<c<0<c<c0020<c<c0030000002c/k<0/k>c0080/k>c00<0000009VIV@2IVIT00P2IVIT01@00
0000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`04
03<c<`030000000I6AT06ATI00P06ATI600000050?ooo`030000003oool0oooo00D0oooo00070?oo
o`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000103oool00`000000oooo0?oo
o`020?oooaX000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0
000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c/`2c/k<0
0P2c/k<00`000000c<c<0<c<c0030<c<c0030000003Vi^H0i^KV00d0i^KV00<000000<c<c03<c<`0
0P3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00@0000007moO`1oOgl000000P1VIVH01000
0000C4a<04a<C000000203<c<`040000000I6AT06ATI01TI6A8000000`0I6AT010000000<c<c03<c
<`00000204a<C0040000001VIVH0IVIV00000080Ogmo00@0000009VIV@2IVIT000000P2c/k<00`00
0000c<c<0<c<c0030<c<c0030000003Vi^H0i^KV00d0i^KV00<000000<c<c03<c<`00`3<c<`01@00
0000/k>c0;>c/`2c/k<0000000@0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<
C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AT000001@3o
ool00`000000oooo0?ooo`050?ooo`002@3oool01@000000oooo0?ooo`3oool000000080oooo00<0
00000?ooo`3oool00P3oool300000080oooo6P00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0
000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00D0
000009VIV@2IVIT0VIVI000000040;>c/`030000003<c<`0c<c<00<0c<c<00<000000>KViP3Vi^H0
2P3Vi^H2000000D0c<c<00D000000;>c/`2c/k<0/k>c0000000209VIV@040000001oOgl0Ogmo0000
0080IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00@0
000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP00000207moO`050000002IVIT0VIVI09VI
V@0000000P2c/k<00`000000c<c<0<c<c0030<c<c0800000303Vi^H00`000000c<c<0<c<c0030<c<
c0030000002c/k<0/k>c0080/k>c00D0000009VIV@2IVIT0VIVI0000000407moO`030000001VIVH0
IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT0
6ATI00P06ATI6@0000030?ooo`<000001`3oool000X0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo6P00000:01TI6@030000000c<c<0
<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0
Ogmo0080Ogmo00D0000009VIV@2IVIT0VIVI000000040;>c/`030000003<c<`0c<c<00<0c<c<1000
00050>KViP<000001P3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00@0000007moO`1oOgl0
00000`1VIVH010000000C4a<04a<C000000203<c<`040000000I6AT06ATI01TI6A8000000`0I6AT0
10000000<c<c03<c<`00000204a<C0040000001VIVH0IVIV000000<0Ogmo00D0000009VIV@2IVIT0
VIVI000000020;>c/`030000003<c<`0c<c<00@0c<c<0`0000050>KViP@000001@3<c<`00`000000
/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@000000101oOgl00`000000IVIV06IVIP0206IV
IP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI
6AT000001@3oool00`000000oooo0?ooo`050?ooo`001`3oool010000000oooo0?ooo`0000020?oo
o`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3ooolJ000000X06ATI00<00000
03<c<`0c<c<01@0c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00<00000
07moO`1oOgl00P1oOgl00`000000VIVI09VIV@0209VIV@030000002c/k<0/k>c0080/k>c00<00000
0<c<c03<c<`01P3<c<`5000000P0c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@040000001o
Ogl0Ogmo00000080IVIV00@0000004a<C01<C4`000000`0c<c<0100000006ATI01TI6@0I6ATB0000
00<06ATI00D0000003<c<`0c<c<0<c<c0000000204a<C0040000001VIVH0IVIV00000080Ogmo00D0
000009VIV@2IVIT0VIVI000000030;>c/`030000003<c<`0c<c<00H0c<c<1@0000080<c<c0800000
0`2c/k<00`000000VIVI09VIV@0209VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH0
0P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0
2@0I6ATI000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo0P0000040?ooo`8000001@3o
ool00`000000oooo0?ooo`020?oooaX000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<
C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002I
VIT0VIVI0080VIVI0P0000030;>c/`8000004@3<c<`2000000@0/k>c00@0000009VIV@2IVIT00000
0P1oOgl01@000000IVIV06IVIP1VIVH000000080C4a<00D0000003<c<`0c<c<0<c<c0000000201TI
6A<000000`0I6AT01@000000<c<c03<c<`0c<c<000000080C4a<00@0000006IVIP1VIVH000000`1o
Ogl01@000000VIVI09VIV@2IVIT0000000<0/k>c0P00000A0<c<c0800000102c/k<00`000000VIVI
09VIV@0209VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<
04a<C00204a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT0200I6ATJ000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolK000000X06ATI00<0
000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP000000
1@1oOgl00`000000VIVI09VIV@0309VIV@030000002c/k<0/k>c0080/k>c0P00000>0<c<c0030000
002c/k<0/k>c00<0/k>c00@0000009VIV@2IVIT000000`1oOgl01@000000IVIV06IVIP1VIVH00000
0080C4a<00D0000003<c<`0c<c<0<c<c0000000201TI6A@000000P0I6AT01@000000<c<c03<c<`0c
<c<000000080C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`040000002IVIT0VIVI000000D0
/k>c00<000000<c<c03<c<`0303<c<`2000000D0/k>c00<0000009VIV@2IVIT00P2IVIT00`000000
Ogmo07moO`0307moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0503<c
<`030000000I6AT06ATI00P06ATI6P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo6`00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<
C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2I
VIT0102IVIT00`000000/k>c0;>c/`030;>c/`@000001`3<c<`3000000D0/k>c00D0000009VIV@2I
VIT0VIVI0000000207moO`050000001VIVH0IVIV06IVIP0000000P1<C4`01@000000<c<c03<c<`0c
<c<0000000<06ATI5000000301TI6@050000000c<c<0<c<c03<c<`0000000P1<C4`010000000IVIV
06IVIP00000307moO`050000002IVIT0VIVI09VIV@0000001@2c/k<3000000L0c<c<100000060;>c
/`030000002IVIT0VIVI00<0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IV
IP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI
6A/000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa`0
00002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1V
IVH00P1VIVH00`000000Ogmo07moO`0207moO`8000001@2IVIT00`000000/k>c0;>c/`060;>c/`L0
00001`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00D0000006IVIP1VIVH0IVIV00000002
04a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATD000000<06ATI00D0000003<c<`0c<c<0<c<c
0000000204a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl01@000000VIVI09VIV@2IVIT00000
00L0/k>c1`0000080;>c/`800000102IVIT2000000@0Ogmo00<0000006IVIP1VIVH00P1VIVH00`00
0000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT0200I6ATK0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolL000000/0
6ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080
IVIV00<0000007moO`1oOgl00`1oOgl00`000000VIVI09VIV@0309VIV@8000004P2c/k<2000000<0
VIVI00<0000007moO`1oOgl00P1oOgl010000000IVIV06IVIP00000304a<C0050000000c<c<0<c<c
03<c<`0000000`0I6ATD000000<06ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0040000001V
IVH0IVIV000000@0Ogmo00@0000009VIV@2IVIT0VIVI0P00000B0;>c/`8000001@2IVIT00`000000
Ogmo07moO`0307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000
<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI6`0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo7@00000:01TI6@030000000c<c<0<c<c00D0<c<c
00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00<0Ogmo
00<0000009VIV@2IVIT0102IVIT2000000h0/k>c0P00000409VIV@030000001oOgl0Ogmo0080Ogmo
00D0000006IVIP1VIVH0IVIV0000000204a<C0050000000c<c<0<c<c03<c<`000000100I6ATD0000
00@06ATI00@0000003<c<`0c<c<000000`1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00<0
000009VIV@2IVIT00P2IVIT2000000h0/k>c0P00000609VIV@030000001oOgl0Ogmo00<0Ogmo00<0
000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0
000001TI6@0I6AT0200I6ATL000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolM000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C003
04a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00`1oOgl2000000H0VIVI10000007
0;>c/`<000001@2IVIT00`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IVIP0000000`1<
C4`01@000000<c<c03<c<`0c<c<0000000@06ATI5000000401TI6@050000000c<c<0<c<c03<c<`00
00000`1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00<0000009VIV@2IVIT00`2IVIT30000
00L0/k>c1000000709VIV@030000001oOgl0Ogmo00<0Ogmo00<0000006IVIP1VIVH00`1VIVH00`00
0000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATL0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolN000000X0
6ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00<0
IVIV00<0000007moO`1oOgl0101oOgl00`000000VIVI09VIV@0709VIV@L000001`2IVIT00`000000
Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00D0000004a<C01<C4`0C4a<0000000303<c
<`040000000I6AT06ATI01TI6AH000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00D0
000006IVIP1VIVH0IVIV0000000507moO`030000002IVIT0VIVI00D0VIVI1`00000:09VIV@030000
001oOgl0Ogmo00<0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00304a<C0030000
000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT0200I6ATM000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooolN000000/06ATI00<0000003<c<`0c<c<01@0c
<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00@0IVIV00<0000007moO`1oOgl0101o
Ogl00`000000VIVI09VIV@0C09VIV@030000001oOgl0Ogmo00<0Ogmo00D0000006IVIP1VIVH0IVIV
0000000404a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATF000000<06ATI00D0000003<c<`0c
<c<0<c<c0000000404a<C0050000001VIVH0IVIV06IVIP0000001@1oOgl00`000000VIVI09VIV@0D
09VIV@030000001oOgl0Ogmo00<0Ogmo00<0000006IVIP1VIVH0101VIVH00`000000C4a<04a<C003
04a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATM000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolO000000X06ATI00<0000003<c
<`0c<c<01P0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00@0IVIV00<0000007mo
O`1oOgl0101oOgl00`000000VIVI09VIV@0A09VIV@030000001oOgl0Ogmo00<0Ogmo00<0000006IV
IP1VIVH00P1VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c00<0000001TI6@0I6AT00P0I6ATF
000000@06ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV0080IVIV00<0
000007moO`1oOgl00`1oOgl00`000000VIVI09VIV@0A09VIV@8000001@1oOgl00`000000IVIV06IV
IP0406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI
6@0801TI6Ah000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo7`00000;
01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP04
06IVIP8000001@1oOgl7000000L0VIVI1@00000507moO`030000001VIVH0IVIV0080IVIV00<00000
04a<C01<C4`00P1<C4`01@000000<c<c03<c<`0c<c<0000000@06ATI5P00000401TI6@050000000c
<c<0<c<c03<c<`000000101<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo00<0Ogmo
1@00000709VIV@L000001P1oOgl00`000000IVIV06IVIP0406IVIP030000001<C4`0C4a<00@0C4a<
00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6Ah00000103oool2000000L0oooo
000E0?ooo`030000003oool0oooo0080oooo7`00000<01TI6@030000000c<c<0<c<c00D0<c<c00<0
000004a<C01<C4`0101<C4`00`000000IVIV06IVIP0506IVIP8000002P1oOgl7000000P0Ogmo0P00
000506IVIP050000001<C4`0C4a<04a<C0000000100c<c<00`0000006ATI01TI6@0201TI6AH00000
100I6AT00`000000<c<c03<c<`0203<c<`050000001<C4`0C4a<04a<C00000001@1VIVH2000000P0
Ogmo1`00000;07moO`8000001P1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00D0
<c<c00<0000001TI6@0I6AT02@0I6ATO000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooolP000000`06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<
04a<C00404a<C08000001`1VIVH2000001D0Ogmo0P00000606IVIP030000001<C4`0C4a<0080C4a<
00D0000003<c<`0c<c<0<c<c0000000501TI6AH000001@0I6AT01@000000<c<c03<c<`0c<c<00000
00@0C4a<00<0000006IVIP1VIVH0101VIVH2000001D0Ogmo0`00000606IVIP8000001P1<C4`00`00
0000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI7`0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo8000000=01TI6@030000000c<c<0<c<c00D0
<c<c00<0000004a<C01<C4`01@1<C4`00`000000IVIV06IVIP0606IVIP8000004@1oOgl2000000L0
IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0203<c<`030000000I6AT06ATI0080
6ATI5`00000501TI6@030000000c<c<0<c<c0080<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0506IVIP8000004@1oOgl2000000P0IVIV00<0000004a<C01<C4`01@1<C4`00`000000
<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI800000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo8@00000<01TI6@030000000c<c<0<c<c00H0<c<c
00<0000004a<C01<C4`01@1<C4`00`000000IVIV06IVIP0706IVIP8000002`1oOgl4000000L0IVIV
0P00000404a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT00P0I6ATH000000@06ATI
00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C08000001`1VIVH4000000/0Ogmo
0P00000906IVIP030000001<C4`0C4a<00D0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI
01TI6@0;01TI6B0000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooob4000003@0I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00D0C4a<0P00
000906IVIP/000002P1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c0080<c<c00<0
000001TI6@0I6AT00`0I6ATH000000D06ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<
C00404a<C0030000001VIVH0IVIV00P0IVIV2`00000906IVIP8000001`1<C4`00`000000<c<c03<c
<`0603<c<`030000000I6AT06ATI00X06ATI8@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo8P00000=01TI6@030000000c<c<0<c<c00H0<c<c00<00000
04a<C01<C4`01P1<C4`3000001T0IVIV0P00000604a<C0030000000c<c<0<c<c00<0<c<c00<00000
01TI6@0I6AT00`0I6ATH000000D06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C004
04a<C08000006P1VIVH2000000P0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0;
01TI6B4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ob<000003@0I6AT00`000000<c<c03<c<`0603<c<`8000002@1<C4`3000001@0IVIV0P00000704a<
C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0100I6ATH000000H06ATI00<0000003<c
<`0c<c<00`0c<c<00`000000C4a<04a<C00504a<C08000005@1VIVH3000000P0C4a<0P00000803<c
<`030000000I6AT06ATI00/06ATI8P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo9000000=01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<
C4`02@1<C4`3000000l0IVIV0P00000704a<C08000001@0c<c<00`0000006ATI01TI6@0401TI6AT0
00001`0I6AT00`000000<c<c03<c<`0303<c<`8000001`1<C4`2000000l0IVIV1000000:04a<C003
0000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02`0I6ATS000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolT000000h06ATI00<0000003<c<`0c<c<0
1`0c<c<2000000`0C4a<1000000706IVIP@00000201<C4`00`000000<c<c03<c<`0503<c<`030000
000I6AT06ATI00@06ATI6P00000701TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`0
1P1<C4`4000000L0IVIV1000000<04a<C08000002@0c<c<00`0000006ATI01TI6@0<01TI6B<00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobD000003P0I
6AT00`000000<c<c03<c<`0803<c<`8000003P1<C4`7000000/0C4a<00<0000003<c<`0c<c<01@0c
<c<00`0000006ATI01TI6@0501TI6AX000001`0I6AT00`000000<c<c03<c<`0503<c<`030000001<
C4`0C4a<00T0C4a<1`00000>04a<C08000002P0c<c<00`0000006ATI01TI6@0<01TI6B@000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobH000003P0I6AT2
000000X0<c<c0P00000L04a<C0800000200c<c<00`0000006ATI01TI6@0401TI6A/00000200I6AT0
0`000000<c<c03<c<`0503<c<`800000701<C4`2000000X0<c<c0P00000>01TI6BD000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo9`00000?01TI6@030000000c<c<0<c<c
00T0<c<c0P00000H04a<C08000002@0c<c<00`0000006ATI01TI6@0501TI6A`00000200I6AT00`00
0000<c<c03<c<`0603<c<`800000601<C4`2000000/0<c<c00<0000001TI6@0I6AT03@0I6ATV0000
00@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooobP000003`0I6AT00`000000
<c<c03<c<`0:03<c<`<000004P1<C4`3000000X0<c<c00<0000001TI6@0I6AT01@0I6ATM000000T0
6ATI00<0000003<c<`0c<c<01`0c<c<3000001<0C4a<0P00000<03<c<`030000000I6AT06ATI00d0
6ATI9`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
:@00000?01TI6@030000000c<c<0<c<c00`0<c<c0`00000;04a<C0@00000300c<c<00`0000006ATI
01TI6@0601TI6Ah00000200I6AT00`000000<c<c03<c<`0:03<c<`@000002`1<C4`4000000d0<c<c
00<0000001TI6@0I6AT03@0I6ATX000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3oool[000000h06ATI0P00000?03<c<`/000003`0c<c<00`0000006ATI01TI
6@0601TI6Al000002@0I6AT00`000000<c<c03<c<`0=03<c<`/000003`0c<c<2000000h06ATI:P00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;000000?
01TI6@8000009@0c<c<2000000T06ATI8000000901TI6@8000009@0c<c<2000000l06ATI:`000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;@00000@01TI
6@8000008@0c<c<2000000X06ATI8@00000;01TI6@8000008@0c<c<2000001006ATI;00000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;P00000A01TI6@<0
00007@0c<c<00`0000006ATI01TI6@0:01TI6B800000300I6AT00`000000<c<c03<c<`0L03<c<`80
00004@0I6AT]000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3oool_000001<06ATI0P00000H03<c<`<00000300I6ATT000000`06ATI0`00000I03<c<`800000
4P0I6AT^000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oola000001<06ATI1000000A03<c<`<000003`0I6ATT000000l06ATI0`00000A03<c<`D000004P0I
6AT`000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolb
000001H06ATI1P00000703<c<`@000004@0I6ATV000001406ATI1000000703<c<`H000005P0I6ATa
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolc0000
01/06ATI1`00000D01TI6BP00000500I6AT7000001/06ATI<P0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo=000000d01TI6BT00000=@0I6ATc000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooole000003<06ATI
:P00000c01TI6C@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo=`00
000`01TI6B`00000<00I6ATf000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`02
0?ooocT00000;00I6AT`000002`06ATI>00000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo>`00000X01TI6C@00000:00I6ATj000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolm000002@06ATI>000000T01TI6C`0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oood000000
7`0I6ATl000001l06ATI?`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo@P00000K01TI6D0000006`0I6AU1000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooom8000001<06ATIA000000C01TI6DL000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodh000001`0I6AU@0000
00L06ATIC@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
n@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooooi000000@0oooo0P0000070?oo
o`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`002@3oool300000080oooo0P0000050?oo
o`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000:0?ooo`04
0000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oo
ooT000001@3oool00`000000oooo0?ooo`050?ooo`001`3oool5000000050?ooo`000000oooo0?oo
o`000000103oool300000080oooon@0000030?ooo`<000001`3oool000L0oooo00@000000?ooo`3o
ool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooon@000005
0?ooo`030000003oool0oooo00D0oooo00080?ooo`030000003oool000000080oooo00@000000?oo
o`3oool00000103oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`05
0?ooo`002@3oool2000000<0oooo0P0000050?ooo`030000003oool0oooo0080oooon@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03`0oooo
00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooool000001@0000070?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00SP3oool2000000050?ooo`00000000000000003oool01@0000000`3oool0
00000000000300000800oooo002>0?ooo`050000003oool0oooo0?ooo`000000103oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0800oooo002>0?ooo`050000003oool000000?ooo`00
0000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0800oooo002>0?ooo`800000
00<0oooo000000000000103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0800oooo
002>0?ooo`80000000<0oooo000000000000103oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0800oooo002>0?ooo`80000000@0oooo00000000000000000P3oool2000000@0oooo0P00
00220?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-3.26594, -1.76599, 0.160642, \
0.160642}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00480769 0.0240385 -0.00480769 0.0240385 [
[.23558 -0.0125 -6 -9 ]
[.23558 -0.0125 6 0 ]
[.47596 -0.0125 -6 -9 ]
[.47596 -0.0125 6 0 ]
[.71635 -0.0125 -6 -9 ]
[.71635 -0.0125 6 0 ]
[.95673 -0.0125 -6 -9 ]
[.95673 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .23558 -12 -4.5 ]
[-0.0125 .23558 0 4.5 ]
[-0.0125 .47596 -12 -4.5 ]
[-0.0125 .47596 0 4.5 ]
[-0.0125 .71635 -12 -4.5 ]
[-0.0125 .71635 0 4.5 ]
[-0.0125 .95673 -12 -4.5 ]
[-0.0125 .95673 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -11 0 ]
[.5 1.0125 11 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23558 0 m
.23558 .00625 L
s
[(10)] .23558 -0.0125 0 1 Mshowa
.47596 0 m
.47596 .00625 L
s
[(20)] .47596 -0.0125 0 1 Mshowa
.71635 0 m
.71635 .00625 L
s
[(30)] .71635 -0.0125 0 1 Mshowa
.95673 0 m
.95673 .00625 L
s
[(40)] .95673 -0.0125 0 1 Mshowa
.125 Mabswid
.04327 0 m
.04327 .00375 L
s
.09135 0 m
.09135 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.1875 0 m
.1875 .00375 L
s
.28365 0 m
.28365 .00375 L
s
.33173 0 m
.33173 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.42788 0 m
.42788 .00375 L
s
.52404 0 m
.52404 .00375 L
s
.57212 0 m
.57212 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.66827 0 m
.66827 .00375 L
s
.76442 0 m
.76442 .00375 L
s
.8125 0 m
.8125 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.90865 0 m
.90865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .23558 m
.00625 .23558 L
s
[(10)] -0.0125 .23558 1 0 Mshowa
0 .47596 m
.00625 .47596 L
s
[(20)] -0.0125 .47596 1 0 Mshowa
0 .71635 m
.00625 .71635 L
s
[(30)] -0.0125 .71635 1 0 Mshowa
0 .95673 m
.00625 .95673 L
s
[(40)] -0.0125 .95673 1 0 Mshowa
.125 Mabswid
0 .04327 m
.00375 .04327 L
s
0 .09135 m
.00375 .09135 L
s
0 .13942 m
.00375 .13942 L
s
0 .1875 m
.00375 .1875 L
s
0 .28365 m
.00375 .28365 L
s
0 .33173 m
.00375 .33173 L
s
0 .37981 m
.00375 .37981 L
s
0 .42788 m
.00375 .42788 L
s
0 .52404 m
.00375 .52404 L
s
0 .57212 m
.00375 .57212 L
s
0 .62019 m
.00375 .62019 L
s
0 .66827 m
.00375 .66827 L
s
0 .76442 m
.00375 .76442 L
s
0 .8125 m
.00375 .8125 L
s
0 .86058 m
.00375 .86058 L
s
0 .90865 m
.00375 .90865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.23558 .99375 m
.23558 1 L
s
.47596 .99375 m
.47596 1 L
s
.71635 .99375 m
.71635 1 L
s
.95673 .99375 m
.95673 1 L
s
.125 Mabswid
.04327 .99625 m
.04327 1 L
s
.09135 .99625 m
.09135 1 L
s
.13942 .99625 m
.13942 1 L
s
.1875 .99625 m
.1875 1 L
s
.28365 .99625 m
.28365 1 L
s
.33173 .99625 m
.33173 1 L
s
.37981 .99625 m
.37981 1 L
s
.42788 .99625 m
.42788 1 L
s
.52404 .99625 m
.52404 1 L
s
.57212 .99625 m
.57212 1 L
s
.62019 .99625 m
.62019 1 L
s
.66827 .99625 m
.66827 1 L
s
.76442 .99625 m
.76442 1 L
s
.8125 .99625 m
.8125 1 L
s
.86058 .99625 m
.86058 1 L
s
.90865 .99625 m
.90865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .23558 m
1 .23558 L
s
.99375 .47596 m
1 .47596 L
s
.99375 .71635 m
1 .71635 L
s
.99375 .95673 m
1 .95673 L
s
.125 Mabswid
.99625 .04327 m
1 .04327 L
s
.99625 .09135 m
1 .09135 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .1875 m
1 .1875 L
s
.99625 .28365 m
1 .28365 L
s
.99625 .33173 m
1 .33173 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .42788 m
1 .42788 L
s
.99625 .52404 m
1 .52404 L
s
.99625 .57212 m
1 .57212 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .66827 m
1 .66827 L
s
.99625 .76442 m
1 .76442 L
s
.99625 .8125 m
1 .8125 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .90865 m
1 .90865 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M20) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.5 Mabswid
.1 g
.56427 .01923 m
.57212 .02072 L
.59615 .02633 L
.62019 .03407 L
.64235 .04327 L
.64423 .04414 L
.66827 .05649 L
.68679 .06731 L
.69231 .07104 L
.71635 .08921 L
.71889 .09135 L
.74038 .11204 L
.7434 .11538 L
.76239 .13942 L
.76442 .14236 L
.77649 .16346 L
.78674 .1875 L
.78846 .19283 L
.7925 .21154 L
.79395 .23558 L
.79045 .25962 L
.78846 .26832 L
.78002 .28365 L
.76442 .30353 L
.7596 .30769 L
.74038 .32113 L
.71916 .33173 L
.71635 .33225 L
.69231 .33735 L
.66827 .34323 L
.64423 .34868 L
.62019 .35315 L
.60242 .35577 L
.59615 .35631 L
.57212 .35799 L
.54808 .35911 L
.52404 .35976 L
.5 .35997 L
.47596 .35976 L
.45192 .35911 L
.42788 .35799 L
.40385 .35631 L
.39758 .35577 L
.37981 .35315 L
.35577 .34868 L
.33173 .34323 L
.30769 .33735 L
.28365 .33225 L
.28084 .33173 L
.25962 .32113 L
.2404 .30769 L
.23558 .30353 L
.21998 .28365 L
.21154 .26832 L
.20955 .25962 L
.20605 .23558 L
.2075 .21154 L
.21154 .19283 L
.21326 .1875 L
.22351 .16346 L
.23558 .14236 L
.23761 .13942 L
.2566 .11538 L
.25962 .11204 L
.28111 .09135 L
.28365 .08921 L
.30769 .07104 L
.31321 .06731 L
.33173 .05649 L
.35577 .04414 L
.35765 .04327 L
.37981 .03407 L
.40385 .02633 L
.42788 .02072 L
.43573 .01923 L
F
0 g
.56427 .01923 m
.57212 .02072 L
.59615 .02633 L
.62019 .03407 L
.64235 .04327 L
.64423 .04414 L
.66827 .05649 L
.68679 .06731 L
.69231 .07104 L
.71635 .08921 L
.71889 .09135 L
.74038 .11204 L
.7434 .11538 L
.76239 .13942 L
.76442 .14236 L
.77649 .16346 L
.78674 .1875 L
.78846 .19283 L
.7925 .21154 L
.79395 .23558 L
.79045 .25962 L
.78846 .26832 L
.78002 .28365 L
.76442 .30353 L
.7596 .30769 L
.74038 .32113 L
.71916 .33173 L
.71635 .33225 L
.69231 .33735 L
.66827 .34323 L
.64423 .34868 L
.62019 .35315 L
.60242 .35577 L
.59615 .35631 L
.57212 .35799 L
.54808 .35911 L
.52404 .35976 L
.5 .35997 L
.47596 .35976 L
.45192 .35911 L
.42788 .35799 L
.40385 .35631 L
.39758 .35577 L
.37981 .35315 L
.35577 .34868 L
.33173 .34323 L
.30769 .33735 L
.28365 .33225 L
.28084 .33173 L
.25962 .32113 L
Mistroke
.2404 .30769 L
.23558 .30353 L
.21998 .28365 L
.21154 .26832 L
.20955 .25962 L
.20605 .23558 L
.2075 .21154 L
.21154 .19283 L
.21326 .1875 L
.22351 .16346 L
.23558 .14236 L
.23761 .13942 L
.2566 .11538 L
.25962 .11204 L
.28111 .09135 L
.28365 .08921 L
.30769 .07104 L
.31321 .06731 L
.33173 .05649 L
.35577 .04414 L
.35765 .04327 L
.37981 .03407 L
.40385 .02633 L
.42788 .02072 L
.43573 .01923 L
Mfstroke
.1 g
.56427 .98077 m
.57212 .97928 L
.59615 .97367 L
.62019 .96593 L
.64235 .95673 L
.64423 .95586 L
.66827 .94351 L
.68679 .93269 L
.69231 .92896 L
.71635 .91079 L
.71889 .90865 L
.74038 .88796 L
.7434 .88462 L
.76239 .86058 L
.76442 .85764 L
.77649 .83654 L
.78674 .8125 L
.78846 .80717 L
.7925 .78846 L
.79395 .76442 L
.79045 .74038 L
.78846 .73168 L
.78002 .71635 L
.76442 .69647 L
.7596 .69231 L
.74038 .67887 L
.71916 .66827 L
.71635 .66775 L
.69231 .66265 L
.66827 .65677 L
.64423 .65132 L
.62019 .64685 L
.60242 .64423 L
.59615 .64369 L
.57212 .64201 L
.54808 .64089 L
.52404 .64024 L
.5 .64003 L
.47596 .64024 L
.45192 .64089 L
.42788 .64201 L
.40385 .64369 L
.39758 .64423 L
.37981 .64685 L
.35577 .65132 L
.33173 .65677 L
.30769 .66265 L
.28365 .66775 L
.28084 .66827 L
.25962 .67887 L
.2404 .69231 L
.23558 .69647 L
.21998 .71635 L
.21154 .73168 L
.20955 .74038 L
.20605 .76442 L
.2075 .78846 L
.21154 .80717 L
.21326 .8125 L
.22351 .83654 L
.23558 .85764 L
.23761 .86058 L
.2566 .88462 L
.25962 .88796 L
.28111 .90865 L
.28365 .91079 L
.30769 .92896 L
.31321 .93269 L
.33173 .94351 L
.35577 .95586 L
.35765 .95673 L
.37981 .96593 L
.40385 .97367 L
.42788 .97928 L
.43573 .98077 L
F
0 g
.56427 .98077 m
.57212 .97928 L
.59615 .97367 L
.62019 .96593 L
.64235 .95673 L
.64423 .95586 L
.66827 .94351 L
.68679 .93269 L
.69231 .92896 L
.71635 .91079 L
.71889 .90865 L
.74038 .88796 L
.7434 .88462 L
.76239 .86058 L
.76442 .85764 L
.77649 .83654 L
.78674 .8125 L
.78846 .80717 L
.7925 .78846 L
.79395 .76442 L
.79045 .74038 L
.78846 .73168 L
.78002 .71635 L
.76442 .69647 L
.7596 .69231 L
.74038 .67887 L
.71916 .66827 L
.71635 .66775 L
.69231 .66265 L
.66827 .65677 L
.64423 .65132 L
.62019 .64685 L
.60242 .64423 L
.59615 .64369 L
.57212 .64201 L
.54808 .64089 L
.52404 .64024 L
.5 .64003 L
.47596 .64024 L
.45192 .64089 L
.42788 .64201 L
.40385 .64369 L
.39758 .64423 L
.37981 .64685 L
.35577 .65132 L
.33173 .65677 L
.30769 .66265 L
.28365 .66775 L
.28084 .66827 L
.25962 .67887 L
Mistroke
.2404 .69231 L
.23558 .69647 L
.21998 .71635 L
.21154 .73168 L
.20955 .74038 L
.20605 .76442 L
.2075 .78846 L
.21154 .80717 L
.21326 .8125 L
.22351 .83654 L
.23558 .85764 L
.23761 .86058 L
.2566 .88462 L
.25962 .88796 L
.28111 .90865 L
.28365 .91079 L
.30769 .92896 L
.31321 .93269 L
.33173 .94351 L
.35577 .95586 L
.35765 .95673 L
.37981 .96593 L
.40385 .97367 L
.42788 .97928 L
.43573 .98077 L
Mfstroke
.1 g
.40385 .40332 m
.42788 .40163 L
.45192 .4005 L
.47596 .39985 L
.5 .39964 L
.52404 .39985 L
.54808 .4005 L
.57212 .40163 L
.59615 .40332 L
.60223 .40385 L
.62019 .40648 L
.64423 .41093 L
.66827 .41635 L
.69231 .42222 L
.71635 .42746 L
.71845 .42788 L
.74038 .43901 L
.75744 .45192 L
.76442 .45617 L
.77506 .47596 L
.78039 .5 L
.77506 .52404 L
.76442 .54383 L
.75744 .54808 L
.74038 .56099 L
.71845 .57212 L
.71635 .57254 L
.69231 .57778 L
.66827 .58365 L
.64423 .58907 L
.62019 .59352 L
.60223 .59615 L
.59615 .59668 L
.57212 .59837 L
.54808 .5995 L
.52404 .60015 L
.5 .60036 L
.47596 .60015 L
.45192 .5995 L
.42788 .59837 L
.40385 .59668 L
.39777 .59615 L
.37981 .59352 L
.35577 .58907 L
.33173 .58365 L
.30769 .57778 L
.28365 .57254 L
.28155 .57212 L
.25962 .56099 L
.24256 .54808 L
.23558 .54383 L
.22494 .52404 L
.21961 .5 L
.22494 .47596 L
.23558 .45617 L
.24256 .45192 L
.25962 .43901 L
.28155 .42788 L
.28365 .42746 L
.30769 .42222 L
.33173 .41635 L
.35577 .41093 L
.37981 .40648 L
.39777 .40385 L
F
0 g
.40385 .40332 m
.42788 .40163 L
.45192 .4005 L
.47596 .39985 L
.5 .39964 L
.52404 .39985 L
.54808 .4005 L
.57212 .40163 L
.59615 .40332 L
.60223 .40385 L
.62019 .40648 L
.64423 .41093 L
.66827 .41635 L
.69231 .42222 L
.71635 .42746 L
.71845 .42788 L
.74038 .43901 L
.75744 .45192 L
.76442 .45617 L
.77506 .47596 L
.78039 .5 L
.77506 .52404 L
.76442 .54383 L
.75744 .54808 L
.74038 .56099 L
.71845 .57212 L
.71635 .57254 L
.69231 .57778 L
.66827 .58365 L
.64423 .58907 L
.62019 .59352 L
.60223 .59615 L
.59615 .59668 L
.57212 .59837 L
.54808 .5995 L
.52404 .60015 L
.5 .60036 L
.47596 .60015 L
.45192 .5995 L
.42788 .59837 L
.40385 .59668 L
.39777 .59615 L
.37981 .59352 L
.35577 .58907 L
.33173 .58365 L
.30769 .57778 L
.28365 .57254 L
.28155 .57212 L
.25962 .56099 L
.24256 .54808 L
Mistroke
.23558 .54383 L
.22494 .52404 L
.21961 .5 L
.22494 .47596 L
.23558 .45617 L
.24256 .45192 L
.25962 .43901 L
.28155 .42788 L
.28365 .42746 L
.30769 .42222 L
.33173 .41635 L
.35577 .41093 L
.37981 .40648 L
.39777 .40385 L
.40385 .40332 L
Mfstroke
.2 g
.40385 .06582 m
.42788 .05918 L
.45192 .05441 L
.47596 .05155 L
.5 .0506 L
.52404 .05155 L
.54808 .05441 L
.57212 .05918 L
.59615 .06582 L
.6008 .06731 L
.62019 .07506 L
.64423 .08685 L
.65225 .09135 L
.66827 .10188 L
.68581 .11538 L
.69231 .12114 L
.71 .13942 L
.71635 .1471 L
.72754 .16346 L
.73979 .1875 L
.74038 .189 L
.7467 .21154 L
.74845 .23558 L
.74419 .25962 L
.74038 .27202 L
.73179 .28365 L
.71635 .30051 L
.70655 .30769 L
.69231 .3161 L
.66827 .32657 L
.65265 .33173 L
.64423 .33279 L
.62019 .33603 L
.59615 .33928 L
.57212 .34207 L
.54808 .34414 L
.52404 .3454 L
.5 .34582 L
.47596 .3454 L
.45192 .34414 L
.42788 .34207 L
.40385 .33928 L
.37981 .33603 L
.35577 .33279 L
.34735 .33173 L
.33173 .32657 L
.30769 .3161 L
.29345 .30769 L
.28365 .30051 L
.26821 .28365 L
.25962 .27202 L
.25581 .25962 L
.25155 .23558 L
.2533 .21154 L
.25962 .189 L
.26021 .1875 L
.27246 .16346 L
.28365 .1471 L
.29 .13942 L
.30769 .12114 L
.31419 .11538 L
.33173 .10188 L
.34775 .09135 L
.35577 .08685 L
.37981 .07506 L
.3992 .06731 L
F
0 g
.40385 .06582 m
.42788 .05918 L
.45192 .05441 L
.47596 .05155 L
.5 .0506 L
.52404 .05155 L
.54808 .05441 L
.57212 .05918 L
.59615 .06582 L
.6008 .06731 L
.62019 .07506 L
.64423 .08685 L
.65225 .09135 L
.66827 .10188 L
.68581 .11538 L
.69231 .12114 L
.71 .13942 L
.71635 .1471 L
.72754 .16346 L
.73979 .1875 L
.74038 .189 L
.7467 .21154 L
.74845 .23558 L
.74419 .25962 L
.74038 .27202 L
.73179 .28365 L
.71635 .30051 L
.70655 .30769 L
.69231 .3161 L
.66827 .32657 L
.65265 .33173 L
.64423 .33279 L
.62019 .33603 L
.59615 .33928 L
.57212 .34207 L
.54808 .34414 L
.52404 .3454 L
.5 .34582 L
.47596 .3454 L
.45192 .34414 L
.42788 .34207 L
.40385 .33928 L
.37981 .33603 L
.35577 .33279 L
.34735 .33173 L
.33173 .32657 L
.30769 .3161 L
.29345 .30769 L
.28365 .30051 L
.26821 .28365 L
Mistroke
.25962 .27202 L
.25581 .25962 L
.25155 .23558 L
.2533 .21154 L
.25962 .189 L
.26021 .1875 L
.27246 .16346 L
.28365 .1471 L
.29 .13942 L
.30769 .12114 L
.31419 .11538 L
.33173 .10188 L
.34775 .09135 L
.35577 .08685 L
.37981 .07506 L
.3992 .06731 L
.40385 .06582 L
Mfstroke
.2 g
.35577 .66721 m
.37981 .66397 L
.40385 .66072 L
.42788 .65793 L
.45192 .65586 L
.47596 .6546 L
.5 .65418 L
.52404 .6546 L
.54808 .65586 L
.57212 .65793 L
.59615 .66072 L
.62019 .66397 L
.64423 .66721 L
.65265 .66827 L
.66827 .67343 L
.69231 .6839 L
.70655 .69231 L
.71635 .69949 L
.73179 .71635 L
.74038 .72798 L
.74419 .74038 L
.74845 .76442 L
.7467 .78846 L
.74038 .811 L
.73979 .8125 L
.72754 .83654 L
.71635 .8529 L
.71 .86058 L
.69231 .87886 L
.68581 .88462 L
.66827 .89812 L
.65225 .90865 L
.64423 .91315 L
.62019 .92494 L
.6008 .93269 L
.59615 .93418 L
.57212 .94082 L
.54808 .94559 L
.52404 .94845 L
.5 .9494 L
.47596 .94845 L
.45192 .94559 L
.42788 .94082 L
.40385 .93418 L
.3992 .93269 L
.37981 .92494 L
.35577 .91315 L
.34775 .90865 L
.33173 .89812 L
.31419 .88462 L
.30769 .87886 L
.29 .86058 L
.28365 .8529 L
.27246 .83654 L
.26021 .8125 L
.25962 .811 L
.2533 .78846 L
.25155 .76442 L
.25581 .74038 L
.25962 .72798 L
.26821 .71635 L
.28365 .69949 L
.29345 .69231 L
.30769 .6839 L
.33173 .67343 L
.34735 .66827 L
F
0 g
.35577 .66721 m
.37981 .66397 L
.40385 .66072 L
.42788 .65793 L
.45192 .65586 L
.47596 .6546 L
.5 .65418 L
.52404 .6546 L
.54808 .65586 L
.57212 .65793 L
.59615 .66072 L
.62019 .66397 L
.64423 .66721 L
.65265 .66827 L
.66827 .67343 L
.69231 .6839 L
.70655 .69231 L
.71635 .69949 L
.73179 .71635 L
.74038 .72798 L
.74419 .74038 L
.74845 .76442 L
.7467 .78846 L
.74038 .811 L
.73979 .8125 L
.72754 .83654 L
.71635 .8529 L
.71 .86058 L
.69231 .87886 L
.68581 .88462 L
.66827 .89812 L
.65225 .90865 L
.64423 .91315 L
.62019 .92494 L
.6008 .93269 L
.59615 .93418 L
.57212 .94082 L
.54808 .94559 L
.52404 .94845 L
.5 .9494 L
.47596 .94845 L
.45192 .94559 L
.42788 .94082 L
.40385 .93418 L
.3992 .93269 L
.37981 .92494 L
.35577 .91315 L
.34775 .90865 L
.33173 .89812 L
.31419 .88462 L
Mistroke
.30769 .87886 L
.29 .86058 L
.28365 .8529 L
.27246 .83654 L
.26021 .8125 L
.25962 .811 L
.2533 .78846 L
.25155 .76442 L
.25581 .74038 L
.25962 .72798 L
.26821 .71635 L
.28365 .69949 L
.29345 .69231 L
.30769 .6839 L
.33173 .67343 L
.34735 .66827 L
.35577 .66721 L
Mfstroke
.2 g
.35577 .42688 m
.37981 .42355 L
.40385 .42029 L
.42788 .41751 L
.45192 .41545 L
.47596 .4142 L
.5 .41378 L
.52404 .4142 L
.54808 .41545 L
.57212 .41751 L
.59615 .42029 L
.62019 .42355 L
.64423 .42688 L
.65161 .42788 L
.66827 .43341 L
.69231 .44439 L
.70387 .45192 L
.71635 .45939 L
.72581 .47596 L
.73224 .5 L
.72581 .52404 L
.71635 .54061 L
.70387 .54808 L
.69231 .55561 L
.66827 .56659 L
.65161 .57212 L
.64423 .57312 L
.62019 .57645 L
.59615 .57971 L
.57212 .58249 L
.54808 .58455 L
.52404 .5858 L
.5 .58622 L
.47596 .5858 L
.45192 .58455 L
.42788 .58249 L
.40385 .57971 L
.37981 .57645 L
.35577 .57312 L
.34839 .57212 L
.33173 .56659 L
.30769 .55561 L
.29613 .54808 L
.28365 .54061 L
.27419 .52404 L
.26776 .5 L
.27419 .47596 L
.28365 .45939 L
.29613 .45192 L
.30769 .44439 L
.33173 .43341 L
.34839 .42788 L
F
0 g
.35577 .42688 m
.37981 .42355 L
.40385 .42029 L
.42788 .41751 L
.45192 .41545 L
.47596 .4142 L
.5 .41378 L
.52404 .4142 L
.54808 .41545 L
.57212 .41751 L
.59615 .42029 L
.62019 .42355 L
.64423 .42688 L
.65161 .42788 L
.66827 .43341 L
.69231 .44439 L
.70387 .45192 L
.71635 .45939 L
.72581 .47596 L
.73224 .5 L
.72581 .52404 L
.71635 .54061 L
.70387 .54808 L
.69231 .55561 L
.66827 .56659 L
.65161 .57212 L
.64423 .57312 L
.62019 .57645 L
.59615 .57971 L
.57212 .58249 L
.54808 .58455 L
.52404 .5858 L
.5 .58622 L
.47596 .5858 L
.45192 .58455 L
.42788 .58249 L
.40385 .57971 L
.37981 .57645 L
.35577 .57312 L
.34839 .57212 L
.33173 .56659 L
.30769 .55561 L
.29613 .54808 L
.28365 .54061 L
.27419 .52404 L
.26776 .5 L
.27419 .47596 L
.28365 .45939 L
.29613 .45192 L
.30769 .44439 L
Mistroke
.33173 .43341 L
.34839 .42788 L
.35577 .42688 L
Mfstroke
.3 g
.40385 .08981 m
.42788 .08223 L
.45192 .07689 L
.47596 .07372 L
.5 .07266 L
.52404 .07372 L
.54808 .07689 L
.57212 .08223 L
.59615 .08981 L
.6003 .09135 L
.62019 .10033 L
.64423 .11403 L
.64631 .11538 L
.66827 .13226 L
.67601 .13942 L
.69231 .1575 L
.69668 .16346 L
.71059 .1875 L
.71635 .20263 L
.71859 .21154 L
.72056 .23558 L
.71635 .25793 L
.71575 .25962 L
.70153 .28365 L
.69231 .2935 L
.67192 .30769 L
.66827 .30967 L
.64423 .32004 L
.62019 .32736 L
.60091 .33173 L
.59615 .33211 L
.57212 .33394 L
.54808 .33546 L
.52404 .33646 L
.5 .3368 L
.47596 .33646 L
.45192 .33546 L
.42788 .33394 L
.40385 .33211 L
.39909 .33173 L
.37981 .32736 L
.35577 .32004 L
.33173 .30967 L
.32808 .30769 L
.30769 .2935 L
.29847 .28365 L
.28425 .25962 L
.28365 .25793 L
.27944 .23558 L
.28141 .21154 L
.28365 .20263 L
.28941 .1875 L
.30332 .16346 L
.30769 .1575 L
.32399 .13942 L
.33173 .13226 L
.35369 .11538 L
.35577 .11403 L
.37981 .10033 L
.3997 .09135 L
F
0 g
.40385 .08981 m
.42788 .08223 L
.45192 .07689 L
.47596 .07372 L
.5 .07266 L
.52404 .07372 L
.54808 .07689 L
.57212 .08223 L
.59615 .08981 L
.6003 .09135 L
.62019 .10033 L
.64423 .11403 L
.64631 .11538 L
.66827 .13226 L
.67601 .13942 L
.69231 .1575 L
.69668 .16346 L
.71059 .1875 L
.71635 .20263 L
.71859 .21154 L
.72056 .23558 L
.71635 .25793 L
.71575 .25962 L
.70153 .28365 L
.69231 .2935 L
.67192 .30769 L
.66827 .30967 L
.64423 .32004 L
.62019 .32736 L
.60091 .33173 L
.59615 .33211 L
.57212 .33394 L
.54808 .33546 L
.52404 .33646 L
.5 .3368 L
.47596 .33646 L
.45192 .33546 L
.42788 .33394 L
.40385 .33211 L
.39909 .33173 L
.37981 .32736 L
.35577 .32004 L
.33173 .30967 L
.32808 .30769 L
.30769 .2935 L
.29847 .28365 L
.28425 .25962 L
.28365 .25793 L
.27944 .23558 L
.28141 .21154 L
Mistroke
.28365 .20263 L
.28941 .1875 L
.30332 .16346 L
.30769 .1575 L
.32399 .13942 L
.33173 .13226 L
.35369 .11538 L
.35577 .11403 L
.37981 .10033 L
.3997 .09135 L
.40385 .08981 L
Mfstroke
.3 g
.40385 .66789 m
.42788 .66606 L
.45192 .66454 L
.47596 .66354 L
.5 .6632 L
.52404 .66354 L
.54808 .66454 L
.57212 .66606 L
.59615 .66789 L
.60091 .66827 L
.62019 .67264 L
.64423 .67996 L
.66827 .69033 L
.67192 .69231 L
.69231 .7065 L
.70153 .71635 L
.71575 .74038 L
.71635 .74207 L
.72056 .76442 L
.71859 .78846 L
.71635 .79737 L
.71059 .8125 L
.69668 .83654 L
.69231 .8425 L
.67601 .86058 L
.66827 .86774 L
.64631 .88462 L
.64423 .88597 L
.62019 .89967 L
.6003 .90865 L
.59615 .91019 L
.57212 .91777 L
.54808 .92311 L
.52404 .92628 L
.5 .92734 L
.47596 .92628 L
.45192 .92311 L
.42788 .91777 L
.40385 .91019 L
.3997 .90865 L
.37981 .89967 L
.35577 .88597 L
.35369 .88462 L
.33173 .86774 L
.32399 .86058 L
.30769 .8425 L
.30332 .83654 L
.28941 .8125 L
.28365 .79737 L
.28141 .78846 L
.27944 .76442 L
.28365 .74207 L
.28425 .74038 L
.29847 .71635 L
.30769 .7065 L
.32808 .69231 L
.33173 .69033 L
.35577 .67996 L
.37981 .67264 L
.39909 .66827 L
F
0 g
.40385 .66789 m
.42788 .66606 L
.45192 .66454 L
.47596 .66354 L
.5 .6632 L
.52404 .66354 L
.54808 .66454 L
.57212 .66606 L
.59615 .66789 L
.60091 .66827 L
.62019 .67264 L
.64423 .67996 L
.66827 .69033 L
.67192 .69231 L
.69231 .7065 L
.70153 .71635 L
.71575 .74038 L
.71635 .74207 L
.72056 .76442 L
.71859 .78846 L
.71635 .79737 L
.71059 .8125 L
.69668 .83654 L
.69231 .8425 L
.67601 .86058 L
.66827 .86774 L
.64631 .88462 L
.64423 .88597 L
.62019 .89967 L
.6003 .90865 L
.59615 .91019 L
.57212 .91777 L
.54808 .92311 L
.52404 .92628 L
.5 .92734 L
.47596 .92628 L
.45192 .92311 L
.42788 .91777 L
.40385 .91019 L
.3997 .90865 L
.37981 .89967 L
.35577 .88597 L
.35369 .88462 L
.33173 .86774 L
.32399 .86058 L
.30769 .8425 L
.30332 .83654 L
.28941 .8125 L
.28365 .79737 L
.28141 .78846 L
Mistroke
.27944 .76442 L
.28365 .74207 L
.28425 .74038 L
.29847 .71635 L
.30769 .7065 L
.32808 .69231 L
.33173 .69033 L
.35577 .67996 L
.37981 .67264 L
.39909 .66827 L
.40385 .66789 L
Mfstroke
.3 g
.40385 .42761 m
.42788 .42567 L
.45192 .42412 L
.47596 .42311 L
.5 .42277 L
.52404 .42311 L
.54808 .42412 L
.57212 .42567 L
.59615 .42761 L
.59933 .42788 L
.62019 .4326 L
.64423 .44016 L
.66827 .45165 L
.66871 .45192 L
.69231 .4709 L
.69469 .47596 L
.70204 .5 L
.69469 .52404 L
.69231 .5291 L
.66871 .54808 L
.66827 .54835 L
.64423 .55984 L
.62019 .5674 L
.59933 .57212 L
.59615 .57239 L
.57212 .57433 L
.54808 .57588 L
.52404 .57689 L
.5 .57723 L
.47596 .57689 L
.45192 .57588 L
.42788 .57433 L
.40385 .57239 L
.40067 .57212 L
.37981 .5674 L
.35577 .55984 L
.33173 .54835 L
.33129 .54808 L
.30769 .5291 L
.30531 .52404 L
.29796 .5 L
.30531 .47596 L
.30769 .4709 L
.33129 .45192 L
.33173 .45165 L
.35577 .44016 L
.37981 .4326 L
.40067 .42788 L
F
0 g
.40385 .42761 m
.42788 .42567 L
.45192 .42412 L
.47596 .42311 L
.5 .42277 L
.52404 .42311 L
.54808 .42412 L
.57212 .42567 L
.59615 .42761 L
.59933 .42788 L
.62019 .4326 L
.64423 .44016 L
.66827 .45165 L
.66871 .45192 L
.69231 .4709 L
.69469 .47596 L
.70204 .5 L
.69469 .52404 L
.69231 .5291 L
.66871 .54808 L
.66827 .54835 L
.64423 .55984 L
.62019 .5674 L
.59933 .57212 L
.59615 .57239 L
.57212 .57433 L
.54808 .57588 L
.52404 .57689 L
.5 .57723 L
.47596 .57689 L
.45192 .57588 L
.42788 .57433 L
.40385 .57239 L
.40067 .57212 L
.37981 .5674 L
.35577 .55984 L
.33173 .54835 L
.33129 .54808 L
.30769 .5291 L
.30531 .52404 L
.29796 .5 L
.30531 .47596 L
.30769 .4709 L
.33129 .45192 L
.33173 .45165 L
.35577 .44016 L
.37981 .4326 L
.40067 .42788 L
.40385 .42761 L
s
.4 g
.47596 .09043 m
.5 .08934 L
.52404 .09043 L
.5364 .09135 L
.54808 .09386 L
.57212 .09981 L
.59615 .1084 L
.61145 .11538 L
.62019 .12015 L
.64423 .13617 L
.64832 .13942 L
.66827 .1586 L
.67233 .16346 L
.68806 .1875 L
.69231 .1968 L
.69694 .21154 L
.69914 .23558 L
.69377 .25962 L
.69231 .26409 L
.67787 .28365 L
.66827 .29273 L
.64423 .30732 L
.64343 .30769 L
.62019 .31665 L
.59615 .32312 L
.57212 .32763 L
.54808 .33062 L
.53862 .33173 L
.52404 .33198 L
.5 .33222 L
.47596 .33198 L
.46138 .33173 L
.45192 .33062 L
.42788 .32763 L
.40385 .32312 L
.37981 .31665 L
.35657 .30769 L
.35577 .30732 L
.33173 .29273 L
.32213 .28365 L
.30769 .26409 L
.30623 .25962 L
.30086 .23558 L
.30306 .21154 L
.30769 .1968 L
.31194 .1875 L
.32767 .16346 L
.33173 .1586 L
.35168 .13942 L
.35577 .13617 L
.37981 .12015 L
.38855 .11538 L
.40385 .1084 L
.42788 .09981 L
.45192 .09386 L
.4636 .09135 L
F
0 g
.47596 .09043 m
.5 .08934 L
.52404 .09043 L
.5364 .09135 L
.54808 .09386 L
.57212 .09981 L
.59615 .1084 L
.61145 .11538 L
.62019 .12015 L
.64423 .13617 L
.64832 .13942 L
.66827 .1586 L
.67233 .16346 L
.68806 .1875 L
.69231 .1968 L
.69694 .21154 L
.69914 .23558 L
.69377 .25962 L
.69231 .26409 L
.67787 .28365 L
.66827 .29273 L
.64423 .30732 L
.64343 .30769 L
.62019 .31665 L
.59615 .32312 L
.57212 .32763 L
.54808 .33062 L
.53862 .33173 L
.52404 .33198 L
.5 .33222 L
.47596 .33198 L
.46138 .33173 L
.45192 .33062 L
.42788 .32763 L
.40385 .32312 L
.37981 .31665 L
.35657 .30769 L
.35577 .30732 L
.33173 .29273 L
.32213 .28365 L
.30769 .26409 L
.30623 .25962 L
.30086 .23558 L
.30306 .21154 L
.30769 .1968 L
.31194 .1875 L
.32767 .16346 L
.33173 .1586 L
.35168 .13942 L
.35577 .13617 L
Mistroke
.37981 .12015 L
.38855 .11538 L
.40385 .1084 L
.42788 .09981 L
.45192 .09386 L
.4636 .09135 L
.47596 .09043 L
Mfstroke
.4 g
.47596 .66802 m
.5 .66778 L
.52404 .66802 L
.53862 .66827 L
.54808 .66938 L
.57212 .67237 L
.59615 .67688 L
.62019 .68335 L
.64343 .69231 L
.64423 .69268 L
.66827 .70727 L
.67787 .71635 L
.69231 .73591 L
.69377 .74038 L
.69914 .76442 L
.69694 .78846 L
.69231 .8032 L
.68806 .8125 L
.67233 .83654 L
.66827 .8414 L
.64832 .86058 L
.64423 .86383 L
.62019 .87985 L
.61145 .88462 L
.59615 .8916 L
.57212 .90019 L
.54808 .90614 L
.5364 .90865 L
.52404 .90957 L
.5 .91066 L
.47596 .90957 L
.4636 .90865 L
.45192 .90614 L
.42788 .90019 L
.40385 .8916 L
.38855 .88462 L
.37981 .87985 L
.35577 .86383 L
.35168 .86058 L
.33173 .8414 L
.32767 .83654 L
.31194 .8125 L
.30769 .8032 L
.30306 .78846 L
.30086 .76442 L
.30623 .74038 L
.30769 .73591 L
.32213 .71635 L
.33173 .70727 L
.35577 .69268 L
.35657 .69231 L
.37981 .68335 L
.40385 .67688 L
.42788 .67237 L
.45192 .66938 L
.46138 .66827 L
F
0 g
.47596 .66802 m
.5 .66778 L
.52404 .66802 L
.53862 .66827 L
.54808 .66938 L
.57212 .67237 L
.59615 .67688 L
.62019 .68335 L
.64343 .69231 L
.64423 .69268 L
.66827 .70727 L
.67787 .71635 L
.69231 .73591 L
.69377 .74038 L
.69914 .76442 L
.69694 .78846 L
.69231 .8032 L
.68806 .8125 L
.67233 .83654 L
.66827 .8414 L
.64832 .86058 L
.64423 .86383 L
.62019 .87985 L
.61145 .88462 L
.59615 .8916 L
.57212 .90019 L
.54808 .90614 L
.5364 .90865 L
.52404 .90957 L
.5 .91066 L
.47596 .90957 L
.4636 .90865 L
.45192 .90614 L
.42788 .90019 L
.40385 .8916 L
.38855 .88462 L
.37981 .87985 L
.35577 .86383 L
.35168 .86058 L
.33173 .8414 L
.32767 .83654 L
.31194 .8125 L
.30769 .8032 L
.30306 .78846 L
.30086 .76442 L
.30623 .74038 L
.30769 .73591 L
.32213 .71635 L
.33173 .70727 L
.35577 .69268 L
Mistroke
.35657 .69231 L
.37981 .68335 L
.40385 .67688 L
.42788 .67237 L
.45192 .66938 L
.46138 .66827 L
.47596 .66802 L
Mfstroke
.5 g
.42788 .11457 m
.45192 .10821 L
.47596 .1045 L
.5 .10327 L
.52404 .1045 L
.54808 .10821 L
.57212 .11457 L
.57465 .11538 L
.59615 .12414 L
.62019 .1375 L
.62309 .13942 L
.64423 .15638 L
.65117 .16346 L
.66827 .18632 L
.6689 .1875 L
.67871 .21154 L
.68116 .23558 L
.67519 .25962 L
.66827 .27429 L
.65747 .28365 L
.64423 .29428 L
.62019 .30652 L
.61715 .30769 L
.59615 .3144 L
.57212 .31973 L
.54808 .32322 L
.52404 .3252 L
.5 .32584 L
.47596 .3252 L
.45192 .32322 L
.42788 .31973 L
.40385 .3144 L
.38285 .30769 L
.37981 .30652 L
.35577 .29428 L
.34253 .28365 L
.33173 .27429 L
.32481 .25962 L
.31884 .23558 L
.32129 .21154 L
.3311 .1875 L
.33173 .18632 L
.34883 .16346 L
.35577 .15638 L
.37691 .13942 L
.37981 .1375 L
.40385 .12414 L
.42535 .11538 L
F
0 g
.42788 .11457 m
.45192 .10821 L
.47596 .1045 L
.5 .10327 L
.52404 .1045 L
.54808 .10821 L
.57212 .11457 L
.57465 .11538 L
.59615 .12414 L
.62019 .1375 L
.62309 .13942 L
.64423 .15638 L
.65117 .16346 L
.66827 .18632 L
.6689 .1875 L
.67871 .21154 L
.68116 .23558 L
.67519 .25962 L
.66827 .27429 L
.65747 .28365 L
.64423 .29428 L
.62019 .30652 L
.61715 .30769 L
.59615 .3144 L
.57212 .31973 L
.54808 .32322 L
.52404 .3252 L
.5 .32584 L
.47596 .3252 L
.45192 .32322 L
.42788 .31973 L
.40385 .3144 L
.38285 .30769 L
.37981 .30652 L
.35577 .29428 L
.34253 .28365 L
.33173 .27429 L
.32481 .25962 L
.31884 .23558 L
.32129 .21154 L
.3311 .1875 L
.33173 .18632 L
.34883 .16346 L
.35577 .15638 L
.37691 .13942 L
.37981 .1375 L
.40385 .12414 L
.42535 .11538 L
.42788 .11457 L
s
.5 g
.40385 .6856 m
.42788 .68027 L
.45192 .67678 L
.47596 .6748 L
.5 .67416 L
.52404 .6748 L
.54808 .67678 L
.57212 .68027 L
.59615 .6856 L
.61715 .69231 L
.62019 .69348 L
.64423 .70572 L
.65747 .71635 L
.66827 .72571 L
.67519 .74038 L
.68116 .76442 L
.67871 .78846 L
.6689 .8125 L
.66827 .81368 L
.65117 .83654 L
.64423 .84362 L
.62309 .86058 L
.62019 .8625 L
.59615 .87586 L
.57465 .88462 L
.57212 .88543 L
.54808 .89179 L
.52404 .8955 L
.5 .89673 L
.47596 .8955 L
.45192 .89179 L
.42788 .88543 L
.42535 .88462 L
.40385 .87586 L
.37981 .8625 L
.37691 .86058 L
.35577 .84362 L
.34883 .83654 L
.33173 .81368 L
.3311 .8125 L
.32129 .78846 L
.31884 .76442 L
.32481 .74038 L
.33173 .72571 L
.34253 .71635 L
.35577 .70572 L
.37981 .69348 L
.38285 .69231 L
F
0 g
.40385 .6856 m
.42788 .68027 L
.45192 .67678 L
.47596 .6748 L
.5 .67416 L
.52404 .6748 L
.54808 .67678 L
.57212 .68027 L
.59615 .6856 L
.61715 .69231 L
.62019 .69348 L
.64423 .70572 L
.65747 .71635 L
.66827 .72571 L
.67519 .74038 L
.68116 .76442 L
.67871 .78846 L
.6689 .8125 L
.66827 .81368 L
.65117 .83654 L
.64423 .84362 L
.62309 .86058 L
.62019 .8625 L
.59615 .87586 L
.57465 .88462 L
.57212 .88543 L
.54808 .89179 L
.52404 .8955 L
.5 .89673 L
.47596 .8955 L
.45192 .89179 L
.42788 .88543 L
.42535 .88462 L
.40385 .87586 L
.37981 .8625 L
.37691 .86058 L
.35577 .84362 L
.34883 .83654 L
.33173 .81368 L
.3311 .8125 L
.32129 .78846 L
.31884 .76442 L
.32481 .74038 L
.33173 .72571 L
.34253 .71635 L
.35577 .70572 L
.37981 .69348 L
.38285 .69231 L
.40385 .6856 L
s
.4 g
.47596 .42775 m
.5 .42749 L
.52404 .42775 L
.53217 .42788 L
.54808 .42931 L
.57212 .43232 L
.59615 .43694 L
.62019 .44379 L
.63954 .45192 L
.64423 .45321 L
.66827 .47256 L
.67005 .47596 L
.67844 .5 L
.67005 .52404 L
.66827 .52744 L
.64423 .54679 L
.63954 .54808 L
.62019 .55621 L
.59615 .56306 L
.57212 .56768 L
.54808 .57069 L
.53217 .57212 L
.52404 .57225 L
.5 .57251 L
.47596 .57225 L
.46783 .57212 L
.45192 .57069 L
.42788 .56768 L
.40385 .56306 L
.37981 .55621 L
.36046 .54808 L
.35577 .54679 L
.33173 .52744 L
.32995 .52404 L
.32156 .5 L
.32995 .47596 L
.33173 .47256 L
.35577 .45321 L
.36046 .45192 L
.37981 .44379 L
.40385 .43694 L
.42788 .43232 L
.45192 .42931 L
.46783 .42788 L
F
0 g
.47596 .42775 m
.5 .42749 L
.52404 .42775 L
.53217 .42788 L
.54808 .42931 L
.57212 .43232 L
.59615 .43694 L
.62019 .44379 L
.63954 .45192 L
.64423 .45321 L
.66827 .47256 L
.67005 .47596 L
.67844 .5 L
.67005 .52404 L
.66827 .52744 L
.64423 .54679 L
.63954 .54808 L
.62019 .55621 L
.59615 .56306 L
.57212 .56768 L
.54808 .57069 L
.53217 .57212 L
.52404 .57225 L
.5 .57251 L
.47596 .57225 L
.46783 .57212 L
.45192 .57069 L
.42788 .56768 L
.40385 .56306 L
.37981 .55621 L
.36046 .54808 L
.35577 .54679 L
.33173 .52744 L
.32995 .52404 L
.32156 .5 L
.32995 .47596 L
.33173 .47256 L
.35577 .45321 L
.36046 .45192 L
.37981 .44379 L
.40385 .43694 L
.42788 .43232 L
.45192 .42931 L
.46783 .42788 L
.47596 .42775 L
s
.6 g
.5 .11531 m
.50558 .11538 L
.52404 .11665 L
.54808 .12074 L
.57212 .12783 L
.59615 .1384 L
.59809 .13942 L
.62019 .15371 L
.63162 .16346 L
.64423 .17671 L
.65162 .1875 L
.66254 .21154 L
.66523 .23558 L
.65864 .25962 L
.64423 .28066 L
.63882 .28365 L
.62019 .29612 L
.59615 .30597 L
.59058 .30769 L
.57212 .31228 L
.54808 .31632 L
.52404 .31858 L
.5 .31932 L
.47596 .31858 L
.45192 .31632 L
.42788 .31228 L
.40942 .30769 L
.40385 .30597 L
.37981 .29612 L
.36118 .28365 L
.35577 .28066 L
.34136 .25962 L
.33477 .23558 L
.33746 .21154 L
.34838 .1875 L
.35577 .17671 L
.36838 .16346 L
.37981 .15371 L
.40191 .13942 L
.40385 .1384 L
.42788 .12783 L
.45192 .12074 L
.47596 .11665 L
.49442 .11538 L
F
0 g
.5 .11531 m
.50558 .11538 L
.52404 .11665 L
.54808 .12074 L
.57212 .12783 L
.59615 .1384 L
.59809 .13942 L
.62019 .15371 L
.63162 .16346 L
.64423 .17671 L
.65162 .1875 L
.66254 .21154 L
.66523 .23558 L
.65864 .25962 L
.64423 .28066 L
.63882 .28365 L
.62019 .29612 L
.59615 .30597 L
.59058 .30769 L
.57212 .31228 L
.54808 .31632 L
.52404 .31858 L
.5 .31932 L
.47596 .31858 L
.45192 .31632 L
.42788 .31228 L
.40942 .30769 L
.40385 .30597 L
.37981 .29612 L
.36118 .28365 L
.35577 .28066 L
.34136 .25962 L
.33477 .23558 L
.33746 .21154 L
.34838 .1875 L
.35577 .17671 L
.36838 .16346 L
.37981 .15371 L
.40191 .13942 L
.40385 .1384 L
.42788 .12783 L
.45192 .12074 L
.47596 .11665 L
.49442 .11538 L
.5 .11531 L
s
.6 g
.42788 .68772 m
.45192 .68368 L
.47596 .68142 L
.5 .68068 L
.52404 .68142 L
.54808 .68368 L
.57212 .68772 L
.59058 .69231 L
.59615 .69403 L
.62019 .70388 L
.63882 .71635 L
.64423 .71934 L
.65864 .74038 L
.66523 .76442 L
.66254 .78846 L
.65162 .8125 L
.64423 .82329 L
.63162 .83654 L
.62019 .84629 L
.59809 .86058 L
.59615 .8616 L
.57212 .87217 L
.54808 .87926 L
.52404 .88335 L
.50558 .88462 L
.5 .88469 L
.49442 .88462 L
.47596 .88335 L
.45192 .87926 L
.42788 .87217 L
.40385 .8616 L
.40191 .86058 L
.37981 .84629 L
.36838 .83654 L
.35577 .82329 L
.34838 .8125 L
.33746 .78846 L
.33477 .76442 L
.34136 .74038 L
.35577 .71934 L
.36118 .71635 L
.37981 .70388 L
.40385 .69403 L
.40942 .69231 L
F
0 g
.42788 .68772 m
.45192 .68368 L
.47596 .68142 L
.5 .68068 L
.52404 .68142 L
.54808 .68368 L
.57212 .68772 L
.59058 .69231 L
.59615 .69403 L
.62019 .70388 L
.63882 .71635 L
.64423 .71934 L
.65864 .74038 L
.66523 .76442 L
.66254 .78846 L
.65162 .8125 L
.64423 .82329 L
.63162 .83654 L
.62019 .84629 L
.59809 .86058 L
.59615 .8616 L
.57212 .87217 L
.54808 .87926 L
.52404 .88335 L
.50558 .88462 L
.5 .88469 L
.49442 .88462 L
.47596 .88335 L
.45192 .87926 L
.42788 .87217 L
.40385 .8616 L
.40191 .86058 L
.37981 .84629 L
.36838 .83654 L
.35577 .82329 L
.34838 .8125 L
.33746 .78846 L
.33477 .76442 L
.34136 .74038 L
.35577 .71934 L
.36118 .71635 L
.37981 .70388 L
.40385 .69403 L
.40942 .69231 L
.42788 .68772 L
s
.5 g
.40385 .44625 m
.42788 .44048 L
.45192 .43684 L
.47596 .4348 L
.5 .43414 L
.52404 .4348 L
.54808 .43684 L
.57212 .44048 L
.59615 .44625 L
.61237 .45192 L
.62019 .45375 L
.64423 .46932 L
.64855 .47596 L
.65811 .5 L
.64855 .52404 L
.64423 .53068 L
.62019 .54625 L
.61237 .54808 L
.59615 .55375 L
.57212 .55952 L
.54808 .56316 L
.52404 .5652 L
.5 .56586 L
.47596 .5652 L
.45192 .56316 L
.42788 .55952 L
.40385 .55375 L
.38763 .54808 L
.37981 .54625 L
.35577 .53068 L
.35145 .52404 L
.34189 .5 L
.35145 .47596 L
.35577 .46932 L
.37981 .45375 L
.38763 .45192 L
F
0 g
.40385 .44625 m
.42788 .44048 L
.45192 .43684 L
.47596 .4348 L
.5 .43414 L
.52404 .4348 L
.54808 .43684 L
.57212 .44048 L
.59615 .44625 L
.61237 .45192 L
.62019 .45375 L
.64423 .46932 L
.64855 .47596 L
.65811 .5 L
.64855 .52404 L
.64423 .53068 L
.62019 .54625 L
.61237 .54808 L
.59615 .55375 L
.57212 .55952 L
.54808 .56316 L
.52404 .5652 L
.5 .56586 L
.47596 .5652 L
.45192 .56316 L
.42788 .55952 L
.40385 .55375 L
.38763 .54808 L
.37981 .54625 L
.35577 .53068 L
.35145 .52404 L
.34189 .5 L
.35145 .47596 L
.35577 .46932 L
.37981 .45375 L
.38763 .45192 L
.40385 .44625 L
s
.7 g
.45192 .1323 m
.47596 .12787 L
.5 .12643 L
.52404 .12787 L
.54808 .1323 L
.57067 .13942 L
.57212 .14004 L
.59615 .15194 L
.61265 .16346 L
.62019 .16975 L
.63548 .1875 L
.64423 .20275 L
.64758 .21154 L
.65052 .23558 L
.64423 .25783 L
.64329 .25962 L
.62096 .28365 L
.62019 .28422 L
.59615 .29732 L
.57212 .30496 L
.56006 .30769 L
.54808 .30965 L
.52404 .31226 L
.5 .31309 L
.47596 .31226 L
.45192 .30965 L
.43994 .30769 L
.42788 .30496 L
.40385 .29732 L
.37981 .28422 L
.37904 .28365 L
.35671 .25962 L
.35577 .25783 L
.34948 .23558 L
.35242 .21154 L
.35577 .20275 L
.36452 .1875 L
.37981 .16975 L
.38735 .16346 L
.40385 .15194 L
.42788 .14004 L
.42933 .13942 L
F
0 g
.45192 .1323 m
.47596 .12787 L
.5 .12643 L
.52404 .12787 L
.54808 .1323 L
.57067 .13942 L
.57212 .14004 L
.59615 .15194 L
.61265 .16346 L
.62019 .16975 L
.63548 .1875 L
.64423 .20275 L
.64758 .21154 L
.65052 .23558 L
.64423 .25783 L
.64329 .25962 L
.62096 .28365 L
.62019 .28422 L
.59615 .29732 L
.57212 .30496 L
.56006 .30769 L
.54808 .30965 L
.52404 .31226 L
.5 .31309 L
.47596 .31226 L
.45192 .30965 L
.43994 .30769 L
.42788 .30496 L
.40385 .29732 L
.37981 .28422 L
.37904 .28365 L
.35671 .25962 L
.35577 .25783 L
.34948 .23558 L
.35242 .21154 L
.35577 .20275 L
.36452 .1875 L
.37981 .16975 L
.38735 .16346 L
.40385 .15194 L
.42788 .14004 L
.42933 .13942 L
.45192 .1323 L
s
.7 g
.45192 .69035 m
.47596 .68774 L
.5 .68691 L
.52404 .68774 L
.54808 .69035 L
.56006 .69231 L
.57212 .69504 L
.59615 .70268 L
.62019 .71578 L
.62096 .71635 L
.64329 .74038 L
.64423 .74217 L
.65052 .76442 L
.64758 .78846 L
.64423 .79725 L
.63548 .8125 L
.62019 .83025 L
.61265 .83654 L
.59615 .84806 L
.57212 .85996 L
.57067 .86058 L
.54808 .8677 L
.52404 .87213 L
.5 .87357 L
.47596 .87213 L
.45192 .8677 L
.42933 .86058 L
.42788 .85996 L
.40385 .84806 L
.38735 .83654 L
.37981 .83025 L
.36452 .8125 L
.35577 .79725 L
.35242 .78846 L
.34948 .76442 L
.35577 .74217 L
.35671 .74038 L
.37904 .71635 L
.37981 .71578 L
.40385 .70268 L
.42788 .69504 L
.43994 .69231 L
F
0 g
.45192 .69035 m
.47596 .68774 L
.5 .68691 L
.52404 .68774 L
.54808 .69035 L
.56006 .69231 L
.57212 .69504 L
.59615 .70268 L
.62019 .71578 L
.62096 .71635 L
.64329 .74038 L
.64423 .74217 L
.65052 .76442 L
.64758 .78846 L
.64423 .79725 L
.63548 .8125 L
.62019 .83025 L
.61265 .83654 L
.59615 .84806 L
.57212 .85996 L
.57067 .86058 L
.54808 .8677 L
.52404 .87213 L
.5 .87357 L
.47596 .87213 L
.45192 .8677 L
.42933 .86058 L
.42788 .85996 L
.40385 .84806 L
.38735 .83654 L
.37981 .83025 L
.36452 .8125 L
.35577 .79725 L
.35242 .78846 L
.34948 .76442 L
.35577 .74217 L
.35671 .74038 L
.37904 .71635 L
.37981 .71578 L
.40385 .70268 L
.42788 .69504 L
.43994 .69231 L
.45192 .69035 L
s
.6 g
.42788 .44864 m
.45192 .44415 L
.47596 .4417 L
.5 .44092 L
.52404 .4417 L
.54808 .44415 L
.57212 .44864 L
.58432 .45192 L
.59615 .45415 L
.62019 .46588 L
.6286 .47596 L
.63955 .5 L
.6286 .52404 L
.62019 .53412 L
.59615 .54585 L
.58432 .54808 L
.57212 .55136 L
.54808 .55585 L
.52404 .5583 L
.5 .55908 L
.47596 .5583 L
.45192 .55585 L
.42788 .55136 L
.41568 .54808 L
.40385 .54585 L
.37981 .53412 L
.3714 .52404 L
.36045 .5 L
.3714 .47596 L
.37981 .46588 L
.40385 .45415 L
.41568 .45192 L
F
0 g
.42788 .44864 m
.45192 .44415 L
.47596 .4417 L
.5 .44092 L
.52404 .4417 L
.54808 .44415 L
.57212 .44864 L
.58432 .45192 L
.59615 .45415 L
.62019 .46588 L
.6286 .47596 L
.63955 .5 L
.6286 .52404 L
.62019 .53412 L
.59615 .54585 L
.58432 .54808 L
.57212 .55136 L
.54808 .55585 L
.52404 .5583 L
.5 .55908 L
.47596 .5583 L
.45192 .55585 L
.42788 .55136 L
.41568 .54808 L
.40385 .54585 L
.37981 .53412 L
.3714 .52404 L
.36045 .5 L
.3714 .47596 L
.37981 .46588 L
.40385 .45415 L
.41568 .45192 L
.42788 .44864 L
s
.8 g
.47596 .13832 m
.5 .13676 L
.52404 .13832 L
.53472 .13942 L
.54808 .14317 L
.57212 .1518 L
.59324 .16346 L
.59615 .16539 L
.61982 .1875 L
.62019 .18797 L
.63335 .21154 L
.63661 .23558 L
.62858 .25962 L
.62019 .27294 L
.60314 .28365 L
.59615 .2877 L
.57212 .29742 L
.54808 .30302 L
.52404 .30602 L
.5 .30697 L
.47596 .30602 L
.45192 .30302 L
.42788 .29742 L
.40385 .2877 L
.39686 .28365 L
.37981 .27294 L
.37142 .25962 L
.36339 .23558 L
.36665 .21154 L
.37981 .18797 L
.38018 .1875 L
.40385 .16539 L
.40676 .16346 L
.42788 .1518 L
.45192 .14317 L
.46528 .13942 L
F
0 g
.47596 .13832 m
.5 .13676 L
.52404 .13832 L
.53472 .13942 L
.54808 .14317 L
.57212 .1518 L
.59324 .16346 L
.59615 .16539 L
.61982 .1875 L
.62019 .18797 L
.63335 .21154 L
.63661 .23558 L
.62858 .25962 L
.62019 .27294 L
.60314 .28365 L
.59615 .2877 L
.57212 .29742 L
.54808 .30302 L
.52404 .30602 L
.5 .30697 L
.47596 .30602 L
.45192 .30302 L
.42788 .29742 L
.40385 .2877 L
.39686 .28365 L
.37981 .27294 L
.37142 .25962 L
.36339 .23558 L
.36665 .21154 L
.37981 .18797 L
.38018 .1875 L
.40385 .16539 L
.40676 .16346 L
.42788 .1518 L
.45192 .14317 L
.46528 .13942 L
.47596 .13832 L
s
.8 g
.40385 .7123 m
.42788 .70258 L
.45192 .69698 L
.47596 .69398 L
.5 .69303 L
.52404 .69398 L
.54808 .69698 L
.57212 .70258 L
.59615 .7123 L
.60314 .71635 L
.62019 .72706 L
.62858 .74038 L
.63661 .76442 L
.63335 .78846 L
.62019 .81203 L
.61982 .8125 L
.59615 .83461 L
.59324 .83654 L
.57212 .8482 L
.54808 .85683 L
.53472 .86058 L
.52404 .86168 L
.5 .86324 L
.47596 .86168 L
.46528 .86058 L
.45192 .85683 L
.42788 .8482 L
.40676 .83654 L
.40385 .83461 L
.38018 .8125 L
.37981 .81203 L
.36665 .78846 L
.36339 .76442 L
.37142 .74038 L
.37981 .72706 L
.39686 .71635 L
F
0 g
.40385 .7123 m
.42788 .70258 L
.45192 .69698 L
.47596 .69398 L
.5 .69303 L
.52404 .69398 L
.54808 .69698 L
.57212 .70258 L
.59615 .7123 L
.60314 .71635 L
.62019 .72706 L
.62858 .74038 L
.63661 .76442 L
.63335 .78846 L
.62019 .81203 L
.61982 .8125 L
.59615 .83461 L
.59324 .83654 L
.57212 .8482 L
.54808 .85683 L
.53472 .86058 L
.52404 .86168 L
.5 .86324 L
.47596 .86168 L
.46528 .86058 L
.45192 .85683 L
.42788 .8482 L
.40676 .83654 L
.40385 .83461 L
.38018 .8125 L
.37981 .81203 L
.36665 .78846 L
.36339 .76442 L
.37142 .74038 L
.37981 .72706 L
.39686 .71635 L
.40385 .7123 L
s
.9 g
.45192 .15376 m
.47596 .14839 L
.5 .14666 L
.52404 .14839 L
.54808 .15376 L
.57194 .16346 L
.57212 .16355 L
.59615 .17938 L
.60417 .1875 L
.61947 .21154 L
.62019 .21355 L
.62309 .23558 L
.62019 .248 L
.61414 .25962 L
.59615 .27912 L
.5845 .28365 L
.57212 .28915 L
.54808 .29609 L
.52404 .29968 L
.5 .3008 L
.47596 .29968 L
.45192 .29609 L
.42788 .28915 L
.4155 .28365 L
.40385 .27912 L
.38586 .25962 L
.37981 .248 L
.37691 .23558 L
.37981 .21355 L
.38053 .21154 L
.39583 .1875 L
.40385 .17938 L
.42788 .16355 L
.42806 .16346 L
F
0 g
.45192 .15376 m
.47596 .14839 L
.5 .14666 L
.52404 .14839 L
.54808 .15376 L
.57194 .16346 L
.57212 .16355 L
.59615 .17938 L
.60417 .1875 L
.61947 .21154 L
.62019 .21355 L
.62309 .23558 L
.62019 .248 L
.61414 .25962 L
.59615 .27912 L
.5845 .28365 L
.57212 .28915 L
.54808 .29609 L
.52404 .29968 L
.5 .3008 L
.47596 .29968 L
.45192 .29609 L
.42788 .28915 L
.4155 .28365 L
.40385 .27912 L
.38586 .25962 L
.37981 .248 L
.37691 .23558 L
.37981 .21355 L
.38053 .21154 L
.39583 .1875 L
.40385 .17938 L
.42788 .16355 L
.42806 .16346 L
.45192 .15376 L
s
.9 g
.42788 .71085 m
.45192 .70391 L
.47596 .70032 L
.5 .6992 L
.52404 .70032 L
.54808 .70391 L
.57212 .71085 L
.5845 .71635 L
.59615 .72088 L
.61414 .74038 L
.62019 .752 L
.62309 .76442 L
.62019 .78645 L
.61947 .78846 L
.60417 .8125 L
.59615 .82062 L
.57212 .83645 L
.57194 .83654 L
.54808 .84624 L
.52404 .85161 L
.5 .85334 L
.47596 .85161 L
.45192 .84624 L
.42806 .83654 L
.42788 .83645 L
.40385 .82062 L
.39583 .8125 L
.38053 .78846 L
.37981 .78645 L
.37691 .76442 L
.37981 .752 L
.38586 .74038 L
.40385 .72088 L
.4155 .71635 L
F
0 g
.42788 .71085 m
.45192 .70391 L
.47596 .70032 L
.5 .6992 L
.52404 .70032 L
.54808 .70391 L
.57212 .71085 L
.5845 .71635 L
.59615 .72088 L
.61414 .74038 L
.62019 .752 L
.62309 .76442 L
.62019 .78645 L
.61947 .78846 L
.60417 .8125 L
.59615 .82062 L
.57212 .83645 L
.57194 .83654 L
.54808 .84624 L
.52404 .85161 L
.5 .85334 L
.47596 .85161 L
.45192 .84624 L
.42806 .83654 L
.42788 .83645 L
.40385 .82062 L
.39583 .8125 L
.38053 .78846 L
.37981 .78645 L
.37691 .76442 L
.37981 .752 L
.38586 .74038 L
.40385 .72088 L
.4155 .71635 L
.42788 .71085 L
s
.7 g
.45192 .45168 m
.47596 .44867 L
.5 .44772 L
.52404 .44867 L
.54808 .45168 L
.54957 .45192 L
.57212 .45492 L
.59615 .46388 L
.6091 .47596 L
.62019 .49174 L
.62179 .5 L
.62019 .50826 L
.6091 .52404 L
.59615 .53612 L
.57212 .54508 L
.54957 .54808 L
.54808 .54832 L
.52404 .55133 L
.5 .55228 L
.47596 .55133 L
.45192 .54832 L
.45043 .54808 L
.42788 .54508 L
.40385 .53612 L
.3909 .52404 L
.37981 .50826 L
.37821 .5 L
.37981 .49174 L
.3909 .47596 L
.40385 .46388 L
.42788 .45492 L
.45043 .45192 L
F
0 g
.45192 .45168 m
.47596 .44867 L
.5 .44772 L
.52404 .44867 L
.54808 .45168 L
.54957 .45192 L
.57212 .45492 L
.59615 .46388 L
.6091 .47596 L
.62019 .49174 L
.62179 .5 L
.62019 .50826 L
.6091 .52404 L
.59615 .53612 L
.57212 .54508 L
.54957 .54808 L
.54808 .54832 L
.52404 .55133 L
.5 .55228 L
.47596 .55133 L
.45192 .54832 L
.45043 .54808 L
.42788 .54508 L
.40385 .53612 L
.3909 .52404 L
.37981 .50826 L
.37821 .5 L
.37981 .49174 L
.3909 .47596 L
.40385 .46388 L
.42788 .45492 L
.45043 .45192 L
.45192 .45168 L
s
1 g
.47596 .15835 m
.5 .15642 L
.52404 .15835 L
.54715 .16346 L
.54808 .16438 L
.57212 .17533 L
.58794 .1875 L
.59615 .19633 L
.60559 .21154 L
.60967 .23558 L
.59947 .25962 L
.59615 .26461 L
.57212 .28139 L
.56363 .28365 L
.54808 .2885 L
.52404 .2929 L
.5 .29425 L
.47596 .2929 L
.45192 .2885 L
.43637 .28365 L
.42788 .28139 L
.40385 .26461 L
.40053 .25962 L
.39033 .23558 L
.39441 .21154 L
.40385 .19633 L
.41206 .1875 L
.42788 .17533 L
.45192 .16438 L
.45285 .16346 L
F
0 g
.47596 .15835 m
.5 .15642 L
.52404 .15835 L
.54715 .16346 L
.54808 .16438 L
.57212 .17533 L
.58794 .1875 L
.59615 .19633 L
.60559 .21154 L
.60967 .23558 L
.59947 .25962 L
.59615 .26461 L
.57212 .28139 L
.56363 .28365 L
.54808 .2885 L
.52404 .2929 L
.5 .29425 L
.47596 .2929 L
.45192 .2885 L
.43637 .28365 L
.42788 .28139 L
.40385 .26461 L
.40053 .25962 L
.39033 .23558 L
.39441 .21154 L
.40385 .19633 L
.41206 .1875 L
.42788 .17533 L
.45192 .16438 L
.45285 .16346 L
.47596 .15835 L
s
1 g
.45192 .7115 m
.47596 .7071 L
.5 .70575 L
.52404 .7071 L
.54808 .7115 L
.56363 .71635 L
.57212 .71861 L
.59615 .73539 L
.59947 .74038 L
.60967 .76442 L
.60559 .78846 L
.59615 .80367 L
.58794 .8125 L
.57212 .82467 L
.54808 .83562 L
.54715 .83654 L
.52404 .84165 L
.5 .84358 L
.47596 .84165 L
.45285 .83654 L
.45192 .83562 L
.42788 .82467 L
.41206 .8125 L
.40385 .80367 L
.39441 .78846 L
.39033 .76442 L
.40053 .74038 L
.40385 .73539 L
.42788 .71861 L
.43637 .71635 L
F
0 g
.45192 .7115 m
.47596 .7071 L
.5 .70575 L
.52404 .7071 L
.54808 .7115 L
.56363 .71635 L
.57212 .71861 L
.59615 .73539 L
.59947 .74038 L
.60967 .76442 L
.60559 .78846 L
.59615 .80367 L
.58794 .8125 L
.57212 .82467 L
.54808 .83562 L
.54715 .83654 L
.52404 .84165 L
.5 .84358 L
.47596 .84165 L
.45285 .83654 L
.45192 .83562 L
.42788 .82467 L
.41206 .8125 L
.40385 .80367 L
.39441 .78846 L
.39033 .76442 L
.40053 .74038 L
.40385 .73539 L
.42788 .71861 L
.43637 .71635 L
.45192 .7115 L
s
.8 g
.42788 .46372 m
.45192 .45665 L
.47596 .45411 L
.5 .45344 L
.52404 .45411 L
.54808 .45665 L
.57212 .46372 L
.58897 .47596 L
.59615 .48247 L
.60412 .5 L
.59615 .51753 L
.58897 .52404 L
.57212 .53628 L
.54808 .54335 L
.52404 .54589 L
.5 .54656 L
.47596 .54589 L
.45192 .54335 L
.42788 .53628 L
.41103 .52404 L
.40385 .51753 L
.39588 .5 L
.40385 .48247 L
.41103 .47596 L
F
0 g
.42788 .46372 m
.45192 .45665 L
.47596 .45411 L
.5 .45344 L
.52404 .45411 L
.54808 .45665 L
.57212 .46372 L
.58897 .47596 L
.59615 .48247 L
.60412 .5 L
.59615 .51753 L
.58897 .52404 L
.57212 .53628 L
.54808 .54335 L
.52404 .54589 L
.5 .54656 L
.47596 .54589 L
.45192 .54335 L
.42788 .53628 L
.41103 .52404 L
.40385 .51753 L
.39588 .5 L
.40385 .48247 L
.41103 .47596 L
.42788 .46372 L
s
.9 g
.45192 .46594 m
.47596 .46045 L
.5 .45905 L
.52404 .46045 L
.54808 .46594 L
.5666 .47596 L
.57212 .47964 L
.5857 .5 L
.57212 .52036 L
.5666 .52404 L
.54808 .53406 L
.52404 .53955 L
.5 .54095 L
.47596 .53955 L
.45192 .53406 L
.4334 .52404 L
.42788 .52036 L
.4143 .5 L
.42788 .47964 L
.4334 .47596 L
F
0 g
.45192 .46594 m
.47596 .46045 L
.5 .45905 L
.52404 .46045 L
.54808 .46594 L
.5666 .47596 L
.57212 .47964 L
.5857 .5 L
.57212 .52036 L
.5666 .52404 L
.54808 .53406 L
.52404 .53955 L
.5 .54095 L
.47596 .53955 L
.45192 .53406 L
.4334 .52404 L
.42788 .52036 L
.4143 .5 L
.42788 .47964 L
.4334 .47596 L
.45192 .46594 L
s
1 g
.47596 .47218 m
.5 .46937 L
.52404 .47218 L
.53981 .47596 L
.54808 .48087 L
.56518 .5 L
.54808 .51913 L
.53981 .52404 L
.52404 .52782 L
.5 .53063 L
.47596 .52782 L
.46019 .52404 L
.45192 .51913 L
.43482 .5 L
.45192 .48087 L
.46019 .47596 L
F
0 g
.47596 .47218 m
.5 .46937 L
.52404 .47218 L
.53981 .47596 L
.54808 .48087 L
.56518 .5 L
.54808 .51913 L
.53981 .52404 L
.52404 .52782 L
.5 .53063 L
.47596 .52782 L
.46019 .52404 L
.45192 .51913 L
.43482 .5 L
.45192 .48087 L
.46019 .47596 L
.47596 .47218 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00C@3oool500000080oooo0P00000e0?ooo`@000000`3oool2000003L0oooo0P0000040?oo
o`800000=`3oool300000080oooo0P00000?0?ooo`00C`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000003D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000g0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0303oool004l0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0b
0?ooo`D0000000D0oooo0000003oool0oooo0000000>0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0380
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000>0?ooo`00C`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0<P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000003D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000e0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003P3oool0
04h0oooo0P0000040?ooo`800000=P3oool2000000@0oooo0P00000g0?ooo`800000103oool20000
03L0oooo0P0000030?ooo`8000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`000005000000L0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo06/0oooo1000000P0?ooo`@00000K@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooofT00000:00I6AUX000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomV000002h06ATII@000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooH`00000d01TI
6F8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooel0
0000?00I6AUN000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooomL000004806ATIF`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3o
oomJ000004H06ATIF@0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooomG
000004`06ATIEP0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080ooooE@00000O01TI6A8000007`0I6AUD000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooomC000001/06ATI1P00000B03<c<`H000006`0I6AUB000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomA000001P06ATI
1@00000N03<c<`D00000600I6AU@000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooom?000001L06ATI0`00000X03<c<`<000005`0I6AU>000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom=000001@06ATI1@00000^
03<c<`D00000500I6AU<000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooom<000001<06ATI0P00000h03<c<`8000004`0I6AU;000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom;000001806ATI0P00000E03<c<a80
00005@0c<c<2000001806ATIBP0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080ooooBP00000A01TI6@8000004@0c<c<600000180C4a<1P00000A03<c<`800000
4P0I6AU8000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oom9000001006ATI0P00000>03<c<`D000007P1<C4`5000000h0<c<c0P00000A01TI6DL000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodL00000400I6AT2
000000d0<c<c0`00000X04a<C0<000003@0c<c<2000001006ATIAP0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`8000000`3ooom6000000l06ATI0P00000<03<c<`<00000301<C4`F0000
00`0C4a<1000000;03<c<`800000400I6AU4000000@0oooo0P0000070?ooo`005@3oool00`000000
oooo0?ooo`020?oood@00000400I6AT00`000000<c<c03<c<`0:03<c<`800000301<C4`3000001H0
IVIV0`00000=04a<C08000002`0c<c<00`0000006ATI01TI6@0>01TI6D<000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oood<000003`0I6AT2000000/0<c<c
0P00000;04a<C0<00000701VIVH3000000`0C4a<0P00000:03<c<`8000003`0I6AU2000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom2000000l06ATI00<0
000003<c<`0c<c<02@0c<c<2000000X0C4a<0`00000>06IVIPH000003P1VIVH3000000/0C4a<00<0
000003<c<`0c<c<02@0c<c<00`0000006ATI01TI6@0=01TI6D4000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?oood4000003`0I6AT00`000000<c<c03<c<`08
03<c<`8000002@1<C4`3000000/0IVIV1P00000607moO`H000002`1VIVH3000000T0C4a<0P00000:
03<c<`030000000I6AT06ATI00d06ATI@00000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo@000000>01TI6@8000002@0c<c<2000000T0C4a<0P00000806IV
IPH000004P1oOgl6000000P0IVIV0P00000904a<C08000002@0c<c<2000000h06ATI?`0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo?`00000>01TI6@03
0000000c<c<0<c<c00L0<c<c0P00000904a<C08000001P1VIVH4000001h0Ogmo1000000606IVIP80
00002@1<C4`2000000T0<c<c00<0000001TI6@0I6AT0300I6ATn000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolo000000d06ATI00<0000003<c<`0c<c<0
200c<c<00`000000C4a<04a<C00504a<C0<000001P1VIVH2000000X0Ogmo4P00000:07moO`800000
1P1VIVH3000000L0C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI6@0<01TI6Cd00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooch000003@0I
6AT00`000000<c<c03<c<`0703<c<`8000001P1<C4`2000000L0IVIV0P00000707moO`D000004P2I
VIT5000000L0Ogmo0P00000706IVIP8000001P1<C4`2000000T0<c<c00<0000001TI6@0I6AT0300I
6ATl000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolm
000000d06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00404a<C08000001P1VIVH3
000000H0Ogmo0`00000;09VIV@H000002`2IVIT3000000H0Ogmo0`00000606IVIP8000001P1<C4`0
0`000000<c<c03<c<`0703<c<`030000000I6AT06ATI00`06ATI>`0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo?000000=01TI6@030000000c<c<0<c<c
00H0<c<c0P00000604a<C0030000001VIVH0IVIV00@0IVIV0P00000707moO`800000202IVIT60000
00H0/k>c1P00000809VIV@8000001`1oOgl2000000H0IVIV00<0000004a<C01<C4`0101<C4`20000
00P0<c<c00<0000001TI6@0I6AT02`0I6ATk000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3oooll000000`06ATI00<0000003<c<`0c<c<01P0c<c<00`000000
C4a<04a<C00404a<C08000001@1VIVH2000000L0Ogmo0P00000509VIV@D000004P2c/k<5000000D0
VIVI0P00000707moO`8000001@1VIVH2000000H0C4a<00<0000003<c<`0c<c<01P0c<c<00`000000
6ATI01TI6@0;01TI6CX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?oooc/00000300I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00@0C4a<
00<0000006IVIP1VIVH00`1VIVH2000000L0Ogmo0P00000409VIV@<000002`2c/k<6000000/0/k>c
0`00000409VIV@8000001`1oOgl2000000D0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c
03<c<`0603<c<`030000000I6AT06ATI00/06ATI>@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`8000000`3ooolj000000`06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<
C00404a<C0030000001VIVH0IVIV00@0IVIV00<0000007moO`1oOgl00`1oOgl3000000@0VIVI0P00
00070;>c/`L000001P3<c<`8000000H0/k>c0P00000409VIV@<000001@1oOgl00`000000IVIV06IV
IP0406IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI
6@0;01TI6CP00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo>@00000<
01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP03
06IVIP800000101oOgl2000000D0VIVI0P0000050;>c/`@000005@3<c<`3000000D0/k>c0P000005
09VIV@800000101oOgl2000000D0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`06
03<c<`030000000I6AT06ATI00X06ATI>00000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo>000000=01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<
C01<C4`0101<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00<0Ogmo00<0000009VI
V@2IVIT00`2IVIT2000000@0/k>c0`0000060<c<c10000001P3<c<`3000000@0/k>c0P00000509VI
V@030000001oOgl0Ogmo00<0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00404a<
C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATg000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolh000000`06ATI00<0000003<c<`0c
<c<01P0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV0P00000407moO`80
0000102IVIT2000000@0/k>c0P0000060<c<c0<00000403Vi^H3000000H0c<c<0P0000040;>c/`80
0000102IVIT2000000@0Ogmo0P00000406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c
<c<01P0c<c<00`0000006ATI01TI6@0:01TI6CL000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooocL00000300I6AT00`000000<c<c03<c<`0603<c<`030000
001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0307moO`030000
002IVIT0VIVI0080VIVI0P0000040;>c/`8000001@3<c<`3000000P0i^KV1P0000080>KViP<00000
1@3<c<`2000000@0/k>c0P00000409VIV@030000001oOgl0Ogmo00<0Ogmo00<0000006IVIP1VIVH0
0P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT0
2P0I6ATf000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolg000000`06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001V
IVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl2000000<0VIVI0P0000040;>c/`800000103<
c<`3000000D0i^KV1P0000060?ooo`H000001@3Vi^H3000000@0c<c<0P0000040;>c/`8000000`2I
VIT2000000@0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c
<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02P0I6ATf000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolf000000`06ATI00<0000003<c<`0c<c<01@0c<c<0
0`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl0
0`000000VIVI09VIV@0209VIV@030000002c/k<0/k>c0080/k>c0P0000040<c<c0800000103Vi^H4
00000180oooo100000040>KViP800000103<c<`2000000@0/k>c00<0000009VIV@2IVIT00P2IVIT0
0`000000Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`0
0`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI=@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=@00000<01TI6@030000000c<c<0<c<c
00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo
0080Ogmo00<0000009VIV@2IVIT00P2IVIT00`000000/k>c0;>c/`030;>c/`040000003<c<`0c<c<
0<c<c0800000103Vi^H2000001X0oooo0P0000040>KViP8000000`3<c<`00`000000/k>c0;>c/`03
0;>c/`030000002IVIT0VIVI0080VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP02
06IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@09
01TI6CD000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ocD00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IV
IP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000@0VIVI00<000000;>c/`2c/k<00`2c/k<0
1@000000c<c<0<c<c03<c<`0000000@0i^KV0P00000N0?ooo`800000103Vi^H010000000c<c<0<c<
c03<c<`2000000@0/k>c00<0000009VIV@2IVIT00P2IVIT01@000000Ogmo07moO`1oOgl0000000@0
IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X0
6ATI=00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
=000000<01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV
06IVIP0206IVIP050000001oOgl0Ogmo07moO`000000102IVIT00`000000/k>c0;>c/`030;>c/`03
0000003<c<`0c<c<008000000`3Vi^H200000280oooo0P0000030>KViP8000000`3<c<`00`000000
/k>c0;>c/`020;>c/`030000002IVIT0VIVI0080VIVI00D0000007moO`1oOgl0Ogmo0000000406IV
IP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI
6C@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc@0
00002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1V
IVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000@0VIVI00<000000;>c/`2c/k<00P2c/k<20000
0080c<c<00<000000>KViP3Vi^H00P3Vi^H00`000000oooo0?ooo`0T0?ooo`030000003Vi^H0i^KV
0080i^KV00D000000<c<c03<c<`0c<c<000000040;>c/`030000002IVIT0VIVI0080VIVI00D00000
07moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c
<c<00`0000006ATI01TI6@0901TI6C<000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oooc<00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0
C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<0
00000;>c/`2c/k<00P2c/k<01@000000c<c<0<c<c03<c<`0000000<0i^KV0P00000X0?ooo`800000
0`3Vi^H200000080c<c<0P0000030;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`000000
IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`000000
6ATI01TI6@0901TI6C<000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo
<`00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV
06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT010000000/k>c0;>c/`2c/k<20000
00<0c<c<00D000000>KViP3Vi^H0i^KV0000000/0?ooo`030000003Vi^H0i^KV0080i^KV00D00000
0<c<c03<c<`0c<c<000000030;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`000000IVIV
06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI
01TI6@0901TI6C800000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo<`00
000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IV
IP0206IVIP050000001oOgl0Ogmo07moO`0000000P2IVIT00`000000/k>c0;>c/`020;>c/`050000
003<c<`0c<c<0<c<c00000000`3Vi^H00`000000oooo0?ooo`0/0?ooo`050000003Vi^H0i^KV0>KV
iP0000000`3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000
000406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI
6@0901TI6C8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?oooc<000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<00000
06IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00D000000;>c/`2c/k<0/k>c
000000040<c<c0050000003Vi^H0i^KV0>KViP000000;P3oool00`000000i^KV0>KViP020>KViP05
0000003<c<`0c<c<0<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00<00000
06IVIP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<00000
01TI6@0I6AT02@0I6ATb000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolc000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<
C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000209VIV@030000002c/k<0
/k>c0080/k>c00D000000<c<c03<c<`0c<c<000000030>KViP030000003oool0oooo02h0oooo00D0
00000>KViP3Vi^H0i^KV000000030<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT01@000000
Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c
<`030000000I6AT06ATI00T06ATI<P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo<`00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<
C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VIV@2IVIT0VIVI00000003
0;>c/`030000003<c<`0c<c<0080c<c<00@000000>KViP3Vi^H00000<P3oool01@000000i^KV0>KV
iP3Vi^H0000000<0c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07mo
O`0000000`1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI
6@0I6AT02@0I6ATb000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolb000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00204a<C003
0000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@050000002c/k<0/k>c
0;>c/`0000000`3<c<`010000000i^KV0>KViP00000c0?ooo`050000003Vi^H0i^KV0>KViP000000
0`3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IV
IP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI
6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc80
00002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1V
IVH0IVIV0000000307moO`050000002IVIT0VIVI09VIV@0000000`2c/k<00`000000c<c<0<c<c002
0<c<c0040000003Vi^H0i^KV000003@0oooo00D000000>KViP3Vi^H0i^KV000000030<c<c0050000
002c/k<0/k>c0;>c/`0000000`2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<
C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<P00000;01TI6@03
0000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH00000
00<0Ogmo00D0000009VIV@2IVIT0VIVI000000030;>c/`030000003<c<`0c<c<008000000P3Vi^H0
0`000000oooo0?ooo`0d0?ooo`030000003Vi^H0i^KV008000000P3<c<`01@000000/k>c0;>c/`2c
/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6C4000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc8000002`0I6AT00`000000<c<c03<c
<`0403<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`050000
002IVIT0VIVI09VIV@0000000`2c/k<010000000c<c<0<c<c00000030>KViP030000003oool0oooo
03@0oooo00D000000>KViP3Vi^H0i^KV000000020<c<c0050000002c/k<0/k>c0;>c/`0000000`2I
VIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c
03<c<`0403<c<`030000000I6AT06ATI00T06ATI<@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo<P00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0
000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00D0000009VIV@2IVIT0
VIVI000000030;>c/`040000003<c<`0c<c<000000<0i^KV00<000000?ooo`3oool0=03oool01@00
0000i^KV0>KViP3Vi^H000000080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001o
Ogl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT02@0I6ATa000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooola000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<
C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@040000
002c/k<0/k>c000000<0c<c<00@000000>KViP3Vi^H00000=`3oool01@000000i^KV0>KViP3Vi^H0
00000080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07moO`000000
101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0
2@0I6ATa000000D0oooo00<000000?ooo`3oool01@3oool000L0oooo1@0000020?ooo`8000001@3o
ool00`000000oooo0?ooo`020?oooc4000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<
C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI
00@000000;>c/`2c/k<000000`3<c<`010000000i^KV0>KViP00000h0?ooo`040000003Vi^H0i^KV
000000<0c<c<00D000000;>c/`2c/k<0/k>c0000000209VIV@050000001oOgl0Ogmo07moO`000000
101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0
2@0I6AT`000000D0oooo00<000000?ooo`3oool01@3oool000T0oooo00D000000?ooo`3oool0oooo
000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooola000000/06ATI
00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV
00D0000007moO`1oOgl0Ogmo0000000309VIV@040000002c/k<0/k>c000000<0c<c<00@000000>KV
iP3Vi^H00000>03oool010000000i^KV0>KViP0000030<c<c0050000002c/k<0/k>c0;>c/`000000
0P2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00`1<C4`00`000000
<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<00000050?ooo`030000003oool0oooo00D0
oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`<0
00000P3ooola000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C003
0000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@040000002c/k<0/k>c
000000<0c<c<00@000000>KViP3Vi^H00000>03oool010000000i^KV0>KViP0000030<c<c0050000
002c/k<0/k>c0;>c/`0000000P2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<
C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<00000030?oo
o`<000001`3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00P3ooola000000/06ATI00<0000003<c<`0c<c<0100c<c<00`00
0000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo00000003
09VIV@040000002c/k<0/k>c000000<0c<c<00@000000>KViP3Vi^H00000=`3oool01@000000i^KV
0>KViP3Vi^H0000000<0c<c<00D000000;>c/`2c/k<0/k>c0000000209VIV@050000001oOgl0Ogmo
07moO`000000101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<00000
01TI6@0I6AT02@0I6AT`000000D0oooo00<000000?ooo`3oool01@3oool000T0oooo00D000000?oo
o`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooola
000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0
IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@050000002c/k<0/k>c0;>c/`000000
0P3<c<`01@000000i^KV0>KViP3Vi^H0000003H0oooo00D000000>KViP3Vi^H0i^KV000000020<c<
c0050000002c/k<0/k>c0;>c/`0000000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0
000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<000
00050?ooo`030000003oool0oooo00D0oooo00080?ooo`800000103oool2000000D0oooo00<00000
0?ooo`3oool00P3ooola000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C002
04a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@050000002c
/k<0/k>c0;>c/`0000000P3<c<`01@000000i^KV0>KViP3Vi^H0000003D0oooo00<000000>KViP3V
i^H00P3Vi^H010000000c<c<0<c<c00000030;>c/`040000002IVIT0VIVI000000<0Ogmo00<00000
06IVIP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<00000
01TI6@0I6AT02@0I6ATa000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolb000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<
C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@040000002c/k<0
/k>c000000<0c<c<00D000000>KViP3Vi^H0i^KV0000000d0?ooo`050000003Vi^H0i^KV0>KViP00
00000`3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo00000004
06IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@09
01TI6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
oc8000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<0080C4a<00<0000006IV
IP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00D000000;>c/`2c/k<0/k>c0000
00020<c<c0050000003Vi^H0i^KV0>KViP000000<`3oool00`000000i^KV0>KViP020>KViP040000
003<c<`0c<c<000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV
0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00T06ATI<@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo<P00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0
000000<0c<c<00D000000>KViP3Vi^H0i^KV0000000b0?ooo`050000003Vi^H0i^KV0>KViP000000
0`3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IV
IP030000001<C4`0C4a<0080C4a<0P00000603<c<`030000000I6AT06ATI00T06ATI<@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<P00000;01TI6@03
0000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH00000
00@0Ogmo00D0000009VIV@2IVIT0VIVI000000030;>c/`050000003<c<`0c<c<0<c<c00000000`3V
i^H00`000000oooo0?ooo`0^0?ooo`050000003Vi^H0i^KV0>KViP0000000`3<c<`01@000000/k>c
0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<
0080C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0801TI6C8000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc<000002`0I6AT00`000000
<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000407mo
O`050000002IVIT0VIVI09VIV@0000000P2c/k<00`000000c<c<0<c<c0020<c<c0050000003Vi^H0
i^KV0>KViP000000;P3oool01@000000i^KV0>KViP3Vi^H0000000@0c<c<00@000000;>c/`2c/k<0
00000`2IVIT00`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`00
0000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI<P0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo<`00000;01TI6@030000000c<c<0<c<c00D0
<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00<0000009VI
V@2IVIT00P2IVIT010000000/k>c0;>c/`0000040<c<c0050000003Vi^H0i^KV0>KViP000000;03o
ool01@000000i^KV0>KViP3Vi^H0000000@0c<c<00@000000;>c/`2c/k<00000102IVIT01@000000
Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0603<c
<`030000000I6AT06ATI00P06ATI<`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo=000000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<
C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00<0000009VIV@2IVIT00P2IVIT00`00
0000/k>c0;>c/`02000000<0c<c<00@000000>KViP3Vi^H0i^KV0P00000X0?ooo`8000000`3Vi^H0
10000000c<c<0<c<c03<c<`200000080/k>c00<0000009VIV@2IVIT00P2IVIT00`000000Ogmo07mo
O`0207moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0503<c<`030000
000I6AT06ATI00T06ATI<`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo=000000<01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<
C4`00`000000IVIV06IVIP0206IVIP8000000`1oOgl00`000000VIVI09VIV@0209VIV@040000002c
/k<0/k>c0;>c/`8000000P3<c<`2000000<0i^KV00<000000?ooo`3oool0903oool010000000i^KV
0>KViP3Vi^H200000080c<c<0P0000030;>c/`030000002IVIT0VIVI0080VIVI00@0000007moO`1o
Ogl0Ogmo0P00000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<01P0c<c<00`00
00006ATI01TI6@0801TI6C@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0
oooo=@00000<01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000
IVIV06IVIP0306IVIP040000001oOgl0Ogmo07moO`8000000`2IVIT00`000000/k>c0;>c/`020;>c
/`040000003<c<`0c<c<0<c<c08000000P3Vi^H4000001h0oooo100000020>KViP8000000`3<c<`0
0`000000/k>c0;>c/`020;>c/`030000002IVIT0VIVI0080VIVI00D0000007moO`1oOgl0Ogmo0000
000506IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI
6@0901TI6C@00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo=P00000<
01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP03
06IVIP030000001oOgl0Ogmo0080Ogmo00@0000009VIV@2IVIT0VIVI0P0000030;>c/`8000000`3<
c<`2000000@0i^KV1000000F0?ooo`@00000103Vi^H2000000<0c<c<0P0000030;>c/`8000000`2I
VIT2000000<0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00304a<C0030000000c
<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATe000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolg000000`06ATI00<0000003<c<`0c<c<0100c<c<0
0`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00P1oOgl2
000000<0VIVI0P0000030;>c/`8000000`3<c<`3000000D0i^KV0`00000@0?ooo`<000001@3Vi^H3
000000<0c<c<0P0000030;>c/`8000000`2IVIT2000000@0Ogmo00<0000006IVIP1VIVH00`1VIVH0
0`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATf
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolg0000
00`06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV
00<0IVIV00<0000007moO`1oOgl00`1oOgl2000000<0VIVI0P0000030;>c/`800000103<c<`60000
0080i^KV400000020>KViPH00000103<c<`2000000<0/k>c0P00000309VIV@8000001@1oOgl00`00
0000IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01P0c<c<00`00
00006ATI01TI6@0901TI6CH000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooocP00000300I6AT00`000000<c<c03<c<`0503<c<`800000101<C4`2000000@0
IVIV0P00000507moO`8000000`2IVIT2000000<0/k>c100000060<c<c0L000001`3Vi^H6000000H0
c<c<100000030;>c/`8000000`2IVIT2000000D0Ogmo0P00000406IVIP800000101<C4`2000000P0
<c<c00<0000001TI6@0I6AT02@0I6ATg000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3oooli000000`06ATI00<0000003<c<`0c<c<01P0c<c<2000000@0C4a<
0P00000406IVIP8000001@1oOgl2000000<0VIVI0`0000040;>c/`H000001`3<c<`7000000H0c<c<
1P0000040;>c/`<000000`2IVIT2000000D0Ogmo0P00000406IVIP800000101<C4`2000000P0<c<c
0P00000;01TI6CP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooocX00000300I6AT2000000P0<c<c00<0000004a<C01<C4`00`1<C4`2000000@0IVIV1000
000307moO`@000000P2IVIT6000000@0/k>c500000040;>c/`H000000P2IVIT4000000<0Ogmo1000
000406IVIP8000001@1<C4`00`000000<c<c03<c<`0603<c<`800000300I6ATi000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolk000000d06ATI00<00000
03<c<`0c<c<01P0c<c<00`000000C4a<04a<C00404a<C08000001P1VIVH3000000@0Ogmo0P000006
09VIV@@00000502c/k<4000000H0VIVI0P00000407moO`<000001P1VIVH2000000H0C4a<00<00000
03<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0;01TI6CX000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooocd00000300I6AT2000000L0<c<c0P00000604a<
C08000001`1VIVH3000000<0Ogmo1000000609VIVA@000001P2IVIT4000000<0Ogmo0`00000706IV
IP8000001P1<C4`2000000L0<c<c0P00000<01TI6C`000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooch000003@0I6AT2000000L0<c<c0P00000604a<C0D0
00001@1VIVH3000000@0Ogmo8000000407moO`<000001@1VIVH5000000H0C4a<0P00000703<c<`80
00003@0I6ATm000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolo000000h06ATI0`00000603<c<`<00000201<C4`5000000<0IVIV2P00000D07moO`X00000
0`1VIVH5000000P0C4a<0`00000603<c<`<000003P0I6ATn000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooom1000000l06ATI0P00000703<c<`<000002P1<
C4`3000000X0IVIV5000000:06IVIP<000002P1<C4`3000000L0<c<c0P00000?01TI6D0000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oood<000003`0I6AT2
000000P0<c<c1000000904a<C0T000005`1VIVH8000000T0C4a<1000000803<c<`8000003`0I6AU2
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?ooodP00000300I6AT60000
00H0<c<c3@00000504a<C1L00000101<C4`=000000H0<c<c1P00000<01TI6DL00000103oool20000
00L0oooo000E0?ooo`030000003oool0oooo0080ooooC@00000=01TI6@L00000300c<c<P000000`0
<c<c1`00000=01TI6D`000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?oooe0000004@0I6AT<00000200<c<c3000000A01TI6Dl000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooe@000006@0I6ATP000001T06ATID`00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooFP000016
01TI6ET000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
of000000>P0I6AUO000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooom]000002006ATIK00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooooi000000@0oooo
0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooofh000007P0I6AU]000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooomP000003X06ATIG`0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooF`00001401TI6EX000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooeH00000600I6ATN000001P0
6ATIE@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
D`00000E01TI6@H000007P0c<c<6000001D06ATIDP0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080ooooC`00000<01TI6@d00000300c<c<B000000`0<c<c3@00
000<01TI6Dh000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooodT000003P0I6AT4000000T0<c<c4000000604a<C0H000001P1<C4`@000000T0<c<c1000000?
01TI6DL000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0ooooA@00000?01TI
6@<000002P0c<c<3000000X0C4a<3000000606IVIP`000002P1<C4`3000000X0<c<c0`00000?01TI
6D@00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo@`00000>01TI6@<0
0000200c<c<5000000L0C4a<1P00000606IVIQ8000001P1VIVH6000000L0C4a<1@00000803<c<`<0
00003P0I6AU2000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooom0000000l06ATI0P00000803<c<`<000001`1<C4`5000000H0IVIV1P00000B07moO`H00000
1P1VIVH5000000L0C4a<0`00000803<c<`8000003`0I6ATo000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3oooln000000l06ATI0P00000803<c<`8000001P1<
C4`4000000D0IVIV1P00000607moOa8000001P1oOgl6000000D0IVIV1000000604a<C0800000200c
<c<2000000l06ATI?@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooo?@00000>01TI6@800000200c<c<2000000D0C4a<0`00000406IVIPD000001P1oOgl6
00000180VIVI1P00000607moO`D00000101VIVH3000000D0C4a<0P00000803<c<`8000003P0I6ATl
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oooll0000
00d06ATI0P00000803<c<`8000001@1<C4`2000000D0IVIV0P00000607moO`D000001P2IVITB0000
00H0VIVI1@00000607moO`8000001@1VIVH2000000D0C4a<0P00000803<c<`8000003@0I6ATk0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolk000000d0
6ATI00<0000003<c<`0c<c<01P0c<c<2000000@0C4a<0`00000306IVIP@000000P1oOgl6000000D0
VIVI7P00000509VIV@H000000P1oOgl4000000<0IVIV0`00000404a<C0800000200c<c<00`000000
6ATI01TI6@0;01TI6CX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooocX00000300I6AT2000000P0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV
06IVIP0206IVIP800000101oOgl2000000H0VIVI1@0000000`2c/k<000000000000300000180c<c<
1@0000000`2c/k<0000000000003000000H0VIVI0P00000407moO`800000101VIVH00`000000C4a<
04a<C00304a<C0030000000c<c<0<c<c00H0<c<c0P00000<01TI6CT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocP000003@0I6AT00`000000<c<c03<c
<`0703<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07mo
O`0207moO`8000001@2IVIT3000000<0/k>c0`0000050<c<c18000001@3<c<`3000000<0/k>c0`00
000509VIV@800000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0
000003<c<`0c<c<01`0c<c<2000000`06ATI=`0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo>000000<01TI6@030000000c<c<0<c<c00H0<c<c0P000004
04a<C08000000`1VIVH2000000<0Ogmo0P00000509VIV@800000102c/k<2000000@0c<c<1000000B
0>KViP@00000103<c<`2000000@0/k>c0P00000509VIV@8000000`1oOgl2000000<0IVIV0P000004
04a<C0800000200c<c<00`0000006ATI01TI6@0:01TI6CL000001@3oool00`000000oooo0?ooo`05
0?ooo`001`3oool4000000<0oooo0P0000050?ooo`030000003oool0oooo0080oooo=`00000<01TI
6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IV
IP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT0102IVIT00`000000/k>c0;>c/`030;>c
/`030000003<c<`0c<c<0080c<c<0P00000:0>KViPH000002P3Vi^H2000000@0c<c<0P0000040;>c
/`030000002IVIT0VIVI00@0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IV
IP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0:01TI
6CH000001@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`030?ooo`04
0000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3ooolg000000`06ATI00<0000003<c
<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007mo
O`1oOgl00`1oOgl00`000000VIVI09VIV@0209VIV@800000102c/k<2000000<0c<c<0P0000070>KV
iPD000001P3oool5000000L0i^KV0P0000040<c<c08000000`2c/k<2000000@0VIVI00<0000007mo
O`1oOgl00P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c
<`0c<c<01@0c<c<00`0000006ATI01TI6@0:01TI6CH000001@3oool00`000000oooo0?ooo`050?oo
o`00203oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo0`0000020?oo
ocH00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IV
IP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI0080VIVI00<000000;>c
/`2c/k<00`2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV00@0i^KV0`00000@0?oo
o`<000001P3Vi^H00`000000c<c<0<c<c0030<c<c0030000002c/k<0/k>c0080/k>c00<0000009VI
V@2IVIT00P2IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV00<0IVIV00<0000004a<
C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI=@0000030?oo
o`<000001`3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool00P3ooolf000000`06ATI00<0000003<c<`0c<c<01@0c<c<00`00
0000C4a<04a<C00304a<C0030000001VIVH0IVIV00<0IVIV00D0000007moO`1oOgl0Ogmo00000004
09VIV@030000002c/k<0/k>c00<0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP03
0>KViP8000005P3oool2000000D0i^KV00<000000<c<c03<c<`00P3<c<`00`000000/k>c0;>c/`03
0;>c/`050000002IVIT0VIVI09VIV@000000101oOgl00`000000IVIV06IVIP0306IVIP030000001<
C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0:01TI6CD000001@3o
ool00`000000oooo0?ooo`050?ooo`001`3oool010000000oooo0?ooo`0000020?ooo`040000003o
ool0oooo000000@0oooo00<000000?ooo`3oool00P3ooolf000000/06ATI00<0000003<c<`0c<c<0
1@0c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl0
0P1oOgl01@000000VIVI09VIV@2IVIT0000000D0/k>c00<000000<c<c03<c<`00P3<c<`00`000000
i^KV0>KViP030>KViP030000003oool0oooo01P0oooo00<000000>KViP3Vi^H00`3Vi^H00`000000
c<c<0<c<c0020<c<c0030000002c/k<0/k>c0080/k>c00<0000009VIV@2IVIT00P2IVIT00`000000
Ogmo07moO`0207moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<C4`00`000000
<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI=@0000050?ooo`030000003oool0oooo00D0
oooo00080?ooo`800000103oool2000000D0oooo00<000000?ooo`3oool00P3ooole000000`06ATI
00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00<0IVIV
00D0000007moO`1oOgl0Ogmo0000000409VIV@030000002c/k<0/k>c0080/k>c00<000000<c<c03<
c<`00P3<c<`00`000000i^KV0>KViP030>KViP030000003oool0oooo01X0oooo00<000000>KViP3V
i^H00`3Vi^H00`000000c<c<0<c<c0020<c<c0030000002c/k<0/k>c0080/k>c00D0000009VIV@2I
VIT0VIVI0000000407moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<C4`00`00
0000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI=@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo=@00000<01TI6@030000000c<c<0<c<c00D0
<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP050000001oOgl0Ogmo07mo
O`0000000`2IVIT00`000000/k>c0;>c/`030;>c/`030000003<c<`0c<c<0080c<c<00<000000>KV
iP3Vi^H00`3Vi^H00`000000oooo0?ooo`0J0?ooo`030000003Vi^H0i^KV00<0i^KV00<000000<c<
c03<c<`00P3<c<`00`000000/k>c0;>c/`030;>c/`050000002IVIT0VIVI09VIV@000000101oOgl0
0`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<0
0`0000006ATI01TI6@0:01TI6C@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooocD000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<
00<0C4a<00<0000006IVIP1VIVH00`1VIVH01@000000Ogmo07moO`1oOgl0000000@0VIVI00<00000
0;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV00<0i^KV00<00000
0?ooo`3oool0703oool00`000000i^KV0>KViP030>KViP030000003<c<`0c<c<0080c<c<00<00000
0;>c/`2c/k<00P2c/k<01@000000VIVI09VIV@2IVIT0000000@0Ogmo00<0000006IVIP1VIVH00`1V
IVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I
6ATd000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooole
000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0
IVIV00<0IVIV00D0000007moO`1oOgl0Ogmo0000000409VIV@030000002c/k<0/k>c0080/k>c00D0
00000<c<c03<c<`0c<c<000000050>KViP030000003oool0oooo01h0oooo00<000000>KViP3Vi^H0
0`3Vi^H00`000000c<c<0<c<c0020<c<c0050000002c/k<0/k>c0;>c/`000000102IVIT00`000000
Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000
<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI=00000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo=@00000;01TI6@030000000c<c<0<c<c00D0<c<c
00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP050000001oOgl0Ogmo07moO`00
0000102IVIT00`000000/k>c0;>c/`020;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3V
i^H00`3Vi^H00`000000oooo0?ooo`0L0?ooo`030000003Vi^H0i^KV00<0i^KV00<000000<c<c03<
c<`00P3<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@000000101oOgl00`00
0000IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`00
00006ATI01TI6@0901TI6C@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooocD00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0
C4a<00<0000006IVIP1VIVH00`1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c
/`2c/k<00`2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV00<0i^KV00<000000?oo
o`3oool06P3oool00`000000i^KV0>KViP030>KViP030000003<c<`0c<c<00<0c<c<00<000000;>c
/`2c/k<00P2c/k<01@000000VIVI09VIV@2IVIT0000000@0Ogmo00<0000006IVIP1VIVH00P1VIVH0
0`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02P0I6ATd
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooole0000
00`06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV
00<0IVIV00D0000007moO`1oOgl0Ogmo0000000409VIV@030000002c/k<0/k>c0080/k>c00<00000
0<c<c03<c<`00P3<c<`00`000000i^KV0>KViP030>KViP030000003oool0oooo01X0oooo00<00000
0>KViP3Vi^H00`3Vi^H00`000000c<c<0<c<c0020<c<c0030000002c/k<0/k>c0080/k>c00D00000
09VIV@2IVIT0VIVI0000000407moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<
C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI=@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=P00000;01TI6@030000000c<c<0
<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0
Ogmo0080Ogmo00D0000009VIV@2IVIT0VIVI000000050;>c/`030000003<c<`0c<c<0080c<c<00<0
00000>KViP3Vi^H00`3Vi^H00`000000oooo0?ooo`0H0?ooo`030000003Vi^H0i^KV00<0i^KV00<0
00000<c<c03<c<`00`3<c<`01@000000/k>c0;>c/`2c/k<0000000@0VIVI00<0000007moO`1oOgl0
0P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0
1@0c<c<00`0000006ATI01TI6@0901TI6CD000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooocH00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<
C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH01@000000Ogmo07moO`1oOgl0000000@0VIVI
00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0030<c<c0030000003Vi^H0i^KV00<0i^KV
00<000000?ooo`3oool05P3oool00`000000i^KV0>KViP030>KViP030000003<c<`0c<c<00<0c<c<
00<000000;>c/`2c/k<00P2c/k<01@000000VIVI09VIV@2IVIT0000000@0Ogmo00<0000006IVIP1V
IVH00`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I
6AT02P0I6ATe000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?ooocH00000
300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH0
0P1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<0
0P2c/k<2000000@0c<c<00<000000>KViP3Vi^H00`3Vi^H300000180oooo0`0000050>KViP030000
003<c<`0c<c<00<0c<c<00<000000;>c/`2c/k<00P2c/k<00`000000VIVI09VIV@0209VIV@030000
001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00304a<C0030000
000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02P0I6ATe000000@0oooo0P0000070?ooo`005@3o
ool00`000000oooo0?ooo`020?ooocH000003@0I6AT00`000000<c<c03<c<`0403<c<`030000001<
C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0307moO`030000002I
VIT0VIVI0080VIVI00<000000;>c/`2c/k<00`2c/k<00`000000c<c<0<c<c0020<c<c08000001P3V
i^H6000000L0oooo1@0000060>KViP8000001@3<c<`00`000000/k>c0;>c/`020;>c/`030000002I
VIT0VIVI0080VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0306IVIP030000001<
C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0901TI6CH000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocL00000300I6AT0
0`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00P1VIVH0
0`000000Ogmo07moO`0207moO`030000002IVIT0VIVI00<0VIVI00<000000;>c/`2c/k<00`2c/k<0
0`000000c<c<0<c<c0030<c<c08000002P3Vi^H7000000T0i^KV0P0000050<c<c0800000102c/k<0
0`000000VIVI09VIV@0309VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH00P1VIVH0
0`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02P0I6ATf
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolg0000
00d06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV
0080IVIV0P00000307moO`800000102IVIT00`000000/k>c0;>c/`030;>c/`030000003<c<`0c<c<
00@0c<c<0`00000D0>KViP<000001P3<c<`00`000000/k>c0;>c/`030;>c/`030000002IVIT0VIVI
0080VIVI0P00000307moO`800000101VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c
00H0<c<c00<0000001TI6@0I6AT02@0I6ATg000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolh000000`06ATI00<0000003<c<`0c<c<01P0c<c<00`000000
C4a<04a<C00404a<C0800000101VIVH00`000000Ogmo07moO`0207moO`8000000`2IVIT2000000@0
/k>c0`0000060<c<c0L000001`3Vi^H6000000H0c<c<0`0000040;>c/`8000000`2IVIT2000000@0
Ogmo00<0000006IVIP1VIVH00P1VIVH2000000H0C4a<00<0000003<c<`0c<c<01P0c<c<00`000000
6ATI01TI6@0:01TI6CL000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooocP000003@0I6AT00`000000<c<c03<c<`0603<c<`8000001P1<C4`00`000000IVIV
06IVIP0206IVIP800000101oOgl2000000<0VIVI0`0000040;>c/`H000001`3<c<`7000000H0c<c<
1P0000040;>c/`<000000`2IVIT2000000@0Ogmo0P00000406IVIP030000001<C4`0C4a<00@0C4a<
0P00000903<c<`030000000I6AT06ATI00T06ATI>00000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo>@00000=01TI6@800000200c<c<00`000000C4a<04a<
C00404a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00`1oOgl3000000<0VIVI1000
00060;>c/a@000001P2c/k<4000000<0VIVI0`00000507moO`030000001VIVH0IVIV00<0IVIV00<0
000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0703<c<`800000300I6ATh000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolk000000d06ATI00<00000
03<c<`0c<c<01P0c<c<00`000000C4a<04a<C00404a<C0800000101VIVH4000000@0Ogmo0`000004
09VIV@H00000502c/k<6000000@0VIVI0`00000407moO`@00000101VIVH2000000H0C4a<00<00000
03<c<`0c<c<01P0c<c<2000000`06ATI>P0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo?000000=01TI6@8000001`0c<c<2000000H0C4a<0P00000606IV
IP@000000`1oOgl4000000H0VIVI5000000609VIV@@000000`1oOgl4000000H0IVIV0P00000604a<
C08000001`0c<c<2000000d06ATI>`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo?P00000=01TI6@8000001`0c<c<2000000H0C4a<0`00000706IVIP<0
0000101oOgl=000000L0VIVI3000000407moO`<000001`1VIVH3000000H0C4a<0P00000703<c<`80
00003@0I6ATm000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolo000000h06ATI0`00000603<c<`<000001P1<C4`4000000H0IVIV1000000=07moO`L00000
301oOgl4000000H0IVIV1000000604a<C0<000001P0c<c<3000000h06ATI?P0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo@@00000?01TI6@8000001`0c
<c<3000000L0C4a<1000000606IVIR0000001P1VIVH4000000L0C4a<0`00000703<c<`8000003`0I
6AU0000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom3
000000l06ATI0P00000803<c<`@000001`1<C4`600000200IVIV1P00000704a<C0@00000200c<c<2
000000l06ATI@P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooom80000
00`06ATI1P00000603<c<cX000001P0c<c<6000000`06ATIA`0000040?ooo`8000001`3oool001D0
oooo00<000000?ooo`3oool00P3ooom=000000d06ATI1`00000<03<c<b000000300c<c<7000000d0
6ATIC00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
D000000A01TI6@H00000;00c<c<6000001406ATIC`0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080ooooE000000C01TI6A<000001`0c<c<B000001<06ATID`00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooFP00000P
01TI6@L000007`0I6AUI000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooomP000003X06ATIG`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080ooooI`00000/01TI6FH000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo
n@0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooomj000000H06ATIN@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooI000000b01TI6F<000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooe/00000A00I6AUJ0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooomF000001h0
6ATI4P00000N01TI6ED000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?oooe<000005@0I6AT<00000180<c<c3000000E01TI6E8000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodl000004P0I6AT700000180<c<c1P00
000B03<c<`L000004P0I6AU>000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooom:000001406ATI1P00000703<c<a8000001P1<C4`B000000L0<c<c1P00000A
01TI6DT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0ooooA`00000=01TI
6@L000001@0c<c<8000000H0C4a<7P00000604a<C0P000001@0c<c<7000000h06ATIA@0000040?oo
o`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooom4000000d06ATI0`00000803<c<`@0
0000201<C4`6000000H0IVIV4P00000606IVIPH00000201<C4`4000000P0<c<c0`00000=01TI6D<0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oood800000
3@0I6AT2000000P0<c<c0`00000704a<C0D000001P1VIVH600000180Ogmo1P00000606IVIPD00000
1`1<C4`3000000P0<c<c0P00000=01TI6D4000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oood0000003@0I6AT2000000P0<c<c0P00000604a<C0@000001@1V
IVH6000000H0Ogmo4P00000607moO`H000001@1VIVH4000000H0C4a<0P00000803<c<`8000003@0I
6ATo000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oooln
000000d06ATI0P00000803<c<`8000001@1<C4`3000000@0IVIV1@00000607moO`H000004P2IVIT6
000000H0Ogmo1@00000406IVIP<000001@1<C4`2000000P0<c<c0P00000=01TI6Cd000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc`000003@0I6AT20000
00P0<c<c0P00000404a<C0<00000101VIVH3000000D0Ogmo1P00000609VIVA8000001P2IVIT60000
00D0Ogmo0`00000406IVIP<00000101<C4`2000000P0<c<c0P00000=01TI6C/000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocX000003@0I6AT2000000L0
<c<c0`00000404a<C0800000101VIVH3000000<0Ogmo1@00000409VIVB800000102IVIT5000000<0
Ogmo0`00000406IVIP800000101<C4`3000000L0<c<c0P00000=01TI6CT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocT000003@0I6AT00`000000<c<c
03<c<`0603<c<`030000001<C4`0C4a<00<0C4a<0P00000406IVIP800000101oOgl2000000H0VIVI
0`0000030;>c/`D000004P3<c<`5000000<0/k>c0`00000609VIV@800000101oOgl2000000@0IVIV
0P00000504a<C0030000000c<c<0<c<c00H0<c<c0P00000<01TI6CP000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocP000003@0I6AT00`000000<c<c03<c
<`0503<c<`8000001@1<C4`00`000000IVIV06IVIP0206IVIP800000101oOgl2000000D0VIVI0`00
00030;>c/`<000001@3<c<`B000000D0c<c<0`0000030;>c/`<000001@2IVIT2000000@0Ogmo0P00
000406IVIP030000001<C4`0C4a<00<0C4a<0P00000803<c<`030000000I6AT06ATI00X06ATI=`00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=`00000=
01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`2000000<0IVIV0P000004
07moO`800000102IVIT3000000<0/k>c0`0000030<c<c0D000001P3Vi^H6000000H0i^KV1@000003
0<c<c0<000000`2c/k<3000000@0VIVI0P00000407moO`8000000`1VIVH2000000D0C4a<00<00000
03<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0:01TI6CH000001@3oool00`000000oooo0?ooo`05
0?ooo`00203oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo=`00000<01TI
6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IV
IP030000001oOgl0Ogmo00<0Ogmo00<0000009VIV@2IVIT00P2IVIT2000000<0/k>c0`0000030<c<
c0<000001@3Vi^H6000000H0oooo1P0000050>KViP<000000`3<c<`3000000<0/k>c0P00000409VI
V@800000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c
<`0c<c<01P0c<c<00`0000006ATI01TI6@0901TI6CH000001@3oool00`000000oooo0?ooo`050?oo
o`001`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<00000
0?ooo`3oool00P3ooolf000000`06ATI00<0000003<c<`0c<c<0100c<c<2000000@0C4a<0P000004
06IVIP030000001oOgl0Ogmo0080Ogmo0P00000309VIV@8000000`2c/k<2000000<0c<c<0`000003
0>KViPD000004P3oool5000000<0i^KV0`0000030<c<c08000000`2c/k<2000000@0VIVI0P000003
07moO`030000001VIVH0IVIV0080IVIV0P00000404a<C08000001`0c<c<00`0000006ATI01TI6@09
01TI6CD000001@3oool00`000000oooo0?ooo`050?ooo`002@3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00P3oool300000080oooo=@00000<01TI6@030000000c<c<0
<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0
Ogmo0080Ogmo00@0000009VIV@2IVIT0VIVI0P0000030;>c/`8000000P3<c<`3000000<0i^KV0`00
000L0?ooo`<000000`3Vi^H300000080c<c<0P0000030;>c/`800000102IVIT01@000000Ogmo07mo
O`1oOgl0000000D0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000
000I6AT06ATI00T06ATI=00000030?ooo`<000001`3oool000X0oooo00@000000?ooo`3oool00000
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo=000000<01TI6@030000
000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP040000
001oOgl0Ogmo07moO`8000000`2IVIT010000000/k>c0;>c/`2c/k<200000080c<c<0P0000040>KV
iP8000008P3oool2000000@0i^KV0P0000020<c<c08000000`2c/k<00`000000VIVI09VIV@0209VI
V@050000001oOgl0Ogmo07moO`0000001@1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0
<c<c00H0<c<c00<0000001TI6@0I6AT0200I6ATd000000D0oooo00<000000?ooo`3oool01@3oool0
00L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0080oooo=000000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<
C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`000000102IVIT00`000000/k>c
0;>c/`02000000<0c<c<00<000000>KViP3Vi^H00P3Vi^H2000002H0oooo0P0000040>KViP040000
003<c<`0c<c<0<c<c08000000P2c/k<00`000000VIVI09VIV@0209VIV@050000001oOgl0Ogmo07mo
O`000000101VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI
6@0I6AT02@0I6ATc000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`020?oooc<000002`0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl00000
00@0VIVI00@000000;>c/`2c/k<00000103<c<`00`000000i^KV0>KViP020>KViP030000003oool0
oooo02P0oooo00<000000>KViP3Vi^H00P3Vi^H00`000000c<c<0<c<c0020<c<c0040000002c/k<0
/k>c000000@0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0801TI6C<000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc<000002`0I6AT00`000000<c<c03<c
<`0503<c<`030000001<C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`050000
002IVIT0VIVI09VIV@0000000P2c/k<00`000000c<c<0<c<c0020<c<c0040000003Vi^H0i^KV0>KV
iP800000;03oool2000000<0i^KV00<000000<c<c03<c<`00P3<c<`010000000/k>c0;>c/`000003
09VIV@030000001oOgl0Ogmo0080Ogmo00D0000006IVIP1VIVH0IVIV0000000504a<C0030000000c
<c<0<c<c00D0<c<c00<0000001TI6@0I6AT02@0I6ATb000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolb000000/06ATI00<0000003<c<`0c<c<01@0c<c<0
0`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000
000309VIV@050000002c/k<0/k>c0;>c/`0000000`3<c<`01@000000i^KV0>KViP3Vi^H000000300
oooo00D000000>KViP3Vi^H0i^KV000000030<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT0
1@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c
<`0603<c<`030000000I6AT06ATI00P06ATI<P0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo<P00000;01TI6@030000000c<c<0<c<c00D0<c<c00<00000
04a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2I
VIT01@000000/k>c0;>c/`2c/k<0000000<0c<c<00D000000>KViP3Vi^H0i^KV0000000b0?ooo`05
0000003Vi^H0i^KV0>KViP0000000`3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D00000
07moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<01@0c
<c<00`0000006ATI01TI6@0901TI6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oooc8000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0
C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00D0
00000;>c/`2c/k<0/k>c000000020<c<c0030000003Vi^H0i^KV0080i^KV00<000000?ooo`3oool0
<03oool00`000000i^KV0>KViP020>KViP040000003<c<`0c<c<000000<0/k>c00D0000009VIV@2I
VIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`00
0000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI<@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo<P00000;01TI6@030000000c<c<0<c<c00D0
<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07mo
O`0000000`2IVIT010000000/k>c0;>c/`0000030<c<c0050000003Vi^H0i^KV0>KViP000000=03o
ool01@000000i^KV0>KViP3Vi^H0000000<0c<c<00@000000;>c/`2c/k<000000`2IVIT01@000000
Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c
<`030000000I6AT06ATI00T06ATI<@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo<P00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<
C4`00`1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01000
0000/k>c0;>c/`0000020<c<c0030000003Vi^H0i^KV0080i^KV00<000000?ooo`3oool0<P3oool0
0`000000i^KV0>KViP020>KViP040000003<c<`0c<c<000000<0/k>c00@0000009VIV@2IVIT00000
0`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0
100c<c<00`0000006ATI01TI6@0901TI6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooc4000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<
C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI
00D000000;>c/`2c/k<0/k>c000000020<c<c0050000003Vi^H0i^KV0>KViP000000=P3oool01@00
0000i^KV0>KViP3Vi^H000000080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001o
Ogl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00D0<c<c
00<0000001TI6@0I6AT02@0I6AT`000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooola000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<
C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@050000
002c/k<0/k>c0;>c/`0000000P3<c<`01@000000i^KV0>KViP3Vi^H0000003H0oooo00D000000>KV
iP3Vi^H0i^KV000000020<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT01@000000Ogmo07mo
O`1oOgl0000000@0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000
000I6AT06ATI00T06ATI<00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo<@00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<
C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT010000000/k>c
0;>c/`0000030<c<c0040000003Vi^H0i^KV000003P0oooo00@000000>KViP3Vi^H000000`3<c<`0
1@000000/k>c0;>c/`2c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000
001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6C000000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo<@00000;01TI6@030000000c
<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP050000001o
Ogl0Ogmo07moO`0000000`2IVIT010000000/k>c0;>c/`0000030<c<c0040000003Vi^H0i^KV0000
03P0oooo00@000000>KViP3Vi^H000000`3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00D0
000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0
100c<c<00`0000006ATI01TI6@0901TI6C000000103oool2000000L0oooo000E0?ooo`030000003o
ool0oooo0080oooo<@00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<
C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT010000000/k>c
0;>c/`0000030<c<c0040000003Vi^H0i^KV000003P0oooo00@000000>KViP3Vi^H000000`3<c<`0
1@000000/k>c0;>c/`2c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000
001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6C000000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc4000002`0I
6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1V
IVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00@000000;>c/`2c/k<000000`3<c<`010000000
i^KV0>KViP00000h0?ooo`040000003Vi^H0i^KV000000<0c<c<00D000000;>c/`2c/k<0/k>c0000
000209VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00304a<C0030000
000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT`000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooola000000/06ATI00<0000003<c<`0c<c<0100c
<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo
0000000309VIV@040000002c/k<0/k>c000000<0c<c<00@000000>KViP3Vi^H00000=`3oool01@00
0000i^KV0>KViP3Vi^H000000080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001o
Ogl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT02@0I6ATa000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooolb000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<
C00304a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl01@000000VIVI09VIV@2IVIT0000000<0
/k>c00@000000<c<c03<c<`000000`3Vi^H00`000000oooo0?ooo`0d0?ooo`050000003Vi^H0i^KV
0>KViP0000000P3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo
0000000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI
01TI6@0901TI6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooc8000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00D0
000006IVIP1VIVH0IVIV0000000307moO`050000002IVIT0VIVI09VIV@0000000`2c/k<010000000
c<c<0<c<c00000030>KViP030000003oool0oooo03@0oooo00D000000>KViP3Vi^H0i^KV00000002
0<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV
00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI
<@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<P00
000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IV
IP1VIVH0000000<0Ogmo00D0000009VIV@2IVIT0VIVI000000030;>c/`050000003<c<`0c<c<0<c<
c00000000P3Vi^H00`000000oooo0?ooo`0d0?ooo`040000003Vi^H0i^KV000000<0c<c<00D00000
0;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<
04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATa000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolb000000/06ATI00<0
000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0IVIV06IVIP000000
0`1oOgl01@000000VIVI09VIV@2IVIT0000000<0/k>c00<000000<c<c03<c<`00P3<c<`010000000
i^KV0>KViP00000d0?ooo`040000003Vi^H0i^KV000000<0c<c<00D000000;>c/`2c/k<0/k>c0000
000309VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00304a<C0030000
000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATa000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooolb000000/06ATI00<0000003<c<`0c<c<01@0c
<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo
0000000309VIV@050000002c/k<0/k>c0;>c/`0000000`3<c<`010000000i^KV0>KViP00000c0?oo
o`050000003Vi^H0i^KV0>KViP0000000`3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0
000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0
100c<c<00`0000006ATI01TI6@0901TI6C4000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooc<000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<
C4`0C4a<00<0C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`050000002IVIT0VIVI09VIV@00
00000`2c/k<00`000000c<c<0<c<c0020<c<c0040000003Vi^H0i^KV00000380oooo00@000000>KV
iP3Vi^H000000`3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo
0000000406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI
01TI6@0901TI6C8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooc<000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0
000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00D000000;>c/`2c/k<0
/k>c000000040<c<c0040000003Vi^H0i^KV00000300oooo00D000000>KViP3Vi^H0i^KV00000003
0<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV
00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI
<P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo<`00
000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IV
IP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0000000@0
c<c<00D000000>KViP3Vi^H0i^KV0000000^0?ooo`050000003Vi^H0i^KV0>KViP0000000`3<c<`0
1@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000
001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6C800000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo<`00000;01TI6@030000000c
<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP050000001o
Ogl0Ogmo07moO`0000000`2IVIT010000000/k>c0;>c/`2c/k<2000000<0c<c<00D000000>KViP3V
i^H0i^KV0000000/0?ooo`030000003Vi^H0i^KV0080i^KV00D000000<c<c03<c<`0c<c<00000003
0;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<
C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6C800000103o
ool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo<`00000<01TI6@030000000c<c<0
<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0
Ogmo07moO`0000000`2IVIT00`000000/k>c0;>c/`020;>c/`050000003<c<`0c<c<0<c<c0000000
0`3Vi^H00`000000oooo0?ooo`0X0?ooo`040000003Vi^H0i^KV0>KViP8000000`3<c<`01@000000
/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP030000001<C4`0
C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6C<000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc@000002`0I6AT00`00
0000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH01@00
0000Ogmo07moO`1oOgl0000000@0VIVI00<000000;>c/`2c/k<00P2c/k<01@000000c<c<0<c<c03<
c<`0000000<0i^KV0P00000V0?ooo`8000000`3Vi^H00`000000c<c<0<c<c0020<c<c0050000002c
/k<0/k>c0;>c/`000000102IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00<0000004a<C01<
C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI<`0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=000000<01TI6@030000
000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP050000
001oOgl0Ogmo07moO`0000000`2IVIT00`000000/k>c0;>c/`030;>c/`040000003<c<`0c<c<0<c<
c08000000`3Vi^H00`000000oooo0?ooo`0R0?ooo`040000003Vi^H0i^KV0>KViP8000000`3<c<`2
000000@0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0
000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI=000
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=@00000<
01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP02
06IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT00`000000/k>c0;>c/`030;>c/`030000003<
c<`0c<c<0080c<c<00@000000>KViP3Vi^H0i^KV0P00000P0?ooo`8000000`3Vi^H00`000000c<c<
0<c<c0020<c<c0030000002c/k<0/k>c00<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`03
0000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`03
0000000I6AT06ATI00X06ATI=00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo=@00000<01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0
0`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00D0000009VIV@2IVIT0
VIVI000000050;>c/`030000003<c<`0c<c<0080c<c<0P0000030>KViP800000703oool2000000<0
i^KV0P0000040<c<c0030000002c/k<0/k>c00<0/k>c00D0000009VIV@2IVIT0VIVI0000000407mo
O`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c
<`030000000I6AT06ATI00T06ATI=@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo=P00000<01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<
C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00@0000009VIV@2I
VIT0VIVI0P0000040;>c/`030000003<c<`0c<c<00<0c<c<00<000000>KViP3Vi^H00P3Vi^H30000
01H0oooo0`0000040>KViP030000003<c<`0c<c<00<0c<c<00<000000;>c/`2c/k<00P2c/k<20000
00<0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<
00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0:01TI6CD000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocH000003@0I6AT00`000000
<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000
Ogmo07moO`0207moO`030000002IVIT0VIVI0080VIVI0P0000030;>c/`800000103<c<`2000000D0
i^KV0`00000@0?ooo`<000001@3Vi^H2000000@0c<c<0P0000030;>c/`800000102IVIT00`000000
Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000
<c<c03<c<`0603<c<`030000000I6AT06ATI00T06ATI=P0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo=`00000<01TI6@030000000c<c<0<c<c00D0<c<c
00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo0080Ogmo
00<0000009VIV@2IVIT00`2IVIT2000000<0/k>c0P0000040<c<c08000001P3Vi^H@000000H0i^KV
0P0000040<c<c08000000`2c/k<2000000D0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV
06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI
01TI6@0:01TI6CH000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooocL000003@0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0
000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI00@0VIVI00<0
00000;>c/`2c/k<00P2c/k<2000000@0c<c<1000000D0>KViP@00000103<c<`2000000@0/k>c00<0
000009VIV@2IVIT0102IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV00<0IVIV00<0
000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0603<c<`030000000I6AT06ATI00T06ATI=`00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo>000000<
01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP03
06IVIP030000001oOgl0Ogmo0080Ogmo0P00000509VIV@800000102c/k<2000000H0c<c<1`000007
0>KViPH000001P3<c<`2000000@0/k>c0P00000509VIV@800000101oOgl00`000000IVIV06IVIP03
06IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0:
01TI6CL000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ocP000003@0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IV
IP1VIVH00`1VIVH2000000@0Ogmo00<0000009VIV@2IVIT0102IVIT2000000@0/k>c0P00000;0<c<
c0L000002P3<c<`2000000@0/k>c0P00000609VIV@030000001oOgl0Ogmo0080Ogmo0P00000506IV
IP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0901TI
6CP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocT0
0000300I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1V
IVH0101VIVH00`000000Ogmo07moO`0207moO`8000001P2IVIT2000000@0/k>c0`00000F0<c<c0<0
0000102c/k<2000000H0VIVI0P00000407moO`030000001VIVH0IVIV00@0IVIV00<0000004a<C01<
C4`0101<C4`00`000000<c<c03<c<`0603<c<`030000000I6AT06ATI00X06ATI>00000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolj000000`06ATI00<0000003<c<`0c<c<0
1P0c<c<00`000000C4a<04a<C00404a<C08000001@1VIVH00`000000Ogmo07moO`0307moO`800000
1@2IVIT3000000D0/k>c5P0000050;>c/`<000001@2IVIT2000000D0Ogmo00<0000006IVIP1VIVH0
0`1VIVH2000000H0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0;01TI6CP00000
103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo>`00000<01TI6@030000000c
<c<0<c<c00H0<c<c0P00000604a<C0030000001VIVH0IVIV00<0IVIV0P00000507moO`8000001P2I
VIT5000001H0/k>c1@00000609VIV@8000001@1oOgl2000000D0IVIV00<0000004a<C01<C4`0101<
C4`2000000P0<c<c00<0000001TI6@0I6AT02`0I6ATi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3oooll000000`06ATI0P00000803<c<`030000001<C4`0
C4a<00@0C4a<00<0000006IVIP1VIVH0101VIVH2000000D0Ogmo0P00000909VIV@<00000402c/k<3
000000T0VIVI0P00000507moO`8000001P1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0
<c<c00H0<c<c0P00000=01TI6CX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?oooc`000003P0I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<
00@0C4a<0P00000606IVIP8000001@1oOgl4000000P0VIVI4000000809VIV@@000001@1oOgl20000
00H0IVIV0P00000604a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT0300I6ATk0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolm000000h0
6ATI00<0000003<c<`0c<c<01P0c<c<2000000H0C4a<00<0000006IVIP1VIVH01@1VIVH2000000L0
Ogmo1P00000D09VIV@H000001`1oOgl2000000L0IVIV00<0000004a<C01<C4`0101<C4`2000000P0
<c<c00<0000001TI6@0I6AT03@0I6ATk000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3oooln000000d06ATI00<0000003<c<`0c<c<0200c<c<00`000000C4a<
04a<C00404a<C08000001`1VIVH2000000/0Ogmo1P00000809VIV@H000002`1oOgl2000000L0IVIV
0P00000604a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT03@0I6ATl000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolo000000d06ATI00<0
000003<c<`0c<c<0200c<c<00`000000C4a<04a<C00504a<C08000001`1VIVH4000000d0Ogmo2000
000=07moO`@000001`1VIVH2000000L0C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI
6@0<01TI6Cd000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooocl000003P0I6AT2000000T0<c<c0P00000704a<C08000002@1VIVH3000001`0Ogmo0`000009
06IVIP8000001`1<C4`2000000T0<c<c0P00000>01TI6Ch000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oood0000003`0I6AT2000000T0<c<c00<0000004a<
C01<C4`01P1<C4`3000000T0IVIV1000000D07moO`@000002@1VIVH3000000P0C4a<00<0000003<c
<`0c<c<01`0c<c<2000000l06ATI?`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo@@00000@01TI6@030000000c<c<0<c<c00L0<c<c0P00000904a<C0<0
00002P1VIVHD000000X0IVIV0`00000904a<C08000002@0c<c<00`0000006ATI01TI6@0>01TI6D00
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oood<00000
3`0I6AT00`000000<c<c03<c<`0803<c<`8000002P1<C4`400000200IVIV1000000:04a<C0800000
2P0c<c<00`0000006ATI01TI6@0=01TI6D8000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oood@000003`0I6AT2000000X0<c<c0`00000;04a<C0D000005P1V
IVH5000000`0C4a<0P00000:03<c<`8000003`0I6AU3000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo0P0000030?ooodD00000400I6AT00`000000<c<c03<c<`0:03<c<`@00000301<C4`8
000000L0IVIV1`00000<04a<C0D000002`0c<c<00`0000006ATI01TI6@0>01TI6D@00000103oool2
000000L0oooo000E0?ooo`030000003oool0oooo0080ooooAP00000@01TI6@8000003P0c<c<30000
0140C4a<1`00000@04a<C0<000003P0c<c<2000001406ATIA00000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080ooooB000000@01TI6@8000003`0c<c<300000280
C4a<0`00000?03<c<`8000004@0I6AU6000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooom9000001406ATI0P00000@03<c<`<00000701<C4`300000100<c<c
0P00000A01TI6DP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oood/000004@0I6AT300000100<c<c1000000D04a<C0@00000400c<c<3000001406ATIBP00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooC000000C
01TI6@8000004P0c<c<D00000180<c<c0P00000C01TI6D/000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooodd00000500I6AT2000003@0<c<c0P00000D01TI
6D`000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodl0
0000500I6AT4000002`0<c<c1000000D01TI6Dh000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooe4000005P0I6AT500000280<c<c1@00000F01TI6E000000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooe8000006P0I
6AT3000001`0<c<c0`00000J01TI6E4000001@3oool00`000000oooo0?ooo`050?ooo`002@3oool3
00000080oooo0P0000050?ooo`030000003oool0oooo0080ooooE000000K01TI6@/000001`0c<c<:
000001/06ATID`0000050?ooo`030000003oool0oooo00D0oooo000:0?ooo`040000003oool0oooo
00000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oooeH00000900I6AT7
000002<06ATIE@0000050?ooo`030000003oool0oooo00D0oooo00070?ooo`D0000000D0oooo0000
003oool0oooo000000040?ooo`<000000P3ooomI000004P06ATIF00000030?ooo`<000001`3oool0
00L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0080ooooF`00001401TI6EX000001@3oool00`000000oooo0?ooo`050?ooo`00203oool0
0`000000oooo000000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3oool00P3o
oomM000004006ATIG00000050?ooo`030000003oool0oooo00D0oooo00090?ooo`8000000`3oool2
000000D0oooo00<000000?ooo`3oool00P3ooomO000003`06ATIGP0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooH`00000d01TI6F8000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooofL00000;00I6AUV000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom[000002@06ATI
JP0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080ooooK@00
000P01TI6F`000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o
0?ooo`40oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3o
ool0>`3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3o
ool0203oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`005@3o
oooo000000D000001`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo
8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool008h0oooo0P0000001@3oool0
0000000000000000oooo00@000000`3oool200000880oooo002>0?ooo`050000003oool0oooo0?oo
o`0000000P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo00000840oooo002>0?oo
o`050000003oool000000?ooo`0000000`3oool00`000000oooo0?ooo`020?ooo`040000003oool0
oooo00000840oooo002>0?ooo`80000000<0oooo000000000000103oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0O`3oool008h0oooo0P0000000`3oool0000000000002
0?ooo`040000003oool0oooo00000080oooo00@000000?ooo`3oool00000P@3oool008h0oooo0P00
0000103oool000000000000000020?ooo`800000103oool200000880oooo003o0?ooob40oooo003o
0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-3.26594, -1.76599, 0.160642, \
0.160642}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00480769 0.0240385 -0.00480769 0.0240385 [
[.23558 -0.0125 -6 -9 ]
[.23558 -0.0125 6 0 ]
[.47596 -0.0125 -6 -9 ]
[.47596 -0.0125 6 0 ]
[.71635 -0.0125 -6 -9 ]
[.71635 -0.0125 6 0 ]
[.95673 -0.0125 -6 -9 ]
[.95673 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .23558 -12 -4.5 ]
[-0.0125 .23558 0 4.5 ]
[-0.0125 .47596 -12 -4.5 ]
[-0.0125 .47596 0 4.5 ]
[-0.0125 .71635 -12 -4.5 ]
[-0.0125 .71635 0 4.5 ]
[-0.0125 .95673 -12 -4.5 ]
[-0.0125 .95673 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -11 0 ]
[.5 1.0125 11 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23558 0 m
.23558 .00625 L
s
[(10)] .23558 -0.0125 0 1 Mshowa
.47596 0 m
.47596 .00625 L
s
[(20)] .47596 -0.0125 0 1 Mshowa
.71635 0 m
.71635 .00625 L
s
[(30)] .71635 -0.0125 0 1 Mshowa
.95673 0 m
.95673 .00625 L
s
[(40)] .95673 -0.0125 0 1 Mshowa
.125 Mabswid
.04327 0 m
.04327 .00375 L
s
.09135 0 m
.09135 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.1875 0 m
.1875 .00375 L
s
.28365 0 m
.28365 .00375 L
s
.33173 0 m
.33173 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.42788 0 m
.42788 .00375 L
s
.52404 0 m
.52404 .00375 L
s
.57212 0 m
.57212 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.66827 0 m
.66827 .00375 L
s
.76442 0 m
.76442 .00375 L
s
.8125 0 m
.8125 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.90865 0 m
.90865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .23558 m
.00625 .23558 L
s
[(10)] -0.0125 .23558 1 0 Mshowa
0 .47596 m
.00625 .47596 L
s
[(20)] -0.0125 .47596 1 0 Mshowa
0 .71635 m
.00625 .71635 L
s
[(30)] -0.0125 .71635 1 0 Mshowa
0 .95673 m
.00625 .95673 L
s
[(40)] -0.0125 .95673 1 0 Mshowa
.125 Mabswid
0 .04327 m
.00375 .04327 L
s
0 .09135 m
.00375 .09135 L
s
0 .13942 m
.00375 .13942 L
s
0 .1875 m
.00375 .1875 L
s
0 .28365 m
.00375 .28365 L
s
0 .33173 m
.00375 .33173 L
s
0 .37981 m
.00375 .37981 L
s
0 .42788 m
.00375 .42788 L
s
0 .52404 m
.00375 .52404 L
s
0 .57212 m
.00375 .57212 L
s
0 .62019 m
.00375 .62019 L
s
0 .66827 m
.00375 .66827 L
s
0 .76442 m
.00375 .76442 L
s
0 .8125 m
.00375 .8125 L
s
0 .86058 m
.00375 .86058 L
s
0 .90865 m
.00375 .90865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.23558 .99375 m
.23558 1 L
s
.47596 .99375 m
.47596 1 L
s
.71635 .99375 m
.71635 1 L
s
.95673 .99375 m
.95673 1 L
s
.125 Mabswid
.04327 .99625 m
.04327 1 L
s
.09135 .99625 m
.09135 1 L
s
.13942 .99625 m
.13942 1 L
s
.1875 .99625 m
.1875 1 L
s
.28365 .99625 m
.28365 1 L
s
.33173 .99625 m
.33173 1 L
s
.37981 .99625 m
.37981 1 L
s
.42788 .99625 m
.42788 1 L
s
.52404 .99625 m
.52404 1 L
s
.57212 .99625 m
.57212 1 L
s
.62019 .99625 m
.62019 1 L
s
.66827 .99625 m
.66827 1 L
s
.76442 .99625 m
.76442 1 L
s
.8125 .99625 m
.8125 1 L
s
.86058 .99625 m
.86058 1 L
s
.90865 .99625 m
.90865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .23558 m
1 .23558 L
s
.99375 .47596 m
1 .47596 L
s
.99375 .71635 m
1 .71635 L
s
.99375 .95673 m
1 .95673 L
s
.125 Mabswid
.99625 .04327 m
1 .04327 L
s
.99625 .09135 m
1 .09135 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .1875 m
1 .1875 L
s
.99625 .28365 m
1 .28365 L
s
.99625 .33173 m
1 .33173 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .42788 m
1 .42788 L
s
.99625 .52404 m
1 .52404 L
s
.99625 .57212 m
1 .57212 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .66827 m
1 .66827 L
s
.99625 .76442 m
1 .76442 L
s
.99625 .8125 m
1 .8125 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .90865 m
1 .90865 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M21) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.5 Mabswid
.1 g
.25962 .04087 m
.28365 .0332 L
.30769 .02868 L
.33173 .02729 L
.35577 .02933 L
.37981 .03567 L
.39652 .04327 L
.40385 .04802 L
.42657 .06731 L
.42788 .06884 L
.44327 .09135 L
.45192 .10879 L
.45298 .11538 L
.45793 .13942 L
.4632 .16346 L
.46734 .1875 L
.46983 .21154 L
.47046 .23558 L
.46893 .25962 L
.46461 .28365 L
.45705 .30769 L
.45192 .32291 L
.44341 .33173 L
.42788 .33812 L
.40385 .34696 L
.37981 .35244 L
.35577 .35524 L
.3466 .35577 L
.33173 .35602 L
.31279 .35577 L
.30769 .35553 L
.28365 .35353 L
.25962 .35014 L
.23558 .34535 L
.21154 .3395 L
.1875 .33375 L
.17754 .33173 L
.16346 .32463 L
.13966 .30769 L
.13942 .30748 L
.12083 .28365 L
.11538 .27543 L
.11137 .25962 L
.10812 .23558 L
.10947 .21154 L
.11465 .1875 L
.11538 .18484 L
.12414 .16346 L
.13723 .13942 L
.13942 .1359 L
.1549 .11538 L
.16346 .10557 L
.1778 .09135 L
.1875 .08299 L
.20831 .06731 L
.21154 .06528 L
.23558 .05168 L
.25359 .04327 L
F
0 g
.25962 .04087 m
.28365 .0332 L
.30769 .02868 L
.33173 .02729 L
.35577 .02933 L
.37981 .03567 L
.39652 .04327 L
.40385 .04802 L
.42657 .06731 L
.42788 .06884 L
.44327 .09135 L
.45192 .10879 L
.45298 .11538 L
.45793 .13942 L
.4632 .16346 L
.46734 .1875 L
.46983 .21154 L
.47046 .23558 L
.46893 .25962 L
.46461 .28365 L
.45705 .30769 L
.45192 .32291 L
.44341 .33173 L
.42788 .33812 L
.40385 .34696 L
.37981 .35244 L
.35577 .35524 L
.3466 .35577 L
.33173 .35602 L
.31279 .35577 L
.30769 .35553 L
.28365 .35353 L
.25962 .35014 L
.23558 .34535 L
.21154 .3395 L
.1875 .33375 L
.17754 .33173 L
.16346 .32463 L
.13966 .30769 L
.13942 .30748 L
.12083 .28365 L
.11538 .27543 L
.11137 .25962 L
.10812 .23558 L
.10947 .21154 L
.11465 .1875 L
.11538 .18484 L
.12414 .16346 L
.13723 .13942 L
.13942 .1359 L
Mistroke
.1549 .11538 L
.16346 .10557 L
.1778 .09135 L
.1875 .08299 L
.20831 .06731 L
.21154 .06528 L
.23558 .05168 L
.25359 .04327 L
.25962 .04087 L
Mfstroke
.1 g
.33173 .64398 m
.3466 .64423 L
.35577 .64476 L
.37981 .64756 L
.40385 .65304 L
.42788 .66188 L
.44341 .66827 L
.45192 .67709 L
.45705 .69231 L
.46461 .71635 L
.46893 .74038 L
.47046 .76442 L
.46983 .78846 L
.46734 .8125 L
.4632 .83654 L
.45793 .86058 L
.45298 .88462 L
.45192 .89121 L
.44327 .90865 L
.42788 .93116 L
.42657 .93269 L
.40385 .95198 L
.39652 .95673 L
.37981 .96433 L
.35577 .97067 L
.33173 .97271 L
.30769 .97132 L
.28365 .9668 L
.25962 .95913 L
.25359 .95673 L
.23558 .94832 L
.21154 .93472 L
.20831 .93269 L
.1875 .91701 L
.1778 .90865 L
.16346 .89443 L
.1549 .88462 L
.13942 .8641 L
.13723 .86058 L
.12414 .83654 L
.11538 .81516 L
.11465 .8125 L
.10947 .78846 L
.10812 .76442 L
.11137 .74038 L
.11538 .72457 L
.12083 .71635 L
.13942 .69252 L
.13966 .69231 L
.16346 .67537 L
.17754 .66827 L
.1875 .66625 L
.21154 .6605 L
.23558 .65465 L
.25962 .64986 L
.28365 .64647 L
.30769 .64447 L
.31279 .64423 L
F
0 g
.33173 .64398 m
.3466 .64423 L
.35577 .64476 L
.37981 .64756 L
.40385 .65304 L
.42788 .66188 L
.44341 .66827 L
.45192 .67709 L
.45705 .69231 L
.46461 .71635 L
.46893 .74038 L
.47046 .76442 L
.46983 .78846 L
.46734 .8125 L
.4632 .83654 L
.45793 .86058 L
.45298 .88462 L
.45192 .89121 L
.44327 .90865 L
.42788 .93116 L
.42657 .93269 L
.40385 .95198 L
.39652 .95673 L
.37981 .96433 L
.35577 .97067 L
.33173 .97271 L
.30769 .97132 L
.28365 .9668 L
.25962 .95913 L
.25359 .95673 L
.23558 .94832 L
.21154 .93472 L
.20831 .93269 L
.1875 .91701 L
.1778 .90865 L
.16346 .89443 L
.1549 .88462 L
.13942 .8641 L
.13723 .86058 L
.12414 .83654 L
.11538 .81516 L
.11465 .8125 L
.10947 .78846 L
.10812 .76442 L
.11137 .74038 L
.11538 .72457 L
.12083 .71635 L
.13942 .69252 L
.13966 .69231 L
.16346 .67537 L
Mistroke
.17754 .66827 L
.1875 .66625 L
.21154 .6605 L
.23558 .65465 L
.25962 .64986 L
.28365 .64647 L
.30769 .64447 L
.31279 .64423 L
.33173 .64398 L
Mfstroke
.1 g
.33173 .40361 m
.34603 .40385 L
.35577 .4044 L
.37981 .40719 L
.40385 .41264 L
.42788 .42145 L
.44306 .42788 L
.45192 .43716 L
.4564 .45192 L
.46263 .47596 L
.46476 .5 L
.46263 .52404 L
.4564 .54808 L
.45192 .56284 L
.44306 .57212 L
.42788 .57855 L
.40385 .58736 L
.37981 .59281 L
.35577 .5956 L
.34603 .59615 L
.33173 .59639 L
.31339 .59615 L
.30769 .59589 L
.28365 .5939 L
.25962 .59052 L
.23558 .58575 L
.21154 .57993 L
.1875 .57412 L
.17821 .57212 L
.16346 .56462 L
.14168 .54808 L
.13942 .5469 L
.12548 .52404 L
.12049 .5 L
.12548 .47596 L
.13942 .4531 L
.14168 .45192 L
.16346 .43538 L
.17821 .42788 L
.1875 .42588 L
.21154 .42007 L
.23558 .41425 L
.25962 .40948 L
.28365 .4061 L
.30769 .40411 L
.31339 .40385 L
F
0 g
.33173 .40361 m
.34603 .40385 L
.35577 .4044 L
.37981 .40719 L
.40385 .41264 L
.42788 .42145 L
.44306 .42788 L
.45192 .43716 L
.4564 .45192 L
.46263 .47596 L
.46476 .5 L
.46263 .52404 L
.4564 .54808 L
.45192 .56284 L
.44306 .57212 L
.42788 .57855 L
.40385 .58736 L
.37981 .59281 L
.35577 .5956 L
.34603 .59615 L
.33173 .59639 L
.31339 .59615 L
.30769 .59589 L
.28365 .5939 L
.25962 .59052 L
.23558 .58575 L
.21154 .57993 L
.1875 .57412 L
.17821 .57212 L
.16346 .56462 L
.14168 .54808 L
.13942 .5469 L
.12548 .52404 L
.12049 .5 L
.12548 .47596 L
.13942 .4531 L
.14168 .45192 L
.16346 .43538 L
.17821 .42788 L
.1875 .42588 L
.21154 .42007 L
.23558 .41425 L
.25962 .40948 L
.28365 .4061 L
.30769 .40411 L
.31339 .40385 L
.33173 .40361 L
s
.2 g
.33173 .06691 m
.34087 .06731 L
.35577 .06937 L
.37981 .07697 L
.40385 .09133 L
.40387 .09135 L
.426 .11538 L
.42788 .11823 L
.43887 .13942 L
.44747 .16346 L
.45192 .18125 L
.45232 .1875 L
.45365 .21154 L
.45405 .23558 L
.45313 .25962 L
.45192 .27795 L
.44946 .28365 L
.43713 .30769 L
.42788 .31772 L
.40417 .33173 L
.40385 .33178 L
.37981 .33544 L
.35577 .33794 L
.33173 .33884 L
.30769 .33822 L
.28365 .33636 L
.25962 .33373 L
.24249 .33173 L
.23558 .32964 L
.21154 .32037 L
.18931 .30769 L
.1875 .30642 L
.16555 .28365 L
.16346 .28179 L
.15415 .25962 L
.15013 .23558 L
.15179 .21154 L
.15829 .1875 L
.16346 .17454 L
.16956 .16346 L
.18607 .13942 L
.1875 .13766 L
.20925 .11538 L
.21154 .11342 L
.23558 .09582 L
.24291 .09135 L
.25962 .08305 L
.28365 .07403 L
.30769 .06857 L
.31886 .06731 L
F
0 g
.33173 .06691 m
.34087 .06731 L
.35577 .06937 L
.37981 .07697 L
.40385 .09133 L
.40387 .09135 L
.426 .11538 L
.42788 .11823 L
.43887 .13942 L
.44747 .16346 L
.45192 .18125 L
.45232 .1875 L
.45365 .21154 L
.45405 .23558 L
.45313 .25962 L
.45192 .27795 L
.44946 .28365 L
.43713 .30769 L
.42788 .31772 L
.40417 .33173 L
.40385 .33178 L
.37981 .33544 L
.35577 .33794 L
.33173 .33884 L
.30769 .33822 L
.28365 .33636 L
.25962 .33373 L
.24249 .33173 L
.23558 .32964 L
.21154 .32037 L
.18931 .30769 L
.1875 .30642 L
.16555 .28365 L
.16346 .28179 L
.15415 .25962 L
.15013 .23558 L
.15179 .21154 L
.15829 .1875 L
.16346 .17454 L
.16956 .16346 L
.18607 .13942 L
.1875 .13766 L
.20925 .11538 L
.21154 .11342 L
.23558 .09582 L
.24291 .09135 L
.25962 .08305 L
.28365 .07403 L
.30769 .06857 L
.31886 .06731 L
Mistroke
.33173 .06691 L
Mfstroke
.2 g
.25962 .66627 m
.28365 .66364 L
.30769 .66178 L
.33173 .66116 L
.35577 .66206 L
.37981 .66456 L
.40385 .66822 L
.40417 .66827 L
.42788 .68228 L
.43713 .69231 L
.44946 .71635 L
.45192 .72205 L
.45313 .74038 L
.45405 .76442 L
.45365 .78846 L
.45232 .8125 L
.45192 .81875 L
.44747 .83654 L
.43887 .86058 L
.42788 .88177 L
.426 .88462 L
.40387 .90865 L
.40385 .90867 L
.37981 .92303 L
.35577 .93063 L
.34087 .93269 L
.33173 .93309 L
.31886 .93269 L
.30769 .93143 L
.28365 .92597 L
.25962 .91695 L
.24291 .90865 L
.23558 .90418 L
.21154 .88658 L
.20925 .88462 L
.1875 .86234 L
.18607 .86058 L
.16956 .83654 L
.16346 .82546 L
.15829 .8125 L
.15179 .78846 L
.15013 .76442 L
.15415 .74038 L
.16346 .71821 L
.16555 .71635 L
.1875 .69358 L
.18931 .69231 L
.21154 .67963 L
.23558 .67036 L
.24249 .66827 L
F
0 g
.25962 .66627 m
.28365 .66364 L
.30769 .66178 L
.33173 .66116 L
.35577 .66206 L
.37981 .66456 L
.40385 .66822 L
.40417 .66827 L
.42788 .68228 L
.43713 .69231 L
.44946 .71635 L
.45192 .72205 L
.45313 .74038 L
.45405 .76442 L
.45365 .78846 L
.45232 .8125 L
.45192 .81875 L
.44747 .83654 L
.43887 .86058 L
.42788 .88177 L
.426 .88462 L
.40387 .90865 L
.40385 .90867 L
.37981 .92303 L
.35577 .93063 L
.34087 .93269 L
.33173 .93309 L
.31886 .93269 L
.30769 .93143 L
.28365 .92597 L
.25962 .91695 L
.24291 .90865 L
.23558 .90418 L
.21154 .88658 L
.20925 .88462 L
.1875 .86234 L
.18607 .86058 L
.16956 .83654 L
.16346 .82546 L
.15829 .8125 L
.15179 .78846 L
.15013 .76442 L
.15415 .74038 L
.16346 .71821 L
.16555 .71635 L
.1875 .69358 L
.18931 .69231 L
.21154 .67963 L
.23558 .67036 L
.24249 .66827 L
Mistroke
.25962 .66627 L
Mfstroke
.2 g
.25962 .42589 m
.28365 .42322 L
.30769 .42135 L
.33173 .42073 L
.35577 .42163 L
.37981 .42414 L
.40342 .42788 L
.40385 .42807 L
.42788 .44263 L
.43576 .45192 L
.44665 .47596 L
.44966 .5 L
.44665 .52404 L
.43576 .54808 L
.42788 .55737 L
.40385 .57193 L
.40342 .57212 L
.37981 .57586 L
.35577 .57837 L
.33173 .57927 L
.30769 .57865 L
.28365 .57678 L
.25962 .57411 L
.24358 .57212 L
.23558 .56971 L
.21154 .56019 L
.19188 .54808 L
.1875 .54618 L
.1712 .52404 L
.16513 .5 L
.1712 .47596 L
.1875 .45382 L
.19188 .45192 L
.21154 .43981 L
.23558 .43029 L
.24358 .42788 L
F
0 g
.25962 .42589 m
.28365 .42322 L
.30769 .42135 L
.33173 .42073 L
.35577 .42163 L
.37981 .42414 L
.40342 .42788 L
.40385 .42807 L
.42788 .44263 L
.43576 .45192 L
.44665 .47596 L
.44966 .5 L
.44665 .52404 L
.43576 .54808 L
.42788 .55737 L
.40385 .57193 L
.40342 .57212 L
.37981 .57586 L
.35577 .57837 L
.33173 .57927 L
.30769 .57865 L
.28365 .57678 L
.25962 .57411 L
.24358 .57212 L
.23558 .56971 L
.21154 .56019 L
.19188 .54808 L
.1875 .54618 L
.1712 .52404 L
.16513 .5 L
.1712 .47596 L
.1875 .45382 L
.19188 .45192 L
.21154 .43981 L
.23558 .43029 L
.24358 .42788 L
.25962 .42589 L
s
.3 g
.33173 .09107 m
.33839 .09135 L
.35577 .09387 L
.37981 .10251 L
.39957 .11538 L
.40385 .11953 L
.42008 .13942 L
.42788 .15351 L
.43199 .16346 L
.43916 .1875 L
.44312 .21154 L
.4441 .23558 L
.44171 .25962 L
.43455 .28365 L
.42788 .29626 L
.41748 .30769 L
.40385 .31699 L
.37981 .32624 L
.35577 .33062 L
.34134 .33173 L
.33173 .33184 L
.31837 .33173 L
.30769 .33106 L
.28365 .32797 L
.25962 .3225 L
.23558 .31397 L
.2229 .30769 L
.21154 .30054 L
.19412 .28365 L
.1875 .2769 L
.18077 .25962 L
.1762 .23558 L
.17808 .21154 L
.18553 .1875 L
.1875 .1828 L
.19881 .16346 L
.21154 .14705 L
.21883 .13942 L
.23558 .1249 L
.24924 .11538 L
.25962 .10955 L
.28365 .09915 L
.30769 .09297 L
.32147 .09135 L
F
0 g
.33173 .09107 m
.33839 .09135 L
.35577 .09387 L
.37981 .10251 L
.39957 .11538 L
.40385 .11953 L
.42008 .13942 L
.42788 .15351 L
.43199 .16346 L
.43916 .1875 L
.44312 .21154 L
.4441 .23558 L
.44171 .25962 L
.43455 .28365 L
.42788 .29626 L
.41748 .30769 L
.40385 .31699 L
.37981 .32624 L
.35577 .33062 L
.34134 .33173 L
.33173 .33184 L
.31837 .33173 L
.30769 .33106 L
.28365 .32797 L
.25962 .3225 L
.23558 .31397 L
.2229 .30769 L
.21154 .30054 L
.19412 .28365 L
.1875 .2769 L
.18077 .25962 L
.1762 .23558 L
.17808 .21154 L
.18553 .1875 L
.1875 .1828 L
.19881 .16346 L
.21154 .14705 L
.21883 .13942 L
.23558 .1249 L
.24924 .11538 L
.25962 .10955 L
.28365 .09915 L
.30769 .09297 L
.32147 .09135 L
.33173 .09107 L
s
.3 g
.33173 .66816 m
.34134 .66827 L
.35577 .66938 L
.37981 .67376 L
.40385 .68301 L
.41748 .69231 L
.42788 .70374 L
.43455 .71635 L
.44171 .74038 L
.4441 .76442 L
.44312 .78846 L
.43916 .8125 L
.43199 .83654 L
.42788 .84649 L
.42008 .86058 L
.40385 .88047 L
.39957 .88462 L
.37981 .89749 L
.35577 .90613 L
.33839 .90865 L
.33173 .90893 L
.32147 .90865 L
.30769 .90703 L
.28365 .90085 L
.25962 .89045 L
.24924 .88462 L
.23558 .8751 L
.21883 .86058 L
.21154 .85295 L
.19881 .83654 L
.1875 .8172 L
.18553 .8125 L
.17808 .78846 L
.1762 .76442 L
.18077 .74038 L
.1875 .7231 L
.19412 .71635 L
.21154 .69946 L
.2229 .69231 L
.23558 .68603 L
.25962 .6775 L
.28365 .67203 L
.30769 .66894 L
.31837 .66827 L
F
0 g
.33173 .66816 m
.34134 .66827 L
.35577 .66938 L
.37981 .67376 L
.40385 .68301 L
.41748 .69231 L
.42788 .70374 L
.43455 .71635 L
.44171 .74038 L
.4441 .76442 L
.44312 .78846 L
.43916 .8125 L
.43199 .83654 L
.42788 .84649 L
.42008 .86058 L
.40385 .88047 L
.39957 .88462 L
.37981 .89749 L
.35577 .90613 L
.33839 .90865 L
.33173 .90893 L
.32147 .90865 L
.30769 .90703 L
.28365 .90085 L
.25962 .89045 L
.24924 .88462 L
.23558 .8751 L
.21883 .86058 L
.21154 .85295 L
.19881 .83654 L
.1875 .8172 L
.18553 .8125 L
.17808 .78846 L
.1762 .76442 L
.18077 .74038 L
.1875 .7231 L
.19412 .71635 L
.21154 .69946 L
.2229 .69231 L
.23558 .68603 L
.25962 .6775 L
.28365 .67203 L
.30769 .66894 L
.31837 .66827 L
.33173 .66816 L
s
.3 g
.23558 .44673 m
.25962 .43759 L
.28365 .43199 L
.30769 .42887 L
.33173 .42793 L
.35577 .42931 L
.37981 .43374 L
.40385 .44341 L
.41539 .45192 L
.42788 .46564 L
.43092 .47596 L
.43481 .5 L
.43092 .52404 L
.42788 .53436 L
.41539 .54808 L
.40385 .55659 L
.37981 .56626 L
.35577 .57069 L
.33173 .57207 L
.30769 .57113 L
.28365 .56801 L
.25962 .56241 L
.23558 .55327 L
.22612 .54808 L
.21154 .54065 L
.20074 .52404 L
.19364 .5 L
.20074 .47596 L
.21154 .45935 L
.22612 .45192 L
F
0 g
.23558 .44673 m
.25962 .43759 L
.28365 .43199 L
.30769 .42887 L
.33173 .42793 L
.35577 .42931 L
.37981 .43374 L
.40385 .44341 L
.41539 .45192 L
.42788 .46564 L
.43092 .47596 L
.43481 .5 L
.43092 .52404 L
.42788 .53436 L
.41539 .54808 L
.40385 .55659 L
.37981 .56626 L
.35577 .57069 L
.33173 .57207 L
.30769 .57113 L
.28365 .56801 L
.25962 .56241 L
.23558 .55327 L
.22612 .54808 L
.21154 .54065 L
.20074 .52404 L
.19364 .5 L
.20074 .47596 L
.21154 .45935 L
.22612 .45192 L
.23558 .44673 L
s
.4 g
.30769 .11193 m
.33173 .10985 L
.35577 .11291 L
.36735 .11538 L
.37981 .12265 L
.40106 .13942 L
.40385 .14273 L
.41775 .16346 L
.4273 .1875 L
.42788 .18953 L
.43213 .21154 L
.4333 .23558 L
.43043 .25962 L
.42788 .27153 L
.42123 .28365 L
.40385 .3033 L
.39736 .30769 L
.37981 .31524 L
.35577 .32065 L
.33173 .32234 L
.30769 .32119 L
.28365 .31739 L
.25962 .31051 L
.2524 .30769 L
.23558 .29911 L
.21699 .28365 L
.21154 .27945 L
.20162 .25962 L
.19643 .23558 L
.19856 .21154 L
.20709 .1875 L
.21154 .17884 L
.22249 .16346 L
.23558 .14926 L
.24709 .13942 L
.25962 .13085 L
.28365 .11881 L
.28876 .11538 L
F
0 g
.30769 .11193 m
.33173 .10985 L
.35577 .11291 L
.36735 .11538 L
.37981 .12265 L
.40106 .13942 L
.40385 .14273 L
.41775 .16346 L
.4273 .1875 L
.42788 .18953 L
.43213 .21154 L
.4333 .23558 L
.43043 .25962 L
.42788 .27153 L
.42123 .28365 L
.40385 .3033 L
.39736 .30769 L
.37981 .31524 L
.35577 .32065 L
.33173 .32234 L
.30769 .32119 L
.28365 .31739 L
.25962 .31051 L
.2524 .30769 L
.23558 .29911 L
.21699 .28365 L
.21154 .27945 L
.20162 .25962 L
.19643 .23558 L
.19856 .21154 L
.20709 .1875 L
.21154 .17884 L
.22249 .16346 L
.23558 .14926 L
.24709 .13942 L
.25962 .13085 L
.28365 .11881 L
.28876 .11538 L
.30769 .11193 L
s
.4 g
.25962 .68949 m
.28365 .68261 L
.30769 .67881 L
.33173 .67766 L
.35577 .67935 L
.37981 .68476 L
.39736 .69231 L
.40385 .6967 L
.42123 .71635 L
.42788 .72847 L
.43043 .74038 L
.4333 .76442 L
.43213 .78846 L
.42788 .81047 L
.4273 .8125 L
.41775 .83654 L
.40385 .85727 L
.40106 .86058 L
.37981 .87735 L
.36735 .88462 L
.35577 .88709 L
.33173 .89015 L
.30769 .88807 L
.28876 .88462 L
.28365 .88119 L
.25962 .86915 L
.24709 .86058 L
.23558 .85074 L
.22249 .83654 L
.21154 .82116 L
.20709 .8125 L
.19856 .78846 L
.19643 .76442 L
.20162 .74038 L
.21154 .72055 L
.21699 .71635 L
.23558 .70089 L
.2524 .69231 L
F
0 g
.25962 .68949 m
.28365 .68261 L
.30769 .67881 L
.33173 .67766 L
.35577 .67935 L
.37981 .68476 L
.39736 .69231 L
.40385 .6967 L
.42123 .71635 L
.42788 .72847 L
.43043 .74038 L
.4333 .76442 L
.43213 .78846 L
.42788 .81047 L
.4273 .8125 L
.41775 .83654 L
.40385 .85727 L
.40106 .86058 L
.37981 .87735 L
.36735 .88462 L
.35577 .88709 L
.33173 .89015 L
.30769 .88807 L
.28876 .88462 L
.28365 .88119 L
.25962 .86915 L
.24709 .86058 L
.23558 .85074 L
.22249 .83654 L
.21154 .82116 L
.20709 .8125 L
.19856 .78846 L
.19643 .76442 L
.20162 .74038 L
.21154 .72055 L
.21699 .71635 L
.23558 .70089 L
.2524 .69231 L
.25962 .68949 L
s
.5 g
.28365 .13597 m
.30769 .12815 L
.33173 .12578 L
.35577 .12928 L
.37926 .13942 L
.37981 .14035 L
.4031 .16346 L
.40385 .16456 L
.41551 .1875 L
.42175 .21154 L
.42324 .23558 L
.41957 .25962 L
.4077 .28365 L
.40385 .28835 L
.37981 .30477 L
.37519 .30769 L
.35577 .31144 L
.33173 .31347 L
.30769 .31209 L
.2839 .30769 L
.28365 .30744 L
.25962 .29866 L
.2375 .28365 L
.23558 .28263 L
.21964 .25962 L
.21375 .23558 L
.21616 .21154 L
.22593 .1875 L
.23558 .17278 L
.24405 .16346 L
.25962 .14993 L
.27616 .13942 L
F
0 g
.28365 .13597 m
.30769 .12815 L
.33173 .12578 L
.35577 .12928 L
.37926 .13942 L
.37981 .14035 L
.4031 .16346 L
.40385 .16456 L
.41551 .1875 L
.42175 .21154 L
.42324 .23558 L
.41957 .25962 L
.4077 .28365 L
.40385 .28835 L
.37981 .30477 L
.37519 .30769 L
.35577 .31144 L
.33173 .31347 L
.30769 .31209 L
.2839 .30769 L
.28365 .30744 L
.25962 .29866 L
.2375 .28365 L
.23558 .28263 L
.21964 .25962 L
.21375 .23558 L
.21616 .21154 L
.22593 .1875 L
.23558 .17278 L
.24405 .16346 L
.25962 .14993 L
.27616 .13942 L
.28365 .13597 L
s
.5 g
.30769 .68791 m
.33173 .68653 L
.35577 .68856 L
.37519 .69231 L
.37981 .69523 L
.40385 .71165 L
.4077 .71635 L
.41957 .74038 L
.42324 .76442 L
.42175 .78846 L
.41551 .8125 L
.40385 .83544 L
.4031 .83654 L
.37981 .85965 L
.37926 .86058 L
.35577 .87072 L
.33173 .87422 L
.30769 .87185 L
.28365 .86403 L
.27616 .86058 L
.25962 .85007 L
.24405 .83654 L
.23558 .82722 L
.22593 .8125 L
.21616 .78846 L
.21375 .76442 L
.21964 .74038 L
.23558 .71737 L
.2375 .71635 L
.25962 .70134 L
.28365 .69256 L
.2839 .69231 L
F
0 g
.30769 .68791 m
.33173 .68653 L
.35577 .68856 L
.37519 .69231 L
.37981 .69523 L
.40385 .71165 L
.4077 .71635 L
.41957 .74038 L
.42324 .76442 L
.42175 .78846 L
.41551 .8125 L
.40385 .83544 L
.4031 .83654 L
.37981 .85965 L
.37926 .86058 L
.35577 .87072 L
.33173 .87422 L
.30769 .87185 L
.28365 .86403 L
.27616 .86058 L
.25962 .85007 L
.24405 .83654 L
.23558 .82722 L
.22593 .8125 L
.21616 .78846 L
.21375 .76442 L
.21964 .74038 L
.23558 .71737 L
.2375 .71635 L
.25962 .70134 L
.28365 .69256 L
.2839 .69231 L
.30769 .68791 L
s
.4 g
.25962 .45067 m
.28365 .44298 L
.30769 .43894 L
.33173 .43775 L
.35577 .43951 L
.37981 .44532 L
.39424 .45192 L
.40385 .45638 L
.41627 .47596 L
.42158 .5 L
.41627 .52404 L
.40385 .54362 L
.39424 .54808 L
.37981 .55468 L
.35577 .56049 L
.33173 .56225 L
.30769 .56106 L
.28365 .55702 L
.25962 .54933 L
.25673 .54808 L
.23558 .53878 L
.22478 .52404 L
.21643 .5 L
.22478 .47596 L
.23558 .46122 L
.25673 .45192 L
F
0 g
.25962 .45067 m
.28365 .44298 L
.30769 .43894 L
.33173 .43775 L
.35577 .43951 L
.37981 .44532 L
.39424 .45192 L
.40385 .45638 L
.41627 .47596 L
.42158 .5 L
.41627 .52404 L
.40385 .54362 L
.39424 .54808 L
.37981 .55468 L
.35577 .56049 L
.33173 .56225 L
.30769 .56106 L
.28365 .55702 L
.25962 .54933 L
.25673 .54808 L
.23558 .53878 L
.22478 .52404 L
.21643 .5 L
.22478 .47596 L
.23558 .46122 L
.25673 .45192 L
.25962 .45067 L
s
.6 g
.28365 .15192 m
.30769 .14291 L
.33173 .14023 L
.35577 .14419 L
.37981 .1571 L
.38719 .16346 L
.40343 .1875 L
.40385 .18847 L
.41125 .21154 L
.41308 .23558 L
.40853 .25962 L
.40385 .2725 L
.39364 .28365 L
.37981 .29378 L
.35577 .30238 L
.33173 .30485 L
.30769 .30318 L
.28365 .29733 L
.25962 .28517 L
.25754 .28365 L
.2363 .25962 L
.23558 .25814 L
.22962 .23558 L
.23233 .21154 L
.23558 .2024 L
.24357 .1875 L
.25962 .16857 L
.26561 .16346 L
F
0 g
.28365 .15192 m
.30769 .14291 L
.33173 .14023 L
.35577 .14419 L
.37981 .1571 L
.38719 .16346 L
.40343 .1875 L
.40385 .18847 L
.41125 .21154 L
.41308 .23558 L
.40853 .25962 L
.40385 .2725 L
.39364 .28365 L
.37981 .29378 L
.35577 .30238 L
.33173 .30485 L
.30769 .30318 L
.28365 .29733 L
.25962 .28517 L
.25754 .28365 L
.2363 .25962 L
.23558 .25814 L
.22962 .23558 L
.23233 .21154 L
.23558 .2024 L
.24357 .1875 L
.25962 .16857 L
.26561 .16346 L
.28365 .15192 L
s
.6 g
.25962 .71483 m
.28365 .70267 L
.30769 .69682 L
.33173 .69515 L
.35577 .69762 L
.37981 .70622 L
.39364 .71635 L
.40385 .7275 L
.40853 .74038 L
.41308 .76442 L
.41125 .78846 L
.40385 .81153 L
.40343 .8125 L
.38719 .83654 L
.37981 .8429 L
.35577 .85581 L
.33173 .85977 L
.30769 .85709 L
.28365 .84808 L
.26561 .83654 L
.25962 .83143 L
.24357 .8125 L
.23558 .7976 L
.23233 .78846 L
.22962 .76442 L
.23558 .74186 L
.2363 .74038 L
.25754 .71635 L
F
0 g
.25962 .71483 m
.28365 .70267 L
.30769 .69682 L
.33173 .69515 L
.35577 .69762 L
.37981 .70622 L
.39364 .71635 L
.40385 .7275 L
.40853 .74038 L
.41308 .76442 L
.41125 .78846 L
.40385 .81153 L
.40343 .8125 L
.38719 .83654 L
.37981 .8429 L
.35577 .85581 L
.33173 .85977 L
.30769 .85709 L
.28365 .84808 L
.26561 .83654 L
.25962 .83143 L
.24357 .8125 L
.23558 .7976 L
.23233 .78846 L
.22962 .76442 L
.23558 .74186 L
.2363 .74038 L
.25754 .71635 L
.25962 .71483 L
s
.5 g
.30769 .44885 m
.33173 .4473 L
.35577 .4496 L
.36895 .45192 L
.37981 .45508 L
.40123 .47596 L
.40385 .48115 L
.40816 .5 L
.40385 .51885 L
.40123 .52404 L
.37981 .54492 L
.36895 .54808 L
.35577 .5504 L
.33173 .5527 L
.30769 .55115 L
.28753 .54808 L
.28365 .54687 L
.25962 .53815 L
.24684 .52404 L
.23683 .5 L
.24684 .47596 L
.25962 .46185 L
.28365 .45313 L
.28753 .45192 L
F
0 g
.30769 .44885 m
.33173 .4473 L
.35577 .4496 L
.36895 .45192 L
.37981 .45508 L
.40123 .47596 L
.40385 .48115 L
.40816 .5 L
.40385 .51885 L
.40123 .52404 L
.37981 .54492 L
.36895 .54808 L
.35577 .5504 L
.33173 .5527 L
.30769 .55115 L
.28753 .54808 L
.28365 .54687 L
.25962 .53815 L
.24684 .52404 L
.23683 .5 L
.24684 .47596 L
.25962 .46185 L
.28365 .45313 L
.28753 .45192 L
.30769 .44885 L
s
.7 g
.30769 .15716 m
.33173 .15405 L
.35577 .15865 L
.3694 .16346 L
.37981 .17385 L
.39075 .1875 L
.40051 .21154 L
.40264 .23558 L
.39726 .25962 L
.37981 .28213 L
.37816 .28365 L
.35577 .29269 L
.33173 .29589 L
.30769 .29374 L
.28365 .2859 L
.27909 .28365 L
.25962 .27134 L
.25255 .25962 L
.24474 .23558 L
.24788 .21154 L
.25962 .18973 L
.26128 .1875 L
.28365 .16766 L
.2872 .16346 L
F
0 g
.30769 .15716 m
.33173 .15405 L
.35577 .15865 L
.3694 .16346 L
.37981 .17385 L
.39075 .1875 L
.40051 .21154 L
.40264 .23558 L
.39726 .25962 L
.37981 .28213 L
.37816 .28365 L
.35577 .29269 L
.33173 .29589 L
.30769 .29374 L
.28365 .2859 L
.27909 .28365 L
.25962 .27134 L
.25255 .25962 L
.24474 .23558 L
.24788 .21154 L
.25962 .18973 L
.26128 .1875 L
.28365 .16766 L
.2872 .16346 L
.30769 .15716 L
s
.7 g
.28365 .7141 m
.30769 .70626 L
.33173 .70411 L
.35577 .70731 L
.37816 .71635 L
.37981 .71787 L
.39726 .74038 L
.40264 .76442 L
.40051 .78846 L
.39075 .8125 L
.37981 .82615 L
.3694 .83654 L
.35577 .84135 L
.33173 .84595 L
.30769 .84284 L
.2872 .83654 L
.28365 .83234 L
.26128 .8125 L
.25962 .81027 L
.24788 .78846 L
.24474 .76442 L
.25255 .74038 L
.25962 .72866 L
.27909 .71635 L
F
0 g
.28365 .7141 m
.30769 .70626 L
.33173 .70411 L
.35577 .70731 L
.37816 .71635 L
.37981 .71787 L
.39726 .74038 L
.40264 .76442 L
.40051 .78846 L
.39075 .8125 L
.37981 .82615 L
.3694 .83654 L
.35577 .84135 L
.33173 .84595 L
.30769 .84284 L
.2872 .83654 L
.28365 .83234 L
.26128 .8125 L
.25962 .81027 L
.24788 .78846 L
.24474 .76442 L
.25255 .74038 L
.25962 .72866 L
.27909 .71635 L
.28365 .7141 L
s
.6 g
.28365 .46386 m
.30769 .4565 L
.33173 .45502 L
.35577 .45729 L
.37981 .47032 L
.38421 .47596 L
.39425 .5 L
.38421 .52404 L
.37981 .52968 L
.35577 .54271 L
.33173 .54498 L
.30769 .5435 L
.28365 .53614 L
.26917 .52404 L
.25962 .51141 L
.25671 .5 L
.25962 .48859 L
.26917 .47596 L
F
0 g
.28365 .46386 m
.30769 .4565 L
.33173 .45502 L
.35577 .45729 L
.37981 .47032 L
.38421 .47596 L
.39425 .5 L
.38421 .52404 L
.37981 .52968 L
.35577 .54271 L
.33173 .54498 L
.30769 .5435 L
.28365 .53614 L
.26917 .52404 L
.25962 .51141 L
.25671 .5 L
.25962 .48859 L
.26917 .47596 L
.28365 .46386 L
s
.8 g
.28365 .18492 m
.30769 .17134 L
.33173 .16776 L
.35577 .17311 L
.37742 .1875 L
.37981 .19383 L
.38882 .21154 L
.39175 .23558 L
.38419 .25962 L
.37981 .26729 L
.35577 .28248 L
.34859 .28365 L
.33173 .28581 L
.31066 .28365 L
.30769 .28327 L
.28365 .27537 L
.26919 .25962 L
.26004 .23558 L
.26364 .21154 L
.2807 .1875 L
F
0 g
.28365 .18492 m
.30769 .17134 L
.33173 .16776 L
.35577 .17311 L
.37742 .1875 L
.37981 .19383 L
.38882 .21154 L
.39175 .23558 L
.38419 .25962 L
.37981 .26729 L
.35577 .28248 L
.34859 .28365 L
.33173 .28581 L
.31066 .28365 L
.30769 .28327 L
.28365 .27537 L
.26919 .25962 L
.26004 .23558 L
.26364 .21154 L
.2807 .1875 L
.28365 .18492 L
s
.8 g
.33173 .71419 m
.34859 .71635 L
.35577 .71752 L
.37981 .73271 L
.38419 .74038 L
.39175 .76442 L
.38882 .78846 L
.37981 .80617 L
.37742 .8125 L
.35577 .82689 L
.33173 .83224 L
.30769 .82866 L
.28365 .81508 L
.2807 .8125 L
.26364 .78846 L
.26004 .76442 L
.26919 .74038 L
.28365 .72463 L
.30769 .71673 L
.31066 .71635 L
F
0 g
.33173 .71419 m
.34859 .71635 L
.35577 .71752 L
.37981 .73271 L
.38419 .74038 L
.39175 .76442 L
.38882 .78846 L
.37981 .80617 L
.37742 .8125 L
.35577 .82689 L
.33173 .83224 L
.30769 .82866 L
.28365 .81508 L
.2807 .8125 L
.26364 .78846 L
.26004 .76442 L
.26919 .74038 L
.28365 .72463 L
.30769 .71673 L
.31066 .71635 L
.33173 .71419 L
s
.9 g
.33173 .18258 m
.35114 .1875 L
.35577 .18998 L
.37717 .21154 L
.37926 .23558 L
.37163 .25962 L
.35577 .27111 L
.33173 .27705 L
.30769 .27327 L
.28571 .25962 L
.28365 .25341 L
.27616 .23558 L
.28121 .21154 L
.28365 .20765 L
.30769 .18759 L
.3079 .1875 L
F
0 g
.33173 .18258 m
.35114 .1875 L
.35577 .18998 L
.37717 .21154 L
.37926 .23558 L
.37163 .25962 L
.35577 .27111 L
.33173 .27705 L
.30769 .27327 L
.28571 .25962 L
.28365 .25341 L
.27616 .23558 L
.28121 .21154 L
.28365 .20765 L
.30769 .18759 L
.3079 .1875 L
.33173 .18258 L
s
.9 g
.30769 .72673 m
.33173 .72295 L
.35577 .72889 L
.37163 .74038 L
.37926 .76442 L
.37717 .78846 L
.35577 .81002 L
.35114 .8125 L
.33173 .81742 L
.3079 .8125 L
.30769 .81241 L
.28365 .79235 L
.28121 .78846 L
.27616 .76442 L
.28365 .74659 L
.28571 .74038 L
F
0 g
.30769 .72673 m
.33173 .72295 L
.35577 .72889 L
.37163 .74038 L
.37926 .76442 L
.37717 .78846 L
.35577 .81002 L
.35114 .8125 L
.33173 .81742 L
.3079 .8125 L
.30769 .81241 L
.28365 .79235 L
.28121 .78846 L
.27616 .76442 L
.28365 .74659 L
.28571 .74038 L
.30769 .72673 L
s
.7 g
.30769 .47041 m
.33173 .46629 L
.35577 .47264 L
.36262 .47596 L
.37863 .5 L
.36262 .52404 L
.35577 .52736 L
.33173 .53371 L
.30769 .52959 L
.29296 .52404 L
.28365 .5134 L
.27793 .5 L
.28365 .4866 L
.29296 .47596 L
F
0 g
.30769 .47041 m
.33173 .46629 L
.35577 .47264 L
.36262 .47596 L
.37863 .5 L
.36262 .52404 L
.35577 .52736 L
.33173 .53371 L
.30769 .52959 L
.29296 .52404 L
.28365 .5134 L
.27793 .5 L
.28365 .4866 L
.29296 .47596 L
.30769 .47041 L
s
1 g
.30769 .20871 m
.33173 .20087 L
.35423 .21154 L
.35577 .21344 L
.36386 .23558 L
.35577 .2481 L
.33173 .25949 L
.30769 .25245 L
.29179 .23558 L
.30272 .21154 L
F
0 g
.30769 .20871 m
.33173 .20087 L
.35423 .21154 L
.35577 .21344 L
.36386 .23558 L
.35577 .2481 L
.33173 .25949 L
.30769 .25245 L
.29179 .23558 L
.30272 .21154 L
.30769 .20871 L
s
1 g
.30769 .74755 m
.33173 .74051 L
.35577 .7519 L
.36386 .76442 L
.35577 .78656 L
.35423 .78846 L
.33173 .79913 L
.30769 .79129 L
.30272 .78846 L
.29179 .76442 L
F
0 g
.30769 .74755 m
.33173 .74051 L
.35577 .7519 L
.36386 .76442 L
.35577 .78656 L
.35423 .78846 L
.33173 .79913 L
.30769 .79129 L
.30272 .78846 L
.29179 .76442 L
.30769 .74755 L
s
.8 g
.33173 .48682 m
.35103 .5 L
.33173 .51318 L
.30802 .5 L
F
0 g
.33173 .48682 m
.35103 .5 L
.33173 .51318 L
.30802 .5 L
.33173 .48682 L
s
.1 g
.62019 .03567 m
.64423 .02933 L
.66827 .02729 L
.69231 .02868 L
.71635 .0332 L
.74038 .04087 L
.74641 .04327 L
.76442 .05168 L
.78846 .06528 L
.79169 .06731 L
.8125 .08299 L
.8222 .09135 L
.83654 .10557 L
.8451 .11538 L
.86058 .1359 L
.86277 .13942 L
.87586 .16346 L
.88462 .18484 L
.88535 .1875 L
.89053 .21154 L
.89188 .23558 L
.88863 .25962 L
.88462 .27543 L
.87917 .28365 L
.86058 .30748 L
.86034 .30769 L
.83654 .32463 L
.82246 .33173 L
.8125 .33375 L
.78846 .3395 L
.76442 .34535 L
.74038 .35014 L
.71635 .35353 L
.69231 .35553 L
.68721 .35577 L
.66827 .35602 L
.6534 .35577 L
.64423 .35524 L
.62019 .35244 L
.59615 .34696 L
.57212 .33812 L
.55659 .33173 L
.54808 .32291 L
.54295 .30769 L
.53539 .28365 L
.53107 .25962 L
.52954 .23558 L
.53017 .21154 L
.53266 .1875 L
.5368 .16346 L
.54207 .13942 L
.54702 .11538 L
.54808 .10879 L
.55673 .09135 L
.57212 .06884 L
.57343 .06731 L
.59615 .04802 L
.60348 .04327 L
F
0 g
.62019 .03567 m
.64423 .02933 L
.66827 .02729 L
.69231 .02868 L
.71635 .0332 L
.74038 .04087 L
.74641 .04327 L
.76442 .05168 L
.78846 .06528 L
.79169 .06731 L
.8125 .08299 L
.8222 .09135 L
.83654 .10557 L
.8451 .11538 L
.86058 .1359 L
.86277 .13942 L
.87586 .16346 L
.88462 .18484 L
.88535 .1875 L
.89053 .21154 L
.89188 .23558 L
.88863 .25962 L
.88462 .27543 L
.87917 .28365 L
.86058 .30748 L
.86034 .30769 L
.83654 .32463 L
.82246 .33173 L
.8125 .33375 L
.78846 .3395 L
.76442 .34535 L
.74038 .35014 L
.71635 .35353 L
.69231 .35553 L
.68721 .35577 L
.66827 .35602 L
.6534 .35577 L
.64423 .35524 L
.62019 .35244 L
.59615 .34696 L
.57212 .33812 L
.55659 .33173 L
.54808 .32291 L
.54295 .30769 L
.53539 .28365 L
.53107 .25962 L
.52954 .23558 L
.53017 .21154 L
.53266 .1875 L
.5368 .16346 L
Mistroke
.54207 .13942 L
.54702 .11538 L
.54808 .10879 L
.55673 .09135 L
.57212 .06884 L
.57343 .06731 L
.59615 .04802 L
.60348 .04327 L
.62019 .03567 L
Mfstroke
.1 g
.66827 .64398 m
.68721 .64423 L
.69231 .64447 L
.71635 .64647 L
.74038 .64986 L
.76442 .65465 L
.78846 .6605 L
.8125 .66625 L
.82246 .66827 L
.83654 .67537 L
.86034 .69231 L
.86058 .69252 L
.87917 .71635 L
.88462 .72457 L
.88863 .74038 L
.89188 .76442 L
.89053 .78846 L
.88535 .8125 L
.88462 .81516 L
.87586 .83654 L
.86277 .86058 L
.86058 .8641 L
.8451 .88462 L
.83654 .89443 L
.8222 .90865 L
.8125 .91701 L
.79169 .93269 L
.78846 .93472 L
.76442 .94832 L
.74641 .95673 L
.74038 .95913 L
.71635 .9668 L
.69231 .97132 L
.66827 .97271 L
.64423 .97067 L
.62019 .96433 L
.60348 .95673 L
.59615 .95198 L
.57343 .93269 L
.57212 .93116 L
.55673 .90865 L
.54808 .89121 L
.54702 .88462 L
.54207 .86058 L
.5368 .83654 L
.53266 .8125 L
.53017 .78846 L
.52954 .76442 L
.53107 .74038 L
.53539 .71635 L
.54295 .69231 L
.54808 .67709 L
.55659 .66827 L
.57212 .66188 L
.59615 .65304 L
.62019 .64756 L
.64423 .64476 L
.6534 .64423 L
F
0 g
.66827 .64398 m
.68721 .64423 L
.69231 .64447 L
.71635 .64647 L
.74038 .64986 L
.76442 .65465 L
.78846 .6605 L
.8125 .66625 L
.82246 .66827 L
.83654 .67537 L
.86034 .69231 L
.86058 .69252 L
.87917 .71635 L
.88462 .72457 L
.88863 .74038 L
.89188 .76442 L
.89053 .78846 L
.88535 .8125 L
.88462 .81516 L
.87586 .83654 L
.86277 .86058 L
.86058 .8641 L
.8451 .88462 L
.83654 .89443 L
.8222 .90865 L
.8125 .91701 L
.79169 .93269 L
.78846 .93472 L
.76442 .94832 L
.74641 .95673 L
.74038 .95913 L
.71635 .9668 L
.69231 .97132 L
.66827 .97271 L
.64423 .97067 L
.62019 .96433 L
.60348 .95673 L
.59615 .95198 L
.57343 .93269 L
.57212 .93116 L
.55673 .90865 L
.54808 .89121 L
.54702 .88462 L
.54207 .86058 L
.5368 .83654 L
.53266 .8125 L
.53017 .78846 L
.52954 .76442 L
.53107 .74038 L
.53539 .71635 L
Mistroke
.54295 .69231 L
.54808 .67709 L
.55659 .66827 L
.57212 .66188 L
.59615 .65304 L
.62019 .64756 L
.64423 .64476 L
.6534 .64423 L
.66827 .64398 L
Mfstroke
.1 g
.66827 .40361 m
.68661 .40385 L
.69231 .40411 L
.71635 .4061 L
.74038 .40948 L
.76442 .41425 L
.78846 .42007 L
.8125 .42588 L
.82179 .42788 L
.83654 .43538 L
.85832 .45192 L
.86058 .4531 L
.87452 .47596 L
.87951 .5 L
.87452 .52404 L
.86058 .5469 L
.85832 .54808 L
.83654 .56462 L
.82179 .57212 L
.8125 .57412 L
.78846 .57993 L
.76442 .58575 L
.74038 .59052 L
.71635 .5939 L
.69231 .59589 L
.68661 .59615 L
.66827 .59639 L
.65397 .59615 L
.64423 .5956 L
.62019 .59281 L
.59615 .58736 L
.57212 .57855 L
.55694 .57212 L
.54808 .56284 L
.5436 .54808 L
.53737 .52404 L
.53524 .5 L
.53737 .47596 L
.5436 .45192 L
.54808 .43716 L
.55694 .42788 L
.57212 .42145 L
.59615 .41264 L
.62019 .40719 L
.64423 .4044 L
.65397 .40385 L
F
0 g
.66827 .40361 m
.68661 .40385 L
.69231 .40411 L
.71635 .4061 L
.74038 .40948 L
.76442 .41425 L
.78846 .42007 L
.8125 .42588 L
.82179 .42788 L
.83654 .43538 L
.85832 .45192 L
.86058 .4531 L
.87452 .47596 L
.87951 .5 L
.87452 .52404 L
.86058 .5469 L
.85832 .54808 L
.83654 .56462 L
.82179 .57212 L
.8125 .57412 L
.78846 .57993 L
.76442 .58575 L
.74038 .59052 L
.71635 .5939 L
.69231 .59589 L
.68661 .59615 L
.66827 .59639 L
.65397 .59615 L
.64423 .5956 L
.62019 .59281 L
.59615 .58736 L
.57212 .57855 L
.55694 .57212 L
.54808 .56284 L
.5436 .54808 L
.53737 .52404 L
.53524 .5 L
.53737 .47596 L
.5436 .45192 L
.54808 .43716 L
.55694 .42788 L
.57212 .42145 L
.59615 .41264 L
.62019 .40719 L
.64423 .4044 L
.65397 .40385 L
.66827 .40361 L
s
.2 g
.66827 .06691 m
.68114 .06731 L
.69231 .06857 L
.71635 .07403 L
.74038 .08305 L
.75709 .09135 L
.76442 .09582 L
.78846 .11342 L
.79075 .11538 L
.8125 .13766 L
.81393 .13942 L
.83044 .16346 L
.83654 .17454 L
.84171 .1875 L
.84821 .21154 L
.84987 .23558 L
.84585 .25962 L
.83654 .28179 L
.83445 .28365 L
.8125 .30642 L
.81069 .30769 L
.78846 .32037 L
.76442 .32964 L
.75751 .33173 L
.74038 .33373 L
.71635 .33636 L
.69231 .33822 L
.66827 .33884 L
.64423 .33794 L
.62019 .33544 L
.59615 .33178 L
.59583 .33173 L
.57212 .31772 L
.56287 .30769 L
.55054 .28365 L
.54808 .27795 L
.54687 .25962 L
.54595 .23558 L
.54635 .21154 L
.54768 .1875 L
.54808 .18125 L
.55253 .16346 L
.56113 .13942 L
.57212 .11823 L
.574 .11538 L
.59613 .09135 L
.59615 .09133 L
.62019 .07697 L
.64423 .06937 L
.65913 .06731 L
F
0 g
.66827 .06691 m
.68114 .06731 L
.69231 .06857 L
.71635 .07403 L
.74038 .08305 L
.75709 .09135 L
.76442 .09582 L
.78846 .11342 L
.79075 .11538 L
.8125 .13766 L
.81393 .13942 L
.83044 .16346 L
.83654 .17454 L
.84171 .1875 L
.84821 .21154 L
.84987 .23558 L
.84585 .25962 L
.83654 .28179 L
.83445 .28365 L
.8125 .30642 L
.81069 .30769 L
.78846 .32037 L
.76442 .32964 L
.75751 .33173 L
.74038 .33373 L
.71635 .33636 L
.69231 .33822 L
.66827 .33884 L
.64423 .33794 L
.62019 .33544 L
.59615 .33178 L
.59583 .33173 L
.57212 .31772 L
.56287 .30769 L
.55054 .28365 L
.54808 .27795 L
.54687 .25962 L
.54595 .23558 L
.54635 .21154 L
.54768 .1875 L
.54808 .18125 L
.55253 .16346 L
.56113 .13942 L
.57212 .11823 L
.574 .11538 L
.59613 .09135 L
.59615 .09133 L
.62019 .07697 L
.64423 .06937 L
.65913 .06731 L
Mistroke
.66827 .06691 L
Mfstroke
.2 g
.59615 .66822 m
.62019 .66456 L
.64423 .66206 L
.66827 .66116 L
.69231 .66178 L
.71635 .66364 L
.74038 .66627 L
.75751 .66827 L
.76442 .67036 L
.78846 .67963 L
.81069 .69231 L
.8125 .69358 L
.83445 .71635 L
.83654 .71821 L
.84585 .74038 L
.84987 .76442 L
.84821 .78846 L
.84171 .8125 L
.83654 .82546 L
.83044 .83654 L
.81393 .86058 L
.8125 .86234 L
.79075 .88462 L
.78846 .88658 L
.76442 .90418 L
.75709 .90865 L
.74038 .91695 L
.71635 .92597 L
.69231 .93143 L
.68114 .93269 L
.66827 .93309 L
.65913 .93269 L
.64423 .93063 L
.62019 .92303 L
.59615 .90867 L
.59613 .90865 L
.574 .88462 L
.57212 .88177 L
.56113 .86058 L
.55253 .83654 L
.54808 .81875 L
.54768 .8125 L
.54635 .78846 L
.54595 .76442 L
.54687 .74038 L
.54808 .72205 L
.55054 .71635 L
.56287 .69231 L
.57212 .68228 L
.59583 .66827 L
F
0 g
.59615 .66822 m
.62019 .66456 L
.64423 .66206 L
.66827 .66116 L
.69231 .66178 L
.71635 .66364 L
.74038 .66627 L
.75751 .66827 L
.76442 .67036 L
.78846 .67963 L
.81069 .69231 L
.8125 .69358 L
.83445 .71635 L
.83654 .71821 L
.84585 .74038 L
.84987 .76442 L
.84821 .78846 L
.84171 .8125 L
.83654 .82546 L
.83044 .83654 L
.81393 .86058 L
.8125 .86234 L
.79075 .88462 L
.78846 .88658 L
.76442 .90418 L
.75709 .90865 L
.74038 .91695 L
.71635 .92597 L
.69231 .93143 L
.68114 .93269 L
.66827 .93309 L
.65913 .93269 L
.64423 .93063 L
.62019 .92303 L
.59615 .90867 L
.59613 .90865 L
.574 .88462 L
.57212 .88177 L
.56113 .86058 L
.55253 .83654 L
.54808 .81875 L
.54768 .8125 L
.54635 .78846 L
.54595 .76442 L
.54687 .74038 L
.54808 .72205 L
.55054 .71635 L
.56287 .69231 L
.57212 .68228 L
.59583 .66827 L
Mistroke
.59615 .66822 L
Mfstroke
.2 g
.62019 .42414 m
.64423 .42163 L
.66827 .42073 L
.69231 .42135 L
.71635 .42322 L
.74038 .42589 L
.75642 .42788 L
.76442 .43029 L
.78846 .43981 L
.80812 .45192 L
.8125 .45382 L
.8288 .47596 L
.83487 .5 L
.8288 .52404 L
.8125 .54618 L
.80812 .54808 L
.78846 .56019 L
.76442 .56971 L
.75642 .57212 L
.74038 .57411 L
.71635 .57678 L
.69231 .57865 L
.66827 .57927 L
.64423 .57837 L
.62019 .57586 L
.59658 .57212 L
.59615 .57193 L
.57212 .55737 L
.56424 .54808 L
.55335 .52404 L
.55034 .5 L
.55335 .47596 L
.56424 .45192 L
.57212 .44263 L
.59615 .42807 L
.59658 .42788 L
F
0 g
.62019 .42414 m
.64423 .42163 L
.66827 .42073 L
.69231 .42135 L
.71635 .42322 L
.74038 .42589 L
.75642 .42788 L
.76442 .43029 L
.78846 .43981 L
.80812 .45192 L
.8125 .45382 L
.8288 .47596 L
.83487 .5 L
.8288 .52404 L
.8125 .54618 L
.80812 .54808 L
.78846 .56019 L
.76442 .56971 L
.75642 .57212 L
.74038 .57411 L
.71635 .57678 L
.69231 .57865 L
.66827 .57927 L
.64423 .57837 L
.62019 .57586 L
.59658 .57212 L
.59615 .57193 L
.57212 .55737 L
.56424 .54808 L
.55335 .52404 L
.55034 .5 L
.55335 .47596 L
.56424 .45192 L
.57212 .44263 L
.59615 .42807 L
.59658 .42788 L
.62019 .42414 L
s
.3 g
.66827 .09107 m
.67853 .09135 L
.69231 .09297 L
.71635 .09915 L
.74038 .10955 L
.75076 .11538 L
.76442 .1249 L
.78117 .13942 L
.78846 .14705 L
.80119 .16346 L
.8125 .1828 L
.81447 .1875 L
.82192 .21154 L
.8238 .23558 L
.81923 .25962 L
.8125 .2769 L
.80588 .28365 L
.78846 .30054 L
.7771 .30769 L
.76442 .31397 L
.74038 .3225 L
.71635 .32797 L
.69231 .33106 L
.68163 .33173 L
.66827 .33184 L
.65866 .33173 L
.64423 .33062 L
.62019 .32624 L
.59615 .31699 L
.58252 .30769 L
.57212 .29626 L
.56545 .28365 L
.55829 .25962 L
.5559 .23558 L
.55688 .21154 L
.56084 .1875 L
.56801 .16346 L
.57212 .15351 L
.57992 .13942 L
.59615 .11953 L
.60043 .11538 L
.62019 .10251 L
.64423 .09387 L
.66161 .09135 L
F
0 g
.66827 .09107 m
.67853 .09135 L
.69231 .09297 L
.71635 .09915 L
.74038 .10955 L
.75076 .11538 L
.76442 .1249 L
.78117 .13942 L
.78846 .14705 L
.80119 .16346 L
.8125 .1828 L
.81447 .1875 L
.82192 .21154 L
.8238 .23558 L
.81923 .25962 L
.8125 .2769 L
.80588 .28365 L
.78846 .30054 L
.7771 .30769 L
.76442 .31397 L
.74038 .3225 L
.71635 .32797 L
.69231 .33106 L
.68163 .33173 L
.66827 .33184 L
.65866 .33173 L
.64423 .33062 L
.62019 .32624 L
.59615 .31699 L
.58252 .30769 L
.57212 .29626 L
.56545 .28365 L
.55829 .25962 L
.5559 .23558 L
.55688 .21154 L
.56084 .1875 L
.56801 .16346 L
.57212 .15351 L
.57992 .13942 L
.59615 .11953 L
.60043 .11538 L
.62019 .10251 L
.64423 .09387 L
.66161 .09135 L
.66827 .09107 L
s
.3 g
.66827 .66816 m
.68163 .66827 L
.69231 .66894 L
.71635 .67203 L
.74038 .6775 L
.76442 .68603 L
.7771 .69231 L
.78846 .69946 L
.80588 .71635 L
.8125 .7231 L
.81923 .74038 L
.8238 .76442 L
.82192 .78846 L
.81447 .8125 L
.8125 .8172 L
.80119 .83654 L
.78846 .85295 L
.78117 .86058 L
.76442 .8751 L
.75076 .88462 L
.74038 .89045 L
.71635 .90085 L
.69231 .90703 L
.67853 .90865 L
.66827 .90893 L
.66161 .90865 L
.64423 .90613 L
.62019 .89749 L
.60043 .88462 L
.59615 .88047 L
.57992 .86058 L
.57212 .84649 L
.56801 .83654 L
.56084 .8125 L
.55688 .78846 L
.5559 .76442 L
.55829 .74038 L
.56545 .71635 L
.57212 .70374 L
.58252 .69231 L
.59615 .68301 L
.62019 .67376 L
.64423 .66938 L
.65866 .66827 L
F
0 g
.66827 .66816 m
.68163 .66827 L
.69231 .66894 L
.71635 .67203 L
.74038 .6775 L
.76442 .68603 L
.7771 .69231 L
.78846 .69946 L
.80588 .71635 L
.8125 .7231 L
.81923 .74038 L
.8238 .76442 L
.82192 .78846 L
.81447 .8125 L
.8125 .8172 L
.80119 .83654 L
.78846 .85295 L
.78117 .86058 L
.76442 .8751 L
.75076 .88462 L
.74038 .89045 L
.71635 .90085 L
.69231 .90703 L
.67853 .90865 L
.66827 .90893 L
.66161 .90865 L
.64423 .90613 L
.62019 .89749 L
.60043 .88462 L
.59615 .88047 L
.57992 .86058 L
.57212 .84649 L
.56801 .83654 L
.56084 .8125 L
.55688 .78846 L
.5559 .76442 L
.55829 .74038 L
.56545 .71635 L
.57212 .70374 L
.58252 .69231 L
.59615 .68301 L
.62019 .67376 L
.64423 .66938 L
.65866 .66827 L
.66827 .66816 L
s
.3 g
.59615 .44341 m
.62019 .43374 L
.64423 .42931 L
.66827 .42793 L
.69231 .42887 L
.71635 .43199 L
.74038 .43759 L
.76442 .44673 L
.77388 .45192 L
.78846 .45935 L
.79926 .47596 L
.80636 .5 L
.79926 .52404 L
.78846 .54065 L
.77388 .54808 L
.76442 .55327 L
.74038 .56241 L
.71635 .56801 L
.69231 .57113 L
.66827 .57207 L
.64423 .57069 L
.62019 .56626 L
.59615 .55659 L
.58461 .54808 L
.57212 .53436 L
.56908 .52404 L
.56519 .5 L
.56908 .47596 L
.57212 .46564 L
.58461 .45192 L
F
0 g
.59615 .44341 m
.62019 .43374 L
.64423 .42931 L
.66827 .42793 L
.69231 .42887 L
.71635 .43199 L
.74038 .43759 L
.76442 .44673 L
.77388 .45192 L
.78846 .45935 L
.79926 .47596 L
.80636 .5 L
.79926 .52404 L
.78846 .54065 L
.77388 .54808 L
.76442 .55327 L
.74038 .56241 L
.71635 .56801 L
.69231 .57113 L
.66827 .57207 L
.64423 .57069 L
.62019 .56626 L
.59615 .55659 L
.58461 .54808 L
.57212 .53436 L
.56908 .52404 L
.56519 .5 L
.56908 .47596 L
.57212 .46564 L
.58461 .45192 L
.59615 .44341 L
s
.4 g
.64423 .11291 m
.66827 .10985 L
.69231 .11193 L
.71124 .11538 L
.71635 .11881 L
.74038 .13085 L
.75291 .13942 L
.76442 .14926 L
.77751 .16346 L
.78846 .17884 L
.79291 .1875 L
.80144 .21154 L
.80357 .23558 L
.79838 .25962 L
.78846 .27945 L
.78301 .28365 L
.76442 .29911 L
.7476 .30769 L
.74038 .31051 L
.71635 .31739 L
.69231 .32119 L
.66827 .32234 L
.64423 .32065 L
.62019 .31524 L
.60264 .30769 L
.59615 .3033 L
.57877 .28365 L
.57212 .27153 L
.56957 .25962 L
.5667 .23558 L
.56787 .21154 L
.57212 .18953 L
.5727 .1875 L
.58225 .16346 L
.59615 .14273 L
.59894 .13942 L
.62019 .12265 L
.63265 .11538 L
F
0 g
.64423 .11291 m
.66827 .10985 L
.69231 .11193 L
.71124 .11538 L
.71635 .11881 L
.74038 .13085 L
.75291 .13942 L
.76442 .14926 L
.77751 .16346 L
.78846 .17884 L
.79291 .1875 L
.80144 .21154 L
.80357 .23558 L
.79838 .25962 L
.78846 .27945 L
.78301 .28365 L
.76442 .29911 L
.7476 .30769 L
.74038 .31051 L
.71635 .31739 L
.69231 .32119 L
.66827 .32234 L
.64423 .32065 L
.62019 .31524 L
.60264 .30769 L
.59615 .3033 L
.57877 .28365 L
.57212 .27153 L
.56957 .25962 L
.5667 .23558 L
.56787 .21154 L
.57212 .18953 L
.5727 .1875 L
.58225 .16346 L
.59615 .14273 L
.59894 .13942 L
.62019 .12265 L
.63265 .11538 L
.64423 .11291 L
s
.4 g
.62019 .68476 m
.64423 .67935 L
.66827 .67766 L
.69231 .67881 L
.71635 .68261 L
.74038 .68949 L
.7476 .69231 L
.76442 .70089 L
.78301 .71635 L
.78846 .72055 L
.79838 .74038 L
.80357 .76442 L
.80144 .78846 L
.79291 .8125 L
.78846 .82116 L
.77751 .83654 L
.76442 .85074 L
.75291 .86058 L
.74038 .86915 L
.71635 .88119 L
.71124 .88462 L
.69231 .88807 L
.66827 .89015 L
.64423 .88709 L
.63265 .88462 L
.62019 .87735 L
.59894 .86058 L
.59615 .85727 L
.58225 .83654 L
.5727 .8125 L
.57212 .81047 L
.56787 .78846 L
.5667 .76442 L
.56957 .74038 L
.57212 .72847 L
.57877 .71635 L
.59615 .6967 L
.60264 .69231 L
F
0 g
.62019 .68476 m
.64423 .67935 L
.66827 .67766 L
.69231 .67881 L
.71635 .68261 L
.74038 .68949 L
.7476 .69231 L
.76442 .70089 L
.78301 .71635 L
.78846 .72055 L
.79838 .74038 L
.80357 .76442 L
.80144 .78846 L
.79291 .8125 L
.78846 .82116 L
.77751 .83654 L
.76442 .85074 L
.75291 .86058 L
.74038 .86915 L
.71635 .88119 L
.71124 .88462 L
.69231 .88807 L
.66827 .89015 L
.64423 .88709 L
.63265 .88462 L
.62019 .87735 L
.59894 .86058 L
.59615 .85727 L
.58225 .83654 L
.5727 .8125 L
.57212 .81047 L
.56787 .78846 L
.5667 .76442 L
.56957 .74038 L
.57212 .72847 L
.57877 .71635 L
.59615 .6967 L
.60264 .69231 L
.62019 .68476 L
s
.5 g
.64423 .12928 m
.66827 .12578 L
.69231 .12815 L
.71635 .13597 L
.72384 .13942 L
.74038 .14993 L
.75595 .16346 L
.76442 .17278 L
.77407 .1875 L
.78384 .21154 L
.78625 .23558 L
.78036 .25962 L
.76442 .28263 L
.7625 .28365 L
.74038 .29866 L
.71635 .30744 L
.7161 .30769 L
.69231 .31209 L
.66827 .31347 L
.64423 .31144 L
.62481 .30769 L
.62019 .30477 L
.59615 .28835 L
.5923 .28365 L
.58043 .25962 L
.57676 .23558 L
.57825 .21154 L
.58449 .1875 L
.59615 .16456 L
.5969 .16346 L
.62019 .14035 L
.62074 .13942 L
F
0 g
.64423 .12928 m
.66827 .12578 L
.69231 .12815 L
.71635 .13597 L
.72384 .13942 L
.74038 .14993 L
.75595 .16346 L
.76442 .17278 L
.77407 .1875 L
.78384 .21154 L
.78625 .23558 L
.78036 .25962 L
.76442 .28263 L
.7625 .28365 L
.74038 .29866 L
.71635 .30744 L
.7161 .30769 L
.69231 .31209 L
.66827 .31347 L
.64423 .31144 L
.62481 .30769 L
.62019 .30477 L
.59615 .28835 L
.5923 .28365 L
.58043 .25962 L
.57676 .23558 L
.57825 .21154 L
.58449 .1875 L
.59615 .16456 L
.5969 .16346 L
.62019 .14035 L
.62074 .13942 L
.64423 .12928 L
s
.5 g
.64423 .68856 m
.66827 .68653 L
.69231 .68791 L
.7161 .69231 L
.71635 .69256 L
.74038 .70134 L
.7625 .71635 L
.76442 .71737 L
.78036 .74038 L
.78625 .76442 L
.78384 .78846 L
.77407 .8125 L
.76442 .82722 L
.75595 .83654 L
.74038 .85007 L
.72384 .86058 L
.71635 .86403 L
.69231 .87185 L
.66827 .87422 L
.64423 .87072 L
.62074 .86058 L
.62019 .85965 L
.5969 .83654 L
.59615 .83544 L
.58449 .8125 L
.57825 .78846 L
.57676 .76442 L
.58043 .74038 L
.5923 .71635 L
.59615 .71165 L
.62019 .69523 L
.62481 .69231 L
F
0 g
.64423 .68856 m
.66827 .68653 L
.69231 .68791 L
.7161 .69231 L
.71635 .69256 L
.74038 .70134 L
.7625 .71635 L
.76442 .71737 L
.78036 .74038 L
.78625 .76442 L
.78384 .78846 L
.77407 .8125 L
.76442 .82722 L
.75595 .83654 L
.74038 .85007 L
.72384 .86058 L
.71635 .86403 L
.69231 .87185 L
.66827 .87422 L
.64423 .87072 L
.62074 .86058 L
.62019 .85965 L
.5969 .83654 L
.59615 .83544 L
.58449 .8125 L
.57825 .78846 L
.57676 .76442 L
.58043 .74038 L
.5923 .71635 L
.59615 .71165 L
.62019 .69523 L
.62481 .69231 L
.64423 .68856 L
s
.4 g
.62019 .44532 m
.64423 .43951 L
.66827 .43775 L
.69231 .43894 L
.71635 .44298 L
.74038 .45067 L
.74327 .45192 L
.76442 .46122 L
.77522 .47596 L
.78357 .5 L
.77522 .52404 L
.76442 .53878 L
.74327 .54808 L
.74038 .54933 L
.71635 .55702 L
.69231 .56106 L
.66827 .56225 L
.64423 .56049 L
.62019 .55468 L
.60576 .54808 L
.59615 .54362 L
.58373 .52404 L
.57842 .5 L
.58373 .47596 L
.59615 .45638 L
.60576 .45192 L
F
0 g
.62019 .44532 m
.64423 .43951 L
.66827 .43775 L
.69231 .43894 L
.71635 .44298 L
.74038 .45067 L
.74327 .45192 L
.76442 .46122 L
.77522 .47596 L
.78357 .5 L
.77522 .52404 L
.76442 .53878 L
.74327 .54808 L
.74038 .54933 L
.71635 .55702 L
.69231 .56106 L
.66827 .56225 L
.64423 .56049 L
.62019 .55468 L
.60576 .54808 L
.59615 .54362 L
.58373 .52404 L
.57842 .5 L
.58373 .47596 L
.59615 .45638 L
.60576 .45192 L
.62019 .44532 L
s
.6 g
.62019 .1571 m
.64423 .14419 L
.66827 .14023 L
.69231 .14291 L
.71635 .15192 L
.73439 .16346 L
.74038 .16857 L
.75643 .1875 L
.76442 .2024 L
.76767 .21154 L
.77038 .23558 L
.76442 .25814 L
.7637 .25962 L
.74246 .28365 L
.74038 .28517 L
.71635 .29733 L
.69231 .30318 L
.66827 .30485 L
.64423 .30238 L
.62019 .29378 L
.60636 .28365 L
.59615 .2725 L
.59147 .25962 L
.58692 .23558 L
.58875 .21154 L
.59615 .18847 L
.59657 .1875 L
.61281 .16346 L
F
0 g
.62019 .1571 m
.64423 .14419 L
.66827 .14023 L
.69231 .14291 L
.71635 .15192 L
.73439 .16346 L
.74038 .16857 L
.75643 .1875 L
.76442 .2024 L
.76767 .21154 L
.77038 .23558 L
.76442 .25814 L
.7637 .25962 L
.74246 .28365 L
.74038 .28517 L
.71635 .29733 L
.69231 .30318 L
.66827 .30485 L
.64423 .30238 L
.62019 .29378 L
.60636 .28365 L
.59615 .2725 L
.59147 .25962 L
.58692 .23558 L
.58875 .21154 L
.59615 .18847 L
.59657 .1875 L
.61281 .16346 L
.62019 .1571 L
s
.6 g
.62019 .70622 m
.64423 .69762 L
.66827 .69515 L
.69231 .69682 L
.71635 .70267 L
.74038 .71483 L
.74246 .71635 L
.7637 .74038 L
.76442 .74186 L
.77038 .76442 L
.76767 .78846 L
.76442 .7976 L
.75643 .8125 L
.74038 .83143 L
.73439 .83654 L
.71635 .84808 L
.69231 .85709 L
.66827 .85977 L
.64423 .85581 L
.62019 .8429 L
.61281 .83654 L
.59657 .8125 L
.59615 .81153 L
.58875 .78846 L
.58692 .76442 L
.59147 .74038 L
.59615 .7275 L
.60636 .71635 L
F
0 g
.62019 .70622 m
.64423 .69762 L
.66827 .69515 L
.69231 .69682 L
.71635 .70267 L
.74038 .71483 L
.74246 .71635 L
.7637 .74038 L
.76442 .74186 L
.77038 .76442 L
.76767 .78846 L
.76442 .7976 L
.75643 .8125 L
.74038 .83143 L
.73439 .83654 L
.71635 .84808 L
.69231 .85709 L
.66827 .85977 L
.64423 .85581 L
.62019 .8429 L
.61281 .83654 L
.59657 .8125 L
.59615 .81153 L
.58875 .78846 L
.58692 .76442 L
.59147 .74038 L
.59615 .7275 L
.60636 .71635 L
.62019 .70622 L
s
.5 g
.64423 .4496 m
.66827 .4473 L
.69231 .44885 L
.71247 .45192 L
.71635 .45313 L
.74038 .46185 L
.75316 .47596 L
.76317 .5 L
.75316 .52404 L
.74038 .53815 L
.71635 .54687 L
.71247 .54808 L
.69231 .55115 L
.66827 .5527 L
.64423 .5504 L
.63105 .54808 L
.62019 .54492 L
.59877 .52404 L
.59615 .51885 L
.59184 .5 L
.59615 .48115 L
.59877 .47596 L
.62019 .45508 L
.63105 .45192 L
F
0 g
.64423 .4496 m
.66827 .4473 L
.69231 .44885 L
.71247 .45192 L
.71635 .45313 L
.74038 .46185 L
.75316 .47596 L
.76317 .5 L
.75316 .52404 L
.74038 .53815 L
.71635 .54687 L
.71247 .54808 L
.69231 .55115 L
.66827 .5527 L
.64423 .5504 L
.63105 .54808 L
.62019 .54492 L
.59877 .52404 L
.59615 .51885 L
.59184 .5 L
.59615 .48115 L
.59877 .47596 L
.62019 .45508 L
.63105 .45192 L
.64423 .4496 L
s
.7 g
.64423 .15865 m
.66827 .15405 L
.69231 .15716 L
.7128 .16346 L
.71635 .16766 L
.73872 .1875 L
.74038 .18973 L
.75212 .21154 L
.75526 .23558 L
.74745 .25962 L
.74038 .27134 L
.72091 .28365 L
.71635 .2859 L
.69231 .29374 L
.66827 .29589 L
.64423 .29269 L
.62184 .28365 L
.62019 .28213 L
.60274 .25962 L
.59736 .23558 L
.59949 .21154 L
.60925 .1875 L
.62019 .17385 L
.6306 .16346 L
F
0 g
.64423 .15865 m
.66827 .15405 L
.69231 .15716 L
.7128 .16346 L
.71635 .16766 L
.73872 .1875 L
.74038 .18973 L
.75212 .21154 L
.75526 .23558 L
.74745 .25962 L
.74038 .27134 L
.72091 .28365 L
.71635 .2859 L
.69231 .29374 L
.66827 .29589 L
.64423 .29269 L
.62184 .28365 L
.62019 .28213 L
.60274 .25962 L
.59736 .23558 L
.59949 .21154 L
.60925 .1875 L
.62019 .17385 L
.6306 .16346 L
.64423 .15865 L
s
.7 g
.64423 .70731 m
.66827 .70411 L
.69231 .70626 L
.71635 .7141 L
.72091 .71635 L
.74038 .72866 L
.74745 .74038 L
.75526 .76442 L
.75212 .78846 L
.74038 .81027 L
.73872 .8125 L
.71635 .83234 L
.7128 .83654 L
.69231 .84284 L
.66827 .84595 L
.64423 .84135 L
.6306 .83654 L
.62019 .82615 L
.60925 .8125 L
.59949 .78846 L
.59736 .76442 L
.60274 .74038 L
.62019 .71787 L
.62184 .71635 L
F
0 g
.64423 .70731 m
.66827 .70411 L
.69231 .70626 L
.71635 .7141 L
.72091 .71635 L
.74038 .72866 L
.74745 .74038 L
.75526 .76442 L
.75212 .78846 L
.74038 .81027 L
.73872 .8125 L
.71635 .83234 L
.7128 .83654 L
.69231 .84284 L
.66827 .84595 L
.64423 .84135 L
.6306 .83654 L
.62019 .82615 L
.60925 .8125 L
.59949 .78846 L
.59736 .76442 L
.60274 .74038 L
.62019 .71787 L
.62184 .71635 L
.64423 .70731 L
s
.6 g
.62019 .47032 m
.64423 .45729 L
.66827 .45502 L
.69231 .4565 L
.71635 .46386 L
.73083 .47596 L
.74038 .48859 L
.74329 .5 L
.74038 .51141 L
.73083 .52404 L
.71635 .53614 L
.69231 .5435 L
.66827 .54498 L
.64423 .54271 L
.62019 .52968 L
.61579 .52404 L
.60575 .5 L
.61579 .47596 L
F
0 g
.62019 .47032 m
.64423 .45729 L
.66827 .45502 L
.69231 .4565 L
.71635 .46386 L
.73083 .47596 L
.74038 .48859 L
.74329 .5 L
.74038 .51141 L
.73083 .52404 L
.71635 .53614 L
.69231 .5435 L
.66827 .54498 L
.64423 .54271 L
.62019 .52968 L
.61579 .52404 L
.60575 .5 L
.61579 .47596 L
.62019 .47032 L
s
.8 g
.64423 .17311 m
.66827 .16776 L
.69231 .17134 L
.71635 .18492 L
.7193 .1875 L
.73636 .21154 L
.73996 .23558 L
.73081 .25962 L
.71635 .27537 L
.69231 .28327 L
.68934 .28365 L
.66827 .28581 L
.65141 .28365 L
.64423 .28248 L
.62019 .26729 L
.61581 .25962 L
.60825 .23558 L
.61118 .21154 L
.62019 .19383 L
.62258 .1875 L
F
0 g
.64423 .17311 m
.66827 .16776 L
.69231 .17134 L
.71635 .18492 L
.7193 .1875 L
.73636 .21154 L
.73996 .23558 L
.73081 .25962 L
.71635 .27537 L
.69231 .28327 L
.68934 .28365 L
.66827 .28581 L
.65141 .28365 L
.64423 .28248 L
.62019 .26729 L
.61581 .25962 L
.60825 .23558 L
.61118 .21154 L
.62019 .19383 L
.62258 .1875 L
.64423 .17311 L
s
.8 g
.66827 .71419 m
.68934 .71635 L
.69231 .71673 L
.71635 .72463 L
.73081 .74038 L
.73996 .76442 L
.73636 .78846 L
.7193 .8125 L
.71635 .81508 L
.69231 .82866 L
.66827 .83224 L
.64423 .82689 L
.62258 .8125 L
.62019 .80617 L
.61118 .78846 L
.60825 .76442 L
.61581 .74038 L
.62019 .73271 L
.64423 .71752 L
.65141 .71635 L
F
0 g
.66827 .71419 m
.68934 .71635 L
.69231 .71673 L
.71635 .72463 L
.73081 .74038 L
.73996 .76442 L
.73636 .78846 L
.7193 .8125 L
.71635 .81508 L
.69231 .82866 L
.66827 .83224 L
.64423 .82689 L
.62258 .8125 L
.62019 .80617 L
.61118 .78846 L
.60825 .76442 L
.61581 .74038 L
.62019 .73271 L
.64423 .71752 L
.65141 .71635 L
.66827 .71419 L
s
.9 g
.66827 .18258 m
.6921 .1875 L
.69231 .18759 L
.71635 .20765 L
.71879 .21154 L
.72384 .23558 L
.71635 .25341 L
.71429 .25962 L
.69231 .27327 L
.66827 .27705 L
.64423 .27111 L
.62837 .25962 L
.62074 .23558 L
.62283 .21154 L
.64423 .18998 L
.64886 .1875 L
F
0 g
.66827 .18258 m
.6921 .1875 L
.69231 .18759 L
.71635 .20765 L
.71879 .21154 L
.72384 .23558 L
.71635 .25341 L
.71429 .25962 L
.69231 .27327 L
.66827 .27705 L
.64423 .27111 L
.62837 .25962 L
.62074 .23558 L
.62283 .21154 L
.64423 .18998 L
.64886 .1875 L
.66827 .18258 L
s
.9 g
.64423 .72889 m
.66827 .72295 L
.69231 .72673 L
.71429 .74038 L
.71635 .74659 L
.72384 .76442 L
.71879 .78846 L
.71635 .79235 L
.69231 .81241 L
.6921 .8125 L
.66827 .81742 L
.64886 .8125 L
.64423 .81002 L
.62283 .78846 L
.62074 .76442 L
.62837 .74038 L
F
0 g
.64423 .72889 m
.66827 .72295 L
.69231 .72673 L
.71429 .74038 L
.71635 .74659 L
.72384 .76442 L
.71879 .78846 L
.71635 .79235 L
.69231 .81241 L
.6921 .8125 L
.66827 .81742 L
.64886 .8125 L
.64423 .81002 L
.62283 .78846 L
.62074 .76442 L
.62837 .74038 L
.64423 .72889 L
s
.7 g
.64423 .47264 m
.66827 .46629 L
.69231 .47041 L
.70704 .47596 L
.71635 .4866 L
.72207 .5 L
.71635 .5134 L
.70704 .52404 L
.69231 .52959 L
.66827 .53371 L
.64423 .52736 L
.63738 .52404 L
.62137 .5 L
.63738 .47596 L
F
0 g
.64423 .47264 m
.66827 .46629 L
.69231 .47041 L
.70704 .47596 L
.71635 .4866 L
.72207 .5 L
.71635 .5134 L
.70704 .52404 L
.69231 .52959 L
.66827 .53371 L
.64423 .52736 L
.63738 .52404 L
.62137 .5 L
.63738 .47596 L
.64423 .47264 L
s
1 g
.66827 .20087 m
.69231 .20871 L
.69728 .21154 L
.70821 .23558 L
.69231 .25245 L
.66827 .25949 L
.64423 .2481 L
.63614 .23558 L
.64423 .21344 L
.64577 .21154 L
F
0 g
.66827 .20087 m
.69231 .20871 L
.69728 .21154 L
.70821 .23558 L
.69231 .25245 L
.66827 .25949 L
.64423 .2481 L
.63614 .23558 L
.64423 .21344 L
.64577 .21154 L
.66827 .20087 L
s
1 g
.64423 .7519 m
.66827 .74051 L
.69231 .74755 L
.70821 .76442 L
.69728 .78846 L
.69231 .79129 L
.66827 .79913 L
.64577 .78846 L
.64423 .78656 L
.63614 .76442 L
F
0 g
.64423 .7519 m
.66827 .74051 L
.69231 .74755 L
.70821 .76442 L
.69728 .78846 L
.69231 .79129 L
.66827 .79913 L
.64577 .78846 L
.64423 .78656 L
.63614 .76442 L
.64423 .7519 L
s
.8 g
.66827 .48682 m
.69198 .5 L
.66827 .51318 L
.64897 .5 L
F
0 g
.66827 .48682 m
.69198 .5 L
.66827 .51318 L
.64897 .5 L
.66827 .48682 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00C@3oool500000080oooo0P00000e0?ooo`@000000`3oool2000003L0oooo0P0000040?oo
o`800000=`3oool300000080oooo0P00000?0?ooo`00C`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000003D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000g0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0303oool004l0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0b
0?ooo`D0000000D0oooo0000003oool0oooo0000000>0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0380
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000>0?ooo`00C`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0<P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000003D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000e0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003P3oool0
04h0oooo0P0000040?ooo`800000=P3oool2000000@0oooo0P00000g0?ooo`800000103oool20000
03L0oooo0P0000030?ooo`8000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`000005000000L0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooodT00000400I6AU8000001406ATIA`0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080ooooA000000H01TI6D8000006@0I6AU2000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooom0000001l06ATI
?000000O01TI6Cl000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo?P00
000S01TI6CP000008`0I6ATm000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`02
0?oooc`000009`0I6ATd000002L06ATI>`0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo>P00000[01TI6C000000:`0I6ATi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolh000002h06ATI;P00000^01TI6CL0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocH00000
<@0I6AT/000003406ATI=@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo=@00000d01TI6BT00000<`0I6ATd000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolc000001L06ATI2`00000E01TI6BL00000500I6AT;
000001L06ATI<P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo<@00000F01TI6@<000002`0c<c<4000001406ATI9P00000A01TI6@@000002`0c<c<40000
01D06ATI<00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo<000000D01TI6@<000004P0c<c<3000000l06ATI9000000?01TI6@<000004`0c<c<3000001<0
6ATI;`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
;P00000B01TI6@@00000600c<c<3000000d06ATI8P00000=01TI6@<000006@0c<c<3000001806ATI
;@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;@00
000A01TI6@8000007`0c<c<2000000/06ATI8P00000;01TI6@8000007`0c<c<2000001406ATI;000
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo;000000@
01TI6@8000008`0c<c<2000000X06ATI8000000:01TI6@8000008`0c<c<2000001006ATI:`000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolZ000001006ATI0P00000A03<c
<`P000003P0c<c<2000000T06ATI7P00000901TI6@8000003P0c<c<800000140<c<c0P00000@01TI
6BT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooo:@00000@01TI6@03
0000000c<c<0<c<c00d0<c<c1000000804a<C0@00000300c<c<00`0000006ATI01TI6@0601TI6Ah0
0000200I6AT00`000000<c<c03<c<`0:03<c<`@00000201<C4`5000000h0<c<c00<0000001TI6@0I
6AT03P0I6ATX000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolX000001006ATI00<0000003<c<`0c<c<02@0c<c<500000100C4a<0`00000903<c<`030000
000I6AT06ATI00L06ATI7000000901TI6@030000000c<c<0<c<c00L0<c<c0`00000A04a<C0@00000
2`0c<c<00`0000006ATI01TI6@0>01TI6BL000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooobL000003`0I6AT2000000X0<c<c0P00000H04a<C0800000200c
<c<00`0000006ATI01TI6@0601TI6A`00000200I6AT00`000000<c<c03<c<`0603<c<`800000601<
C4`2000000X0<c<c0P00000?01TI6BH000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooobH000003`0I6AT00`000000<c<c03<c<`0803<c<`800000701<C4`2
000000L0<c<c00<0000001TI6@0I6AT01P0I6ATJ000000P06ATI00<0000003<c<`0c<c<01P0c<c<0
0`000000C4a<04a<C00J04a<C08000002P0c<c<00`0000006ATI01TI6@0=01TI6BD000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobD000003P0I6AT20000
00T0<c<c0P00000?04a<C0D00000301<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI
00D06ATI6P00000701TI6@030000000c<c<0<c<c00D0<c<c0P00000;04a<C0D000003`1<C4`20000
00T0<c<c0P00000>01TI6B@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooobD000003@0I6AT00`000000<c<c03<c<`0803<c<`030000001<C4`0C4a<00T0
C4a<1P00000506IVIPD00000201<C4`2000000D0<c<c00<0000001TI6@0I6AT01@0I6ATJ000000L0
6ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00604a<C0D000001@1VIVH6000000/0
C4a<00<0000003<c<`0c<c<0200c<c<00`0000006ATI01TI6@0;01TI6B@000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob@000003@0I6AT00`000000<c<c
03<c<`0803<c<`030000001<C4`0C4a<00L0C4a<0`00000@06IVIP<000001`1<C4`00`000000<c<c
03<c<`0303<c<`8000001@0I6ATJ000000D06ATI0P00000603<c<`030000001<C4`0C4a<00@0C4a<
0`00000@06IVIP<000002@1<C4`00`000000<c<c03<c<`0803<c<`030000000I6AT06ATI00/06ATI
8`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo8`00
000=01TI6@030000000c<c<0<c<c00L0<c<c0P00000804a<C08000005P1VIVH2000000H0C4a<00<0
000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0301TI6AX00000100I6AT00`000000<c<c03<c
<`0403<c<`8000001@1<C4`2000001H0IVIV0P00000804a<C08000002@0c<c<00`0000006ATI01TI
6@0;01TI6B8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooob8000003@0I6AT00`000000<c<c03<c<`0603<c<`800000201<C4`2000000/0IVIV1@00000:
06IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@03
01TI6AP000001@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00@0C4a<00<00000
06IVIP1VIVH0201VIVH5000000/0IVIV0P00000804a<C0800000200c<c<00`0000006ATI01TI6@0;
01TI6B4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ob800000300I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00H0C4a<0P00000806IV
IPD000001@1oOgl4000000L0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0203<c
<`030000000I6AT06ATI00<06ATI6000000401TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<
C01<C4`0101<C4`00`000000IVIV06IVIP0506IVIP@000001@1oOgl5000000P0IVIV0P00000804a<
C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATQ000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ000000`06ATI00<0000003<c<`0c
<c<01P0c<c<00`000000C4a<04a<C00504a<C08000001`1VIVH3000000h0Ogmo0P00000606IVIP80
0000101<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00806ATI6000000401TI6@03
0000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`2000000H0IVIV0P00000>07moO`@0
00001P1VIVH2000000L0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0:01TI6B00
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooob000000
300I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<00@0C4a<0P00000706IVIP800000
4`1oOgl2000000H0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0203<c<`030000
000I6AT06ATI00<06ATI5P00000401TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`0
0P1<C4`00`000000IVIV06IVIP0406IVIP800000501oOgl2000000H0IVIV0P00000604a<C0030000
000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02P0I6ATO000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo0P0000030?ooob0000002`0I6AT00`000000<c<c03<c<`0603<c<`030000001<
C4`0C4a<00@0C4a<00<0000006IVIP1VIVH01@1VIVH2000000X0Ogmo1@00000807moO`8000001@1V
IVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT00P0I
6ATF000000@06ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<C00204a<C0030000001V
IVH0IVIV00<0IVIV0P00000807moO`D000002`1oOgl2000000H0IVIV00<0000004a<C01<C4`0101<
C4`00`000000<c<c03<c<`0603<c<`030000000I6AT06ATI00X06ATI7P0000040?ooo`8000001`3o
ool001D0oooo00<000000?ooo`3oool00P3ooolO000000/06ATI00<0000003<c<`0c<c<01P0c<c<0
0`000000C4a<04a<C00304a<C08000001P1VIVH2000000L0Ogmo1@00000509VIV@@000001P1oOgl0
0`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<0080C4a<00D0000003<c<`0c<c<0<c<c0000
000401TI6AH00000100I6AT01@000000<c<c03<c<`0c<c<0000000@0C4a<00<0000006IVIP1VIVH0
0`1VIVH00`000000Ogmo07moO`0407moO`@000001@2IVIT5000000P0Ogmo00<0000006IVIP1VIVH0
101VIVH2000000D0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0901TI6Ah00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooal000002`0I
6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH0101V
IVH2000000H0Ogmo0`00000>09VIV@8000001@1oOgl00`000000IVIV06IVIP0306IVIP050000001<
C4`0C4a<04a<C0000000100c<c<0100000006ATI01TI6@0I6ATF000000<06ATI00<0000003<c<`0c
<c<00P0c<c<01@000000C4a<04a<C01<C4`0000000D0IVIV00<0000007moO`1oOgl00`1oOgl20000
00h0VIVI1000000507moO`8000001P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c
00D0<c<c00<0000001TI6@0I6AT02P0I6ATM000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolN000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000
C4a<04a<C00304a<C0030000001VIVH0IVIV00@0IVIV00<0000007moO`1oOgl0101oOgl2000001<0
VIVI0P00000407moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`01@000000
<c<c03<c<`0c<c<0000000<06ATI5@00000401TI6@050000000c<c<0<c<c03<c<`000000101<C4`0
0`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo0P00000D09VIV@8000001@1oOgl0
0`000000IVIV06IVIP0406IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<0
0`0000006ATI01TI6@0901TI6Ad000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?oooad000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<
00<0C4a<00<0000006IVIP1VIVH0101VIVH00`000000Ogmo07moO`0307moO`8000001@2IVIT:0000
00P0VIVI0P00000307moO`030000001VIVH0IVIV0080IVIV00D0000004a<C01<C4`0C4a<00000003
03<c<`030000000I6AT06ATI00806ATI5000000401TI6@050000000c<c<0<c<c03<c<`0000000`1<
C4`00`000000IVIV06IVIP0206IVIP040000001oOgl0Ogmo07moO`800000202IVIT:000000H0VIVI
00<0000007moO`1oOgl00`1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00@0C4a<
00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6A`000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooad000002`0I6AT00`000000<c<c03<c
<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH2000000@0Ogmo0P00
000409VIV@<000002P2c/k<5000000D0VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000
001<C4`0C4a<0080C4a<00D0000003<c<`0c<c<0<c<c0000000301TI6A@000000`0I6AT01@000000
<c<c03<c<`0c<c<0000000@0C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`030000002IVIT0
VIVI00<0VIVI1@00000:0;>c/`<00000102IVIT2000000@0Ogmo0P00000406IVIP030000001<C4`0
C4a<00@0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6A`000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa`000002`0I6AT00`00
0000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`00
0000Ogmo07moO`0307moO`030000002IVIT0VIVI0080VIVI0P00000B0;>c/`<000000`2IVIT01000
0000Ogmo07moO`1oOgl200000080IVIV00D0000004a<C01<C4`0C4a<0000000303<c<`040000000I
6AT06ATI01TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00<0000006IVIP1V
IVH00P00000307moO`040000002IVIT0VIVI09VIV@<000004P2c/k<2000000@0VIVI00<0000007mo
O`1oOgl00`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6A/000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooa`000002P0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`80
00001@2IVIT00`000000/k>c0;>c/`070;>c/`@000002@2c/k<01@000000VIVI09VIV@2IVIT00000
00<0Ogmo00@0000006IVIP1VIVH000000`1<C4`01@000000<c<c03<c<`0c<c<0000000<06ATI5000
000301TI6@050000000c<c<0<c<c03<c<`0000000P1<C4`010000000IVIV06IVIP00000407moO`05
0000002IVIT0VIVI09VIV@0000002@2c/k<4000000X0/k>c00<0000009VIV@2IVIT00P2IVIT20000
00@0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c
00D0<c<c00<0000001TI6@0I6AT0200I6ATK000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolK000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000
C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl00`000000
VIVI09VIV@0409VIV@030000002c/k<0/k>c00@0/k>c100000040<c<c0<000001P2c/k<00`000000
VIVI09VIV@0209VIV@050000001oOgl0Ogmo07moO`0000000P1VIVH01@000000C4a<04a<C01<C4`0
00000080<c<c00@0000001TI6@0I6AT06ATI5000000301TI6@040000000c<c<0<c<c000000<0C4a<
00@0000006IVIP1VIVH00000101oOgl01@000000VIVI09VIV@2IVIT0000000H0/k>c0`0000040<c<
c0@000001`2c/k<00`000000VIVI09VIV@0309VIV@030000001oOgl0Ogmo0080Ogmo00D0000006IV
IP1VIVH0IVIV0000000604a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATJ
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolK0000
00X06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0050000001VIVH0IVIV
06IVIP000000101oOgl00`000000VIVI09VIV@0409VIV@030000002c/k<0/k>c00<0/k>c0P00000;
0<c<c08000001@2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00@0000006IVIP1VIVH00000
0`1<C4`01@000000<c<c03<c<`0c<c<0000000806ATI4`00000301TI6@050000000c<c<0<c<c03<c
<`0000000P1<C4`010000000IVIV06IVIP00000407moO`050000002IVIT0VIVI09VIV@0000001@2c
/k<2000000/0c<c<0P0000060;>c/`030000002IVIT0VIVI00<0VIVI00<0000007moO`1oOgl00P1o
Ogl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI
01TI6@0801TI6AX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooa/000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<0080C4a<00<0
000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI0080VIVI0P00
00050;>c/`030000003<c<`0c<c<00d0c<c<0P0000040;>c/`050000002IVIT0VIVI09VIV@000000
0`1oOgl010000000IVIV06IVIP00000204a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATB0000
00<06ATI00D0000003<c<`0c<c<0<c<c0000000204a<C0040000001VIVH0IVIV000000<0Ogmo00D0
000009VIV@2IVIT0VIVI000000040;>c/`8000003`3<c<`2000000D0/k>c00<0000009VIV@2IVIT0
0P2IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0
0`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI6P0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6P00000:01TI6@030000000c
<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP030000001o
Ogl0Ogmo0080Ogmo00<0000009VIV@2IVIT00P2IVIT00`000000/k>c0;>c/`030;>c/`8000001`3<
c<`5000000H0c<c<0P0000030;>c/`050000002IVIT0VIVI09VIV@0000000P1oOgl010000000IVIV
06IVIP00000304a<C0040000000c<c<0<c<c000000<06ATI4P00000301TI6@040000000c<c<0<c<c
00000080C4a<00@0000006IVIP1VIVH00000101oOgl010000000VIVI09VIV@0000030;>c/`800000
1P3<c<`5000000P0c<c<0P0000040;>c/`030000002IVIT0VIVI0080VIVI00<0000007moO`1oOgl0
0P1oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<01@0c<c<00`000000
6ATI01TI6@0801TI6AT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo
6P00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV
06IVIP0206IVIP050000001oOgl0Ogmo07moO`000000102IVIT00`000000/k>c0;>c/`020;>c/`80
00001@3<c<`4000000D0i^KV0`0000050<c<c08000000P2c/k<01@000000VIVI09VIV@2IVIT00000
0080Ogmo00@0000006IVIP1VIVH000000P1<C4`010000000<c<c03<c<`00000301TI6A8000000`0I
6AT010000000<c<c03<c<`00000204a<C0040000001VIVH0IVIV000000<0Ogmo00@0000009VIV@2I
VIT000000P2c/k<2000000D0c<c<0`0000050>KViP@000001P3<c<`00`000000/k>c0;>c/`020;>c
/`030000002IVIT0VIVI0080VIVI00<0000007moO`1oOgl00P1oOgl01@000000IVIV06IVIP1VIVH0
000000D0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AT00000103oool2
000000L0oooo000E0?ooo`030000003oool0oooo0080oooo6P00000:01TI6@030000000c<c<0<c<c
00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP040000001oOgl0Ogmo
000000@0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0040<c<c0030000003Vi^H0
i^KV00X0i^KV00<000000<c<c03<c<`00`3<c<`010000000/k>c0;>c/`00000309VIV@040000001o
Ogl0Ogmo00000080IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6ATB0000
00<06ATI00@0000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP00000207moO`050000002I
VIT0VIVI09VIV@0000000P2c/k<00`000000c<c<0<c<c0030<c<c0030000003Vi^H0i^KV00X0i^KV
00<000000<c<c03<c<`0103<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@00
0000101oOgl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0801TI6AT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0
C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c
/`2c/k<00`2c/k<00`000000c<c<0<c<c0030<c<c0030000003Vi^H0i^KV00`0i^KV00<000000<c<
c03<c<`00P3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00@0000007moO`1oOgl000000P1V
IVH010000000C4a<04a<C000000203<c<`040000000I6AT06ATI01TI6A8000000`0I6AT010000000
<c<c03<c<`00000204a<C0040000001VIVH0IVIV00000080Ogmo00@0000009VIV@2IVIT000000`2c
/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV00`0i^KV00<000000<c<c03<c<`00`3<
c<`00`000000/k>c0;>c/`020;>c/`030000002IVIT0VIVI0080VIVI00<0000007moO`1oOgl00P1o
Ogl01@000000IVIV06IVIP1VIVH0000000D0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI
01TI6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooaT000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0
000006IVIP1VIVH00P1VIVH010000000Ogmo07moO`00000409VIV@030000002c/k<0/k>c0080/k>c
00<000000<c<c03<c<`00`3<c<`00`000000i^KV0>KViP0>0>KViP030000003<c<`0c<c<0080c<c<
00@000000;>c/`2c/k<000000`2IVIT00`000000Ogmo0000000206IVIP040000001<C4`0C4a<0000
0080<c<c00@0000001TI6@0I6AT06ATI4P00000301TI6@040000000c<c<0<c<c00000080C4a<00@0
000006IVIP1VIVH000000P1oOgl010000000VIVI09VIV@0000020;>c/`030000003<c<`0c<c<0080
c<c<00<000000>KViP3Vi^H03P3Vi^H2000000@0c<c<00<000000;>c/`2c/k<00P2c/k<01@000000
VIVI09VIV@2IVIT0000000@0Ogmo00D0000006IVIP1VIVH0IVIV0000000504a<C0030000000c<c<0
<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATH000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolI000000X06ATI00<0000003<c<`0c<c<0100c<c<00`00
0000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo00000003
09VIV@030000002c/k<0/k>c0080/k>c00<000000<c<c03<c<`00`3<c<`00`000000i^KV0>KViP06
0>KViP800000203Vi^H01@000000c<c<0<c<c03<c<`0000000<0/k>c00@0000009VIV@2IVIT00000
0P1oOgl00`000000IVIV0000000304a<C0040000000c<c<0<c<c000000<06ATI4000000401TI6@03
0000000c<c<000000080C4a<00@0000006IVIP1VIVH000000P1oOgl010000000VIVI09VIV@000003
0;>c/`050000003<c<`0c<c<0<c<c0000000203Vi^H2000000T0i^KV00<000000<c<c03<c<`00P3<
c<`01@000000/k>c0;>c/`2c/k<0000000@0VIVI00D0000007moO`1oOgl0Ogmo0000000406IVIP03
0000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AP0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT00000
2P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH0
0P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00D000000;>c/`2c/k<0/k>c000000050<c<
c0030000003Vi^H0i^KV00@0i^KV0`0000020?ooo`8000001`3Vi^H01@000000c<c<0<c<c03<c<`0
00000080/k>c00@0000009VIV@2IVIT000000P1oOgl010000000IVIV06IVIP00000204a<C0040000
000c<c<0<c<c000000<06ATI4000000401TI6@030000000c<c<000000080C4a<00@0000006IVIP1V
IVH000000P1oOgl010000000VIVI09VIV@0000020;>c/`050000003<c<`0c<c<0<c<c00000001`3V
i^H200000080oooo0`0000070>KViP030000003<c<`0c<c<0080c<c<00D000000;>c/`2c/k<0/k>c
0000000309VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C003
0000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATH000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0
100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0
Ogmo0000000309VIV@030000002c/k<0/k>c0080/k>c00<000000<c<c03<c<`00P3<c<`00`000000
i^KV0>KViP030>KViP8000001`3oool2000000H0i^KV00@000000<c<c03<c<`000000`2c/k<01P00
0000VIVI09VIV@000000Ogmo00000080IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI
01TI6@0I6AT@000000@06ATI00<0000003<c<`0000000P1<C4`010000000IVIV06IVIP00000207mo
O`030000002IVIT0000000<0/k>c00@000000<c<c03<c<`000001P3Vi^H2000000L0oooo0P000006
0>KViP050000003<c<`0c<c<0<c<c00000000`2c/k<00`000000VIVI09VIV@0209VIV@050000001o
Ogl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<
C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@050000
002c/k<0/k>c0;>c/`000000103<c<`00`000000i^KV0>KViP020>KViP8000002`3oool2000000D0
i^KV00@000000<c<c03<c<`000000P2c/k<01P000000VIVI09VIV@000000Ogmo00000080IVIV00@0
000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6AT@000000@06ATI00<0000003<c<`00
00000P1<C4`010000000IVIV06IVIP00000207moO`030000002IVIT000000080/k>c00@000000<c<
c03<c<`000001@3Vi^H2000000/0oooo0P0000040>KViP030000003<c<`0c<c<0080c<c<00D00000
0;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<
04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATG000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolH000000X06ATI00<0
000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0
000007moO`1oOgl0Ogmo0000000309VIV@050000002c/k<0/k>c0;>c/`000000103<c<`00`000000
i^KV0>KViP020>KViP030000003oool0oooo00/0oooo00<000000>KViP3Vi^H00`3Vi^H010000000
c<c<0<c<c00000020;>c/`060000002IVIT0VIVI0000001oOgl000000P1VIVH010000000C4a<04a<
C000000203<c<`040000000I6AT06ATI01TI6A000000100I6AT00`000000<c<c0000000204a<C004
0000001VIVH0IVIV00000080Ogmo00<0000009VIV@0000000P2c/k<010000000c<c<0<c<c0000005
0>KViP030000003oool0oooo00/0oooo00<000000>KViP3Vi^H00P3Vi^H00`000000c<c<0<c<c002
0<c<c0050000002c/k<0/k>c0;>c/`0000000`2IVIT01@000000Ogmo07moO`1oOgl0000000@0IVIV
00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI
5`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000
000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IV
IP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0000000@0
c<c<00D000000>KViP3Vi^H0i^KV0000000?0?ooo`030000003Vi^H0i^KV0080i^KV00@000000<c<
c03<c<`000000P2c/k<01P000000VIVI09VIV@000000Ogmo00000080IVIV00@0000004a<C01<C4`0
00000P0c<c<0100000006ATI01TI6@0I6AT@000000@06ATI00<0000003<c<`0000000P1<C4`01000
0000IVIV06IVIP00000207moO`030000002IVIT000000080/k>c00@000000<c<c03<c<`00000103V
i^H00`000000oooo0?ooo`0=0?ooo`030000003Vi^H0i^KV0080i^KV00D000000<c<c03<c<`0c<c<
000000030;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`000000IVIV06IVIP0206IVIP03
0000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AL0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaP00000
2P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0
IVIV0000000407moO`040000002IVIT0VIVI000000<0/k>c00<000000<c<c03<c<`00P3<c<`00`00
0000i^KV0>KViP020>KViP030000003oool0oooo00d0oooo00<000000>KViP3Vi^H00P3Vi^H01000
0000c<c<0<c<c00000020;>c/`060000002IVIT0VIVI0000001oOgl000000P1VIVH010000000C4a<
04a<C000000203<c<`040000000I6AT06ATI01TI6A0000000`0I6AT010000000<c<c03<c<`000002
04a<C0030000001VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<0<c<
c00000040>KViP030000003oool0oooo00d0oooo00<000000>KViP3Vi^H00P3Vi^H01@000000c<c<
0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV
0080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00P06ATI5`0000050?ooo`030000003oool0oooo00D0oooo00070?ooo`D000000P3oool2000000D0
oooo00<000000?ooo`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP000000101oOgl010000000VIVI09VIV@000003
0;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H00P3Vi^H00`000000oooo0?ooo`0=
0?ooo`030000003Vi^H0i^KV0080i^KV00L000000<c<c03<c<`0c<c<0000002c/k<000000080VIVI
00H0000007moO`1oOgl0000006IVIP00000204a<C0040000000c<c<0<c<c000000<06ATI40000003
01TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl010000000VIVI09VI
V@0000020;>c/`040000003<c<`0c<c<000000@0i^KV00<000000?ooo`3oool03@3oool00`000000
i^KV0>KViP020>KViP030000003<c<`0c<c<0080c<c<00D000000;>c/`2c/k<0/k>c0000000309VI
V@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0
<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool0
00T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<00000
0?ooo`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C002
04a<C0050000001VIVH0IVIV06IVIP000000101oOgl010000000VIVI09VIV@0000030;>c/`030000
003<c<`0c<c<0080c<c<00D000000>KViP3Vi^H0i^KV0000000A0?ooo`050000003Vi^H0i^KV0>KV
iP0000000`3<c<`00`000000/k>c0000000209VIV@060000001oOgl0Ogmo0000001VIVH000000P1<
C4`010000000<c<c03<c<`00000301TI6A0000000`0I6AT010000000<c<c03<c<`00000204a<C003
0000001VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<0<c<c0000003
0>KViP030000003oool0oooo00l0oooo00<000000>KViP3Vi^H00P3Vi^H01@000000c<c<0<c<c03<
c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0IVIV06IVIP00
0000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`0000050?ooo`03
0000003oool0oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000
oooo0?ooo`020?ooo`<000000P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000
C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP000000101oOgl010000000VIVI09VIV@000003
0;>c/`030000003<c<`0c<c<0080c<c<00D000000>KViP3Vi^H0i^KV0000000A0?ooo`050000003V
i^H0i^KV0>KViP0000000`3<c<`00`000000/k>c0000000209VIV@060000001oOgl0Ogmo0000001V
IVH000000P1<C4`010000000<c<c03<c<`00000301TI6A0000000`0I6AT010000000<c<c03<c<`00
000204a<C0030000001VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<
0<c<c00000030>KViP030000003oool0oooo00l0oooo00<000000>KViP3Vi^H00P3Vi^H01@000000
c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0
IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`00
00030?ooo`<000001`3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003o
ool0oooo0080oooo00<000000?ooo`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c
<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP000000101oOgl010000000VIVI
09VIV@0000030;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H00P3Vi^H00`000000
oooo0?ooo`0=0?ooo`030000003Vi^H0i^KV0080i^KV00L000000<c<c03<c<`0c<c<0000002c/k<0
00000080VIVI00H0000007moO`1oOgl0000006IVIP00000204a<C0040000000c<c<0<c<c000000<0
6ATI4000000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl01000
0000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<000000@0i^KV00<000000?ooo`3oool03@3o
ool00`000000i^KV0>KViP020>KViP050000003<c<`0c<c<0<c<c0000000102c/k<01@000000VIVI
09VIV@2IVIT0000000<0Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool000T0
oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo00<000000?oo
o`3oool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<
C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@050000002c/k<0
/k>c0;>c/`000000103<c<`00`000000i^KV0>KViP020>KViP030000003oool0oooo00`0oooo00D0
00000>KViP3Vi^H0i^KV000000030<c<c0040000002c/k<0/k>c00000080VIVI00H0000007moO`1o
Ogl0000006IVIP00000204a<C0040000000c<c<0<c<c000000<06ATI4000000301TI6@040000000c
<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl010000000VIVI09VIV@0000030;>c/`04
0000003<c<`0c<c<000000<0i^KV00<000000?ooo`3oool0303oool00`000000i^KV0>KViP030>KV
iP050000003<c<`0c<c<0<c<c00000000`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00<0
000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0
000001TI6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo0P000004
0?ooo`8000001@3oool00`000000oooo0?ooo`020?oooaP000002P0I6AT00`000000<c<c03<c<`04
03<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1o
Ogl0000000<0VIVI00D000000;>c/`2c/k<0/k>c000000040<c<c0030000003Vi^H0i^KV00<0i^KV
00<000000?ooo`3oool02P3oool00`000000i^KV0>KViP020>KViP070000003<c<`0c<c<0<c<c000
0000/k>c0000000209VIV@040000001oOgl0Ogmo00000080IVIV00<0000004a<C00000000P0c<c<0
0`0000006ATI01TI6@0201TI6A0000000`0I6AT010000000<c<c03<c<`00000204a<C0030000001V
IVH000000080Ogmo00@0000009VIV@2IVIT000000`2c/k<010000000c<c<0<c<c00000040>KViP03
0000003oool0oooo00X0oooo00<000000>KViP3Vi^H00`3Vi^H01@000000c<c<0<c<c03<c<`00000
00@0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0IVIV06IVIP000000101<
C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI600000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6@00000:01TI6@030000000c<c<0
<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00@0
000009VIV@2IVIT00000102c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV00<0i^KV
0P0000080?ooo`8000001@3Vi^H01`000000c<c<0<c<c03<c<`000000;>c/`0000000P2IVIT01000
0000Ogmo07moO`00000206IVIP030000001<C4`000000080<c<c00<0000001TI6@0I6AT00P0I6ATA
000000<06ATI00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`040000002I
VIT0VIVI00000080/k>c00@000000<c<c03<c<`000001@3Vi^H2000000P0oooo0P0000060>KViP05
0000003<c<`0c<c<0<c<c0000000102c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00D00000
06IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I
6ATH000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolI
000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0
IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@050000002c/k<0/k>c0;>c/`000000
103<c<`00`000000i^KV0>KViP050>KViP<000000`3oool2000000H0i^KV00D000000<c<c03<c<`0
c<c<000000020;>c/`040000002IVIT0VIVI00000080Ogmo00H0000006IVIP1VIVH0000004a<C000
000203<c<`030000000I6AT06ATI00806ATI4@00000301TI6@040000000c<c<0<c<c00000080C4a<
00<0000006IVIP0000000P1oOgl010000000VIVI09VIV@0000030;>c/`040000003<c<`0c<c<0000
00H0i^KV0P0000030?ooo`<000001`3Vi^H01@000000c<c<0<c<c03<c<`0000000@0/k>c00D00000
09VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<
C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI600000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6@00000:01TI6@030000000c<c<0
<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0
Ogmo07moO`0000000`2IVIT00`000000/k>c0;>c/`020;>c/`050000003<c<`0c<c<0<c<c0000000
2P3Vi^H3000000P0i^KV00D000000<c<c03<c<`0c<c<000000020;>c/`040000002IVIT0VIVI0000
0080Ogmo00H0000006IVIP1VIVH0000004a<C000000203<c<`030000000I6AT06ATI00806ATI4@00
000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1oOgl010000000VIVI
09VIV@0000030;>c/`040000003<c<`0c<c<000000P0i^KV0`00000:0>KViP050000003<c<`0c<c<
0<c<c0000000102c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00<0000006IVIP1VIVH00P1V
IVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I
6ATH000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolI
000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0
IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@030000002c/k<0/k>c0080/k>c00@0
00000<c<c03<c<`0c<c<0P00000B0>KViP050000003<c<`0c<c<0<c<c00000000P2c/k<01`000000
VIVI09VIV@2IVIT0000007moO`0000000`1VIVH00`000000C4a<0000000203<c<`030000000I6AT0
6ATI00806ATI4@00000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP0000000P1o
Ogl01@000000VIVI09VIV@2IVIT000000080/k>c00D000000<c<c03<c<`0c<c<0000000B0>KViP80
00000`3<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`00
0000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<01@0c<c<00`00
00006ATI01TI6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooaT000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080
C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`040000002IVIT0VIVI0000
00D0/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP0=0>KViP8000000`3<c<`01000
0000/k>c0;>c/`00000309VIV@040000001oOgl0Ogmo00000080IVIV00@0000004a<C01<C4`00000
0P0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00L0000003<c<`0c<c<0<c<c0000001<C4`0
00000080IVIV00@0000007moO`1oOgl000000`2IVIT010000000/k>c0;>c/`0000030<c<c0800000
3`3Vi^H00`000000c<c<0<c<c0020<c<c0030000002c/k<0/k>c00<0/k>c00@0000009VIV@2IVIT0
0000101oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c
<c<0100c<c<00`0000006ATI01TI6@0801TI6AT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooaX000002P0I6AT00`000000<c<c03<c<`0403<c<`030000
001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`040000
002IVIT0VIVI000000D0/k>c00<000000<c<c03<c<`00P3<c<`2000000X0i^KV0`0000030<c<c080
00000P2c/k<00`000000VIVI09VIV@0209VIV@030000001oOgl0000000<0IVIV00<0000004a<C000
00000`0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00L0000003<c<`0c<c<0<c<c0000001<
C4`000000080IVIV00@0000007moO`1oOgl000000`2IVIT010000000/k>c0;>c/`2c/k<2000000<0
c<c<0`00000:0>KViP8000001@3<c<`00`000000/k>c0;>c/`020;>c/`040000002IVIT0VIVI0000
00@0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c
00D0<c<c00<0000001TI6@0I6AT0200I6ATI000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolJ000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`000000
C4a<04a<C00204a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00P1oOgl00`000000
VIVI09VIV@02000000@0/k>c0P0000040<c<c0X000001@3<c<`00`000000/k>c0;>c/`020;>c/`05
0000002IVIT0VIVI09VIV@0000000P1oOgl010000000IVIV06IVIP00000204a<C0050000000c<c<0
<c<c03<c<`0000000`0I6ATC000000806ATI00D0000003<c<`0c<c<0<c<c0000000204a<C0040000
001VIVH0IVIV00000080Ogmo00D0000009VIV@2IVIT0VIVI000000040;>c/`030000003<c<`0c<c<
00<0c<c<2P0000050<c<c08000000`2c/k<200000080VIVI00<0000007moO`1oOgl00P1oOgl00`00
0000IVIV06IVIP0306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<01@0c<c<00`00
00006ATI01TI6@0801TI6AT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooaX000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0
C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0307moO`040000002IVIT0VIVI09VI
V@800000102c/k<3000000h0c<c<0P0000040;>c/`050000002IVIT0VIVI09VIV@0000000P1oOgl0
1@000000IVIV06IVIP1VIVH000000080C4a<00D0000003<c<`0c<c<0<c<c0000000201TI6A@00000
0P0I6AT00`000000<c<c03<c<`0203<c<`030000001<C4`000000080IVIV00D0000007moO`1oOgl0
Ogmo0000000309VIV@030000002c/k<0/k>c0080/k>c0P00000>0<c<c0@000000`2c/k<2000000<0
VIVI00<0000007moO`1oOgl00`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080
C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0801TI6AX000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool2000000<0oooo6`00000:01TI6@8000001P0c<c<00`000000C4a<
04a<C00304a<C0030000001VIVH0IVIV0080IVIV0P00000407moO`030000002IVIT0VIVI0080VIVI
00<000000;>c/`2c/k<0102c/k<5000000D0c<c<100000050;>c/`050000002IVIT0VIVI09VIV@00
00000`1oOgl010000000IVIV06IVIP00000304a<C0040000000c<c<0<c<c000000<06ATI50000003
01TI6@050000000c<c<0<c<c03<c<`0000000P1<C4`010000000IVIV06IVIP00000307moO`050000
002IVIT0VIVI09VIV@0000001@2c/k<4000000H0c<c<100000060;>c/`030000002IVIT0VIVI0080
VIVI00<0000007moO`1oOgl00`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0
C4a<00<0000003<c<`0c<c<0100c<c<2000000X06ATI6P0000040?ooo`8000001`3oool001D0oooo
00<000000?ooo`3oool00P3ooolL000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<
04a<C00304a<C0030000001VIVH0IVIV00<0IVIV00@0000007moO`1oOgl0Ogmo0P00000409VIV@<0
0000202c/k<5000000L0/k>c0P00000309VIV@050000001oOgl0Ogmo07moO`0000000P1VIVH01@00
0000C4a<04a<C01<C4`000000080<c<c00<0000001TI6@0I6AT00P0I6ATD000000<06ATI00D00000
03<c<`0c<c<0<c<c0000000304a<C0040000001VIVH0IVIV000000<0Ogmo00@0000009VIV@2IVIT0
VIVI0P0000070;>c/`H00000202c/k<2000000D0VIVI00@0000007moO`1oOgl0Ogmo0P00000406IV
IP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI
6A/000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooad0
00002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<0P00000406IVIP80
00000`1oOgl2000000D0VIVI0`00000?0;>c/`8000000`2IVIT200000080Ogmo0P00000206IVIP03
0000001<C4`0C4a<0080C4a<00@0000003<c<`0c<c<000000`0I6ATF000000<06ATI00D0000003<c
<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV008000000P1oOgl2000000<0VIVI0P00000?
0;>c/`@000001@2IVIT2000000<0Ogmo00<0000006IVIP1VIVH00P1VIVH2000000D0C4a<00<00000
03<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6A`000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooad00000300I6AT00`000000<c<c03<c<`0403<c
<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0207mo
O`8000001P2IVIT?000000<0VIVI0P00000307moO`030000001VIVH0IVIV0080IVIV00D0000004a<
C01<C4`0C4a<0000000203<c<`030000000I6AT06ATI00806ATI5P00000301TI6@050000000c<c<0
<c<c03<c<`0000000`1<C4`00`000000IVIV06IVIP0206IVIP040000001oOgl0Ogmo07moO`800000
0`2IVIT?000000L0VIVI0P00000307moO`800000101VIVH00`000000C4a<04a<C00404a<C0030000
000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATM000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooolN000000`06ATI00<0000003<c<`0c<c<0100c
<c<00`000000C4a<04a<C00404a<C0030000001VIVH0IVIV00<0IVIV0P00000407moO`@000004@2I
VIT3000000@0Ogmo00<0000006IVIP1VIVH00P1VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c
00<0000001TI6@0I6AT00P0I6ATF000000@06ATI00D0000003<c<`0c<c<0<c<c0000000304a<C003
0000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1oOgl300000140VIVI1@00000307moO`80
00001@1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I
6AT02P0I6ATM000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolO000000`06ATI00<0000003<c<`0c<c<0100c<c<2000000D0C4a<0P00000506IVIP@00000
101oOgl6000000L0VIVI1000000507moO`800000101VIVH01@000000C4a<04a<C01<C4`0000000<0
<c<c00<0000001TI6@0I6AT00P0I6ATH000000<06ATI00<0000003<c<`0c<c<00P0c<c<01@000000
C4a<04a<C01<C4`0000000@0IVIV0P00000507moO`@000001`2IVIT6000000D0Ogmo0`00000506IV
IP8000001@1<C4`2000000H0<c<c00<0000001TI6@0I6AT02P0I6ATN000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolP000000`06ATI00<0000003<c<`0c
<c<01@0c<c<2000000D0C4a<0P00000706IVIP<000001`1oOgl7000000D0Ogmo1000000306IVIP<0
00000`1<C4`00`000000<c<c03<c<`0203<c<`030000000I6AT06ATI00806ATI6000000401TI6@03
0000000c<c<0<c<c0080<c<c00@0000004a<C01<C4`0C4a<0`00000306IVIP@000001@1oOgl70000
00P0Ogmo0`00000606IVIP8000001@1<C4`2000000L0<c<c00<0000001TI6@0I6AT02P0I6ATO0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ000000`0
6ATI0P00000703<c<`8000001@1<C4`3000000L0IVIV0`00000;07moO`D000001@1VIVH2000000D0
C4a<00<0000003<c<`0c<c<00P0c<c<00`0000006ATI01TI6@0301TI6AP000001@0I6AT00`000000
<c<c03<c<`0203<c<`030000001<C4`0C4a<00<0C4a<0P00000506IVIPD000002`1oOgl4000000H0
IVIV0`00000504a<C08000001`0c<c<2000000`06ATI800000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo8P00000=01TI6@030000000c<c<0<c<c00H0<c<c
0P00000604a<C0@000001P1VIVH;000000L0IVIV0`00000604a<C0030000000c<c<0<c<c00<0<c<c
00<0000001TI6@0I6AT00P0I6ATI000000D06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<
04a<C00404a<C0<000001`1VIVH;000000L0IVIV0`00000604a<C0800000200c<c<00`0000006ATI
01TI6@0;01TI6B4000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooob@00000300I6AT2000000P0<c<c0`00000704a<C0@000004@1VIVH3000000L0C4a<0P00
000503<c<`030000000I6AT06ATI00<06ATI6P00000501TI6@030000000c<c<0<c<c00<0<c<c0P00
000704a<C0<000004@1VIVH5000000H0C4a<0`00000803<c<`800000300I6ATS000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolU000000d06ATI0P000009
03<c<`<00000201<C4`A000000H0C4a<1000000503<c<`8000001P0I6ATJ000000H06ATI0P000005
03<c<`@000001P1<C4`A000000P0C4a<0`00000903<c<`8000003@0I6ATT000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolV000000h06ATI0`00000903<c
<`@000005`1<C4`4000000P0<c<c00<0000001TI6@0I6AT01@0I6ATL000000L06ATI00<0000003<c
<`0c<c<01P0c<c<4000001P0C4a<0`00000903<c<`<000003P0I6ATU000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolX000000l06ATI0P00000;03<c<`T0
00002@1<C4`5000000X0<c<c0P00000801TI6A`00000200I6AT2000000X0<c<c1@00000:04a<C0T0
00002P0c<c<2000000l06ATI9`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`800000
0`3oool^000000/06ATI2@00000;03<c<`T000002`0c<c<4000000P06ATI8000000801TI6@@00000
2`0c<c<:000000/0<c<c2000000;01TI6Bd00000103oool2000000L0oooo000E0?ooo`030000003o
ool0oooo0080oooo<@00000A01TI6Al000002@0I6ATV000000T06ATI8000000@01TI6C0000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocD00000<`0I6ATZ
000003<06ATI=00000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo>`00000[01TI6Bh00000:`0I6ATj000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooom2000001l06ATI>000000P01TI6D0000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodP000004`0I6AU4000001<06ATI
A`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`8000000`3ooooi000000@0oooo0P0000070?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodT0
00004@0I6AU6000001806ATIA`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo@P00000M01TI6C`000007@0I6AU1000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3oooll000002L06ATI=000000W01TI6C/000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocL00000;`0I6AT^
000002l06ATI=P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo=000000>01TI6AP000003`0I6ATX000000l06ATI6000000>01TI6C<000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc0000003@0I6AT5000001P0
<c<c1`00000:01TI6B@000002`0I6AT6000001P0<c<c1@00000=01TI6Bl000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool2000000<0oooo:`00000=01TI6@D00000300c<c<A000000L0<c<c
1000000801TI6B000000200I6AT5000000H0<c<c4P00000;03<c<`D000003@0I6ATZ000000@0oooo
0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooobP000003P0I6AT2000000X0<c<c1`00
000A04a<C0D000001P0c<c<2000000P06ATI7000000801TI6@8000001P0c<c<500000180C4a<1P00
000:03<c<`8000003P0I6ATW000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolU000000l06ATI0P00000703<c<`D000001`1<C4`;000000/0C4a<0P000006
03<c<`8000001`0I6ATJ000000L06ATI0P00000603<c<`8000002`1<C4`<000000H0C4a<1@000007
03<c<`8000003`0I6ATT000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolT000000h06ATI0P00000603<c<`<000001`1<C4`5000000/0IVIV1P00000704a<
C08000001P0c<c<2000000D06ATI6P00000501TI6@8000001P0c<c<2000000L0C4a<1P00000<06IV
IPD000001P1<C4`3000000H0<c<c0P00000>01TI6B<000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooob<000003@0I6AT2000000H0<c<c0P00000604a<C0@0
00005P1VIVH4000000D0C4a<0P00000603<c<`030000000I6AT06ATI00806ATI6@00000501TI6@03
0000000c<c<0<c<c00@0<c<c0P00000504a<C0@000005`1VIVH3000000H0C4a<0P00000603<c<`80
00003@0I6ATR000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolR000000`06ATI0P00000703<c<`030000001<C4`0C4a<00@0C4a<0P00000906IVIQ000000
1@1VIVH2000000D0C4a<0P00000403<c<`030000000I6AT06ATI00<06ATI6000000501TI6@030000
000c<c<0<c<c0080<c<c0P00000504a<C08000001@1VIVH@000000T0IVIV0P00000604a<C0030000
000c<c<0<c<c00D0<c<c0P00000<01TI6B4000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooob4000002`0I6AT2000000P0<c<c00<0000004a<C01<C4`0101<
C4`2000000D0IVIV1@00000@07moO`<00000101VIVH3000000@0C4a<00<0000003<c<`0c<c<00P0c
<c<00`0000006ATI01TI6@0201TI6AP00000100I6AT00`000000<c<c03<c<`0203<c<`030000001<
C4`0C4a<0080C4a<0`00000406IVIP<00000401oOgl6000000D0IVIV0P00000504a<C0030000000c
<c<0<c<c00H0<c<c0P00000;01TI6B0000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?oooal00000300I6AT00`000000<c<c03<c<`0603<c<`800000101<C4`3
000000<0IVIV1000000607moO`h00000101oOgl2000000D0IVIV0P00000304a<C0050000000c<c<0
<c<c03<c<`000000100I6ATH000000<06ATI00<0000003<c<`0c<c<00P0c<c<010000000C4a<04a<
C01<C4`2000000D0IVIV0P00000407moO`h000001`1oOgl3000000@0IVIV0P00000404a<C0800000
200c<c<00`0000006ATI01TI6@0:01TI6Ah000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooal000002`0I6AT00`000000<c<c03<c<`0503<c<`800000101<
C4`2000000@0IVIV0P00000707moO`<000003P2IVIT2000000@0Ogmo00<0000006IVIP1VIVH0101V
IVH01@000000C4a<04a<C01<C4`0000000<0<c<c00<0000001TI6@0I6AT00P0I6ATF000000@06ATI
00D0000003<c<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV00@0IVIV00<0000007moO`1o
Ogl00P1oOgl2000000h0VIVI1000000607moO`800000101VIVH2000000@0C4a<0P00000703<c<`03
0000000I6AT06ATI00T06ATI7P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo7P00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0
0`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00D0Ogmo0P00000909VIV@<00000
1`2IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`0
0P1<C4`010000000<c<c03<c<`00000401TI6AH000000`0I6AT01@000000<c<c03<c<`0c<c<00000
00@0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI
00D0VIVI0`00000:09VIV@8000001P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<
00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0:01TI6Ad000001@3oool00`00
0000oooo0?ooo`050?ooo`001`3oool4000000<0oooo0P0000050?ooo`030000003oool0oooo0080
oooo7P00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`000000
IVIV06IVIP0306IVIP030000001oOgl0Ogmo00D0Ogmo00<0000009VIV@2IVIT01P2IVIT3000000<0
/k>c0`00000509VIV@8000000`1oOgl2000000@0IVIV00D0000004a<C01<C4`0C4a<0000000303<c
<`040000000I6AT06ATI01TI6AH000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00<0
000006IVIP1VIVH00P1VIVH2000000<0Ogmo0P00000509VIV@<000000`2c/k<3000000T0VIVI00<0
000007moO`1oOgl00`1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0
000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0:01TI6A`000001@3oool00`000000oooo0?oo
o`050?ooo`001`3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool00P3ooolM000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<
C00304a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00`1oOgl2000000H0VIVI0`00
00090;>c/`8000001@2IVIT00`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IVIP000000
101<C4`010000000<c<c03<c<`00000401TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<00000
00@0C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`030000002IVIT0VIVI00<0VIVI0P000009
0;>c/`<000001`2IVIT00`000000Ogmo07moO`0307moO`030000001VIVH0IVIV00<0IVIV00<00000
04a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI70000005
0?ooo`030000003oool0oooo00D0oooo00080?ooo`030000003oool0oooo0080oooo00@000000?oo
o`3oool00000103oool300000080oooo7@00000:01TI6@030000000c<c<0<c<c00D0<c<c00<00000
04a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00<0Ogmo00<00000
09VIV@2IVIT00`2IVIT3000000h0/k>c0P00000409VIV@8000000`1oOgl01@000000IVIV06IVIP1V
IVH0000000<0C4a<00D0000003<c<`0c<c<0<c<c0000000301TI6A@000000`0I6AT01@000000<c<c
03<c<`0c<c<0000000<0C4a<00D0000006IVIP1VIVH0IVIV0000000407moO`030000002IVIT0VIVI
0080VIVI0P00000>0;>c/`<000001@2IVIT00`000000Ogmo07moO`0307moO`030000001VIVH0IVIV
00<0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI
00T06ATI6`0000030?ooo`<000001`3oool000T0oooo00D000000?ooo`3oool0oooo000000020?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooolM000000X06ATI00<0000003<c
<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007mo
O`1oOgl00`1oOgl00`000000VIVI09VIV@0309VIV@030000002c/k<0/k>c0140/k>c00<0000009VI
V@2IVIT00P2IVIT00`000000Ogmo07moO`0207moO`040000001VIVH0IVIV000000<0C4a<00D00000
03<c<`0c<c<0<c<c0000000301TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<
00@0000006IVIP1VIVH00000101oOgl00`000000VIVI09VIV@0209VIV@030000002c/k<0/k>c0140
/k>c00<0000009VIV@2IVIT00`2IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV00<0
IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T0
6ATI6`0000050?ooo`030000003oool0oooo00D0oooo00070?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?oooa`000002`0I6AT00`00
0000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH00`00
0000Ogmo07moO`0207moO`030000002IVIT0VIVI00@0VIVI00<000000;>c/`2c/k<04@2c/k<00`00
0000VIVI09VIV@0309VIV@050000001oOgl0Ogmo07moO`0000000P1VIVH01@000000C4a<04a<C01<
C4`0000000<0<c<c00@0000001TI6@0I6AT06ATI5000000301TI6@050000000c<c<0<c<c03<c<`00
00000`1<C4`010000000IVIV06IVIP00000407moO`030000002IVIT0VIVI0080VIVI00<000000;>c
/`2c/k<04P2c/k<00`000000VIVI09VIV@0309VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IV
IP1VIVH00`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI
6@0I6AT02@0I6ATK000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo0P0000040?ooo`80
00001@3oool00`000000oooo0?ooo`020?oooa`000002P0I6AT00`000000<c<c03<c<`0503<c<`03
0000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`03
0000002IVIT0VIVI00@0VIVI00<000000;>c/`2c/k<02@2c/k<00`000000/k>c0;>c/`070;>c/`03
0000002IVIT0VIVI0080VIVI00D0000007moO`1oOgl0Ogmo0000000206IVIP050000001<C4`0C4a<
04a<C00000000`0c<c<0100000006ATI01TI6@0I6ATD000000<06ATI00@0000003<c<`0c<c<00000
0`1<C4`01@000000IVIV06IVIP1VIVH0000000<0Ogmo00<0000009VIV@2IVIT00P2IVIT00`000000
/k>c0;>c/`070;>c/`030000002c/k<0/k>c00X0/k>c00<0000009VIV@2IVIT00`2IVIT01@000000
Ogmo07moO`1oOgl0000000D0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c
<`030000000I6AT06ATI00T06ATI6`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo7000000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<
C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2I
VIT00`2IVIT00`000000/k>c0;>c/`080;>c/`80000000<0c<c<000000000000202c/k<01@000000
VIVI09VIV@2IVIT0000000@0Ogmo00@0000006IVIP1VIVH000000`1<C4`01@000000<c<c03<c<`0c
<c<0000000806ATI5000000301TI6@040000000c<c<0<c<c000000<0C4a<00@0000006IVIP1VIVH0
0000101oOgl01@000000VIVI09VIV@2IVIT0000000P0/k>c0P0000000`3<c<`000000000000:0;>c
/`030000002IVIT0VIVI00<0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP0206IV
IP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI
6AX000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa/0
00002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1V
IVH00P1VIVH00`000000Ogmo07moO`0307moO`030000002IVIT0VIVI00<0VIVI00<000000;>c/`2c
/k<01P2c/k<2000000D0c<c<0P0000060;>c/`030000002IVIT0VIVI0080VIVI00D0000007moO`1o
Ogl0Ogmo0000000206IVIP050000001<C4`0C4a<04a<C00000000`0c<c<00`0000006ATI01TI6@0D
000000<06ATI00@0000003<c<`0c<c<000000`1<C4`010000000IVIV06IVIP00000307moO`030000
002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<0102c/k<2000000D0c<c<0P0000090;>c/`030000
002IVIT0VIVI00<0VIVI00D0000007moO`1oOgl0Ogmo0000000506IVIP030000001<C4`0C4a<00<0
C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6AX000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa/000002`0I6AT00`000000<c<c
03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo
07moO`0307moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<01@2c/k<2000000T0c<c<
00<000000;>c/`2c/k<0102c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00@0000006IVIP1V
IVH000000`1<C4`01@000000<c<c03<c<`0c<c<0000000806ATI5000000301TI6@040000000c<c<0
<c<c000000<0C4a<00@0000006IVIP1VIVH000000`1oOgl01@000000VIVI09VIV@2IVIT0000000H0
/k>c00<000000<c<c03<c<`01`3<c<`2000000L0/k>c00<0000009VIV@2IVIT00`2IVIT00`000000
Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000
<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI6P0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo6`00000;01TI6@030000000c<c<0<c<c00@0<c<c
00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo00<0Ogmo
00<0000009VIV@2IVIT00P2IVIT00`000000/k>c0;>c/`060;>c/`8000001`3<c<`00`000000/k>c
0;>c/`040;>c/`030000002IVIT0VIVI0080VIVI00D0000007moO`1oOgl0Ogmo0000000206IVIP05
0000001<C4`0C4a<04a<C00000000`0c<c<00`0000006ATI01TI6@0D000000<06ATI00@0000003<c
<`0c<c<000000`1<C4`010000000IVIV06IVIP00000307moO`030000002IVIT0VIVI0080VIVI00<0
00000;>c/`2c/k<0102c/k<00`000000c<c<0<c<c0050<c<c0800000202c/k<00`000000VIVI09VI
V@0309VIV@050000001oOgl0Ogmo07moO`0000001@1VIVH00`000000C4a<04a<C00304a<C0030000
000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATJ000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooolL000000X06ATI00<0000003<c<`0c<c<01@0c
<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00P1o
Ogl00`000000VIVI09VIV@0309VIV@030000002c/k<0/k>c00L0/k>c00<000000<c<c03<c<`00P3<
c<`2000000L0/k>c00D0000009VIV@2IVIT0VIVI0000000407moO`040000001VIVH0IVIV000000<0
C4a<00D0000003<c<`0c<c<0<c<c0000000201TI6A@000000`0I6AT010000000<c<c03<c<`000003
04a<C0040000001VIVH0IVIV000000@0Ogmo00D0000009VIV@2IVIT0VIVI000000070;>c/`800000
103<c<`00`000000/k>c0;>c/`070;>c/`030000002IVIT0VIVI00<0VIVI00<0000007moO`1oOgl0
0P1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0
1@0c<c<00`0000006ATI01TI6@0901TI6AX000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooa`000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<
C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002I
VIT0VIVI00<0VIVI00<000000;>c/`2c/k<0202c/k<2000000030<c<c0000000/k>c00L0/k>c00<0
000009VIV@2IVIT00P2IVIT01@000000Ogmo07moO`1oOgl000000080IVIV00D0000004a<C01<C4`0
C4a<0000000303<c<`040000000I6AT06ATI01TI6A@000000`0I6AT010000000<c<c03<c<`000003
04a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl00`000000VIVI09VIV@0209VIV@030000002c
/k<0/k>c00H0/k>c00@000000<c<c000000000002P2c/k<00`000000VIVI09VIV@0309VIV@050000
001oOgl0Ogmo07moO`0000001@1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0
<c<c00<0000001TI6@0I6AT02@0I6ATK000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooolL000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<
04a<C00304a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00P1oOgl00`000000VIVI
09VIV@0309VIV@030000002c/k<0/k>c00T0/k>c00<000000;>c/`2c/k<01P2c/k<00`000000VIVI
09VIV@0309VIV@050000001oOgl0Ogmo07moO`0000000P1VIVH01@000000C4a<04a<C01<C4`00000
00<0<c<c00@0000001TI6@0I6AT06ATI5000000301TI6@050000000c<c<0<c<c03<c<`0000000`1<
C4`010000000IVIV06IVIP00000407moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<0
1P2c/k<00`000000/k>c0;>c/`0:0;>c/`030000002IVIT0VIVI0080VIVI00<0000007moO`1oOgl0
0P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0
100c<c<00`0000006ATI01TI6@0901TI6A/000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooad000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<
C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0307moO`030000002I
VIT0VIVI00<0VIVI00<000000;>c/`2c/k<04@2c/k<00`000000VIVI09VIV@0209VIV@030000001o
Ogl0Ogmo0080Ogmo00@0000006IVIP1VIVH000000`1<C4`01@000000<c<c03<c<`0c<c<0000000<0
6ATI5000000301TI6@050000000c<c<0<c<c03<c<`0000000`1<C4`010000000IVIV06IVIP000004
07moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<04@2c/k<2000000@0VIVI00<00000
07moO`1oOgl00P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00<0C4a<00<00000
03<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6A/000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool2000000<0oooo7@00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<
C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00<0Ogmo00<0000009VI
V@2IVIT00`2IVIT00`000000/k>c0;>c/`0?0;>c/`030000002IVIT0VIVI00<0VIVI00D0000007mo
O`1oOgl0Ogmo0000000306IVIP050000001<C4`0C4a<04a<C00000000`0c<c<0100000006ATI01TI
6@0I6ATD000000<06ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0050000001VIVH0IVIV06IV
IP000000101oOgl00`000000VIVI09VIV@0209VIV@030000002c/k<0/k>c00l0/k>c00<0000009VI
V@2IVIT00`2IVIT00`000000Ogmo07moO`0307moO`030000001VIVH0IVIV00<0IVIV00<0000004a<
C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI6`0000040?oo
o`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooolM000000/06ATI00<0000003<c<`0c
<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1o
Ogl00`1oOgl00`000000VIVI09VIV@0309VIV@800000302c/k<3000000D0VIVI00D0000007moO`1o
Ogl0Ogmo0000000306IVIP030000001<C4`0C4a<0080C4a<00D0000003<c<`0c<c<0<c<c00000003
01TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00<0000006IVIP1VIVH00P1V
IVH01@000000Ogmo07moO`1oOgl0000000D0VIVI0`00000<0;>c/`8000001@2IVIT00`000000Ogmo
07moO`0307moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c
03<c<`0503<c<`030000000I6AT06ATI00T06ATI700000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo7P00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0
000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00@0Ogmo00<0
000009VIV@2IVIT0102IVIT4000000D0/k>c0`00000709VIV@050000001oOgl0Ogmo07moO`000000
101VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c00@0000001TI6@0I6AT06ATI5P00000301TI
6@050000000c<c<0<c<c03<c<`0000000`1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0
Ogmo07moO`0000001`2IVIT3000000D0/k>c1000000609VIV@030000001oOgl0Ogmo00<0Ogmo00<0
000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00@0<c<c00<0
000001TI6@0I6AT02P0I6ATL000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolN000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C003
04a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl0101oOgl00`000000VIVI09VIV@07
09VIV@D00000202IVIT2000000<0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C002
04a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATF000000<06ATI00D0000003<c<`0c<c<0<c<c
0000000304a<C0030000001VIVH0IVIV00<0IVIV00@0000007moO`1oOgl0Ogmo0P00000809VIV@D0
00002P2IVIT00`000000Ogmo07moO`0307moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<
C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00X06ATI7@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo7`00000;01TI6@030000
000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP0306IVIP800000
1@1oOgl300000140VIVI0P00000407moO`030000001VIVH0IVIV00<0IVIV00D0000004a<C01<C4`0
C4a<0000000303<c<`030000000I6AT06ATI00806ATI5P00000401TI6@050000000c<c<0<c<c03<c
<`0000000`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo0080Ogmo0P00000A09VI
V@@00000101oOgl2000000D0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0403<c
<`030000000I6AT06ATI00T06ATI7P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo7`00000<01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<
C4`0101<C4`2000000D0IVIV1000000407moO`H000001`2IVIT4000000D0Ogmo00<0000006IVIP1V
IVH00`1VIVH01@000000C4a<04a<C01<C4`0000000@0<c<c00<0000001TI6@0I6AT00P0I6ATF0000
00@06ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV00@0IVIV00<00000
07moO`1oOgl00`1oOgl4000000L0VIVI1P00000507moO`<000001@1VIVH2000000H0C4a<00<00000
03<c<`0c<c<0100c<c<00`0000006ATI01TI6@0:01TI6Ah000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooob000000300I6AT00`000000<c<c03<c<`0403<c
<`8000001P1<C4`2000000L0IVIV0P00000807moO`L00000201oOgl00`000000IVIV06IVIP0306IV
IP8000000`1<C4`01@000000<c<c03<c<`0c<c<0000000@06ATI6000000401TI6@050000000c<c<0
<c<c03<c<`0000000`1<C4`2000000D0IVIV00<0000007moO`1oOgl01P1oOgl7000000T0Ogmo0P00
000606IVIP8000001P1<C4`2000000H0<c<c00<0000001TI6@0I6AT02P0I6ATO000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolQ000000`06ATI00<00000
03<c<`0c<c<01@0c<c<2000000H0C4a<0`00000606IVIPP000001`1oOgl8000000<0IVIV0`000004
04a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT00P0I6ATH000000@06ATI00<00000
03<c<`0c<c<00P0c<c<00`000000C4a<04a<C00204a<C0<000000`1VIVH8000000L0Ogmo2@000005
06IVIP<000001P1<C4`2000000L0<c<c00<0000001TI6@0I6AT02P0I6ATP000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolR000000`06ATI0P00000703<c
<`<000001P1<C4`4000000X0IVIV1`00000706IVIP@000001@1<C4`2000000@0<c<c00<0000001TI
6@0I6AT00`0I6ATH000000D06ATI00<0000003<c<`0c<c<00P0c<c<2000000D0C4a<1000000706IV
IPL000002`1VIVH3000000H0C4a<0`00000703<c<`800000300I6ATQ000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolT000000`06ATI0P00000803<c<`<0
00001`1<C4`400000140IVIV0`00000704a<C08000001@0c<c<00`0000006ATI01TI6@0301TI6AX0
00001@0I6AT00`000000<c<c03<c<`0303<c<`8000001`1<C4`300000140IVIV1@00000604a<C0<0
0000200c<c<2000000`06ATI8`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo9@00000=01TI6@8000002@0c<c<3000000P0C4a<4@00000604a<C0@00000
1@0c<c<2000000H06ATI6P00000601TI6@8000001@0c<c<4000000H0C4a<4@00000804a<C0<00000
2@0c<c<2000000d06ATI900000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo9P00000>01TI6@<000002@0c<c<4000001P0C4a<0`00000803<c<`030000000I
6AT06ATI00D06ATI7000000701TI6@030000000c<c<0<c<c00H0<c<c0`00000I04a<C0<000002@0c
<c<3000000h06ATI9@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooo:000000?01TI6@8000002`0c<c<400000140C4a<0`00000903<c<`800000200I6ATL
000000P06ATI0P00000903<c<`<000004@1<C4`5000000X0<c<c0P00000?01TI6BL000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo;P00000;01TI6@T000001P0c<c<A0000
00P0<c<c1000000901TI6Ah000002@0I6AT4000000P0<c<c4@00000703<c<`P000002`0I6AT]0000
00@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?oooc4000004@0I6AT6000001<0
<c<c1P00000;01TI6B8000002`0I6AT6000001<0<c<c1`00000@01TI6C0000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocD000004`0I6ATC000000h06ATI
:000000>01TI6A<000004`0I6ATd000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooolj000002`06ATI;P00000/01TI6CT000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocd00000900I6ATh000002@06ATI?0000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo@P00000I01TI
6D@000006P0I6AU0000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?ooooT00000103oool2000000L0oooo
000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo@P00000M01TI6C`000007@0I6AU1000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3oooll000002L06ATI=000000W01TI6C/000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooocL00000;`0I6AT^000002l06ATI
=P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=000
000E01TI6A4000003`0I6ATX000000l06ATI4P00000D01TI6C<000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?oooc0000003@0I6AT<00000140<c<c1`00000:
01TI6B@000002P0I6AT700000180<c<c2`00000=01TI6Bl000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool2000000<0oooo:`00000=01TI6@D00000300c<c<A000000L0<c<c1000000801TI
6B000000200I6AT4000000L0<c<c4P00000;03<c<`D000003@0I6ATZ000000@0oooo0P0000070?oo
o`005@3oool00`000000oooo0?ooo`020?ooobT000003@0I6AT2000000X0<c<c1`00000A04a<C0D0
00001P0c<c<2000000P06ATI7000000801TI6@8000001P0c<c<500000180C4a<1P00000:03<c<`80
00003@0I6ATX000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolW000000d06ATI0P00000703<c<`D000003@1<C4`5000000/0C4a<0P00000603<c<`800000
1`0I6ATJ000000L06ATI0P00000603<c<`8000002`1<C4`5000000d0C4a<1@00000703<c<`800000
3@0I6ATV000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolU000000d06ATI0P00000603<c<`<00000301<C4`6000000D0IVIV1P00000704a<C08000001P0c
<c<2000000D06ATI6P00000501TI6@8000001P0c<c<2000000L0C4a<1P00000506IVIPL000002`1<
C4`3000000H0<c<c0P00000=01TI6B@000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooob<000003@0I6AT2000000H0<c<c0P00000804a<C0L000004@1VIVH5
000000@0C4a<0P00000603<c<`030000000I6AT06ATI00806ATI6@00000501TI6@030000000c<c<0
<c<c00@0<c<c0P00000404a<C0D000004P1VIVH6000000P0C4a<0P00000603<c<`8000003@0I6ATR
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolR0000
00`06ATI0P00000603<c<`8000001P1<C4`4000000L0IVIV4@00000506IVIP800000101<C4`20000
00@0<c<c00<0000001TI6@0I6AT00`0I6ATH000000D06ATI00<0000003<c<`0c<c<00P0c<c<20000
00@0C4a<0P00000506IVIQ8000001P1VIVH4000000H0C4a<0P00000603<c<`800000300I6ATQ0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolP000000`0
6ATI0P00000703<c<`030000001<C4`0C4a<00@0C4a<0P00000606IVIPD000004@1oOgl3000000@0
IVIV0P00000404a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT00P0I6ATH000000@0
6ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<C00204a<C0800000101VIVH300000180
Ogmo1@00000506IVIP8000001P1<C4`00`000000<c<c03<c<`0503<c<`800000300I6ATO000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolO000000`06ATI
00<0000003<c<`0c<c<01@0c<c<2000000D0C4a<0P00000406IVIP@000001P1oOgl>000000D0Ogmo
00<0000006IVIP1VIVH00`1VIVH2000000<0C4a<00D0000003<c<`0c<c<0<c<c0000000401TI6AP0
00000`0I6AT00`000000<c<c03<c<`0203<c<`040000001<C4`0C4a<04a<C08000001@1VIVH00`00
0000Ogmo07moO`0307moO`h000001`1oOgl3000000@0IVIV0P00000504a<C08000001`0c<c<00`00
00006ATI01TI6@0:01TI6Ah000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooah00000300I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0
C4a<0P00000406IVIP8000001`1oOgl3000000h0VIVI0P00000407moO`8000001@1VIVH01@000000
C4a<04a<C01<C4`0000000<0<c<c00<0000001TI6@0I6AT00P0I6ATF000000@06ATI00D0000003<c
<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV00<0IVIV0P00000407moO`8000003P2IVIT4
000000H0Ogmo0P00000406IVIP8000001@1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT0
6ATI00X06ATI7@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo7@00000<01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`00`00
0000IVIV06IVIP0306IVIP030000001oOgl0Ogmo00@0Ogmo0`00000809VIV@D000001P2IVIT20000
00@0Ogmo0P00000406IVIP050000001<C4`0C4a<04a<C00000000P0c<c<00`0000006ATI01TI6@02
01TI6AH000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00<0000006IVIP1VIVH00P1V
IVH2000000@0Ogmo0P00000609VIV@D000002@2IVIT2000000H0Ogmo0P00000406IVIP030000001<
C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6Ad000001@3o
ool00`000000oooo0?ooo`050?ooo`00203oool2000000@0oooo0P0000050?ooo`030000003oool0
oooo0080oooo7@00000;01TI6@030000000c<c<0<c<c00@0<c<c0P00000404a<C0800000101VIVH2
000000D0Ogmo0P00000609VIV@D000001@2c/k<5000000<0VIVI0P00000407moO`8000000P1VIVH0
0`000000C4a<04a<C00204a<C0040000000c<c<0<c<c000000<06ATI5P00000301TI6@050000000c
<c<0<c<c03<c<`0000000`1<C4`00`000000IVIV06IVIP02000000@0Ogmo0P00000309VIV@D00000
1@2c/k<5000000H0VIVI0P00000607moO`030000001VIVH0IVIV0080IVIV0P00000404a<C0800000
1P0c<c<00`0000006ATI01TI6@0901TI6A`000001@3oool00`000000oooo0?ooo`050?ooo`001`3o
ool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool00P3ooolL000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C003
0000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00`1oOgl2000000D0VIVI0`00000?0;>c/`<0
00000P2IVIT2000000@0Ogmo00@0000006IVIP1VIVH000000`1<C4`010000000<c<c03<c<`000004
01TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00@0000006IVIP1VIVH00000
101oOgl200000080VIVI0`00000?0;>c/`@00000102IVIT2000000D0Ogmo0P00000406IVIP030000
001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6A/00000
1@3oool00`000000oooo0?ooo`050?ooo`002@3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool00P3oool300000080oooo6`00000;01TI6@030000000c<c<0<c<c00@0<c<c
00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo0080Ogmo
0P00000309VIV@@000000`2c/k<<000000H0/k>c0P00000209VIV@8000000`1oOgl010000000IVIV
06IVIP00000304a<C0040000000c<c<0<c<c000000<06ATI5000000301TI6@050000000c<c<0<c<c
03<c<`0000000P1<C4`010000000IVIV06IVIP00000307moO`8000000P2IVIT2000000H0/k>c3000
00040;>c/`<000000`2IVIT2000000D0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<
C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6ATJ000000<0oooo0`00
00070?ooo`002P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0080oooo00<0
00000?ooo`3oool00P3ooolJ000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<
C00304a<C0030000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00P1oOgl010000000VIVI09VI
V@2IVIT2000000@0/k>c0`00000<0<c<c08000001@2c/k<00`000000VIVI09VIV@0209VIV@040000
001oOgl0Ogmo000000<0IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6ATD
000000806ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<0000000206IVIP050000001oOgl0
Ogmo07moO`000000102IVIT00`000000/k>c0;>c/`030;>c/`800000303<c<`4000000<0/k>c0P00
000309VIV@030000001oOgl0Ogmo0080Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<
C00204a<C0030000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT0200I6ATJ000000D0oooo00<0
00000?ooo`3oool01@3oool000L0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?oo
o`0000040?ooo`030000003oool0oooo0080oooo6P00000;01TI6@030000000c<c<0<c<c00@0<c<c
00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo0080Ogmo
00<0000009VIV@2IVIT00P0000040;>c/`800000203<c<`5000000@0c<c<0P0000040;>c/`030000
002IVIT0VIVI0080VIVI00@0000007moO`1oOgl000000P1VIVH010000000C4a<04a<C000000303<c
<`040000000I6AT06ATI01TI6A<000000P0I6AT01@000000<c<c03<c<`0c<c<000000080C4a<00@0
000006IVIP1VIVH000000P1oOgl00`000000VIVI09VIV@0209VIV@030000002c/k<0/k>c0080/k>c
0P0000040<c<c0D000002@3<c<`2000000<0/k>c0P00000209VIV@030000001oOgl0Ogmo0080Ogmo
00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT02@0I6ATI000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo0P00
00040?ooo`8000001@3oool00`000000oooo0?ooo`020?oooaX000002P0I6AT00`000000<c<c03<c
<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07mo
O`0207moO`040000002IVIT0VIVI000000D0/k>c00<000000<c<c03<c<`0103<c<`4000000D0i^KV
100000020<c<c08000000`2c/k<00`000000VIVI09VIV@0209VIV@030000001oOgl0000000<0IVIV
00<0000004a<C00000000`0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00L0000003<c<`0c
<c<0<c<c0000001<C4`000000080IVIV00@0000007moO`1oOgl00000102IVIT010000000/k>c0;>c
/`2c/k<200000080c<c<100000050>KViP@000001`3<c<`00`000000/k>c0;>c/`020;>c/`040000
002IVIT0VIVI000000@0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C003
0000000c<c<0<c<c00D0<c<c00<0000001TI6@0I6AT0200I6ATI000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolI000000/06ATI00<0000003<c<`0c<c<0
100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV00<0IVIV00D0000007moO`1oOgl0
Ogmo0000000209VIV@030000002c/k<0/k>c00<0/k>c00<000000<c<c03<c<`00`3<c<`2000000d0
i^KV00@000000<c<c03<c<`0c<c<0P0000020;>c/`050000002IVIT0VIVI09VIV@0000000P1oOgl0
10000000IVIV06IVIP00000204a<C0040000000c<c<0<c<c000000<06ATI4P00000301TI6@070000
000c<c<0<c<c03<c<`000000C4a<0000000206IVIP040000001oOgl0Ogmo000000<0VIVI00<00000
0;>c/`2c/k<00P0000030<c<c0030000003Vi^H0i^KV00/0i^KV0P0000050<c<c0030000002c/k<0
/k>c00<0/k>c00@0000009VIV@2IVIT000000`1oOgl00`000000IVIV06IVIP0306IVIP030000001<
C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AT000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002P0I6AT0
0`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH0
1@000000Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<
c0020<c<c0800000403Vi^H2000000<0c<c<00@000000;>c/`2c/k<000000`2IVIT00`000000Ogmo
0000000306IVIP030000001<C4`000000080<c<c00<0000001TI6@0I6AT00P0I6ATA000000<06ATI
00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`050000002IVIT0VIVI09VI
V@0000000P2c/k<010000000c<c<0<c<c03<c<`200000100i^KV0P0000040<c<c0030000002c/k<0
/k>c0080/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0
000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI6000
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6@00000:
01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP02
06IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT00`000000/k>c0;>c/`020;>c/`040000003<
c<`0c<c<0<c<c08000002@3Vi^H2000000T0i^KV00D000000<c<c03<c<`0c<c<000000020;>c/`04
0000002IVIT0VIVI00000080Ogmo00H0000006IVIP1VIVH0000004a<C000000203<c<`030000000I
6AT06ATI00806ATI4@00000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IVIP000000
0P1oOgl010000000VIVI09VIV@0000030;>c/`040000003<c<`0c<c<000000T0i^KV0P0000090>KV
iP8000000`3<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl0
0`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<0
0`0000006ATI01TI6@0801TI6AP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<
0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00<00000
0;>c/`2c/k<00P2c/k<01@000000c<c<0<c<c03<c<`0000000L0i^KV0`0000020?ooo`8000001`3V
i^H01@000000c<c<0<c<c03<c<`000000080/k>c00@0000009VIV@2IVIT000000P1oOgl01P000000
IVIV06IVIP000000C4a<00000080<c<c00<0000001TI6@0I6AT00P0I6ATA000000<06ATI00@00000
03<c<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`040000002IVIT0VIVI000000<0/k>c
00@000000<c<c03<c<`000001`3Vi^H200000080oooo0`0000070>KViP050000003<c<`0c<c<0<c<
c0000000102c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00<0000006IVIP1VIVH00P1VIVH0
0`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATH
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolI0000
00X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV
06IVIP000000101oOgl010000000VIVI09VIV@0000040;>c/`030000003<c<`0c<c<0080c<c<00<0
00000>KViP3Vi^H00`3Vi^H2000000L0oooo0P0000060>KViP070000003<c<`0c<c<0<c<c0000000
/k>c0000000209VIV@040000001oOgl0Ogmo00000080IVIV00<0000004a<C00000000P0c<c<00`00
00006ATI01TI6@0201TI6A4000000`0I6AT010000000<c<c03<c<`00000204a<C0030000001VIVH0
00000080Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<0<c<c00000060>KViP800000
1`3oool2000000H0i^KV00D000000<c<c03<c<`0c<c<000000040;>c/`040000002IVIT0VIVI0000
00@0Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c00@0<c<c00<00000
01TI6@0I6AT0200I6ATH000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3ooolI000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<
C0050000001VIVH0IVIV06IVIP000000101oOgl010000000VIVI09VIV@0000040;>c/`030000003<
c<`0c<c<0080c<c<00<000000>KViP3Vi^H00P3Vi^H00`000000oooo0?ooo`090?ooo`800000103V
i^H01`000000c<c<0<c<c03<c<`000000;>c/`0000000P2IVIT010000000Ogmo07moO`00000206IV
IP030000001<C4`000000080<c<c00<0000001TI6@0I6AT00P0I6ATA000000<06ATI00@0000003<c
<`0c<c<000000P1<C4`00`000000IVIV0000000207moO`040000002IVIT0VIVI00000080/k>c00@0
00000<c<c03<c<`00000103Vi^H2000000/0oooo00<000000>KViP3Vi^H00`3Vi^H01@000000c<c<
0<c<c03<c<`0000000@0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0IVIV
06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI60000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000000:01TI
6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IV
IP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0000000@0c<c<00<0
00000>KViP3Vi^H00P3Vi^H00`000000oooo0?ooo`0;0?ooo`030000003Vi^H0i^KV0080i^KV00D0
00000<c<c03<c<`0c<c<000000020;>c/`040000002IVIT0VIVI00000080Ogmo00<0000006IVIP00
00000P1<C4`010000000<c<c03<c<`00000301TI6A0000000`0I6AT010000000<c<c03<c<`000002
04a<C0030000001VIVH000000080Ogmo00@0000009VIV@2IVIT000000`2c/k<010000000c<c<0<c<
c00000030>KViP030000003oool0oooo00`0oooo00<000000>KViP3Vi^H00`3Vi^H01@000000c<c<
0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV
0080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00P06ATI5`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo6000000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000
IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0
000000@0c<c<00<000000>KViP3Vi^H00P3Vi^H00`000000oooo0?ooo`0<0?ooo`050000003Vi^H0
i^KV0>KViP0000000`3<c<`010000000/k>c0;>c/`00000209VIV@060000001oOgl0Ogmo0000001V
IVH000000P1<C4`010000000<c<c03<c<`00000301TI6A0000000`0I6AT010000000<c<c03<c<`00
000204a<C0030000001VIVH000000080Ogmo00@0000009VIV@2IVIT000000`2c/k<010000000c<c<
0<c<c00000030>KViP030000003oool0oooo00`0oooo00<000000>KViP3Vi^H00`3Vi^H01@000000
c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0
IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT0
6ATI00P06ATI5`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo6000000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`01@00
0000IVIV06IVIP1VIVH0000000@0Ogmo00@0000009VIV@2IVIT000000`2c/k<00`000000c<c<0<c<
c0020<c<c0030000003Vi^H0i^KV0080i^KV00<000000?ooo`3oool03@3oool00`000000i^KV0>KV
iP020>KViP070000003<c<`0c<c<0<c<c0000000/k>c0000000209VIV@060000001oOgl0Ogmo0000
001VIVH000000P1<C4`010000000<c<c03<c<`00000301TI6A0000000`0I6AT010000000<c<c03<c
<`00000204a<C0030000001VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000
c<c<0<c<c00000030>KViP030000003oool0oooo00h0oooo00<000000>KViP3Vi^H00`3Vi^H01@00
0000c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001V
IVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI
5`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolH000000X06ATI00<0
000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP000000
101oOgl010000000VIVI09VIV@0000030;>c/`030000003<c<`0c<c<0080c<c<00D000000>KViP3V
i^H0i^KV0000000A0?ooo`050000003Vi^H0i^KV0>KViP0000000`3<c<`00`000000/k>c00000002
09VIV@060000001oOgl0Ogmo0000001VIVH000000P1<C4`010000000<c<c03<c<`00000301TI6A00
00000`0I6AT010000000<c<c03<c<`00000204a<C0030000001VIVH000000080Ogmo00@0000009VI
V@2IVIT000000P2c/k<010000000c<c<0<c<c00000030>KViP030000003oool0oooo00l0oooo00<0
00000>KViP3Vi^H00P3Vi^H01@000000c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0
VIVI0000000307moO`050000001VIVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c
<`030000000I6AT06ATI00P06ATI5`0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3o
ool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C005
0000001VIVH0IVIV06IVIP000000101oOgl010000000VIVI09VIV@0000030;>c/`030000003<c<`0
c<c<0080c<c<00D000000>KViP3Vi^H0i^KV0000000A0?ooo`050000003Vi^H0i^KV0>KViP000000
0`3<c<`00`000000/k>c0000000209VIV@060000001oOgl0Ogmo0000001VIVH000000P1<C4`01000
0000<c<c03<c<`00000301TI6A0000000`0I6AT010000000<c<c03<c<`00000204a<C0030000001V
IVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<0<c<c00000030>KViP03
0000003oool0oooo00l0oooo00<000000>KViP3Vi^H00P3Vi^H01@000000c<c<0<c<c03<c<`00000
00<0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0IVIV06IVIP000000101<
C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000000:01TI6@030000000c<c<0
<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo00@0
000009VIV@2IVIT000000`2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV0080i^KV
00<000000?ooo`3oool03@3oool00`000000i^KV0>KViP020>KViP070000003<c<`0c<c<0<c<c000
0000/k>c0000000209VIV@060000001oOgl0Ogmo0000001VIVH000000P1<C4`010000000<c<c03<c
<`00000301TI6A0000000`0I6AT010000000<c<c03<c<`00000204a<C0030000001VIVH000000080
Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<0<c<c00000040>KViP030000003oool0
oooo00d0oooo00<000000>KViP3Vi^H00P3Vi^H00`000000c<c<0<c<c0020<c<c0050000002c/k<0
/k>c0;>c/`0000000`2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<C01<C4`0
0P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000000:01TI6@030000000c
<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo
00@0000009VIV@2IVIT000000`2c/k<00`000000c<c<0<c<c0020<c<c0030000003Vi^H0i^KV0080
i^KV00<000000?ooo`3oool03@3oool00`000000i^KV0>KViP020>KViP040000003<c<`0c<c<0000
0080/k>c00H0000009VIV@2IVIT0000007moO`00000206IVIP040000001<C4`0C4a<00000080<c<c
00@0000001TI6@0I6AT06ATI4000000301TI6@040000000c<c<0<c<c00000080C4a<00<0000006IV
IP0000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<000000@0i^KV00<0
00000?ooo`3oool03@3oool00`000000i^KV0>KViP020>KViP050000003<c<`0c<c<0<c<c0000000
0`2c/k<01@000000VIVI09VIV@2IVIT0000000<0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000
C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATG000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolH000000X06ATI
00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV
00D0000007moO`1oOgl0Ogmo0000000309VIV@050000002c/k<0/k>c0;>c/`000000103<c<`01@00
0000i^KV0>KViP3Vi^H0000000h0oooo00<000000>KViP3Vi^H00`3Vi^H010000000c<c<0<c<c000
00020;>c/`060000002IVIT0VIVI0000001oOgl000000P1VIVH010000000C4a<04a<C000000203<c
<`040000000I6AT06ATI01TI6A000000100I6AT00`000000<c<c0000000204a<C0040000001VIVH0
IVIV00000080Ogmo00<0000009VIV@0000000P2c/k<010000000c<c<0<c<c00000050>KViP030000
003oool0oooo00`0oooo00<000000>KViP3Vi^H00P3Vi^H01@000000c<c<0<c<c03<c<`0000000<0
/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`030000001VIVH0IVIV0080IVIV00<0000004a<
C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI5`0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6000000:01TI6@03
0000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP05
0000001oOgl0Ogmo07moO`0000000`2IVIT01@000000/k>c0;>c/`2c/k<0000000@0c<c<00<00000
0>KViP3Vi^H00P3Vi^H00`000000oooo0?ooo`0;0?ooo`030000003Vi^H0i^KV00<0i^KV00@00000
0<c<c03<c<`000000P2c/k<01P000000VIVI09VIV@000000Ogmo00000080IVIV00@0000004a<C01<
C4`000000P0c<c<0100000006ATI01TI6@0I6AT@000000@06ATI00<0000003<c<`0000000P1<C4`0
10000000IVIV06IVIP00000207moO`030000002IVIT000000080/k>c00@000000<c<c03<c<`00000
1@3Vi^H00`000000oooo0?ooo`0;0?ooo`030000003Vi^H0i^KV0080i^KV00<000000<c<c03<c<`0
0P3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo0000000406IV
IP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI
6AL000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaP0
00002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1V
IVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000<0VIVI00D000000;>c/`2c/k<0/k>c00000004
0<c<c0030000003Vi^H0i^KV0080i^KV00<000000?ooo`3oool02`3oool00`000000i^KV0>KViP03
0>KViP040000003<c<`0c<c<00000080/k>c00H0000009VIV@2IVIT0000007moO`00000206IVIP04
0000001<C4`0C4a<00000080<c<c00@0000001TI6@0I6AT06ATI4000000401TI6@030000000c<c<0
00000080C4a<00@0000006IVIP1VIVH000000P1oOgl00`000000VIVI000000020;>c/`040000003<
c<`0c<c<000000D0i^KV00<000000?ooo`3oool02`3oool00`000000i^KV0>KViP020>KViP030000
003<c<`0c<c<0080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@050000001oOgl0Ogmo07mo
O`000000101VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI
6@0I6AT0200I6ATG000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolH000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C003
0000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@030000002c/k<0/k>c
0080/k>c00<000000<c<c03<c<`00P3<c<`00`000000i^KV0>KViP020>KViP<00000203oool20000
00D0i^KV00@000000<c<c03<c<`000000P2c/k<01`000000VIVI09VIV@2IVIT0000007moO`000000
0P1VIVH010000000C4a<04a<C000000203<c<`040000000I6AT06ATI01TI6A000000100I6AT00`00
0000<c<c0000000204a<C0040000001VIVH0IVIV00000080Ogmo00<0000009VIV@0000000`2c/k<0
10000000c<c<0<c<c00000050>KViP800000203oool3000000D0i^KV00D000000<c<c03<c<`0c<c<
000000030;>c/`050000002IVIT0VIVI09VIV@000000101oOgl01@000000IVIV06IVIP1VIVH00000
00D0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AL000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002P0I6AT00`000000
<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000
Ogmo07moO`1oOgl0000000<0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0020<c<
c0030000003Vi^H0i^KV00@0i^KV0`0000030?ooo`8000001P3Vi^H01@000000c<c<0<c<c03<c<`0
00000080/k>c00@0000009VIV@2IVIT000000P1oOgl010000000IVIV06IVIP00000204a<C0040000
000c<c<0<c<c000000<06ATI4000000401TI6@030000000c<c<000000080C4a<00@0000006IVIP1V
IVH000000P1oOgl010000000VIVI09VIV@0000020;>c/`050000003<c<`0c<c<0<c<c00000001P3V
i^H2000000<0oooo0`0000060>KViP8000000`3<c<`00`000000/k>c0;>c/`020;>c/`050000002I
VIT0VIVI09VIV@0000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6AP000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaT000002P0I6AT00`000000<c<c03<c
<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH01@000000Ogmo07mo
O`1oOgl0000000<0VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0030<c<c0030000
003Vi^H0i^KV00H0i^KV0`0000060>KViP8000000`3<c<`010000000/k>c0;>c/`00000309VIV@03
0000001oOgl000000080IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6ATA
000000@06ATI00<0000003<c<`0000000P1<C4`010000000IVIV06IVIP00000207moO`040000002I
VIT0VIVI000000<0/k>c00@000000<c<c03<c<`0c<c<0P0000060>KViP<00000203Vi^H00`000000
c<c<0<c<c0020<c<c0030000002c/k<0/k>c0080/k>c00D0000009VIV@2IVIT0VIVI0000000407mo
O`050000001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT0
6ATI00P06ATI600000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0080oooo6@00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00`1<C4`00`00
0000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT00`000000/k>c0;>c/`02
0;>c/`030000003<c<`0c<c<00<0c<c<0P00000>0>KViP030000003<c<`0c<c<00<0c<c<00@00000
0;>c/`2c/k<000000`2IVIT00`000000Ogmo0000000206IVIP040000001<C4`0C4a<00000080<c<c
00@0000001TI6@0I6AT06ATI4P00000301TI6@040000000c<c<0<c<c00000080C4a<00@0000006IV
IP1VIVH000000P1oOgl010000000VIVI09VIV@0000020;>c/`030000003<c<`0c<c<00<0c<c<00<0
00000>KViP3Vi^H03@3Vi^H00`000000c<c<0<c<c0030<c<c0030000002c/k<0/k>c0080/k>c00D0
000009VIV@2IVIT0VIVI0000000407moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`000000
<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI600000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooo6P00000:01TI6@030000000c<c<0<c<c00@0<c<c
00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`00
00000`2IVIT00`000000/k>c0;>c/`030;>c/`030000003<c<`0c<c<00@0c<c<00<000000>KViP3V
i^H02P3Vi^H00`000000c<c<0<c<c0030<c<c0040000002c/k<0/k>c000000<0VIVI00@0000007mo
O`1oOgl000000P1VIVH010000000C4a<04a<C000000203<c<`040000000I6AT06ATI01TI6A800000
0`0I6AT010000000<c<c03<c<`00000204a<C0040000001VIVH0IVIV00000080Ogmo00@0000009VI
V@2IVIT000000`2c/k<00`000000c<c<0<c<c0030<c<c0030000003Vi^H0i^KV00X0i^KV0P000005
0<c<c0030000002c/k<0/k>c0080/k>c00D0000009VIV@2IVIT0VIVI0000000407moO`050000001V
IVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI
6@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolJ000000X06ATI00<0
000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00D0
000007moO`1oOgl0Ogmo0000000309VIV@800000102c/k<00`000000c<c<0<c<c0040<c<c0<00000
1P3Vi^H3000000H0c<c<00@000000;>c/`2c/k<000000`2IVIT010000000Ogmo07moO`00000206IV
IP040000001<C4`0C4a<00000080<c<c00@0000001TI6@0I6AT06ATI4P00000301TI6@040000000c
<c<0<c<c00000080C4a<00@0000006IVIP1VIVH000000P1oOgl200000080VIVI00@000000;>c/`2c
/k<000001P3<c<`3000000H0i^KV0`0000060<c<c0030000002c/k<0/k>c0080/k>c0P00000309VI
V@030000001oOgl0Ogmo0080Ogmo00D0000006IVIP1VIVH0IVIV0000000504a<C0030000000c<c<0
<c<c00@0<c<c00<0000001TI6@0I6AT0200I6ATI000000@0oooo0P0000070?ooo`005@3oool00`00
0000oooo0?ooo`020?oooaX000002P0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<
0080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0VIVI
0080VIVI00<000000;>c/`2c/k<00P2c/k<00`000000c<c<0<c<c0060<c<c0H000001`3<c<`20000
0080/k>c00D0000009VIV@2IVIT0VIVI0000000207moO`040000001VIVH0IVIV000000<0C4a<00@0
000003<c<`0c<c<000000`0I6ATB000000<06ATI00@0000003<c<`0c<c<000000P1<C4`010000000
IVIV06IVIP00000407moO`040000002IVIT0VIVI00000080/k>c0P0000070<c<c0H00000203<c<`2
000000<0/k>c00<0000009VIV@2IVIT00P2IVIT00`000000Ogmo07moO`0207moO`050000001VIVH0
IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI6@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6P00000;
01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP02
06IVIP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00P2IVIT00`000000/k>c0;>c/`02
0;>c/`8000004P3<c<`01@000000/k>c0;>c/`2c/k<0000000<0VIVI00D0000007moO`1oOgl0Ogmo
0000000206IVIP040000001<C4`0C4a<000000<0<c<c00@0000001TI6@0I6AT06ATI4P00000301TI
6@050000000c<c<0<c<c03<c<`0000000P1<C4`010000000IVIV06IVIP00000307moO`040000002I
VIT0VIVI000000@0/k>c00<000000<c<c03<c<`0403<c<`2000000@0/k>c00<0000009VIV@2IVIT0
0P2IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0
0`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00T06ATI6@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6`00000:01TI6@030000000c
<c<0<c<c00D0<c<c00<0000004a<C01<C4`00`1<C4`01@000000IVIV06IVIP1VIVH0000000@0Ogmo
00<0000009VIV@2IVIT00`2IVIT2000000@0/k>c0P00000>0<c<c0800000102c/k<010000000VIVI
09VIV@00000307moO`040000001VIVH0IVIV000000<0C4a<00D0000003<c<`0c<c<0<c<c00000002
01TI6A<000000`0I6AT01@000000<c<c03<c<`0c<c<000000080C4a<00@0000006IVIP1VIVH00000
101oOgl010000000VIVI09VIV@0000040;>c/`8000003P3<c<`2000000D0/k>c00<0000009VIV@2I
VIT00`2IVIT00`000000Ogmo07moO`0207moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`00
0000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI6P0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo6`00000;01TI6@030000000c<c<0<c<c00D0
<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080
Ogmo00<0000009VIV@2IVIT0102IVIT00`000000/k>c0;>c/`030;>c/`@000001`3<c<`3000000D0
/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`040000001VIVH0IVIV000000<0C4a<00@00000
03<c<`0c<c<000000`0I6ATD000000806ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0040000
001VIVH0IVIV000000@0Ogmo00@0000009VIV@2IVIT000001@2c/k<3000000L0c<c<100000060;>c
/`030000002IVIT0VIVI00<0VIVI00<0000007moO`1oOgl00P1oOgl01@000000IVIV06IVIP1VIVH0
000000H0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6AX000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa`000002P0I6AT00`00
0000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`00
0000Ogmo07moO`0207moO`030000002IVIT0VIVI00@0VIVI00<000000;>c/`2c/k<01P2c/k<70000
00L0/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`040000001VIVH0IVIV000000<0C4a<00D0
000003<c<`0c<c<0<c<c0000000301TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<000000080
C4a<00@0000006IVIP1VIVH00000101oOgl01@000000VIVI09VIV@2IVIT0000000L0/k>c1`000009
0;>c/`030000002IVIT0VIVI00<0VIVI00<0000007moO`1oOgl00P1oOgl00`000000IVIV06IVIP02
06IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@08
01TI6A/000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
oa`000002`0I6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00<0C4a<00<0000006IV
IP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`800000102IVIT2000001@0/k>c00D0000009VI
V@2IVIT0VIVI0000000307moO`8000000P1VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c00@0
000001TI6@0I6AT06ATI5000000301TI6@050000000c<c<0<c<c03<c<`0000000`1<C4`00`000000
IVIV06IVIP02000000<0Ogmo00D0000009VIV@2IVIT0VIVI0000000D0;>c/`800000102IVIT20000
00@0Ogmo00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT02@0I6ATK000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolM000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000
C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00`1oOgl2000000@0
VIVI0`00000?0;>c/`8000000`2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<
C01<C4`00P1<C4`01@000000<c<c03<c<`0c<c<0000000<06ATI5000000301TI6@050000000c<c<0
<c<c03<c<`0000000`1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`000000
0`2IVIT2000000l0/k>c0`00000509VIV@030000001oOgl0Ogmo00<0Ogmo00<0000006IVIP1VIVH0
0P1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0
2P0I6ATK000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolM000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001V
IVH0IVIV00<0IVIV00<0000007moO`1oOgl0101oOgl2000000D0VIVI100000070;>c/`@00000102I
VIT01@000000Ogmo07moO`1oOgl0000000@0IVIV00D0000004a<C01<C4`0C4a<0000000303<c<`03
0000000I6AT06ATI00806ATI5000000401TI6@050000000c<c<0<c<c03<c<`0000000`1<C4`00`00
0000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`000000102IVIT4000000L0/k>c10000006
09VIV@8000001@1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<00@0C4a<00<00000
03<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6A`000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooah000002`0I6AT00`000000<c<c03<c<`0503<c
<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0507mo
O`030000002IVIT0VIVI00H0VIVI1`00000609VIV@8000000`1oOgl00`000000IVIV06IVIP0206IV
IP030000001<C4`0C4a<0080C4a<00D0000003<c<`0c<c<0<c<c0000000401TI6A@00000100I6AT0
1@000000<c<c03<c<`0c<c<0000000<0C4a<00<0000006IVIP1VIVH00`1VIVH010000000Ogmo07mo
O`1oOgl2000000H0VIVI1`00000809VIV@8000001P1oOgl00`000000IVIV06IVIP0306IVIP030000
001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0:01TI6A`00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooah000002`0I
6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00`1V
IVH00`000000Ogmo07moO`0507moO`8000004@2IVIT2000000@0Ogmo00<0000006IVIP1VIVH00`1V
IVH01@000000C4a<04a<C01<C4`0000000@0<c<c00@0000001TI6@0I6AT06ATI5P00000301TI6@05
0000000c<c<0<c<c03<c<`000000101<C4`00`000000IVIV06IVIP0306IVIP030000001oOgl0Ogmo
0080Ogmo0P00000A09VIV@8000001`1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<
00@0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0901TI6Ad000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooal000002`0I6AT00`000000
<c<c03<c<`0503<c<`030000001<C4`0C4a<00@0C4a<00<0000006IVIP1VIVH00`1VIVH2000000L0
Ogmo0P00000;09VIV@@000001@1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<0080
C4a<00<0000003<c<`0c<c<00P0c<c<0100000006ATI01TI6@0I6ATF000000<06ATI00<0000003<c
<`0c<c<00P0c<c<01@000000C4a<04a<C01<C4`0000000H0IVIV00<0000007moO`1oOgl00`1oOgl4
000000/0VIVI0P00000807moO`030000001VIVH0IVIV00<0IVIV00<0000004a<C01<C4`0101<C4`0
0`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00X06ATI7@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo7`00000;01TI6@030000000c<c<0<c<c
00H0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP0406IVIP8000001`1oOgl;0000
00P0Ogmo00<0000006IVIP1VIVH0101VIVH01@000000C4a<04a<C01<C4`0000000@0<c<c00<00000
01TI6@0I6AT00P0I6ATF000000@06ATI00D0000003<c<`0c<c<0<c<c0000000404a<C0030000001V
IVH0IVIV00@0IVIV00<0000007moO`1oOgl01P1oOgl;000000P0Ogmo0P00000506IVIP030000001<
C4`0C4a<00@0C4a<00<0000003<c<`0c<c<01P0c<c<00`0000006ATI01TI6@0901TI6Ah000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo8000000;01TI6@8000001`0c<c<0
0`000000C4a<04a<C00404a<C0030000001VIVH0IVIV00D0IVIV0`00000F07moO`8000001@1VIVH0
0`000000C4a<04a<C00204a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT00P0I6ATF
000000@06ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0
IVIV00<0IVIV0P00000F07moO`@000001P1VIVH00`000000C4a<04a<C00404a<C0030000000c<c<0
<c<c00D0<c<c0P00000<01TI6Ah00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo
0080oooo8000000=01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`20000
00P0IVIV0P00000A07moO`<000001@1VIVH2000000@0C4a<00<0000003<c<`0c<c<00P0c<c<00`00
00006ATI01TI6@0301TI6AH000001@0I6AT00`000000<c<c03<c<`0203<c<`030000001<C4`0C4a<
0080C4a<0P00000506IVIP<000004@1oOgl2000000P0IVIV0P00000604a<C0030000000c<c<0<c<c
00D0<c<c00<0000001TI6@0I6AT02`0I6ATO000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooolQ000000d06ATI00<0000003<c<`0c<c<01@0c<c<2000000H0
C4a<0P00000806IVIP8000002`1oOgl4000000L0IVIV00<0000004a<C01<C4`00`1<C4`00`000000
<c<c03<c<`0303<c<`030000000I6AT06ATI00806ATI6000000401TI6@030000000c<c<0<c<c00<0
<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0506IVIP@000002`1oOgl2000000T0
IVIV00<0000004a<C01<C4`0101<C4`2000000L0<c<c00<0000001TI6@0I6AT02`0I6ATP000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolR000000`06ATI
00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00504a<C0800000201VIVH;000000T0IVIV
0P00000604a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT00`0I6ATH000000D06ATI
00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<C00404a<C08000002@1VIVH;000000T0IVIV
0P00000604a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02`0I6ATQ000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolR000000d06ATI00<0
000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00604a<C08000006@1VIVH00`000000C4a<04a<
C00504a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT00`0I6ATH000000D06ATI00<0
000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00504a<C0030000001VIVH0IVIV01P0IVIV0P00
000704a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT02`0I6ATQ000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolS000000d06ATI00<00000
03<c<`0c<c<01`0c<c<2000000P0C4a<0P00000E06IVIP8000001`1<C4`00`000000<c<c03<c<`03
03<c<`030000000I6AT06ATI00<06ATI6P00000501TI6@030000000c<c<0<c<c00<0<c<c00<00000
04a<C01<C4`01@1<C4`2000001H0IVIV0P00000704a<C08000002@0c<c<00`0000006ATI01TI6@0;
01TI6B8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
ob@000003@0I6AT2000000T0<c<c00<0000004a<C01<C4`01`1<C4`3000000`0IVIV1P00000804a<
C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0100I6ATJ000000H06ATI00<0000003<c
<`0c<c<00`0c<c<2000000L0C4a<1P00000<06IVIP@00000201<C4`00`000000<c<c03<c<`0703<c
<`8000003@0I6ATS000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3ooolU000000h06ATI00<0000003<c<`0c<c<01`0c<c<3000000T0C4a<3000000<04a<C080
00001@0c<c<00`0000006ATI01TI6@0501TI6AX000001`0I6AT00`000000<c<c03<c<`0403<c<`80
00002`1<C4`<000000X0C4a<0P00000903<c<`030000000I6AT06ATI00`06ATI900000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo9P00000>01TI6@030000
000c<c<0<c<c00T0<c<c0P00000M04a<C08000001P0c<c<00`0000006ATI01TI6@0601TI6AX00000
200I6AT00`000000<c<c03<c<`0503<c<`8000007@1<C4`2000000X0<c<c00<0000001TI6@0I6AT0
300I6ATU000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolW000000h06ATI0P00000;03<c<`800000601<C4`3000000L0<c<c00<0000001TI6@0I6AT01P0I
6ATK000000P06ATI00<0000003<c<`0c<c<01`0c<c<2000001T0C4a<0P00000:03<c<`8000003P0I
6ATV000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolX
000000l06ATI00<0000003<c<`0c<c<02P0c<c<300000180C4a<0`00000:03<c<`030000000I6AT0
6ATI00H06ATI7000000801TI6@030000000c<c<0<c<c00P0<c<c0`00000C04a<C0<000002`0c<c<0
0`0000006ATI01TI6@0=01TI6BL000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooobT000003`0I6AT00`000000<c<c03<c<`0<03<c<`<00000301<C4`30000
00`0<c<c00<0000001TI6@0I6AT01P0I6ATM000000T06ATI00<0000003<c<`0c<c<02P0c<c<30000
00`0C4a<1000000=03<c<`030000000I6AT06ATI00d06ATI:00000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`8000000`3ooolZ000000l06ATI0P00000?03<c<``000003P0c<c<00`000000
6ATI01TI6@0701TI6Ah000002@0I6AT2000000d0<c<c3000000?03<c<`8000003`0I6ATY000000@0
oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooob`000003`0I6AT2000002D0<c<c
0P00000901TI6B0000002@0I6AT2000002D0<c<c0P00000?01TI6B/000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobd00000400I6AT300000200<c<c0P00
000;01TI6B0000002`0I6AT200000240<c<c0P00000@01TI6B`000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobh000004P0I6AT2000001`0<c<c0P00000<
01TI6B800000300I6AT2000001d0<c<c0P00000A01TI6Bd000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooc0000004P0I6AT2000001P0<c<c0P00000=01TI
6B@000003@0I6AT2000001T0<c<c0P00000A01TI6Bl000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooc4000004`0I6AT400000140<c<c0`00000?01TI6B@0
00003`0I6AT300000140<c<c1@00000B01TI6C0000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooc8000005P0I6ATA000001406ATI9`00000@01TI6A400000
5P0I6ATa000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
oolc000003H06ATI:@00000e01TI6C8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooocD00000<`0I6AT[000003806ATI=00000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo=`00000_01TI6Bh00000;`0I6ATf0000
00D0oooo00<000000?ooo`3oool01@3oool000T0oooo0`0000020?ooo`8000001@3oool00`000000
oooo0?ooo`020?ooocX00000:`0I6AT`000002/06ATI>@0000050?ooo`030000003oool0oooo00D0
oooo000:0?ooo`040000003oool0oooo00000080oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?oooc`00000:00I6ATb000002P06ATI>`0000050?ooo`030000003oool0oooo00D0
oooo00070?ooo`D0000000D0oooo0000003oool0oooo000000040?ooo`<000000P3oooln000002<0
6ATI>000000S01TI6Cd000000`3oool3000000L0oooo00070?ooo`040000003oool0oooo00000080
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?oood0000007`0I6ATl0000
01l06ATI?`0000050?ooo`030000003oool0oooo00D0oooo00080?ooo`030000003oool000000080
oooo00@000000?ooo`3oool00000103oool00`000000oooo0?ooo`020?oood@00000600I6AU20000
01T06ATI@P0000050?ooo`030000003oool0oooo00D0oooo00090?ooo`8000000`3oool2000000D0
oooo00<000000?ooo`3oool00P3ooom8000001406ATIB000000A01TI6DL000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooodh000001`0I6AU@000000L06ATI
C@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0k0?ooo`030000003o
ool0oooo03`0oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00D0oooo000E0?ooool000001@0000070?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?oo
o`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00SP3oool2000000050?ooo`00000000000000003oool0
100000020?ooo`D00000P03oool008h0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0P03oool008h0oooo00D000000?ooo`000000oooo
000000030?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0P03oool008h0oooo0P00
00000`3oool00000000000040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0P03o
ool008h0oooo0P0000000`3oool00000000000020?ooo`040000003oool0oooo000000@0oooo00<0
00000?ooo`3oool0P03oool008h0oooo0P000000103oool000000000000000020?ooo`800000103o
ool200000880oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-3.26594, -1.76599, 0.160642, \
0.160642}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00480769 0.0240385 -0.00480769 0.0240385 [
[.23558 -0.0125 -6 -9 ]
[.23558 -0.0125 6 0 ]
[.47596 -0.0125 -6 -9 ]
[.47596 -0.0125 6 0 ]
[.71635 -0.0125 -6 -9 ]
[.71635 -0.0125 6 0 ]
[.95673 -0.0125 -6 -9 ]
[.95673 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .23558 -12 -4.5 ]
[-0.0125 .23558 0 4.5 ]
[-0.0125 .47596 -12 -4.5 ]
[-0.0125 .47596 0 4.5 ]
[-0.0125 .71635 -12 -4.5 ]
[-0.0125 .71635 0 4.5 ]
[-0.0125 .95673 -12 -4.5 ]
[-0.0125 .95673 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -11 0 ]
[.5 1.0125 11 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23558 0 m
.23558 .00625 L
s
[(10)] .23558 -0.0125 0 1 Mshowa
.47596 0 m
.47596 .00625 L
s
[(20)] .47596 -0.0125 0 1 Mshowa
.71635 0 m
.71635 .00625 L
s
[(30)] .71635 -0.0125 0 1 Mshowa
.95673 0 m
.95673 .00625 L
s
[(40)] .95673 -0.0125 0 1 Mshowa
.125 Mabswid
.04327 0 m
.04327 .00375 L
s
.09135 0 m
.09135 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.1875 0 m
.1875 .00375 L
s
.28365 0 m
.28365 .00375 L
s
.33173 0 m
.33173 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.42788 0 m
.42788 .00375 L
s
.52404 0 m
.52404 .00375 L
s
.57212 0 m
.57212 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.66827 0 m
.66827 .00375 L
s
.76442 0 m
.76442 .00375 L
s
.8125 0 m
.8125 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.90865 0 m
.90865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .23558 m
.00625 .23558 L
s
[(10)] -0.0125 .23558 1 0 Mshowa
0 .47596 m
.00625 .47596 L
s
[(20)] -0.0125 .47596 1 0 Mshowa
0 .71635 m
.00625 .71635 L
s
[(30)] -0.0125 .71635 1 0 Mshowa
0 .95673 m
.00625 .95673 L
s
[(40)] -0.0125 .95673 1 0 Mshowa
.125 Mabswid
0 .04327 m
.00375 .04327 L
s
0 .09135 m
.00375 .09135 L
s
0 .13942 m
.00375 .13942 L
s
0 .1875 m
.00375 .1875 L
s
0 .28365 m
.00375 .28365 L
s
0 .33173 m
.00375 .33173 L
s
0 .37981 m
.00375 .37981 L
s
0 .42788 m
.00375 .42788 L
s
0 .52404 m
.00375 .52404 L
s
0 .57212 m
.00375 .57212 L
s
0 .62019 m
.00375 .62019 L
s
0 .66827 m
.00375 .66827 L
s
0 .76442 m
.00375 .76442 L
s
0 .8125 m
.00375 .8125 L
s
0 .86058 m
.00375 .86058 L
s
0 .90865 m
.00375 .90865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.23558 .99375 m
.23558 1 L
s
.47596 .99375 m
.47596 1 L
s
.71635 .99375 m
.71635 1 L
s
.95673 .99375 m
.95673 1 L
s
.125 Mabswid
.04327 .99625 m
.04327 1 L
s
.09135 .99625 m
.09135 1 L
s
.13942 .99625 m
.13942 1 L
s
.1875 .99625 m
.1875 1 L
s
.28365 .99625 m
.28365 1 L
s
.33173 .99625 m
.33173 1 L
s
.37981 .99625 m
.37981 1 L
s
.42788 .99625 m
.42788 1 L
s
.52404 .99625 m
.52404 1 L
s
.57212 .99625 m
.57212 1 L
s
.62019 .99625 m
.62019 1 L
s
.66827 .99625 m
.66827 1 L
s
.76442 .99625 m
.76442 1 L
s
.8125 .99625 m
.8125 1 L
s
.86058 .99625 m
.86058 1 L
s
.90865 .99625 m
.90865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .23558 m
1 .23558 L
s
.99375 .47596 m
1 .47596 L
s
.99375 .71635 m
1 .71635 L
s
.99375 .95673 m
1 .95673 L
s
.125 Mabswid
.99625 .04327 m
1 .04327 L
s
.99625 .09135 m
1 .09135 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .1875 m
1 .1875 L
s
.99625 .28365 m
1 .28365 L
s
.99625 .33173 m
1 .33173 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .42788 m
1 .42788 L
s
.99625 .52404 m
1 .52404 L
s
.99625 .57212 m
1 .57212 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .66827 m
1 .66827 L
s
.99625 .76442 m
1 .76442 L
s
.99625 .8125 m
1 .8125 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .90865 m
1 .90865 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M02) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.5 Mabswid
.1 g
.01923 .56427 m
.02072 .57212 L
.02633 .59615 L
.03407 .62019 L
.04327 .64235 L
.04414 .64423 L
.05649 .66827 L
.06731 .68679 L
.07104 .69231 L
.08921 .71635 L
.09135 .71889 L
.11204 .74038 L
.11538 .7434 L
.13942 .76239 L
.14236 .76442 L
.16346 .77649 L
.1875 .78674 L
.19283 .78846 L
.21154 .7925 L
.23558 .79395 L
.25962 .79045 L
.26832 .78846 L
.28365 .78002 L
.30353 .76442 L
.30769 .7596 L
.32113 .74038 L
.33173 .71916 L
.33225 .71635 L
.33735 .69231 L
.34323 .66827 L
.34868 .64423 L
.35315 .62019 L
.35577 .60242 L
.35631 .59615 L
.35799 .57212 L
.35911 .54808 L
.35976 .52404 L
.35997 .5 L
.35976 .47596 L
.35911 .45192 L
.35799 .42788 L
.35631 .40385 L
.35577 .39758 L
.35315 .37981 L
.34868 .35577 L
.34323 .33173 L
.33735 .30769 L
.33225 .28365 L
.33173 .28084 L
.32113 .25962 L
.30769 .2404 L
.30353 .23558 L
.28365 .21998 L
.26832 .21154 L
.25962 .20955 L
.23558 .20605 L
.21154 .2075 L
.19283 .21154 L
.1875 .21326 L
.16346 .22351 L
.14236 .23558 L
.13942 .23761 L
.11538 .2566 L
.11204 .25962 L
.09135 .28111 L
.08921 .28365 L
.07104 .30769 L
.06731 .31321 L
.05649 .33173 L
.04414 .35577 L
.04327 .35765 L
.03407 .37981 L
.02633 .40385 L
.02072 .42788 L
.01923 .43573 L
F
0 g
.01923 .56427 m
.02072 .57212 L
.02633 .59615 L
.03407 .62019 L
.04327 .64235 L
.04414 .64423 L
.05649 .66827 L
.06731 .68679 L
.07104 .69231 L
.08921 .71635 L
.09135 .71889 L
.11204 .74038 L
.11538 .7434 L
.13942 .76239 L
.14236 .76442 L
.16346 .77649 L
.1875 .78674 L
.19283 .78846 L
.21154 .7925 L
.23558 .79395 L
.25962 .79045 L
.26832 .78846 L
.28365 .78002 L
.30353 .76442 L
.30769 .7596 L
.32113 .74038 L
.33173 .71916 L
.33225 .71635 L
.33735 .69231 L
.34323 .66827 L
.34868 .64423 L
.35315 .62019 L
.35577 .60242 L
.35631 .59615 L
.35799 .57212 L
.35911 .54808 L
.35976 .52404 L
.35997 .5 L
.35976 .47596 L
.35911 .45192 L
.35799 .42788 L
.35631 .40385 L
.35577 .39758 L
.35315 .37981 L
.34868 .35577 L
.34323 .33173 L
.33735 .30769 L
.33225 .28365 L
.33173 .28084 L
.32113 .25962 L
Mistroke
.30769 .2404 L
.30353 .23558 L
.28365 .21998 L
.26832 .21154 L
.25962 .20955 L
.23558 .20605 L
.21154 .2075 L
.19283 .21154 L
.1875 .21326 L
.16346 .22351 L
.14236 .23558 L
.13942 .23761 L
.11538 .2566 L
.11204 .25962 L
.09135 .28111 L
.08921 .28365 L
.07104 .30769 L
.06731 .31321 L
.05649 .33173 L
.04414 .35577 L
.04327 .35765 L
.03407 .37981 L
.02633 .40385 L
.02072 .42788 L
.01923 .43573 L
Mfstroke
.2 g
.21154 .2533 m
.23558 .25155 L
.25962 .25581 L
.27202 .25962 L
.28365 .26821 L
.30051 .28365 L
.30769 .29345 L
.3161 .30769 L
.32657 .33173 L
.33173 .34735 L
.33279 .35577 L
.33603 .37981 L
.33928 .40385 L
.34207 .42788 L
.34414 .45192 L
.3454 .47596 L
.34582 .5 L
.3454 .52404 L
.34414 .54808 L
.34207 .57212 L
.33928 .59615 L
.33603 .62019 L
.33279 .64423 L
.33173 .65265 L
.32657 .66827 L
.3161 .69231 L
.30769 .70655 L
.30051 .71635 L
.28365 .73179 L
.27202 .74038 L
.25962 .74419 L
.23558 .74845 L
.21154 .7467 L
.189 .74038 L
.1875 .73979 L
.16346 .72754 L
.1471 .71635 L
.13942 .71 L
.12114 .69231 L
.11538 .68581 L
.10188 .66827 L
.09135 .65225 L
.08685 .64423 L
.07506 .62019 L
.06731 .6008 L
.06582 .59615 L
.05918 .57212 L
.05441 .54808 L
.05155 .52404 L
.0506 .5 L
.05155 .47596 L
.05441 .45192 L
.05918 .42788 L
.06582 .40385 L
.06731 .3992 L
.07506 .37981 L
.08685 .35577 L
.09135 .34775 L
.10188 .33173 L
.11538 .31419 L
.12114 .30769 L
.13942 .29 L
.1471 .28365 L
.16346 .27246 L
.1875 .26021 L
.189 .25962 L
F
0 g
.21154 .2533 m
.23558 .25155 L
.25962 .25581 L
.27202 .25962 L
.28365 .26821 L
.30051 .28365 L
.30769 .29345 L
.3161 .30769 L
.32657 .33173 L
.33173 .34735 L
.33279 .35577 L
.33603 .37981 L
.33928 .40385 L
.34207 .42788 L
.34414 .45192 L
.3454 .47596 L
.34582 .5 L
.3454 .52404 L
.34414 .54808 L
.34207 .57212 L
.33928 .59615 L
.33603 .62019 L
.33279 .64423 L
.33173 .65265 L
.32657 .66827 L
.3161 .69231 L
.30769 .70655 L
.30051 .71635 L
.28365 .73179 L
.27202 .74038 L
.25962 .74419 L
.23558 .74845 L
.21154 .7467 L
.189 .74038 L
.1875 .73979 L
.16346 .72754 L
.1471 .71635 L
.13942 .71 L
.12114 .69231 L
.11538 .68581 L
.10188 .66827 L
.09135 .65225 L
.08685 .64423 L
.07506 .62019 L
.06731 .6008 L
.06582 .59615 L
.05918 .57212 L
.05441 .54808 L
.05155 .52404 L
.0506 .5 L
Mistroke
.05155 .47596 L
.05441 .45192 L
.05918 .42788 L
.06582 .40385 L
.06731 .3992 L
.07506 .37981 L
.08685 .35577 L
.09135 .34775 L
.10188 .33173 L
.11538 .31419 L
.12114 .30769 L
.13942 .29 L
.1471 .28365 L
.16346 .27246 L
.1875 .26021 L
.189 .25962 L
.21154 .2533 L
Mfstroke
.3 g
.21154 .28141 m
.23558 .27944 L
.25793 .28365 L
.25962 .28425 L
.28365 .29847 L
.2935 .30769 L
.30769 .32808 L
.30967 .33173 L
.32004 .35577 L
.32736 .37981 L
.33173 .39909 L
.33211 .40385 L
.33394 .42788 L
.33546 .45192 L
.33646 .47596 L
.3368 .5 L
.33646 .52404 L
.33546 .54808 L
.33394 .57212 L
.33211 .59615 L
.33173 .60091 L
.32736 .62019 L
.32004 .64423 L
.30967 .66827 L
.30769 .67192 L
.2935 .69231 L
.28365 .70153 L
.25962 .71575 L
.25793 .71635 L
.23558 .72056 L
.21154 .71859 L
.20263 .71635 L
.1875 .71059 L
.16346 .69668 L
.1575 .69231 L
.13942 .67601 L
.13226 .66827 L
.11538 .64631 L
.11403 .64423 L
.10033 .62019 L
.09135 .6003 L
.08981 .59615 L
.08223 .57212 L
.07689 .54808 L
.07372 .52404 L
.07266 .5 L
.07372 .47596 L
.07689 .45192 L
.08223 .42788 L
.08981 .40385 L
.09135 .3997 L
.10033 .37981 L
.11403 .35577 L
.11538 .35369 L
.13226 .33173 L
.13942 .32399 L
.1575 .30769 L
.16346 .30332 L
.1875 .28941 L
.20263 .28365 L
F
0 g
.21154 .28141 m
.23558 .27944 L
.25793 .28365 L
.25962 .28425 L
.28365 .29847 L
.2935 .30769 L
.30769 .32808 L
.30967 .33173 L
.32004 .35577 L
.32736 .37981 L
.33173 .39909 L
.33211 .40385 L
.33394 .42788 L
.33546 .45192 L
.33646 .47596 L
.3368 .5 L
.33646 .52404 L
.33546 .54808 L
.33394 .57212 L
.33211 .59615 L
.33173 .60091 L
.32736 .62019 L
.32004 .64423 L
.30967 .66827 L
.30769 .67192 L
.2935 .69231 L
.28365 .70153 L
.25962 .71575 L
.25793 .71635 L
.23558 .72056 L
.21154 .71859 L
.20263 .71635 L
.1875 .71059 L
.16346 .69668 L
.1575 .69231 L
.13942 .67601 L
.13226 .66827 L
.11538 .64631 L
.11403 .64423 L
.10033 .62019 L
.09135 .6003 L
.08981 .59615 L
.08223 .57212 L
.07689 .54808 L
.07372 .52404 L
.07266 .5 L
.07372 .47596 L
.07689 .45192 L
.08223 .42788 L
.08981 .40385 L
Mistroke
.09135 .3997 L
.10033 .37981 L
.11403 .35577 L
.11538 .35369 L
.13226 .33173 L
.13942 .32399 L
.1575 .30769 L
.16346 .30332 L
.1875 .28941 L
.20263 .28365 L
.21154 .28141 L
Mfstroke
.4 g
.21154 .30306 m
.23558 .30086 L
.25962 .30623 L
.26409 .30769 L
.28365 .32213 L
.29273 .33173 L
.30732 .35577 L
.30769 .35657 L
.31665 .37981 L
.32312 .40385 L
.32763 .42788 L
.33062 .45192 L
.33173 .46138 L
.33198 .47596 L
.33222 .5 L
.33198 .52404 L
.33173 .53862 L
.33062 .54808 L
.32763 .57212 L
.32312 .59615 L
.31665 .62019 L
.30769 .64343 L
.30732 .64423 L
.29273 .66827 L
.28365 .67787 L
.26409 .69231 L
.25962 .69377 L
.23558 .69914 L
.21154 .69694 L
.1968 .69231 L
.1875 .68806 L
.16346 .67233 L
.1586 .66827 L
.13942 .64832 L
.13617 .64423 L
.12015 .62019 L
.11538 .61145 L
.1084 .59615 L
.09981 .57212 L
.09386 .54808 L
.09135 .5364 L
.09043 .52404 L
.08934 .5 L
.09043 .47596 L
.09135 .4636 L
.09386 .45192 L
.09981 .42788 L
.1084 .40385 L
.11538 .38855 L
.12015 .37981 L
.13617 .35577 L
.13942 .35168 L
.1586 .33173 L
.16346 .32767 L
.1875 .31194 L
.1968 .30769 L
F
0 g
.21154 .30306 m
.23558 .30086 L
.25962 .30623 L
.26409 .30769 L
.28365 .32213 L
.29273 .33173 L
.30732 .35577 L
.30769 .35657 L
.31665 .37981 L
.32312 .40385 L
.32763 .42788 L
.33062 .45192 L
.33173 .46138 L
.33198 .47596 L
.33222 .5 L
.33198 .52404 L
.33173 .53862 L
.33062 .54808 L
.32763 .57212 L
.32312 .59615 L
.31665 .62019 L
.30769 .64343 L
.30732 .64423 L
.29273 .66827 L
.28365 .67787 L
.26409 .69231 L
.25962 .69377 L
.23558 .69914 L
.21154 .69694 L
.1968 .69231 L
.1875 .68806 L
.16346 .67233 L
.1586 .66827 L
.13942 .64832 L
.13617 .64423 L
.12015 .62019 L
.11538 .61145 L
.1084 .59615 L
.09981 .57212 L
.09386 .54808 L
.09135 .5364 L
.09043 .52404 L
.08934 .5 L
.09043 .47596 L
.09135 .4636 L
.09386 .45192 L
.09981 .42788 L
.1084 .40385 L
.11538 .38855 L
.12015 .37981 L
Mistroke
.13617 .35577 L
.13942 .35168 L
.1586 .33173 L
.16346 .32767 L
.1875 .31194 L
.1968 .30769 L
.21154 .30306 L
Mfstroke
.5 g
.1875 .3311 m
.21154 .32129 L
.23558 .31884 L
.25962 .32481 L
.27429 .33173 L
.28365 .34253 L
.29428 .35577 L
.30652 .37981 L
.30769 .38285 L
.3144 .40385 L
.31973 .42788 L
.32322 .45192 L
.3252 .47596 L
.32584 .5 L
.3252 .52404 L
.32322 .54808 L
.31973 .57212 L
.3144 .59615 L
.30769 .61715 L
.30652 .62019 L
.29428 .64423 L
.28365 .65747 L
.27429 .66827 L
.25962 .67519 L
.23558 .68116 L
.21154 .67871 L
.1875 .6689 L
.18632 .66827 L
.16346 .65117 L
.15638 .64423 L
.13942 .62309 L
.1375 .62019 L
.12414 .59615 L
.11538 .57465 L
.11457 .57212 L
.10821 .54808 L
.1045 .52404 L
.10327 .5 L
.1045 .47596 L
.10821 .45192 L
.11457 .42788 L
.11538 .42535 L
.12414 .40385 L
.1375 .37981 L
.13942 .37691 L
.15638 .35577 L
.16346 .34883 L
.18632 .33173 L
F
0 g
.1875 .3311 m
.21154 .32129 L
.23558 .31884 L
.25962 .32481 L
.27429 .33173 L
.28365 .34253 L
.29428 .35577 L
.30652 .37981 L
.30769 .38285 L
.3144 .40385 L
.31973 .42788 L
.32322 .45192 L
.3252 .47596 L
.32584 .5 L
.3252 .52404 L
.32322 .54808 L
.31973 .57212 L
.3144 .59615 L
.30769 .61715 L
.30652 .62019 L
.29428 .64423 L
.28365 .65747 L
.27429 .66827 L
.25962 .67519 L
.23558 .68116 L
.21154 .67871 L
.1875 .6689 L
.18632 .66827 L
.16346 .65117 L
.15638 .64423 L
.13942 .62309 L
.1375 .62019 L
.12414 .59615 L
.11538 .57465 L
.11457 .57212 L
.10821 .54808 L
.1045 .52404 L
.10327 .5 L
.1045 .47596 L
.10821 .45192 L
.11457 .42788 L
.11538 .42535 L
.12414 .40385 L
.1375 .37981 L
.13942 .37691 L
.15638 .35577 L
.16346 .34883 L
.18632 .33173 L
.1875 .3311 L
s
.6 g
.1875 .34838 m
.21154 .33746 L
.23558 .33477 L
.25962 .34136 L
.28066 .35577 L
.28365 .36118 L
.29612 .37981 L
.30597 .40385 L
.30769 .40942 L
.31228 .42788 L
.31632 .45192 L
.31858 .47596 L
.31932 .5 L
.31858 .52404 L
.31632 .54808 L
.31228 .57212 L
.30769 .59058 L
.30597 .59615 L
.29612 .62019 L
.28365 .63882 L
.28066 .64423 L
.25962 .65864 L
.23558 .66523 L
.21154 .66254 L
.1875 .65162 L
.17671 .64423 L
.16346 .63162 L
.15371 .62019 L
.13942 .59809 L
.1384 .59615 L
.12783 .57212 L
.12074 .54808 L
.11665 .52404 L
.11538 .50558 L
.11531 .5 L
.11538 .49442 L
.11665 .47596 L
.12074 .45192 L
.12783 .42788 L
.1384 .40385 L
.13942 .40191 L
.15371 .37981 L
.16346 .36838 L
.17671 .35577 L
F
0 g
.1875 .34838 m
.21154 .33746 L
.23558 .33477 L
.25962 .34136 L
.28066 .35577 L
.28365 .36118 L
.29612 .37981 L
.30597 .40385 L
.30769 .40942 L
.31228 .42788 L
.31632 .45192 L
.31858 .47596 L
.31932 .5 L
.31858 .52404 L
.31632 .54808 L
.31228 .57212 L
.30769 .59058 L
.30597 .59615 L
.29612 .62019 L
.28365 .63882 L
.28066 .64423 L
.25962 .65864 L
.23558 .66523 L
.21154 .66254 L
.1875 .65162 L
.17671 .64423 L
.16346 .63162 L
.15371 .62019 L
.13942 .59809 L
.1384 .59615 L
.12783 .57212 L
.12074 .54808 L
.11665 .52404 L
.11538 .50558 L
.11531 .5 L
.11538 .49442 L
.11665 .47596 L
.12074 .45192 L
.12783 .42788 L
.1384 .40385 L
.13942 .40191 L
.15371 .37981 L
.16346 .36838 L
.17671 .35577 L
.1875 .34838 L
s
.7 g
.21154 .35242 m
.23558 .34948 L
.25783 .35577 L
.25962 .35671 L
.28365 .37904 L
.28422 .37981 L
.29732 .40385 L
.30496 .42788 L
.30769 .43994 L
.30965 .45192 L
.31226 .47596 L
.31309 .5 L
.31226 .52404 L
.30965 .54808 L
.30769 .56006 L
.30496 .57212 L
.29732 .59615 L
.28422 .62019 L
.28365 .62096 L
.25962 .64329 L
.25783 .64423 L
.23558 .65052 L
.21154 .64758 L
.20275 .64423 L
.1875 .63548 L
.16975 .62019 L
.16346 .61265 L
.15194 .59615 L
.14004 .57212 L
.13942 .57067 L
.1323 .54808 L
.12787 .52404 L
.12643 .5 L
.12787 .47596 L
.1323 .45192 L
.13942 .42933 L
.14004 .42788 L
.15194 .40385 L
.16346 .38735 L
.16975 .37981 L
.1875 .36452 L
.20275 .35577 L
F
0 g
.21154 .35242 m
.23558 .34948 L
.25783 .35577 L
.25962 .35671 L
.28365 .37904 L
.28422 .37981 L
.29732 .40385 L
.30496 .42788 L
.30769 .43994 L
.30965 .45192 L
.31226 .47596 L
.31309 .5 L
.31226 .52404 L
.30965 .54808 L
.30769 .56006 L
.30496 .57212 L
.29732 .59615 L
.28422 .62019 L
.28365 .62096 L
.25962 .64329 L
.25783 .64423 L
.23558 .65052 L
.21154 .64758 L
.20275 .64423 L
.1875 .63548 L
.16975 .62019 L
.16346 .61265 L
.15194 .59615 L
.14004 .57212 L
.13942 .57067 L
.1323 .54808 L
.12787 .52404 L
.12643 .5 L
.12787 .47596 L
.1323 .45192 L
.13942 .42933 L
.14004 .42788 L
.15194 .40385 L
.16346 .38735 L
.16975 .37981 L
.1875 .36452 L
.20275 .35577 L
.21154 .35242 L
s
.8 g
.21154 .36665 m
.23558 .36339 L
.25962 .37142 L
.27294 .37981 L
.28365 .39686 L
.2877 .40385 L
.29742 .42788 L
.30302 .45192 L
.30602 .47596 L
.30697 .5 L
.30602 .52404 L
.30302 .54808 L
.29742 .57212 L
.2877 .59615 L
.28365 .60314 L
.27294 .62019 L
.25962 .62858 L
.23558 .63661 L
.21154 .63335 L
.18797 .62019 L
.1875 .61982 L
.16539 .59615 L
.16346 .59324 L
.1518 .57212 L
.14317 .54808 L
.13942 .53472 L
.13832 .52404 L
.13676 .5 L
.13832 .47596 L
.13942 .46528 L
.14317 .45192 L
.1518 .42788 L
.16346 .40676 L
.16539 .40385 L
.1875 .38018 L
.18797 .37981 L
F
0 g
.21154 .36665 m
.23558 .36339 L
.25962 .37142 L
.27294 .37981 L
.28365 .39686 L
.2877 .40385 L
.29742 .42788 L
.30302 .45192 L
.30602 .47596 L
.30697 .5 L
.30602 .52404 L
.30302 .54808 L
.29742 .57212 L
.2877 .59615 L
.28365 .60314 L
.27294 .62019 L
.25962 .62858 L
.23558 .63661 L
.21154 .63335 L
.18797 .62019 L
.1875 .61982 L
.16539 .59615 L
.16346 .59324 L
.1518 .57212 L
.14317 .54808 L
.13942 .53472 L
.13832 .52404 L
.13676 .5 L
.13832 .47596 L
.13942 .46528 L
.14317 .45192 L
.1518 .42788 L
.16346 .40676 L
.16539 .40385 L
.1875 .38018 L
.18797 .37981 L
.21154 .36665 L
s
.9 g
.23558 .37691 m
.248 .37981 L
.25962 .38586 L
.27912 .40385 L
.28365 .4155 L
.28915 .42788 L
.29609 .45192 L
.29968 .47596 L
.3008 .5 L
.29968 .52404 L
.29609 .54808 L
.28915 .57212 L
.28365 .5845 L
.27912 .59615 L
.25962 .61414 L
.248 .62019 L
.23558 .62309 L
.21355 .62019 L
.21154 .61947 L
.1875 .60417 L
.17938 .59615 L
.16355 .57212 L
.16346 .57194 L
.15376 .54808 L
.14839 .52404 L
.14666 .5 L
.14839 .47596 L
.15376 .45192 L
.16346 .42806 L
.16355 .42788 L
.17938 .40385 L
.1875 .39583 L
.21154 .38053 L
.21355 .37981 L
F
0 g
.23558 .37691 m
.248 .37981 L
.25962 .38586 L
.27912 .40385 L
.28365 .4155 L
.28915 .42788 L
.29609 .45192 L
.29968 .47596 L
.3008 .5 L
.29968 .52404 L
.29609 .54808 L
.28915 .57212 L
.28365 .5845 L
.27912 .59615 L
.25962 .61414 L
.248 .62019 L
.23558 .62309 L
.21355 .62019 L
.21154 .61947 L
.1875 .60417 L
.17938 .59615 L
.16355 .57212 L
.16346 .57194 L
.15376 .54808 L
.14839 .52404 L
.14666 .5 L
.14839 .47596 L
.15376 .45192 L
.16346 .42806 L
.16355 .42788 L
.17938 .40385 L
.1875 .39583 L
.21154 .38053 L
.21355 .37981 L
.23558 .37691 L
s
1 g
.21154 .39441 m
.23558 .39033 L
.25962 .40053 L
.26461 .40385 L
.28139 .42788 L
.28365 .43637 L
.2885 .45192 L
.2929 .47596 L
.29425 .5 L
.2929 .52404 L
.2885 .54808 L
.28365 .56363 L
.28139 .57212 L
.26461 .59615 L
.25962 .59947 L
.23558 .60967 L
.21154 .60559 L
.19633 .59615 L
.1875 .58794 L
.17533 .57212 L
.16438 .54808 L
.16346 .54715 L
.15835 .52404 L
.15642 .5 L
.15835 .47596 L
.16346 .45285 L
.16438 .45192 L
.17533 .42788 L
.1875 .41206 L
.19633 .40385 L
F
0 g
.21154 .39441 m
.23558 .39033 L
.25962 .40053 L
.26461 .40385 L
.28139 .42788 L
.28365 .43637 L
.2885 .45192 L
.2929 .47596 L
.29425 .5 L
.2929 .52404 L
.2885 .54808 L
.28365 .56363 L
.28139 .57212 L
.26461 .59615 L
.25962 .59947 L
.23558 .60967 L
.21154 .60559 L
.19633 .59615 L
.1875 .58794 L
.17533 .57212 L
.16438 .54808 L
.16346 .54715 L
.15835 .52404 L
.15642 .5 L
.15835 .47596 L
.16346 .45285 L
.16438 .45192 L
.17533 .42788 L
.1875 .41206 L
.19633 .40385 L
.21154 .39441 L
s
.1 g
.47596 .22494 m
.5 .21961 L
.52404 .22494 L
.54383 .23558 L
.54808 .24256 L
.56099 .25962 L
.57212 .28155 L
.57254 .28365 L
.57778 .30769 L
.58365 .33173 L
.58907 .35577 L
.59352 .37981 L
.59615 .39777 L
.59668 .40385 L
.59837 .42788 L
.5995 .45192 L
.60015 .47596 L
.60036 .5 L
.60015 .52404 L
.5995 .54808 L
.59837 .57212 L
.59668 .59615 L
.59615 .60223 L
.59352 .62019 L
.58907 .64423 L
.58365 .66827 L
.57778 .69231 L
.57254 .71635 L
.57212 .71845 L
.56099 .74038 L
.54808 .75744 L
.54383 .76442 L
.52404 .77506 L
.5 .78039 L
.47596 .77506 L
.45617 .76442 L
.45192 .75744 L
.43901 .74038 L
.42788 .71845 L
.42746 .71635 L
.42222 .69231 L
.41635 .66827 L
.41093 .64423 L
.40648 .62019 L
.40385 .60223 L
.40332 .59615 L
.40163 .57212 L
.4005 .54808 L
.39985 .52404 L
.39964 .5 L
.39985 .47596 L
.4005 .45192 L
.40163 .42788 L
.40332 .40385 L
.40385 .39777 L
.40648 .37981 L
.41093 .35577 L
.41635 .33173 L
.42222 .30769 L
.42746 .28365 L
.42788 .28155 L
.43901 .25962 L
.45192 .24256 L
.45617 .23558 L
F
0 g
.47596 .22494 m
.5 .21961 L
.52404 .22494 L
.54383 .23558 L
.54808 .24256 L
.56099 .25962 L
.57212 .28155 L
.57254 .28365 L
.57778 .30769 L
.58365 .33173 L
.58907 .35577 L
.59352 .37981 L
.59615 .39777 L
.59668 .40385 L
.59837 .42788 L
.5995 .45192 L
.60015 .47596 L
.60036 .5 L
.60015 .52404 L
.5995 .54808 L
.59837 .57212 L
.59668 .59615 L
.59615 .60223 L
.59352 .62019 L
.58907 .64423 L
.58365 .66827 L
.57778 .69231 L
.57254 .71635 L
.57212 .71845 L
.56099 .74038 L
.54808 .75744 L
.54383 .76442 L
.52404 .77506 L
.5 .78039 L
.47596 .77506 L
.45617 .76442 L
.45192 .75744 L
.43901 .74038 L
.42788 .71845 L
.42746 .71635 L
.42222 .69231 L
.41635 .66827 L
.41093 .64423 L
.40648 .62019 L
.40385 .60223 L
.40332 .59615 L
.40163 .57212 L
.4005 .54808 L
.39985 .52404 L
.39964 .5 L
Mistroke
.39985 .47596 L
.4005 .45192 L
.40163 .42788 L
.40332 .40385 L
.40385 .39777 L
.40648 .37981 L
.41093 .35577 L
.41635 .33173 L
.42222 .30769 L
.42746 .28365 L
.42788 .28155 L
.43901 .25962 L
.45192 .24256 L
.45617 .23558 L
.47596 .22494 L
Mfstroke
.2 g
.47596 .27419 m
.5 .26776 L
.52404 .27419 L
.54061 .28365 L
.54808 .29613 L
.55561 .30769 L
.56659 .33173 L
.57212 .34839 L
.57312 .35577 L
.57645 .37981 L
.57971 .40385 L
.58249 .42788 L
.58455 .45192 L
.5858 .47596 L
.58622 .5 L
.5858 .52404 L
.58455 .54808 L
.58249 .57212 L
.57971 .59615 L
.57645 .62019 L
.57312 .64423 L
.57212 .65161 L
.56659 .66827 L
.55561 .69231 L
.54808 .70387 L
.54061 .71635 L
.52404 .72581 L
.5 .73224 L
.47596 .72581 L
.45939 .71635 L
.45192 .70387 L
.44439 .69231 L
.43341 .66827 L
.42788 .65161 L
.42688 .64423 L
.42355 .62019 L
.42029 .59615 L
.41751 .57212 L
.41545 .54808 L
.4142 .52404 L
.41378 .5 L
.4142 .47596 L
.41545 .45192 L
.41751 .42788 L
.42029 .40385 L
.42355 .37981 L
.42688 .35577 L
.42788 .34839 L
.43341 .33173 L
.44439 .30769 L
.45192 .29613 L
.45939 .28365 L
F
0 g
.47596 .27419 m
.5 .26776 L
.52404 .27419 L
.54061 .28365 L
.54808 .29613 L
.55561 .30769 L
.56659 .33173 L
.57212 .34839 L
.57312 .35577 L
.57645 .37981 L
.57971 .40385 L
.58249 .42788 L
.58455 .45192 L
.5858 .47596 L
.58622 .5 L
.5858 .52404 L
.58455 .54808 L
.58249 .57212 L
.57971 .59615 L
.57645 .62019 L
.57312 .64423 L
.57212 .65161 L
.56659 .66827 L
.55561 .69231 L
.54808 .70387 L
.54061 .71635 L
.52404 .72581 L
.5 .73224 L
.47596 .72581 L
.45939 .71635 L
.45192 .70387 L
.44439 .69231 L
.43341 .66827 L
.42788 .65161 L
.42688 .64423 L
.42355 .62019 L
.42029 .59615 L
.41751 .57212 L
.41545 .54808 L
.4142 .52404 L
.41378 .5 L
.4142 .47596 L
.41545 .45192 L
.41751 .42788 L
.42029 .40385 L
.42355 .37981 L
.42688 .35577 L
.42788 .34839 L
.43341 .33173 L
.44439 .30769 L
Mistroke
.45192 .29613 L
.45939 .28365 L
.47596 .27419 L
Mfstroke
.3 g
.47596 .30531 m
.5 .29796 L
.52404 .30531 L
.5291 .30769 L
.54808 .33129 L
.54835 .33173 L
.55984 .35577 L
.5674 .37981 L
.57212 .40067 L
.57239 .40385 L
.57433 .42788 L
.57588 .45192 L
.57689 .47596 L
.57723 .5 L
.57689 .52404 L
.57588 .54808 L
.57433 .57212 L
.57239 .59615 L
.57212 .59933 L
.5674 .62019 L
.55984 .64423 L
.54835 .66827 L
.54808 .66871 L
.5291 .69231 L
.52404 .69469 L
.5 .70204 L
.47596 .69469 L
.4709 .69231 L
.45192 .66871 L
.45165 .66827 L
.44016 .64423 L
.4326 .62019 L
.42788 .59933 L
.42761 .59615 L
.42567 .57212 L
.42412 .54808 L
.42311 .52404 L
.42277 .5 L
.42311 .47596 L
.42412 .45192 L
.42567 .42788 L
.42761 .40385 L
.42788 .40067 L
.4326 .37981 L
.44016 .35577 L
.45165 .33173 L
.45192 .33129 L
.4709 .30769 L
F
0 g
.47596 .30531 m
.5 .29796 L
.52404 .30531 L
.5291 .30769 L
.54808 .33129 L
.54835 .33173 L
.55984 .35577 L
.5674 .37981 L
.57212 .40067 L
.57239 .40385 L
.57433 .42788 L
.57588 .45192 L
.57689 .47596 L
.57723 .5 L
.57689 .52404 L
.57588 .54808 L
.57433 .57212 L
.57239 .59615 L
.57212 .59933 L
.5674 .62019 L
.55984 .64423 L
.54835 .66827 L
.54808 .66871 L
.5291 .69231 L
.52404 .69469 L
.5 .70204 L
.47596 .69469 L
.4709 .69231 L
.45192 .66871 L
.45165 .66827 L
.44016 .64423 L
.4326 .62019 L
.42788 .59933 L
.42761 .59615 L
.42567 .57212 L
.42412 .54808 L
.42311 .52404 L
.42277 .5 L
.42311 .47596 L
.42412 .45192 L
.42567 .42788 L
.42761 .40385 L
.42788 .40067 L
.4326 .37981 L
.44016 .35577 L
.45165 .33173 L
.45192 .33129 L
.4709 .30769 L
.47596 .30531 L
s
.4 g
.47596 .32995 m
.5 .32156 L
.52404 .32995 L
.52744 .33173 L
.54679 .35577 L
.54808 .36046 L
.55621 .37981 L
.56306 .40385 L
.56768 .42788 L
.57069 .45192 L
.57212 .46783 L
.57225 .47596 L
.57251 .5 L
.57225 .52404 L
.57212 .53217 L
.57069 .54808 L
.56768 .57212 L
.56306 .59615 L
.55621 .62019 L
.54808 .63954 L
.54679 .64423 L
.52744 .66827 L
.52404 .67005 L
.5 .67844 L
.47596 .67005 L
.47256 .66827 L
.45321 .64423 L
.45192 .63954 L
.44379 .62019 L
.43694 .59615 L
.43232 .57212 L
.42931 .54808 L
.42788 .53217 L
.42775 .52404 L
.42749 .5 L
.42775 .47596 L
.42788 .46783 L
.42931 .45192 L
.43232 .42788 L
.43694 .40385 L
.44379 .37981 L
.45192 .36046 L
.45321 .35577 L
.47256 .33173 L
F
0 g
.47596 .32995 m
.5 .32156 L
.52404 .32995 L
.52744 .33173 L
.54679 .35577 L
.54808 .36046 L
.55621 .37981 L
.56306 .40385 L
.56768 .42788 L
.57069 .45192 L
.57212 .46783 L
.57225 .47596 L
.57251 .5 L
.57225 .52404 L
.57212 .53217 L
.57069 .54808 L
.56768 .57212 L
.56306 .59615 L
.55621 .62019 L
.54808 .63954 L
.54679 .64423 L
.52744 .66827 L
.52404 .67005 L
.5 .67844 L
.47596 .67005 L
.47256 .66827 L
.45321 .64423 L
.45192 .63954 L
.44379 .62019 L
.43694 .59615 L
.43232 .57212 L
.42931 .54808 L
.42788 .53217 L
.42775 .52404 L
.42749 .5 L
.42775 .47596 L
.42788 .46783 L
.42931 .45192 L
.43232 .42788 L
.43694 .40385 L
.44379 .37981 L
.45192 .36046 L
.45321 .35577 L
.47256 .33173 L
.47596 .32995 L
s
.5 g
.47596 .35145 m
.5 .34189 L
.52404 .35145 L
.53068 .35577 L
.54625 .37981 L
.54808 .38763 L
.55375 .40385 L
.55952 .42788 L
.56316 .45192 L
.5652 .47596 L
.56586 .5 L
.5652 .52404 L
.56316 .54808 L
.55952 .57212 L
.55375 .59615 L
.54808 .61237 L
.54625 .62019 L
.53068 .64423 L
.52404 .64855 L
.5 .65811 L
.47596 .64855 L
.46932 .64423 L
.45375 .62019 L
.45192 .61237 L
.44625 .59615 L
.44048 .57212 L
.43684 .54808 L
.4348 .52404 L
.43414 .5 L
.4348 .47596 L
.43684 .45192 L
.44048 .42788 L
.44625 .40385 L
.45192 .38763 L
.45375 .37981 L
.46932 .35577 L
F
0 g
.47596 .35145 m
.5 .34189 L
.52404 .35145 L
.53068 .35577 L
.54625 .37981 L
.54808 .38763 L
.55375 .40385 L
.55952 .42788 L
.56316 .45192 L
.5652 .47596 L
.56586 .5 L
.5652 .52404 L
.56316 .54808 L
.55952 .57212 L
.55375 .59615 L
.54808 .61237 L
.54625 .62019 L
.53068 .64423 L
.52404 .64855 L
.5 .65811 L
.47596 .64855 L
.46932 .64423 L
.45375 .62019 L
.45192 .61237 L
.44625 .59615 L
.44048 .57212 L
.43684 .54808 L
.4348 .52404 L
.43414 .5 L
.4348 .47596 L
.43684 .45192 L
.44048 .42788 L
.44625 .40385 L
.45192 .38763 L
.45375 .37981 L
.46932 .35577 L
.47596 .35145 L
s
.6 g
.47596 .3714 m
.5 .36045 L
.52404 .3714 L
.53412 .37981 L
.54585 .40385 L
.54808 .41568 L
.55136 .42788 L
.55585 .45192 L
.5583 .47596 L
.55908 .5 L
.5583 .52404 L
.55585 .54808 L
.55136 .57212 L
.54808 .58432 L
.54585 .59615 L
.53412 .62019 L
.52404 .6286 L
.5 .63955 L
.47596 .6286 L
.46588 .62019 L
.45415 .59615 L
.45192 .58432 L
.44864 .57212 L
.44415 .54808 L
.4417 .52404 L
.44092 .5 L
.4417 .47596 L
.44415 .45192 L
.44864 .42788 L
.45192 .41568 L
.45415 .40385 L
.46588 .37981 L
F
0 g
.47596 .3714 m
.5 .36045 L
.52404 .3714 L
.53412 .37981 L
.54585 .40385 L
.54808 .41568 L
.55136 .42788 L
.55585 .45192 L
.5583 .47596 L
.55908 .5 L
.5583 .52404 L
.55585 .54808 L
.55136 .57212 L
.54808 .58432 L
.54585 .59615 L
.53412 .62019 L
.52404 .6286 L
.5 .63955 L
.47596 .6286 L
.46588 .62019 L
.45415 .59615 L
.45192 .58432 L
.44864 .57212 L
.44415 .54808 L
.4417 .52404 L
.44092 .5 L
.4417 .47596 L
.44415 .45192 L
.44864 .42788 L
.45192 .41568 L
.45415 .40385 L
.46588 .37981 L
.47596 .3714 L
s
.7 g
.5 .37821 m
.50826 .37981 L
.52404 .3909 L
.53612 .40385 L
.54508 .42788 L
.54808 .45043 L
.54832 .45192 L
.55133 .47596 L
.55228 .5 L
.55133 .52404 L
.54832 .54808 L
.54808 .54957 L
.54508 .57212 L
.53612 .59615 L
.52404 .6091 L
.50826 .62019 L
.5 .62179 L
.49174 .62019 L
.47596 .6091 L
.46388 .59615 L
.45492 .57212 L
.45192 .54957 L
.45168 .54808 L
.44867 .52404 L
.44772 .5 L
.44867 .47596 L
.45168 .45192 L
.45192 .45043 L
.45492 .42788 L
.46388 .40385 L
.47596 .3909 L
.49174 .37981 L
F
0 g
.5 .37821 m
.50826 .37981 L
.52404 .3909 L
.53612 .40385 L
.54508 .42788 L
.54808 .45043 L
.54832 .45192 L
.55133 .47596 L
.55228 .5 L
.55133 .52404 L
.54832 .54808 L
.54808 .54957 L
.54508 .57212 L
.53612 .59615 L
.52404 .6091 L
.50826 .62019 L
.5 .62179 L
.49174 .62019 L
.47596 .6091 L
.46388 .59615 L
.45492 .57212 L
.45192 .54957 L
.45168 .54808 L
.44867 .52404 L
.44772 .5 L
.44867 .47596 L
.45168 .45192 L
.45192 .45043 L
.45492 .42788 L
.46388 .40385 L
.47596 .3909 L
.49174 .37981 L
.5 .37821 L
s
.8 g
.5 .39588 m
.51753 .40385 L
.52404 .41103 L
.53628 .42788 L
.54335 .45192 L
.54589 .47596 L
.54656 .5 L
.54589 .52404 L
.54335 .54808 L
.53628 .57212 L
.52404 .58897 L
.51753 .59615 L
.5 .60412 L
.48247 .59615 L
.47596 .58897 L
.46372 .57212 L
.45665 .54808 L
.45411 .52404 L
.45344 .5 L
.45411 .47596 L
.45665 .45192 L
.46372 .42788 L
.47596 .41103 L
.48247 .40385 L
F
0 g
.5 .39588 m
.51753 .40385 L
.52404 .41103 L
.53628 .42788 L
.54335 .45192 L
.54589 .47596 L
.54656 .5 L
.54589 .52404 L
.54335 .54808 L
.53628 .57212 L
.52404 .58897 L
.51753 .59615 L
.5 .60412 L
.48247 .59615 L
.47596 .58897 L
.46372 .57212 L
.45665 .54808 L
.45411 .52404 L
.45344 .5 L
.45411 .47596 L
.45665 .45192 L
.46372 .42788 L
.47596 .41103 L
.48247 .40385 L
.5 .39588 L
s
.9 g
.5 .4143 m
.52036 .42788 L
.52404 .4334 L
.53406 .45192 L
.53955 .47596 L
.54095 .5 L
.53955 .52404 L
.53406 .54808 L
.52404 .5666 L
.52036 .57212 L
.5 .5857 L
.47964 .57212 L
.47596 .5666 L
.46594 .54808 L
.46045 .52404 L
.45905 .5 L
.46045 .47596 L
.46594 .45192 L
.47596 .4334 L
.47964 .42788 L
F
0 g
.5 .4143 m
.52036 .42788 L
.52404 .4334 L
.53406 .45192 L
.53955 .47596 L
.54095 .5 L
.53955 .52404 L
.53406 .54808 L
.52404 .5666 L
.52036 .57212 L
.5 .5857 L
.47964 .57212 L
.47596 .5666 L
.46594 .54808 L
.46045 .52404 L
.45905 .5 L
.46045 .47596 L
.46594 .45192 L
.47596 .4334 L
.47964 .42788 L
.5 .4143 L
s
1 g
.5 .43482 m
.51913 .45192 L
.52404 .46019 L
.52782 .47596 L
.53063 .5 L
.52782 .52404 L
.52404 .53981 L
.51913 .54808 L
.5 .56518 L
.48087 .54808 L
.47596 .53981 L
.47218 .52404 L
.46937 .5 L
.47218 .47596 L
.47596 .46019 L
.48087 .45192 L
F
0 g
.5 .43482 m
.51913 .45192 L
.52404 .46019 L
.52782 .47596 L
.53063 .5 L
.52782 .52404 L
.52404 .53981 L
.51913 .54808 L
.5 .56518 L
.48087 .54808 L
.47596 .53981 L
.47218 .52404 L
.46937 .5 L
.47218 .47596 L
.47596 .46019 L
.48087 .45192 L
.5 .43482 L
s
.1 g
.98077 .56427 m
.97928 .57212 L
.97367 .59615 L
.96593 .62019 L
.95673 .64235 L
.95586 .64423 L
.94351 .66827 L
.93269 .68679 L
.92896 .69231 L
.91079 .71635 L
.90865 .71889 L
.88796 .74038 L
.88462 .7434 L
.86058 .76239 L
.85764 .76442 L
.83654 .77649 L
.8125 .78674 L
.80717 .78846 L
.78846 .7925 L
.76442 .79395 L
.74038 .79045 L
.73168 .78846 L
.71635 .78002 L
.69647 .76442 L
.69231 .7596 L
.67887 .74038 L
.66827 .71916 L
.66775 .71635 L
.66265 .69231 L
.65677 .66827 L
.65132 .64423 L
.64685 .62019 L
.64423 .60242 L
.64369 .59615 L
.64201 .57212 L
.64089 .54808 L
.64024 .52404 L
.64003 .5 L
.64024 .47596 L
.64089 .45192 L
.64201 .42788 L
.64369 .40385 L
.64423 .39758 L
.64685 .37981 L
.65132 .35577 L
.65677 .33173 L
.66265 .30769 L
.66775 .28365 L
.66827 .28084 L
.67887 .25962 L
.69231 .2404 L
.69647 .23558 L
.71635 .21998 L
.73168 .21154 L
.74038 .20955 L
.76442 .20605 L
.78846 .2075 L
.80717 .21154 L
.8125 .21326 L
.83654 .22351 L
.85764 .23558 L
.86058 .23761 L
.88462 .2566 L
.88796 .25962 L
.90865 .28111 L
.91079 .28365 L
.92896 .30769 L
.93269 .31321 L
.94351 .33173 L
.95586 .35577 L
.95673 .35765 L
.96593 .37981 L
.97367 .40385 L
.97928 .42788 L
.98077 .43573 L
F
0 g
.98077 .56427 m
.97928 .57212 L
.97367 .59615 L
.96593 .62019 L
.95673 .64235 L
.95586 .64423 L
.94351 .66827 L
.93269 .68679 L
.92896 .69231 L
.91079 .71635 L
.90865 .71889 L
.88796 .74038 L
.88462 .7434 L
.86058 .76239 L
.85764 .76442 L
.83654 .77649 L
.8125 .78674 L
.80717 .78846 L
.78846 .7925 L
.76442 .79395 L
.74038 .79045 L
.73168 .78846 L
.71635 .78002 L
.69647 .76442 L
.69231 .7596 L
.67887 .74038 L
.66827 .71916 L
.66775 .71635 L
.66265 .69231 L
.65677 .66827 L
.65132 .64423 L
.64685 .62019 L
.64423 .60242 L
.64369 .59615 L
.64201 .57212 L
.64089 .54808 L
.64024 .52404 L
.64003 .5 L
.64024 .47596 L
.64089 .45192 L
.64201 .42788 L
.64369 .40385 L
.64423 .39758 L
.64685 .37981 L
.65132 .35577 L
.65677 .33173 L
.66265 .30769 L
.66775 .28365 L
.66827 .28084 L
.67887 .25962 L
Mistroke
.69231 .2404 L
.69647 .23558 L
.71635 .21998 L
.73168 .21154 L
.74038 .20955 L
.76442 .20605 L
.78846 .2075 L
.80717 .21154 L
.8125 .21326 L
.83654 .22351 L
.85764 .23558 L
.86058 .23761 L
.88462 .2566 L
.88796 .25962 L
.90865 .28111 L
.91079 .28365 L
.92896 .30769 L
.93269 .31321 L
.94351 .33173 L
.95586 .35577 L
.95673 .35765 L
.96593 .37981 L
.97367 .40385 L
.97928 .42788 L
.98077 .43573 L
Mfstroke
.2 g
.74038 .25581 m
.76442 .25155 L
.78846 .2533 L
.811 .25962 L
.8125 .26021 L
.83654 .27246 L
.8529 .28365 L
.86058 .29 L
.87886 .30769 L
.88462 .31419 L
.89812 .33173 L
.90865 .34775 L
.91315 .35577 L
.92494 .37981 L
.93269 .3992 L
.93418 .40385 L
.94082 .42788 L
.94559 .45192 L
.94845 .47596 L
.9494 .5 L
.94845 .52404 L
.94559 .54808 L
.94082 .57212 L
.93418 .59615 L
.93269 .6008 L
.92494 .62019 L
.91315 .64423 L
.90865 .65225 L
.89812 .66827 L
.88462 .68581 L
.87886 .69231 L
.86058 .71 L
.8529 .71635 L
.83654 .72754 L
.8125 .73979 L
.811 .74038 L
.78846 .7467 L
.76442 .74845 L
.74038 .74419 L
.72798 .74038 L
.71635 .73179 L
.69949 .71635 L
.69231 .70655 L
.6839 .69231 L
.67343 .66827 L
.66827 .65265 L
.66721 .64423 L
.66397 .62019 L
.66072 .59615 L
.65793 .57212 L
.65586 .54808 L
.6546 .52404 L
.65418 .5 L
.6546 .47596 L
.65586 .45192 L
.65793 .42788 L
.66072 .40385 L
.66397 .37981 L
.66721 .35577 L
.66827 .34735 L
.67343 .33173 L
.6839 .30769 L
.69231 .29345 L
.69949 .28365 L
.71635 .26821 L
.72798 .25962 L
F
0 g
.74038 .25581 m
.76442 .25155 L
.78846 .2533 L
.811 .25962 L
.8125 .26021 L
.83654 .27246 L
.8529 .28365 L
.86058 .29 L
.87886 .30769 L
.88462 .31419 L
.89812 .33173 L
.90865 .34775 L
.91315 .35577 L
.92494 .37981 L
.93269 .3992 L
.93418 .40385 L
.94082 .42788 L
.94559 .45192 L
.94845 .47596 L
.9494 .5 L
.94845 .52404 L
.94559 .54808 L
.94082 .57212 L
.93418 .59615 L
.93269 .6008 L
.92494 .62019 L
.91315 .64423 L
.90865 .65225 L
.89812 .66827 L
.88462 .68581 L
.87886 .69231 L
.86058 .71 L
.8529 .71635 L
.83654 .72754 L
.8125 .73979 L
.811 .74038 L
.78846 .7467 L
.76442 .74845 L
.74038 .74419 L
.72798 .74038 L
.71635 .73179 L
.69949 .71635 L
.69231 .70655 L
.6839 .69231 L
.67343 .66827 L
.66827 .65265 L
.66721 .64423 L
.66397 .62019 L
.66072 .59615 L
.65793 .57212 L
Mistroke
.65586 .54808 L
.6546 .52404 L
.65418 .5 L
.6546 .47596 L
.65586 .45192 L
.65793 .42788 L
.66072 .40385 L
.66397 .37981 L
.66721 .35577 L
.66827 .34735 L
.67343 .33173 L
.6839 .30769 L
.69231 .29345 L
.69949 .28365 L
.71635 .26821 L
.72798 .25962 L
.74038 .25581 L
Mfstroke
.3 g
.76442 .27944 m
.78846 .28141 L
.79737 .28365 L
.8125 .28941 L
.83654 .30332 L
.8425 .30769 L
.86058 .32399 L
.86774 .33173 L
.88462 .35369 L
.88597 .35577 L
.89967 .37981 L
.90865 .3997 L
.91019 .40385 L
.91777 .42788 L
.92311 .45192 L
.92628 .47596 L
.92734 .5 L
.92628 .52404 L
.92311 .54808 L
.91777 .57212 L
.91019 .59615 L
.90865 .6003 L
.89967 .62019 L
.88597 .64423 L
.88462 .64631 L
.86774 .66827 L
.86058 .67601 L
.8425 .69231 L
.83654 .69668 L
.8125 .71059 L
.79737 .71635 L
.78846 .71859 L
.76442 .72056 L
.74207 .71635 L
.74038 .71575 L
.71635 .70153 L
.7065 .69231 L
.69231 .67192 L
.69033 .66827 L
.67996 .64423 L
.67264 .62019 L
.66827 .60091 L
.66789 .59615 L
.66606 .57212 L
.66454 .54808 L
.66354 .52404 L
.6632 .5 L
.66354 .47596 L
.66454 .45192 L
.66606 .42788 L
.66789 .40385 L
.66827 .39909 L
.67264 .37981 L
.67996 .35577 L
.69033 .33173 L
.69231 .32808 L
.7065 .30769 L
.71635 .29847 L
.74038 .28425 L
.74207 .28365 L
F
0 g
.76442 .27944 m
.78846 .28141 L
.79737 .28365 L
.8125 .28941 L
.83654 .30332 L
.8425 .30769 L
.86058 .32399 L
.86774 .33173 L
.88462 .35369 L
.88597 .35577 L
.89967 .37981 L
.90865 .3997 L
.91019 .40385 L
.91777 .42788 L
.92311 .45192 L
.92628 .47596 L
.92734 .5 L
.92628 .52404 L
.92311 .54808 L
.91777 .57212 L
.91019 .59615 L
.90865 .6003 L
.89967 .62019 L
.88597 .64423 L
.88462 .64631 L
.86774 .66827 L
.86058 .67601 L
.8425 .69231 L
.83654 .69668 L
.8125 .71059 L
.79737 .71635 L
.78846 .71859 L
.76442 .72056 L
.74207 .71635 L
.74038 .71575 L
.71635 .70153 L
.7065 .69231 L
.69231 .67192 L
.69033 .66827 L
.67996 .64423 L
.67264 .62019 L
.66827 .60091 L
.66789 .59615 L
.66606 .57212 L
.66454 .54808 L
.66354 .52404 L
.6632 .5 L
.66354 .47596 L
.66454 .45192 L
.66606 .42788 L
Mistroke
.66789 .40385 L
.66827 .39909 L
.67264 .37981 L
.67996 .35577 L
.69033 .33173 L
.69231 .32808 L
.7065 .30769 L
.71635 .29847 L
.74038 .28425 L
.74207 .28365 L
.76442 .27944 L
Mfstroke
.4 g
.74038 .30623 m
.76442 .30086 L
.78846 .30306 L
.8032 .30769 L
.8125 .31194 L
.83654 .32767 L
.8414 .33173 L
.86058 .35168 L
.86383 .35577 L
.87985 .37981 L
.88462 .38855 L
.8916 .40385 L
.90019 .42788 L
.90614 .45192 L
.90865 .4636 L
.90957 .47596 L
.91066 .5 L
.90957 .52404 L
.90865 .5364 L
.90614 .54808 L
.90019 .57212 L
.8916 .59615 L
.88462 .61145 L
.87985 .62019 L
.86383 .64423 L
.86058 .64832 L
.8414 .66827 L
.83654 .67233 L
.8125 .68806 L
.8032 .69231 L
.78846 .69694 L
.76442 .69914 L
.74038 .69377 L
.73591 .69231 L
.71635 .67787 L
.70727 .66827 L
.69268 .64423 L
.69231 .64343 L
.68335 .62019 L
.67688 .59615 L
.67237 .57212 L
.66938 .54808 L
.66827 .53862 L
.66802 .52404 L
.66778 .5 L
.66802 .47596 L
.66827 .46138 L
.66938 .45192 L
.67237 .42788 L
.67688 .40385 L
.68335 .37981 L
.69231 .35657 L
.69268 .35577 L
.70727 .33173 L
.71635 .32213 L
.73591 .30769 L
F
0 g
.74038 .30623 m
.76442 .30086 L
.78846 .30306 L
.8032 .30769 L
.8125 .31194 L
.83654 .32767 L
.8414 .33173 L
.86058 .35168 L
.86383 .35577 L
.87985 .37981 L
.88462 .38855 L
.8916 .40385 L
.90019 .42788 L
.90614 .45192 L
.90865 .4636 L
.90957 .47596 L
.91066 .5 L
.90957 .52404 L
.90865 .5364 L
.90614 .54808 L
.90019 .57212 L
.8916 .59615 L
.88462 .61145 L
.87985 .62019 L
.86383 .64423 L
.86058 .64832 L
.8414 .66827 L
.83654 .67233 L
.8125 .68806 L
.8032 .69231 L
.78846 .69694 L
.76442 .69914 L
.74038 .69377 L
.73591 .69231 L
.71635 .67787 L
.70727 .66827 L
.69268 .64423 L
.69231 .64343 L
.68335 .62019 L
.67688 .59615 L
.67237 .57212 L
.66938 .54808 L
.66827 .53862 L
.66802 .52404 L
.66778 .5 L
.66802 .47596 L
.66827 .46138 L
.66938 .45192 L
.67237 .42788 L
.67688 .40385 L
Mistroke
.68335 .37981 L
.69231 .35657 L
.69268 .35577 L
.70727 .33173 L
.71635 .32213 L
.73591 .30769 L
.74038 .30623 L
Mfstroke
.5 g
.74038 .32481 m
.76442 .31884 L
.78846 .32129 L
.8125 .3311 L
.81368 .33173 L
.83654 .34883 L
.84362 .35577 L
.86058 .37691 L
.8625 .37981 L
.87586 .40385 L
.88462 .42535 L
.88543 .42788 L
.89179 .45192 L
.8955 .47596 L
.89673 .5 L
.8955 .52404 L
.89179 .54808 L
.88543 .57212 L
.88462 .57465 L
.87586 .59615 L
.8625 .62019 L
.86058 .62309 L
.84362 .64423 L
.83654 .65117 L
.81368 .66827 L
.8125 .6689 L
.78846 .67871 L
.76442 .68116 L
.74038 .67519 L
.72571 .66827 L
.71635 .65747 L
.70572 .64423 L
.69348 .62019 L
.69231 .61715 L
.6856 .59615 L
.68027 .57212 L
.67678 .54808 L
.6748 .52404 L
.67416 .5 L
.6748 .47596 L
.67678 .45192 L
.68027 .42788 L
.6856 .40385 L
.69231 .38285 L
.69348 .37981 L
.70572 .35577 L
.71635 .34253 L
.72571 .33173 L
F
0 g
.74038 .32481 m
.76442 .31884 L
.78846 .32129 L
.8125 .3311 L
.81368 .33173 L
.83654 .34883 L
.84362 .35577 L
.86058 .37691 L
.8625 .37981 L
.87586 .40385 L
.88462 .42535 L
.88543 .42788 L
.89179 .45192 L
.8955 .47596 L
.89673 .5 L
.8955 .52404 L
.89179 .54808 L
.88543 .57212 L
.88462 .57465 L
.87586 .59615 L
.8625 .62019 L
.86058 .62309 L
.84362 .64423 L
.83654 .65117 L
.81368 .66827 L
.8125 .6689 L
.78846 .67871 L
.76442 .68116 L
.74038 .67519 L
.72571 .66827 L
.71635 .65747 L
.70572 .64423 L
.69348 .62019 L
.69231 .61715 L
.6856 .59615 L
.68027 .57212 L
.67678 .54808 L
.6748 .52404 L
.67416 .5 L
.6748 .47596 L
.67678 .45192 L
.68027 .42788 L
.6856 .40385 L
.69231 .38285 L
.69348 .37981 L
.70572 .35577 L
.71635 .34253 L
.72571 .33173 L
.74038 .32481 L
s
.6 g
.74038 .34136 m
.76442 .33477 L
.78846 .33746 L
.8125 .34838 L
.82329 .35577 L
.83654 .36838 L
.84629 .37981 L
.86058 .40191 L
.8616 .40385 L
.87217 .42788 L
.87926 .45192 L
.88335 .47596 L
.88462 .49442 L
.88469 .5 L
.88462 .50558 L
.88335 .52404 L
.87926 .54808 L
.87217 .57212 L
.8616 .59615 L
.86058 .59809 L
.84629 .62019 L
.83654 .63162 L
.82329 .64423 L
.8125 .65162 L
.78846 .66254 L
.76442 .66523 L
.74038 .65864 L
.71934 .64423 L
.71635 .63882 L
.70388 .62019 L
.69403 .59615 L
.69231 .59058 L
.68772 .57212 L
.68368 .54808 L
.68142 .52404 L
.68068 .5 L
.68142 .47596 L
.68368 .45192 L
.68772 .42788 L
.69231 .40942 L
.69403 .40385 L
.70388 .37981 L
.71635 .36118 L
.71934 .35577 L
F
0 g
.74038 .34136 m
.76442 .33477 L
.78846 .33746 L
.8125 .34838 L
.82329 .35577 L
.83654 .36838 L
.84629 .37981 L
.86058 .40191 L
.8616 .40385 L
.87217 .42788 L
.87926 .45192 L
.88335 .47596 L
.88462 .49442 L
.88469 .5 L
.88462 .50558 L
.88335 .52404 L
.87926 .54808 L
.87217 .57212 L
.8616 .59615 L
.86058 .59809 L
.84629 .62019 L
.83654 .63162 L
.82329 .64423 L
.8125 .65162 L
.78846 .66254 L
.76442 .66523 L
.74038 .65864 L
.71934 .64423 L
.71635 .63882 L
.70388 .62019 L
.69403 .59615 L
.69231 .59058 L
.68772 .57212 L
.68368 .54808 L
.68142 .52404 L
.68068 .5 L
.68142 .47596 L
.68368 .45192 L
.68772 .42788 L
.69231 .40942 L
.69403 .40385 L
.70388 .37981 L
.71635 .36118 L
.71934 .35577 L
.74038 .34136 L
s
.7 g
.76442 .34948 m
.78846 .35242 L
.79725 .35577 L
.8125 .36452 L
.83025 .37981 L
.83654 .38735 L
.84806 .40385 L
.85996 .42788 L
.86058 .42933 L
.8677 .45192 L
.87213 .47596 L
.87357 .5 L
.87213 .52404 L
.8677 .54808 L
.86058 .57067 L
.85996 .57212 L
.84806 .59615 L
.83654 .61265 L
.83025 .62019 L
.8125 .63548 L
.79725 .64423 L
.78846 .64758 L
.76442 .65052 L
.74217 .64423 L
.74038 .64329 L
.71635 .62096 L
.71578 .62019 L
.70268 .59615 L
.69504 .57212 L
.69231 .56006 L
.69035 .54808 L
.68774 .52404 L
.68691 .5 L
.68774 .47596 L
.69035 .45192 L
.69231 .43994 L
.69504 .42788 L
.70268 .40385 L
.71578 .37981 L
.71635 .37904 L
.74038 .35671 L
.74217 .35577 L
F
0 g
.76442 .34948 m
.78846 .35242 L
.79725 .35577 L
.8125 .36452 L
.83025 .37981 L
.83654 .38735 L
.84806 .40385 L
.85996 .42788 L
.86058 .42933 L
.8677 .45192 L
.87213 .47596 L
.87357 .5 L
.87213 .52404 L
.8677 .54808 L
.86058 .57067 L
.85996 .57212 L
.84806 .59615 L
.83654 .61265 L
.83025 .62019 L
.8125 .63548 L
.79725 .64423 L
.78846 .64758 L
.76442 .65052 L
.74217 .64423 L
.74038 .64329 L
.71635 .62096 L
.71578 .62019 L
.70268 .59615 L
.69504 .57212 L
.69231 .56006 L
.69035 .54808 L
.68774 .52404 L
.68691 .5 L
.68774 .47596 L
.69035 .45192 L
.69231 .43994 L
.69504 .42788 L
.70268 .40385 L
.71578 .37981 L
.71635 .37904 L
.74038 .35671 L
.74217 .35577 L
.76442 .34948 L
s
.8 g
.74038 .37142 m
.76442 .36339 L
.78846 .36665 L
.81203 .37981 L
.8125 .38018 L
.83461 .40385 L
.83654 .40676 L
.8482 .42788 L
.85683 .45192 L
.86058 .46528 L
.86168 .47596 L
.86324 .5 L
.86168 .52404 L
.86058 .53472 L
.85683 .54808 L
.8482 .57212 L
.83654 .59324 L
.83461 .59615 L
.8125 .61982 L
.81203 .62019 L
.78846 .63335 L
.76442 .63661 L
.74038 .62858 L
.72706 .62019 L
.71635 .60314 L
.7123 .59615 L
.70258 .57212 L
.69698 .54808 L
.69398 .52404 L
.69303 .5 L
.69398 .47596 L
.69698 .45192 L
.70258 .42788 L
.7123 .40385 L
.71635 .39686 L
.72706 .37981 L
F
0 g
.74038 .37142 m
.76442 .36339 L
.78846 .36665 L
.81203 .37981 L
.8125 .38018 L
.83461 .40385 L
.83654 .40676 L
.8482 .42788 L
.85683 .45192 L
.86058 .46528 L
.86168 .47596 L
.86324 .5 L
.86168 .52404 L
.86058 .53472 L
.85683 .54808 L
.8482 .57212 L
.83654 .59324 L
.83461 .59615 L
.8125 .61982 L
.81203 .62019 L
.78846 .63335 L
.76442 .63661 L
.74038 .62858 L
.72706 .62019 L
.71635 .60314 L
.7123 .59615 L
.70258 .57212 L
.69698 .54808 L
.69398 .52404 L
.69303 .5 L
.69398 .47596 L
.69698 .45192 L
.70258 .42788 L
.7123 .40385 L
.71635 .39686 L
.72706 .37981 L
.74038 .37142 L
s
.9 g
.76442 .37691 m
.78645 .37981 L
.78846 .38053 L
.8125 .39583 L
.82062 .40385 L
.83645 .42788 L
.83654 .42806 L
.84624 .45192 L
.85161 .47596 L
.85334 .5 L
.85161 .52404 L
.84624 .54808 L
.83654 .57194 L
.83645 .57212 L
.82062 .59615 L
.8125 .60417 L
.78846 .61947 L
.78645 .62019 L
.76442 .62309 L
.752 .62019 L
.74038 .61414 L
.72088 .59615 L
.71635 .5845 L
.71085 .57212 L
.70391 .54808 L
.70032 .52404 L
.6992 .5 L
.70032 .47596 L
.70391 .45192 L
.71085 .42788 L
.71635 .4155 L
.72088 .40385 L
.74038 .38586 L
.752 .37981 L
F
0 g
.76442 .37691 m
.78645 .37981 L
.78846 .38053 L
.8125 .39583 L
.82062 .40385 L
.83645 .42788 L
.83654 .42806 L
.84624 .45192 L
.85161 .47596 L
.85334 .5 L
.85161 .52404 L
.84624 .54808 L
.83654 .57194 L
.83645 .57212 L
.82062 .59615 L
.8125 .60417 L
.78846 .61947 L
.78645 .62019 L
.76442 .62309 L
.752 .62019 L
.74038 .61414 L
.72088 .59615 L
.71635 .5845 L
.71085 .57212 L
.70391 .54808 L
.70032 .52404 L
.6992 .5 L
.70032 .47596 L
.70391 .45192 L
.71085 .42788 L
.71635 .4155 L
.72088 .40385 L
.74038 .38586 L
.752 .37981 L
.76442 .37691 L
s
1 g
.74038 .40053 m
.76442 .39033 L
.78846 .39441 L
.80367 .40385 L
.8125 .41206 L
.82467 .42788 L
.83562 .45192 L
.83654 .45285 L
.84165 .47596 L
.84358 .5 L
.84165 .52404 L
.83654 .54715 L
.83562 .54808 L
.82467 .57212 L
.8125 .58794 L
.80367 .59615 L
.78846 .60559 L
.76442 .60967 L
.74038 .59947 L
.73539 .59615 L
.71861 .57212 L
.71635 .56363 L
.7115 .54808 L
.7071 .52404 L
.70575 .5 L
.7071 .47596 L
.7115 .45192 L
.71635 .43637 L
.71861 .42788 L
.73539 .40385 L
F
0 g
.74038 .40053 m
.76442 .39033 L
.78846 .39441 L
.80367 .40385 L
.8125 .41206 L
.82467 .42788 L
.83562 .45192 L
.83654 .45285 L
.84165 .47596 L
.84358 .5 L
.84165 .52404 L
.83654 .54715 L
.83562 .54808 L
.82467 .57212 L
.8125 .58794 L
.80367 .59615 L
.78846 .60559 L
.76442 .60967 L
.74038 .59947 L
.73539 .59615 L
.71861 .57212 L
.71635 .56363 L
.7115 .54808 L
.7071 .52404 L
.70575 .5 L
.7071 .47596 L
.7115 .45192 L
.71635 .43637 L
.71861 .42788 L
.73539 .40385 L
.74038 .40053 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00C@3oool500000080oooo0P00000e0?ooo`@000000`3oool2000003L0oooo0P0000040?oo
o`800000=`3oool300000080oooo0P00000?0?ooo`00C`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000003D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000g0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0303oool004l0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0b
0?ooo`D0000000D0oooo0000003oool0oooo0000000>0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0380
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000>0?ooo`00C`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0<P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000003D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000e0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003P3oool0
04h0oooo0P0000040?ooo`800000=P3oool2000000@0oooo0P00000g0?ooo`800000103oool20000
03L0oooo0P0000030?ooo`8000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`000005000000L0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooon@00
00040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oo
ooT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3o
oooi000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool20000
00<0oooon@0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooola000000X06ATIQ000000:01TI6C00
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobl00000
4@0I6AUk000001006ATI;P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo:`00000G01TI6GL000005P0I6ATZ000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolY000001/06ATIL`00000J01TI6BP000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooobL000007`0I6ATd0000
00H06ATI=@00000N01TI6BH000001@3oool00`000000oooo0?ooo`050?ooo`001`3oool500000080
oooo0P0000050?ooo`030000003oool0oooo0080oooo9@00000R01TI6Bl000003P0I6AT_00000280
6ATI900000050?ooo`030000003oool0oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo8`00000V01TI6B/0
00004P0I6AT/000002D06ATI8P0000050?ooo`030000003oool0oooo00D0oooo00090?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`<000000P3ooolQ000002T0
6ATI:000000F01TI6BP00000:@0I6ATP000000<0oooo0`0000070?ooo`002@3oool01@000000oooo
0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`020?oooal0
0000;00I6ATV000001L06ATI9`00000/01TI6Ah000001@3oool00`000000oooo0?ooo`050?ooo`00
2@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`020?oooah00000;P0I6ATU000001P06ATI9@00000^01TI6Ad000001@3oool00`000000
oooo0?ooo`050?ooo`00203oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo
7@00000_01TI6B@000006P0I6ATT000002l06ATI700000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo6`00000F01TI6@X000004P0I6ATR000001/06ATI8`00
000B01TI6@X000005P0I6ATJ000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolJ000001@06ATI0`00000:03<c<`D000003@0I6ATR000001`06ATI8P00000=
01TI6@D000002P0c<c<3000001@06ATI6@0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo6@00000B01TI6@<000004P0c<c<3000000/06ATI8000000N01TI
6B000000300I6AT200000180<c<c0`00000B01TI6AP000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?oooaP000004@0I6AT2000001P0<c<c0P00000:01TI6Ah0
00007`0I6ATO000000/06ATI0P00000G03<c<`8000004@0I6ATG000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolG000001006ATI0P00000L03<c<`030000
000I6AT06ATI00L06ATI7P00000?01TI6@<000003P0I6ATN000000X06ATI00<0000003<c<`0c<c<0
6@0c<c<2000001006ATI5P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo5P00000?01TI6@8000007`0c<c<00`0000006ATI01TI6@0701TI6A`00000300I
6AT4000000<0<c<c0`00000;01TI6Ad000002P0I6AT00`000000<c<c03<c<`0L03<c<`8000003P0I
6ATF000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolF
000000h06ATI00<0000003<c<`0c<c<0800c<c<00`0000006ATI01TI6@0601TI6A`000002P0I6AT2
000000X0<c<c0P00000:01TI6A`00000200I6AT200000240<c<c00<0000001TI6@0I6AT0300I6ATE
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolE0000
00d06ATI0P00000B03<c<`D000003@0c<c<00`0000006ATI01TI6@0601TI6AX000002@0I6AT20000
00h0<c<c0P00000801TI6A/00000200I6AT00`000000<c<c03<c<`0;03<c<`D000004P0c<c<20000
00d06ATI500000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolD000000d0
6ATI00<0000003<c<`0c<c<0300c<c<6000000D0C4a<1000000:03<c<`030000000I6AT06ATI00D0
6ATI6P00000701TI6@8000004P0c<c<2000000L06ATI6P00000701TI6@030000000c<c<0<c<c00P0
<c<c1000000504a<C0L000003@0c<c<00`0000006ATI01TI6@0;01TI6A<00000103oool2000000L0
oooo000E0?ooo`030000003oool0oooo0080oooo4P00000>01TI6@030000000c<c<0<c<c00/0<c<c
0P00000?04a<C08000002@0c<c<00`0000006ATI01TI6@0401TI6AX000001P0I6AT00`000000<c<c
03<c<`0D03<c<`030000000I6AT06ATI00@06ATI6P00000601TI6@030000000c<c<0<c<c00L0<c<c
0P00000@04a<C0800000300c<c<00`0000006ATI01TI6@0<01TI6A4000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa4000003P0I6AT00`000000<c<c03<c
<`0903<c<`<000004`1<C4`2000000L0<c<c00<0000001TI6@0I6AT0100I6ATI000000L06ATI00<0
000003<c<`0c<c<0500c<c<00`0000006ATI01TI6@0501TI6AT000001P0I6AT00`000000<c<c03<c
<`0603<c<`030000001<C4`0C4a<0180C4a<0P00000;03<c<`030000000I6AT06ATI00`06ATI4000
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo4000000>
01TI6@030000000c<c<0<c<c00P0<c<c0P00000H04a<C08000001P0c<c<00`0000006ATI01TI6@03
01TI6AT000001P0I6AT00`000000<c<c03<c<`0F03<c<`030000000I6AT06ATI00@06ATI60000006
01TI6@030000000c<c<0<c<c00D0<c<c0P00000G04a<C08000002P0c<c<00`0000006ATI01TI6@0;
01TI6A0000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
oa000000300I6AT2000000T0<c<c0P00000L04a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI
6@0I6AT00`0I6ATH000000D06ATI00<0000003<c<`0c<c<02P0c<c<3000000/0<c<c00<0000001TI
6@0I6AT00`0I6ATH000000D06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00I04a<
C08000002@0c<c<2000000`06ATI3`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo3`00000<01TI6@030000000c<c<0<c<c00L0<c<c0P00000:04a<C0X0
00002`1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00<06ATI5`00000601TI6@03
0000000c<c<0<c<c00H0<c<c1000000304a<C0<00000200c<c<00`0000006ATI01TI6@0401TI6AL0
00001@0I6AT00`000000<c<c03<c<`0303<c<`8000002P1<C4`:000000X0C4a<0P00000903<c<`03
0000000I6AT06ATI00X06ATI3P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo3P00000<01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<C01<C4`0
1`1<C4`3000000X0IVIV1@00000704a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0
0P0I6ATG000000D06ATI00<0000003<c<`0c<c<0100c<c<3000000X0C4a<0`00000603<c<`030000
000I6AT06ATI00<06ATI5`00000401TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`0
1@1<C4`5000000X0IVIV0`00000904a<C0030000000c<c<0<c<c00L0<c<c00<0000001TI6@0I6AT0
2P0I6AT=000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3o
ool>000000/06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C00704a<C0030000001V
IVH0IVIV0100IVIV0P00000604a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I6AT00P0I
6ATG000000D06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00>04a<C0030000000c
<c<0<c<c00<0<c<c00<0000001TI6@0I6AT00`0I6ATG000000@06ATI00<0000003<c<`0c<c<00P0c
<c<00`000000C4a<04a<C00504a<C0030000001VIVH0IVIV0100IVIV00<0000004a<C01<C4`01`1<
C4`00`000000<c<c03<c<`0603<c<`030000000I6AT06ATI00X06ATI3@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo3P00000;01TI6@030000000c<c<0
<c<c00H0<c<c00<0000004a<C01<C4`01`1<C4`00`000000IVIV06IVIP0C06IVIP030000001<C4`0
C4a<00<0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0201TI6AH00000100I6AT0
0`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00h0C4a<00<0000003<c<`0c<c<0100c<c<0
0`0000006ATI01TI6@0201TI6AH00000100I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0
C4a<00<0C4a<0P00000D06IVIP030000001<C4`0C4a<00L0C4a<00<0000003<c<`0c<c<01P0c<c<0
0`0000006ATI01TI6@0:01TI6@`000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooo`d000002`0I6AT00`000000<c<c03<c<`0603<c<`030000001<C4`0C4a<
00H0C4a<0P00000:06IVIP@000002@1VIVH2000000@0C4a<00<0000003<c<`0c<c<00P0c<c<00`00
00006ATI01TI6@0201TI6AH00000100I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<
0100C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0201TI6AH00000100I6AT00`00
0000<c<c03<c<`0203<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH01`1VIVH40000
00X0IVIV0P00000804a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I6AT02@0I6AT<0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool=000000X0
6ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00504a<C08000001`1VIVH5000000@0
Ogmo0`00000806IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00P0c<c<010000000
6ATI01TI6@0I6ATE000000@06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00704a<
C0<00000201<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00806ATI5@00000301TI
6@030000000c<c<0<c<c0080<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0506IV
IP<00000101oOgl5000000L0IVIV0P00000704a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI
6@0I6AT02@0I6AT;000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3oool<000000/06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00404a<C080
00001P1VIVH3000000`0Ogmo0P00000706IVIP050000001<C4`0C4a<04a<C0000000100c<c<01000
00006ATI01TI6@0I6ATE000000@06ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<04a<C004
04a<C0@000000`1VIVH3000000H0C4a<00<0000003<c<`0c<c<00P0c<c<00`0000006ATI01TI6@02
01TI6AD000000`0I6AT00`000000<c<c03<c<`0203<c<`030000001<C4`0C4a<0080C4a<00<00000
06IVIP1VIVH0101VIVH2000000`0Ogmo0`00000606IVIP8000001P1<C4`00`000000<c<c03<c<`05
03<c<`030000000I6AT06ATI00T06ATI2`0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo3000000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<
C01<C4`0101<C4`00`000000IVIV06IVIP0406IVIP8000004@1oOgl2000000D0IVIV00<0000004a<
C01<C4`00P1<C4`00`000000<c<c03<c<`0203<c<`040000000I6AT06ATI01TI6A@000000`0I6AT0
0`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<0P00000:06IVIP800000101<C4`0
0`000000<c<c03<c<`0303<c<`040000000I6AT06ATI01TI6A@000000`0I6AT00`000000<c<c03<c
<`0203<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00`1VIVH200000140Ogmo0P00
000606IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI
6@0901TI6@X000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo2`00000:
01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP04
06IVIP030000001oOgl0Ogmo00P0Ogmo1000000707moO`800000101VIVH01@000000C4a<04a<C01<
C4`0000000@0<c<c00@0000001TI6@0I6AT06ATI5000000301TI6@030000000c<c<0<c<c0080<c<c
00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0<06IVIP030000001<C4`0C4a<0080C4a<
00<0000003<c<`0c<c<00P0c<c<0100000006ATI01TI6@0I6ATD000000<06ATI00<0000003<c<`0c
<c<00P0c<c<01@000000C4a<04a<C01<C4`0000000@0IVIV0P00000707moO`@000002P1oOgl00`00
0000IVIV06IVIP0406IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<01@0c<c<00`00
00006ATI01TI6@0801TI6@X00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080
oooo2P00000:01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`00`000000
IVIV06IVIP0306IVIP8000001`1oOgl4000000@0VIVI0`00000607moO`8000000`1VIVH010000000
C4a<04a<C000000403<c<`040000000I6AT06ATI01TI6A@000000`0I6AT01@000000<c<c03<c<`0c
<c<0000000@0C4a<00<0000006IVIP1VIVH03P1VIVH01@000000C4a<04a<C01<C4`0000000@0<c<c
00@0000001TI6@0I6AT06ATI5000000301TI6@050000000c<c<0<c<c03<c<`0000000`1<C4`00`00
0000IVIV06IVIP0206IVIP030000001oOgl0Ogmo00@0Ogmo0`00000409VIV@@000001`1oOgl20000
00D0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00T06ATI2@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo2P00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`0101<C4`00`000000
IVIV06IVIP0306IVIP030000001oOgl0Ogmo00D0Ogmo0P00000;09VIV@8000001P1oOgl010000000
IVIV06IVIP00000304a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATC000000<06ATI00<00000
03<c<`0c<c<00P0c<c<01@000000C4a<04a<C01<C4`0000000P0IVIV0P00000806IVIP050000001<
C4`0C4a<04a<C00000000`0c<c<00`0000006ATI01TI6@0201TI6A<000000P0I6AT00`000000<c<c
03<c<`0203<c<`050000001<C4`0C4a<04a<C00000000`1VIVH00`000000Ogmo07moO`0307moO`80
00002`2IVIT2000000L0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<04a<C00404a<C003
0000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT0200I6AT9000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3oool9000000X06ATI00<0000003<c<`0c<c<0
1@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080IVIV0P00000607moO`800000
3`2IVIT2000000@0Ogmo00D0000006IVIP1VIVH0IVIV0000000204a<C0030000000c<c<0<c<c0080
<c<c00<0000001TI6@0I6AT04`00000301TI6@050000000c<c<0<c<c03<c<`0000000`1<C4`00`00
0000IVIV06IVIP0506IVIP8000000P1oOgl2000000H0IVIV00D0000004a<C01<C4`0C4a<00000004
03<c<`040000000I6AT06ATI01TI6A8000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<
00D0000006IVIP1VIVH0IVIV0000000407moO`8000003`2IVIT2000000H0Ogmo0P00000406IVIP03
0000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0901TI6@P0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T00000
2P0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH0
0P1VIVH00`000000Ogmo07moO`0407moO`800000202IVIT4000000L0VIVI00<0000007moO`1oOgl0
0P1oOgl01@000000IVIV06IVIP1VIVH000000080C4a<00D0000003<c<`0c<c<0<c<c0000000301TI
6A8000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00<0000006IVIP1VIVH00`1VIVH2
000000H0Ogmo0P00000506IVIP050000001<C4`0C4a<04a<C00000000`0c<c<0100000006ATI01TI
6@0I6ATB000000<06ATI00D0000003<c<`0c<c<0<c<c0000000204a<C0050000001VIVH0IVIV06IV
IP000000101oOgl00`000000VIVI09VIV@0509VIV@@00000202IVIT2000000H0Ogmo00<0000006IV
IP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI
6@0I6AT02@0I6AT7000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3oool8000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C003
0000001VIVH0IVIV0080IVIV00<0000007moO`1oOgl00`1oOgl2000000H0VIVI100000040;>c/`<0
00001@2IVIT200000080Ogmo00D0000006IVIP1VIVH0IVIV0000000204a<C0050000000c<c<0<c<c
03<c<`0000000`0I6ATA000000@06ATI00@0000003<c<`0c<c<000000`1<C4`00`000000IVIV06IV
IP0206IVIP8000002P1oOgl2000000@0IVIV00@0000004a<C01<C4`000000`0c<c<00`0000006ATI
01TI6@0201TI6A4000000`0I6AT010000000<c<c03<c<`00000304a<C0050000001VIVH0IVIV06IV
IP0000000P1oOgl2000000D0VIVI0`0000040;>c/`D000001@2IVIT2000000D0Ogmo00<0000006IV
IP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI
6@0I6AT0200I6AT7000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3oool8000000X06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C003
0000001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl00P1oOgl00`000000VIVI09VIV@0409VIV@80
00002`2c/k<2000000D0VIVI00@0000007moO`1oOgl000000`1VIVH010000000C4a<04a<C0000002
03<c<`040000000I6AT06ATI01TI6A400000100I6AT010000000<c<c03<c<`00000204a<C0030000
001VIVH0IVIV0080IVIV00<0000007moO`1oOgl0301oOgl2000000<0IVIV00@0000004a<C01<C4`0
00000P0c<c<00`0000006ATI01TI6@0201TI6A4000000`0I6AT010000000<c<c03<c<`00000204a<
C0050000001VIVH0IVIV06IVIP0000000P1oOgl00`000000VIVI09VIV@0309VIV@800000302c/k<2
000000D0VIVI00<0000007moO`1oOgl00`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0
C4a<00<0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6@H000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`L000002P0I6AT00`00
0000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00`1VIVH00`00
0000Ogmo07moO`0207moO`030000002IVIT0VIVI00<0VIVI0P00000?0;>c/`030000002IVIT0VIVI
00<0VIVI00<0000007moO`0000000`1VIVH010000000C4a<04a<C000000203<c<`040000000I6AT0
6ATI01TI6A400000100I6AT010000000<c<c03<c<`00000204a<C0050000001VIVH0IVIV06IVIP00
00001`1oOgl2000000P0Ogmo00@0000006IVIP1VIVH000000P1<C4`010000000<c<c03<c<`000004
01TI6A4000000`0I6AT010000000<c<c03<c<`00000204a<C0040000001VIVH0IVIV000000<0Ogmo
00<0000009VIV@2IVIT00P2IVIT00`000000/k>c0;>c/`0>0;>c/`800000102IVIT00`000000Ogmo
07moO`0307moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c
03<c<`0403<c<`030000000I6AT06ATI00P06ATI1P0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo1P00000;01TI6@030000000c<c<0<c<c00@0<c<c00<0
000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP040000001oOgl0Ogmo07moO`800000
102IVIT2000000P0/k>c100000060;>c/`030000002IVIT0VIVI00<0VIVI00<0000007moO`000000
0`1VIVH01P000000C4a<04a<C0000000<c<c000000@06ATI4000000401TI6@030000000c<c<00000
00<0C4a<00D0000006IVIP1VIVH0IVIV0000000507moO`8000000P2IVIT2000000H0Ogmo00@00000
06IVIP1VIVH000000`1<C4`00`000000<c<c0000000401TI6A4000000`0I6AT00`000000<c<c0000
000204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl00`000000VIVI09VIV@0209VIV@030000
002c/k<0/k>c00@0/k>c100000090;>c/`030000002IVIT0VIVI0080VIVI0P00000407moO`050000
001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P0
6ATI1@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
1P00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV
06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000001@2IVIT00`000000/k>c0;>c/`040;>c/`@0
0000103<c<`3000000@0/k>c0P00000309VIV@030000001oOgl0000000<0IVIV00H0000004a<C01<
C4`0000003<c<`00000401TI6@l00000100I6AT010000000<c<c03<c<`00000204a<C0050000001V
IVH0IVIV06IVIP000000101oOgl2000000H0VIVI0P00000507moO`040000001VIVH0IVIV00000080
C4a<00<0000003<c<`000000100I6AT@000000<06ATI00@0000003<c<`0c<c<000000P1<C4`01000
0000IVIV06IVIP00000207moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<00P2c/k<3
000000@0c<c<100000060;>c/`030000002IVIT0VIVI00<0VIVI00D0000007moO`1oOgl0Ogmo0000
000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI
6@0801TI6@D000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`H000002P0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00<00000
06IVIP1VIVH00P1VIVH01@000000Ogmo07moO`1oOgl0000000@0VIVI0P0000050;>c/`8000002`3<
c<`2000000@0/k>c00L0000009VIV@2IVIT0VIVI0000001oOgl000000080IVIV00@0000004a<C01<
C4`000000P0c<c<0100000006ATI01TI6@0I6AT?000000@06ATI00@0000003<c<`0c<c<000000P1<
C4`010000000IVIV06IVIP00000307moO`8000002P2IVIT2000000@0Ogmo00<0000006IVIP000000
0P1<C4`010000000<c<c03<c<`00000401TI6@l000000`0I6AT010000000<c<c03<c<`00000204a<
C0040000001VIVH0IVIV00000080Ogmo00D0000009VIV@2IVIT0VIVI000000030;>c/`8000002`3<
c<`2000000D0/k>c0P00000409VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<
04a<C00204a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT01`0I6AT5000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool5000000X06ATI00<0
000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP000000
101oOgl01@000000VIVI09VIV@2IVIT0000000D0/k>c0P0000060<c<c0@000001@3<c<`2000000<0
/k>c00H0000009VIV@2IVIT0000007moO`00000306IVIP060000001<C4`0C4a<0000000c<c<00000
100I6AT>000000@06ATI00<0000003<c<`0000000P1<C4`01@000000IVIV06IVIP1VIVH000000080
Ogmo00<0000009VIV@2IVIT0302IVIT01@000000Ogmo07moO`1oOgl000000080IVIV00H0000004a<
C01<C4`0000003<c<`00000401TI6@l000000`0I6AT00`000000<c<c0000000204a<C0040000001V
IVH0IVIV00000080Ogmo00D0000009VIV@2IVIT0VIVI000000020;>c/`8000001@3<c<`4000000H0
c<c<0P0000050;>c/`050000002IVIT0VIVI09VIV@000000101oOgl01@000000IVIV06IVIP1VIVH0
000000@0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6@@000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo1@00000:01TI6@030000000c<c<0<c<c
00<0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo
07moO`0000000`2IVIT00`000000/k>c0;>c/`020;>c/`800000103<c<`4000000@0i^KV0P000005
0<c<c08000000P2c/k<01P000000VIVI09VIV@000000Ogmo00000080IVIV00H0000004a<C01<C4`0
000003<c<`00000401TI6@h00000100I6AT00`000000<c<c0000000204a<C0040000001VIVH0IVIV
00000080Ogmo00<0000009VIV@2IVIT00`2IVIT6000000D0VIVI00L0000007moO`1oOgl0Ogmo0000
001VIVH000000080C4a<00<0000003<c<`000000100I6AT?000000<06ATI00<0000003<c<`000000
0P1<C4`01P000000IVIV06IVIP000000Ogmo00000080VIVI0P0000000`2c/k<00000000000050<c<
c0800000103Vi^H4000000@0c<c<0P0000040;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl0
0`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<0
0`0000006ATI01TI6@0701TI6@@00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo
0080oooo1@00000:01TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<00000004
06IVIP050000001oOgl0Ogmo07moO`0000000`2IVIT00`000000/k>c0;>c/`020;>c/`030000003<
c<`0c<c<0080c<c<0P00000:0>KViP8000001@3<c<`00`000000/k>c0000000209VIV@060000001o
Ogl0Ogmo0000001VIVH000000P1<C4`00`000000<c<c0000000401TI6@h00000100I6AT00`000000
<c<c0000000204a<C0030000001VIVH000000080Ogmo00<0000009VIV@2IVIT00`2IVIT00`000000
/k>c0;>c/`040;>c/`030000002IVIT0VIVI0080VIVI00L0000007moO`1oOgl0Ogmo0000001VIVH0
00000080C4a<00<0000003<c<`000000100I6AT?000000<06ATI00<0000003<c<`0000000P1<C4`0
0`000000IVIV0000000207moO`030000002IVIT0000000<0/k>c00<000000<c<c03<c<`00P3<c<`2
000000X0i^KV0P0000040<c<c0030000002c/k<0/k>c0080/k>c00D0000009VIV@2IVIT0VIVI0000
000307moO`050000001VIVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000
000I6AT06ATI00L06ATI100000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo1000000:01TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<
C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`0000000P2IVIT00`000000/k>c
0;>c/`020;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H0303Vi^H00`000000c<c<
0<c<c0020<c<c0040000002c/k<0/k>c00000080VIVI00<0000007moO`0000000P1VIVH01@000000
C4a<0000000c<c<0000000@06ATI3P00000401TI6@050000000c<c<0000004a<C00000000P1VIVH0
10000000Ogmo07moO`00000309VIV@800000202c/k<2000000<0VIVI00@0000007moO`1oOgl00000
0P1VIVH01@000000C4a<0000000c<c<0000000@06ATI3`00000301TI6@050000000c<c<0000004a<
C00000000P1VIVH00`000000Ogmo0000000209VIV@040000002c/k<0/k>c000000@0c<c<00<00000
0>KViP3Vi^H0303Vi^H00`000000c<c<0<c<c0020<c<c0030000002c/k<0/k>c0080/k>c00@00000
09VIV@2IVIT000000`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0
000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0701TI6@<000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`@000002P0I6AT00`000000<c<c03<c<`03
03<c<`050000001<C4`0C4a<04a<C0000000101VIVH01@000000Ogmo07moO`1oOgl000000080VIVI
00<000000;>c/`2c/k<00P2c/k<010000000c<c<0<c<c03<c<`2000000L0i^KV100000050>KViP03
0000003<c<`0c<c<0080c<c<00<000000;>c/`0000000P2IVIT00`000000Ogmo0000000206IVIP03
0000001<C4`0C4a<00800000100I6AT>000000<06ATI00<0000003<c<`0000000P1<C4`01P000000
IVIV06IVIP000000Ogmo000000<0VIVI00<000000;>c/`2c/k<02P2c/k<010000000VIVI09VIV@00
000207moO`040000001VIVH0IVIV00000080C4a<0P00000401TI6@h000000`0I6AT00`000000<c<c
0000000204a<C0080000001VIVH0IVIV0000001oOgl0000009VIV@0000030;>c/`050000003<c<`0
c<c<0<c<c00000001@3Vi^H4000000L0i^KV0P0000030<c<c0030000002c/k<0/k>c0080/k>c00@0
000009VIV@2IVIT000000`1oOgl01@000000IVIV06IVIP1VIVH0000000@0C4a<00<0000003<c<`0c
<c<0100c<c<00`0000006ATI01TI6@0701TI6@<000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?ooo`@000002@0I6AT00`000000<c<c03<c<`0303<c<`030000
001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`040000002IVIT0VIVI0000
00@0/k>c00D000000<c<c03<c<`0c<c<000000050>KViP@00000103oool3000000<0i^KV0P000002
0<c<c0060000002c/k<0/k>c0000002IVIT000000P1oOgl00`000000IVIV0000000204a<C0030000
000c<c<0000000<06ATI3P00000301TI6@030000000c<c<000000080C4a<00<0000006IVIP000000
0P1oOgl010000000VIVI09VIV@0000060;>c/`8000001P2c/k<01P000000VIVI09VIV@000000Ogmo
00000080IVIV00H0000004a<C01<C4`0000003<c<`00000301TI6@h000000`0I6AT00`000000<c<c
0000000204a<C0030000001VIVH000000080Ogmo00<0000009VIV@0000000P2c/k<00`000000c<c<
0<c<c002000000<0i^KV0`0000040?ooo`@000001@3Vi^H01@000000c<c<0<c<c03<c<`0000000<0
/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`050000001VIVH0IVIV06IVIP000000101<C4`0
0`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00H06ATI0`0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo0`00000:01TI6@030000000c<c<0<c<c
00<0<c<c00D0000004a<C01<C4`0C4a<0000000406IVIP050000001oOgl0Ogmo07moO`0000000P2I
VIT01@000000/k>c0;>c/`2c/k<0000000<0c<c<00<000000>KViP3Vi^H00P3Vi^H2000000/0oooo
0P0000030>KViP060000003<c<`0c<c<0000002c/k<000000P2IVIT00`000000Ogmo0000000206IV
IP050000001<C4`0000003<c<`0000000`0I6AT>000000<06ATI00D0000003<c<`000000C4a<0000
000206IVIP030000001oOgl000000080VIVI00<000000;>c/`2c/k<00`2c/k<200000080c<c<0P00
00050;>c/`030000002IVIT000000080Ogmo00P0000006IVIP1VIVH0000004a<C0000000<c<c0000
00<06ATI3P00000301TI6@050000000c<c<0000004a<C00000000P1VIVH01@000000Ogmo0000002I
VIT0000000<0/k>c00<000000<c<c00000000`3Vi^H2000000/0oooo0P0000040>KViP8000000P3<
c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP03
0000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0701TI6@80
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`<00000
2@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0
IVIV0000000307moO`040000002IVIT0VIVI000000<0/k>c00D000000<c<c03<c<`0c<c<00000003
0>KViP8000003`3oool200000080i^KV00X000000<c<c03<c<`000000;>c/`000000VIVI0000001o
Ogl000000P1VIVH01@000000C4a<0000000c<c<0000000<06ATI3P00000301TI6@050000000c<c<0
000004a<C00000000P1VIVH01@000000Ogmo0000002IVIT0000000@0/k>c0P0000060<c<c0800000
102c/k<01@000000VIVI0000001oOgl000000080IVIV00D0000004a<C0000000<c<c0000000401TI
6@d000000`0I6AT01@000000<c<c0000001<C4`000000080IVIV00D0000007moO`000000VIVI0000
00020;>c/`030000003<c<`0000000<0i^KV00<000000?ooo`3oool03@3oool2000000@0i^KV00@0
00000<c<c03<c<`000000`2c/k<010000000VIVI09VIV@00000307moO`050000001VIVH0IVIV06IV
IP000000101<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI0P0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo0`00000901TI6@03
0000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH00000
00<0Ogmo00@0000009VIV@2IVIT000000P2c/k<01@000000c<c<0<c<c03<c<`0000000<0i^KV00<0
00000?ooo`3oool04@3oool030000000i^KV0>KViP000000c<c<0000002c/k<0000009VIV@000000
Ogmo00000080IVIV00D0000004a<C0000000<c<c0000000301TI6@h000000`0I6AT01@000000<c<c
0000001<C4`000000080IVIV00D0000007moO`000000VIVI000000030;>c/`030000003<c<`0c<c<
00P0c<c<00T000000;>c/`2c/k<0/k>c0000002IVIT0000007moO`0000000P1VIVH01@000000C4a<
0000000c<c<0000000@06ATI3@00000301TI6@050000000c<c<0000004a<C00000000P1VIVH20000
0080VIVI00H000000;>c/`2c/k<000000<c<c00000020>KViP030000003oool0oooo0100oooo00<0
00000>KViP3Vi^H00P3Vi^H010000000c<c<0<c<c00000020;>c/`040000002IVIT0VIVI000000<0
Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI
6@0I6AT01`0I6AT2000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3o
ool00P3oool2000000T06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C005
0000001VIVH0IVIV06IVIP0000000`1oOgl010000000VIVI09VIV@0000020;>c/`030000003<c<`0
c<c<0080c<c<00@000000>KViP3Vi^H00000503oool010000000i^KV0>KViP0000020<c<c00=0000
002c/k<0000009VIV@000000Ogmo0000001VIVH0000004a<C0000000<c<c0000000301TI6@h00000
0`0I6AT02`000000<c<c0000001<C4`0000006IVIP000000Ogmo0000002IVIT0000000<0/k>c00<0
00000<c<c03<c<`02P3<c<`03`000000/k>c0;>c/`2c/k<0000009VIV@000000Ogmo0000001VIVH0
000004a<C0000000<c<c0000000401TI6@d000000`0I6AT02`000000<c<c0000001<C4`0000006IV
IP000000Ogmo0000002IVIT000000080/k>c00<000000<c<c00000000`3Vi^H00`000000oooo0?oo
o`0A0?ooo`050000003Vi^H0i^KV0>KViP0000000P3<c<`01@000000/k>c0;>c/`2c/k<000000080
VIVI00D0000007moO`1oOgl0Ogmo0000000306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c
<`0c<c<00`0c<c<00`0000006ATI01TI6@0701TI6@030000003oool0oooo00<0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool2000000T06ATI00<0000003<c<`0c
<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl01000
0000VIVI09VIV@0000020;>c/`050000003<c<`0c<c<0<c<c00000000P3Vi^H00`000000oooo0?oo
o`0D0?ooo`0B0000003Vi^H0i^KV0000003<c<`000000;>c/`000000VIVI0000001oOgl0000006IV
IP000000C4a<0000000c<c<000000`0I6AT>000000<06ATI00/0000003<c<`000000C4a<0000001V
IVH0000007moO`000000VIVI000000020;>c/`030000003<c<`0c<c<00D0c<c<00<000000<c<c03<
c<`0103<c<`03P000000/k>c0;>c/`000000VIVI0000001oOgl0000006IVIP000000C4a<0000000c
<c<00000100I6AT=000000<06ATI00/0000003<c<`000000C4a<0000001VIVH0000007moO`000000
VIVI000000020;>c/`030000003<c<`000000080i^KV00<000000?ooo`3oool04`3oool01@000000
i^KV0>KViP3Vi^H000000080c<c<00@000000;>c/`2c/k<000000P2IVIT01@000000Ogmo07moO`1o
Ogl0000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I
6AT06ATI00L06ATI00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`8000002@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0
C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`040000002IVIT0VIVI00000080/k>c
00D000000<c<c03<c<`0c<c<000000020>KViP030000003oool0oooo01D0oooo00`000000>KViP3V
i^H000000<c<c0000000/k>c0000002IVIT0000007moO`00000206IVIP050000001<C4`0000003<c
<`0000000`0I6AT<000000<06ATI00D0000003<c<`000000C4a<0000000206IVIP050000001oOgl0
000009VIV@0000000P2c/k<00`000000c<c<0<c<c0030<c<c080000000<0i^KV0000003<c<`0103<
c<`020000000/k>c0;>c/`000000VIVI0000001oOgl000000P1VIVH01@000000C4a<0000000c<c<0
000000<06ATI3000000301TI6@030000000c<c<0<c<c008000000P1VIVH02@000000Ogmo0000002I
VIT000000;>c/`000000c<c<000000020>KViP030000003oool0oooo01D0oooo00@000000>KViP3V
i^H000000P3<c<`01@000000/k>c0;>c/`2c/k<000000080VIVI00@0000007moO`1oOgl000000`1V
IVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01`0I
6AT00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0
oooo0080oooo0P00000901TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`0
10000000IVIV06IVIP00000307moO`040000002IVIT0VIVI00000080/k>c00@000000<c<c03<c<`0
00000`3Vi^H00`000000oooo0?ooo`0F0?ooo`070000003Vi^H000000<c<c0000000/k>c00000002
09VIV@8000000P1VIVH01@000000C4a<0000000c<c<0000000<06ATI3000000301TI6@050000000c
<c<0000004a<C00000000P1VIVH200000080VIVI00<000000;>c/`0000001@3<c<`00`000000i^KV
0>KViP020>KViP800000103<c<`01`000000/k>c0000002IVIT0000007moO`0000000P1VIVH01@00
0000C4a<0000000c<c<0000000<06ATI3000000301TI6@030000000c<c<0<c<c008000000P1VIVH2
00000080VIVI00L000000;>c/`000000c<c<0000003Vi^H0000001P0oooo00D000000>KViP3Vi^H0
i^KV000000020<c<c0040000002c/k<0/k>c00000080VIVI00D0000007moO`1oOgl0Ogmo00000002
06IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@07
01TI6@030000003oool0oooo00<0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3oool00`0000006ATI01TI6@0701TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<
C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c
/k<01@000000c<c<0<c<c03<c<`000000080i^KV00<000000?ooo`3oool05`3oool04P000000i^KV
0>KViP000000c<c<0000002c/k<0000009VIV@000000Ogmo0000001VIVH0000004a<C0000000<c<c
000000<06ATI3000000301TI6@0;0000000c<c<0000004a<C0000000IVIV0000001oOgl0000009VI
V@0000000P2c/k<010000000c<c<0<c<c03<c<`2000000L0i^KV00D000000<c<c03<c<`0c<c<0000
00020;>c/`0;0000002IVIT0000007moO`000000IVIV0000001<C4`0000003<c<`0000000`0I6AT<
000000<06ATI00<0000003<c<`0c<c<00P0000002P1VIVH0000007moO`000000VIVI0000002c/k<0
00000<c<c00000020>KViP030000003oool0oooo01L0oooo00@000000>KViP3Vi^H000000P3<c<`0
1@000000/k>c0;>c/`2c/k<000000080VIVI00@0000007moO`1oOgl000000`1VIVH00`000000C4a<
04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01`0I6AT00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3oool00`0000006ATI01TI
6@0701TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IV
IP1VIVH000000080Ogmo00@0000009VIV@2IVIT000000P2c/k<010000000c<c<0<c<c00000020>KV
iP030000003oool0oooo01T0oooo014000000>KViP000000c<c<0000002c/k<0000009VIV@000000
Ogmo0000001VIVH0000004a<C0000000<c<c0000000301TI6@`000000`0I6AT03@000000<c<c0000
001<C4`0000006IVIP000000Ogmo0000002IVIT000000;>c/`0000000`3<c<`00`000000i^KV0>KV
iP080>KViP0A0000003<c<`0c<c<0<c<c0000000/k>c0000002IVIT0000007moO`000000IVIV0000
001<C4`0000003<c<`0000000`0I6AT<000000<06ATI00<0000003<c<`0c<c<00P000000301VIVH0
000007moO`000000VIVI0000002c/k<000000<c<c0000000i^KV000001/0oooo00@000000>KViP3V
i^H000000P3<c<`010000000/k>c0;>c/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00<0
000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI00@0
00000?ooo`3oool0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000000I
6AT06ATI00L06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001V
IVH0IVIV06IVIP0000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<0000
0080i^KV00<000000?ooo`3oool06@3oool04@000000i^KV0000003<c<`000000;>c/`000000VIVI
0000001oOgl0000006IVIP000000C4a<0000000c<c<0000000<06ATI3000000301TI6@0=0000000c
<c<0000004a<C0000000IVIV0000001oOgl0000009VIV@000000/k>c000000020<c<c0030000003V
i^H0i^KV00@0i^KV00<000000>KViP3Vi^H00`3Vi^H040000000c<c<0<c<c0000000/k>c0000002I
VIT0000007moO`000000IVIV0000001<C4`0000003<c<`00000301TI6@`000000`0I6AT00`000000
<c<c03<c<`020000000<06IVIP000000Ogmo0000002IVIT000000;>c/`000000c<c<0000003Vi^H0
00006`3oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080VIVI00@00000
07moO`1oOgl000000`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0
000001TI6@0I6AT01`0I6AT00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo00<0000001TI6@0I6AT01`0I6AT00`000000<c<c03<c<`03
03<c<`050000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`00000209VIV@040000
002c/k<0/k>c00000080c<c<00@000000>KViP3Vi^H000007@3oool01P000000i^KV0000003<c<`0
00000;>c/`80000000P0Ogmo0000001VIVH0000004a<C0000000<c<c000000<06ATI3000000301TI
6@0:0000000c<c<0000004a<C0000000IVIV0000001oOgl0000009VIV@8000000`3<c<`00`000000
i^KV0>KViP030>KViP030000003oool0000000@0i^KV00@000000<c<c03<c<`0c<c<0P0000002P2I
VIT0000007moO`000000IVIV0000001<C4`0000003<c<`00000301TI6@`000000`0I6AT00`000000
<c<c03<c<`020000000306IVIP000000Ogmo008000000P2c/k<200000080i^KV00<000000?ooo`3o
ool06P3oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080VIVI00@00000
07moO`1oOgl000000`1VIVH01@000000C4a<04a<C01<C4`0000000D0<c<c00<0000001TI6@0I6AT0
1`0I6AT00`000000oooo0?ooo`020?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo2@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D0
000006IVIP1VIVH0IVIV0000000207moO`040000002IVIT0VIVI00000080/k>c00@000000<c<c03<
c<`000000P3Vi^H00`000000oooo0?ooo`0K0?ooo`060000003Vi^H000000<c<c0000000/k>c0P00
0000201oOgl0000006IVIP000000C4a<0000000c<c<000000`0I6AT<000000<06ATI00`0000003<c
<`000000000006IVIP000000Ogmo0000002IVIT000000;>c/`0000020<c<c0030000003Vi^H0i^KV
00<0i^KV00D000000?ooo`3oool0oooo000000040>KViP050000003<c<`0c<c<0000002c/k<00P00
0000201oOgl0000006IVIP000000C4a<0000000c<c<000000`0I6AT<000000<06ATI0100000003<c
<`000000000006IVIP000000Ogmo0000002IVIT000000;>c/`000000c<c<0000003Vi^H000007@3o
ool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080VIVI00@0000007moO`1o
Ogl000000`1VIVH01@000000C4a<04a<C01<C4`0000000D0<c<c00<0000001TI6@0I6AT01`0I6AT5
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo2@0I6AT00`00
0000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV00000002
07moO`040000002IVIT0VIVI00000080/k>c00@000000<c<c03<c<`000000P3Vi^H00`000000oooo
0?ooo`0K0?ooo`0<0000003Vi^H000000<c<c0000000/k>c0000002IVIT0000007moO`000000IVIV
0P0000000`0c<c<0000001TI6@0201TI6@`000000`0I6AT030000000<c<c000000000000IVIV0000
001oOgl0000009VIV@000000/k>c00000080c<c<00<000000>KViP3Vi^H00P3Vi^H00`000000oooo
0?ooo`030?ooo`050000003Vi^H0i^KV0>KViP0000000P3<c<`020000000/k>c0000002IVIT00000
07moO`000000IVIV0P0000000`0c<c<0000001TI6@0201TI6@`000000`0I6AT040000000<c<c0000
00000000IVIV0000001oOgl0000009VIV@000000/k>c0000003<c<`000000>KViP00000M0?ooo`04
0000003Vi^H0i^KV00000080c<c<00@000000;>c/`2c/k<000000P2IVIT010000000Ogmo07moO`00
000306IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI
6@0601TI6@D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool9
01TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001o
Ogl0Ogmo00000080VIVI00@000000;>c/`2c/k<000000P3<c<`010000000i^KV0>KViP00000O0?oo
o`040000003Vi^H000000<c<c080000000D0VIVI0000001oOgl0000006IVIP020000000303<c<`00
00006ATI00806ATI3000000301TI6@090000000c<c<000000000001VIVH0000007moO`000000VIVI
008000000P3<c<`00`000000i^KV0>KViP020>KViP030000003oool0oooo00D0oooo00D000000>KV
iP3Vi^H0i^KV000000020<c<c080000000D0VIVI0000001oOgl0000006IVIP020000000303<c<`00
00006ATI00806ATI3000000301TI6@0;0000000c<c<000000000001VIVH0000007moO`000000VIVI
0000002c/k<00P0000000`3Vi^H000000?ooo`0N0?ooo`040000003Vi^H0i^KV00000080c<c<00@0
00000;>c/`2c/k<000000P2IVIT010000000Ogmo07moO`00000306IVIP050000001<C4`0C4a<04a<
C00000001@0c<c<00`0000006ATI01TI6@0601TI6@D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3oool901TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<
C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI00@000000;>c/`2c/k<000000P3<
c<`010000000i^KV00000000000O0?ooo`040000003Vi^H000000<c<c080000000D0VIVI0000001o
Ogl0000006IVIP020000000303<c<`0000006ATI00806ATI3000000301TI6@090000000c<c<00000
0000001VIVH0000007moO`000000VIVI008000000P3<c<`01@000000i^KV0>KViP3Vi^H0000000T0
oooo00@000000>KViP3Vi^H000000P3<c<`20000000509VIV@000000Ogmo0000001VIVH00P000000
0`0c<c<0000001TI6@0201TI6@`000000`0I6AT02`000000<c<c000000000000IVIV0000001oOgl0
000009VIV@000000/k>c0080000000<0i^KV0000003oool07P3oool2000000050>KViP000000c<c<
0<c<c00000000P2c/k<010000000VIVI09VIV@00000207moO`050000001VIVH0IVIV06IVIP000000
0`1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00H06ATI1@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`T06ATI00<0000003<c<`0c<c<00`0c
<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@0000007moO`1oOgl000000P2IVIT010000000
/k>c0;>c/`0000020<c<c0030000003Vi^H000000200oooo00@000000>KViP000000c<c<0P000000
1@2IVIT0000007moO`000000IVIV0080000000<0<c<c0000000I6AT00P0I6AT<000000<06ATI00T0
000003<c<`000000000006IVIP000000Ogmo0000002IVIT00P0000020<c<c0040000003Vi^H0i^KV
000000X0oooo00@000000>KViP3Vi^H000000P3<c<`20000000509VIV@000000Ogmo0000001VIVH0
0P0000000`0c<c<0000001TI6@0201TI6@`000000`0I6AT02`000000<c<c000000000000IVIV0000
001oOgl0000009VIV@000000/k>c0080000000<0i^KV0000003oool07`3oool00`000000i^KV0000
00020<c<c0040000002c/k<0/k>c00000080VIVI00@0000007moO`1oOgl000000`1VIVH01@000000
C4a<04a<C01<C4`0000000D0<c<c00<0000001TI6@0I6AT01P0I6AT50?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo2@0I6AT00`000000<c<c03<c<`0303<c<`05
0000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`00000209VIV@030000002c/k<0
000000<0c<c<00<000000>KViP000000803oool010000000i^KV0000003<c<`20000000509VIV@00
0000Ogmo0000001VIVH00P0000000`0c<c<0000001TI6@0201TI6@`000000`0I6AT02@000000<c<c
000000000000IVIV0000001oOgl0000009VIV@02000000050<c<c0000000i^KV0>KViP000000303o
ool01@000000i^KV0>KViP000000c<c<0080000000D0VIVI0000001oOgl0000006IVIP0200000003
03<c<`0000006ATI00806ATI3000000301TI6@0;0000000c<c<000000000001VIVH0000007moO`00
0000VIVI0000002c/k<00P0000000`3Vi^H000000?ooo`0O0?ooo`040000003Vi^H0i^KV00000080
c<c<00<000000;>c/`0000000P2IVIT010000000Ogmo07moO`00000306IVIP050000001<C4`0C4a<
04a<C00000001@0c<c<00`0000006ATI01TI6@0601TI6@D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3oool801TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<
C01<C4`00P1<C4`010000000IVIV06IVIP00000207moO`040000002IVIT0VIVI00000080/k>c00H0
00000<c<c03<c<`000000>KViP00000Q0?ooo`040000003Vi^H000000<c<c080000000D0VIVI0000
001oOgl0000006IVIP020000000303<c<`0000006ATI00806ATI3000000201TI6@030000000c<c<0
<c<c0080000000T0IVIV000000000000VIVI0000002c/k<000000<c<c00000000P3Vi^H00`000000
oooo0?ooo`0:0?ooo`050000003Vi^H0i^KV0000003<c<`00P0000001@2IVIT0000007moO`000000
IVIV0080000000<0<c<c0000000I6AT00P0I6AT<000000<06ATI00L0000003<c<`000000000006IV
IP000000Ogmo0080000000D0/k>c000000000000i^KV0000000Q0?ooo`040000003Vi^H0i^KV0000
0080c<c<00<000000;>c/`0000000P2IVIT010000000Ogmo07moO`00000306IVIP050000001<C4`0
C4a<04a<C00000001@0c<c<00`0000006ATI01TI6@0601TI6@D0oooo00<000000?ooo`3oool01@3o
ool000L0oooo100000030?ooo`8000001@3oool00`000000oooo0?ooo`020?ooo`P06ATI00<00000
03<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0040000001VIVH0IVIV00000080Ogmo00@0
000009VIV@2IVIT000000P2c/k<01P000000c<c<0<c<c0000000i^KV00000280oooo00L000000>KV
iP00000000000;>c/`000000VIVI0080000000<0IVIV0000000000000P0c<c<00`0000006ATI01TI
6@0<000000806ATI00<0000003<c<`0c<c<00P0000002`1VIVH000000000002IVIT000000;>c/`00
0000c<c<0000003Vi^H0000000d0oooo00T000000>KViP3Vi^H000000<c<c0000000/k>c0000002I
VIT00P0000000`1VIVH000000000000203<c<`030000000I6AT06ATI00`000000`0I6AT01`000000
<c<c000000000000IVIV0000001oOgl00P0000001@2c/k<000000000003Vi^H000000280oooo00<0
00000>KViP0000000P3<c<`010000000/k>c0;>c/`00000209VIV@040000001oOgl0Ogmo00000080
IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00D0
6ATI1@3oool00`000000oooo0?ooo`050?ooo`001`3oool00`000000oooo0?ooo`030?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool00P3oool801TI6@030000000c<c<0<c<c00<0
<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI00@00000
0;>c/`2c/k<000000P3<c<`00`000000i^KV0000000R0?ooo`070000003Vi^H000000000002c/k<0
000009VIV@020000000306IVIP00000000000080<c<c00<0000001TI6@0I6AT03000000201TI6@03
0000000c<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<200000080i^KV00<00000
0?ooo`3oool0303oool00`000000i^KV0>KViP02000000030;>c/`000000VIVI0080000000<0IVIV
0000000000000P0c<c<00`0000006ATI01TI6@0<000000<06ATI00L0000003<c<`000000000006IV
IP000000Ogmo0080000000D0/k>c000000000000i^KV0000000R0?ooo`060000003Vi^H0i^KV0000
003<c<`000000P2c/k<010000000VIVI09VIV@00000207moO`050000001VIVH0IVIV06IVIP000000
0`1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00D06ATI1@3oool00`000000oooo
0?ooo`050?ooo`00203oool00`000000oooo0?ooo`020?ooo`040000003oool0oooo000000@0oooo
0`0000020?ooo`P06ATI00<0000003<c<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0
IVIV00@0000007moO`1oOgl000000P2IVIT010000000/k>c0;>c/`0000020<c<c0030000003Vi^H0
00000280oooo00L000000>KViP00000000000;>c/`000000VIVI0080000000<0IVIV000000000000
0P0c<c<00`0000006ATI01TI6@0<000000806ATI00<0000003<c<`0c<c<00P0000001P1VIVH00000
0000002IVIT000000;>c/`8000000P3Vi^H00`000000oooo0?ooo`0<0?ooo`030000003Vi^H0i^KV
0080000000<0/k>c0000002IVIT00P0000000`1VIVH000000000000203<c<`030000000I6AT06ATI
00`000000`0I6AT01`000000<c<c000000000000IVIV0000001oOgl00P0000001@2c/k<000000000
003Vi^H000000280oooo00H000000>KViP3Vi^H000000<c<c00000020;>c/`040000002IVIT0VIVI
00000080Ogmo00D0000006IVIP1VIVH0IVIV0000000304a<C0030000000c<c<0<c<c00<0<c<c00<0
000001TI6@0I6AT01@0I6AT30?ooo`<000001`3oool000T0oooo00D000000?ooo`3oool0oooo0000
00020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3oool801TI6@030000000c
<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080
VIVI00@000000;>c/`2c/k<000000P3<c<`00`000000i^KV0000000R0?ooo`070000003Vi^H00000
0000002c/k<0000009VIV@020000000306IVIP00000000000080<c<c00<0000001TI6@0I6AT03000
000201TI6@030000000c<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<200000080
i^KV00<000000?ooo`3oool0303oool00`000000i^KV0>KViP02000000030;>c/`000000VIVI0080
000000<0IVIV0000000000000P0c<c<00`0000006ATI01TI6@0<000000<06ATI00L0000003<c<`00
0000000006IVIP000000Ogmo0080000000D0/k>c000000000000i^KV0000000R0?ooo`060000003V
i^H0i^KV0000003<c<`000000P2c/k<010000000VIVI09VIV@00000207moO`050000001VIVH0IVIV
06IVIP0000000`1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00D06ATI1@3oool0
0`000000oooo0?ooo`050?ooo`001`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00P3oool801TI6@030000000c<c<0<c<c00<0<c<c00D0
000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI00@000000;>c/`2c
/k<000000P3<c<`00`000000i^KV0000000R0?ooo`070000003Vi^H000000000002c/k<0000009VI
V@020000000306IVIP00000000000080<c<c00<0000001TI6@0I6AT03000000201TI6@030000000c
<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<200000080i^KV00<000000?ooo`3o
ool0303oool00`000000i^KV0>KViP02000000030;>c/`000000VIVI0080000000<0IVIV00000000
00000P0c<c<00`0000006ATI01TI6@0<000000<06ATI00L0000003<c<`000000000006IVIP000000
Ogmo0080000000D0/k>c000000000000i^KV0000000R0?ooo`060000003Vi^H0i^KV0000003<c<`0
00000P2c/k<010000000VIVI09VIV@00000207moO`050000001VIVH0IVIV06IVIP0000000`1<C4`0
0`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00D06ATI1@3oool00`000000oooo0?ooo`05
0?ooo`00203oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo200I6AT00`00
0000<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`00
000209VIV@030000002c/k<000000080c<c<00@000000>KViP3Vi^H000008P3oool01`000000i^KV
000000000000/k>c0000002IVIT00P0000000`1VIVH000000000000203<c<`030000000I6AT06ATI
00`000000P0I6AT00`000000<c<c03<c<`020000000606IVIP000000000009VIV@000000/k>c0P00
00020>KViP030000003oool0oooo00`0oooo00<000000>KViP3Vi^H00P0000000`2c/k<0000009VI
V@020000000306IVIP00000000000080<c<c00<0000001TI6@0I6AT03000000201TI6@030000000c
<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<2000000030>KViP000000oooo0240
oooo00H000000>KViP3Vi^H000000<c<c00000020;>c/`040000002IVIT0VIVI00000080Ogmo00D0
000006IVIP1VIVH0IVIV0000000304a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0
1@0I6AT50?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo200I
6AT00`000000<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo
07moO`00000209VIV@030000002c/k<000000080c<c<00@000000>KViP3Vi^H000008P3oool01000
0000i^KV0000003<c<`20000000409VIV@000000000006IVIP8000000P0c<c<00`0000006ATI01TI
6@0<000000806ATI00<0000003<c<`0c<c<00P0000001P1VIVH000000000002IVIT000000;>c/`80
00000P3Vi^H00`000000oooo0?ooo`0<0?ooo`050000003Vi^H0i^KV0000003<c<`00P0000000`2I
VIT0000007moO`020000000404a<C0000000<c<c000000<06ATI2`00000201TI6@030000000c<c<0
<c<c0080000000H0IVIV000000000000VIVI0000002c/k<2000000030>KViP000000oooo0280oooo
00<000000>KViP0000000P3<c<`00`000000/k>c0000000209VIV@040000001oOgl0Ogmo000000<0
IVIV00D0000004a<C01<C4`0C4a<0000000503<c<`030000000I6AT06ATI00D06ATI1@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P06ATI00<0000003<c<`0c
<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@0000007moO`1oOgl000000P2IVIT0
0`000000/k>c000000020<c<c0040000003Vi^H0i^KV00000280oooo00@000000>KViP000000c<c<
0P000000102IVIT000000000001VIVH200000080<c<c00<0000001TI6@0I6AT03000000201TI6@03
0000000c<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<200000080i^KV00<00000
0?ooo`3oool0303oool01@000000i^KV0>KViP000000c<c<0080000000<0VIVI0000001oOgl00P00
0000101<C4`0000003<c<`00000301TI6@/000000P0I6AT00`000000<c<c03<c<`020000000606IV
IP000000000009VIV@000000/k>c0P0000000`3Vi^H000000?ooo`0R0?ooo`030000003Vi^H00000
0080c<c<00<000000;>c/`0000000P2IVIT010000000Ogmo07moO`00000306IVIP050000001<C4`0
C4a<04a<C00000001@0c<c<00`0000006ATI01TI6@0501TI6@D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3oool801TI6@030000000c<c<0<c<c00<0<c<c00D00000
04a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI00<000000;>c/`000000
0P3<c<`010000000i^KV0>KViP00000R0?ooo`040000003Vi^H000000<c<c080000000@0VIVI0000
00000000IVIV0P00000203<c<`030000000I6AT06ATI00`000000P0I6AT00`000000<c<c03<c<`02
0000000606IVIP000000000009VIV@000000/k>c0P0000020>KViP030000003oool0oooo00`0oooo
00D000000>KViP3Vi^H000000<c<c0020000000309VIV@000000Ogmo0080000000@0C4a<0000000c
<c<000000`0I6AT;000000806ATI00<0000003<c<`0c<c<00P0000001P1VIVH000000000002IVIT0
00000;>c/`80000000<0i^KV0000003oool08P3oool00`000000i^KV000000020<c<c0030000002c
/k<000000080VIVI00@0000007moO`1oOgl000000`1VIVH01@000000C4a<04a<C01<C4`0000000D0
<c<c00<0000001TI6@0I6AT01@0I6AT50?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo200I6AT00`000000<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C000
00000`1VIVH010000000Ogmo07moO`00000209VIV@030000002c/k<000000080c<c<00@000000>KV
iP3Vi^H000008P3oool010000000i^KV0000003<c<`20000000409VIV@000000000006IVIP800000
0P0c<c<00`0000006ATI01TI6@0<000000806ATI00<0000003<c<`0c<c<00P0000001P1VIVH00000
0000002IVIT000000;>c/`8000000P3Vi^H00`000000oooo0?ooo`0<0?ooo`050000003Vi^H0i^KV
0000003<c<`00P0000000`2IVIT0000007moO`020000000404a<C0000000<c<c000000<06ATI2`00
000201TI6@030000000c<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<200000003
0>KViP000000oooo0280oooo00<000000>KViP0000000P3<c<`00`000000/k>c0000000209VIV@04
0000001oOgl0Ogmo000000<0IVIV00D0000004a<C01<C4`0C4a<0000000503<c<`030000000I6AT0
6ATI00D06ATI1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oo
o`P06ATI00<0000003<c<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@00000
07moO`1oOgl000000P2IVIT00`000000/k>c000000020<c<c0040000003Vi^H0i^KV00000280oooo
00@000000>KViP000000c<c<0P000000102IVIT000000000001VIVH200000080<c<c00<0000001TI
6@0I6AT03000000201TI6@030000000c<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c
/k<200000080i^KV00<000000?ooo`3oool0303oool01@000000i^KV0>KViP000000c<c<00800000
00<0VIVI0000001oOgl00P000000101<C4`0000003<c<`00000301TI6@/000000P0I6AT00`000000
<c<c03<c<`020000000606IVIP000000000009VIV@000000/k>c0P0000000`3Vi^H000000?ooo`0R
0?ooo`030000003Vi^H000000080c<c<00<000000;>c/`0000000P2IVIT010000000Ogmo07moO`00
000306IVIP050000001<C4`0C4a<04a<C00000001@0c<c<00`0000006ATI01TI6@0501TI6@D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool801TI6@030000000c
<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080
VIVI00<000000;>c/`0000000P3<c<`010000000i^KV0>KViP00000R0?ooo`070000003Vi^H00000
0000002c/k<0000009VIV@020000000306IVIP00000000000080<c<c00<0000001TI6@0I6AT03000
000201TI6@030000000c<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<200000080
i^KV00<000000?ooo`3oool0303oool00`000000i^KV0>KViP02000000030;>c/`000000VIVI0080
000000<0IVIV0000000000000P0c<c<00`0000006ATI01TI6@0<000000806ATI00<0000003<c<`0c
<c<00P0000001P1VIVH000000000002IVIT000000;>c/`80000000<0i^KV0000003oool08@3oool0
1P000000i^KV0>KViP000000c<c<00000080/k>c00@0000009VIV@2IVIT000000P1oOgl01@000000
IVIV06IVIP1VIVH0000000<0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0501TI
6@D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool801TI6@03
0000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo
00000080VIVI00@000000;>c/`2c/k<000000P3<c<`00`000000i^KV0000000R0?ooo`070000003V
i^H000000000002c/k<0000009VIV@020000000306IVIP00000000000080<c<c00<0000001TI6@0I
6AT03000000201TI6@030000000c<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<2
00000080i^KV00<000000?ooo`3oool0303oool00`000000i^KV0>KViP02000000030;>c/`000000
VIVI0080000000<0IVIV0000000000000P0c<c<00`0000006ATI01TI6@0<000000<06ATI00L00000
03<c<`000000000006IVIP000000Ogmo0080000000D0/k>c000000000000i^KV0000000R0?ooo`06
0000003Vi^H0i^KV0000003<c<`000000P2c/k<010000000VIVI09VIV@00000207moO`050000001V
IVH0IVIV06IVIP0000000`1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00D06ATI
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P06ATI00<0
000003<c<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@0000007moO`1oOgl0
00000P2IVIT010000000/k>c0;>c/`0000020<c<c0030000003Vi^H000000280oooo00L000000>KV
iP00000000000;>c/`000000VIVI0080000000<0IVIV0000000000000P0c<c<00`0000006ATI01TI
6@0<000000806ATI00<0000003<c<`0c<c<00P0000001P1VIVH000000000002IVIT000000;>c/`80
00000P3Vi^H00`000000oooo0?ooo`0<0?ooo`030000003Vi^H0i^KV0080000000<0/k>c0000002I
VIT00P0000000`1VIVH000000000000203<c<`030000000I6AT06ATI00`000000`0I6AT01`000000
<c<c000000000000IVIV0000001oOgl00P0000001@2c/k<000000000003Vi^H000000280oooo00H0
00000>KViP3Vi^H000000<c<c00000020;>c/`040000002IVIT0VIVI00000080Ogmo00D0000006IV
IP1VIVH0IVIV0000000304a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01@0I6AT5
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3oool801TI6@030000000c<c<0<c<c
00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI00@0
00000;>c/`2c/k<000000P3<c<`00`000000i^KV0000000R0?ooo`070000003Vi^H000000000002c
/k<0000009VIV@020000000306IVIP00000000000080<c<c00<0000001TI6@0I6AT03000000201TI
6@030000000c<c<0<c<c0080000000H0IVIV000000000000VIVI0000002c/k<200000080i^KV00<0
00000?ooo`3oool0303oool00`000000i^KV0>KViP02000000030;>c/`000000VIVI0080000000<0
IVIV0000000000000P0c<c<00`0000006ATI01TI6@0<000000<06ATI00L0000003<c<`0000000000
06IVIP000000Ogmo0080000000D0/k>c000000000000i^KV0000000R0?ooo`060000003Vi^H0i^KV
0000003<c<`000000P2c/k<010000000VIVI09VIV@00000207moO`050000001VIVH0IVIV06IVIP00
00000`1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00D06ATI103oool2000000L0
oooo000E0?ooo`030000003oool0oooo0080oooo200I6AT00`000000<c<c03<c<`0303<c<`050000
001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`00000209VIV@040000002c/k<0/k>c
00000080c<c<00<000000>KViP0000008P3oool01`000000i^KV000000000000/k>c0000002IVIT0
0P0000000`1VIVH000000000000203<c<`030000000I6AT06ATI00`000000P0I6AT00`000000<c<c
03<c<`020000000606IVIP000000000009VIV@000000/k>c0P0000020>KViP030000003oool0oooo
00`0oooo00<000000>KViP3Vi^H00P0000000`2c/k<0000009VIV@020000000306IVIP0000000000
0080<c<c00<0000001TI6@0I6AT03000000301TI6@070000000c<c<000000000001VIVH0000007mo
O`02000000050;>c/`00000000000>KViP0000008P3oool01P000000i^KV0>KViP000000c<c<0000
0080/k>c00@0000009VIV@2IVIT000000P1oOgl01@000000IVIV06IVIP1VIVH0000000<0C4a<00<0
000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0501TI6@D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3oool801TI6@030000000c<c<0<c<c00<0<c<c00D00000
04a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI00@000000;>c/`2c/k<0
00000P3<c<`00`000000i^KV0000000R0?ooo`070000003Vi^H000000000002c/k<0000009VIV@02
0000000306IVIP00000000000080<c<c00<0000001TI6@0I6AT03000000201TI6@030000000c<c<0
<c<c0080000000/0IVIV000000000000VIVI0000002c/k<000000<c<c0000000i^KV0000000>0?oo
o`080000003Vi^H000000<c<c0000000/k>c0000002IVIT20000000306IVIP00000000000080<c<c
00<0000001TI6@0I6AT03000000301TI6@070000000c<c<000000000001VIVH0000007moO`020000
00050;>c/`00000000000>KViP0000008P3oool00`000000i^KV000000020<c<c0040000002c/k<0
/k>c00000080VIVI00@0000007moO`1oOgl000000P1VIVH00`000000C4a<04a<C00204a<C0030000
000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01@0I6AT50?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo200I6AT00`000000<c<c03<c<`0303<c<`030000001<
C4`0C4a<0080C4a<00@0000006IVIP1VIVH000000P1oOgl010000000VIVI09VIV@0000020;>c/`06
0000003<c<`0c<c<0000003Vi^H000008P3oool01`000000i^KV000000000000/k>c0000002IVIT0
0P0000000`1VIVH000000000000203<c<`030000000I6AT06ATI00`000000P0I6AT00`000000<c<c
03<c<`020000000906IVIP000000000009VIV@000000/k>c0000003<c<`000000080i^KV00<00000
0?ooo`3oool02P3oool02@000000i^KV0>KViP000000c<c<0000002c/k<0000009VIV@0200000003
06IVIP00000000000080<c<c00<0000001TI6@0I6AT03000000301TI6@070000000c<c<000000000
001VIVH0000007moO`02000000050;>c/`00000000000>KViP0000008@3oool010000000i^KV0>KV
iP0000020<c<c0040000002c/k<0/k>c00000080VIVI00@0000007moO`1oOgl000000P1VIVH00`00
0000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01@0I6AT50?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo2@0I6AT00`000000
<c<c03<c<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`000002
09VIV@030000002c/k<0000000<0c<c<00<000000>KViP000000803oool010000000i^KV0000003<
c<`20000000509VIV@000000Ogmo0000001VIVH00P0000000`0c<c<0000001TI6@0201TI6@`00000
0`0I6AT02@000000<c<c000000000000IVIV0000001oOgl0000009VIV@02000000050<c<c0000000
i^KV0>KViP000000303oool01@000000i^KV0>KViP000000c<c<0080000000D0VIVI0000001oOgl0
000006IVIP020000000303<c<`0000006ATI00806ATI3000000301TI6@0;0000000c<c<000000000
001VIVH0000007moO`000000VIVI0000002c/k<00P0000000`3Vi^H000000?ooo`0O0?ooo`040000
003Vi^H0i^KV00000080c<c<00<000000;>c/`0000000P2IVIT010000000Ogmo07moO`00000306IV
IP050000001<C4`0C4a<04a<C00000001@0c<c<00`0000006ATI01TI6@0601TI6@D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool901TI6@030000000c<c<0<c<c
00<0<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI00<0
00000;>c/`0000000`3<c<`00`000000i^KV0000000P0?ooo`040000003Vi^H000000<c<c0800000
00D0VIVI0000001oOgl0000006IVIP020000000303<c<`0000006ATI00806ATI3000000301TI6@09
0000000c<c<000000000001VIVH0000007moO`000000VIVI0080000000D0c<c<0000003Vi^H0i^KV
0000000<0?ooo`050000003Vi^H0i^KV0000003<c<`00P0000001@2IVIT0000007moO`000000IVIV
0080000000<0<c<c0000000I6AT00P0I6AT<000000<06ATI00/0000003<c<`000000000006IVIP00
0000Ogmo0000002IVIT000000;>c/`02000000030>KViP000000oooo01l0oooo00H000000>KViP3V
i^H000000<c<c00000020;>c/`040000002IVIT0VIVI00000080Ogmo00D0000006IVIP1VIVH0IVIV
0000000304a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01P0I6AT50?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo2@0I6AT00`000000<c<c03<c
<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`00000209VIV@04
0000002c/k<0/k>c00000080c<c<00<000000>KViP000000803oool010000000i^KV0000003<c<`2
0000000509VIV@000000Ogmo0000001VIVH00P0000000`0c<c<0000001TI6@0201TI6@`000000`0I
6AT02@000000<c<c000000000000IVIV0000001oOgl0000009VIV@0200000080c<c<00@000000>KV
iP3Vi^H000002P3oool010000000i^KV0>KViP0000020<c<c080000000D0VIVI0000001oOgl00000
06IVIP020000000303<c<`0000006ATI00806ATI3000000301TI6@0;0000000c<c<000000000001V
IVH0000007moO`000000VIVI0000002c/k<00P0000000`3Vi^H000000?ooo`0O0?ooo`030000003V
i^H000000080c<c<00@000000;>c/`2c/k<000000P2IVIT010000000Ogmo07moO`00000306IVIP05
0000001<C4`0C4a<04a<C00000001@0c<c<00`0000006ATI01TI6@0601TI6@D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool901TI6@030000000c<c<0<c<c00<0
<c<c00D0000004a<C01<C4`0C4a<0000000306IVIP040000001oOgl0Ogmo00000080VIVI00@00000
0;>c/`2c/k<000000P3<c<`010000000i^KV0>KViP00000O0?ooo`040000003Vi^H000000<c<c080
000000D0VIVI0000001oOgl0000006IVIP020000000303<c<`0000006ATI00806ATI3000000301TI
6@090000000c<c<000000000001VIVH0000007moO`000000VIVI008000000P3<c<`01@000000i^KV
0>KViP3Vi^H0000000T0oooo00@000000>KViP3Vi^H000000P3<c<`20000000509VIV@000000Ogmo
0000001VIVH00P0000000`0c<c<0000001TI6@0201TI6@`000000`0I6AT02`000000<c<c00000000
0000IVIV0000001oOgl0000009VIV@000000/k>c0080000000<0i^KV0000003oool07P3oool01000
0000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080VIVI00@0000007moO`1oOgl00000
0`1VIVH01@000000C4a<04a<C01<C4`0000000D0<c<c00<0000001TI6@0I6AT01P0I6AT50?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo2@0I6AT00`000000<c<c
03<c<`0303<c<`050000001<C4`0C4a<04a<C00000000`1VIVH010000000Ogmo07moO`00000209VI
V@040000002c/k<0/k>c00000080c<c<00@000000>KViP3Vi^H000007`3oool010000000i^KV0000
003<c<`20000000509VIV@000000Ogmo0000001VIVH00P0000000`0c<c<0000001TI6@0201TI6@`0
00000`0I6AT02@000000<c<c000000000000IVIV0000001oOgl0000009VIV@0200000080c<c<00<0
00000>KViP3Vi^H00P3Vi^H00`000000oooo0?ooo`050?ooo`040000003Vi^H0i^KV000000<0c<c<
0P0000001@2IVIT0000007moO`000000IVIV0080000000<0<c<c0000000I6AT00P0I6AT<000000<0
6ATI00/0000003<c<`000000000006IVIP000000Ogmo0000002IVIT000000;>c/`02000000030>KV
iP000000oooo01h0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c/`00000209VI
V@040000001oOgl0Ogmo000000<0IVIV00D0000004a<C01<C4`0C4a<0000000503<c<`030000000I
6AT06ATI00H06ATI1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`T06ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0
IVIV06IVIP0000000P1oOgl010000000VIVI09VIV@0000020;>c/`040000003<c<`0c<c<00000080
i^KV00<000000?ooo`3oool06`3oool030000000i^KV0000003<c<`000000;>c/`000000VIVI0000
001oOgl0000006IVIP80000000<0<c<c0000000I6AT00P0I6AT<000000<06ATI00`0000003<c<`00
0000000006IVIP000000Ogmo0000002IVIT000000;>c/`0000020<c<c0030000003Vi^H0i^KV0080
i^KV0P0000030?ooo`8000000`3Vi^H02`000000c<c<0<c<c0000000/k>c0000002IVIT0000007mo
O`000000IVIV0080000000<0<c<c0000000I6AT00P0I6AT<000000<06ATI0100000003<c<`000000
000006IVIP000000Ogmo0000002IVIT000000;>c/`000000c<c<0000003Vi^H000007@3oool01000
0000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c00000080VIVI00@0000007moO`1oOgl00000
0`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT0
1P0I6AT50?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo2@0I
6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV
0000000207moO`040000002IVIT0VIVI00000080/k>c00@000000<c<c03<c<`000000P3Vi^H00`00
0000oooo0?ooo`0K0?ooo`060000003Vi^H000000<c<c0000000/k>c0P000000201oOgl0000006IV
IP000000C4a<0000000c<c<000000`0I6AT<000000<06ATI00`0000003<c<`000000000006IVIP00
0000Ogmo0000002IVIT000000;>c/`0000020<c<c0030000003Vi^H0i^KV00@0i^KV00<000000?oo
o`000000103Vi^H010000000c<c<0<c<c03<c<`20000000:09VIV@000000Ogmo0000001VIVH00000
04a<C0000000<c<c000000<06ATI3000000301TI6@0@0000000c<c<000000000001VIVH0000007mo
O`000000VIVI0000002c/k<000000<c<c0000000i^KV000001d0oooo00@000000>KViP3Vi^H00000
0P3<c<`010000000/k>c0;>c/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00D0000004a<
C01<C4`0C4a<0000000503<c<`030000000I6AT06ATI00L06ATI1@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000000I6AT06ATI00L06ATI00<0000003<c
<`0c<c<00`0c<c<01@000000C4a<04a<C01<C4`0000000<0IVIV00@0000007moO`1oOgl000000P2I
VIT010000000/k>c0;>c/`0000020<c<c0040000003Vi^H0i^KV000001d0oooo00H000000>KViP00
0000c<c<0000002c/k<20000000807moO`000000IVIV0000001<C4`0000003<c<`00000301TI6@`0
00000`0I6AT02P000000<c<c0000001<C4`0000006IVIP000000Ogmo0000002IVIT2000000<0c<c<
00<000000>KViP3Vi^H0103Vi^H00`000000i^KV0>KViP030>KViP040000003<c<`0c<c<0<c<c080
000000X0VIVI0000001oOgl0000006IVIP000000C4a<0000000c<c<000000`0I6AT<000000<06ATI
00<0000003<c<`0c<c<00P0000000`1VIVH0000007moO`0200000080/k>c0P0000020>KViP030000
003oool0oooo01X0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c0;>c/`00000209VI
V@040000001oOgl0Ogmo000000<0IVIV00D0000004a<C01<C4`0C4a<0000000503<c<`030000000I
6AT06ATI00L06ATI00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooo`030000000I6AT06ATI00L06ATI00<0000003<c<`0c<c<00`0c<c<0
0`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl010000000VIVI09VI
V@0000020;>c/`040000003<c<`0c<c<00000080i^KV00<000000?ooo`3oool06@3oool04@000000
i^KV0000003<c<`000000;>c/`000000VIVI0000001oOgl0000006IVIP000000C4a<0000000c<c<0
000000<06ATI3000000301TI6@0=0000000c<c<0000004a<C0000000IVIV0000001oOgl0000009VI
V@000000/k>c000000020<c<c0030000003Vi^H0i^KV00T0i^KV014000000<c<c03<c<`0c<c<0000
002c/k<0000009VIV@000000Ogmo0000001VIVH0000004a<C0000000<c<c0000000301TI6@`00000
0`0I6AT00`000000<c<c03<c<`020000000<06IVIP000000Ogmo0000002IVIT000000;>c/`000000
c<c<0000003Vi^H000006`3oool010000000i^KV0>KViP0000020<c<c0040000002c/k<0/k>c0000
0080VIVI00@0000007moO`1oOgl000000`1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0
<c<c00<0<c<c00<0000001TI6@0I6AT01`0I6AT00`000000oooo0?ooo`020?ooo`030000003oool0
oooo00D0oooo000E0?ooo`8000000`3oool00`0000006ATI01TI6@0701TI6@030000000c<c<0<c<c
00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@00000
09VIV@2IVIT000000P2c/k<010000000c<c<0<c<c00000020>KViP030000003oool0oooo01T0oooo
014000000>KViP000000c<c<0000002c/k<0000009VIV@000000Ogmo0000001VIVH0000004a<C000
0000<c<c0000000301TI6@`000000`0I6AT03@000000<c<c0000001<C4`0000006IVIP000000Ogmo
0000002IVIT000000;>c/`0000000`3<c<`00`000000i^KV0>KViP080>KViP0A0000003<c<`0c<c<
0<c<c0000000/k>c0000002IVIT0000007moO`000000IVIV0000001<C4`0000003<c<`0000000`0I
6AT<000000<06ATI00<0000003<c<`0c<c<00P000000301VIVH0000007moO`000000VIVI0000002c
/k<000000<c<c0000000i^KV000001/0oooo00@000000>KViP3Vi^H000000P3<c<`010000000/k>c
0;>c/`00000209VIV@040000001oOgl0Ogmo000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`00
0000<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI00@000000?ooo`3oool0oooo0P000007
0?ooo`005@3oool00`000000oooo0?ooo`020?ooo`030000000I6AT06ATI00L06ATI00<0000003<c
<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0050000001VIVH0IVIV06IVIP0000000P1oOgl0
10000000VIVI09VIV@0000030;>c/`040000003<c<`0c<c<00000080i^KV00<000000?ooo`3oool0
5`3oool04P000000i^KV0>KViP000000c<c<0000002c/k<0000009VIV@000000Ogmo0000001VIVH0
000004a<C0000000<c<c000000<06ATI3000000301TI6@0;0000000c<c<0000004a<C0000000IVIV
0000001oOgl0000009VIV@0000000P2c/k<010000000c<c<0<c<c03<c<`2000000H0i^KV0P000003
0<c<c00>0000002c/k<0/k>c0000002IVIT0000007moO`000000IVIV0000001<C4`0000003<c<`00
000301TI6@`000000`0I6AT00`000000<c<c03<c<`020000000806IVIP000000Ogmo0000002IVIT0
00000;>c/`0000020<c<c0030000003Vi^H0000001T0oooo00@000000>KViP3Vi^H000000P3<c<`0
10000000/k>c0;>c/`00000209VIV@050000001oOgl0Ogmo07moO`0000000`1VIVH00`000000C4a<
04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01`0I6AT00`000000oooo
0?ooo`020?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo0P00
000901TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`010000000IVIV06IV
IP00000307moO`040000002IVIT0VIVI00000080/k>c00D000000<c<c03<c<`0c<c<000000020>KV
iP030000003oool0oooo01H0oooo00L000000>KViP000000c<c<0000002c/k<000000080VIVI0P00
000206IVIP050000001<C4`0000003<c<`0000000`0I6AT<000000<06ATI00D0000003<c<`000000
C4a<0000000206IVIP070000001oOgl0000009VIV@000000/k>c000000050<c<c08000000P3Vi^H2
000000@0c<c<00P000000;>c/`2c/k<0000009VIV@000000Ogmo00000080IVIV00D0000004a<C000
0000<c<c0000000301TI6@`000000`0I6AT00`000000<c<c03<c<`0200000080IVIV0P00000209VI
V@050000002c/k<000000<c<c00000000P3Vi^H00`000000oooo0?ooo`0E0?ooo`050000003Vi^H0
i^KV0>KViP0000000P3<c<`010000000/k>c0;>c/`00000209VIV@050000001oOgl0Ogmo07moO`00
00000P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I
6AT01`0I6AT00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo0P00000901TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`0
0P1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo00@0000009VIV@2IVIT000000`2c/k<01000
0000c<c<0<c<c00000030>KViP030000003oool0oooo01@0oooo018000000>KViP3Vi^H000000<c<
c0000000/k>c0000002IVIT0000007moO`000000IVIV0000001<C4`0000003<c<`00000301TI6@d0
00000`0I6AT01@000000<c<c0000001<C4`000000080IVIV00D0000007moO`000000VIVI00000002
0;>c/`030000003<c<`0c<c<00@0c<c<0P0000060<c<c00>0000002c/k<0/k>c0000002IVIT00000
07moO`000000IVIV0000001<C4`0000003<c<`00000401TI6@`000000`0I6AT00`000000<c<c03<c
<`0200000080IVIV00L0000007moO`000000VIVI0000002c/k<000000080c<c<00<000000>KViP00
00005P3oool01@000000i^KV0>KViP3Vi^H000000080c<c<00@000000;>c/`2c/k<000000P2IVIT0
1@000000Ogmo07moO`1oOgl0000000<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c
<`0303<c<`030000000I6AT06ATI00L06ATI00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`8000002@0I6AT00`000000<c<c03<c<`03
03<c<`030000001<C4`0C4a<0080C4a<00D0000006IVIP1VIVH0IVIV0000000307moO`040000002I
VIT0VIVI00000080/k>c00D000000<c<c03<c<`0c<c<000000030>KViP030000003oool0oooo0180
oooo00@000000>KViP3Vi^H000000P3<c<`03@000000/k>c0000002IVIT0000007moO`000000IVIV
0000001<C4`0000003<c<`0000000`0I6AT>000000<06ATI00/0000003<c<`000000C4a<0000001V
IVH0000007moO`000000VIVI000000030;>c/`030000003<c<`0c<c<00X0c<c<00l000000;>c/`2c
/k<0/k>c0000002IVIT0000007moO`000000IVIV0000001<C4`0000003<c<`000000100I6AT=0000
00<06ATI00/0000003<c<`000000C4a<0000001VIVH0000007moO`000000VIVI000000020;>c/`03
0000003<c<`000000080i^KV00<000000?ooo`3oool04P3oool01@000000i^KV0>KViP3Vi^H00000
00<0c<c<00@000000;>c/`2c/k<000000P2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00<0
000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00L06ATI00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`02
0?ooo`<000002@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00D00000
06IVIP1VIVH0IVIV0000000207moO`040000002IVIT0VIVI000000<0/k>c00D000000<c<c03<c<`0
c<c<000000030>KViP030000003oool0oooo0140oooo00P000000>KViP3Vi^H000000<c<c0000000
/k>c00000080VIVI0P00000206IVIP050000001<C4`0000003<c<`0000000`0I6AT>000000<06ATI
00D0000003<c<`000000C4a<0000000206IVIP050000001oOgl0000009VIV@0000000`2c/k<00`00
0000c<c<0<c<c0080<c<c0090000002c/k<0/k>c0;>c/`000000VIVI0000001oOgl000000080IVIV
00D0000004a<C0000000<c<c0000000401TI6@d000000`0I6AT01@000000<c<c0000001<C4`00000
0080IVIV0P00000209VIV@030000002c/k<000000080c<c<00@000000>KViP3Vi^H000004P3oool0
0`000000i^KV0>KViP020>KViP040000003<c<`0c<c<00000080/k>c00@0000009VIV@2IVIT00000
0`1oOgl01@000000IVIV06IVIP1VIVH0000000@0C4a<00<0000003<c<`0c<c<00`0c<c<00`000000
6ATI01TI6@0701TI6@8000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooo`<000002@0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<0080C4a<
00D0000006IVIP1VIVH0IVIV0000000307moO`040000002IVIT0VIVI000000<0/k>c00D000000<c<
c03<c<`0c<c<000000030>KViP030000003oool0oooo00l0oooo00@000000>KViP3Vi^H000000P3<
c<`01`000000/k>c0000002IVIT0000007moO`0000000P1VIVH01@000000C4a<0000000c<c<00000
00<06ATI3P00000301TI6@050000000c<c<0000004a<C00000000P1VIVH01@000000Ogmo0000002I
VIT0000000@0/k>c0P0000070<c<c0030000002c/k<0/k>c0080/k>c00D0000009VIV@000000Ogmo
0000000206IVIP050000001<C4`0000003<c<`000000100I6AT=000000<06ATI00D0000003<c<`00
0000C4a<0000000206IVIP050000001oOgl0000009VIV@0000000P2c/k<00`000000c<c<00000003
0>KViP030000003oool0oooo00h0oooo00<000000>KViP3Vi^H00P3Vi^H010000000c<c<0<c<c000
00030;>c/`040000002IVIT0VIVI000000<0Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C003
0000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT01`0I6AT2000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3oool3000000X06ATI00<0000003<c<`0c<c<0
0`0c<c<01@000000C4a<04a<C01<C4`0000000@0IVIV00@0000007moO`1oOgl000000`2IVIT01@00
0000/k>c0;>c/`2c/k<0000000<0c<c<00D000000>KViP3Vi^H0i^KV0000000>0?ooo`8000000P3V
i^H01P000000c<c<0<c<c0000000/k>c00000080VIVI00<0000007moO`0000000P1VIVH01@000000
C4a<0000000c<c<0000000<06ATI3P00000301TI6@050000000c<c<0000004a<C00000000P1VIVH0
0`000000Ogmo0000000209VIV@030000002c/k<0/k>c00<0/k>c0P0000030<c<c0800000102c/k<0
0`000000VIVI0000000207moO`080000001VIVH0IVIV0000001<C4`0000003<c<`00000301TI6@h0
00000`0I6AT01@000000<c<c0000001<C4`000000080IVIV00D0000007moO`000000VIVI00000002
0;>c/`040000003<c<`0c<c<000000<0i^KV00<000000?ooo`3oool0303oool010000000i^KV0>KV
iP3Vi^H200000080c<c<00D000000;>c/`2c/k<0/k>c0000000309VIV@040000001oOgl0Ogmo0000
00<0IVIV00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00L06ATI0P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo1000000901TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`01@000000
IVIV06IVIP1VIVH0000000<0Ogmo00@0000009VIV@2IVIT00000102c/k<01@000000c<c<0<c<c03<
c<`0000000<0i^KV0P00000:0?ooo`8000000`3Vi^H02@000000c<c<0<c<c03<c<`000000;>c/`00
0000VIVI0000000207moO`030000001VIVH000000080C4a<00<0000003<c<`0000000`0I6AT>0000
00<06ATI00<0000003<c<`0000000P1<C4`00`000000IVIV0000000207moO`040000002IVIT0VIVI
000000H0/k>c0`0000050;>c/`060000002IVIT0VIVI0000001oOgl000000P1VIVH01P000000C4a<
04a<C0000000<c<c000000<06ATI3P00000301TI6@030000000c<c<000000080C4a<00<0000006IV
IP0000000P1oOgl00`000000VIVI000000020;>c/`040000003<c<`0c<c<000000<0i^KV0P00000:
0?ooo`8000000`3Vi^H01@000000c<c<0<c<c03<c<`0000000<0/k>c00D0000009VIV@2IVIT0VIVI
0000000307moO`050000001VIVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`03
0000000I6AT06ATI00H06ATI0`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000
003oool0oooo0080oooo1000000:01TI6@030000000c<c<0<c<c00<0<c<c00D0000004a<C01<C4`0
C4a<0000000406IVIP050000001oOgl0Ogmo07moO`0000000P2IVIT00`000000/k>c0;>c/`020;>c
/`040000003<c<`0c<c<0<c<c08000000`3Vi^H3000000D0oooo0P0000040>KViP070000003<c<`0
c<c<0<c<c0000000/k>c0000000209VIV@030000001oOgl000000080IVIV00<0000004a<C01<C4`0
0P00000401TI6@h000000`0I6AT00`000000<c<c0000000204a<C0060000001VIVH0IVIV0000001o
Ogl000000`2IVIT00`000000/k>c0;>c/`0:0;>c/`040000002IVIT0VIVI00000080Ogmo00@00000
06IVIP1VIVH000000P1<C4`2000000@06ATI3P00000301TI6@030000000c<c<000000080C4a<00<0
000006IVIP0000000P1oOgl00`000000VIVI000000020;>c/`050000003<c<`0c<c<0<c<c0000000
103Vi^H2000000D0oooo0`0000030>KViP8000000`3<c<`00`000000/k>c0;>c/`020;>c/`040000
002IVIT0VIVI000000<0Ogmo00D0000006IVIP1VIVH0IVIV0000000404a<C0030000000c<c<0<c<c
00@0<c<c00<0000001TI6@0I6AT01`0I6AT3000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3oool4000000X06ATI00<0000003<c<`0c<c<00`0c<c<00`000000
C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00@0000007moO`1oOgl000000`2IVIT00`00
0000/k>c0;>c/`020;>c/`030000003<c<`0c<c<0080c<c<00<000000>KViP3Vi^H00`3Vi^H50000
00D0i^KV00D000000<c<c03<c<`0c<c<000000020;>c/`060000002IVIT0VIVI0000001oOgl00000
0P1VIVH01@000000C4a<0000000c<c<0000000@06ATI3P00000401TI6@050000000c<c<0000004a<
C00000000P1VIVH010000000Ogmo07moO`00000309VIV@030000002c/k<0/k>c00P0/k>c00D00000
09VIV@2IVIT0VIVI0000000207moO`080000001VIVH0IVIV0000001<C4`0000003<c<`00000401TI
6@h00000100I6AT01@000000<c<c0000001<C4`000000080IVIV00<0000007moO`0000000P2IVIT0
10000000/k>c0;>c/`0000030<c<c0030000003Vi^H0i^KV00<0i^KV1@0000050>KViP030000003<
c<`0c<c<0080c<c<00<000000;>c/`2c/k<00P2c/k<01@000000VIVI09VIV@2IVIT000000080Ogmo
00<0000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c00@0<c<c
00<0000001TI6@0I6AT01`0I6AT3000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3oool5000000X06ATI00<0000003<c<`0c<c<00`0c<c<01@000000C4a<04a<
C01<C4`0000000@0IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@030000002c/k<0/k>c0080
/k>c00<000000<c<c03<c<`00P3<c<`2000000/0i^KV0P0000040<c<c0030000002c/k<000000080
VIVI00H0000007moO`1oOgl0000006IVIP00000204a<C0030000000c<c<0000000@06ATI3P000004
01TI6@030000000c<c<000000080C4a<00<0000006IVIP0000000P1oOgl00`000000VIVI09VIV@02
09VIV@8000001P2c/k<2000000<0VIVI00L0000007moO`1oOgl0Ogmo0000001VIVH000000080C4a<
00<0000003<c<`000000100I6AT?000000<06ATI00<0000003<c<`0000000P1<C4`00`000000IVIV
0000000207moO`030000002IVIT000000080/k>c00<000000<c<c03<c<`00P3<c<`2000000/0i^KV
0P0000040<c<c0030000002c/k<0/k>c0080/k>c00D0000009VIV@2IVIT0VIVI0000000307moO`05
0000001VIVH0IVIV06IVIP000000101<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI
00L06ATI100000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3oool5000000X0
6ATI00<0000003<c<`0c<c<00`0c<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080
IVIV00D0000007moO`1oOgl0Ogmo0000000309VIV@030000002c/k<0/k>c0080/k>c00<000000<c<
c03<c<`00`3<c<`3000000D0i^KV0`0000050<c<c0040000002c/k<0/k>c00000080VIVI00H00000
07moO`000000000006IVIP00000204a<C0030000000c<c<0000000@06ATI3P00000401TI6@030000
000c<c<000000080C4a<00@0000006IVIP1VIVH000000P1oOgl00`000000VIVI09VIV@0309VIV@80
00000`2c/k<00`000000VIVI09VIV@0309VIV@070000001oOgl0Ogmo07moO`000000IVIV00000002
04a<C0030000000c<c<0000000@06ATI3`00000301TI6@030000000c<c<000000080C4a<00H00000
06IVIP000000000007moO`00000209VIV@040000002c/k<0/k>c000000D0c<c<0`0000050>KViP<0
00001@3<c<`00`000000/k>c0;>c/`020;>c/`050000002IVIT0VIVI09VIV@0000000`1oOgl00`00
0000IVIV06IVIP0206IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0701TI6@@00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080
oooo1@00000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`01@000000
IVIV06IVIP1VIVH0000000@0Ogmo00D0000009VIV@2IVIT0VIVI000000040;>c/`8000001P3<c<`5
000000L0c<c<00L000000;>c/`2c/k<0/k>c0000002IVIT000000080Ogmo00@0000006IVIP1VIVH0
00000P1<C4`00`000000<c<c0000000401TI6@h00000100I6AT00`000000<c<c0000000204a<C005
0000001VIVH0IVIV06IVIP0000000P1oOgl00`000000VIVI09VIV@0409VIV@<000001@2IVIT01@00
0000Ogmo07moO`1oOgl000000080IVIV00H0000004a<C01<C4`0000003<c<`00000401TI6@l00000
0`0I6AT00`000000<c<c0000000204a<C0040000001VIVH0IVIV00000080Ogmo00@0000009VIV@2I
VIT000000P2c/k<00`000000c<c<0<c<c0050<c<c0D000001P3<c<`2000000@0/k>c00D0000009VI
V@2IVIT0VIVI0000000407moO`050000001VIVH0IVIV06IVIP0000001@1<C4`00`000000<c<c03<c
<`0403<c<`030000000I6AT06ATI00L06ATI100000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo1P00000:01TI6@030000000c<c<0<c<c00<0<c<c00<00000
04a<C01<C4`00P1<C4`00`000000IVIV06IVIP0206IVIP050000001oOgl0Ogmo07moO`000000102I
VIT2000000@0/k>c00<000000<c<c03<c<`03@3<c<`200000080/k>c0P00000209VIV@030000001o
Ogl000000080IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6AT?000000@0
6ATI00@0000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP00000207moO`030000002IVIT0
VIVI00`0VIVI00L0000007moO`1oOgl0Ogmo0000001VIVH000000080C4a<00@0000003<c<`0c<c<0
0000100I6AT?000000<06ATI00@0000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP000002
07moO`040000002IVIT0VIVI00000080/k>c0P00000?0<c<c0030000002c/k<0/k>c0080/k>c0P00
000409VIV@050000001oOgl0Ogmo07moO`000000101VIVH00`000000C4a<04a<C00204a<C0030000
000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT01`0I6AT5000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3oool6000000X06ATI00<0000003<c<`0c<c<0100c
<c<00`000000C4a<04a<C00204a<C0030000001VIVH0IVIV0080IVIV00D0000007moO`1oOgl0Ogmo
0000000509VIV@030000002c/k<0/k>c0080/k>c0P00000;0<c<c08000000`2c/k<01@000000VIVI
09VIV@2IVIT000000080Ogmo00@0000006IVIP1VIVH000000P1<C4`010000000<c<c03<c<`000003
01TI6@l00000100I6AT010000000<c<c03<c<`00000204a<C0050000001VIVH0IVIV06IVIP000000
0P1oOgl2000000X0VIVI0P00000307moO`040000001VIVH0IVIV00000080C4a<00@0000003<c<`0c
<c<00000100I6AT?000000<06ATI00@0000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP00
000207moO`050000002IVIT0VIVI09VIV@0000000`2c/k<2000000/0c<c<0P0000040;>c/`030000
002IVIT0VIVI00<0VIVI00<0000007moO`1oOgl00P1oOgl01@000000IVIV06IVIP1VIVH0000000D0
C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0701TI6@D000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`H000002`0I6AT00`000000<c<c
03<c<`0303<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo
07moO`0207moO`030000002IVIT0VIVI00<0VIVI00<000000;>c/`2c/k<00`2c/k<3000000D0c<c<
0`0000040;>c/`030000002IVIT0VIVI0080VIVI00<0000007moO`0000000`1VIVH01P000000C4a<
04a<C0000000<c<c000000@06ATI4000000401TI6@030000000c<c<0000000<0C4a<00@0000006IV
IP1VIVH00000101oOgl4000000<0VIVI0`00000507moO`030000001VIVH0000000<0C4a<00<00000
03<c<`000000100I6ATA000000<06ATI00<0000003<c<`0000000P1<C4`01@000000IVIV06IVIP1V
IVH000000080Ogmo00@0000009VIV@2IVIT0VIVI0P0000030;>c/`<000001@3<c<`3000000D0/k>c
00<0000009VIV@2IVIT00`2IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV
00<0000004a<C01<C4`00P1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI
1@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo1`00
000:01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IV
IP0206IVIP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00`2IVIT00`000000/k>c0;>c
/`050;>c/`D000001@2c/k<2000000@0VIVI00@0000007moO`1oOgl000000P1VIVH01`000000C4a<
04a<C01<C4`0000003<c<`000000100I6AT@000000@06ATI00<0000003<c<`0000000`1<C4`01@00
0000IVIV06IVIP1VIVH0000000L0Ogmo0`00000707moO`040000001VIVH0IVIV000000<0C4a<00<0
000003<c<`000000100I6ATA000000<06ATI00<0000003<c<`0000000`1<C4`010000000IVIV06IV
IP00000307moO`030000002IVIT0VIVI0080VIVI00<000000;>c/`2c/k<00`2c/k<5000000L0/k>c
00<0000009VIV@2IVIT00`2IVIT00`000000Ogmo07moO`0207moO`030000001VIVH0IVIV0080IVIV
00<0000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00L06ATI
1P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo1`00
000;01TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`00P1<C4`00`000000IVIV06IV
IP0306IVIP030000001oOgl0Ogmo0080Ogmo00<0000009VIV@2IVIT00`2IVIT2000000h0/k>c00<0
000009VIV@2IVIT00`2IVIT010000000Ogmo07moO`00000306IVIP040000001<C4`0C4a<00000080
<c<c00@0000001TI6@0I6AT06ATI4@00000401TI6@040000000c<c<0<c<c00000080C4a<00D00000
06IVIP1VIVH0IVIV0000000A07moO`040000001VIVH0IVIV00000080C4a<00@0000003<c<`0c<c<0
0000100I6ATA000000<06ATI00@0000003<c<`0c<c<000000P1<C4`01@000000IVIV06IVIP1VIVH0
00000080Ogmo00<0000009VIV@2IVIT00`2IVIT00`000000/k>c0;>c/`0=0;>c/`030000002IVIT0
VIVI00<0VIVI00<0000007moO`1oOgl00`1oOgl00`000000IVIV06IVIP0206IVIP030000001<C4`0
C4a<0080C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI6@0801TI6@H000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P000002P0I6AT00`00
0000<c<c03<c<`0403<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00`1VIVH00`00
0000Ogmo07moO`0207moO`8000001@2IVIT5000000L0/k>c0`00000509VIV@040000001oOgl0Ogmo
000000<0IVIV00@0000004a<C01<C4`000000P0c<c<0100000006ATI01TI6@0I6ATA000000@06ATI
00@0000003<c<`0c<c<000000P1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo00d0
Ogmo00D0000006IVIP1VIVH0IVIV0000000204a<C0040000000c<c<0<c<c000000@06ATI4@000003
01TI6@040000000c<c<0<c<c00000080C4a<00D0000006IVIP1VIVH0IVIV0000000207moO`030000
002IVIT0VIVI00<0VIVI0`0000070;>c/`H00000102IVIT2000000D0Ogmo00<0000006IVIP1VIVH0
0P1VIVH00`000000C4a<04a<C00204a<C08000001P0c<c<00`0000006ATI01TI6@0801TI6@H00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`P000002P0I
6AT00`000000<c<c03<c<`0503<c<`030000001<C4`0C4a<0080C4a<00<0000006IVIP1VIVH00`1V
IVH00`000000Ogmo07moO`0307moO`800000202IVIT7000000H0VIVI0P00000207moO`050000001V
IVH0IVIV06IVIP0000000P1<C4`01@000000<c<c03<c<`0c<c<0000000<06ATI4@00000401TI6@04
0000000c<c<0<c<c000000<0C4a<00<0000006IVIP1VIVH00P1VIVH2000000X0Ogmo0`00000306IV
IP040000001<C4`0C4a<000000<0<c<c00<0000001TI6@0I6AT00P0I6ATA000000<06ATI00@00000
03<c<`0c<c<000000`1<C4`01@000000IVIV06IVIP1VIVH000000080Ogmo0P00000609VIV@L00000
202IVIT2000000D0Ogmo0P00000406IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<0
1@0c<c<00`0000006ATI01TI6@0801TI6@L000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooo`T000002P0I6AT00`000000<c<c03<c<`0403<c<`030000001<
C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0407moO`8000004@2I
VIT2000000@0Ogmo00D0000006IVIP1VIVH0IVIV0000000204a<C0050000000c<c<0<c<c03<c<`00
00000`0I6ATB000000<06ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV
00<0IVIV1000000307moO`<000001@1VIVH01@000000C4a<04a<C01<C4`0000000<0<c<c00@00000
01TI6@0I6AT06ATI4P00000301TI6@050000000c<c<0<c<c03<c<`0000000P1<C4`00`000000IVIV
06IVIP0206IVIP040000001oOgl0Ogmo07moO`8000004@2IVIT2000000H0Ogmo00<0000006IVIP1V
IVH00`1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I
6AT02@0I6AT7000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3oool9000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000
001VIVH0IVIV00<0IVIV00<0000007moO`1oOgl01@1oOgl2000000`0VIVI0`00000507moO`050000
001VIVH0IVIV06IVIP0000000P1<C4`00`000000<c<c03<c<`0203<c<`030000000I6AT06ATI01<0
00000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00<0000006IVIP1VIVH01`1VIVH30000
00L0IVIV00D0000004a<C01<C4`0C4a<0000000403<c<`040000000I6AT06ATI01TI6A8000000`0I
6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo
07moO`0207moO`<00000302IVIT2000000L0Ogmo00<0000006IVIP1VIVH00`1VIVH00`000000C4a<
04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT8000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool:000000X06ATI00<0
000003<c<`0c<c<01@0c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV00<0IVIV0P00
000707moO`@000001@2IVIT3000000L0Ogmo00D0000006IVIP1VIVH0IVIV0000000304a<C0050000
000c<c<0<c<c03<c<`0000000`0I6ATC000000@06ATI00D0000003<c<`0c<c<0<c<c0000000304a<
C0030000001VIVH0IVIV0100IVIV00D0000004a<C01<C4`0C4a<0000000303<c<`030000000I6AT0
6ATI00806ATI4`00000201TI6@030000000c<c<0<c<c0080<c<c00D0000004a<C01<C4`0C4a<0000
000406IVIP030000001oOgl0Ogmo00@0Ogmo0`00000509VIV@@000001`1oOgl2000000D0IVIV00<0
000004a<C01<C4`00`1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI2@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo2P00000:
01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP04
06IVIP030000001oOgl0Ogmo00P0Ogmo1@00000907moO`030000001VIVH0IVIV0080IVIV00@00000
04a<C01<C4`00000100c<c<0100000006ATI01TI6@0I6ATD000000<06ATI00D0000003<c<`0c<c<0
<c<c0000000404a<C0030000001VIVH0IVIV00h0IVIV00D0000004a<C01<C4`0C4a<0000000403<c
<`040000000I6AT06ATI01TI6A@000000`0I6AT01@000000<c<c03<c<`0c<c<0000000<0C4a<00<0
000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0707moO`D000002P1oOgl00`000000IVIV06IV
IP0406IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<0100c<c<00`0000006ATI01TI
6@0901TI6@T000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooo2`00000:
01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP04
06IVIP<00000501oOgl00`000000IVIV06IVIP0206IVIP050000001<C4`0C4a<04a<C0000000100c
<c<0100000006ATI01TI6@0I6ATD000000<06ATI00<0000003<c<`0c<c<00P0c<c<00`000000C4a<
04a<C00204a<C0<000002P1VIVH3000000@0C4a<00<0000003<c<`0c<c<00P0c<c<0100000006ATI
01TI6@0I6ATD000000<06ATI00<0000003<c<`0c<c<00P0c<c<01@000000C4a<04a<C01<C4`00000
00@0IVIV00<0000007moO`1oOgl04P1oOgl3000000H0IVIV00<0000004a<C01<C4`0101<C4`00`00
0000<c<c03<c<`0503<c<`030000000I6AT06ATI00P06ATI2P0000040?ooo`8000001`3oool001D0
oooo00<000000?ooo`3oool00P3oool<000000X06ATI00<0000003<c<`0c<c<01@0c<c<00`000000
C4a<04a<C00404a<C0030000001VIVH0IVIV00H0IVIV0`00000?07moO`800000101VIVH00`000000
C4a<04a<C00204a<C0050000000c<c<0<c<c03<c<`000000100I6ATD000000<06ATI00<0000003<c
<`0c<c<00`0c<c<00`000000C4a<04a<C00404a<C0@000000`1VIVH3000000H0C4a<00<0000003<c
<`0c<c<00P0c<c<00`0000006ATI01TI6@0201TI6A@000000`0I6AT00`000000<c<c03<c<`0203<c
<`030000001<C4`0C4a<0080C4a<0P00000306IVIP8000003`1oOgl3000000P0IVIV00<0000004a<
C01<C4`0101<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI2P0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo3000000;01TI6@03
0000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`0101<C4`2000000T0IVIV1000000707moO`@0
00001@1VIVH00`000000C4a<04a<C00204a<C0030000000c<c<0<c<c0080<c<c00@0000001TI6@0I
6AT06ATI5@00000401TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`01`1<C4`30000
00P0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0201TI6AD000000`0I6AT00`00
0000<c<c03<c<`0203<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH00P1VIVH40000
00L0Ogmo1000000906IVIP8000001P1<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI
00T06ATI2`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooo3@00000;01TI6@030000000c<c<0<c<c00D0<c<c00<0000004a<C01<C4`01@1<C4`2000000/0
IVIV1`00000706IVIP800000101<C4`00`000000<c<c03<c<`0203<c<`030000000I6AT06ATI0080
6ATI5@00000401TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<C4`04@1<C4`00`000000
<c<c03<c<`0303<c<`030000000I6AT06ATI00806ATI5P00000301TI6@030000000c<c<0<c<c00<0
<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0506IVIPL000002`1VIVH2000000L0
C4a<00<0000003<c<`0c<c<01@0c<c<00`0000006ATI01TI6@0:01TI6@/000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`d00000300I6AT00`000000<c<c
03<c<`0503<c<`8000001`1<C4`2000001H0IVIV00<0000004a<C01<C4`0101<C4`00`000000<c<c
03<c<`0203<c<`030000000I6AT06ATI00806ATI5P00000401TI6@030000000c<c<0<c<c00<0<c<c
00<0000004a<C01<C4`0401<C4`00`000000<c<c03<c<`0303<c<`030000000I6AT06ATI00806ATI
5P00000401TI6@030000000c<c<0<c<c0080<c<c00<0000004a<C01<C4`0101<C4`2000001D0IVIV
0P00000704a<C08000001`0c<c<00`0000006ATI01TI6@0:01TI6@`000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooo`h000002`0I6AT00`000000<c<c03<c
<`0703<c<`030000001<C4`0C4a<00H0C4a<00<0000006IVIP1VIVH04@1VIVH2000000H0C4a<00<0
000003<c<`0c<c<00P0c<c<00`0000006ATI01TI6@0201TI6AL00000100I6AT00`000000<c<c03<c
<`0403<c<`030000001<C4`0C4a<00h0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI
6@0301TI6AL000000`0I6AT00`000000<c<c03<c<`0303<c<`030000001<C4`0C4a<00D0C4a<00<0
000006IVIP1VIVH04@1VIVH00`000000C4a<04a<C00604a<C0030000000c<c<0<c<c00H0<c<c00<0
000001TI6@0I6AT02`0I6AT<000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3oool>000000`06ATI00<0000003<c<`0c<c<01`0c<c<00`000000C4a<04a<C006
04a<C0<000003@1VIVH3000000L0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@02
01TI6AL000001@0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00`0C4a<00<00000
03<c<`0c<c<0100c<c<00`0000006ATI01TI6@0301TI6AL00000100I6AT00`000000<c<c03<c<`03
03<c<`030000001<C4`0C4a<00D0C4a<0`00000=06IVIP<00000201<C4`00`000000<c<c03<c<`07
03<c<`030000000I6AT06ATI00X06ATI3@0000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo3`00000<01TI6@030000000c<c<0<c<c00L0<c<c00<0000004a<
C01<C4`0201<C4`5000000D0IVIV0`00000904a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI
6@0I6AT00`0I6ATG000000H06ATI00<0000003<c<`0c<c<0100c<c<2000000X0C4a<0P00000603<c
<`030000000I6AT06ATI00@06ATI5`00000401TI6@030000000c<c<0<c<c00@0<c<c0P00000804a<
C0<000001@1VIVH5000000X0C4a<00<0000003<c<`0c<c<01`0c<c<00`0000006ATI01TI6@0:01TI
6@h000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooa00
0000300I6AT00`000000<c<c03<c<`0703<c<`8000003@1<C4`5000000/0C4a<00<0000003<c<`0c
<c<0100c<c<00`0000006ATI01TI6@0301TI6AP000001@0I6AT00`000000<c<c03<c<`0603<c<`@0
00000`1<C4`3000000P0<c<c00<0000001TI6@0I6AT00`0I6ATH000000D06ATI00<0000003<c<`0c
<c<01@0c<c<00`000000C4a<04a<C00804a<C0D000003@1<C4`2000000T0<c<c00<0000001TI6@0I
6AT02P0I6AT?000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3oool@000000d06ATI00<0000003<c<`0c<c<0200c<c<2000001T0C4a<0P00000603<c<`030000
000I6AT06ATI00<06ATI6@00000601TI6@030000000c<c<0<c<c00T0<c<c0`00000:03<c<`030000
000I6AT06ATI00@06ATI6000000501TI6@030000000c<c<0<c<c00H0<c<c0P00000H04a<C0800000
2P0c<c<00`0000006ATI01TI6@0:01TI6A0000001@3oool00`000000oooo0?ooo`050?ooo`00203o
ool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo4@00000=01TI6@030000000c
<c<0<c<c00T0<c<c0P00000E04a<C0800000200c<c<00`0000006ATI01TI6@0301TI6AT000001`0I
6AT00`000000<c<c03<c<`0D03<c<`030000000I6AT06ATI00D06ATI6@00000501TI6@030000000c
<c<0<c<c00L0<c<c00<0000004a<C01<C4`04`1<C4`2000000/0<c<c00<0000001TI6@0I6AT02`0I
6AT@000000D0oooo00<000000?ooo`3oool01@3oool000L0oooo00@000000?ooo`3oool000000P3o
ool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo0080oooo4P00000=01TI6@030000
000c<c<0<c<c00X0<c<c0P00000A04a<C08000002@0c<c<00`0000006ATI01TI6@0401TI6AX00000
1P0I6AT00`000000<c<c03<c<`0D03<c<`030000000I6AT06ATI00@06ATI6P00000601TI6@030000
000c<c<0<c<c00L0<c<c0P00000A04a<C0800000300c<c<00`0000006ATI01TI6@0;01TI6A400000
1@3oool00`000000oooo0?ooo`050?ooo`002@3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool00P3oool300000080oooo4`00000=01TI6@800000300c<c<3000000/0C4a<
0`00000:03<c<`030000000I6AT06ATI00D06ATI6P00000701TI6@030000000c<c<0<c<c0180<c<c
00<0000001TI6@0I6AT01@0I6ATJ000000L06ATI00<0000003<c<`0c<c<0200c<c<3000000/0C4a<
0`00000<03<c<`8000003@0I6ATB000000<0oooo0`0000070?ooo`002P3oool010000000oooo0?oo
o`0000020?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool00P3ooolD000000h06ATI
00<0000003<c<`0c<c<0300c<c<;000000`0<c<c00<0000001TI6@0I6AT01P0I6ATJ000000P06ATI
00<0000003<c<`0c<c<0400c<c<00`0000006ATI01TI6@0601TI6AX00000200I6AT00`000000<c<c
03<c<`0:03<c<`/000003P0c<c<00`0000006ATI01TI6@0<01TI6A<000001@3oool00`000000oooo
0?ooo`050?ooo`001`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0oooo000000@0
oooo00<000000?ooo`3oool00P3ooolE000000h06ATI0P00000R03<c<`030000000I6AT06ATI00H0
6ATI7000000801TI6@8000003P0c<c<2000000P06ATI7000000801TI6@8000008@0c<c<2000000h0
6ATI500000050?ooo`030000003oool0oooo00D0oooo00080?ooo`800000103oool2000000D0oooo
00<000000?ooo`3oool00P3ooolF000000l06ATI0P00000O03<c<`030000000I6AT06ATI00L06ATI
7000000:01TI6@@000001`0c<c<3000000X06ATI7000000:01TI6@030000000c<c<0<c<c01`0<c<c
0P00000?01TI6AD000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooaL00000400I6AT2000001`0<c<c00<0000001TI6@0I6AT01`0I6ATN000000d06ATI1`00
000<01TI6Ah000002P0I6AT00`000000<c<c03<c<`0I03<c<`800000400I6ATF000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolH000001406ATI0P00000H
03<c<`8000002P0I6ATN000002006ATI7P00000;01TI6@8000005`0c<c<2000001406ATI5`000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo6@00000B01TI
6@<000004`0c<c<2000000/06ATI8000000N01TI6B000000300I6AT200000180<c<c0`00000B01TI
6AP000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooaX0
0000500I6AT3000000`0<c<c1000000<01TI6B800000700I6ATR000000d06ATI0`00000<03<c<`<0
0000500I6ATI000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3ooolK000001H06ATI1000000503<c<`<00000400I6ATR000001`06ATI8P00000@01TI6@<00000
1@0c<c<4000001H06ATI6P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo7000000I01TI6@D000004P0I6ATT000001X06ATI9000000B01TI6@D000006@0I
6ATK000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolN
000002h06ATI9000000J01TI6B@00000;P0I6ATM000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooolO000002`06ATI9P00000H01TI6BH00000;00I6ATN0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooolP000002X0
6ATI9`00000G01TI6BL00000:`0I6ATO000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
0P0000030?ooob400000:@0I6ATY000001@06ATI:@00000Y01TI6B000000103oool2000000L0oooo
000E0?ooo`030000003oool0oooo0080oooo8`00000V01TI6B`00000400I6AT]000002D06ATI8P00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo9@00000R
01TI6C4000002P0I6ATa000002806ATI900000050?ooo`030000003oool0oooo00D0oooo000E0?oo
o`030000003oool0oooo0080oooo9`00000O01TI6CH000000`0I6ATf000001h06ATI9P0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo:`00000J01TI6G40
00006@0I6ATZ000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3oool]000001H06ATIM@00000E01TI6B`000001@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?oooc000000300I6AV2000000`06ATI;`0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`8000000`3ooooi000000@0oooo0P0000070?ooo`005@3oool00`000000oooo0?ooo`020?oo
ooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT0
00001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT00000
1@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3o
ool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`00
0000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000
oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo
0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?oo
o`050?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?oo
o`005@3oool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool2000000<0oooon@0000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3o
oooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi
000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi0000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo
00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<0
00000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo0P0000030?ooooT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo
0080oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080
oooon@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
n@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@00
00050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?oo
o`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo00090?ooo`<000000P3oool2000000D0oooo00<000000?ooo`3oool00P3ooooi
000000D0oooo00<000000?ooo`3oool01@3oool000X0oooo00@000000?ooo`3oool000000P3oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo00070?ooo`D0000000D0oooo0000003oool0oooo000000040?ooo`<000000P3ooooi
000000<0oooo0`0000070?ooo`001`3oool010000000oooo0?ooo`0000020?ooo`040000003oool0
oooo000000@0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool000P0oooo00<000000?ooo`0000000P3oool010000000oooo0?ooo`0000040?ooo`030000003o
ool0oooo0080oooon@0000050?ooo`030000003oool0oooo00D0oooo00090?ooo`8000000`3oool2
000000D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo
0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`0j0?ooo`03
0000003oool0oooo03/0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0k0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
2P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
1@3oool001D0ooooo`000005000000L0oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40
oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo003o0?ooob40oooo002>0?ooo`80
000000@0oooo00000000000000000P3oool2000000<0oooo100000210?ooo`00SP3oool01@000000
oooo0?ooo`3oool000000080oooo00@000000?ooo`3oool000000P3oool00`000000oooo0?ooo`22
0?ooo`00SP3oool01@000000oooo0000003oool000000080oooo00@000000?ooo`3oool000000`3o
ool00`000000oooo0?ooo`210?ooo`00SP3oool2000000030?ooo`00000000000080oooo00@00000
0?ooo`3oool00000103oool00`000000oooo0?ooo`200?ooo`00SP3oool2000000030?ooo`000000
00000080oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`0000210?ooo`00SP3o
ool2000000040?ooo`000000000000000080oooo0P0000040?ooo`800000PP3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {287, 0}} -> {-3.26594, -1.76599, 0.160642, \
0.160642}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.00480769 0.0240385 -0.00480769 0.0240385 [
[.23558 -0.0125 -6 -9 ]
[.23558 -0.0125 6 0 ]
[.47596 -0.0125 -6 -9 ]
[.47596 -0.0125 6 0 ]
[.71635 -0.0125 -6 -9 ]
[.71635 -0.0125 6 0 ]
[.95673 -0.0125 -6 -9 ]
[.95673 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[-0.0125 .23558 -12 -4.5 ]
[-0.0125 .23558 0 4.5 ]
[-0.0125 .47596 -12 -4.5 ]
[-0.0125 .47596 0 4.5 ]
[-0.0125 .71635 -12 -4.5 ]
[-0.0125 .71635 0 4.5 ]
[-0.0125 .95673 -12 -4.5 ]
[-0.0125 .95673 0 4.5 ]
[ 0 0 -0.125 0 ]
[ 0 1 .125 0 ]
[ 1 0 .125 0 ]
[.5 1.0125 -11 0 ]
[.5 1.0125 11 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.23558 0 m
.23558 .00625 L
s
[(10)] .23558 -0.0125 0 1 Mshowa
.47596 0 m
.47596 .00625 L
s
[(20)] .47596 -0.0125 0 1 Mshowa
.71635 0 m
.71635 .00625 L
s
[(30)] .71635 -0.0125 0 1 Mshowa
.95673 0 m
.95673 .00625 L
s
[(40)] .95673 -0.0125 0 1 Mshowa
.125 Mabswid
.04327 0 m
.04327 .00375 L
s
.09135 0 m
.09135 .00375 L
s
.13942 0 m
.13942 .00375 L
s
.1875 0 m
.1875 .00375 L
s
.28365 0 m
.28365 .00375 L
s
.33173 0 m
.33173 .00375 L
s
.37981 0 m
.37981 .00375 L
s
.42788 0 m
.42788 .00375 L
s
.52404 0 m
.52404 .00375 L
s
.57212 0 m
.57212 .00375 L
s
.62019 0 m
.62019 .00375 L
s
.66827 0 m
.66827 .00375 L
s
.76442 0 m
.76442 .00375 L
s
.8125 0 m
.8125 .00375 L
s
.86058 0 m
.86058 .00375 L
s
.90865 0 m
.90865 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .23558 m
.00625 .23558 L
s
[(10)] -0.0125 .23558 1 0 Mshowa
0 .47596 m
.00625 .47596 L
s
[(20)] -0.0125 .47596 1 0 Mshowa
0 .71635 m
.00625 .71635 L
s
[(30)] -0.0125 .71635 1 0 Mshowa
0 .95673 m
.00625 .95673 L
s
[(40)] -0.0125 .95673 1 0 Mshowa
.125 Mabswid
0 .04327 m
.00375 .04327 L
s
0 .09135 m
.00375 .09135 L
s
0 .13942 m
.00375 .13942 L
s
0 .1875 m
.00375 .1875 L
s
0 .28365 m
.00375 .28365 L
s
0 .33173 m
.00375 .33173 L
s
0 .37981 m
.00375 .37981 L
s
0 .42788 m
.00375 .42788 L
s
0 .52404 m
.00375 .52404 L
s
0 .57212 m
.00375 .57212 L
s
0 .62019 m
.00375 .62019 L
s
0 .66827 m
.00375 .66827 L
s
0 .76442 m
.00375 .76442 L
s
0 .8125 m
.00375 .8125 L
s
0 .86058 m
.00375 .86058 L
s
0 .90865 m
.00375 .90865 L
s
.25 Mabswid
0 0 m
0 1 L
s
.23558 .99375 m
.23558 1 L
s
.47596 .99375 m
.47596 1 L
s
.71635 .99375 m
.71635 1 L
s
.95673 .99375 m
.95673 1 L
s
.125 Mabswid
.04327 .99625 m
.04327 1 L
s
.09135 .99625 m
.09135 1 L
s
.13942 .99625 m
.13942 1 L
s
.1875 .99625 m
.1875 1 L
s
.28365 .99625 m
.28365 1 L
s
.33173 .99625 m
.33173 1 L
s
.37981 .99625 m
.37981 1 L
s
.42788 .99625 m
.42788 1 L
s
.52404 .99625 m
.52404 1 L
s
.57212 .99625 m
.57212 1 L
s
.62019 .99625 m
.62019 1 L
s
.66827 .99625 m
.66827 1 L
s
.76442 .99625 m
.76442 1 L
s
.8125 .99625 m
.8125 1 L
s
.86058 .99625 m
.86058 1 L
s
.90865 .99625 m
.90865 1 L
s
.25 Mabswid
0 1 m
1 1 L
s
.99375 .23558 m
1 .23558 L
s
.99375 .47596 m
1 .47596 L
s
.99375 .71635 m
1 .71635 L
s
.99375 .95673 m
1 .95673 L
s
.125 Mabswid
.99625 .04327 m
1 .04327 L
s
.99625 .09135 m
1 .09135 L
s
.99625 .13942 m
1 .13942 L
s
.99625 .1875 m
1 .1875 L
s
.99625 .28365 m
1 .28365 L
s
.99625 .33173 m
1 .33173 L
s
.99625 .37981 m
1 .37981 L
s
.99625 .42788 m
1 .42788 L
s
.99625 .52404 m
1 .52404 L
s
.99625 .57212 m
1 .57212 L
s
.99625 .62019 m
1 .62019 L
s
.99625 .66827 m
1 .66827 L
s
.99625 .76442 m
1 .76442 L
s
.99625 .8125 m
1 .8125 L
s
.99625 .86058 m
1 .86058 L
s
.99625 .90865 m
1 .90865 L
s
.25 Mabswid
1 0 m
1 1 L
s
gsave
.5 1.0125 -72 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(M12) show
81.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.01923 .98077 m
.98077 .98077 L
.98077 .01923 L
.01923 .01923 L
F
.5 Mabswid
.1 g
.1875 .11465 m
.21154 .10947 L
.23558 .10812 L
.25962 .11137 L
.27543 .11538 L
.28365 .12083 L
.30748 .13942 L
.30769 .13966 L
.32463 .16346 L
.33173 .17754 L
.33375 .1875 L
.3395 .21154 L
.34535 .23558 L
.35014 .25962 L
.35353 .28365 L
.35553 .30769 L
.35577 .31279 L
.35602 .33173 L
.35577 .3466 L
.35524 .35577 L
.35244 .37981 L
.34696 .40385 L
.33812 .42788 L
.33173 .44341 L
.32291 .45192 L
.30769 .45705 L
.28365 .46461 L
.25962 .46893 L
.23558 .47046 L
.21154 .46983 L
.1875 .46734 L
.16346 .4632 L
.13942 .45793 L
.11538 .45298 L
.10879 .45192 L
.09135 .44327 L
.06884 .42788 L
.06731 .42657 L
.04802 .40385 L
.04327 .39652 L
.03567 .37981 L
.02933 .35577 L
.02729 .33173 L
.02868 .30769 L
.0332 .28365 L
.04087 .25962 L
.04327 .25359 L
.05168 .23558 L
.06528 .21154 L
.06731 .20831 L
.08299 .1875 L
.09135 .1778 L
.10557 .16346 L
.11538 .1549 L
.1359 .13942 L
.13942 .13723 L
.16346 .12414 L
.18484 .11538 L
F
0 g
.1875 .11465 m
.21154 .10947 L
.23558 .10812 L
.25962 .11137 L
.27543 .11538 L
.28365 .12083 L
.30748 .13942 L
.30769 .13966 L
.32463 .16346 L
.33173 .17754 L
.33375 .1875 L
.3395 .21154 L
.34535 .23558 L
.35014 .25962 L
.35353 .28365 L
.35553 .30769 L
.35577 .31279 L
.35602 .33173 L
.35577 .3466 L
.35524 .35577 L
.35244 .37981 L
.34696 .40385 L
.33812 .42788 L
.33173 .44341 L
.32291 .45192 L
.30769 .45705 L
.28365 .46461 L
.25962 .46893 L
.23558 .47046 L
.21154 .46983 L
.1875 .46734 L
.16346 .4632 L
.13942 .45793 L
.11538 .45298 L
.10879 .45192 L
.09135 .44327 L
.06884 .42788 L
.06731 .42657 L
.04802 .40385 L
.04327 .39652 L
.03567 .37981 L
.02933 .35577 L
.02729 .33173 L
.02868 .30769 L
.0332 .28365 L
.04087 .25962 L
.04327 .25359 L
.05168 .23558 L
.06528 .21154 L
.06731 .20831 L
Mistroke
.08299 .1875 L
.09135 .1778 L
.10557 .16346 L
.11538 .1549 L
.1359 .13942 L
.13942 .13723 L
.16346 .12414 L
.18484 .11538 L
.1875 .11465 L
Mfstroke
.1 g
.11538 .54702 m
.13942 .54207 L
.16346 .5368 L
.1875 .53266 L
.21154 .53017 L
.23558 .52954 L
.25962 .53107 L
.28365 .53539 L
.30769 .54295 L
.32291 .54808 L
.33173 .55659 L
.33812 .57212 L
.34696 .59615 L
.35244 .62019 L
.35524 .64423 L
.35577 .6534 L
.35602 .66827 L
.35577 .68721 L
.35553 .69231 L
.35353 .71635 L
.35014 .74038 L
.34535 .76442 L
.3395 .78846 L
.33375 .8125 L
.33173 .82246 L
.32463 .83654 L
.30769 .86034 L
.30748 .86058 L
.28365 .87917 L
.27543 .88462 L
.25962 .88863 L
.23558 .89188 L
.21154 .89053 L
.1875 .88535 L
.18484 .88462 L
.16346 .87586 L
.13942 .86277 L
.1359 .86058 L
.11538 .8451 L
.10557 .83654 L
.09135 .8222 L
.08299 .8125 L
.06731 .79169 L
.06528 .78846 L
.05168 .76442 L
.04327 .74641 L
.04087 .74038 L
.0332 .71635 L
.02868 .69231 L
.02729 .66827 L
.02933 .64423 L
.03567 .62019 L
.04327 .60348 L
.04802 .59615 L
.06731 .57343 L
.06884 .57212 L
.09135 .55673 L
.10879 .54808 L
F
0 g
.11538 .54702 m
.13942 .54207 L
.16346 .5368 L
.1875 .53266 L
.21154 .53017 L
.23558 .52954 L
.25962 .53107 L
.28365 .53539 L
.30769 .54295 L
.32291 .54808 L
.33173 .55659 L
.33812 .57212 L
.34696 .59615 L
.35244 .62019 L
.35524 .64423 L
.35577 .6534 L
.35602 .66827 L
.35577 .68721 L
.35553 .69231 L
.35353 .71635 L
.35014 .74038 L
.34535 .76442 L
.3395 .78846 L
.33375 .8125 L
.33173 .82246 L
.32463 .83654 L
.30769 .86034 L
.30748 .86058 L
.28365 .87917 L
.27543 .88462 L
.25962 .88863 L
.23558 .89188 L
.21154 .89053 L
.1875 .88535 L
.18484 .88462 L
.16346 .87586 L
.13942 .86277 L
.1359 .86058 L
.11538 .8451 L
.10557 .83654 L
.09135 .8222 L
.08299 .8125 L
.06731 .79169 L
.06528 .78846 L
.05168 .76442 L
.04327 .74641 L
.04087 .74038 L
.0332 .71635 L
.02868 .69231 L
.02729 .66827 L
Mistroke
.02933 .64423 L
.03567 .62019 L
.04327 .60348 L
.04802 .59615 L
.06731 .57343 L
.06884 .57212 L
.09135 .55673 L
.10879 .54808 L
.11538 .54702 L
Mfstroke
.2 g
.1875 .15829 m
.21154 .15179 L
.23558 .15013 L
.25962 .15415 L
.28179 .16346 L
.28365 .16555 L
.30642 .1875 L
.30769 .18931 L
.32037 .21154 L
.32964 .23558 L
.33173 .24249 L
.33373 .25962 L
.33636 .28365 L
.33822 .30769 L
.33884 .33173 L
.33794 .35577 L
.33544 .37981 L
.33178 .40385 L
.33173 .40417 L
.31772 .42788 L
.30769 .43713 L
.28365 .44946 L
.27795 .45192 L
.25962 .45313 L
.23558 .45405 L
.21154 .45365 L
.1875 .45232 L
.18125 .45192 L
.16346 .44747 L
.13942 .43887 L
.11823 .42788 L
.11538 .426 L
.09135 .40387 L
.09133 .40385 L
.07697 .37981 L
.06937 .35577 L
.06731 .34087 L
.06691 .33173 L
.06731 .31886 L
.06857 .30769 L
.07403 .28365 L
.08305 .25962 L
.09135 .24291 L
.09582 .23558 L
.11342 .21154 L
.11538 .20925 L
.13766 .1875 L
.13942 .18607 L
.16346 .16956 L
.17454 .16346 L
F
0 g
.1875 .15829 m
.21154 .15179 L
.23558 .15013 L
.25962 .15415 L
.28179 .16346 L
.28365 .16555 L
.30642 .1875 L
.30769 .18931 L
.32037 .21154 L
.32964 .23558 L
.33173 .24249 L
.33373 .25962 L
.33636 .28365 L
.33822 .30769 L
.33884 .33173 L
.33794 .35577 L
.33544 .37981 L
.33178 .40385 L
.33173 .40417 L
.31772 .42788 L
.30769 .43713 L
.28365 .44946 L
.27795 .45192 L
.25962 .45313 L
.23558 .45405 L
.21154 .45365 L
.1875 .45232 L
.18125 .45192 L
.16346 .44747 L
.13942 .43887 L
.11823 .42788 L
.11538 .426 L
.09135 .40387 L
.09133 .40385 L
.07697 .37981 L
.06937 .35577 L
.06731 .34087 L
.06691 .33173 L
.06731 .31886 L
.06857 .30769 L
.07403 .28365 L
.08305 .25962 L
.09135 .24291 L
.09582 .23558 L
.11342 .21154 L
.11538 .20925 L
.13766 .1875 L
.13942 .18607 L
.16346 .16956 L
.17454 .16346 L
Mistroke
.1875 .15829 L
Mfstroke
.2 g
.1875 .54768 m
.21154 .54635 L
.23558 .54595 L
.25962 .54687 L
.27795 .54808 L
.28365 .55054 L
.30769 .56287 L
.31772 .57212 L
.33173 .59583 L
.33178 .59615 L
.33544 .62019 L
.33794 .64423 L
.33884 .66827 L
.33822 .69231 L
.33636 .71635 L
.33373 .74038 L
.33173 .75751 L
.32964 .76442 L
.32037 .78846 L
.30769 .81069 L
.30642 .8125 L
.28365 .83445 L
.28179 .83654 L
.25962 .84585 L
.23558 .84987 L
.21154 .84821 L
.1875 .84171 L
.17454 .83654 L
.16346 .83044 L
.13942 .81393 L
.13766 .8125 L
.11538 .79075 L
.11342 .78846 L
.09582 .76442 L
.09135 .75709 L
.08305 .74038 L
.07403 .71635 L
.06857 .69231 L
.06731 .68114 L
.06691 .66827 L
.06731 .65913 L
.06937 .64423 L
.07697 .62019 L
.09133 .59615 L
.09135 .59613 L
.11538 .574 L
.11823 .57212 L
.13942 .56113 L
.16346 .55253 L
.18125 .54808 L
F
0 g
.1875 .54768 m
.21154 .54635 L
.23558 .54595 L
.25962 .54687 L
.27795 .54808 L
.28365 .55054 L
.30769 .56287 L
.31772 .57212 L
.33173 .59583 L
.33178 .59615 L
.33544 .62019 L
.33794 .64423 L
.33884 .66827 L
.33822 .69231 L
.33636 .71635 L
.33373 .74038 L
.33173 .75751 L
.32964 .76442 L
.32037 .78846 L
.30769 .81069 L
.30642 .8125 L
.28365 .83445 L
.28179 .83654 L
.25962 .84585 L
.23558 .84987 L
.21154 .84821 L
.1875 .84171 L
.17454 .83654 L
.16346 .83044 L
.13942 .81393 L
.13766 .8125 L
.11538 .79075 L
.11342 .78846 L
.09582 .76442 L
.09135 .75709 L
.08305 .74038 L
.07403 .71635 L
.06857 .69231 L
.06731 .68114 L
.06691 .66827 L
.06731 .65913 L
.06937 .64423 L
.07697 .62019 L
.09133 .59615 L
.09135 .59613 L
.11538 .574 L
.11823 .57212 L
.13942 .56113 L
.16346 .55253 L
.18125 .54808 L
Mistroke
.1875 .54768 L
Mfstroke
.3 g
.1875 .18553 m
.21154 .17808 L
.23558 .1762 L
.25962 .18077 L
.2769 .1875 L
.28365 .19412 L
.30054 .21154 L
.30769 .2229 L
.31397 .23558 L
.3225 .25962 L
.32797 .28365 L
.33106 .30769 L
.33173 .31837 L
.33184 .33173 L
.33173 .34134 L
.33062 .35577 L
.32624 .37981 L
.31699 .40385 L
.30769 .41748 L
.29626 .42788 L
.28365 .43455 L
.25962 .44171 L
.23558 .4441 L
.21154 .44312 L
.1875 .43916 L
.16346 .43199 L
.15351 .42788 L
.13942 .42008 L
.11953 .40385 L
.11538 .39957 L
.10251 .37981 L
.09387 .35577 L
.09135 .33839 L
.09107 .33173 L
.09135 .32147 L
.09297 .30769 L
.09915 .28365 L
.10955 .25962 L
.11538 .24924 L
.1249 .23558 L
.13942 .21883 L
.14705 .21154 L
.16346 .19881 L
.1828 .1875 L
F
0 g
.1875 .18553 m
.21154 .17808 L
.23558 .1762 L
.25962 .18077 L
.2769 .1875 L
.28365 .19412 L
.30054 .21154 L
.30769 .2229 L
.31397 .23558 L
.3225 .25962 L
.32797 .28365 L
.33106 .30769 L
.33173 .31837 L
.33184 .33173 L
.33173 .34134 L
.33062 .35577 L
.32624 .37981 L
.31699 .40385 L
.30769 .41748 L
.29626 .42788 L
.28365 .43455 L
.25962 .44171 L
.23558 .4441 L
.21154 .44312 L
.1875 .43916 L
.16346 .43199 L
.15351 .42788 L
.13942 .42008 L
.11953 .40385 L
.11538 .39957 L
.10251 .37981 L
.09387 .35577 L
.09135 .33839 L
.09107 .33173 L
.09135 .32147 L
.09297 .30769 L
.09915 .28365 L
.10955 .25962 L
.11538 .24924 L
.1249 .23558 L
.13942 .21883 L
.14705 .21154 L
.16346 .19881 L
.1828 .1875 L
.1875 .18553 L
s
.3 g
.16346 .56801 m
.1875 .56084 L
.21154 .55688 L
.23558 .5559 L
.25962 .55829 L
.28365 .56545 L
.29626 .57212 L
.30769 .58252 L
.31699 .59615 L
.32624 .62019 L
.33062 .64423 L
.33173 .65866 L
.33184 .66827 L
.33173 .68163 L
.33106 .69231 L
.32797 .71635 L
.3225 .74038 L
.31397 .76442 L
.30769 .7771 L
.30054 .78846 L
.28365 .80588 L
.2769 .8125 L
.25962 .81923 L
.23558 .8238 L
.21154 .82192 L
.1875 .81447 L
.1828 .8125 L
.16346 .80119 L
.14705 .78846 L
.13942 .78117 L
.1249 .76442 L
.11538 .75076 L
.10955 .74038 L
.09915 .71635 L
.09297 .69231 L
.09135 .67853 L
.09107 .66827 L
.09135 .66161 L
.09387 .64423 L
.10251 .62019 L
.11538 .60043 L
.11953 .59615 L
.13942 .57992 L
.15351 .57212 L
F
0 g
.16346 .56801 m
.1875 .56084 L
.21154 .55688 L
.23558 .5559 L
.25962 .55829 L
.28365 .56545 L
.29626 .57212 L
.30769 .58252 L
.31699 .59615 L
.32624 .62019 L
.33062 .64423 L
.33173 .65866 L
.33184 .66827 L
.33173 .68163 L
.33106 .69231 L
.32797 .71635 L
.3225 .74038 L
.31397 .76442 L
.30769 .7771 L
.30054 .78846 L
.28365 .80588 L
.2769 .8125 L
.25962 .81923 L
.23558 .8238 L
.21154 .82192 L
.1875 .81447 L
.1828 .8125 L
.16346 .80119 L
.14705 .78846 L
.13942 .78117 L
.1249 .76442 L
.11538 .75076 L
.10955 .74038 L
.09915 .71635 L
.09297 .69231 L
.09135 .67853 L
.09107 .66827 L
.09135 .66161 L
.09387 .64423 L
.10251 .62019 L
.11538 .60043 L
.11953 .59615 L
.13942 .57992 L
.15351 .57212 L
.16346 .56801 L
s
.4 g
.1875 .20709 m
.21154 .19856 L
.23558 .19643 L
.25962 .20162 L
.27945 .21154 L
.28365 .21699 L
.29911 .23558 L
.30769 .2524 L
.31051 .25962 L
.31739 .28365 L
.32119 .30769 L
.32234 .33173 L
.32065 .35577 L
.31524 .37981 L
.30769 .39736 L
.3033 .40385 L
.28365 .42123 L
.27153 .42788 L
.25962 .43043 L
.23558 .4333 L
.21154 .43213 L
.18953 .42788 L
.1875 .4273 L
.16346 .41775 L
.14273 .40385 L
.13942 .40106 L
.12265 .37981 L
.11538 .36735 L
.11291 .35577 L
.10985 .33173 L
.11193 .30769 L
.11538 .28876 L
.11881 .28365 L
.13085 .25962 L
.13942 .24709 L
.14926 .23558 L
.16346 .22249 L
.17884 .21154 L
F
0 g
.1875 .20709 m
.21154 .19856 L
.23558 .19643 L
.25962 .20162 L
.27945 .21154 L
.28365 .21699 L
.29911 .23558 L
.30769 .2524 L
.31051 .25962 L
.31739 .28365 L
.32119 .30769 L
.32234 .33173 L
.32065 .35577 L
.31524 .37981 L
.30769 .39736 L
.3033 .40385 L
.28365 .42123 L
.27153 .42788 L
.25962 .43043 L
.23558 .4333 L
.21154 .43213 L
.18953 .42788 L
.1875 .4273 L
.16346 .41775 L
.14273 .40385 L
.13942 .40106 L
.12265 .37981 L
.11538 .36735 L
.11291 .35577 L
.10985 .33173 L
.11193 .30769 L
.11538 .28876 L
.11881 .28365 L
.13085 .25962 L
.13942 .24709 L
.14926 .23558 L
.16346 .22249 L
.17884 .21154 L
.1875 .20709 L
s
.4 g
.21154 .56787 m
.23558 .5667 L
.25962 .56957 L
.27153 .57212 L
.28365 .57877 L
.3033 .59615 L
.30769 .60264 L
.31524 .62019 L
.32065 .64423 L
.32234 .66827 L
.32119 .69231 L
.31739 .71635 L
.31051 .74038 L
.30769 .7476 L
.29911 .76442 L
.28365 .78301 L
.27945 .78846 L
.25962 .79838 L
.23558 .80357 L
.21154 .80144 L
.1875 .79291 L
.17884 .78846 L
.16346 .77751 L
.14926 .76442 L
.13942 .75291 L
.13085 .74038 L
.11881 .71635 L
.11538 .71124 L
.11193 .69231 L
.10985 .66827 L
.11291 .64423 L
.11538 .63265 L
.12265 .62019 L
.13942 .59894 L
.14273 .59615 L
.16346 .58225 L
.1875 .5727 L
.18953 .57212 L
F
0 g
.21154 .56787 m
.23558 .5667 L
.25962 .56957 L
.27153 .57212 L
.28365 .57877 L
.3033 .59615 L
.30769 .60264 L
.31524 .62019 L
.32065 .64423 L
.32234 .66827 L
.32119 .69231 L
.31739 .71635 L
.31051 .74038 L
.30769 .7476 L
.29911 .76442 L
.28365 .78301 L
.27945 .78846 L
.25962 .79838 L
.23558 .80357 L
.21154 .80144 L
.1875 .79291 L
.17884 .78846 L
.16346 .77751 L
.14926 .76442 L
.13942 .75291 L
.13085 .74038 L
.11881 .71635 L
.11538 .71124 L
.11193 .69231 L
.10985 .66827 L
.11291 .64423 L
.11538 .63265 L
.12265 .62019 L
.13942 .59894 L
.14273 .59615 L
.16346 .58225 L
.1875 .5727 L
.18953 .57212 L
.21154 .56787 L
s
.5 g
.1875 .22593 m
.21154 .21616 L
.23558 .21375 L
.25962 .21964 L
.28263 .23558 L
.28365 .2375 L
.29866 .25962 L
.30744 .28365 L
.30769 .2839 L
.31209 .30769 L
.31347 .33173 L
.31144 .35577 L
.30769 .37519 L
.30477 .37981 L
.28835 .40385 L
.28365 .4077 L
.25962 .41957 L
.23558 .42324 L
.21154 .42175 L
.1875 .41551 L
.16456 .40385 L
.16346 .4031 L
.14035 .37981 L
.13942 .37926 L
.12928 .35577 L
.12578 .33173 L
.12815 .30769 L
.13597 .28365 L
.13942 .27616 L
.14993 .25962 L
.16346 .24405 L
.17278 .23558 L
F
0 g
.1875 .22593 m
.21154 .21616 L
.23558 .21375 L
.25962 .21964 L
.28263 .23558 L
.28365 .2375 L
.29866 .25962 L
.30744 .28365 L
.30769 .2839 L
.31209 .30769 L
.31347 .33173 L
.31144 .35577 L
.30769 .37519 L
.30477 .37981 L
.28835 .40385 L
.28365 .4077 L
.25962 .41957 L
.23558 .42324 L
.21154 .42175 L
.1875 .41551 L
.16456 .40385 L
.16346 .4031 L
.14035 .37981 L
.13942 .37926 L
.12928 .35577 L
.12578 .33173 L
.12815 .30769 L
.13597 .28365 L
.13942 .27616 L
.14993 .25962 L
.16346 .24405 L
.17278 .23558 L
.1875 .22593 L
s
.5 g
.1875 .58449 m
.21154 .57825 L
.23558 .57676 L
.25962 .58043 L
.28365 .5923 L
.28835 .59615 L
.30477 .62019 L
.30769 .62481 L
.31144 .64423 L
.31347 .66827 L
.31209 .69231 L
.30769 .7161 L
.30744 .71635 L
.29866 .74038 L
.28365 .7625 L
.28263 .76442 L
.25962 .78036 L
.23558 .78625 L
.21154 .78384 L
.1875 .77407 L
.17278 .76442 L
.16346 .75595 L
.14993 .74038 L
.13942 .72384 L
.13597 .71635 L
.12815 .69231 L
.12578 .66827 L
.12928 .64423 L
.13942 .62074 L
.14035 .62019 L
.16346 .5969 L
.16456 .59615 L
F
0 g
.1875 .58449 m
.21154 .57825 L
.23558 .57676 L
.25962 .58043 L
.28365 .5923 L
.28835 .59615 L
.30477 .62019 L
.30769 .62481 L
.31144 .64423 L
.31347 .66827 L
.31209 .69231 L
.30769 .7161 L
.30744 .71635 L
.29866 .74038 L
.28365 .7625 L
.28263 .76442 L
.25962 .78036 L
.23558 .78625 L
.21154 .78384 L
.1875 .77407 L
.17278 .76442 L
.16346 .75595 L
.14993 .74038 L
.13942 .72384 L
.13597 .71635 L
.12815 .69231 L
.12578 .66827 L
.12928 .64423 L
.13942 .62074 L
.14035 .62019 L
.16346 .5969 L
.16456 .59615 L
.1875 .58449 L
s
.6 g
.21154 .23233 m
.23558 .22962 L
.25814 .23558 L
.25962 .2363 L
.28365 .25754 L
.28517 .25962 L
.29733 .28365 L
.30318 .30769 L
.30485 .33173 L
.30238 .35577 L
.29378 .37981 L
.28365 .39364 L
.2725 .40385 L
.25962 .40853 L
.23558 .41308 L
.21154 .41125 L
.18847 .40385 L
.1875 .40343 L
.16346 .38719 L
.1571 .37981 L
.14419 .35577 L
.14023 .33173 L
.14291 .30769 L
.15192 .28365 L
.16346 .26561 L
.16857 .25962 L
.1875 .24357 L
.2024 .23558 L
F
0 g
.21154 .23233 m
.23558 .22962 L
.25814 .23558 L
.25962 .2363 L
.28365 .25754 L
.28517 .25962 L
.29733 .28365 L
.30318 .30769 L
.30485 .33173 L
.30238 .35577 L
.29378 .37981 L
.28365 .39364 L
.2725 .40385 L
.25962 .40853 L
.23558 .41308 L
.21154 .41125 L
.18847 .40385 L
.1875 .40343 L
.16346 .38719 L
.1571 .37981 L
.14419 .35577 L
.14023 .33173 L
.14291 .30769 L
.15192 .28365 L
.16346 .26561 L
.16857 .25962 L
.1875 .24357 L
.2024 .23558 L
.21154 .23233 L
s
.6 g
.21154 .58875 m
.23558 .58692 L
.25962 .59147 L
.2725 .59615 L
.28365 .60636 L
.29378 .62019 L
.30238 .64423 L
.30485 .66827 L
.30318 .69231 L
.29733 .71635 L
.28517 .74038 L
.28365 .74246 L
.25962 .7637 L
.25814 .76442 L
.23558 .77038 L
.21154 .76767 L
.2024 .76442 L
.1875 .75643 L
.16857 .74038 L
.16346 .73439 L
.15192 .71635 L
.14291 .69231 L
.14023 .66827 L
.14419 .64423 L
.1571 .62019 L
.16346 .61281 L
.1875 .59657 L
.18847 .59615 L
F
0 g
.21154 .58875 m
.23558 .58692 L
.25962 .59147 L
.2725 .59615 L
.28365 .60636 L
.29378 .62019 L
.30238 .64423 L
.30485 .66827 L
.30318 .69231 L
.29733 .71635 L
.28517 .74038 L
.28365 .74246 L
.25962 .7637 L
.25814 .76442 L
.23558 .77038 L
.21154 .76767 L
.2024 .76442 L
.1875 .75643 L
.16857 .74038 L
.16346 .73439 L
.15192 .71635 L
.14291 .69231 L
.14023 .66827 L
.14419 .64423 L
.1571 .62019 L
.16346 .61281 L
.1875 .59657 L
.18847 .59615 L
.21154 .58875 L
s
.7 g
.21154 .24788 m
.23558 .24474 L
.25962 .25255 L
.27134 .25962 L
.28365 .27909 L
.2859 .28365 L
.29374 .30769 L
.29589 .33173 L
.29269 .35577 L
.28365 .37816 L
.28213 .37981 L
.25962 .39726 L
.23558 .40264 L
.21154 .40051 L
.1875 .39075 L
.17385 .37981 L
.16346 .3694 L
.15865 .35577 L
.15405 .33173 L
.15716 .30769 L
.16346 .2872 L
.16766 .28365 L
.1875 .26128 L
.18973 .25962 L
F
0 g
.21154 .24788 m
.23558 .24474 L
.25962 .25255 L
.27134 .25962 L
.28365 .27909 L
.2859 .28365 L
.29374 .30769 L
.29589 .33173 L
.29269 .35577 L
.28365 .37816 L
.28213 .37981 L
.25962 .39726 L
.23558 .40264 L
.21154 .40051 L
.1875 .39075 L
.17385 .37981 L
.16346 .3694 L
.15865 .35577 L
.15405 .33173 L
.15716 .30769 L
.16346 .2872 L
.16766 .28365 L
.1875 .26128 L
.18973 .25962 L
.21154 .24788 L
s
.7 g
.1875 .60925 m
.21154 .59949 L
.23558 .59736 L
.25962 .60274 L
.28213 .62019 L
.28365 .62184 L
.29269 .64423 L
.29589 .66827 L
.29374 .69231 L
.2859 .71635 L
.28365 .72091 L
.27134 .74038 L
.25962 .74745 L
.23558 .75526 L
.21154 .75212 L
.18973 .74038 L
.1875 .73872 L
.16766 .71635 L
.16346 .7128 L
.15716 .69231 L
.15405 .66827 L
.15865 .64423 L
.16346 .6306 L
.17385 .62019 L
F
0 g
.1875 .60925 m
.21154 .59949 L
.23558 .59736 L
.25962 .60274 L
.28213 .62019 L
.28365 .62184 L
.29269 .64423 L
.29589 .66827 L
.29374 .69231 L
.2859 .71635 L
.28365 .72091 L
.27134 .74038 L
.25962 .74745 L
.23558 .75526 L
.21154 .75212 L
.18973 .74038 L
.1875 .73872 L
.16766 .71635 L
.16346 .7128 L
.15716 .69231 L
.15405 .66827 L
.15865 .64423 L
.16346 .6306 L
.17385 .62019 L
.1875 .60925 L
s
.8 g
.1875 .2807 m
.21154 .26364 L
.23558 .26004 L
.25962 .26919 L
.27537 .28365 L
.28327 .30769 L
.28365 .31066 L
.28581 .33173 L
.28365 .34859 L
.28248 .35577 L
.26729 .37981 L
.25962 .38419 L
.23558 .39175 L
.21154 .38882 L
.19383 .37981 L
.1875 .37742 L
.17311 .35577 L
.16776 .33173 L
.17134 .30769 L
.18492 .28365 L
F
0 g
.1875 .2807 m
.21154 .26364 L
.23558 .26004 L
.25962 .26919 L
.27537 .28365 L
.28327 .30769 L
.28365 .31066 L
.28581 .33173 L
.28365 .34859 L
.28248 .35577 L
.26729 .37981 L
.25962 .38419 L
.23558 .39175 L
.21154 .38882 L
.19383 .37981 L
.1875 .37742 L
.17311 .35577 L
.16776 .33173 L
.17134 .30769 L
.18492 .28365 L
.1875 .2807 L
s
.8 g
.21154 .61118 m
.23558 .60825 L
.25962 .61581 L
.26729 .62019 L
.28248 .64423 L
.28365 .65141 L
.28581 .66827 L
.28365 .68934 L
.28327 .69231 L
.27537 .71635 L
.25962 .73081 L
.23558 .73996 L
.21154 .73636 L
.1875 .7193 L
.18492 .71635 L
.17134 .69231 L
.16776 .66827 L
.17311 .64423 L
.1875 .62258 L
.19383 .62019 L
F
0 g
.21154 .61118 m
.23558 .60825 L
.25962 .61581 L
.26729 .62019 L
.28248 .64423 L
.28365 .65141 L
.28581 .66827 L
.28365 .68934 L
.28327 .69231 L
.27537 .71635 L
.25962 .73081 L
.23558 .73996 L
.21154 .73636 L
.1875 .7193 L
.18492 .71635 L
.17134 .69231 L
.16776 .66827 L
.17311 .64423 L
.1875 .62258 L
.19383 .62019 L
.21154 .61118 L
s
.9 g
.21154 .28121 m
.23558 .27616 L
.25341 .28365 L
.25962 .28571 L
.27327 .30769 L
.27705 .33173 L
.27111 .35577 L
.25962 .37163 L
.23558 .37926 L
.21154 .37717 L
.18998 .35577 L
.1875 .35114 L
.18258 .33173 L
.1875 .3079 L
.18759 .30769 L
.20765 .28365 L
F
0 g
.21154 .28121 m
.23558 .27616 L
.25341 .28365 L
.25962 .28571 L
.27327 .30769 L
.27705 .33173 L
.27111 .35577 L
.25962 .37163 L
.23558 .37926 L
.21154 .37717 L
.18998 .35577 L
.1875 .35114 L
.18258 .33173 L
.1875 .3079 L
.18759 .30769 L
.20765 .28365 L
.21154 .28121 L
s
.9 g
.21154 .62283 m
.23558 .62074 L
.25962 .62837 L
.27111 .64423 L
.27705 .66827 L
.27327 .69231 L
.25962 .71429 L
.25341 .71635 L
.23558 .72384 L
.21154 .71879 L
.20765 .71635 L
.18759 .69231 L
.1875 .6921 L
.18258 .66827 L
.1875 .64886 L
.18998 .64423 L
F
0 g
.21154 .62283 m
.23558 .62074 L
.25962 .62837 L
.27111 .64423 L
.27705 .66827 L
.27327 .69231 L
.25962 .71429 L
.25341 .71635 L
.23558 .72384 L
.21154 .71879 L
.20765 .71635 L
.18759 .69231 L
.1875 .6921 L
.18258 .66827 L
.1875 .64886 L
.18998 .64423 L
.21154 .62283 L
s
1 g
.21154 .30272 m
.23558 .29179 L
.25245 .30769 L
.25949 .33173 L
.2481 .35577 L
.23558 .36386 L
.21344 .35577 L
.21154 .35423 L
.20087 .33173 L
.20871 .30769 L
F
0 g
.21154 .30272 m
.23558 .29179 L
.25245 .30769 L
.25949 .33173 L
.2481 .35577 L
.23558 .36386 L
.21344 .35577 L
.21154 .35423 L
.20087 .33173 L
.20871 .30769 L
.21154 .30272 L
s
1 g
.23558 .63614 m
.2481 .64423 L
.25949 .66827 L
.25245 .69231 L
.23558 .70821 L
.21154 .69728 L
.20871 .69231 L
.20087 .66827 L
.21154 .64577 L
.21344 .64423 L
F
0 g
.23558 .63614 m
.2481 .64423 L
.25949 .66827 L
.25245 .69231 L
.23558 .70821 L
.21154 .69728 L
.20871 .69231 L
.20087 .66827 L
.21154 .64577 L
.21344 .64423 L
.23558 .63614 L
s
.1 g
.47596 .12548 m
.5 .12049 L
.52404 .12548 L
.5469 .13942 L
.54808 .14168 L
.56462 .16346 L
.57212 .17821 L
.57412 .1875 L
.57993 .21154 L
.58575 .23558 L
.59052 .25962 L
.5939 .28365 L
.59589 .30769 L
.59615 .31339 L
.59639 .33173 L
.59615 .34603 L
.5956 .35577 L
.59281 .37981 L
.58736 .40385 L
.57855 .42788 L
.57212 .44306 L
.56284 .45192 L
.54808 .4564 L
.52404 .46263 L
.5 .46476 L
.47596 .46263 L
.45192 .4564 L
.43716 .45192 L
.42788 .44306 L
.42145 .42788 L
.41264 .40385 L
.40719 .37981 L
.4044 .35577 L
.40385 .34603 L
.40361 .33173 L
.40385 .31339 L
.40411 .30769 L
.4061 .28365 L
.40948 .25962 L
.41425 .23558 L
.42007 .21154 L
.42588 .1875 L
.42788 .17821 L
.43538 .16346 L
.45192 .14168 L
.4531 .13942 L
F
0 g
.47596 .12548 m
.5 .12049 L
.52404 .12548 L
.5469 .13942 L
.54808 .14168 L
.56462 .16346 L
.57212 .17821 L
.57412 .1875 L
.57993 .21154 L
.58575 .23558 L
.59052 .25962 L
.5939 .28365 L
.59589 .30769 L
.59615 .31339 L
.59639 .33173 L
.59615 .34603 L
.5956 .35577 L
.59281 .37981 L
.58736 .40385 L
.57855 .42788 L
.57212 .44306 L
.56284 .45192 L
.54808 .4564 L
.52404 .46263 L
.5 .46476 L
.47596 .46263 L
.45192 .4564 L
.43716 .45192 L
.42788 .44306 L
.42145 .42788 L
.41264 .40385 L
.40719 .37981 L
.4044 .35577 L
.40385 .34603 L
.40361 .33173 L
.40385 .31339 L
.40411 .30769 L
.4061 .28365 L
.40948 .25962 L
.41425 .23558 L
.42007 .21154 L
.42588 .1875 L
.42788 .17821 L
.43538 .16346 L
.45192 .14168 L
.4531 .13942 L
.47596 .12548 L
s
.1 g
.45192 .5436 m
.47596 .53737 L
.5 .53524 L
.52404 .53737 L
.54808 .5436 L
.56284 .54808 L
.57212 .55694 L
.57855 .57212 L
.58736 .59615 L
.59281 .62019 L
.5956 .64423 L
.59615 .65397 L
.59639 .66827 L
.59615 .68661 L
.59589 .69231 L
.5939 .71635 L
.59052 .74038 L
.58575 .76442 L
.57993 .78846 L
.57412 .8125 L
.57212 .82179 L
.56462 .83654 L
.54808 .85832 L
.5469 .86058 L
.52404 .87452 L
.5 .87951 L
.47596 .87452 L
.4531 .86058 L
.45192 .85832 L
.43538 .83654 L
.42788 .82179 L
.42588 .8125 L
.42007 .78846 L
.41425 .76442 L
.40948 .74038 L
.4061 .71635 L
.40411 .69231 L
.40385 .68661 L
.40361 .66827 L
.40385 .65397 L
.4044 .64423 L
.40719 .62019 L
.41264 .59615 L
.42145 .57212 L
.42788 .55694 L
.43716 .54808 L
F
0 g
.45192 .5436 m
.47596 .53737 L
.5 .53524 L
.52404 .53737 L
.54808 .5436 L
.56284 .54808 L
.57212 .55694 L
.57855 .57212 L
.58736 .59615 L
.59281 .62019 L
.5956 .64423 L
.59615 .65397 L
.59639 .66827 L
.59615 .68661 L
.59589 .69231 L
.5939 .71635 L
.59052 .74038 L
.58575 .76442 L
.57993 .78846 L
.57412 .8125 L
.57212 .82179 L
.56462 .83654 L
.54808 .85832 L
.5469 .86058 L
.52404 .87452 L
.5 .87951 L
.47596 .87452 L
.4531 .86058 L
.45192 .85832 L
.43538 .83654 L
.42788 .82179 L
.42588 .8125 L
.42007 .78846 L
.41425 .76442 L
.40948 .74038 L
.4061 .71635 L
.40411 .69231 L
.40385 .68661 L
.40361 .66827 L
.40385 .65397 L
.4044 .64423 L
.40719 .62019 L
.41264 .59615 L
.42145 .57212 L
.42788 .55694 L
.43716 .54808 L
.45192 .5436 L
s
.2 g
.47596 .1712 m
.5 .16513 L
.52404 .1712 L
.54618 .1875 L
.54808 .19188 L
.56019 .21154 L
.56971 .23558 L
.57212 .24358 L
.57411 .25962 L
.57678 .28365 L
.57865 .30769 L
.57927 .33173 L
.57837 .35577 L
.57586 .37981 L
.57212 .40342 L
.57193 .40385 L
.55737 .42788 L
.54808 .43576 L
.52404 .44665 L
.5 .44966 L
.47596 .44665 L
.45192 .43576 L
.44263 .42788 L
.42807 .40385 L
.42788 .40342 L
.42414 .37981 L
.42163 .35577 L
.42073 .33173 L
.42135 .30769 L
.42322 .28365 L
.42589 .25962 L
.42788 .24358 L
.43029 .23558 L
.43981 .21154 L
.45192 .19188 L
.45382 .1875 L
F
0 g
.47596 .1712 m
.5 .16513 L
.52404 .1712 L
.54618 .1875 L
.54808 .19188 L
.56019 .21154 L
.56971 .23558 L
.57212 .24358 L
.57411 .25962 L
.57678 .28365 L
.57865 .30769 L
.57927 .33173 L
.57837 .35577 L
.57586 .37981 L
.57212 .40342 L
.57193 .40385 L
.55737 .42788 L
.54808 .43576 L
.52404 .44665 L
.5 .44966 L
.47596 .44665 L
.45192 .43576 L
.44263 .42788 L
.42807 .40385 L
.42788 .40342 L
.42414 .37981 L
.42163 .35577 L
.42073 .33173 L
.42135 .30769 L
.42322 .28365 L
.42589 .25962 L
.42788 .24358 L
.43029 .23558 L
.43981 .21154 L
.45192 .19188 L
.45382 .1875 L
.47596 .1712 L
s
.2 g
.45192 .56424 m
.47596 .55335 L
.5 .55034 L
.52404 .55335 L
.54808 .56424 L
.55737 .57212 L
.57193 .59615 L
.57212 .59658 L
.57586 .62019 L
.57837 .64423 L
.57927 .66827 L
.57865 .69231 L
.57678 .71635 L
.57411 .74038 L
.57212 .75642 L
.56971 .76442 L
.56019 .78846 L
.54808 .80812 L
.54618 .8125 L
.52404 .8288 L
.5 .83487 L
.47596 .8288 L
.45382 .8125 L
.45192 .80812 L
.43981 .78846 L
.43029 .76442 L
.42788 .75642 L
.42589 .74038 L
.42322 .71635 L
.42135 .69231 L
.42073 .66827 L
.42163 .64423 L
.42414 .62019 L
.42788 .59658 L
.42807 .59615 L
.44263 .57212 L
F
0 g
.45192 .56424 m
.47596 .55335 L
.5 .55034 L
.52404 .55335 L
.54808 .56424 L
.55737 .57212 L
.57193 .59615 L
.57212 .59658 L
.57586 .62019 L
.57837 .64423 L
.57927 .66827 L
.57865 .69231 L
.57678 .71635 L
.57411 .74038 L
.57212 .75642 L
.56971 .76442 L
.56019 .78846 L
.54808 .80812 L
.54618 .8125 L
.52404 .8288 L
.5 .83487 L
.47596 .8288 L
.45382 .8125 L
.45192 .80812 L
.43981 .78846 L
.43029 .76442 L
.42788 .75642 L
.42589 .74038 L
.42322 .71635 L
.42135 .69231 L
.42073 .66827 L
.42163 .64423 L
.42414 .62019 L
.42788 .59658 L
.42807 .59615 L
.44263 .57212 L
.45192 .56424 L
s
.3 g
.47596 .20074 m
.5 .19364 L
.52404 .20074 L
.54065 .21154 L
.54808 .22612 L
.55327 .23558 L
.56241 .25962 L
.56801 .28365 L
.57113 .30769 L
.57207 .33173 L
.57069 .35577 L
.56626 .37981 L
.55659 .40385 L
.54808 .41539 L
.53436 .42788 L
.52404 .43092 L
.5 .43481 L
.47596 .43092 L
.46564 .42788 L
.45192 .41539 L
.44341 .40385 L
.43374 .37981 L
.42931 .35577 L
.42793 .33173 L
.42887 .30769 L
.43199 .28365 L
.43759 .25962 L
.44673 .23558 L
.45192 .22612 L
.45935 .21154 L
F
0 g
.47596 .20074 m
.5 .19364 L
.52404 .20074 L
.54065 .21154 L
.54808 .22612 L
.55327 .23558 L
.56241 .25962 L
.56801 .28365 L
.57113 .30769 L
.57207 .33173 L
.57069 .35577 L
.56626 .37981 L
.55659 .40385 L
.54808 .41539 L
.53436 .42788 L
.52404 .43092 L
.5 .43481 L
.47596 .43092 L
.46564 .42788 L
.45192 .41539 L
.44341 .40385 L
.43374 .37981 L
.42931 .35577 L
.42793 .33173 L
.42887 .30769 L
.43199 .28365 L
.43759 .25962 L
.44673 .23558 L
.45192 .22612 L
.45935 .21154 L
.47596 .20074 L
s
.3 g
.47596 .56908 m
.5 .56519 L
.52404 .56908 L
.53436 .57212 L
.54808 .58461 L
.55659 .59615 L
.56626 .62019 L
.57069 .64423 L
.57207 .66827 L
.57113 .69231 L
.56801 .71635 L
.56241 .74038 L
.55327 .76442 L
.54808 .77388 L
.54065 .78846 L
.52404 .79926 L
.5 .80636 L
.47596 .79926 L
.45935 .78846 L
.45192 .77388 L
.44673 .76442 L
.43759 .74038 L
.43199 .71635 L
.42887 .69231 L
.42793 .66827 L
.42931 .64423 L
.43374 .62019 L
.44341 .59615 L
.45192 .58461 L
.46564 .57212 L
F
0 g
.47596 .56908 m
.5 .56519 L
.52404 .56908 L
.53436 .57212 L
.54808 .58461 L
.55659 .59615 L
.56626 .62019 L
.57069 .64423 L
.57207 .66827 L
.57113 .69231 L
.56801 .71635 L
.56241 .74038 L
.55327 .76442 L
.54808 .77388 L
.54065 .78846 L
.52404 .79926 L
.5 .80636 L
.47596 .79926 L
.45935 .78846 L
.45192 .77388 L
.44673 .76442 L
.43759 .74038 L
.43199 .71635 L
.42887 .69231 L
.42793 .66827 L
.42931 .64423 L
.43374 .62019 L
.44341 .59615 L
.45192 .58461 L
.46564 .57212 L
.47596 .56908 L
s
.4 g
.47596 .22478 m
.5 .21643 L
.52404 .22478 L
.53878 .23558 L
.54808 .25673 L
.54933 .25962 L
.55702 .28365 L
.56106 .30769 L
.56225 .33173 L
.56049 .35577 L
.55468 .37981 L
.54808 .39424 L
.54362 .40385 L
.52404 .41627 L
.5 .42158 L
.47596 .41627 L
.45638 .40385 L
.45192 .39424 L
.44532 .37981 L
.43951 .35577 L
.43775 .33173 L
.43894 .30769 L
.44298 .28365 L
.45067 .25962 L
.45192 .25673 L
.46122 .23558 L
F
0 g
.47596 .22478 m
.5 .21643 L
.52404 .22478 L
.53878 .23558 L
.54808 .25673 L
.54933 .25962 L
.55702 .28365 L
.56106 .30769 L
.56225 .33173 L
.56049 .35577 L
.55468 .37981 L
.54808 .39424 L
.54362 .40385 L
.52404 .41627 L
.5 .42158 L
.47596 .41627 L
.45638 .40385 L
.45192 .39424 L
.44532 .37981 L
.43951 .35577 L
.43775 .33173 L
.43894 .30769 L
.44298 .28365 L
.45067 .25962 L
.45192 .25673 L
.46122 .23558 L
.47596 .22478 L
s
.4 g
.47596 .58373 m
.5 .57842 L
.52404 .58373 L
.54362 .59615 L
.54808 .60576 L
.55468 .62019 L
.56049 .64423 L
.56225 .66827 L
.56106 .69231 L
.55702 .71635 L
.54933 .74038 L
.54808 .74327 L
.53878 .76442 L
.52404 .77522 L
.5 .78357 L
.47596 .77522 L
.46122 .76442 L
.45192 .74327 L
.45067 .74038 L
.44298 .71635 L
.43894 .69231 L
.43775 .66827 L
.43951 .64423 L
.44532 .62019 L
.45192 .60576 L
.45638 .59615 L
F
0 g
.47596 .58373 m
.5 .57842 L
.52404 .58373 L
.54362 .59615 L
.54808 .60576 L
.55468 .62019 L
.56049 .64423 L
.56225 .66827 L
.56106 .69231 L
.55702 .71635 L
.54933 .74038 L
.54808 .74327 L
.53878 .76442 L
.52404 .77522 L
.5 .78357 L
.47596 .77522 L
.46122 .76442 L
.45192 .74327 L
.45067 .74038 L
.44298 .71635 L
.43894 .69231 L
.43775 .66827 L
.43951 .64423 L
.44532 .62019 L
.45192 .60576 L
.45638 .59615 L
.47596 .58373 L
s
.5 g
.47596 .24684 m
.5 .23683 L
.52404 .24684 L
.53815 .25962 L
.54687 .28365 L
.54808 .28753 L
.55115 .30769 L
.5527 .33173 L
.5504 .35577 L
.54808 .36895 L
.54492 .37981 L
.52404 .40123 L
.51885 .40385 L
.5 .40816 L
.48115 .40385 L
.47596 .40123 L
.45508 .37981 L
.45192 .36895 L
.4496 .35577 L
.4473 .33173 L
.44885 .30769 L
.45192 .28753 L
.45313 .28365 L
.46185 .25962 L
F
0 g
.47596 .24684 m
.5 .23683 L
.52404 .24684 L
.53815 .25962 L
.54687 .28365 L
.54808 .28753 L
.55115 .30769 L
.5527 .33173 L
.5504 .35577 L
.54808 .36895 L
.54492 .37981 L
.52404 .40123 L
.51885 .40385 L
.5 .40816 L
.48115 .40385 L
.47596 .40123 L
.45508 .37981 L
.45192 .36895 L
.4496 .35577 L
.4473 .33173 L
.44885 .30769 L
.45192 .28753 L
.45313 .28365 L
.46185 .25962 L
.47596 .24684 L
s
.5 g
.5 .59184 m
.51885 .59615 L
.52404 .59877 L
.54492 .62019 L
.54808 .63105 L
.5504 .64423 L
.5527 .66827 L
.55115 .69231 L
.54808 .71247 L
.54687 .71635 L
.53815 .74038 L
.52404 .75316 L
.5 .76317 L
.47596 .75316 L
.46185 .74038 L
.45313 .71635 L
.45192 .71247 L
.44885 .69231 L
.4473 .66827 L
.4496 .64423 L
.45192 .63105 L
.45508 .62019 L
.47596 .59877 L
.48115 .59615 L
F
0 g
.5 .59184 m
.51885 .59615 L
.52404 .59877 L
.54492 .62019 L
.54808 .63105 L
.5504 .64423 L
.5527 .66827 L
.55115 .69231 L
.54808 .71247 L
.54687 .71635 L
.53815 .74038 L
.52404 .75316 L
.5 .76317 L
.47596 .75316 L
.46185 .74038 L
.45313 .71635 L
.45192 .71247 L
.44885 .69231 L
.4473 .66827 L
.4496 .64423 L
.45192 .63105 L
.45508 .62019 L
.47596 .59877 L
.48115 .59615 L
.5 .59184 L
s
.6 g
.5 .25671 m
.51141 .25962 L
.52404 .26917 L
.53614 .28365 L
.5435 .30769 L
.54498 .33173 L
.54271 .35577 L
.52968 .37981 L
.52404 .38421 L
.5 .39425 L
.47596 .38421 L
.47032 .37981 L
.45729 .35577 L
.45502 .33173 L
.4565 .30769 L
.46386 .28365 L
.47596 .26917 L
.48859 .25962 L
F
0 g
.5 .25671 m
.51141 .25962 L
.52404 .26917 L
.53614 .28365 L
.5435 .30769 L
.54498 .33173 L
.54271 .35577 L
.52968 .37981 L
.52404 .38421 L
.5 .39425 L
.47596 .38421 L
.47032 .37981 L
.45729 .35577 L
.45502 .33173 L
.4565 .30769 L
.46386 .28365 L
.47596 .26917 L
.48859 .25962 L
.5 .25671 L
s
.6 g
.47596 .61579 m
.5 .60575 L
.52404 .61579 L
.52968 .62019 L
.54271 .64423 L
.54498 .66827 L
.5435 .69231 L
.53614 .71635 L
.52404 .73083 L
.51141 .74038 L
.5 .74329 L
.48859 .74038 L
.47596 .73083 L
.46386 .71635 L
.4565 .69231 L
.45502 .66827 L
.45729 .64423 L
.47032 .62019 L
F
0 g
.47596 .61579 m
.5 .60575 L
.52404 .61579 L
.52968 .62019 L
.54271 .64423 L
.54498 .66827 L
.5435 .69231 L
.53614 .71635 L
.52404 .73083 L
.51141 .74038 L
.5 .74329 L
.48859 .74038 L
.47596 .73083 L
.46386 .71635 L
.4565 .69231 L
.45502 .66827 L
.45729 .64423 L
.47032 .62019 L
.47596 .61579 L
s
.7 g
.5 .27793 m
.5134 .28365 L
.52404 .29296 L
.52959 .30769 L
.53371 .33173 L
.52736 .35577 L
.52404 .36262 L
.5 .37863 L
.47596 .36262 L
.47264 .35577 L
.46629 .33173 L
.47041 .30769 L
.47596 .29296 L
.4866 .28365 L
F
0 g
.5 .27793 m
.5134 .28365 L
.52404 .29296 L
.52959 .30769 L
.53371 .33173 L
.52736 .35577 L
.52404 .36262 L
.5 .37863 L
.47596 .36262 L
.47264 .35577 L
.46629 .33173 L
.47041 .30769 L
.47596 .29296 L
.4866 .28365 L
.5 .27793 L
s
.7 g
.47596 .63738 m
.5 .62137 L
.52404 .63738 L
.52736 .64423 L
.53371 .66827 L
.52959 .69231 L
.52404 .70704 L
.5134 .71635 L
.5 .72207 L
.4866 .71635 L
.47596 .70704 L
.47041 .69231 L
.46629 .66827 L
.47264 .64423 L
F
0 g
.47596 .63738 m
.5 .62137 L
.52404 .63738 L
.52736 .64423 L
.53371 .66827 L
.52959 .69231 L
.52404 .70704 L
.5134 .71635 L
.5 .72207 L
.4866 .71635 L
.47596 .70704 L
.47041 .69231 L
.46629 .66827 L
.47264 .64423 L
.47596 .63738 L
s
.8 g
.5 .30802 m
.51318 .33173 L
.5 .35103 L
.48682 .33173 L
F
0 g
.5 .30802 m
.51318 .33173 L
.5 .35103 L
.48682 .33173 L
.5 .30802 L
s
.8 g
.5 .64897 m
.51318 .66827 L
.5 .69198 L
.48682 .66827 L
F
0 g
.5 .64897 m
.51318 .66827 L
.5 .69198 L
.48682 .66827 L
.5 .64897 L
s
.1 g
.74038 .11137 m
.76442 .10812 L
.78846 .10947 L
.8125 .11465 L
.81516 .11538 L
.83654 .12414 L
.86058 .13723 L
.8641 .13942 L
.88462 .1549 L
.89443 .16346 L
.90865 .1778 L
.91701 .1875 L
.93269 .20831 L
.93472 .21154 L
.94832 .23558 L
.95673 .25359 L
.95913 .25962 L
.9668 .28365 L
.97132 .30769 L
.97271 .33173 L
.97067 .35577 L
.96433 .37981 L
.95673 .39652 L
.95198 .40385 L
.93269 .42657 L
.93116 .42788 L
.90865 .44327 L
.89121 .45192 L
.88462 .45298 L
.86058 .45793 L
.83654 .4632 L
.8125 .46734 L
.78846 .46983 L
.76442 .47046 L
.74038 .46893 L
.71635 .46461 L
.69231 .45705 L
.67709 .45192 L
.66827 .44341 L
.66188 .42788 L
.65304 .40385 L
.64756 .37981 L
.64476 .35577 L
.64423 .3466 L
.64398 .33173 L
.64423 .31279 L
.64447 .30769 L
.64647 .28365 L
.64986 .25962 L
.65465 .23558 L
.6605 .21154 L
.66625 .1875 L
.66827 .17754 L
.67537 .16346 L
.69231 .13966 L
.69252 .13942 L
.71635 .12083 L
.72457 .11538 L
F
0 g
.74038 .11137 m
.76442 .10812 L
.78846 .10947 L
.8125 .11465 L
.81516 .11538 L
.83654 .12414 L
.86058 .13723 L
.8641 .13942 L
.88462 .1549 L
.89443 .16346 L
.90865 .1778 L
.91701 .1875 L
.93269 .20831 L
.93472 .21154 L
.94832 .23558 L
.95673 .25359 L
.95913 .25962 L
.9668 .28365 L
.97132 .30769 L
.97271 .33173 L
.97067 .35577 L
.96433 .37981 L
.95673 .39652 L
.95198 .40385 L
.93269 .42657 L
.93116 .42788 L
.90865 .44327 L
.89121 .45192 L
.88462 .45298 L
.86058 .45793 L
.83654 .4632 L
.8125 .46734 L
.78846 .46983 L
.76442 .47046 L
.74038 .46893 L
.71635 .46461 L
.69231 .45705 L
.67709 .45192 L
.66827 .44341 L
.66188 .42788 L
.65304 .40385 L
.64756 .37981 L
.64476 .35577 L
.64423 .3466 L
.64398 .33173 L
.64423 .31279 L
.64447 .30769 L
.64647 .28365 L
.64986 .25962 L
.65465 .23558 L
Mistroke
.6605 .21154 L
.66625 .1875 L
.66827 .17754 L
.67537 .16346 L
.69231 .13966 L
.69252 .13942 L
.71635 .12083 L
.72457 .11538 L
.74038 .11137 L
Mfstroke
.1 g
.69231 .54295 m
.71635 .53539 L
.74038 .53107 L
.76442 .52954 L
.78846 .53017 L
.8125 .53266 L
.83654 .5368 L
.86058 .54207 L
.88462 .54702 L
.89121 .54808 L
.90865 .55673 L
.93116 .57212 L
.93269 .57343 L
.95198 .59615 L
.95673 .60348 L
.96433 .62019 L
.97067 .64423 L
.97271 .66827 L
.97132 .69231 L
.9668 .71635 L
.95913 .74038 L
.95673 .74641 L
.94832 .76442 L
.93472 .78846 L
.93269 .79169 L
.91701 .8125 L
.90865 .8222 L
.89443 .83654 L
.88462 .8451 L
.8641 .86058 L
.86058 .86277 L
.83654 .87586 L
.81516 .88462 L
.8125 .88535 L
.78846 .89053 L
.76442 .89188 L
.74038 .88863 L
.72457 .88462 L
.71635 .87917 L
.69252 .86058 L
.69231 .86034 L
.67537 .83654 L
.66827 .82246 L
.66625 .8125 L
.6605 .78846 L
.65465 .76442 L
.64986 .74038 L
.64647 .71635 L
.64447 .69231 L
.64423 .68721 L
.64398 .66827 L
.64423 .6534 L
.64476 .64423 L
.64756 .62019 L
.65304 .59615 L
.66188 .57212 L
.66827 .55659 L
.67709 .54808 L
F
0 g
.69231 .54295 m
.71635 .53539 L
.74038 .53107 L
.76442 .52954 L
.78846 .53017 L
.8125 .53266 L
.83654 .5368 L
.86058 .54207 L
.88462 .54702 L
.89121 .54808 L
.90865 .55673 L
.93116 .57212 L
.93269 .57343 L
.95198 .59615 L
.95673 .60348 L
.96433 .62019 L
.97067 .64423 L
.97271 .66827 L
.97132 .69231 L
.9668 .71635 L
.95913 .74038 L
.95673 .74641 L
.94832 .76442 L
.93472 .78846 L
.93269 .79169 L
.91701 .8125 L
.90865 .8222 L
.89443 .83654 L
.88462 .8451 L
.8641 .86058 L
.86058 .86277 L
.83654 .87586 L
.81516 .88462 L
.8125 .88535 L
.78846 .89053 L
.76442 .89188 L
.74038 .88863 L
.72457 .88462 L
.71635 .87917 L
.69252 .86058 L
.69231 .86034 L
.67537 .83654 L
.66827 .82246 L
.66625 .8125 L
.6605 .78846 L
.65465 .76442 L
.64986 .74038 L
.64647 .71635 L
.64447 .69231 L
.64423 .68721 L
Mistroke
.64398 .66827 L
.64423 .6534 L
.64476 .64423 L
.64756 .62019 L
.65304 .59615 L
.66188 .57212 L
.66827 .55659 L
.67709 .54808 L
.69231 .54295 L
Mfstroke
.2 g
.74038 .15415 m
.76442 .15013 L
.78846 .15179 L
.8125 .15829 L
.82546 .16346 L
.83654 .16956 L
.86058 .18607 L
.86234 .1875 L
.88462 .20925 L
.88658 .21154 L
.90418 .23558 L
.90865 .24291 L
.91695 .25962 L
.92597 .28365 L
.93143 .30769 L
.93269 .31886 L
.93309 .33173 L
.93269 .34087 L
.93063 .35577 L
.92303 .37981 L
.90867 .40385 L
.90865 .40387 L
.88462 .426 L
.88177 .42788 L
.86058 .43887 L
.83654 .44747 L
.81875 .45192 L
.8125 .45232 L
.78846 .45365 L
.76442 .45405 L
.74038 .45313 L
.72205 .45192 L
.71635 .44946 L
.69231 .43713 L
.68228 .42788 L
.66827 .40417 L
.66822 .40385 L
.66456 .37981 L
.66206 .35577 L
.66116 .33173 L
.66178 .30769 L
.66364 .28365 L
.66627 .25962 L
.66827 .24249 L
.67036 .23558 L
.67963 .21154 L
.69231 .18931 L
.69358 .1875 L
.71635 .16555 L
.71821 .16346 L
F
0 g
.74038 .15415 m
.76442 .15013 L
.78846 .15179 L
.8125 .15829 L
.82546 .16346 L
.83654 .16956 L
.86058 .18607 L
.86234 .1875 L
.88462 .20925 L
.88658 .21154 L
.90418 .23558 L
.90865 .24291 L
.91695 .25962 L
.92597 .28365 L
.93143 .30769 L
.93269 .31886 L
.93309 .33173 L
.93269 .34087 L
.93063 .35577 L
.92303 .37981 L
.90867 .40385 L
.90865 .40387 L
.88462 .426 L
.88177 .42788 L
.86058 .43887 L
.83654 .44747 L
.81875 .45192 L
.8125 .45232 L
.78846 .45365 L
.76442 .45405 L
.74038 .45313 L
.72205 .45192 L
.71635 .44946 L
.69231 .43713 L
.68228 .42788 L
.66827 .40417 L
.66822 .40385 L
.66456 .37981 L
.66206 .35577 L
.66116 .33173 L
.66178 .30769 L
.66364 .28365 L
.66627 .25962 L
.66827 .24249 L
.67036 .23558 L
.67963 .21154 L
.69231 .18931 L
.69358 .1875 L
.71635 .16555 L
.71821 .16346 L
Mistroke
.74038 .15415 L
Mfstroke
.2 g
.74038 .54687 m
.76442 .54595 L
.78846 .54635 L
.8125 .54768 L
.81875 .54808 L
.83654 .55253 L
.86058 .56113 L
.88177 .57212 L
.88462 .574 L
.90865 .59613 L
.90867 .59615 L
.92303 .62019 L
.93063 .64423 L
.93269 .65913 L
.93309 .66827 L
.93269 .68114 L
.93143 .69231 L
.92597 .71635 L
.91695 .74038 L
.90865 .75709 L
.90418 .76442 L
.88658 .78846 L
.88462 .79075 L
.86234 .8125 L
.86058 .81393 L
.83654 .83044 L
.82546 .83654 L
.8125 .84171 L
.78846 .84821 L
.76442 .84987 L
.74038 .84585 L
.71821 .83654 L
.71635 .83445 L
.69358 .8125 L
.69231 .81069 L
.67963 .78846 L
.67036 .76442 L
.66827 .75751 L
.66627 .74038 L
.66364 .71635 L
.66178 .69231 L
.66116 .66827 L
.66206 .64423 L
.66456 .62019 L
.66822 .59615 L
.66827 .59583 L
.68228 .57212 L
.69231 .56287 L
.71635 .55054 L
.72205 .54808 L
F
0 g
.74038 .54687 m
.76442 .54595 L
.78846 .54635 L
.8125 .54768 L
.81875 .54808 L
.83654 .55253 L
.86058 .56113 L
.88177 .57212 L
.88462 .574 L
.90865 .59613 L
.90867 .59615 L
.92303 .62019 L
.93063 .64423 L
.93269 .65913 L
.93309 .66827 L
.93269 .68114 L
.93143 .69231 L
.92597 .71635 L
.91695 .74038 L
.90865 .75709 L
.90418 .76442 L
.88658 .78846 L
.88462 .79075 L
.86234 .8125 L
.86058 .81393 L
.83654 .83044 L
.82546 .83654 L
.8125 .84171 L
.78846 .84821 L
.76442 .84987 L
.74038 .84585 L
.71821 .83654 L
.71635 .83445 L
.69358 .8125 L
.69231 .81069 L
.67963 .78846 L
.67036 .76442 L
.66827 .75751 L
.66627 .74038 L
.66364 .71635 L
.66178 .69231 L
.66116 .66827 L
.66206 .64423 L
.66456 .62019 L
.66822 .59615 L
.66827 .59583 L
.68228 .57212 L
.69231 .56287 L
.71635 .55054 L
.72205 .54808 L
Mistroke
.74038 .54687 L
Mfstroke
.3 g
.74038 .18077 m
.76442 .1762 L
.78846 .17808 L
.8125 .18553 L
.8172 .1875 L
.83654 .19881 L
.85295 .21154 L
.86058 .21883 L
.8751 .23558 L
.88462 .24924 L
.89045 .25962 L
.90085 .28365 L
.90703 .30769 L
.90865 .32147 L
.90893 .33173 L
.90865 .33839 L
.90613 .35577 L
.89749 .37981 L
.88462 .39957 L
.88047 .40385 L
.86058 .42008 L
.84649 .42788 L
.83654 .43199 L
.8125 .43916 L
.78846 .44312 L
.76442 .4441 L
.74038 .44171 L
.71635 .43455 L
.70374 .42788 L
.69231 .41748 L
.68301 .40385 L
.67376 .37981 L
.66938 .35577 L
.66827 .34134 L
.66816 .33173 L
.66827 .31837 L
.66894 .30769 L
.67203 .28365 L
.6775 .25962 L
.68603 .23558 L
.69231 .2229 L
.69946 .21154 L
.71635 .19412 L
.7231 .1875 L
F
0 g
.74038 .18077 m
.76442 .1762 L
.78846 .17808 L
.8125 .18553 L
.8172 .1875 L
.83654 .19881 L
.85295 .21154 L
.86058 .21883 L
.8751 .23558 L
.88462 .24924 L
.89045 .25962 L
.90085 .28365 L
.90703 .30769 L
.90865 .32147 L
.90893 .33173 L
.90865 .33839 L
.90613 .35577 L
.89749 .37981 L
.88462 .39957 L
.88047 .40385 L
.86058 .42008 L
.84649 .42788 L
.83654 .43199 L
.8125 .43916 L
.78846 .44312 L
.76442 .4441 L
.74038 .44171 L
.71635 .43455 L
.70374 .42788 L
.69231 .41748 L
.68301 .40385 L
.67376 .37981 L
.66938 .35577 L
.66827 .34134 L
.66816 .33173 L
.66827 .31837 L
.66894 .30769 L
.67203 .28365 L
.6775 .25962 L
.68603 .23558 L
.69231 .2229 L
.69946 .21154 L
.71635 .19412 L
.7231 .1875 L
.74038 .18077 L
s
.3 g
.71635 .56545 m
.74038 .55829 L
.76442 .5559 L
.78846 .55688 L
.8125 .56084 L
.83654 .56801 L
.84649 .57212 L
.86058 .57992 L
.88047 .59615 L
.88462 .60043 L
.89749 .62019 L
.90613 .64423 L
.90865 .66161 L
.90893 .66827 L
.90865 .67853 L
.90703 .69231 L
.90085 .71635 L
.89045 .74038 L
.88462 .75076 L
.8751 .76442 L
.86058 .78117 L
.85295 .78846 L
.83654 .80119 L
.8172 .8125 L
.8125 .81447 L
.78846 .82192 L
.76442 .8238 L
.74038 .81923 L
.7231 .8125 L
.71635 .80588 L
.69946 .78846 L
.69231 .7771 L
.68603 .76442 L
.6775 .74038 L
.67203 .71635 L
.66894 .69231 L
.66827 .68163 L
.66816 .66827 L
.66827 .65866 L
.66938 .64423 L
.67376 .62019 L
.68301 .59615 L
.69231 .58252 L
.70374 .57212 L
F
0 g
.71635 .56545 m
.74038 .55829 L
.76442 .5559 L
.78846 .55688 L
.8125 .56084 L
.83654 .56801 L
.84649 .57212 L
.86058 .57992 L
.88047 .59615 L
.88462 .60043 L
.89749 .62019 L
.90613 .64423 L
.90865 .66161 L
.90893 .66827 L
.90865 .67853 L
.90703 .69231 L
.90085 .71635 L
.89045 .74038 L
.88462 .75076 L
.8751 .76442 L
.86058 .78117 L
.85295 .78846 L
.83654 .80119 L
.8172 .8125 L
.8125 .81447 L
.78846 .82192 L
.76442 .8238 L
.74038 .81923 L
.7231 .8125 L
.71635 .80588 L
.69946 .78846 L
.69231 .7771 L
.68603 .76442 L
.6775 .74038 L
.67203 .71635 L
.66894 .69231 L
.66827 .68163 L
.66816 .66827 L
.66827 .65866 L
.66938 .64423 L
.67376 .62019 L
.68301 .59615 L
.69231 .58252 L
.70374 .57212 L
.71635 .56545 L
s
.4 g
.74038 .20162 m
.76442 .19643 L
.78846 .19856 L
.8125 .20709 L
.82116 .21154 L
.83654 .22249 L
.85074 .23558 L
.86058 .24709 L
.86915 .25962 L
.88119 .28365 L
.88462 .28876 L
.88807 .30769 L
.89015 .33173 L
.88709 .35577 L
.88462 .36735 L
.87735 .37981 L
.86058 .40106 L
.85727 .40385 L
.83654 .41775 L
.8125 .4273 L
.81047 .42788 L
.78846 .43213 L
.76442 .4333 L
.74038 .43043 L
.72847 .42788 L
.71635 .42123 L
.6967 .40385 L
.69231 .39736 L
.68476 .37981 L
.67935 .35577 L
.67766 .33173 L
.67881 .30769 L
.68261 .28365 L
.68949 .25962 L
.69231 .2524 L
.70089 .23558 L
.71635 .21699 L
.72055 .21154 L
F
0 g
.74038 .20162 m
.76442 .19643 L
.78846 .19856 L
.8125 .20709 L
.82116 .21154 L
.83654 .22249 L
.85074 .23558 L
.86058 .24709 L
.86915 .25962 L
.88119 .28365 L
.88462 .28876 L
.88807 .30769 L
.89015 .33173 L
.88709 .35577 L
.88462 .36735 L
.87735 .37981 L
.86058 .40106 L
.85727 .40385 L
.83654 .41775 L
.8125 .4273 L
.81047 .42788 L
.78846 .43213 L
.76442 .4333 L
.74038 .43043 L
.72847 .42788 L
.71635 .42123 L
.6967 .40385 L
.69231 .39736 L
.68476 .37981 L
.67935 .35577 L
.67766 .33173 L
.67881 .30769 L
.68261 .28365 L
.68949 .25962 L
.69231 .2524 L
.70089 .23558 L
.71635 .21699 L
.72055 .21154 L
.74038 .20162 L
s
.4 g
.74038 .56957 m
.76442 .5667 L
.78846 .56787 L
.81047 .57212 L
.8125 .5727 L
.83654 .58225 L
.85727 .59615 L
.86058 .59894 L
.87735 .62019 L
.88462 .63265 L
.88709 .64423 L
.89015 .66827 L
.88807 .69231 L
.88462 .71124 L
.88119 .71635 L
.86915 .74038 L
.86058 .75291 L
.85074 .76442 L
.83654 .77751 L
.82116 .78846 L
.8125 .79291 L
.78846 .80144 L
.76442 .80357 L
.74038 .79838 L
.72055 .78846 L
.71635 .78301 L
.70089 .76442 L
.69231 .7476 L
.68949 .74038 L
.68261 .71635 L
.67881 .69231 L
.67766 .66827 L
.67935 .64423 L
.68476 .62019 L
.69231 .60264 L
.6967 .59615 L
.71635 .57877 L
.72847 .57212 L
F
0 g
.74038 .56957 m
.76442 .5667 L
.78846 .56787 L
.81047 .57212 L
.8125 .5727 L
.83654 .58225 L
.85727 .59615 L
.86058 .59894 L
.87735 .62019 L
.88462 .63265 L
.88709 .64423 L
.89015 .66827 L
.88807 .69231 L
.88462 .71124 L
.88119 .71635 L
.86915 .74038 L
.86058 .75291 L
.85074 .76442 L
.83654 .77751 L
.82116 .78846 L
.8125 .79291 L
.78846 .80144 L
.76442 .80357 L
.74038 .79838 L
.72055 .78846 L
.71635 .78301 L
.70089 .76442 L
.69231 .7476 L
.68949 .74038 L
.68261 .71635 L
.67881 .69231 L
.67766 .66827 L
.67935 .64423 L
.68476 .62019 L
.69231 .60264 L
.6967 .59615 L
.71635 .57877 L
.72847 .57212 L
.74038 .56957 L
s
.5 g
.74038 .21964 m
.76442 .21375 L
.78846 .21616 L
.8125 .22593 L
.82722 .23558 L
.83654 .24405 L
.85007 .25962 L
.86058 .27616 L
.86403 .28365 L
.87185 .30769 L
.87422 .33173 L
.87072 .35577 L
.86058 .37926 L
.85965 .37981 L
.83654 .4031 L
.83544 .40385 L
.8125 .41551 L
.78846 .42175 L
.76442 .42324 L
.74038 .41957 L
.71635 .4077 L
.71165 .40385 L
.69523 .37981 L
.69231 .37519 L
.68856 .35577 L
.68653 .33173 L
.68791 .30769 L
.69231 .2839 L
.69256 .28365 L
.70134 .25962 L
.71635 .2375 L
.71737 .23558 L
F
0 g
.74038 .21964 m
.76442 .21375 L
.78846 .21616 L
.8125 .22593 L
.82722 .23558 L
.83654 .24405 L
.85007 .25962 L
.86058 .27616 L
.86403 .28365 L
.87185 .30769 L
.87422 .33173 L
.87072 .35577 L
.86058 .37926 L
.85965 .37981 L
.83654 .4031 L
.83544 .40385 L
.8125 .41551 L
.78846 .42175 L
.76442 .42324 L
.74038 .41957 L
.71635 .4077 L
.71165 .40385 L
.69523 .37981 L
.69231 .37519 L
.68856 .35577 L
.68653 .33173 L
.68791 .30769 L
.69231 .2839 L
.69256 .28365 L
.70134 .25962 L
.71635 .2375 L
.71737 .23558 L
.74038 .21964 L
s
.5 g
.71635 .5923 m
.74038 .58043 L
.76442 .57676 L
.78846 .57825 L
.8125 .58449 L
.83544 .59615 L
.83654 .5969 L
.85965 .62019 L
.86058 .62074 L
.87072 .64423 L
.87422 .66827 L
.87185 .69231 L
.86403 .71635 L
.86058 .72384 L
.85007 .74038 L
.83654 .75595 L
.82722 .76442 L
.8125 .77407 L
.78846 .78384 L
.76442 .78625 L
.74038 .78036 L
.71737 .76442 L
.71635 .7625 L
.70134 .74038 L
.69256 .71635 L
.69231 .7161 L
.68791 .69231 L
.68653 .66827 L
.68856 .64423 L
.69231 .62481 L
.69523 .62019 L
.71165 .59615 L
F
0 g
.71635 .5923 m
.74038 .58043 L
.76442 .57676 L
.78846 .57825 L
.8125 .58449 L
.83544 .59615 L
.83654 .5969 L
.85965 .62019 L
.86058 .62074 L
.87072 .64423 L
.87422 .66827 L
.87185 .69231 L
.86403 .71635 L
.86058 .72384 L
.85007 .74038 L
.83654 .75595 L
.82722 .76442 L
.8125 .77407 L
.78846 .78384 L
.76442 .78625 L
.74038 .78036 L
.71737 .76442 L
.71635 .7625 L
.70134 .74038 L
.69256 .71635 L
.69231 .7161 L
.68791 .69231 L
.68653 .66827 L
.68856 .64423 L
.69231 .62481 L
.69523 .62019 L
.71165 .59615 L
.71635 .5923 L
s
.6 g
.76442 .22962 m
.78846 .23233 L
.7976 .23558 L
.8125 .24357 L
.83143 .25962 L
.83654 .26561 L
.84808 .28365 L
.85709 .30769 L
.85977 .33173 L
.85581 .35577 L
.8429 .37981 L
.83654 .38719 L
.8125 .40343 L
.81153 .40385 L
.78846 .41125 L
.76442 .41308 L
.74038 .40853 L
.7275 .40385 L
.71635 .39364 L
.70622 .37981 L
.69762 .35577 L
.69515 .33173 L
.69682 .30769 L
.70267 .28365 L
.71483 .25962 L
.71635 .25754 L
.74038 .2363 L
.74186 .23558 L
F
0 g
.76442 .22962 m
.78846 .23233 L
.7976 .23558 L
.8125 .24357 L
.83143 .25962 L
.83654 .26561 L
.84808 .28365 L
.85709 .30769 L
.85977 .33173 L
.85581 .35577 L
.8429 .37981 L
.83654 .38719 L
.8125 .40343 L
.81153 .40385 L
.78846 .41125 L
.76442 .41308 L
.74038 .40853 L
.7275 .40385 L
.71635 .39364 L
.70622 .37981 L
.69762 .35577 L
.69515 .33173 L
.69682 .30769 L
.70267 .28365 L
.71483 .25962 L
.71635 .25754 L
.74038 .2363 L
.74186 .23558 L
.76442 .22962 L
s
.6 g
.74038 .59147 m
.76442 .58692 L
.78846 .58875 L
.81153 .59615 L
.8125 .59657 L
.83654 .61281 L
.8429 .62019 L
.85581 .64423 L
.85977 .66827 L
.85709 .69231 L
.84808 .71635 L
.83654 .73439 L
.83143 .74038 L
.8125 .75643 L
.7976 .76442 L
.78846 .76767 L
.76442 .77038 L
.74186 .76442 L
.74038 .7637 L
.71635 .74246 L
.71483 .74038 L
.70267 .71635 L
.69682 .69231 L
.69515 .66827 L
.69762 .64423 L
.70622 .62019 L
.71635 .60636 L
.7275 .59615 L
F
0 g
.74038 .59147 m
.76442 .58692 L
.78846 .58875 L
.81153 .59615 L
.8125 .59657 L
.83654 .61281 L
.8429 .62019 L
.85581 .64423 L
.85977 .66827 L
.85709 .69231 L
.84808 .71635 L
.83654 .73439 L
.83143 .74038 L
.8125 .75643 L
.7976 .76442 L
.78846 .76767 L
.76442 .77038 L
.74186 .76442 L
.74038 .7637 L
.71635 .74246 L
.71483 .74038 L
.70267 .71635 L
.69682 .69231 L
.69515 .66827 L
.69762 .64423 L
.70622 .62019 L
.71635 .60636 L
.7275 .59615 L
.74038 .59147 L
s
.7 g
.74038 .25255 m
.76442 .24474 L
.78846 .24788 L
.81027 .25962 L
.8125 .26128 L
.83234 .28365 L
.83654 .2872 L
.84284 .30769 L
.84595 .33173 L
.84135 .35577 L
.83654 .3694 L
.82615 .37981 L
.8125 .39075 L
.78846 .40051 L
.76442 .40264 L
.74038 .39726 L
.71787 .37981 L
.71635 .37816 L
.70731 .35577 L
.70411 .33173 L
.70626 .30769 L
.7141 .28365 L
.71635 .27909 L
.72866 .25962 L
F
0 g
.74038 .25255 m
.76442 .24474 L
.78846 .24788 L
.81027 .25962 L
.8125 .26128 L
.83234 .28365 L
.83654 .2872 L
.84284 .30769 L
.84595 .33173 L
.84135 .35577 L
.83654 .3694 L
.82615 .37981 L
.8125 .39075 L
.78846 .40051 L
.76442 .40264 L
.74038 .39726 L
.71787 .37981 L
.71635 .37816 L
.70731 .35577 L
.70411 .33173 L
.70626 .30769 L
.7141 .28365 L
.71635 .27909 L
.72866 .25962 L
.74038 .25255 L
s
.7 g
.74038 .60274 m
.76442 .59736 L
.78846 .59949 L
.8125 .60925 L
.82615 .62019 L
.83654 .6306 L
.84135 .64423 L
.84595 .66827 L
.84284 .69231 L
.83654 .7128 L
.83234 .71635 L
.8125 .73872 L
.81027 .74038 L
.78846 .75212 L
.76442 .75526 L
.74038 .74745 L
.72866 .74038 L
.71635 .72091 L
.7141 .71635 L
.70626 .69231 L
.70411 .66827 L
.70731 .64423 L
.71635 .62184 L
.71787 .62019 L
F
0 g
.74038 .60274 m
.76442 .59736 L
.78846 .59949 L
.8125 .60925 L
.82615 .62019 L
.83654 .6306 L
.84135 .64423 L
.84595 .66827 L
.84284 .69231 L
.83654 .7128 L
.83234 .71635 L
.8125 .73872 L
.81027 .74038 L
.78846 .75212 L
.76442 .75526 L
.74038 .74745 L
.72866 .74038 L
.71635 .72091 L
.7141 .71635 L
.70626 .69231 L
.70411 .66827 L
.70731 .64423 L
.71635 .62184 L
.71787 .62019 L
.74038 .60274 L
s
.8 g
.74038 .26919 m
.76442 .26004 L
.78846 .26364 L
.8125 .2807 L
.81508 .28365 L
.82866 .30769 L
.83224 .33173 L
.82689 .35577 L
.8125 .37742 L
.80617 .37981 L
.78846 .38882 L
.76442 .39175 L
.74038 .38419 L
.73271 .37981 L
.71752 .35577 L
.71635 .34859 L
.71419 .33173 L
.71635 .31066 L
.71673 .30769 L
.72463 .28365 L
F
0 g
.74038 .26919 m
.76442 .26004 L
.78846 .26364 L
.8125 .2807 L
.81508 .28365 L
.82866 .30769 L
.83224 .33173 L
.82689 .35577 L
.8125 .37742 L
.80617 .37981 L
.78846 .38882 L
.76442 .39175 L
.74038 .38419 L
.73271 .37981 L
.71752 .35577 L
.71635 .34859 L
.71419 .33173 L
.71635 .31066 L
.71673 .30769 L
.72463 .28365 L
.74038 .26919 L
s
.8 g
.74038 .61581 m
.76442 .60825 L
.78846 .61118 L
.80617 .62019 L
.8125 .62258 L
.82689 .64423 L
.83224 .66827 L
.82866 .69231 L
.81508 .71635 L
.8125 .7193 L
.78846 .73636 L
.76442 .73996 L
.74038 .73081 L
.72463 .71635 L
.71673 .69231 L
.71635 .68934 L
.71419 .66827 L
.71635 .65141 L
.71752 .64423 L
.73271 .62019 L
F
0 g
.74038 .61581 m
.76442 .60825 L
.78846 .61118 L
.80617 .62019 L
.8125 .62258 L
.82689 .64423 L
.83224 .66827 L
.82866 .69231 L
.81508 .71635 L
.8125 .7193 L
.78846 .73636 L
.76442 .73996 L
.74038 .73081 L
.72463 .71635 L
.71673 .69231 L
.71635 .68934 L
.71419 .66827 L
.71635 .65141 L
.71752 .64423 L
.73271 .62019 L
.74038 .61581 L
s
.9 g
.76442 .27616 m
.78846 .28121 L
.79235 .28365 L
.81241 .30769 L
.8125 .3079 L
.81742 .33173 L
.8125 .35114 L
.81002 .35577 L
.78846 .37717 L
.76442 .37926 L
.74038 .37163 L
.72889 .35577 L
.72295 .33173 L
.72673 .30769 L
.74038 .28571 L
.74659 .28365 L
F
0 g
.76442 .27616 m
.78846 .28121 L
.79235 .28365 L
.81241 .30769 L
.8125 .3079 L
.81742 .33173 L
.8125 .35114 L
.81002 .35577 L
.78846 .37717 L
.76442 .37926 L
.74038 .37163 L
.72889 .35577 L
.72295 .33173 L
.72673 .30769 L
.74038 .28571 L
.74659 .28365 L
.76442 .27616 L
s
.9 g
.74038 .62837 m
.76442 .62074 L
.78846 .62283 L
.81002 .64423 L
.8125 .64886 L
.81742 .66827 L
.8125 .6921 L
.81241 .69231 L
.79235 .71635 L
.78846 .71879 L
.76442 .72384 L
.74659 .71635 L
.74038 .71429 L
.72673 .69231 L
.72295 .66827 L
.72889 .64423 L
F
0 g
.74038 .62837 m
.76442 .62074 L
.78846 .62283 L
.81002 .64423 L
.8125 .64886 L
.81742 .66827 L
.8125 .6921 L
.81241 .69231 L
.79235 .71635 L
.78846 .71879 L
.76442 .72384 L
.74659 .71635 L
.74038 .71429 L
.72673 .69231 L
.72295 .66827 L
.72889 .64423 L
.74038 .62837 L
s
1 g
.76442 .29179 m
.78846 .30272 L
.79129 .30769 L
.79913 .33173 L
.78846 .35423 L
.78656 .35577 L
.76442 .36386 L
.7519 .35577 L
.74051 .33173 L
.74755 .30769 L
F
0 g
.76442 .29179 m
.78846 .30272 L
.79129 .30769 L
.79913 .33173 L
.78846 .35423 L
.78656 .35577 L
.76442 .36386 L
.7519 .35577 L
.74051 .33173 L
.74755 .30769 L
.76442 .29179 L
s
1 g
.76442 .63614 m
.78656 .64423 L
.78846 .64577 L
.79913 .66827 L
.79129 .69231 L
.78846 .69728 L
.76442 .70821 L
.74755 .69231 L
.74051 .66827 L
.7519 .64423 L
F
0 g
.76442 .63614 m
.78656 .64423 L
.78846 .64577 L
.79913 .66827 L
.79129 .69231 L
.78846 .69728 L
.76442 .70821 L
.74755 .69231 L
.74051 .66827 L
.7519 .64423 L
.76442 .63614 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P000182000`400?l00000o`00003oo`3ooolQ
0?ooo`00C@3oool500000080oooo0P00000e0?ooo`@000000`3oool2000003L0oooo0P0000040?oo
o`800000=`3oool300000080oooo0P00000?0?ooo`00C`3oool01@000000oooo0?ooo`3oool00000
0080oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`030?ooo`040000003oool0oooo
000003D0oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000g0?ooo`040000
003oool0oooo00000080oooo00<000000?ooo`3oool0303oool004l0oooo00D000000?ooo`3oool0
oooo000000020?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`00000g0?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`0b
0?ooo`D0000000D0oooo0000003oool0oooo0000000>0?ooo`00C`3oool01@000000oooo0?ooo`3o
ool000000080oooo00<000000?ooo`3oool0=03oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool0=P3oool010000000oooo0?ooo`0000020?ooo`030000003oool0oooo0380
oooo00@000000?ooo`3oool000000P3oool010000000oooo0?ooo`00000>0?ooo`00C`3oool01@00
0000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool0<P3oool010000000oooo0?ooo`00
00020?ooo`040000003oool0oooo000003D0oooo00@000000?ooo`3oool000000P3oool010000000
oooo0?ooo`00000e0?ooo`030000003oool000000080oooo00@000000?ooo`3oool000003P3oool0
04h0oooo0P0000040?ooo`800000=P3oool2000000@0oooo0P00000g0?ooo`800000103oool20000
03L0oooo0P0000030?ooo`8000003`3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3o
ool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool001D0ooooo`000005000000L0oooo
000E0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`3o0?ooo`40oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool0o`3oool10?ooo`030000003oool0oooo00D0
oooo000E0?ooo`030000003oool0oooo0?l0oooo0@3oool00`000000oooo0?ooo`050?ooo`005@3o
ool00`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool0
0`000000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`00
0000oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo
0?ooo`020?ooooT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool2000000<0oooon@00
00040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<00000
0?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?oo
o`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3o
ool01@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool0
1@3oool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool0
01D0oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0
oooo00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<0
00000?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooooi000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo0P0000030?oo
ooT00000103oool2000000L0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003o
ool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0
oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooon@0000050?ooo`030000003oool0oooo
00D0oooo000E0?ooo`030000003oool0oooo0080oooo<000000;01TI6H@000002`0I6AT_000000D0
oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool/000001@06ATI
NP00000D01TI6B/000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?ooobX000006P0I6AUc000001T06ATI:@0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo9`00000O01TI6C@000001P0I6ATe000001h06ATI9P000005
0?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo9@00000R01TI
6Bl000003P0I6AT_000002806ATI900000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo8`00000U01TI6B`000004P0I6AT/000002D06ATI8P0000050?ooo`03
0000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo8@00000Y01TI6BT00000
500I6ATZ000002P06ATI800000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3o
oolO000002`06ATI9P00000H01TI6BH00000;00I6ATN000000@0oooo0P0000070?ooo`005@3oool0
0`000000oooo0?ooo`020?oooah00000;P0I6ATT000001X06ATI9000000^01TI6Ad000001@3oool0
0`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?ooo`020?oooad00000;`0I6ATT0000
01X06ATI9000000_01TI6A`000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000
oooo0?ooo`020?oooa/000005P0I6AT:000001806ATI8P00000L01TI6B8000004P0I6AT:000001H0
6ATI6P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo
6P00000D01TI6@<000002P0c<c<5000000h06ATI8000000N01TI6B0000003P0I6AT5000000X0<c<c
0`00000D01TI6AT000001@3oool00`000000oooo0?ooo`050?ooo`005@3oool00`000000oooo0?oo
o`020?oooaT000004P0I6AT300000180<c<c0`00000;01TI6B0000007P0I6ATP000000/06ATI0`00
000B03<c<`<000004P0I6ATH000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3ooolG000001406ATI0`00000H03<c<`8000002P0I6ATN000000l06ATI0`00000>
01TI6Ah000002P0I6AT2000001P0<c<c0`00000A01TI6AH000001@3oool00`000000oooo0?ooo`05
0?ooo`005@3oool00`000000oooo0?ooo`020?oooaH00000400I6AT2000001d0<c<c00<0000001TI
6@0I6AT01`0I6ATM000000`06ATI1000000303<c<`<000002`0I6ATM000000/06ATI00<0000003<c
<`0c<c<06P0c<c<2000001006ATI5@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo5@00000@01TI6@030000000c<c<0<c<c01h0<c<c00<0000001TI6@0I
6AT01`0I6ATL000000X06ATI0P00000:03<c<`8000002P0I6ATL000000X06ATI00<0000003<c<`0c
<c<07@0c<c<00`0000006ATI01TI6@0=01TI6AD000001@3oool00`000000oooo0?ooo`050?ooo`00
5@3oool00`000000oooo0?ooo`020?oooaD000003P0I6AT200000140<c<c1000000=03<c<`030000
000I6AT06ATI00H06ATI6`00000:01TI6@030000000c<c<0<c<c00`0<c<c0P00000801TI6A/00000
2P0I6AT00`000000<c<c03<c<`0:03<c<`@000004@0c<c<2000000h06ATI500000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo5000000>01TI6@030000000c
<c<0<c<c00`0<c<c1@00000404a<C0<000002`0c<c<00`0000006ATI01TI6@0601TI6AX00000200I
6AT200000140<c<c00<0000001TI6@0I6AT01P0I6ATJ000000P06ATI0P00000:03<c<`<00000101<
C4`5000000h0<c<c00<0000001TI6@0I6AT0300I6ATC000000D0oooo00<000000?ooo`3oool01@3o
ool001D0oooo00<000000?ooo`3oool00P3ooolC000000d06ATI0P00000<03<c<`<00000301<C4`4
000000P0<c<c00<0000001TI6@0I6AT01@0I6ATI000000P06ATI00<0000003<c<`0c<c<04P0c<c<2
000000H06ATI6P00000701TI6@030000000c<c<0<c<c00H0<c<c1000000<04a<C0<00000300c<c<2
000000d06ATI4P0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`8000000`3ooolB0000
00d06ATI00<0000003<c<`0c<c<0200c<c<4000001<0C4a<0`00000603<c<`030000000I6AT06ATI
00D06ATI6000000701TI6@030000000c<c<0<c<c01D0<c<c00<0000001TI6@0I6AT0100I6ATI0000
00H06ATI00<0000003<c<`0c<c<0100c<c<3000001<0C4a<1000000:03<c<`030000000I6AT06ATI
00`06ATI400000040?ooo`8000001`3oool001D0oooo00<000000?ooo`3oool00P3ooolA000000d0
6ATI00<0000003<c<`0c<c<01`0c<c<2000001X0C4a<00<0000003<c<`0c<c<0100c<c<00`000000
6ATI01TI6@0401TI6AP000001P0I6AT00`000000<c<c03<c<`0F03<c<`030000000I6AT06ATI00@0
6ATI6@00000501TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`0601<C4`2000000T0
<c<c00<0000001TI6@0I6AT0300I6AT?000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo
00<000000?ooo`3oool00P3ooolA000000`06ATI00<0000003<c<`0c<c<01P0c<c<2000001d0C4a<
00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0401TI6AP000001@0I6AT00`000000<c<c
03<c<`0:03<c<`<000002P0c<c<00`0000006ATI01TI6@0401TI6AP000001@0I6AT00`000000<c<c
03<c<`0503<c<`030000001<C4`0C4a<01X0C4a<0P00000803<c<`030000000I6AT06ATI00/06ATI
3`0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo4000
000<01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<C4`02@1<C4`:000000/0C4a<00<0
000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0301TI6AP000001@0I6AT00`000000<c<c03<c
<`0603<c<`@000000`1<C4`3000000P0<c<c00<0000001TI6@0I6AT00`0I6ATH000000D06ATI00<0
000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00804a<C0X000002`1<C4`00`000000<c<c03<c
<`0603<c<`030000000I6AT06ATI00/06ATI3P0000050?ooo`030000003oool0oooo00D0oooo000E
0?ooo`030000003oool0oooo0080oooo3`00000<01TI6@030000000c<c<0<c<c00H0<c<c00<00000
04a<C01<C4`01`1<C4`3000000X0IVIV1000000804a<C0030000000c<c<0<c<c0080<c<c00<00000
01TI6@0I6AT0100I6ATF000000D06ATI00<0000003<c<`0c<c<01@0c<c<2000000X0C4a<0P000006
03<c<`030000000I6AT06ATI00@06ATI5`00000401TI6@030000000c<c<0<c<c00@0<c<c00<00000
04a<C01<C4`01@1<C4`4000000X0IVIV0`00000904a<C0030000000c<c<0<c<c00H0<c<c00<00000
01TI6@0I6AT02`0I6AT=000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3oool?000000/06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00604a<
C08000004@1VIVH2000000H0C4a<00<0000003<c<`0c<c<00`0c<c<00`0000006ATI01TI6@0301TI
6AH000001@0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00`0C4a<00<0000003<c
<`0c<c<0100c<c<00`0000006ATI01TI6@0301TI6AL00000100I6AT00`000000<c<c03<c<`0303<c
<`030000001<C4`0C4a<00@0C4a<0P00000A06IVIP800000201<C4`00`000000<c<c03<c<`0603<c
<`030000000I6AT06ATI00X06ATI3@0000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`03
0000003oool0oooo0080oooo3P00000;01TI6@030000000c<c<0<c<c00H0<c<c00<0000004a<C01<
C4`01@1<C4`2000001D0IVIV0P00000504a<C0030000000c<c<0<c<c0080<c<c00<0000001TI6@0I
6AT00`0I6ATF000000@06ATI00<0000003<c<`0c<c<00`0c<c<200000100C4a<0P00000403<c<`03
0000000I6AT06ATI00<06ATI5P00000401TI6@030000000c<c<0<c<c00<0<c<c00<0000004a<C01<
C4`00`1<C4`2000001D0IVIV0P00000704a<C0030000000c<c<0<c<c00H0<c<c00<0000001TI6@0I
6AT02P0I6AT<000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool0
0P3oool=000000/06ATI00<0000003<c<`0c<c<01P0c<c<00`000000C4a<04a<C00504a<C0030000
001VIVH0IVIV00X0IVIV1000000906IVIP030000001<C4`0C4a<00<0C4a<00<0000003<c<`0c<c<0
0P0c<c<00`0000006ATI01TI6@0201TI6AH00000100I6AT00`000000<c<c03<c<`0203<c<`030000
001<C4`0C4a<0180C4a<00<0000003<c<`0c<c<00P0c<c<00`0000006ATI01TI6@0201TI6AH00000
100I6AT00`000000<c<c03<c<`0203<c<`030000001<C4`0C4a<00<0C4a<00<0000006IVIP1VIVH0
1`1VIVH4000000`0IVIV00<0000004a<C01<C4`01@1<C4`00`000000<c<c03<c<`0603<c<`030000
000I6AT06ATI00T06ATI300000050?ooo`030000003oool0oooo00D0oooo000E0?ooo`030000003o
ool0oooo0080oooo3000000;01TI6@030000000c<c<0<c<c00D0<c<c0P00000604a<C0800000201V
IVH5000000@0Ogmo0`00000706IVIP800000101<C4`01@000000<c<c03<c<`0c<c<0000000@06ATI
5P00000401TI6@050000000c<c<0<c<c03<c<`0000002P1<C4`3000000T0C4a<00D0000003<c<`0c
<c<0<c<c0000000401TI6AH00000100I6AT01@000000<c<c03<c<`0c<c<0000000D0C4a<00<00000
06IVIP1VIVH01@1VIVH3000000@0Ogmo1@00000806IVIP8000001P1<C4`2000000L0<c<c00<00000
01TI6@0I6AT02@0I6AT;000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?oo
o`3oool00P3oool<000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00404a<
C08000001`1VIVH3000000`0Ogmo0P00000706IVIP030000001<C4`0C4a<0080C4a<00D0000003<c
<`0c<c<0<c<c0000000401TI6A@00000100I6AT00`000000<c<c03<c<`0203<c<`030000001<C4`0
C4a<00@0C4a<1000000306IVIP<000001P1<C4`00`000000<c<c03<c<`0203<c<`030000000I6AT0
6ATI00806ATI5@00000301TI6@050000000c<c<0<c<c03<c<`0000001@1<C4`00`000000IVIV06IV
IP0406IVIP800000301oOgl3000000L0IVIV0P00000604a<C0030000000c<c<0<c<c00@0<c<c00<0
000001TI6@0I6AT02@0I6AT;000000D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<00000
0?ooo`3oool00P3oool;000000/06ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C004
04a<C0030000001VIVH0IVIV00D0IVIV0P00000A07moO`8000001P1VIVH01@000000C4a<04a<C01<
C4`0000000<0<c<c00<0000001TI6@0I6AT00P0I6ATD000000@06ATI00D0000003<c<`0c<c<0<c<c
0000000504a<C08000002P1VIVH2000000D0C4a<00D0000003<c<`0c<c<0<c<c0000000401TI6A@0
0000100I6AT01@000000<c<c03<c<`0c<c<0000000@0C4a<00<0000006IVIP1VIVH00`1VIVH20000
0140Ogmo0P00000706IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c<c<0100c<c<00`00
00006ATI01TI6@0901TI6@X000001@3oool00`000000oooo0?ooo`050?ooo`001`3oool500000080
oooo0P0000050?ooo`030000003oool0oooo0080oooo2P00000;01TI6@030000000c<c<0<c<c00D0
<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0506IVIP030000001oOgl0Ogmo00P0
Ogmo1000000707moO`030000001VIVH0IVIV00<0IVIV00D0000004a<C01<C4`0C4a<0000000303<c
<`030000000I6AT06ATI00806ATI5000000401TI6@050000000c<c<0<c<c03<c<`000000101<C4`0
0`000000IVIV06IVIP0<06IVIP030000001<C4`0C4a<0080C4a<00<0000003<c<`0c<c<00P0c<c<0
100000006ATI01TI6@0I6ATD000000@06ATI00@0000003<c<`0c<c<000001@1<C4`00`000000IVIV
06IVIP0206IVIP030000001oOgl0Ogmo00D0Ogmo1000000:07moO`030000001VIVH0IVIV00@0IVIV
00<0000004a<C01<C4`0101<C4`00`000000<c<c03<c<`0503<c<`030000000I6AT06ATI00T06ATI
2@0000050?ooo`030000003oool0oooo00D0oooo00090?ooo`050000003oool0oooo0?ooo`000000
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo2P00000;01TI6@030000
000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`0101<C4`00`000000IVIV06IVIP0306IVIP800000
1P1oOgl5000000@0VIVI0`00000507moO`800000101VIVH01@000000C4a<04a<C01<C4`0000000<0
<c<c00<0000001TI6@0I6AT00P0I6ATB000000@06ATI00D0000003<c<`0c<c<0<c<c0000000404a<
C0030000001VIVH0IVIV00h0IVIV0P00000304a<C0050000000c<c<0<c<c03<c<`000000100I6ATC
000000<06ATI00D0000003<c<`0c<c<0<c<c0000000404a<C0040000001VIVH0IVIV06IVIP800000
1@1oOgl3000000@0VIVI1@00000607moO`8000001@1VIVH00`000000C4a<04a<C00404a<C0030000
000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT9000000D0oooo00<000000?ooo`3oool0
1@3oool000T0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo0080oooo
0`0000020?ooo`T000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<00@0C4a<
00<0000006IVIP1VIVH00`1VIVH00`000000Ogmo07moO`0407moO`800000302IVIT2000000D0Ogmo
0P00000306IVIP040000001<C4`0C4a<000000<0<c<c00<0000001TI6@0I6AT00P0I6ATB000000@0
6ATI00D0000003<c<`0c<c<0<c<c0000000304a<C0030000001VIVH0IVIV00H0IVIV0P00000906IV
IP040000001<C4`0C4a<000000@0<c<c00@0000001TI6@0I6AT06ATI4`00000301TI6@050000000c
<c<0<c<c03<c<`0000000`1<C4`01@000000IVIV06IVIP1VIVH0000000D0Ogmo0P00000<09VIV@80
00001P1oOgl00`000000IVIV06IVIP0306IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c<`0c
<c<0100c<c<00`0000006ATI01TI6@0901TI6@P000000`3oool3000000L0oooo00090?ooo`050000
003oool0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080
oooo2000000;01TI6@030000000c<c<0<c<c00@0<c<c00<0000004a<C01<C4`0101<C4`00`000000
IVIV06IVIP0206IVIP8000001@1oOgl200000100VIVI0P00000407moO`050000001VIVH0IVIV06IV
IP0000000P1<C4`01@000000<c<c03<c<`0c<c<0000000@06ATI4P00000301TI6@050000000c<c<0
<c<c03<c<`0000000`1<C4`00`000000IVIV06IVIP0506IVIP8000000P1oOgl2000000L0IVIV00@0
000004a<C01<C4`00000100c<c<0100000006ATI01TI6@0I6ATC000000806ATI00<0000003<c<`0c
<c<00P0c<c<010000000C4a<04a<C000000306IVIP030000001oOgl0Ogmo00<0Ogmo00<0000009VI
V@2IVIT03P2IVIT2000000D0Ogmo0P00000406IVIP030000001<C4`0C4a<00@0C4a<00<0000003<c
<`0c<c<00`0c<c<00`0000006ATI01TI6@0901TI6@P000001@3oool00`000000oooo0?ooo`050?oo
o`002@3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`020?ooo`P000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<
00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0407moO`030000002IVIT0VIVI
00L0VIVI1000000709VIV@030000001oOgl0Ogmo0080Ogmo00D0000006IVIP1VIVH0IVIV00000002
04a<C0050000000c<c<0<c<c03<c<`0000000`0I6ATB000000<06ATI00D0000003<c<`0c<c<0<c<c
0000000304a<C0030000001VIVH0IVIV00<0IVIV0P00000607moO`8000001P1VIVH010000000C4a<
04a<C000000303<c<`040000000I6AT06ATI01TI6A8000000`0I6AT01@000000<c<c03<c<`0c<c<0
00000080C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0207moO`030000002IVIT0
VIVI00@0VIVI1000000909VIV@030000001oOgl0Ogmo00@0Ogmo00<0000006IVIP1VIVH00P1VIVH0
0`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0000001TI6@0I6AT02@0I6AT7
000000D0oooo00<000000?ooo`3oool01@3oool000P0oooo0P0000040?ooo`8000001@3oool00`00
0000oooo0?ooo`020?ooo`L000002`0I6AT00`000000<c<c03<c<`0403<c<`030000001<C4`0C4a<
00<0C4a<00<0000006IVIP1VIVH00P1VIVH00`000000Ogmo07moO`0407moO`030000002IVIT0VIVI
00@0VIVI100000040;>c/`<000001@2IVIT01@000000Ogmo07moO`1oOgl0000000<0IVIV00@00000
04a<C01<C4`000000`0c<c<0100000006ATI01TI6@0I6ATA000000@06ATI00@0000003<c<`0c<c<0
00000`1<C4`00`000000IVIV06IVIP0206IVIP8000002P1oOgl2000000@0IVIV00@0000004a<C01<
C4`000000`0c<c<0100000006ATI01TI6@0I6ATB000000<06ATI00D0000003<c<`0c<c<0<c<c0000
000204a<C0050000001VIVH0IVIV06IVIP0000000`1oOgl2000000@0VIVI0`0000040;>c/`@00000
1P2IVIT00`000000Ogmo07moO`0407moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`0
0`1<C4`00`000000<c<c03<c<`0403<c<`030000000I6AT06ATI00P06ATI1`0000050?ooo`030000
003oool0oooo00D0oooo000E0?ooo`030000003oool0oooo0080oooo1`00000;01TI6@030000000c
<c<0<c<c00<0<c<c00<0000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001o
Ogl0Ogmo00<0Ogmo0P00000509VIV@8000002`2c/k<2000000@0VIVI0P00000207moO`050000001V
IVH0IVIV06IVIP0000000P1<C4`010000000<c<c03<c<`00000401TI6A0000000`0I6AT01@000000
<c<c03<c<`0c<c<0000000<0C4a<00D0000006IVIP1VIVH0IVIV0000000>07moO`030000001VIVH0
IVIV0080IVIV00@0000004a<C01<C4`000000P0c<c<00`0000006ATI01TI6@0201TI6A4000000`0I
6AT01`000000<c<c03<c<`0c<c<0000004a<C00000000`1VIVH01@000000Ogmo07moO`1oOgl00000
00@0VIVI0P00000;0;>c/`8000001@2IVIT2000000@0Ogmo00<0000006IVIP1VIVH00`1VIVH00`00
0000C4a<04a<C00304a<C0030000000c<c<0<c<c00<0<c<c00<0000001TI6@0I6AT02@0I6AT60000
00D0oooo00<000000?ooo`3oool01@3oool001D0oooo00<000000?ooo`3oool00P3oool7000000X0
6ATI00<0000003<c<`0c<c<0100c<c<00`000000C4a<04a<C00304a<C0030000001VIVH0IVIV0080
IVIV00<0000007moO`1oOgl00P1oOgl00`000000VIVI09VIV@0309VIV@8000003`2c/k<2000000@0
VIVI00<0000007moO`0000000`1VIVH010000000C4a<04a<C000000303<c<`040000000I6AT06ATI
01TI6A0000000`0I6AT010000000<c<c03<c<`00000304a<C0050000001VIVH0IVIV06IVIP000000
1`1oOgl3000000H0Ogmo00D0000006IVIP1VIVH0IVIV0000000204a<C0050000000c<c<0<c<c03<c
<`0000000`0I6AT@000000@06ATI00@0000003<c<`0c<c<000000P1<C4`01@000000IVIV06IVIP1V
IVH000000080Ogmo00@0000009VIV@2IVIT0VIVI0P00000?0;>c/`8000001@2IVIT00`000000Ogmo
07moO`0207moO`030000001VIVH0IVIV0080IVIV00<0000004a<C01<C4`00`1<C4`00`000000<c<c
03<c<`0403<c<`030000000I6AT06ATI00P06ATI1P0000050?ooo`030000003oool0oooo00D0oooo
000E0?ooo`030000003oool0oooo0080oooo1`00000:01TI6@030000000c<c<0<c<c00<0<c<c00<0
000004a<C01<C4`00`1<C4`00`000000IVIV06IVIP0206IVIP030000001oOgl0Ogmo0080Ogmo00<0
000009VIV@2IVIT00P2IVIT2000000P0/k>c100000070;>c/`050000002IVIT0VIVI09VIV@000000
0P1oOgl010000000IVIV06IVIP00000304a<C0040000000c<c<0<c<c000000<06ATI4000000301TI
6@040000000c<c<0<c<c000000<0C4a<00@0000006IVIP1VIVH000001P1oOgl2000000<0VIVI0P00
000507moO`040000001VIVH0IVIV000000<0C4a<00@0000003<c<`0c<c<000000`0I6AT@000000@0
6ATI00@0000003<c<`0c<c<000000P1<C4`010000000IVIV06IVIP00000207moO`050000002IVIT0
VIVI09VIV@0000001`2c/k<4000000P0/k>c0P00000409VIV@030000001oOgl0Ogmo0080Ogmo00<0
000006IVIP1VIVH00P1VIVH00`000000C4a<04a<C00304a<C0030000000c<c<0<c<c00@0<c<c00<0
000001TI6@0I6AT01`0I6AT6