(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5148,        113]*)
(*NotebookOutlinePosition[      5791,        135]*)
(*  CellTagsIndexPosition[      5747,        131]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
L12MOCY5to9S
  
Cylindircal Coordinates for circular mirrors in confocal resonator.Field \
distribution as contour plot of 02 to 20.
The L(l,p) functions are written out for 00 to 22. The constant in the \
exponential is X.\
\>"], "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
        "*)"}], "\[IndentingNewLine]", \(n = 30;\)}], "\[IndentingNewLine]", 
    RowBox[{\(X\  = \ 2;\), 
      " "}], "\[IndentingNewLine]", \(xi[i_] := \ \(-4\)\  + \ 
          0.30001*i;\), "\[IndentingNewLine]", 
    RowBox[{\(yj[j_] := \ \(-4\)\  + \ 0.30001*j;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(R[x_, y_] := \ 
        x\^2 + y\^2;\), "\[IndentingNewLine]", \(\[Beta][x_, 
          y_] := \ \((ArcTan[x\/y])\);\), "\[IndentingNewLine]", 
    RowBox[{\(q[x_, 
            y_] := \ \((\[ExponentialE]\^\(\(-\((R[x, y])\)\)\/X\))\);\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
There h stands for l and p from 0 to 2,all formulas are written below.
L h2(x,y)=[1/2(h+1)(h+2)-(h+2)u(x,y)]+1/2u(x,y)^2\
\>"], "\[IndentingNewLine]", 
        "*)"}]}], "\[IndentingNewLine]", \(u[x_, y_] := \ 
        4*R[x, y]\/X;\), "\[IndentingNewLine]", 
    RowBox[{\(g[x_, y_] := \ Cos[0*\[Beta][x, y]];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(L02[x_, y_] := \ 
        1 - 2*u[x, y] + 1\/2*u[x, y]\^2;\), "\[IndentingNewLine]", \(L22[x_, 
          y_] := \ 6 - 4*u[x, y] + 
          1\/2*u[x, y]\^2;\), "\[IndentingNewLine]", \(L12[x_, y_] := \ 
        3 - 3*u[x, y] + 1\/2*u[x, y]\^2;\), "\[IndentingNewLine]", \(L21[x_, 
          y_] := \ 3 - u[x, y];\), "\[IndentingNewLine]", 
    RowBox[{\(L20[x_, y_] := \ 1;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(M02\  = \ 
          Table[\((Cos[2*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L20[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 1}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(M20\  = \ 
        Table[\((Cos[0*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L02[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 
            1}];\), "\[IndentingNewLine]", \(M12\  = \ 
        Table[\((Cos[2*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L21[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 
            1}];\), "\[IndentingNewLine]", \(M21\  = \ 
        Table[\((Cos[1*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L12[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 1}];\), "\[IndentingNewLine]", 
    RowBox[{\(M22\  = \ 
          Table[\((Cos[2*\[Beta][xi[i], yj[j]]]*q[xi[i], yj[j]]*L22[xi[i], \
yj[j]])\)\^2, {i, 0, n, 1}, {j, 0, n, 1}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ListPlot3D[M02, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 0.7}}, 
        PlotLabel -> "\<M02\>"];\), "\[IndentingNewLine]", \(ListPlot3D[M20, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 7}}, 
        PlotLabel -> "\<M20\>"];\), "\[IndentingNewLine]", \(ListPlot3D[M12, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 4.5}}, 
        PlotLabel -> "\<M12\>"];\), "\[IndentingNewLine]", \(ListPlot3D[M21, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 4.5}}, 
        PlotLabel -> "\<M21\>"];\), "\[IndentingNewLine]", \(ListPlot3D[M22, 
        PlotRange \[Rule] {{0, n}, {0, n}, {0, 14}}, 
        PlotLabel -> "\<M22\>"];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 537},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3439, 61, 1475, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

