(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4404,        107]*)
(*NotebookOutlinePosition[      5048,        129]*)
(*  CellTagsIndexPosition[      5004,        125]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
L3BBFS
    
1. Black body Radiation. Graph of f(\[Nu]) = dL/d\[Nu], \[Nu] is frequency

2. Integration over the wavelength range from 10^14 to 10^13 1/s to obtain \
the Radiance.
    
3. Multiplication with area times solid angle to obtain the Radiant energy.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\), 
      "\[IndentingNewLine]", \( (*\ 
        1. \ Black\ body\ Radiation . Graph\ of\ dL/
            d\[Nu]\ and\ \[Nu]\ is\ frequency\n*) \)}], \
"\[IndentingNewLine]", \(T\  = \ 1000;\), "\[IndentingNewLine]", \(c3 = \ 
        1.47*10\^\(-50\);\), "\[IndentingNewLine]", \(c4\  = 
        4.78*10\^\(-11\);\), "\[IndentingNewLine]", 
    RowBox[{\(\[Nu]\  = \ Range[5*10\^14, 10\^12, \(-0.01\)*10\^14];\), " ", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Planck' s\ Law\ depending\ on\ frequency\ *) \)}], "\
\[IndentingNewLine]", 
    RowBox[{\(f[x_] := \ 
          c3\/\((\[ExponentialE]\^\((\(c4*\[Nu]\)\/T)\) - 1)\)*\[Nu]\^3;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{\[Nu], f[\[Nu]]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<\[Nu]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 5*10\^14}, {0, 2*10\^\(-10\)}}], {{{Hue[
                  1], "\<f[\[Nu]]\>"}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
2. Integration over the frequency range from 10^14 to 10^13 to obtain 
the Radiance.\
\>"], " ", "*)"}], "  ", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Radiant\ Energy\ *) \)}], "\[IndentingNewLine]", \(R = \ 
        NIntegrate[\ 
          f[\[Nu]], {\[Nu], \ \ 10\^13, 10\^14}];\), "\[IndentingNewLine]", 
    RowBox[{\( (*\ Radiance\ \ R\  = \ 1.316*10^4\ *) \), 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
3. Multiplication with area times solid angle to obtain the Radiant energy.
Area A,Solid angle SA\
\>"], "\[IndentingNewLine]", "*)"}]}], "\[IndentingNewLine]", \(A = \ 
        0.1;\), "\[IndentingNewLine]", \(SA\  = \ 4;\), "\[IndentingNewLine]",
   
    RowBox[{\(RR\  = \ A*SA*R;\), 
      " ", \( (*\ Radiant\ energy\ RR\ \ \ RR = \ 
          5.263*10^3\ Watts\ *) \)}], "\[IndentingNewLine]", \( (*\ 
      RR\ has\ the\ same\ value\ as\ the\ corresponding\ value\ when\ \
integrating\ over\ \(\(wavelength\)\(.\)\)\ *) \)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{1016, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2695, 55, 867, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

