(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3164,         82]*)
(*NotebookOutlinePosition[      3808,        104]*)
(*  CellTagsIndexPosition[      3764,        100]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
L6BANDS
Lorentian Line shape\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(m\  = \ 11;\), 
      "  ", \( (*\ 
        Frequency\ interval\ *) \)}], "\[IndentingNewLine]", \(\[Omega]0\  = \
\ 49\/\((2\^m - 1)\);\), "\[IndentingNewLine]", 
    RowBox[{\(\[Omega] = Range[1\/\((2\^m - 1)\), 1, 1\/\((2\^m - 1)\)];\), 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", Cell["\<\
To make a graph the life time is chosen such that the Lorentzian line shape \
can be demonstrated.\
\>"], " ", "*)"}], 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(\[Tau]\  = \ 
        1000;\), "\[IndentingNewLine]", \(g1[\[Omega]_] := 
        2*\(1\/\((2*\[Tau])\)\)\/\(1\/\((2*\[Tau])\)\^2 + \((\[Omega] - \
\[Omega]0)\)\^2\);\), "\[IndentingNewLine]", 
    RowBox[{\(Q\  = \ \[Tau]*\[Omega]0\ ;\), \( (*\ Q\  = \ 23.937\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Omega], g1[\[Omega]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Omega]\>", "\<\>"}, 
          PlotRange \[Rule] {{0.01, 0.04}, {0, 4000}}], {{{Hue[
                1], "\<g1[\[Omega]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 599},
WindowMargins->{{Automatic, 37}, {Automatic, 5}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 1455, 30, 521, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

