(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4411,        102]*)
(*NotebookOutlinePosition[      5055,        124]*)
(*  CellTagsIndexPosition[      5011,        120]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
O1FRNKPSS
  
Complex reflection coefficients of Fresnel' formulas as function of angle of \
incidence for values of n2 and K.
    
Absolute value and imaginary parts are plotted.
Complex reflection coefficients zrp for parallel and zrs for perpendicular \
case.\
\>"], "\n", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n2\  = \ 
        1.5;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[0, 90, 1];\), "\[IndentingNewLine]", \(K\  = \ 
        2;\), "\[IndentingNewLine]", \(i\  = \ 
        Sqrt[\(-1\)];\), "\[IndentingNewLine]", \(zrp[\[Theta]_] := \ \
\((\((\(n2 - i*K\)\/n1)\)*
                Cos[2*\((Pi\/360)\)*\[Theta]] - \@\(1 - \((\((n1\/\(n2 - \
i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((\((\(n2 - i*K\)\/n1)\)*
                Cos[2*\((Pi\/360)\)*\[Theta]] + \@\(1 - \((\((n1\/\(n2 - \
i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\), "\[IndentingNewLine]", 
    RowBox[{\(zrs[\[Theta]_] := \ \((Cos[
                  2*\((Pi\/360)\)*\[Theta]] - \((\(n2 - i*K\)\/n1)\)*\@\(1 - \
\((\((n1\/\(n2 - i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((Cos[
                  2*\((Pi\/360)\)*\[Theta]] + \((\(n2 - i*K\)\/n1)\)*\@\(1 - \
\((\((n1\/\(n2 - i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], Abs[zrp[\[Theta]]]}], 
            Transpose[{\[Theta], Abs[zrs[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {\(-1\), 1}}], {{{Hue[
                  1], "\<Abs[zrp[\[Theta]]]\>"}, {Hue[
                  0.5], "\<Abs[zrs[\[Theta]]]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta], Arg[zrp[\[Theta]]]}], 
          Transpose[{\[Theta], Arg[zrs[\[Theta]]]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 100}, {\(-3.5\), 3.5}}], {{{Hue[
                1], "\<Arg[zrp[\[Theta]]]\>"}, {Hue[
                0.5], "\<Arg[zrs[\[Theta]]]\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{674, 586},
WindowMargins->{{10, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2702, 50, 770, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

