(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10086,        197]*)
(*NotebookOutlinePosition[     10731,        219]*)
(*  CellTagsIndexPosition[     10687,        215]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
O2FRSOPS
Graphs of Ratios of reflection coefficients

Reflection coefficients of Fresnel's formulas as function of angle 
of incidence for n and K.  Real part and ratios of real parts are plotted.

Complex zrp, zzrp, zzzrp  for parallel and 
zrs, zzrs, zzzrs for perpendicular case.    \
\>"], "\n", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", 
    RowBox[{\(i\  = \ Sqrt[\(-1\)];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n2\  = \ 
        1.5;\), "\[IndentingNewLine]", \(nn2\  = \ 
        3;\), "\[IndentingNewLine]", \(\[Theta]\  = \ 
        Range[0, 90, 1.5];\), "\[IndentingNewLine]", \(K\  = 
        0.1;\), "\[IndentingNewLine]", \(KK\  = \ 
        0.5;\), "\[IndentingNewLine]", 
    RowBox[{\(KKK\  = \ 2;\), "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        K\  = 0\ *) \)}], "\[IndentingNewLine]", \(zrp0[\[Theta]_] := \ \
\((\((n2\/n1)\)*
                Cos[2*\((Pi\/360)\)*\[Theta]] - \@\(1 - \
\((\((n1\/n2)\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((\((n2\/n1)\)*
                Cos[2*\((Pi\/360)\)*\[Theta]] + \@\(1 - \
\((\((n1\/n2)\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(zrs0[\[Theta]_] := \ \((Cos[
                  2*\((Pi\/360)\)*\[Theta]] - \((n2\/n1)\)*\@\(1 - \((\((n1\/\
\(n2 - i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((Cos[
                  2*\((Pi\/360)\)*\[Theta]] + \((n2\/n1)\)*\@\(1 - \
\((\((n1\/n2)\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\( (*\ 
        K\ not\ 0\ *) \), \(zrp[\[Theta]_] := \ \((\((\(n2 - i*K\)\/n1)\)*
                  Cos[2*\((Pi\/360)\)*\[Theta]] - \@\(1 - \((\((n1\/\(n2 - \
i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((\((\(n2 - i*K\)\/n1)\)*
                  Cos[2*\((Pi\/360)\)*\[Theta]] + \@\(1 - \((\((n1\/\(n2 - \
i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\)}], "\[IndentingNewLine]",
   
    RowBox[{\(zrs[\[Theta]_] := \ \((Cos[
                  2*\((Pi\/360)\)*\[Theta]] - \((\(n2 - i*K\)\/n1)\)*\@\(1 - \
\((\((n1\/\(n2 - i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((Cos[
                  2*\((Pi\/360)\)*\[Theta]] + \((\(n2 - i*K\)\/n1)\)*\@\(1 - \
\((\((n1\/\(n2 - i*K\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\( (*\ 
        For\ different\ n\ and\ K\ *) \), \(zzrp[\[Theta]_] := \ \((\((\(nn2 \
- i*KK\)\/n1)\)*Cos[
                    2*\((Pi\/360)\)*\[Theta]] - \@\(1 - \((\((n1\/\(nn2 - \
i*KK\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((\((\(nn2 - \
i*KK\)\/n1)\)*Cos[
                    2*\((Pi\/360)\)*\[Theta]] + \@\(1 - \((\((n1\/\(nn2 - \
i*KK\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\)}], \
"\[IndentingNewLine]", 
    RowBox[{\(zzrs[\[Theta]_] := \ \((Cos[
                  2*\((Pi\/360)\)*\[Theta]] - \((\(nn2 - i*KK\)\/n1)\)*\@\(1 \
- \((\((n1\/\(nn2 - i*KK\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((Cos[
                  2*\((Pi\/360)\)*\[Theta]] + \((\(nn2 - i*KK\)\/n1)\)*\@\(1 \
- \((\((n1\/\(nn2 - i*KK\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(zzzrp[\[Theta]_] := \ \
\((\((\(nn2 - i*KKK\)\/n1)\)*
                Cos[2*\((Pi\/360)\)*\[Theta]] - \@\(1 - \((\((n1\/\(nn2 - \
i*KKK\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((\((\(nn2 - \
i*KKK\)\/n1)\)*
                Cos[2*\((Pi\/360)\)*\[Theta]] + \@\(1 - \((\((n1\/\(nn2 - \
i*KKK\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\), "\[IndentingNewLine]",
   
    RowBox[{\(zzzrs[\[Theta]_] := \ \((Cos[
                  2*\((Pi\/360)\)*\[Theta]] - \((\(nn2 - i*KKK\)\/n1)\)*\@\(1 \
- \((\((n1\/\(nn2 - \
i*KKK\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\)/\((Cos[
                  2*\((Pi\/360)\)*\[Theta]] + \((\(nn2 - i*KKK\)\/n1)\)*\@\(1 \
- \((\((n1\/\(nn2 - i*KKK\))\)*Sin[2*\((Pi\/360)\)*\[Theta]])\)\^2\))\);\), 
      "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], Re[zrp0[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zrp[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zzrp[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zzzrp[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {\(-1\), 1}}], {{{Hue[
                  1], "\<Re[zrp0[\[Theta]]]\>"}, {Hue[
                  0.5], "\<Re[zrp[\[Theta]]]\>"}, {Hue[
                  0.25], "\<Re[zzrp[\[Theta]]]\>"}, {Hue[
                  0.1], "\<zzzrp[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta], Re[zrs0[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zrs[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zzrs[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zzzrs[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {\(-1\), 1}}], {{{Hue[
                  1], "\<Re[zrs0[\[Theta]]]\>"}, {Hue[
                  0.5], "\<Re[zrs[\[Theta]]]\>"}, {Hue[
                  0.25], "\<Re[zzrs[\[Theta]]]\>"}, {Hue[
                  0.1], "\<zzzrs[\[Theta]]]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Ratios : \ p/s\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[
            Transpose[{\[Theta], Re[zrp0[\[Theta]]]\/Re[zrs0[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zrp[\[Theta]]]\/Re[zrs[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zzrp[\[Theta]]]\/Re[zzrs[\[Theta]]]}], 
            Transpose[{\[Theta], Re[zzzrp[\[Theta]]]\/Re[zzzrs[\[Theta]]]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
            AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(Re[zrp0[\[Theta]]]\/Re[zrs0[\[Theta]]]\)\>\"\
"}, {Hue[0.5], \*"\"\<\!\(Re[zrp[\[Theta]]]\/Re[zrs[\[Theta]]]\)\>\""}, {Hue[
                  0.25], \*"\"\<\!\(Re[zzrp[\[Theta]]]\/Re[zzrs[\[Theta]]]\)\>\
\""}, {Hue[
                  0.1], \*"\"\<\!\(Re[zzzrp[\[Theta]]]\/Re[zzzrs[\[Theta]]]\)\
\>\""}}, LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Ratios : \ s/p\ *) \)}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[
          Transpose[{\[Theta], Re[zrs0[\[Theta]]]\/Re[zrp0[\[Theta]]]}], 
          Transpose[{\[Theta], Re[zrs[\[Theta]]]\/Re[zrp[\[Theta]]]}], 
          Transpose[{\[Theta], Re[zzrs[\[Theta]]]\/Re[zzrp[\[Theta]]]}], 
          Transpose[{\[Theta], Re[zzzrs[\[Theta]]]\/Re[zzzrp[\[Theta]]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 100}, {\(-300\), 200}}], {{{Hue[
                1], \*"\"\<\!\(Re[zrs0[\[Theta]]]\/Re[zrp0[\[Theta]]]\)\>\""},\
 {Hue[0.5], \*"\"\<\!\(Re[zrs[\[Theta]]]\/Re[zrp[\[Theta]]]\)\>\""}, {Hue[
                0.25], \*"\"\<\!\(Re[zzrs[\[Theta]]]\/Re[zzrp[\[Theta]]]\)\>\"\
"}, {Hue[0.1], \*"\"\<\!\(Re[zzzrs[\[Theta]]]\/Re[zzzrp[\[Theta]]]\)\>\""}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{676, 586},
WindowMargins->{{129, Automatic}, {Automatic, 7}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 8377, 145, 2527, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

