(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      3992,         97]*)
(*NotebookOutlinePosition[      4637,        119]*)
(*  CellTagsIndexPosition[      4593,        115]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
O8ARDELS

Graph of difference of argument of p and s case of Fresnel's Formulas with \
Absorption 

Calculation of real part and argument of parallel zrp and perpendicular zrs \
case
of Fresnel's formulas with absorption.  We assume zrs = rs exp ids and zrp = \
rp exp idp and the argument as function of \[Theta].

The difference of the angle of the two components of the reflected light is \
plotted.
This angle is the angle discussed in chapter 5 for light elliptically \
polarized  by reflection.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(i\  = \ 
        Sqrt[\(-1\)];\), "\[IndentingNewLine]", \(\(\[Theta]\  = \ 
          Range[0, 89.9, 1];\);\), "\[IndentingNewLine]", \(n1\  = \ 
        1;\), "\[IndentingNewLine]", \(n2\  = \ 3;\), "\[IndentingNewLine]", 
    RowBox[{\(K = \ 5;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(zrp[\[Theta]_] := \ \
\((\((\(n2 - i*K\)\/n1)\)*
                Cos[2*Pi\/360*\[Theta]] - \@\(1 - \((\((n1\/\(n2 - \
i*K\))\)*Sin[2*Pi\/360*\[Theta]])\)\^2\))\)/\((\((\(n2 - i*K\)\/n1)\)*
                Cos[2*Pi\/360*\[Theta]] + \@\(1 - \((\((n1\/\(n2 - \
i*K\))\)*Sin[2*Pi\/360*\[Theta]])\)\^2\))\);\), "\[IndentingNewLine]", \(zrs[\
\[Theta]_] := \ \((Cos[
                2*Pi\/360*\[Theta]] - \((\(n2 - i*K\)\/n1)\)*\@\(1 - \((\((n1\
\/\(n2 - i*K\))\)*Sin[2*Pi\/360*\[Theta]])\)\^2\))\)/\((Cos[
                2*Pi\/360*\[Theta]] + \((\(n2 - i*K\)\/n1)\)*\@\(1 - \((\((n1\
\/\(n2 - i*K\))\)*Sin[2*Pi\/360*\[Theta]])\)\^2\))\);\), \
"\[IndentingNewLine]", 
    RowBox[{\(arg\[CapitalDelta][\[Theta]_] := \ 
          Arg[zrs[\[Theta]]] - Arg[zrp[\[Theta]]] - Pi;\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{\[Theta], arg\[CapitalDelta][\[Theta]]}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<\[Theta]\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 100}, {\(-0.5\), 6.5}}], {{{Hue[
                1], "\<arg\[CapitalDelta][\[Theta]]\>"}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{496, 602},
WindowMargins->{{Automatic, -2}, {Automatic, -4}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 2283, 45, 1146, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

