(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7057,        145]*)
(*NotebookOutlinePosition[      7700,        167]*)
(*  CellTagsIndexPosition[      7656,        163]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
OA2METPDS
  
Calculation of n and K from input values P and D for exact and approximate \
expressions\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< 
        Graphics`Legend`\)}], "\[IndentingNewLine]", \(<< 
      Graphics`MultipleListPlot`\), "\[IndentingNewLine]", \(i\  = \ 
        Sqrt[\(-1\)];\), "\[IndentingNewLine]", \(\[CapitalDelta]\  = \ 
        114;\), "\[IndentingNewLine]", \(P\  = \ 
        0.50;\), "\[IndentingNewLine]", 
    RowBox[{\(\[CurlyPhi]\  = \ ArcTan[P];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(k\  = \ 
        Range[1, 40, 1];\), "\[IndentingNewLine]", 
    RowBox[{\(\[Theta]\_k = \ k*2;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        1. \ Exact\ Expression\ *) \)}], "\[IndentingNewLine]", \(z\_k = \
\[Sqrt]\((Sin[\(2*Pi*\[Theta]\_k\)\/360]\^2 + \((\((\((Cos[2*\[CurlyPhi]] + \
i*Sin[\(2*Pi*\[CapitalDelta]\)\/360]*Sin[2*\[CurlyPhi]])\)*\((Sin[\(2*Pi*\
\[Theta]\_k\)\/360]\^2)\))\)/\((Cos[\(2*Pi*\[Theta]\_k\)\/360]*\((Cos[\(2*Pi*\
\[CapitalDelta]\)\/360]*Sin[2*\[CurlyPhi]] + 1)\))\))\)\^2)\);\), "\
\[IndentingNewLine]", \(n\_k = Re[z\_k];\), "\[IndentingNewLine]", 
    RowBox[{\(K\_k = Im[z\_k];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ For\ the\ approximation\ one\ disregards\ the\ sin^2\ term\ *) \
\), "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(z1\_k = \
\[Sqrt]\((\((\((\((Cos[2*\[CurlyPhi]] + \
i*Sin[\(2*Pi*\[CapitalDelta]\)\/360]*Sin[2*\[CurlyPhi]])\)*\((Sin[\(2*Pi*\
\[Theta]\_k\)\/360]\^2)\))\)/\((Cos[\(2*Pi*\[Theta]\_k\)\/360]*\((Cos[\(2*Pi*\
\[CapitalDelta]\)\/360]*Sin[2*\[CurlyPhi]] + 1)\))\))\)\^2)\);\), "\
\[IndentingNewLine]", \(nn\_k = Re[z1\_k];\), "\[IndentingNewLine]", 
    RowBox[{\(KK\_k = Im[z1\_k];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 3. \ Comparison\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta]\_k, Re[z\_k]}], 
            Transpose[{\[Theta]\_k, Re[z1\_k]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {\*"\"\<\!\(\[Theta]\_k\)\>\"", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {0, 4}}], {{{Hue[
                  1], \*"\"\<Re[\!\(z\_k\)]\>\""}, {Hue[
                  0.5], \*"\"\<Re[\!\(z1\_k\)]\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta]\_k, Im[z\_k]}], 
            Transpose[{\[Theta]\_k, Im[z1\_k]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {\*"\"\<\!\(\[Theta]\_k\)\>\"", "\<\>"}, 
            PlotRange \[Rule] {{0, 100}, {0, 8}}], {{{Hue[
                  1], \*"\"\<Im[\!\(z\_k\)]\>\""}, {Hue[
                  0.5], \*"\"\<Im[\!\(z1\_k\)]\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        4. \ The\ approximation\ can\ be\ written\ as\ two\ real\ expressions\
\ *) \)}], "\[IndentingNewLine]", \(nn\_k = \((Sin[\(2*Pi*\[Theta]\_k\)\/360]\
\^2*Cos[2*\[CurlyPhi]])\)\/\(Cos[\(2*Pi*\[Theta]\_k\)\/360]*\((1 + \
Cos[\(2*Pi*\[CapitalDelta]\)\/360]*Sin[2*\[CurlyPhi]])\)\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(KK\_k = \ \(Sin[\(2*Pi*\[Theta]\_k\)\/360]\^2*\((Sin[\
\[CapitalDelta]]*Sin[2*\[CurlyPhi]])\)\)\/\(Cos[\(2*Pi*\[Theta]\_k\)\/360]*\((\
1 + Cos[\(2*Pi*\[CapitalDelta]\)\/360]*Sin[2*\[CurlyPhi]])\)\);\), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 5. \ Comparison\ of\ all\ three\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{\[Theta]\_k, nn\_k}], 
            Transpose[{\[Theta]\_k, Re[z\_k]}], 
            Transpose[{\[Theta]\_k, Re[z1\_k]}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {\*"\"\<\!\(\[Theta]\_k\)\>\"", "\<\>"}, 
            PlotRange \[Rule] {{0, 80}, {0, 2}}], {{{Hue[
                  1], \*"\"\<\!\(nn\_k\)\>\""}, {Hue[
                  0.5], \*"\"\<Re[\!\(z\_k\)]\>\""}, {Hue[
                  0.25], \*"\"\<Re[\!\(z1\_k\)]\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{\[Theta]\_k, KK\_k}], 
          Transpose[{\[Theta]\_k, Im[z\_k]}], 
          Transpose[{\[Theta]\_k, Im[z1\_k]}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {\*"\"\<\!\(\[Theta]\_k\)\>\"", "\<\>"}, 
          PlotRange \[Rule] {{0, 80}, {0, 8}}], {{{Hue[
                1], \*"\"\<\!\(KK\_k\)\>\""}, {Hue[
                0.5], \*"\"\<Im[\!\(z\_k\)]\>\""}, {Hue[
                0.25], \*"\"\<Im[\!\(z1\_k\)]\>\""}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{490, 525},
WindowMargins->{{9, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 5348, 93, 1829, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

