(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4751,        110]*)
(*NotebookOutlinePosition[      5395,        132]*)
(*  CellTagsIndexPosition[      5351,        128]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F10FTGAUSGS
Complex Fourier transformation of Gauss function for 
two values of a and for general Fourier Transformation .
The maximum is at i = 0. The FT of the FT is also calculated.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(<< Graphics`MultipleListPlot`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(i\  = \ 
        Range[0, 325, 1];\), "\[IndentingNewLine]", \(A\  = \ 
        1;\), "\[IndentingNewLine]", \(a\  = \ 100;\), "\[IndentingNewLine]", 
  
    RowBox[{\(aa\  = \ 50;\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Original\ function\ *) \)}], "\[IndentingNewLine]", \(y1\_i = \ 
        A*\[ExponentialE]\^\(\(-a\)*\((\((i\/255)\)\^2)\)\);\), "\
\[IndentingNewLine]", \(y2\_i = \ 
        A*\[ExponentialE]\^\(\(-aa\)*\((\((i\/255)\)\^2)\)\);\), "\
\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i/255, y2\_i}], 
            Transpose[{i/255, y1\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<i/255\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 1.5}, {0, 1}}], {{{Hue[
                  1], \*"\"\<\!\(y2\_i\)\>\""}, {Hue[
                  0.5], \*"\"\<\!\(y1\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Fourier\ transform\ *) \)}], "\[IndentingNewLine]", \(c1\  = \ 
        Fourier[y1\_i];\), "\[IndentingNewLine]", 
    RowBox[{\(c2\  = \ Fourier[y2\_i];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i, Re[c1]}], Transpose[{i, Re[c2]}], 
            PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 400}, {0, 3}}], {{{Hue[
                  1], "\<Re[c1]\>"}, {Hue[0.5], "\<Re[c2]\>"}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        Fourier\ transform\ \((inverse)\)\ of\ Fourier\ transform\ *) \)}], "\
\[IndentingNewLine]", \(zf1\  = \ 
        InverseFourier[c1];\), "\[IndentingNewLine]", 
    RowBox[{\(zf2\  = \ InverseFourier[c2];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{i/255, zf1}], Transpose[{i/255, zf2}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5]}, 
          AxesLabel \[Rule] {"\<i/255\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 0.6}, {0, 1}}], {{{Hue[1], "\<zf1\>"}, {Hue[
                0.5], "\<zf2\>"}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{455, 599},
WindowMargins->{{Automatic, 99}, {Automatic, 8}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3042, 58, 1176, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

