(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5141,        115]*)
(*NotebookOutlinePosition[      5786,        137]*)
(*  CellTagsIndexPosition[      5742,        133]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F12FTDISC1S
    
Graph of cosine functions depending on i=1,2,3....and frequencies \
1/128,2/128....to 130/128. Look for the repetition.
      
Length interval is i=1,2,3...\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(<< Graphics`MultipleListPlot`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(i\  = \ Range[0, 140, 1];\), 
      "\[IndentingNewLine]", \( (*\ 1.  Frequencies\ f\  = \ 1/128, \ 
        2/128, \ 3/128\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y1\_i = 
        Cos[2*Pi*1\/128*i];\), "\[IndentingNewLine]", \(y2\_i = 
        Cos[2*Pi*2\/128*i];\), "\[IndentingNewLine]", 
    RowBox[{\(y3\_i = Cos[2*Pi*3\/128*i];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i, y1\_i}], Transpose[{i, y2\_i}], 
            Transpose[{i, y3\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 140}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(y1\_i\)\>\""}, {Hue[
                  0.5], \*"\"\<\!\(y2\_i\)\>\""}, {Hue[
                  0.25], \*"\"\<\!\(y3\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        2. \ Frequency\ 64/128\ *) \)}], "\[IndentingNewLine]", \(y64\_i = 
        Cos[2*Pi*64\/128*i];\), "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, y64\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange -> {{0, 140}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(y64\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 3. \ Frequencies\ 127/128, \ 128/128, \ 
        129/128, \ 130, 128\ *) \)}], "\[IndentingNewLine]", \(y127\_i = 
        Cos[2*Pi*127\/128*i];\), "\[IndentingNewLine]", 
    RowBox[{\(y128\_i = Cos[2*Pi*128\/128*i];\), \( (*\ 
        Will\ not\ show\ up\ on\ the\ graph\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(y129\_i = Cos[2*Pi*129\/128*i];\), \( (*\ 
        Same\ as\ 127/128\ and\ 1/128\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(y130\_i = Cos[2*Pi*130\/128*i];\), 
      " ", \( (*\ Same\ as\ 2/128\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{i, y127\_i}], Transpose[{i, y128\_i}], 
          Transpose[{i, y129\_i}], Transpose[{i, y130\_i}], 
          PlotJoined \[Rule] True, DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25], Hue[0.1]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 140}, {\(-1\), 1}}], {{{Hue[
                1], \*"\"\<\!\(y127\_i\)\>\""}, {Hue[
                0.5], \*"\"\<\!\(y128\_i\)\>\""}, {Hue[
                0.25], \*"\"\<\!\(y129\_i\)\>\""}, {Hue[
                0.1], \*"\"\<\!\(y130\_i\)\>\""}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{443, 599},
WindowMargins->{{39, Automatic}, {Automatic, 20}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3432, 63, 1298, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

