(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5226,        118]*)
(*NotebookOutlinePosition[      5871,        140]*)
(*  CellTagsIndexPosition[      5827,        136]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F13FTDISC2S
    
The cos-function shows \"mirror\" symmetry around the
middle of the interval, at the beginning and at the end.
      
Length interval is i=1,2,3...\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(<< Graphics`MultipleListPlot`\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(i\  = \ Range[0, 127, 1];\), 
      "\[IndentingNewLine]", \( (*\ 1.  Frequencies\ f\  = \ 1/128, \ 
        2/128, \ 3/128\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y1\_i = 
        Cos[2*Pi*1\/128*i];\), "\[IndentingNewLine]", \(y2\_i = 
        Cos[2*Pi*2\/128*i];\), "\[IndentingNewLine]", 
    RowBox[{\(y3\_i = Cos[2*Pi*63\/128*i];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i, y1\_i}], Transpose[{i, y2\_i}], 
            Transpose[{i, y3\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 140}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(y1\_i\)\>\""}, {Hue[
                  0.5], \*"\"\<\!\(y2\_i\)\>\""}, {Hue[
                  0.25], \*"\"\<\!\(y3\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 2. \ Frequencies\ 63/128, \ 64/128, \ 
        65/128\ *) \)}], "\[IndentingNewLine]", \(y63\_i = 
        Cos[2*Pi*63\/128*i];\), "\[IndentingNewLine]", \(y64\_i = 
        Cos[2*Pi*64\/128*i];\), "\[IndentingNewLine]", 
    RowBox[{\(y65\_i = Cos[2*Pi*65\/128*i];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          MultipleListPlot[Transpose[{i, y63\_i}], Transpose[{i, y64\_i}], 
            Transpose[{i, y65\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, 
            PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 130}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(y63\_i\)\>\""}, {Hue[
                  0.5], \*"\"\<\!\(y64\_i\)\>\""}, {Hue[
                  0.25], \*"\"\<\!\(y65\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, 0}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 
        3. \ Expended\ Graph\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(j\  = \ Range[20, 50, 1];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(y63\_j = 
        Cos[2*Pi*63\/128*j];\), "\[IndentingNewLine]", \(y64\_j = 
        Cos[2*Pi*64\/128*j];\), "\[IndentingNewLine]", \(y65\_j = 
        Cos[2*Pi*65\/128*j];\), "\[IndentingNewLine]", \(ShowLegend[
        MultipleListPlot[Transpose[{i, y63\_i}], Transpose[{i, y64\_i}], 
          Transpose[{i, y65\_i}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, 
          PlotStyle \[Rule] {Hue[1], Hue[0.5], Hue[0.25]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{20, 50}, {\(-1\), 1}}], {{{Hue[
                1], \*"\"\<\!\(y63\_i\)\>\""}, {Hue[
                0.5], \*"\"\<\!\(y64\_i\)\>\""}, {Hue[
                0.25], \*"\"\<\!\(y65\_i\)\>\""}}, 
          LegendPosition \[Rule] {1.1, 0}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{658, 599},
WindowMargins->{{Automatic, 39}, {Automatic, 10}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3517, 66, 1166, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

