(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5226,        117]*)
(*NotebookOutlinePosition[      5872,        139]*)
(*  CellTagsIndexPosition[      5828,        135]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[{
    RowBox[{
      RowBox[{"(*", "\[IndentingNewLine]", Cell["\<\
F14MICHOPS
Michelson interferometer.Beamsplitter is assumed to be ideal with 50-50 \
efficiency. Fringe pattern on displacement of mirrors.
      
Amplitude and intensity pattern depending on displacement x of mirror.The \
\"space coordinate\" is a sequence of discrete points,all having the same \
distance.

1. Cosine function, one frequency, amplitude.\
\>"], "\[IndentingNewLine]", "*)"}], 
      "\[IndentingNewLine]", \(<< Graphics`Legend`\)}], "\[IndentingNewLine]",
   
    RowBox[{\(i\  = \ Range[0, 127, 1];\), 
      " ", \( (*\ 
        The\ space\ coordinate\ runs\ from\ 0\ to\ 127\ *) \)}], "\
\[IndentingNewLine]", 
    RowBox[{\(u1\_i = \ \[Sum]\+\(k = 1\)\%1 Cos[\((2*Pi*k\/128)\)*i];\), 
      " ", \( (*\ we\ have\ k\  = \ 
          1/128\ as\ the\ \(\(frequency\)\(.\)\)\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, u1\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 140}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<\!\(u1\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ We\ just\ go\ through\ one\ cycle\ *) \), 
      "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 2. \ Cosine\ function, \ 
        one\ frequency, \ intensity\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, \((u1\_i)\)\^2}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 130}, {\(-1\), 1}}], {{{Hue[
                  1], \*"\"\<(\!\(u1\_i\)\!\(\()\^2\)\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 3. \ Cosine\ function, \ 
        many\ frequencies, \ amplitude\ *) \)}], "\[IndentingNewLine]", 
    RowBox[{\(i\  = \ Range[0, 127, 1];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(u2\_i = \ \[Sum]\+\(k = 1\)\%20 Cos[\((2*Pi*k\/128)\)*i];\), 
      "\[IndentingNewLine]", \( (*\ k\  = \ 1/128, 
        2/128.   .20/128\ are\ the\ frequencies\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(ShowLegend[
          ListPlot[Transpose[{i, u2\_i}], PlotJoined \[Rule] True, 
            DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
            AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
            PlotRange \[Rule] {{0, 140}, {\(-20\), 20}}], {{{Hue[
                  1], \*"\"\<\!\(u2\_i\)\>\""}}, 
            LegendPosition \[Rule] {1.1, \(-0\)}}];\), "\[IndentingNewLine]", 
      "\[IndentingNewLine]", \( (*\ 4. \ Cosine\ function, \ 
        many\ frequencies, \ \(\(intensity\)\(.\)\)\ *) \), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", \(ShowLegend[
        ListPlot[Transpose[{i, \((u2\_i)\)\^2}], PlotJoined \[Rule] True, 
          DisplayFunction \[Rule] Identity, PlotStyle \[Rule] {Hue[1]}, 
          AxesLabel \[Rule] {"\<i\>", "\<\>"}, 
          PlotRange \[Rule] {{0, 140}, {0, 400}}], {{{Hue[
                1], \*"\"\<(\!\(u2\_i\)\!\(\()\^2\)\)\>\""}}, 
          LegendPosition \[Rule] {1.1, \(-0\)}}];\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{500, 599},
WindowMargins->{{38, Automatic}, {Automatic, -26}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 3517, 65, 1136, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

