(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   4949981,     150090]*)
(*NotebookOutlinePosition[   4951708,     150146]*)
(*  CellTagsIndexPosition[   4951577,     150138]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Routines"
}], "Subsection",
  CellTags->"c:6"],

Cell[CellGroupData[{

Cell["\<\
 \"The parabolic reflector antenna in Radio Astronomy and \
Communication\" \
\>", "Subsubsection"],

Cell[TextData[{
  "This file contains the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " routines used in the text of the book \"The parabolic reflector antenna \
in Radio Astronomy and Communication\" by Jacob W.M. Baars. They have been \
used to obtain numerical and graphical results throughout the book. They are \
numbered ",
  StyleBox["Mat.x.y",
    FontColor->RGBColor[0, 0, 1]],
  " in the text, where x = chapter number and y= running number, and they are \
identified by the same number in the first line of the expressions in this \
file.\n\nThe routines have been written and tested with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  5.2. on a Macintosh computer. Some of the routines, in particular those \
with integration of a Bessel function multiplied by a Cos or Sin function, \
produce warning messages, mostly of a style \"Integrand ...is not numerical \
at ...\". However, the calculation is carried through and the results appear \
to be correct.\n\nThese routine, when loaded into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", can be adapted to the input parameters desired by the reader to produce \
numerical results for his own cases.\n\nTo illuminate the calculations, most \
of the routines are presented together with their graphical output, as used \
in the book. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 2 - Geometry of reflector antennas", "Subsubsection"],

Cell[BoxData[{
    StyleBox[\(Mat  .2  .1 - ALMA\ antenna\ geometry;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(dp = 12.0; 
    f = 4.8; m = 20. ; 
    ds = 0.75;\), "\[IndentingNewLine]", \(\[CapitalPsi]\_0 = 
      2\ ArcTan[dp/\((4\ f)\)]\ \((180/\[Pi])\)\), "\n", \(\[CapitalPhi]\_0 = 
      2\ ArcTan[
          dp/\((4\ m\ f)\)] \((180/\[Pi])\)\), "\n", \(e = \((m + 1)\)/\((m - 
            1)\)\), "\n", \(m = \((e + 1)\)/\((e - 1)\)\), "\n", \(fc = \((ds/
            2)\)\ \((Cot[\[CapitalPsi]\_0\ \[Pi]/180] + 
            Cot[\[CapitalPhi]\_0\ \[Pi]/180])\)\), "\n", \(l = 
      fc \((e - 1)\)/2\ e\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326],
  CellTags->"i:1"],

Cell[CellGroupData[{

Cell[BoxData[{
    StyleBox[\(Mat  .2  .2 - lateral\ defocus\ pathlength\ error;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(f = 
      4.8; \[Chi] = 0; \[Delta] = 
      0.001;\), "\[IndentingNewLine]", \(dl = \((\[Delta]\ r\ /
                f)\)/\((1 + \((r/\((2\ f)\))\)^2)\);\), \
"\[IndentingNewLine]", \(Plot[1000\ dl, {r, 0, 6}, \ 
      PlotRange \[Rule] {0, 1}, Frame \[Rule] True, \ 
      GridLines \[Rule] \ Automatic, 
      FrameLabel \[Rule] {\ "\<Radius (m)\>", "\<Pathlength (mm)\>"}]\)}], \
"Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326],
  CellTags->"i:1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 0 0.618034 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.34127 -0.0125 -3 -9 ]
[.34127 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -32.0625 -21 ]
[.5 -0.0125 32.0625 -9 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -30 -47.0625 ]
[-0.01875 .30902 -18 47.0625 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .61803 L
s
.34127 0 m
.34127 .61803 L
s
.5 0 m
.5 .61803 L
s
.65873 0 m
.65873 .61803 L
s
.81746 0 m
.81746 .61803 L
s
0 .12361 m
1 .12361 L
s
0 .24721 m
1 .24721 L
s
0 .37082 m
1 .37082 L
s
0 .49443 m
1 .49443 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(1)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(2)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(3)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(4)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(5)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(6)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -93.0625 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Radius) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
105.000 13.000 moveto
(H) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
117.125 13.000 moveto
(L) show
123.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -132.062 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
108.063 10 translate
90 rotate
-108.063 -10 translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pathlength) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
129.000 13.000 moveto
(H) show
135.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(mm) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
147.125 13.000 moveto
(L) show
153.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .61178 m
.02381 .61803 L
s
.18254 .61178 m
.18254 .61803 L
s
.34127 .61178 m
.34127 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.65873 .61178 m
.65873 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.05556 .61428 m
.05556 .61803 L
s
.0873 .61428 m
.0873 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.15079 .61428 m
.15079 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.24603 .61428 m
.24603 .61803 L
s
.27778 .61428 m
.27778 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.37302 .61428 m
.37302 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.43651 .61428 m
.43651 .61803 L
s
.46825 .61428 m
.46825 .61803 L
s
.53175 .61428 m
.53175 .61803 L
s
.56349 .61428 m
.56349 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.62698 .61428 m
.62698 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.72222 .61428 m
.72222 .61803 L
s
.75397 .61428 m
.75397 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.84921 .61428 m
.84921 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.9127 .61428 m
.9127 .61803 L
s
.94444 .61428 m
.94444 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 0 m
1 0 L
s
.99375 .12361 m
1 .12361 L
s
.99375 .24721 m
1 .24721 L
s
.99375 .37082 m
1 .37082 L
s
.99375 .49443 m
1 .49443 L
s
.125 Mabswid
.99625 .0309 m
1 .0309 L
s
.99625 .0618 m
1 .0618 L
s
.99625 .09271 m
1 .09271 L
s
.99625 .15451 m
1 .15451 L
s
.99625 .18541 m
1 .18541 L
s
.99625 .21631 m
1 .21631 L
s
.99625 .27812 m
1 .27812 L
s
.99625 .30902 m
1 .30902 L
s
.99625 .33992 m
1 .33992 L
s
.99625 .40172 m
1 .40172 L
s
.99625 .43262 m
1 .43262 L
s
.99625 .46353 m
1 .46353 L
s
.99625 .52533 m
1 .52533 L
s
.99625 .55623 m
1 .55623 L
s
.99625 .58713 m
1 .58713 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 0 m
.06244 .03132 L
.10458 .06533 L
.14415 .09701 L
.18221 .12711 L
.22272 .15864 L
.26171 .18839 L
.30316 .21923 L
.34309 .2481 L
.3815 .27499 L
.42237 .3026 L
.46172 .32812 L
.49955 .35163 L
.53984 .37552 L
.57861 .39736 L
.61984 .41932 L
.65954 .43924 L
.69774 .45724 L
.73838 .47515 L
.77751 .49121 L
.81909 .50701 L
.85916 .52103 L
.89771 .53344 L
.93871 .5455 L
.97619 .55554 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00/?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo06Co
oooo002_ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0Hoooool008;ooooo0ol0
0002ooooo`03o`000?oooooo000000?o00000_ooool4o`000003ooooool0003o000000?o00000ooo
ool2o`000003ooooool0003o000000?o00002_ooool02Ol0003ooooooooooooooooo0000ooooool0
003oooooo`000004ooooo`03o`000?oooooooooo06;ooooo0023ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Oooooo
00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000001?ooool00ol0003oooooooooo`1R
ooooo`00Poooool00ol0003oooooo`000003ooooo`?o00000_ooool01?l0003oooooooooool00004
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool3o`0000[ooooo00Wo
0000ooooooooooooooooo`000?oooooo0000ooooool000001?ooool00ol0003oooooooooo`1Roooo
o`00Poooool3o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00004
ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool0000=ooooo`09o`00
0?ooooooooooooooool0003oooooo`000?oooooo000000Cooooo00?o0000ooooooooool0H_ooool0
08?ooooo00Co0000oooooooooooo00000_ooool2o`0000Cooooo0ol00002ooooo`?o00000oooool2
o`000003ooooool0003o000000;ooooo1?l0000:ooooo`03o`000?oooooooooo00;o000000?ooooo
o`000?ooool00oooool00ol0003oooooooooo`1Sooooo`00Poooool01?l0003oooooooooool0000:
ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1T
ooooo`00P_ooool4o`0000[ooooo0_l00004ooooo`03o`000?oooooooooo08Oooooo003oooooob7o
oooo003oooooob7ooooo000]ooooo`;o00008oooool3o`0002;ooooo1Ol0000Rooooo`?o00009?oo
ool3o`0002;ooooo0ol0000Tooooo`?o00003?ooool002cooooo00Co0000oooooooooooo00008ooo
ool00ol0003oooooooooo`0Rooooo`04o`000?ooooooooooo`00027ooooo00Go0000oooooooooooo
ooooo`00000Tooooo`03o`000?oooooooooo023ooooo00Go0000ooooooooooooooooo`00000Roooo
o`05o`000?ooooooooooooooool000002oooool002cooooo00Co0000oooooooooooo00008oooool0
0ol0003oooooooooo`0Sooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool07oooool5
o`0002Gooooo00?o0000ooooooooool08?ooool01Ol0003ooooooooooooooooo000000_ooooo000/
ooooo`04o`000?ooooooooooo`0002?ooooo00?o0000ooooooooool09?ooool00ol0003ooooooooo
o`0Rooooo`;o00008_ooool01?l0003oooooooooool0000Vooooo`03o`000?oooooooooo023ooooo
1?l0000<ooooo`00;?ooool01?l0003oooooooooool0000Sooooo`03o`000?oooooooooo027ooooo
00Go0000ooooooooooooooooo`00000Uooooo`03o`000?oooooooooo023ooooo00?o0000ooooool0
00008_ooool4o`0002?ooooo00?o0000ooooooooool03Oooool002cooooo00Co0000oooooooooooo
00008_ooool2o`0002?ooooo00Go0000ooooooooooooooooo`00000Qooooo`05o`000?oooooooooo
ooooool000008oooool2o`0002;ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0<
ooooo`00;Oooool2o`0002Cooooo00?o0000ooooooooool08_ooool3o`0002?ooooo0ol0000Uoooo
o`03o`000?oooooooooo023ooooo1Ol0000Tooooo`;o00003?ooool00?oooooo8Oooool00?oooooo
8Oooool00?oooooo8Oooool00?oooooo8Oooool002SooooolOl00007ooooo`00:?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooo000002?ooooo00?o0000ooooooooool08oooool00ol0003o
ooooooooo`0Sooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool08oooool00ol0003o
ooooooooo`0Tooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool002Sooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Pooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003ooooooooo
o`07ooooo`;o00008?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o
0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0M
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05
ooooo`00:?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01cooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool06oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo0_l0000=ooooo`;o0000
6oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Sooooo0_l00007ooooo`00:?oo
ool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Sooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool05oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`0Fooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0
003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Aooooo`;o00005_ooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo
00?o0000ooooooooool04oooool00ol0003oooooooooo`0Cooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo01;ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`;o00005_ooool00ol0003oooooooooo`0A
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:?ooool2o`0000Oooooo000Xoooo
o`03o`000?oooooooooo01Kooooo0_l0000Aooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Hooooo`03
o`000?oooooooooo00kooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03
o`000?oooooooooo00Gooooo000Xooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0
3Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool0
1Oooool002Sooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0<ooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool0
0ol0003oooooooooo`0Kooooo`;o00003?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool07Oooool00ol0
003oooooooooo`09ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0
003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo00So
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Go
oooo000Xooooo`;o00008?ooool00ol0003oooooooooo`07ooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool0:?ooool2o`0000Oooooo000Xooooo`03o`000?oooooooooo023ooooo0_l0
0007ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003ooooooooo
o`05ooooo`00:?ooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Cooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xoooo
o`03o`000?oooooooooo02?ooooo00?o0000ooooooooool00oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000oooooooo
ool09?ooool2o`0000?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03
o`000?oooooooooo00Gooooo000Eooooo`;o00001?ooool01?l0003oooooooooooooool5o`0000Co
oooo00?o0000ooooooooool09_ooool01?l0003oooooooooool007lUooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02Wooooo00?o0000ooooooooool01Oooool001Cooooo00Co0000oooooooooooo00002?ooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooool007l09Oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Dooooo`04o`000?oooooooooo
o`0000Wooooo00?o0000ooooooooool01?ooool3o`0002So001o00?o0000o`00Ool007l0`Ol007l2
o`0000Oooooo0008ooooo`03oooomoo=]kgok_oo00?ooooo00?od[Ngon3gooooool00oooool01?l0
003oooooooooool0000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool2
o`0002Cooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool02?oo
oo;oT@00od5iROnATI7oV9RHoiRAP_l^047o`_;o1?ooool01?l0003oooooooooool00007ooooo`05
o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooo0000
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool02?oooo;o
V44^oh:U/Onm]jGoG45LojFgZomL04oob?;o1?ooool01?l0003oooooooooool00007ooooo`05o`00
0?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Yooooo`04o`00Ooooooooooooo`00
02;ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool02?ooonko
RBi?olgoooooon[oPUbHooOooon[L73ob?;o1Oooool2o`0000Wooooo0ol00005ooooo`03o`000?oo
oooooooo02Wooooo00Go001oooooooooooooooooo`00000Qooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo
00?o0000ooooooooool01Oooool000Sooooo00Kooookok5V0?m?TK7o_ImVo`11WoogoolJooooo`03
o`000?oooooooooo02Wooooo00?o001oooooooooool00_ooool2o`0001oooooo00?o001ooooooooo
ool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooooooo
ool0:Oooool00ol0003oooooooooo`05ooooo`002Oooool01?ook]OoTG1LoeaVROoBk_/Kooooo`03
o`000?oooooooooo02Wooooo00?o001oooooooooool01?ooool00ol0003oooooooooo`0Looooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000cooooo00?oooobomO=cOoPk_/0
6Oooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo00Gooooo00?o0000ooooooooool0
6oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06on[2TOn2
/Lgo/G0^o`0^0?l005cod_Oo6?ooool2o`0002[ooooo00?o001oooooooooool01_ooool00ol0003o
ooooooooo`0Jooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02Sooooo0_l00007ooooo`002_ooool01_o8REcoTKfg
og1?TOogoo_oV45?ol;^oaSooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`07oooo
o`;o00006_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06
olR9I_nO`[7oG46Hoo;kg?m`;W3oeo_o6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooo
oooo00Wooooo00?o0000ooooooooool05oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooo
oooo00Gooooo000:ooooo`06onFmROl0003o0000o`000?l0073oeoOo6?ooool00ol0003ooooooooo
o`0Yooooo`03o`00Oooooooooooo00[ooooo00?o0000ooooooooool05_ooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Yooooo`03o`000?oooooooooo00Gooooo000;ooooo`05ooogmoobl_;onoOUoi5?I_o8l_l06?oo
ool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo00_ooooo0_l0000Fooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00?oon[=okO=j_ooool06oooool0
0ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo00gooooo00?o0000ooooooooool04oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo0008ooooo`07oooomooPemOo_ImV
o`1LWooBem;ocLgBonGbn`0Iooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool03_oo
ool00ol0003oooooooooo`0Booooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Ooo
ool000Sooooo00SooooZojF2L?mVG2ko02i?og1iNOm`G47o001VomOkoaSooooo0_l0000Zooooo`03
o`00Oooooooooooo00oooooo00?o0000ooooooooool04Oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Xooooo`;o
00001oooool000[ooooo00Konm:Aod69cOooooooooogoi4^@Oo2l_lHooooo`03o`000?oooooooooo
02Wooooo00?o001oooooooooool04?ooool2o`00017ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0
003oooooooooo`05ooooo`002_ooool01_obcHWo@HW8oooooooonmOoG01?olggoaSooooo00?o0000
ooooooooool0:Oooool00ol007ooooooooooo`0Booooo`03o`000?oooooooooo00kooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002oooool01Ookooooooooooobd_nAV<;o
nooo01Sooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Cooooo`;o00003_ooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo0008ooooo`03oo;PcOoBj__ooooo
00?ooooo00?oel;2onGkooooool05oooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo
01Gooooo00?o0000ooooooooool02oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo
00Gooooo0008ooooo`08olf9;_l0003o@Dm?od51@Ol^;T7o@D4^o`00;_o8l_lHooooo`03o`000?oo
oooooooo02Wooooo00?o001oooooooooool05_ooool00ol0003oooooooooo`0:ooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02Wooooo00?o0000ooooooooool01Oooool000Sooooo00Sooo_bonkbk_o2TD7o;X:gon[^
k_o^k^3oYGV9om;boaSooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Gooooo`;o
00002_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooooooo
ool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06olf2
@On2b?;ooooooooooooUd];oj__o6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo
01Wooooo00?o0000ooooooooool01oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo
00Gooooo000:ooooo`06on2gP_l0003o;T51od51;_l002kob?;o6?ooool2o`0002[ooooo00?o001o
ooooooooool06_ooool2o`0000Oooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:?ooool2o`0000Oooooo000;oooo
o`05ooObj_oUiN[ok^kPoim`NOo=l_l06?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooo
oooo01cooooo00?o0000ooooooooool01?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooo
oooo00Gooooo000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool07Oooool2o`00
00Cooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool00ooP/HWo
Wm;booooo`02ooooo`03oooomonH@Doo`_;o01Sooooo00?o0000ooooooooool0:Oooool00ol007oo
ooooooooo`0Oooooo`05o`000?ooooooooooooooool007l09Oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05oooo
o`002?ooool00oo8PRkoG9S2omOGdP02om;BdP03omOG`_m`;Toob?;o00Gooooo0_l00004ooooo`03
o`000?oooooooooo00?ooooo0ol00004ooooo`03o`000?oooooooooo02Wooooo00?o001ooooooooo
ool08?ooool01?l0003oooooooooool007lUooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo0008ooooo`03
on[8YOm`L73oL71`00;oL71`00?oL71Vo`00Coo8l_l01?ooool01?l0003oooooooooool0000:oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Qoooo
o`;o000000?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`003Oooool00oooooOo
TBi1ol;bo`04ooooo`04o`000?ooooooooooo`0000Oooooo1Ol00004ooooo`03o`000?oooooooooo
02Wooooo00?o001oooooooooool08oooool00ol0003oooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo
00Gooooo000=ooooo`03oooonoo=/KOoh?Oo00Cooooo00Co0000oooooooooooo00001oooool01?l0
003oooooooooool00005ooooo`?o0000D?l007l2o`0009[o001o0_l00007ooooo`002oooool01?og
iM;o]k6[ok6mcOobool5ooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooool000001Ooo
ool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00Co001ooooooooooooo0000
8_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
:Oooool00ol0003oooooooooo`05ooooo`002_ooool01_obdYoo0000o`000?l0003o046Honkoo`Co
oooo00Co0000oooooooooooo00002Oooool2o`0000Gooooo00?o0000ooooooooool0:Oooool00ol0
07ooooooooooo`0Sooooo`05o`00Ooooooooooooooooool000008Oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05
ooooo`002_ooool01_o2PTooV<gLoim?G?oBno;oV45?ol;^o`Gooooo0_l0000;ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo00;ooooo0_l0000Oooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06okM`G?nmk^ko
YDmLolgknonaIVKo`^ko6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool01?ooool00ol0003oooooooooo`0Looooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo
000:ooooo`06on2aL?l002ko001?olSUcOm?05coeo_o6?ooool00ol0003oooooooooo`0Yooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool01Oooool00ol0003oooooooooo`0Kooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03
o`000?oooooooooo00Gooooo000:ooooo`05oooonooB/I7oIW2Hom;G_OnHZm806Oooool00ol0003o
ooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool01_ooool00ol0003o
ooooooooo`0Jooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06on[Bb?oGk_oooooooooooooL
b<Soj__o6?ooool2o`0002[ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`07oooo
o`;o00006_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool0:?ooool2o`0000Oooooo000:ooooo`06olf9;_l002koCdm?odm?;_l002ko`_;o6?ooool0
0ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool02Oooool2
o`0001Sooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00Kog:ELod62/OoUj^[ok^kLoimiP_oB
l_lHooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0;ooooo`03o`000?oooooooooo01Gooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00Kob891
oh;8l_ooooooooooonGBd_oZnolHooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0<ooooo`;o00005Oooool00ol007ooooooooooo`0Sooooo`03o`00
Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002_oo
ool01_oP/GWo0000od51Com?@Bko000^olSboaSooooo00?o0000ooooooooool0:Oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo00kooooo0_l0000Cooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Go
oooo000;ooooo`05ooO^j_oUiNGoj^[Loim`NOo=l_l06?ooool00ol0003oooooooooo`0Yooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool04?ooool00ol0003oooooooooo`0@ooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03
o`000?oooooooooo00Gooooo000;ooooo`03ooogj_oBcLgoenGb01[ooooo00?o0000ooooooooool0
:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo017ooooo0_l0000@ooooo`03o`00
Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`00
0?oooooooooo00Gooooo000:ooooo`08oo_U]ol^003o@EaLo`000?mVZmcoooooon[PiOokoolFoooo
o`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Coooo
o`03o`000?oooooooooo00gooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00SocI5?ofJah?oo
ooooonZgobh^TOogon[oN@0^ol;boaKooooo0_l0000Zooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool05?ooool2o`0000gooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02Sooooo0_l00007ooooo`002_ooool02?oBV5coL;7Poooooooo
j[Oo@DnUoo_oh?mV04oocOOo5_ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool05_ooool00ol0003oooooooooo`0:ooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Go
oooo000:ooooo`07ombUI_l0003oCfIVobh00?l0003o@@00obj2_@0Gooooo`03o`000?oooooooooo
02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Gooooo`;o00002_ooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0
003oooooooooo`05ooooo`002_ooool00ooBV6KoP[7BonGPh002on3Ph003on3Pj_okoooooooo01Ko
oooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo01Wo
oooo00?o0000ooooooooool01oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool00oooj/go]lgZ
ooooo`0Kooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Jooooo`;o00001oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool01oooooOoh=OGokfO
I_l0G9ood]OBolg=d_oUl_/06Oooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool07?ooool00ol0003oooooooooo`04ooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Go
oooo0008ooooo`08ooooj_nUPW3oIU`^o`0^Com`NGWoL5a1o`00I_oGnolHooooo`03o`000?oooooo
oooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Mooooo`;o00001?ooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool0
0ol0003oooooooooo`05ooooo`002_ooool01_okdY7o@HW=ooooooooooOoTBi1ol;boaSooooo0_l0
000Zooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool07oooool01Ol0003ooooooooo
oooooooo001o02Gooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Xooooo`;o0000
1oooool000[ooooo00Kol/f9od69b?oooooooo_Goe`0Coo=molHooooo`03o`000?oooooooooo02Wo
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Pooooo`;o000000?oooooo`00Oooo
ool09?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000oooooooo
ool01Oooool000_ooooo00Gonoooooooooool];oTIS2oo_oo`0Hooooo`03o`000?oooooooooo02Wo
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Rooooo`03o`000?l007oooooo02Co
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Go
oooo0008ooooo`03oo;PcOoBj__ooooo00?ooooo00?oel;2onGkooooool05oooool00ol0003ooooo
ooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool2o`0002Cooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo
0008ooooo`08olf9;_l0003o@Dm?od51@Ol^;T7o@D4^o`00;_o8l_lHooooo`03o`000?oooooooooo
02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`04o`00Oooooooo0000
o`0002;ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooo
oooo00Gooooo0008ooooo`08oookl_o^l^ko`Y51obj2]ooZk^kok^kPojEiROoBl_l5ooooo`;o0000
1?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`0Yooooo`03o`00
Oooooooooooo02?ooooo00?o001oooooooooool08oooool01Ol007oooooooooooooooooo0000027o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Go
oooo000:ooooo`06olf2@On2b?;ooooooooooooUd];oj__o1?ooool01?l0003oooooooooool00007
ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`02ooooo`;o00007ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Ooo
ool000[ooooo00Koh;N2o`000?l^@D7o@D4^o`00;_o8l_l4ooooo`04o`000?ooooooooooo`0000Oo
oooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo02Wooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00Cooooo0_l0000Moooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05oooo
o`002oooool01Oogl^[oiNGZonk^h?nOL7WocO;o00Cooooo00Co0000oooooooooooo00001oooool4
o`0000Gooooo0ol0001no`00O`03o`000?l007oo001o06_o001o0_l00007ooooo`005?ooool01?l0
003oooooooooool00007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0:Oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool01oooool2
o`0001[ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooo
oooo00Gooooo000Dooooo`04o`000?ooooooooooo`0000Sooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`09ooooo`;o00006?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02Wooooo00?o0000ooooooooool01Oooool001Gooooo0_l0000:ooooo`;o00001Oooool00ol0
003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0;ooooo`;o00005_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool03Oooool00ol0003o
ooooooooo`0Cooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003o
ooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0>ooooo`;o00004oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o
0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool04?ooool2o`00017ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`;o0000:_ooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool04_ooool2o`0000oooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Xooooo`;o00001oooool002Sooooo00?o0000oooo
ooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool05?ooool2o`0000gooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yoooo
o`03o`000?oooooooooo00Gooooo000;ooooo`04oo_gk_oUh>3oh>GZooOooaWooooo00?o0000oooo
ooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool05_ooool2o`0000_ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yoooo
o`03o`000?oooooooooo00Gooooo0009ooooo`08oo;Pb?n9IUcoG6IioiROYOnOV97oL6ILog29ZooL
l_/Gooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo01Sooooo0_l00009ooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool00oogg;OoPY6aon3bn`04
ooooo`03onkP`_nATKOol_oo01Kooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool06_ooool2o`0000Oooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xoooo
o`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo01cooooo0_l00005ooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool01_o=TEcoIYo2omOGd_oGelSoND5L
olSboaSooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool07_ooool2o`0000?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06om:HCol0;UcoNGUi
ogUiI_l002kob?;o6?ooool2o`0002[ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo023ooooo0_l000000ooooooo001oooooo`0Tooooo`03o`00Oooo
oooooooo02Sooooo0_l00007ooooo`002_ooool01_ngL03oG:G=onk^j_oZj^Gob;NmonGkoaSooooo
00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08_ooool2o`0002Gooooo00?o001oooooooooool0:Oooool00ol0003ooooo
ooooo`05ooooo`002_ooool01_oLZfKo000^oeaLG?mLG4oo000^ol;boaSooooo00?o0000oooooooo
ool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooooooo
ool08oooool00ol007oo0000o`00000Sooooo`03o`00Oooooooooooo02Wooooo00?o0000oooooooo
ool01Oooool000[ooooo00Ko/FH0oebUd_ogmoOomoO^om;8cOo^nolHooooo`03o`000?oooooooooo
02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool00_l0000Qooooo`03o`00Oooooooooooo02Wooooo00?o0000oooo
ooooool01Oooool000[ooooo00Koj/f[ofI1@Ol^@D7o@D4^o`00;_o2l_lHooooo`03o`000?oooooo
oooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool00_ooool3o`0001kooooo00?o001oooooooooool0:Oooool0
0ol0003oooooooooo`05ooooo`002_ooool01_o=TEcoIYo2omOGd_oGelSoJSI<ok_^oaSooooo00?o
0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`05ooooo`;o00007?ooool00ol007oooooooooo
o`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06om:HCol0;UcoNGUiogUiI_l002kob?;o
6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00Oooooo0_l0000Jooooo`03o`00
Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00Ko]g00oebUcOo^k^[oj^[U
olRg_OoUnolHooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool02Oooool2o`0001So
oooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool01_oLZfKo000^
oeaLG?mLG4oo000^ol;boaSooooo0_l0000Zooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00_ooooo0_l0000Foooo
o`03o`00Oooooooooooo02Sooooo0_l00007ooooo`002_ooool01_naIP3oG:GBooOgmoogmnkod/S=
onkkoaSooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0=ooooo`03o`000?oooooo
oooo01?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool01_oZ
cJ_oIT51obi1@Om1@Bko000^ol;boaSooooo00?o0000ooooooooool0:Oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0>ooooo`;o00004oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000>
ooooo`03on3Bd_o^nooooooo01Oooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0@
ooooo`;o00004Oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo0008oooo
o`03ooOUcOo2d^Gooooo00Cooooo00?oooobomO=eoogool05_ooool00ol0003oooooooooo`0Yoooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo01;ooooo0ol0000>ooooo`03o`00Oooooooooooo02Wooooo00?o0000oooo
ooooool01Oooool000Sooooo00Wooo_^ol:UROmLIWWoYKg8omcPh?oLem;o]jFAofILI_nO`]`01?oo
ool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool0:Ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Eooooo`;o00003?ooool00ol007ooooooooooo`0Yooooo`03o`000?oo
oooooooo00Gooooo000:ooooo`06oookk_oB`[OoZj^[oj^[/Oo8enGonooo1?ooool01?l0003ooooo
ooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Yoooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo01Oooooo0ol00009ooooo`03o`00Oooooooooooo02Wooooo00?o0000oooo
ooooool01Oooool001Cooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo
000000Cooooo0ol0002ho`00O`?o0000<Ol007l2o`0000Oooooo000Dooooo`04o`000?oooooooooo
o`0000Sooooo0ol00005ooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool07Oooool3
o`0000?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`005?ooool01?l0
003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooooooo
o`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo023ooooo0ol000000ol007ooooooooooo`0Yooooo`03o`000?oo
oooooooo00Gooooo000Dooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool3o`0002Wooooo
00?o0000ooooooooool01Oooool001Gooooo0_l00009ooooo`?o00001Oooool00ol0003ooooooooo
o`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool00_l0000Wooooo`03o`000?oo
oooooooo00Gooooo000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`02ooooo`?o00009?ooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0
003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool01Oooool2o`00
02;ooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo00Oooooo0ol0000Oooooo`03o`000?oooooooooo00Go
oooo000Xooooo`;o0000:_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00[ooooo
0ol0000Kooooo`;o00001oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo00gooooo0ol0000Iooooo`03o`000?oooooooooo00Gooooo000X
ooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0@
ooooo`Co00005Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yoooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool05?ooool3o`0001;ooooo00?o0000oooo
ooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo01Oooooo0ol0000?ooooo`03o`000?oooooooooo00Gooooo000Xooooo`03o`00
0?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00
Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Jooooo`Co0000
2oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool07_ooool5o`0000Kooooo00?o0000ooooooooool01Ooo
ool002Sooooo0_l0000Zooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool2
o`0000?ooooo0_l00007ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003o
ooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003o
ooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003ooooooooo
o`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003ooooooooo
o`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yoooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05oooo
o`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001ooooooooo
ool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooooooo
ool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool2o`0002[ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Xooooo`;o00001oooool002Sooooo00?o0000ooooooooool0:Ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Ooo
ool002Sooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool0023o
oooo0ol00005ooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Qooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo02?ooooo
00?o0000ooooooooool08oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo02?ooooo
00?o0000ooooooooool09?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo
000Qooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00Gooooo000Qooooo`03o`000?oooooooooo00CooooolOl00007
ooooo`008Oooool00ol0003oooooooooo`3looooo`008?ooool2o`000?kooooo000Qooooo`03o`00
0?oooooooooo0?cooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.21506, -0.161707, \
0.0262312, 0.00673696}},
  CellTags->"i:1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"i:1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    StyleBox[\(Mat  .2  .3 - \ Exact\ vs\ approx\ \ path\ error;\),
      FontColor->RGBColor[0, 0, 1]], "\n", \(f = 4.8; \[Delta] = 
      0.003;\), "\n", \(\[Rho]d = 
      Sqrt[\((r - \[Delta])\)^2 + \((f - 
                r^2/\((4\ f)\))\)^2]; \ \((defocus)\);\), "\n", \(\[Rho]o = 
      Sqrt[r^2 + \((f - 
                r^2/\((4\ f)\))\)^2]; \ \ \ \ \ \ \ \ \ \ \ \ \((in\ \
focus)\);\), "\n", \(dl = \((\[Delta]\ r\ /
              f)\)/\((1 + \((r/\((2\ f)\))\)^2)\); \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \((Eq  .2  .23)\);\), "\n", \(Plot[{10^6 \((dl - \ \((\[Rho]o - \
\[Rho]d)\))\)}, {r, 0, 6}, \ PlotRange \[Rule] {0, 1}, Frame \[Rule] True, \ 
      GridLines \[Rule] \ Automatic, 
      FrameLabel \[Rule] {\ "\<Radius (m)\>", "\<Pathlength \
(\[Mu]m)\>"}]\)}], "Input",
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  Background->GrayLevel[0.833326]],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 0 0.618034 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.34127 -0.0125 -3 -9 ]
[.34127 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -32.0625 -21 ]
[.5 -0.0125 32.0625 -9 ]
[-0.0125 .12361 -18 -4.5 ]
[-0.0125 .12361 0 4.5 ]
[-0.0125 .24721 -18 -4.5 ]
[-0.0125 .24721 0 4.5 ]
[-0.0125 .37082 -18 -4.5 ]
[-0.0125 .37082 0 4.5 ]
[-0.0125 .49443 -18 -4.5 ]
[-0.0125 .49443 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -30 -47.0625 ]
[-0.01875 .30902 -18 47.0625 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .61803 L
s
.34127 0 m
.34127 .61803 L
s
.5 0 m
.5 .61803 L
s
.65873 0 m
.65873 .61803 L
s
.81746 0 m
.81746 .61803 L
s
0 .12361 m
1 .12361 L
s
0 .24721 m
1 .24721 L
s
0 .37082 m
1 .37082 L
s
0 .49443 m
1 .49443 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(1)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(2)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(3)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(4)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(5)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(6)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -93.0625 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Radius) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
105.000 13.000 moveto
(H) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
117.125 13.000 moveto
(L) show
123.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .12361 m
.00625 .12361 L
s
[(0.2)] -0.0125 .12361 1 0 Mshowa
0 .24721 m
.00625 .24721 L
s
[(0.4)] -0.0125 .24721 1 0 Mshowa
0 .37082 m
.00625 .37082 L
s
[(0.6)] -0.0125 .37082 1 0 Mshowa
0 .49443 m
.00625 .49443 L
s
[(0.8)] -0.0125 .49443 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(1)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .0309 m
.00375 .0309 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .15451 m
.00375 .15451 L
s
0 .18541 m
.00375 .18541 L
s
0 .21631 m
.00375 .21631 L
s
0 .27812 m
.00375 .27812 L
s
0 .30902 m
.00375 .30902 L
s
0 .33992 m
.00375 .33992 L
s
0 .40172 m
.00375 .40172 L
s
0 .43262 m
.00375 .43262 L
s
0 .46353 m
.00375 .46353 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .58713 m
.00375 .58713 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -132.062 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
108.063 10 translate
90 rotate
-108.063 -10 translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Pathlength) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
129.000 13.000 moveto
(H) show
135.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
147.125 13.000 moveto
(L) show
153.125 13.000 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .61178 m
.02381 .61803 L
s
.18254 .61178 m
.18254 .61803 L
s
.34127 .61178 m
.34127 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.65873 .61178 m
.65873 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.05556 .61428 m
.05556 .61803 L
s
.0873 .61428 m
.0873 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.15079 .61428 m
.15079 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.24603 .61428 m
.24603 .61803 L
s
.27778 .61428 m
.27778 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.37302 .61428 m
.37302 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.43651 .61428 m
.43651 .61803 L
s
.46825 .61428 m
.46825 .61803 L
s
.53175 .61428 m
.53175 .61803 L
s
.56349 .61428 m
.56349 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.62698 .61428 m
.62698 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.72222 .61428 m
.72222 .61803 L
s
.75397 .61428 m
.75397 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.84921 .61428 m
.84921 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.9127 .61428 m
.9127 .61803 L
s
.94444 .61428 m
.94444 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 0 m
1 0 L
s
.99375 .12361 m
1 .12361 L
s
.99375 .24721 m
1 .24721 L
s
.99375 .37082 m
1 .37082 L
s
.99375 .49443 m
1 .49443 L
s
.125 Mabswid
.99625 .0309 m
1 .0309 L
s
.99625 .0618 m
1 .0618 L
s
.99625 .09271 m
1 .09271 L
s
.99625 .15451 m
1 .15451 L
s
.99625 .18541 m
1 .18541 L
s
.99625 .21631 m
1 .21631 L
s
.99625 .27812 m
1 .27812 L
s
.99625 .30902 m
1 .30902 L
s
.99625 .33992 m
1 .33992 L
s
.99625 .40172 m
1 .40172 L
s
.99625 .43262 m
1 .43262 L
s
.99625 .46353 m
1 .46353 L
s
.99625 .52533 m
1 .52533 L
s
.99625 .55623 m
1 .55623 L
s
.99625 .58713 m
1 .58713 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .57941 m
.02499 .57941 L
.02605 .5794 L
.02729 .57939 L
.02846 .57938 L
.03053 .57935 L
.03279 .57931 L
.03527 .57925 L
.0379 .57917 L
.04262 .57897 L
.04749 .57872 L
.05205 .57843 L
.06244 .57757 L
.07305 .57641 L
.08274 .57512 L
.10458 .57136 L
.12357 .56717 L
.14429 .56164 L
.18493 .54801 L
.22406 .53163 L
.26565 .51109 L
.30571 .48864 L
.34426 .46496 L
.38527 .438 L
.42475 .41075 L
.46273 .38375 L
.50315 .35456 L
.54206 .3264 L
.58342 .2968 L
.62326 .26893 L
.66159 .24297 L
.70238 .21651 L
.74164 .19235 L
.77939 .17046 L
.8196 .14871 L
.85828 .12935 L
.89942 .11049 L
.93905 .09401 L
.97619 .08004 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00/?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo06Co
oooo002_ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0Hoooool008;ooooo0ol0
0002ooooo`03o`000?oooooo000000?o00000_ooool4o`000003ooooool0003o000000?o00000ooo
ool2o`000003ooooool0003o000000?o00002_ooool02Ol0003ooooooooooooooooo0000ooooool0
003oooooo`000004ooooo`03o`000?oooooooooo06;ooooo0023ooooo`06o`000?ooooooooooo`00
0?oooooo00000_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool00_ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00Oooooo
00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000001?ooool00ol0003oooooooooo`1R
ooooo`00Poooool00ol0003oooooo`000003ooooo`?o00000_ooool01?l0003oooooooooool00004
ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00000_ooool3o`0000[ooooo00Wo
0000ooooooooooooooooo`000?oooooo0000ooooool000001?ooool00ol0003oooooooooo`1Roooo
o`00Poooool3o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00004
ooooo`03o`000?oooooooooo00;ooooo00Ko0000oooooooooooo0000ooooool0000=ooooo`09o`00
0?ooooooooooooooool0003oooooo`000?oooooo000000Cooooo00?o0000ooooooooool0H_ooool0
08?ooooo00Co0000oooooooooooo00000_ooool2o`0000Cooooo0ol00002ooooo`?o00000oooool2
o`000003ooooool0003o000000;ooooo1?l0000:ooooo`03o`000?oooooooooo00;o000000?ooooo
o`000?ooool00oooool00ol0003oooooooooo`1Sooooo`00Poooool01?l0003oooooooooool0000:
ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1T
ooooo`00P_ooool4o`0000[ooooo0_l00004ooooo`03o`000?oooooooooo08Oooooo003oooooob7o
oooo003oooooob7ooooo000]ooooo`;o00008oooool3o`0002;ooooo1Ol0000Rooooo`?o00009?oo
ool3o`0002;ooooo0ol0000Tooooo`?o00003?ooool002cooooo00Co0000oooooooooooo00008ooo
ool00ol0003oooooooooo`0Rooooo`04o`000?ooooooooooo`00027ooooo00Go0000oooooooooooo
ooooo`00000Tooooo`03o`000?oooooooooo023ooooo00Go0000ooooooooooooooooo`00000Roooo
o`05o`000?ooooooooooooooool000002oooool002cooooo00Co0000oooooooooooo00008oooool0
0ol0003oooooooooo`0Sooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool07oooool5
o`0002Gooooo00?o0000ooooooooool08?ooool01Ol0003ooooooooooooooooo000000_ooooo000/
ooooo`04o`000?ooooooooooo`0002?ooooo00?o0000ooooooooool09?ooool00ol0003ooooooooo
o`0Rooooo`;o00008_ooool01?l0003oooooooooool0000Vooooo`03o`000?oooooooooo023ooooo
1?l0000<ooooo`00;?ooool01?l0003oooooooooool0000Sooooo`03o`000?oooooooooo027ooooo
00Go0000ooooooooooooooooo`00000Uooooo`03o`000?oooooooooo023ooooo00?o0000ooooool0
00008_ooool4o`0002?ooooo00?o0000ooooooooool03Oooool002cooooo00Co0000oooooooooooo
00008_ooool2o`0002?ooooo00Go0000ooooooooooooooooo`00000Qooooo`05o`000?oooooooooo
ooooool000008oooool2o`0002;ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`0<
ooooo`00;Oooool2o`0002Cooooo00?o0000ooooooooool08_ooool3o`0002?ooooo0ol0000Uoooo
o`03o`000?oooooooooo023ooooo1Ol0000Tooooo`;o00003?ooool00?oooooo8Oooool00?oooooo
8Oooool00?oooooo8Oooool00?oooooo8Oooool002SooooolOl00007ooooo`00:?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool08oooool00ol0003o
ooooooooo`0Sooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool08oooool00ol0003o
ooooooooo`0Tooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool01Oooool002Sooooo
00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo
00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000
ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000
ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000oooooooo
ool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooooooo
ool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000oooooooo
ool01Oooool002Sooooo0_l0000Zooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
:?ooool2o`0000Oooooo000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`03o`000?oooooo
oooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooo
oooo00Gooooo000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`03o`000?oooooooooo02Wo
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Go
oooo000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`03o`000?oooooooooo02Wooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000X
ooooo`;o0000:_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Sooooo0_l00007
ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00
:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool0
0ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool2
o`0000Cooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo023ooooo0ol00006ooooo`03o`000?oooooooooo
00Gooooo000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Mooooo`?o00002Oooool00ol0003oooooooooo`05ooooo`00:?ooool2o`0002[ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Jooooo`?o00002oooool2o`0000Oooooo
000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Gooooo`?o00003oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Y
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool05Oooool2o`0001;ooooo00?o0000
ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo01;ooooo0ol0000Dooooo`03o`000?oooooooooo00Gooooo000Xooooo`03
o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0@ooooo`;o
00005oooool00ol0003oooooooooo`05ooooo`005Oooool2o`0000Cooooo00Co0000oooooooooooo
oooo1Ol00004ooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0>ooooo`;o00006Oooool00ol0003oooooooooo`05ooooo`005?ooool01?l0003ooooo
ooooool00008ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000ooooooooool0:Oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo00cooooo0_l0000Kooooo`03o`000?oooooooooo
00Gooooo000Dooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01?ooool3o`00
0<ko001o0_l0000Lo`00O`;o00001oooool000Sooooo00?oooogolfg_Oo^ool00oooool00ooB]kOo
h?Ooooooo`03ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool02?ooool2o`00
01oooooo00?o0000ooooooooool01Oooool000Sooooo00Sooooboi400?m1NHWoTI6AoiRHV?nHTH;o
;P11ol;bo`Cooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Co
oooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00Ko
oooo0_l0000Qooooo`03o`000?oooooooooo00Gooooo0008ooooo`08ooool_nH@BkoPZFaokfgYOmL
@EcoYKN[oe`0Coo8l_l4ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000oooooooooooooooo
o`000004ooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`04ooooo`;o00008oooool00ol0003oooooooooo`05ooooo`002?ooool02?ooonkoRBi?olgo
ooooon[oPUbHooOooon[L73ob?;o1Oooool2o`0000Wooooo0ol00005ooooo`03o`000?oooooooooo
02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool01?l007ooooooooooooooool3o`0002Gooooo00?o0000
ooooooooool01Oooool000Sooooo00Kooookok5V0?m?TK7o_ImVo`11WoogoolJooooo`03o`000?oo
oooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool08oooool01?l007ooooooo`000?l0000Xooooo`03o`00
0?oooooooooo00Gooooo0009ooooo`04ooo^eonAL5coG6J9om;^na_ooooo00?o0000ooooooooool0
:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`;o0000:_ooool00ol0003oooooooooo`05ooooo`003?oo
ool00ooooo;oelg=on3^n`0Iooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08Ooo
ool2o`000003o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00Koj/:A
oh:acOnaL2ko02h0o`00G?oBmolHooooo`;o0000:_ooool00ol007ooooooooooo`0Sooooo`03o`00
Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Pooooo`04o`00
0?ooooooooooo`00Ob[ooooo0_l00007ooooo`002_ooool01_o8REcoTKfgog1?TOogoo_oV45?ol;^
oaSooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Nooooo`;o00000oooool00ol0
07ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06olR9I_nO`[7oG46Hoo;k
g?m`;W3oeo_o6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo01cooooo0_l00005
ooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00KoiKf9o`00
0?l0003o0000o`00L?oGmolHooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool06ooo
ool00ol0003oooooooooo`05ooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Ooo
ool000_ooooo00GoooOgoo;bl_okmnGoTDmVolSbo`0Hooooo`03o`000?oooooooooo02Wooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool06Oooool2o`0000Sooooo00?o001oooooooooool0:Oooool00ol0003ooooooooo
o`05ooooo`002_ooool00oooj/go]lgZooooo`0Kooooo`03o`000?oooooooooo02Wooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool05oooool2o`0000[ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05
ooooo`002?ooool01oooooOoh=OGokfOI_l0G9ood]OBolg=d_oUl_/06Oooool00ol0003ooooooooo
o`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo01Gooooo0_l0000<ooooo`03o`00Oooooooooooo02Wooooo00?o
0000ooooooooool01Oooool000Sooooo00SooooZojF2L?mVG2ko02i?og1iNOm`G47o001VomOkoaSo
oooo0_l0000Zooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo01Cooooo00?o0000ooooooooool03?ooool00ol007oo
ooooooooo`0Xooooo`;o00001oooool000[ooooo00Konm:Aod69cOooooooooogoi4^@Oo2l_lHoooo
o`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool04_ooool2o`0000oooooo00?o001ooooo
ooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool01_obcHWo@HW8oooooooonmOoG01?
olggoaSooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0@ooooo`;o00004Oooool0
0ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000;ooooo`05oo_ooooooooooo;B
oi6H`_okool06?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00oooooo00?o0000
ooooooooool04Oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo0008oooo
o`03oo;PcOoBj__ooooo00?ooooo00?oel;2onGkooooool05oooool00ol0003oooooooooo`0Yoooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo00gooooo0_l0000Dooooo`03o`00Oooooooooooo02Wooooo00?o0000oooo
ooooool01Oooool000Sooooo00SocHT^o`000?m1Cdoo@D51obh^@Om1@Bko000^olSboaSooooo00?o
0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0<ooooo`03o`000?oooooooooo01Cooooo00?o
001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool02?oono;ok_;^ol:A@Ol^
P[Ooj^k^onk^h?nUNHWod_;o6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00[o
oooo0_l0000Gooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo
00KocH91oh;8l_ooooooooooonGBd_oZnolHooooo`03o`000?oooooooooo02Wooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool02Oooool00ol0003oooooooooo`0Gooooo`03o`00Oooooooooooo02Wooooo00?o0000oooo
ooooool01Oooool000[ooooo00Koh;N2o`000?l^@D7o@D4^o`00;_o8l_lHooooo`;o0000:_ooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`07ooooo`;o00006_ooool00ol007ooooooooooo`0Xooooo`;o00001oooool0
00_ooooo00Gomo;ZonGUj_o^k^3oWg1iolgbo`0Hooooo`03o`000?oooooooooo02Wooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool01Oooool2o`0001cooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05
ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00Cooooo00?o0000oooo
ooooool07?ooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo0008ooooo`03
on2aROnOd_;ooooo00;ooooo00?oooogoiQ1Coo2l_l06?ooool00ol0003oooooooooo`0Yooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo00;ooooo0_l0000Oooooo`03o`00Oooooooooooo02Wooooo00?o0000oooooooo
ool01Oooool000Sooooo00?ob88^oebH`_oGem800_oBd]800ooGel;oL2i?olSbo`05ooooo`;o0000
1?ooool00ol0003oooooooooo`03ooooo`?o00001?ooool00ol0003oooooooooo`0Yooooo`03o`00
Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00
Oooooooooooo00;o00008Oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo
0008ooooo`03on[8YOm`L73oL71`00;oL71`00?oL71Vo`00Coo8l_l01?ooool01?l0003ooooooooo
ool0000:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooo
o`00000Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000gooooo00?o
ooogoi4^@Oo2l_l01?ooool01?l0003oooooooooool00007ooooo`Go00001?ooool00ol0003ooooo
ooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Sooooo`;o00009?ooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo
000=ooooo`03oooonoo=/KOoh?Oo00Cooooo00Co0000oooooooooooo00001oooool01?l0003ooooo
ooooool00005ooooo`?o0000V_l007l00ol0003o001oo`00O`1?o`00O`;o00001oooool000_ooooo
00ComnGBokNaZona_Lgol_oo1Oooool01?l0003oooooooooool00008ooooo`03o`000?oooooo0000
00Gooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08?ooool2o`000003ooooool007oooooo02Cooooo00?o001ooooo
ooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool01_obdYoo0000o`000?l0003o046H
onkoo`Cooooo00Co0000oooooooooooo00002Oooool2o`0000Gooooo00?o0000ooooooooool0:Ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool07ooo
ool01Ol0003ooooooooooooooooo001o02Gooooo00?o001oooooooooool0:Oooool00ol0003ooooo
ooooo`05ooooo`002_ooool01_o2PTooV<gLoim?G?oBno;oV45?ol;^o`Gooooo0_l0000;ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool07Oooool2o`0000Cooooo00?o001ooooooooo
ool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06okM`
G?nmk^koYDmLolgknonaIVKo`^ko6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Looooo`03o`000?oooooooooo
00Cooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo
00Gooooo000:ooooo`06on2aL?l002ko001?olSUcOm?05coeo_o6?ooool00ol0003oooooooooo`0Y
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0J
ooooo`;o00001oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000
ooooooooool01Oooool000[ooooo00Gooookom:aTOmVL9Sod]NmoiR[dP0Iooooo`03o`000?oooooo
oooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo01Wooooo00?o0000ooooooooool01oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00Koj];8omO^ooooooooooooomc8b?oZ
nolHooooo`;o0000:_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool05oooool2o`0000[ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Xooooo`;o00001oooool000[ooooo00KocHT^o`00;_m?CdooCdl^o`00;_o2l_lHooooo`03o`00
0?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00
Oooooooooooo01Kooooo00?o0000ooooooooool02_ooool00ol007ooooooooooo`0Sooooo`03o`00
Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00Kog:ELod62/OoUj^[ok^kL
oimiP_oBl_lHooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo01Gooooo00?o0000ooooooooool02oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo
00Kob891oh;8l_ooooooooooonGBd_oZnolHooooo`03o`000?oooooooooo02Wooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo01?ooooo0_l0000>oooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05oooo
o`002_ooool01_oP/GWo0000od51Com?@Bko000^olSboaSooooo00?o0000ooooooooool0:Oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool04_ooool0
0ol0003oooooooooo`0>ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool0
0ol0003oooooooooo`05ooooo`002oooool01Oogk^[oiNGUon[Zg?nOL7WocO;o01Sooooo00?o0000
ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool04?ooool2o`00017ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Y
ooooo`03o`000?oooooooooo00Gooooo000;ooooo`03ooogj_oBcLgoenGb01[ooooo00?o0000oooo
ooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool03oooool00ol0003oooooooooo`0Aooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool02?okiKOo;P00od5LG?l0003oIZ_L
oooooooZh>Gonooo5_ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0=ooooo`;o00005?ooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00SocI5?
ofJah?ooooooonZgobh^TOogon[oN@0^ol;boaKooooo0_l0000Zooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0<ooooo`03o`000?oooooooooo01Co
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Xooooo`;o00001oooool000[ooooo
00SodYQLog2ah?ooooooonZgod5?YOokon3oIP1?olggoaKooooo00?o0000ooooooooool0:Oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool02oooool0
0ol0003oooooooooo`0Eooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool0
0ol0003oooooooooo`05ooooo`002_ooool01ooLYFKo0000odmVI_l^003o0000od400?l^P[d05ooo
ool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`09ooooo`;o00006?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00?odYQVoh:ad_oUh>000_oPh>00
0ooPh>[onoooooooo`0Fooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00Sooooo00?o0000ooooooooool06?ooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool0
00[ooooo00?oon[=okO=j_ooool06oooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`06ooooo`;o00006oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000So
oooo00Ooooogon3GeonmWfKo05bOom;Gd_o=cM;oiO;k01Wooooo00?o0000ooooooooool0:Oooool0
0ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool01Oooool0
0ol0003oooooooooo`0Kooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool0
0ol0003oooooooooo`05ooooo`002?ooool02?ooon[oYH9`ofIL;_l0;TooL7Uiog1L@Ol006Koeo_o
6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`04ooooo`03o`000?oooooooooo01cooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06oo_BTOm1
RLgooooooooomonA;T7o`_;o6?ooool2o`0002[ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo00;ooooo0_l0000Oooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool0:?ooool2o`0000Oooooo000:ooooo`06oo;=ROm1RLSooooooookeomL
04oocOOo6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool01Ol007oooooooooooooooooo0000027ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000;ooooo`05oo_ooooooooooo;B
oi6H`_okool06?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool01?l007ooooooooooool0000Rooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool00oobh<god^[kooooo`03
ooooo`03omO2`_oUnooooooo01Oooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooool000008oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000Sooooo00SocHT^o`00
0?m1Cdoo@D51obh^@Om1@Bko000^olSboaSooooo00?o0000ooooooooool0:Oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo0_l0000Tooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002?ooool02?oono;ok_;^ol:A
@Ol^P[Ooj^k^onk^h?nUNHWod_;o1Oooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`00
00Gooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02;ooooo00?o0000o`00Ooooool09?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02Wooooo00?o0000ooooooooool01Oooool000[ooooo00KocH91oh;8l_ooooooooooonGBd_oZnol4
ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`00
0?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Pooooo`;o0000
00?oooooo`00Ooooool09?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo
00?o0000ooooooooool01Oooool000[ooooo00Koh;N2o`000?l^@D7o@D4^o`00;_o8l_l4ooooo`04
o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooo
oooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Oooooo`05o`000?oooooo
ooooooooool007l09Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o
0000ooooooooool01Oooool000_ooooo00Gomo;ZonGUj_o^k^3oWg1iolgbo`04ooooo`04o`000?oo
ooooooooo`0000Oooooo1?l00005ooooo`?o0000L?l007l00ol0003o001oo`00O`1io`00O`;o0000
1oooool001Cooooo00Co0000oooooooooooo00001oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Looooo`;o0000
1Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
:Oooool00ol0003oooooooooo`05ooooo`005?ooool01?l0003oooooooooool00008ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00
Oooooooooooo01_ooooo00?o0000ooooooooool01Oooool00ol007ooooooooooo`0Sooooo`03o`00
Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`005Ooo
ool2o`0000[ooooo0_l00005ooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Iooooo`;o00002?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool0
0ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool06?ooool0
0ol0003oooooooooo`08ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool0
0ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`03o`000?oooooooooo
02Wooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Fooooo`;o00002oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0
003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool05Oooool00ol0003oooooooooo`0;ooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Go
oooo000Xooooo`;o0000:_ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo01?ooooo
0_l0000>ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Xooooo`;o00001oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo01;ooooo00?o0000ooooooooool03_ooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003ooooooooo
o`05ooooo`002oooool01?okmnkoiN3Pon3Uj_ogoolIooooo`03o`000?oooooooooo02Wooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0@ooooo`;o00004Oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003ooooooooo
o`05ooooo`002Oooool02?obh<SoRFILoeaVNOnHWjGoWiRAog1VG?m`RJ_og?;k5oooool00ol0003o
ooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool03oooool00ol0003o
ooooooooo`0Aooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oo
ooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo0008ooooo`03ooOL]on2TK7oh?;k00Cooooo
00?ok^32oi6A]oobool05_ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool03_ooool00ol0003oooooooooo`0Booooo`03o`00Oooooooooooo02?ooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo
000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0<ooooo`;o00005Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`003Oooool01Oogl^koh=O=ok6UTOn2
V;gomooo01Kooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo00_ooooo00?o0000ooooooooool05Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool0
1ooZd[OoRH9iog1`L?n2TI7oNDm1oiS8iOoknol05oooool2o`0002[ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0:ooooo`03o`000?oooooooooo01Kooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Sooooo0_l00007ooooo`002_oo
ool01_ogk^[oj_;gooooooooooool/:AojGGmaSooooo00?o0000ooooooooool0:Oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo00Wooooo00?o0000ooooooooool05oooool00ol007oo
ooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003o
ooooooooo`05ooooo`003Oooool00ooommOoNFJAon[oo`0Hooooo`03o`000?oooooooooo02Wooooo
00?o001oooooooooool08oooool00ol007ooooooooooo`07ooooo`;o00006_ooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003ooooo
ooooo`05ooooo`002_ooool01_ogiMOo_K6Uoi62P_mVG2ko001Vom;boaSooooo00?o0000oooooooo
ool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo00Gooooo0_l0000Looooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03
o`000?oooooooooo00Gooooo000:ooooo`06onkLcOo8d]cok_Okooooooooj]coiO;o6?ooool00ol0
003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool01?ooool00ol0
003oooooooooo`0Looooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06olfAG?mVWl;oemOBomOG
b?mi@Ecob?;o6?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool00_ooool2o`0001oooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00KodYQ?o`0^
G?miNGWoNGUVo`00;_o8l_lHooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`02o`00027ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool000[ooooo00Ko]g00
oebUcOo^k^[oj^[UolRg_OoUnolHooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool0
8oooool00ol007ooooooo`00000Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000:ooooo`06omb[I_l0
02koG5aLoeaLCol002ko`_;o6?ooool2o`0002[ooooo00?o001oooooooooool08oooool2o`0002Co
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02So
oooo0_l00007ooooo`002_ooool01_naIP3oG:GBooOgmoogmnkod/S=onkkoaSooooo00?o0000oooo
ooooool0:Oooool00ol007ooooooooooo`0Rooooo`03o`000?l007oooooo02Cooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000oooo
ooooool01Oooool000[ooooo00Koj/f[ofI1@Ol^@D7o@D4^o`00;_o2l_lHooooo`03o`000?oooooo
oooo02Wooooo00?o001oooooooooool08?ooool2o`000003ooooool007oooooo02Cooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000
ooooooooool01Oooool000kooooo00?oh=;Bonkkooooool05oooool00ol0003oooooooooo`0Yoooo
o`03o`00Oooooooooooo01oooooo00Go0000ooooooooooooooooo`00O`0Uooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooo
oooo00Gooooo0008ooooo`03ooOUcOo2d^Gooooo00Cooooo00?oooobomO=eoogool05_ooool00ol0
003oooooooooo`0Yooooo`03o`00Oooooooooooo01gooooo0_l00004ooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02Wooooo00?o0000ooooooooool01Oooool000Sooooo00Wooo_^ol:UROmLIWWoYKg8omcPh?oLem;o
]jFAofILI_nO`]`01?ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o
0000ooooooooool0:Oooool00ol007ooooooooooo`0Looooo`03o`000?oooooooooo00Cooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`002_ooool01_oonnkod/:goj^[Zon[
Zk7ob=OUoo_oo`Cooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000
00Cooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Jooooo`;o00001oooool00ol0
07ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol0
07ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Dooooo`04o`000?ooooooooooo`00
00Oooooo00Go0000ooooooooooooooooo`000004ooooo`?o0000A?l007l2o`000:Ko001o0_l00007
ooooo`005?ooool01?l0003oooooooooool00008ooooo`?o00001Oooool00ol0003oooooooooo`0Y
ooooo`03o`00Oooooooooooo01Kooooo0_l0000;ooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000
ooooooooool01Oooool001Cooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooo
oooo000000Cooooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Dooooo`;o00003Ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Dooooo`04o`000?oooooo
ooooo`0000Oooooo00Go0000ooooooooooooooooo`000004ooooo`03o`000?oooooooooo02Wooooo
00?o001oooooooooool04_ooool2o`0000oooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003ooooo
ooooo`05ooooo`005Oooool2o`0000Wooooo0ol00005ooooo`03o`000?oooooooooo02Wooooo00?o
001oooooooooool04?ooool2o`00017ooooo00?o001oooooooooool08oooool00ol007oooooooooo
o`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003ooooooooo
o`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo00kooooo0_l0000C
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000oooo
ooooool0:Oooool00ol007ooooooooooo`0<ooooo`;o00005Oooool00ol007ooooooooooo`0Soooo
o`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Yoooo
o`03o`000?oooooooooo00Gooooo000Xooooo`03o`000?oooooooooo02Wooooo00?o001ooooooooo
ool02_ooool2o`0001Oooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03
o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00
:?ooool2o`0002[ooooo00?o001oooooooooool02?ooool2o`0001Wooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
:?ooool2o`0000Oooooo000Xooooo`03o`000?oooooooooo02Wooooo00?o001oooooooooool01_oo
ool2o`0001_ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooo
oooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool0
0ol0003oooooooooo`0Yooooo`03o`00Oooooooooooo00Cooooo0_l0000Mooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool01?l0
07ooooooooooooooool3o`0001oooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0S
ooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05
ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`04o`00Oooooooo0000o`0002;ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Xoooo
o`?o00009?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`03
o`000?oooooooooo02Gooooo0ol000000ooooooo001oooooo`0Tooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wo
oooo00?o0000ooooooooool01Oooool002Sooooo0_l0000Sooooo`?o00001?ooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02Sooooo0_l00007ooooo`00:?ooool00ol0003ooooooooo
o`0Oooooo`?o00001oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o
0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool07?ooool3o`0000[ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xoooo
o`03o`000?oooooooooo01Wooooo0ol0000=ooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooo
ooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Dooooo`Go
00004?ooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001ooooooooo
ool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000oooooooo
ool01Oooool002Sooooo00?o0000ooooooooool02_ooool:o`0001Gooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0
8oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Xooooo`03o`000?oo
oooooooo00?ooooo1ol0000Oooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08ooo
ool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool0:Ooo
ool00ol0003oooooooooo`05ooooo`00:?ooool00ol0003oooooooooo`0Yooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooo
oooo02?ooooo00?o001oooooooooool0:Oooool00ol0003oooooooooo`05ooooo`00:?ooool2o`00
02[ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo
02?ooooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Xooooo`;o00001oooool002So
oooo00?o0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?o
oooo00?o001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wo
oooo00?o0000ooooooooool01Oooool002Sooooo00?o0000ooooooooool0:Oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001oooooooooool08oooool00ol007oooooo
ooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o0000ooooooooool01Oooool002Sooooo00?o
0000ooooooooool0:Oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o
001oooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02Wooooo00?o
0000ooooooooool01Oooool0023ooooo0ol00005ooooo`03o`000?oooooooooo02Wooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Sooooo`03o`00Oooooooooooo02?ooooo00?o001o
ooooooooool08oooool00ol007ooooooooooo`0Yooooo`03o`000?oooooooooo00Gooooo000Qoooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Soooo
o`03o`000?oooooooooo02?ooooo00?o0000ooooooooool08oooool00ol0003oooooooooo`0Soooo
o`03o`000?oooooooooo02?ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo00Gooooo000Qooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo00Gooooo000Qooooo`03o`00
0?oooooooooo00CooooolOl00007ooooo`008Oooool00ol0003oooooooooo`3looooo`008?ooool2
o`000?kooooo000Qooooo`03o`000?oooooooooo0?cooooo003oooooob7ooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.21506, -0.161707, \
0.0262312, 0.00673696}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    StyleBox[\(Mat  .2  .4 - Axial\ defocus\ \ approximation\ comparison;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(f = 
      4.8; \ \[Delta] =  .001;\), "\n", 
    RowBox[{\(dl = \(-1000\)\ \((Sqrt[
                  r\^2 + \((f - r\^2\/\(4\ f\) + \[Delta])\)\^2] - \((f + 
                    r\^2\/\(4\ f\) + \[Delta])\))\);\), " "}], "\n", 
    RowBox[{\(dm = 
          1000\ \[Delta]\ 2\ \((r\/\(2\ f\))\)\^2/\((1 + \((r\/\(2\ \
f\))\)\^2)\);\), "                                    "}], "\n", 
    RowBox[{\(db = 1422\ \[Delta]\ r\^2\/\(4\ f\^2\); 
      db1 = 1000\ \[Delta]\ r\^2\/\(4\ f\^2\);\), 
      "                                                                       \
   "}], "\n", \(Plot[{\ dl, \ db, dm, db1}, {r, 0, 6}, Frame -> True, \ 
      GridLines -> Automatic, 
      PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 
              0]}, {Dashing[{0.05, 0.05}], 
            RGBColor[0, 0, 1]}, {RGBColor[1, 0, 1]}}, 
      FrameLabel -> {"\<aperture radius (m)\>", "\<pathlength diff. (mm)\>"}]\
\), "\n", \(Plot[1000\ {\ dm - dl}, {r, 0, 6}, Frame -> True, \ 
      GridLines -> Automatic, 
      FrameLabel -> {"\<aperture radius (m)\>", "\<pathlength diff. \
(\[Mu]m)\>"}]\)}], "Input",
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  Background->GrayLevel[0.833326],
  CellTags->"i:1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 0.0147151 1.04771 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.34127 -0.0125 -3 -9 ]
[.34127 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -59.0625 -21 ]
[.5 -0.0125 59.0625 -9 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .11949 -18 -4.5 ]
[-0.0125 .11949 0 4.5 ]
[-0.0125 .22426 -18 -4.5 ]
[-0.0125 .22426 0 4.5 ]
[-0.0125 .32903 -18 -4.5 ]
[-0.0125 .32903 0 4.5 ]
[-0.0125 .4338 -18 -4.5 ]
[-0.0125 .4338 0 4.5 ]
[-0.0125 .53857 -18 -4.5 ]
[-0.0125 .53857 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -30 -65.0625 ]
[-0.01875 .30902 -18 65.0625 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .61803 L
s
.34127 0 m
.34127 .61803 L
s
.5 0 m
.5 .61803 L
s
.65873 0 m
.65873 .61803 L
s
.81746 0 m
.81746 .61803 L
s
0 .11949 m
1 .11949 L
s
0 .22426 m
1 .22426 L
s
0 .32903 m
1 .32903 L
s
0 .4338 m
1 .4338 L
s
0 .53857 m
1 .53857 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(1)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(2)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(3)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(4)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(5)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(6)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -120.063 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(aperture) show
117.000 13.000 moveto
(radius) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
159.000 13.000 moveto
(H) show
165.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
171.125 13.000 moveto
(L) show
177.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .11949 m
.00625 .11949 L
s
[(0.1)] -0.0125 .11949 1 0 Mshowa
0 .22426 m
.00625 .22426 L
s
[(0.2)] -0.0125 .22426 1 0 Mshowa
0 .32903 m
.00625 .32903 L
s
[(0.3)] -0.0125 .32903 1 0 Mshowa
0 .4338 m
.00625 .4338 L
s
[(0.4)] -0.0125 .4338 1 0 Mshowa
0 .53857 m
.00625 .53857 L
s
[(0.5)] -0.0125 .53857 1 0 Mshowa
.125 Mabswid
0 .03567 m
.00375 .03567 L
s
0 .05662 m
.00375 .05662 L
s
0 .07758 m
.00375 .07758 L
s
0 .09853 m
.00375 .09853 L
s
0 .14044 m
.00375 .14044 L
s
0 .1614 m
.00375 .1614 L
s
0 .18235 m
.00375 .18235 L
s
0 .2033 m
.00375 .2033 L
s
0 .24521 m
.00375 .24521 L
s
0 .26617 m
.00375 .26617 L
s
0 .28712 m
.00375 .28712 L
s
0 .30808 m
.00375 .30808 L
s
0 .34998 m
.00375 .34998 L
s
0 .37094 m
.00375 .37094 L
s
0 .39189 m
.00375 .39189 L
s
0 .41285 m
.00375 .41285 L
s
0 .45476 m
.00375 .45476 L
s
0 .47571 m
.00375 .47571 L
s
0 .49666 m
.00375 .49666 L
s
0 .51762 m
.00375 .51762 L
s
0 .55953 m
.00375 .55953 L
s
0 .58048 m
.00375 .58048 L
s
0 .60144 m
.00375 .60144 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -150.062 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
126.063 10 translate
90 rotate
-126.063 -10 translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(pathlength) show
129.000 13.000 moveto
(diff) show
153.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(.) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
165.000 13.000 moveto
(H) show
171.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(mm) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
183.125 13.000 moveto
(L) show
189.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .61178 m
.02381 .61803 L
s
.18254 .61178 m
.18254 .61803 L
s
.34127 .61178 m
.34127 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.65873 .61178 m
.65873 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.05556 .61428 m
.05556 .61803 L
s
.0873 .61428 m
.0873 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.15079 .61428 m
.15079 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.24603 .61428 m
.24603 .61803 L
s
.27778 .61428 m
.27778 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.37302 .61428 m
.37302 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.43651 .61428 m
.43651 .61803 L
s
.46825 .61428 m
.46825 .61803 L
s
.53175 .61428 m
.53175 .61803 L
s
.56349 .61428 m
.56349 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.62698 .61428 m
.62698 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.72222 .61428 m
.72222 .61803 L
s
.75397 .61428 m
.75397 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.84921 .61428 m
.84921 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.9127 .61428 m
.9127 .61803 L
s
.94444 .61428 m
.94444 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .11949 m
1 .11949 L
s
.99375 .22426 m
1 .22426 L
s
.99375 .32903 m
1 .32903 L
s
.99375 .4338 m
1 .4338 L
s
.99375 .53857 m
1 .53857 L
s
.125 Mabswid
.99625 .03567 m
1 .03567 L
s
.99625 .05662 m
1 .05662 L
s
.99625 .07758 m
1 .07758 L
s
.99625 .09853 m
1 .09853 L
s
.99625 .14044 m
1 .14044 L
s
.99625 .1614 m
1 .1614 L
s
.99625 .18235 m
1 .18235 L
s
.99625 .2033 m
1 .2033 L
s
.99625 .24521 m
1 .24521 L
s
.99625 .26617 m
1 .26617 L
s
.99625 .28712 m
1 .28712 L
s
.99625 .30808 m
1 .30808 L
s
.99625 .34998 m
1 .34998 L
s
.99625 .37094 m
1 .37094 L
s
.99625 .39189 m
1 .39189 L
s
.99625 .41285 m
1 .41285 L
s
.99625 .45476 m
1 .45476 L
s
.99625 .47571 m
1 .47571 L
s
.99625 .49666 m
1 .49666 L
s
.99625 .51762 m
1 .51762 L
s
.99625 .55953 m
1 .55953 L
s
.99625 .58048 m
1 .58048 L
s
.99625 .60144 m
1 .60144 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01473 L
.02846 .01473 L
.03053 .01476 L
.03279 .01479 L
.03527 .01483 L
.0379 .01489 L
.04262 .01503 L
.04749 .01522 L
.05205 .01543 L
.06244 .01606 L
.07305 .0169 L
.08274 .01784 L
.10458 .02058 L
.12357 .02366 L
.14429 .02773 L
.18493 .03788 L
.22406 .05028 L
.26565 .06619 L
.30571 .08404 L
.34426 .10344 L
.38527 .12632 L
.42475 .15037 L
.46273 .17522 L
.50315 .20336 L
.54206 .23193 L
.58342 .2637 L
.62326 .2955 L
.66159 .32703 L
.70238 .36143 L
.74164 .39522 L
.77939 .42819 L
.8196 .46368 L
.85828 .49808 L
.89942 .5348 L
.93905 .57018 L
.97619 .60326 L
s
0 1 0 r
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01473 L
.03053 .01474 L
.03279 .01477 L
.03527 .0148 L
.0379 .01484 L
.04262 .01494 L
.04749 .01507 L
.05205 .01523 L
.06244 .01567 L
.07305 .01627 L
.08274 .01694 L
.10458 .0189 L
.12357 .0211 L
.14429 .02403 L
.18493 .03137 L
.22406 .04045 L
.26565 .05224 L
.30571 .0657 L
.34426 .0806 L
.38527 .09854 L
.42475 .11786 L
.46273 .13832 L
.50315 .16214 L
.54206 .18704 L
.58342 .21565 L
.62326 .24528 L
.66159 .27571 L
.70238 .31015 L
.74164 .34533 L
.77939 .38102 L
.8196 .42104 L
.85828 .46151 L
.89942 .50665 L
.93905 .55218 L
.97619 .59669 L
s
0 0 1 r
[ .05 .05 ] 0 setdash
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01473 L
.02846 .01473 L
.03053 .01476 L
.03279 .01479 L
.03527 .01483 L
.0379 .01489 L
.04262 .01503 L
.04749 .01522 L
.05205 .01543 L
.06244 .01606 L
.07305 .0169 L
.08274 .01784 L
.10458 .02059 L
.12357 .02366 L
.14429 .02773 L
.18493 .03788 L
.22406 .05029 L
.26565 .0662 L
.30571 .08406 L
.34426 .10346 L
.38527 .12634 L
.42475 .15039 L
.46273 .17525 L
.50315 .20339 L
.54206 .23196 L
.58342 .26374 L
.62326 .29554 L
.66159 .32707 L
.70238 .36148 L
.74164 .39527 L
.77939 .42824 L
.8196 .46374 L
.85828 .49814 L
.89942 .53486 L
.93905 .57024 L
.97619 .60332 L
s
1 0 1 r
[ ] 0 setdash
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01472 L
.02846 .01472 L
.03053 .01474 L
.03279 .01475 L
.03527 .01477 L
.0379 .0148 L
.04262 .01487 L
.04749 .01497 L
.05205 .01508 L
.06244 .01539 L
.07305 .01581 L
.08274 .01628 L
.10458 .01766 L
.12357 .01921 L
.14429 .02126 L
.18493 .02643 L
.22406 .03281 L
.26565 .0411 L
.30571 .05057 L
.34426 .06105 L
.38527 .07367 L
.42475 .08725 L
.46273 .10164 L
.50315 .11839 L
.54206 .1359 L
.58342 .15602 L
.62326 .17686 L
.66159 .19825 L
.70238 .22248 L
.74164 .24722 L
.77939 .27232 L
.8196 .30046 L
.85828 .32892 L
.89942 .36066 L
.93905 .39268 L
.97619 .42398 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00KOooool3o`0005_ooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`19ooooo`00K_ooool00ol0003oooooooooo`1Iooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool0B?ooool006Sooooo1?l00002ooooo`?o00000oooool3o`0000;ooooo0ol0
0005ooooo`;o00001?ooool2o`000003ooooool0003o000000;o00001?ooool3o`0000Sooooo0ol0
0004ooooo`Co00000_ooool4o`000003ooooool0003o000000?o00000oooool2o`000003ooooool0
003o000000?o00002_ooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000004oooo
o`03o`000?oooooooooo04Oooooo001Wooooo`04o`000?ooooooooooo`0000?ooooo00Ko0000oooo
oooooooo0000ooooool00006ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00001?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Gooooo00?o
0000ooooooooool01oooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000004oooo
o`03o`000?oooooooooo04Oooooo001Xooooo`?o00000oooool01Ol0003oooooooooool0003ooooo
00Go00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`02ooooo`Go00002?ooool00ol0003oooooooooo`03
ooooo`?o00000_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00;ooooo00Co
0000oooooooooooo00000_ooool3o`0000[ooooo00Wo0000ooooooooooooooooo`000?oooooo0000
ooooool000001?ooool00ol0003oooooooooo`17ooooo`00Ioooool01?l0003oooooooooool00003
ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooooooo`02o`0000Cooooo
00?o0000ooooooooool00oooool01?l0003oooooooooool00002ooooo`;o00000oooool01Ol0003o
oooooooooooooooo000000Sooooo0_l00003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00001?ooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooo`000?oooooo
00003Oooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000004ooooo`03o`000?oo
oooooooo04Oooooo001Xooooo`;o00000oooool4o`0000?ooooo0ol00002ooooo`;o000000Cooooo
o`000?l0003ooooo1?l00002ooooo`;o000000Coooooo`000?l0003ooooo0_l000000ooooooo0000
o`000002ooooo`?o00002?ooool2o`000003ooooool0003o000000;ooooo0_l00004ooooo`?o0000
0_ooool3o`0000?ooooo0_l000000ooooooo0000o`000002ooooo`Co00002_ooool00ol0003ooooo
ooooo`02o`000003ooooool0003ooooo00?ooooo00?o0000ooooooooool0B?ooool0083ooooo00?o
0000ooooooooool0:Oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool0BOooool0083ooooo00?o0000ooooooooool0:?ooool2o`0000Cooooo00?o0000
ooooooooool0K?ooool00?oooooo8Oooool00?oooooo8Oooool002Wooooo0_l0000Uooooo`?o0000
8oooool5o`0002?ooooo0ol0000Vooooo`?o00008oooool3o`0002Cooooo0ol00009ooooo`00:?oo
ool01?l0003oooooooooool0000Uooooo`03o`000?oooooooooo02?ooooo00Co0000oooooooooooo
00008_ooool01Ol0003ooooooooooooooooo000002Kooooo00?o0000ooooooooool08Oooool01Ol0
003ooooooooooooooooo000002;ooooo00Go0000ooooooooooooooooo`000008ooooo`00:?ooool0
1?l0003oooooooooool0000Uooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool09_oo
ool00ol0003oooooooooo`0Qooooo`Go00009_ooool00ol0003oooooooooo`0Pooooo`05o`000?oo
ooooooooooooool000002?ooool002Sooooo00Co0000oooooooooooo00009Oooool00ol0003ooooo
ooooo`0Uooooo`03o`000?oooooooooo02?ooooo0_l0000Tooooo`04o`000?ooooooooooo`0002Oo
oooo00?o0000ooooooooool08?ooool4o`0000Wooooo000Xooooo`04o`000?ooooooooooo`0002Go
oooo00?o0000ooooooooool08_ooool01Ol0003ooooooooooooooooo000002Kooooo00?o0000oooo
ooooool08_ooool00ol0003oooooo`00000Sooooo`Co00008oooool00ol0003oooooooooo`0:oooo
o`00:?ooool01?l0003oooooooooool0000Tooooo`;o00009?ooool01Ol0003ooooooooooooooooo
000002;ooooo00Go0000ooooooooooooooooo`00000Uooooo`;o00008oooool00ol0003ooooooooo
o`0Uooooo`03o`000?oooooooooo00Wooooo000Yooooo`;o00009_ooool00ol0003oooooooooo`0S
ooooo`?o00009?ooool3o`0002Oooooo00?o0000ooooooooool08Oooool5o`0002Cooooo0_l00009
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`009Ooooooh
o`0000?ooooo000Nooooo`;o00001Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00Oooool001gooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool00ol0
003oooooooooo`01ooooo`007Oooool01?l0003oooooooooool00004ooooo`;o00000oooool=ool0
oa_ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Gooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Xooooo`?o00000oooool001go
oooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0<ooooo`?o003o4?oo0?l;oooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uoooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01oooo
o`007Oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo01Gooooo1Ooo0005o`3o
00Ooo`3o1?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooo
ooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo00?o0000oooo
ooooool00Oooool001gooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0Joooo
o`03ool00?l00?oo003o00;o003o1ol0o`08ool0ob?ooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool00ol0
003oooooooooo`01ooooo`007_ooool2o`0000Gooooo00?o0000ooooooooool07oooool6o`00o`03
ooooool0o`3o0?l000Go0?l000?oooooool0oooo0?l00ooo0?lNooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[o
oooo00?o0000ooooooooool00Oooool002Gooooo0_l0000Uooooo`07ool00?l00?oo003oo`00oooo
003oooooo`00O`02ooooo`?o0?l00oooool5ool0oaWooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:Oooool2o`00
00?ooooo000Uooooo`03o`000?oooooooooo02Wooooo1?oo0003ooooo`?o0?l01Oooool5ool0oaCo
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`009Oooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo00?oo`000oooool4o`3o00Kooooo1Ooo0?l?ooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02[ooooo00?o0000ooooooooool00Oooool002Gooooo00?o0000ooooooooool0:_oo
ool00ol007ooooooooooo`03ooooo`?oo`001?ooool3o`3o00Sooooo1Ooo0?l:ooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo02[ooooo00?o0000ooooooooool00Oooool002Gooooo00?o0000ooooooooool0:_ooool0
0ol007ooooooooooo`06ooooo`?o003o1?ooool3o`3o00[ooooo1?oo0?l6ooooo`03o`00Oooooooo
oooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02[ooooo00?o0000ooooooooool00Oooool002Gooooo00?o0000ooooooooool0:_ooool00ol0
07ooooooooooo`09ooooo`?o003o1?ooool4o`3o00[ooooo0ooo0?l3ooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02[ooooo00?o0000ooooooooool00Oooool000Kooooo00?oh;NOokOLl_ooool00_ooool00ooooo;o
_InUomcko`0Gooooo`;o0000:oooool00ol007ooooooooooo`0<ooooo`;o003o1_ooool3o`3o00[o
oooo0ooo0?l00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Yooooo`;o00000oooool000Kooooo00?odY51o`000?l00000
0ol000000ol0047ob?;oooooo`0Fooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
3_ooool3o`00o`Kooooo0ol0o`0:ooooo`Coo`3o8oooool00ol007ooooooooooo`0Uooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`001_oo
ool02?oU_GWo06J[oo;oooobg;7o;P22on[ol_n9;T7o`^ko5oooool00ol0003oooooooooo`0Zoooo
o`03o`00Oooooooooooo017ooooo00?o003oool00?ooool01_ooool3o`3o00Oooooo00Co001ooooo
oooooooooooo0ooo0?lPooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Zooooo`03o`000?oooooooooo007ooooo0006ooooo`08olR2@On9cOOooooo
oooomonA;T7o`_;komNm_OoUnolGooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
4oooool3ool000Oooooo0ol0o`04ooooo`03o`00Oooooooooooo00Cooooo0ooo0?lMooooo`03o`00
Oooooooooooo02Gooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`03o`00
0?oooooooooo007ooooo0006ooooo`06onZmNOl007Wod^GZomNgP_l007Woh?oo6Oooool00ol0003o
ooooooooo`0Zooooo`03o`00Oooooooooooo01Kooooo0_oo0008ooooo`;o0?l00_ooool00ol007oo
ooooooooo`07ooooo`Coo`3o6Oooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`001_ooool01Ooooo;o`YQ`
o`000?l0;Uco/MO^01[ooooo0_l0000[ooooo`03o`00Oooooooooooo01Sooooo0ooo0007ooooo`?o
0?l03Oooool3ool0oaKooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Wooooo0_l00003ooooo`002?ooool00ooooo;oelg=on3^n`0Jooooo`03o`00
0?oooooooooo02[ooooo00?o001oooooooooool06oooool2ool000Oooooo00?o001oo`3o0?l0o`00
3_ooool3ool0oa?ooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02[ooooo00?o0000ooooooooool00Oooool000Kooooo00Koj/:Aoh:acOnaL2ko02h0
o`00G?oBmolIooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool07Oooool2o`00o`Go
oooo00?o001oooooooooool00ol0o`0>ooooo`?oo`3o4?ooool00ol007ooooooooooo`0Uooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`00
1_ooool01_o8REcoTKfgog1?TOogoo_oV45?ol;^oaWooooo00?o0000ooooooooool0:_ooool00ol0
07ooooooooooo`0Oooooo`;o003o0oooool00ol007ooooooooooo`03ooooo`;o0?l03oooool2ool0
o`kooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02[ooooo00?o0000ooooooooool00Oooool000Kooooo00Kob8UVoio2/OmL@ISol__Log0^L?oGnolI
ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool08Oooool2o`00o`03ooooool007oo
oooo00Kooooo0ol0o`0>ooooo`?oo`3o2oooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooo
oooo02Cooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`001_ooool01_oU
_HWo0000o`000?l0003o001`omOgoaWooooo0_l0000[ooooo`03o`00Oooooooooooo02?ooooo0_l0
0?l:ooooo`;o0?l03oooool2ool0o`Wooooo00?o001oooooooooool09Oooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02Wooooo0_l00003ooooo`001oooool01OoomoOol_;boo_giOnA
CfKob?;o01Wooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Ool0
0?oo003o00[ooooo0_l0o`0?ooooo`;oo`3o1oooool00ol007ooooooooooo`0Uooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`001_ooool0
0oooj/go]lgZooooo`0Looooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool0
1Ol007ooooooooooool00?ooo`0000[ooooo0_l0o`0?ooooo`?oo`3o1?ooool00ol007oooooooooo
o`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool00ol0003ooooooooo
o`01ooooo`001?ooool01oooooOoh=OGokfOI_l0G9ood]OBolg=d_oUl_/01oooool2o`0000Cooooo
00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000ooooooooool0:_ooool00ol007oooooo
ooooo`0Tooooo`06o`00Ooooooooooooooooool00?ooo`002oooool2o`3o013ooooo0_oo0?l2oooo
o`03o`00Oooooooooooo02Gooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zoooo
o`03o`000?oooooooooo007ooooo0004ooooo`08ooooj_nUPW3oIU`^o`0^Com`NGWoL5a1o`00I_oG
nol5ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool00oooool2ool000_ooooo
0_l0o`0@ooooo`?oo`3o9oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo
00?o0000ooooooooool00Oooool000Kooooo00Konm:Aod69cOooooooooogoi4^@Oo2l_l5ooooo`04
o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool01?ooool2o`0005[o001o0_oo000;o`00
O`;o0?l04Ol007l2ool0ogOo001o0ol00003ooooo`001_ooool01_obcHWo@HW8oooooooonmOoG01?
olggo`Gooooo00Co0000oooooooooooo00002Oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`07ooooo`03ool00?oo
oooooooo00[ooooo0_l0o`0>ooooo`03o`00Oooooooooooo00?oo`3o8_ooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02[ooooo00?o0000ooooooooool00Oooool000Oooooo00Gonooo
ooooooool];oTIS2oo_oo`05ooooo`04o`000?ooooooooooo`0000Wooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
2?ooool2ool000cooooo0_l0o`0<ooooo`03o`00Oooooooooooo00?ooooo0_oo0?lPooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`001?oo
ool00oobh<god^[kooooo`03ooooo`03omO2`_oUnooooooo00Cooooo00Co0000oooooooooooo0000
2?ooool2o`0000Kooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo00[ooooo0_oo000<ooooo`03o`3o0?oooooooooo00Wooooo00?o001oooooooooool0
1Oooool3ool0oagooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`03o`00
0?oooooooooo007ooooo0004ooooo`08olf9;_l0003o@Dm?od51@Ol^;T7o@D4^o`00;_o8l_l6oooo
o`;o00002_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02[ooooo00?o001ooooo
ooooool09?ooool00ol007ooooooooooo`0;ooooo`;o003o3?ooool2o`3o00Wooooo00?o001ooooo
ooooool02?ooool2ool0oa_ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zoooo
o`03o`000?oooooooooo007ooooo0004ooooo`08oookl_o^l^ko`Y51obj2]ooZk^kok^kPojEiROoB
l_lIooooo`;o0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00gooooo0_l0
0?l<ooooo`;o0?l01oooool00ol007ooooooooooo`0:ooooo`;oo`3o6Oooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02Wooooo0_l00003ooooo`001_ooool01_o=PT7oP/Sboooooooo
ooooiM;Bon[koaWooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo00oooooo00?o003oool00?ooool02oooool2o`3o00Gooooo00?o001oooooooooool0
3?ooool2ool0oaOooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`03o`00
0?oooooooooo007ooooo0006ooooo`06on2gP_l0003o;T51od51;_l002kob?;o6Oooool00ol0003o
ooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool04?ooool2o`00o`go
oooo00?o0?l0ooooooooool00_ooool00ol007ooooooooooo`0>ooooo`;oo`3o5Oooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo00?o0000ooooooooool00Oooool000Oooooo
00Gomo;ZonGUj_o^k^3oWg1iolgbo`0Iooooo`03o`000?oooooooooo02[ooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Booooo`;o003o3?ooool2o`3o00;ooooo00?o001ooooooooo
ool04?ooool2ool0oa?ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`03
o`000?oooooooooo007ooooo000Uooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Dooooo`03o`00oooooooooooo00_ooooo0_l0o`000ol007oooooo
ooooo`0Booooo`;oo`3o4Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo
00?o0000ooooooooool00Oooool000Cooooo00?oh;69oioBl_ooool00_ooool00oooooOoV45?ol;b
o`0Iooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oooooooooo
o`0Eooooo`03o`00oooo003ooooo00cooooo00?o0?l0ooooooooool05?ooool2ool0o`oooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`03o`000?oooooooooo007ooooo0004
ooooo`03olR2;_mLV<;oemOB00;od];B00?oemO2og0^Coo8l_l06Oooool2o`0002_ooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Fooooo`03o`00oooo003ooooo00_ooooo00?o001o
o`3o0?l0o`005_ooool2ool0o`gooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Y
ooooo`;o00000oooool000Cooooo00?oj/RUog1`L?m`L7000_m`L7000om`L6Ko001?olSbo`0Ioooo
o`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Hoooo
o`;oo`002_ooool00ol007ooooooooooo`02o`3o01Kooooo0_oo0?l;ooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`002Oooool00oooooOo
TBi1ol;bo`0Iooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Jooooo`03ool00?oooooooooo00Oooooo00?o001oooooooooool00_ooool00ol0o`3o
ooooooooo`0Eooooo`;oo`3o2Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[o
oooo00?o0000ooooooooool00Oooool000Wooooo00?ooookolfa]ooPmol06Oooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool06oooool2ool000Oooooo
00?o001oooooooooool00oooool2o`3o01Oooooo0_oo0?l7ooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`001oooool01?ogiM;o]k6[ok6m
cOoboolJooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Mooooo`03ool00?oooooooooo00Cooooo00?o001oooooooooool01Oooool2o`3o01Oooooo
00?oo`3oooooooooool01?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo
00?o0000ooooooooool00Oooool000Kooooo00Kol]:Oo`000?l0003o0000o`11V?o^oolIooooo`;o
0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01kooooo0_oo0004ooooo`03
o`00Oooooooooooo00Oooooo00?o0?l0ooooooooool05Oooool2ool0o`Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Yooooo`;o00000oooool000Kooooo00Ko`X9?oiS=g?nOCeco
d__boiQ1Coo2k_lIooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Pooooo`05ool00?ooooooooooooooool007l02_ooool2o`3o01Oooooo00Goo`3o
ooooooooooooooooo`00O`0Vooooo`03o`00Oooooooooooo02[ooooo00?o0000ooooooooool00Ooo
ool000Kooooo00Ko]g1Lokg^k_nUCecocO_kok5VI_o2k_lIooooo`03o`000?oooooooooo02[ooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Pooooo`;o003o0_ooool00ol007oooooo
ooooo`0:ooooo`03o`3o0?oooooooooo01Gooooo0_oo0?l00ooooooo001oooooo`0Uooooo`03o`00
Oooooooooooo02[ooooo00?o0000ooooooooool00Oooool000Kooooo00Koh;5`o`00;_l004oob>G=
odl0G?oGnolIooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Rooooo`;o003o00?o001oooooooooool02oooool2o`3o01Oooooo00?oo`3oo`00Oooo
ool09Oooool00ol007ooooooooooo`0Zooooo`03o`000?oooooooooo007ooooo0006ooooo`05oooo
nooB/I7oIW2Hom;G_OnHZm806_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool09?ooool00ol00?ooooooooooo`0=ooooo`03o`3o0?oooooooooo01Go
oooo0_oo0?lUooooo`03o`00Oooooooooooo02[ooooo00?o0000ooooooooool00Oooool000Kooooo
00Koj];8omO^ooooooooooooomc8b?oZnolIooooo`;o0000:oooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oo`00ool00?l03_ooool00ol0o`3oooooooooo`0Doooo
o`04o`00Ooooooooo`3oool0ob?ooooo00?o001oooooooooool0:Oooool2o`0000?ooooo0006oooo
o`06olf9;_l002koCdm?odm?;_l002ko`_;o6Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool09?ooool01?l007ooooooooooool00?l>ooooo`;o0?l0
5?ooool01Ol007ooooooooooooooooooo`3o02;ooooo00?o001oooooooooool0:_ooool00ol0003o
ooooooooo`01ooooo`001_ooool01_oLYEco@H:aonGZj_o^k]coWgV2om;boaWooooo00?o0000oooo
ooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00Ko001ooooo
ooooooooooooo`00oooo000>ooooo`03o`3o0?oooooooooo017ooooo00?o001oooooooooool00_oo
ool2ool0ob3ooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`001_ooool0
1_o8PT7oP/SbooooooooooooiM;Bon[ko`Kooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go
00001?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`02ooooo`03o`00oooo003ooooo00gooooo0_l0o`0Aooooo`03
o`00Oooooooooooo00Cooooo0_oo0?lNooooo`03o`00Oooooooooooo02[ooooo00?o0000oooooooo
ool00Oooool000Kooooo00Koh;5io`000?m1@DooCd4^o`00;_o8l_l5ooooo`04o`000?oooooooooo
o`0000Sooooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`03ooooo`03o`00oooo
003ooooo00kooooo00?o0?l0ooooooooool03_ooool00ol007ooooooooooo`06ooooo`03ool0oooo
oooooooo01_ooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`001oooool0
1Oogk^[oiNGUon[Zg?nOL7WocO;o00Gooooo00Co0000oooooooooooo00002Oooool00ol0003ooooo
ooooo`04ooooo`;o0000POl007l2ool000ko001o0_l0o`0Ho`00O`;oo`3oA_l007l3o`0000?ooooo
0007ooooo`03ooogj_oBcLgoenGb00Oooooo00Co0000oooooooooooo00002_ooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo00Oooooo00?oo`00ooooooooool03Oooool00ol0o`3ooooo
ooooo`0;ooooo`03o`00Oooooooooooo00Wooooo0_oo0?lIooooo`03o`00Oooooooooooo02[ooooo
00?o0000ooooooooool00Oooool000Kooooo00SonnFgobh00?m1G5co0000ofJ[g?ooooooj^3Uoo_o
o`?ooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo000000Cooooo00?o
0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool02?ooool2ool000kooooo00?o0?l0ooooooooool02_ooool00ol007oooooooooo
o`0;ooooo`03ool0oooooooooooo01Kooooo00?o001oooooooooool0:_ooool00ol0003ooooooooo
o`01ooooo`001_ooool02?o=TDooI[7Pooooooooj[Oo;RjAooOoj_mi02ko`_;o0oooool01?l0003o
ooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Z
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0:
ooooo`03ool00?oooooooooo00cooooo0_l0o`0:ooooo`03o`00Oooooooooooo00cooooo0_oo0?lF
ooooo`03o`00Oooooooooooo02[ooooo00?o0000ooooooooool00Oooool000Kooooo00SodYQLog2a
h?ooooooonZgod5?YOokon3oIP1?olggo`Cooooo0_l00009ooooo`?o00001Oooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0;ooooo`03ool00?oooooooooo00gooooo00?o0?l0ooooooooool01oooool00ol007oooooo
ooooo`0>ooooo`;oo`3o5?ooool00ol007ooooooooooo`0Zooooo`03o`000?oooooooooo007ooooo
0006ooooo`07ombUI_l0003oCfIVobh00?l0003o@@00obj2_@0Hooooo`;o0000:oooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool03?ooool00ooo003o
ooooooooo`0=ooooo`;o0?l01oooool00ol007ooooooooooo`0@ooooo`03ool0oooooooooooo017o
oooo00?o001oooooooooool0:Oooool2o`0000?ooooo0006ooooo`03om:HI_n2/M;oiN3P00;oh>3P
00?oh>3Zoo_oooooool05oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0=ooooo`;o003o3oooool00ol0o`3ooooo
ooooo`04ooooo`03o`00Oooooooooooo017ooooo0_oo0?lAooooo`03o`00Oooooooooooo02[ooooo
00?o0000ooooooooool00Oooool000Kooooo00?oon[=okO=j_ooool07?ooool00ol0003ooooooooo
o`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooooooo
o`0?ooooo`03o`00oooooooooooo00gooooo00?o0?l0ooooooooool00oooool00ol007oooooooooo
o`0Cooooo`03ool0oooooooooooo00kooooo00?o001oooooooooool0:_ooool00ol0003ooooooooo
o`01ooooo`001?ooool01oooooOoh=OGokfOI_l0G9ood]OBolg=d_oUl_/06_ooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0@ooooo`03o`00oooooooooooo00gooooo00?o0?l0ooooooooool00_ooool00ol007oooooo
ooooo`0Dooooo`;oo`3o3_ooool00ol007ooooooooooo`0Zooooo`03o`000?oooooooooo007ooooo
0004ooooo`08ooooj_nUPW3oIU`^o`0^Com`NGWoL5a1o`00I_oGnolIooooo`03o`000?oooooooooo
02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
017ooooo00?o003oooooooooool03Oooool01Ol0o`3ooooooooooooooooo001o01Sooooo00?oo`3o
ooooooooool02oooool00ol007ooooooooooo`0Zooooo`03o`000?oooooooooo007ooooo0006oooo
o`06oo_BTOm1RLgooooooooomonA;T7o`_;o6Oooool2o`0002_ooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01;ooooo0_l00?l>ooooo`04o`3o0?oo
ooooooooo`00OaWooooo0_oo0?l;ooooo`03o`00Oooooooooooo02Wooooo0_l00003ooooo`001_oo
ool01_obcHWo@HW8oooooooonmOoG01?olggoaWooooo00?o0000ooooooooool0:_ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool05?ooool00ol00?oo
ooooooooo`0<ooooo`03o`3o0?oooooo001o01_ooooo00?oo`3oooooooooool02?ooool00ol007oo
ooooooooo`0Zooooo`03o`000?oooooooooo007ooooo0007ooooo`05oo_ooooooooooo;Boi6H`_ok
ool06Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Eooooo`03o`00oooooooooooo00cooooo00?o0?l0o`00Oooo
ool06oooool2ool0o`Sooooo00?o001oooooooooool0:_ooool00ol0003oooooooooo`01ooooo`00
1?ooool00oobh<god^[kooooo`03ooooo`03omO2`_oUnooooooo01Sooooo00?o0000ooooooooool0
:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
5_ooool00ol00?ooooooooooo`0<ooooo`;o0?l07Oooool00ooo0?ooooooooooo`05ooooo`03o`00
Oooooooooooo02[ooooo00?o0000ooooooooool00Oooool000Cooooo00SocHT^o`000?m1Cdoo@D51
obh^@Om1@Bko000^olSboaWooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool05oooool00ol00?ooo`00ooooo`0;oooo
o`03o`00Oooooooo0?l001gooooo0_oo0?l5ooooo`03o`00Oooooooooooo02[ooooo00?o0000oooo
ooooool00Oooool000Cooooo00Sooo_bonkbk_o2TD7o;X:gon[^k_o^k^3oYGV9om;boaWooooo00?o
0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool06Oooool00ooo003oooooooooo`09ooooo`04o`00Ooooooooooooo`3o01kooooo
00?oo`3oooooooooool00_ooool00ol007ooooooooooo`0Zooooo`03o`000?oooooooooo007ooooo
0006ooooo`06olf2@On2b?;ooooooooooooUd];oj__o6Oooool2o`0002_ooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01[ooooo00?oo`00oooooooo
ool02?ooool01Ol007oooooooooooooooooo0?l001kooooo00Goo`3oooooooooooooooooo`00O`0[
ooooo`;o00000oooool000Kooooo00Koh;N2o`000?l^@D7o@D4^o`00;_o8l_lIooooo`03o`000?oo
oooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo01_ooooo00?oo`00ooooooooool01oooool00ol007ooooooooooo`02ooooo`;o0?l07Ooo
ool2ool0o`03ooooool007oooooo02_ooooo00?o0000ooooooooool00Oooool000Oooooo00Gomo;Z
onGUj_o^k^3oWg1iolgbo`0Iooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01cooooo0_oo0007ooooo`03o`00Oooo
oooooooo00Cooooo00?o0?l0ooooooooool07?ooool00ooo0?oo001oooooo`0[ooooo`03o`000?oo
oooooooo007ooooo000Uooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01kooooo00?oo`00ooooooooool01?ooool0
0ol007ooooooooooo`05ooooo`03o`3o0?oooooooooo01cooooo0_oo0?l[ooooo`03o`000?oooooo
oooo007ooooo000Uooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo01oooooo00?oo`00ooooooooool00oooool00ol0
07ooooooooooo`06ooooo`03o`3o0?oooooooooo01_ooooo00?o001ooooooooo0?l0:_ooool00ol0
003oooooooooo`01ooooo`009Oooool2o`0002_ooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo023ooooo00?oo`00ooooooooool00_ooool00ol007oo
ooooooooo`07ooooo`;o0?l06oooool00ol007ooooooooooo`02ool0obOooooo0_l00003ooooo`00
9Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Pooooo`;o003o0oooool00ol007ooooooooooo`09ooooo`03o`3o
0?oooooooooo01Sooooo00?o001oooooooooool00_ooool00ooo0?ooooooooooo`0Uooooo`03o`00
0?oooooooooo007ooooo000Uooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02;ooooo00Co003ooooooooooooo001o
3?ooool00ol0o`3oooooooooo`0Gooooo`03o`00Oooooooooooo00?ooooo00?oo`3oooooooooool0
9?ooool00ol0003oooooooooo`01ooooo`004_ooool2o`0000Cooooo00?o0000ooooooooool00_oo
ool3o`0000Gooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool08oooool00ol00?ooooooo`00O`0=ooooo`03o`3o0?oo
oooooooo01Kooooo00?o001oooooooooool01?ooool2ool0obCooooo00?o0000ooooooooool00Ooo
ool000Oooooo00ComnG=ojFHTOnOZkgoj__o1_ooool01?l0003oooooooooool00007ooooo`05o`00
0?ooooooooooooooool000001?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00ool007oooooo00go
oooo00?o0?l0ooooooooool05Oooool00ol007ooooooooooo`06ooooo`03ool0oooooooooooo027o
oooo00?o0000ooooooooool00Oooool000Kooooo00KommbUo`000?m`RI7oNDl0o`00P_oUool5oooo
o`04o`000?ooooooooooo`0000_ooooo00?o0000ooooooooool00_ooool2o`000:7o001o0_l00?l>
o`00O`03o`3o0?l007oo001o01ko001o0_oo0?lOo`00O`?o00000oooool000Kooooo00KocHU?og2m
j_ooooooooo^ohT^@Oo2k_l5ooooo`04o`000?ooooooooooo`0000Wooooo0_l00005ooooo`03o`00
0?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02Gooooo00?o001oooooool00?l03_ooool00ol0o`3oooooooooo`0Cooooo`03o`00
Oooooooooooo00Wooooo00?oo`3oooooooooool07_ooool00ol0003oooooooooo`01ooooo`001?oo
ool02?o^ekgocNkoonFUI_mVZn3oooooooooiOn2;UcocO;o1Oooool01?l0003oooooooooool0000;
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool01?l007ooooooooooool0
0?l>ooooo`03o`3o0?oooooooooo01;ooooo00?o001oooooooooool02_ooool00ooo0?oooooooooo
o`0Mooooo`03o`000?oooooooooo007ooooo0004ooooo`08olR20?l0@G3oPVH0o`000?m?L7WoG2h0
o`00@OoBnol5ooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004
ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Gooooo00Go001oooooooooooooooooo`00o`0>ooooo`03o`3o0?oo
oooooooo017ooooo00?o001oooooooooool02oooool00ooo0?ooooooooooo`0Looooo`03o`000?oo
oooooooo007ooooo0004ooooo`08oo_^h?o=b<SocLg=om;Bd_o=cLgod];8oh9?G?o8l_l6ooooo`;o
00002Oooool3o`0000Gooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`02ooooo`03
o`00oooo003ooooo00cooooo00?o0?l0ooooooooool04?ooool00ol007ooooooooooo`0<ooooo`;o
o`3o7?ooool00ol0003oooooooooo`01ooooo`002_ooool00oogl_;onoooooooo`0Hooooo`;o0000
:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
9Oooool00ol007ooooooooooo`04ooooo`03ool00?oooooooooo00_ooooo00?o0?l0ooooooooool0
3oooool00ol007ooooooooooo`0>ooooo`03ool0oooooooooooo01Sooooo0_l00003ooooo`001_oo
ool01_oP_J_ob>[koooooooooo;oTBi1ol;boaWooooo00?o0000ooooooooool0:_ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007oo
ooooooooo`05ooooo`03ool00?oooooooooo00_ooooo00?o0?l0ooooooooool03_ooool00ol007oo
ooooooooo`0?ooooo`03ool0oooooooooooo01Sooooo00?o0000ooooooooool00Oooool000?ooooo
00Wooookomc8]oo8h>kocHT^odnH`_oPg=cog=c8og0^Coo8l_l06Oooool00ol0003oooooooooo`0Z
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0U
ooooo`03o`00Oooooooooooo00Kooooo00?oo`00ooooooooool02oooool00ol0o`3oooooooooo`0=
ooooo`03o`00Oooooooooooo013ooooo00?oo`3oooooooooool05oooool00ol0003oooooooooo`01
ooooo`000oooool01?oooo;oYE`0oebUeooP`YP2oeaLG003ofIVG?l004oob?;o01Wooooo00?o0000
ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool09Oooool00ol007ooooooooooo`07ooooo`;oo`003?ooool00ol0o`3oooooooooo`0<
ooooo`03o`00Oooooooooooo017ooooo0_oo0?lGooooo`03o`000?oooooooooo007ooooo0009oooo
o`03oooomonA;T7o`_;o01Wooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`09oooo
o`03ool00?oooooooooo00[ooooo00?o0?l0ooooooooool02oooool00ol007ooooooooooo`0Coooo
o`03ool0oooooooooooo01Cooooo00?o0000ooooooooool00Oooool000Wooooo00?oooogol:OWooG
mol06Oooool2o`0002_ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Gooooo00?o001oooooooooool02_ooool00ooo003oooooooooo`0:ooooo`03
o`3o0?oooooooooo00[ooooo00?o001oooooooooool05?ooool00ooo0?ooooooooooo`0Booooo`;o
00000oooool002Gooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0;ooooo`03ool0
0?oooooooooo00[ooooo00?o0?l0ooooooooool02Oooool00ol007ooooooooooo`0Eooooo`03ool0
oooooooooooo01;ooooo00?o0000ooooooooool00Oooool000Kooooo00KoeiQLohW8l_ooooooooog
oiQ1Coo2l_lIooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool02oooool2o`00o`03
ool00?oooooooooo00Wooooo00?o0?l0ooooooooool02?ooool00ol007ooooooooooo`0Fooooo`;o
o`3o4_ooool00ol0003oooooooooo`01ooooo`001?ooool01?ool]OoRE`^o`000?l0;Rh2obh^;P03
o`00Coo8l_oooooo01Sooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0=ooooo`03
o`00oooo003ooooo00[ooooo00?o0?l0ooooooooool01oooool00ol007ooooooooooo`0Hooooo`03
ool0oooooooooooo00oooooo00?o0000ooooooooool00Oooool000Cooooo00Sok/R2od62]onmREco
NK7Gonk^j_o^k]OoPRi?ol;boaWooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0>
ooooo`;o003o2oooool00ol0o`3oooooooooo`06ooooo`03o`00Oooooooooooo01Wooooo00?oo`3o
ooooooooool03_ooool00ol0003oooooooooo`01ooooo`001?ooool02?oBV47oCj_LomNHComi`^ko
ooooooool_n9;T7o`_;o6Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo013ooooo
00?o003oooooooooool02Oooool00ol0o`3oooooooooo`05ooooo`03o`00Oooooooooooo01[ooooo
00?oo`3oooooooooool03Oooool00ol0003oooooooooo`01ooooo`001?ooool01?okiLgo]lgZoook
k_o^mo/2ooooo`03ooObl_okoooooooo01Sooooo0_l0000[ooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo017ooooo
00?o003oooooooooool02Oooool00ol0o`3oooooooooo`04ooooo`03o`00Oooooooooooo01_ooooo
0_oo0?l<ooooo`;o00000oooool002Gooooo00?o0000ooooooooool0:_ooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007oooooooooo
o`0Booooo`03o`00oooooooooooo00Wooooo00?o0?l0ooooooooool00oooool00ol007oooooooooo
o`0Mooooo`03ool0oooooooooooo00[ooooo00?o0000ooooooooool00Oooool000Kooooo00KoeiQL
ohW8l_ooooooooogoiQ1Coo2l_lIooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool0
4oooool00ol00?ooooooooooo`09ooooo`03o`3o0?oooooooooo00;ooooo00?o001oooooooooool0
7_ooool00ooo0?ooooooooooo`09ooooo`03o`000?oooooooooo007ooooo0004ooooo`04ooobeon9
G2ko0000o`0^;P;o;Rh^00?o001?olSbooooool06?ooool00ol0003oooooooooo`0Zooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00
Oooooooooooo01Cooooo00?o003oooooooooool02Oooool01Ol0o`3ooooooooooooooooo001o027o
oooo00?oo`3oooooooooool02?ooool00ol0003oooooooooo`01ooooo`001?ooool02?o^b8;o@H:g
okf9G?mi/MOok^kZonk^eon2;Too`_;o6Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooo
oooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooo
oooo01Gooooo00?o003oooooooooool02Oooool01?l0o`3oooooooooool007lRooooo`03ool0oooo
oooooooo00Oooooo00?o0000ooooooooool00Oooool000Cooooo00SodYQ1odn[g?oGV4ooNL;^oooo
oooooo;oRBi1ol;boaWooooo0_l0000[ooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo01Kooooo00?oo`00oooooooo
ool02Oooool00ol0o`3oooooo`00O`0Sooooo`03ool0oooooooooooo00Gooooo0_l00003ooooo`00
1?ooool01?okiLgo]lgZoookk_o^mo/2ooooo`03ooObl_okoooooooo01Sooooo00?o0000oooooooo
ool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09Oooool00ol007ooooooooooo`0Gooooo`03ool00?oooooooooo00Wooooo00?o0?l0o`00Oooo
ool08oooool00ooo0?ooooooooooo`05ooooo`03o`000?oooooooooo007ooooo000Booooo`;o0000
1?ooool00ol0003oooooooooo`03ooooo`?o00001?ooool00ol0003oooooooooo`0Zooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00
Oooooooooooo01Sooooo00?oo`00ooooooooool02Oooool00ol0o`3oooooooooo`0Sooooo`03ool0
oooooooooooo00Cooooo00?o0000ooooooooool00Oooool0017ooooo00Co0000oooooooooooo0000
2_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool0
6Oooool00ooo003oooooooooo`08ooooo`03o`00Ool0o`3ooooo02Cooooo00?oo`3oooooooooool0
0oooool00ol0003oooooooooo`01ooooo`002Oooool00oo=WfKo001`omOgo`05ooooo`04o`000?oo
ooooooooo`0000Oooooo1Ol00004ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool0
6_ooool2ool000Sooooo00?o001oooooool0o`00:_ooool00ol0003oooooooooo`01ooooo`002Ooo
ool00onaIP3o0011olSbo`05ooooo`04o`000?ooooooooooo`0000Oooooo00Co0000oooooooooooo
00001Oooool2o`000<3o001o00?oo`00o`00Ool007l02?l007l00ol0o`3o001oo`00O`0Uo`00O`?o
00000oooool000Wooooo00?ooo_^onGZl_ooool01Oooool01?l0003oooooooooool00008ooooo`03
o`000?oooooo000000Gooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Mooooo`03
ool00?oooooooooo00Cooooo00Go001oooooooooooooooooo`3o000Xooooo`03o`000?oooooooooo
007ooooo000Aooooo`04o`000?ooooooooooo`0000Wooooo0_l00005ooooo`03o`000?oooooooooo
02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Gooooo00?o001oooooooooool07_ooool2o`00o`Cooooo00?o001oooooooooool00_ooool00ol0
o`3oooooooooo`0Uooooo`03o`000?oooooooooo007ooooo000Booooo`;o00002oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool07oooool00ooo003o
003oooooo`02ooooo`03o`00Oooooooooooo00?ooooo00?o0?l0ooooooooool09?ooool00ol0003o
ooooooooo`01ooooo`009Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo027ooooo
00Co003ooooooooooooo001o1_ooool00ol0o`3oooooooooo`0Sooooo`03o`000?oooooooooo007o
oooo000Uooooo`;o0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09Oooool00ol007ooooooooooo`0Rooooo`03o`00oooooooo001o00Oooooo
00?o0?l0ooooooooool08Oooool2o`0000?ooooo000Uooooo`03o`000?oooooooooo02[ooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o
001oooooooooool08oooool00ol00?oo001oooooo`07ooooo`03o`3o0?oooooooooo027ooooo00?o
0000ooooooooool00Oooool002Gooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0T
ooooo`03o`00oooo003ooooo00Oooooo00?o0?l0ooooooooool08?ooool00ol0003oooooooooo`01
ooooo`009Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001ooooo
ooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oo`00
oooo00001oooool00ol0o`3oooooooooo`0Pooooo`03o`000?oooooooooo007ooooo000Uooooo`03
o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Gooooo00?o001oooooooooool09?ooool01?l007ooooooo`00oooo0007oooo
o`03o`3o0?oooooooooo01oooooo00?o0000ooooooooool00Oooool002Gooooo0_l0000[ooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03
o`00Oooooooooooo02Cooooo00Go001ooooooooooooo003oool00007ooooo`03o`3o0?oooooooooo
01gooooo0_l00003ooooo`001oooool01?okmnkoiN3Pon3Uj_ogoolJooooo`03o`000?oooooooooo
02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Gooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`02ooooo`03ool00?oooooooooo
00Gooooo00?o0?l0ooooooooool07Oooool00ol0003oooooooooo`01ooooo`001Oooool02?obh<So
RFILoeaVNOnHWjGoWiRAog1VG?m`RJ_og?;k6?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool00oooool00ooo003oooooooooo`05ooooo`03o`3o0?oo
oooooooo01cooooo00?o0000ooooooooool00Oooool000Cooooo00?ommbgoh:A/OoPl_/01?ooool0
0oo^h<;oTI6goo;oo`0Gooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`04ooooo`03ool00?oooooooooo00Gooooo00?o0?l0ooooooooool06oooool0
0ol0003oooooooooo`01ooooo`009Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool01Oooool00ooo003oooooooooo`05ooooo`03o`3o0?oooooooooo
01[ooooo00?o0000ooooooooool00Oooool000Kooooo00KocI5LofJO`_oGem;oemO8ogU1G?o8l_lI
ooooo`;o0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00Kooooo00?oo`00
ooooooooool01Oooool00ol0o`3oooooooooo`0Hooooo`;o00000oooool000Kooooo00KodYQ?o`0^
G?miNGWoNGUVo`00;_o8l_lIooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`07ooooo`;oo`001_ooool00ol0o`3oooooooooo`0Hooooo`03o`000?oo
oooooooo007ooooo0006ooooo`06okM`0?mLYLgok^kZon[ZiOo8]kgoiO_o6Oooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool02Oooool00ooo003ooooo
ooooo`04ooooo`03o`3o0?oooooooooo01Oooooo00?o0000ooooooooool00Oooool000Kooooo00Ko
g:]Vo`00;_mLG5coG5a?o`00;_o2l_lIooooo`03o`000?oooooooooo02[ooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`09ooooo`;o003o1_ooool00ol0o`3oooooooooo`0Fooooo`03
o`000?oooooooooo007ooooo0006ooooo`06ok5V0?mLYM;omoOgooOgk_oBb<gok__o6Oooool00ol0
003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool02oooool00ol0
0?ooooooooooo`03ooooo`03o`3o0?oooooooooo01Kooooo00?o0000ooooooooool00Oooool000Ko
oooo00Koj/f[ofI1@Ol^@D7o@D4^o`00;_o2l_lIooooo`03o`000?oooooooooo02[ooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0<ooooo`03o`00oooooooooooo00?ooooo00?o0?l0
ooooooooool05Oooool00ol0003oooooooooo`01ooooo`001_ooool01_o=TEcoIYo2omOGd_oGelSo
JSI<ok_^oaWooooo0_l0000[ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool03Ooo
ool00ol00?ooooooooooo`03ooooo`03o`3o0?oooooooooo01?ooooo0_l00003ooooo`001_ooool0
1_oBV4oo02iLogUiNOmiNFKo000^olSboaWooooo00?o0000ooooooooool0:_ooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo00kooooo00?o003oooooooooool00oooool00ol0o`3ooooo
ooooo`0Cooooo`03o`000?oooooooooo007ooooo0006ooooo`06okM`0?mLYLgok^kZon[ZiOo8]kgo
iO_o1_ooool2o`0000Cooooo00?o0000ooooooooool00_ooool3o`0000Gooooo00?o0000oooooooo
ool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00oooooo00?o003ooooooooo
ool00oooool00ol0o`3oooooooooo`0Booooo`03o`000?oooooooooo007ooooo0006ooooo`06omb[
I_l002koG5aLoeaLCol002ko`_;o1Oooool01?l0003oooooooooool00007ooooo`05o`000?oooooo
ooooooooool000001?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool04?ooool00ol00?ooooooooooo`03ooooo`03o`3o0?oooooooooo017ooooo00?o
0000ooooooooool00Oooool000Kooooo00Ko/FH0oebUd_ogmoOomoO^om;8cOo^nol5ooooo`04o`00
0?ooooooooooo`0000_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Zooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool04Oooool2o`00o`Cooooo00?o0?l0oooooooo
ool04?ooool00ol0003oooooooooo`01ooooo`001_ooool01_oZcJ_oIT51obi1@Om1@Bko000^ol;b
o`Gooooo00Co0000oooooooooooo00002oooool00ol0003oooooooooo`02ooooo`;o0000g_l007l0
0ol00?oo001oo`00O`02o`00O`03o`3o0?l007oo001o00go001o0ol00003ooooo`002_ooool00ooP
d];ok__oooooo`04ooooo`04o`000?ooooooooooo`0000Oooooo1?l00005ooooo`03o`000?oooooo
oooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02Gooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Dooooo`03ool00?oooooo
oooo00;ooooo00?o0?l0ooooooooool03_ooool00ol0003oooooooooo`01ooooo`001?ooool00oog
iLgo`];Uooooo`04ooooo`03ooool_oGcMOomooo00?ooooo00Co0000oooooooooooo00001oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Eooooo`03ool00?oooooooooo00;ooooo00?o0?l0ooooooooool03Oooool0
0ol0003oooooooooo`01ooooo`001?ooool02Ooonnko`ZF9oeaVNOnU_LSog>3PomcGd_ngYI7oIUaV
oio2g005ooooo`;o00002?ooool5o`0000Cooooo00?o0000ooooooooool0:_ooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo01Kooooo00?oo`00ooooooooool00_ooool00ol0o`3ooooo
ooooo`0<ooooo`03o`000?oooooooooo007ooooo0006ooooo`06oookk_oB`[OoZj^[oj^[/Oo8enGo
nooo6Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool05oooool01Ooo003ooooooooooooooooo0?l000kooooo00?o0000ooooooooool00Oooool002Go
oooo0_l0000[ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool06?ooool01Ooo003o
oooooooooooooooo0?l000cooooo0_l00003ooooo`009Oooool00ol0003oooooooooo`0Zooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool06Oooool01Ooo003ooooooooooooooooo0?l0
00cooooo00?o0000ooooooooool00Oooool002Gooooo00?o0000ooooooooool0:_ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo01[ooooo00Goo`00ooooooooooooooooo`3o000;oooo
o`03o`000?oooooooooo007ooooo000Uooooo`03o`000?oooooooooo02[ooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Kooooo`;oo`000_ooool00ol0o`3oooooooooo`08ooooo`03
o`000?oooooooooo007ooooo000Uooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Looooo`;o003o0_ooool00ol0o`3oooooooooo`07ooooo`03o`00
0?oooooooooo007ooooo000Uooooo`;o0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo01kooooo00?o003oooooool0o`002?ooool2o`0000?ooooo000Uooooo`03o`000?oooooo
oooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02Gooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Oooooo`03o`00oooooooo
0?l000Sooooo00?o0000ooooooooool00Oooool002Gooooo00?o0000ooooooooool0:_ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo023ooooo00?o003oooooool0o`001oooool00ol0
003oooooooooo`01ooooo`009Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool08Oooool00ol00?ooooooo`3o0006ooooo`03o`000?oooooooooo007o
oooo000Uooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo02Gooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Rooooo`03o`00oooooooo0?l000Gooooo00?o0000ooooooooool00Oooool002Gooooo0_l0
000[ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooooooo
o`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool08oooool00ol00?oooooooooo
o`03ooooo`;o00000oooool002Gooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09Oooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o003oooooooooool00oooool00ol0003oooooooooo`01
ooooo`009Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001ooooo
ooooool09?ooool00ol007ooooooooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001ooooo
ooooool0:_ooool00ol0003oooooooooo`01ooooo`009Oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo02Gooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Tooooo`03
o`000?oooooooooo02Gooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Tooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool00Oooool002Gooooon?l00003ooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.09513, -0.107026, \
0.0254742, 0.00385939}},
  CellTags->"i:1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"i:1"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.15873 0.0147151 9.72597 [
[.02381 -0.0125 -3 -9 ]
[.02381 -0.0125 3 0 ]
[.18254 -0.0125 -3 -9 ]
[.18254 -0.0125 3 0 ]
[.34127 -0.0125 -3 -9 ]
[.34127 -0.0125 3 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.65873 -0.0125 -3 -9 ]
[.65873 -0.0125 3 0 ]
[.81746 -0.0125 -3 -9 ]
[.81746 -0.0125 3 0 ]
[.97619 -0.0125 -3 -9 ]
[.97619 -0.0125 3 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -59.0625 -21 ]
[.5 -0.0125 59.0625 -9 ]
[-0.0125 .01472 -6 -4.5 ]
[-0.0125 .01472 0 4.5 ]
[-0.0125 .11197 -24 -4.5 ]
[-0.0125 .11197 0 4.5 ]
[-0.0125 .20923 -24 -4.5 ]
[-0.0125 .20923 0 4.5 ]
[-0.0125 .30649 -24 -4.5 ]
[-0.0125 .30649 0 4.5 ]
[-0.0125 .40375 -24 -4.5 ]
[-0.0125 .40375 0 4.5 ]
[-0.0125 .50101 -24 -4.5 ]
[-0.0125 .50101 0 4.5 ]
[-0.0125 .59827 -24 -4.5 ]
[-0.0125 .59827 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -36 -65.0625 ]
[-0.01875 .30902 -24 65.0625 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.18254 0 m
.18254 .61803 L
s
.34127 0 m
.34127 .61803 L
s
.5 0 m
.5 .61803 L
s
.65873 0 m
.65873 .61803 L
s
.81746 0 m
.81746 .61803 L
s
0 .11197 m
1 .11197 L
s
0 .20923 m
1 .20923 L
s
0 .30649 m
1 .30649 L
s
0 .40375 m
1 .40375 L
s
0 .50101 m
1 .50101 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(0)] .02381 -0.0125 0 1 Mshowa
.18254 0 m
.18254 .00625 L
s
[(1)] .18254 -0.0125 0 1 Mshowa
.34127 0 m
.34127 .00625 L
s
[(2)] .34127 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(3)] .5 -0.0125 0 1 Mshowa
.65873 0 m
.65873 .00625 L
s
[(4)] .65873 -0.0125 0 1 Mshowa
.81746 0 m
.81746 .00625 L
s
[(5)] .81746 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(6)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.05556 0 m
.05556 .00375 L
s
.0873 0 m
.0873 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.15079 0 m
.15079 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.24603 0 m
.24603 .00375 L
s
.27778 0 m
.27778 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.37302 0 m
.37302 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.43651 0 m
.43651 .00375 L
s
.46825 0 m
.46825 .00375 L
s
.53175 0 m
.53175 .00375 L
s
.56349 0 m
.56349 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.62698 0 m
.62698 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.72222 0 m
.72222 .00375 L
s
.75397 0 m
.75397 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.84921 0 m
.84921 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.9127 0 m
.9127 .00375 L
s
.94444 0 m
.94444 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -120.063 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(aperture) show
117.000 13.000 moveto
(radius) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
159.000 13.000 moveto
(H) show
165.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
171.125 13.000 moveto
(L) show
177.125 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .01472 m
.00625 .01472 L
s
[(0)] -0.0125 .01472 1 0 Mshowa
0 .11197 m
.00625 .11197 L
s
[(0.01)] -0.0125 .11197 1 0 Mshowa
0 .20923 m
.00625 .20923 L
s
[(0.02)] -0.0125 .20923 1 0 Mshowa
0 .30649 m
.00625 .30649 L
s
[(0.03)] -0.0125 .30649 1 0 Mshowa
0 .40375 m
.00625 .40375 L
s
[(0.04)] -0.0125 .40375 1 0 Mshowa
0 .50101 m
.00625 .50101 L
s
[(0.05)] -0.0125 .50101 1 0 Mshowa
0 .59827 m
.00625 .59827 L
s
[(0.06)] -0.0125 .59827 1 0 Mshowa
.125 Mabswid
0 .03417 m
.00375 .03417 L
s
0 .05362 m
.00375 .05362 L
s
0 .07307 m
.00375 .07307 L
s
0 .09252 m
.00375 .09252 L
s
0 .13143 m
.00375 .13143 L
s
0 .15088 m
.00375 .15088 L
s
0 .17033 m
.00375 .17033 L
s
0 .18978 m
.00375 .18978 L
s
0 .22869 m
.00375 .22869 L
s
0 .24814 m
.00375 .24814 L
s
0 .26759 m
.00375 .26759 L
s
0 .28704 m
.00375 .28704 L
s
0 .32595 m
.00375 .32595 L
s
0 .3454 m
.00375 .3454 L
s
0 .36485 m
.00375 .36485 L
s
0 .3843 m
.00375 .3843 L
s
0 .42321 m
.00375 .42321 L
s
0 .44266 m
.00375 .44266 L
s
0 .46211 m
.00375 .46211 L
s
0 .48156 m
.00375 .48156 L
s
0 .52047 m
.00375 .52047 L
s
0 .53992 m
.00375 .53992 L
s
0 .55937 m
.00375 .55937 L
s
0 .57882 m
.00375 .57882 L
s
0 .61773 m
.00375 .61773 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -156.062 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
126.063 10 translate
90 rotate
-126.063 -10 translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding MacintoshRomanEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(pathlength) show
129.000 13.000 moveto
(diff) show
153.000 13.000 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(.) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
165.000 13.000 moveto
(H) show
171.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(m) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
183.125 13.000 moveto
(L) show
189.125 13.000 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .61178 m
.02381 .61803 L
s
.18254 .61178 m
.18254 .61803 L
s
.34127 .61178 m
.34127 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.65873 .61178 m
.65873 .61803 L
s
.81746 .61178 m
.81746 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.05556 .61428 m
.05556 .61803 L
s
.0873 .61428 m
.0873 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.15079 .61428 m
.15079 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.24603 .61428 m
.24603 .61803 L
s
.27778 .61428 m
.27778 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.37302 .61428 m
.37302 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.43651 .61428 m
.43651 .61803 L
s
.46825 .61428 m
.46825 .61803 L
s
.53175 .61428 m
.53175 .61803 L
s
.56349 .61428 m
.56349 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.62698 .61428 m
.62698 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.72222 .61428 m
.72222 .61803 L
s
.75397 .61428 m
.75397 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.84921 .61428 m
.84921 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.9127 .61428 m
.9127 .61803 L
s
.94444 .61428 m
.94444 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .01472 m
1 .01472 L
s
.99375 .11197 m
1 .11197 L
s
.99375 .20923 m
1 .20923 L
s
.99375 .30649 m
1 .30649 L
s
.99375 .40375 m
1 .40375 L
s
.99375 .50101 m
1 .50101 L
s
.99375 .59827 m
1 .59827 L
s
.125 Mabswid
.99625 .03417 m
1 .03417 L
s
.99625 .05362 m
1 .05362 L
s
.99625 .07307 m
1 .07307 L
s
.99625 .09252 m
1 .09252 L
s
.99625 .13143 m
1 .13143 L
s
.99625 .15088 m
1 .15088 L
s
.99625 .17033 m
1 .17033 L
s
.99625 .18978 m
1 .18978 L
s
.99625 .22869 m
1 .22869 L
s
.99625 .24814 m
1 .24814 L
s
.99625 .26759 m
1 .26759 L
s
.99625 .28704 m
1 .28704 L
s
.99625 .32595 m
1 .32595 L
s
.99625 .3454 m
1 .3454 L
s
.99625 .36485 m
1 .36485 L
s
.99625 .3843 m
1 .3843 L
s
.99625 .42321 m
1 .42321 L
s
.99625 .44266 m
1 .44266 L
s
.99625 .46211 m
1 .46211 L
s
.99625 .48156 m
1 .48156 L
s
.99625 .52047 m
1 .52047 L
s
.99625 .53992 m
1 .53992 L
s
.99625 .55937 m
1 .55937 L
s
.99625 .57882 m
1 .57882 L
s
.99625 .61773 m
1 .61773 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .01472 m
.02499 .01472 L
.02605 .01472 L
.02729 .01474 L
.02846 .01475 L
.03053 .01479 L
.03279 .01486 L
.03527 .01494 L
.0379 .01506 L
.04262 .01533 L
.04749 .01569 L
.05205 .01611 L
.06244 .01731 L
.07305 .01893 L
.08274 .02075 L
.10458 .026 L
.14429 .03957 L
.18248 .05725 L
.22313 .0806 L
.26226 .10698 L
.30384 .13857 L
.34391 .17178 L
.38246 .20564 L
.42346 .243 L
.46295 .27959 L
.50092 .31476 L
.54134 .35157 L
.58025 .38587 L
.62161 .4206 L
.66146 .45197 L
.69979 .47989 L
.74057 .50692 L
.77984 .53015 L
.81759 .54979 L
.85779 .56777 L
.89648 .5822 L
.93762 .59452 L
.97619 .60332 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00L?ooool3o`0005_ooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`16ooooo`00LOooool00ol0003oooooooooo`1Iooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool0AOooool006_ooooo1?l00002ooooo`?o00000oooool3o`0000;ooooo0ol0
0005ooooo`;o00001?ooool2o`000003ooooool0003o000000;o00001?ooool3o`0000Sooooo0ol0
0004ooooo`Co00000_ooool4o`000003ooooool0003o000000?o00000oooool2o`000003ooooool0
003o000000?o00002_ooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000004oooo
o`03o`000?oooooooooo04Cooooo001Zooooo`04o`000?ooooooooooo`0000?ooooo00Ko0000oooo
oooooooo0000ooooool00006ooooo`03o`000?oooooooooo00?ooooo00Co0000oooooooooooo0000
0_ooool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00001?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Gooooo00?o
0000ooooooooool01oooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000004oooo
o`03o`000?oooooooooo04Cooooo001[ooooo`?o00000oooool01Ol0003oooooooooool0003ooooo
00Go00000_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00?ooooo00Co0000oooo
oooooooo00000_ooool00ol0003oooooooooo`02ooooo`Go00002?ooool00ol0003oooooooooo`03
ooooo`?o00000_ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo00;ooooo00Co
0000oooooooooooo00000_ooool3o`0000[ooooo00Wo0000ooooooooooooooooo`000?oooooo0000
ooooool000001?ooool00ol0003oooooooooo`14ooooo`00J_ooool01?l0003oooooooooool00003
ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooooooo`02o`0000Cooooo
00?o0000ooooooooool00oooool01?l0003oooooooooool00002ooooo`;o00000oooool01Ol0003o
oooooooooooooooo000000Sooooo0_l00003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000
oooooooooooo00001?ooool00ol0003oooooooooo`02ooooo`06o`000?ooooooooooo`000?oooooo
00003Oooool02Ol0003ooooooooooooooooo0000ooooool0003oooooo`000004ooooo`03o`000?oo
oooooooo04Cooooo001[ooooo`;o00000oooool4o`0000?ooooo0ol00002ooooo`;o000000Cooooo
o`000?l0003ooooo1?l00002ooooo`;o000000Coooooo`000?l0003ooooo0_l000000ooooooo0000
o`000002ooooo`?o00002?ooool2o`000003ooooool0003o000000;ooooo0_l00004ooooo`?o0000
0_ooool3o`0000?ooooo0_l000000ooooooo0000o`000002ooooo`Co00002_ooool00ol0003ooooo
ooooo`02o`000003ooooool0003ooooo00?ooooo00?o0000ooooooooool0AOooool008?ooooo00?o
0000ooooooooool0:Oooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool0A_ooool008?ooooo00?o0000ooooooooool0:?ooool2o`0000Cooooo00?o0000
ooooooooool0JOooool00?oooooo8Oooool00?oooooo8Oooool002gooooo0_l0000Tooooo`?o0000
8oooool5o`0002?ooooo0ol0000Uooooo`?o00008oooool3o`0002Gooooo0ol00006ooooo`00;?oo
ool01?l0003oooooooooool0000Tooooo`03o`000?oooooooooo02?ooooo00Co0000oooooooooooo
00008_ooool01Ol0003ooooooooooooooooo000002Gooooo00?o0000ooooooooool08Oooool01Ol0
003ooooooooooooooooo000002?ooooo00Go0000ooooooooooooooooo`000005ooooo`00;?ooool0
1?l0003oooooooooool0000Tooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool09_oo
ool00ol0003oooooooooo`0Pooooo`Go00009_ooool00ol0003oooooooooo`0Qooooo`05o`000?oo
ooooooooooooool000001Oooool002cooooo00Co0000oooooooooooo00009?ooool00ol0003ooooo
ooooo`0Uooooo`03o`000?oooooooooo02?ooooo0_l0000Sooooo`04o`000?ooooooooooo`0002Oo
oooo00?o0000ooooooooool08Oooool4o`0000Kooooo000/ooooo`04o`000?ooooooooooo`0002Co
oooo00?o0000ooooooooool08_ooool01Ol0003ooooooooooooooooo000002Kooooo00?o0000oooo
ooooool08Oooool00ol0003oooooo`00000Sooooo`Co00009?ooool00ol0003oooooooooo`07oooo
o`00;?ooool01?l0003oooooooooool0000Sooooo`;o00009?ooool01Ol0003ooooooooooooooooo
000002;ooooo00Go0000ooooooooooooooooo`00000Tooooo`;o00008oooool00ol0003ooooooooo
o`0Vooooo`03o`000?oooooooooo00Kooooo000]ooooo`;o00009Oooool00ol0003oooooooooo`0S
ooooo`?o00009?ooool3o`0002Kooooo00?o0000ooooooooool08Oooool5o`0002Gooooo0_l00006
ooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00:?ooooog
o`00007ooooo000Qooooo`;o00001Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00;ooooo0Ol00001ooooo`008?ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo
02Cooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo
02Gooooo00?o0000ooooooooool00_ooool1o`00007ooooo000Pooooo`04o`000?ooooooooooo`00
00Cooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02[ooooo0Ol00001ooooo`008?ooool01?l0003oooooooooool00004ooooo`?o00000oooool<o`00
01_ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Yooooo`;o00000Oooool0023o
oooo00Co0000oooooooooooo00001?ooool00ol0003oooooooooo`0?ooooo`Ko00005Oooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`008?ooool01?l0003o
ooooooooool00004ooooo`03o`000?oooooooooo01Gooooo1?l0000Aooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo000Qooooo`;o00001Oooool00ol0003o
ooooooooo`0Iooooo`?o00003_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[o
oooo0Ol00001ooooo`00:?ooool2o`0001gooooo0_l0000<ooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool0:Oooool2o`00007ooooo000Xooooo`03o`000?oooooooooo01kooooo0ol0
0009ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo000X
ooooo`03o`000?oooooooooo027ooooo0_l00007ooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool0:_ooool1o`00007ooooo000Xooooo`03o`000?oooooooooo02?ooooo0_l00005oooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo000Xooooo`03
o`000?oooooooooo02Gooooo0ol00002ooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool0:_ooool1o`00007ooooo000Xooooo`;o0000:Oooool2o`000003o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool0:Oooool2o`00007ooooo0004ooooo`03on2gWongg?;ooooo00;ooooo00?o
ooobokfOYOoLnol07?ooool00ol0003oooooooooo`0Zooooo`;o00009Oooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooooooo
o`0Zooooo`7o00000Oooool000Cooooo00?odY51o`000?l000000ol000000ol0047ob?;oooooo`0K
ooooo`03o`000?oooooooooo02[ooooo00Co001oooooool0003o00008oooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooooooo
o`0Zooooo`7o00000Oooool000Cooooo00SoiKeio`1VZoobooool]baobh0P_oZoo;oRBi1ol;^oaco
oooo00?o0000ooooooooool0:_ooool01Ol007oooooooooooooooooo000002;ooooo00?o001ooooo
ooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooo
ooooool0:_ooool1o`00007ooooo0004ooooo`08olR2@On9cOOooooooooomonA;T7o`_;komNm_OoU
nolLooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool00_ooool2o`00023ooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool0:_ooool1o`00007ooooo0004ooooo`06onZmNOl007Wod^GZomNgP_l007Woh?oo
7_ooool2o`0002_ooooo00?o001oooooooooool01?ooool2o`0001kooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
:Oooool2o`00007ooooo0004ooooo`05ooool_o2V73o0000o`0^G?naenh07oooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo00Kooooo00?o0000ooooooooool06oooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Zooooo`7o00000Oooool000Kooooo00?oooobomO=cOoPk_/07oooool00ol0003ooooooooo
o`0Zooooo`03o`00Oooooooooooo00Oooooo0_l0000Kooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol0
0001ooooo`001?ooool01_oZ`Y7oP[7=ok5`;_l0;P3o001Lom;goakooooo00?o0000ooooooooool0
:_ooool00ol007ooooooooooo`09ooooo`;o00006Oooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o0000
0Oooool000Cooooo00Kob8ULoi6m]om`Ci7omookoiQ1Coo2k_lNooooo`03o`000?oooooooooo02[o
oooo00?o001oooooooooool02oooool00ol0003oooooooooo`0Fooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[o
oooo0Ol00001ooooo`001?ooool01_o8RFKoWl:aoea1V?obnmcoL2i`omOkoakooooo0_l0000[oooo
o`03o`00Oooooooooooo00cooooo0_l0000Fooooo`03o`00Oooooooooooo02Cooooo00?o001ooooo
ooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Wooooo0_l00001oooo
o`001?ooool01_oU_HWo0000o`000?l0003o001`omOgoakooooo00?o0000ooooooooool0:_ooool0
0ol007ooooooooooo`0>ooooo`;o00005?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool0
00Gooooo00GoooOgoo;bl_okmnGoTDmVolSbo`05ooooo`;o00001?ooool00ol0003oooooooooo`03
ooooo`;o00000oooool3o`0000Gooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0@
ooooo`03o`000?oooooooooo017ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0004oooo
o`03oooZcOngcN[ooooo00Oooooo00Co0000oooooooooooo00002?ooool01?l0003oooooooooool0
0003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0:_ooool00ol007oooooooooo
o`0Aooooo`;o00004Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000;ooooo00Ooooog
on3GeonmWfKo05bOom;Gd_o=cM;oiO;k00Gooooo00Co0000oooooooooooo00002?ooool01?l0003o
ooooooooool00003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0:_ooool00ol0
07ooooooooooo`0Cooooo`03o`000?oooooooooo00kooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00
007ooooo0002ooooo`08ooooj_nUPW3oIU`^o`0^Com`NGWoL5a1o`00I_oGnol4ooooo`04o`000?oo
ooooooooo`0000Sooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`04ooooo`?o
0000@Ol007l00ol0003o001oo`00O`2^o`00O`;o00000Oooool000Cooooo00Konm:Aod69cOoooooo
ooogoi4^@Oo2l_l4ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00000ooo
ool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool05Ooo
ool00ol0003oooooooooo`0<ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`001?ooool0
1_obcHWo@HW8oooooooonmOoG01?olggo`Cooooo00Co0000oooooooooooo00002?ooool01?l0003o
ooooooooool00002ooooo`;o00001_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo
01Kooooo0_l0000<ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`001Oooool01Ookoooo
ooooooobd_nAV<;onooo00Gooooo0_l0000:ooooo`;o00001?ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo02[ooooo00?o001oooooooooool06?ooool00ol0003oooooooooo`09oooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`000_ooool00oobh<god^[kooooo`03ooooo`03
omO2`_oUnooooooo01gooooo0_l0000[ooooo`03o`00Oooooooooooo01Wooooo00?o0000oooooooo
ool02?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Yooooo`;o00000Oooool000;ooooo00SocHT^o`000?m1Cdoo
@D51obh^@Om1@Bko000^olSboakooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0J
ooooo`03o`000?oooooooooo00Oooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0002oooo
o`08oookl_o^l^ko`Y51obj2]ooZk^kok^kPojEiROoBl_lNooooo`03o`000?oooooooooo02[ooooo
00?o001oooooooooool06oooool2o`0000Oooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo
0004ooooo`06olf2@On2b?;ooooooooooooUd];oj__o7_ooool00ol0003oooooooooo`0Zooooo`03
o`00Oooooooooooo01gooooo00?o0000ooooooooool01?ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o
00000Oooool000Cooooo00Koh;N2o`000?l^@D7o@D4^o`00;_o8l_lNooooo`03o`000?oooooooooo
02[ooooo00?o001oooooooooool07_ooool00ol0003oooooooooo`03ooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02[ooooo0Ol00001ooooo`001Oooool01Oogl^[oiNGZonk^h?nOL7WocO;o01kooooo0_l0000[oooo
o`03o`00Oooooooooooo01oooooo00?o0000ooooooooool00_ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Yoooo
o`;o00000Oooool002Sooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Pooooo`;o
00000_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000;ooooo00?oh;69oioBl_ooool0
0_ooool00oooooOoV45?ol;bo`0Nooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
8_ooool00ol0003oooooo`00O`0Vooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000;ooooo00?ob88^oebH`_oGem800_oB
d]800ooGel;oL2i?olSbo`0Nooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool08ooo
ool00ol0003o001oooooo`0Uooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Zooooo`7o00000Oooool000;ooooo00?oj/RUog1`L?m`L7000_m`L700
0om`L6Ko001?olSbo`0Nooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool0
0ol0003oooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Zooooo`7o00000Oooool000Oooooo00?oooogoi4^@Oo2l_l07_ooool2o`00
02_ooooo00?o001oooooooooool09?ooool00ol007oo0000ooooo`0Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Yooooo`;o00000Oooool000Oo
oooo00?ooookolfa]ooPmol07_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooool000009?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool0:_ooool1o`00007ooooo0005ooooo`04ooOUd_ng/J_o/Kg=oo;ooaoo
oooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`04o`00Ooooooooooooo`00
02?ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02[ooooo0Ol00001ooooo`001?ooool01_obdYoo0000o`000?l0003o046Honkooakooooo00?o0000
ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`05o`00Ooooooooooooooooool000008_oo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_oo
ool1o`00007ooooo0004ooooo`06ol:2ConHcMcoWdmLom;kl_nH@Doo`^ko7_ooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool00_ooool00ol0003ooooo
ooooo`0Oooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Zooooo`7o00000Oooool000Cooooo00Ko]g1Lokg^k_nUCecocO_kok5VI_o2k_lNooooo`;o
0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00?ooooo00?o0000oooooooo
ool07_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool0:Oooool2o`00007ooooo0004ooooo`06on2aL?l002ko001?olSUcOm?05coeo_o7_ooool00ol0
003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool01?ooool00ol0
003oooooooooo`0Mooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Zooooo`7o00000Oooool000Cooooo00Gooookom:aTOmVL9Sod]NmoiR[dP06oooo
o`;o00001?ooool00ol0003oooooooooo`03ooooo`;o00000_ooool5o`0000Cooooo00?o0000oooo
ooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00Gooooo00?o0000oooo
ooooool07?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooo
ooooool0:_ooool1o`00007ooooo0004ooooo`06on[Bb?oGk_oooooooooooooLb<Soj__o1?ooool0
1?l0003oooooooooool00008ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo
00001?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool01_ooool00ol0003oooooooooo`0Kooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000Cooooo00KocHT^o`00;_m?Cdoo
Cdl^o`00;_o2l_l4ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00000ooo
ool00ol0003oooooooooo`04ooooo`?o0000Fol007l2o`0009Go001o0_l00001ooooo`001?ooool0
1_oLYEco@H:aonGZj_o^k]coWgV2om;bo`Cooooo00Co0000oooooooooooo00002?ooool01?l0003o
ooooooooool00004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:_ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo00Wooooo00?o0000ooooooooool06?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00
007ooooo0004ooooo`06olR2@On2b?;ooooooooooooUd];oj__o1?ooool01?l0003oooooooooool0
0008ooooo`06o`000?ooooooooooo`000?oooooo00000oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0:ooooo`03
o`000?oooooooooo01Oooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02[ooooo0Ol00001ooooo`001?ooool01_oP/GWo0000od51Com?@Bko000^olSb
o`Cooooo00Co0000oooooooooooo00002?ooool01_l0003oooooooooool0003oooooo`0000?ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool02oooool00ol0003oooooooooo`0Fooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000Gooooo00Go
mnkZonGUiOoZj]coWg1iolgbo`05ooooo`;o00002_ooool2o`0000?ooooo0ol00005ooooo`03o`00
0?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0<ooooo`03o`00
0?oooooooooo01Gooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02[ooooo0Ol00001ooooo`001Oooool00ooomn[od/g=omOUlP0Pooooo`;o0000:ooo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00gooooo00?o0000ooooooooool05?oo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:Ooo
ool2o`00007ooooo0004ooooo`08oo_U]ol^003o@EaLo`000?mVZmcoooooon[PiOokoolLooooo`03
o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0>ooooo`03
o`000?oooooooooo01?ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02[ooooo0Ol00001ooooo`001?ooool02?o=TDooI[7Pooooooooj[Oo;RjAooOo
j_mi02ko`_;o7?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool03oooool00ol0003oooooooooo`0Booooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000Cooooo00SodYQLog2a
h?ooooooonZgod5?YOokon3oIP1?olggoacooooo00?o0000ooooooooool0:_ooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo013ooooo00?o0000ooooooooool04Oooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo
0004ooooo`07ombUI_l0003oCfIVobh00?l0003o@@00obj2_@0Mooooo`03o`000?oooooooooo02[o
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Aooooo`;o00004Oooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007o
oooo0004ooooo`03om:HI_n2/M;oiN3P00;oh>3P00?oh>3Zoo_oooooool07?ooool2o`0002_ooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Cooooo`03o`000?oooooooooo00kooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Wooooo
0_l00001ooooo`001?ooool00oooj/go]lgZooooo`0Qooooo`03o`000?oooooooooo02[ooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Dooooo`03o`000?oooooooooo00gooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol0
0001ooooo`000_ooool01oooooOoh=OGokfOI_l0G9ood]OBolg=d_oUl_/07oooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool05Oooool00ol0003ooooo
ooooo`0<ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Zooooo`7o00000Oooool000;ooooo00SooooZojF2L?mVG2ko02i?og1iNOm`G47o001VomOk
oakooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
01Kooooo00?o0000ooooooooool02oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0004ooooo`06oo_BTOm1RLgooooooooo
monA;T7o`_;o7_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool05oooool00ol0003oooooooooo`0:ooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000Cooooo00Kol/f9od69
b?oooooooo_Goe`0Coo=molNooooo`;o0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo01Sooooo00?o0000ooooooooool02Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool0:Oooool2o`00007ooooo0005ooooo`05oo_ooooooooo
oo;Boi6H`_okool07_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool06Oooool00ol0003oooooooooo`08ooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000;ooooo00?ol^3=
om;Znoooool00oooool00ooG`/;oiO_oooooo`0Mooooo`03o`000?oooooooooo02[ooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Jooooo`03o`000?oooooooooo00Oooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001
ooooo`000_ooool02?o=RBko0000od5?Com1@D7o;Ri1od51;_l002kob?;o7_ooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool06oooool2o`0000Oooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo
0Ol00001ooooo`000_ooool02?oono;ok_;^ol:A@Ol^P[Ooj^k^onk^h?nUNHWod_;o7_ooool00ol0
003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool07Oooool00ol0
003oooooooooo`04ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Zooooo`7o00000Oooool000Cooooo00KocH91oh;8l_ooooooooooonGBd_oZnolN
ooooo`;o0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01kooooo00?o0000
ooooooooool00oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool0:Oooool2o`00007ooooo0004ooooo`06on2gP_l0003o;T51od51;_l002kob?;o7_oo
ool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool07ooo
ool00ol0003oooooooooo`02ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Zooooo`7o00000Oooool000Gooooo00Gomo;ZonGUj_o^k^3oWg1iolgb
o`05ooooo`;o00001?ooool00ol0003oooooooooo`03ooooo`;o00000oooool3o`0000Gooooo00?o
0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo023ooooo00Go
0000ooooooooooooooooo`00O`0Vooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
:_ooool1o`00007ooooo000>ooooo`04o`000?ooooooooooo`0000Sooooo00Ko0000oooooooooooo
0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:_ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo027ooooo00Co0000oooooooooooo001o9_ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`003_ooool01?l0
003oooooooooool00008ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000ooooooooool00_oo
ool3o`0007Ko001o00?o0000o`00Ool007l0NOl007l2o`00007ooooo000>ooooo`04o`000?oooooo
ooooo`0000Sooooo00Co0000oooooooooooo00000oooool2o`0000Gooooo00?o0000ooooooooool0
:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02?ooooo00?o0000o`00Ooooool0
9Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`003_oo
ool01?l0003oooooooooool00008ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol0003oooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool0:_ooool1o`00007ooooo000>ooooo`04o`000?ooooooooooo`0000Sooooo00Ko0000oooooooo
oooo0000ooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:_ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oo`000?ooool09?ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`003oooool2o`00
00[ooooo0_l00003ooooo`?o00001Oooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09?ooool00ol007ooooooo`00000Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0005ooooo`04ooOUcOnUV97oWj^mon[k
oaoooooo0_l0000[ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool01?l0
07ooooooooooool0000Sooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:Oooool2
o`00007ooooo0004ooooo`06ooOLYOl0003oL8VAogU?0?l008;oiOoo7_ooool00ol0003ooooooooo
o`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool01Ol007oooooooooo
oooooooo000002;ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o0000
0Oooool000Cooooo00KocHU?og2mj_ooooooooo^ohT^@Oo2k_lNooooo`03o`000?oooooooooo02[o
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00;o
oooo00?o0000ooooooooool07oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[o
oooo0Ol00001ooooo`000_ooool02?o^ekgocNkoonFUI_mVZn3oooooooooiOn2;UcocO;o7_ooool0
0ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`03ooooo`03o`000?oooooooooo01kooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Zooooo`7o00000Oooool000;ooooo00Sob880o`11L?n2IP3o0000odm`NOmL
;P3o0011om;koakooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool01?ooool00ol0003oooooooooo`0Mooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0002ooooo`08oo_^h?o=
b<SocLg=om;Bd_o=cLgod];8oh9?G?o8l_lNooooo`;o0000:oooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool01Oooool00ol0003oooooooooo`0Loooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:Oooool2o`00007ooooo0008ooooo`03
ooObl_okoooooooo01gooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool01_ooool00ol0003oooooooooo`0Kooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0004ooooo`06on2m
Zoo8j__oooooooool_nA;T7o`_;o7_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`07ooooo`;o00006oooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`0000[ooooooooonooL
b;Oob>3^olf9;_m?V<;oh=cLomcLb?m`;Toob?;o7_ooool00ol0003oooooooooo`0Zooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`09ooooo`03o`00
0?oooooooooo01Sooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o0000
0Oooool00005oooooooooo;oYE`0oebUeooP`YP00_mLG5`00omVIUco001?olSbo`0Nooooo`03o`00
0?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo00[ooooo00?o0000ooooooooool05oooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02[ooooo0Ol00001ooooo`001oooool00oooooOoTBi1ol;bo`0Nooooo`;o0000:ooo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool02ooo
ool00ol0003oooooooooo`0Fooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:Ooo
ool2o`00007ooooo0007ooooo`03oooomoo2WiooeoOo01kooooo00?o0000ooooooooool0:_ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool03?ooool2
o`0001Kooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool0
02Sooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool03_ooool00ol0003oooooooooo`0Cooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0004ooooo`06omNHG?n9b?;ooooooooo
monH@Doo`_;o7_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0?ooooo`03o`000?oooooooooo01;ooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000;ooooo00Cooo;GohUL
;_l0003o02h^0_l^;Rh00ol004oob?;oooooo`0Mooooo`03o`000?oooooooooo02[ooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo013ooooo00?o0000
ooooooooool04Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02[ooooo0Ol00001
ooooo`000_ooool02?o^b8;o@H:gokf9G?mi/MOok^kZonk^eon2;Too`_;o7_ooool2o`0002_ooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo017ooooo
0_l0000Aooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:Oooool2o`00007ooooo
0002ooooo`08om:H@Om?ZmcoeiQ?ogW2k_ooooooooobohT^@Oo2l_lNooooo`03o`000?oooooooooo
02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
01?ooooo00?o0000ooooooooool03_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02[ooooo0Ol00001ooooo`000_ooool01?okiLgo]lgZoookk_o^mo/2ooooo`03ooObl_okoooooooo
00Cooooo0_l00004ooooo`03o`000?oooooooooo00?ooooo0_l00004ooooo`?o00001?ooool00ol0
003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Dooooo`03o`000?oooooooooo00gooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Zooooo`7o00000Oooool000kooooo00Co0000oooooooooooo00002?ooool01?l0
003oooooooooool00004ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:_ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool05Oooool0
0ol0003oooooooooo`0<ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1
o`00007ooooo0004ooooo`06omNHG?n9b?;ooooooooomonH@Doo`_;o1?ooool01?l0003ooooooooo
ool00008ooooo`05o`000?ooooooooooo`000?ooool01Ol00004ooooo`?o0000TOl007l00ol0003o
001oo`00O`1No`00O`;o00000Oooool000;ooooo00Cooo;GohUL;_l0003o02h^0_l^;Rh00ol004oo
b?;oooooo`03ooooo`04o`000?ooooooooooo`0000Sooooo00Ko0000oooooooooooo0000ooooool0
0002ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:_ooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool05oooool00ol0003ooooooooo
o`0:ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0002
ooooo`08onk8P_m1P[Oo_HULogVaeoo^k^[ok^kGoh8^Coo2l_l4ooooo`04o`000?ooooooooooo`00
00Sooooo00Co0000oooooooooooo00000_ooool00ol0003oooooo`000005ooooo`03o`000?oooooo
oooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo01Sooooo00?o0000ooooooooool02Oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02[ooooo0Ol00001ooooo`000_ooool02?oBV47oCj_LomNHComi`^koooooooool_n9;T7o`_;o
1?ooool01?l0003oooooooooool00008ooooo`04o`000?ooooooooooo`0000?ooooo0_l00005oooo
o`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo01Wooooo00?o0000ooooooooool02?ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`000_ooool01?okiLgo]lgZoookk_o^mo/2oooo
o`03ooObl_okoooooooo00Cooooo0_l0000:ooooo`;o00001Oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo01[ooooo00?o0000ooooooooool01oooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`00:?ooool2o`0002_ooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01_ooooo0_l00007ooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool0:Oooool2o`00007ooooo000Xooooo`03o`00
0?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo01gooooo00?o0000ooooooooool01?ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02[ooooo0Ol00001ooooo`001oooool00oo=WfKo001`omOgo`0Nooooo`03o`000?oo
oooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo01kooooo0_l00004ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0:_oo
ool1o`00007ooooo0007ooooo`03ok5V0?l0047ob?;o01kooooo00?o0000ooooooooool0:_ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool08?ooool0
1Ol0003ooooooooooooooooo001o02Kooooo00?o001oooooooooool0:_ooool1o`00007ooooo0007
ooooo`03oookk_oUj_;ooooo01kooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool08Oooool01?l0003oooooooooool0
07lVooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`00:?ooool2o`0002_ooooo00?o001o
ooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02;ooooo0_l00000
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Wooooo0_l00001ooooo`00:?ooool00ol0
003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`000?oooooooooo02Cooooo00?o001oooooooooool0:_ooool1o`00
007ooooo000Xooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oo`000?l000009?ooool00ol007oo
ooooooooo`0Zooooo`7o00000Oooool002Sooooo00?o0000ooooooooool0:_ooool00ol007oooooo
ooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool01?l007oooooo
ooooool0000Sooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`00:?ooool00ol0003ooooo
ooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooo
ooooo`0Tooooo`05o`00Ooooooooooooooooool000008_ooool00ol007ooooooooooo`0Zooooo`7o
00000Oooool002Sooooo0_l0000[ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00;ooooo0_l0000Pooooo`03o`00
Oooooooooooo02Wooooo0_l00001ooooo`00:?ooool00ol0003oooooooooo`0Zooooo`03o`00Oooo
oooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooo
oooooooo00Cooooo00?o0000ooooooooool07Oooool00ol007ooooooooooo`0Zooooo`7o00000Ooo
ool002Sooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`05ooooo`03o`000?oooooo
oooo01cooooo00?o001oooooooooool0:_ooool1o`00007ooooo000Xooooo`03o`000?oooooooooo
02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool01_ooool00ol0003oooooooooo`0Kooooo`03o`00Oooooooooooo
02[ooooo0Ol00001ooooo`001Oooool01?okmnkoiN3Pon3Uj_ogoolOooooo`03o`000?oooooooooo
02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo
02Cooooo00?o001oooooooooool01oooool2o`0001_ooooo00?o001oooooooooool0:_ooool1o`00
007ooooo0003ooooo`08oo;Pb?n9IUcoG6IioiROYOnOV97oL6ILog29ZooLl_/Mooooo`;o0000:ooo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`09ooooo`03o`000?oooooooooo01Sooooo00?o001oooooooooool0:Ooo
ool2o`00007ooooo0002ooooo`03ooOL]on2TK7oh?;k00Cooooo00?ok^32oi6A]oobool07?ooool0
0ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo00[ooooo0_l0000Hooooo`03o`00Oooooooo
oooo02[ooooo0Ol00001ooooo`003oooool2o`0000Cooooo00?o0000ooooooooool00oooool2o`00
00?ooooo0ol00005ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool03?ooool00ol0
003oooooooooo`0Eooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`001oooool01Oogl^ko
h=O=ok6UTOn2V;gomooo00;ooooo00Co0000oooooooooooo00002?ooool01_l0003oooooooooool0
003oooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Zooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo00gooooo00?o0000ooooooooool05?ooool00ol007ooooooooooo`0Zooooo`7o0000
0Oooool000Cooooo00Ooj]:gohV2NOm`L73oPY6AogU?@OnHb>Gono_o00?ooooo00Co0000oooooooo
oooo00002?ooool01?l0003oooooooooool00005ooooo`03o`000?oooooooooo00;ooooo0ol0002`
o`00O`;o0000@?l007l2o`00007ooooo0004ooooo`06ooO^j_oZl_Ooooooooooooob`Y7oYMOg1?oo
ool01?l0003oooooooooool00008ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001ooooooooo
ool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo013ooooo00?o0000oooooooo
ool04Oooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000Oooooo00?oooOGogUVTOoZool0
1?ooool01?l0003oooooooooool00008ooooo`05o`000?ooooooooooo`000?ooool01?l00005oooo
o`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool04Oooool2o`00017ooooo00?o001ooooo
ooooool0:_ooool1o`00007ooooo0004ooooo`06ooOUeonm/JGoTH:2ofIL;_l006Kod_;o1?ooool0
1?l0003oooooooooool00008ooooo`06o`000?ooooooooooo`000?oooooo00002?ooool00ol0003o
ooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo01?ooooo0_l0000?ooooo`03o`00Oooooooooooo02[o
oooo0Ol00001ooooo`001?ooool01_o^g<gob=;Lonkgnoooooooon[LonGbo`Gooooo0_l0000:oooo
o`;o00000_ooool5o`0000Cooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Eoooo
o`03o`000?oooooooooo00cooooo00?o001oooooooooool0:_ooool1o`00007ooooo0004ooooo`06
olfAG?mVWl;oemOBomOGb?mi@Ecob?;o7_ooool2o`0002_ooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool05_ooool2
o`0000cooooo00?o001oooooooooool0:Oooool2o`00007ooooo0004ooooo`06om:HCol0;UcoNGUi
ogUiI_l002kob?;o7_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o
001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01Sooooo0_l0
000:ooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`001?ooool01_ngL03oG:G=onk^j_oZ
j^Gob;NmonGkoakooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Jooooo`03o`00
0?oooooooooo00Oooooo00?o001oooooooooool0:_ooool1o`00007ooooo0004ooooo`06omb[I_l0
02koG5aLoeaLCol002ko`_;o7_ooool00ol0003oooooooooo`0Zooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo01_o
oooo0_l00007ooooo`03o`00Oooooooooooo02[ooooo0Ol00001ooooo`001?ooool01_naIP3oG:GB
ooOgmoogmnkod/S=onkkoakooooo00?o0000ooooooooool0:_ooool00ol007ooooooooooo`0Toooo
o`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Moooo
o`;o00001Oooool00ol007ooooooooooo`0Zooooo`7o00000Oooool000Cooooo00Koj/f[ofI1@Ol^
@D7o@D4^o`00;_o2l_lNooooo`;o0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Oooooo`?o00000_ooool0
0ol007ooooooooooo`0Yooooo`;o00000Oooool000Sooooo00?oh=;Bonkkooooool07Oooool00ol0
003oooooooooo`0Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02;ooooo0_l000000ol007ooooooooooo`0Zoooo
o`7o00000Oooool000;ooooo00?omnG=ol;BiOooool01?ooool00ooooo;oelgGooOoo`0Looooo`03
o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03
o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool2o`0002_ooooo0Ol00001ooooo`00
0_ooool02Ooonnko`ZF9oeaVNOnU_LSog>3PomcGd_ngYI7oIUaVoio2g00Mooooo`03o`000?oooooo
oooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02Cooooo00?o001oooooooooool09?ooool01?l007ooooooo`000?l0000Yooooo`7o00000Ooo
ool000Cooooo00Kooo_^om;2]on[Zj_oZj^aolSGiOokoolNooooo`03o`000?oooooooooo02[ooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool01?l007ooooooooooooooool2o`0002Oooooo0Ol00001ooooo`00
:?ooool2o`0002_ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00
Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`03ooooo`;o0000
9?ooool2o`00007ooooo000Xooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?oo
ool00ol007ooooooooooo`05ooooo`;o00008oooool1o`00007ooooo000Xooooo`03o`000?oooooo
oooo02[ooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooo
oooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`07ooooo`?o00008?ooool1
o`00007ooooo000Xooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0:ooooo`?o00007Oooool1o`00007ooooo000Xooooo`03o`000?oooooooooo02[o
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Co
oooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0=ooooo`?o00006_ooool1o`00007o
oooo000Xooooo`;o0000:oooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo013ooooo
1?l0000Eooooo`;o00000Oooool002Sooooo00?o0000ooooooooool0:_ooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oooooooooo
o`0Tooooo`03o`00Oooooooooooo01Cooooo0ol0000Cooooo`7o00000Oooool000oooooo0_l00004
ooooo`03o`000?oooooooooo00?ooooo0_l00003ooooo`?o00001Oooool00ol0003oooooooooo`0Z
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007ooooooooooo`0T
ooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool05oooool3o`00013ooooo0Ol00001
ooooo`003_ooool01?l0003oooooooooool00008ooooo`06o`000?ooooooooooo`000?oooooo0000
0oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool0
9?ooool00ol007ooooooooooo`0Jooooo`Co00003?ooool1o`00007ooooo000>ooooo`04o`000?oo
ooooooooo`0000Sooooo00Ko0000oooooooooooo0000ooooool00003ooooo`03o`000?oooooooooo
00;ooooo0ol0000Zooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol0
07ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool07_ooool3o`00
00Sooooo0_l00001ooooo`003_ooool01?l0003oooooooooool00008ooooo`05o`000?oooooooooo
o`000?ooool01?l00005ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool0
0ol007ooooooooooo`0Qooooo`?o00001_ooool1o`00007ooooo000>ooooo`04o`000?oooooooooo
o`0000Sooooo00Ko0000oooooooooooo0000ooooool00008ooooo`03o`000?oooooooooo02[ooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo
00?o001oooooooooool09?ooool00ol007ooooooooooo`0Tooooo`;o00001?ooool1o`00007ooooo
000>ooooo`04o`000?ooooooooooo`0000Sooooo00Co0000oooooooooooo00000_ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo02[ooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Tooooo`03o`00Oooooooooooo02Cooooo00?o001oooooooooool09?ooool00ol007oo
ooooooooo`0Zooooo`7o00000Oooool000oooooo0_l0000:ooooo`;o00001?ooool2o`0000Gooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`7o00000Oooool002Sooooomol0
0001ooooo`00\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.18915, -0.0117053, \
0.0255832, 0.000417524}},
  CellTags->"i:1"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output",
  CellTags->"i:1"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 3. Electromagnetic theory of the reflector antenna", \
"Subsubsection",
  CellTags->"c:10"],

Cell[CellGroupData[{

Cell[BoxData[{
    StyleBox[\(Mat  .3  .1 - \ "\<Lambda function\>"\ beam;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(<< 
      Graphics`SurfaceOfRevolution`\), "\[IndentingNewLine]", \(t =. ; 
    u =. ;\), "\[IndentingNewLine]", \(ff = 
      Integrate[\((2/\((1 + 
                  t)\))\) \((2\ r\ \((1 - \((1 - t)\) r^2)\))\)\ BesselJ[0, 
            u\ r], {r, 0, 1}]\), "\[IndentingNewLine]", \(Plot[
      Evaluate[Table[ff, {t, 0, 1}], {u, \(-20\), 20}, PlotRange \[Rule] All, 
        Frame \[Rule] True, GridLines -> Automatic, 
        FrameLabel \[Rule] {"\<angular coordinate u\>", "\<farfield amplitude\
\>"}, PlotStyle \[Rule] {{RGBColor[0, 0, 1]}, {RGBColor[1, 0, 
                0]}}]]\), "\n", \(SurfaceOfRevolution[
      2\ BesselJ[1, u]/u, {u, \(-10\), 10}, 
      BoxRatios -> {1, 1, 1}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{19, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[
    \(\(4\ t\ u\ BesselJ[1, u] - 8\ \((\(-1\) + t)\)\ BesselJ[2, u]\)\/\(\((1 \
+ t)\)\ u\^2\)\)], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0238095 0.0834793 0.519841 [
[.02381 -0.0125 -9 -9 ]
[.02381 -0.0125 9 0 ]
[.2619 -0.0125 -9 -9 ]
[.2619 -0.0125 9 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.7381 -0.0125 -6 -9 ]
[.7381 -0.0125 6 0 ]
[.97619 -0.0125 -6 -9 ]
[.97619 -0.0125 6 0 ]
[ 0 0 -0.125 0 ]
[.5 -0.0125 -62 -21 ]
[.5 -0.0125 62 -9 ]
[-0.0125 .08348 -6 -4.5 ]
[-0.0125 .08348 0 4.5 ]
[-0.0125 .18745 -18 -4.5 ]
[-0.0125 .18745 0 4.5 ]
[-0.0125 .29142 -18 -4.5 ]
[-0.0125 .29142 0 4.5 ]
[-0.0125 .39538 -18 -4.5 ]
[-0.0125 .39538 0 4.5 ]
[-0.0125 .49935 -18 -4.5 ]
[-0.0125 .49935 0 4.5 ]
[-0.0125 .60332 -6 -4.5 ]
[-0.0125 .60332 0 4.5 ]
[ 0 0 -0.125 0 ]
[-0.01875 .30902 -30 -56 ]
[-0.01875 .30902 -18 56 ]
[ 0 .61803 .125 0 ]
[ 1 0 .125 0 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 .5 r
.25 Mabswid
[ ] 0 setdash
.2619 0 m
.2619 .61803 L
s
.5 0 m
.5 .61803 L
s
.7381 0 m
.7381 .61803 L
s
0 .08348 m
1 .08348 L
s
0 .18745 m
1 .18745 L
s
0 .29142 m
1 .29142 L
s
0 .39538 m
1 .39538 L
s
0 .49935 m
1 .49935 L
s
0 g
.02381 0 m
.02381 .00625 L
s
[(-20)] .02381 -0.0125 0 1 Mshowa
.2619 0 m
.2619 .00625 L
s
[(-10)] .2619 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(0)] .5 -0.0125 0 1 Mshowa
.7381 0 m
.7381 .00625 L
s
[(10)] .7381 -0.0125 0 1 Mshowa
.97619 0 m
.97619 .00625 L
s
[(20)] .97619 -0.0125 0 1 Mshowa
.125 Mabswid
.07143 0 m
.07143 .00375 L
s
.11905 0 m
.11905 .00375 L
s
.16667 0 m
.16667 .00375 L
s
.21429 0 m
.21429 .00375 L
s
.30952 0 m
.30952 .00375 L
s
.35714 0 m
.35714 .00375 L
s
.40476 0 m
.40476 .00375 L
s
.45238 0 m
.45238 .00375 L
s
.54762 0 m
.54762 .00375 L
s
.59524 0 m
.59524 .00375 L
s
.64286 0 m
.64286 .00375 L
s
.69048 0 m
.69048 .00375 L
s
.78571 0 m
.78571 .00375 L
s
.83333 0 m
.83333 .00375 L
s
.88095 0 m
.88095 .00375 L
s
.92857 0 m
.92857 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
gsave
.5 -0.0125 -123 -25 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(angular) show
111.000 13.000 moveto
(coordinate) show
177.000 13.000 moveto
(u) show
183.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .08348 m
.00625 .08348 L
s
[(0)] -0.0125 .08348 1 0 Mshowa
0 .18745 m
.00625 .18745 L
s
[(0.2)] -0.0125 .18745 1 0 Mshowa
0 .29142 m
.00625 .29142 L
s
[(0.4)] -0.0125 .29142 1 0 Mshowa
0 .39538 m
.00625 .39538 L
s
[(0.6)] -0.0125 .39538 1 0 Mshowa
0 .49935 m
.00625 .49935 L
s
[(0.8)] -0.0125 .49935 1 0 Mshowa
0 .60332 m
.00625 .60332 L
s
[(1)] -0.0125 .60332 1 0 Mshowa
.125 Mabswid
0 .10947 m
.00375 .10947 L
s
0 .13546 m
.00375 .13546 L
s
0 .16146 m
.00375 .16146 L
s
0 .21344 m
.00375 .21344 L
s
0 .23943 m
.00375 .23943 L
s
0 .26542 m
.00375 .26542 L
s
0 .31741 m
.00375 .31741 L
s
0 .3434 m
.00375 .3434 L
s
0 .36939 m
.00375 .36939 L
s
0 .42138 m
.00375 .42138 L
s
0 .44737 m
.00375 .44737 L
s
0 .47336 m
.00375 .47336 L
s
0 .52534 m
.00375 .52534 L
s
0 .55134 m
.00375 .55134 L
s
0 .57733 m
.00375 .57733 L
s
0 .05749 m
.00375 .05749 L
s
0 .0315 m
.00375 .0315 L
s
0 .0055 m
.00375 .0055 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
gsave
-0.01875 .30902 -141 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
117 10 translate
90 rotate
-117 -10 translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(farfield) show
117.000 13.000 moveto
(amplitude) show
171.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.02381 .61178 m
.02381 .61803 L
s
.2619 .61178 m
.2619 .61803 L
s
.5 .61178 m
.5 .61803 L
s
.7381 .61178 m
.7381 .61803 L
s
.97619 .61178 m
.97619 .61803 L
s
.125 Mabswid
.07143 .61428 m
.07143 .61803 L
s
.11905 .61428 m
.11905 .61803 L
s
.16667 .61428 m
.16667 .61803 L
s
.21429 .61428 m
.21429 .61803 L
s
.30952 .61428 m
.30952 .61803 L
s
.35714 .61428 m
.35714 .61803 L
s
.40476 .61428 m
.40476 .61803 L
s
.45238 .61428 m
.45238 .61803 L
s
.54762 .61428 m
.54762 .61803 L
s
.59524 .61428 m
.59524 .61803 L
s
.64286 .61428 m
.64286 .61803 L
s
.69048 .61428 m
.69048 .61803 L
s
.78571 .61428 m
.78571 .61803 L
s
.83333 .61428 m
.83333 .61803 L
s
.88095 .61428 m
.88095 .61803 L
s
.92857 .61428 m
.92857 .61803 L
s
.25 Mabswid
0 .61803 m
1 .61803 L
s
.99375 .08348 m
1 .08348 L
s
.99375 .18745 m
1 .18745 L
s
.99375 .29142 m
1 .29142 L
s
.99375 .39538 m
1 .39538 L
s
.99375 .49935 m
1 .49935 L
s
.99375 .60332 m
1 .60332 L
s
.125 Mabswid
.99625 .10947 m
1 .10947 L
s
.99625 .13546 m
1 .13546 L
s
.99625 .16146 m
1 .16146 L
s
.99625 .21344 m
1 .21344 L
s
.99625 .23943 m
1 .23943 L
s
.99625 .26542 m
1 .26542 L
s
.99625 .31741 m
1 .31741 L
s
.99625 .3434 m
1 .3434 L
s
.99625 .36939 m
1 .36939 L
s
.99625 .42138 m
1 .42138 L
s
.99625 .44737 m
1 .44737 L
s
.99625 .47336 m
1 .47336 L
s
.99625 .52534 m
1 .52534 L
s
.99625 .55134 m
1 .55134 L
s
.99625 .57733 m
1 .57733 L
s
.99625 .05749 m
1 .05749 L
s
.99625 .0315 m
1 .0315 L
s
.99625 .0055 m
1 .0055 L
s
.25 Mabswid
1 0 m
1 .61803 L
s
0 .08348 m
1 .08348 L
s
.5 0 m
.5 .61803 L
s
0 0 1 r
.5 Mabswid
.02381 .08181 m
.02605 .08172 L
.02846 .08164 L
.03053 .08158 L
.03279 .08154 L
.03416 .08152 L
.03543 .0815 L
.03665 .08149 L
.03793 .08149 L
.03908 .08149 L
.04016 .0815 L
.04135 .08151 L
.04262 .08153 L
.04393 .08156 L
.04516 .08159 L
.04793 .08167 L
.05037 .08177 L
.05297 .0819 L
.06244 .08255 L
.08414 .08471 L
.08932 .08523 L
.09479 .08572 L
.09985 .0861 L
.10232 .08625 L
.10458 .08637 L
.10694 .08646 L
.10918 .08653 L
.1104 .08655 L
.11154 .08657 L
.11278 .08658 L
.1141 .08658 L
.11534 .08658 L
.11603 .08657 L
.11666 .08656 L
.11784 .08654 L
.11907 .0865 L
.12169 .08641 L
.12455 .08625 L
.12739 .08605 L
.12997 .08584 L
.13575 .08522 L
.14616 .08373 L
.15627 .08201 L
.16696 .08021 L
.17137 .07956 L
.1761 .07896 L
.17881 .07868 L
.18129 .07847 L
.18248 .07838 L
.18378 .0783 L
Mistroke
.18501 .07824 L
.18614 .07819 L
.1874 .07815 L
.18806 .07814 L
.18876 .07813 L
.18993 .07812 L
.19122 .07813 L
.19237 .07814 L
.19359 .07818 L
.19476 .07822 L
.19581 .07828 L
.19835 .07845 L
.2011 .07872 L
.2061 .07939 L
.21077 .08025 L
.21572 .08138 L
.22461 .08387 L
.23423 .08698 L
.24434 .09024 L
.25298 .09256 L
.25535 .09307 L
.25787 .09353 L
.26023 .09388 L
.26241 .09412 L
.26363 .09422 L
.26492 .0943 L
.26622 .09435 L
.26696 .09436 L
.26764 .09437 L
.26889 .09435 L
.27002 .09431 L
.27133 .09423 L
.27258 .09412 L
.27369 .094 L
.27487 .09383 L
.27699 .09347 L
.27928 .09296 L
.2818 .09227 L
.28697 .09041 L
.29256 .08774 L
.30267 .08134 L
.32229 .06577 L
.33268 .0583 L
.33566 .05658 L
.33849 .05522 L
.34102 .05424 L
.34245 .05381 L
.34378 .05348 L
.34496 .05326 L
.34624 .0531 L
Mistroke
.34697 .05304 L
.34766 .05301 L
.34895 .05303 L
.34961 .05307 L
.35031 .05314 L
.35158 .05335 L
.35235 .05352 L
.35308 .05371 L
.35444 .05416 L
.3569 .05529 L
.35917 .05669 L
.36165 .05866 L
.36428 .06124 L
.36899 .06726 L
.37338 .07457 L
.38337 .09766 L
.39383 .13182 L
.40374 .17335 L
.4223 .27104 L
.44053 .38061 L
.46065 .49463 L
.47017 .53858 L
.48044 .57468 L
.48319 .58206 L
.48609 .58869 L
.48878 .59376 L
.49128 .59753 L
.49363 .60022 L
.49494 .60137 L
.49614 .60218 L
.49745 .60282 L
.49819 .60307 L
.49887 .60322 L
.50012 .60332 L
.50075 .60328 L
.50145 .60316 L
.50274 .60274 L
.50395 .60213 L
.50526 .60121 L
.50667 .59993 L
.50927 .59679 L
.51162 .59308 L
.51641 .58305 L
.52091 .5707 L
.53096 .53384 L
.54181 .48198 L
.56141 .36886 L
.58288 .24167 L
.59278 .18993 L
.60336 .14273 L
Mistroke
.61335 .10727 L
.62244 .08311 L
.62727 .07338 L
.63239 .06531 L
.63676 .06015 L
.63925 .05789 L
.64158 .05619 L
.64286 .05542 L
.64426 .05471 L
.64549 .05419 L
.64681 .05374 L
.64811 .05341 L
.64929 .0532 L
.65047 .05306 L
.65159 .05301 L
.6529 .05303 L
.65356 .05308 L
.65428 .05315 L
.65557 .05335 L
.65676 .05361 L
.65946 .05441 L
.66236 .0556 L
.66764 .05849 L
.67253 .06181 L
.68359 .07054 L
.69397 .07885 L
.70371 .08559 L
.71269 .09026 L
.71773 .09213 L
.71997 .09277 L
.72236 .09334 L
.72485 .09379 L
.72595 .09395 L
.72716 .09409 L
.72789 .09416 L
.72857 .09422 L
.7292 .09427 L
.7299 .0943 L
.73111 .09435 L
.7324 .09437 L
.7331 .09436 L
.73377 .09435 L
.73503 .0943 L
.73573 .09426 L
.73638 .09422 L
.73786 .09409 L
.74033 .0938 L
.74296 .09339 L
.74833 .09226 L
.75327 .09095 L
Mistroke
.76441 .08743 L
.77485 .08403 L
.78459 .0813 L
.78926 .08024 L
.79369 .07943 L
.79613 .07906 L
.79879 .07873 L
.80121 .07849 L
.80344 .07832 L
.80462 .07825 L
.8059 .0782 L
.8071 .07816 L
.80821 .07813 L
.80943 .07812 L
.81013 .07812 L
.81077 .07812 L
.81208 .07814 L
.81281 .07816 L
.81347 .07818 L
.81484 .07823 L
.8161 .0783 L
.81895 .07849 L
.82146 .0787 L
.82411 .07898 L
.83357 .08029 L
.84372 .08201 L
.85323 .08363 L
.86204 .08494 L
.86686 .08552 L
.87219 .08602 L
.87495 .08622 L
.87755 .08637 L
.88029 .08648 L
.88183 .08653 L
.88257 .08655 L
.88325 .08656 L
.88441 .08657 L
.88566 .08658 L
.88682 .08658 L
.88792 .08658 L
.88919 .08656 L
.89037 .08654 L
.89167 .08651 L
.89304 .08646 L
.89557 .08636 L
.89795 .08623 L
.90336 .08587 L
.92324 .08393 L
.93304 .08295 L
.93781 .08253 L
Mistroke
.94214 .0822 L
.94592 .08196 L
.95002 .08175 L
.95227 .08167 L
.95434 .0816 L
.95633 .08155 L
.95732 .08153 L
.95842 .08152 L
.95961 .0815 L
.96074 .0815 L
.96175 .08149 L
.96286 .08149 L
.96405 .0815 L
.96533 .08151 L
.96641 .08152 L
.96761 .08154 L
.96974 .08159 L
.97204 .08166 L
.97619 .08181 L
Mfstroke
1 0 0 r
.02381 .08695 m
.04262 .07959 L
.0522 .07613 L
.05756 .07458 L
.06244 .07352 L
.06501 .07312 L
.06636 .07295 L
.0678 .07281 L
.06905 .07272 L
.06976 .07268 L
.07043 .07265 L
.0716 .07262 L
.07286 .07261 L
.0741 .07264 L
.0748 .07267 L
.07545 .0727 L
.07665 .07279 L
.07792 .07291 L
.08035 .07323 L
.08255 .07361 L
.088 .07495 L
.0939 .07697 L
.10458 .08181 L
.12413 .09183 L
.12948 .09414 L
.13243 .09522 L
.13522 .09611 L
.13782 .09679 L
.13919 .09709 L
.14064 .09737 L
.14186 .09756 L
.14321 .09774 L
.14443 .09786 L
.14558 .09793 L
.14678 .09798 L
.14789 .09799 L
.14911 .09797 L
.15041 .0979 L
.15107 .09785 L
.15178 .09778 L
.15308 .09762 L
.1555 .09721 L
.15779 .09667 L
.16023 .09596 L
.16459 .09432 L
.17434 .08916 L
.18507 .08182 L
.19505 .07456 L
.20452 .06846 L
.20974 .06583 L
Mistroke
.2125 .06472 L
.21544 .06379 L
.21683 .06343 L
.21815 .06316 L
.21933 .06297 L
.22061 .06282 L
.22183 .06272 L
.22311 .06268 L
.22421 .0627 L
.22541 .06276 L
.22672 .06289 L
.22793 .06307 L
.22926 .06334 L
.23067 .06369 L
.23303 .06444 L
.23564 .06552 L
.24045 .06817 L
.24496 .07137 L
.26589 .09245 L
.27574 .10312 L
.28112 .10819 L
.28611 .11209 L
.29039 .11464 L
.29279 .11568 L
.29496 .11638 L
.2962 .11667 L
.29735 .11685 L
.29861 .11697 L
.29924 .117 L
.29993 .117 L
.3011 .11693 L
.30236 .11677 L
.30355 .11653 L
.30463 .11623 L
.30691 .11537 L
.30942 .11403 L
.31205 .11221 L
.31452 .1101 L
.32369 .09906 L
.33367 .08215 L
.34444 .06052 L
.3548 .03979 L
.35986 .03092 L
.36446 .02413 L
.36679 .02127 L
.36932 .01868 L
.37071 .01752 L
.372 .01661 L
.37321 .0159 L
.37452 .01532 L
Mistroke
.37584 .01493 L
.37707 .01474 L
.37782 .01472 L
.37854 .01476 L
.37918 .01484 L
.37988 .015 L
.38062 .01524 L
.3813 .01551 L
.38282 .01635 L
.38422 .01741 L
.38555 .01865 L
.38796 .02155 L
.39021 .02503 L
.39532 .03577 L
.4003 .05014 L
.40564 .06987 L
.41531 .11664 L
.42412 .17043 L
.44483 .32431 L
.46398 .46815 L
.47358 .5273 L
.48258 .56931 L
.4871 .58449 L
.48964 .59112 L
.49197 .59597 L
.49438 .59971 L
.49575 .60125 L
.49702 .6023 L
.49771 .60272 L
.49837 .60301 L
.49959 .6033 L
.50091 .60323 L
.50165 .60301 L
.50233 .6027 L
.50359 .60185 L
.50478 .60071 L
.50701 .5977 L
.50942 .59322 L
.51204 .58689 L
.51675 .57183 L
.52111 .55388 L
.53111 .49998 L
.54176 .4275 L
.56178 .27268 L
.57231 .19478 L
.58341 .12385 L
.59339 .07391 L
.59906 .05227 L
.60433 .03664 L
.60683 .03076 L
Mistroke
.60919 .02608 L
.61134 .02256 L
.61362 .01956 L
.61479 .01831 L
.61609 .01715 L
.61729 .01629 L
.61838 .01567 L
.61966 .01514 L
.62037 .01494 L
.62105 .01481 L
.62224 .01472 L
.62355 .01481 L
.62419 .01493 L
.62488 .01512 L
.6261 .01557 L
.62741 .01625 L
.62886 .01719 L
.63144 .01941 L
.63386 .02202 L
.64321 .03617 L
.66418 .07802 L
.67463 .09652 L
.67977 .10379 L
.68452 .10918 L
.68883 .11287 L
.69101 .11429 L
.69226 .11497 L
.69341 .11551 L
.69456 .11596 L
.69581 .11636 L
.69707 .11666 L
.69776 .11679 L
.6984 .11688 L
.69958 .11698 L
.70066 .117 L
.7019 .11693 L
.70308 .11679 L
.70423 .11658 L
.70547 .11627 L
.7077 .11549 L
.71036 .11425 L
.71279 .11282 L
.72308 .10429 L
.74153 .08423 L
.75074 .075 L
.75579 .07079 L
.76055 .06755 L
.76326 .06606 L
.76619 .06474 L
.76885 .06382 L
Mistroke
.77012 .06348 L
.7713 .06322 L
.77242 .06302 L
.77362 .06285 L
.7743 .06278 L
.77495 .06274 L
.77616 .06269 L
.77743 .06269 L
.77861 .06275 L
.77991 .06287 L
.78056 .06296 L
.78128 .06307 L
.78364 .06355 L
.78621 .06428 L
.79139 .06635 L
.79619 .06887 L
.80066 .07163 L
.8114 .07923 L
.82152 .08647 L
.83136 .09241 L
.8369 .09493 L
.83954 .09589 L
.84201 .09662 L
.84426 .09716 L
.84632 .09753 L
.84749 .0977 L
.8486 .09782 L
.84977 .09791 L
.85105 .09797 L
.85219 .09799 L
.85345 .09798 L
.85477 .09791 L
.85601 .09782 L
.85716 .09769 L
.85822 .09755 L
.86061 .09713 L
.86308 .09657 L
.86533 .09594 L
.87039 .09419 L
.8795 .09008 L
.89026 .08448 L
.90019 .0795 L
.90949 .07575 L
.91418 .07435 L
.91684 .07373 L
.91934 .07327 L
.92062 .07308 L
.92202 .07291 L
.92334 .07279 L
.92457 .0727 L
Mistroke
.92579 .07264 L
.92689 .07262 L
.92816 .07261 L
.92935 .07264 L
.93067 .0727 L
.93133 .07274 L
.93205 .0728 L
.93453 .07306 L
.93593 .07325 L
.93742 .0735 L
.94013 .07404 L
.949 .07652 L
.95865 .08009 L
.97619 .08695 L
Mfstroke
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003ooooooolQ
ooooo`00oooooolQooooo`00LOooool3o`000:cooooo001dooooo`03o`000?oooooooooo0:Wooooo
001Uooooo`Co000000Goooooo`000?l0003o0000ooooo`02o`000003ooooool0003o000000;o0000
0oooool2o`000003ooooool0003o000000Co00000_ooool4o`000004ooooool0003o0000o`0000[o
oooo0ol00003ooooo`?o00000oooool3o`0000;ooooo0ol00004ooooo`Co000000?oooooo`000?l0
00000ol000001Ooooooo0000o`000?l0003ooooo00;o000000?oooooo`000?l000000_l00003oooo
o`;o00000oooool3o`0000[ooooo0_l000000ooooooo0000ooooo`13ooooo`00I?ooool01?l0003o
ooooooooool00003ooooo`06o`000?ooooooooooo`000?oooooo00000oooool01?l0003ooooooooo
ool00002ooooo`05o`000?ooooooooooooooool000000oooool01?l0003oooooooooool00003oooo
o`03o`000?oooooooooo00Sooooo00Oo0000ooooooooooooooooo`000?oooooo000000?ooooo00?o
0000ooooool000000oooool01?l0003oooooooooool00004ooooo`04o`000?ooooooooooo`0000Co
oooo00?o0000ooooooooool00_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Go0000
ooooooooooooooooo`000002ooooo`03o`000?oooooo000000cooooo00Co0000oooooooooooo0000
AOooool006Gooooo0ol00003ooooo`06o`000?ooooooooooo`000?oooooo00000oooool01?l0003o
ooooooooool00002ooooo`05o`000?ooooooooooooooool000001?ooool3o`0000?ooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`03ooooo`07o`000?ooooooooooooooool0003ooooo
o`000003ooooo`04o`000?ooooooooooo`0000Cooooo00Co0000oooooooooooo00001?ooool00ol0
003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo0ol00003ooooo`03o`000?oooooo
oooo00;ooooo1Ol00008ooooo`04o`000?ooooooooooo`0004Gooooo001Tooooo`04o`000?oooooo
ooooo`0000?ooooo00Ko0000oooooooooooo0000ooooool00003ooooo`04o`000?ooooooooooo`00
00;ooooo00Go0000ooooooooooooooooo`000003ooooo`04o`000?ooooooooooo`0000?ooooo0_l0
0009ooooo`07o`000?ooooooooooooooool0003oooooo`000003ooooo`03o`000?oooooo000000?o
oooo00?o0000ooooooooool00_l00003ooooo`04o`000?ooooooooooo`0000Cooooo00?o0000oooo
ooooool00_ooool01_l0003oooooooooool0003oooooo`0000;ooooo00Go0000oooooooooooooooo
o`000004ooooo`05o`000?ooooooooooooooool000002?ooool01?l0003oooooooooool00015oooo
o`00IOooool2o`0000?ooooo1?l00003ooooo`Oo000000?oooooo`000?l000000oooool00ol0003o
ooooooooo`02ooooo`;o00000oooool2o`000003ooooool0003o000000Sooooo0ol00003ooooo`?o
00000oooool3o`0000;ooooo0_l000000ooooooo0000o`000002ooooo`?o00000_ooool3o`0000?o
oooo1?l00003ooooo`;o00000oooool4o`0000?ooooo0ol00008ooooo`;o000000?oooooo`000?l0
0000AOooool007kooooo00?o0000ooooooooool0;_ooool00ol0003oooooooooo`0Cooooo`03o`00
0?oooooooooo05Sooooo001looooo`?o0000;oooool2o`0000Cooooo00?o0000ooooooooool03_oo
ool00ol0003oooooooooo`1Hooooo`00oooooolQooooo`00oooooolQooooo`00:?ooool5o`0000?o
oooo0_l0000booooo`?o00001?ooool2o`0003;ooooo0_l0000eooooo`?o00001?ooool2o`00033o
oooo1Ol00003ooooo`;o00001oooool002Wooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool0000booooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000<?ooool0
1?l0003oooooooooool0000eooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000
<?ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000Kooooo000Rooooo`Go
00000oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0002[ooooo1Ol00003oooo
o`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000<?ooool01?l0003oooooooooool0
000eooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000<Oooool00ol0003ooooo
ooooo`02ooooo`04o`000?ooooooooooo`0000Kooooo000[ooooo`05o`000?ooooooooooooooool0
00000_ooool00ol0003oooooooooo`0`ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooo
oooo0000<?ooool01?l0003oooooooooool0000eooooo`03o`000?oooooooooo00;ooooo00Co0000
oooooooooooo0000<_ooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool0
1?ooool002Sooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0003;o
oooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0000`ooooo`04o`000?oooooooooo
o`0003Gooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0000_ooooo`05o`000?oo
ooooooooooooool000000_ooool01?l0003oooooooooool00006ooooo`00:?ooool01Ol0003ooooo
oooooooooooo000000;ooooo00Co0000oooooooooooo0000<Oooool2o`0000Cooooo00Co0000oooo
oooooooo0000<?ooool01?l0003oooooooooool0000dooooo`;o00001?ooool01?l0003ooooooooo
ool0000_ooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool00006oooo
o`00:Oooool3o`0000Cooooo0_l0000cooooo`03o`000?oooooooooo00?ooooo0_l0000booooo`;o
0000=_ooool00ol0003oooooooooo`03ooooo`;o0000<Oooool3o`0000Cooooo0_l00007ooooo`00
oooooolQooooo`00oooooolQooooo`00oooooolQooooo`00oooooolQooooo`009Oooooogo`0000Co
oooo000Uooooo`;o00001?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Sooooo
00?o0000ooooooooool00_ooool2o`0000Cooooo000Uooooo`03o`000?oooooooooo03kooooo00?o
001oooooooooool0=oooool00ol0003oooooooooo`0hooooo`03o`00Oooooooooooo03gooooo00?o
0000ooooooooool00_ooool002Gooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0H
ooooo`?oo`007?ooool00ol0003oooooooooo`0Jooooo`?oo`006oooool00ol007ooooooooooo`0m
ooooo`03o`000?oooooooooo00;ooooo000Uooooo`03o`000?oooooooooo03kooooo00?o001ooooo
ooooool05oooool2ool00003oooooooo003oo`0001_ooooo00?o0000ooooooooool06Oooool2ool0
00;ooooo0_oo000Iooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool002Go
oooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0Fooooo`03ool00?oooooooooo00?o
oooo00?oo`00ooooooooool06?ooool00ol0003oooooooooo`0Iooooo`03ool00?oooooooooo00;o
oooo00?oo`00ooooooooool05oooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;o
oooo000Uooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool05_ooool00ooo003ooooo
ooooo`03ooooo`03ool00?oooooooooo01Sooooo00?o0000ooooooooool06?ooool00ooo003ooooo
ooooo`03ooooo`03ool00?oooooooooo01Oooooo00?o001oooooooooool0?Oooool00ol0003ooooo
ooooo`02ooooo`009Oooool2o`0003oooooo00?o001oooooooooool05Oooool00ooo003ooooooooo
o`04ooooo`03ool00?oooooooooo01Sooooo00?o0000ooooooooool06?ooool00ooo003ooooooooo
o`04ooooo`03ool00?oooooooooo01Kooooo00?o001oooooooooool0??ooool2o`0000Cooooo000U
ooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool05Oooool00ooo003oooooooooo`05
ooooo`03ool00?oooooooooo01Oooooo00?o0000ooooooooool06?ooool00ooo003oooooooooo`04
ooooo`03ool00?oooooooooo01Kooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02
ooooo`009Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo01Cooooo00?oo`00oooo
ooooool01_ooool00ooo003oooooooooo`0Gooooo`03o`000?oooooooooo01Oooooo00?oo`00oooo
ooooool01_ooool00ooo003oooooooooo`0Eooooo`03o`00Oooooooooooo03gooooo00?o0000oooo
ooooool00_ooool002Gooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0Dooooo`03
ool00?oooooooooo00Oooooo00?oo`00ooooooooool05_ooool00ol0003oooooooooo`0Gooooo`03
ool00?oooooooooo00Kooooo00?oo`00ooooooooool05Oooool00ol007ooooooooooo`0mooooo`03
o`000?oooooooooo00;ooooo000Uooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool0
4oooool00ooo003oooooooooo`08ooooo`03ool00?oooooooooo01Kooooo00?o0000ooooooooool0
5_ooool00ooo003oooooooooo`08ooooo`03ool00?oooooooooo01Cooooo00?o001oooooooooool0
?Oooool00ol0003oooooooooo`02ooooo`009Oooool00ol0003oooooooooo`0nooooo`03o`00Oooo
oooooooo01?ooooo00?oo`00ooooooooool02Oooool00ooo003oooooooooo`0Eooooo`03o`000?oo
oooooooo01Kooooo00?oo`00ooooooooool02Oooool00ooo003oooooooooo`0Cooooo`03o`00Oooo
oooooooo03gooooo00?o0000ooooooooool00_ooool002Gooooo00?o0000ooooooooool0?_ooool0
0ol007ooooooooooo`0@ooooo`;o003o00?oo`00o`00ool00?l02_ooool00ooo003oooooooooo`0E
ooooo`03o`000?oooooooooo01Kooooo00?oo`00ooooooooool01oooool2o`00o`04ool00?l00?oo
003oo`00oa;ooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`009Oooool2
o`0003oooooo00?o001oooooooooool03_ooool2o`00o`;ooooo00Coo`00oooooooooooo003o2Ooo
ool00ooo003oooooooooo`0Eooooo`03o`000?oooooooooo01Gooooo00?oo`00ooooooooool01ooo
ool01Ol00?ooooooooooooooooooo`0000;ooooo0_l00?l@ooooo`03o`00Oooooooooooo03cooooo
0_l00004ooooo`009Oooool00ol0003oooooooooo`0booooo`Koo`001_ooool00ol007oooooooooo
o`0=ooooo`05o`00oooooooooooooooooooo00001?ooool00ol00?ooooooooooo`07ooooo`03ool0
0?oooooooooo01Cooooo00?o0000ooooooooool05Oooool00ooo003oooooooooo`07ooooo`05o`00
oooooooooooooooooooo00001?ooool00ol00?ooooooooooo`0=ooooo`03o`00Oooooooooooo00Co
oooo1_oo000cooooo`03o`000?oooooooooo00;ooooo000Uooooo`03o`000?oooooooooo02oooooo
1?oo0004ooooo`?oo`001?ooool00ol007ooooooooooo`0;ooooo`;o003o1?ooool00ooo003ooooo
ooooo`03ooooo`03o`00oooooooooooo00Kooooo00?oo`00ooooooooool05?ooool00ol0003ooooo
ooooo`0Eooooo`03ool00?oooooooooo00Kooooo00?o003oooooooooool00oooool00ooo003ooooo
ooooo`02ooooo`03o`00oooooooooooo00cooooo00?o001oooooooooool00_ooool3ool000Gooooo
00?oo`00ooooooooool0<?ooool00ol0003oooooooooo`02ooooo`009Oooool00ol0003ooooooooo
o`0?ooooo`;oo`007Oooool00ooo003oooooooooo`09ooooo`05ool00?ooooooooooooooool007l0
3?ooool00ol00?ooooooooooo`03ooooo`03ool00?oooooooooo00Cooooo00?o003oooooooooool0
1_ooool00ooo003oooooooooo`0Dooooo`03o`000?oooooooooo01Cooooo00?oo`00ooooooooool0
1oooool00ol00?ooooooooooo`04ooooo`03ool00?oooooooooo00;ooooo0_l00?l<ooooo`05o`00
Oooooooooooooooooooo00002Oooool3ool001gooooo0_oo000@ooooo`03o`000?oooooooooo00;o
oooo000Nooooo`;o00001Oooool00ol0003oooooooooo`09ooooo`_oo`006Oooool00ooo003ooooo
ooooo`0;ooooo`04ool00?ooooooooooo`00O`_ooooo00?o003oooooooooool00oooool00ooo003o
ooooooooo`06ooooo`03o`00oooooooooooo00Gooooo00?oo`00ooooooooool05?ooool00ol0003o
ooooooooo`0Dooooo`03ool00?oooooooooo00Kooooo00?o003oooooooooool01Oooool00ooo003o
ooooooooo`04ooooo`03o`00oooooooooooo00Wooooo00Co001oooooooooooooo`003Oooool00ooo
003oooooooooo`0Eooooo`goo`002_ooool00ol0003oooooooooo`02ooooo`007Oooool01?l0003o
ooooooooool00004ooooo`03o`000?oooooooooo00Oooooo0_oo000;ooooo`?oo`003_ooool7o`00
o`03ool00?l00?oo003o00?o003o2_ooool00ooo003oooooo`00O`0:ooooo`03o`00oooooooooooo
00Cooooo00?oo`00ooooooooool01_ooool00ol00?ooooooooooo`05ooooo`03ool00?oooooooooo
01Cooooo00?o0000ooooooooool05?ooool00ooo003oooooooooo`05ooooo`03o`00oooooooooooo
00Oooooo00?oo`00ooooooooool01?ooool00ol00?ooooooooooo`08ooooo`03o`00Ooooooooo`00
00Wooooo1_l00?l00ooo003o003oo`00o`05o`00o`gooooo0_oo000=ooooo`;oo`002?ooool00ol0
003oooooooooo`02ooooo`007Oooool01?l0003oooooooooool00004ooooo`Ko000000Co003oool0
0?oo003oo`003?l00?l4o`0000;oo`001ol00005o`00o`Go00000_oo0006o`0000Go003o1_l00000
0ooo003o0000o`000007o`0000;o003o1_l000000ooo003o0000o`000008o`000003o`00ool0003o
000000Co000000?oo`00o`000?l00000:ol000000ooo003o0000o`000004o`000003o`00ool0003o
000000So000000?oo`00o`000?l000001Ol000000ol00?oo0000o`000008o`000003ool00?l0003o
000000Co00001?l00?l7o`000003ool00?l0003o000000Co00001?l00?l7o`0000;oo`001?l0000=
o`00o`;oo`0000?o003oo`000?l000001?l00004ooooo`007Oooool01?l0003oooooooooool00004
ooooo`03o`000?oooooooooo00?ooooo00?oo`00ooooooooool03Oooool6o`00o`?oo`001?l00?l9
ooooo`03ool00?oooooooooo00_ooooo0_l00?l5ooooo`03ool00?oooooooooo00Cooooo0_l00?l8
ooooo`03ool00?oooooooooo00Sooooo00?o003oooooooooool01Oooool00ooo003oooooooooo`0C
ooooo`03o`000?oooooooooo01Cooooo00?oo`00ooooooooool01?ooool00ol00?ooooooooooo`09
ooooo`03ool00?oooooooooo00Gooooo0ol00?l6ooooo`03ool00?oooooooooo00;ooooo0ol00?l<
ooooo`?oo`001oooool6o`00o`03ool00?l00?oo003o00Co003o3oooool00ooo003oooooooooo`03
ooooo`03o`000?oooooooooo00;ooooo000Mooooo`04o`000?ooooooooooo`0000Cooooo00?o0000
ooooooooool07?ooool00ooo003oooooooooo`08ooooo`;oo`004?ooool3o`00o`;ooooo00Co001o
ool00?oooooooooo0ol00?l9ooooo`03ool00?oooooooooo00[ooooo00?o003oooooooooool01?oo
ool00ooo003oooooooooo`0Cooooo`03o`000?oooooooooo01?ooooo00?oo`00ooooooooool01?oo
ool00ol00?ooooooooooo`0:ooooo`03ool00?oooooooooo00Sooooo0_l00?l3ooooo`03ool00?l0
07oooooo00?o003o4_ooool00ooo003oooooooooo`08ooooo`;oo`007?ooool00ol0003ooooooooo
o`02ooooo`007Oooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo01gooooo0ooo
0004ooooo`?oo`005Oooool3o`00o`03ool00?l00?oo003o00cooooo00?oo`00ooooooooool02_oo
ool00ol00?ooooooooooo`04ooooo`03ool00?oooooooooo01?ooooo00?o0000ooooooooool04ooo
ool00ooo003oooooooooo`04ooooo`03o`00oooooooooooo00_ooooo00?oo`00ooooooooool02Ooo
ool2o`00o`04ool00?l00?oo003oo`00oaKooooo0_oo0005ooooo`?oo`007_ooool00ol0003ooooo
ooooo`02ooooo`001oooool01_oGV5coRLSbooooooooooOoV45?ol;boa7ooooo0_l00005ooooo`03
o`000?oooooooooo023ooooo1Ooo000Iooooo`03o`00Ooooooooo`0000cooooo00?oo`00oooooooo
ool03?ooool00ol00?ooooooooooo`03ooooo`03ool00?oooooooooo01?ooooo00?o0000oooooooo
ool04oooool00ooo003oooooooooo`04ooooo`03o`00oooooooooooo00_ooooo00?oo`00oooooooo
ool02_ooool01?oo003oooooooooool007lIooooo`Goo`008Oooool00ol0003oooooooooo`02oooo
o`001Oooool01?ool]OoRE`^o`000?l0;Rh2obh^;P03o`00Coo8l_oooooo01Oooooo00?o0000oooo
ooooool0?_ooool01?l007oooooooooooooo000;ooooo`03ool00?oooooooooo00cooooo00?o003o
ooooooooool00oooool00ooo003oooooooooo`0Cooooo`03o`000?oooooooooo01?ooooo00?oo`00
ooooooooool00oooool00ol00?ooooooooooo`0=ooooo`;oo`002Oooool01Ooo003ooooooooooooo
oooo001o03oooooo00?o0000ooooooooool00_ooool000Gooooo00Sok/R2od62]onmREcoNK7Gonk^
j_o^k]OoPRi?ol;boaSooooo00?o0000ooooooooool0?_ooool01?l007ooooooooooooooool2ool0
00Sooooo00?oo`00ooooooooool03Oooool00ol00?ooooooooooo`04ooooo`03ool00?oooooooooo
01;ooooo00?o0000ooooooooool04oooool00ooo003oooooooooo`03ooooo`03o`00oooooooooooo
00oooooo00?oo`00ooooooooool01Oooool00ooo003oooooooooo`02ooooo`03o`00Oooooooooooo
03gooooo00?o0000ooooooooool00_ooool000Gooooo00SodYQ1odn[g?oGV4ooNL;^oooooooooo;o
RBi1ol;boaSooooo0_l0000oooooo`03o`00Oooooooooooo00?ooooo00?oo`00ooooooooool00ooo
ool2ool0017ooooo00?o003oooooooooool00oooool00ooo003oooooooooo`0Booooo`03o`000?oo
oooooooo01?ooooo00?oo`00ooooooooool00oooool00ol00?ooooooooooo`0@ooooo`03ool00?oo
oooooooo00?ooooo00?oo`00ooooooooool00oooool00ol007ooooooooooo`0looooo`;o00001?oo
ool000Gooooo00ConnG=okO=j_oonnkok_Ok0_ooool00oogl_;onoooooooo`0Gooooo`03o`000?oo
oooooooo03kooooo00?o001oooooooooool01?ooool5ool001?ooooo00?o003oooooooooool00ooo
ool00ooo003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?oo`00ooooooooool01?oo
ool00ol00?ooooooooooo`0@ooooo`Koo`001_ooool00ol007ooooooooooo`0mooooo`03o`000?oo
oooooooo00;ooooo0009ooooo`03ooool_oGcLgoh>kk01Wooooo00?o0000ooooooooool0?_ooool0
0ol007ooooooooooo`0Looooo`03o`00oooooooooooo00?ooooo00?oo`00ooooooooool04_ooool0
0ol0003oooooooooo`0Booooo`03ool00?oooooooooo00?ooooo00?o003oooooooooool07Oooool0
0ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0007ooooo`06on[2TOn2/Lgo/G0^
o`0^0?l005cod_Oo6?ooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo01cooooo00?o
003oooooooooool00oooool00ooo003oooooooooo`0Booooo`03o`000?oooooooooo01;ooooo00?o
o`00ooooooooool00oooool00ol00?ooooooooooo`0Mooooo`03o`00Oooooooooooo03gooooo00?o
0000ooooooooool00_ooool000Oooooo00Kob8ULoi6m]om`Ci7omookoiQ1Coo2k_lHooooo`03o`00
0?oooooooooo03kooooo00?o001oooooooooool07Oooool00ol00?ooooooooooo`03ooooo`03ool0
0?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ooo003oooooooooo`03ooooo`03o`00
oooooooooooo01gooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`001ooo
ool01_o8RFKoWl:aoea1V?obnmcoL2i`omOkoaSooooo00?o0000ooooooooool0?_ooool00ol007oo
ooooooooo`0Mooooo`03o`00oooooooooooo00?ooooo00?oo`00ooooooooool04Oooool00ol0003o
ooooooooo`0Booooo`03ool00?oooooooooo00?ooooo00?o003oooooooooool07Oooool00ol007oo
ooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0007ooooo`06onFmROl0003o0000o`000?l0
073oeoOo6?ooool2o`0003oooooo00?o001oooooooooool07Oooool00ol00?ooooooooooo`03oooo
o`03ool00?oooooooooo017ooooo00?o0000ooooooooool04_ooool00ooo003oooooooooo`03oooo
o`03o`00oooooooooooo01gooooo00?o001oooooooooool0??ooool2o`0000Cooooo0008ooooo`05
ooogmoobl_;onoOUoi5?I_o8l_l06?ooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo
01gooooo00?o003oooooooooool00oooool00ooo003oooooooooo`0Aooooo`03o`000?oooooooooo
017ooooo00?oo`00ooooooooool00oooool00ol00?ooooooooooo`0Nooooo`03o`00Oooooooooooo
03gooooo00?o0000ooooooooool00_ooool000Oooooo00KomnkZoo;kooooooooooooon3=cOoZnolH
ooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool07_ooool00ol00?ooooooooooo`02
ooooo`03ool00?oooooooooo017ooooo00?o0000ooooooooool04Oooool00ooo003oooooooooo`03
ooooo`03o`00oooooooooooo01kooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02
ooooo`001oooool01_o8PRkoI[7Goo;^j_o^k]OoL00^ol;boaSooooo00?o0000ooooooooool0?_oo
ool00ol007ooooooooooo`0Nooooo`03o`00oooooooooooo00?ooooo00?oo`00ooooooooool04?oo
ool00ol0003oooooooooo`0Aooooo`03ool00?oooooooooo00?ooooo00?o003oooooooooool07_oo
ool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0007ooooo`06on2aNOl0003o
02i1odm?@Ol004oob?;o6?ooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo01kooooo
00?o003oooooooooool00oooool00ooo003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo
00?oo`00ooooooooool00oooool00ol00?ooooooooooo`0Nooooo`03o`00Oooooooooooo03gooooo
00?o0000ooooooooool00_ooool000Oooooo00KoiKf2od5`/Ookooooooogoi4^@Oo2l_lHooooo`03
o`000?oooooooooo03kooooo00?o001oooooooooool07oooool00ol00?ooooooooooo`02ooooo`03
ool00?oooooooooo013ooooo00?o0000ooooooooool04Oooool00ooo003oooooooooo`02ooooo`03
o`00oooooooooooo01oooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`00
1oooool01_o8PRkoNL;^ooooooooooOo/H:9om;boaSooooo0_l0000oooooo`03o`00Oooooooooooo
01oooooo00?o003oooooooooool00_ooool00ooo003oooooooooo`0@ooooo`03o`000?oooooooooo
017ooooo00?oo`00ooooooooool00_ooool00ol00?ooooooooooo`0Oooooo`03o`00Oooooooooooo
03cooooo0_l00004ooooo`001oooool00ooLZh;oP[7Pooooo`0Kooooo`03o`000?oooooooooo03ko
oooo00?o001oooooooooool07oooool00ol00?ooooooooooo`02ooooo`03ool00?oooooooooo013o
oooo00?o0000ooooooooool04?ooool00ooo003oooooooooo`03ooooo`03o`00oooooooooooo01oo
oooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`009Oooool00ol0003ooooo
ooooo`0nooooo`03o`00Oooooooooooo023ooooo00?o003oooooooooool00_ooool00ooo003ooooo
ooooo`0?ooooo`03o`000?oooooooooo013ooooo00?oo`00ooooooooool00_ooool00ol00?oooooo
ooooo`0Pooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Oooooo00Ko
eiQLohW8l_ooooooooogoiQ1Coo2l_lHooooo`03o`000?oooooooooo03kooooo00?o001ooooooooo
ool08?ooool00ol00?ooooooooooo`02ooooo`03ool00?oooooooooo00oooooo00?o0000oooooooo
ool04?ooool00ooo003oooooooooo`02ooooo`03o`00oooooooooooo023ooooo00?o001ooooooooo
ool0?Oooool00ol0003oooooooooo`02ooooo`001Oooool01?ool]OoRE`^o`000?l0;Rh2obh^;P03
o`00Coo8l_oooooo00Cooooo0_l00004ooooo`04o`000?ooooooooooooooo`Go00001?ooool00ol0
003oooooooooo`0nooooo`03o`00Oooooooooooo023ooooo00?o003oooooooooool00_ooool00ooo
003oooooooooo`0?ooooo`03o`000?oooooooooo013ooooo00?oo`00ooooooooool00_ooool00ol0
0?ooooooooooo`0Pooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Go
oooo00Sok/R2od62]onmREcoNK7Gonk^j_o^k]OoPRi?ol;bo`Cooooo00Co0000oooooooooooo0000
2?ooool01?l0003oooooooooool00004ooooo`03o`000?oooooooooo03kooooo00?o001ooooooooo
ool08?ooool00ol00?ooooooooooo`02ooooo`03ool00?oooooooooo00oooooo00?o0000oooooooo
ool04?ooool00ooo003oooooooooo`02ooooo`03o`00oooooooooooo023ooooo00?o001ooooooooo
ool0?Oooool00ol0003oooooooooo`02ooooo`001Oooool02?oBV47oCj_LomNHComi`^kooooooooo
l_n9;T7o`_;o1?ooool01?l0003oooooooooool00009ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0?_ooool00ol007ooooooooooo`0Pooooo`03o`00oooooooooooo00;ooooo00?o
o`00ooooooooool03oooool00ol0003oooooooooo`0@ooooo`05ool00?ooooooooooooooool00?l0
8oooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0005ooooo`04oo_UcOng
cN[ooo_^onkgn`;ooooo00?omo;boo_oooooool00oooool01?l0003oooooooooool0000:ooooo`03
o`000?oooooooooo00?ooooo0ol0001Ro`00O`05o`00ool007oo001oo`00Oooo00004Ol007l00ol0
003o001oo`00O`0?o`00O`03ool00?l007oo001o00;o001o00?o003oo`00Ool007l0H?l007l2o`00
00Cooooo000;ooooo`03ooObl_okoooooooo00?ooooo00Co0000oooooooooooo00001oooool01Ol0
003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0Q
ooooo`03o`00oooooooooooo00;ooooo00?oo`00ooooooooool03_ooool00ol0003oooooooooo`0?
ooooo`03ool00?oooooooooo00;ooooo00?o003oooooooooool08Oooool00ol007ooooooooooo`0m
ooooo`03o`000?oooooooooo00;ooooo0007ooooo`06on2mZoo8j__oooooooool_nA;T7o`_;o1?oo
ool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003o
ooooooooo`0nooooo`03o`00Oooooooooooo027ooooo00?o003oooooooooool00_ooool00ooo003o
ooooooooo`0>ooooo`03o`000?oooooooooo00oooooo00?oo`00ooooooooool00_ooool00ol00?oo
ooooooooo`0Qooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Cooooo
00Wooookomc8]oo8h>kocHT^odnH`_oPg=cog=c8og0^Coo8l_l01Oooool2o`0000Wooooo0ol00005
ooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool08Oooool00ol00?ooooooooooo`02
ooooo`03ool00?oooooooooo00kooooo00?o0000ooooooooool03oooool00ooo003oooooooooo`02
ooooo`03o`00oooooooooooo027ooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02
ooooo`001?ooool01?oooo;oYE`0oebUeooP`YP2oeaLG003ofIVG?l004oob?;o01Sooooo00?o0000
ooooooooool0?_ooool00ol007ooooooooooo`0Qooooo`03o`00oooooooooooo00;ooooo00?oo`00
ooooooooool03_ooool00ol0003oooooooooo`0?ooooo`05ool00?ooooooooooooooool00?l09?oo
ool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo000:ooooo`03oooomonA;T7o
`_;o01Sooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0Qooooo`03o`00oooooooo
oooo00;ooooo00?oo`00ooooooooool03_ooool00ol0003oooooooooo`0?ooooo`05ool00?oooooo
ooooooooool00?l09?ooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo000:
ooooo`03oooomoo2WiooeoOo01Sooooo0_l0000oooooo`03o`00Oooooooooooo02;ooooo00Go003o
ooooooooooooooooool0000@ooooo`03o`000?oooooooooo00kooooo00?oo`00ooooooooool00_oo
ool00ol00?ooooooooooo`0Rooooo`03o`00Oooooooooooo03cooooo0_l00004ooooo`002?ooool0
1?ogiM;o]k6[ok6mcOoboolIooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool08_oo
ool01Ol00?ooooooooooooooooooo`00013ooooo00?o0000ooooooooool03_ooool00ooo003ooooo
ooooo`02ooooo`03o`00oooooooooooo02;ooooo00?o001oooooooooool0?Oooool00ol0003ooooo
ooooo`02ooooo`001oooool01_obdYoo0000o`000?l0003o046HonkooaSooooo00?o0000oooooooo
ool0?_ooool00ol007ooooooooooo`0Rooooo`03o`00oooooooooooo00;ooooo00?oo`00oooooooo
ool03Oooool00ol0003oooooooooo`0>ooooo`03ool00?oooooooooo00;ooooo00?o003ooooooooo
ool08_ooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0007ooooo`06ol:2
ConHcMcoWdmLom;kl_nH@Doo`^ko6?ooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo
02;ooooo00?o003oooooooooool00_ooool00ooo003oooooooooo`0=ooooo`03o`000?oooooooooo
00kooooo00?oo`00ooooooooool00_ooool00ol00?ooooooooooo`0Rooooo`03o`00Oooooooooooo
03gooooo00?o0000ooooooooool00_ooool000Oooooo00Ko]g1Lokg^k_nUCecocO_kok5VI_o2k_lH
ooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool08_ooool00ol00?ooooooooooo`02
ooooo`03ool00?oooooooooo00gooooo00?o0000ooooooooool03_ooool00ooo003oooooooooo`02
ooooo`03o`00oooooooooooo02;ooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02
ooooo`001oooool01_oP/G3o000^o`00Coo8iLgoC`1LomOkoaSooooo00?o0000ooooooooool0?_oo
ool00ol007ooooooooooo`0Rooooo`03o`00oooooooooooo00;ooooo00?oo`00ooooooooool03Ooo
ool00ol0003oooooooooo`0>ooooo`05ool00?ooooooooooooooool00?l09Oooool00ol007oooooo
ooooo`0mooooo`03o`000?oooooooooo00;ooooo0007ooooo`05oooonooB/I7oIW2Hom;G_OnHZm80
6Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02?ooooo00Go003ooooooooooooo
ooooool0000?ooooo`03o`000?oooooooooo00gooooo00?oo`00ooooooooool00_ooool00ol00?oo
ooooooooo`0Sooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool002Gooooo
0_l0000oooooo`03o`00Oooooooooooo02?ooooo00Go003oooooooooooooooooool0000?ooooo`03
o`000?oooooooooo00gooooo00?oo`00ooooooooool00_ooool00ol00?ooooooooooo`0Sooooo`03
o`00Oooooooooooo03cooooo0_l00004ooooo`001Oooool00ooP/HWoWm;booooo`02ooooo`03oooo
monH@Doo`_;o01Sooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0Sooooo`05o`00
oooooooooooooooooooo00003oooool00ol0003oooooooooo`0=ooooo`03ool00?oooooooooo00;o
oooo00?o003oooooooooool08oooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;o
oooo0005ooooo`03olR2;_mLV<;oemOB00;od];B00?oemO2og0^Coo8l_l06?ooool00ol0003ooooo
ooooo`0nooooo`03o`00Oooooooooooo02?ooooo00?o003oooooooooool00_ooool00ooo003ooooo
ooooo`0<ooooo`03o`000?oooooooooo00gooooo00?oo`00ooooooooool00_ooool00ol00?oooooo
ooooo`0Sooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Gooooo00?o
j/RUog1`L?m`L7000_m`L7000om`L6Ko001?olSbo`0Hooooo`03o`000?oooooooooo03kooooo00?o
001oooooooooool08oooool00ol00?ooooooooooo`02ooooo`03ool00?oooooooooo00cooooo00?o
0000ooooooooool03Oooool00ooo003oooooooooo`02ooooo`03o`00oooooooooooo02?ooooo00?o
001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`002_ooool00oooooOoTBi1ol;bo`0H
ooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool08oooool00ol00?ooooooooooo`02
ooooo`03ool00?oooooooooo00cooooo00?o0000ooooooooool03Oooool01Ooo003ooooooooooooo
oooo003o02Kooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`002_ooool0
0ooooo_ocK6gon3go`0Hooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool09?ooool0
1Ol00?ooooooooooooooooooo`0000kooooo00?o0000ooooooooool03Oooool01Ooo003ooooooooo
oooooooo003o02Kooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`002?oo
ool01?ogiLgoYIRAoin[_OoZnolIooooo`;o0000?oooool00ol007ooooooooooo`0Tooooo`05o`00
oooooooooooooooooooo00003_ooool00ol0003oooooooooo`0<ooooo`03ool00?oooooooooo00;o
oooo00?o003oooooooooool09?ooool00ol007ooooooooooo`0looooo`;o00001?ooool000Oooooo
00KommbUo`000?m`RI7oNDl0o`00P_oUoolHooooo`03o`000?oooooooooo03kooooo00?o001ooooo
ooooool09?ooool01Ol00?ooooooooooooooooooo`0000kooooo00?o0000ooooooooool03?ooool0
0ooo003oooooooooo`02ooooo`03o`00oooooooooooo02Cooooo00?o001oooooooooool0?Oooool0
0ol0003oooooooooo`02ooooo`001oooool01_o=RDooL;gZooooooooonkoRBi1ol;^oaSooooo00?o
0000ooooooooool0?_ooool00ol007ooooooooooo`0Tooooo`05o`00oooooooooooooooooooo0000
3_ooool00ol0003oooooooooo`0<ooooo`03ool00?oooooooooo00;ooooo00?o003oooooooooool0
9?ooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0005ooooo`08onkG_Oo=
k_ooiJEVofJ[h?oooooooooUoh8^G?o=l_lHooooo`03o`000?oooooooooo03kooooo00?o001ooooo
ooooool09?ooool01Ol00?ooooooooooooooooooo`0000kooooo00?o0000ooooooooool03?ooool0
1Ooo003ooooooooooooooooo003o02Oooooo00?o001oooooooooool0?Oooool00ol0003ooooooooo
o`02ooooo`001Oooool02?o8PP3o045`oh9V0?l0003oCg1ioe`^0?l0047od__o1Oooool2o`0000Co
oooo00?o0000ooooooooool00oooool3o`0000Cooooo00?o0000ooooooooool0?_ooool00ol007oo
ooooooooo`0Tooooo`03o`00oooooooooooo00;ooooo00?oo`00ooooooooool02oooool00ol0003o
ooooooooo`0<ooooo`05ool00?ooooooooooooooool00?l09oooool00ol007ooooooooooo`0moooo
o`03o`000?oooooooooo00;ooooo0005ooooo`08oo_^h?o=b<SocLg=om;Bd_o=cLgod];8oh9?G?o8
l_l4ooooo`04o`000?ooooooooooo`0000[ooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0nooooo`03o`00Oooooooooooo02Gooooo00Go003oooooooooooooooooool0000=ooooo`03
o`000?oooooooooo00cooooo00Goo`00ooooooooooooooooo`00o`0Wooooo`03o`00Oooooooooooo
03gooooo00?o0000ooooooooool00_ooool0017ooooo00Co0000oooooooooooo00001oooool5o`00
00Cooooo0ol0001Vo`00O`05o`00ool007oo001oo`00Oooo00003Ol007l00ol0003o001oo`00O`0<
o`00O`05ool00?l007oo001oo`00Ool00?l0I_l007l2o`0000Cooooo000Aooooo`04o`000?oooooo
ooooo`0000Oooooo00Co0000oooooooooooo00001Oooool00ol0003oooooooooo`0nooooo`03o`00
Oooooooooooo02Gooooo00Go003oooooooooooooooooool0000=ooooo`03o`000?oooooooooo00co
oooo00Goo`00ooooooooooooooooo`00o`0Wooooo`03o`00Oooooooooooo03gooooo00?o0000oooo
ooooool00_ooool0017ooooo00Co0000oooooooooooo00002?ooool00ol0003oooooo`000005oooo
o`03o`000?oooooooooo03kooooo00?o001oooooooooool09Oooool01Ol00?oooooooooooooooooo
o`0000gooooo00?o0000ooooooooool02oooool01Ooo003ooooooooooooooooo003o02Sooooo00?o
001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`004Oooool01?l0003oooooooooool0
0009ooooo`;o00001Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02Gooooo00Go
003oooooooooooooooooool0000=ooooo`03o`000?oooooooooo00_ooooo00Goo`00oooooooooooo
ooooo`00o`0Xooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool001;ooooo
0_l0000;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0?_ooool00ol007oooooo
ooooo`0Vooooo`04o`00ooooooooooooool000gooooo00?o0000ooooooooool02oooool01Ooo003o
oooooooooooooooo003o02Sooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02oooo
o`009Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02Kooooo00Go003ooooooooo
ooooooooool0000<ooooo`03o`000?oooooooooo00_ooooo00Goo`00ooooooooooooooooo`00o`0X
ooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Wooooo00?oooobomO=
cOoPk_/06Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02Kooooo00Go003ooooo
ooooooooooooool0000<ooooo`03o`000?oooooooooo00_ooooo00Goo`00ooooooooooooooooo`00
o`0Xooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Oooooo00Koj/:A
oh:acOnaL2ko02h0o`00G?oBmolHooooo`;o0000?oooool00ol007ooooooooooo`0Vooooo`05o`00
oooooooooooooooooooo00003?ooool00ol0003oooooooooo`0;ooooo`04ool00?ooooooooooo`00
obWooooo00?o001oooooooooool0??ooool2o`0000Cooooo0007ooooo`06olR9G?nA_KOoL4nAooOo
nonH@Doo`^ko6?ooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02Kooooo00Go003o
ooooooooooooooooool0000<ooooo`03o`000?oooooooooo00_ooooo00Coo`00oooooooooooo003o
:Oooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0007ooooo`06olR9I_nO
`[7oG46Hoo;kg?m`;W3oeo_o6?ooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02Oo
oooo00Co003oooooooooooooo`003?ooool00ol0003oooooooooo`0;ooooo`04ool00?oooooooooo
o`00obWooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`001oooool01_oU
_HWo0000o`000?l0003o001`omOgoaSooooo00?o0000ooooooooool0?_ooool00ol007oooooooooo
o`0Wooooo`04o`00ooooooooooooool000cooooo00?o0000ooooooooool02oooool01?oo003ooooo
ooooool00?lYooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Sooooo
00GoooOgoo;bl_okmnGoTDmVolSbo`0Hooooo`03o`000?oooooooooo03kooooo00?o001ooooooooo
ool09oooool01?l00?oooooooooooooo000<ooooo`03o`000?oooooooooo00[ooooo00Goo`00oooo
ooooooooooooo`00o`0Yooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool0
00Oooooo00KocI5LofJO`_oGem;oemO8ogU1G?o8l_lHooooo`03o`000?oooooooooo03kooooo00?o
001oooooooooool09oooool01?l00?oooooooooooooo000<ooooo`03o`000?oooooooooo00[ooooo
00Coo`00oooooooooooo003o:_ooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;o
oooo0007ooooo`06om:HCol0;UcoNGUiogUiI_l002kob?;o6?ooool2o`0003oooooo00?o001ooooo
ooooool09oooool01Ol00?ooooooooooooooooooo`0000_ooooo00?o0000ooooooooool02_ooool0
1?oo003oooooooooool00?lZooooo`03o`00Oooooooooooo03cooooo0_l00004ooooo`001oooool0
1_ngL03oG:G=onk^j_oZj^Gob;NmonGkoaSooooo00?o0000ooooooooool0?_ooool00ol007oooooo
ooooo`0Wooooo`05o`00oooooooooooooooooooo00002oooool00ol0003oooooooooo`0:ooooo`04
ool00?ooooooooooo`00ob[ooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02oooo
o`001oooool01_oLZfKo000^oeaLG?mLG4oo000^ol;boaSooooo00?o0000ooooooooool0?_ooool0
0ol007ooooooooooo`0Xooooo`04o`00ooooooooooooool000_ooooo00?o0000ooooooooool02_oo
ool01?oo003oooooooooool00?lZooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool0
0_ooool000Oooooo00Ko/FH0oebUd_ogmoOomoO^om;8cOo^nolHooooo`03o`000?oooooooooo03ko
oooo00?o001oooooooooool0:?ooool01?l00?oooooooooooooo000;ooooo`03o`000?oooooooooo
00[ooooo00Coo`00oooooooooooo003o:_ooool00ol007ooooooooooo`0mooooo`03o`000?oooooo
oooo00;ooooo0007ooooo`06on[=ZomV@D7o;T51od51;_l002ko`_;o6?ooool00ol0003ooooooooo
o`0nooooo`03o`00Oooooooooooo02Sooooo00Co003oooooooooooooo`002oooool00ol0003ooooo
ooooo`0:ooooo`03ool00?oooooo003o02_ooooo00?o001oooooooooool0?Oooool00ol0003ooooo
ooooo`02ooooo`001oooool02?oP]ioo]mcbooooooooooooh=;Bonkkl_nmWjGog?_o5_ooool00ol0
003oooooooooo`0nooooo`03o`00Oooooooooooo02Sooooo00Co003oooooooooooooo`002oooool0
0ol0003oooooooooo`0:ooooo`03ool00?oooooo003o02_ooooo00?o001oooooooooool0?Oooool0
0ol0003oooooooooo`02ooooo`001oooool00ooBTD7o0000o`000003o`000003o`00@Oo8l_oooooo
01Gooooo0_l0000oooooo`03o`00Oooooooooooo02Sooooo00Co003oooooooooooooo`002oooool0
0ol0003oooooooooo`0:ooooo`03ool00?oooooo003o02_ooooo00?o001oooooooooool0??ooool2
o`0000Cooooo0007ooooo`08onFmNOl0IZ_ol_oooo;L/Ol^08;oj_obohT^@Oo2k_lFooooo`03o`00
0?oooooooooo03kooooo00?o001oooooooooool0:Oooool00ol00?ooooooool0000;ooooo`03o`00
0?oooooooooo00[ooooo00?oo`00ooooool00?l0:oooool00ol007ooooooooooo`0mooooo`03o`00
0?oooooooooo00;ooooo0007ooooo`08olR2@On9cOOooooooooomonA;T7o`_;komNm_OoUnolFoooo
o`03o`000?oooooooooo03kooooo00?o001oooooooooool0:Oooool00ol00?ooooooool0000;oooo
o`03o`000?oooooooooo00Wooooo00Coo`00oooooooooooo003o:oooool00ol007ooooooooooo`0m
ooooo`03o`000?oooooooooo00;ooooo0007ooooo`06onZmNOl007Wod^GZomNgP_l007Woh?oo6?oo
ool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02Wooooo00Co003oooooooooooooo`00
2_ooool00ol0003oooooooooo`09ooooo`04ool00?ooooooooooo`00ob_ooooo00?o001ooooooooo
ool0?Oooool00ol0003oooooooooo`02ooooo`001oooool01Ooooo;o`YQ`o`000?l0;Uco/MO^00Ko
oooo0_l00004ooooo`03o`000?oooooooooo00;ooooo0ol00005ooooo`03o`000?oooooooooo03ko
oooo00?o001oooooooooool0:Oooool01?l00?oooooooooooooo000:ooooo`03o`000?oooooooooo
00Wooooo00?oo`00ooooool00?l0;?ooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo
00;ooooo000Aooooo`04o`000?ooooooooooo`0000Oooooo00Go0000ooooooooooooooooo`000004
ooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool0:Oooool01?l00?oooooooooooooo
000:ooooo`03o`000?oooooooooo00Wooooo00?oo`00ooooool00?l0;?ooool00ol007oooooooooo
o`0mooooo`03o`000?oooooooooo00;ooooo0005ooooo`03on2aROnOd_;ooooo00;ooooo00?oooog
oiQ1Coo2l_l01?ooool01?l0003oooooooooool00007ooooo`05o`000?ooooooooooooooool00000
1?ooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02Wooooo00Co003ooooooooooooo
o`002_ooool00ol0003oooooooooo`09ooooo`03ool00?oooooo003o02cooooo00?o001ooooooooo
ool0?Oooool00ol0003oooooooooo`02ooooo`001Oooool00oo8PRkoG9S2omOGdP02om;BdP03omOG
`_m`;Toob?;o00Cooooo00Co0000oooooooooooo00001oooool4o`0000Gooooo0ol0001[o`00O`03
o`00ool007ooo`0000[o001o00?o0000o`00Ool007l02Ol007l00ooo003o001oo`00o`1[o`00O`;o
00001?ooool000Gooooo00?oj/RUog1`L?m`L7000_m`L7000om`L6Ko001?olSbo`04ooooo`04o`00
0?ooooooooooo`0000Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0nooooo`03
o`00Oooooooooooo02[ooooo00?o003ooooooooo00002_ooool00ol0003oooooooooo`09ooooo`03
ool00?oooooo003o02cooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`00
2_ooool00oooooOoTBi1ol;bo`04ooooo`04o`000?ooooooooooo`0000Sooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02[ooooo00?o003ooooooooo
00002_ooool00ol0003oooooooooo`09ooooo`03ool00?oooooo003o02cooooo00?o001ooooooooo
ool0?Oooool00ol0003oooooooooo`02ooooo`002_ooool00ooooo_ocK6gon3go`05ooooo`;o0000
2_ooool2o`0000Gooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0Zooooo`03o`00
ooooooooo`0000[ooooo00?o0000ooooooooool02Oooool00ooo003oooooo`00o`0/ooooo`03o`00
Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000_ooooo00?omo;boo_oooooool05ooo
ool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02[ooooo00?o003ooooooooo00002_oo
ool00ol0003oooooooooo`08ooooo`03ool00?oooooo003o02gooooo00?o001oooooooooool0?Ooo
ool00ol0003oooooooooo`02ooooo`001oooool01_oP_J_ob>[koooooooooo;oTBi1ol;boaSooooo
00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0[ooooo`03o`00ooooooooo`0000Wooooo
00?o0000ooooooooool02?ooool00ooo003oooooo`00o`0]ooooo`03o`00Oooooooooooo03gooooo
00?o0000ooooooooool00_ooool000Cooooo00Wooookomc8]oo8h>kocHT^odnH`_oPg=cog=c8og0^
Coo8l_l06?ooool2o`0003oooooo00?o001oooooooooool0:oooool00ol00?ooooooool00009oooo
o`03o`000?oooooooooo00Sooooo00?oo`00ooooool00?l0;Oooool00ol007ooooooooooo`0loooo
o`;o00001?ooool000Cooooo00CoooobojEL0?mLYMOoh<:H0_mLG5`00omVIUco001?olSbo`0Hoooo
o`03o`000?oooooooooo03kooooo00?o001oooooooooool0:oooool00ol00?ooooooool00009oooo
o`03o`000?oooooooooo00Sooooo00?oo`00ooooool00?l0;Oooool00ol007ooooooooooo`0moooo
o`03o`000?oooooooooo00;ooooo000:ooooo`03oooomonA;T7o`_;o01Sooooo00?o0000oooooooo
ool0?_ooool00ol007ooooooooooo`0[ooooo`03o`00ooooooooo`0000Wooooo00?o0000oooooooo
ool02?ooool00ooo003oooooo`00o`0]ooooo`03o`00Oooooooooooo03gooooo00?o0000oooooooo
ool00_ooool000[ooooo00?oooogol:OWooGmol06?ooool00ol0003oooooooooo`0nooooo`03o`00
Oooooooooooo02_ooooo00?o003ooooooooo00002Oooool00ol0003oooooooooo`08ooooo`03ool0
0?oooooo003o02gooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`001ooo
ool00oooj/go]lgZooooo`0Kooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool0:ooo
ool00ol00?ooooooool00009ooooo`03o`000?oooooooooo00Sooooo00?oo`00ooooool00?l0;Ooo
ool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0005ooooo`07oooomooPemOo
_ImVo`1LWooBem;ocLgBonGbn`0Iooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool0
;?ooool00ol00?ooo`00ooooo`08ooooo`03o`000?oooooooooo00Sooooo00?oo`00o`00ooooool0
;Oooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0005ooooo`08ooooj_nU
PW3oIU`^o`0^Com`NGWoL5a1o`00I_oGnolHooooo`03o`000?oooooooooo03kooooo00?o001ooooo
ooooool0;?ooool00ol00?ooo`00ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?oo`00oooo
ool00?l0;_ooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0007ooooo`06
oo_BTOm1RLgooooooooomonA;T7o`_;o6?ooool2o`0003oooooo00?o001oooooooooool0;?ooool0
0ol00?ooo`00ooooo`08ooooo`03o`000?oooooooooo00Oooooo00?oo`00ooooool00?l0;_ooool0
0ol007ooooooooooo`0looooo`;o00001?ooool000Oooooo00Kol/f9od69b?oooooooo_Goe`0Coo=
molHooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool0;?ooool00ol00?ooooooool0
0008ooooo`03o`000?oooooooooo00Oooooo00?oo`00ooooool00?l0;_ooool00ol007oooooooooo
o`0mooooo`03o`000?oooooooooo00;ooooo0008ooooo`05oo_ooooooooooo;Boi6H`_okool06?oo
ool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02cooooo00?o003ooooooooo00002?oo
ool00ol0003oooooooooo`07ooooo`03ool00?oooooo003o02kooooo00?o001oooooooooool0?Ooo
ool00ol0003oooooooooo`02ooooo`001oooool00ooP_JGo_N3gooooo`0Kooooo`03o`000?oooooo
oooo03kooooo00?o001oooooooooool0;?ooool00ol00?ooooooool00008ooooo`03o`000?oooooo
oooo00Oooooo00?oo`00ooooool00?l0;_ooool00ol007ooooooooooo`0mooooo`03o`000?oooooo
oooo00;ooooo0007ooooo`06olfA@Ol0003o0000o`000?m1NJ_ok_oo6?ooool00ol0003ooooooooo
o`0nooooo`03o`00Oooooooooooo02gooooo00?o003oool00?ooool01oooool00ol0003ooooooooo
o`07ooooo`03ool00?oooooo003o02kooooo00?o001oooooooooool0?Oooool00ol0003ooooooooo
o`02ooooo`002?ooool01Ooono_omo_koo_geomV02ko`_;o01Sooooo00?o0000ooooooooool0?_oo
ool00ol007ooooooooooo`0]ooooo`03o`00oooo003ooooo00Oooooo00?o0000ooooooooool01_oo
ool00ooo003oooooo`00o`0_ooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_oo
ool000Oooooo00KodYmioioGmooooooooooUogT0G?o=molHooooo`;o0000?oooool00ol007oooooo
ooooo`0]ooooo`03o`00oooo003ooooo00Oooooo00?o0000ooooooooool01_ooool00ooo003ooooo
o`00o`0_ooooo`03o`00Oooooooooooo03cooooo0_l00004ooooo`001oooool01_o=TBko0000od51
@Ol^003o001?om;goaSooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0]ooooo`03
o`00oooo003ooooo00Oooooo00?o0000ooooooooool01_ooool00ooo003oooooo`00o`0_ooooo`03
o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Oooooo00KonoObonk^k_o^j^ko
l_;Poim`NOo=l_lHooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool0;Oooool00ol0
0?ooooooool00007ooooo`03o`000?oooooooooo00Kooooo00?oo`00ooooool00?l0;oooool00ol0
07ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo0008ooooo`04ooOUcOnUV97oWj^mon[k
oaWooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0^ooooo`03o`00oooo003ooooo
00Kooooo00?o0000ooooooooool01_ooool00ooo003oooooo`00o`0_ooooo`03o`00Oooooooooooo
03gooooo00?o0000ooooooooool00_ooool000Oooooo00KommbUo`000?m`RI7oNDl0o`00P_oUool5
ooooo`;o00001?ooool00ol0003oooooooooo`02ooooo`?o00001Oooool00ol0003oooooooooo`0n
ooooo`03o`00Oooooooooooo02kooooo00?o003oool00?ooool01_ooool00ol0003oooooooooo`06
ooooo`03ool00?oooooo003o02oooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02
ooooo`001oooool01_o=RDooL;gZooooooooonkoRBi1ol;^o`Cooooo00Co0000oooooooooooo0000
1oooool01Ol0003ooooooooooooooooo000000Cooooo00?o0000ooooooooool0?_ooool00ol007oo
ooooooooo`0^ooooo`03o`00oooo003ooooo00Kooooo00?o0000ooooooooool01Oooool00ooo003o
ooooo`00o`0`ooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool000Gooooo
00Sok]Nmolg^oooUYFKoIZ_PooooooooonGoPRiLolgbo`Cooooo00Co0000oooooooooooo00001ooo
ool01Ol0003ooooooooooooooooo000000Cooooo0ol0001_o`00O`03o`00oooo003o001o00Ko001o
00?o0000o`00Ool007l01Ol007l00ooo003o001oo`00o`1_o`00O`;o00001?ooool000Gooooo00So
b880o`11L?n2IP3o0000odm`NOmL;P3o0011om;ko`Cooooo00Co0000oooooooooooo00002?ooool3
o`0000Gooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0^ooooo`03o`00oooooooo
o`0000Kooooo00?o0000ooooooooool01Oooool00ooo003oooooo`00o`0`ooooo`03o`00Oooooooo
oooo03gooooo00?o0000ooooooooool00_ooool000Gooooo00SonnkPolg8b?o=cLgod];Bolg=cOoB
d/SoPTmLolSbo`Cooooo00Co0000oooooooooooo00001oooool01Ol0003ooooooooooooooooo0000
00Cooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0^ooooo`03o`00ooooooooo`00
00Kooooo00?o0000ooooooooool01Oooool00ooo003oooooo`00o`0`ooooo`03o`00Oooooooooooo
03gooooo00?o0000ooooooooool00_ooool000Sooooo00ComnGBokNaZona_Lgol_oo1Oooool01?l0
003oooooooooool00007ooooo`05o`000?ooooooooooooooool000001?ooool00ol0003ooooooooo
o`0nooooo`03o`00Oooooooooooo02oooooo00?o003oool00?ooool01Oooool00ol0003ooooooooo
o`05ooooo`03ool00?l00?oooooo033ooooo00?o001oooooooooool0?Oooool00ol0003ooooooooo
o`02ooooo`001oooool01_obdYoo0000o`000?l0003o046Honkoo`Gooooo0_l00009ooooo`?o0000
1Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo02oooooo00?o003oool00?ooool0
1Oooool00ol0003oooooooooo`04ooooo`03ool00?oooooo003o037ooooo00?o001oooooooooool0
?Oooool00ol0003oooooooooo`02ooooo`001oooool01_o2PTooV<gLoim?G?oBno;oV45?ol;^oaSo
oooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0_ooooo`03o`00oooo003ooooo00Go
oooo00?o0000ooooooooool01?ooool00ooo003oooooo`00o`0aooooo`03o`00Oooooooooooo03go
oooo00?o0000ooooooooool00_ooool000Oooooo00Ko]g1Lokg^k_nUCecocO_kok5VI_o2k_lHoooo
o`03o`000?oooooooooo03kooooo00?o001oooooooooool0;oooool00ol00?ooooooool00005oooo
o`03o`000?oooooooooo00Cooooo00?oo`00ooooool00?l0<Oooool00ol007ooooooooooo`0moooo
o`03o`000?oooooooooo00;ooooo0007ooooo`06on2aL?l002ko001?olSUcOm?05coeo_o6?ooool2
o`0003oooooo00?o001oooooooooool0;oooool00ol00?ooooooool00005ooooo`03o`000?oooooo
oooo00Cooooo00?oo`00ooooool00?l0<Oooool00ol007ooooooooooo`0looooo`;o00001?ooool0
00Oooooo00Gooookom:aTOmVL9Sod]NmoiR[dP0Iooooo`03o`000?oooooooooo03kooooo00?o001o
ooooooooool0<?ooool00ol00?ooo`00ooooo`04ooooo`03o`000?oooooooooo00?ooooo00?oo`00
ooooool00?l0<_ooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo000Uoooo
o`03o`000?oooooooooo03kooooo00?o001oooooooooool0<?ooool00ol00?ooo`00ooooo`04oooo
o`03o`000?oooooooooo00?ooooo00?oo`00ooooool00?l0<_ooool00ol007ooooooooooo`0moooo
o`03o`000?oooooooooo00;ooooo000Uooooo`03o`000?oooooooooo03kooooo00?o001ooooooooo
ool0<?ooool00ol00?ooo`00ooooo`04ooooo`03o`000?oooooooooo00?ooooo00?oo`00ooooool0
0?l0<_ooool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo000Uooooo`03o`00
0?oooooooooo03kooooo00?o001oooooooooool0<?ooool00ol00?ooooooool00004ooooo`03o`00
0?oooooooooo00?ooooo00?oo`00o`00ooooool0<_ooool00ol007ooooooooooo`0mooooo`03o`00
0?oooooooooo00;ooooo000Uooooo`03o`000?oooooooooo03kooooo00?o001oooooooooool0<?oo
ool00ol00?ooooooool00004ooooo`03o`000?oooooooooo00?ooooo00?oo`00o`00ooooool0<_oo
ool00ol007ooooooooooo`0mooooo`03o`000?oooooooooo00;ooooo000Uooooo`;o0000?oooool0
0ol007ooooooooooo`0aooooo`03o`00oooo003ooooo00?ooooo00?o0000ooooooooool00_ooool0
0ooo003oooooo`00o`0cooooo`03o`00Oooooooooooo03cooooo0_l00004ooooo`009Oooool00ol0
003oooooooooo`0nooooo`03o`00Oooooooooooo037ooooo00?o003oool00?ooool00oooool00ol0
003oooooooooo`02ooooo`03ool00?l00?oooooo03?ooooo00?o001oooooooooool0?Oooool00ol0
003oooooooooo`02ooooo`009Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo037o
oooo00?o003oool00?ooool00oooool00ol0003oooooooooo`02ooooo`03ool00?l00?oooooo03?o
oooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`009Oooool00ol0003ooooo
ooooo`0nooooo`03o`00Oooooooooooo037ooooo00?o003ooooooooo00000oooool00ol0003ooooo
ooooo`02ooooo`03ool00?l00?oooooo03?ooooo00?o001oooooooooool0?Oooool00ol0003ooooo
ooooo`02ooooo`009Oooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo037ooooo00?o
003ooooooooo00000oooool01_l0003oooooooooooooooooo`00o`00ocGooooo00?o001ooooooooo
ool0?Oooool00ol0003oooooooooo`02ooooo`009Oooool00ol0003oooooooooo`0nooooo`03o`00
Oooooooooooo03;ooooo00?o003oool00?ooool00_ooool01_l0003oooooooooooooooooo`00o`00
ocGooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02ooooo`009Oooool00ol0003o
ooooooooo`0nooooo`03o`00Oooooooooooo03;ooooo00?o003oool00?ooool00_ooool01_l0003o
ooooooooooooooooo`00o`00ocGooooo00?o001oooooooooool0?Oooool00ol0003oooooooooo`02
ooooo`009Oooool2o`0003oooooo00?o001oooooooooool0<_ooool00ol00?ooooooool00002oooo
o`05o`000?oooooooooooooooooo0000=_ooool00ol007ooooooooooo`0looooo`;o00001?ooool0
02Gooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0cooooo`05o`00oooo003ooooo
ooooool000000_ooool00ooo003o003oooooo`0eooooo`03o`00Oooooooooooo03gooooo00?o0000
ooooooooool00_ooool002Gooooo00?o0000ooooooooool0?_ooool00ol007ooooooooooo`0doooo
o`04ool00?ooooooooooo`0000;ooooo00?oo`00o`00ooooool0=Oooool00ol007ooooooooooo`0m
ooooo`03o`000?oooooooooo00;ooooo000Mooooo`?o00001Oooool00ol0003oooooooooo`0noooo
o`03o`00Oooooooooooo03Cooooo00Co003oool00?oooooo00000_ooool00ooo003oooooooooo`0e
ooooo`03o`00Oooooooooooo03gooooo00?o0000ooooooooool00_ooool001kooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0nooooo`03o`00Oooooooooooo03Cooooo00Co003oool0
0?oooooo00000_ooool00ooo003oooooooooo`0eooooo`03o`00Oooooooooooo03gooooo00?o0000
ooooooooool00_ooool001kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0noooo
o`03o`00Oooooooooooo03Gooooo00?o003oool00?l000000_oo000hooooo`03o`00Oooooooooooo
03gooooo00?o0000ooooooooool00_ooool001kooooo00?o0000ooooooooool01?ooool3o`0003ko
oooo00?o001oooooooooool0=_ooool00ol00?ooo`00ool0000iooooo`03o`00Oooooooooooo03co
oooo0_l00004ooooo`007_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03kooooo
00?o001oooooooooool0=oooool00ol0003oooooooooo`0hooooo`03o`00Oooooooooooo03gooooo
00?o0000ooooooooool00_ooool001gooooo0_l00006ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0>?ooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo03Sooooo00?o
0000ooooooooool0=oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00;ooooo000N
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02
ooooo`009Oooooogo`0000Cooooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-27.4523, -0.348914, \
0.170795, 0.00782266}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 0 1.16608 [
[.09072 .22988 -17.7473 -9 ]
[.09072 .22988 .25272 0 ]
[.21906 .17566 -11.3073 -9 ]
[.21906 .17566 .69269 0 ]
[.3545 .11847 -5.39155 -9 ]
[.3545 .11847 .60845 0 ]
[.49765 .05807 -5.12945 -9 ]
[.49765 .05807 .87055 0 ]
[.64919 -0.00583 -9.73469 -9 ]
[.64919 -0.00583 2.26531 0 ]
[.0092 .82619 -10.3919 0 ]
[.0092 .82619 7.60811 9 ]
[.12063 .90431 -6.71135 0 ]
[.12063 .90431 5.28865 9 ]
[.22056 .97437 -3.26269 0 ]
[.22056 .97437 2.73731 9 ]
[.31067 1.03754 -3.18198 0 ]
[.31067 1.03754 2.81802 9 ]
[.39235 1.0948 -6.22251 0 ]
[.39235 1.0948 5.77749 9 ]
[.06468 .31592 -6 -2.66524 ]
[.06468 .31592 0 6.33476 ]
[.04753 .42326 -24 -2.76089 ]
[.04753 .42326 0 6.23911 ]
[.02903 .53909 -18 -2.86489 ]
[.02903 .53909 0 6.13511 ]
[.00901 .66445 -24 -2.97837 ]
[.00901 .66445 0 6.02163 ]
[-0.01273 .80056 -6 -3.1027 ]
[-0.01273 .80056 0 5.8973 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(-10)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(-5)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(5)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(10)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.01143 .81178 m
.01255 .80458 L
s
[(-10)] .0092 .82619 .15465 -1 Mshowa
.12235 .88984 m
.12321 .8826 L
s
[(-5)] .12063 .90431 .11856 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0)] .22056 .97437 .08756 -1 Mshowa
.31155 1.02299 m
.312 1.01572 L
s
[(5)] .31067 1.03754 .06066 -1 Mshowa
.39289 1.08023 m
.39316 1.07295 L
s
[(10)] .39235 1.0948 .03709 -1 Mshowa
.125 Mabswid
.03462 .8281 m
.03526 .82378 L
s
.05729 .84406 m
.0579 .83973 L
s
.07946 .85966 m
.08003 .85532 L
s
.10114 .87491 m
.10168 .87058 L
s
.1431 .90444 m
.14359 .9001 L
s
.16341 .91874 m
.16387 .91439 L
s
.18329 .93273 m
.18373 .92838 L
s
.20276 .94643 m
.20317 .94208 L
s
.24051 .97299 m
.24086 .96863 L
s
.25881 .98587 m
.25914 .98151 L
s
.27674 .99849 m
.27705 .99413 L
s
.29432 1.01086 m
.29461 1.0065 L
s
.32845 1.03488 m
.3287 1.03052 L
s
.34503 1.04655 m
.34525 1.04218 L
s
.36129 1.05799 m
.36149 1.05362 L
s
.37724 1.06921 m
.37742 1.06485 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.07818 .31042 m
.08493 .30766 L
s
[(0)] .06468 .31592 1 -0.40772 Mshowa
.06113 .41801 m
.06792 .41538 L
s
[(0.25)] .04753 .42326 1 -0.38647 Mshowa
.04273 .53411 m
.04958 .53162 L
s
[(0.5)] .02903 .53909 1 -0.36336 Mshowa
.02281 .65978 m
.02972 .65744 L
s
[(0.75)] .00901 .66445 1 -0.33814 Mshowa
.00119 .79624 m
.00815 .79408 L
s
[(1)] -0.01273 .80056 1 -0.31051 Mshowa
.125 Mabswid
.07487 .3313 m
.07892 .32966 L
s
.07151 .35249 m
.07557 .35087 L
s
.0681 .374 m
.07217 .3724 L
s
.06464 .39584 m
.06871 .39425 L
s
.05756 .44052 m
.06164 .43896 L
s
.05394 .46337 m
.05803 .46183 L
s
.05026 .48659 m
.05436 .48506 L
s
.04652 .51016 m
.05063 .50865 L
s
.03887 .55844 m
.04299 .55697 L
s
.03495 .58317 m
.03908 .58171 L
s
.03097 .60829 m
.0351 .60685 L
s
.02693 .63382 m
.03106 .6324 L
s
.01863 .68616 m
.02278 .68478 L
s
.01438 .71299 m
.01854 .71163 L
s
.01006 .74027 m
.01422 .73893 L
s
.00566 .76802 m
.00983 .7667 L
s
.08144 .28984 m
.08548 .28817 L
s
.08465 .26956 m
.08869 .26788 L
s
.08782 .24957 m
.09185 .24787 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.309 0 0 r
.49948 .57911 m .48499 .57729 L p .49929 .58093 L F P
0 g
s
.309 0 0 r
.50086 .5811 m .49948 .57911 L p .49929 .58093 L F P
0 g
s
.279 0 0 r
.47027 .57642 m .48499 .57729 L p .47481 .57868 L F P
0 g
s
.279 0 0 r
.47356 .57885 m .47315 .57855 L p .47481 .57868 L F P
0 g
s
.279 0 0 r
.47315 .57855 m .47027 .57642 L p .47481 .57868 L F P
0 g
s
.328 0 0 r
.44153 .57186 m .4278 .56821 L p .44447 .57387 L F P
0 g
s
.328 0 0 r
.4459 .57423 m .44153 .57186 L p .44447 .57387 L F P
0 g
s
.326 0 0 r
.4135 .56545 m .4278 .56821 L p .42101 .56851 L F P
0 g
s
.326 0 0 r
.42017 .56855 m .41934 .56816 L p .42101 .56851 L F P
0 g
s
.326 0 0 r
.41934 .56816 m .4135 .56545 L p .42101 .56851 L F P
0 g
s
.326 0 0 r
.43175 .5702 m .42017 .56855 L .4278 .56821 L F
.328 0 0 r
.4278 .56821 m .41447 .56467 L p .43132 .56998 L F P
0 g
s
.314 0 0 r
.3606 .54722 m .37397 .55183 L p .37088 .55148 L F P
0 g
s
.314 0 0 r
.3705 .55144 m .36927 .55092 L p .37088 .55148 L F P
0 g
s
.314 0 0 r
.36927 .55092 m .3606 .54722 L p .37088 .55148 L F P
0 g
s
.282 0 0 r
.34775 .54049 m .33623 .53551 L p .34773 .54048 L F P
0 g
s
.314 0 0 r
.38013 .5545 m .3705 .55144 L .37397 .55183 L F
.282 0 0 r
.38644 .55722 m .37397 .55183 L p .39248 .55984 L F P
0 g
s
.282 0 0 r
.39475 .56082 m .37397 .55183 L .38088 .55482 L F
.328 0 0 r
.40034 .56091 m .38644 .55722 L p .40189 .56161 L F P
0 g
s
.314 0 0 r
.40034 .56091 m .4135 .56545 L p .4023 .5618 L F P
0 g
s
.328 0 0 r
.44652 .57457 m .4278 .56821 L .43223 .57044 L F
.309 0 0 r
.4561 .57368 m .44153 .57186 L p .45719 .57436 L F P
0 g
s
.279 0 0 r
.48684 .57911 m .47356 .57885 L .48499 .57729 L F
.309 0 0 r
.50105 .58138 m .48684 .57911 L .48735 .5796 L F
.279 0 0 r
.48742 .57968 m .47356 .57885 L p .48684 .57911 L F P
0 g
s
.326 0 0 r
.47027 .57642 m .47315 .57855 L p .46024 .57628 L F P
0 g
s
.326 0 0 r
.47315 .57855 m .47356 .57885 L .46024 .57628 L p F P
0 g
s
.326 0 0 r
.47027 .57642 m .46024 .57628 L .45719 .57436 L F
.309 0 0 r
.46024 .57628 m .50105 .58138 L p .45985 .57604 L F P
0 g
s
.309 0 0 r
.45985 .57604 m .4459 .57423 L .46024 .57628 L F
.44153 .57186 m .4459 .57423 L p .48735 .5796 L F P
0 g
s
.309 0 0 r
.48684 .57911 m .44153 .57186 L .48735 .5796 L F
.328 0 0 r
.43362 .57114 m .44652 .57457 L p .43223 .57044 L F P
0 g
s
.326 0 0 r
.46024 .57628 m .43362 .57114 L p .45719 .57436 L F P
0 g
s
.326 0 0 r
.43362 .57114 m .42017 .56855 L p .43223 .57044 L F P
0 g
s
.326 0 0 r
.45719 .57436 m .43362 .57114 L .43223 .57044 L F
.45719 .57436 m .43223 .57044 L .4561 .57368 L F
.43223 .57044 m .42017 .56855 L .43175 .5702 L F
.43223 .57044 m .43175 .5702 L .4561 .57368 L F
.328 0 0 r
.38644 .55722 m .39372 .56037 L p .4072 .56401 L F P
0 g
s
.314 0 0 r
.4135 .56545 m .41934 .56816 L p .40781 .56429 L F P
0 g
s
.314 0 0 r
.41934 .56816 m .42017 .56855 L .40781 .56429 L p F P
0 g
s
.314 0 0 r
.4135 .56545 m .40781 .56429 L .4023 .5618 L F
.328 0 0 r
.43362 .57114 m .40295 .56209 L .4072 .56401 L F
.40295 .56209 m .38644 .55722 L .4072 .56401 L F
.40781 .56429 m .43362 .57114 L p .39372 .56037 L F P
0 g
s
.328 0 0 r
.43223 .57044 m .38644 .55722 L .43362 .57114 L F
.43223 .57044 m .43132 .56998 L .40189 .56161 L F
.4023 .5618 m .40189 .56161 L .38644 .55722 L F
.43223 .57044 m .40189 .56161 L .4023 .5618 L F
.314 0 0 r
.38305 .55576 m .3705 .55144 L p .38088 .55482 L F P
0 g
s
.314 0 0 r
.4023 .5618 m .38088 .55482 L .40034 .56091 L F
.38088 .55482 m .3705 .55144 L .38013 .5545 L F
.38088 .55482 m .38013 .5545 L .40034 .56091 L F
0 .323 .713 r
.34894 .54101 m .3606 .54722 L p .35173 .54222 L F P
0 g
s
0 .349 .772 r
.3255 .52851 m .30391 .51442 L p .33472 .53261 L F P
0 g
s
.002 .401 .851 r
.28441 .49884 m .26726 .48187 L p .2957 .50439 L F P
0 g
s
.163 .439 .872 r
.2527 .46365 m .24097 .44433 L p .26571 .47098 L F P
0 g
s
.294 .465 .859 r
.23227 .42408 m .22683 .40311 L p .24655 .43349 L F P
0 g
s
.393 .484 .834 r
.2248 .38163 m .22635 .35988 L p .23977 .39335 L F P
0 g
s
.469 .502 .81 r
.23156 .33813 m .24051 .31666 L p .24652 .35232 L F P
0 g
s
.528 .519 .789 r
.2532 .29576 m .26958 .27575 L p .26735 .31245 L F P
0 g
s
.577 .537 .774 r
.28954 .25693 m .31287 .2396 L p .30203 .27597 L F P
0 g
s
.577 .537 .774 r
.30203 .27597 m .31287 .2396 L .31681 .24658 L F
.532 .533 .801 r
.39552 .28638 m .39515 .28594 L .39159 .29121 L p F P
0 g
s
.778 .949 .931 r
.38723 .29612 m .38724 .29218 L .39126 .29128 L F
.804 .936 .917 r
.39159 .29121 m .39515 .28594 L p .38724 .29218 L F P
0 g
s
.778 .949 .931 r
.39159 .29121 m .38723 .29612 L p .39414 .28782 L F P
0 g
s
.574 .545 .784 r
.40032 .28136 m .39515 .28594 L p .39585 .28603 L F P
0 g
s
.574 .545 .784 r
.39515 .28594 m .39552 .28638 L p .39585 .28603 L F P
0 g
s
.778 .949 .931 r
.40356 .27652 m .40475 .27637 L .40032 .28136 L p F P
0 g
s
.744 .956 .942 r
.39515 .28594 m .40032 .28136 L p .37855 .28878 L F P
0 g
s
.744 .956 .942 r
.37642 .28951 m .37824 .28916 L p .37855 .28878 L F P
0 g
s
.744 .956 .942 r
.37824 .28916 m .39515 .28594 L p .37855 .28878 L F P
0 g
s
.744 .956 .942 r
.37642 .28951 m .40032 .28136 L .38727 .28348 L F
.822 .919 .902 r
.36748 .30112 m .3694 .30063 L p .36901 .30116 L F P
0 g
s
.822 .919 .902 r
.37004 .30576 m .36748 .30112 L .38456 .3016 L F
.787 .986 .731 r
.36778 .2994 m .37217 .29572 L .37642 .28951 L F
.804 .936 .917 r
.3641 .30842 m .37004 .30576 L .36499 .30721 L F
.36056 .31325 m .36304 .31129 L .3641 .30842 L F
.36304 .31129 m .37004 .30576 L .3641 .30842 L F
.866 .995 .765 r
.3665 .30195 m .36748 .30112 L .3645 .30735 L p F P
0 g
s
.787 .986 .731 r
.35954 .31415 m .3645 .30735 L .36384 .30792 L F
.35954 .31415 m .36384 .30792 L .36375 .308 L F
.35954 .31415 m .36056 .31325 L .3645 .30735 L p F P
0 g
s
.804 .936 .917 r
.3645 .30735 m .36056 .31325 L p .36499 .30721 L F P
0 g
s
.822 .919 .902 r
.38723 .29612 m .38456 .3016 L p .36901 .30116 L F P
0 g
s
.822 .919 .902 r
.3694 .30063 m .38723 .29612 L p .36901 .30116 L F P
0 g
s
.804 .936 .917 r
.36056 .31325 m .38105 .30678 L .38456 .3016 L p F P
0 g
s
.804 .936 .917 r
.38456 .3016 m .39159 .29121 L p .38762 .29653 L F P
0 g
s
.744 .956 .942 r
.40032 .28136 m .41068 .2722 L p .4051 .27684 L F P
0 g
s
.554 .539 .792 r
.40407 .305 m .39187 .29152 L .40041 .28148 L F
.481 .523 .823 r
.37929 .31239 m .37583 .32345 L p .39428 .3254 L F P
0 g
s
.481 .523 .823 r
.37583 .32345 m .37411 .32896 L p .37462 .32887 L F P
0 g
s
.42 .515 .85 r
.37453 .32927 m .37411 .32896 L .37419 .33463 L p F P
0 g
s
.839 .878 .871 r
.37337 .34021 m .37228 .33932 L .37323 .33509 L F
.37337 .34021 m .37323 .33509 L .37395 .33475 L F
.84 .856 .856 r
.37419 .33463 m .37411 .32896 L p .36939 .33695 L F P
0 g
s
.839 .878 .871 r
.37419 .33463 m .37337 .34021 L p .37453 .32927 L F P
0 g
s
.84 .856 .856 r
.37411 .32896 m .35497 .33751 L p .35308 .34486 L F P
0 g
s
.84 .856 .856 r
.35497 .33751 m .35291 .33843 L .35308 .34486 L p F P
0 g
s
.93 .949 .78 r
.35308 .34486 m .35221 .35117 L p .3515 .35099 L F P
0 g
s
.93 .949 .78 r
.3515 .35099 m .348 .35008 L .35308 .34486 L F
.839 .834 .842 r
.37337 .34021 m .37434 .34581 L p .35404 .35199 L F P
0 g
s
.839 .834 .842 r
.35917 .35428 m .35404 .35199 L .37434 .34581 L F
.35221 .35117 m .35426 .35011 L p .35404 .35199 L F P
0 g
s
.839 .834 .842 r
.35426 .35011 m .37337 .34021 L p .35404 .35199 L F P
0 g
s
.84 .856 .856 r
.35339 .3575 m .35355 .3638 L p .35502 .36131 L F P
0 g
s
.84 .856 .856 r
.35502 .36131 m .35917 .35428 L .35339 .3575 L F
.928 .877 .765 r
.30743 .39882 m .33002 .37473 L .33144 .38178 L p F P
0 g
s
.933 .913 .775 r
.3317 .38878 m .35252 .36498 L p .35269 .35888 L F P
0 g
s
.933 .913 .775 r
.3317 .38878 m .35269 .35888 L .35111 .36058 L F
.3317 .38878 m .3527 .35826 L .33938 .373 L F
.928 .877 .766 r
.33002 .37473 m .35116 .35228 L p .35248 .35781 L F P
0 g
s
.928 .877 .766 r
.35262 .35836 m .35092 .35959 L .35248 .35781 L F
.35092 .35959 m .33002 .37473 L .35248 .35781 L F
.934 .914 .774 r
.30948 .41428 m .3317 .38878 L .33144 .38178 L p F P
0 g
s
.934 .914 .774 r
.31484 .40067 m .33144 .38178 L .31517 .39984 L F
.30948 .41428 m .33144 .38178 L .31484 .40067 L F
.928 .877 .766 r
.33745 .37513 m .33002 .37473 L .35262 .35836 L F
.933 .913 .775 r
.3317 .38878 m .33915 .37347 L .33732 .37544 L F
.928 .877 .766 r
.35687 .37618 m .3356 .40253 L .33422 .39564 L p F P
0 g
s
.928 .877 .766 r
.35687 .37618 m .33422 .39564 L .34908 .3779 L F
.933 .913 .775 r
.33732 .37544 m .33752 .37506 L .33745 .37513 L F
.93 .949 .78 r
.35221 .35117 m .33002 .37473 L .33091 .36769 L p F P
0 g
s
.933 .913 .775 r
.35291 .33843 m .33065 .36053 L .33091 .36769 L p F P
0 g
s
.93 .949 .78 r
.34832 .35016 m .33091 .36769 L .348 .35008 L F
.35221 .35117 m .33091 .36769 L .34832 .35016 L F
.928 .877 .766 r
.33144 .38178 m .33002 .37473 L p .33745 .37513 L F P
0 g
s
.933 .913 .775 r
.33091 .36769 m .3317 .38878 L p .348 .35008 L F P
0 g
s
.933 .913 .775 r
.348 .35008 m .35291 .33843 L .33091 .36769 L F
.93 .949 .779 r
.31107 .36754 m .33362 .34636 L .33271 .35355 L p F P
0 g
s
.91 .979 .779 r
.33065 .36053 m .35291 .33843 L .35463 .33277 L p F P
0 g
s
.91 .979 .779 r
.33065 .36053 m .35463 .33277 L .35293 .33439 L F
.33065 .36053 m .35481 .33218 L .33877 .34769 L F
.934 .914 .774 r
.33091 .36769 m .33065 .36053 L p .3258 .37285 L F P
0 g
s
.934 .914 .774 r
.3257 .37309 m .33091 .36769 L .3258 .37285 L F
.93 .949 .779 r
.33091 .36769 m .33002 .37473 L p .3257 .37309 L F P
0 g
s
.928 .877 .765 r
.31517 .39984 m .31472 .39978 L .33144 .38178 L F
.31472 .39978 m .30743 .39882 L .33144 .38178 L F
.93 .949 .779 r
.33002 .37473 m .30743 .39882 L .30833 .39108 L p F P
0 g
s
.934 .914 .774 r
.33065 .36053 m .30794 .38318 L .30833 .39108 L p F P
0 g
s
.934 .914 .774 r
.3257 .37309 m .33065 .36053 L .30833 .39108 L F
.91 .979 .778 r
.30794 .38318 m .33065 .36053 L .33271 .35355 L p F P
0 g
s
.91 .979 .778 r
.30794 .38318 m .33271 .35355 L .31628 .36952 L F
.93 .949 .78 r
.33271 .35355 m .33362 .34636 L p .33877 .34769 L F P
0 g
s
.93 .949 .78 r
.33877 .34769 m .33362 .34636 L .34071 .34581 L F
.91 .979 .779 r
.35463 .33277 m .35481 .33218 L p .35293 .33439 L F P
0 g
s
.933 .913 .775 r
.35308 .34486 m .35291 .33843 L p .348 .35008 L F P
0 g
s
.833 .899 .886 r
.35291 .33843 m .35497 .33751 L p .35493 .33617 L F P
0 g
s
.839 .878 .871 r
.36209 .32915 m .35569 .32574 L .37583 .32345 L F
.833 .899 .886 r
.37411 .32896 m .37583 .32345 L p .35493 .33617 L F P
0 g
s
.833 .899 .886 r
.35493 .33617 m .37583 .32345 L .36062 .32977 L F
.35497 .33751 m .37411 .32896 L p .35493 .33617 L F P
0 g
s
.84 .856 .856 r
.36939 .33695 m .37411 .32896 L .35308 .34486 L F
.839 .878 .871 r
.36939 .33695 m .36062 .32977 L .37323 .33509 L F
.36062 .32977 m .35569 .32574 L .36209 .32915 L F
.36062 .32977 m .36209 .32915 L .37323 .33509 L F
.35569 .32574 m .37667 .31777 L .37583 .32345 L p F P
0 g
s
.833 .899 .886 r
.37583 .32345 m .37929 .31239 L p .37709 .31811 L F P
0 g
s
.452 .519 .836 r
.37583 .32345 m .37667 .31777 L p .377 .31848 L F P
0 g
s
.481 .523 .823 r
.38131 .32769 m .39428 .3254 L .37583 .32345 L F
.452 .519 .836 r
.394 .34836 m .38297 .32898 L .39339 .33705 L F
.39553 .33871 m .394 .34836 L p .39369 .34276 L F P
0 g
s
.384 .513 .864 r
.39561 .36757 m .3935 .3664 L .39377 .36218 L F
.39403 .35801 m .39561 .36757 L p .39377 .36218 L F P
0 g
s
.804 .737 .79 r
.37961 .40881 m .37792 .41051 L .38351 .41542 L p F P
0 g
s
.87 .751 .729 r
.38351 .41542 m .38826 .42063 L p .38677 .42093 L F P
0 g
s
.87 .751 .729 r
.38677 .42093 m .37949 .42243 L .38351 .41542 L F
.794 .72 .782 r
.40449 .40185 m .41 .40583 L p .39019 .41931 L F P
0 g
s
.794 .72 .782 r
.38826 .42063 m .38982 .41882 L p .39019 .41931 L F P
0 g
s
.794 .72 .782 r
.38982 .41882 m .40449 .40185 L p .39019 .41931 L F P
0 g
s
.149 .506 .911 r
.41 .40583 m .41482 .41014 L p .41477 .40992 L F P
0 g
s
.784 .705 .776 r
.40146 .42801 m .40004 .42992 L .40694 .4339 L p F P
0 g
s
.804 .737 .79 r
.39454 .42509 m .40004 .42992 L p .39971 .42728 L F P
0 g
s
.804 .737 .79 r
.39971 .42728 m .39879 .4198 L .39454 .42509 L F
.837 .702 .715 r
.35437 .48316 m .37138 .45171 L .37848 .45663 L p F P
0 g
s
.853 .726 .722 r
.3847 .46195 m .39931 .43144 L p .39452 .42657 L F P
0 g
s
.853 .726 .722 r
.3847 .46195 m .39452 .42657 L .39332 .42881 L F
.3847 .46195 m .39403 .42608 L .38427 .44525 L F
.836 .702 .716 r
.37138 .45171 m .38746 .4221 L p .39343 .42572 L F P
0 g
s
.836 .702 .716 r
.39403 .42608 m .39232 .42802 L .39343 .42572 L F
.39232 .42802 m .37138 .45171 L .39343 .42572 L F
.853 .725 .721 r
.36924 .49432 m .3847 .46195 L .37848 .45663 L p F P
0 g
s
.853 .725 .721 r
.36682 .48072 m .37848 .45663 L .36667 .47989 L F
.36924 .49432 m .37848 .45663 L .36682 .48072 L F
.836 .702 .716 r
.38427 .44525 m .37138 .45171 L .39403 .42608 L F
.853 .726 .722 r
.3847 .46195 m .38428 .44575 L .3829 .44834 L F
.836 .702 .716 r
.38286 .44802 m .37138 .45171 L .38427 .44525 L F
.853 .726 .722 r
.38428 .44575 m .38427 .44525 L .3829 .44834 L F
.87 .751 .729 r
.38826 .42063 m .37138 .45171 L .366 .44595 L p F P
0 g
s
.853 .726 .722 r
.37792 .41051 m .35967 .44054 L .366 .44595 L p F P
0 g
s
.87 .751 .729 r
.38015 .42229 m .366 .44595 L .37949 .42243 L F
.38826 .42063 m .366 .44595 L .38015 .42229 L F
.836 .702 .716 r
.37848 .45663 m .37138 .45171 L p .38286 .44802 L F P
0 g
s
.853 .726 .722 r
.366 .44595 m .3847 .46195 L p .37949 .42243 L F P
0 g
s
.853 .726 .722 r
.37949 .42243 m .37792 .41051 L .366 .44595 L F
.87 .751 .728 r
.33003 .45786 m .34971 .42854 L .35519 .43441 L p F P
0 g
s
.886 .779 .737 r
.35967 .44054 m .37792 .41051 L .37437 .40549 L p F P
0 g
s
.886 .779 .737 r
.35967 .44054 m .37437 .40549 L .37287 .40775 L F
.35967 .44054 m .37399 .40496 L .36033 .42636 L F
.853 .725 .721 r
.366 .44595 m .35967 .44054 L p .36186 .45287 L F P
0 g
s
.853 .725 .721 r
.36191 .45312 m .366 .44595 L .36186 .45287 L F
.87 .751 .728 r
.366 .44595 m .37138 .45171 L p .36191 .45312 L F P
0 g
s
.837 .702 .715 r
.36667 .47989 m .36596 .48007 L .37848 .45663 L F
.36596 .48007 m .35437 .48316 L .37848 .45663 L F
.87 .751 .728 r
.37138 .45171 m .35437 .48316 L .34833 .47688 L p F P
0 g
s
.853 .725 .721 r
.35967 .44054 m .34124 .47097 L .34833 .47688 L p F P
0 g
s
.853 .725 .721 r
.36191 .45312 m .35967 .44054 L .34833 .47688 L F
.887 .778 .737 r
.34124 .47097 m .35967 .44054 L .35519 .43441 L p F P
0 g
s
.887 .778 .737 r
.34124 .47097 m .35519 .43441 L .34135 .45618 L F
.87 .751 .729 r
.35519 .43441 m .34971 .42854 L p .36033 .42636 L F P
0 g
s
.87 .751 .729 r
.36033 .42636 m .34971 .42854 L .36198 .42378 L F
.886 .779 .737 r
.37437 .40549 m .37399 .40496 L p .37287 .40775 L F P
0 g
s
.853 .726 .722 r
.38351 .41542 m .37792 .41051 L p .37949 .42243 L F P
0 g
s
.822 .773 .807 r
.37792 .41051 m .37961 .40881 L p .37819 .40784 L F P
0 g
s
.813 .755 .798 r
.36916 .39966 m .38655 .38431 L p .39111 .38878 L F P
0 g
s
.813 .755 .798 r
.38042 .39888 m .36916 .39966 L .39111 .38878 L F
.822 .773 .807 r
.39545 .39284 m .39204 .3879 L p .37819 .40784 L F P
0 g
s
.822 .773 .807 r
.37819 .40784 m .39204 .3879 L .37896 .40027 L F
.37961 .40881 m .39545 .39284 L p .37819 .40784 L F P
0 g
s
.804 .737 .79 r
.39545 .39284 m .37961 .40881 L p .38351 .41542 L F P
0 g
s
.804 .737 .79 r
.39651 .40136 m .39545 .39284 L .38351 .41542 L F
.794 .72 .782 r
.39879 .4198 m .38826 .42063 L .41 .40583 L F
.813 .755 .798 r
.40449 .40185 m .39651 .40136 L .40005 .39752 L F
.40034 .39721 m .40449 .40185 L p .40005 .39752 L F P
0 g
s
.804 .737 .79 r
.40004 .42992 m .41482 .41014 L .41 .40583 L p F P
0 g
s
.804 .737 .79 r
.40004 .42992 m .41 .40583 L .40015 .4181 L F
.822 .773 .807 r
.37399 .40496 m .37792 .41051 L p .37896 .40027 L F P
0 g
s
.813 .755 .798 r
.40449 .40185 m .38826 .42063 L .36916 .39966 L p F P
0 g
s
.804 .737 .79 r
.40004 .42992 m .40034 .39721 L .39651 .40136 L F
.784 .705 .776 r
.41482 .41014 m .40146 .42801 L p .40694 .4339 L F P
0 g
s
.784 .705 .776 r
.4177 .4183 m .41482 .41014 L .40694 .4339 L F
.794 .72 .782 r
.42632 .41762 m .4144 .43631 L p .40694 .4339 L F P
0 g
s
.794 .72 .782 r
.4144 .43631 m .41313 .43829 L .40694 .4339 L p F P
0 g
s
.836 .702 .716 r
.41313 .43829 m .39944 .47117 L .39247 .46633 L p F P
0 g
s
.836 .702 .716 r
.41313 .43829 m .39247 .46633 L .40246 .44394 L F
.82 .681 .71 r
.40004 .42992 m .3847 .46195 L .39247 .46633 L p F P
0 g
s
.836 .702 .716 r
.41313 .43829 m .40246 .44394 L .40361 .44135 L F
.82 .681 .71 r
.40349 .51319 m .41546 .4793 L .4078 .47498 L p F P
0 g
s
.804 .661 .706 r
.39944 .47117 m .41313 .43829 L .41985 .44143 L p F P
0 g
s
.804 .661 .706 r
.41891 .44406 m .39944 .47117 L .41985 .44143 L F
.41128 .46592 m .39944 .47117 L .42056 .44176 L F
.82 .681 .71 r
.39247 .46633 m .3847 .46195 L p .38909 .47392 L F P
0 g
s
.804 .661 .706 r
.38568 .50436 m .39944 .47117 L .4078 .47498 L p F P
0 g
s
.804 .661 .706 r
.39844 .49943 m .38568 .50436 L .4078 .47498 L F
.82 .681 .71 r
.39497 .5085 m .40349 .51319 L p .39844 .49943 L F P
0 g
s
.82 .681 .71 r
.40349 .51319 m .4078 .47498 L .39873 .50023 L F
.804 .661 .706 r
.43256 .48627 m .42248 .52076 L .41332 .51668 L p F P
0 g
s
.804 .661 .706 r
.43256 .48627 m .41332 .51668 L .42088 .49318 L F
.82 .681 .71 r
.39873 .50023 m .4078 .47498 L .39854 .49918 L F
.837 .702 .715 r
.39247 .46633 m .39944 .47117 L p .38909 .47392 L F P
0 g
s
.837 .702 .715 r
.39944 .47117 m .38568 .50436 L .3779 .49909 L p F P
0 g
s
.82 .681 .71 r
.3847 .46195 m .36924 .49432 L .3779 .49909 L p F P
0 g
s
.82 .681 .71 r
.38792 .47655 m .3847 .46195 L .3779 .49909 L F
.837 .702 .715 r
.39944 .47117 m .3779 .49909 L .38909 .47392 L F
.804 .661 .706 r
.39497 .5085 m .38568 .50436 L p .39844 .49943 L F P
0 g
s
.82 .681 .71 r
.39844 .49943 m .3847 .46195 L .39497 .5085 L F
.837 .702 .715 r
.36229 .48852 m .35437 .48316 L p .36667 .47989 L F P
0 g
s
.87 .751 .728 r
.37138 .45171 m .34833 .47688 L .36191 .45312 L F
.853 .725 .721 r
.34833 .47688 m .36229 .48852 L p .36191 .45312 L F P
0 g
s
.853 .725 .721 r
.36229 .48852 m .36924 .49432 L p .36667 .47989 L F P
0 g
s
.853 .725 .721 r
.36667 .47989 m .36191 .45312 L .36229 .48852 L F
.837 .702 .715 r
.3779 .49909 m .36229 .48852 L p .38909 .47392 L F P
0 g
s
.837 .702 .715 r
.38909 .47392 m .36229 .48852 L .36667 .47989 L F
.82 .681 .71 r
.3779 .49909 m .39497 .5085 L p .38792 .47655 L F P
0 g
s
.82 .681 .71 r
.39873 .50023 m .39247 .46633 L .38909 .47392 L F
.787 .643 .702 r
.41546 .4793 m .40349 .51319 L .41332 .51668 L p F P
0 g
s
.787 .643 .702 r
.42176 .49044 m .41546 .4793 L .41332 .51668 L F
.804 .661 .706 r
.42176 .49044 m .39497 .5085 L .39844 .49943 L F
.43256 .48627 m .42088 .49318 L .42176 .49044 L F
.42088 .49318 m .39497 .5085 L .42176 .49044 L F
.771 .626 .699 r
.42248 .52076 m .43256 .48627 L .44182 .48885 L p F P
0 g
s
.771 .626 .699 r
.4352 .51418 m .42248 .52076 L .44182 .48885 L F
.787 .643 .702 r
.42431 .48251 m .41546 .4793 L p .42176 .49044 L F P
0 g
s
.82 .681 .71 r
.4078 .47498 m .41546 .4793 L p .41128 .46592 L F P
0 g
s
.82 .681 .71 r
.40361 .44135 m .40004 .42992 L .39247 .46633 L F
.40361 .44135 m .40694 .4339 L .40065 .43187 L F
.853 .726 .722 r
.38427 .44525 m .38291 .44792 L .3829 .44834 L F
.836 .702 .716 r
.41151 .43881 m .38286 .44802 L .40694 .4339 L F
.82 .681 .71 r
.41128 .46592 m .40694 .4339 L .40361 .44135 L F
.41546 .4793 m .4124 .46301 L .41128 .46592 L F
.4124 .46301 m .40694 .4339 L .41128 .46592 L F
.804 .661 .706 r
.41985 .44143 m .42056 .44176 L p .41891 .44406 L F P
0 g
s
.836 .702 .716 r
.40694 .4339 m .41313 .43829 L p .41151 .43881 L F P
0 g
s
.773 .69 .771 r
.42056 .44176 m .41313 .43829 L p .41596 .43769 L F P
0 g
s
.773 .69 .771 r
.41313 .43829 m .42632 .41762 L .43287 .42071 L p F P
0 g
s
.784 .705 .776 r
.42737 .44568 m .43886 .42423 L .43287 .42071 L p F P
0 g
s
.784 .705 .776 r
.42737 .44568 m .43287 .42071 L .42502 .43412 L F
.773 .69 .771 r
.42394 .43598 m .41313 .43829 L .43287 .42071 L F
.794 .72 .782 r
.42632 .41762 m .40694 .4339 L .41659 .41991 L F
.42632 .41762 m .39454 .42509 L .39879 .4198 L F
.42397 .41781 m .4177 .4183 L .42025 .41461 L F
.784 .705 .776 r
.42088 .41369 m .41482 .41014 L p .4177 .4183 L F P
0 g
s
.047 .503 .888 r
.41512 .41022 m .41482 .41014 L .42088 .41369 L p F P
0 g
s
.794 .72 .782 r
.42632 .41762 m .42397 .41781 L .41512 .41022 L F
.41 .40583 m .42088 .41369 L p .41512 .41022 L F P
0 g
s
.794 .72 .782 r
.42088 .41369 m .42632 .41762 L p .41512 .41022 L F P
0 g
s
.773 .69 .771 r
.45229 .4299 m .44987 .43042 L .44533 .42783 L F
.44581 .42684 m .45229 .4299 L p .44533 .42783 L F P
0 g
s
.763 .676 .767 r
.44581 .42684 m .43886 .42423 L p .4434 .4318 L F P
0 g
s
.047 .503 .888 r
.43886 .42423 m .43866 .42402 L .43412 .42143 L F
0 .505 .837 r
.43909 .42427 m .43886 .42423 L .44581 .42684 L p F P
0 g
s
.773 .69 .771 r
.44581 .42684 m .44533 .42783 L .43909 .42427 L F
.43287 .42071 m .44581 .42684 L p .43909 .42427 L F P
0 g
s
.804 .661 .706 r
.4426 .45203 m .43256 .48627 L .42431 .48251 L p F P
0 g
s
.82 .681 .71 r
.41546 .4793 m .4268 .44728 L p .40694 .4339 L F P
0 g
s
.804 .661 .706 r
.4426 .45203 m .42431 .48251 L .43186 .45911 L F
.787 .643 .702 r
.42737 .44568 m .41546 .4793 L .42431 .48251 L p F P
0 g
s
.804 .661 .706 r
.4426 .45203 m .43186 .45911 L .43273 .4564 L F
.787 .643 .702 r
.44247 .52701 m .45058 .49202 L .44182 .48885 L p F P
0 g
s
.771 .626 .7 r
.43256 .48627 m .4426 .45203 L .45007 .45415 L p F P
0 g
s
.771 .626 .7 r
.44942 .45687 m .43256 .48627 L .45007 .45415 L F
.44428 .47945 m .43256 .48627 L .45085 .45438 L F
.804 .661 .706 r
.4078 .47498 m .42431 .48251 L p .39844 .49943 L F P
0 g
s
.804 .661 .706 r
.42431 .48251 m .43256 .48627 L p .42176 .49044 L F P
0 g
s
.804 .661 .706 r
.42176 .49044 m .39844 .49943 L .42431 .48251 L F
.787 .643 .702 r
.44182 .48885 m .45058 .49202 L p .44428 .47945 L F P
0 g
s
.787 .643 .702 r
.45058 .49202 m .45828 .45892 L p .45053 .4556 L F P
0 g
s
.787 .643 .702 r
.45058 .49202 m .45053 .4556 L .44503 .47659 L F
.43273 .4564 m .42737 .44568 L .42431 .48251 L F
.43273 .4564 m .43512 .449 L .42737 .44568 L F
.43525 .4486 m .42737 .44568 L p .43512 .449 L F P
0 g
s
.784 .705 .776 r
.42737 .44568 m .42502 .43412 L .42394 .43598 L F
.82 .681 .71 r
.4268 .44728 m .42737 .44568 L .42056 .44176 L p F P
0 g
s
.82 .681 .71 r
.42056 .44176 m .40694 .4339 L p .4268 .44728 L F P
0 g
s
.773 .69 .771 r
.42394 .43598 m .42056 .44176 L .41596 .43769 L F
.784 .705 .776 r
.40694 .4339 m .42737 .44568 L p .4177 .4183 L F P
0 g
s
.751 .663 .764 r
.45229 .4299 m .45958 .432 L p .4441 .45025 L F P
0 g
s
.751 .663 .764 r
.4426 .45203 m .44353 .4499 L p .4441 .45025 L F P
0 g
s
.751 .663 .764 r
.44353 .4499 m .45229 .4299 L p .4441 .45025 L F P
0 g
s
.751 .663 .764 r
.45325 .44823 m .4426 .45203 L .45958 .432 L F
.763 .676 .767 r
.43886 .42423 m .42737 .44568 L .43525 .4486 L p F P
0 g
s
.763 .676 .767 r
.44256 .43353 m .43886 .42423 L .43525 .4486 L F
.773 .69 .771 r
.45229 .4299 m .44256 .43353 L .4434 .4318 L F
.45229 .4299 m .4426 .45203 L .42056 .44176 L p F P
0 g
s
.763 .676 .767 r
.45085 .45438 m .45866 .45727 L p .45325 .44823 L F P
0 g
s
.763 .676 .767 r
.45866 .45727 m .46647 .43459 L .45958 .432 L p F P
0 g
s
.763 .676 .767 r
.45866 .45727 m .45958 .432 L .45402 .44627 L F
.773 .69 .771 r
.44987 .43042 m .4434 .4318 L .44533 .42783 L F
.763 .676 .767 r
.45866 .45727 m .44581 .42684 L .4434 .4318 L F
.74 .651 .761 r
.45941 .45509 m .45866 .45727 L .4672 .45903 L p F P
0 g
s
.751 .663 .764 r
.45085 .45438 m .4426 .45203 L p .45325 .44823 L F P
0 g
s
.771 .626 .7 r
.45007 .45415 m .45085 .45438 L p .44942 .45687 L F P
0 g
s
.787 .643 .702 r
.45085 .45438 m .43525 .4486 L p .45828 .45892 L F P
0 g
s
.804 .661 .706 r
.43525 .4486 m .4426 .45203 L p .43273 .4564 L F P
0 g
s
.787 .643 .702 r
.45828 .45892 m .43525 .4486 L .43512 .449 L F
.44428 .47945 m .43512 .449 L .43273 .4564 L F
.45058 .49202 m .44503 .47659 L .44428 .47945 L F
.44503 .47659 m .43512 .449 L .44428 .47945 L F
.45828 .45892 m .45866 .45727 L .45085 .45438 L p F P
0 g
s
.771 .626 .7 r
.4672 .45903 m .47539 .46136 L p .47372 .46234 L F P
0 g
s
.771 .626 .7 r
.47372 .46234 m .46558 .46707 L .4672 .45903 L F
.751 .663 .764 r
.48126 .43826 m .47539 .46136 L .4672 .45903 L p F P
0 g
s
.771 .626 .7 r
.47539 .46136 m .46932 .49652 L .46014 .49396 L p F P
0 g
s
.755 .61 .697 r
.45866 .45727 m .45058 .49202 L .46014 .49396 L p F P
0 g
s
.755 .61 .697 r
.46558 .46707 m .45866 .45727 L .46014 .49396 L F
.771 .626 .7 r
.46014 .49396 m .44182 .48885 L p .46501 .46986 L F P
0 g
s
.771 .626 .7 r
.47539 .46136 m .46014 .49396 L .46501 .46986 L F
.47539 .46136 m .44182 .48885 L .44428 .47945 L F
.755 .61 .697 r
.48459 .53537 m .48861 .49973 L .4791 .4978 L p F P
0 g
s
.739 .595 .696 r
.46932 .49652 m .47539 .46136 L .4833 .46242 L p F P
0 g
s
.739 .595 .696 r
.48297 .46519 m .46932 .49652 L .4833 .46242 L F
.48047 .48819 m .46932 .49652 L .48413 .46253 L F
.755 .61 .697 r
.46014 .49396 m .45058 .49202 L p .4585 .50212 L F P
0 g
s
.771 .626 .7 r
.44182 .48885 m .43256 .48627 L p .44428 .47945 L F P
0 g
s
.787 .643 .702 r
.44182 .48885 m .42431 .48251 L p .43633 .51196 L F P
0 g
s
.787 .643 .702 r
.44247 .52701 m .44182 .48885 L .43633 .51196 L F
.4352 .51418 m .42431 .48251 L .42176 .49044 L F
.44247 .52701 m .436 .51115 L .4352 .51418 L F
.436 .51115 m .42431 .48251 L .4352 .51418 L F
.43275 .52357 m .44247 .52701 L p .4352 .51418 L F P
0 g
s
.747 .636 .738 r
.48069 .56207 m .48254 .54942 L p .47216 .54362 L F P
0 g
s
.747 .636 .738 r
.48069 .56207 m .47216 .54362 L .47049 .55271 L F
.181 0 0 r
.52876 .58213 m .52891 .57991 L .54357 .57889 L p F P
0 g
s
.237 0 0 r
.55833 .57882 m .54357 .57889 L p .55504 .58086 L F P
0 g
s
.237 0 0 r
.55645 .58111 m .55668 .58082 L p .55504 .58086 L F P
0 g
s
.237 0 0 r
.55668 .58082 m .55833 .57882 L p .55504 .58086 L F P
0 g
s
.237 0 0 r
.55645 .58111 m .54357 .57889 L .54288 .58044 L F
.181 0 0 r
.5428 .58063 m .52876 .58213 L .54357 .57889 L F
.279 0 0 r
.52891 .57991 m .52878 .58186 L p .51494 .58131 L F P
0 g
s
.279 0 0 r
.52878 .58186 m .52876 .58213 L .51494 .58131 L p F P
0 g
s
.279 0 0 r
.52891 .57991 m .51494 .58131 L .51448 .57983 L F
.309 0 0 r
.50105 .58138 m .48499 .57729 L .48684 .57911 L F
.237 0 0 r
.49948 .57911 m .50086 .5811 L p .51494 .58131 L F P
0 g
s
.237 0 0 r
.50086 .5811 m .50105 .58138 L .51494 .58131 L p F P
0 g
s
.237 0 0 r
.51442 .57963 m .49948 .57911 L .51494 .58131 L F
.279 0 0 r
.51442 .57963 m .48742 .57968 L .48684 .57911 L F
.51448 .57983 m .48742 .57968 L .51442 .57963 L F
.52891 .57991 m .51448 .57983 L .51442 .57963 L F
.181 0 0 r
.54256 .58117 m .52876 .58213 L p .53352 .58162 L F P
0 g
s
.181 0 0 r
.5428 .58063 m .54256 .58117 L .53352 .58162 L F
.237 0 0 r
.51494 .58131 m .54256 .58117 L p .51442 .57963 L F P
0 g
s
.237 0 0 r
.54256 .58117 m .55645 .58111 L p .5428 .58063 L F P
0 g
s
.237 0 0 r
.5428 .58063 m .51442 .57963 L .54256 .58117 L F
.55645 .58111 m .51423 .57903 L .51442 .57963 L F
.181 0 0 r
.58747 .57584 m .58432 .578 L p .57003 .57927 L F P
0 g
s
.181 0 0 r
.58747 .57584 m .57003 .57927 L .57181 .5777 L F
.112 0 0 r
.55833 .57882 m .55668 .58082 L p .57003 .57927 L F P
0 g
s
.112 0 0 r
.55668 .58082 m .55645 .58111 L .57003 .57927 L p F P
0 g
s
.112 0 0 r
.57204 .57749 m .55833 .57882 L .57003 .57927 L F
.029 0 0 r
.58747 .57584 m .60156 .57296 L p .58581 .57772 L F P
0 g
s
.029 0 0 r
.58432 .578 m .58747 .57584 L p .58581 .57772 L F P
0 g
s
.112 0 0 r
.6161 .57099 m .60156 .57296 L p .60979 .57367 L F P
0 g
s
.112 0 0 r
.61081 .57375 m .61146 .57341 L p .60979 .57367 L F P
0 g
s
.112 0 0 r
.61146 .57341 m .6161 .57099 L p .60979 .57367 L F P
0 g
s
.112 0 0 r
.61081 .57375 m .60156 .57296 L .59855 .57475 L F
.029 0 0 r
.59819 .57497 m .58387 .57831 L .60156 .57296 L F
.181 0 0 r
.58747 .57584 m .57181 .5777 L .57204 .57749 L F
.54357 .57889 m .57276 .57686 L p .5428 .58063 L F P
0 g
s
.181 0 0 r
.57276 .57686 m .58747 .57584 L p .57204 .57749 L F P
0 g
s
.112 0 0 r
.57276 .57686 m .55833 .57882 L p .57204 .57749 L F P
0 g
s
.181 0 0 r
.57204 .57749 m .5428 .58063 L .57276 .57686 L F
.112 0 0 r
.61081 .57375 m .59855 .57475 L .59819 .57497 L F
.029 0 0 r
.59713 .5756 m .58387 .57831 L p .59819 .57497 L F P
0 g
s
.112 0 0 r
.57003 .57927 m .59713 .5756 L p .57204 .57749 L F P
0 g
s
.112 0 0 r
.59713 .5756 m .61081 .57375 L p .59819 .57497 L F P
0 g
s
.112 0 0 r
.59819 .57497 m .57204 .57749 L .59713 .5756 L F
0 0 0 r
.6161 .57099 m .61146 .57341 L p .62362 .5702 L F P
0 g
s
.029 0 0 r
.64397 .5643 m .63787 .56708 L p .62362 .5702 L F P
0 g
s
.029 0 0 r
.63787 .56708 m .63701 .56747 L .62362 .5702 L p F P
0 g
s
.029 0 0 r
.64397 .5643 m .62362 .5702 L .6276 .56825 L F
0 0 0 r
.62812 .56799 m .6161 .57099 L .62362 .5702 L F
.62973 .56721 m .6161 .57099 L p .62812 .56799 L F P
0 g
s
.029 0 0 r
.62812 .56799 m .59713 .5756 L .59819 .57497 L F
.64397 .5643 m .6276 .56825 L .62812 .56799 L F
.6276 .56825 m .59713 .5756 L .62812 .56799 L F
0 0 0 r
.64397 .5643 m .65701 .55963 L p .63919 .56661 L F P
0 g
s
0 0 0 r
.67082 .5558 m .65701 .55963 L p .66166 .5595 L F P
0 g
s
0 0 0 r
.66223 .55949 m .6633 .55903 L p .66166 .5595 L F P
0 g
s
0 0 0 r
.6633 .55903 m .67082 .5558 L p .66166 .5595 L F P
0 g
s
0 0 0 r
.66223 .55949 m .65701 .55963 L .65175 .56198 L F
.65701 .55963 m .67816 .55207 L p .65572 .56021 L F P
0 g
s
.301 .773 .66 r
.67082 .5558 m .66223 .55949 L .6738 .55431 L p F P
0 g
s
0 0 0 r
.67816 .55207 m .68315 .55028 L p .65572 .56021 L F P
0 g
s
0 0 0 r
.68263 .5505 m .65572 .56021 L .68315 .55028 L F
.65111 .56226 m .63701 .56747 L .65701 .55963 L F
.029 0 0 r
.60974 .57129 m .64397 .5643 L p .59844 .57483 L F P
0 g
s
.029 0 0 r
.64397 .5643 m .59819 .57497 L .59844 .57483 L F
0 0 0 r
.65111 .56226 m .62973 .56721 L .62812 .56799 L F
.66223 .55949 m .65175 .56198 L .65111 .56226 L F
.65175 .56198 m .62973 .56721 L .65111 .56226 L F
.301 .773 .66 r
.6807 .55134 m .67082 .5558 L .6738 .55431 L F
.68315 .55028 m .67082 .5558 L p .6807 .55134 L F P
0 g
s
0 0 0 r
.69641 .54553 m .68625 .54986 L .6738 .55431 L p F P
0 g
s
0 0 0 r
.69641 .54553 m .6738 .55431 L .6799 .55168 L F
.69641 .54553 m .64926 .56309 L .65111 .56226 L F
.69641 .54553 m .65111 .56226 L .65572 .56021 L F
.68315 .55028 m .69641 .54553 L p .68263 .5505 L F P
0 g
s
.426 .855 .724 r
.68625 .54986 m .69641 .54553 L .70792 .53919 L p F P
0 g
s
.426 .855 .724 r
.70792 .53919 m .73104 .52645 L p .69963 .54278 L F P
0 g
s
.426 .855 .724 r
.72779 .5279 m .69963 .54278 L .73104 .52645 L F
.546 .922 .782 r
.71867 .53197 m .73852 .51856 L p .72779 .5279 L F P
0 g
s
.546 .922 .782 r
.74181 .51702 m .72779 .5279 L .73852 .51856 L F
.652 .968 .826 r
.75632 .50378 m .73852 .51856 L p .76612 .49892 L F P
0 g
s
.736 .992 .855 r
.75632 .50378 m .77185 .48774 L p .76741 .49828 L F P
0 g
s
.736 .992 .855 r
.77573 .48569 m .76741 .49828 L .77185 .48774 L F
.798 .995 .869 r
.78488 .47058 m .77185 .48774 L p .79612 .46418 L F P
0 g
s
.839 .982 .872 r
.78488 .47058 m .79521 .45243 L p .7976 .46333 L F P
0 g
s
.839 .982 .872 r
.79954 .44977 m .7976 .46333 L .79521 .45243 L F
.863 .96 .867 r
.80263 .43348 m .79521 .45243 L p .81489 .4253 L F P
0 g
s
.874 .932 .857 r
.80263 .43348 m .80696 .41391 L p .81652 .42421 L F P
0 g
s
.874 .932 .857 r
.81158 .41055 m .81652 .42421 L .80696 .41391 L F
.877 .902 .844 r
.80807 .39393 m .80696 .41391 L p .82086 .38377 L F P
0 g
s
.874 .872 .832 r
.80807 .39393 m .80581 .37377 L p .82255 .38242 L F P
0 g
s
.874 .872 .832 r
.81051 .36967 m .82255 .38242 L .80581 .37377 L F
.867 .843 .819 r
.80012 .35368 m .80581 .37377 L p .81284 .34142 L F P
0 g
s
.857 .816 .808 r
.80012 .35368 m .79096 .33392 L p .81453 .33979 L F P
0 g
s
.857 .816 .808 r
.79551 .32904 m .81453 .33979 L .79096 .33392 L F
.846 .79 .797 r
.77834 .31476 m .79096 .33392 L p .79029 .30038 L F P
0 g
s
.833 .766 .788 r
.77834 .31476 m .76232 .29648 L p .79188 .29847 L F P
0 g
s
.609 .71 .916 r
.75621 .36026 m .77601 .35771 L p .77129 .34883 L F P
0 g
s
.8 .796 .848 r
.77486 .35501 m .79112 .35963 L .78078 .36646 L F
.772 .3483 m .79478 .35722 L .77486 .35501 L F
.77594 .34531 m .79478 .35722 L .772 .3483 L F
.79478 .35722 m .79112 .35963 L .77486 .35501 L F
.794 .779 .839 r
.79096 .33392 m .77834 .31476 L p .77594 .34531 L F P
0 g
s
.794 .779 .839 r
.77331 .31914 m .77594 .34531 L .77834 .31476 L F
.78 .747 .823 r
.7422 .28035 m .74986 .30905 L .75965 .29917 L F
.73864 .28454 m .74868 .31024 L .7422 .28035 L F
.74868 .31024 m .74986 .30905 L .7422 .28035 L F
.807 .723 .773 r
.74304 .27936 m .72068 .26369 L p .75491 .26083 L F P
0 g
s
.787 .762 .831 r
.7459 .31482 m .77168 .32057 L .76011 .33066 L F
.75231 .3226 m .76011 .33066 L .75943 .33125 L F
.7459 .31482 m .76011 .33066 L .75231 .3226 L F
.609 .721 .925 r
.73409 .32802 m .75231 .3226 L p .74377 .31474 L F P
0 g
s
.609 .721 .925 r
.73172 .3189 m .73409 .32802 L .74377 .31474 L F
.609 .716 .921 r
.7188 .31315 m .73583 .30636 L p .74446 .3145 L F P
0 g
s
.771 .732 .817 r
.70728 .28451 m .73864 .28454 L .7271 .29814 L F
.71644 .29134 m .7271 .29814 L .7265 .29883 L F
.70728 .28451 m .7271 .29814 L .71644 .29134 L F
.612 .734 .932 r
.70088 .2994 m .71644 .29134 L p .70509 .28489 L F P
0 g
s
.612 .734 .932 r
.69474 .29096 m .70088 .2994 L .70509 .28489 L F
.753 .705 .807 r
.65731 .25972 m .69201 .25558 L .68288 .27096 L F
.6594 .25534 m .69201 .25558 L .65731 .25972 L F
.66986 .26588 m .68288 .27096 L .68241 .27175 L F
.6572 .25996 m .68288 .27096 L .66986 .26588 L F
.256 .598 .951 r
.66321 .27698 m .66154 .27679 L p .66114 .27643 L F P
0 g
s
.806 .733 .783 r
.63996 .27086 m .63458 .26627 L p .63466 .26705 L F P
0 g
s
.256 .598 .951 r
.6518 .27189 m .66321 .27698 L .63996 .27086 L F
.64601 .27497 m .63996 .27086 L p .66114 .27643 L F P
0 g
s
.256 .598 .951 r
.66154 .27679 m .64601 .27497 L p .66114 .27643 L F P
0 g
s
.311 .573 .933 r
.65058 .27991 m .64601 .27497 L p .65462 .28052 L F P
0 g
s
.282 .584 .944 r
.63564 .26632 m .63458 .26627 L .63996 .27086 L p F P
0 g
s
.282 .584 .944 r
.63996 .27086 m .65058 .27991 L p .64567 .27544 L F P
0 g
s
.794 .715 .776 r
.64601 .27497 m .64567 .27544 L p .64528 .27512 L F P
0 g
s
.794 .715 .776 r
.62785 .26263 m .63996 .27086 L p .61834 .27925 L F P
0 g
s
.782 .698 .771 r
.62785 .26263 m .6144 .25535 L p .61726 .28113 L F P
0 g
s
.22 .632 .955 r
.62172 .25847 m .6144 .25535 L p .63367 .25786 L F P
0 g
s
.22 .632 .955 r
.63422 .25815 m .62172 .25847 L p .63367 .25786 L F P
0 g
s
.782 .698 .771 r
.6144 .25535 m .6076 .25167 L p .60785 .25243 L F P
0 g
s
.757 .667 .763 r
.60736 .25222 m .6076 .25167 L .59977 .24913 L p F P
0 g
s
.22 .632 .955 r
.59238 .24598 m .59506 .24674 L .60026 .24905 L F
.59238 .24598 m .60026 .24905 L .59989 .24911 L F
.214 .653 .952 r
.59977 .24913 m .6076 .25167 L p .6022 .24874 L F P
0 g
s
.22 .632 .955 r
.59977 .24913 m .59238 .24598 L p .60736 .25222 L F P
0 g
s
.22 .632 .955 r
.6144 .25535 m .59977 .24913 L p .60736 .25222 L F P
0 g
s
.77 .682 .766 r
.58984 .27495 m .59258 .27332 L .59677 .27625 L F
.60252 .28026 m .58984 .27495 L p .59677 .27625 L F P
0 g
s
.369 .555 .905 r
.67673 .3166 m .6753 .31607 L .67252 .31071 L p F P
0 g
s
.369 .555 .905 r
.67252 .31071 m .66694 .29997 L p .6702 .3055 L F P
0 g
s
.846 .818 .821 r
.67252 .31071 m .6706 .30512 L p .67036 .30586 L F P
0 g
s
.398 .549 .889 r
.69098 .31135 m .689 .31075 L p .68933 .3113 L F P
0 g
s
.398 .549 .889 r
.69098 .31135 m .67252 .31071 L .68741 .31578 L F
.369 .555 .905 r
.67357 .31107 m .69409 .32261 L .67673 .3166 L F
.69621 .3238 m .69418 .32305 L p .69409 .32261 L F P
0 g
s
.369 .555 .905 r
.69418 .32305 m .67673 .3166 L p .69409 .32261 L F P
0 g
s
.369 .555 .905 r
.68741 .31578 m .69621 .3238 L .67357 .31107 L F
.049 .284 .776 r
.73446 .34976 m .71246 .33028 L .71478 .33739 L p F P
0 g
s
0 .246 .76 r
.71821 .3442 m .69724 .32476 L p .69417 .31899 L F P
0 g
s
0 .246 .76 r
.6957 .32035 m .71821 .3442 L .69417 .31899 L F
.70883 .33199 m .71821 .3442 L .69386 .31841 L F
.049 .284 .776 r
.71933 .35139 m .7216 .35835 L p .72453 .35639 L F P
0 g
s
.232 .347 .776 r
.69944 .36187 m .72136 .38664 L .72142 .37962 L p F P
0 g
s
.232 .347 .776 r
.70621 .36299 m .69944 .36187 L .72142 .37962 L F
.3 .37 .767 r
.70042 .34922 m .72264 .37255 L .72142 .37962 L p F P
0 g
s
.3 .37 .767 r
.70042 .34922 m .72142 .37962 L .70445 .36108 L F
.23 .345 .775 r
.74429 .38077 m .7216 .35835 L .72154 .36552 L p F P
0 g
s
.15 .32 .781 r
.72264 .37255 m .70042 .34922 L .69947 .34351 L p F P
0 g
s
.15 .32 .781 r
.70119 .34522 m .72264 .37255 L .69947 .34351 L F
.71546 .35932 m .72264 .37255 L .69937 .34291 L F
.148 .318 .78 r
.74526 .39643 m .72264 .37255 L .72154 .36552 L p F P
0 g
s
.23 .345 .775 r
.73835 .38229 m .72154 .36552 L .73799 .38239 L F
.74429 .38077 m .72154 .36552 L .73835 .38229 L F
.232 .347 .776 r
.72154 .36552 m .7216 .35835 L p .7156 .3593 L F P
0 g
s
.15 .32 .781 r
.69947 .34351 m .69937 .34291 L p .70119 .34522 L F P
0 g
s
.3 .37 .767 r
.69942 .35557 m .70042 .34922 L p .70445 .36108 L F P
0 g
s
.475 .541 .844 r
.69837 .34818 m .70042 .34922 L .69942 .35557 L p F P
0 g
s
.398 .549 .889 r
.6973 .33558 m .69935 .33647 L .69727 .33024 L p F P
0 g
s
.425 .545 .874 r
.70042 .34922 m .69837 .34818 L p .69863 .34685 L F P
0 g
s
.398 .549 .889 r
.67818 .32723 m .6973 .33558 L p .69727 .33024 L F P
0 g
s
.398 .549 .889 r
.68272 .32434 m .67818 .32723 L .69727 .33024 L F
.425 .545 .874 r
.6753 .31607 m .69418 .32305 L p .69575 .32962 L F P
0 g
s
.425 .545 .874 r
.6753 .31607 m .69575 .32962 L .68106 .32367 L F
.398 .549 .889 r
.6931 .31771 m .69098 .31135 L p .68741 .31578 L F P
0 g
s
.398 .549 .889 r
.6706 .30512 m .67252 .31071 L p .68933 .3113 L F P
0 g
s
.398 .549 .889 r
.689 .31075 m .6706 .30512 L p .68933 .3113 L F P
0 g
s
.369 .555 .905 r
.6818 .29883 m .6837 .2993 L .68686 .3055 L p F P
0 g
s
0 .198 .722 r
.68686 .3055 m .69098 .31135 L p .69109 .31107 L F P
0 g
s
0 .198 .722 r
.69166 .30966 m .68686 .3055 L .69109 .31107 L F
.34 .563 .919 r
.6706 .30512 m .689 .31075 L p .68686 .3055 L F P
0 g
s
.34 .563 .919 r
.689 .31075 m .69098 .31135 L .68686 .3055 L p F P
0 g
s
.052 .287 .777 r
.69199 .31224 m .69098 .31135 L .6931 .31771 L p F P
0 g
s
0 .246 .76 r
.69378 .31833 m .69724 .32476 L .6931 .31771 L F
.052 .287 .777 r
.69199 .31224 m .6931 .31771 L .69386 .31841 L F
0 .246 .76 r
.68643 .30443 m .69724 .32476 L .68686 .3055 L F
.34 .563 .919 r
.67146 .30122 m .6706 .30512 L .68686 .3055 L F
.369 .555 .905 r
.68686 .3055 m .69621 .3238 L p .67146 .30122 L F P
0 g
s
.425 .545 .874 r
.69418 .32305 m .69621 .3238 L .69727 .33024 L p F P
0 g
s
.15 .32 .781 r
.69727 .33024 m .69621 .3238 L p .69725 .32572 L F P
0 g
s
.15 .32 .781 r
.69725 .32572 m .70232 .33507 L .69727 .33024 L F
.052 .287 .777 r
.69727 .33024 m .69935 .33647 L p .69753 .33049 L F P
0 g
s
0 .246 .76 r
.69386 .31841 m .6957 .32035 L .69417 .31899 L F
.69724 .32476 m .69621 .3238 L .6931 .31771 L p F P
0 g
s
.15 .32 .781 r
.69621 .3238 m .71821 .3442 L .71933 .35139 L p F P
0 g
s
.15 .32 .781 r
.69621 .3238 m .71933 .35139 L .70232 .33507 L F
.052 .287 .777 r
.70883 .33199 m .69386 .31841 L .69753 .33049 L F
.69882 .33172 m .69753 .33049 L .6979 .33169 L F
.70883 .33199 m .69753 .33049 L .69882 .33172 L F
.232 .347 .776 r
.7216 .35835 m .7004 .33751 L p .70007 .34361 L F P
0 g
s
.398 .549 .889 r
.68106 .32367 m .67818 .32723 L .68272 .32434 L F
.451 .542 .859 r
.69937 .34291 m .69935 .33647 L p .69355 .34015 L F P
0 g
s
.451 .542 .859 r
.69935 .33647 m .67818 .32723 L .67827 .33291 L p F P
0 g
s
.451 .542 .859 r
.69935 .33647 m .67827 .33291 L .69355 .34015 L F
.425 .545 .874 r
.6763 .32174 m .6753 .31607 L p .68106 .32367 L F P
0 g
s
.369 .555 .905 r
.67345 .31103 m .67673 .3166 L .67252 .31071 L F
.828 .772 .8 r
.6702 .3055 m .6706 .30512 L .66694 .29997 L p F P
0 g
s
.369 .555 .905 r
.66694 .29997 m .66412 .29452 L p .66728 .30006 L F P
0 g
s
.369 .555 .905 r
.66412 .29452 m .6818 .29883 L p .68686 .3055 L F P
0 g
s
.369 .555 .905 r
.66412 .29452 m .68686 .3055 L .67146 .30122 L F
.34 .563 .919 r
.66694 .29997 m .6706 .30512 L p .67146 .30122 L F P
0 g
s
.846 .818 .821 r
.6706 .30512 m .6702 .3055 L p .67036 .30586 L F P
0 g
s
.369 .555 .905 r
.66412 .29452 m .68741 .31578 L .67357 .31107 L F
.838 .794 .81 r
.66373 .29494 m .66412 .29452 L .66694 .29997 L p F P
0 g
s
.34 .563 .919 r
.66726 .29946 m .66373 .29494 L .66694 .29997 L F
.65961 .28966 m .66694 .29997 L p .66373 .29494 L F P
0 g
s
.828 .772 .8 r
.65961 .28966 m .654 .31287 L .66668 .30023 L F
.66694 .29997 m .65961 .28966 L p .66668 .30023 L F P
0 g
s
.398 .549 .889 r
.67252 .31071 m .6763 .32174 L p .67488 .31641 L F P
0 g
s
.846 .818 .821 r
.65328 .32773 m .65666 .33723 L p .65602 .33162 L F P
0 g
s
.846 .818 .821 r
.65537 .32588 m .65328 .32773 L .65602 .33162 L F
.681 .974 .906 r
.64442 .40455 m .63374 .41254 L p .63407 .40766 L F P
0 g
s
.742 .982 .911 r
.64442 .40455 m .65384 .39582 L p .6329 .40802 L F P
0 g
s
.742 .982 .911 r
.65384 .39582 m .65861 .3914 L p .65795 .39182 L F P
0 g
s
.82 .963 .901 r
.65826 .39153 m .65861 .3914 L .6619 .38642 L p F P
0 g
s
.557 .548 .799 r
.66598 .38165 m .666 .38401 L .66273 .38718 L F
.66598 .38165 m .66273 .38718 L .6621 .38661 L F
.539 .544 .809 r
.6619 .38642 m .65861 .3914 L p .66605 .39026 L F P
0 g
s
.557 .548 .799 r
.6619 .38642 m .66598 .38165 L p .65826 .39153 L F P
0 g
s
.557 .548 .799 r
.6662 .4089 m .66627 .41646 L .65384 .39582 L F
.66627 .41646 m .66629 .41913 L .66519 .41706 L F
.66627 .41646 m .66519 .41706 L .65384 .39582 L F
.514 .451 .723 r
.66388 .43087 m .66032 .42403 L .65475 .42855 L F
.543 .464 .717 r
.66013 .42366 m .66629 .41913 L p .66388 .43087 L F P
0 g
s
.557 .548 .799 r
.66629 .41913 m .64982 .40051 L .65384 .39582 L p F P
0 g
s
.592 .557 .784 r
.6647 .41733 m .66629 .41913 L .66013 .42366 L p F P
0 g
s
.514 .45 .723 r
.71348 .46901 m .69483 .43875 L .68864 .44424 L p F P
0 g
s
.483 .437 .73 r
.68341 .45005 m .66629 .41913 L .67046 .41436 L p F P
0 g
s
.483 .437 .73 r
.67188 .4167 m .68341 .45005 L .67046 .41436 L F
.68379 .43594 m .68341 .45005 L .6709 .41386 L F
.514 .45 .723 r
.67645 .45505 m .67037 .46044 L p .68026 .46241 L F P
0 g
s
.568 .476 .711 r
.68611 .49267 m .67037 .46044 L .66272 .46491 L p F P
0 g
s
.543 .464 .717 r
.65587 .46982 m .64189 .43707 L .64738 .43303 L p F P
0 g
s
.543 .464 .717 r
.64858 .43552 m .65587 .46982 L .64738 .43303 L F
.6574 .45326 m .65587 .46982 L .64796 .4326 L F
.542 .464 .716 r
.66994 .50289 m .65587 .46982 L .66272 .46491 L p F P
0 g
s
.568 .476 .711 r
.67428 .48893 m .66272 .46491 L .67356 .48871 L F
.68611 .49267 m .66272 .46491 L .67428 .48893 L F
.568 .477 .711 r
.66272 .46491 m .67037 .46044 L p .65896 .45619 L F P
0 g
s
.543 .464 .717 r
.64738 .43303 m .64796 .4326 L p .64858 .43552 L F P
0 g
s
.568 .477 .711 r
.67037 .46044 m .65549 .43006 L p .64848 .43375 L F P
0 g
s
.568 .477 .711 r
.67037 .46044 m .64848 .43375 L .65869 .45609 L F
.483 .437 .73 r
.67046 .41436 m .6709 .41386 L p .67188 .4167 L F P
0 g
s
.514 .451 .723 r
.66032 .42403 m .66013 .42366 L .6592 .42494 L F
.543 .464 .717 r
.66629 .41913 m .68341 .45005 L .67645 .45505 L p F P
0 g
s
.543 .464 .717 r
.66629 .41913 m .67645 .45505 L .66388 .43087 L F
.575 .552 .791 r
.67636 .40889 m .65861 .3914 L .65384 .39582 L p F P
0 g
s
.592 .557 .784 r
.64982 .40051 m .6647 .41733 L p .65899 .42228 L F P
0 g
s
.592 .557 .784 r
.64982 .40051 m .65899 .42228 L .64885 .40995 L F
.557 .548 .799 r
.6709 .41386 m .66629 .41913 L p .6662 .4089 L F P
0 g
s
.575 .552 .791 r
.63971 .40892 m .65475 .42855 L .66013 .42366 L p F P
0 g
s
.575 .552 .791 r
.64925 .41043 m .63971 .40892 L .66013 .42366 L F
.608 .562 .777 r
.64796 .4326 m .65475 .42855 L p .64405 .42709 L F P
0 g
s
.608 .562 .777 r
.65475 .42855 m .63971 .40892 L .63374 .41254 L p F P
0 g
s
.681 .974 .906 r
.63374 .41254 m .62841 .41653 L p .62852 .41631 L F P
0 g
s
.608 .562 .777 r
.61844 .4236 m .62252 .42065 L .61604 .42327 L F
.623 .568 .772 r
.62194 .41969 m .62841 .41653 L p .62482 .42447 L F P
0 g
s
.608 .562 .777 r
.63374 .41254 m .62194 .41969 L p .62814 .41659 L F P
0 g
s
.52 .917 .87 r
.61269 .42166 m .62175 .41973 L .6091 .42597 L F
.652 .583 .764 r
.57444 .43936 m .57401 .43777 L .5812 .4356 L p F P
0 g
s
.652 .583 .764 r
.5812 .4356 m .59553 .43127 L p .58854 .43395 L F P
0 g
s
.242 .757 .783 r
.5812 .4356 m .5887 .43394 L p .58803 .43407 L F P
0 g
s
.634 .514 .7 r
.58666 .49591 m .58054 .46248 L p .58788 .45989 L F P
0 g
s
.634 .514 .7 r
.58862 .45963 m .58847 .46238 L .58788 .45989 L F
.58847 .46238 m .58666 .49591 L .58788 .45989 L F
.653 .527 .697 r
.61374 .52614 m .60528 .49122 L .59576 .49326 L p F P
0 g
s
.634 .514 .7 r
.59375 .48376 m .58666 .49591 L .58862 .45963 L F
.653 .527 .697 r
.57691 .4973 m .56745 .49932 L p .57816 .50552 L F P
0 g
s
.653 .527 .698 r
.56308 .46392 m .56745 .49932 L .57691 .4973 L p F P
0 g
s
.653 .527 .698 r
.57319 .47299 m .56308 .46392 L .57691 .4973 L F
.671 .54 .696 r
.58023 .46081 m .58666 .49591 L .57691 .4973 L p F P
0 g
s
.653 .527 .698 r
.57276 .47018 m .56308 .46392 L .57319 .47299 L F
.671 .54 .696 r
.55757 .50004 m .54786 .50142 L p .55646 .49063 L F P
0 g
s
.671 .54 .696 r
.55666 .49038 m .55757 .50004 L .55646 .49063 L F
.689 .552 .695 r
.57184 .53492 m .56745 .49932 L .55757 .50004 L p F P
0 g
s
.692 .608 .758 r
.55424 .46457 m .56308 .46392 L p .56054 .46241 L F P
0 g
s
.671 .539 .696 r
.55016 .53719 m .54786 .50142 L .55757 .50004 L p F P
0 g
s
.689 .553 .695 r
.56745 .49932 m .56308 .46392 L .55509 .46451 L p F P
0 g
s
.689 .553 .695 r
.56745 .49932 m .55509 .46451 L .55528 .46729 L F
.56745 .49932 m .55424 .46457 L .55666 .49038 L F
.671 .539 .696 r
.55971 .52295 m .55922 .52368 L .55757 .50004 L F
.55922 .52368 m .55016 .53719 L .55757 .50004 L F
.671 .54 .696 r
.54786 .50142 m .54568 .46752 L p .55435 .46569 L F P
0 g
s
.671 .54 .696 r
.55637 .48727 m .54786 .50142 L .55435 .46569 L F
.58023 .46081 m .57691 .4973 L .57276 .47018 L F
.57152 .46207 m .58023 .46081 L p .57276 .47018 L F P
0 g
s
.634 .514 .7 r
.58054 .46248 m .58023 .46081 L .58836 .45839 L p F P
0 g
s
.633 .514 .7 r
.5931 .53123 m .58666 .49591 L .59576 .49326 L p F P
0 g
s
.653 .527 .698 r
.60528 .49122 m .59685 .45653 L .58917 .45821 L p F P
0 g
s
.653 .527 .698 r
.60528 .49122 m .58917 .45821 L .58968 .46096 L F
.60528 .49122 m .58836 .45839 L .59375 .48376 L F
.633 .514 .7 r
.60119 .51886 m .60072 .51958 L .59576 .49326 L F
.60072 .51958 m .5931 .53123 L .59576 .49326 L F
.671 .539 .696 r
.57691 .4973 m .58666 .49591 L p .57816 .50552 L F P
0 g
s
.689 .552 .695 r
.56068 .52658 m .55757 .50004 L .56 .52607 L F
.57184 .53492 m .55757 .50004 L .56068 .52658 L F
.5609 .5357 m .57184 .53492 L p .56 .52607 L F P
0 g
s
.653 .527 .697 r
.56745 .49932 m .57184 .53492 L .58231 .53273 L p F P
0 g
s
.671 .539 .696 r
.58666 .49591 m .5931 .53123 L .58231 .53273 L p F P
0 g
s
.671 .539 .696 r
.58666 .49591 m .58231 .53273 L .57859 .50837 L F
.653 .527 .697 r
.57816 .50552 m .56745 .49932 L .58231 .53273 L F
.671 .539 .696 r
.58666 .49591 m .5609 .5357 L .56 .52607 L F
.645 .557 .741 r
.59936 .55762 m .5931 .53123 L .6032 .52835 L p F P
0 g
s
.633 .514 .7 r
.6032 .52835 m .5931 .53123 L p .60119 .51886 L F P
0 g
s
.653 .527 .697 r
.60268 .5259 m .57816 .50552 L .58119 .52542 L F
.61374 .52614 m .60119 .51886 L .60268 .5259 L F
.60119 .51886 m .57816 .50552 L .60268 .5259 L F
.6032 .52835 m .61374 .52614 L p .58119 .52542 L F P
0 g
s
.653 .527 .697 r
.61374 .52614 m .59576 .49326 L .60191 .51928 L F
.613 .501 .703 r
.60528 .49122 m .61374 .52614 L .62337 .5226 L p F P
0 g
s
.633 .514 .7 r
.62315 .48528 m .63356 .51969 L .62337 .5226 L p F P
0 g
s
.633 .514 .7 r
.62315 .48528 m .62337 .5226 L .6169 .49877 L F
.613 .501 .703 r
.61614 .49599 m .60528 .49122 L .62337 .5226 L F
.653 .527 .697 r
.60191 .51928 m .59576 .49326 L .60113 .5186 L F
.60191 .51928 m .57691 .4973 L .57816 .50552 L F
.633 .514 .7 r
.61614 .49599 m .6032 .52835 L .60119 .51886 L F
.62315 .48528 m .6169 .49877 L .61614 .49599 L F
.6169 .49877 m .6032 .52835 L .61614 .49599 L F
.613 .501 .703 r
.61396 .48796 m .60528 .49122 L p .61614 .49599 L F P
0 g
s
.653 .527 .698 r
.59576 .49326 m .60528 .49122 L p .59375 .48376 L F P
0 g
s
.613 .502 .703 r
.59685 .45653 m .60528 .49122 L .61396 .48796 L p F P
0 g
s
.633 .514 .7 r
.59576 .49326 m .61396 .48796 L p .60119 .51886 L F P
0 g
s
.633 .514 .7 r
.61396 .48796 m .62315 .48528 L p .61628 .49579 L F P
0 g
s
.633 .514 .7 r
.61628 .49579 m .60119 .51886 L .61396 .48796 L F
.613 .502 .703 r
.606 .4611 m .59685 .45653 L .61396 .48796 L F
.653 .527 .698 r
.58917 .45821 m .58836 .45839 L p .58968 .46096 L F P
0 g
s
.634 .514 .7 r
.61278 .45112 m .60674 .46148 L .60469 .45397 L F
.60458 .45356 m .61278 .45112 L p .60469 .45397 L F P
0 g
s
.426 .87 .842 r
.60916 .42596 m .61604 .42327 L p .61535 .4235 L F P
0 g
s
.606 .953 .892 r
.61581 .42331 m .61604 .42327 L .62194 .41969 L p F P
0 g
s
.608 .562 .777 r
.62194 .41969 m .61604 .42327 L p .62252 .42065 L F P
0 g
s
.623 .568 .772 r
.62194 .41969 m .62155 .42103 L .61581 .42331 L F
.60916 .42596 m .62194 .41969 L p .61581 .42331 L F P
0 g
s
.52 .917 .87 r
.61269 .42166 m .6091 .42597 L .6063 .42644 L F
.666 .591 .761 r
.56121 .44154 m .56655 .43996 L .55885 .44055 L F
.679 .599 .759 r
.56631 .4389 m .57401 .43777 L p .5675 .44419 L F P
0 g
s
.666 .591 .761 r
.5812 .4356 m .56631 .4389 L p .57389 .43777 L F P
0 g
s
.692 .608 .758 r
.52991 .4442 m .53556 .44338 L .5277 .44289 L F
.704 .618 .758 r
.5355 .44231 m .54336 .44226 L p .53577 .44769 L F P
0 g
s
.692 .608 .758 r
.55103 .44114 m .5355 .44231 L p .54331 .44226 L F P
0 g
s
.706 .566 .695 r
.54557 .46583 m .53698 .47407 L .53671 .4663 L F
.689 .553 .695 r
.5367 .46587 m .52788 .46653 L p .53698 .47407 L F P
0 g
s
.716 .628 .758 r
.52788 .46653 m .52786 .46426 L p .52717 .46439 L F P
0 g
s
.035 .605 .738 r
.5126 .44242 m .51831 .4424 L .51203 .44243 L F
.704 .618 .758 r
.51203 .44243 m .51988 .44239 L p .51103 .46392 L F P
0 g
s
.704 .618 .758 r
.51017 .46601 m .51035 .46375 L p .51103 .46392 L F P
0 g
s
.704 .618 .758 r
.51035 .46375 m .51203 .44243 L p .51103 .46392 L F P
0 g
s
.722 .58 .695 r
.52789 .46822 m .52788 .46653 L .51905 .46597 L p F P
0 g
s
.706 .566 .695 r
.51901 .46723 m .51008 .4677 L .51905 .46597 L F
.704 .618 .758 r
.51935 .45742 m .51017 .46601 L .51988 .44239 L F
.706 .566 .695 r
.51008 .4677 m .51017 .46601 L .51905 .46597 L p F P
0 g
s
.716 .628 .758 r
.52788 .46653 m .51988 .44239 L .51927 .4595 L F
.5277 .44289 m .51988 .44239 L p .52717 .46439 L F P
0 g
s
.716 .628 .758 r
.52786 .46426 m .5277 .44289 L p .52717 .46439 L F P
0 g
s
.692 .608 .758 r
.5355 .44231 m .5277 .44289 L p .53556 .44338 L F P
0 g
s
.035 .605 .738 r
.54331 .44226 m .54336 .44226 L .5355 .44231 L p F P
0 g
s
.161 .701 .759 r
.54384 .44218 m .54948 .44136 L .54336 .44226 L F
.679 .599 .759 r
.54557 .46583 m .54336 .44226 L .55103 .44114 L p F P
0 g
s
.679 .599 .759 r
.55308 .45608 m .54557 .46583 L .55103 .44114 L F
.692 .608 .758 r
.56308 .46392 m .55103 .44114 L .55336 .45814 L F
.56308 .46392 m .55885 .44055 L .55103 .44114 L p F P
0 g
s
.666 .591 .761 r
.56631 .4389 m .55885 .44055 L p .56655 .43996 L F P
0 g
s
.161 .701 .759 r
.57389 .43777 m .57401 .43777 L .56631 .4389 L p F P
0 g
s
.332 .815 .812 r
.57401 .43777 m .57389 .43777 L p .57427 .43766 L F P
0 g
s
.242 .757 .783 r
.56631 .4389 m .5812 .4356 L p .56287 .439 L F P
0 g
s
.332 .815 .812 r
.58887 .43212 m .57931 .43575 L .58593 .43281 L F
.161 .701 .759 r
.56248 .43901 m .56623 .4389 L .55101 .44114 L F
.55078 .44113 m .55101 .44114 L .54948 .44136 L F
.56248 .43901 m .55101 .44114 L .55078 .44113 L F
.092 .65 .744 r
.5277 .44288 m .5277 .44289 L .5355 .44231 L p F P
0 g
s
.704 .618 .758 r
.51988 .44239 m .5355 .44231 L p .5277 .44288 L F P
0 g
s
0 .569 .742 r
.51988 .44239 m .5277 .44289 L p .52716 .44285 L F P
0 g
s
.092 .65 .744 r
.52753 .44254 m .5277 .44288 L p .53549 .4423 L F P
0 g
s
.092 .65 .744 r
.55103 .44114 m .53471 .44211 L .53549 .4423 L F
.035 .605 .738 r
.53471 .44211 m .53548 .4423 L .51989 .44239 L F
.728 .639 .759 r
.48085 .43986 m .48126 .43826 L .48899 .43931 L p F P
0 g
s
.74 .651 .761 r
.49262 .46429 m .49649 .44088 L .48899 .43931 L p F P
0 g
s
.74 .651 .761 r
.49262 .46429 m .48899 .43931 L .48546 .45616 L F
.751 .663 .764 r
.47886 .43912 m .47246 .44139 L .47363 .4375 L F
.74 .651 .761 r
.47402 .43617 m .46647 .43459 L p .47246 .44139 L F P
0 g
s
0 .523 .778 r
.46663 .43461 m .46647 .43459 L .47402 .43617 L p F P
0 g
s
.74 .651 .761 r
.46647 .43459 m .45941 .45509 L p .4672 .45903 L F P
0 g
s
.74 .651 .761 r
.47246 .44139 m .46647 .43459 L .4672 .45903 L F
.751 .663 .764 r
.45958 .432 m .48126 .43826 L p .47886 .43912 L F P
0 g
s
0 .505 .837 r
.44581 .42684 m .45958 .432 L p .44595 .42686 L F P
0 g
s
.047 .503 .888 r
.42088 .41369 m .43287 .42071 L p .42107 .41374 L F P
0 g
s
.096 .504 .904 r
.42088 .41369 m .41 .40583 L p .43112 .41625 L F P
0 g
s
.096 .504 .904 r
.41 .40583 m .40449 .40185 L p .40517 .40222 L F P
0 g
s
.203 .507 .91 r
.40482 .40196 m .40449 .40185 L .40034 .39721 L p F P
0 g
s
.804 .737 .79 r
.40033 .3986 m .40482 .40196 L .40034 .39721 L F
.41 .40583 m .40034 .39721 L p .40482 .40196 L F P
0 g
s
.822 .773 .807 r
.38148 .37534 m .38432 .37872 L .38172 .37298 L F
.38519 .378 m .38172 .37298 L p .38432 .37872 L F P
0 g
s
.829 .793 .818 r
.38519 .378 m .38783 .38318 L p .38085 .3816 L F P
0 g
s
.203 .507 .91 r
.38847 .38365 m .39127 .38699 L .38783 .38318 L F
.302 .509 .892 r
.3882 .38334 m .38783 .38318 L .38519 .378 L p F P
0 g
s
.822 .773 .807 r
.38432 .37872 m .3882 .38334 L .38519 .378 L F
.39204 .3879 m .38519 .378 L p .3882 .38334 L F P
0 g
s
.203 .507 .91 r
.40034 .39721 m .39204 .3879 L p .40057 .39728 L F P
0 g
s
.149 .506 .911 r
.41 .40583 m .41141 .40097 L .40057 .39728 L F
.203 .507 .91 r
.4006 .39729 m .39204 .3879 L .39213 .38794 L F
.149 .506 .911 r
.40034 .39721 m .41 .40583 L p .40057 .39728 L F P
0 g
s
.203 .507 .91 r
.40482 .40196 m .40057 .39728 L .4006 .39729 L F
.40057 .39728 m .39204 .3879 L .4006 .39729 L F
.813 .755 .798 r
.38655 .38431 m .38783 .38318 L .39204 .3879 L p F P
0 g
s
.813 .755 .798 r
.39204 .3879 m .40034 .39721 L p .3958 .39297 L F P
0 g
s
.254 .508 .903 r
.39204 .3879 m .39545 .39284 L p .39555 .39262 L F P
0 g
s
.149 .506 .911 r
.41406 .40703 m .41267 .4014 L .41 .40583 L F
.41267 .4014 m .41141 .40097 L .41 .40583 L F
.096 .504 .904 r
.41406 .40703 m .41 .40583 L .40517 .40222 L F
.43112 .41625 m .41 .40583 L .41406 .40703 L F
.149 .506 .911 r
.41477 .40992 m .41406 .40703 L .41 .40583 L F
.203 .507 .91 r
.41144 .40098 m .4006 .39729 L .39213 .38794 L F
.41175 .40109 m .39213 .38794 L .39332 .3884 L F
.096 .504 .904 r
.42864 .41337 m .41406 .40703 L .42305 .40967 L F
.43412 .417 m .43153 .41571 L .42864 .41337 L F
.43153 .41571 m .41406 .40703 L .42864 .41337 L F
.42465 .41014 m .43412 .417 L p .42305 .40967 L F P
0 g
s
.096 .504 .904 r
.43112 .41625 m .41406 .40703 L .43412 .417 L F
.047 .503 .888 r
.42884 .4139 m .41512 .41022 L p .42109 .41374 L F P
0 g
s
.005 .503 .865 r
.44581 .42684 m .43287 .42071 L p .45358 .42811 L F P
0 g
s
.005 .503 .865 r
.45358 .42811 m .43287 .42071 L .4361 .42138 L F
.047 .503 .888 r
.43293 .42073 m .43035 .41606 L .42109 .41374 L F
.43412 .42143 m .43375 .4209 L .43293 .42073 L F
.43375 .4209 m .43035 .41606 L .43293 .42073 L F
.42848 .4181 m .41512 .41022 L .42843 .41809 L F
.42848 .4181 m .42843 .41809 L .43287 .42071 L F
.43293 .42073 m .42848 .4181 L .43287 .42071 L F
.43866 .42402 m .42884 .4139 L .43412 .42143 L F
.784 .705 .776 r
.43287 .42071 m .42088 .41369 L p .42659 .41768 L F P
0 g
s
.728 .639 .759 r
.48876 .44037 m .48085 .43986 L .48899 .43931 L F
.74 .651 .761 r
.48899 .43931 m .47402 .43617 L p .48138 .43827 L F P
0 g
s
0 .542 .756 r
.48899 .43931 m .48126 .43826 L p .4819 .43834 L F P
0 g
s
0 .511 .806 r
.47853 .43651 m .47411 .43618 L .45958 .432 L F
.47402 .43617 m .45958 .432 L p .47411 .43618 L F P
0 g
s
0 .511 .806 r
.48138 .43827 m .47402 .43617 L .47411 .43618 L F
0 .523 .778 r
.47402 .43617 m .48899 .43931 L p .47411 .43618 L F P
0 g
s
0 .523 .778 r
.47411 .43618 m .46663 .43461 L .47402 .43617 L F
0 .511 .806 r
.47904 .43655 m .45958 .432 L .46188 .43228 L F
.716 .628 .758 r
.50367 .44675 m .50416 .44275 L .49846 .44249 L F
.728 .639 .759 r
.51203 .44243 m .50367 .44675 L .50428 .44179 L F
.092 .65 .744 r
.5355 .44231 m .55103 .44114 L p .53549 .4423 L F P
0 g
s
.092 .65 .744 r
.53549 .4423 m .5277 .44288 L .5355 .44231 L F
.035 .605 .738 r
.5355 .44231 m .51988 .44239 L p .53549 .4423 L F P
0 g
s
.035 .605 .738 r
.54331 .44226 m .5355 .44231 L .53549 .4423 L F
.51988 .44239 m .51203 .44243 L p .51831 .4424 L F P
0 g
s
.035 .605 .738 r
.54331 .44226 m .51988 .44239 L .51989 .44239 L F
.53469 .44211 m .51989 .44239 L .51994 .44237 L F
.54125 .44199 m .53471 .44211 L .53469 .44211 L F
.53471 .44211 m .51989 .44239 L .53469 .44211 L F
.092 .65 .744 r
.55018 .4411 m .53462 .44209 L .55103 .44114 L F
.53462 .44209 m .53471 .44211 L .55103 .44114 L F
0 .542 .756 r
.50432 .44139 m .48899 .43931 L p .50622 .44127 L F P
0 g
s
0 .569 .742 r
.5201 .44231 m .50643 .44126 L .51988 .44239 L F
.50643 .44126 m .50622 .44127 L .51988 .44239 L F
.51988 .44239 m .50622 .44127 L .50436 .44139 L F
0 .523 .778 r
.49027 .43934 m .47904 .43655 L .48899 .43931 L F
.47904 .43655 m .47853 .43651 L .48899 .43931 L F
.48899 .43931 m .47853 .43651 L .47411 .43618 L F
.728 .639 .759 r
.48899 .43931 m .50432 .44139 L p .49657 .44088 L F P
0 g
s
0 .569 .742 r
.50432 .44139 m .51988 .44239 L p .49657 .44088 L F P
0 g
s
0 .542 .756 r
.50643 .44126 m .48899 .43931 L .49027 .43934 L F
.50622 .44127 m .48899 .43931 L .50643 .44126 L F
.49361 .4394 m .50705 .44122 L p .50487 .44098 L F P
0 g
s
0 .542 .756 r
.50487 .44098 m .49027 .43934 L .49361 .4394 L F
.50643 .44126 m .49027 .43934 L .50705 .44122 L F
0 .523 .778 r
.50019 .44078 m .49361 .4394 L p .49643 .44085 L F P
0 g
s
0 .523 .778 r
.49649 .44088 m .49657 .44088 L p .49643 .44085 L F P
0 g
s
0 .523 .778 r
.49657 .44088 m .50019 .44078 L p .49643 .44085 L F P
0 g
s
.728 .639 .759 r
.50432 .44139 m .51203 .44243 L p .50428 .44179 L F P
0 g
s
0 .542 .756 r
.51206 .44242 m .51203 .44243 L .50432 .44139 L p F P
0 g
s
.716 .628 .758 r
.51988 .44239 m .49649 .44088 L p .49846 .44249 L F P
0 g
s
.728 .639 .759 r
.50428 .44179 m .49876 .44133 L .50432 .44139 L F
0 .523 .778 r
.49649 .44088 m .49361 .4394 L .49027 .43934 L F
.48899 .43931 m .49649 .44088 L p .49605 .44077 L F P
0 g
s
.035 .605 .738 r
.53462 .44209 m .51831 .4424 L .5126 .44242 L F
.54125 .44199 m .53469 .44211 L .53462 .44209 L F
.53469 .44211 m .51831 .4424 L .53462 .44209 L F
.092 .65 .744 r
.55018 .4411 m .54797 .441 L .53642 .44191 L F
.55018 .4411 m .53436 .44203 L .53462 .44209 L F
.161 .701 .759 r
.54336 .44226 m .54125 .44199 L .54797 .441 L p F P
0 g
s
.161 .701 .759 r
.54991 .44109 m .54336 .44226 L .54797 .441 L F
.54797 .441 m .56135 .43904 L p .55969 .43934 L F P
0 g
s
.161 .701 .759 r
.55969 .43934 m .54991 .44109 L .54797 .441 L F
.679 .599 .759 r
.55103 .44114 m .56631 .4389 L p .55876 .44055 L F P
0 g
s
.161 .701 .759 r
.56631 .4389 m .54336 .44226 L p .57389 .43777 L F P
0 g
s
.242 .757 .783 r
.55482 .44049 m .55876 .44055 L p .56631 .4389 L F P
0 g
s
.242 .757 .783 r
.55876 .44055 m .55885 .44055 L .56631 .4389 L p F P
0 g
s
.679 .599 .759 r
.56631 .4389 m .56543 .44004 L .55876 .44055 L F
.092 .65 .744 r
.55885 .44055 m .55876 .44055 L .55862 .44056 L F
.666 .591 .761 r
.5675 .44419 m .56655 .43996 L .56121 .44154 L F
.652 .583 .764 r
.58023 .46081 m .57444 .43936 L p .58156 .43677 L F P
0 g
s
.652 .583 .764 r
.58639 .45214 m .58023 .46081 L .58156 .43677 L F
.679 .599 .759 r
.57963 .4586 m .58023 .46081 L .57152 .46207 L p F P
0 g
s
.634 .514 .7 r
.58862 .45963 m .58054 .46248 L .58836 .45839 L F
.666 .591 .761 r
.58836 .45839 m .59685 .45653 L p .58639 .45214 L F P
0 g
s
.666 .591 .761 r
.5887 .43394 m .5812 .4356 L p .59546 .45468 L F P
0 g
s
.666 .591 .761 r
.59685 .45653 m .59607 .45436 L p .59546 .45468 L F P
0 g
s
.666 .591 .761 r
.59607 .45436 m .5887 .43394 L p .59546 .45468 L F P
0 g
s
.666 .591 .761 r
.59685 .45653 m .5812 .4356 L .58639 .45214 L F
.652 .583 .764 r
.60276 .42909 m .61278 .45112 L .60458 .45356 L p F P
0 g
s
.638 .575 .768 r
.5887 .43394 m .59685 .45653 L .60458 .45356 L p F P
0 g
s
.638 .575 .768 r
.5976 .43636 m .5887 .43394 L .60458 .45356 L F
.652 .583 .764 r
.60458 .45356 m .58023 .46081 L p .5976 .43636 L F P
0 g
s
.652 .583 .764 r
.60276 .42909 m .60458 .45356 L .5976 .43636 L F
.623 .568 .772 r
.60276 .42909 m .60916 .42596 L p .61348 .44872 L F P
0 g
s
.52 .917 .87 r
.62814 .41659 m .62841 .41653 L .62194 .41969 L p F P
0 g
s
.623 .568 .772 r
.62841 .41653 m .64059 .43509 L p .63455 .44061 L F P
0 g
s
.623 .568 .772 r
.64059 .43509 m .64189 .43707 L .63455 .44061 L p F P
0 g
s
.592 .557 .784 r
.64796 .4326 m .64189 .43707 L p .64761 .43212 L F P
0 g
s
.592 .557 .784 r
.64245 .43446 m .64647 .43311 L .64189 .43707 L F
.608 .562 .777 r
.65475 .42855 m .63374 .41254 L .64405 .42709 L F
.575 .552 .791 r
.64442 .40455 m .63971 .40892 L p .648 .40891 L F P
0 g
s
.575 .552 .791 r
.648 .40891 m .63971 .40892 L .64925 .41043 L F
.592 .557 .784 r
.62933 .41794 m .62841 .41653 L .63374 .41254 L p F P
0 g
s
.592 .557 .784 r
.63374 .41254 m .64442 .40455 L p .63941 .409 L F P
0 g
s
.606 .953 .892 r
.63374 .41254 m .63971 .40892 L p .63902 .40924 L F P
0 g
s
.557 .548 .799 r
.65384 .39582 m .6619 .38642 L p .65826 .39153 L F P
0 g
s
.742 .982 .911 r
.64937 .39737 m .6329 .40802 L .65384 .39582 L F
.787 .977 .909 r
.6656 .38181 m .66598 .38165 L .6619 .38642 L p F P
0 g
s
.575 .552 .791 r
.67636 .40889 m .65384 .39582 L .6662 .4089 L F
.6709 .41386 m .67636 .40889 L p .6662 .4089 L F P
0 g
s
.557 .548 .799 r
.683 .39636 m .68482 .39793 L .68013 .40329 L p F P
0 g
s
.447 .423 .739 r
.68013 .40329 m .67636 .40889 L p .67774 .40908 L F P
0 g
s
.447 .423 .739 r
.68449 .41001 m .68013 .40329 L .67774 .40908 L F
.539 .544 .809 r
.65861 .3914 m .67636 .40889 L .68013 .40329 L p F P
0 g
s
.514 .451 .723 r
.67723 .4103 m .66013 .42366 L .66032 .42403 L F
.67723 .4103 m .6709 .41386 L .67145 .41481 L F
.69483 .43875 m .67723 .4103 L p .67204 .41451 L F P
0 g
s
.514 .451 .723 r
.68268 .43357 m .67204 .41451 L .66032 .42403 L F
.69483 .43875 m .67204 .41451 L .68268 .43357 L F
.482 .436 .73 r
.70069 .48135 m .68341 .45005 L .68864 .44424 L p F P
0 g
s
.482 .436 .73 r
.7017 .46667 m .70164 .46752 L .68864 .44424 L F
.70164 .46752 m .70069 .48135 L .68864 .44424 L F
.542 .464 .716 r
.67645 .45505 m .68341 .45005 L p .68026 .46241 L F P
0 g
s
.568 .476 .711 r
.67758 .49754 m .68611 .49267 L p .67356 .48871 L F P
0 g
s
.514 .45 .723 r
.67037 .46044 m .68611 .49267 L .69291 .4868 L p F P
0 g
s
.542 .464 .716 r
.68341 .45005 m .70069 .48135 L .69291 .4868 L p F P
0 g
s
.542 .464 .716 r
.68341 .45005 m .69291 .4868 L .68158 .46495 L F
.514 .45 .723 r
.68026 .46241 m .67037 .46044 L .69291 .4868 L F
.542 .464 .716 r
.68341 .45005 m .67758 .49754 L .67356 .48871 L F
.53 .509 .777 r
.71753 .50376 m .70069 .48135 L .70655 .47501 L p F P
0 g
s
.482 .436 .73 r
.70655 .47501 m .70069 .48135 L p .7017 .46667 L F P
0 g
s
.514 .45 .723 r
.70529 .47285 m .68026 .46241 L .68951 .48024 L F
.71348 .46901 m .7017 .46667 L .70529 .47285 L F
.7017 .46667 m .68026 .46241 L .70529 .47285 L F
.70655 .47501 m .71348 .46901 L p .68951 .48024 L F P
0 g
s
.514 .45 .723 r
.71348 .46901 m .68864 .44424 L .70238 .4668 L F
.446 .422 .738 r
.69483 .43875 m .71348 .46901 L .71834 .46226 L p F P
0 g
s
.482 .436 .73 r
.70446 .42663 m .72433 .45577 L .71834 .46226 L p F P
0 g
s
.482 .436 .73 r
.70446 .42663 m .71834 .46226 L .70512 .44181 L F
.446 .422 .738 r
.70358 .43943 m .69483 .43875 L .71834 .46226 L F
.514 .45 .723 r
.70238 .4668 m .68864 .44424 L .70156 .46644 L F
.70238 .4668 m .67645 .45505 L .68026 .46241 L F
.482 .436 .73 r
.70358 .43943 m .70655 .47501 L .7017 .46667 L F
.70446 .42663 m .70512 .44181 L .70358 .43943 L F
.70512 .44181 m .70655 .47501 L .70358 .43943 L F
.446 .422 .738 r
.69913 .43256 m .69483 .43875 L p .70358 .43943 L F P
0 g
s
.514 .451 .723 r
.68379 .43594 m .66032 .42403 L .66388 .43087 L F
.69483 .43875 m .68232 .43341 L .68379 .43594 L F
.68232 .43341 m .66032 .42403 L .68379 .43594 L F
.483 .437 .73 r
.68864 .44424 m .68341 .45005 L p .68379 .43594 L F P
0 g
s
.514 .451 .723 r
.65475 .42855 m .67037 .46044 L .69483 .43875 L p F P
0 g
s
.447 .423 .739 r
.67636 .40889 m .69483 .43875 L .69913 .43256 L p F P
0 g
s
.483 .437 .73 r
.68482 .39793 m .70446 .42663 L .69913 .43256 L p F P
0 g
s
.483 .437 .73 r
.68482 .39793 m .69913 .43256 L .68601 .41234 L F
.447 .423 .739 r
.68449 .41001 m .67636 .40889 L .69913 .43256 L F
.483 .437 .73 r
.68482 .39793 m .68864 .44424 L .68379 .43594 L F
.446 .422 .738 r
.73307 .44175 m .71218 .41382 L .70778 .42014 L p F P
0 g
s
.406 .407 .748 r
.70446 .42663 m .68482 .39793 L .68743 .39262 L p F P
0 g
s
.406 .407 .748 r
.68902 .39477 m .70446 .42663 L .68743 .39262 L F
.70229 .41246 m .70446 .42663 L .68771 .39206 L F
.482 .436 .73 r
.68864 .44424 m .69913 .43256 L p .7017 .46667 L F P
0 g
s
.482 .436 .73 r
.69913 .43256 m .70446 .42663 L p .70358 .43943 L F P
0 g
s
.482 .436 .73 r
.70358 .43943 m .7017 .46667 L .69913 .43256 L F
.405 .406 .747 r
.72433 .45577 m .70446 .42663 L .70778 .42014 L p F P
0 g
s
.446 .422 .738 r
.72144 .4386 m .70778 .42014 L .72081 .43843 L F
.73307 .44175 m .70778 .42014 L .72144 .4386 L F
.447 .423 .739 r
.70778 .42014 m .71218 .41382 L p .70229 .41246 L F P
0 g
s
.405 .406 .747 r
.72259 .44093 m .72433 .45577 L .70778 .42014 L F
.446 .422 .738 r
.72259 .44093 m .69913 .43256 L .70358 .43943 L F
.73307 .44175 m .72081 .43843 L .72259 .44093 L F
.72081 .43843 m .69913 .43256 L .72259 .44093 L F
.405 .406 .747 r
.7281 .44867 m .72433 .45577 L p .72259 .44093 L F P
0 g
s
.446 .422 .738 r
.73307 .44175 m .70358 .43943 L .71437 .45611 L F
.71834 .46226 m .7281 .44867 L p .71437 .45611 L F P
0 g
s
.446 .422 .738 r
.7281 .44867 m .73307 .44175 L p .71437 .45611 L F P
0 g
s
.479 .496 .798 r
.74376 .47603 m .72433 .45577 L .7281 .44867 L p F P
0 g
s
.506 .502 .787 r
.75353 .4608 m .73307 .44175 L .7281 .44867 L p F P
0 g
s
.479 .496 .798 r
.74264 .46303 m .74376 .47603 L .7281 .44867 L F
.506 .502 .787 r
.71834 .46226 m .71348 .46901 L p .72272 .46712 L F P
0 g
s
.553 .516 .768 r
.7317 .49039 m .71348 .46901 L .70655 .47501 L p F P
0 g
s
.53 .509 .777 r
.71933 .49101 m .71753 .50376 L .70655 .47501 L F
.553 .516 .768 r
.69291 .4868 m .68611 .49267 L p .69666 .49215 L F P
0 g
s
.574 .523 .761 r
.68363 .52705 m .66994 .50289 L .67758 .49754 L p F P
0 g
s
.574 .523 .761 r
.6869 .51284 m .68363 .52705 L .67758 .49754 L F
.593 .531 .754 r
.70144 .51601 m .68611 .49267 L .67758 .49754 L p F P
0 g
s
.593 .531 .754 r
.70144 .51601 m .67758 .49754 L .68816 .5149 L F
.553 .516 .768 r
.68611 .49267 m .70144 .51601 L .70894 .50966 L p F P
0 g
s
.574 .523 .761 r
.70069 .48135 m .71753 .50376 L .70894 .50966 L p F P
0 g
s
.553 .516 .768 r
.69666 .49215 m .68611 .49267 L .70894 .50966 L F
.593 .531 .754 r
.69204 .52127 m .70144 .51601 L p .68816 .5149 L F P
0 g
s
.546 .922 .782 r
.75227 .51213 m .73104 .52645 L p .74181 .51702 L F P
0 g
s
.546 .922 .782 r
.73104 .52645 m .72049 .53356 L p .72779 .5279 L F P
0 g
s
.546 .922 .782 r
.74181 .51702 m .73104 .52645 L .72779 .5279 L F
.426 .855 .724 r
.7428 .51997 m .7313 .52517 L p .71982 .53146 L F P
0 g
s
.301 .773 .66 r
.70792 .53919 m .68315 .55028 L p .70052 .5424 L F P
0 g
s
.301 .773 .66 r
.69963 .54278 m .68315 .55028 L .6807 .55134 L F
.70881 .53864 m .70052 .5424 L .69963 .54278 L F
.70052 .5424 m .68315 .55028 L .69963 .54278 L F
.426 .855 .724 r
.72779 .5279 m .71982 .53146 L .69736 .54377 L F
.72779 .5279 m .69736 .54377 L .69963 .54278 L F
0 0 0 r
.6738 .55431 m .64926 .56309 L p .6799 .55168 L F P
0 g
s
.301 .773 .66 r
.6738 .55431 m .69702 .54391 L p .6807 .55134 L F P
0 g
s
.426 .855 .724 r
.7313 .52517 m .69702 .54391 L .69736 .54377 L F
.301 .773 .66 r
.69702 .54391 m .70881 .53864 L p .69963 .54278 L F P
0 g
s
.301 .773 .66 r
.69963 .54278 m .6807 .55134 L .69702 .54391 L F
.426 .855 .724 r
.71867 .53197 m .69702 .54391 L p .7313 .52517 L F P
0 g
s
.426 .855 .724 r
.69702 .54391 m .68625 .54986 L p .69736 .54377 L F P
0 g
s
.426 .855 .724 r
.69963 .54278 m .69736 .54377 L .68625 .54986 L F
.7428 .51997 m .71982 .53146 L .72779 .5279 L F
.7313 .52517 m .72968 .5259 L .71867 .53197 L p F P
0 g
s
0 0 0 r
.65701 .55963 m .62973 .56721 L p .65175 .56198 L F P
0 g
s
.57 .91 .973 r
.67331 .55424 m .64361 .56178 L .64805 .56281 L F
.67122 .55396 m .64307 .56165 L .67331 .55424 L F
0 0 0 r
.62362 .5702 m .63007 .56751 L p .62812 .56799 L F P
0 g
s
.029 0 0 r
.62362 .5702 m .59713 .5756 L p .6276 .56825 L F P
0 g
s
.112 0 0 r
.59819 .57497 m .57276 .57686 L .57204 .57749 L F
.59855 .57475 m .57276 .57686 L .59819 .57497 L F
.029 0 0 r
.60156 .57296 m .60974 .57129 L p .59844 .57483 L F P
0 g
s
.112 0 0 r
.60156 .57296 m .57276 .57686 L p .59855 .57475 L F P
0 g
s
.426 .841 .966 r
.59397 .57377 m .59652 .57525 L .57003 .57927 L F
.59713 .5756 m .57003 .57927 L p .59652 .57525 L F P
0 g
s
.521 .89 .971 r
.64307 .56165 m .62362 .5702 L .62193 .56958 L F
.64373 .56181 m .62362 .5702 L .64307 .56165 L F
.64373 .56181 m .64819 .56284 L .62362 .5702 L F
0 0 0 r
.64926 .56309 m .63701 .56747 L p .65111 .56226 L F P
0 g
s
0 0 0 r
.63787 .56708 m .64397 .5643 L p .63919 .56661 L F P
0 g
s
.521 .89 .971 r
.64926 .56309 m .62362 .5702 L p .64819 .56284 L F P
0 g
s
.57 .91 .973 r
.64926 .56309 m .6738 .55431 L p .64805 .56281 L F P
0 g
s
.57 .91 .973 r
.67331 .55424 m .64805 .56281 L .6738 .55431 L F
.64307 .56165 m .64361 .56178 L .67331 .55424 L F
.66 .933 .969 r
.69702 .54391 m .71867 .53197 L p .68927 .54349 L F P
0 g
s
.66 .933 .969 r
.71526 .53202 m .68834 .54344 L .71867 .53197 L F
.68834 .54344 m .68927 .54349 L .71867 .53197 L F
.617 .924 .972 r
.68834 .54344 m .67122 .55396 L .68563 .54329 L F
.67122 .55396 m .67038 .55385 L .68563 .54329 L F
.662 .685 .861 r
.63454 .55136 m .62195 .55213 L .63524 .55241 L F
.617 .924 .972 r
.68483 .54385 m .67038 .55385 L .66437 .55304 L F
.67499 .54817 m .66437 .55304 L .66402 .553 L F
.68483 .54385 m .66437 .55304 L .67499 .54817 L F
.642 .682 .872 r
.70144 .51601 m .71517 .52591 L p .72353 .51923 L F P
0 g
s
.642 .682 .872 r
.71253 .51202 m .70144 .51601 L .72353 .51923 L F
.698 .936 .964 r
.72468 .51961 m .71526 .53202 L .70622 .53214 L F
.71517 .52591 m .70622 .53214 L .70576 .53214 L F
.72468 .51961 m .70622 .53214 L .71517 .52591 L F
.72758 .51939 m .71526 .53202 L .72468 .51961 L F
.729 .934 .956 r
.73852 .51856 m .75632 .50378 L p .72758 .51939 L F P
0 g
s
.729 .934 .956 r
.75218 .50434 m .72758 .51939 L .75632 .50378 L F
.736 .992 .855 r
.78807 .47915 m .77137 .49632 L p .77573 .48569 L F P
0 g
s
.736 .992 .855 r
.77573 .48569 m .77137 .49632 L .76741 .49828 L F
.652 .968 .826 r
.75227 .51213 m .7811 .48826 L p .74181 .51702 L F P
0 g
s
.736 .992 .855 r
.77137 .49632 m .76309 .50483 L p .76741 .49828 L F P
0 g
s
.652 .968 .826 r
.76741 .49828 m .73852 .51856 L .74181 .51702 L F
.7811 .48826 m .76612 .49892 L .76741 .49828 L F
.76612 .49892 m .73852 .51856 L .76741 .49828 L F
.755 .927 .945 r
.77185 .48774 m .75632 .50378 L p .76035 .48994 L F P
0 g
s
.775 .915 .933 r
.77185 .48774 m .78488 .47058 L p .75898 .4902 L F P
0 g
s
.775 .915 .933 r
.78014 .47175 m .75898 .4902 L .78488 .47058 L F
.789 .901 .921 r
.79521 .45243 m .78488 .47058 L p .78238 .45635 L F P
0 g
s
.799 .885 .908 r
.79521 .45243 m .80263 .43348 L p .78084 .45682 L F P
0 g
s
.799 .885 .908 r
.79745 .43537 m .78084 .45682 L .80263 .43348 L F
.805 .868 .894 r
.80696 .41391 m .80263 .43348 L p .7933 .41979 L F P
0 g
s
.807 .85 .882 r
.80696 .41391 m .80807 .39393 L p .79167 .42049 L F P
0 g
s
.807 .85 .882 r
.80268 .39662 m .79167 .42049 L .80807 .39393 L F
.804 .813 .859 r
.79478 .35722 m .78069 .36652 L .78617 .38507 L F
.78069 .36652 m .77997 .367 L .78308 .37607 L F
.78069 .36652 m .78308 .37607 L .78617 .38507 L F
.615 .696 .902 r
.76291 .37715 m .78308 .37607 L p .78455 .38551 L F P
0 g
s
.615 .696 .902 r
.76291 .37715 m .78455 .38551 L .7691 .38577 L F
.611 .705 .912 r
.76291 .37715 m .75887 .3689 L p .78293 .37563 L F P
0 g
s
.611 .705 .912 r
.78308 .37607 m .76291 .37715 L p .78293 .37563 L F P
0 g
s
.611 .705 .912 r
.77249 .36767 m .78427 .376 L .75887 .3689 L F
.609 .71 .916 r
.75722 .35119 m .75621 .36026 L .77129 .34883 L F
.75352 .32407 m .75415 .33258 L .75943 .33125 L F
.794 .779 .839 r
.77331 .31914 m .76011 .33066 L .772 .3483 L F
.76011 .33066 m .75943 .33125 L .76573 .3398 L F
.76011 .33066 m .76573 .3398 L .772 .3483 L F
.611 .705 .912 r
.74659 .3438 m .76573 .3398 L p .77043 .34898 L F P
0 g
s
.611 .705 .912 r
.74659 .3438 m .77043 .34898 L .75556 .35147 L F
.609 .716 .921 r
.75415 .33258 m .75943 .33125 L .76467 .33836 L F
.609 .721 .925 r
.73021 .31942 m .73409 .32802 L .73172 .3189 L F
.609 .716 .921 r
.76686 .33956 m .74659 .3438 L .7397 .33621 L p F P
0 g
s
.184 .468 .889 r
.73446 .34976 m .75528 .35981 L p .75005 .35196 L F P
0 g
s
.184 .468 .889 r
.73809 .34648 m .73446 .34976 L .75005 .35196 L F
.24 .471 .88 r
.72558 .33479 m .74659 .3438 L .75073 .35228 L p F P
0 g
s
.24 .471 .88 r
.72558 .33479 m .75073 .35228 L .73437 .34477 L F
.124 .465 .891 r
.74659 .3438 m .72558 .33479 L .71928 .32789 L p F P
0 g
s
0 .194 .719 r
.71246 .33028 m .72766 .34374 L p .72439 .33811 L F P
0 g
s
0 .194 .719 r
.71284 .32804 m .71246 .33028 L .72439 .33811 L F
0 .243 .758 r
.7407 .36515 m .71821 .3442 L .71478 .33739 L p F P
0 g
s
0 .243 .758 r
.72897 .35035 m .7407 .36515 L .71478 .33739 L F
.049 .284 .776 r
.73112 .35199 m .71478 .33739 L .73075 .35197 L F
.73446 .34976 m .71478 .33739 L .73112 .35199 L F
0 .243 .758 r
.70788 .32372 m .70438 .31677 L p .71284 .32804 L F P
0 g
s
0 .246 .76 r
.6837 .2993 m .70438 .31677 L .70788 .32372 L p F P
0 g
s
0 .145 .657 r
.70438 .31677 m .6837 .2993 L .67909 .29428 L p F P
0 g
s
.34 .563 .919 r
.65589 .28443 m .65961 .28966 L p .67309 .28795 L F P
0 g
s
.34 .563 .919 r
.67441 .28778 m .67262 .28746 L p .67309 .28795 L F P
0 g
s
.34 .563 .919 r
.67262 .28746 m .65589 .28443 L p .67309 .28795 L F P
0 g
s
.817 .752 .791 r
.66412 .29452 m .66373 .29494 L p .66364 .29482 L F P
0 g
s
.838 .794 .81 r
.65397 .31289 m .66665 .30027 L .67242 .3108 L F
.828 .772 .8 r
.65468 .29522 m .65253 .31433 L .65961 .28966 L F
.838 .794 .81 r
.65253 .31433 m .67242 .3108 L .66717 .31545 L F
.65397 .31289 m .67242 .3108 L .65253 .31433 L F
.846 .818 .821 r
.66717 .31545 m .65537 .32588 L .65666 .33723 L F
.66717 .31545 m .65666 .33723 L .66108 .33374 L F
.451 .542 .859 r
.67978 .34886 m .67938 .34462 L .67851 .34967 L F
.475 .541 .844 r
.67843 .34409 m .67925 .33848 L p .6832 .3467 L F P
0 g
s
.451 .542 .859 r
.67827 .33291 m .67843 .34409 L p .67882 .33876 L F P
0 g
s
.852 .919 .876 r
.67141 .37156 m .67181 .37137 L .67347 .36598 L p F P
0 g
s
.519 .542 .82 r
.68482 .39793 m .683 .39636 L p .68419 .39528 L F P
0 g
s
.406 .407 .748 r
.68743 .39262 m .68771 .39206 L p .68902 .39477 L F P
0 g
s
.483 .437 .73 r
.68013 .40329 m .68482 .39793 L p .68449 .41001 L F P
0 g
s
.539 .544 .809 r
.68771 .39206 m .69156 .38637 L p .68241 .38776 L F P
0 g
s
.539 .544 .809 r
.69156 .38637 m .67316 .3724 L p .66935 .37715 L F P
0 g
s
.519 .542 .82 r
.66946 .37724 m .68419 .39528 L .66727 .38277 L F
.68241 .38776 m .68419 .39528 L .66946 .37724 L F
.683 .39636 m .66727 .38277 L p .68419 .39528 L F P
0 g
s
.519 .542 .82 r
.66727 .38277 m .66598 .38165 L .66847 .37643 L p F P
0 g
s
.539 .544 .809 r
.67316 .3724 m .67181 .37137 L .66847 .37643 L p F P
0 g
s
.539 .544 .809 r
.67316 .3724 m .66847 .37643 L .66935 .37715 L F
.519 .542 .82 r
.66847 .37643 m .67347 .36598 L p .67141 .37156 L F P
0 g
s
.82 .963 .901 r
.66837 .37648 m .64955 .3913 L .66162 .38652 L F
.6671 .37705 m .64955 .3913 L .66837 .37648 L F
.841 .943 .889 r
.67347 .36598 m .66847 .37643 L p .66034 .37259 L F P
0 g
s
.841 .943 .889 r
.65885 .37334 m .66847 .37643 L .66344 .37869 L F
.852 .919 .876 r
.67142 .3582 m .65885 .37334 L .67681 .35516 L F
.65885 .37334 m .66034 .37259 L .67681 .35516 L F
.857 .868 .847 r
.67843 .34409 m .67827 .33291 L p .66315 .35373 L F P
0 g
s
.853 .842 .834 r
.66108 .33374 m .67599 .32198 L .67816 .33298 L F
.66108 .33374 m .67816 .33298 L .67664 .33405 L F
.857 .868 .847 r
.67276 .33679 m .66315 .35373 L .67827 .33291 L F
.853 .842 .834 r
.67276 .33679 m .67838 .33409 L .67878 .33836 L F
.66108 .33374 m .67664 .33405 L .67276 .33679 L F
.67664 .33405 m .67838 .33409 L .67276 .33679 L F
.6763 .32174 m .67925 .33848 L p .67599 .32198 L F P
0 g
s
.846 .818 .821 r
.67776 .32755 m .67818 .32723 L .6763 .32174 L p F P
0 g
s
.857 .868 .847 r
.67818 .32723 m .67776 .32755 L p .67777 .32765 L F P
0 g
s
.425 .545 .874 r
.67925 .33848 m .67827 .33291 L p .68066 .33909 L F P
0 g
s
.425 .545 .874 r
.67827 .33291 m .6763 .32174 L p .67776 .32755 L F P
0 g
s
.857 .868 .847 r
.67827 .33291 m .67818 .32723 L p .67276 .33679 L F P
0 g
s
.425 .545 .874 r
.67776 .32755 m .68066 .33909 L .67827 .33291 L F
.857 .868 .847 r
.65846 .34687 m .65871 .35653 L p .66062 .34535 L F P
0 g
s
.852 .919 .876 r
.65676 .37314 m .65702 .37026 L .65458 .37549 L F
.6574 .36611 m .65458 .37549 L p .65702 .37026 L F P
0 g
s
.841 .943 .889 r
.65031 .38456 m .65458 .37549 L p .65345 .37956 L F P
0 g
s
.841 .943 .889 r
.65573 .3759 m .66344 .37869 L .65031 .38456 L F
.82 .963 .901 r
.66344 .37869 m .64855 .39169 L .6671 .37705 L F
.592 .557 .784 r
.64442 .40455 m .64982 .40051 L p .648 .40891 L F P
0 g
s
.681 .974 .906 r
.64949 .40062 m .64982 .40051 L .64442 .40455 L p F P
0 g
s
.575 .552 .791 r
.64569 .40481 m .64949 .40062 L .64442 .40455 L F
.65384 .39582 m .64442 .40455 L p .64949 .40062 L F P
0 g
s
.787 .977 .909 r
.64937 .39737 m .65384 .39582 L .64979 .40029 L F
.64855 .39169 m .65384 .39582 L .64937 .39737 L F
.64992 .39115 m .65384 .39582 L .64855 .39169 L F
.64296 .3961 m .64937 .39737 L .63946 .40081 L F
.6377 .40142 m .64466 .39323 L p .63946 .40081 L F P
0 g
s
.798 .85 .395 r
.65318 .38017 m .65458 .37549 L p .65403 .3768 L F P
0 g
s
.82 .963 .901 r
.65318 .38017 m .65031 .38456 L p .65239 .38328 L F P
0 g
s
.841 .943 .889 r
.65885 .37334 m .66344 .37869 L .65458 .37549 L F
.66034 .37259 m .66847 .37643 L .65885 .37334 L F
.82 .963 .901 r
.67126 .37182 m .65279 .38305 L .64713 .39124 L F
.65279 .38305 m .64844 .3885 L .64713 .39124 L F
.65031 .38456 m .64466 .39323 L p .64713 .39124 L F P
0 g
s
.82 .963 .901 r
.67121 .3719 m .64466 .39323 L .64855 .39169 L F
.67181 .37137 m .67126 .37182 L .67121 .3719 L F
.67126 .37182 m .64466 .39323 L .67121 .3719 L F
.519 .542 .82 r
.67347 .36598 m .67601 .36068 L p .67381 .36622 L F P
0 g
s
.497 .541 .831 r
.67347 .36598 m .67181 .37137 L p .67803 .36923 L F P
0 g
s
.519 .542 .82 r
.67601 .36068 m .67656 .36302 L .67226 .37015 L F
.539 .544 .809 r
.69156 .38637 m .66935 .37715 L .68072 .38638 L F
.557 .548 .799 r
.66598 .38165 m .683 .39636 L p .68013 .40329 L F P
0 g
s
.557 .548 .799 r
.66598 .38165 m .68013 .40329 L .6675 .3916 L F
.539 .544 .809 r
.66605 .39026 m .65861 .3914 L .68013 .40329 L F
.557 .548 .799 r
.66598 .38165 m .6709 .41386 L .6662 .4089 L F
.787 .977 .909 r
.64528 .39299 m .63946 .40081 L .64466 .39323 L F
.6484 .39061 m .64937 .39737 L .64296 .3961 L F
.64992 .39115 m .66165 .38651 L .65384 .39582 L F
.539 .544 .809 r
.66847 .37643 m .6619 .38642 L p .6656 .38181 L F P
0 g
s
.841 .943 .889 r
.66847 .37643 m .66598 .38165 L p .6658 .38144 L F P
0 g
s
.82 .963 .901 r
.65279 .38305 m .65031 .38456 L .64844 .3885 L F
.64855 .39169 m .64955 .3913 L .6671 .37705 L F
.787 .977 .909 r
.6619 .38642 m .65384 .39582 L p .66165 .38651 L F P
0 g
s
.82 .963 .901 r
.6619 .38642 m .67181 .37137 L p .66162 .38652 L F P
0 g
s
.787 .977 .909 r
.6656 .38181 m .6619 .38642 L .66165 .38651 L F
.82 .963 .901 r
.66162 .38652 m .65826 .39153 L .6619 .38642 L F
.841 .943 .889 r
.64818 .38909 m .65031 .38456 L p .66565 .38171 L F P
0 g
s
.841 .943 .889 r
.66598 .38165 m .6656 .38181 L p .66565 .38171 L F P
0 g
s
.841 .943 .889 r
.6656 .38181 m .64818 .38909 L p .66565 .38171 L F P
0 g
s
.82 .963 .901 r
.67181 .37137 m .67136 .37165 L .67126 .37182 L F
.67181 .37137 m .65318 .38017 L p .65239 .38328 L F P
0 g
s
.82 .963 .901 r
.67181 .37137 m .67121 .3719 L .66906 .37546 L F
.519 .542 .82 r
.67226 .37015 m .66727 .38277 L .67141 .37156 L F
.841 .943 .889 r
.66344 .37869 m .66598 .38165 L .65031 .38456 L F
.519 .542 .82 r
.66935 .37715 m .66727 .38277 L .66847 .37643 L F
.539 .544 .809 r
.68072 .38638 m .66935 .37715 L .6656 .38181 L F
.66314 .38641 m .6656 .38181 L .6619 .38642 L F
.742 .982 .911 r
.65818 .3916 m .64183 .39757 L .63972 .40045 L F
.65861 .3914 m .65826 .39153 L p .65818 .3916 L F P
0 g
s
.742 .982 .911 r
.65826 .39153 m .64183 .39757 L p .65818 .3916 L F P
0 g
s
.742 .982 .911 r
.65861 .3914 m .6377 .40142 L .64937 .39737 L F
.557 .548 .799 r
.66273 .38718 m .6662 .4089 L .65384 .39582 L F
.666 .38401 m .66605 .39026 L .66273 .38718 L F
.66605 .39026 m .6662 .4089 L .66273 .38718 L F
.539 .544 .809 r
.68072 .38638 m .6656 .38181 L .66314 .38641 L F
.66935 .37715 m .66847 .37643 L .6656 .38181 L F
.841 .943 .889 r
.66344 .37869 m .66847 .37643 L .6658 .38144 L F
.539 .544 .809 r
.69156 .38637 m .6619 .38642 L .66605 .39026 L F
.497 .541 .831 r
.67181 .37137 m .68965 .38492 L p .69351 .38028 L F P
0 g
s
.497 .541 .831 r
.68965 .38492 m .69156 .38637 L .69351 .38028 L p F P
0 g
s
.519 .542 .82 r
.68771 .39206 m .68482 .39793 L p .68241 .38776 L F P
0 g
s
.447 .423 .739 r
.71218 .41382 m .69253 .38766 L p .68834 .39295 L F P
0 g
s
.447 .423 .739 r
.70053 .41 m .68834 .39295 L .68013 .40329 L F
.71218 .41382 m .68834 .39295 L .70053 .41 L F
.71218 .41382 m .68013 .40329 L .68449 .41001 L F
.358 .39 .758 r
.69156 .38637 m .71218 .41382 L .71445 .40708 L p F P
0 g
s
.406 .407 .748 r
.69646 .3743 m .71785 .40044 L .71445 .40708 L p F P
0 g
s
.406 .407 .748 r
.69646 .3743 m .71445 .40708 L .69998 .38856 L F
.358 .39 .758 r
.69831 .38643 m .69156 .38637 L .71445 .40708 L F
.406 .407 .748 r
.69831 .38643 m .70778 .42014 L .70229 .41246 L F
.69646 .3743 m .69998 .38856 L .69831 .38643 L F
.69998 .38856 m .70778 .42014 L .69831 .38643 L F
.69351 .38028 m .69646 .3743 L p .69678 .37637 L F P
0 g
s
.358 .39 .758 r
.69351 .38028 m .69156 .38637 L p .69831 .38643 L F P
0 g
s
.406 .407 .748 r
.69678 .37637 m .70229 .41246 L .69351 .38028 L F
.497 .541 .831 r
.67803 .36923 m .67181 .37137 L .69351 .38028 L F
.519 .542 .82 r
.67601 .36068 m .69646 .3743 L .68771 .39206 L p F P
0 g
s
.475 .541 .844 r
.67601 .36068 m .67681 .35516 L p .69508 .372 L F P
0 g
s
.475 .541 .844 r
.68994 .36338 m .69508 .372 L .67681 .35516 L F
.69646 .3743 m .69448 .37299 L p .69508 .372 L F P
0 g
s
.475 .541 .844 r
.69448 .37299 m .67601 .36068 L p .69508 .372 L F P
0 g
s
.519 .542 .82 r
.67601 .36068 m .68771 .39206 L .68241 .38776 L F
.497 .541 .831 r
.67851 .34967 m .67681 .35516 L p .69742 .36127 L F P
0 g
s
.497 .541 .831 r
.69944 .36187 m .69742 .36069 L p .69742 .36127 L F P
0 g
s
.497 .541 .831 r
.69742 .36069 m .67851 .34967 L p .69742 .36127 L F P
0 g
s
.497 .541 .831 r
.69944 .36187 m .67681 .35516 L .68994 .36338 L F
.69744 .36808 m .69944 .36187 L p .69176 .36452 L F P
0 g
s
.299 .369 .767 r
.73955 .42708 m .71785 .40044 L .71903 .39353 L p F P
0 g
s
.358 .39 .758 r
.72136 .38664 m .70047 .36304 L p .69833 .36834 L F P
0 g
s
.358 .39 .758 r
.72136 .38664 m .69833 .36834 L .69987 .37021 L F
.72136 .38664 m .69812 .36887 L .71123 .38433 L F
.3 .37 .767 r
.71785 .40044 m .69747 .37554 L p .69806 .36949 L F P
0 g
s
.3 .37 .767 r
.69812 .36887 m .69962 .37127 L .69806 .36949 L F
.69962 .37127 m .71785 .40044 L .69806 .36949 L F
.356 .388 .757 r
.74365 .41192 m .72136 .38664 L .71903 .39353 L p F P
0 g
s
.356 .388 .757 r
.73551 .41241 m .71903 .39353 L .73501 .41244 L F
.74365 .41192 m .71903 .39353 L .73551 .41241 L F
.3 .37 .767 r
.71123 .38433 m .71785 .40044 L .69812 .36887 L F
.358 .39 .758 r
.72136 .38664 m .71153 .38439 L .71331 .38656 L F
.3 .37 .767 r
.71903 .39353 m .71785 .40044 L p .71312 .38656 L F P
0 g
s
.3 .37 .767 r
.71312 .38656 m .71785 .40044 L .71123 .38433 L F
.358 .39 .758 r
.71445 .40708 m .71903 .39353 L p .69831 .38643 L F P
0 g
s
.358 .39 .758 r
.71903 .39353 m .72136 .38664 L p .71312 .38656 L F P
0 g
s
.358 .39 .758 r
.71312 .38656 m .69831 .38643 L .71903 .39353 L F
.71153 .38439 m .69351 .38028 L .71331 .38656 L F
.232 .347 .776 r
.7216 .35835 m .69942 .35557 L .70029 .36174 L F
.70445 .36108 m .69944 .36187 L .70621 .36299 L F
.3 .37 .767 r
.70445 .36108 m .71312 .38656 L .69942 .35557 L F
.71312 .38656 m .71123 .38433 L .69942 .35557 L F
.72142 .37962 m .71903 .39353 L p .70445 .36108 L F P
0 g
s
.358 .39 .758 r
.71331 .38656 m .71306 .38648 L .71312 .38656 L F
.3 .37 .767 r
.70445 .36108 m .71903 .39353 L .71312 .38656 L F
.358 .39 .758 r
.71312 .38656 m .69351 .38028 L .69831 .38643 L F
.71306 .38648 m .69351 .38028 L .71312 .38656 L F
.299 .369 .767 r
.72142 .37962 m .72264 .37255 L p .72659 .3853 L F P
0 g
s
.15 .32 .781 r
.72154 .36552 m .72264 .37255 L p .71546 .35932 L F P
0 g
s
.148 .318 .78 r
.73601 .38036 m .73648 .38118 L .72154 .36552 L F
.73648 .38118 m .74526 .39643 L .72154 .36552 L F
0 .243 .758 r
.73092 .35212 m .7407 .36515 L .72897 .35035 L F
.148 .318 .78 r
.71821 .3442 m .7407 .36515 L .74186 .37309 L p F P
0 g
s
.049 .284 .776 r
.7216 .35835 m .73729 .37385 L p .7366 .36803 L F P
0 g
s
.049 .284 .776 r
.72453 .35639 m .7216 .35835 L .7366 .36803 L F
.148 .318 .78 r
.71821 .3442 m .74186 .37309 L .72453 .35639 L F
.049 .284 .776 r
.73729 .37385 m .74429 .38077 L .74186 .37309 L p F P
0 g
s
.049 .284 .776 r
.73446 .34976 m .73092 .35212 L .73519 .35602 L F
0 .243 .758 r
.73695 .35763 m .7407 .36515 L p .73092 .35212 L F P
0 g
s
.049 .284 .776 r
.73695 .35763 m .73446 .34976 L p .73729 .37385 L F P
0 g
s
0 .194 .719 r
.71284 .32804 m .70788 .32372 L .71283 .32809 L F
0 .243 .758 r
.70438 .31677 m .72558 .33479 L .72942 .3425 L p F P
0 g
s
0 .243 .758 r
.70438 .31677 m .72942 .3425 L .71456 .32954 L F
.049 .284 .776 r
.73112 .35199 m .73075 .35197 L .73092 .35212 L F
0 .243 .758 r
.70438 .31677 m .73695 .35763 L .73092 .35212 L F
0 .141 .653 r
.72558 .33479 m .70438 .31677 L .69868 .31054 L p F P
0 g
s
0 .194 .719 r
.71412 .32046 m .71186 .32164 L .71366 .32316 L F
.71412 .32046 m .694 .30385 L .69868 .31054 L p F P
0 g
s
0 .141 .653 r
.71366 .32316 m .72558 .33479 L .69868 .31054 L F
0 .145 .657 r
.69342 .30618 m .70438 .31677 L .67909 .29428 L F
.828 .772 .8 r
.65253 .31433 m .654 .31287 L .65961 .28966 L F
.846 .818 .821 r
.6763 .32174 m .67252 .31071 L p .66263 .33252 L F P
0 g
s
.838 .794 .81 r
.66694 .29997 m .67252 .31071 L p .66665 .30027 L F P
0 g
s
.857 .868 .847 r
.67276 .33679 m .66062 .34535 L .65871 .35653 L F
.67276 .33679 m .65871 .35653 L .66315 .35373 L F
.853 .842 .834 r
.66265 .34951 m .65937 .35168 L .65666 .33723 L p F P
0 g
s
.991 .879 .612 r
.65666 .33723 m .65846 .34687 L p .65791 .34824 L F P
0 g
s
.978 .906 .573 r
.65871 .35653 m .65846 .34687 L p .64568 .38735 L F P
0 g
s
.606 .953 .892 r
.63001 .41349 m .62172 .41561 L .61579 .41896 L F
.61256 .42111 m .61579 .41896 L .60998 .42224 L F
.63001 .41349 m .61579 .41896 L .61256 .42111 L F
.62025 .41599 m .60998 .42224 L p .62172 .41561 L F P
0 g
s
.606 .953 .892 r
.63001 .41349 m .60998 .42224 L .61269 .42166 L F
.681 .974 .906 r
.62953 .40903 m .62938 .41 L .62393 .41375 L F
.606 .953 .892 r
.62194 .41969 m .63374 .41254 L p .61363 .42146 L F P
0 g
s
.426 .87 .842 r
.60916 .42596 m .58955 .43203 L .59541 .43129 L F
.59553 .43127 m .60916 .42596 L p .59541 .43129 L F P
0 g
s
.242 .757 .783 r
.57931 .43575 m .5783 .43614 L .5812 .4356 L F
.332 .815 .812 r
.59553 .43127 m .5812 .4356 L p .58887 .43212 L F P
0 g
s
.332 .815 .812 r
.5812 .4356 m .57401 .43777 L p .57931 .43575 L F P
0 g
s
.332 .815 .812 r
.58887 .43212 m .5812 .4356 L .57931 .43575 L F
.57931 .43575 m .57871 .4358 L .58691 .43237 L F
.161 .701 .759 r
.56248 .43901 m .54336 .44226 L .56135 .43904 L F
.56248 .43901 m .54948 .44136 L .54384 .44218 L F
.242 .757 .783 r
.57931 .43575 m .57513 .43609 L .55482 .44049 L F
.57841 .43593 m .56248 .43901 L .57761 .43626 L F
.56248 .43901 m .56287 .439 L .57761 .43626 L F
.332 .815 .812 r
.58098 .43485 m .57427 .43766 L .5681 .43805 L F
.242 .757 .783 r
.57513 .43609 m .57438 .43615 L .56818 .43758 L F
.56135 .43904 m .55482 .44049 L p .57513 .43609 L F P
0 g
s
.332 .815 .812 r
.58691 .43237 m .58098 .43485 L .57198 .43708 L F
.5681 .43805 m .58691 .43237 L p .57198 .43708 L F P
0 g
s
.242 .757 .783 r
.58095 .4347 m .57438 .43615 L p .57577 .43594 L F P
0 g
s
.652 .583 .764 r
.59553 .43127 m .60276 .42909 L p .59568 .43166 L F P
0 g
s
.638 .575 .768 r
.60916 .42596 m .59553 .43127 L p .60256 .42912 L F P
0 g
s
.426 .87 .842 r
.6063 .42644 m .58095 .4347 L .60916 .42596 L F
.52 .917 .87 r
.60931 .42287 m .60539 .4266 L .59995 .42752 L F
.605 .42486 m .59995 .42752 L .59882 .42771 L F
.60931 .42287 m .59995 .42752 L .605 .42486 L F
.426 .87 .842 r
.60483 .42537 m .59882 .42771 L p .60049 .42728 L F P
0 g
s
.426 .87 .842 r
.6063 .42644 m .59995 .42752 L .59227 .43042 L F
.332 .815 .812 r
.58887 .43212 m .58593 .43281 L .58786 .43225 L F
.426 .87 .842 r
.6063 .42644 m .59227 .43042 L .58557 .43319 L F
.59882 .42771 m .58691 .43237 L p .59995 .42752 L F P
0 g
s
.332 .815 .812 r
.58786 .43225 m .58593 .43281 L .58691 .43237 L F
.426 .87 .842 r
.58691 .43237 m .58095 .4347 L p .59995 .42752 L F P
0 g
s
.52 .917 .87 r
.61269 .42166 m .6063 .42644 L .60998 .42224 L F
.332 .815 .812 r
.60256 .42912 m .60276 .42909 L .59553 .43127 L p F P
0 g
s
.638 .575 .768 r
.62616 .44298 m .61686 .42474 L .60966 .42695 L F
.62784 .44462 m .62671 .44256 L p .62616 .44298 L F P
0 g
s
.638 .575 .768 r
.62671 .44256 m .61686 .42474 L p .62616 .44298 L F P
0 g
s
.568 .477 .711 r
.6347 .44101 m .63455 .44061 L .63332 .44173 L F
.592 .49 .707 r
.64189 .43707 m .63755 .44823 L .6347 .44101 L F
.638 .575 .768 r
.62784 .44462 m .60966 .42695 L .61438 .43637 L F
.623 .568 .772 r
.61609 .43976 m .61348 .44872 L .60916 .42596 L F
.638 .575 .768 r
.59553 .43127 m .5887 .43394 L p .5976 .43636 L F P
0 g
s
.652 .583 .764 r
.60276 .42909 m .58639 .45214 L .58156 .43677 L F
.623 .568 .772 r
.61181 .449 m .60276 .42909 L p .61348 .44872 L F P
0 g
s
.638 .575 .768 r
.61609 .43976 m .60256 .42912 L .59689 .43184 L F
.62784 .44462 m .61438 .43637 L .61609 .43976 L F
.61438 .43637 m .60256 .42912 L .61609 .43976 L F
.623 .568 .772 r
.61705 .44167 m .61278 .45112 L .61609 .43976 L F
.638 .575 .768 r
.62784 .44462 m .59553 .43127 L .5976 .43636 L F
.608 .562 .777 r
.62482 .42447 m .62252 .42065 L .61844 .4236 L F
.62671 .44256 m .62784 .44462 L .63455 .44061 L p F P
0 g
s
.638 .575 .768 r
.62003 .44762 m .62784 .44462 L p .61705 .44167 L F P
0 g
s
.591 .489 .706 r
.63356 .51969 m .62315 .48528 L .6313 .48143 L p F P
0 g
s
.613 .502 .703 r
.64007 .47813 m .62842 .44621 L p .62112 .44846 L F P
0 g
s
.613 .502 .703 r
.64007 .47813 m .62112 .44846 L .62188 .45092 L F
.64007 .47813 m .62039 .44868 L .62724 .46924 L F
.568 .476 .711 r
.64007 .47813 m .65236 .51192 L .66075 .50713 L p F P
0 g
s
.542 .464 .716 r
.67758 .49754 m .66994 .50289 L p .67356 .48871 L F P
0 g
s
.542 .464 .716 r
.67214 .48673 m .66994 .50289 L .66272 .46491 L F
.68026 .46241 m .66994 .50289 L .67645 .45505 L F
.568 .476 .711 r
.65171 .48415 m .64007 .47813 L .66075 .50713 L F
.591 .489 .706 r
.65587 .46982 m .66994 .50289 L .66075 .50713 L p F P
0 g
s
.613 .501 .703 r
.65236 .51192 m .64007 .47813 L .6313 .48143 L p F P
0 g
s
.613 .501 .703 r
.65236 .51192 m .6313 .48143 L .63857 .50331 L F
.591 .489 .706 r
.65587 .46982 m .66075 .50713 L .65066 .48147 L F
.568 .476 .711 r
.67356 .48871 m .65066 .48147 L .67758 .49754 L F
.65066 .48147 m .64007 .47813 L .65171 .48415 L F
.65066 .48147 m .65171 .48415 L .67758 .49754 L F
.613 .501 .703 r
.65236 .51192 m .63857 .50331 L .63956 .50629 L F
.592 .49 .707 r
.62315 .48528 m .61327 .45274 L p .62043 .44882 L F P
0 g
s
.592 .49 .707 r
.62729 .4694 m .62315 .48528 L .62043 .44882 L F
.613 .502 .703 r
.64007 .47813 m .62724 .46924 L .62823 .47221 L F
.543 .464 .717 r
.65869 .45609 m .65587 .46982 L .6574 .45326 L F
.613 .502 .703 r
.6313 .48143 m .64007 .47813 L p .62823 .47221 L F P
0 g
s
.592 .49 .707 r
.64189 .43707 m .65587 .46982 L .64761 .47372 L p F P
0 g
s
.592 .49 .707 r
.63787 .44739 m .64761 .47372 L .63755 .44823 L F
.64189 .43707 m .64761 .47372 L .63787 .44739 L F
.568 .477 .711 r
.65896 .45619 m .65869 .45609 L .66272 .46491 L F
.543 .464 .717 r
.67645 .45505 m .65587 .46982 L p .66388 .43087 L F P
0 g
s
.568 .477 .711 r
.65869 .45609 m .63755 .44823 L .66272 .46491 L F
.63755 .44823 m .62784 .44462 L .63859 .45087 L F
.63755 .44823 m .63859 .45087 L .66272 .46491 L F
.62784 .44462 m .64007 .47813 L .66272 .46491 L p F P
0 g
s
.592 .49 .707 r
.64761 .47372 m .62315 .48528 L p .63755 .44823 L F P
0 g
s
.591 .489 .706 r
.64761 .47372 m .65587 .46982 L p .65066 .48147 L F P
0 g
s
.542 .464 .716 r
.67226 .48585 m .67214 .48673 L .66272 .46491 L F
.568 .476 .711 r
.66272 .46491 m .64761 .47372 L p .67356 .48871 L F P
0 g
s
.568 .476 .711 r
.64761 .47372 m .64007 .47813 L p .65045 .48141 L F P
0 g
s
.568 .476 .711 r
.67356 .48871 m .64761 .47372 L .65045 .48141 L F
.568 .477 .711 r
.65869 .45609 m .64848 .43375 L .6347 .44101 L F
.63755 .44823 m .6347 .44101 L .62784 .44462 L F
.65869 .45609 m .6347 .44101 L .63755 .44823 L F
.592 .49 .707 r
.63614 .44022 m .6347 .44101 L .63455 .44061 L F
.613 .502 .703 r
.62188 .45092 m .62112 .44846 L .62039 .44868 L F
.568 .477 .711 r
.63455 .44061 m .62784 .44462 L p .63332 .44173 L F P
0 g
s
.613 .502 .703 r
.62842 .44621 m .62784 .44462 L .62003 .44762 L p F P
0 g
s
.592 .49 .707 r
.62039 .44868 m .61327 .45274 L .62003 .44762 L F
.61327 .45274 m .61278 .45112 L .62003 .44762 L p F P
0 g
s
.623 .568 .772 r
.62003 .44762 m .61278 .45112 L p .61705 .44167 L F P
0 g
s
.623 .568 .772 r
.61278 .45112 m .61181 .449 L p .61348 .44872 L F P
0 g
s
.613 .502 .703 r
.62003 .44762 m .60458 .45356 L p .62039 .44868 L F P
0 g
s
.613 .502 .703 r
.62842 .44621 m .62003 .44762 L .62039 .44868 L F
.592 .49 .707 r
.6347 .44101 m .62043 .44882 L .63455 .44061 L F
.62043 .44882 m .61327 .45274 L .62039 .44868 L F
.62043 .44882 m .62039 .44868 L .63455 .44061 L F
.63755 .44823 m .62823 .47221 L .6347 .44101 L F
.62823 .47221 m .62315 .48528 L .62729 .4694 L F
.62823 .47221 m .62729 .4694 L .6347 .44101 L F
.613 .502 .703 r
.60674 .46148 m .606 .4611 L .61396 .48796 L F
.634 .514 .7 r
.61278 .45112 m .62315 .48528 L .58666 .49591 L p F P
0 g
s
.613 .502 .703 r
.61396 .48796 m .6313 .48143 L p .60674 .46148 L F P
0 g
s
.613 .502 .703 r
.62823 .47221 m .60674 .46148 L .6313 .48143 L F
.62823 .47221 m .60458 .45356 L .60674 .46148 L F
.62724 .46924 m .60458 .45356 L .62823 .47221 L F
.592 .49 .707 r
.6347 .44101 m .62729 .4694 L .62043 .44882 L F
.591 .489 .706 r
.6313 .48143 m .64761 .47372 L p .63947 .50603 L F P
0 g
s
.591 .489 .706 r
.63947 .50603 m .63921 .50706 L .6313 .48143 L F
.65066 .48147 m .63956 .50629 L .64761 .47372 L F
.63956 .50629 m .63921 .50706 L .63947 .50603 L F
.63956 .50629 m .63947 .50603 L .64761 .47372 L F
.63853 .50859 m .64028 .50847 L .63356 .51969 L F
.64262 .51551 m .63356 .51969 L p .64028 .50847 L F P
0 g
s
.591 .489 .706 r
.63921 .50706 m .63356 .51969 L .6313 .48143 L F
.613 .501 .703 r
.62337 .5226 m .64262 .51551 L p .61614 .49599 L F P
0 g
s
.613 .501 .703 r
.64262 .51551 m .65236 .51192 L p .63956 .50629 L F P
0 g
s
.591 .489 .706 r
.63956 .50629 m .64028 .50847 L .63853 .50859 L F
.613 .501 .703 r
.63956 .50629 m .61614 .49599 L .64262 .51551 L F
.63956 .50629 m .61396 .48796 L .61614 .49599 L F
.63857 .50331 m .61396 .48796 L .63956 .50629 L F
.591 .489 .706 r
.65066 .48147 m .66075 .50713 L .64028 .50847 L F
.65066 .48147 m .64028 .50847 L .63956 .50629 L F
.613 .501 .703 r
.6313 .48143 m .61396 .48796 L p .63857 .50331 L F P
0 g
s
.591 .489 .706 r
.66075 .50713 m .64262 .51551 L p .64028 .50847 L F P
0 g
s
.574 .523 .761 r
.68816 .5149 m .68363 .52705 L .6869 .51284 L F
.593 .531 .754 r
.66374 .51287 m .66219 .50989 L .65236 .51192 L F
.612 .539 .749 r
.66075 .50713 m .66994 .50289 L p .66374 .51287 L F P
0 g
s
.593 .531 .754 r
.66075 .50713 m .65236 .51192 L p .66219 .50989 L F P
0 g
s
.612 .539 .749 r
.66994 .50289 m .68363 .52705 L .67353 .53163 L p F P
0 g
s
.612 .539 .749 r
.66994 .50289 m .67353 .53163 L .66374 .51287 L F
.593 .531 .754 r
.68255 .5057 m .66075 .50713 L .66219 .50989 L F
.574 .523 .761 r
.69666 .49215 m .70849 .50901 L .68363 .52705 L F
.69204 .52127 m .68363 .52705 L p .70849 .50901 L F P
0 g
s
.593 .531 .754 r
.65236 .51192 m .6643 .5368 L .67353 .53163 L p F P
0 g
s
.593 .531 .754 r
.67353 .53163 m .69204 .52127 L p .69095 .52101 L F P
0 g
s
.593 .531 .754 r
.69095 .52101 m .65236 .51192 L .67353 .53163 L F
.652 .682 .866 r
.6643 .5368 m .67499 .54817 L p .68513 .54281 L F P
0 g
s
.647 .682 .869 r
.69461 .52331 m .69647 .53741 L .68689 .52989 L F
.69588 .53774 m .68689 .52989 L p .69647 .53741 L F P
0 g
s
.66 .933 .969 r
.71526 .53202 m .70622 .53214 L .67831 .5477 L F
.70622 .53214 m .70576 .53214 L .69588 .53774 L F
.70622 .53214 m .69588 .53774 L .67831 .5477 L F
.652 .682 .866 r
.67732 .53528 m .6643 .5368 L .68513 .54281 L F
.657 .683 .863 r
.68363 .52705 m .69588 .53774 L p .68513 .54281 L F P
0 g
s
.657 .683 .863 r
.68363 .52705 m .68513 .54281 L .67639 .53439 L F
.647 .682 .869 r
.69937 .5325 m .6966 .53836 L .69586 .53279 L F
.69937 .5325 m .69586 .53279 L .69461 .52331 L F
.70123 .52856 m .69937 .5325 L .69461 .52331 L F
.652 .682 .866 r
.70144 .51601 m .69204 .52127 L p .71471 .52621 L F P
0 g
s
.652 .682 .866 r
.71517 .52591 m .70144 .51601 L p .71471 .52621 L F P
0 g
s
.647 .682 .869 r
.70211 .52925 m .6966 .53836 L .70123 .52856 L F
.657 .683 .863 r
.68363 .52705 m .67639 .53439 L .67428 .53236 L F
.647 .682 .869 r
.68689 .52989 m .68363 .52705 L .69204 .52127 L p F P
0 g
s
.647 .682 .869 r
.69432 .52308 m .68689 .52989 L .69204 .52127 L F
.652 .682 .866 r
.71598 .52648 m .69204 .52127 L .70211 .52925 L F
.647 .682 .869 r
.70894 .50966 m .71753 .50376 L p .70988 .51028 L F P
0 g
s
.642 .682 .872 r
.70894 .50966 m .70144 .51601 L p .71253 .51202 L F P
0 g
s
.647 .682 .869 r
.70988 .51028 m .68689 .52989 L .70894 .50966 L F
.71753 .50376 m .71253 .51202 L .70988 .51028 L F
.652 .682 .866 r
.70576 .53214 m .71598 .52648 L p .70556 .53199 L F P
0 g
s
.652 .682 .866 r
.71598 .52648 m .70211 .52925 L .70556 .53199 L F
.633 .683 .88 r
.7317 .49039 m .74807 .49841 L p .75422 .49064 L F P
0 g
s
.633 .683 .88 r
.74234 .48538 m .7317 .49039 L .75422 .49064 L F
.77111 .46799 m .76189 .47323 L .76795 .47332 L F
.629 .685 .884 r
.74376 .47603 m .74799 .46831 L p .7622 .48162 L F P
0 g
s
.629 .685 .884 r
.76189 .47323 m .7622 .48162 L .74799 .46831 L F
.76124 .48296 m .74376 .47603 L p .7622 .48162 L F P
0 g
s
.637 .682 .876 r
.74376 .47603 m .76124 .48296 L p .75497 .49096 L F P
0 g
s
.637 .682 .876 r
.74376 .47603 m .75497 .49096 L .74131 .48493 L F
.633 .683 .88 r
.76189 .47323 m .76535 .47445 L .76795 .47332 L F
.775 .915 .933 r
.78014 .47175 m .76759 .47486 L .76124 .48296 L F
.78014 .47175 m .76124 .48296 L .75613 .49007 L F
.629 .685 .884 r
.76189 .47323 m .76694 .47502 L .7622 .48162 L F
.633 .683 .88 r
.74131 .48493 m .74234 .48538 L .76546 .47449 L F
.76535 .47445 m .76546 .47449 L .76795 .47332 L F
.74131 .48493 m .76546 .47449 L .76535 .47445 L F
.76795 .47332 m .74234 .48538 L .75422 .49064 L F
.625 .687 .888 r
.75353 .4608 m .77197 .46655 L p .77555 .45796 L F P
0 g
s
.625 .687 .888 r
.76118 .45404 m .75353 .4608 L .77555 .45796 L F
.633 .683 .88 r
.75497 .49096 m .76694 .47502 L p .74807 .49841 L F P
0 g
s
.789 .901 .921 r
.77705 .45798 m .78014 .47175 L .76759 .47486 L F
.77197 .46655 m .76759 .47486 L .76694 .47502 L F
.77705 .45798 m .76759 .47486 L .77197 .46655 L F
.633 .683 .88 r
.76694 .47502 m .77305 .46689 L p .76668 .47492 L F P
0 g
s
.633 .683 .88 r
.76668 .47492 m .74807 .49841 L .76694 .47502 L F
.637 .682 .876 r
.7371 .48307 m .74376 .47603 L p .74131 .48493 L F P
0 g
s
.633 .683 .88 r
.77305 .46689 m .75842 .46232 L p .7317 .49039 L F P
0 g
s
.53 .509 .777 r
.72433 .45577 m .74376 .47603 L .7371 .48307 L p F P
0 g
s
.506 .502 .787 r
.75353 .4608 m .7281 .44867 L .74264 .46303 L F
.479 .496 .798 r
.74264 .46303 m .74777 .4681 L .74376 .47603 L F
.506 .502 .787 r
.74799 .46831 m .75353 .4608 L p .74264 .46303 L F P
0 g
s
.449 .491 .81 r
.73307 .44175 m .75353 .4608 L .7565 .45276 L p F P
0 g
s
.449 .491 .81 r
.74055 .43866 m .73307 .44175 L .7565 .45276 L F
.479 .496 .798 r
.74799 .46831 m .74376 .47603 L p .75584 .45217 L F P
0 g
s
.479 .496 .798 r
.75994 .44408 m .75591 .45224 L .75584 .45217 L F
.75591 .45224 m .74799 .46831 L .75584 .45217 L F
.73955 .42708 m .75994 .44408 L p .75584 .45217 L F P
0 g
s
.479 .496 .798 r
.74216 .44008 m .75584 .45217 L .74777 .4681 L F
.73955 .42708 m .75584 .45217 L .74216 .44008 L F
.73955 .42708 m .74777 .4681 L .74264 .46303 L F
.299 .369 .767 r
.73527 .41329 m .73955 .42708 L .71903 .39353 L F
.449 .491 .81 r
.73569 .43436 m .73307 .44175 L p .74055 .43866 L F P
0 g
s
.479 .496 .798 r
.73955 .42708 m .74081 .44177 L .73532 .44475 L F
.356 .388 .757 r
.71218 .41382 m .73307 .44175 L .73569 .43436 L p F P
0 g
s
.479 .496 .798 r
.7281 .44867 m .73569 .43436 L p .73532 .44475 L F P
0 g
s
.479 .496 .798 r
.73569 .43436 m .73955 .42708 L p .73532 .44475 L F P
0 g
s
.405 .406 .747 r
.71785 .40044 m .73955 .42708 L .73569 .43436 L p F P
0 g
s
.356 .388 .757 r
.71936 .41339 m .71218 .41382 L .73569 .43436 L F
.405 .406 .747 r
.73569 .43436 m .7281 .44867 L p .72106 .41557 L F P
0 g
s
.405 .406 .747 r
.71785 .40044 m .73569 .43436 L .72106 .41557 L F
.299 .369 .767 r
.73501 .41244 m .73527 .41329 L .71903 .39353 L F
.405 .406 .747 r
.71936 .41339 m .7281 .44867 L .72259 .44093 L F
.71785 .40044 m .72106 .41557 L .71936 .41339 L F
.72106 .41557 m .7281 .44867 L .71936 .41339 L F
.356 .388 .757 r
.71445 .40708 m .71218 .41382 L p .71936 .41339 L F P
0 g
s
.405 .406 .747 r
.70778 .42014 m .71785 .40044 L p .72259 .44093 L F P
0 g
s
.356 .388 .757 r
.71903 .39353 m .71445 .40708 L p .73501 .41244 L F P
0 g
s
.356 .388 .757 r
.73501 .41244 m .71445 .40708 L .71936 .41339 L F
.299 .369 .767 r
.74097 .41949 m .73955 .42708 L p .73501 .41244 L F P
0 g
s
.356 .388 .757 r
.74365 .41192 m .73648 .41235 L .73606 .42417 L F
.73569 .43436 m .74097 .41949 L p .73606 .42417 L F P
0 g
s
.356 .388 .757 r
.74097 .41949 m .74365 .41192 L p .73606 .42417 L F P
0 g
s
.416 .486 .824 r
.76084 .44483 m .73955 .42708 L .74097 .41949 L p F P
0 g
s
.449 .491 .81 r
.76555 .4283 m .74365 .41192 L .74097 .41949 L p F P
0 g
s
.416 .486 .824 r
.7567 .43197 m .76084 .44483 L .74097 .41949 L F
.449 .491 .81 r
.74097 .41949 m .73569 .43436 L p .75483 .43048 L F P
0 g
s
.449 .491 .81 r
.76555 .4283 m .74097 .41949 L .75483 .43048 L F
.7567 .43197 m .73569 .43436 L .74055 .43866 L F
.76555 .4283 m .75483 .43048 L .7567 .43197 L F
.75483 .43048 m .73569 .43436 L .7567 .43197 L F
.416 .486 .824 r
.7625 .43656 m .76084 .44483 L p .7567 .43197 L F P
0 g
s
.479 .496 .798 r
.75994 .44408 m .76084 .44483 L .7565 .45276 L p F P
0 g
s
.479 .496 .798 r
.7565 .45276 m .74799 .46831 L p .75194 .4603 L F P
0 g
s
.479 .496 .798 r
.75994 .44408 m .7565 .45276 L .75194 .4603 L F
.629 .685 .884 r
.76084 .44483 m .76279 .45448 L .76118 .45404 L F
.625 .687 .888 r
.78521 .43204 m .7708 .42915 L .76634 .43732 L F
.78534 .43148 m .7708 .42915 L p .78521 .43204 L F P
0 g
s
.615 .696 .902 r
.78593 .40398 m .78743 .40406 L .78772 .40592 L F
.618 .693 .897 r
.78758 .40219 m .78203 .40377 L .78743 .40406 L F
.807 .831 .87 r
.78696 .39464 m .80092 .3975 L .78846 .40372 L F
.78626 .38613 m .80092 .3975 L .78696 .39464 L F
.618 .693 .897 r
.78709 .39624 m .78203 .40377 L .78758 .40219 L F
.807 .85 .882 r
.80092 .3975 m .78846 .40372 L .78764 .42123 L F
.78846 .40372 m .78773 .40408 L .78768 .41318 L F
.78846 .40372 m .78768 .41318 L .78764 .42123 L F
.618 .693 .897 r
.76555 .4283 m .78534 .43148 L p .78604 .42242 L F P
0 g
s
.621 .689 .893 r
.76752 .41139 m .78768 .41318 L p .78604 .42242 L F P
0 g
s
.621 .689 .893 r
.76752 .41139 m .78604 .42242 L .77079 .42051 L F
.615 .696 .902 r
.78203 .40377 m .78772 .40592 L .78769 .41165 L F
.612 .7 .907 r
.7691 .38577 m .76667 .39427 L .77083 .38574 L F
.609 .71 .916 r
.75556 .35147 m .75621 .36026 L .75722 .35119 L F
.612 .7 .907 r
.77668 .35928 m .77433 .36751 L .77997 .367 L F
.75621 .36026 m .75887 .3689 L p .7762 .35816 L F P
0 g
s
.8 .796 .848 r
.77601 .35771 m .78537 .37533 L .77997 .367 L F
.794 .779 .839 r
.77691 .35497 m .772 .3483 L .77717 .35756 L F
.609 .71 .916 r
.75338 .32228 m .73409 .32802 L .7397 .33621 L p F P
0 g
s
.609 .71 .916 r
.75338 .32228 m .7397 .33621 L .75415 .33258 L F
.609 .721 .925 r
.71736 .29086 m .70088 .2994 L .7093 .30666 L p F P
0 g
s
.609 .721 .925 r
.71736 .29086 m .7093 .30666 L .72189 .30093 L F
.612 .734 .932 r
.69385 .29149 m .70088 .2994 L .69474 .29096 L F
.771 .732 .817 r
.70927 .27959 m .73864 .28454 L .70574 .28451 L F
.782 .698 .771 r
.6076 .25167 m .60736 .25222 L p .60785 .25243 L F P
0 g
s
.22 .632 .955 r
.62275 .25482 m .63556 .25811 L .6144 .25535 L F
.235 .614 .955 r
.6076 .25167 m .6144 .25535 L p .61899 .25077 L F P
0 g
s
.235 .614 .955 r
.61829 .25045 m .6076 .25167 L p .61899 .25077 L F P
0 g
s
.22 .632 .955 r
.62366 .25477 m .63556 .25811 L .62275 .25482 L F
.235 .614 .955 r
.6144 .25535 m .62785 .26263 L p .62145 .25899 L F P
0 g
s
.77 .682 .766 r
.59258 .27332 m .61109 .2623 L .60252 .28026 L F
.59207 .26915 m .61109 .2623 L .58984 .27495 L F
.806 .733 .783 r
.65058 .27991 m .63996 .27086 L p .63904 .29479 L F P
0 g
s
.794 .715 .776 r
.61726 .28113 m .63996 .27086 L .63572 .27717 L F
.61834 .27925 m .63996 .27086 L .61726 .28113 L F
.256 .598 .951 r
.62172 .25847 m .6243 .25962 L .62851 .26264 L F
.235 .614 .955 r
.62851 .26264 m .62802 .26263 L .63458 .26627 L F
.256 .598 .951 r
.62785 .26263 m .62172 .25847 L p .62851 .26264 L F P
0 g
s
.794 .715 .776 r
.62145 .25899 m .62172 .25847 L .62785 .26263 L p F P
0 g
s
.235 .614 .955 r
.62785 .26263 m .63458 .26627 L p .62802 .26263 L F P
0 g
s
.235 .614 .955 r
.62145 .25899 m .62785 .26263 L .62802 .26263 L F
.63365 .2653 m .62851 .26264 L .63458 .26627 L F
.256 .598 .951 r
.6243 .25962 m .63117 .26269 L .62851 .26264 L F
.77 .682 .766 r
.62172 .25847 m .62145 .25899 L p .62132 .25893 L F P
0 g
s
.757 .667 .763 r
.58411 .2442 m .59207 .26915 L .59961 .24954 L F
.218 .677 .947 r
.59238 .24598 m .58416 .24405 L p .60043 .24382 L F P
0 g
s
.218 .677 .947 r
.6011 .24401 m .59238 .24598 L p .60043 .24382 L F P
0 g
s
.757 .667 .763 r
.57627 .24149 m .57668 .2422 L .58254 .24365 L F
.214 .653 .952 r
.57627 .24149 m .58416 .24405 L p .58364 .23913 L F P
0 g
s
.214 .653 .952 r
.58359 .23864 m .58288 .23892 L p .58364 .23913 L F P
0 g
s
.214 .653 .952 r
.58288 .23892 m .57627 .24149 L p .58364 .23913 L F P
0 g
s
.214 .653 .952 r
.58359 .23864 m .58416 .24405 L .58952 .24249 L F
.218 .677 .947 r
.59027 .24227 m .60204 .2438 L .58416 .24405 L F
.22 .632 .955 r
.59506 .24674 m .6022 .24874 L .60026 .24905 L F
.235 .614 .955 r
.61944 .25032 m .6144 .25535 L .62366 .25477 L F
.6272 .25454 m .61944 .25032 L p .62366 .25477 L F P
0 g
s
.214 .653 .952 r
.6076 .25167 m .61829 .25045 L p .61049 .24741 L F P
0 g
s
.22 .632 .955 r
.59238 .24598 m .6011 .24401 L p .60971 .24753 L F P
0 g
s
.22 .632 .955 r
.59238 .24598 m .60971 .24753 L .6022 .24874 L F
.214 .653 .952 r
.6022 .24874 m .6076 .25167 L .61049 .24741 L F
.22 .632 .955 r
.61049 .24741 m .63556 .25811 L p .6011 .24401 L F P
0 g
s
.218 .677 .947 r
.59262 .24158 m .60204 .2438 L p .59027 .24227 L F P
0 g
s
.214 .653 .952 r
.61049 .24741 m .59262 .24158 L p .6022 .24874 L F P
0 g
s
.214 .653 .952 r
.59262 .24158 m .58359 .23864 L p .59027 .24227 L F P
0 g
s
.214 .653 .952 r
.59027 .24227 m .6022 .24874 L .59262 .24158 L F
.59027 .24227 m .59977 .24913 L .6022 .24874 L F
.58359 .23864 m .58952 .24249 L .59027 .24227 L F
.58952 .24249 m .59977 .24913 L .59027 .24227 L F
.233 .704 .942 r
.57627 .24149 m .58288 .23892 L p .57383 .23716 L F P
0 g
s
.218 .677 .947 r
.55948 .23826 m .56388 .23525 L p .57383 .23716 L F P
0 g
s
.218 .677 .947 r
.56388 .23525 m .56435 .23493 L .57383 .23716 L p F P
0 g
s
.218 .677 .947 r
.55948 .23826 m .57383 .23716 L .56961 .23927 L F
.233 .704 .942 r
.56913 .23951 m .57627 .24149 L .57383 .23716 L F
.218 .677 .947 r
.56913 .23951 m .59262 .24158 L .59027 .24227 L F
.55948 .23826 m .56961 .23927 L .56913 .23951 L F
.56961 .23927 m .59262 .24158 L .56913 .23951 L F
.233 .704 .942 r
.56775 .2402 m .57627 .24149 L p .56913 .23951 L F P
0 g
s
.731 .641 .758 r
.57613 .24207 m .57627 .24149 L .56775 .2402 L p F P
0 g
s
.218 .677 .947 r
.55948 .23826 m .56211 .2386 L .57613 .24207 L F
.58416 .24405 m .56775 .2402 L p .57613 .24207 L F P
0 g
s
.218 .677 .947 r
.56775 .2402 m .55948 .23826 L p .57613 .24207 L F P
0 g
s
.744 .654 .76 r
.56213 .26733 m .56468 .26529 L .56959 .26754 L F
.57632 .27062 m .56213 .26733 L p .56959 .26754 L F P
0 g
s
.791 .599 .642 r
.57626 .27106 m .5761 .27237 L .58296 .27366 L F
.747 .559 .64 r
.54737 .26693 m .55804 .31321 L .56213 .26733 L F
.54659 .28187 m .55804 .31321 L .54737 .26693 L F
.725 .54 .64 r
.53251 .26409 m .54746 .26515 L p .53187 .30575 L F P
0 g
s
.676 .595 .758 r
.48796 .26777 m .50256 .26541 L p .49499 .26513 L F P
0 g
s
.594 .552 .778 r
.42268 .28962 m .41092 .27256 L .42261 .26396 L F
.42268 .28962 m .42261 .26396 L .42642 .27044 L F
.629 .568 .767 r
.44764 .2805 m .44665 .27848 L .45362 .27708 L F
.46049 .2757 m .44797 .28116 L p .45362 .27708 L F P
0 g
s
.629 .568 .767 r
.44764 .2805 m .45362 .27708 L .44797 .28116 L F
.612 .56 .772 r
.42642 .27044 m .44797 .28116 L .44523 .2756 L F
.594 .552 .778 r
.41068 .2722 m .42254 .26384 L p .4109 .27252 L F P
0 g
s
.574 .545 .784 r
.41068 .2722 m .40032 .28136 L p .42146 .28785 L F P
0 g
s
.594 .552 .778 r
.4051 .27684 m .41068 .2722 L .4109 .27252 L F
.4051 .27684 m .42254 .26384 L .42261 .26396 L F
.612 .56 .772 r
.42766 .27254 m .44797 .28116 L .42642 .27044 L F
.43576 .25641 m .42254 .26384 L p .44523 .2756 L F P
0 g
s
.612 .56 .772 r
.42642 .27044 m .44523 .2756 L .42254 .26384 L F
.43648 .28752 m .44797 .28116 L p .44152 .28304 L F P
0 g
s
.507 .527 .812 r
.37929 .31239 m .38456 .3016 L p .39275 .32407 L F P
0 g
s
.452 .519 .836 r
.39369 .34276 m .39339 .33705 L .39553 .33871 L F
.38953 .34526 m .38131 .32769 L .394 .34836 L F
.38131 .32769 m .38297 .32898 L .394 .34836 L F
.42 .515 .85 r
.37445 .34587 m .38953 .34526 L .3745 .33485 L F
.839 .834 .842 r
.37434 .34581 m .37626 .35684 L p .37484 .35162 L F P
0 g
s
.384 .513 .864 r
.3935 .3664 m .37981 .3492 L .39403 .35801 L F
.345 .511 .878 r
.39868 .3769 m .39561 .36757 L p .39612 .3717 L F P
0 g
s
.345 .511 .878 r
.38511 .37019 m .39868 .3769 L .39424 .36791 L F
.149 .506 .911 r
.41614 .40332 m .41964 .40613 L .41628 .40263 L F
.41535 .40741 m .42465 .41014 L .41614 .40332 L F
.096 .504 .904 r
.41987 .40667 m .42465 .41014 L p .4227 .40934 L F P
0 g
s
.149 .506 .911 r
.41482 .41014 m .41628 .40263 L .41267 .4014 L F
.096 .504 .904 r
.40449 .40185 m .41987 .40667 L p .4227 .40934 L F P
0 g
s
.203 .507 .91 r
.41235 .39901 m .41032 .39967 L .40723 .3938 L F
.41987 .40667 m .41567 .4036 L .41235 .39901 L F
.41567 .4036 m .41032 .39967 L .41235 .39901 L F
.40546 .39042 m .41628 .40263 L p .40723 .3938 L F P
0 g
s
.203 .507 .91 r
.41628 .40263 m .41987 .40667 L p .40723 .3938 L F P
0 g
s
.254 .508 .903 r
.39827 .39032 m .40723 .3938 L .40521 .38984 L F
.4091 .39452 m .4032 .38592 L p .40521 .38984 L F P
0 g
s
.254 .508 .903 r
.40723 .3938 m .4091 .39452 L .40521 .38984 L F
.203 .507 .91 r
.41987 .40667 m .41144 .40098 L .41175 .40109 L F
.41144 .40098 m .39213 .38794 L .41175 .40109 L F
.254 .508 .903 r
.38519 .378 m .39204 .3879 L p .39913 .38413 L F P
0 g
s
.254 .508 .903 r
.39676 .38974 m .39913 .38413 L .39204 .3879 L F
.203 .507 .91 r
.39676 .38974 m .39127 .38699 L .38847 .38365 L F
.41987 .40667 m .39332 .3884 L .39676 .38974 L F
.39332 .3884 m .39127 .38699 L .39676 .38974 L F
.254 .508 .903 r
.39676 .38974 m .4032 .38592 L .39913 .38413 L F
.39827 .39032 m .4032 .38592 L .39676 .38974 L F
.39827 .39032 m .40521 .38984 L .40249 .38656 L F
.203 .507 .91 r
.38783 .38318 m .40546 .39042 L p .40723 .3938 L F P
0 g
s
.203 .507 .91 r
.41032 .39967 m .39676 .38974 L .40723 .3938 L F
.39676 .38974 m .38783 .38318 L .40723 .3938 L F
.804 .737 .79 r
.40034 .39721 m .39545 .39284 L p .39651 .40136 L F P
0 g
s
.813 .755 .798 r
.40005 .39752 m .39689 .39442 L .40034 .39721 L F
.254 .508 .903 r
.39545 .39284 m .39561 .3927 L .39555 .39262 L F
.39545 .39284 m .41204 .39882 L .4091 .39452 L p F P
0 g
s
.254 .508 .903 r
.39545 .39284 m .4091 .39452 L .39827 .39032 L F
.813 .755 .798 r
.39689 .39442 m .38655 .38431 L .3958 .39297 L F
.149 .506 .911 r
.3958 .39297 m .39545 .39284 L .40034 .39721 L p F P
0 g
s
.813 .755 .798 r
.39689 .39442 m .3958 .39297 L .40034 .39721 L F
.254 .508 .903 r
.39555 .39262 m .39827 .39032 L .39676 .38974 L F
.39561 .3927 m .39827 .39032 L .39555 .39262 L F
.149 .506 .911 r
.41267 .4014 m .41204 .39882 L .41141 .40097 L F
.203 .507 .91 r
.41987 .40667 m .40482 .40196 L p .4006 .39729 L F P
0 g
s
.203 .507 .91 r
.41987 .40667 m .4006 .39729 L .41144 .40098 L F
.149 .506 .911 r
.41204 .39882 m .3958 .39297 L p .40057 .39728 L F P
0 g
s
.149 .506 .911 r
.41141 .40097 m .41204 .39882 L .40057 .39728 L F
.879 .454 .051 r
.41364 .40519 m .40973 .396 L .4067 .39267 L F
.826 .414 0 r
.41204 .39882 m .41364 .40519 L .40958 .39566 L F
.41204 .39882 m .40958 .39566 L .40928 .39495 L F
.149 .506 .911 r
.41267 .4014 m .41454 .40203 L .41204 .39882 L F
.41628 .40263 m .41204 .39882 L p .41454 .40203 L F P
0 g
s
.826 .414 0 r
.4091 .39452 m .41204 .39882 L p .40928 .39495 L F P
0 g
s
.891 .467 .148 r
.41274 .40049 m .41204 .39882 L .41628 .40263 L p F P
0 g
s
.879 .454 .051 r
.41987 .40667 m .41628 .40263 L p .41681 .4038 L F P
0 g
s
.149 .506 .911 r
.42465 .41014 m .41628 .40263 L p .41964 .40613 L F P
0 g
s
.891 .467 .148 r
.41628 .40263 m .42465 .41014 L p .41673 .40372 L F P
0 g
s
.891 .467 .148 r
.41673 .40372 m .41274 .40049 L .41628 .40263 L F
.879 .454 .051 r
.41683 .40384 m .41673 .40372 L .41674 .40374 L F
.891 .467 .148 r
.41679 .40386 m .41274 .40049 L .41673 .40372 L F
0 .511 .806 r
.47853 .43651 m .45958 .432 L .47904 .43655 L F
0 .505 .837 r
.46188 .43228 m .45585 .42848 L .45358 .42811 L F
0 .523 .778 r
.49027 .43934 m .49361 .4394 L .48178 .437 L F
.49027 .43934 m .48051 .43665 L .47904 .43655 L F
.704 .618 .758 r
.51927 .4595 m .51017 .46601 L .51935 .45742 L F
.728 .639 .759 r
.51035 .46375 m .51017 .46601 L .50147 .46485 L p F P
0 g
s
.739 .595 .696 r
.50147 .46485 m .51017 .46601 L p .50857 .46721 L F P
0 g
s
.739 .595 .696 r
.51017 .46601 m .50825 .50162 L .49851 .50034 L p F P
0 g
s
.755 .61 .697 r
.4791 .4978 m .48861 .49973 L p .48066 .48845 L F P
0 g
s
.755 .61 .697 r
.48066 .48845 m .48047 .48819 L .4791 .4978 L F
.739 .594 .695 r
.46323 .53189 m .46932 .49652 L .4791 .4978 L p F P
0 g
s
.739 .594 .695 r
.47543 .52369 m .47472 .52416 L .4791 .4978 L F
.47472 .52416 m .46323 .53189 L .4791 .4978 L F
.755 .61 .697 r
.48861 .49973 m .49262 .46429 L .48413 .46253 L p F P
0 g
s
.755 .61 .697 r
.48861 .49973 m .48413 .46253 L .48091 .4851 L F
.48861 .49973 m .4672 .45903 L .46558 .46707 L F
.722 .58 .695 r
.49262 .46429 m .48861 .49973 L .49851 .50034 L p F P
0 g
s
.739 .595 .696 r
.51017 .46601 m .49851 .50034 L .50079 .47302 L F
.50857 .46721 m .50079 .47302 L .50147 .46485 L F
.722 .58 .695 r
.50079 .47302 m .50017 .47237 L .49851 .50034 L F
.50017 .47237 m .49262 .46429 L .49851 .50034 L F
.50143 .46527 m .50147 .46485 L .49966 .46507 L F
.706 .566 .695 r
.50825 .50162 m .51008 .4677 L p .5182 .46727 L F P
0 g
s
.706 .566 .695 r
.51901 .46723 m .5182 .46984 L .5182 .46727 L F
.5182 .46984 m .50825 .50162 L .5182 .46727 L F
.722 .58 .695 r
.52825 .53803 m .52806 .50218 L .51818 .50157 L p F P
0 g
s
.739 .594 .695 r
.49851 .50034 m .50825 .50162 L p .49803 .50849 L F P
0 g
s
.739 .594 .695 r
.49803 .50849 m .49782 .50863 L .49851 .50034 L F
.722 .58 .695 r
.49851 .50034 m .48861 .49973 L p .49782 .50863 L F P
0 g
s
.755 .61 .697 r
.47596 .52437 m .4791 .4978 L .47546 .52342 L F
.771 .626 .699 r
.46932 .49652 m .46323 .53189 L .45307 .52911 L p F P
0 g
s
.755 .61 .697 r
.45058 .49202 m .44247 .52701 L .45307 .52911 L p F P
0 g
s
.755 .61 .697 r
.4585 .50212 m .45058 .49202 L .45307 .52911 L F
.771 .626 .699 r
.45793 .50494 m .45307 .52911 L .43867 .51919 L F
.46932 .49652 m .45307 .52911 L .45793 .50494 L F
.46932 .49652 m .43275 .52357 L .4352 .51418 L F
.755 .61 .697 r
.47406 .53328 m .48459 .53537 L p .47543 .52369 L F P
0 g
s
.755 .61 .697 r
.48459 .53537 m .4791 .4978 L .47596 .52437 L F
.733 .623 .736 r
.50633 .53742 m .50446 .56428 L .49268 .56279 L p F P
0 g
s
.733 .623 .736 r
.50633 .53742 m .49268 .56279 L .49464 .54446 L F
.719 .611 .735 r
.48459 .53537 m .48069 .56207 L .49268 .56279 L p F P
0 g
s
.733 .623 .736 r
.50633 .53742 m .49464 .54446 L .49488 .5423 L F
.181 0 0 r
.57204 .57749 m .54256 .58117 L .5428 .58063 L F
.57181 .5777 m .54256 .58117 L .57204 .57749 L F
.57003 .57927 m .54256 .58117 L p .57181 .5777 L F P
0 g
s
.384 .815 .963 r
.54256 .58117 m .57003 .57927 L p .54242 .58077 L F P
0 g
s
.237 0 0 r
.54357 .57889 m .51423 .57903 L p .54288 .58044 L F P
0 g
s
.348 .788 .963 r
.54183 .5791 m .54242 .58077 L .51494 .58131 L F
.472 .867 .969 r
.6233 .57008 m .5939 .57373 L .59644 .57521 L F
.426 .841 .966 r
.5936 .57355 m .57003 .57927 L .56928 .5785 L F
.472 .867 .969 r
.62295 .56996 m .59383 .57369 L .6233 .57008 L F
.59383 .57369 m .5939 .57373 L .6233 .57008 L F
.426 .841 .966 r
.59397 .57377 m .57003 .57927 L .5936 .57355 L F
.472 .867 .969 r
.62193 .56958 m .5936 .57355 L .62292 .56994 L F
.5936 .57355 m .59383 .57369 L .62604 .56956 L F
.59713 .5756 m .62362 .5702 L p .59644 .57521 L F P
0 g
s
.472 .867 .969 r
.62362 .5702 m .63701 .56747 L p .6233 .57008 L F P
0 g
s
.472 .867 .969 r
.6233 .57008 m .59644 .57521 L .62362 .5702 L F
.662 .685 .861 r
.62195 .55213 m .62929 .56458 L p .64114 .5612 L F P
0 g
s
.521 .89 .971 r
.62929 .56458 m .62193 .56958 L .61745 .56794 L F
.64114 .5612 m .64024 .5616 L .62929 .56458 L F
.64024 .5616 m .62193 .56958 L .62929 .56458 L F
.384 .815 .963 r
.56989 .57912 m .5424 .58072 L .57003 .57927 L F
.348 .788 .963 r
.54256 .58117 m .51494 .58131 L p .54242 .58077 L F P
0 g
s
.384 .815 .963 r
.5424 .58072 m .52873 .58152 L .54242 .58077 L F
.5424 .58072 m .54242 .58077 L .57003 .57927 L F
.348 .788 .963 r
.55606 .58051 m .54256 .58117 L .54242 .58077 L F
.237 0 0 r
.51423 .57903 m .49948 .57911 L p .51442 .57963 L F P
0 g
s
.279 0 0 r
.51494 .58131 m .48742 .57968 L p .51448 .57983 L F P
0 g
s
.279 0 0 r
.48499 .57729 m .52891 .57991 L p .48684 .57911 L F P
0 g
s
.319 .763 .963 r
.51514 .58051 m .51566 .57837 L .48987 .57683 L F
.51566 .57837 m .51568 .57826 L .5028 .57755 L F
.51566 .57837 m .5028 .57755 L .48987 .57683 L F
.695 .707 .857 r
.50446 .56428 m .5028 .57755 L p .49008 .57615 L F P
0 g
s
.695 .707 .857 r
.50446 .56428 m .49008 .57615 L .49204 .56608 L F
.686 .699 .856 r
.50446 .56428 m .51648 .56422 L p .50343 .57758 L F P
0 g
s
.686 .699 .856 r
.5028 .57755 m .50446 .56428 L p .50343 .57758 L F P
0 g
s
.691 .702 .856 r
.52782 .57825 m .52847 .56848 L .51633 .56685 L F
.319 .763 .963 r
.51514 .58051 m .48987 .57683 L .48936 .57743 L F
.326 0 0 r
.4561 .57368 m .47027 .57642 L p .45719 .57436 L F P
0 g
s
.309 0 0 r
.48684 .57911 m .48229 .57696 L .46703 .57594 L F
.48499 .57729 m .48229 .57696 L p .48684 .57911 L F P
0 g
s
.299 .739 .965 r
.48923 .57757 m .4878 .57924 L .46045 .57614 L F
.314 0 0 r
.40781 .56429 m .38305 .55576 L p .4023 .5618 L F P
0 g
s
.328 0 0 r
.41447 .56467 m .40034 .56091 L p .43132 .56998 L F P
0 g
s
.328 0 0 r
.43132 .56998 m .40034 .56091 L .40189 .56161 L F
.326 0 0 r
.4278 .56821 m .4561 .57368 L p .43175 .5702 L F P
0 g
s
.282 .698 .971 r
.43796 .56943 m .43452 .57079 L .4082 .56419 L F
.282 0 0 r
.35957 .54561 m .38305 .55576 L p .35265 .54261 L F P
0 g
s
0 .323 .713 r
.3606 .54722 m .3705 .55144 L .35957 .54561 L p F P
0 g
s
.282 0 0 r
.38088 .55482 m .35173 .54222 L .38305 .55576 L F
.35173 .54222 m .35265 .54261 L .38305 .55576 L F
0 .349 .772 r
.33472 .53261 m .30391 .51442 L .30746 .51608 L F
.282 0 0 r
.38088 .55482 m .34775 .54049 L .34773 .54048 L F
.37397 .55183 m .34775 .54049 L p .38088 .55482 L F P
0 g
s
0 .376 .819 r
.28441 .49884 m .30391 .51442 L p .29449 .5038 L F P
0 g
s
.002 .401 .851 r
.2957 .50439 m .26726 .48187 L .27148 .48408 L F
0 .376 .819 r
.30746 .51608 m .2957 .50439 L .30391 .51442 L F
.086 .421 .868 r
.2527 .46365 m .26726 .48187 L p .26432 .47019 L F P
0 g
s
.163 .439 .872 r
.26571 .47098 m .24097 .44433 L .24571 .44721 L F
.086 .421 .868 r
.27148 .48408 m .26571 .47098 L .26726 .48187 L F
.233 .453 .868 r
.23227 .42408 m .24097 .44433 L p .24502 .43248 L F P
0 g
s
.294 .465 .859 r
.24655 .43349 m .22683 .40311 L .23191 .40675 L F
.233 .453 .868 r
.24571 .44721 m .24655 .43349 L .24097 .44433 L F
.347 .475 .847 r
.2248 .38163 m .22683 .40311 L p .23817 .3921 L F P
0 g
s
.393 .484 .834 r
.23977 .39335 m .22635 .35988 L .23156 .36436 L F
.347 .475 .847 r
.23191 .40675 m .23977 .39335 L .22683 .40311 L F
.433 .493 .821 r
.23156 .33813 m .22635 .35988 L p .24492 .3508 L F P
0 g
s
.469 .502 .81 r
.24652 .35232 m .24051 .31666 L .24559 .32201 L F
.433 .493 .821 r
.23156 .36436 m .24652 .35232 L .22635 .35988 L F
.5 .51 .799 r
.2532 .29576 m .24051 .31666 L p .26584 .31067 L F P
0 g
s
.528 .519 .789 r
.26735 .31245 m .26958 .27575 L .27424 .28195 L F
.5 .51 .799 r
.24559 .32201 m .26735 .31245 L .24051 .31666 L F
.554 .528 .781 r
.28954 .25693 m .26958 .27575 L p .3007 .27394 L F P
0 g
s
.554 .528 .781 r
.27424 .28195 m .30203 .27597 L .26958 .27575 L F
.577 .537 .774 r
.32777 .26599 m .30592 .28191 L p .31681 .24658 L F P
0 g
s
.577 .537 .774 r
.30203 .27597 m .31681 .24658 L .30592 .28191 L F
.554 .528 .781 r
.30203 .27597 m .31547 .27308 L .3007 .27394 L F
.30203 .27597 m .3007 .27394 L .26958 .27575 L F
.2872 .29922 m .30592 .28191 L p .27424 .28195 L F P
0 g
s
.554 .528 .781 r
.30592 .28191 m .31547 .27308 L p .3109 .27407 L F P
0 g
s
.554 .528 .781 r
.27424 .28195 m .30592 .28191 L .3109 .27407 L F
.637 .567 .759 r
.37976 .23941 m .40923 .2292 L p .37156 .21823 L F P
0 g
s
.651 .618 .804 r
.38335 .24664 m .39074 .26152 L .41805 .25219 L F
.39074 .26152 m .39115 .26234 L .40454 .25729 L F
.39074 .26152 m .40454 .25729 L .41805 .25219 L F
.594 .552 .778 r
.4051 .27684 m .40475 .27637 L .41068 .2722 L p F P
0 g
s
.744 .956 .942 r
.41346 .26892 m .40992 .27227 L .41592 .26755 L F
.701 .956 .95 r
.41068 .2722 m .40475 .27637 L p .40691 .27256 L F P
0 g
s
.744 .956 .942 r
.40992 .27227 m .4051 .27684 L .41049 .27221 L F
.40992 .27227 m .41049 .27221 L .41592 .26755 L F
.612 .56 .772 r
.42254 .26384 m .41592 .26755 L p .41667 .26776 L F P
0 g
s
.574 .545 .784 r
.41624 .26805 m .41592 .26755 L .41068 .2722 L p F P
0 g
s
.744 .956 .942 r
.41068 .2722 m .41592 .26755 L p .4051 .27684 L F P
0 g
s
.701 .956 .95 r
.41068 .2722 m .41083 .27166 L .41624 .26805 L F
.42254 .26384 m .41068 .2722 L p .41624 .26805 L F P
0 g
s
.574 .545 .784 r
.40642 .28905 m .4153 .30023 L .42616 .29467 L F
.41712 .30252 m .42616 .29467 L p .42076 .29743 L F P
0 g
s
.457 .351 .646 r
.41728 .30306 m .43744 .33691 L .42659 .2963 L F
.42 .515 .85 r
.37981 .3492 m .38953 .34526 L .37445 .34587 L F
.452 .519 .836 r
.37379 .34048 m .37337 .34021 L .37419 .33463 L p F P
0 g
s
.384 .513 .864 r
.37383 .34085 m .37337 .34021 L .3738 .34058 L F
.84 .856 .856 r
.37299 .35223 m .37442 .35138 L .37434 .34581 L p F P
0 g
s
.84 .856 .856 r
.37434 .34581 m .37419 .33463 L p .37379 .34048 L F P
0 g
s
.345 .511 .878 r
.38511 .37019 m .39561 .36757 L .39124 .36514 L F
.302 .509 .892 r
.39913 .38413 m .38 .36766 L .38511 .37019 L F
.39774 .38352 m .38 .36766 L .39913 .38413 L F
.39774 .38352 m .38548 .37813 L .38 .36766 L F
.345 .511 .878 r
.37626 .35684 m .3799 .36761 L p .39124 .36514 L F P
0 g
s
.302 .509 .892 r
.38519 .378 m .3799 .36761 L p .3882 .38334 L F P
0 g
s
.302 .509 .892 r
.3882 .38334 m .3799 .36761 L .38 .36766 L F
.829 .793 .818 r
.35687 .37618 m .35884 .37485 L p .35893 .37542 L F P
0 g
s
.345 .511 .878 r
.3799 .36761 m .38172 .37298 L p .38196 .37278 L F P
0 g
s
.813 .755 .798 r
.3958 .39297 m .38655 .38431 L .39204 .3879 L F
.203 .507 .91 r
.39204 .3879 m .38783 .38318 L p .39213 .38794 L F P
0 g
s
.813 .755 .798 r
.37896 .40027 m .36916 .39966 L .38042 .39888 L F
.829 .793 .818 r
.37096 .39807 m .36916 .39966 L .36611 .39383 L p F P
0 g
s
.87 .751 .729 r
.34971 .42854 m .36824 .40103 L p .38351 .41542 L F P
0 g
s
.87 .751 .729 r
.36824 .40103 m .36916 .39966 L .37399 .40496 L p F P
0 g
s
.87 .751 .729 r
.37399 .40496 m .38351 .41542 L p .36824 .40103 L F P
0 g
s
.886 .779 .737 r
.36611 .39383 m .36211 .38818 L p .36201 .39025 L F P
0 g
s
.886 .779 .737 r
.36154 .40031 m .36611 .39383 L .36201 .39025 L F
.822 .773 .807 r
.38172 .37298 m .36211 .38818 L .36611 .39383 L p F P
0 g
s
.902 .809 .746 r
.31401 .42937 m .3356 .40253 L .33917 .40912 L p F P
0 g
s
.916 .842 .756 r
.34164 .41583 m .36114 .38948 L p .3595 .38357 L F P
0 g
s
.916 .842 .756 r
.34164 .41583 m .3595 .38357 L .35799 .38547 L F
.34164 .41583 m .35933 .38297 L .34669 .39937 L F
.886 .779 .737 r
.36211 .38818 m .34164 .41583 L .34621 .42209 L p F P
0 g
s
.902 .809 .746 r
.36916 .39966 m .34971 .42854 L .34621 .42209 L p F P
0 g
s
.886 .779 .737 r
.35996 .40256 m .3601 .40159 L .34621 .42209 L F
.3601 .40159 m .36211 .38818 L .34621 .42209 L F
.902 .809 .746 r
.36916 .39966 m .34621 .42209 L .36154 .40031 L F
.886 .779 .737 r
.36033 .42636 m .36211 .38818 L .35519 .43441 L F
.902 .809 .746 r
.3356 .40253 m .35687 .37618 L .35969 .38156 L p F P
0 g
s
.902 .809 .746 r
.35969 .38156 m .35998 .38212 L p .35809 .38371 L F P
0 g
s
.902 .809 .746 r
.35809 .38371 m .3356 .40253 L .35969 .38156 L F
.917 .842 .755 r
.32091 .44395 m .34164 .41583 L .33917 .40912 L p F P
0 g
s
.902 .809 .746 r
.33917 .40912 m .3356 .40253 L p .34487 .40174 L F P
0 g
s
.917 .842 .755 r
.32363 .43 m .33917 .40912 L .3238 .42915 L F
.32091 .44395 m .33917 .40912 L .32363 .43 L F
.916 .842 .756 r
.34164 .41583 m .34669 .39937 L .34487 .40174 L F
.902 .809 .746 r
.34621 .42209 m .34971 .42854 L p .34171 .42873 L F P
0 g
s
.886 .779 .737 r
.35519 .43441 m .35967 .44054 L p .36033 .42636 L F P
0 g
s
.87 .751 .728 r
.35519 .43441 m .366 .44595 L p .34149 .45595 L F P
0 g
s
.87 .751 .728 r
.34149 .45595 m .3407 .45627 L .35519 .43441 L F
.36191 .45312 m .34135 .45618 L .366 .44595 L F
.34135 .45618 m .3407 .45627 L .34149 .45595 L F
.34135 .45618 m .34149 .45595 L .366 .44595 L F
.3362 .46427 m .33003 .45786 L p .34135 .45618 L F P
0 g
s
.87 .751 .728 r
.3407 .45627 m .33003 .45786 L .35519 .43441 L F
.902 .809 .746 r
.34971 .42854 m .33003 .45786 L .32606 .4508 L p F P
0 g
s
.887 .778 .737 r
.34164 .41583 m .32091 .44395 L .32606 .4508 L p F P
0 g
s
.887 .778 .737 r
.33993 .43103 m .34164 .41583 L .32606 .4508 L F
.902 .809 .746 r
.34971 .42854 m .32606 .4508 L .34155 .42873 L F
.887 .778 .737 r
.34135 .45618 m .34164 .41583 L .3362 .46427 L F
.902 .809 .746 r
.31808 .4366 m .31401 .42937 L p .3238 .42915 L F P
0 g
s
.902 .809 .746 r
.32324 .42916 m .31401 .42937 L .33917 .40912 L F
.917 .842 .755 r
.3317 .38878 m .30948 .41428 L .31238 .42181 L p F P
0 g
s
.917 .842 .755 r
.32742 .40378 m .3317 .38878 L .31238 .42181 L F
.887 .778 .737 r
.34621 .42209 m .34164 .41583 L p .34155 .42873 L F P
0 g
s
.902 .809 .746 r
.34155 .42873 m .32324 .42916 L .34621 .42209 L F
.32396 .42894 m .32324 .42916 L .33917 .40912 L F
.928 .877 .765 r
.3356 .40253 m .31401 .42937 L .31238 .42181 L p F P
0 g
s
.928 .877 .765 r
.3356 .40253 m .31238 .42181 L .32917 .40168 L F
.917 .842 .755 r
.3238 .42915 m .32917 .40168 L .31808 .4366 L F
.32917 .40168 m .3317 .38878 L .32742 .40378 L F
.32917 .40168 m .32742 .40378 L .31808 .4366 L F
.928 .877 .765 r
.3091 .40658 m .30743 .39882 L p .31517 .39984 L F P
0 g
s
.93 .949 .779 r
.33002 .37473 m .30833 .39108 L .3257 .37309 L F
.934 .914 .774 r
.30833 .39108 m .3091 .40658 L p .3257 .37309 L F P
0 g
s
.934 .914 .774 r
.3091 .40658 m .30948 .41428 L p .31517 .39984 L F P
0 g
s
.934 .914 .774 r
.31517 .39984 m .3257 .37309 L .3091 .40658 L F
.928 .877 .765 r
.31238 .42181 m .3091 .40658 L p .32917 .40168 L F P
0 g
s
.928 .877 .765 r
.32917 .40168 m .3091 .40658 L .31517 .39984 L F
.33422 .39564 m .3356 .40253 L p .32917 .40168 L F P
0 g
s
.902 .809 .746 r
.34669 .39937 m .3356 .40253 L .35998 .38212 L F
.36154 .40031 m .34487 .40174 L .36611 .39383 L F
.34487 .40174 m .3356 .40253 L .34669 .39937 L F
.34487 .40174 m .34669 .39937 L .36611 .39383 L F
.916 .842 .756 r
.35355 .3638 m .3317 .38878 L .33422 .39564 L p F P
0 g
s
.916 .842 .756 r
.34908 .3779 m .35355 .3638 L .33422 .39564 L F
.928 .877 .766 r
.35687 .37618 m .34908 .3779 L .35079 .37585 L F
.916 .842 .756 r
.34487 .40174 m .35079 .37585 L .33917 .40912 L F
.35079 .37585 m .35355 .3638 L .34908 .3779 L F
.35079 .37585 m .34908 .3779 L .33917 .40912 L F
.345 .511 .878 r
.38511 .37019 m .39124 .36514 L .3799 .36761 L F
.384 .513 .864 r
.37763 .36256 m .37722 .36234 L .37626 .35684 L p F P
0 g
s
.835 .813 .829 r
.36211 .38818 m .38037 .37403 L p .37888 .36836 L F P
0 g
s
.835 .813 .829 r
.36211 .38818 m .37888 .36836 L .36547 .37813 L F
.822 .773 .807 r
.37933 .38286 m .38172 .37298 L .36611 .39383 L F
.829 .793 .818 r
.38783 .38318 m .37096 .39807 L p .36611 .39383 L F P
0 g
s
.829 .793 .818 r
.38783 .38318 m .36611 .39383 L .38085 .3816 L F
.822 .773 .807 r
.37896 .40027 m .38172 .37298 L .37399 .40496 L F
.829 .793 .818 r
.35998 .38212 m .35687 .37618 L p .36547 .37813 L F P
0 g
s
.829 .793 .818 r
.37898 .36829 m .35687 .37618 L .37883 .36801 L F
.36723 .37685 m .35687 .37618 L .37898 .36829 L F
.37722 .36234 m .3799 .36761 L p .35893 .37542 L F P
0 g
s
.829 .793 .818 r
.35884 .37485 m .37722 .36234 L p .35893 .37542 L F P
0 g
s
.835 .813 .829 r
.37442 .35138 m .35557 .3626 L p .35572 .36997 L F P
0 g
s
.835 .813 .829 r
.35557 .3626 m .35355 .3638 L .35572 .36997 L p F P
0 g
s
.384 .513 .864 r
.37434 .34581 m .37337 .34021 L p .37383 .34085 L F P
0 g
s
.84 .856 .856 r
.35355 .3638 m .37299 .35223 L p .37339 .34634 L F P
0 g
s
.84 .856 .856 r
.35355 .3638 m .37339 .34634 L .3643 .35141 L F
.835 .813 .829 r
.36996 .36087 m .37442 .35138 L .35572 .36997 L F
.839 .834 .842 r
.37722 .36234 m .35687 .37618 L .35572 .36997 L p F P
0 g
s
.839 .834 .842 r
.37722 .36234 m .35572 .36997 L .36996 .36087 L F
.835 .813 .829 r
.37159 .35983 m .37442 .35138 L .36996 .36087 L F
.384 .513 .864 r
.37337 .34021 m .37379 .34048 L p .3738 .34058 L F P
0 g
s
.839 .878 .871 r
.37228 .33932 m .36939 .33695 L .37323 .33509 L F
.833 .899 .886 r
.35481 .33218 m .35291 .33843 L p .36062 .32977 L F P
0 g
s
.839 .878 .871 r
.37337 .34021 m .35221 .35117 L .35569 .32574 L p F P
0 g
s
.84 .856 .856 r
.35355 .3638 m .37379 .34048 L .37331 .33587 L F
.35355 .3638 m .37419 .33463 L .36939 .33695 L F
.839 .834 .842 r
.37159 .35983 m .35339 .3575 L .35917 .35428 L F
.37722 .36234 m .36996 .36087 L .37159 .35983 L F
.36996 .36087 m .35339 .3575 L .37159 .35983 L F
.37569 .36166 m .37159 .35983 L .37533 .35744 L F
.302 .509 .892 r
.3799 .36761 m .37722 .36234 L p .37945 .3666 L F P
0 g
s
.835 .813 .829 r
.38037 .37403 m .38172 .37298 L .3799 .36761 L p F P
0 g
s
.829 .793 .818 r
.379 .36827 m .37883 .36801 L .3799 .36761 L F
.835 .813 .829 r
.3799 .36761 m .37626 .35684 L p .37763 .36256 L F P
0 g
s
.302 .509 .892 r
.38511 .37019 m .38 .36766 L .37945 .3666 L F
.37779 .3629 m .37945 .3666 L .37722 .36234 L F
.38511 .37019 m .37945 .3666 L .37779 .3629 L F
.879 .454 .051 r
.4091 .39452 m .40546 .39042 L p .41293 .39914 L F P
0 g
s
.826 .414 0 r
.40928 .39495 m .40732 .39221 L .4091 .39452 L F
.254 .508 .903 r
.40249 .38656 m .40521 .38984 L .4032 .38592 L F
.302 .509 .892 r
.40032 .38213 m .37779 .3629 L .39327 .37075 L F
.40546 .39042 m .40177 .38675 L .40032 .38213 L F
.40177 .38675 m .37779 .3629 L .40032 .38213 L F
.4032 .38592 m .40546 .39042 L p .40032 .38213 L F P
0 g
s
.302 .509 .892 r
.40032 .38213 m .39327 .37075 L .39995 .38096 L F
.40032 .38213 m .39995 .38096 L .4032 .38592 L F
.39639 .37233 m .4032 .38592 L p .39664 .37589 L F P
0 g
s
.302 .509 .892 r
.39664 .37589 m .39327 .37075 L .39639 .37233 L F
0 0 .372 r
.39561 .36757 m .39868 .3769 L p .39742 .37287 L F P
0 g
s
0 0 .372 r
.39742 .37287 m .39615 .36883 L .39561 .36757 L F
.826 .414 0 r
.4065 .39096 m .40457 .38827 L .40641 .39081 L F
.40732 .39221 m .40457 .38827 L .4065 .39096 L F
.71 .337 0 r
.40546 .39042 m .4032 .38592 L p .40371 .3871 L F P
0 g
s
.302 .509 .892 r
.40546 .39042 m .39774 .38352 L .39913 .38413 L F
.40546 .39042 m .3882 .38334 L p .38548 .37813 L F P
0 g
s
.302 .509 .892 r
.40546 .39042 m .38548 .37813 L .39774 .38352 L F
.71 .337 0 r
.40621 .39216 m .40546 .39042 L p .40371 .3871 L F P
0 g
s
.096 .504 .904 r
.41406 .40703 m .40449 .40185 L .42465 .41014 L F
.784 .705 .776 r
.42394 .43598 m .42088 .41369 L .4177 .4183 L F
.149 .506 .911 r
.41482 .41014 m .42884 .4139 L .42465 .41014 L p F P
0 g
s
.149 .506 .911 r
.41482 .41014 m .42465 .41014 L .41535 .40741 L F
.794 .72 .782 r
.42025 .41461 m .39879 .4198 L .41 .40583 L F
.4177 .4183 m .39879 .4198 L .42025 .41461 L F
.71 .337 0 r
.42223 .42917 m .40621 .39216 L p .40378 .38724 L F P
0 g
s
.254 .508 .903 r
.39913 .38413 m .40124 .38506 L .40022 .38156 L F
.4032 .38592 m .40022 .38156 L p .40124 .38506 L F P
0 g
s
.826 .414 0 r
.401 .38336 m .40022 .38156 L .4032 .38592 L p F P
0 g
s
.826 .414 0 r
.4032 .38592 m .4091 .39452 L p .40371 .3871 L F P
0 g
s
.826 .414 0 r
.40371 .3871 m .401 .38336 L .4032 .38592 L F
.71 .337 0 r
.40378 .38724 m .39868 .3769 L .39888 .37736 L F
.40371 .3871 m .39868 .3769 L .40378 .38724 L F
0 0 .372 r
.40022 .38156 m .39921 .37812 L .39882 .37721 L F
.40022 .38156 m .40074 .38259 L .39921 .37812 L F
.826 .414 0 r
.40211 .3849 m .401 .38336 L .40208 .38484 L F
.40378 .38724 m .40368 .38706 L .40371 .3871 L F
0 0 .372 r
.39868 .3769 m .40022 .38156 L p .39882 .37721 L F P
0 g
s
0 0 .372 r
.39882 .37721 m .39742 .37287 L .39868 .3769 L F
.71 .337 0 r
.40621 .39216 m .40371 .3871 L .40378 .38724 L F
.42223 .42917 m .40378 .38724 L .41649 .41655 L F
.879 .454 .051 r
.40973 .396 m .40958 .39566 L .4067 .39267 L F
.4067 .39267 m .41293 .39914 L .40546 .39042 L F
.096 .504 .904 r
.42659 .41768 m .42632 .41762 L .42088 .41369 L p F P
0 g
s
.005 .503 .865 r
.42632 .41762 m .42659 .41768 L p .4267 .41773 L F P
0 g
s
.005 .503 .865 r
.45476 .4283 m .4361 .42138 L .44328 .42287 L F
.44962 .4257 m .44328 .42287 L .44456 .42313 L F
.45476 .4283 m .44328 .42287 L .44962 .4257 L F
0 .505 .837 r
.461 .43253 m .453 .42801 L .44597 .42686 L F
.005 .503 .865 r
.45358 .42811 m .4361 .42138 L .45476 .4283 L F
0 .505 .837 r
.453 .42801 m .44978 .4262 L .44597 .42686 L F
.005 .503 .865 r
.45688 .42938 m .45358 .42811 L .45476 .4283 L F
0 .505 .837 r
.46261 .43237 m .45684 .42905 L .46188 .43228 L F
.45684 .42905 m .45585 .42848 L .45664 .42898 L F
.45684 .42905 m .45664 .42898 L .46188 .43228 L F
0 .511 .806 r
.475 .43515 m .46188 .43228 L .46697 .43289 L F
.48028 .43664 m .47861 .43624 L .475 .43515 L F
.47861 .43624 m .46188 .43228 L .475 .43515 L F
.47904 .43655 m .46188 .43228 L .48028 .43664 L F
.46788 .433 m .48051 .43665 L p .46697 .43289 L F P
0 g
s
0 .511 .806 r
.48051 .43665 m .48685 .43848 L p .46697 .43289 L F P
0 g
s
0 .505 .837 r
.46647 .43459 m .47268 .43516 L p .45585 .42848 L F P
0 g
s
0 .505 .837 r
.45502 .43027 m .43909 .42427 L .45498 .43027 L F
.45502 .43027 m .45498 .43027 L .45958 .432 L F
.45962 .43201 m .45502 .43027 L .45958 .432 L F
.763 .676 .767 r
.45958 .432 m .44581 .42684 L p .45249 .42993 L F P
0 g
s
0 .505 .837 r
.46615 .43443 m .44978 .4262 L .461 .43253 L F
.005 .503 .865 r
.46151 .43116 m .45249 .42993 L p .44581 .42684 L F P
0 g
s
.005 .503 .865 r
.45249 .42993 m .45229 .4299 L .44581 .42684 L p F P
0 g
s
.763 .676 .767 r
.44636 .42813 m .45249 .42993 L .44581 .42684 L F
0 .511 .806 r
.45262 .42996 m .45229 .4299 L .45249 .42993 L F
0 .505 .837 r
.47268 .43516 m .47391 .43527 L .45585 .42848 L p F P
0 g
s
0 .511 .806 r
.46188 .43228 m .45229 .4299 L .46788 .433 L F
.45958 .432 m .45229 .4299 L p .46188 .43228 L F P
0 g
s
.763 .676 .767 r
.45402 .44627 m .45958 .432 L .44636 .42813 L F
0 .511 .806 r
.46151 .43116 m .46205 .43184 L p .45262 .42996 L F P
0 g
s
0 .511 .806 r
.45262 .42996 m .45249 .42993 L .46151 .43116 L F
.716 .628 .758 r
.49649 .44088 m .49299 .46204 L p .50165 .46334 L F P
0 g
s
.716 .628 .758 r
.50344 .44861 m .49649 .44088 L .50165 .46334 L F
.49299 .46204 m .49262 .46429 L .50147 .46485 L p F P
0 g
s
.728 .639 .759 r
.51203 .44243 m .51035 .46375 L p .50147 .46485 L F P
0 g
s
.728 .639 .759 r
.51203 .44243 m .50147 .46485 L .50367 .44675 L F
.704 .618 .758 r
.54336 .44226 m .54557 .46583 L .5367 .46587 L p F P
0 g
s
.704 .618 .758 r
.54336 .44226 m .5367 .46587 L .53577 .44769 L F
.679 .599 .759 r
.55336 .45814 m .54557 .46583 L .55308 .45608 L F
.692 .608 .758 r
.55336 .45814 m .55103 .44114 L .53556 .44338 L F
.53577 .44769 m .53556 .44338 L .52991 .4442 L F
.55336 .45814 m .53556 .44338 L .53577 .44769 L F
.716 .628 .758 r
.51905 .46597 m .52788 .46653 L p .51927 .4595 L F P
0 g
s
.666 .591 .761 r
.55885 .44055 m .56308 .46392 L .57152 .46207 L p F P
0 g
s
.666 .591 .761 r
.56792 .44603 m .55885 .44055 L .57152 .46207 L F
.679 .599 .759 r
.57401 .43777 m .57963 .4586 L p .57152 .46207 L F P
0 g
s
.679 .599 .759 r
.57401 .43777 m .57152 .46207 L .5675 .44419 L F
.666 .591 .761 r
.58639 .45214 m .55885 .44055 L .58836 .45839 L F
.692 .608 .758 r
.56054 .46241 m .55336 .45814 L .55424 .46457 L F
.679 .599 .759 r
.57152 .46207 m .55424 .46457 L p .5675 .44419 L F P
0 g
s
.679 .599 .759 r
.55424 .46457 m .54557 .46583 L p .55336 .45814 L F P
0 g
s
.679 .599 .759 r
.5675 .44419 m .55424 .46457 L .55336 .45814 L F
.692 .608 .758 r
.55336 .45814 m .5277 .44289 L .55424 .46457 L F
.5277 .44289 m .52786 .46426 L p .55424 .46457 L F P
0 g
s
.692 .608 .758 r
.52786 .46426 m .52788 .46653 L .5367 .46587 L p F P
0 g
s
.692 .608 .758 r
.5367 .46587 m .55424 .46457 L p .52786 .46426 L F P
0 g
s
.722 .58 .695 r
.52789 .46822 m .51905 .46597 L .51901 .46723 L F
.689 .553 .695 r
.52788 .46653 m .52806 .50218 L .53793 .50147 L p F P
0 g
s
.653 .527 .698 r
.59375 .48376 m .57152 .46207 L .56473 .46498 L F
.671 .54 .696 r
.57276 .47018 m .55666 .49038 L .57152 .46207 L F
.55666 .49038 m .54786 .50142 L .55637 .48727 L F
.55666 .49038 m .55637 .48727 L .57152 .46207 L F
.689 .553 .695 r
.53708 .47691 m .52788 .46653 L .53793 .50147 L F
.722 .58 .695 r
.51818 .50157 m .52806 .50218 L p .51864 .4921 L F P
0 g
s
.722 .58 .695 r
.51864 .4921 m .51842 .49187 L .51818 .50157 L F
.706 .566 .694 r
.50633 .53742 m .50825 .50162 L .51818 .50157 L p F P
0 g
s
.706 .566 .694 r
.51755 .52769 m .5169 .52825 L .51818 .50157 L F
.5169 .52825 m .50633 .53742 L .51818 .50157 L F
.706 .566 .695 r
.51818 .50157 m .50825 .50162 L p .51842 .49187 L F P
0 g
s
.739 .594 .695 r
.50825 .50162 m .50633 .53742 L .49555 .53603 L p F P
0 g
s
.722 .58 .695 r
.48861 .49973 m .48459 .53537 L .49555 .53603 L p F P
0 g
s
.722 .58 .695 r
.49782 .50863 m .48861 .49973 L .49555 .53603 L F
.739 .594 .695 r
.49758 .5115 m .49555 .53603 L .47958 .52817 L F
.50825 .50162 m .49555 .53603 L .49758 .5115 L F
.771 .626 .699 r
.46014 .49396 m .46932 .49652 L p .4585 .50212 L F P
0 g
s
.755 .61 .697 r
.47543 .52369 m .46014 .49396 L .4585 .50212 L F
.47596 .52437 m .47546 .52342 L .47543 .52369 L F
.47546 .52342 m .46014 .49396 L .47543 .52369 L F
.739 .594 .695 r
.50825 .50162 m .47406 .53328 L .47543 .52369 L F
.705 .599 .735 r
.50446 .56428 m .50633 .53742 L .51732 .53736 L p F P
0 g
s
.706 .566 .694 r
.51732 .53736 m .50633 .53742 L p .51755 .52769 L F P
0 g
s
.722 .58 .695 r
.51738 .53486 m .49782 .50863 L .49616 .52868 L F
.52825 .53803 m .51755 .52769 L .51738 .53486 L F
.51755 .52769 m .49782 .50863 L .51738 .53486 L F
.51732 .53736 m .52825 .53803 L p .49616 .52868 L F P
0 g
s
.722 .58 .695 r
.52825 .53803 m .51818 .50157 L .51817 .52829 L F
.689 .552 .695 r
.52806 .50218 m .52825 .53803 L .53917 .53725 L p F P
0 g
s
.706 .566 .694 r
.54786 .50142 m .55016 .53719 L .53917 .53725 L p F P
0 g
s
.706 .566 .694 r
.54786 .50142 m .53917 .53725 L .53832 .51265 L F
.671 .539 .696 r
.5609 .5357 m .55016 .53719 L p .56 .52607 L F P
0 g
s
.671 .539 .696 r
.57816 .50552 m .55016 .53719 L .57691 .4973 L F
.689 .552 .695 r
.53917 .53725 m .5609 .5357 L p .53832 .51265 L F P
0 g
s
.689 .552 .695 r
.53832 .51265 m .52806 .50218 L .53917 .53725 L F
.706 .566 .694 r
.53917 .53725 m .51732 .53736 L p .53832 .51265 L F P
0 g
s
.722 .58 .695 r
.51817 .52829 m .51818 .50157 L .51756 .52742 L F
.51817 .52829 m .49851 .50034 L .49782 .50863 L F
.706 .566 .694 r
.54786 .50142 m .53832 .51265 L .53822 .50978 L F
.689 .552 .695 r
.56 .52607 m .53822 .50978 L .5609 .5357 L F
.53822 .50978 m .52806 .50218 L .53832 .51265 L F
.53822 .50978 m .53832 .51265 L .5609 .5357 L F
.706 .566 .694 r
.53822 .50978 m .51732 .53736 L .51755 .52769 L F
.53832 .51265 m .51732 .53736 L .53822 .50978 L F
.719 .611 .735 r
.52835 .55219 m .52825 .53803 L .51732 .53736 L p F P
0 g
s
.705 .599 .735 r
.5167 .55702 m .50446 .56428 L .51732 .53736 L F
.719 .611 .735 r
.49488 .5423 m .48459 .53537 L .49268 .56279 L F
.49488 .5423 m .49518 .53944 L .48459 .53537 L F
.49555 .53603 m .48459 .53537 L p .49518 .53944 L F P
0 g
s
.747 .636 .738 r
.48254 .54942 m .48459 .53537 L .47406 .53328 L p F P
0 g
s
.733 .623 .736 r
.45733 .55833 m .46323 .53189 L .47406 .53328 L p F P
0 g
s
.733 .623 .736 r
.47091 .5504 m .45733 .55833 L .47406 .53328 L F
.739 .594 .695 r
.47406 .53328 m .46323 .53189 L p .47543 .52369 L F P
0 g
s
.76 .65 .741 r
.46323 .53189 m .45733 .55833 L .4462 .55534 L p F P
0 g
s
.314 0 0 r
.4023 .5618 m .38305 .55576 L .38088 .55482 L F
.285 .681 .972 r
.4082 .56419 m .40269 .56139 L .39997 .5612 L F
.314 0 0 r
.37397 .55183 m .40034 .56091 L p .38013 .5545 L F P
0 g
s
.285 .681 .972 r
.40269 .56139 m .38966 .55478 L .39997 .5612 L F
.38966 .55478 m .3889 .5549 L .39997 .5612 L F
0 .323 .713 r
.35957 .54561 m .33762 .5339 L p .35173 .54222 L F P
0 g
s
0 .323 .713 r
.35173 .54222 m .33762 .5339 L .33472 .53261 L F
.282 0 0 r
.35173 .54222 m .33623 .53551 L .35265 .54261 L F
.34786 .54054 m .34766 .54046 L .35957 .54561 L p F P
0 g
s
.282 0 0 r
.34766 .54046 m .3477 .54048 L p .33623 .53551 L F P
0 g
s
0 .323 .713 r
.3255 .52851 m .34894 .54101 L p .33373 .53217 L F P
0 g
s
0 .323 .713 r
.35173 .54222 m .32927 .52954 L .34894 .54101 L F
.32927 .52954 m .32647 .52795 L .32848 .52912 L F
.32927 .52954 m .32848 .52912 L .34894 .54101 L F
.086 .421 .868 r
.26571 .47098 m .26432 .47019 L .26726 .48187 L F
.002 .401 .851 r
.2957 .50439 m .27148 .48408 L .29925 .50614 L F
.27148 .48408 m .27286 .48481 L .29925 .50614 L F
.233 .453 .868 r
.24655 .43349 m .24502 .43248 L .24097 .44433 L F
.163 .439 .872 r
.25897 .45528 m .2698 .47328 L p .24726 .44815 L F P
0 g
s
.347 .475 .847 r
.23977 .39335 m .23817 .3921 L .22683 .40311 L F
.294 .465 .859 r
.24613 .41695 m .25103 .43644 L p .23358 .40795 L F P
0 g
s
.433 .493 .821 r
.24652 .35232 m .24492 .3508 L .22635 .35988 L F
.393 .484 .834 r
.24611 .37687 m .24445 .39702 L p .23326 .36583 L F P
0 g
s
.5 .51 .799 r
.26735 .31245 m .26584 .31067 L .24051 .31666 L F
.469 .502 .81 r
.25974 .33692 m .25119 .35675 L p .24725 .32376 L F P
0 g
s
.528 .519 .789 r
.2872 .29922 m .27176 .31765 L p .27576 .28398 L F P
0 g
s
.528 .519 .789 r
.26735 .31245 m .27795 .26553 L .27176 .31765 L F
.5 .51 .799 r
.25974 .33692 m .27176 .31765 L p .24559 .32201 L F P
0 g
s
.5 .51 .799 r
.27176 .31765 m .2779 .30781 L p .27431 .30939 L F P
0 g
s
.5 .51 .799 r
.24559 .32201 m .27176 .31765 L .27431 .30939 L F
.578 .594 .832 r
.28632 .33006 m .27461 .32008 L .28811 .30011 L F
.28632 .33006 m .28811 .30011 L .292 .30395 L F
.594 .597 .825 r
.30592 .28191 m .2872 .29922 L p .31739 .29505 L F P
0 g
s
.618 .557 .763 r
.35248 .25174 m .37252 .22072 L .37885 .23706 L F
.637 .567 .759 r
.37156 .21823 m .40923 .2292 L .40711 .22215 L F
.618 .557 .763 r
.34936 .24518 m .37156 .21823 L .35248 .25174 L F
.672 .589 .753 r
.4405 .22132 m .47308 .21591 L p .43565 .19893 L F P
0 g
s
.612 .56 .772 r
.4427 .25319 m .44245 .25265 L .43576 .25641 L p F P
0 g
s
.591 .93 .955 r
.42854 .2596 m .43279 .25626 L .43554 .25639 L F
.65 .947 .955 r
.43576 .25641 m .44245 .25265 L p .43279 .25626 L F P
0 g
s
.591 .93 .955 r
.43576 .25641 m .42854 .2596 L p .44053 .2541 L F P
0 g
s
.645 .577 .763 r
.44245 .25265 m .4427 .25319 L p .44321 .25297 L F P
0 g
s
.661 .586 .76 r
.48796 .26777 m .47388 .27122 L p .48362 .24826 L F P
0 g
s
.661 .586 .76 r
.47203 .26528 m .48362 .24826 L .47388 .27122 L F
.645 .577 .763 r
.4502 .25001 m .44245 .25265 L p .44321 .25297 L F P
0 g
s
.591 .93 .955 r
.45681 .24664 m .45749 .24678 L .4502 .25001 L p F P
0 g
s
.528 .905 .953 r
.44245 .25265 m .4502 .25001 L p .43203 .25131 L F P
0 g
s
.528 .905 .953 r
.43024 .25144 m .43143 .25156 L p .43203 .25131 L F P
0 g
s
.528 .905 .953 r
.43143 .25156 m .44245 .25265 L p .43203 .25131 L F P
0 g
s
.591 .93 .955 r
.4497 .24994 m .45681 .24664 L .4502 .25001 L F
.528 .905 .953 r
.43024 .25144 m .4502 .25001 L .44218 .24886 L F
.701 .956 .95 r
.42854 .2596 m .42254 .26384 L p .41509 .25981 L F P
0 g
s
.701 .956 .95 r
.41436 .25941 m .41574 .25943 L p .41509 .25981 L F P
0 g
s
.701 .956 .95 r
.41574 .25943 m .42854 .2596 L p .41509 .25981 L F P
0 g
s
.701 .956 .95 r
.41301 .2641 m .41436 .25941 L .42254 .26384 L F
.65 .947 .955 r
.41592 .26755 m .42254 .26384 L p .402 .26809 L F P
0 g
s
.65 .947 .955 r
.40153 .26841 m .41592 .26755 L p .402 .26809 L F P
0 g
s
.594 .552 .778 r
.42854 .2596 m .42882 .26012 L p .42871 .26019 L F P
0 g
s
.629 .568 .767 r
.42882 .26012 m .42854 .2596 L .43576 .25641 L p F P
0 g
s
.65 .947 .955 r
.43426 .25692 m .42882 .26012 L .43576 .25641 L F
.42254 .26384 m .43576 .25641 L p .42882 .26012 L F P
0 g
s
.528 .905 .953 r
.4502 .25001 m .46566 .24475 L p .45769 .24734 L F P
0 g
s
.612 .56 .772 r
.44504 .27992 m .44152 .28304 L .44797 .28116 L F
.42766 .27254 m .43648 .28752 L .44504 .27992 L F
.629 .568 .767 r
.4417 .2839 m .42882 .26012 L p .45025 .25015 L F P
0 g
s
.645 .577 .763 r
.46566 .24475 m .4502 .25001 L p .47138 .2632 L F P
0 g
s
.629 .568 .767 r
.4417 .2839 m .45025 .25015 L .45098 .25196 L F
.661 .586 .76 r
.47203 .26528 m .46579 .24518 L .48197 .24086 L F
.47203 .26528 m .48197 .24086 L .48362 .24826 L F
.69 .606 .757 r
.50246 .26467 m .50215 .26244 L .50988 .26331 L F
.51747 .26418 m .50256 .26541 L p .50988 .26331 L F P
0 g
s
.676 .595 .758 r
.48362 .24826 m .50256 .26541 L .50172 .25925 L F
.48415 .25066 m .50256 .26541 L .48362 .24826 L F
.4999 .26328 m .49499 .26513 L .50256 .26541 L F
.69 .606 .757 r
.50256 .26541 m .49506 .26603 L p .50988 .26331 L F P
0 g
s
.69 .606 .757 r
.50215 .26244 m .51653 .24548 L .51747 .26418 L F
.731 .641 .758 r
.55077 .23778 m .56339 .26125 L .56766 .24064 L F
.54986 .24532 m .56339 .26125 L .55077 .23778 L F
.704 .617 .756 r
.51747 .26418 m .53251 .26409 L p .53261 .26109 L F P
0 g
s
.704 .617 .756 r
.51647 .24422 m .51747 .26418 L .53261 .26109 L F
.51647 .24422 m .53261 .26109 L .53273 .25788 L F
.718 .628 .757 r
.53348 .23639 m .55079 .23764 L p .53273 .25788 L F P
0 g
s
.731 .641 .758 r
.56775 .2402 m .55079 .23764 L p .56767 .24059 L F P
0 g
s
.757 .667 .763 r
.59977 .24913 m .58416 .24405 L p .59963 .2495 L F P
0 g
s
.77 .682 .766 r
.59977 .24913 m .6144 .25535 L p .59285 .26712 L F P
0 g
s
.757 .667 .763 r
.58411 .2442 m .60736 .25222 L .58416 .24405 L F
.77 .682 .766 r
.59219 .24655 m .59238 .24598 L .59977 .24913 L p F P
0 g
s
.744 .654 .76 r
.58416 .24405 m .59238 .24598 L p .59164 .24638 L F P
0 g
s
.214 .653 .952 r
.58416 .24405 m .59977 .24913 L p .59219 .24655 L F P
0 g
s
.757 .667 .763 r
.58197 .25147 m .59207 .26915 L .58411 .2442 L F
.744 .654 .76 r
.56775 .2402 m .58416 .24405 L p .56339 .26125 L F P
0 g
s
.744 .654 .76 r
.56339 .26125 m .58416 .24405 L .58197 .25147 L F
.757 .667 .763 r
.59396 .27248 m .59091 .27215 L .59662 .27712 L F
.57632 .27062 m .58984 .27495 L p .58356 .27138 L F P
0 g
s
.791 .599 .642 r
.58984 .27495 m .57632 .27062 L p .58296 .27366 L F P
0 g
s
.791 .599 .642 r
.5761 .27237 m .58262 .31981 L .58984 .27495 L F
.718 .628 .757 r
.54746 .26515 m .53251 .26409 L p .54956 .24776 L F P
0 g
s
.702 .521 .64 r
.51749 .26478 m .5318 .31041 L .53248 .26588 L F
.679 .503 .64 r
.51751 .26597 m .51005 .26569 L .51748 .26463 L F
.50256 .26541 m .51747 .26418 L p .51005 .26569 L F P
0 g
s
.702 .521 .64 r
.53251 .26409 m .51747 .26418 L p .53248 .26588 L F P
0 g
s
.702 .521 .64 r
.51749 .26478 m .53248 .26588 L .51747 .26418 L F
.679 .503 .64 r
.51747 .26418 m .52498 .26356 L p .51748 .26463 L F P
0 g
s
.679 .503 .64 r
.51005 .26569 m .51747 .26418 L .51748 .26463 L F
.702 .521 .64 r
.51747 .26418 m .50991 .26422 L p .51749 .26478 L F P
0 g
s
.702 .521 .64 r
.51784 .28095 m .5318 .31041 L .51749 .26478 L F
.679 .503 .64 r
.50527 .31155 m .50256 .26541 L .51751 .26597 L F
.50527 .31155 m .51751 .26597 L .51784 .28095 L F
.702 .521 .64 r
.52911 .3159 m .52517 .31887 L .5316 .32363 L F
.51877 .3237 m .5316 .32363 L p .52517 .31887 L F P
0 g
s
.747 .559 .64 r
.55475 .31842 m .55096 .32064 L .55688 .32632 L F
.54436 .32451 m .55688 .32632 L p .55096 .32064 L F P
0 g
s
.813 .621 .643 r
.59141 .33703 m .58056 .33263 L p .58681 .33022 L F P
0 g
s
.52 .917 .87 r
.6063 .42644 m .60539 .4266 L .60998 .42224 L F
.62194 .41969 m .60916 .42596 L p .62814 .41659 L F P
0 g
s
.52 .917 .87 r
.60916 .42596 m .60276 .42909 L p .6091 .42597 L F P
0 g
s
.52 .917 .87 r
.62814 .41659 m .60916 .42596 L .6091 .42597 L F
.426 .87 .842 r
.61604 .42327 m .60483 .42537 L p .60049 .42728 L F P
0 g
s
.426 .87 .842 r
.61604 .42327 m .59882 .42771 L .6063 .42644 L F
.52 .917 .87 r
.60539 .4266 m .60291 .42895 L .59882 .42771 L F
.59324 .43046 m .59882 .42771 L p .5991 .4278 L F P
0 g
s
.52 .917 .87 r
.59623 .42999 m .59976 .428 L p .60291 .42895 L F P
0 g
s
.424 .11 .327 r
.60483 .42537 m .6035 .42712 L .59853 .42869 L F
.354 .047 .299 r
.59853 .42869 m .59875 .42796 L .59324 .43046 L F
.59882 .42771 m .59324 .43046 L p .59875 .42796 L F P
0 g
s
.424 .11 .327 r
.59882 .42771 m .60483 .42537 L p .59875 .42796 L F P
0 g
s
.354 .047 .299 r
.60423 .42548 m .59882 .42771 L .59875 .42796 L F
.424 .11 .327 r
.59875 .42796 m .59273 .43053 L .59882 .42771 L F
.59875 .42796 m .59853 .42869 L .59273 .43053 L F
.60483 .42537 m .59853 .42869 L .59875 .42796 L F
.52 .917 .87 r
.60256 .42912 m .59324 .43046 L p .60291 .42895 L F P
0 g
s
.332 .815 .812 r
.59324 .43046 m .60256 .42912 L p .59553 .43127 L F P
0 g
s
.332 .815 .812 r
.59324 .43046 m .59553 .43127 L .58887 .43212 L F
.354 .047 .299 r
.59367 .43144 m .59853 .42869 L .59324 .43046 L F
.59853 .42869 m .60423 .42548 L .59875 .42796 L F
.426 .87 .842 r
.58557 .43319 m .59227 .43042 L .58095 .4347 L F
.58095 .4347 m .58854 .43395 L p .59541 .43129 L F P
0 g
s
.426 .87 .842 r
.58955 .43203 m .58095 .4347 L .59541 .43129 L F
.332 .815 .812 r
.58691 .43237 m .59324 .43046 L p .58887 .43212 L F P
0 g
s
.482 .162 .347 r
.59283 .43191 m .59324 .43046 L .58691 .43237 L p F P
0 g
s
.424 .11 .327 r
.58691 .43237 m .59882 .42771 L p .59273 .43053 L F P
0 g
s
.652 .583 .764 r
.59568 .43166 m .59066 .43348 L .59553 .43127 L F
.426 .87 .842 r
.58854 .43395 m .5887 .43394 L .59553 .43127 L p F P
0 g
s
.652 .583 .764 r
.59066 .43348 m .58854 .43395 L .59553 .43127 L F
.638 .575 .768 r
.59689 .43184 m .60256 .42912 L .59553 .43127 L F
.482 .162 .347 r
.59283 .43191 m .58691 .43237 L .58667 .43332 L F
.242 .757 .783 r
.5887 .43394 m .58854 .43395 L p .5884 .43398 L F P
0 g
s
.242 .757 .783 r
.5887 .43394 m .57438 .43615 L .57931 .43575 L F
.652 .583 .764 r
.59066 .43348 m .57444 .43936 L .58854 .43395 L F
.242 .757 .783 r
.5884 .43398 m .58095 .4347 L .57577 .43594 L F
.58854 .43395 m .58095 .4347 L p .5884 .43398 L F P
0 g
s
.653 .527 .698 r
.58836 .45839 m .57152 .46207 L p .59375 .48376 L F P
0 g
s
.666 .591 .761 r
.57152 .46207 m .58836 .45839 L p .56792 .44603 L F P
0 g
s
.332 .815 .812 r
.57439 .43762 m .57401 .43777 L .57427 .43766 L F
.652 .583 .764 r
.58152 .43664 m .57444 .43936 L .5812 .4356 L F
.666 .591 .761 r
.58639 .45214 m .5812 .4356 L .56655 .43996 L F
.58639 .45214 m .56655 .43996 L .5675 .44419 L F
.242 .757 .783 r
.58803 .43407 m .57931 .43575 L .5812 .4356 L F
.652 .583 .764 r
.58854 .43395 m .58152 .43664 L .5812 .4356 L F
.424 .11 .327 r
.58052 .45741 m .57352 .46663 L .58691 .43237 L F
.57352 .46663 m .58095 .4347 L p .58653 .43336 L F P
0 g
s
.426 .87 .842 r
.59541 .43129 m .58854 .43395 L .59553 .43127 L F
.332 .815 .812 r
.57931 .43575 m .57439 .43762 L .57871 .4358 L F
.57439 .43762 m .57427 .43766 L .57871 .4358 L F
.57389 .43777 m .5681 .43805 L p .57427 .43766 L F P
0 g
s
.532 .206 .361 r
.58095 .4347 m .57256 .445 L .57431 .43651 L F
.653 .527 .698 r
.57152 .46207 m .56308 .46392 L p .56473 .46498 L F P
0 g
s
.689 .553 .695 r
.55509 .46451 m .55424 .46457 L p .55528 .46729 L F P
0 g
s
.671 .54 .696 r
.57152 .46207 m .55637 .48727 L .55435 .46569 L F
.55424 .46457 m .57152 .46207 L p .54568 .46752 L F P
0 g
s
.532 .206 .361 r
.58095 .4347 m .57352 .46663 L .56785 .46786 L p F P
0 g
s
.679 .599 .759 r
.56543 .44004 m .55308 .45608 L .55103 .44114 L F
.5675 .44419 m .55336 .45814 L .56631 .4389 L F
.55336 .45814 m .55308 .45608 L .56631 .4389 L F
.666 .591 .761 r
.56655 .43996 m .57389 .43777 L .56631 .4389 L F
.575 .244 .371 r
.56243 .46947 m .56784 .43945 L p .56119 .44008 L F P
0 g
s
.575 .244 .371 r
.56243 .46947 m .56119 .44008 L .55767 .4633 L F
.161 .701 .759 r
.5681 .43805 m .57389 .43777 L p .56623 .4389 L F P
0 g
s
.482 .162 .347 r
.57256 .445 m .57431 .43651 L .5681 .43805 L F
.161 .701 .759 r
.56135 .43904 m .5681 .43805 L p .56248 .43901 L F P
0 g
s
.242 .757 .783 r
.56248 .43901 m .55482 .44049 L .56287 .439 L F
.56287 .439 m .55482 .44049 L .56631 .4389 L F
.161 .701 .759 r
.5681 .43805 m .56623 .4389 L .56248 .43901 L F
.575 .244 .371 r
.56784 .43945 m .5681 .43805 L .56135 .43904 L p F P
0 g
s
.722 .58 .695 r
.52806 .50218 m .52789 .46822 L p .51901 .46723 L F P
0 g
s
.722 .58 .695 r
.52806 .50218 m .51901 .46723 L .51842 .49187 L F
.706 .566 .695 r
.54557 .46583 m .54786 .50142 L .53793 .50147 L p F P
0 g
s
.706 .566 .695 r
.54557 .46583 m .53793 .50147 L .53765 .47616 L F
.689 .553 .695 r
.53698 .47407 m .52788 .46653 L .53708 .47691 L F
.706 .566 .695 r
.54557 .46583 m .51818 .50157 L .51842 .49187 L F
.689 .553 .695 r
.55666 .49038 m .53698 .47407 L .55757 .50004 L F
.706 .566 .695 r
.53765 .47616 m .53793 .50147 L .53708 .47691 L F
.689 .553 .695 r
.53698 .47407 m .53708 .47691 L .55757 .50004 L F
.706 .566 .695 r
.53793 .50147 m .51818 .50157 L p .53708 .47691 L F P
0 g
s
.689 .552 .695 r
.53793 .50147 m .52806 .50218 L p .53802 .50963 L F P
0 g
s
.706 .566 .694 r
.51818 .50157 m .53793 .50147 L p .51755 .52769 L F P
0 g
s
.706 .566 .694 r
.53793 .50147 m .54786 .50142 L p .53822 .50978 L F P
0 g
s
.689 .552 .695 r
.53822 .50978 m .53793 .50147 L .53802 .50963 L F
.706 .566 .694 r
.53822 .50978 m .51755 .52769 L .53793 .50147 L F
.689 .552 .695 r
.56 .52607 m .53793 .50147 L .53822 .50978 L F
.55757 .50004 m .53793 .50147 L p .56 .52607 L F P
0 g
s
.706 .566 .695 r
.53849 .4662 m .53671 .4663 L .5367 .46587 L F
.5367 .46587 m .54557 .46583 L p .53849 .4662 L F P
0 g
s
.671 .54 .696 r
.54568 .46752 m .54557 .46583 L .55424 .46457 L p F P
0 g
s
.689 .553 .695 r
.55424 .46457 m .5367 .46587 L p .55666 .49038 L F P
0 g
s
.532 .206 .361 r
.55095 .47155 m .55465 .44187 L p .56119 .44008 L F P
0 g
s
.575 .244 .371 r
.56784 .43945 m .56135 .43904 L .56121 .43997 L F
.092 .65 .744 r
.55482 .44049 m .55462 .44073 L p .55862 .44056 L F P
0 g
s
.092 .65 .744 r
.55876 .44055 m .55482 .44049 L .55862 .44056 L F
.55207 .44083 m .55482 .44049 L .54797 .441 L p F P
0 g
s
.575 .244 .371 r
.54797 .441 m .54125 .44199 L p .54794 .44135 L F P
0 g
s
.092 .65 .744 r
.55885 .44055 m .54797 .441 L .55018 .4411 L F
.55103 .44114 m .55885 .44055 L p .55018 .4411 L F P
0 g
s
.614 .277 .376 r
.55482 .44049 m .54715 .44965 L .54794 .44135 L F
.532 .206 .361 r
.55465 .44187 m .55482 .44049 L .56135 .43904 L p F P
0 g
s
.242 .757 .783 r
.57438 .43615 m .56135 .43904 L p .56818 .43758 L F P
0 g
s
.532 .206 .361 r
.56135 .43904 m .57438 .43615 L p .56121 .43997 L F P
0 g
s
.532 .206 .361 r
.56121 .43997 m .55465 .44187 L .56135 .43904 L F
.614 .277 .376 r
.54797 .441 m .55482 .44049 L p .54794 .44135 L F P
0 g
s
.035 .605 .738 r
.54125 .44199 m .54331 .44226 L p .53548 .4423 L F P
0 g
s
.692 .608 .758 r
.53556 .44338 m .54331 .44226 L .5355 .44231 L F
.575 .244 .371 r
.54715 .44965 m .54794 .44135 L .54125 .44199 L F
.704 .618 .758 r
.53577 .44769 m .51927 .4595 L .5355 .44231 L F
.51927 .4595 m .51935 .45742 L .5355 .44231 L F
.035 .605 .738 r
.54125 .44199 m .53548 .4423 L .53471 .44211 L F
.704 .618 .758 r
.5355 .44231 m .53443 .44331 L .5277 .44288 L F
.53443 .44331 m .51935 .45742 L .5277 .44288 L F
.035 .605 .738 r
.52892 .44207 m .53246 .44212 L .52059 .44213 L F
.54125 .44199 m .53738 .44205 L .52892 .44207 L F
.53738 .44205 m .53246 .44212 L .52892 .44207 L F
0 .569 .742 r
.52068 .4421 m .50705 .44122 L p .50874 .44136 L F P
0 g
s
0 .569 .742 r
.5201 .44231 m .52068 .4421 L .50874 .44136 L F
.5201 .44231 m .50705 .44122 L .50643 .44126 L F
.035 .605 .738 r
.51828 .44234 m .51379 .44214 L p .53246 .44212 L F P
0 g
s
.035 .605 .738 r
.51401 .4424 m .51203 .44243 L .51379 .44214 L F
.51989 .44239 m .51988 .44239 L .51831 .4424 L F
.716 .628 .758 r
.51984 .44347 m .51206 .44242 L .50419 .44246 L F
.51984 .44347 m .50419 .44246 L .50416 .44275 L F
.51927 .4595 m .51984 .44347 L .50416 .44275 L F
.51984 .44347 m .51988 .44239 L .51206 .44242 L F
.704 .618 .758 r
.5277 .44288 m .51935 .45742 L .51984 .44347 L F
0 .569 .742 r
.5277 .44289 m .5277 .44288 L p .52716 .44285 L F P
0 g
s
.704 .618 .758 r
.5277 .44288 m .51984 .44347 L .51988 .44239 L F
.649 .307 .378 r
.52089 .4507 m .52069 .44244 L .51379 .44214 L F
0 .542 .756 r
.51379 .44214 m .51206 .44242 L p .50432 .44139 L F P
0 g
s
.714 .358 .372 r
.51387 .44351 m .51379 .44214 L p .50713 .44214 L F P
0 g
s
.704 .618 .758 r
.5367 .46587 m .51017 .46601 L p .53577 .44769 L F P
0 g
s
.716 .628 .758 r
.50752 .46523 m .51905 .46597 L p .50805 .46431 L F P
0 g
s
.716 .628 .758 r
.50805 .46431 m .49299 .46204 L .50752 .46523 L F
.50147 .46485 m .50752 .46523 L p .49299 .46204 L F P
0 g
s
.716 .628 .758 r
.51927 .4595 m .49649 .44088 L .51905 .46597 L F
.728 .639 .759 r
.50367 .44675 m .50222 .45862 L .50103 .44812 L F
.50222 .45862 m .50147 .46485 L .50103 .44812 L F
.48413 .46253 m .47539 .46136 L p .48546 .45616 L F P
0 g
s
.716 .628 .758 r
.50416 .44275 m .50419 .44246 L .49846 .44249 L F
.728 .639 .759 r
.47539 .46136 m .48085 .43986 L p .50428 .44179 L F P
0 g
s
.728 .639 .759 r
.50367 .44675 m .47539 .46136 L .50428 .44179 L F
.751 .663 .764 r
.48126 .43826 m .4672 .45903 L .47192 .44321 L F
.48126 .43826 m .45085 .45438 L .45325 .44823 L F
.74 .651 .761 r
.4672 .45903 m .48413 .46253 L p .47246 .44139 L F P
0 g
s
.74 .651 .761 r
.48413 .46253 m .49262 .46429 L p .48546 .45616 L F P
0 g
s
.74 .651 .761 r
.48546 .45616 m .47246 .44139 L .48413 .46253 L F
.728 .639 .759 r
.50147 .46485 m .48413 .46253 L p .50103 .44812 L F P
0 g
s
.728 .639 .759 r
.50103 .44812 m .48413 .46253 L .48546 .45616 L F
.706 .566 .695 r
.51849 .48891 m .50825 .50162 L .51901 .46723 L F
.53698 .47407 m .50825 .50162 L .53671 .4663 L F
.722 .58 .695 r
.51842 .49187 m .51901 .46723 L .49262 .46429 L F
.682 .333 .377 r
.50373 .47179 m .503 .46545 L p .50713 .46591 L F P
0 g
s
.722 .58 .695 r
.51901 .46723 m .50147 .46485 L .50143 .46527 L F
.51905 .46597 m .50147 .46485 L p .51901 .46723 L F P
0 g
s
.716 .628 .758 r
.51905 .46597 m .50344 .44861 L .50165 .46334 L F
.682 .333 .377 r
.503 .46545 m .50035 .44216 L p .50713 .46591 L F P
0 g
s
.716 .628 .758 r
.51927 .4595 m .50416 .44275 L .50367 .44675 L F
.714 .358 .372 r
.51549 .47295 m .51387 .44351 L p .50714 .44226 L F P
0 g
s
.682 .333 .377 r
.50714 .44226 m .50713 .46591 L .50035 .44216 L F
.50888 .46289 m .50713 .46591 L .50714 .44226 L F
.714 .358 .372 r
.51549 .47295 m .50714 .44226 L .50907 .46522 L F
.706 .566 .695 r
.53671 .4663 m .51901 .46723 L .5367 .46587 L F
.51905 .46597 m .5367 .46587 L p .51901 .46723 L F P
0 g
s
.706 .566 .695 r
.53671 .4663 m .51849 .48891 L .51901 .46723 L F
.649 .307 .378 r
.51379 .44214 m .51549 .47295 L .52144 .47291 L p F P
0 g
s
.614 .277 .376 r
.52736 .47329 m .52752 .44391 L p .53433 .44306 L F P
0 g
s
.614 .277 .376 r
.5336 .46361 m .52736 .47329 L .53433 .44306 L F
0 .569 .742 r
.52716 .44285 m .5201 .44231 L .51988 .44239 L F
.035 .605 .738 r
.51379 .44214 m .53436 .44203 L p .52059 .44213 L F P
0 g
s
.035 .605 .738 r
.53436 .44203 m .54125 .44199 L p .52059 .44213 L F P
0 g
s
0 .569 .742 r
.52753 .44254 m .52068 .4421 L p .52716 .44285 L F P
0 g
s
0 .569 .742 r
.52716 .44285 m .52068 .4421 L .5201 .44231 L F
.682 .333 .377 r
.52753 .44254 m .52089 .4507 L .52069 .44244 L F
.092 .65 .744 r
.53436 .44203 m .52753 .44254 L p .53462 .44209 L F P
0 g
s
.092 .65 .744 r
.53462 .44209 m .52753 .44254 L .53471 .44211 L F
.53471 .44211 m .52753 .44254 L .53549 .4423 L F
.614 .277 .376 r
.52752 .44391 m .52753 .44254 L .53436 .44203 L p F P
0 g
s
.689 .553 .695 r
.55666 .49038 m .5367 .46587 L .53698 .47407 L F
.649 .307 .378 r
.53923 .47282 m .54116 .44336 L p .53433 .44306 L F P
0 g
s
.614 .277 .376 r
.53433 .44294 m .52752 .44391 L .53436 .44203 L F
.649 .307 .378 r
.54116 .44336 m .54125 .44199 L .53436 .44203 L p F P
0 g
s
.649 .307 .378 r
.54116 .44336 m .53436 .44203 L .53433 .44294 L F
.614 .277 .376 r
.53433 .44306 m .52752 .44391 L .53433 .44294 L F
.682 .333 .377 r
.52068 .4421 m .52753 .44254 L p .52069 .44244 L F P
0 g
s
.035 .605 .738 r
.51994 .44237 m .51989 .44239 L .51831 .4424 L F
0 .569 .742 r
.5277 .44288 m .52753 .44254 L p .52716 .44285 L F P
0 g
s
.649 .307 .378 r
.52068 .4421 m .51379 .44214 L p .52069 .44244 L F P
0 g
s
.682 .333 .377 r
.52753 .44254 m .52736 .47329 L .52144 .47291 L p F P
0 g
s
.682 .333 .377 r
.52753 .44254 m .52144 .47291 L .52089 .4507 L F
.649 .307 .378 r
.54116 .44336 m .52068 .4421 L .52069 .44244 L F
.52089 .4507 m .51379 .44214 L .52144 .47291 L F
.682 .333 .377 r
.50966 .47217 m .50373 .47179 L p .50907 .46522 L F P
0 g
s
.682 .333 .377 r
.52089 .4507 m .50907 .46522 L .52069 .44244 L F
.50907 .46522 m .50373 .47179 L .50888 .46289 L F
.50907 .46522 m .50888 .46289 L .52069 .44244 L F
.739 .595 .696 r
.50079 .47302 m .48047 .48819 L .50147 .46485 L F
.722 .58 .695 r
.50147 .46485 m .49262 .46429 L p .49966 .46507 L F P
0 g
s
.739 .595 .696 r
.48413 .46253 m .50147 .46485 L p .48047 .48819 L F P
0 g
s
.728 .639 .759 r
.49876 .44133 m .48085 .43986 L .49657 .44088 L F
0 .542 .756 r
.49027 .43934 m .48899 .43931 L .4819 .43834 L F
.48685 .43848 m .49361 .4394 L p .49245 .4393 L F P
0 g
s
0 .542 .756 r
.49245 .4393 m .4819 .43834 L .48685 .43848 L F
0 .523 .778 r
.48051 .43665 m .47391 .43527 L p .47904 .43655 L F P
0 g
s
0 .511 .806 r
.48685 .43848 m .47904 .43655 L .48028 .43664 L F
.48685 .43848 m .47853 .43651 L .47904 .43655 L F
0 .523 .778 r
.47904 .43655 m .47391 .43527 L .47853 .43651 L F
.47853 .43651 m .47391 .43527 L .47411 .43618 L F
0 .511 .806 r
.48685 .43848 m .48138 .43827 L p .47411 .43618 L F P
0 g
s
0 .511 .806 r
.48685 .43848 m .47411 .43618 L .47853 .43651 L F
.48138 .43827 m .48126 .43826 L .47402 .43617 L p F P
0 g
s
.74 .651 .761 r
.4747 .43735 m .48138 .43827 L .47402 .43617 L F
.751 .663 .764 r
.47371 .43722 m .45918 .43303 L .46663 .43461 L F
.47886 .43912 m .47363 .4375 L .47371 .43722 L F
.47363 .4375 m .45918 .43303 L .47371 .43722 L F
.74 .651 .761 r
.48546 .45616 m .47402 .43617 L .47246 .44139 L F
.744 .38 .363 r
.47423 .43669 m .47391 .43527 L .48051 .43665 L p F P
0 g
s
.774 .402 .35 r
.48685 .43848 m .48051 .43665 L p .4807 .43759 L F P
0 g
s
.744 .38 .363 r
.48715 .4385 m .4807 .43759 L .48051 .43665 L F
.4807 .43759 m .47423 .43669 L .48051 .43665 L F
.774 .402 .35 r
.48051 .43665 m .46788 .433 L p .4807 .43759 L F P
0 g
s
0 .542 .756 r
.49027 .43934 m .4819 .43834 L .49361 .4394 L F
.48138 .43827 m .48685 .43848 L p .4819 .43834 L F P
0 g
s
0 .542 .756 r
.48126 .43826 m .48138 .43827 L p .4819 .43834 L F P
0 g
s
.74 .651 .761 r
.48876 .44037 m .48899 .43931 L .48138 .43827 L F
.774 .402 .35 r
.48709 .43988 m .48685 .43848 L p .4807 .43759 L F P
0 g
s
.74 .651 .761 r
.48546 .45616 m .48876 .44037 L .48138 .43827 L F
.714 .358 .372 r
.48685 .43848 m .4922 .46984 L .49805 .47062 L p F P
0 g
s
.714 .358 .372 r
.49525 .45089 m .48685 .43848 L .49805 .47062 L F
.49485 .44811 m .48685 .43848 L .49525 .45089 L F
0 .569 .742 r
.49657 .44088 m .49649 .44088 L .50432 .44139 L p F P
0 g
s
.728 .639 .759 r
.49876 .44133 m .49657 .44088 L .50432 .44139 L F
0 .569 .742 r
.50019 .44078 m .49657 .44088 L p .50436 .44139 L F P
0 g
s
.744 .38 .363 r
.50019 .44078 m .50373 .47179 L .49805 .47062 L p F P
0 g
s
.739 .595 .696 r
.4833 .46242 m .48413 .46253 L p .48297 .46519 L F P
0 g
s
.755 .61 .697 r
.48413 .46253 m .4672 .45903 L p .48091 .4851 L F P
0 g
s
.744 .38 .363 r
.4834 .4676 m .48103 .46711 L p .48407 .46294 L F P
0 g
s
.74 .651 .761 r
.48546 .45616 m .48138 .43827 L .4747 .43735 L F
.774 .402 .35 r
.4922 .46984 m .48709 .43988 L p .48072 .43771 L F P
0 g
s
0 .523 .778 r
.49605 .44077 m .49027 .43934 L .48899 .43931 L F
.728 .639 .759 r
.49657 .44088 m .48876 .44037 L .48899 .43931 L F
.714 .358 .372 r
.49485 .44811 m .49366 .43975 L .48685 .43848 L F
.774 .402 .35 r
.48709 .43988 m .4807 .43759 L .48072 .43771 L F
.744 .38 .363 r
.50019 .44078 m .49805 .47062 L .49485 .44811 L F
.49361 .4394 m .50019 .44078 L p .49366 .43975 L F P
0 g
s
.744 .38 .363 r
.50019 .44078 m .49485 .44811 L .49366 .43975 L F
.682 .333 .377 r
.50714 .44226 m .50035 .44216 L .50713 .44214 L F
0 .542 .756 r
.51379 .44214 m .50622 .44127 L .50643 .44126 L F
0 .569 .742 r
.50705 .44122 m .50019 .44078 L p .50643 .44126 L F P
0 g
s
0 .569 .742 r
.50643 .44126 m .50019 .44078 L .50622 .44127 L F
0 .542 .756 r
.50705 .44122 m .51379 .44214 L p .50643 .44126 L F P
0 g
s
0 .542 .756 r
.51379 .44214 m .50432 .44139 L .50622 .44127 L F
0 .569 .742 r
.50622 .44127 m .50019 .44078 L .50436 .44139 L F
.682 .333 .377 r
.50035 .44216 m .50019 .44078 L .50705 .44122 L p F P
0 g
s
.714 .358 .372 r
.51379 .44214 m .50705 .44122 L p .50713 .44214 L F P
0 g
s
.682 .333 .377 r
.50705 .44122 m .52068 .4421 L p .50713 .44214 L F P
0 g
s
.682 .333 .377 r
.50713 .44214 m .50035 .44216 L .50705 .44122 L F
.714 .358 .372 r
.50705 .44122 m .49361 .4394 L p .50713 .44214 L F P
0 g
s
.714 .358 .372 r
.49361 .4394 m .48685 .43848 L p .50714 .44226 L F P
0 g
s
.714 .358 .372 r
.51387 .44351 m .50713 .44214 L .50714 .44226 L F
.50713 .44214 m .49361 .4394 L .50714 .44226 L F
.682 .333 .377 r
.52069 .44244 m .50714 .44226 L .52068 .4421 L F
.50714 .44226 m .50713 .44214 L .52068 .4421 L F
.744 .38 .363 r
.49366 .43975 m .48072 .43771 L .49361 .4394 L F
.48072 .43771 m .47423 .43669 L .4807 .43759 L F
.48072 .43771 m .4807 .43759 L .49361 .4394 L F
.804 .421 .331 r
.47391 .43527 m .47032 .43494 L .46812 .43396 L F
0 .511 .806 r
.46555 .43254 m .46151 .43116 L .46788 .433 L p F P
0 g
s
.774 .402 .35 r
.46788 .433 m .46151 .43116 L p .46797 .43337 L F P
0 g
s
.804 .421 .331 r
.47391 .43527 m .46812 .43396 L .46794 .43324 L F
.774 .402 .35 r
.4922 .46984 m .48072 .43771 L .48534 .46119 L F
.744 .38 .363 r
.48103 .46711 m .47423 .43669 L p .48072 .43771 L F P
0 g
s
.744 .38 .363 r
.49366 .43975 m .48487 .4588 L .48072 .43771 L F
.48487 .4588 m .48103 .46711 L .48072 .43771 L F
.48534 .46119 m .4834 .4676 L .48407 .46294 L F
.4858 .46353 m .4834 .4676 L .48534 .46119 L F
.774 .402 .35 r
.48673 .46829 m .4922 .46984 L p .48534 .46119 L F P
0 g
s
.744 .38 .363 r
.49485 .44811 m .49732 .46546 L .4834 .4676 L F
.49805 .47062 m .48673 .46829 L p .49732 .46546 L F P
0 g
s
.744 .38 .363 r
.48673 .46829 m .4834 .4676 L p .49732 .46546 L F P
0 g
s
.722 .58 .695 r
.49555 .53603 m .51732 .53736 L p .49616 .52868 L F P
0 g
s
.739 .594 .695 r
.49782 .50863 m .47543 .52369 L .49851 .50034 L F
.4791 .4978 m .49851 .50034 L p .47543 .52369 L F P
0 g
s
.739 .595 .696 r
.49851 .50034 m .4791 .4978 L p .50079 .47302 L F P
0 g
s
.739 .595 .696 r
.50079 .47302 m .4791 .4978 L .48047 .48819 L F
.787 .468 .447 r
.49749 .53439 m .4922 .46984 L .48673 .46829 L p F P
0 g
s
.744 .38 .363 r
.49485 .44811 m .48103 .46711 L .49366 .43975 L F
0 .523 .778 r
.47391 .43527 m .46663 .43461 L p .47411 .43618 L F P
0 g
s
.804 .421 .331 r
.47391 .43527 m .48103 .46711 L .47583 .46519 L p F P
0 g
s
0 .505 .837 r
.46647 .43459 m .46261 .43237 L .46188 .43228 L F
.45958 .432 m .46647 .43459 L p .45962 .43201 L F P
0 g
s
.751 .663 .764 r
.47363 .4375 m .45325 .44823 L .45918 .43303 L F
.47246 .44139 m .45325 .44823 L .47363 .4375 L F
0 .505 .837 r
.46647 .43459 m .46615 .43443 L .461 .43253 L F
.751 .663 .764 r
.46663 .43461 m .45918 .43303 L .45958 .432 L F
.4672 .45903 m .45085 .45438 L p .47192 .44321 L F P
0 g
s
.774 .402 .35 r
.46151 .43116 m .47033 .46363 L .47583 .46519 L p F P
0 g
s
.804 .421 .331 r
.47391 .43527 m .47583 .46519 L .4701 .44199 L F
.774 .402 .35 r
.47583 .46519 m .48673 .46829 L p .47081 .44485 L F P
0 g
s
.774 .402 .35 r
.47081 .44485 m .46151 .43116 L .47583 .46519 L F
.48534 .46119 m .4701 .44199 L .48673 .46829 L F
.4701 .44199 m .46151 .43116 L .47081 .44485 L F
.4701 .44199 m .47081 .44485 L .48673 .46829 L F
.804 .421 .331 r
.47333 .43629 m .4701 .44199 L .46812 .43396 L F
.47391 .43527 m .47333 .43629 L .47032 .43494 L F
.774 .402 .35 r
.48534 .46119 m .48072 .43771 L .46797 .43337 L F
.4701 .44199 m .46797 .43337 L .46151 .43116 L F
.48534 .46119 m .46797 .43337 L .4701 .44199 L F
.005 .503 .865 r
.46151 .43116 m .45688 .42938 L .45476 .4283 L F
.45585 .42848 m .46151 .43116 L p .45476 .4283 L F P
0 g
s
.005 .503 .865 r
.46151 .43116 m .44581 .42684 L .45358 .42811 L F
.832 .439 .305 r
.47033 .46363 m .46151 .43116 L .45585 .42848 L p F P
0 g
s
.755 .61 .697 r
.4672 .45903 m .45866 .45727 L p .46558 .46707 L F P
0 g
s
.771 .626 .7 r
.45085 .45438 m .4672 .45903 L p .44428 .47945 L F P
0 g
s
.804 .421 .331 r
.46263 .45167 m .46022 .45942 L .45585 .42848 L F
.771 .626 .7 r
.46558 .46707 m .44428 .47945 L .4672 .45903 L F
.832 .439 .305 r
.47033 .46363 m .45585 .42848 L .4633 .45399 L F
.804 .421 .331 r
.4701 .44199 m .4633 .45399 L .46812 .43396 L F
.4633 .45399 m .46022 .45942 L .46263 .45167 L F
.4633 .45399 m .46263 .45167 L .46812 .43396 L F
.832 .439 .305 r
.46546 .46136 m .47033 .46363 L p .4633 .45399 L F P
0 g
s
.804 .421 .331 r
.46271 .45503 m .46993 .46062 L .46022 .45942 L F
.47583 .46519 m .46546 .46136 L p .46993 .46062 L F P
0 g
s
.804 .421 .331 r
.46546 .46136 m .46022 .45942 L p .46993 .46062 L F P
0 g
s
.739 .594 .695 r
.49555 .53603 m .47406 .53328 L p .47958 .52817 L F P
0 g
s
.739 .595 .696 r
.4791 .4978 m .46932 .49652 L p .48047 .48819 L F P
0 g
s
.755 .61 .697 r
.4791 .4978 m .46014 .49396 L p .47546 .52342 L F P
0 g
s
.755 .61 .697 r
.46014 .49396 m .4791 .4978 L p .46558 .46707 L F P
0 g
s
.755 .61 .697 r
.48047 .48819 m .46558 .46707 L .4791 .4978 L F
.845 .511 .422 r
.47904 .52934 m .47033 .46363 L .46546 .46136 L p F P
0 g
s
.005 .503 .865 r
.44456 .42313 m .45585 .42848 L p .45476 .4283 L F P
0 g
s
0 .505 .837 r
.45585 .42848 m .44978 .4262 L p .45358 .42811 L F P
0 g
s
.804 .421 .331 r
.46022 .45942 m .44978 .4262 L .45585 .42848 L p F P
0 g
s
.859 .454 .268 r
.44978 .4262 m .46022 .45942 L .45573 .45682 L p F P
0 g
s
0 .505 .837 r
.44978 .4262 m .43909 .42427 L p .44597 .42686 L F P
0 g
s
.047 .503 .888 r
.43886 .42423 m .44759 .4258 L p .44328 .42287 L F P
0 g
s
.047 .503 .888 r
.43713 .4216 m .44328 .42287 L .43867 .41992 L F
.43455 .41767 m .43867 .41992 L .43412 .417 L F
.43713 .4216 m .43867 .41992 L .43455 .41767 L F
.44759 .4258 m .44797 .42587 L p .44328 .42287 L F P
0 g
s
.047 .503 .888 r
.43886 .42423 m .44328 .42287 L .43713 .4216 L F
.44797 .42587 m .44978 .4262 L .44456 .42313 L p F P
0 g
s
.047 .503 .888 r
.44456 .42313 m .43412 .417 L p .43867 .41992 L F P
0 g
s
.047 .503 .888 r
.44797 .42587 m .44456 .42313 L .43867 .41992 L F
.763 .676 .767 r
.45325 .44823 m .4434 .4318 L .45085 .45438 L F
.859 .454 .268 r
.44978 .4262 m .45573 .45682 L .44768 .43254 L F
.44978 .4262 m .44946 .42716 L .44489 .42413 L F
.005 .503 .865 r
.44395 .42301 m .44372 .42288 L .44456 .42313 L F
.047 .503 .888 r
.43886 .42423 m .43412 .417 L .43112 .41625 L F
.005 .503 .865 r
.4361 .42138 m .44372 .42288 L .44395 .42301 L F
.4361 .42138 m .42632 .41762 L .44372 .42288 L F
.859 .454 .268 r
.44978 .4262 m .44489 .42413 L .44464 .42338 L F
.005 .503 .865 r
.43885 .42043 m .44456 .42313 L p .44279 .4226 L F P
0 g
s
.005 .503 .865 r
.44279 .4226 m .4267 .41773 L .43885 .42043 L F
.047 .503 .888 r
.43412 .417 m .42884 .4139 L p .43112 .41625 L F P
0 g
s
.784 .705 .776 r
.432 .4222 m .43287 .42071 L .43111 .41987 L F
.005 .503 .865 r
.43287 .42071 m .42632 .41762 L p .4361 .42138 L F P
0 g
s
.784 .705 .776 r
.432 .4222 m .43111 .41987 L .42116 .41505 L F
.42502 .43412 m .432 .4222 L .42116 .41505 L F
.096 .504 .904 r
.43885 .42043 m .42659 .41768 L p .42088 .41369 L F P
0 g
s
.005 .503 .865 r
.42659 .41768 m .43885 .42043 L p .4267 .41773 L F P
0 g
s
.096 .504 .904 r
.43412 .417 m .43885 .42043 L p .43112 .41625 L F P
0 g
s
.047 .503 .888 r
.43035 .41606 m .42884 .4139 L .42109 .41374 L F
.096 .504 .904 r
.43885 .42043 m .42088 .41369 L .43112 .41625 L F
.047 .503 .888 r
.43287 .42071 m .43886 .42423 L p .43293 .42073 L F P
0 g
s
.763 .676 .767 r
.4434 .4318 m .43886 .42423 L .44256 .43353 L F
.773 .69 .771 r
.4434 .4318 m .42056 .44176 L .42394 .43598 L F
.44256 .43353 m .42056 .44176 L .4434 .4318 L F
.44533 .42783 m .42394 .43598 L .43287 .42071 L F
.4434 .4318 m .42394 .43598 L .44533 .42783 L F
.763 .676 .767 r
.43525 .4486 m .45085 .45438 L p .44256 .43353 L F P
0 g
s
.859 .454 .268 r
.44222 .449 m .42884 .4139 L .43412 .417 L p F P
0 g
s
.88 .465 .218 r
.43885 .42043 m .43412 .417 L p .43449 .41803 L F P
0 g
s
.88 .465 .218 r
.43938 .42195 m .43885 .42043 L p .43449 .41803 L F P
0 g
s
.832 .439 .305 r
.44019 .42227 m .44489 .42413 L .43885 .42043 L F
.44489 .42413 m .44464 .42338 L .43885 .42043 L F
0 .505 .837 r
.44595 .42686 m .43909 .42427 L .44581 .42684 L F
.832 .439 .305 r
.44768 .43254 m .44499 .42443 L .44019 .42227 L F
.859 .454 .268 r
.44456 .42313 m .44978 .4262 L p .44464 .42338 L F P
0 g
s
.832 .439 .305 r
.45614 .42946 m .45037 .42631 L .44489 .42413 L F
.44499 .42443 m .44489 .42413 L .44019 .42227 L F
.859 .454 .268 r
.44946 .42716 m .44768 .43254 L .44489 .42413 L F
.832 .439 .305 r
.45614 .42946 m .44489 .42413 L .44499 .42443 L F
.44456 .42313 m .43885 .42043 L p .45037 .42631 L F P
0 g
s
.763 .676 .767 r
.4434 .4318 m .44256 .43353 L .45085 .45438 L F
.832 .439 .305 r
.43885 .42043 m .45082 .45453 L .45573 .45682 L p F P
0 g
s
.832 .439 .305 r
.44867 .43553 m .43885 .42043 L .45573 .45682 L F
.804 .421 .331 r
.4701 .44199 m .47583 .46519 L .46271 .45503 L F
.832 .439 .305 r
.4633 .45399 m .43885 .42043 L .46546 .46136 L F
.859 .454 .268 r
.44392 .44387 m .44222 .449 L .43412 .417 L F
.88 .465 .218 r
.45082 .45453 m .43938 .42195 L p .43454 .41816 L F P
0 g
s
.891 .467 .148 r
.42465 .41014 m .42884 .4139 L p .42481 .41054 L F P
0 g
s
.784 .705 .776 r
.42116 .41505 m .42659 .41768 L .42088 .41369 L F
.879 .454 .051 r
.43453 .44289 m .41683 .40384 L .41674 .40374 L F
.047 .503 .888 r
.42107 .41374 m .41512 .41022 L .42088 .41369 L F
.784 .705 .776 r
.42502 .43412 m .42088 .41369 L .42394 .43598 L F
.879 .454 .051 r
.43453 .44289 m .41674 .40374 L .42703 .42872 L F
.43453 .44289 m .41987 .40667 L p .41681 .4038 L F P
0 g
s
.88 .465 .218 r
.42465 .41014 m .41987 .40667 L p .42481 .41054 L F P
0 g
s
.88 .465 .218 r
.43938 .42195 m .42465 .41014 L .42481 .41054 L F
.891 .467 .148 r
.42884 .4139 m .4288 .41484 L .42507 .4112 L F
.88 .465 .218 r
.42507 .4112 m .42481 .41054 L .41987 .40667 L F
.891 .467 .148 r
.42481 .41054 m .42507 .4112 L .42195 .40816 L F
.42884 .4139 m .42507 .4112 L .42481 .41054 L F
.42481 .41054 m .41679 .40386 L .42465 .41014 L F
.88 .465 .218 r
.42119 .40872 m .42507 .4112 L .41987 .40667 L F
.42507 .4112 m .42829 .41327 L .42481 .41054 L F
.891 .467 .148 r
.43146 .43947 m .42784 .43626 L p .42806 .43122 L F P
0 g
s
.891 .467 .148 r
.42784 .43626 m .42717 .43468 L p .42738 .43491 L F P
0 g
s
.891 .467 .148 r
.42717 .43468 m .41274 .40049 L p .42738 .43491 L F P
0 g
s
.891 .467 .148 r
.41679 .40386 m .42738 .43491 L .41274 .40049 L F
.42546 .4249 m .42784 .43626 L .41679 .40386 L F
.88 .465 .218 r
.42856 .42012 m .42507 .4112 L .42119 .40872 L F
.891 .467 .148 r
.42699 .42863 m .42784 .43626 L .42546 .4249 L F
.879 .454 .051 r
.43453 .44289 m .42703 .42872 L .42806 .43122 L F
.88 .465 .218 r
.41987 .40667 m .43453 .44289 L .43863 .44582 L p F P
0 g
s
.891 .467 .148 r
.42884 .4139 m .44222 .449 L .43863 .44582 L p F P
0 g
s
.891 .467 .148 r
.42884 .4139 m .43863 .44582 L .4298 .42328 L F
.88 .465 .218 r
.42856 .42012 m .41987 .40667 L .43863 .44582 L F
.879 .454 .051 r
.43146 .43947 m .43453 .44289 L p .42806 .43122 L F P
0 g
s
.891 .467 .148 r
.42884 .4139 m .43146 .43947 L .42806 .43122 L F
.859 .454 .268 r
.44392 .44387 m .44467 .44591 L .44359 .44485 L F
.44359 .44485 m .44467 .44591 L .44222 .449 L F
.88 .465 .218 r
.44675 .45162 m .45082 .45453 L p .44392 .44387 L F P
0 g
s
.891 .467 .148 r
.4288 .41484 m .42856 .42012 L .42507 .4112 L F
.88 .465 .218 r
.45082 .45453 m .42829 .41327 L .42507 .4112 L F
.45082 .45453 m .42507 .4112 L .42856 .42012 L F
.45082 .45453 m .43454 .41816 L .44175 .43793 L F
.859 .454 .268 r
.45573 .45682 m .44675 .45162 L p .44467 .44591 L F P
0 g
s
.859 .454 .268 r
.44675 .45162 m .44222 .449 L p .44467 .44591 L F P
0 g
s
.88 .465 .218 r
.43863 .44582 m .44675 .45162 L p .42856 .42012 L F P
0 g
s
.88 .465 .218 r
.44392 .44387 m .42856 .42012 L .44675 .45162 L F
.891 .467 .148 r
.43863 .44582 m .43146 .43947 L p .4298 .42328 L F P
0 g
s
.891 .467 .148 r
.42856 .42012 m .42784 .43626 L .42507 .4112 L F
.826 .414 0 r
.41204 .39882 m .42784 .43626 L .42533 .43263 L p F P
0 g
s
.879 .454 .051 r
.40546 .39042 m .42223 .42917 L .42533 .43263 L p F P
0 g
s
.879 .454 .051 r
.41508 .40857 m .40546 .39042 L .42533 .43263 L F
.826 .414 0 r
.41204 .39882 m .42533 .43263 L .41364 .40519 L F
.879 .454 .051 r
.42806 .43122 m .40546 .39042 L .43146 .43947 L F
.826 .414 0 r
.42032 .42537 m .41779 .4217 L p .41649 .41655 L F P
0 g
s
.826 .414 0 r
.41779 .4217 m .401 .38336 L p .40378 .38724 L F P
0 g
s
.826 .414 0 r
.40928 .39495 m .4152 .41357 L .40378 .38724 L F
.4152 .41357 m .41779 .4217 L .40378 .38724 L F
.41364 .40519 m .41779 .4217 L .40928 .39495 L F
.71 .337 0 r
.41649 .41655 m .40378 .38724 L .39888 .37736 L F
.41649 .41655 m .39888 .37736 L .40367 .38835 L F
.826 .414 0 r
.40732 .39221 m .40378 .38724 L .40457 .38827 L F
.40378 .38724 m .40371 .3871 L .40457 .38827 L F
.40732 .39221 m .40641 .39081 L .4091 .39452 L F
0 0 .488 r
.40984 .40046 m .39561 .36757 L .39459 .35932 L F
0 .012 .564 r
.39417 .35834 m .39459 .35932 L .39429 .35387 L F
.394 .34836 m .39403 .35801 L p .39429 .35387 L F P
0 g
s
0 0 .488 r
.39561 .36757 m .39403 .35801 L p .39459 .35932 L F P
0 g
s
0 .012 .564 r
.39403 .35801 m .39405 .36283 L p .39417 .35834 L F P
0 g
s
0 .012 .564 r
.39417 .35834 m .39429 .35387 L .39403 .35801 L F
.384 .513 .864 r
.39639 .37233 m .37763 .36256 L p .37434 .34581 L F P
0 g
s
.384 .513 .864 r
.37626 .35684 m .37434 .34581 L p .37763 .36256 L F P
0 g
s
.384 .513 .864 r
.39639 .37233 m .37434 .34581 L .37981 .3492 L F
.39124 .36514 m .37981 .3492 L .3935 .3664 L F
.42 .515 .85 r
.37442 .35138 m .39405 .36283 L .39403 .35801 L p F P
0 g
s
.42 .515 .85 r
.37981 .3492 m .39189 .35668 L .394 .34836 L F
.39403 .35801 m .394 .34836 L p .39189 .35668 L F P
0 g
s
.879 .454 .051 r
.41628 .40263 m .4091 .39452 L p .41293 .39914 L F P
0 g
s
0 0 .488 r
.40984 .40046 m .39459 .35932 L .39925 .37032 L F
0 .012 .564 r
.39459 .35932 m .40854 .38366 L .394 .34836 L F
.39925 .37032 m .40854 .38366 L .39459 .35932 L F
.879 .454 .051 r
.42806 .43122 m .40973 .396 L .41364 .40519 L F
.42703 .42872 m .40973 .396 L .42806 .43122 L F
.42703 .42872 m .41674 .40374 L .40973 .396 L F
.41674 .40374 m .40958 .39566 L .40973 .396 L F
.41674 .40374 m .40958 .39566 L .41674 .40374 L F
.41674 .40374 m .41293 .39914 L .40958 .39566 L F
0 0 .488 r
.41394 .40993 m .39925 .37032 L .4096 .39469 L F
0 0 .372 r
.40074 .38259 m .40367 .38835 L .39938 .37849 L F
.71 .337 0 r
.4032 .38592 m .39868 .3769 L p .40121 .38202 L F P
0 g
s
0 0 .372 r
.39921 .37812 m .39612 .36872 L .39742 .37287 L F
.40074 .38259 m .39938 .37849 L .39921 .37812 L F
.39938 .37849 m .39612 .36872 L .39921 .37812 L F
.71 .337 0 r
.41649 .41655 m .40367 .38835 L .42032 .42537 L F
.254 .508 .903 r
.38211 .37317 m .38172 .37298 L .38519 .378 L p F P
0 g
s
.829 .793 .818 r
.3799 .36761 m .38519 .378 L p .384 .37793 L F P
0 g
s
.345 .511 .878 r
.38172 .37298 m .40022 .38156 L .39868 .3769 L p F P
0 g
s
.345 .511 .878 r
.38172 .37298 m .39868 .3769 L .38511 .37019 L F
.71 .337 0 r
.40367 .38835 m .40526 .39198 L .42032 .42537 L F
0 0 .488 r
.40984 .40046 m .39925 .37032 L .41394 .40993 L F
.71 .337 0 r
.4165 .41778 m .42032 .42537 L p .41728 .41863 L F P
0 g
s
.71 .337 0 r
.41728 .41863 m .40526 .39198 L .4165 .41778 L F
0 0 .372 r
.40022 .38156 m .41779 .4217 L .4165 .41778 L p F P
0 g
s
.782 .489 0 r
.41779 .4217 m .41929 .42873 L .41806 .42443 L F
.794 .72 .782 r
.40694 .4339 m .39454 .42509 L p .41659 .41991 L F P
0 g
s
.896 .56 .073 r
.42147 .43896 m .4171 .42031 L .41457 .41393 L F
.782 .489 0 r
.41779 .4217 m .41806 .42443 L .417 .41991 L F
.896 .56 .073 r
.4165 .41778 m .41457 .41393 L p .4171 .42031 L F P
0 g
s
.782 .489 0 r
.41779 .4217 m .417 .41991 L .4169 .41946 L F
.4165 .41778 m .41779 .4217 L p .41602 .41724 L F P
0 g
s
.804 .661 .706 r
.42056 .44176 m .43525 .4486 L p .41128 .46592 L F P
0 g
s
.804 .661 .706 r
.43273 .4564 m .41128 .46592 L .43525 .4486 L F
.787 .643 .702 r
.42431 .48251 m .44182 .48885 L p .43273 .4564 L F P
0 g
s
.804 .661 .706 r
.43273 .4564 m .4078 .47498 L .41128 .46592 L F
.43186 .45911 m .4078 .47498 L .43273 .4564 L F
.42431 .48251 m .4078 .47498 L p .43186 .45911 L F P
0 g
s
.942 .587 .19 r
.435 .49536 m .41779 .4217 L .42032 .42537 L p F P
0 g
s
.896 .56 .073 r
.42442 .43879 m .42182 .43189 L .42201 .4327 L F
.942 .587 .19 r
.43341 .48229 m .435 .49536 L .42032 .42537 L F
.771 .626 .699 r
.44182 .48885 m .46014 .49396 L p .4352 .51418 L F P
0 g
s
.896 .56 .073 r
.43868 .50139 m .42442 .43879 L p .42201 .4327 L F P
0 g
s
.896 .56 .073 r
.43236 .48909 m .43395 .49219 L p .43005 .47646 L F P
0 g
s
.782 .489 0 r
.41779 .4217 m .435 .49536 L .43395 .49219 L p F P
0 g
s
.782 .489 0 r
.41779 .4217 m .43395 .49219 L .42303 .44562 L F
.896 .56 .073 r
.41457 .41393 m .43236 .48909 L p .43005 .47646 L F P
0 g
s
.896 .56 .073 r
.42147 .43896 m .41457 .41393 L .43395 .49219 L F
.782 .489 0 r
.41779 .4217 m .43185 .48586 L .42792 .46919 L F
.942 .587 .19 r
.4371 .49832 m .435 .49536 L p .43341 .48229 L F P
0 g
s
.896 .56 .073 r
.43868 .50139 m .42147 .43896 L .42933 .47249 L F
.43395 .49219 m .4371 .49832 L p .42933 .47249 L F P
0 g
s
.896 .56 .073 r
.4371 .49832 m .43868 .50139 L p .42933 .47249 L F P
0 g
s
.706 .721 .861 r
.4346 .55307 m .42395 .54936 L p .42699 .56542 L F P
0 g
s
.706 .721 .861 r
.42757 .56558 m .4346 .55307 L p .42699 .56542 L F P
0 g
s
.294 .665 .972 r
.39028 .55469 m .38446 .55555 L .36013 .54557 L F
.309 .651 .97 r
.33762 .5339 m .35957 .54561 L p .34727 .53394 L F P
0 g
s
.309 .651 .97 r
.36251 .54542 m .34727 .53394 L .35957 .54561 L F
0 .323 .713 r
.3606 .54722 m .35957 .54561 L .35173 .54222 L F
.282 0 0 r
.35265 .54261 m .33623 .53551 L .35957 .54561 L F
.294 .665 .972 r
.36251 .54542 m .36013 .54557 L .34766 .54046 L F
.39028 .55469 m .36013 .54557 L .36251 .54542 L F
.38305 .55576 m .35957 .54561 L p .38446 .55555 L F P
0 g
s
.294 .665 .972 r
.35957 .54561 m .34766 .54046 L p .36013 .54557 L F P
0 g
s
.294 .665 .972 r
.38446 .55555 m .35957 .54561 L .36013 .54557 L F
.709 .726 .863 r
.4127 .54634 m .39944 .54588 L .40026 .54487 L F
.086 .421 .868 r
.28329 .49028 m .2698 .47328 L p .27148 .48408 L F P
0 g
s
.372 .618 .947 r
.29925 .50614 m .28329 .49028 L p .31103 .50761 L F P
0 g
s
.233 .453 .868 r
.25897 .45528 m .25103 .43644 L p .24571 .44721 L F P
0 g
s
.419 .603 .923 r
.2698 .47328 m .25897 .45528 L p .28335 .47652 L F P
0 g
s
.347 .475 .847 r
.24613 .41695 m .24445 .39702 L p .23191 .40675 L F P
0 g
s
.464 .594 .897 r
.25103 .43644 m .24613 .41695 L p .26586 .44172 L F P
0 g
s
.433 .493 .821 r
.24611 .37687 m .25119 .35675 L p .23156 .36436 L F P
0 g
s
.506 .589 .872 r
.24445 .39702 m .24611 .37687 L p .25995 .40458 L F P
0 g
s
.544 .589 .85 r
.25119 .35675 m .25974 .33692 L p .26662 .36673 L F P
0 g
s
.562 .591 .841 r
.27176 .31765 m .25974 .33692 L p .28632 .33006 L F P
0 g
s
.562 .591 .841 r
.26499 .34082 m .28632 .33006 L .25974 .33692 L F
.544 .589 .85 r
.25974 .33692 m .26411 .32679 L p .26499 .34082 L F P
0 g
s
.544 .589 .85 r
.26662 .36673 m .25974 .33692 L .26499 .34082 L F
.562 .591 .841 r
.25974 .33692 m .25378 .34647 L p .26499 .34082 L F P
0 g
s
.506 .589 .872 r
.25995 .40458 m .24611 .37687 L .25151 .37992 L F
.544 .589 .85 r
.27509 .3605 m .26985 .34442 L .27882 .35107 L F
.707 .783 .911 r
.30409 .34629 m .30021 .3548 L p .28391 .34405 L F P
0 g
s
.703 .785 .915 r
.29498 .36283 m .30021 .3548 L p .27584 .359 L F P
0 g
s
.703 .785 .915 r
.27584 .359 m .30021 .3548 L .28506 .35245 L F
.27509 .3605 m .29498 .36283 L p .27584 .359 L F P
0 g
s
.711 .78 .906 r
.29498 .36283 m .27509 .3605 L p .27229 .36989 L F P
0 g
s
.714 .776 .901 r
.2888 .37977 m .28788 .38847 L p .26848 .37937 L F P
0 g
s
.714 .776 .901 r
.26858 .37891 m .2888 .37977 L p .26848 .37937 L F P
0 g
s
.609 .601 .818 r
.31875 .29661 m .30843 .28478 L .32853 .26703 L F
.31875 .29661 m .32853 .26703 L .32944 .26826 L F
.594 .552 .778 r
.42642 .27044 m .42839 .26038 L .43648 .28752 L F
.42839 .26038 m .42854 .2596 L .42871 .26019 L F
.42839 .26038 m .42871 .26019 L .43648 .28752 L F
.42254 .26384 m .42854 .2596 L p .42261 .26396 L F P
0 g
s
.594 .552 .778 r
.42642 .27044 m .42261 .26396 L .42854 .2596 L F
.65 .947 .955 r
.40274 .26757 m .42254 .26384 L .41301 .2641 L F
.402 .26809 m .42254 .26384 L .40274 .26757 L F
.40752 .26425 m .39999 .26851 L p .40789 .26424 L F P
0 g
s
.65 .947 .955 r
.39999 .26851 m .41168 .26414 L .40789 .26424 L F
.701 .956 .95 r
.41168 .26414 m .41436 .25941 L .41301 .2641 L F
.591 .93 .955 r
.42854 .2596 m .41574 .25943 L p .42261 .25575 L F P
0 g
s
.65 .947 .955 r
.42346 .25579 m .43143 .25156 L .42261 .25575 L F
.591 .93 .955 r
.42854 .2596 m .42261 .25575 L .43279 .25626 L F
.701 .956 .95 r
.40752 .26425 m .41436 .25941 L p .41168 .26414 L F P
0 g
s
.65 .947 .955 r
.40789 .26424 m .43143 .25156 L .40752 .26425 L F
.44245 .25265 m .43143 .25156 L p .40789 .26424 L F P
0 g
s
.65 .947 .955 r
.41168 .26414 m .44245 .25265 L .40789 .26424 L F
.528 .905 .953 r
.4391 .24842 m .43024 .25144 L p .44218 .24886 L F P
0 g
s
.591 .93 .955 r
.42261 .25575 m .4391 .24842 L p .43279 .25626 L F P
0 g
s
.591 .93 .955 r
.44218 .24886 m .4391 .24842 L .44606 .2458 L F
.43279 .25626 m .4391 .24842 L .44218 .24886 L F
.44744 .24471 m .45681 .24664 L p .44963 .24993 L F P
0 g
s
.591 .93 .955 r
.44053 .2541 m .44418 .24915 L .44963 .24993 L F
.44418 .24915 m .44744 .24471 L .44963 .24993 L F
.43585 .25609 m .44744 .24471 L .44053 .2541 L F
.43279 .25626 m .44744 .24471 L .43554 .25639 L F
.528 .905 .953 r
.47346 .2421 m .46647 .23961 L p .45678 .24239 L F P
0 g
s
.528 .905 .953 r
.46647 .23961 m .46572 .23934 L .45678 .24239 L p F P
0 g
s
.528 .905 .953 r
.46295 .24403 m .47346 .2421 L .45678 .24239 L F
.464 .875 .948 r
.45749 .24678 m .44842 .24491 L p .45678 .24239 L F P
0 g
s
.464 .875 .948 r
.44842 .24491 m .44744 .24471 L .45678 .24239 L p F P
0 g
s
.464 .875 .948 r
.45749 .24678 m .45678 .24239 L .46365 .24422 L F
.528 .905 .953 r
.44218 .24886 m .46365 .24422 L .4391 .24842 L F
.46365 .24422 m .46295 .24403 L .4391 .24842 L F
.46365 .24422 m .47346 .2421 L .46295 .24403 L F
.402 .84 .943 r
.47346 .2421 m .48194 .24071 L p .46717 .23946 L F P
0 g
s
.402 .84 .943 r
.46572 .23934 m .46647 .23961 L p .46717 .23946 L F P
0 g
s
.402 .84 .943 r
.46647 .23961 m .47346 .2421 L p .46717 .23946 L F P
0 g
s
.402 .84 .943 r
.46572 .23934 m .48194 .24071 L .47723 .23857 L F
.464 .875 .948 r
.47543 .23775 m .48484 .2354 L p .48285 .23623 L F P
0 g
s
.464 .875 .948 r
.47723 .23857 m .47543 .23775 L .48285 .23623 L F
.48484 .2354 m .49015 .23867 L .48194 .24071 L p F P
0 g
s
.676 .595 .758 r
.48194 .24071 m .47346 .2421 L p .47419 .24254 L F P
0 g
s
.464 .875 .948 r
.46566 .24475 m .45749 .24678 L p .46365 .24422 L F P
0 g
s
.661 .586 .76 r
.45769 .24734 m .45749 .24678 L .46566 .24475 L p F P
0 g
s
.528 .905 .953 r
.47078 .24268 m .45769 .24734 L .47346 .2421 L F
.46566 .24475 m .47346 .2421 L p .45769 .24734 L F P
0 g
s
.645 .577 .763 r
.47361 .24267 m .47346 .2421 L .46566 .24475 L p F P
0 g
s
.464 .875 .948 r
.46566 .24475 m .46646 .24436 L .47361 .24267 L F
.48194 .24071 m .46566 .24475 L p .47361 .24267 L F P
0 g
s
.661 .586 .76 r
.46566 .24475 m .48194 .24071 L p .45769 .24734 L F P
0 g
s
.661 .586 .76 r
.45769 .24734 m .48194 .24071 L .48197 .24086 L F
.645 .577 .763 r
.48063 .26895 m .47361 .24267 L p .46566 .24475 L F P
0 g
s
.676 .595 .758 r
.47419 .24254 m .48362 .24826 L .48194 .24071 L F
.47346 .2421 m .48415 .25066 L .48362 .24826 L F
.629 .568 .767 r
.45718 .24753 m .4517 .24948 L .45749 .24678 L F
.43576 .25641 m .4502 .25001 L p .42882 .26012 L F P
0 g
s
.629 .568 .767 r
.42882 .26012 m .4502 .25001 L .45025 .25015 L F
.645 .577 .763 r
.45307 .25718 m .48063 .26895 L .4502 .25001 L F
.629 .568 .767 r
.45307 .25718 m .4517 .24948 L .45718 .24753 L F
.4417 .2839 m .45098 .25196 L .45307 .25718 L F
.45098 .25196 m .4517 .24948 L .45307 .25718 L F
.645 .577 .763 r
.45307 .25718 m .47388 .27122 L .47203 .26528 L F
.591 .93 .955 r
.4502 .25001 m .43576 .25641 L p .4497 .24994 L F P
0 g
s
.629 .568 .767 r
.44376 .27906 m .45307 .25718 L .46049 .2757 L F
.645 .577 .763 r
.45394 .25935 m .47388 .27122 L .45307 .25718 L F
.46049 .2757 m .47388 .27122 L p .46668 .27206 L F P
0 g
s
.602 .446 .642 r
.46059 .27628 m .47985 .31658 L .47411 .27297 L F
.572 .425 .643 r
.46078 .27743 m .45438 .2793 L .46056 .27614 L F
.44797 .28116 m .46049 .2757 L p .45438 .2793 L F P
0 g
s
.602 .446 .642 r
.47388 .27122 m .46049 .2757 L p .47411 .27297 L F P
0 g
s
.602 .446 .642 r
.46059 .27628 m .47411 .27297 L .46049 .2757 L F
.572 .425 .643 r
.46049 .2757 m .46681 .27295 L p .46056 .27614 L F P
0 g
s
.572 .425 .643 r
.45438 .2793 m .46049 .2757 L .46056 .27614 L F
.602 .446 .642 r
.46049 .2757 m .45378 .27795 L p .46059 .27628 L F P
0 g
s
.602 .446 .642 r
.4632 .29191 m .47985 .31658 L .46059 .27628 L F
.572 .425 .643 r
.45685 .32519 m .44797 .28116 L .46078 .27743 L F
.45685 .32519 m .46078 .27743 L .4632 .29191 L F
.602 .446 .642 r
.47822 .3227 m .47512 .32672 L .48155 .32953 L F
.4701 .33325 m .48155 .32953 L p .47512 .32672 L F P
0 g
s
.679 .503 .64 r
.50604 .32472 m .50845 .31697 L .51221 .31943 L F
.51877 .3237 m .50604 .32472 L p .51221 .31943 L F P
0 g
s
.673 .47 .603 r
.50604 .32472 m .51877 .3237 L p .51251 .32844 L F P
0 g
s
.673 .47 .603 r
.50635 .33309 m .50604 .32472 L .51251 .32844 L F
.646 .449 .602 r
.49407 .33501 m .50867 .39741 L .50604 .32472 L F
.49513 .35317 m .50867 .39741 L .49407 .33501 L F
.617 .427 .602 r
.48694 .39651 m .48155 .32953 L .49407 .33501 L F
.586 .404 .601 r
.48155 .32953 m .4701 .33325 L p .48733 .40144 L F P
0 g
s
.405 .32 .646 r
.42128 .34719 m .41004 .31271 L .4173 .30312 L F
.507 .527 .812 r
.39863 .32918 m .39653 .32735 L .39993 .3236 L F
.40329 .31989 m .39863 .32918 L p .39993 .3236 L F P
0 g
s
.164 .179 .629 r
.39863 .32918 m .39553 .33871 L p .39735 .33467 L F P
0 g
s
.164 .179 .629 r
.39735 .33467 m .39918 .33063 L .39863 .32918 L F
.481 .523 .823 r
.39553 .33871 m .39863 .32918 L p .38305 .32904 L F P
0 g
s
.342 .282 .645 r
.40347 .3204 m .42254 .35107 L .40998 .31252 L F
.263 .236 .64 r
.39863 .32918 m .40329 .31989 L p .41279 .36693 L F P
0 g
s
.263 .236 .64 r
.41279 .36693 m .40329 .31989 L .40824 .33397 L F
.342 .282 .645 r
.4002 .32435 m .40824 .33397 L .40347 .3204 L F
.40824 .33397 m .42254 .35107 L .40347 .3204 L F
.40948 .31097 m .40329 .31989 L p .40998 .31252 L F P
0 g
s
.342 .282 .645 r
.40329 .31989 m .4002 .32435 L p .40347 .3204 L F P
0 g
s
.342 .282 .645 r
.40347 .3204 m .40998 .31252 L .40329 .31989 L F
.532 .533 .801 r
.39143 .30831 m .40126 .31791 L .40948 .31097 L F
.40329 .31989 m .40948 .31097 L p .40126 .31791 L F P
0 g
s
.405 .32 .646 r
.40643 .31748 m .40565 .31519 L .40948 .31097 L p F P
0 g
s
.405 .32 .646 r
.40948 .31097 m .41712 .30252 L p .41354 .30754 L F P
0 g
s
.405 .32 .646 r
.40643 .31748 m .40948 .31097 L .41354 .30754 L F
.263 .236 .64 r
.41685 .37776 m .40824 .33397 L .41803 .36179 L F
.42092 .37001 m .41685 .37776 L p .41743 .3699 L F P
0 g
s
.859 .454 .268 r
.44768 .43254 m .44467 .44591 L .44392 .44387 L F
.44489 .42413 m .44392 .44387 L .43412 .417 L F
.44768 .43254 m .44392 .44387 L .44489 .42413 L F
.44464 .42338 m .43952 .42058 L .44456 .42313 L F
.44464 .42338 m .44489 .42413 L .43952 .42058 L F
.43412 .417 m .44456 .42313 L p .43952 .42058 L F P
0 g
s
0 .012 .564 r
.41032 .38983 m .41117 .39424 L .41271 .39381 L F
.41266 .40191 m .41271 .39381 L p .41117 .39424 L F P
0 g
s
.896 .56 .073 r
.43226 .47728 m .42201 .4327 L .4171 .42031 L F
.42201 .4327 m .4165 .41778 L .4171 .42031 L F
.42182 .43189 m .4165 .41778 L .42201 .4327 L F
0 0 .372 r
.41038 .40152 m .41376 .41048 L .41264 .40595 L F
.4165 .41778 m .41394 .40993 L p .41376 .41048 L F P
0 g
s
0 0 .372 r
.41394 .40993 m .41264 .40595 L p .41376 .41048 L F P
0 g
s
0 0 .234 r
.41394 .40993 m .41266 .40191 L p .41411 .40938 L F P
0 g
s
0 0 .372 r
.40022 .38156 m .4165 .41778 L .41038 .40152 L F
.71 .337 0 r
.41457 .41393 m .4165 .41778 L p .41373 .41151 L F P
0 g
s
.71 .337 0 r
.40526 .39198 m .39639 .37233 L .4165 .41778 L F
0 0 .234 r
.41457 .41393 m .41394 .40993 L p .41547 .41652 L F P
0 g
s
0 0 .234 r
.43236 .48909 m .41457 .41393 L p .41547 .41652 L F P
0 g
s
.71 .337 0 r
.39639 .37233 m .41457 .41393 L p .41373 .41151 L F P
0 g
s
.782 .489 0 r
.41929 .42873 m .42792 .46919 L .41554 .41672 L F
.41602 .41724 m .41554 .41672 L .41394 .40993 L F
.41929 .42873 m .41554 .41672 L .41602 .41724 L F
0 0 .234 r
.43236 .48909 m .41394 .40993 L .42792 .46919 L F
.782 .489 0 r
.42792 .46919 m .43079 .48266 L .41394 .40993 L F
.41394 .40993 m .4165 .41778 L p .41602 .41724 L F P
0 g
s
0 0 .234 r
.41554 .41672 m .41394 .40993 L .41411 .40938 L F
.896 .56 .073 r
.43868 .50139 m .4171 .42031 L .42147 .43896 L F
.42442 .43879 m .42223 .42917 L .4165 .41778 L p F P
0 g
s
.71 .337 0 r
.42032 .42537 m .42223 .42917 L p .41649 .41655 L F P
0 g
s
.826 .414 0 r
.42533 .43263 m .42032 .42537 L p .41364 .40519 L F P
0 g
s
.826 .414 0 r
.41364 .40519 m .42032 .42537 L .41649 .41655 L F
.879 .454 .051 r
.42533 .43263 m .43146 .43947 L p .41508 .40857 L F P
0 g
s
.879 .454 .051 r
.41673 .40372 m .41293 .39914 L .41674 .40374 L F
.41683 .40384 m .41628 .40263 L .41293 .39914 L F
.024 .026 .519 r
.41452 .38756 m .41573 .39295 L .41629 .38543 L F
.41685 .37776 m .41411 .38573 L p .41629 .38543 L F P
0 g
s
0 0 .462 r
.41271 .39381 m .41411 .38573 L p .41573 .39295 L F P
0 g
s
.036 .105 .606 r
.41411 .38573 m .41271 .39381 L p .4119 .38603 L F P
0 g
s
.891 .467 .148 r
.42507 .4112 m .42699 .42863 L .42195 .40816 L F
.42699 .42863 m .42546 .4249 L .42195 .40816 L F
.42195 .40816 m .42546 .4249 L .41679 .40386 L F
.879 .454 .051 r
.41683 .40384 m .41674 .40374 L .41674 .40374 L F
.891 .467 .148 r
.41679 .40386 m .41673 .40372 L .42465 .41014 L F
.942 .587 .19 r
.42784 .43626 m .44335 .50713 L .44126 .50419 L p F P
0 g
s
.942 .587 .19 r
.42784 .43626 m .44126 .50419 L .43129 .45938 L F
.896 .56 .073 r
.43868 .50139 m .42201 .4327 L .43226 .47728 L F
.945 .587 .274 r
.42223 .42917 m .43868 .50139 L .44126 .50419 L p F P
0 g
s
.945 .587 .274 r
.42986 .45298 m .42223 .42917 L .44126 .50419 L F
.942 .587 .19 r
.42986 .45298 m .4371 .49832 L .43341 .48229 L F
.42784 .43626 m .43129 .45938 L .42986 .45298 L F
.43129 .45938 m .4371 .49832 L .42986 .45298 L F
.771 .626 .699 r
.4585 .50212 m .4352 .51418 L .46014 .49396 L F
.787 .643 .702 r
.44428 .47945 m .43273 .4564 L .44182 .48885 L F
.928 .573 .332 r
.44335 .50713 m .42784 .43626 L .43146 .43947 L p F P
0 g
s
.928 .573 .332 r
.4431 .49427 m .44335 .50713 L .43146 .43947 L F
.945 .587 .274 r
.42533 .43263 m .42223 .42917 L p .42986 .45298 L F P
0 g
s
.942 .587 .19 r
.42032 .42537 m .42784 .43626 L p .43341 .48229 L F P
0 g
s
.787 .643 .702 r
.44503 .47659 m .45053 .4556 L .43512 .449 L F
.945 .587 .274 r
.44894 .5125 m .43453 .44289 L .43146 .43947 L p F P
0 g
s
.945 .587 .274 r
.43146 .43947 m .42533 .43263 L p .44194 .48881 L F P
0 g
s
.945 .587 .274 r
.44894 .5125 m .43146 .43947 L .44194 .48881 L F
.44638 .50973 m .44894 .5125 L p .4431 .49427 L F P
0 g
s
.945 .587 .274 r
.44894 .5125 m .42533 .43263 L .42986 .45298 L F
.928 .573 .332 r
.44222 .449 m .45538 .51745 L .45238 .51487 L p F P
0 g
s
.928 .573 .332 r
.44222 .449 m .45238 .51487 L .44377 .47162 L F
.903 .554 .373 r
.43453 .44289 m .44894 .5125 L .45238 .51487 L p F P
0 g
s
.903 .554 .373 r
.44254 .46544 m .43453 .44289 L .45238 .51487 L F
.928 .573 .332 r
.44254 .46544 m .44638 .50973 L .4431 .49427 L F
.44222 .449 m .44377 .47162 L .44254 .46544 L F
.44377 .47162 m .44638 .50973 L .44254 .46544 L F
.755 .61 .697 r
.45307 .52911 m .47406 .53328 L p .4585 .50212 L F P
0 g
s
.874 .533 .402 r
.45538 .51745 m .44222 .449 L .44675 .45162 L p F P
0 g
s
.874 .533 .402 r
.45646 .50462 m .45538 .51745 L .44675 .45162 L F
.903 .554 .373 r
.43863 .44582 m .43453 .44289 L p .44254 .46544 L F P
0 g
s
.928 .573 .332 r
.43146 .43947 m .44222 .449 L p .4431 .49427 L F P
0 g
s
.755 .61 .697 r
.47543 .52369 m .4585 .50212 L .47406 .53328 L F
.903 .554 .373 r
.46261 .52194 m .45082 .45453 L .44675 .45162 L p F P
0 g
s
.903 .554 .373 r
.44675 .45162 m .43863 .44582 L p .45549 .49934 L F P
0 g
s
.903 .554 .373 r
.46261 .52194 m .44675 .45162 L .45549 .49934 L F
.45919 .51958 m .46261 .52194 L p .45646 .50462 L F P
0 g
s
.903 .554 .373 r
.46261 .52194 m .43863 .44582 L .44254 .46544 L F
.845 .511 .422 r
.45409 .46321 m .45671 .46279 L .45082 .45453 L F
.874 .533 .402 r
.46022 .45942 m .47052 .52591 L .46674 .5238 L p F P
0 g
s
.874 .533 .402 r
.46022 .45942 m .46674 .5238 L .45984 .48183 L F
.46022 .45942 m .45984 .48183 L .45886 .47584 L F
.845 .511 .422 r
.45082 .45453 m .46261 .52194 L .46674 .5238 L p F P
0 g
s
.816 .49 .437 r
.47052 .52591 m .46022 .45942 L .46546 .46136 L p F P
0 g
s
.816 .49 .437 r
.47284 .51292 m .47052 .52591 L .46546 .46136 L F
.874 .533 .402 r
.45573 .45682 m .46022 .45942 L p .45886 .47584 L F P
0 g
s
.845 .511 .422 r
.47284 .51292 m .46546 .46136 L .45409 .46321 L F
.47904 .52934 m .46546 .46136 L .47284 .51292 L F
.47493 .52749 m .47904 .52934 L p .47284 .51292 L F P
0 g
s
.787 .468 .447 r
.47348 .47183 m .47653 .47101 L .47033 .46363 L F
.816 .49 .437 r
.48103 .46711 m .48806 .53217 L .48367 .53061 L p F P
0 g
s
.816 .49 .437 r
.48103 .46711 m .48367 .53061 L .47876 .48961 L F
.48103 .46711 m .47876 .48961 L .47806 .48375 L F
.787 .468 .447 r
.47033 .46363 m .47904 .52934 L .48367 .53061 L p F P
0 g
s
.759 .446 .455 r
.48806 .53217 m .48103 .46711 L .48673 .46829 L p F P
0 g
s
.759 .446 .455 r
.49152 .51884 m .48806 .53217 L .48673 .46829 L F
.816 .49 .437 r
.47583 .46519 m .48103 .46711 L p .47806 .48375 L F P
0 g
s
.787 .468 .447 r
.49152 .51884 m .48673 .46829 L .47348 .47183 L F
.49749 .53439 m .48673 .46829 L .49152 .51884 L F
.49287 .53313 m .49749 .53439 L p .49152 .51884 L F P
0 g
s
.722 .58 .695 r
.51818 .50157 m .49851 .50034 L p .51756 .52742 L F P
0 g
s
.722 .58 .695 r
.49851 .50034 m .51818 .50157 L p .50079 .47302 L F P
0 g
s
.722 .58 .695 r
.51842 .49187 m .50079 .47302 L .51818 .50157 L F
.759 .446 .455 r
.50373 .47179 m .50723 .53598 L .50243 .53503 L p F P
0 g
s
.759 .446 .455 r
.50373 .47179 m .50243 .53503 L .49968 .49465 L F
.731 .423 .46 r
.4922 .46984 m .49749 .53439 L .50243 .53503 L p F P
0 g
s
.731 .423 .46 r
.49929 .48889 m .4922 .46984 L .50243 .53503 L F
.759 .446 .455 r
.49929 .48889 m .49287 .53313 L .49152 .51884 L F
.50373 .47179 m .49968 .49465 L .49929 .48889 L F
.49968 .49465 m .49287 .53313 L .49929 .48889 L F
.702 .4 .463 r
.50723 .53598 m .50373 .47179 L .50966 .47217 L p F P
0 g
s
.702 .4 .463 r
.51167 .52215 m .50723 .53598 L .50966 .47217 L F
.731 .423 .46 r
.49805 .47062 m .4922 .46984 L p .49929 .48889 L F P
0 g
s
.759 .446 .455 r
.48673 .46829 m .50373 .47179 L p .49152 .51884 L F P
0 g
s
.731 .423 .46 r
.51717 .53692 m .51549 .47295 L .50966 .47217 L p F P
0 g
s
.731 .423 .46 r
.50966 .47217 m .49805 .47062 L p .51147 .51716 L F P
0 g
s
.731 .423 .46 r
.51717 .53692 m .50966 .47217 L .51147 .51716 L F
.51224 .53629 m .51717 .53692 L p .51167 .52215 L F P
0 g
s
.731 .423 .46 r
.51717 .53692 m .49805 .47062 L .49929 .48889 L F
.672 .376 .463 r
.51549 .47295 m .51717 .53692 L .5222 .5369 L p F P
0 g
s
.702 .4 .463 r
.52736 .47329 m .5272 .5372 L .5222 .5369 L p F P
0 g
s
.702 .4 .463 r
.52736 .47329 m .5222 .5369 L .52172 .49678 L F
.672 .376 .463 r
.52166 .49106 m .51549 .47295 L .5222 .5369 L F
.702 .4 .463 r
.52166 .49106 m .51224 .53629 L .51167 .52215 L F
.52736 .47329 m .52172 .49678 L .52166 .49106 L F
.52172 .49678 m .51224 .53629 L .52166 .49106 L F
.672 .376 .463 r
.52144 .47291 m .51549 .47295 L p .52166 .49106 L F P
0 g
s
.714 .358 .372 r
.50966 .47217 m .51549 .47295 L p .50907 .46522 L F P
0 g
s
.702 .4 .463 r
.50966 .47217 m .52736 .47329 L p .51167 .52215 L F P
0 g
s
.649 .307 .378 r
.53923 .47282 m .53433 .44306 L .5336 .46361 L F
.53923 .47282 m .5336 .46361 L .53352 .46593 L F
.532 .206 .361 r
.55803 .46093 m .55095 .47155 L .56119 .44008 L F
.5566 .47032 m .55095 .47155 L p .55767 .4633 L F P
0 g
s
.532 .206 .361 r
.55767 .4633 m .55095 .47155 L .55803 .46093 L F
.614 .277 .376 r
.55482 .44049 m .55095 .47155 L .54504 .47198 L p F P
0 g
s
.575 .244 .371 r
.54125 .44199 m .53923 .47282 L .54504 .47198 L p F P
0 g
s
.575 .244 .371 r
.54689 .4524 m .54125 .44199 L .54504 .47198 L F
.614 .277 .376 r
.55482 .44049 m .54504 .47198 L .54715 .44965 L F
.575 .244 .371 r
.55767 .4633 m .54125 .44199 L .5566 .47032 L F
.689 .553 .695 r
.53793 .50147 m .55757 .50004 L p .53708 .47691 L F P
0 g
s
.672 .376 .463 r
.53723 .53682 m .53923 .47282 L .53327 .47285 L p F P
0 g
s
.649 .307 .378 r
.53327 .47285 m .53923 .47282 L p .53352 .46593 L F P
0 g
s
.614 .277 .376 r
.54715 .44965 m .54552 .46686 L .52736 .47329 L F
.53327 .47285 m .52736 .47329 L p .54552 .46686 L F P
0 g
s
.614 .277 .376 r
.53352 .46593 m .52736 .47329 L .5336 .46361 L F
.641 .351 .462 r
.5272 .5372 m .52736 .47329 L .53327 .47285 L p F P
0 g
s
.672 .376 .463 r
.53723 .53682 m .53327 .47285 L .53252 .51776 L F
.641 .351 .462 r
.53243 .52274 m .5272 .5372 L .53327 .47285 L F
.672 .376 .463 r
.53243 .52274 m .52144 .47291 L .52166 .49106 L F
.53723 .53682 m .53252 .51776 L .53243 .52274 L F
.53252 .51776 m .52144 .47291 L .53243 .52274 L F
.641 .351 .462 r
.5322 .53684 m .5272 .5372 L p .53243 .52274 L F P
0 g
s
.672 .376 .463 r
.53723 .53682 m .52166 .49106 L .522 .5199 L F
.5222 .5369 m .5322 .53684 L p .522 .5199 L F P
0 g
s
.672 .376 .463 r
.5322 .53684 m .53723 .53682 L p .522 .5199 L F P
0 g
s
.733 .623 .736 r
.49555 .53603 m .50633 .53742 L p .49488 .5423 L F P
0 g
s
.719 .611 .735 r
.51699 .54782 m .49555 .53603 L .49518 .53944 L F
.52835 .55219 m .51703 .54661 L .51699 .54782 L F
.51703 .54661 m .49555 .53603 L .51699 .54782 L F
.705 .599 .735 r
.51648 .56422 m .50446 .56428 L p .5167 .55702 L F P
0 g
s
.719 .611 .735 r
.52843 .56493 m .49488 .5423 L .49276 .56203 L F
.51648 .56422 m .52843 .56493 L p .49276 .56203 L F P
0 g
s
.719 .611 .735 r
.52843 .56493 m .52835 .55219 L p .49518 .53944 L F P
0 g
s
.719 .611 .735 r
.52843 .56493 m .49518 .53944 L .49488 .5423 L F
.682 .695 .856 r
.54063 .56741 m .54043 .56497 L .52843 .56493 L F
.691 .702 .856 r
.52859 .57825 m .52847 .56848 L p .52782 .57825 L F P
0 g
s
.348 .788 .963 r
.54153 .57824 m .51519 .58028 L .51566 .57837 L F
.52859 .57825 m .51566 .57837 L .51568 .57826 L F
.54153 .57824 m .51566 .57837 L .52859 .57825 L F
.426 .841 .966 r
.57989 .57468 m .56903 .57825 L .56728 .57645 L F
.59249 .57291 m .59125 .57319 L .57989 .57468 L F
.59125 .57319 m .56903 .57825 L .57989 .57468 L F
.686 .699 .856 r
.55238 .56404 m .54321 .56667 L .54055 .56643 L F
.682 .695 .856 r
.52843 .56493 m .52859 .57825 L p .54145 .57755 L F P
0 g
s
.682 .695 .856 r
.5407 .56822 m .52843 .56493 L .54145 .57755 L F
.686 .699 .856 r
.55238 .56404 m .55436 .57729 L p .54149 .57813 L F P
0 g
s
.299 .739 .965 r
.48923 .57757 m .46045 .57614 L .46069 .576 L F
.286 .717 .968 r
.46045 .57614 m .43786 .56947 L .43452 .57079 L F
.282 .698 .971 r
.43949 .56882 m .41044 .56363 L .41535 .5624 L F
.42757 .56558 m .41535 .5624 L .41563 .56233 L F
.43949 .56882 m .41535 .5624 L .42757 .56558 L F
.699 .711 .858 r
.46711 .57388 m .46579 .5699 L .46463 .57336 L F
.286 .717 .968 r
.46069 .576 m .43796 .56943 L .46045 .57614 L F
.43796 .56943 m .43786 .56947 L .46045 .57614 L F
.309 0 0 r
.4459 .57423 m .44652 .57457 L .46024 .57628 L p F P
0 g
s
.282 .698 .971 r
.43826 .56931 m .40987 .56377 L .43949 .56882 L F
.285 .681 .972 r
.40987 .56377 m .39242 .55438 L .39028 .55469 L F
.41051 .56361 m .39242 .55438 L .40987 .56377 L F
.309 .651 .97 r
.36251 .54542 m .37028 .5449 L .34982 .53395 L F
.37028 .5449 m .37069 .54488 L .3603 .53943 L F
.37028 .5449 m .3603 .53943 L .34982 .53395 L F
.36251 .54542 m .34982 .53395 L .34727 .53394 L F
.294 .665 .972 r
.34766 .54046 m .3596 .54007 L .37069 .54488 L p F P
0 g
s
.714 .736 .868 r
.37229 .52864 m .3603 .53943 L p .35084 .53349 L F P
0 g
s
.714 .736 .868 r
.37229 .52864 m .35084 .53349 L .36055 .52554 L F
.712 .731 .865 r
.37964 .54884 m .37383 .54175 L .37069 .54488 L F
.709 .726 .863 r
.37383 .54175 m .37069 .54488 L .36206 .54036 L F
.706 .721 .861 r
.39842 .5434 m .40097 .544 L .39186 .53818 L F
.40265 .54194 m .39186 .53818 L p .40097 .544 L F P
0 g
s
.706 .721 .861 r
.40026 .54487 m .40097 .544 L .39842 .5434 L F
.39186 .53818 m .38146 .54965 L p .39255 .55436 L F P
0 g
s
.294 .665 .972 r
.39255 .55436 m .39102 .55389 L .38146 .54965 L F
.39102 .55389 m .34766 .54046 L .37069 .54488 L F
.706 .721 .861 r
.38146 .54965 m .38085 .55032 L .39255 .55436 L p F P
0 g
s
.712 .731 .865 r
.38085 .55032 m .39186 .53818 L .3825 .53311 L p F P
0 g
s
.709 .726 .863 r
.3596 .54007 m .37229 .52864 L .3825 .53311 L p F P
0 g
s
.709 .726 .863 r
.37485 .54073 m .3596 .54007 L .3825 .53311 L F
.712 .731 .865 r
.38085 .55032 m .3825 .53311 L .37383 .54175 L F
.706 .721 .861 r
.40026 .54487 m .39186 .53818 L .39255 .55436 L F
.709 .726 .863 r
.40026 .54487 m .3596 .54007 L .40265 .54194 L F
.773 .665 .744 r
.40349 .51319 m .39186 .53818 L .40265 .54194 L p F P
0 g
s
.786 .681 .748 r
.42248 .52076 m .41312 .54526 L p .40299 .54113 L F P
0 g
s
.786 .681 .748 r
.42248 .52076 m .40299 .54113 L .41082 .52259 L F
.773 .665 .744 r
.41082 .52259 m .40349 .51319 L .40265 .54194 L F
.786 .681 .748 r
.41312 .54526 m .4127 .54634 L .40265 .54194 L p F P
0 g
s
.786 .681 .748 r
.38584 .52651 m .38263 .53285 L .37229 .52864 L F
.799 .698 .753 r
.3825 .53311 m .39186 .53818 L p .38584 .52651 L F P
0 g
s
.786 .681 .748 r
.3825 .53311 m .37229 .52864 L p .38263 .53285 L F P
0 g
s
.799 .698 .753 r
.39186 .53818 m .40349 .51319 L .39497 .5085 L p F P
0 g
s
.799 .698 .753 r
.39186 .53818 m .39497 .5085 L .38584 .52651 L F
.786 .681 .748 r
.41312 .54526 m .3825 .53311 L .38263 .53285 L F
.773 .665 .744 r
.41332 .51668 m .40349 .51319 L p .41082 .52259 L F P
0 g
s
.786 .681 .748 r
.37229 .52864 m .38568 .50436 L .41332 .51668 L p F P
0 g
s
.786 .681 .748 r
.41332 .51668 m .42248 .52076 L p .41082 .52259 L F P
0 g
s
.786 .681 .748 r
.41082 .52259 m .37229 .52864 L .41332 .51668 L F
.773 .665 .744 r
.4346 .55307 m .44247 .52701 L .43275 .52357 L p F P
0 g
s
.773 .665 .744 r
.4346 .55307 m .43275 .52357 L .42707 .54021 L F
.4346 .55307 m .42707 .54021 L .42631 .54245 L F
.76 .65 .741 r
.4127 .54634 m .42248 .52076 L .43275 .52357 L p F P
0 g
s
.747 .636 .738 r
.45146 .53526 m .45219 .53245 L .44247 .52701 L F
.45307 .52911 m .44247 .52701 L p .45219 .53245 L F P
0 g
s
.76 .65 .741 r
.45307 .52911 m .46323 .53189 L p .45146 .53526 L F P
0 g
s
.76 .65 .741 r
.46323 .53189 m .4462 .55534 L .45146 .53526 L F
.747 .636 .738 r
.48254 .54942 m .47238 .54242 L .47216 .54362 L F
.48254 .54942 m .47406 .53328 L .47238 .54242 L F
.733 .623 .736 r
.49488 .5423 m .47049 .55271 L .49555 .53603 L F
.47049 .55271 m .45733 .55833 L .47091 .5504 L F
.47049 .55271 m .47091 .5504 L .49555 .53603 L F
.747 .636 .738 r
.47216 .54362 m .45307 .52911 L .45219 .53245 L F
.47238 .54242 m .45307 .52911 L .47216 .54362 L F
.733 .623 .736 r
.46918 .55982 m .45733 .55833 L p .47049 .55271 L F P
0 g
s
.747 .636 .738 r
.44247 .52701 m .43493 .55197 L p .48069 .56207 L F P
0 g
s
.703 .716 .859 r
.42239 .55179 m .40466 .55862 L .41037 .54954 L F
.285 .681 .972 r
.41051 .56361 m .41531 .56241 L .40059 .55724 L F
.703 .716 .859 r
.40396 .55838 m .41037 .54954 L p .40466 .55862 L F P
0 g
s
.285 .681 .972 r
.42678 .56643 m .42716 .56631 L .41563 .56233 L p F P
0 g
s
.703 .716 .859 r
.41784 .55888 m .40593 .55905 L .42239 .55179 L F
.40593 .55905 m .40466 .55862 L .42239 .55179 L F
.709 .726 .863 r
.4127 .54634 m .40396 .55838 L p .39255 .55436 L F P
0 g
s
.285 .681 .972 r
.42678 .56643 m .41563 .56233 L .40396 .55838 L F
.41051 .56361 m .40059 .55724 L .39302 .55468 L F
.706 .721 .861 r
.41563 .56233 m .42716 .56631 L p .41784 .55888 L F P
0 g
s
.695 .707 .857 r
.45733 .55833 m .46918 .55982 L p .45267 .57131 L F P
0 g
s
.299 .739 .965 r
.48936 .57743 m .46071 .57598 L .46138 .57556 L F
.309 0 0 r
.48229 .57696 m .4561 .57368 L p .46703 .57594 L F P
0 g
s
.309 0 0 r
.46703 .57594 m .4561 .57368 L .45719 .57436 L F
.299 .739 .965 r
.48987 .57683 m .46169 .57536 L .46441 .57365 L F
.47722 .57519 m .46441 .57365 L .46457 .57355 L F
.48987 .57683 m .46441 .57365 L .47722 .57519 L F
.695 .707 .857 r
.50446 .56428 m .49476 .56569 L .49223 .5651 L F
.691 .702 .856 r
.48069 .56207 m .47722 .57519 L p .49008 .57615 L F P
0 g
s
.691 .702 .856 r
.49204 .56608 m .48069 .56207 L .49008 .57615 L F
.747 .636 .738 r
.46918 .55982 m .48069 .56207 L p .43493 .55197 L F P
0 g
s
.691 .702 .856 r
.49204 .56608 m .49251 .56365 L .48069 .56207 L F
.695 .707 .857 r
.49268 .56279 m .50446 .56428 L p .49223 .5651 L F P
0 g
s
.686 .699 .856 r
.51589 .57453 m .5027 .57832 L .51648 .56422 L F
.691 .702 .856 r
.49268 .56279 m .48069 .56207 L p .52847 .56848 L F P
0 g
s
.695 .707 .857 r
.45206 .57119 m .45733 .55833 L p .45267 .57131 L F P
0 g
s
.703 .716 .859 r
.45733 .55833 m .45206 .57119 L p .43971 .56874 L F P
0 g
s
.703 .716 .859 r
.45733 .55833 m .43971 .56874 L .44467 .5585 L F
.45733 .55833 m .44467 .5585 L .4458 .55617 L F
.699 .711 .858 r
.4462 .55534 m .4346 .55307 L p .44467 .5585 L F P
0 g
s
.699 .711 .858 r
.4346 .55307 m .42757 .56558 L p .43998 .56818 L F P
0 g
s
.699 .711 .858 r
.44417 .55954 m .4346 .55307 L .43998 .56818 L F
.703 .716 .859 r
.4462 .55534 m .45733 .55833 L p .4458 .55617 L F P
0 g
s
.699 .711 .858 r
.44467 .5585 m .4346 .55307 L .44417 .55954 L F
.703 .716 .859 r
.42239 .55179 m .41037 .54954 L .42257 .55152 L F
.706 .721 .861 r
.42716 .56631 m .42395 .54936 L .41805 .55855 L F
.747 .636 .738 r
.43493 .55197 m .4346 .55307 L .4462 .55534 L p F P
0 g
s
.773 .665 .744 r
.42395 .54936 m .4346 .55307 L p .42631 .54245 L F P
0 g
s
.703 .716 .859 r
.41037 .54954 m .4127 .54634 L .4462 .55534 L p F P
0 g
s
.709 .726 .863 r
.40265 .54194 m .4127 .54634 L p .40026 .54487 L F P
0 g
s
.709 .726 .863 r
.4127 .54634 m .39255 .55436 L .39944 .54588 L F
.706 .721 .861 r
.41805 .55855 m .42395 .54936 L .40097 .544 L F
.703 .716 .859 r
.4458 .55617 m .42239 .55179 L .4462 .55534 L F
.42239 .55179 m .42257 .55152 L .4462 .55534 L F
.699 .711 .858 r
.47701 .57595 m .48069 .56207 L .46918 .55982 L p F P
0 g
s
.699 .711 .858 r
.47701 .57595 m .46918 .55982 L .46619 .56871 L F
.299 .739 .965 r
.48936 .57743 m .46138 .57556 L .48987 .57683 L F
.46138 .57556 m .46169 .57536 L .48987 .57683 L F
.282 .698 .971 r
.40987 .56377 m .41044 .56363 L .43949 .56882 L F
.286 .717 .968 r
.46138 .57556 m .44846 .57051 L .43949 .56882 L F
.282 .698 .971 r
.45176 .57194 m .44889 .57139 L .43949 .56882 L F
.695 .707 .857 r
.46579 .5699 m .45418 .57159 L .46918 .55982 L F
.45418 .57159 m .45267 .57131 L .46918 .55982 L F
.286 .717 .968 r
.46216 .57507 m .44846 .57051 L .46138 .57556 L F
.46216 .57507 m .46439 .57366 L .44846 .57051 L F
.695 .707 .857 r
.46579 .5699 m .46463 .57336 L .46205 .57307 L F
.286 .717 .968 r
.47682 .57611 m .46457 .57355 L .45206 .57119 L F
.695 .707 .857 r
.46579 .5699 m .46205 .57307 L .45418 .57159 L F
.699 .711 .858 r
.46457 .57355 m .47701 .57595 L p .46463 .57336 L F P
0 g
s
.699 .711 .858 r
.46579 .5699 m .4462 .55534 L .44467 .5585 L F
.47701 .57595 m .46619 .56871 L .46579 .5699 L F
.46619 .56871 m .4462 .55534 L .46579 .5699 L F
.695 .707 .857 r
.5028 .57755 m .48997 .57673 L .49007 .57621 L F
.691 .702 .856 r
.49008 .57615 m .47722 .57519 L .48997 .57673 L F
.699 .711 .858 r
.47508 .57491 m .46579 .5699 L .46711 .57388 L F
.695 .707 .857 r
.5028 .57755 m .46457 .57355 L .46463 .57336 L F
.691 .702 .856 r
.51568 .57826 m .5286 .57902 L p .51569 .57806 L F P
0 g
s
.686 .699 .856 r
.51568 .57826 m .5027 .57832 L p .51589 .57453 L F P
0 g
s
.691 .702 .856 r
.5286 .57902 m .49204 .56608 L .49008 .57615 L F
.682 .695 .856 r
.54063 .56741 m .52843 .56493 L .5407 .56822 L F
.686 .699 .856 r
.55238 .56404 m .54149 .57813 L .54063 .56741 L F
.426 .841 .966 r
.57989 .57468 m .56728 .57645 L .56717 .57634 L F
.384 .815 .963 r
.56876 .57797 m .56729 .57646 L .55068 .57756 L F
.319 .763 .963 r
.51502 .58099 m .48923 .57757 L .51498 .58116 L F
.48923 .57757 m .48919 .57762 L .51498 .58116 L F
.51498 .58116 m .48919 .57762 L .4878 .57924 L F
.348 .788 .963 r
.54175 .57885 m .51494 .58131 L .51514 .58051 L F
.54183 .5791 m .51494 .58131 L .54175 .57885 L F
.319 .763 .963 r
.52289 .58143 m .51514 .58051 L .51773 .58135 L F
.299 .739 .965 r
.48923 .57757 m .46069 .576 L .48936 .57743 L F
.46069 .576 m .46071 .57598 L .48936 .57743 L F
.319 .763 .963 r
.51514 .58051 m .47701 .57595 L .51502 .58099 L F
.51514 .58051 m .51502 .58099 L .51773 .58135 L F
.348 .788 .963 r
.54175 .57885 m .51514 .58051 L .54153 .57824 L F
.319 .763 .963 r
.48742 .57968 m .52876 .58213 L p .4878 .57924 L F P
0 g
s
.299 .739 .965 r
.48742 .57968 m .46024 .57628 L p .4878 .57924 L F P
0 g
s
.286 .717 .968 r
.43362 .57114 m .46024 .57628 L p .43442 .57083 L F P
0 g
s
.282 .698 .971 r
.43362 .57114 m .40781 .56429 L p .43452 .57079 L F P
0 g
s
.328 0 0 r
.39372 .56037 m .39475 .56082 L .40781 .56429 L p F P
0 g
s
.282 .698 .971 r
.43452 .57079 m .40781 .56429 L .4082 .56419 L F
.285 .681 .972 r
.38305 .55576 m .40781 .56429 L p .37254 .55122 L F P
0 g
s
.285 .681 .972 r
.40781 .56429 m .42017 .56855 L p .4082 .56419 L F P
0 g
s
.285 .681 .972 r
.4082 .56419 m .37254 .55122 L .40781 .56429 L F
.294 .665 .972 r
.39028 .55469 m .34766 .54046 L .39255 .55436 L F
.285 .681 .972 r
.40987 .56377 m .38085 .55032 L .40862 .56408 L F
.40616 .56286 m .40527 .5627 L .4082 .56419 L F
.40862 .56408 m .40616 .56286 L .4082 .56419 L F
.282 .698 .971 r
.40987 .56377 m .40552 .56352 L .40127 .56209 L F
.286 .717 .968 r
.46138 .57556 m .43949 .56882 L .43826 .56931 L F
.46138 .57556 m .43826 .56931 L .46069 .576 L F
.282 .698 .971 r
.43826 .56931 m .40862 .56408 L .40987 .56377 L F
.43796 .56943 m .40862 .56408 L .43826 .56931 L F
.286 .717 .968 r
.43826 .56931 m .42716 .56631 L .43796 .56943 L F
.43826 .56931 m .43796 .56943 L .46069 .576 L F
.282 .698 .971 r
.45176 .57194 m .43796 .56943 L .43826 .56931 L F
.40862 .56408 m .40552 .56352 L .40987 .56377 L F
.40781 .56429 m .39475 .56082 L p .4082 .56419 L F P
0 g
s
.282 .698 .971 r
.43796 .56943 m .4082 .56419 L .40862 .56408 L F
.285 .681 .972 r
.41574 .56649 m .40987 .56377 L .4106 .56506 L F
.40987 .56377 m .40862 .56408 L .4106 .56506 L F
.286 .717 .968 r
.43442 .57083 m .42155 .5681 L .43362 .57114 L F
.46045 .57614 m .42155 .5681 L .46024 .57628 L F
.282 .698 .971 r
.44755 .57405 m .43362 .57114 L .43452 .57079 L F
.299 .739 .965 r
.46024 .57628 m .44652 .57457 L p .46045 .57614 L F P
0 g
s
.299 .739 .965 r
.4878 .57924 m .46024 .57628 L .46045 .57614 L F
.286 .717 .968 r
.46024 .57628 m .47356 .57885 L p .46045 .57614 L F P
0 g
s
.319 .763 .963 r
.4878 .57924 m .47424 .57828 L .48742 .57968 L F
.299 .739 .965 r
.50138 .58078 m .48742 .57968 L .4878 .57924 L F
.348 .788 .963 r
.51514 .58051 m .50105 .58138 L .51519 .58028 L F
.51514 .58051 m .51519 .58028 L .54153 .57824 L F
.426 .841 .966 r
.5936 .57355 m .56928 .5785 L .59249 .57291 L F
.384 .815 .963 r
.56907 .57828 m .55068 .57756 L .54153 .57824 L F
.56876 .57797 m .55068 .57756 L .56907 .57828 L F
.426 .841 .966 r
.56928 .5785 m .56903 .57825 L .59249 .57291 L F
.181 0 0 r
.58432 .578 m .58387 .57831 L .57003 .57927 L p F P
0 g
s
.384 .815 .963 r
.58387 .57831 m .54153 .57824 L .54175 .57885 L F
.56928 .5785 m .54175 .57885 L .56989 .57912 L F
.54175 .57885 m .54182 .57906 L .56989 .57912 L F
.56989 .57912 m .54182 .57906 L .5424 .58072 L F
.426 .841 .966 r
.56928 .5785 m .55645 .58111 L .56903 .57825 L F
.384 .815 .963 r
.58387 .57831 m .56876 .57797 L .56907 .57828 L F
.54175 .57885 m .54153 .57824 L .53139 .57899 L F
.677 .692 .857 r
.55238 .56404 m .56412 .56243 L p .55498 .57724 L F P
0 g
s
.677 .692 .857 r
.55436 .57729 m .55238 .56404 L p .55498 .57724 L F P
0 g
s
.384 .815 .963 r
.58031 .5756 m .58011 .57545 L .56717 .57634 L p F P
0 g
s
.677 .692 .857 r
.56636 .57265 m .55653 .57713 L .56412 .56243 L F
.55653 .57713 m .55498 .57724 L .56412 .56243 L F
.384 .815 .963 r
.58031 .5756 m .56717 .57634 L .55436 .57729 L F
.682 .695 .856 r
.56973 .57601 m .56713 .57615 L .56717 .57634 L F
.57773 .57496 m .56636 .57265 L .56973 .57601 L F
.677 .692 .857 r
.56636 .57265 m .56717 .57634 L .55653 .57713 L F
.682 .695 .856 r
.56636 .57265 m .54063 .56741 L .56692 .57518 L F
.56636 .57265 m .56692 .57518 L .56973 .57601 L F
.54063 .56741 m .5407 .56822 L .56973 .57601 L F
.56973 .57601 m .5407 .56822 L .54145 .57755 L F
.686 .699 .856 r
.54036 .5641 m .55238 .56404 L p .54055 .56643 L F P
0 g
s
.682 .695 .856 r
.58011 .57545 m .5771 .56508 L p .54043 .56497 L F P
0 g
s
.686 .699 .856 r
.54321 .56667 m .54063 .56741 L .54055 .56643 L F
.682 .695 .856 r
.58011 .57545 m .54043 .56497 L .54063 .56741 L F
.672 .689 .858 r
.57609 .56159 m .57989 .57468 L p .59231 .57241 L F P
0 g
s
.672 .689 .858 r
.58911 .56358 m .57609 .56159 L .59231 .57241 L F
.521 .89 .971 r
.64307 .56165 m .62193 .56958 L .64114 .5612 L F
.672 .689 .858 r
.62724 .56513 m .61541 .56431 L .61722 .56786 L F
.667 .687 .859 r
.61541 .56431 m .61722 .56786 L .60701 .57 L F
.677 .692 .857 r
.59936 .55762 m .60494 .57043 L p .59249 .57291 L F P
0 g
s
.677 .692 .857 r
.59936 .55762 m .59249 .57291 L .58911 .56358 L F
.59936 .55762 m .58911 .56358 L .58871 .56247 L F
.672 .689 .858 r
.58871 .56247 m .57609 .56159 L .58911 .56358 L F
.705 .599 .735 r
.55016 .53719 m .55238 .56404 L .54036 .5641 L p F P
0 g
s
.676 .577 .736 r
.55238 .56404 m .55016 .53719 L .5609 .5357 L p F P
0 g
s
.676 .577 .736 r
.56326 .55527 m .55238 .56404 L .5609 .5357 L F
.705 .599 .735 r
.55016 .53719 m .54036 .5641 L .53954 .54571 L F
.691 .588 .735 r
.52825 .53803 m .52843 .56493 L .54036 .5641 L p F P
0 g
s
.691 .588 .735 r
.53954 .54571 m .52825 .53803 L .54036 .5641 L F
.705 .599 .735 r
.55016 .53719 m .53954 .54571 L .53945 .54354 L F
.691 .588 .735 r
.57609 .56159 m .57184 .53492 L .5609 .5357 L p F P
0 g
s
.691 .588 .735 r
.57609 .56159 m .5609 .5357 L .56298 .55295 L F
.705 .599 .735 r
.53917 .53725 m .55016 .53719 L p .53945 .54354 L F P
0 g
s
.691 .588 .735 r
.57609 .56159 m .53917 .53725 L .53945 .54354 L F
.56412 .56243 m .57609 .56159 L p .56326 .55527 L F P
0 g
s
.661 .567 .738 r
.57184 .53492 m .57609 .56159 L .58754 .55923 L p F P
0 g
s
.676 .577 .736 r
.5931 .53123 m .59936 .55762 L .58754 .55923 L p F P
0 g
s
.676 .577 .736 r
.5931 .53123 m .58754 .55923 L .58396 .54108 L F
.661 .567 .738 r
.58353 .53894 m .57184 .53492 L .58754 .55923 L F
.676 .577 .736 r
.58353 .53894 m .56412 .56243 L .56326 .55527 L F
.5931 .53123 m .58396 .54108 L .58353 .53894 L F
.58396 .54108 m .56412 .56243 L .58353 .53894 L F
.661 .567 .738 r
.58231 .53273 m .57184 .53492 L p .58353 .53894 L F P
0 g
s
.676 .577 .736 r
.5609 .5357 m .5931 .53123 L p .56326 .55527 L F P
0 g
s
.661 .567 .738 r
.62195 .55213 m .61374 .52614 L .6032 .52835 L p F P
0 g
s
.661 .567 .738 r
.62195 .55213 m .6032 .52835 L .60785 .54523 L F
.645 .557 .741 r
.60847 .5475 m .59936 .55762 L .6032 .52835 L F
.661 .567 .738 r
.60847 .5475 m .58231 .53273 L .58353 .53894 L F
.62195 .55213 m .60785 .54523 L .60847 .5475 L F
.60785 .54523 m .58231 .53273 L .60847 .5475 L F
.645 .557 .741 r
.61041 .55451 m .59936 .55762 L p .60847 .5475 L F P
0 g
s
.661 .567 .738 r
.62195 .55213 m .58353 .53894 L .5874 .55848 L F
.58754 .55923 m .61041 .55451 L p .5874 .55848 L F P
0 g
s
.661 .567 .738 r
.61041 .55451 m .62195 .55213 L p .5874 .55848 L F P
0 g
s
.472 .867 .969 r
.63701 .56747 m .63011 .56542 L p .60141 .57118 L F P
0 g
s
.472 .867 .969 r
.63701 .56747 m .60141 .57118 L .58297 .57504 L F
.667 .687 .859 r
.59936 .55762 m .61041 .55451 L p .60553 .57031 L F P
0 g
s
.667 .687 .859 r
.60494 .57043 m .59936 .55762 L p .60553 .57031 L F P
0 g
s
.672 .689 .858 r
.62195 .55213 m .61041 .55451 L p .62724 .56513 L F P
0 g
s
.521 .89 .971 r
.62929 .56458 m .61745 .56794 L .61722 .56786 L F
.472 .867 .969 r
.63011 .56542 m .61722 .56786 L .60494 .57043 L F
.667 .687 .859 r
.61482 .56316 m .60656 .57009 L .61041 .55451 L F
.472 .867 .969 r
.63011 .56542 m .60494 .57043 L .60141 .57118 L F
.667 .687 .859 r
.60656 .57009 m .60526 .57118 L .60553 .57031 L F
.60656 .57009 m .60553 .57031 L .61041 .55451 L F
.472 .867 .969 r
.59249 .57291 m .58011 .57545 L p .60141 .57118 L F P
0 g
s
.472 .867 .969 r
.60494 .57043 m .59249 .57291 L .60141 .57118 L F
.677 .692 .857 r
.58754 .55923 m .59936 .55762 L p .58871 .56247 L F P
0 g
s
.672 .689 .858 r
.62724 .56513 m .61041 .55451 L .61541 .56431 L F
.62929 .56458 m .62195 .55213 L p .62724 .56513 L F P
0 g
s
.662 .685 .861 r
.63524 .55241 m .62195 .55213 L .64114 .5612 L F
.67561 .54884 m .66714 .53982 L p .65556 .54298 L F P
0 g
s
.662 .685 .861 r
.67561 .54884 m .65556 .54298 L .66125 .54972 L F
.652 .682 .866 r
.67639 .53439 m .6643 .5368 L .67732 .53528 L F
.657 .683 .863 r
.66125 .54972 m .66387 .55283 L .66174 .55383 L F
.617 .924 .972 r
.69702 .54391 m .6738 .55431 L p .68834 .54344 L F P
0 g
s
.617 .924 .972 r
.68834 .54344 m .6738 .55431 L .67122 .55396 L F
.57 .91 .973 r
.68625 .54986 m .67619 .54889 L p .66442 .55305 L F P
0 g
s
.57 .91 .973 r
.66945 .55372 m .66442 .55305 L .64947 .55833 L F
.68625 .54986 m .66442 .55305 L .66945 .55372 L F
.617 .924 .972 r
.6738 .55431 m .66223 .55949 L p .67122 .55396 L F P
0 g
s
.57 .91 .973 r
.68625 .54986 m .64947 .55833 L .64222 .56099 L F
.657 .683 .863 r
.66125 .54972 m .66174 .55383 L .65462 .55644 L F
.57 .91 .973 r
.67619 .54889 m .67561 .54884 L .66402 .553 L p F P
0 g
s
.662 .685 .861 r
.67313 .54899 m .66125 .54972 L .66402 .553 L F
.657 .683 .863 r
.66387 .55283 m .66402 .553 L .66174 .55383 L F
.57 .91 .973 r
.67619 .54889 m .66402 .553 L .65271 .55714 L F
.64114 .5612 m .62972 .5653 L p .64947 .55833 L F P
0 g
s
.57 .91 .973 r
.67619 .54889 m .65271 .55714 L .64947 .55833 L F
.65271 .55714 m .64114 .5612 L .64947 .55833 L F
.657 .683 .863 r
.65556 .54298 m .65339 .55689 L .64608 .54836 L F
.65324 .55784 m .65271 .55714 L p .65339 .55689 L F P
0 g
s
.657 .683 .863 r
.65271 .55714 m .64608 .54836 L p .65339 .55689 L F P
0 g
s
.662 .685 .861 r
.66714 .53982 m .6643 .5368 L .65361 .54067 L p F P
0 g
s
.662 .685 .861 r
.66714 .53982 m .65361 .54067 L .65534 .54272 L F
.657 .683 .863 r
.64608 .54836 m .64367 .54518 L .65361 .54067 L p F P
0 g
s
.657 .683 .863 r
.65534 .54272 m .64608 .54836 L .65361 .54067 L F
.662 .685 .861 r
.66714 .53982 m .65534 .54272 L .65556 .54298 L F
.657 .683 .863 r
.67353 .53163 m .68363 .52705 L p .67428 .53236 L F P
0 g
s
.652 .682 .866 r
.67373 .53492 m .67554 .53357 L .6643 .5368 L F
.67353 .53163 m .6643 .5368 L p .67554 .53357 L F P
0 g
s
.657 .683 .863 r
.67428 .53236 m .64608 .54836 L .67353 .53163 L F
.652 .682 .866 r
.69204 .52127 m .67353 .53163 L p .67554 .53357 L F P
0 g
s
.667 .687 .859 r
.64367 .54518 m .65271 .55714 L p .64114 .5612 L F P
0 g
s
.667 .687 .859 r
.64367 .54518 m .64114 .5612 L .63454 .55136 L F
.6325 .54831 m .64367 .54518 L p .63454 .55136 L F P
0 g
s
.662 .685 .861 r
.6325 .54831 m .62195 .55213 L p .65556 .54298 L F P
0 g
s
.662 .685 .861 r
.65534 .54272 m .6325 .54831 L .65556 .54298 L F
.645 .557 .741 r
.63356 .51969 m .64367 .54518 L .6325 .54831 L p F P
0 g
s
.629 .548 .745 r
.61374 .52614 m .62161 .55103 L p .63221 .5475 L F P
0 g
s
.629 .548 .745 r
.62551 .52862 m .61374 .52614 L .63221 .5475 L F
.645 .557 .741 r
.63356 .51969 m .6325 .54831 L .62624 .53069 L F
.629 .548 .745 r
.62161 .55103 m .62195 .55213 L .6325 .54831 L p F P
0 g
s
.629 .548 .745 r
.6643 .5368 m .65066 .53392 L .6535 .5404 L F
.612 .539 .749 r
.65361 .54067 m .64367 .54518 L p .65066 .53392 L F P
0 g
s
.629 .548 .745 r
.65361 .54067 m .6643 .5368 L p .6535 .5404 L F P
0 g
s
.612 .539 .749 r
.64367 .54518 m .63356 .51969 L .64262 .51551 L p F P
0 g
s
.612 .539 .749 r
.64971 .53173 m .64367 .54518 L .64262 .51551 L F
.593 .531 .754 r
.68816 .5149 m .65236 .51192 L .69204 .52127 L F
.629 .548 .745 r
.6643 .5368 m .65236 .51192 L .64262 .51551 L p F P
0 g
s
.629 .548 .745 r
.6643 .5368 m .64262 .51551 L .65066 .53392 L F
.612 .539 .749 r
.66374 .51287 m .65066 .53392 L .66075 .50713 L F
.65066 .53392 m .64367 .54518 L .64971 .53173 L F
.65066 .53392 m .64971 .53173 L .66075 .50713 L F
.645 .557 .741 r
.62551 .52862 m .61041 .55451 L .60847 .5475 L F
.63356 .51969 m .62624 .53069 L .62551 .52862 L F
.62624 .53069 m .61041 .55451 L .62551 .52862 L F
.629 .548 .745 r
.62337 .5226 m .61374 .52614 L p .62551 .52862 L F P
0 g
s
.645 .557 .741 r
.6032 .52835 m .63356 .51969 L p .62333 .53103 L F P
0 g
s
.629 .548 .745 r
.64262 .51551 m .62337 .5226 L p .65066 .53392 L F P
0 g
s
.629 .548 .745 r
.65066 .53392 m .62337 .5226 L .62551 .52862 L F
.6535 .5404 m .62161 .55103 L .65361 .54067 L F
.612 .539 .749 r
.64262 .51551 m .66075 .50713 L p .64971 .53173 L F P
0 g
s
.612 .539 .749 r
.67353 .53163 m .65361 .54067 L p .66374 .51287 L F P
0 g
s
.612 .539 .749 r
.66374 .51287 m .65361 .54067 L .65066 .53392 L F
.629 .548 .745 r
.6535 .5404 m .62551 .52862 L .63221 .5475 L F
.65066 .53392 m .62551 .52862 L .6535 .5404 L F
.6325 .54831 m .65361 .54067 L p .64289 .54414 L F P
0 g
s
.629 .548 .745 r
.64289 .54414 m .62161 .55103 L .6325 .54831 L F
.657 .683 .863 r
.66059 .54894 m .65324 .55784 L .65556 .54298 L F
.652 .682 .866 r
.70211 .52925 m .69204 .52127 L .67373 .53492 L F
.657 .683 .863 r
.67639 .53439 m .65324 .55784 L .67428 .53236 L F
.662 .685 .861 r
.66125 .54972 m .65556 .54298 L .62195 .55213 L F
.667 .687 .859 r
.6325 .54831 m .62892 .55132 L .62207 .5525 L F
.61041 .55451 m .6325 .54831 L p .62207 .5525 L F P
0 g
s
.645 .557 .741 r
.62624 .53069 m .6325 .54831 L .61103 .55357 L F
.657 .683 .863 r
.65361 .54067 m .67353 .53163 L p .66447 .53715 L F P
0 g
s
.657 .683 .863 r
.66447 .53715 m .65534 .54272 L .65361 .54067 L F
.67428 .53236 m .66059 .54894 L .65556 .54298 L F
.662 .685 .861 r
.65361 .54067 m .6325 .54831 L p .65534 .54272 L F P
0 g
s
.662 .685 .861 r
.66125 .54972 m .63454 .55136 L .66402 .553 L F
.657 .683 .863 r
.69588 .53774 m .68519 .54286 L .68513 .54281 L F
.652 .682 .866 r
.68519 .54286 m .67499 .54817 L .68563 .54329 L F
.68513 .54281 m .67499 .54817 L .68519 .54286 L F
.657 .683 .863 r
.68563 .54329 m .66402 .553 L p .68519 .54286 L F P
0 g
s
.657 .683 .863 r
.69588 .53774 m .68563 .54329 L .68519 .54286 L F
.642 .682 .872 r
.72353 .51923 m .71517 .52591 L .72416 .51964 L F
.647 .682 .869 r
.72416 .51964 m .6966 .53836 L p .71253 .51202 L F P
0 g
s
.652 .682 .866 r
.70556 .53199 m .68513 .54281 L .70576 .53214 L F
.68513 .54281 m .68519 .54286 L .70576 .53214 L F
.68563 .54329 m .70576 .53214 L p .68519 .54286 L F P
0 g
s
.657 .683 .863 r
.68513 .54281 m .66402 .553 L .66387 .55283 L F
.68519 .54286 m .66402 .553 L .68513 .54281 L F
.57 .91 .973 r
.66402 .553 m .64114 .5612 L p .65271 .55714 L F P
0 g
s
.657 .683 .863 r
.66402 .553 m .65324 .55784 L p .66174 .55383 L F P
0 g
s
.657 .683 .863 r
.65462 .55644 m .66174 .55383 L .65324 .55784 L F
.57 .91 .973 r
.64222 .56099 m .64947 .55833 L .64125 .56123 L F
.657 .683 .863 r
.67639 .53439 m .68513 .54281 L .66387 .55283 L F
.67639 .53439 m .66387 .55283 L .66125 .54972 L F
.645 .557 .741 r
.6325 .54831 m .61041 .55451 L p .61103 .55357 L F P
0 g
s
.667 .687 .859 r
.63454 .55136 m .60526 .57118 L .6325 .54831 L F
.672 .689 .858 r
.61041 .55451 m .57609 .56159 L p .61541 .56431 L F P
0 g
s
.667 .687 .859 r
.62892 .55132 m .61482 .56316 L .61041 .55451 L F
.521 .89 .971 r
.61722 .56786 m .64114 .5612 L p .62929 .56458 L F P
0 g
s
.672 .689 .858 r
.62972 .5653 m .62929 .56458 L p .62724 .56513 L F P
0 g
s
.472 .867 .969 r
.63011 .56542 m .62972 .5653 L .61722 .56786 L p F P
0 g
s
.472 .867 .969 r
.61722 .56786 m .59249 .57291 L p .60494 .57043 L F P
0 g
s
.667 .687 .859 r
.60526 .57118 m .60494 .57043 L p .60553 .57031 L F P
0 g
s
.645 .557 .741 r
.62333 .53103 m .60847 .5475 L .6032 .52835 L F
.661 .567 .738 r
.6032 .52835 m .58231 .53273 L p .60785 .54523 L F P
0 g
s
.676 .577 .736 r
.58754 .55923 m .56412 .56243 L p .58396 .54108 L F P
0 g
s
.676 .577 .736 r
.56412 .56243 m .55238 .56404 L p .56326 .55527 L F P
0 g
s
.691 .588 .735 r
.5609 .5357 m .53917 .53725 L p .56298 .55295 L F P
0 g
s
.691 .588 .735 r
.56326 .55527 m .53945 .54354 L .56412 .56243 L F
.53945 .54354 m .52825 .53803 L .53954 .54571 L F
.53945 .54354 m .53954 .54571 L .56412 .56243 L F
.53917 .53725 m .52825 .53803 L p .53945 .54354 L F P
0 g
s
.705 .599 .735 r
.51732 .53736 m .53917 .53725 L p .53655 .54526 L F P
0 g
s
.705 .599 .735 r
.53945 .54354 m .53655 .54526 L .53917 .53725 L F
.719 .611 .735 r
.52835 .55219 m .51732 .53736 L .51703 .54661 L F
.705 .599 .735 r
.53945 .54354 m .51648 .56422 L .5167 .55702 L F
.53954 .54571 m .51648 .56422 L .53945 .54354 L F
.691 .588 .735 r
.54036 .5641 m .56412 .56243 L p .53954 .54571 L F P
0 g
s
.705 .599 .735 r
.53954 .54571 m .54036 .5641 L .51739 .56348 L F
.682 .695 .856 r
.5771 .56508 m .57609 .56159 L .54036 .5641 L p F P
0 g
s
.682 .695 .856 r
.54036 .5641 m .52843 .56493 L p .5771 .56508 L F P
0 g
s
.677 .692 .857 r
.56412 .56243 m .58754 .55923 L p .56636 .57265 L F P
0 g
s
.677 .692 .857 r
.58871 .56247 m .56636 .57265 L .58754 .55923 L F
.672 .689 .858 r
.61541 .56431 m .58871 .56247 L .61722 .56786 L F
.58871 .56247 m .58911 .56358 L .61722 .56786 L F
.667 .687 .859 r
.63454 .55136 m .61722 .56786 L .61541 .56431 L F
.64114 .5612 m .61722 .56786 L p .63454 .55136 L F P
0 g
s
.667 .687 .859 r
.61722 .56786 m .60526 .57118 L p .60701 .57 L F P
0 g
s
.472 .867 .969 r
.58297 .57504 m .60141 .57118 L .58011 .57545 L F
.677 .692 .857 r
.60494 .57043 m .60526 .57118 L .59249 .57291 L p F P
0 g
s
.672 .689 .858 r
.59231 .57241 m .57989 .57468 L .59249 .57291 L F
.677 .692 .857 r
.59249 .57291 m .56717 .57634 L p .58911 .56358 L F P
0 g
s
.672 .689 .858 r
.59249 .57291 m .61722 .56786 L p .59231 .57241 L F P
0 g
s
.672 .689 .858 r
.61722 .56786 m .58911 .56358 L .59231 .57241 L F
.677 .692 .857 r
.58871 .56247 m .56717 .57634 L .56636 .57265 L F
.58911 .56358 m .56717 .57634 L .58871 .56247 L F
.384 .815 .963 r
.58031 .5756 m .55436 .57729 L .55068 .57756 L F
.677 .692 .857 r
.56717 .57634 m .55448 .57806 L p .55653 .57713 L F P
0 g
s
.348 .788 .963 r
.55448 .57806 m .55177 .57823 L .54153 .57824 L F
.682 .695 .856 r
.56713 .57615 m .52859 .57825 L .56717 .57634 L F
.54149 .57813 m .56717 .57634 L p .52859 .57825 L F P
0 g
s
.691 .702 .856 r
.52678 .57825 m .51633 .56685 L .51594 .57363 L F
.5286 .57902 m .52782 .57825 L .52678 .57825 L F
.52782 .57825 m .51633 .56685 L .52678 .57825 L F
.695 .707 .857 r
.49476 .56569 m .46579 .5699 L .46918 .55982 L F
.691 .702 .856 r
.5286 .57902 m .49251 .56365 L .49204 .56608 L F
.348 .788 .963 r
.51568 .57826 m .54149 .57813 L p .54153 .57824 L F P
0 g
s
.384 .815 .963 r
.55068 .57756 m .54149 .57813 L .54151 .57817 L F
.53139 .57899 m .55068 .57756 L .5286 .57902 L F
.348 .788 .963 r
.54149 .57813 m .55448 .57806 L p .54153 .57824 L F P
0 g
s
.384 .815 .963 r
.54149 .57813 m .5286 .57902 L p .54151 .57817 L F P
0 g
s
.384 .815 .963 r
.55436 .57729 m .54149 .57813 L .55068 .57756 L F
.56717 .57634 m .54149 .57813 L p .55436 .57729 L F P
0 g
s
.677 .692 .857 r
.55653 .57713 m .55448 .57806 L .55498 .57724 L F
.426 .841 .966 r
.56728 .57645 m .55458 .57823 L .56717 .57634 L F
.384 .815 .963 r
.58387 .57831 m .58031 .5756 L p .56729 .57646 L F P
0 g
s
.384 .815 .963 r
.58387 .57831 m .56729 .57646 L .56876 .57797 L F
.677 .692 .857 r
.55448 .57806 m .55436 .57729 L p .55498 .57724 L F P
0 g
s
.682 .695 .856 r
.56717 .57634 m .58011 .57545 L p .56973 .57601 L F P
0 g
s
.426 .841 .966 r
.55458 .57823 m .55448 .57806 L .56717 .57634 L p F P
0 g
s
.426 .841 .966 r
.56717 .57634 m .59249 .57291 L p .57989 .57468 L F P
0 g
s
.686 .699 .856 r
.54149 .57813 m .51568 .57826 L p .54063 .56741 L F P
0 g
s
.686 .699 .856 r
.54063 .56741 m .51568 .57826 L .51589 .57453 L F
.691 .702 .856 r
.48997 .57673 m .51568 .57826 L p .49008 .57615 L F P
0 g
s
.691 .702 .856 r
.51569 .57806 m .49008 .57615 L .51568 .57826 L F
.695 .707 .857 r
.48997 .57673 m .46457 .57355 L p .49007 .57621 L F P
0 g
s
.282 .698 .971 r
.43971 .56874 m .43949 .56882 L .42757 .56558 L F
.286 .717 .968 r
.43971 .56874 m .42716 .56631 L p .44846 .57051 L F P
0 g
s
.286 .717 .968 r
.47682 .57611 m .45206 .57119 L .44846 .57051 L F
.45206 .57119 m .43971 .56874 L .44846 .57051 L F
.695 .707 .857 r
.46457 .57355 m .45176 .57194 L p .46205 .57307 L F P
0 g
s
.695 .707 .857 r
.46463 .57336 m .46457 .57355 L .46205 .57307 L F
.699 .711 .858 r
.43971 .56874 m .46457 .57355 L p .42757 .56558 L F P
0 g
s
.699 .711 .858 r
.46463 .57336 m .42757 .56558 L .46457 .57355 L F
.706 .721 .861 r
.41784 .55888 m .40097 .544 L .40026 .54487 L F
.42716 .56631 m .41805 .55855 L .41784 .55888 L F
.41805 .55855 m .40097 .544 L .41784 .55888 L F
.703 .716 .859 r
.43971 .56874 m .41563 .56233 L p .44467 .5585 L F P
0 g
s
.285 .681 .972 r
.39255 .55436 m .38085 .55032 L p .40059 .55724 L F P
0 g
s
.285 .681 .972 r
.42678 .56643 m .40396 .55838 L .40059 .55724 L F
.40396 .55838 m .39255 .55436 L .40059 .55724 L F
.703 .716 .859 r
.41563 .56233 m .40345 .55909 L p .40593 .55905 L F P
0 g
s
.703 .716 .859 r
.41784 .55888 m .41563 .56233 L .40593 .55905 L F
.44467 .5585 m .41563 .56233 L .41784 .55888 L F
.282 .698 .971 r
.41563 .56233 m .43971 .56874 L p .42757 .56558 L F P
0 g
s
.695 .707 .857 r
.45418 .57159 m .46205 .57307 L .45176 .57194 L F
.286 .717 .968 r
.47682 .57611 m .47701 .57595 L .46457 .57355 L p F P
0 g
s
.286 .717 .968 r
.46457 .57355 m .43971 .56874 L p .45206 .57119 L F P
0 g
s
.286 .717 .968 r
.42952 .56695 m .44846 .57051 L .42716 .56631 L F
.282 .698 .971 r
.43971 .56874 m .45176 .57194 L p .43949 .56882 L F P
0 g
s
.286 .717 .968 r
.43826 .56931 m .43949 .56882 L .42952 .56695 L F
.47356 .57885 m .46216 .57507 L .46138 .57556 L F
.299 .739 .965 r
.46069 .576 m .45767 .57583 L .46071 .57598 L F
.46138 .57556 m .44652 .57457 L .46169 .57536 L F
.286 .717 .968 r
.47356 .57885 m .47682 .57611 L p .46439 .57366 L F P
0 g
s
.286 .717 .968 r
.47356 .57885 m .46439 .57366 L .46216 .57507 L F
.695 .707 .857 r
.45418 .57159 m .45176 .57194 L .45267 .57131 L F
.699 .711 .858 r
.46918 .55982 m .4462 .55534 L p .46619 .56871 L F P
0 g
s
.699 .711 .858 r
.46579 .5699 m .44467 .5585 L .46463 .57336 L F
.44467 .5585 m .44417 .55954 L .46463 .57336 L F
.703 .716 .859 r
.4458 .55617 m .41784 .55888 L .42239 .55179 L F
.44467 .5585 m .41784 .55888 L .4458 .55617 L F
.695 .707 .857 r
.46918 .55982 m .49268 .56279 L p .49223 .5651 L F P
0 g
s
.299 .739 .965 r
.5027 .57832 m .49987 .57813 L .48987 .57683 L F
.46457 .57355 m .48997 .57673 L p .48987 .57683 L F P
0 g
s
.319 .763 .963 r
.51568 .57826 m .48997 .57673 L p .48987 .57683 L F P
0 g
s
.299 .739 .965 r
.48997 .57673 m .5027 .57832 L p .48987 .57683 L F P
0 g
s
.319 .763 .963 r
.47964 .57627 m .48987 .57683 L .47701 .57595 L F
.48997 .57673 m .47701 .57595 L p .48987 .57683 L F P
0 g
s
.691 .702 .856 r
.47722 .57519 m .47701 .57595 L .48997 .57673 L p F P
0 g
s
.695 .707 .857 r
.45176 .57194 m .45206 .57119 L p .45267 .57131 L F P
0 g
s
.703 .716 .859 r
.45206 .57119 m .45176 .57194 L .43971 .56874 L p F P
0 g
s
.699 .711 .858 r
.46463 .57336 m .44417 .55954 L .43998 .56818 L F
.285 .681 .972 r
.41563 .56233 m .39255 .55436 L p .40396 .55838 L F P
0 g
s
.703 .716 .859 r
.40593 .55905 m .40345 .55909 L .40466 .55862 L F
.40345 .55909 m .40396 .55838 L p .40466 .55862 L F P
0 g
s
.285 .681 .972 r
.39302 .55468 m .40059 .55724 L .39242 .55438 L F
.706 .721 .861 r
.39255 .55436 m .41563 .56233 L p .40026 .54487 L F P
0 g
s
.706 .721 .861 r
.41784 .55888 m .40026 .54487 L .41563 .56233 L F
.747 .636 .738 r
.4462 .55534 m .46918 .55982 L p .45779 .55721 L F P
0 g
s
.747 .636 .738 r
.45779 .55721 m .43493 .55197 L .4462 .55534 L F
.76 .65 .741 r
.43275 .52357 m .45307 .52911 L p .42631 .54245 L F P
0 g
s
.76 .65 .741 r
.45146 .53526 m .42631 .54245 L .45307 .52911 L F
.42631 .54245 m .4127 .54634 L .43275 .52357 L F
.42395 .54936 m .4127 .54634 L p .42403 .54912 L F P
0 g
s
.76 .65 .741 r
.42631 .54245 m .42403 .54912 L .4127 .54634 L F
.786 .681 .748 r
.41312 .54526 m .40265 .54194 L .39276 .53718 L F
.773 .665 .744 r
.40265 .54194 m .42395 .54936 L p .41082 .52259 L F P
0 g
s
.773 .665 .744 r
.42631 .54245 m .41082 .52259 L .42395 .54936 L F
.42631 .54245 m .41332 .51668 L .41082 .52259 L F
.42707 .54021 m .41332 .51668 L .42631 .54245 L F
.76 .65 .741 r
.44639 .5546 m .42395 .54936 L .42403 .54912 L F
.45146 .53526 m .44639 .5546 L .42403 .54912 L F
.45146 .53526 m .42403 .54912 L .42631 .54245 L F
.771 .626 .699 r
.43275 .52357 m .42248 .52076 L p .4352 .51418 L F P
0 g
s
.773 .665 .744 r
.43275 .52357 m .41332 .51668 L p .42707 .54021 L F P
0 g
s
.812 .716 .759 r
.38568 .50436 m .37229 .52864 L .36372 .52295 L p F P
0 g
s
.812 .716 .759 r
.38568 .50436 m .36372 .52295 L .37458 .50467 L F
.799 .698 .753 r
.36924 .49432 m .35419 .51779 L .36372 .52295 L p F P
0 g
s
.799 .698 .753 r
.36372 .52295 m .3825 .53311 L p .38214 .53206 L F P
0 g
s
.799 .698 .753 r
.37344 .50659 m .36924 .49432 L .36372 .52295 L F
.3779 .49909 m .36924 .49432 L p .37458 .50467 L F P
0 g
s
.799 .698 .753 r
.38584 .52651 m .36924 .49432 L .3825 .53311 L F
.824 .735 .767 r
.35419 .51779 m .36924 .49432 L .36229 .48852 L p F P
0 g
s
.812 .716 .759 r
.33778 .50572 m .35437 .48316 L .36229 .48852 L p F P
0 g
s
.812 .716 .759 r
.35212 .50335 m .33778 .50572 L .36229 .48852 L F
.824 .735 .767 r
.35419 .51779 m .36229 .48852 L .35075 .50535 L F
.812 .716 .759 r
.37458 .50467 m .35075 .50535 L .3779 .49909 L F
.35075 .50535 m .33778 .50572 L .35212 .50335 L F
.35075 .50535 m .35212 .50335 L .3779 .49909 L F
.824 .735 .767 r
.34652 .51152 m .35419 .51779 L p .35075 .50535 L F P
0 g
s
.812 .716 .759 r
.37458 .50467 m .36412 .52227 L .33778 .50572 L F
.36372 .52295 m .34652 .51152 L p .36412 .52227 L F P
0 g
s
.812 .716 .759 r
.34652 .51152 m .33778 .50572 L p .36412 .52227 L F P
0 g
s
.349 .628 .957 r
.31743 .52071 m .30977 .50745 L .30129 .50639 L F
.29925 .50614 m .31743 .52071 L p .29317 .4992 L F P
0 g
s
.372 .618 .947 r
.31103 .50761 m .28329 .49028 L .2877 .49109 L F
.349 .628 .957 r
.32116 .52096 m .31103 .50761 L .31743 .52071 L F
.395 .61 .936 r
.2698 .47328 m .28329 .49028 L p .2819 .47617 L F P
0 g
s
.419 .603 .923 r
.28335 .47652 m .25897 .45528 L .26392 .45674 L F
.395 .61 .936 r
.2877 .49109 m .28335 .47652 L .28329 .49028 L F
.442 .598 .91 r
.25103 .43644 m .25897 .45528 L p .26428 .44116 L F P
0 g
s
.464 .594 .897 r
.26586 .44172 m .24613 .41695 L .25143 .41917 L F
.442 .598 .91 r
.26392 .45674 m .26586 .44172 L .25897 .45528 L F
.486 .591 .884 r
.24445 .39702 m .24613 .41695 L p .2583 .40378 L F P
0 g
s
.486 .591 .884 r
.25143 .41917 m .25995 .40458 L .24613 .41695 L F
.711 .78 .906 r
.26625 .3902 m .27221 .38838 L .2668 .38835 L F
.26547 .39595 m .27221 .38838 L .26625 .3902 L F
.506 .589 .872 r
.26415 .40568 m .25151 .37992 L .26577 .38794 L F
.26526 .39749 m .26577 .38794 L .2665 .38835 L F
.26415 .40568 m .26577 .38794 L .26526 .39749 L F
.486 .591 .884 r
.25995 .40458 m .2583 .40378 L .24613 .41695 L F
.464 .594 .897 r
.26957 .44215 m .25315 .4199 L .2654 .42504 L F
.26795 .43426 m .2654 .42504 L .26612 .42534 L F
.26957 .44215 m .2654 .42504 L .26795 .43426 L F
.442 .598 .91 r
.26586 .44172 m .26428 .44116 L .25897 .45528 L F
.419 .603 .923 r
.28642 .47647 m .26554 .45722 L .277 .46062 L F
.28232 .46913 m .277 .46062 L .27767 .46082 L F
.28642 .47647 m .277 .46062 L .28232 .46913 L F
.395 .61 .936 r
.28335 .47652 m .2819 .47617 L .28329 .49028 L F
.372 .618 .947 r
.31338 .5072 m .28914 .49135 L .29938 .49322 L F
.30709 .50069 m .29938 .49322 L .29998 .49332 L F
.31338 .5072 m .29938 .49322 L .30709 .50069 L F
.349 .628 .957 r
.31103 .50761 m .30977 .50745 L .31743 .52071 L F
0 .376 .819 r
.30822 .51643 m .31618 .52013 L .29703 .50447 L F
.30746 .51608 m .29703 .50447 L .29193 .50064 L F
0 .349 .772 r
.33472 .53261 m .30746 .51608 L .33762 .5339 L F
.30746 .51608 m .30863 .51662 L .33762 .5339 L F
0 .376 .819 r
.31358 .52216 m .30822 .51643 L .30746 .51608 L F
.30822 .51643 m .29703 .50447 L .30746 .51608 L F
.2957 .50439 m .29449 .5038 L .30391 .51442 L F
0 .349 .772 r
.30746 .51608 m .29291 .50725 L .30863 .51662 L F
.31743 .52071 m .33762 .5339 L p .30863 .51662 L F P
0 g
s
0 .376 .819 r
.31743 .52071 m .28998 .49871 L p .32487 .52723 L F P
0 g
s
0 .349 .772 r
.29291 .50725 m .30716 .514 L .31743 .52071 L p F P
0 g
s
0 .349 .772 r
.30863 .51662 m .29291 .50725 L .31743 .52071 L F
0 .376 .819 r
.31358 .52216 m .32487 .52723 L p .31618 .52013 L F P
0 g
s
0 .376 .819 r
.31358 .52216 m .31618 .52013 L .30822 .51643 L F
.29193 .50064 m .29703 .50447 L .28998 .49871 L F
.327 .639 .965 r
.3407 .52781 m .32462 .52119 L .33104 .52162 L F
.34882 .53327 m .32238 .52104 L .3407 .52781 L F
.32238 .52104 m .32462 .52119 L .3407 .52781 L F
.714 .736 .868 r
.34371 .51342 m .32341 .51527 L .33382 .50815 L F
.32289 .51486 m .33382 .50815 L p .32341 .51527 L F P
0 g
s
.349 .628 .957 r
.32116 .52096 m .33104 .52162 L .31501 .50868 L F
.33104 .52162 m .33155 .52165 L .32289 .51486 L F
.33104 .52162 m .32289 .51486 L .31501 .50868 L F
.716 .741 .872 r
.32325 .49252 m .30709 .50069 L p .31539 .50769 L F P
0 g
s
.718 .747 .875 r
.33778 .50572 m .32289 .51486 L p .31539 .50769 L F P
0 g
s
.718 .747 .875 r
.33778 .50572 m .31539 .50769 L .32723 .50108 L F
.714 .736 .868 r
.32564 .51635 m .32202 .5154 L .32427 .51519 L F
.32564 .51635 m .32427 .51519 L .34371 .51342 L F
.33553 .51895 m .32564 .51635 L .34371 .51342 L F
.716 .741 .872 r
.33339 .52289 m .33553 .51895 L .33175 .52151 L F
.327 .639 .965 r
.3407 .52781 m .32121 .51532 L .33155 .52165 L F
.716 .741 .872 r
.33992 .5284 m .33916 .52677 L .33339 .52289 L F
.33916 .52677 m .33553 .51895 L .33339 .52289 L F
.327 .639 .965 r
.32121 .51532 m .32202 .5154 L .33155 .52165 L p F P
0 g
s
.716 .741 .872 r
.35419 .51779 m .34652 .51152 L p .34026 .52751 L F P
0 g
s
.716 .741 .872 r
.3407 .52781 m .35419 .51779 L p .34026 .52751 L F P
0 g
s
.714 .736 .868 r
.33382 .50815 m .33778 .50572 L .34652 .51152 L p F P
0 g
s
.714 .736 .868 r
.34403 .5132 m .33382 .50815 L .34652 .51152 L F
.716 .741 .872 r
.33992 .5284 m .34652 .51152 L .33553 .51895 L F
.714 .736 .868 r
.36372 .52295 m .37229 .52864 L p .36289 .52363 L F P
0 g
s
.712 .731 .865 r
.35916 .52385 m .36149 .52477 L .35419 .51779 L F
.36372 .52295 m .35419 .51779 L p .36149 .52477 L F P
0 g
s
.712 .731 .865 r
.35419 .51779 m .3407 .52781 L p .35028 .53395 L F P
0 g
s
.712 .731 .865 r
.36055 .52554 m .35419 .51779 L .35028 .53395 L F
.714 .736 .868 r
.36289 .52363 m .33382 .50815 L .36372 .52295 L F
.36289 .52363 m .33553 .51895 L .34371 .51342 L F
.37229 .52864 m .36055 .52554 L .36289 .52363 L F
.712 .731 .865 r
.36055 .52554 m .36149 .52477 L .35916 .52385 L F
.714 .736 .868 r
.36055 .52554 m .33553 .51895 L .36289 .52363 L F
.712 .731 .865 r
.37383 .54175 m .3825 .53311 L .36149 .52477 L F
.37383 .54175 m .36149 .52477 L .36055 .52554 L F
.3825 .53311 m .36372 .52295 L p .36149 .52477 L F P
0 g
s
.716 .741 .872 r
.32597 .50178 m .32325 .49252 L .31539 .50769 L F
.714 .736 .868 r
.33553 .51895 m .33175 .52151 L .32202 .5154 L F
.716 .741 .872 r
.33553 .51895 m .32325 .49252 L .33175 .52151 L F
.718 .747 .875 r
.3108 .4783 m .31764 .48525 L p .29436 .48645 L F P
0 g
s
.718 .747 .875 r
.33109 .49892 m .33778 .50572 L p .32723 .50108 L F P
0 g
s
.716 .741 .872 r
.32636 .49921 m .33754 .50604 L .32325 .49252 L F
.836 .756 .775 r
.35437 .48316 m .33778 .50572 L .33109 .49892 L p F P
0 g
s
.716 .741 .872 r
.34652 .51152 m .33109 .49892 L p .33754 .50604 L F P
0 g
s
.716 .741 .872 r
.33109 .49892 m .32325 .49252 L p .33754 .50604 L F P
0 g
s
.824 .735 .767 r
.34124 .47097 m .32325 .49252 L .33109 .49892 L p F P
0 g
s
.836 .756 .775 r
.35437 .48316 m .33109 .49892 L .3443 .48203 L F
.824 .735 .767 r
.33109 .49892 m .34652 .51152 L p .34291 .48381 L F P
0 g
s
.824 .735 .767 r
.34291 .48381 m .34124 .47097 L .33109 .49892 L F
.35075 .50535 m .3443 .48203 L .34652 .51152 L F
.3443 .48203 m .34124 .47097 L .34291 .48381 L F
.3443 .48203 m .34291 .48381 L .34652 .51152 L F
.836 .756 .775 r
.34833 .47688 m .35437 .48316 L p .3443 .48203 L F P
0 g
s
.824 .735 .767 r
.36229 .48852 m .34124 .47097 L p .35075 .50535 L F P
0 g
s
.887 .778 .737 r
.3362 .46427 m .34124 .47097 L p .34135 .45618 L F P
0 g
s
.847 .778 .785 r
.32325 .49252 m .34124 .47097 L .3362 .46427 L p F P
0 g
s
.836 .756 .775 r
.3108 .4783 m .33003 .45786 L .3362 .46427 L p F P
0 g
s
.836 .756 .775 r
.32424 .47779 m .3108 .4783 L .3362 .46427 L F
.847 .778 .785 r
.32325 .49252 m .3362 .46427 L .32263 .47962 L F
.836 .756 .775 r
.3443 .48203 m .32263 .47962 L .34833 .47688 L F
.32263 .47962 m .3108 .4783 L .32424 .47779 L F
.32263 .47962 m .32424 .47779 L .34833 .47688 L F
.847 .778 .785 r
.31764 .48525 m .32325 .49252 L p .32263 .47962 L F P
0 g
s
.836 .756 .775 r
.3443 .48203 m .33109 .49892 L .31258 .4785 L F
.31258 .4785 m .32465 .49181 L .3108 .4783 L F
.33109 .49892 m .31764 .48525 L p .32465 .49181 L F P
0 g
s
.836 .756 .775 r
.31764 .48525 m .3108 .4783 L p .32465 .49181 L F P
0 g
s
.718 .752 .879 r
.30614 .50116 m .32325 .49252 L .31764 .48525 L p F P
0 g
s
.718 .747 .875 r
.29349 .4854 m .3108 .4783 L p .29436 .48645 L F P
0 g
s
.857 .802 .796 r
.33003 .45786 m .3108 .4783 L .30635 .47063 L p F P
0 g
s
.847 .778 .785 r
.32091 .44395 m .30061 .46319 L .30635 .47063 L p F P
0 g
s
.857 .802 .796 r
.33003 .45786 m .30635 .47063 L .32146 .45543 L F
.847 .778 .785 r
.30635 .47063 m .31764 .48525 L p .31987 .45703 L F P
0 g
s
.847 .778 .785 r
.31987 .45703 m .32091 .44395 L .30635 .47063 L F
.32263 .47962 m .32146 .45543 L .31764 .48525 L F
.32146 .45543 m .32091 .44395 L .31987 .45703 L F
.32146 .45543 m .31987 .45703 L .31764 .48525 L F
.857 .802 .796 r
.32606 .4508 m .33003 .45786 L p .32146 .45543 L F P
0 g
s
.847 .778 .785 r
.3362 .46427 m .32091 .44395 L p .32263 .47962 L F P
0 g
s
.917 .842 .755 r
.31808 .4366 m .32091 .44395 L p .3238 .42915 L F P
0 g
s
.866 .828 .808 r
.30061 .46319 m .32091 .44395 L .31808 .4366 L p F P
0 g
s
.857 .802 .796 r
.29285 .44733 m .31401 .42937 L .31808 .4366 L p F P
0 g
s
.857 .802 .796 r
.30476 .44857 m .29285 .44733 L .31808 .4366 L F
.866 .828 .808 r
.30061 .46319 m .31808 .4366 L .30296 .45019 L F
.857 .802 .796 r
.32146 .45543 m .30296 .45019 L .32606 .4508 L F
.30296 .45019 m .29285 .44733 L .30476 .44857 L F
.30296 .45019 m .30476 .44857 L .32606 .4508 L F
.866 .828 .808 r
.29741 .45519 m .30061 .46319 L p .30296 .45019 L F P
0 g
s
.857 .802 .796 r
.32146 .45543 m .30691 .47007 L .29437 .44776 L F
.30691 .47007 m .30635 .47063 L .30218 .46267 L F
.30691 .47007 m .30218 .46267 L .29437 .44776 L F
.718 .763 .887 r
.28124 .46948 m .30061 .46319 L .29741 .45519 L p F P
0 g
s
.857 .802 .796 r
.30635 .47063 m .29285 .44733 L p .29437 .44776 L F P
0 g
s
.719 .757 .883 r
.29285 .44733 m .29741 .45519 L p .27394 .45246 L F P
0 g
s
.719 .757 .883 r
.27375 .45203 m .29285 .44733 L p .27394 .45246 L F P
0 g
s
.716 .772 .896 r
.28555 .3969 m .26526 .39749 L p .26565 .40687 L F P
0 g
s
.716 .772 .896 r
.26649 .42714 m .26777 .42511 L .26641 .4253 L F
.506 .589 .872 r
.25995 .40458 m .25151 .37992 L .26476 .40693 L F
.486 .591 .884 r
.25143 .41917 m .2654 .42504 L .26319 .39903 L F
.2654 .42504 m .26612 .42534 L .26508 .41602 L F
.2654 .42504 m .26508 .41602 L .26319 .39903 L F
.716 .772 .896 r
.27985 .40594 m .28555 .3969 L .26565 .40687 L F
.714 .776 .901 r
.2852 .414 m .26508 .41602 L p .26565 .40687 L F P
0 g
s
.714 .776 .901 r
.2852 .414 m .26565 .40687 L .28108 .40586 L F
.718 .767 .892 r
.27173 .42457 m .26612 .42534 L .26526 .4176 L F
.2639 .41613 m .2852 .414 L .28714 .42247 L p F P
0 g
s
.718 .767 .892 r
.29095 .43908 m .29285 .44733 L p .28613 .44009 L F P
0 g
s
.716 .772 .896 r
.26764 .43276 m .27173 .42457 L .26649 .42714 L F
.27173 .42457 m .26789 .4251 L .26649 .42714 L F
.718 .767 .892 r
.27173 .42457 m .2639 .41613 L .28714 .42247 L F
.716 .772 .896 r
.28108 .40586 m .27985 .40594 L .26649 .42714 L F
.718 .767 .892 r
.29285 .44733 m .27375 .45203 L p .27123 .44321 L F P
0 g
s
.718 .767 .892 r
.29285 .44733 m .27123 .44321 L .28447 .44044 L F
.718 .763 .887 r
.28767 .43087 m .26795 .43426 L p .27132 .44319 L F P
0 g
s
.718 .763 .887 r
.28496 .44034 m .28767 .43087 L .27132 .44319 L F
.28613 .44009 m .28767 .43087 L .28496 .44034 L F
.714 .776 .901 r
.26508 .41602 m .26476 .40693 L .26565 .40687 L F
.716 .772 .896 r
.26476 .40693 m .26679 .43446 L p .26565 .40687 L F P
0 g
s
.716 .772 .896 r
.26565 .40687 m .26526 .39749 L .26476 .40693 L F
.526 .589 .86 r
.25151 .37992 m .26577 .38794 L .27068 .36935 L F
.26577 .38794 m .2665 .38835 L .26858 .37891 L F
.26577 .38794 m .26858 .37891 L .27068 .36935 L F
.707 .783 .911 r
.2888 .37977 m .26858 .37891 L p .27229 .36989 L F P
0 g
s
.711 .78 .906 r
.2722 .36989 m .27509 .3605 L .27141 .36982 L F
.27229 .36989 m .27509 .3605 L .2722 .36989 L F
.562 .591 .841 r
.26499 .34082 m .27882 .35107 L .28995 .33315 L F
.27882 .35107 m .27953 .35159 L .2848 .34251 L F
.693 .788 .924 r
.3161 .33039 m .3241 .32321 L p .29896 .32381 L F P
0 g
s
.693 .788 .924 r
.29896 .32381 m .3241 .32321 L .31031 .31867 L F
.29769 .32519 m .3161 .33039 L p .29896 .32381 L F P
0 g
s
.703 .785 .915 r
.3161 .33039 m .29769 .32519 L p .29166 .3341 L F P
0 g
s
.698 .787 .92 r
.30409 .34629 m .2848 .34251 L p .29166 .3341 L F P
0 g
s
.698 .787 .92 r
.30409 .34629 m .29166 .3341 L .30454 .33716 L F
.703 .785 .915 r
.30607 .33752 m .3161 .33039 L .29166 .3341 L F
.698 .787 .92 r
.31031 .31867 m .30553 .31709 L .30695 .31536 L F
.687 .789 .928 r
.33091 .31536 m .31364 .30878 L p .32345 .30148 L F P
0 g
s
.693 .788 .924 r
.34838 .30143 m .33254 .29355 L p .32345 .30148 L F P
0 g
s
.693 .788 .924 r
.3361 .30699 m .34838 .30143 L .32345 .30148 L F
.687 .789 .928 r
.34725 .289 m .34323 .28674 L .34525 .28523 L F
.637 .612 .808 r
.37827 .26759 m .38279 .24551 L .39074 .26152 L F
.36591 .2736 m .36669 .2723 L .37827 .26759 L F
.36669 .2723 m .38279 .24551 L .37827 .26759 L F
.65 .947 .955 r
.42261 .25575 m .40752 .26425 L p .42346 .25579 L F P
0 g
s
.65 .947 .955 r
.39999 .26851 m .4008 .26823 L .40095 .26815 L F
.4008 .26823 m .43576 .25641 L .40095 .26815 L F
.40095 .26815 m .43576 .25641 L .43279 .25626 L F
.701 .956 .95 r
.38899 .27837 m .38729 .27859 L .39403 .27382 L p F P
0 g
s
.513 .854 .586 r
.35661 .30579 m .37642 .28951 L .38172 .28478 L p F P
0 g
s
.513 .854 .586 r
.38172 .28478 m .38228 .28429 L p .38029 .28596 L F P
0 g
s
.513 .854 .586 r
.35661 .30579 m .38172 .28478 L .38029 .28596 L F
.665 .938 .667 r
.3498 .30898 m .3688 .29352 L .36319 .29992 L p F P
0 g
s
.513 .854 .586 r
.35661 .30579 m .38228 .28429 L .37012 .29425 L F
.667 .94 .671 r
.38169 .28477 m .38642 .27929 L .38228 .28429 L F
0 0 0 r
.38729 .27859 m .39001 .27708 L .39382 .27398 L F
.787 .986 .731 r
.37241 .29552 m .37642 .28951 L p .37217 .29572 L F P
0 g
s
.804 .936 .917 r
.37824 .28916 m .37642 .28951 L .37241 .29552 L p F P
0 g
s
.701 .956 .95 r
.40475 .27637 m .38899 .27837 L p .39403 .27382 L F P
0 g
s
.701 .956 .95 r
.40475 .27637 m .39403 .27382 L .40559 .27269 L F
.744 .956 .942 r
.41592 .26755 m .40153 .26841 L p .39524 .2737 L F P
0 g
s
.701 .956 .95 r
.40475 .27637 m .40559 .27269 L .40691 .27256 L F
.778 .949 .931 r
.38729 .27859 m .40356 .27652 L p .3994 .28151 L F P
0 g
s
.822 .919 .902 r
.3645 .30735 m .36748 .30112 L p .37004 .30576 L F P
0 g
s
.804 .936 .917 r
.39515 .28594 m .37824 .28916 L p .3738 .2952 L F P
0 g
s
.778 .949 .931 r
.38723 .29612 m .36748 .30112 L .37241 .29552 L p F P
0 g
s
.778 .949 .931 r
.38723 .29612 m .37241 .29552 L .38724 .29218 L F
.804 .936 .917 r
.36499 .30721 m .38586 .29249 L .3738 .2952 L F
.38586 .29249 m .39515 .28594 L .3738 .2952 L F
.744 .956 .942 r
.37642 .28951 m .38727 .28348 L .38272 .28421 L F
.778 .949 .931 r
.38228 .28429 m .38729 .27859 L p .38727 .28348 L F P
0 g
s
.778 .949 .931 r
.39053 .28295 m .38729 .27859 L .3994 .28151 L F
.804 .936 .917 r
.37004 .30576 m .39515 .28594 L .36499 .30721 L F
.778 .949 .931 r
.39116 .29094 m .38729 .27859 L .39414 .28782 L F
.38724 .29218 m .38729 .27859 L .39126 .29128 L F
.744 .956 .942 r
.39403 .27382 m .38228 .28429 L p .40153 .26841 L F P
0 g
s
.744 .956 .942 r
.38228 .28429 m .37642 .28951 L p .38272 .28421 L F P
0 g
s
.744 .956 .942 r
.38272 .28421 m .40153 .26841 L .38228 .28429 L F
.804 .936 .917 r
.37241 .29552 m .3645 .30735 L p .37824 .28916 L F P
0 g
s
.804 .936 .917 r
.36499 .30721 m .37824 .28916 L .3645 .30735 L F
.778 .949 .931 r
.37241 .29552 m .38228 .28429 L p .38724 .29218 L F P
0 g
s
.778 .949 .931 r
.38724 .29218 m .38228 .28429 L .38727 .28348 L F
.39414 .28782 m .39053 .28295 L .3994 .28151 L F
.744 .956 .942 r
.38272 .28421 m .40691 .27256 L .39524 .2737 L F
.38727 .28348 m .40691 .27256 L .38272 .28421 L F
.40691 .27256 m .41592 .26755 L .39524 .2737 L F
.701 .956 .95 r
.40691 .27256 m .40752 .26425 L .41168 .26414 L F
.40559 .27269 m .40752 .26425 L .40691 .27256 L F
.39403 .27382 m .40752 .26425 L p .40559 .27269 L F P
0 g
s
0 0 0 r
.40752 .26425 m .39403 .27382 L p .40703 .26466 L F P
0 g
s
0 0 0 r
.39403 .27382 m .38729 .27859 L p .39251 .27491 L F P
0 g
s
.667 .94 .671 r
.37217 .29572 m .38161 .28484 L .37241 .29552 L F
.38161 .28484 m .38642 .27929 L .38169 .28477 L F
.38161 .28484 m .38169 .28477 L .37241 .29552 L F
.513 .854 .586 r
.35661 .30579 m .37012 .29425 L .36844 .29562 L F
.787 .986 .731 r
.37642 .28951 m .35661 .30579 L .35214 .31253 L p F P
0 g
s
.866 .995 .765 r
.34663 .31881 m .3665 .30195 L p .364 .30745 L F P
0 g
s
.866 .995 .765 r
.36375 .308 m .36247 .30881 L .364 .30745 L F
.36247 .30881 m .34663 .31881 L .364 .30745 L F
.785 .985 .728 r
.31684 .3521 m .33895 .33239 L .34334 .32579 L p F P
0 g
s
.665 .938 .667 r
.35214 .31253 m .34663 .31881 L p .34734 .31661 L F P
0 g
s
.665 .938 .667 r
.34734 .31661 m .34735 .31657 L .35214 .31253 L F
.785 .985 .728 r
.35214 .31253 m .35661 .30579 L p .34735 .31657 L F P
0 g
s
.865 .995 .763 r
.32526 .33705 m .34663 .31881 L .34334 .32579 L p F P
0 g
s
.865 .995 .763 r
.32756 .33962 m .32526 .33705 L .34334 .32579 L F
.785 .985 .728 r
.32166 .34479 m .31684 .3521 L p .32756 .33962 L F P
0 g
s
.785 .985 .728 r
.31684 .3521 m .34334 .32579 L .32694 .34034 L F
.865 .995 .763 r
.33362 .34636 m .31107 .36754 L .31458 .35999 L p F P
0 g
s
.865 .995 .763 r
.33362 .34636 m .31458 .35999 L .32994 .34588 L F
.785 .985 .728 r
.32694 .34034 m .34334 .32579 L .32773 .33947 L F
.665 .938 .667 r
.34663 .31881 m .32526 .33705 L .33135 .33009 L p F P
0 g
s
.785 .985 .728 r
.35661 .30579 m .33628 .32261 L .33135 .33009 L p F P
0 g
s
.785 .985 .728 r
.34569 .31797 m .35661 .30579 L .33135 .33009 L F
.665 .938 .667 r
.34663 .31881 m .33135 .33009 L .34735 .31657 L F
.865 .995 .763 r
.32166 .34479 m .32526 .33705 L p .32756 .33962 L F P
0 g
s
.785 .985 .728 r
.32756 .33962 m .35661 .30579 L .32166 .34479 L F
.509 .851 .581 r
.33628 .32261 m .35661 .30579 L .36319 .29992 L p F P
0 g
s
.509 .851 .581 r
.33628 .32261 m .36319 .29992 L .34893 .31169 L F
.665 .938 .667 r
.34735 .31657 m .34893 .31169 L .35214 .31253 L F
.34893 .31169 m .34898 .31153 L .34908 .31156 L F
.34893 .31169 m .34908 .31156 L .35214 .31253 L F
.34358 .3161 m .3498 .30898 L p .34893 .31169 L F P
0 g
s
.667 .94 .671 r
.3688 .29352 m .38642 .27929 L p .38205 .28433 L F P
0 g
s
.787 .986 .731 r
.36843 .29866 m .37642 .28951 L .35214 .31253 L F
.667 .94 .671 r
.37217 .29572 m .37 .29429 L .38205 .28433 L F
.37 .29429 m .3688 .29352 L .38205 .28433 L F
.665 .938 .667 r
.34898 .31153 m .3498 .30898 L .36319 .29992 L F
.667 .94 .671 r
.37109 .29662 m .36963 .29464 L .37217 .29572 L F
.36963 .29464 m .3688 .29352 L .37003 .29432 L F
.36963 .29464 m .37003 .29432 L .37217 .29572 L F
.36753 .30082 m .36778 .2994 L .37123 .2968 L F
.787 .986 .731 r
.36778 .2994 m .36843 .29866 L .35214 .31253 L F
.667 .94 .671 r
.36778 .2994 m .3688 .29352 L .37109 .29662 L F
.36778 .2994 m .37109 .29662 L .37123 .2968 L F
.866 .995 .765 r
.34914 .32073 m .34663 .31881 L .36375 .308 L F
.787 .986 .731 r
.34334 .32579 m .33895 .33239 L p .34914 .32073 L F P
0 g
s
.91 .979 .779 r
.36056 .31325 m .33895 .33239 L .33685 .33953 L p F P
0 g
s
.866 .995 .765 r
.35569 .32574 m .33362 .34636 L .33685 .33953 L p F P
0 g
s
.866 .995 .765 r
.35569 .32574 m .33685 .33953 L .35191 .32575 L F
.93 .949 .78 r
.33362 .34636 m .35465 .32671 L p .35308 .34486 L F P
0 g
s
.91 .979 .779 r
.33685 .33953 m .33271 .35355 L p .35191 .32575 L F P
0 g
s
.91 .979 .779 r
.35191 .32575 m .36056 .31325 L .33685 .33953 L F
.866 .995 .765 r
.36375 .308 m .3665 .30195 L .3645 .30735 L F
.667 .94 .671 r
.37241 .29552 m .36748 .30112 L p .37217 .29572 L F P
0 g
s
.667 .94 .671 r
.37123 .2968 m .37109 .29662 L .37217 .29572 L F
.36748 .30112 m .36753 .30082 L .37123 .2968 L F
.513 .854 .586 r
.36319 .29992 m .35661 .30579 L p .36844 .29562 L F P
0 g
s
.667 .94 .671 r
.36748 .30112 m .34663 .31881 L .3688 .29352 L p F P
0 g
s
.787 .986 .731 r
.33895 .33239 m .35954 .31415 L p .37217 .29572 L F P
0 g
s
.787 .986 .731 r
.33895 .33239 m .37217 .29572 L .36778 .2994 L F
.866 .995 .765 r
.33685 .33953 m .34334 .32579 L p .35191 .32575 L F P
0 g
s
.866 .995 .765 r
.34334 .32579 m .34663 .31881 L p .34914 .32073 L F P
0 g
s
.866 .995 .765 r
.35569 .32574 m .35191 .32575 L .35365 .32417 L F
.91 .979 .779 r
.33877 .34769 m .35365 .32417 L .33271 .35355 L F
.35365 .32417 m .36056 .31325 L .35191 .32575 L F
.35365 .32417 m .35191 .32575 L .33271 .35355 L F
.866 .995 .765 r
.35365 .32417 m .34334 .32579 L .34914 .32073 L F
.35191 .32575 m .34334 .32579 L .35365 .32417 L F
.787 .986 .731 r
.35214 .31253 m .34334 .32579 L p .36778 .2994 L F P
0 g
s
.787 .986 .731 r
.34914 .32073 m .36778 .2994 L .34334 .32579 L F
.667 .94 .671 r
.38642 .27929 m .38729 .27859 L .38228 .28429 L p F P
0 g
s
0 0 0 r
.38729 .27859 m .3688 .29352 L .37639 .28815 L p F P
0 g
s
.513 .854 .586 r
.37639 .28815 m .36319 .29992 L p .38861 .27822 L F P
0 g
s
0 0 0 r
.38729 .27859 m .37639 .28815 L .39001 .27708 L F
.39251 .27491 m .39382 .27398 L .39403 .27382 L F
.513 .854 .586 r
.36844 .29562 m .39999 .26851 L .36319 .29992 L F
.36844 .29562 m .39403 .27382 L .39001 .27708 L F
.37012 .29425 m .39403 .27382 L .36844 .29562 L F
.38228 .28429 m .39403 .27382 L p .37012 .29425 L F P
0 g
s
.65 .947 .955 r
.43143 .25156 m .43024 .25144 L .42261 .25575 L p F P
0 g
s
.528 .905 .953 r
.44218 .24886 m .44313 .249 L .44357 .24856 L F
.591 .93 .955 r
.44053 .2541 m .45681 .24664 L .4427 .25319 L F
.528 .905 .953 r
.44313 .249 m .4502 .25001 L .44357 .24856 L F
.645 .577 .763 r
.45394 .25935 m .46049 .2757 L .47101 .26951 L F
.629 .568 .767 r
.45307 .25718 m .45749 .24678 L .46049 .2757 L F
.4502 .25001 m .45749 .24678 L p .45025 .25015 L F P
0 g
s
.629 .568 .767 r
.45749 .24678 m .46681 .27295 L .46049 .2757 L p F P
0 g
s
.528 .905 .953 r
.44357 .24856 m .4502 .25001 L .47078 .24268 L F
0 0 0 r
.42245 .25589 m .43153 .25554 L .43869 .24881 L F
.464 .875 .948 r
.45678 .24239 m .45759 .24219 L p .45692 .24242 L F P
0 g
s
.402 .84 .943 r
.46942 .23909 m .4759 .23796 L p .46572 .23934 L F P
0 g
s
.402 .84 .943 r
.47543 .23775 m .46572 .23934 L p .4759 .23796 L F P
0 g
s
.464 .875 .948 r
.45759 .24219 m .47543 .23775 L p .45692 .24242 L F P
0 g
s
.464 .875 .948 r
.46365 .24422 m .45692 .24242 L .47543 .23775 L F
.676 .595 .758 r
.47346 .2421 m .48063 .26895 L .48796 .26777 L p F P
0 g
s
.676 .595 .758 r
.47346 .2421 m .48796 .26777 L .48415 .25066 L F
.464 .875 .948 r
.46646 .24436 m .47781 .23883 L .48194 .24071 L F
.47781 .23883 m .48484 .2354 L .48194 .24071 L F
.46365 .24422 m .48484 .2354 L .46566 .24475 L F
.346 .804 .939 r
.49015 .23867 m .48536 .23572 L p .49478 .23457 L F P
0 g
s
.346 .804 .939 r
.48536 .23572 m .48484 .2354 L .49478 .23457 L p F P
0 g
s
.402 .84 .943 r
.49488 .23465 m .4968 .23432 L p .49478 .23457 L F P
0 g
s
.402 .84 .943 r
.4968 .23432 m .50454 .23297 L .49478 .23457 L p F P
0 g
s
.346 .804 .939 r
.49015 .23867 m .49478 .23457 L .49791 .23718 L F
.402 .84 .943 r
.50454 .23297 m .49629 .23582 L p .50733 .23655 L F P
0 g
s
.402 .84 .943 r
.49629 .23582 m .49104 .23764 L p .49791 .23718 L F P
0 g
s
.402 .84 .943 r
.49791 .23718 m .50733 .23655 L .49629 .23582 L F
.346 .804 .939 r
.49882 .23794 m .49015 .23867 L p .49791 .23718 L F P
0 g
s
.402 .84 .943 r
.48194 .24071 m .49882 .23794 L p .49025 .23926 L F P
0 g
s
.718 .628 .757 r
.53273 .25788 m .55079 .23764 L .54986 .24532 L F
.731 .641 .758 r
.55077 .23778 m .57613 .24207 L .55079 .23764 L F
.744 .654 .76 r
.55939 .23885 m .55948 .23826 L .56775 .2402 L p F P
0 g
s
.233 .704 .942 r
.56679 .23989 m .55939 .23885 L .56775 .2402 L F
.55079 .23764 m .56775 .2402 L p .55939 .23885 L F P
0 g
s
.718 .628 .757 r
.53273 .25788 m .54986 .24532 L .53251 .26409 L F
.54986 .24532 m .54958 .24764 L .53251 .26409 L F
.744 .654 .76 r
.56468 .26529 m .58197 .25147 L .57632 .27062 L F
.56339 .26125 m .58197 .25147 L .56213 .26733 L F
.731 .641 .758 r
.54986 .24532 m .54782 .26217 L .56949 .26843 L F
.54746 .26515 m .56213 .26733 L p .54782 .26217 L F P
0 g
s
.731 .641 .758 r
.56213 .26733 m .56949 .26843 L p .54782 .26217 L F P
0 g
s
.747 .559 .64 r
.56213 .26733 m .54746 .26515 L p .54737 .26693 L F P
0 g
s
.769 .578 .641 r
.55479 .26835 m .55498 .26568 L .56213 .26733 L p F P
0 g
s
.769 .578 .641 r
.56213 .26733 m .57632 .27062 L p .56913 .26986 L F P
0 g
s
.769 .578 .641 r
.55479 .26835 m .56213 .26733 L .56913 .26986 L F
.718 .628 .757 r
.55879 .23876 m .55893 .23878 L .53251 .26409 L F
.26 .734 .938 r
.55948 .23826 m .55079 .23764 L p .56313 .23517 L F P
0 g
s
.26 .734 .938 r
.56388 .23525 m .55948 .23826 L p .56313 .23517 L F P
0 g
s
.704 .617 .756 r
.54219 .23694 m .54224 .23634 L .53348 .23639 L p F P
0 g
s
.26 .734 .938 r
.52477 .23577 m .52721 .23572 L .53353 .23623 L F
.52477 .23577 m .53353 .23623 L .5335 .23635 L F
.298 .768 .937 r
.53348 .23639 m .54224 .23634 L p .53372 .23558 L F P
0 g
s
.26 .734 .938 r
.53348 .23639 m .52477 .23577 L p .54219 .23694 L F P
0 g
s
.731 .641 .758 r
.54224 .23634 m .54219 .23694 L p .54235 .23695 L F P
0 g
s
.26 .734 .938 r
.55079 .23764 m .53348 .23639 L p .54219 .23694 L F P
0 g
s
.731 .641 .758 r
.54224 .23634 m .54746 .26515 L .54986 .24532 L F
.233 .704 .942 r
.54224 .23634 m .55079 .23764 L p .54513 .23317 L F P
0 g
s
.233 .704 .942 r
.54458 .23273 m .54435 .23308 L p .54513 .23317 L F P
0 g
s
.233 .704 .942 r
.54435 .23308 m .54224 .23634 L p .54513 .23317 L F P
0 g
s
.26 .734 .938 r
.55237 .23613 m .56287 .23522 L .55079 .23764 L F
.233 .704 .942 r
.54458 .23273 m .55079 .23764 L .55307 .23546 L F
.731 .641 .758 r
.55079 .23764 m .54224 .23634 L p .55077 .23778 L F P
0 g
s
.731 .641 .758 r
.54224 .23634 m .54986 .24532 L .55077 .23778 L F
.233 .704 .942 r
.54458 .23273 m .55307 .23546 L .55338 .23516 L F
.298 .768 .937 r
.54224 .23634 m .54435 .23308 L p .53454 .23279 L F P
0 g
s
.346 .804 .939 r
.52477 .23577 m .51608 .2365 L p .52379 .23247 L F P
0 g
s
.346 .804 .939 r
.52455 .23207 m .52457 .23243 L p .52379 .23247 L F P
0 g
s
.346 .804 .939 r
.52457 .23243 m .52477 .23577 L p .52379 .23247 L F P
0 g
s
.346 .804 .939 r
.51513 .23422 m .52455 .23207 L .51608 .2365 L F
.298 .768 .937 r
.50733 .23655 m .51608 .2365 L p .50558 .23328 L F P
0 g
s
.298 .768 .937 r
.50454 .23297 m .50481 .23331 L p .50558 .23328 L F P
0 g
s
.298 .768 .937 r
.50481 .23331 m .50733 .23655 L p .50558 .23328 L F P
0 g
s
.298 .768 .937 r
.50454 .23297 m .51608 .2365 L .51513 .23422 L F
.346 .804 .939 r
.515 .2339 m .52455 .23207 L .51513 .23422 L F
.26 .734 .938 r
.52721 .23572 m .53371 .23563 L .53353 .23623 L F
.298 .768 .937 r
.53372 .23558 m .54224 .23634 L .53454 .23279 L F
.26 .734 .938 r
.52721 .23572 m .56435 .23493 L .56287 .23522 L F
.52477 .23577 m .52457 .23243 L p .56435 .23493 L F P
0 g
s
.26 .734 .938 r
.52457 .23243 m .52455 .23207 L .53454 .23279 L p F P
0 g
s
.26 .734 .938 r
.53454 .23279 m .56435 .23493 L p .52457 .23243 L F P
0 g
s
.298 .768 .937 r
.50454 .23297 m .50768 .23334 L .50853 .23332 L F
.50768 .23334 m .53348 .23639 L .50853 .23332 L F
.50853 .23332 m .53348 .23639 L .53372 .23558 L F
.69 .606 .757 r
.49025 .23926 m .49015 .23867 L .49882 .23794 L p F P
0 g
s
.661 .586 .76 r
.48194 .24071 m .49015 .23867 L p .48361 .24042 L F P
0 g
s
.676 .595 .758 r
.49882 .23794 m .48194 .24071 L p .50143 .25709 L F P
0 g
s
.676 .595 .758 r
.48362 .24826 m .50172 .25925 L .48194 .24071 L F
.69 .606 .757 r
.50143 .25713 m .49888 .23839 L .51609 .23665 L F
.676 .595 .758 r
.50172 .25925 m .50143 .25709 L .48194 .24071 L F
.48415 .25066 m .48796 .26777 L .4999 .26328 L F
.69 .606 .757 r
.49506 .26603 m .51609 .23665 L .51647 .24422 L F
.298 .768 .937 r
.51608 .2365 m .53348 .23639 L p .52478 .23636 L F P
0 g
s
.704 .617 .756 r
.54007 .26404 m .54219 .23694 L p .51608 .2365 L F P
0 g
s
.704 .617 .756 r
.53348 .23639 m .51608 .2365 L p .54219 .23694 L F P
0 g
s
.704 .617 .756 r
.51647 .24422 m .54007 .26404 L .51608 .2365 L F
.718 .628 .757 r
.52498 .26356 m .52478 .23636 L p .53348 .23639 L F P
0 g
s
.718 .628 .757 r
.52478 .23636 m .52477 .23577 L .53348 .23639 L p F P
0 g
s
.298 .768 .937 r
.53227 .23625 m .52478 .23636 L .53348 .23639 L F
.69 .606 .757 r
.52418 .23637 m .52477 .23577 L .52426 .23637 L F
.51647 .24422 m .51609 .23665 L .52477 .23577 L F
.49882 .23794 m .52477 .23577 L p .49025 .23926 L F P
0 g
s
.69 .606 .757 r
.51653 .24548 m .52477 .23577 L .51747 .26418 L F
.52477 .23577 m .52498 .26356 L .51747 .26418 L p F P
0 g
s
.298 .768 .937 r
.51513 .23422 m .51608 .2365 L .53227 .23625 L F
.69 .606 .757 r
.50275 .2582 m .52418 .23637 L .5045 .25967 L F
.52418 .23637 m .52426 .23637 L .5045 .25967 L F
.50275 .2582 m .5045 .25967 L .50215 .26244 L F
.50172 .25925 m .50275 .2582 L .50215 .26244 L F
.676 .595 .758 r
.50172 .25925 m .50991 .26422 L .50143 .25709 L F
.69 .606 .757 r
.49506 .26603 m .49025 .23926 L p .49888 .23839 L F P
0 g
s
.69 .606 .757 r
.49506 .26603 m .49888 .23839 L .50143 .25713 L F
.661 .586 .76 r
.48362 .24826 m .48197 .24086 L .49015 .23867 L F
.49015 .23867 m .49506 .26603 L .48796 .26777 L p F P
0 g
s
.661 .586 .76 r
.48362 .24826 m .49015 .23867 L .48796 .26777 L F
.402 .84 .943 r
.47723 .23857 m .48194 .24071 L .50476 .23672 L F
.346 .804 .939 r
.50352 .23611 m .515 .2339 L .50328 .23683 L F
.402 .84 .943 r
.50476 .23672 m .49025 .23926 L .50733 .23655 L F
.49882 .23794 m .50733 .23655 L p .49025 .23926 L F P
0 g
s
.346 .804 .939 r
.50352 .23611 m .50328 .23683 L .49882 .23794 L F
.49791 .23718 m .50352 .23611 L .49882 .23794 L F
.515 .2339 m .51513 .23422 L .49882 .23794 L F
.298 .768 .937 r
.52882 .23489 m .53372 .23558 L .53435 .23344 L F
.52882 .23489 m .53435 .23344 L .53454 .23279 L F
.53454 .23279 m .51458 .23291 L p .52882 .23489 L F P
0 g
s
.298 .768 .937 r
.51458 .23291 m .50454 .23297 L p .515 .2339 L F P
0 g
s
.298 .768 .937 r
.515 .2339 m .53372 .23558 L .51458 .23291 L F
.346 .804 .939 r
.51608 .2365 m .49882 .23794 L p .50739 .23714 L F P
0 g
s
.676 .595 .758 r
.50991 .26422 m .50739 .23714 L p .49882 .23794 L F P
0 g
s
.676 .595 .758 r
.50739 .23714 m .50733 .23655 L .49882 .23794 L p F P
0 g
s
.346 .804 .939 r
.49882 .23794 m .4999 .2377 L .50739 .23714 L F
.704 .617 .756 r
.51608 .2365 m .50733 .23655 L p .50798 .2371 L F P
0 g
s
.704 .617 .756 r
.50733 .23655 m .50991 .26422 L .51747 .26418 L p F P
0 g
s
.704 .617 .756 r
.50733 .23655 m .51747 .26418 L .51647 .24422 L F
.346 .804 .939 r
.4999 .2377 m .51513 .23422 L .51608 .2365 L F
.704 .617 .756 r
.50798 .2371 m .51647 .24422 L .51608 .2365 L F
.26 .734 .938 r
.53353 .23623 m .55318 .23536 L .5426 .23697 L F
.53371 .23563 m .55318 .23536 L .53353 .23623 L F
.55318 .23536 m .56287 .23522 L .55237 .23613 L F
.55318 .23536 m .55237 .23613 L .5426 .23697 L F
.218 .677 .947 r
.56211 .2386 m .56913 .23951 L .56803 .24006 L F
.233 .704 .942 r
.55338 .23516 m .56775 .2402 L .56913 .23951 L F
.55307 .23546 m .56775 .2402 L .55338 .23516 L F
.718 .628 .757 r
.55879 .23876 m .55948 .23826 L .55893 .23878 L F
.55079 .23764 m .55948 .23826 L p .54986 .24532 L F P
0 g
s
.718 .628 .757 r
.55948 .23826 m .55498 .26568 L .54746 .26515 L p F P
0 g
s
.718 .628 .757 r
.54956 .24776 m .55948 .23826 L .54746 .26515 L F
.233 .704 .942 r
.55307 .23546 m .55079 .23764 L .56679 .23989 L F
.26 .734 .938 r
.5426 .23697 m .55237 .23613 L .55079 .23764 L F
.491 0 0 r
.53455 .23289 m .55683 .24015 L .55451 .23454 L F
.718 .628 .757 r
.54986 .24532 m .55879 .23876 L .54958 .24764 L F
.744 .654 .76 r
.55498 .26568 m .55939 .23885 L p .56775 .2402 L F P
0 g
s
.744 .654 .76 r
.55498 .26568 m .56775 .2402 L .56339 .26125 L F
.731 .641 .758 r
.56949 .26843 m .57613 .24207 L p .56766 .24064 L F P
0 g
s
.731 .641 .758 r
.56339 .26125 m .56949 .26843 L .56766 .24064 L F
.491 0 0 r
.53461 .23337 m .55691 .24034 L .53455 .23289 L F
.218 .677 .947 r
.56913 .23951 m .59027 .24227 L .56803 .24006 L F
.233 .704 .942 r
.57383 .23716 m .5657 .23857 L p .56913 .23951 L F P
0 g
s
.757 .667 .763 r
.57627 .24149 m .57632 .27062 L .59396 .27248 L F
.744 .654 .76 r
.58197 .25147 m .59164 .24638 L .57632 .27062 L F
.59164 .24638 m .59238 .24598 L .59204 .2465 L F
.59164 .24638 m .59204 .2465 L .57632 .27062 L F
.214 .653 .952 r
.58952 .24249 m .58454 .24394 L .59219 .24655 L F
.744 .654 .76 r
.59238 .24598 m .59219 .24655 L p .59204 .2465 L F P
0 g
s
.214 .653 .952 r
.58952 .24249 m .59219 .24655 L .5991 .24869 L F
.757 .667 .763 r
.57627 .24149 m .56949 .26843 L .57632 .27062 L p F P
0 g
s
.757 .667 .763 r
.58416 .24405 m .57627 .24149 L p .58411 .2442 L F P
0 g
s
.218 .677 .947 r
.56803 .24006 m .59027 .24227 L .58416 .24405 L F
.57383 .23716 m .59262 .24158 L p .56961 .23927 L F P
0 g
s
.22 .632 .955 r
.6022 .24874 m .60971 .24753 L .63556 .25811 L F
.6011 .24401 m .60204 .2438 L .61049 .24741 L p F P
0 g
s
.578 .007 0 r
.59858 .24835 m .59293 .24194 L .61062 .24753 L F
.235 .614 .955 r
.62366 .25477 m .62318 .2548 L .6243 .25544 L F
.62318 .2548 m .6144 .25535 L .6243 .25544 L F
.782 .698 .771 r
.61109 .2623 m .61726 .28113 L .6144 .25535 L F
.77 .682 .766 r
.6144 .25535 m .62172 .25847 L p .61109 .2623 L F P
0 g
s
.782 .698 .771 r
.61008 .26441 m .60381 .27757 L .6142 .28649 L F
.59662 .27712 m .60252 .28026 L p .59849 .27301 L F P
0 g
s
.782 .698 .771 r
.60252 .28026 m .6142 .28649 L p .60905 .28207 L F P
0 g
s
.782 .698 .771 r
.59849 .27301 m .60252 .28026 L .60905 .28207 L F
.836 .645 .644 r
.60239 .28091 m .60522 .32562 L .61377 .28837 L F
.59939 .29624 m .60426 .32981 L .60239 .28091 L F
.885 .699 .646 r
.62467 .29539 m .62313 .33848 L .634 .30128 L F
.817 .752 .791 r
.63467 .30041 m .6534 .29667 L .64407 .30719 L F
.63773 .29647 m .65468 .29522 L .63467 .30041 L F
.65468 .29522 m .6534 .29667 L .63467 .30041 L F
.828 .772 .8 r
.65468 .29522 m .64834 .3185 L .65253 .31433 L F
.806 .733 .783 r
.63572 .27717 m .63773 .29647 L .63996 .27086 L F
.63773 .29647 m .63904 .29479 L .63996 .27086 L F
.63405 .2981 m .63023 .29622 L .634 .30128 L F
.62473 .29352 m .634 .30128 L p .63023 .29622 L F P
0 g
s
.885 .699 .646 r
.634 .30128 m .62473 .29352 L p .62467 .29539 L F P
0 g
s
.885 .699 .646 r
.62072 .30886 m .62191 .34265 L .62473 .29352 L F
.91 .73 .646 r
.62191 .34265 m .634 .30128 L .6414 .31119 L F
.96 .802 .641 r
.64834 .3185 m .65328 .32773 L p .65055 .32387 L F P
0 g
s
.96 .802 .641 r
.64782 .32 m .64834 .3185 L .65055 .32387 L F
.838 .794 .81 r
.65328 .32773 m .64834 .3185 L p .66546 .31695 L F P
0 g
s
.935 .764 .645 r
.64834 .3185 m .6419 .30964 L p .63612 .35368 L F P
0 g
s
.935 .764 .645 r
.63722 .3242 m .63475 .35762 L .6419 .30964 L F
.63475 .35762 m .63612 .35368 L .6419 .30964 L F
.91 .73 .646 r
.62191 .34265 m .6414 .31119 L .63722 .3242 L F
.634 .30128 m .6419 .30964 L p .6414 .31119 L F P
0 g
s
.935 .764 .645 r
.62526 .36145 m .63085 .36884 L p .62944 .36102 L F P
0 g
s
.935 .764 .645 r
.62799 .35296 m .62526 .36145 L .62944 .36102 L F
.532 .206 .361 r
.58095 .4347 m .56785 .46786 L .57256 .445 L F
.424 .11 .327 r
.58095 .4347 m .58691 .43237 L p .58653 .43336 L F P
0 g
s
.482 .162 .347 r
.59283 .43191 m .57438 .43615 L .57431 .43651 L F
.58412 .46303 m .59283 .43191 L p .58664 .43344 L F P
0 g
s
.482 .162 .347 r
.58114 .45497 m .58664 .43344 L .57431 .43651 L F
.58412 .46303 m .58664 .43344 L .58114 .45497 L F
.58412 .46303 m .57431 .43651 L .57256 .445 L F
.52 .917 .87 r
.6063 .42644 m .6091 .42597 L .60276 .42909 L F
.638 .575 .768 r
.61438 .43637 m .60966 .42695 L .60256 .42912 L F
.52 .917 .87 r
.6063 .42644 m .60301 .4289 L .60539 .4266 L F
.60301 .4289 m .60276 .42909 L .60291 .42895 L F
.60301 .4289 m .60291 .42895 L .60539 .4266 L F
.60276 .42909 m .60256 .42912 L p .60291 .42895 L F P
0 g
s
.638 .575 .768 r
.61686 .42474 m .60916 .42596 L .60256 .42912 L F
.60458 .45356 m .62003 .44762 L p .5976 .43636 L F P
0 g
s
.638 .575 .768 r
.61705 .44167 m .5976 .43636 L .62003 .44762 L F
.634 .514 .7 r
.58836 .45839 m .60458 .45356 L p .58862 .45963 L F P
0 g
s
.613 .502 .703 r
.60458 .45356 m .59685 .45653 L p .60674 .46148 L F P
0 g
s
.634 .514 .7 r
.60469 .45397 m .58862 .45963 L .60458 .45356 L F
.60469 .45397 m .59375 .48376 L .58862 .45963 L F
.424 .11 .327 r
.60483 .42537 m .59412 .45871 L .58894 .4607 L p F P
0 g
s
.424 .11 .327 r
.60483 .42537 m .58894 .4607 L .59518 .43986 L F
.57867 .46465 m .57352 .46663 L p .58052 .45741 L F P
0 g
s
.482 .162 .347 r
.5681 .43805 m .56243 .46947 L .56785 .46786 L p F P
0 g
s
.671 .539 .696 r
.58231 .53273 m .5609 .5357 L p .57859 .50837 L F P
0 g
s
.689 .553 .695 r
.55757 .50004 m .56745 .49932 L p .55666 .49038 L F P
0 g
s
.671 .539 .696 r
.55757 .50004 m .57691 .4973 L p .55971 .52295 L F P
0 g
s
.671 .54 .696 r
.57691 .4973 m .55757 .50004 L p .57276 .47018 L F P
0 g
s
.653 .527 .698 r
.59375 .48376 m .57276 .47018 L .59576 .49326 L F
.57276 .47018 m .57319 .47299 L .59576 .49326 L F
.57691 .4973 m .59576 .49326 L p .57319 .47299 L F P
0 g
s
.482 .217 .435 r
.56619 .53178 m .57352 .46663 L .57867 .46465 L p F P
0 g
s
.482 .162 .347 r
.58412 .46303 m .57256 .445 L .56893 .46262 L F
.57867 .46465 m .58412 .46303 L p .56893 .46262 L F P
0 g
s
.354 .047 .299 r
.59324 .43046 m .58412 .46303 L .58894 .4607 L p F P
0 g
s
.606 .953 .892 r
.60483 .42537 m .61581 .42331 L p .62194 .41969 L F P
0 g
s
.426 .87 .842 r
.61535 .4235 m .6063 .42644 L .60916 .42596 L F
.606 .953 .892 r
.61363 .42146 m .60483 .42537 L .62194 .41969 L F
.267 0 .261 r
.59412 .45871 m .60483 .42537 L p .60952 .4233 L F P
0 g
s
.606 .953 .892 r
.60959 .42312 m .60483 .42537 L .60952 .42329 L F
.60959 .42312 m .60952 .42329 L .63374 .41254 L F
.63001 .41349 m .60959 .42312 L .63374 .41254 L F
.52 .917 .87 r
.59882 .42771 m .60998 .42224 L p .60931 .42287 L F P
0 g
s
.606 .953 .892 r
.60998 .42224 m .60483 .42537 L p .61269 .42166 L F P
0 g
s
.267 0 .261 r
.6011 .44848 m .59412 .45871 L .60998 .42224 L F
.424 .11 .327 r
.60483 .42537 m .59518 .43986 L .59606 .43693 L F
.354 .047 .299 r
.59606 .43693 m .59324 .43046 L .58894 .4607 L F
.59606 .43693 m .59853 .42869 L .59367 .43144 L F
.424 .11 .327 r
.59853 .42869 m .58052 .45741 L .58691 .43237 L F
.6035 .42712 m .59606 .43693 L .59853 .42869 L F
.59606 .43693 m .58052 .45741 L .59853 .42869 L F
.267 0 .261 r
.60483 .42537 m .60998 .42224 L p .60952 .4233 L F P
0 g
s
.638 .575 .768 r
.61686 .42474 m .61604 .42327 L .60916 .42596 L p F P
0 g
s
.606 .953 .892 r
.63971 .40892 m .63941 .409 L p .63902 .40924 L F P
0 g
s
.592 .557 .784 r
.64189 .43707 m .62933 .41794 L p .63941 .409 L F P
0 g
s
.742 .982 .911 r
.63941 .409 m .63971 .40892 L .64442 .40455 L p F P
0 g
s
.592 .557 .784 r
.64431 .40594 m .64189 .43707 L .63941 .409 L F
.648 .40891 m .64189 .43707 L .64442 .40455 L F
.623 .568 .772 r
.62841 .41653 m .63455 .44061 L .62482 .42447 L F
.592 .557 .784 r
.64405 .42709 m .64647 .43311 L .64245 .43446 L F
.64662 .43071 m .64647 .43311 L .64405 .42709 L F
.64885 .40995 m .64647 .43311 L .648 .40891 L F
.64885 .40995 m .65899 .42228 L .64647 .43311 L F
.608 .562 .777 r
.61604 .42327 m .62671 .44256 L p .64796 .4326 L F P
0 g
s
.608 .562 .777 r
.64405 .42709 m .61604 .42327 L .64796 .4326 L F
.623 .568 .772 r
.62155 .42103 m .61609 .43976 L .60916 .42596 L F
.354 .047 .299 r
.60339 .45372 m .60998 .42224 L .59853 .42869 L F
.60339 .45372 m .60154 .44949 L .60043 .45048 L F
.59854 .45606 m .60339 .45372 L p .60043 .45048 L F P
0 g
s
.354 .047 .299 r
.60339 .45372 m .59853 .42869 L .59606 .43693 L F
.623 .568 .772 r
.62482 .42447 m .61705 .44167 L .62194 .41969 L F
.61705 .44167 m .61609 .43976 L .62194 .41969 L F
.681 .974 .906 r
.62938 .41 m .62841 .41653 L .62393 .41375 L F
.62841 .41653 m .61773 .41898 L p .62393 .41375 L F P
0 g
s
.681 .974 .906 r
.61773 .41898 m .61561 .41947 L .62025 .41599 L p F P
0 g
s
.681 .974 .906 r
.62025 .41599 m .62953 .40903 L p .62565 .4123 L F P
0 g
s
.681 .974 .906 r
.62565 .4123 m .61773 .41898 L .62025 .41599 L F
.52 .917 .87 r
.61561 .41947 m .62814 .41659 L p .62175 .41973 L F P
0 g
s
.52 .917 .87 r
.61561 .41947 m .62175 .41973 L .61269 .42166 L F
.157 0 .207 r
.61665 .42571 m .62011 .41638 L .61561 .41947 L F
.52 .917 .87 r
.60998 .42224 m .61561 .41947 L p .61269 .42166 L F P
0 g
s
.354 .047 .299 r
.60339 .45372 m .61561 .41947 L .60998 .42224 L p F P
0 g
s
.681 .974 .906 r
.6329 .40802 m .62841 .41653 L .62953 .40903 L F
.6329 .40802 m .63374 .41254 L .63001 .41349 L F
.742 .982 .911 r
.64937 .39737 m .63946 .40081 L .63116 .40854 L F
.63946 .40081 m .6377 .40142 L .63445 .40496 L F
.63946 .40081 m .63445 .40496 L .63116 .40854 L F
.64937 .39737 m .63116 .40854 L .6329 .40802 L F
.681 .974 .906 r
.63422 .40551 m .63407 .40766 L .6329 .40802 L F
.742 .982 .911 r
.6377 .40142 m .62953 .40903 L p .63116 .40854 L F P
0 g
s
.681 .974 .906 r
.62953 .40903 m .63422 .40551 L p .6329 .40802 L F P
0 g
s
.157 0 .207 r
.63356 .40713 m .63422 .40551 L .62953 .40903 L p F P
0 g
s
.157 0 .207 r
.62953 .40903 m .62025 .41599 L p .62468 .41304 L F P
0 g
s
.742 .982 .911 r
.6329 .40802 m .63116 .40854 L .62979 .41002 L F
.681 .974 .906 r
.63407 .40766 m .63374 .41254 L .6329 .40802 L F
.606 .953 .892 r
.63902 .40924 m .62212 .41532 L .63001 .41349 L F
.62212 .41532 m .62025 .41599 L .62172 .41561 L F
.62212 .41532 m .62172 .41561 L .63001 .41349 L F
.62544 .41283 m .62025 .41599 L p .62212 .41532 L F P
0 g
s
.606 .953 .892 r
.63902 .40924 m .62544 .41283 L .62212 .41532 L F
.742 .982 .911 r
.62979 .41002 m .63116 .40854 L .62544 .41283 L F
.606 .953 .892 r
.63941 .409 m .62544 .41283 L p .63902 .40924 L F P
0 g
s
.742 .982 .911 r
.62544 .41283 m .63941 .409 L p .64442 .40455 L F P
0 g
s
.592 .557 .784 r
.63941 .409 m .62933 .41794 L .63374 .41254 L F
.608 .562 .777 r
.64405 .42709 m .63374 .41254 L .62252 .42065 L F
.64405 .42709 m .62252 .42065 L .62482 .42447 L F
.62252 .42065 m .62814 .41659 L .62194 .41969 L F
.742 .982 .911 r
.6329 .40802 m .62544 .41283 L .64442 .40455 L F
.016 0 .133 r
.61183 .4481 m .62484 .41441 L p .62905 .41023 L F P
0 g
s
.742 .982 .911 r
.62953 .40903 m .62544 .41283 L p .63116 .40854 L F P
0 g
s
.157 0 .207 r
.63356 .40713 m .62953 .40903 L .62911 .4101 L F
.016 0 .133 r
.62095 .4307 m .61183 .4481 L .62905 .41023 L F
.157 0 .207 r
.61561 .41947 m .60339 .45372 L .60737 .45077 L p F P
0 g
s
.157 0 .207 r
.61665 .42571 m .61561 .41947 L .60737 .45077 L F
.267 0 .261 r
.61975 .41733 m .6011 .44848 L .60964 .42324 L F
.62411 .41479 m .61665 .42571 L .61975 .41733 L F
.61665 .42571 m .6011 .44848 L .61975 .41733 L F
.61781 .43263 m .61734 .42984 L p .62544 .41283 L F P
0 g
s
.267 0 .261 r
.61217 .44722 m .61183 .4481 L p .60737 .45077 L F P
0 g
s
.267 0 .261 r
.62544 .41283 m .60737 .45077 L .61551 .4288 L F
.354 .047 .299 r
.60154 .44949 m .6011 .44848 L .60043 .45048 L F
.267 0 .261 r
.62544 .41283 m .59854 .45606 L .6011 .44848 L F
.623 .568 .772 r
.62482 .42447 m .62003 .44762 L .61705 .44167 L F
.608 .562 .777 r
.63455 .44061 m .64796 .4326 L p .62671 .44256 L F P
0 g
s
.623 .568 .772 r
.63455 .44061 m .62003 .44762 L p .62482 .42447 L F P
0 g
s
.606 .953 .892 r
.63902 .40924 m .63001 .41349 L .63374 .41254 L F
.681 .974 .906 r
.63001 .41349 m .63374 .41254 L .62852 .41631 L F
.157 0 .207 r
.61935 .4419 m .63356 .40713 L p .62905 .41023 L F P
0 g
s
.016 0 .133 r
.61958 .43414 m .61183 .4481 L .62095 .4307 L F
.157 0 .207 r
.62025 .41599 m .61561 .41947 L p .62011 .41638 L F P
0 g
s
.267 0 .261 r
.61987 .41703 m .60964 .42324 L .61492 .41963 L F
.62411 .41479 m .61975 .41733 L .61987 .41703 L F
.61975 .41733 m .60964 .42324 L .61987 .41703 L F
.60998 .42224 m .62544 .41283 L p .62411 .41479 L F P
0 g
s
.016 0 .133 r
.62484 .41441 m .62544 .41283 L .62953 .40903 L p F P
0 g
s
.016 0 .133 r
.62953 .40903 m .6377 .40142 L p .62911 .4101 L F P
0 g
s
.016 0 .133 r
.62911 .4101 m .62484 .41441 L .62953 .40903 L F
.157 0 .207 r
.63356 .40713 m .62911 .4101 L .62905 .41023 L F
.787 .977 .909 r
.64982 .40051 m .63422 .40551 L .6377 .40142 L p F P
0 g
s
0 0 .031 r
.6377 .40142 m .63422 .40551 L p .63724 .40252 L F P
0 g
s
.742 .982 .911 r
.64183 .39757 m .6377 .40142 L p .63972 .40045 L F P
0 g
s
.787 .977 .909 r
.64937 .39737 m .64982 .40051 L .6377 .40142 L F
.016 0 .133 r
.6377 .40142 m .64183 .39757 L p .63753 .40183 L F P
0 g
s
.016 0 .133 r
.63753 .40183 m .62484 .41441 L .6377 .40142 L F
.681 .974 .906 r
.63422 .40551 m .64949 .40062 L p .64442 .40455 L F P
0 g
s
.681 .974 .906 r
.63422 .40551 m .64442 .40455 L .63407 .40766 L F
.016 0 .133 r
.64183 .39757 m .6334 .41177 L .63753 .40183 L F
.787 .977 .909 r
.64818 .38909 m .6484 .39061 L .64296 .3961 L F
.82 .963 .901 r
.64466 .39323 m .64183 .39757 L p .64855 .39169 L F P
0 g
s
0 0 0 r
.64183 .39757 m .64466 .39323 L p .64417 .39437 L F P
0 g
s
.82 .963 .901 r
.64855 .39169 m .64183 .39757 L .64955 .3913 L F
.64183 .39757 m .65826 .39153 L p .66162 .38652 L F P
0 g
s
.82 .963 .901 r
.64955 .3913 m .64183 .39757 L .66162 .38652 L F
0 0 0 r
.64112 .39925 m .64183 .39757 L p .64417 .39437 L F P
0 g
s
0 0 0 r
.62586 .4352 m .64112 .39925 L p .64411 .39452 L F P
0 g
s
0 0 .031 r
.63126 .42805 m .64466 .39323 L .63308 .42027 L F
.787 .977 .909 r
.64466 .39323 m .64818 .38909 L p .64528 .39299 L F P
0 g
s
.592 .557 .784 r
.64442 .40455 m .64431 .40594 L .63941 .409 L F
0 0 .031 r
.63126 .42805 m .64818 .38909 L .64466 .39323 L p F P
0 g
s
0 0 0 r
.64797 .38841 m .63317 .42008 L .64411 .39452 L F
.65012 .38501 m .64968 .38592 L .64797 .38841 L F
.64968 .38592 m .63317 .42008 L .64797 .38841 L F
.63317 .42008 m .62586 .4352 L .64411 .39452 L F
0 0 .031 r
.63126 .42805 m .63308 .42027 L .63193 .42297 L F
.787 .977 .909 r
.64818 .38909 m .64992 .39115 L .64855 .39169 L F
.64818 .38909 m .6656 .38181 L p .66165 .38651 L F P
0 g
s
.787 .977 .909 r
.64818 .38909 m .66165 .38651 L .64992 .39115 L F
0 0 0 r
.64777 .39009 m .6498 .38574 L .64818 .38909 L F
.65031 .38456 m .64818 .38909 L p .6498 .38574 L F P
0 g
s
.82 .963 .901 r
.67136 .37165 m .65031 .38456 L .67126 .37182 L F
0 0 0 r
.65318 .38017 m .63549 .42053 L p .63584 .41815 L F P
0 g
s
0 0 0 r
.64818 .38909 m .63126 .42805 L .63306 .42423 L p F P
0 g
s
0 0 0 r
.64395 .39919 m .64818 .38909 L .63306 .42423 L F
.65318 .38017 m .63306 .42423 L .64548 .39566 L F
.64067 .4074 m .64818 .38909 L .63666 .41659 L F
0 0 .031 r
.62826 .43154 m .63126 .42805 L p .63193 .42297 L F P
0 g
s
0 0 0 r
.63306 .42423 m .62826 .43154 L p .64548 .39566 L F P
0 g
s
0 0 0 r
.62826 .43154 m .62586 .4352 L p .63193 .42297 L F P
0 g
s
0 0 0 r
.64548 .39566 m .62826 .43154 L .63193 .42297 L F
.63193 .42297 m .62586 .4352 L .63317 .42008 L F
.016 0 .133 r
.64183 .39757 m .62586 .4352 L .62232 .43845 L p F P
0 g
s
0 0 .031 r
.63422 .40551 m .61935 .4419 L .62232 .43845 L p F P
0 g
s
0 0 .031 r
.63203 .41506 m .63422 .40551 L .62232 .43845 L F
.016 0 .133 r
.64183 .39757 m .62232 .43845 L .6334 .41177 L F
0 0 .031 r
.63193 .42297 m .63422 .40551 L .62826 .43154 L F
.157 0 .207 r
.61935 .4419 m .62905 .41023 L .61958 .43414 L F
.61533 .44488 m .61935 .4419 L p .61851 .43685 L F P
0 g
s
.157 0 .207 r
.61935 .4419 m .61958 .43414 L .61851 .43685 L F
0 0 .031 r
.6334 .41177 m .63724 .40252 L .6341 .40646 L F
.6341 .40646 m .63724 .40252 L .63422 .40551 L F
.016 0 .133 r
.6334 .41177 m .61183 .4481 L .63753 .40183 L F
.157 0 .207 r
.61851 .43685 m .62011 .41638 L .61665 .42571 L F
.61958 .43414 m .62011 .41638 L .61851 .43685 L F
.016 0 .133 r
.62232 .43845 m .61533 .44488 L p .6334 .41177 L F P
0 g
s
.016 0 .133 r
.61533 .44488 m .61183 .4481 L p .61851 .43685 L F P
0 g
s
.016 0 .133 r
.6334 .41177 m .61533 .44488 L .61851 .43685 L F
0 0 .031 r
.62232 .43845 m .62826 .43154 L p .63203 .41506 L F P
0 g
s
0 0 0 r
.63666 .41659 m .64395 .39919 L .6359 .41769 L F
.63549 .42053 m .63306 .42423 L p .63584 .41815 L F P
0 g
s
0 0 0 r
.63306 .42423 m .63666 .41659 L p .6359 .41769 L F P
0 g
s
0 0 0 r
.65318 .38017 m .64548 .39566 L .65012 .38501 L F
.65031 .38456 m .65318 .38017 L p .65012 .38501 L F P
0 g
s
0 0 0 r
.65012 .38501 m .64112 .39925 L .65031 .38456 L F
.798 .85 .395 r
.64067 .4074 m .63549 .42053 L .65458 .37549 L F
0 0 0 r
.64193 .40451 m .65458 .37549 L .6498 .38574 L F
.64548 .39566 m .6498 .38574 L .64777 .39009 L F
.64548 .39566 m .63193 .42297 L .65012 .38501 L F
.63193 .42297 m .63317 .42008 L .65012 .38501 L F
.64466 .39323 m .65031 .38456 L p .64723 .38949 L F P
0 g
s
0 0 0 r
.64723 .38949 m .64417 .39437 L .64466 .39323 L F
.921 .905 .504 r
.65685 .36738 m .65777 .36198 L .65726 .36643 L F
.65871 .35653 m .6574 .36611 L p .65777 .36198 L F P
0 g
s
.921 .905 .504 r
.65777 .36198 m .6574 .36611 L .65726 .36643 L F
.497 .541 .831 r
.67681 .35516 m .67347 .36598 L p .6756 .36089 L F P
0 g
s
.852 .919 .876 r
.66971 .35917 m .6574 .36611 L .65676 .37314 L F
.857 .893 .861 r
.66158 .35288 m .67142 .3582 L .6574 .36611 L F
.475 .541 .844 r
.67681 .35516 m .67843 .34409 L p .67809 .34992 L F P
0 g
s
.857 .893 .861 r
.6574 .36611 m .65937 .35168 L p .66158 .35288 L F P
0 g
s
.857 .893 .861 r
.66315 .35373 m .67671 .35522 L .67142 .3582 L F
.66468 .35277 m .67671 .35522 L .66315 .35373 L F
.66468 .35277 m .67811 .34429 L .67671 .35522 L F
.67843 .34409 m .67681 .35516 L p .67882 .33876 L F P
0 g
s
.852 .919 .876 r
.67681 .35516 m .66034 .37259 L .6732 .36611 L F
.67347 .36598 m .67681 .35516 L p .67141 .37156 L F P
0 g
s
.857 .893 .861 r
.67681 .35516 m .67601 .36068 L p .67671 .35522 L F P
0 g
s
.857 .893 .861 r
.67882 .33876 m .67681 .35516 L .67671 .35522 L F
.852 .919 .876 r
.67142 .3582 m .65458 .37549 L .65885 .37334 L F
.67851 .34967 m .66971 .35917 L .67142 .3582 L F
.66971 .35917 m .65458 .37549 L .67142 .3582 L F
.857 .868 .847 r
.65883 .36136 m .67809 .34992 L p .67843 .34409 L F P
0 g
s
.857 .868 .847 r
.67809 .34992 m .67851 .34967 L .67843 .34409 L p F P
0 g
s
.451 .542 .859 r
.67843 .34409 m .67851 .34967 L p .67938 .34462 L F P
0 g
s
.475 .541 .844 r
.67843 .34409 m .67919 .34538 L .67809 .34992 L F
.852 .919 .876 r
.67851 .34967 m .67807 .35002 L .67802 .3502 L F
.67851 .34967 m .65883 .36136 L .6574 .36611 L p F P
0 g
s
.852 .919 .876 r
.67681 .35516 m .67851 .34967 L p .67142 .3582 L F P
0 g
s
.853 .842 .834 r
.67925 .33848 m .66265 .34951 L p .65666 .33723 L F P
0 g
s
.853 .842 .834 r
.66108 .33374 m .67925 .33848 L .65666 .33723 L F
.857 .868 .847 r
.67818 .32723 m .67777 .32765 L .6778 .32792 L F
.425 .545 .874 r
.67776 .32755 m .69863 .34685 L .68066 .33909 L F
.853 .842 .834 r
.67488 .31641 m .6753 .31607 L .6763 .32174 L p F P
0 g
s
.398 .549 .889 r
.67897 .32626 m .67488 .31641 L .67818 .32723 L F
.6763 .32174 m .67818 .32723 L p .67488 .31641 L F P
0 g
s
.846 .818 .821 r
.66717 .31545 m .66108 .33374 L .67252 .31071 L F
.66108 .33374 m .66263 .33252 L .67252 .31071 L F
.838 .794 .81 r
.6753 .31607 m .65574 .33235 L .65328 .32773 L p F P
0 g
s
.838 .794 .81 r
.66546 .31695 m .6753 .31607 L .65328 .32773 L F
.65253 .31433 m .6753 .31607 L .64834 .3185 L F
.67252 .31071 m .6753 .31607 L p .673 .31186 L F P
0 g
s
.838 .794 .81 r
.66717 .31545 m .67242 .3108 L .6753 .31607 L F
.369 .555 .905 r
.66952 .30399 m .67673 .3166 L .6702 .3055 L F
.398 .549 .889 r
.68741 .31578 m .67252 .31071 L .67897 .32626 L F
.425 .545 .874 r
.67732 .32289 m .69863 .34685 L .67776 .32755 L F
.857 .893 .861 r
.67882 .33876 m .67925 .33848 L .67843 .34409 L p F P
0 g
s
.853 .842 .834 r
.67878 .33836 m .67838 .33409 L .67925 .33848 L F
.425 .545 .874 r
.68106 .32367 m .69863 .34685 L .6763 .32174 L F
.69837 .34818 m .67925 .33848 L p .69863 .34685 L F P
0 g
s
.475 .541 .844 r
.67925 .33848 m .69837 .34818 L p .69789 .35474 L F P
0 g
s
.475 .541 .844 r
.67925 .33848 m .69789 .35474 L .6832 .3467 L F
.451 .542 .859 r
.69355 .34015 m .67827 .33291 L .67938 .34462 L F
.6832 .3467 m .67938 .34462 L .67978 .34886 L F
.69355 .34015 m .67938 .34462 L .6832 .3467 L F
.475 .541 .844 r
.69176 .36452 m .69646 .3743 L .68994 .36338 L F
.519 .542 .82 r
.67656 .36302 m .67803 .36923 L .67438 .36663 L F
.497 .541 .831 r
.69176 .36452 m .67347 .36598 L .67803 .36923 L F
.69944 .36187 m .68994 .36338 L .69176 .36452 L F
.68994 .36338 m .67347 .36598 L .69176 .36452 L F
.425 .545 .874 r
.69937 .34291 m .70042 .34922 L p .69886 .34266 L F P
0 g
s
.425 .545 .874 r
.69355 .34015 m .69886 .34266 L .70042 .34922 L F
.451 .542 .859 r
.67851 .34967 m .69944 .36187 L .69942 .35557 L p F P
0 g
s
.475 .541 .844 r
.69837 .34818 m .69942 .35557 L .69789 .35474 L F
.451 .542 .859 r
.69942 .35557 m .69937 .34291 L p .68486 .34761 L F P
0 g
s
.451 .542 .859 r
.68486 .34761 m .67851 .34967 L .69942 .35557 L F
.475 .541 .844 r
.69942 .35557 m .69646 .3743 L p .69789 .35474 L F P
0 g
s
.451 .542 .859 r
.69355 .34015 m .67851 .34967 L .69937 .34291 L F
.475 .541 .844 r
.6832 .3467 m .69789 .35474 L .69694 .36776 L F
.69176 .36452 m .69694 .36776 L .69646 .3743 L F
.6832 .3467 m .69694 .36776 L .69176 .36452 L F
.67919 .34538 m .68994 .36338 L .67681 .35516 L F
.852 .919 .876 r
.67802 .3502 m .6574 .36611 L .66971 .35917 L F
.67807 .35002 m .6574 .36611 L .67802 .3502 L F
.857 .893 .861 r
.67142 .3582 m .67601 .36068 L .6574 .36611 L F
.841 .943 .889 r
.65675 .37089 m .6756 .36089 L p .67347 .36598 L F P
0 g
s
.841 .943 .889 r
.6756 .36089 m .67601 .36068 L .67347 .36598 L p F P
0 g
s
.497 .541 .831 r
.67456 .36581 m .6756 .36089 L .67347 .36598 L F
.857 .893 .861 r
.67601 .36068 m .6756 .36089 L p .67562 .36079 L F P
0 g
s
.857 .893 .861 r
.67142 .3582 m .67671 .35522 L .67601 .36068 L F
.497 .541 .831 r
.68994 .36338 m .67681 .35516 L .67456 .36581 L F
.857 .893 .861 r
.65675 .37089 m .6574 .36611 L p .67562 .36079 L F P
0 g
s
.857 .893 .861 r
.6756 .36089 m .65675 .37089 L p .67562 .36079 L F P
0 g
s
0 0 0 r
.64067 .4074 m .6498 .38574 L .64548 .39566 L F
.64193 .40451 m .6498 .38574 L .64067 .4074 L F
.6498 .38574 m .65218 .38064 L .65031 .38456 L F
.65458 .37549 m .65031 .38456 L p .65218 .38064 L F P
0 g
s
.978 .906 .573 r
.65322 .35969 m .64421 .39081 L .65846 .34687 L F
.921 .905 .504 r
.64552 .38771 m .65871 .35653 L .65685 .36738 L F
.978 .906 .573 r
.64421 .39081 m .64568 .38735 L .65846 .34687 L F
.921 .905 .504 r
.64421 .39081 m .65685 .36738 L .65224 .37804 L F
0 0 .031 r
.63308 .42027 m .64466 .39323 L .63724 .40252 L F
.63724 .40252 m .64093 .3979 L .6377 .40142 L F
.64466 .39323 m .6377 .40142 L p .64093 .3979 L F P
0 g
s
.991 .879 .612 r
.64226 .37395 m .65666 .33723 L .65791 .34824 L F
.64226 .37395 m .65791 .34824 L .65322 .35969 L F
.978 .906 .573 r
.65155 .36375 m .64283 .38506 L .64005 .40066 L F
.63976 .39256 m .64005 .40066 L p .64142 .39298 L F P
0 g
s
0 0 .031 r
.63193 .42297 m .63724 .40252 L .6334 .41177 L F
.63308 .42027 m .63724 .40252 L .63193 .42297 L F
.016 0 .133 r
.63706 .40267 m .61958 .43414 L .63449 .40484 L F
.61958 .43414 m .62095 .4307 L .63449 .40484 L F
.63449 .40484 m .62095 .4307 L .62905 .41023 L F
.613 .502 .703 r
.62724 .46924 m .62039 .44868 L .60458 .45356 L F
.592 .49 .707 r
.62003 .44762 m .63455 .44061 L p .62039 .44868 L F P
0 g
s
.016 0 .133 r
.63753 .40183 m .63706 .40267 L .63449 .40484 L F
.653 .527 .697 r
.59576 .49326 m .57691 .4973 L p .60113 .5186 L F P
0 g
s
.169 0 .324 r
.59844 .51672 m .61183 .4481 L .61533 .44488 L p F P
0 g
s
.169 0 .324 r
.60444 .49888 m .59844 .51672 L .61533 .44488 L F
.634 .514 .7 r
.60674 .46148 m .59375 .48376 L .60469 .45397 L F
.359 .112 .397 r
.60737 .45077 m .61183 .4481 L p .60377 .47012 L F P
0 g
s
.359 .112 .397 r
.61183 .4481 m .59844 .51672 L .59469 .51889 L p F P
0 g
s
.275 .042 .367 r
.60339 .45372 m .59135 .52128 L .59469 .51889 L p F P
0 g
s
.275 .042 .367 r
.60263 .47622 m .60339 .45372 L .59469 .51889 L F
.359 .112 .397 r
.61183 .4481 m .59469 .51889 L .60377 .47012 L F
.275 .042 .367 r
.60474 .5117 m .61935 .4419 L .61533 .44488 L p F P
0 g
s
.275 .042 .367 r
.60474 .5117 m .61533 .44488 L .60552 .4935 L F
.60474 .5117 m .60737 .45077 L .60377 .47012 L F
.60137 .51411 m .60474 .5117 L p .60444 .49888 L F P
0 g
s
.03 0 .262 r
.61935 .4419 m .60474 .5117 L .60722 .5089 L p F P
0 g
s
.169 0 .324 r
.62586 .4352 m .61017 .50627 L .60722 .5089 L p F P
0 g
s
.169 0 .324 r
.62586 .4352 m .60722 .5089 L .61668 .46478 L F
.03 0 .262 r
.61803 .45847 m .61935 .4419 L .60722 .5089 L F
.169 0 .324 r
.61803 .45847 m .60137 .51411 L .60444 .49888 L F
.62586 .4352 m .61668 .46478 L .61803 .45847 L F
.61668 .46478 m .60137 .51411 L .61803 .45847 L F
.03 0 .262 r
.62232 .43845 m .61935 .4419 L p .61803 .45847 L F P
0 g
s
.169 0 .324 r
.61533 .44488 m .62586 .4352 L p .60444 .49888 L F P
0 g
s
0 0 .172 r
.61017 .50627 m .62586 .4352 L .62826 .43154 L p F P
0 g
s
.03 0 .262 r
.61467 .50048 m .63126 .42805 L .62826 .43154 L p F P
0 g
s
.03 0 .262 r
.61467 .50048 m .62826 .43154 L .61695 .48195 L F
0 0 .172 r
.6157 .48753 m .61017 .50627 L .62826 .43154 L F
.03 0 .262 r
.6157 .48753 m .62232 .43845 L .61803 .45847 L F
.61467 .50048 m .61695 .48195 L .6157 .48753 L F
.61695 .48195 m .62232 .43845 L .6157 .48753 L F
0 0 .172 r
.61217 .50331 m .61017 .50627 L p .6157 .48753 L F P
0 g
s
.03 0 .262 r
.61467 .50048 m .61803 .45847 L .61122 .49022 L F
.60722 .5089 m .61217 .50331 L p .61122 .49022 L F P
0 g
s
.03 0 .262 r
.61217 .50331 m .61467 .50048 L p .61122 .49022 L F P
0 g
s
.426 .841 .966 r
.59249 .57291 m .60526 .57118 L p .5936 .57355 L F P
0 g
s
.426 .841 .966 r
.60526 .57118 m .59397 .57377 L .5936 .57355 L F
.60971 .57325 m .59713 .5756 L .59652 .57525 L F
.60526 .57118 m .60971 .57325 L p .59652 .57525 L F P
0 g
s
.426 .841 .966 r
.60526 .57118 m .59652 .57525 L .59397 .57377 L F
.633 .514 .7 r
.62337 .5226 m .6032 .52835 L p .6169 .49877 L F P
0 g
s
.426 .841 .966 r
.60971 .57325 m .61081 .57375 L .59713 .5756 L p F P
0 g
s
0 0 .241 r
.59403 .60476 m .61017 .50627 L .61217 .50331 L p F P
0 g
s
0 0 .049 r
.63126 .42805 m .61467 .50048 L .61615 .4974 L p F P
0 g
s
0 0 .172 r
.63549 .42053 m .61817 .49441 L .61615 .4974 L p F P
0 g
s
0 0 .049 r
.62825 .44504 m .63126 .42805 L .61615 .4974 L F
0 0 .172 r
.61615 .4974 m .61217 .50331 L p .62674 .4516 L F P
0 g
s
0 0 .172 r
.63549 .42053 m .61615 .4974 L .62674 .4516 L F
.62825 .44504 m .61217 .50331 L .6157 .48753 L F
.63549 .42053 m .62674 .4516 L .62825 .44504 L F
.62674 .4516 m .61217 .50331 L .62825 .44504 L F
0 0 .049 r
.63306 .42423 m .63126 .42805 L p .62825 .44504 L F P
0 g
s
0 0 .172 r
.62826 .43154 m .63549 .42053 L p .6157 .48753 L F P
0 g
s
.798 .85 .395 r
.63666 .41659 m .63549 .42053 L p .64067 .4074 L F P
0 g
s
.798 .85 .395 r
.63549 .42053 m .65318 .38017 L p .65403 .3768 L F P
0 g
s
0 0 .049 r
.62062 .48811 m .63848 .41272 L .63666 .41659 L p F P
0 g
s
0 0 .049 r
.62062 .48811 m .63666 .41659 L .62434 .46904 L F
0 0 0 r
.63666 .41659 m .63438 .42828 L .63509 .42326 L F
.63438 .42828 m .63433 .4285 L .63509 .42326 L F
.63549 .42053 m .63666 .41659 L p .63509 .42326 L F P
0 g
s
.811 .77 .26 r
.63389 .43039 m .6374 .41551 L .63661 .41991 L F
0 0 0 r
.61817 .49441 m .63549 .42053 L p .63509 .42326 L F P
0 g
s
0 0 .049 r
.62062 .48811 m .62434 .46904 L .62297 .47484 L F
0 0 0 r
.62297 .47484 m .61817 .49441 L .63509 .42326 L F
.61912 .49123 m .61817 .49441 L p .62297 .47484 L F P
0 g
s
0 0 .049 r
.61615 .4974 m .61912 .49123 L p .62327 .47314 L F P
0 g
s
0 0 .049 r
.61912 .49123 m .62062 .48811 L p .62297 .47484 L F P
0 g
s
0 0 .049 r
.62297 .47484 m .62327 .47314 L .61912 .49123 L F
.811 .77 .26 r
.63848 .41272 m .62062 .48811 L .62103 .48487 L p F P
0 g
s
.811 .77 .26 r
.63389 .43039 m .63848 .41272 L .62103 .48487 L F
.63661 .41991 m .6374 .41551 L .63848 .41272 L F
.798 .85 .395 r
.639 .4087 m .63666 .41659 L p .63948 .40957 L F P
0 g
s
.798 .85 .395 r
.65061 .38183 m .639 .4087 L .63948 .40957 L F
.921 .905 .504 r
.64552 .38771 m .65685 .36738 L .64421 .39081 L F
.798 .85 .395 r
.65224 .37804 m .63666 .41659 L .64067 .4074 L F
.978 .906 .573 r
.65322 .35969 m .64005 .40066 L .64421 .39081 L F
.65155 .36375 m .64005 .40066 L .65322 .35969 L F
.64283 .38506 m .63976 .39256 L .64142 .39298 L F
.991 .879 .612 r
.65937 .35168 m .64057 .39659 L .63976 .39256 L p F P
0 g
s
.981 .841 .631 r
.64819 .34144 m .64226 .37395 L .65328 .32773 L F
.991 .879 .612 r
.63976 .39256 m .63812 .38449 L p .64045 .38477 L F P
0 g
s
.03 0 .262 r
.62826 .43154 m .62232 .43845 L p .61695 .48195 L F P
0 g
s
.157 0 .207 r
.62905 .41023 m .62025 .41599 L .62011 .41638 L F
.62911 .4101 m .62025 .41599 L .62905 .41023 L F
.61958 .43414 m .62905 .41023 L .62011 .41638 L F
.62911 .4101 m .62953 .40903 L .62468 .41304 L F
.999 .817 .526 r
.63357 .38395 m .62404 .44767 L .63812 .38449 L F
.63012 .40009 m .62404 .44767 L .63357 .38395 L F
.275 .042 .367 r
.61533 .44488 m .60737 .45077 L p .60552 .4935 L F P
0 g
s
.157 0 .207 r
.60737 .45077 m .61533 .44488 L p .61665 .42571 L F P
0 g
s
.157 0 .207 r
.61851 .43685 m .61665 .42571 L .61533 .44488 L F
.983 .783 .557 r
.6185 .42996 m .63085 .36884 L .63357 .38395 L F
.958 .746 .575 r
.63085 .36884 m .62526 .36145 L p .61759 .43447 L F P
0 g
s
.354 .047 .299 r
.60998 .42224 m .59882 .42771 L p .60423 .42548 L F P
0 g
s
.86 .671 .645 r
.60142 .3422 m .60507 .33643 L .60704 .34067 L F
.61047 .34804 m .60142 .3422 L p .60704 .34067 L F P
0 g
s
.847 .623 .599 r
.60142 .3422 m .59141 .33703 L p .5959 .34369 L F P
0 g
s
.847 .623 .599 r
.5959 .34369 m .60031 .35023 L .60142 .3422 L F
.873 .65 .596 r
.60142 .3422 m .61047 .34804 L p .59177 .41206 L F P
0 g
s
.901 .679 .592 r
.61005 .35072 m .60668 .42239 L .61709 .3623 L F
.60652 .37326 m .60668 .42239 L .61005 .35072 L F
.61845 .35449 m .61047 .34804 L p .61709 .3623 L F P
0 g
s
.873 .65 .596 r
.59177 .41206 m .61047 .34804 L .60652 .37326 L F
.901 .679 .592 r
.61047 .34804 m .60643 .34478 L p .61005 .35072 L F P
0 g
s
.901 .679 .592 r
.61005 .35072 m .61709 .3623 L .61047 .34804 L F
.86 .671 .645 r
.60507 .33643 m .61945 .31371 L .61047 .34804 L F
.91 .73 .646 r
.62526 .36145 m .61845 .35449 L p .63574 .32881 L F P
0 g
s
.885 .699 .646 r
.62191 .34265 m .62313 .33848 L .62473 .29352 L F
.86 .671 .645 r
.62859 .29884 m .61927 .29084 L .63 .29704 L F
.6142 .28649 m .62473 .29352 L p .61927 .29084 L F P
0 g
s
.86 .671 .645 r
.62473 .29352 m .63 .29704 L p .61927 .29084 L F P
0 g
s
.935 .764 .645 r
.63722 .3242 m .62799 .35296 L .63085 .36884 L F
.63722 .3242 m .63085 .36884 L .63475 .35762 L F
.817 .752 .791 r
.6419 .30964 m .634 .30128 L p .64382 .30747 L F P
0 g
s
.782 .698 .771 r
.63427 .26677 m .63458 .26627 L .62785 .26263 L p F P
0 g
s
.256 .598 .951 r
.62785 .26263 m .62851 .26264 L .63427 .26677 L F
.63996 .27086 m .62785 .26263 L p .63427 .26677 L F P
0 g
s
.806 .733 .783 r
.63572 .27717 m .634 .30128 L .63773 .29647 L F
.77 .682 .766 r
.59207 .26915 m .6144 .25535 L .61109 .2623 L F
.59285 .26712 m .6144 .25535 L .59207 .26915 L F
.782 .698 .771 r
.60785 .25243 m .6142 .28649 L .61726 .28113 L F
.794 .715 .776 r
.60887 .28293 m .63572 .27717 L .62638 .29107 L F
.62473 .29352 m .6142 .28649 L p .62638 .29107 L F P
0 g
s
.794 .715 .776 r
.6142 .28649 m .60887 .28293 L p .62638 .29107 L F P
0 g
s
.86 .671 .645 r
.60426 .32981 m .6142 .28649 L .62431 .29516 L F
.60426 .32981 m .62431 .29516 L .62072 .30886 L F
.828 .772 .8 r
.6419 .30964 m .64834 .3185 L p .64382 .30747 L F P
0 g
s
.91 .73 .646 r
.62191 .34265 m .64585 .31382 L .61845 .35449 L F
.885 .699 .646 r
.62072 .30886 m .61311 .33795 L .61939 .35126 L F
.62191 .34265 m .61939 .35126 L .62244 .35772 L F
.62072 .30886 m .61939 .35126 L .62191 .34265 L F
.86 .671 .645 r
.60426 .32981 m .63 .29704 L .60142 .3422 L F
.885 .699 .646 r
.62004 .2896 m .60983 .33101 L p .61311 .33795 L F P
0 g
s
.885 .699 .646 r
.62004 .2896 m .61311 .33795 L .62072 .30886 L F
.86 .671 .645 r
.62072 .30886 m .62431 .29516 L .62859 .29884 L F
.836 .645 .644 r
.61943 .29208 m .61966 .29117 L p .6142 .28649 L F P
0 g
s
.836 .645 .644 r
.61966 .29117 m .62004 .2896 L p .6142 .28649 L F P
0 g
s
.836 .645 .644 r
.6142 .28649 m .60252 .28026 L p .60819 .28423 L F P
0 g
s
.836 .645 .644 r
.60819 .28423 m .61943 .29208 L .6142 .28649 L F
.806 .733 .783 r
.63458 .26627 m .63437 .27918 L .63572 .27717 L F
.63437 .27918 m .634 .30128 L .63572 .27717 L F
.63458 .26627 m .62473 .29352 L .63405 .2981 L F
.794 .715 .776 r
.63 .29704 m .62473 .29352 L p .64528 .27512 L F P
0 g
s
.794 .715 .776 r
.63572 .27717 m .64528 .27512 L .62473 .29352 L F
.782 .698 .771 r
.62004 .2896 m .63427 .26677 L p .62785 .26263 L F P
0 g
s
.828 .772 .8 r
.65311 .29699 m .64382 .30747 L .64834 .3185 L F
.817 .752 .791 r
.634 .30128 m .63 .29704 L p .64885 .31064 L F P
0 g
s
.828 .772 .8 r
.64147 .30174 m .63864 .30515 L .6419 .30964 L p F P
0 g
s
.828 .772 .8 r
.64147 .30174 m .6419 .30964 L .64382 .30747 L F
.817 .752 .791 r
.64885 .31064 m .64585 .31382 L .6419 .30964 L p F P
0 g
s
.817 .752 .791 r
.64382 .30747 m .64885 .31064 L .6419 .30964 L F
.885 .699 .646 r
.60983 .33101 m .60643 .34478 L .61845 .35449 L p F P
0 g
s
.885 .699 .646 r
.61845 .35449 m .62244 .35772 L p .60983 .33101 L F P
0 g
s
.929 .711 .586 r
.61305 .36271 m .615 .35097 L .61845 .35449 L p F P
0 g
s
.929 .711 .586 r
.61845 .35449 m .62526 .36145 L p .62116 .36188 L F P
0 g
s
.929 .711 .586 r
.61305 .36271 m .61845 .35449 L .62116 .36188 L F
.873 .65 .596 r
.59667 .43626 m .58908 .4316 L p .59456 .42252 L F P
0 g
s
.267 0 .261 r
.59854 .45606 m .59412 .45871 L p .6011 .44848 L F P
0 g
s
.354 .047 .299 r
.60043 .45048 m .59606 .43693 L .58894 .4607 L F
.424 .11 .327 r
.59606 .43693 m .57867 .46465 L .58052 .45741 L F
.59518 .43986 m .57867 .46465 L .59606 .43693 L F
.354 .047 .299 r
.58894 .4607 m .59854 .45606 L p .60043 .45048 L F P
0 g
s
.53 .257 .446 r
.57513 .52885 m .58412 .46303 L .57867 .46465 L p F P
0 g
s
.482 .217 .435 r
.57233 .51573 m .56619 .53178 L .57867 .46465 L F
.671 .54 .696 r
.57276 .47018 m .55757 .50004 L .55666 .49038 L F
.53 .257 .446 r
.56785 .46786 m .56243 .46947 L p .56602 .48628 L F P
0 g
s
.575 .244 .371 r
.5566 .47032 m .56243 .46947 L p .55767 .4633 L F P
0 g
s
.571 .292 .454 r
.54714 .53578 m .55095 .47155 L .5566 .47032 L p F P
0 g
s
.571 .292 .454 r
.55331 .51555 m .54714 .53578 L .5566 .47032 L F
.608 .323 .459 r
.55683 .53409 m .56243 .46947 L .5566 .47032 L p F P
0 g
s
.608 .323 .459 r
.55683 .53409 m .5566 .47032 L .55294 .52057 L F
.53 .257 .446 r
.56243 .46947 m .55683 .53409 L .56141 .53278 L p F P
0 g
s
.571 .292 .454 r
.57352 .46663 m .56619 .53178 L .56141 .53278 L p F P
0 g
s
.571 .292 .454 r
.57352 .46663 m .56141 .53278 L .56602 .48628 L F
.53 .257 .446 r
.57053 .53017 m .57513 .52885 L p .57233 .51573 L F P
0 g
s
.53 .257 .446 r
.57513 .52885 m .57867 .46465 L .57233 .51573 L F
.653 .527 .697 r
.58231 .53273 m .6032 .52835 L p .58119 .52542 L F P
0 g
s
.427 .17 .419 r
.58412 .46303 m .57513 .52885 L .57918 .52696 L p F P
0 g
s
.482 .217 .435 r
.59412 .45871 m .58355 .52534 L .57918 .52696 L p F P
0 g
s
.482 .217 .435 r
.59412 .45871 m .57918 .52696 L .58529 .48544 L F
.427 .17 .419 r
.58617 .47951 m .58412 .46303 L .57918 .52696 L F
.482 .217 .435 r
.58617 .47951 m .57053 .53017 L .57233 .51573 L F
.59412 .45871 m .58529 .48544 L .58617 .47951 L F
.58529 .48544 m .57053 .53017 L .58617 .47951 L F
.427 .17 .419 r
.58894 .4607 m .58412 .46303 L p .58617 .47951 L F P
0 g
s
.482 .217 .435 r
.59088 .46719 m .57233 .51573 L .57867 .46465 L F
.59412 .45871 m .59088 .46719 L .58807 .4666 L F
.58872 .4622 m .58807 .4666 L .5834 .46563 L F
.59412 .45871 m .58807 .4666 L .58872 .4622 L F
.427 .17 .419 r
.59135 .52128 m .60339 .45372 L .59854 .45606 L p F P
0 g
s
.427 .17 .419 r
.59135 .52128 m .59854 .45606 L .59063 .50318 L F
.359 .112 .397 r
.58355 .52534 m .59412 .45871 L .59854 .45606 L p F P
0 g
s
.359 .112 .397 r
.59063 .50318 m .58355 .52534 L .59854 .45606 L F
.427 .17 .419 r
.59135 .52128 m .59063 .50318 L .58975 .5084 L F
.169 0 .324 r
.60137 .51411 m .59844 .51672 L p .60444 .49888 L F P
0 g
s
.275 .042 .367 r
.60444 .49888 m .60377 .47012 L .60137 .51411 L F
.60377 .47012 m .60339 .45372 L .60263 .47622 L F
.60377 .47012 m .60263 .47622 L .60137 .51411 L F
.60737 .45077 m .60339 .45372 L p .60377 .47012 L F P
0 g
s
.359 .112 .397 r
.60377 .47012 m .58975 .5084 L .60737 .45077 L F
.58975 .5084 m .58355 .52534 L .59063 .50318 L F
.58975 .5084 m .59063 .50318 L .60737 .45077 L F
.58727 .52319 m .58355 .52534 L p .58975 .5084 L F P
0 g
s
.427 .17 .419 r
.57918 .52696 m .58727 .52319 L p .58617 .47951 L F P
0 g
s
.427 .17 .419 r
.58727 .52319 m .59135 .52128 L p .58975 .5084 L F P
0 g
s
.427 .17 .419 r
.58975 .5084 m .58617 .47951 L .58727 .52319 L F
.482 .217 .435 r
.58894 .4607 m .59412 .45871 L p .5834 .46563 L F P
0 g
s
.427 .17 .419 r
.58975 .5084 m .58894 .4607 L .58617 .47951 L F
.59063 .50318 m .58894 .4607 L .58975 .5084 L F
.359 .112 .397 r
.59854 .45606 m .60737 .45077 L p .59063 .50318 L F P
0 g
s
.359 .112 .397 r
.59469 .51889 m .58727 .52319 L p .60377 .47012 L F P
0 g
s
.359 .112 .397 r
.60377 .47012 m .58727 .52319 L .58975 .5084 L F
.427 .17 .419 r
.59854 .45606 m .58894 .4607 L p .59063 .50318 L F P
0 g
s
.482 .217 .435 r
.57918 .52696 m .57053 .53017 L p .58529 .48544 L F P
0 g
s
.482 .217 .435 r
.57053 .53017 m .56619 .53178 L p .57233 .51573 L F P
0 g
s
.53 .257 .446 r
.56141 .53278 m .57053 .53017 L p .56602 .48628 L F P
0 g
s
.53 .257 .446 r
.57233 .51573 m .56602 .48628 L .57053 .53017 L F
.56602 .48628 m .56243 .46947 L .56141 .53278 L F
.608 .323 .459 r
.55191 .53478 m .55683 .53409 L p .55294 .52057 L F P
0 g
s
.686 .699 .856 r
.55436 .57729 m .55448 .57806 L .54149 .57813 L p F P
0 g
s
.348 .788 .963 r
.55177 .57823 m .54175 .57885 L .54153 .57824 L F
.55448 .57806 m .54183 .5791 L .54175 .57885 L F
.55448 .57806 m .55606 .58051 L p .54242 .58077 L F P
0 g
s
.348 .788 .963 r
.55448 .57806 m .54242 .58077 L .54183 .5791 L F
.55606 .58051 m .55645 .58111 L .54256 .58117 L p F P
0 g
s
.615 .343 .481 r
.55103 .62602 m .55683 .53409 L .55191 .53478 L p F P
0 g
s
.571 .292 .454 r
.56602 .48628 m .56312 .51554 L .54714 .53578 L F
.55191 .53478 m .54714 .53578 L p .56312 .51554 L F P
0 g
s
.571 .292 .454 r
.55294 .52057 m .54714 .53578 L .55331 .51555 L F
.647 .369 .484 r
.54714 .53578 m .54301 .55481 L .5416 .55247 L F
.615 .343 .481 r
.54006 .55511 m .5416 .55247 L .53723 .53682 L F
.54214 .53614 m .53723 .53682 L p .5416 .55247 L F P
0 g
s
.608 .323 .459 r
.53923 .47282 m .53723 .53682 L .54214 .53614 L p F P
0 g
s
.641 .351 .462 r
.55095 .47155 m .54714 .53578 L .54214 .53614 L p F P
0 g
s
.608 .323 .459 r
.54395 .49592 m .53923 .47282 L .54214 .53614 L F
.641 .351 .462 r
.54214 .53614 m .5322 .53684 L p .54395 .49592 L F P
0 g
s
.641 .351 .462 r
.55095 .47155 m .54214 .53614 L .54395 .49592 L F
.608 .323 .459 r
.54962 .52359 m .54395 .49592 L .54214 .53614 L F
.54214 .53614 m .55191 .53478 L p .54962 .52359 L F P
0 g
s
.691 .702 .856 r
.52847 .56848 m .52843 .56493 L .49268 .56279 L p F P
0 g
s
.686 .699 .856 r
.51648 .56422 m .54036 .5641 L p .54055 .56643 L F P
0 g
s
.682 .695 .856 r
.52859 .57825 m .5286 .57902 L .54149 .57813 L p F P
0 g
s
.686 .699 .856 r
.54055 .56643 m .51589 .57453 L .51648 .56422 L F
.54063 .56741 m .51589 .57453 L .54055 .56643 L F
.705 .599 .735 r
.54036 .5641 m .51648 .56422 L p .51739 .56348 L F P
0 g
s
.705 .599 .735 r
.53655 .54526 m .5167 .55702 L .51732 .53736 L F
.384 .815 .963 r
.54175 .57885 m .5286 .57902 L .54182 .57906 L F
.691 .702 .856 r
.5286 .57902 m .52859 .57825 L p .52782 .57825 L F P
0 g
s
.319 .763 .963 r
.52876 .58213 m .51568 .57826 L .51514 .58051 L F
.384 .815 .963 r
.5286 .57902 m .52873 .58152 L p .5424 .58072 L F P
0 g
s
.384 .815 .963 r
.54182 .57906 m .5286 .57902 L .5424 .58072 L F
.54242 .58077 m .52873 .58152 L .54256 .58117 L F
.319 .763 .963 r
.52876 .58213 m .5286 .57902 L .51568 .57826 L p F P
0 g
s
.319 .763 .963 r
.52876 .58213 m .52289 .58143 L .51773 .58135 L F
.384 .815 .963 r
.52873 .58152 m .52876 .58213 L .54256 .58117 L p F P
0 g
s
.647 .369 .484 r
.52703 .62841 m .5272 .5372 L .5322 .53684 L p F P
0 g
s
.677 .394 .485 r
.53516 .62811 m .53723 .53682 L .5322 .53684 L p F P
0 g
s
.647 .369 .484 r
.53132 .60866 m .52703 .62841 L .5322 .53684 L F
.719 .611 .735 r
.51732 .53736 m .49555 .53603 L p .51703 .54661 L F P
0 g
s
.677 .394 .485 r
.5222 .5369 m .51717 .53692 L p .52242 .56358 L F P
0 g
s
.319 .763 .963 r
.51773 .58135 m .51502 .58099 L .51498 .58116 L F
.348 .788 .963 r
.51519 .58028 m .50105 .58138 L .51568 .57826 L F
.50105 .58138 m .5027 .57832 L .51568 .57826 L p F P
0 g
s
.691 .702 .856 r
.51594 .57363 m .51633 .56685 L .49251 .56365 L F
.348 .788 .963 r
.51514 .58051 m .51494 .58131 L .50712 .581 L F
.719 .611 .735 r
.49268 .56279 m .51648 .56422 L p .49276 .56203 L F P
0 g
s
.348 .788 .963 r
.51494 .58131 m .50105 .58138 L p .50712 .581 L F P
0 g
s
.734 .44 .482 r
.5189 .62819 m .51717 .53692 L .51224 .53629 L p F P
0 g
s
.706 .417 .484 r
.51085 .62747 m .50723 .53598 L .51224 .53629 L p F P
0 g
s
.706 .417 .484 r
.51414 .60124 m .51085 .62747 L .51224 .53629 L F
.734 .44 .482 r
.5189 .62819 m .51224 .53629 L .51434 .60821 L F
.677 .394 .485 r
.51717 .53692 m .5189 .62819 L .52298 .62817 L p F P
0 g
s
.706 .417 .484 r
.5272 .5372 m .52703 .62841 L .52298 .62817 L p F P
0 g
s
.706 .417 .484 r
.5272 .5372 m .52298 .62817 L .52242 .56358 L F
.677 .394 .485 r
.53108 .62813 m .53516 .62811 L p .53132 .60866 L F P
0 g
s
.677 .394 .485 r
.53516 .62811 m .5322 .53684 L .53132 .60866 L F
.647 .369 .484 r
.54714 .53578 m .54318 .62732 L .53913 .62759 L p F P
0 g
s
.647 .369 .484 r
.54714 .53578 m .53913 .62759 L .54099 .57117 L F
.615 .343 .481 r
.53723 .53682 m .53516 .62811 L .53913 .62759 L p F P
0 g
s
.615 .343 .481 r
.54126 .56287 m .53723 .53682 L .53913 .62759 L F
.647 .369 .484 r
.54126 .56287 m .53108 .62813 L .53132 .60866 L F
.54714 .53578 m .54099 .57117 L .54126 .56287 L F
.54099 .57117 m .53108 .62813 L .54126 .56287 L F
.58 .313 .477 r
.54318 .62732 m .54714 .53578 L .55191 .53478 L p F P
0 g
s
.58 .313 .477 r
.54808 .60698 m .54318 .62732 L .55191 .53478 L F
.615 .343 .481 r
.54126 .56287 m .5416 .55247 L .54006 .55511 L F
.647 .369 .484 r
.54301 .55481 m .53132 .60866 L .5322 .53684 L F
.615 .343 .481 r
.54823 .60419 m .55191 .53478 L .5416 .55247 L F
.55103 .62602 m .55191 .53478 L .54823 .60419 L F
.54705 .62655 m .55103 .62602 L p .54808 .60698 L F P
0 g
s
.615 .343 .481 r
.54674 .59828 m .5416 .55247 L .54126 .56287 L F
.55103 .62602 m .54667 .592 L .54674 .59828 L F
.54667 .592 m .5416 .55247 L .54674 .59828 L F
.611 .331 .469 r
.53462 .76225 m .53581 .73258 L .53291 .73114 L F
.644 .359 .471 r
.53588 .73077 m .5389 .73058 L p .53462 .76225 L F P
0 g
s
.581 .316 .479 r
.5389 .73058 m .53922 .72295 L p .53945 .72359 L F P
0 g
s
.581 .316 .479 r
.54283 .70937 m .5389 .73058 L .54705 .62655 L F
.54318 .62732 m .54705 .62655 L p .53945 .72359 L F P
0 g
s
.581 .316 .479 r
.53922 .72295 m .54318 .62732 L p .53945 .72359 L F P
0 g
s
.58 .313 .477 r
.54705 .62655 m .54318 .62732 L p .54808 .60698 L F P
0 g
s
.648 .371 .486 r
.53913 .62759 m .54318 .62732 L p .53813 .65954 L F P
0 g
s
.648 .371 .486 r
.53922 .72295 m .5389 .73058 L .53588 .73077 L p F P
0 g
s
.616 .345 .484 r
.55103 .62602 m .54705 .62655 L p .54491 .72274 L F P
0 g
s
.616 .345 .484 r
.54475 .72968 m .54522 .72202 L p .54491 .72274 L F P
0 g
s
.616 .345 .484 r
.54522 .72202 m .55103 .62602 L p .54491 .72274 L F P
0 g
s
.575 .301 .464 r
.53853 .73764 m .5389 .73058 L .54178 .73004 L p F P
0 g
s
.611 .331 .469 r
.54421 .73676 m .54178 .73004 L .54148 .7348 L F
.616 .345 .484 r
.54475 .72968 m .54705 .62655 L .54322 .7018 L F
.611 .331 .469 r
.54421 .73676 m .54148 .7348 L .54144 .73538 L F
.648 .371 .486 r
.54318 .62732 m .53922 .72295 L p .53588 .73077 L F P
0 g
s
.648 .371 .486 r
.54318 .62732 m .53588 .73077 L .53813 .65954 L F
.616 .345 .484 r
.54475 .72968 m .53913 .62759 L .53813 .65954 L F
.54178 .73004 m .54475 .72968 L p .54283 .70937 L F P
0 g
s
.611 .331 .469 r
.54421 .73676 m .54475 .72968 L .54178 .73004 L p F P
0 g
s
.581 .316 .479 r
.551 .72074 m .5504 .72844 L .54751 .72897 L p F P
0 g
s
.575 .301 .464 r
.54751 .72897 m .5504 .72844 L p .54796 .73033 L F P
0 g
s
.535 .268 .456 r
.54751 .72897 m .54475 .72968 L p .54475 .7355 L F P
0 g
s
.575 .301 .464 r
.54796 .73033 m .54735 .7308 L .54751 .72897 L F
.535 .268 .456 r
.54473 .76073 m .54751 .72897 L .54475 .7355 L F
.5379 .81921 m .53781 .8203 L .53953 .81989 L p F P
0 g
s
.575 .301 .464 r
.54144 .73538 m .53853 .73764 L .54178 .73004 L F
.54144 .73538 m .53426 .81976 L .53853 .73764 L F
.53417 .82083 m .53422 .81975 L p .53426 .81976 L F P
0 g
s
.575 .301 .464 r
.53422 .81975 m .53853 .73764 L p .53426 .81976 L F P
0 g
s
.547 .235 .39 r
.529 .87007 m .53407 .82179 L p .53588 .82116 L F P
0 g
s
.587 .269 .397 r
.53025 .86989 m .53767 .82127 L p .53587 .82124 L F P
0 g
s
.587 .269 .397 r
.53025 .86989 m .53587 .82124 L .53027 .86488 L F
.53767 .82127 m .53781 .8203 L .53596 .82051 L p F P
0 g
s
.547 .235 .39 r
.53055 .8627 m .529 .87007 L .53588 .82116 L F
.53407 .82179 m .53417 .82083 L .53596 .82051 L p F P
0 g
s
.547 .235 .39 r
.53588 .82116 m .53407 .82179 L .53596 .82051 L F
.575 .301 .464 r
.53697 .80489 m .53417 .82083 L .54144 .73538 L F
.611 .331 .469 r
.53581 .73258 m .53588 .73077 L .53523 .73229 L F
.644 .359 .471 r
.5389 .73058 m .53422 .81975 L p .53231 .82013 L F P
0 g
s
.644 .359 .471 r
.5389 .73058 m .53231 .82013 L .53462 .76225 L F
.611 .331 .469 r
.54144 .73538 m .53588 .73077 L .53581 .73258 L F
.644 .359 .471 r
.52877 .80562 m .52854 .82089 L .52665 .82128 L F
.675 .384 .472 r
.52853 .82116 m .53043 .82116 L p .53032 .82015 L F P
0 g
s
.675 .384 .472 r
.53032 .82015 m .52877 .80562 L .52853 .82116 L F
.587 .269 .397 r
.53226 .82118 m .53228 .82094 L .5319 .82118 L F
.623 .3 .402 r
.53417 .82083 m .53034 .84525 L .53226 .82118 L F
.587 .269 .397 r
.53228 .82094 m .53043 .82116 L p .5319 .82118 L F P
0 g
s
.587 .269 .397 r
.53034 .84525 m .53226 .82118 L .53043 .82116 L F
.675 .384 .472 r
.53043 .82116 m .53291 .73114 L .52987 .73115 L p F P
0 g
s
.675 .384 .472 r
.53043 .82116 m .52987 .73115 L .52877 .80562 L F
.611 .331 .469 r
.53291 .73114 m .53043 .82116 L .53228 .82094 L p F P
0 g
s
.644 .359 .471 r
.53422 .81975 m .53228 .82094 L .53231 .82022 L F
.611 .331 .469 r
.53462 .76225 m .53291 .73114 L .53228 .82094 L F
.644 .359 .471 r
.53422 .81975 m .52853 .82116 L .52854 .82089 L F
.53422 .81975 m .53417 .82083 L .53228 .82094 L p F P
0 g
s
.611 .331 .469 r
.53596 .82051 m .53781 .8203 L p .53697 .80489 L F P
0 g
s
.611 .331 .469 r
.53779 .81928 m .54421 .73676 L .53581 .73258 L F
.53781 .8203 m .5379 .81921 L p .53779 .81928 L F P
0 g
s
.611 .331 .469 r
.5379 .81921 m .54421 .73676 L p .53779 .81928 L F P
0 g
s
.535 .268 .456 r
.54475 .72968 m .5379 .81921 L p .53953 .81989 L F P
0 g
s
.535 .268 .456 r
.54473 .76073 m .54475 .72968 L .53953 .81989 L F
.611 .331 .469 r
.53781 .8203 m .53581 .73258 L .53462 .76225 L F
.575 .301 .464 r
.54144 .81848 m .54133 .81957 L .53953 .81989 L p F P
0 g
s
.547 .235 .39 r
.53953 .81989 m .54133 .81957 L p .5411 .82053 L F P
0 g
s
.547 .235 .39 r
.5411 .82053 m .53523 .84455 L .53953 .81989 L F
.502 .195 .378 r
.53523 .84455 m .53953 .81989 L .53771 .82123 L F
.547 .235 .39 r
.53027 .86488 m .529 .87007 L .53055 .8627 L F
.623 .3 .402 r
.53417 .82083 m .529 .87007 L .52836 .87011 L p F P
0 g
s
.587 .269 .397 r
.53043 .82116 m .52772 .87018 L .52836 .87011 L p F P
0 g
s
.587 .269 .397 r
.52995 .8502 m .53043 .82116 L .52836 .87011 L F
.623 .3 .402 r
.53417 .82083 m .52836 .87011 L .53034 .84525 L F
.587 .269 .397 r
.52962 .86996 m .53025 .86989 L p .53027 .86488 L F P
0 g
s
.547 .235 .39 r
.54133 .81957 m .53145 .86965 L .53084 .86976 L p F P
0 g
s
.502 .195 .378 r
.53781 .8203 m .53025 .86989 L .53084 .86976 L p F P
0 g
s
.502 .195 .378 r
.53523 .84455 m .53781 .8203 L .53084 .86976 L F
.547 .235 .39 r
.53084 .86976 m .529 .87007 L p .53523 .84455 L F P
0 g
s
.547 .235 .39 r
.54133 .81957 m .53084 .86976 L .53523 .84455 L F
.449 .148 .361 r
.53145 .86965 m .54133 .81957 L .54295 .81907 L p F P
0 g
s
.449 .148 .361 r
.53313 .86431 m .53145 .86965 L .54295 .81907 L F
.502 .195 .378 r
.53313 .86431 m .53953 .81989 L .53523 .84455 L F
.53259 .86935 m .53361 .86209 L .53313 .86431 L F
.53361 .86209 m .53953 .81989 L .53313 .86431 L F
.532 .86949 m .53259 .86935 L p .53313 .86431 L F P
0 g
s
.502 .195 .378 r
.53259 .86935 m .54444 .81965 L p .53953 .81989 L F P
0 g
s
.502 .195 .378 r
.54444 .81965 m .54468 .81866 L .54295 .81907 L p F P
0 g
s
.535 .268 .456 r
.54295 .81907 m .54468 .81866 L p .54469 .80328 L F P
0 g
s
.489 .229 .446 r
.5504 .72844 m .55301 .72758 L p .54155 .81852 L F P
0 g
s
.489 .229 .446 r
.54469 .80328 m .54155 .81852 L .55301 .72758 L F
.54144 .81848 m .5504 .72844 L p .54155 .81852 L F P
0 g
s
.575 .301 .464 r
.5504 .72844 m .54144 .81848 L p .53596 .82051 L F P
0 g
s
.575 .301 .464 r
.5504 .72844 m .53596 .82051 L .53697 .80489 L F
.5504 .72844 m .54473 .76073 L .54735 .7308 L F
.535 .268 .456 r
.54469 .80328 m .54751 .72897 L .54473 .76073 L F
.54468 .81866 m .54535 .79723 L .54469 .80328 L F
.54535 .79723 m .54751 .72897 L .54469 .80328 L F
.54468 .81866 m .55491 .73405 L p .54751 .72897 L F P
0 g
s
.535 .268 .456 r
.55491 .73405 m .55578 .72687 L .55301 .72758 L p F P
0 g
s
.497 .246 .464 r
.5504 .72844 m .551 .72074 L p .55157 .72267 L F P
0 g
s
.542 .283 .473 r
.55578 .72687 m .55483 .70669 L .55317 .72567 L F
.497 .246 .464 r
.55301 .72758 m .5504 .72844 L p .55483 .70669 L F P
0 g
s
.581 .316 .479 r
.55861 .62425 m .551 .72074 L p .54751 .72897 L F P
0 g
s
.581 .316 .479 r
.55861 .62425 m .54751 .72897 L .55183 .66688 L F
.542 .283 .473 r
.54751 .72897 m .55578 .72687 L p .54522 .72202 L F P
0 g
s
.542 .283 .473 r
.55578 .72687 m .56583 .62201 L .56211 .62302 L p F P
0 g
s
.497 .246 .464 r
.55861 .62425 m .56211 .62302 L p .55157 .72267 L F P
0 g
s
.497 .246 .464 r
.55483 .70669 m .55157 .72267 L .56211 .62302 L F
.551 .72074 m .55861 .62425 L p .55157 .72267 L F P
0 g
s
.542 .283 .473 r
.55103 .62602 m .54522 .72202 L p .54791 .72325 L F P
0 g
s
.542 .283 .473 r
.5525 .65721 m .55103 .62602 L .54791 .72325 L F
.581 .316 .479 r
.5525 .65721 m .54178 .73004 L .54283 .70937 L F
.55861 .62425 m .55183 .66688 L .5525 .65721 L F
.55183 .66688 m .54178 .73004 L .5525 .65721 L F
.542 .283 .473 r
.55473 .62502 m .55103 .62602 L p .5525 .65721 L F P
0 g
s
.581 .316 .479 r
.55861 .62425 m .54767 .68329 L .54763 .67993 L F
.426 .841 .966 r
.55645 .58111 m .55458 .57823 L p .56728 .57645 L F P
0 g
s
.541 .281 .47 r
.55683 .53409 m .55103 .62602 L .55473 .62502 L p F P
0 g
s
.581 .316 .479 r
.54705 .62655 m .55473 .62502 L p .54763 .67993 L F P
0 g
s
.581 .316 .479 r
.55473 .62502 m .55861 .62425 L p .54763 .67993 L F P
0 g
s
.541 .281 .47 r
.56211 .62302 m .56583 .62201 L p .56391 .60322 L F P
0 g
s
.426 .841 .966 r
.56903 .57825 m .55645 .58111 L .56728 .57645 L F
.56928 .5785 m .57003 .57927 L .56197 .57998 L F
.57003 .57927 m .55645 .58111 L p .56197 .57998 L F P
0 g
s
.496 .243 .461 r
.56391 .60322 m .55861 .62425 L .57053 .53017 L F
.682 .695 .856 r
.58011 .57545 m .57773 .57496 L .56973 .57601 L F
.384 .815 .963 r
.58387 .57831 m .56928 .5785 L .56989 .57912 L F
.57268 .57896 m .56989 .57912 L .57003 .57927 L F
.57003 .57927 m .58387 .57831 L p .57268 .57896 L F P
0 g
s
.541 .281 .47 r
.56583 .62201 m .57513 .52885 L .57053 .53017 L p F P
0 g
s
.496 .243 .461 r
.55861 .62425 m .56619 .53178 L .57053 .53017 L p F P
0 g
s
.58 .313 .477 r
.56619 .53178 m .55861 .62425 L .55473 .62502 L p F P
0 g
s
.58 .313 .477 r
.56619 .53178 m .55473 .62502 L .55885 .56812 L F
.56619 .53178 m .55885 .56812 L .55946 .55975 L F
.541 .281 .47 r
.5611 .57581 m .55946 .55975 L .55473 .62502 L F
.55946 .55975 m .55683 .53409 L .55473 .62502 L F
.58 .313 .477 r
.55946 .55975 m .54705 .62655 L .54808 .60698 L F
.55885 .56812 m .54705 .62655 L .55946 .55975 L F
.55473 .62502 m .54705 .62655 L p .55885 .56812 L F P
0 g
s
.541 .281 .47 r
.56141 .53278 m .55683 .53409 L p .55946 .55975 L F P
0 g
s
.58 .313 .477 r
.55191 .53478 m .56619 .53178 L p .54808 .60698 L F P
0 g
s
.541 .281 .47 r
.57053 .53017 m .56141 .53278 L p .56391 .60322 L F P
0 g
s
.541 .281 .47 r
.56391 .60322 m .56141 .53278 L .55946 .55975 L F
.56583 .62201 m .57053 .53017 L .56391 .60322 L F
.496 .243 .461 r
.56211 .62302 m .55861 .62425 L p .56391 .60322 L F P
0 g
s
.496 .243 .461 r
.56633 .5936 m .56211 .62302 L .56391 .60322 L F
.444 .2 .448 r
.57513 .52885 m .56583 .62201 L .5691 .62056 L p F P
0 g
s
.496 .243 .461 r
.58355 .52534 m .57263 .61932 L .5691 .62056 L p F P
0 g
s
.496 .243 .461 r
.58355 .52534 m .5691 .62056 L .57532 .56283 L F
.444 .2 .448 r
.57624 .55434 m .57513 .52885 L .5691 .62056 L F
.496 .243 .461 r
.57624 .55434 m .56211 .62302 L .56633 .5936 L F
.58355 .52534 m .57532 .56283 L .57624 .55434 L F
.57532 .56283 m .56211 .62302 L .57624 .55434 L F
.444 .2 .448 r
.57918 .52696 m .57513 .52885 L p .57624 .55434 L F P
0 g
s
.496 .243 .461 r
.57053 .53017 m .58355 .52534 L p .56391 .60322 L F P
0 g
s
.672 .689 .858 r
.57989 .57468 m .58011 .57545 L .59249 .57291 L p F P
0 g
s
.472 .867 .969 r
.5936 .57355 m .58011 .57545 L .59383 .57369 L F
.59383 .57369 m .58011 .57545 L .5939 .57373 L F
.59644 .57521 m .58313 .57774 L .59713 .5756 L F
.58011 .57545 m .58313 .57774 L p .59644 .57521 L F P
0 g
s
.472 .867 .969 r
.5939 .57373 m .58011 .57545 L .59644 .57521 L F
.029 0 0 r
.58387 .57831 m .58432 .578 L p .58581 .57772 L F P
0 g
s
.472 .867 .969 r
.58313 .57774 m .58387 .57831 L .59713 .5756 L p F P
0 g
s
.381 .147 .43 r
.57263 .61932 m .58355 .52534 L .58727 .52319 L p F P
0 g
s
.444 .2 .448 r
.57891 .61622 m .59135 .52128 L .58727 .52319 L p F P
0 g
s
.444 .2 .448 r
.57891 .61622 m .58727 .52319 L .57899 .59035 L F
.381 .147 .43 r
.57811 .59754 m .57263 .61932 L .58727 .52319 L F
.444 .2 .448 r
.57811 .59754 m .57918 .52696 L .57624 .55434 L F
.57891 .61622 m .57899 .59035 L .57811 .59754 L F
.57899 .59035 m .57918 .52696 L .57811 .59754 L F
.381 .147 .43 r
.57563 .61767 m .57263 .61932 L p .57811 .59754 L F P
0 g
s
.444 .2 .448 r
.5691 .62056 m .57563 .61767 L p .57624 .55434 L F P
0 g
s
.444 .2 .448 r
.57563 .61767 m .57891 .61622 L p .57774 .58902 L F P
0 g
s
.444 .2 .448 r
.57774 .58902 m .57624 .55434 L .57563 .61767 L F
.435 .183 .432 r
.55401 .75808 m .55797 .72771 L .55578 .72687 L F
.489 .229 .446 r
.55821 .72586 m .56083 .725 L p .55401 .75808 L F P
0 g
s
.383 .151 .434 r
.56083 .725 m .5617 .7172 L p .56182 .7178 L F P
0 g
s
.383 .151 .434 r
.56556 .70266 m .56083 .725 L .57563 .61767 L F
.57263 .61932 m .57563 .61767 L p .56182 .7178 L F P
0 g
s
.383 .151 .434 r
.5617 .7172 m .57263 .61932 L p .56182 .7178 L F P
0 g
s
.497 .246 .464 r
.5691 .62056 m .57263 .61932 L p .56573 .65319 L F P
0 g
s
.497 .246 .464 r
.5617 .7172 m .56083 .725 L .55821 .72586 L p F P
0 g
s
.489 .229 .446 r
.54797 .81645 m .54781 .81756 L .54619 .81807 L p F P
0 g
s
.449 .148 .361 r
.54781 .81756 m .53366 .86899 L .53311 .86916 L p F P
0 g
s
.449 .148 .361 r
.54781 .81756 m .53311 .86916 L .5384 .84849 L F
.386 .092 .338 r
.54468 .81866 m .53259 .86935 L .53311 .86916 L p F P
0 g
s
.449 .148 .361 r
.54781 .81756 m .5384 .84849 L .53972 .84334 L F
.308 .023 .307 r
.53366 .86899 m .54781 .81756 L .54919 .81689 L p F P
0 g
s
.308 .023 .307 r
.53568 .86345 m .53366 .86899 L .54919 .81689 L F
.386 .092 .338 r
.53972 .84334 m .54468 .81866 L .53311 .86916 L F
.53972 .84334 m .54619 .81807 L .54449 .81961 L F
.54619 .81807 m .54468 .81866 L p .54449 .81961 L F P
0 g
s
.489 .229 .446 r
.54295 .81907 m .54133 .81957 L p .54469 .80328 L F P
0 g
s
.502 .195 .378 r
.54295 .81907 m .53953 .81989 L p .54444 .81965 L F P
0 g
s
.449 .148 .361 r
.54295 .81907 m .54619 .81807 L p .53313 .86431 L F P
0 g
s
.449 .148 .361 r
.54619 .81807 m .54781 .81756 L p .5475 .81855 L F P
0 g
s
.449 .148 .361 r
.5475 .81855 m .53313 .86431 L .54619 .81807 L F
.489 .229 .446 r
.56083 .725 m .54797 .81645 L p .54619 .81807 L F P
0 g
s
.489 .229 .446 r
.56083 .725 m .54619 .81807 L .55284 .76705 L F
.435 .183 .432 r
.55578 .72687 m .54481 .81755 L p .5463 .81724 L F P
0 g
s
.435 .183 .432 r
.55401 .75808 m .55578 .72687 L .5463 .81724 L F
.489 .229 .446 r
.55401 .75808 m .54295 .81907 L .54469 .80328 L F
.56083 .725 m .55284 .76705 L .55401 .75808 L F
.55284 .76705 m .54295 .81907 L .55401 .75808 L F
.386 .092 .338 r
.53465 .86857 m .55039 .81732 L p .549 .81757 L F P
0 g
s
.386 .092 .338 r
.53465 .86857 m .549 .81757 L .53634 .86116 L F
.53568 .86345 m .54619 .81807 L .53972 .84334 L F
.53465 .86857 m .53634 .86116 L .53568 .86345 L F
.53634 .86116 m .54619 .81807 L .53568 .86345 L F
.53413 .86877 m .53465 .86857 L p .53568 .86345 L F P
0 g
s
.211 0 .263 r
.55071 .8163 m .53465 .86857 L .53506 .86833 L p F P
0 g
s
.308 .023 .307 r
.55332 .81488 m .53553 .86811 L .53506 .86833 L p F P
0 g
s
.308 .023 .307 r
.55332 .81488 m .53506 .86833 L .54189 .84699 L F
.211 0 .263 r
.54359 .84168 m .55071 .8163 L .53506 .86833 L F
.308 .023 .307 r
.54359 .84168 m .53413 .86877 L .53568 .86345 L F
.55332 .81488 m .54189 .84699 L .54359 .84168 L F
.54189 .84699 m .53413 .86877 L .54359 .84168 L F
.211 0 .263 r
.55194 .81555 m .55071 .8163 L p .54359 .84168 L F P
0 g
s
.386 .092 .338 r
.55039 .81732 m .55071 .8163 L .54919 .81689 L p F P
0 g
s
.37 .128 .412 r
.55158 .80084 m .54781 .81756 L .56305 .72385 L F
.435 .183 .432 r
.55071 .8163 m .55158 .80084 L .54924 .81661 L F
.54919 .81689 m .55071 .8163 L p .54924 .81661 L F P
0 g
s
.37 .128 .412 r
.56083 .725 m .56305 .72385 L p .54799 .81646 L F P
0 g
s
.37 .128 .412 r
.54797 .81645 m .56083 .725 L p .54799 .81646 L F P
0 g
s
.435 .183 .432 r
.55071 .8163 m .56434 .73016 L p .55797 .72771 L F P
0 g
s
.435 .183 .432 r
.55071 .8163 m .55797 .72771 L .55401 .75808 L F
.37 .128 .412 r
.54919 .81689 m .54781 .81756 L p .55158 .80084 L F P
0 g
s
.386 .092 .338 r
.54919 .81689 m .54619 .81807 L p .549 .81757 L F P
0 g
s
.386 .092 .338 r
.55039 .81732 m .54919 .81689 L .549 .81757 L F
.308 .023 .307 r
.54919 .81689 m .55194 .81555 L p .53568 .86345 L F P
0 g
s
.308 .023 .307 r
.55194 .81555 m .55332 .81488 L p .55295 .81591 L F P
0 g
s
.308 .023 .307 r
.55295 .81591 m .53568 .86345 L .55194 .81555 L F
.289 .061 .384 r
.56549 .72284 m .55089 .81518 L p .55194 .81555 L F P
0 g
s
.289 .061 .384 r
.55089 .81518 m .55071 .8163 L .55194 .81555 L p F P
0 g
s
.37 .128 .412 r
.56972 .72041 m .55332 .81488 L .55194 .81555 L p F P
0 g
s
.37 .128 .412 r
.56972 .72041 m .55194 .81555 L .56054 .76357 L F
.289 .061 .384 r
.56205 .75443 m .56549 .72284 L .55194 .81555 L F
.37 .128 .412 r
.56205 .75443 m .54919 .81689 L .55158 .80084 L F
.56972 .72041 m .56054 .76357 L .56205 .75443 L F
.56054 .76357 m .54919 .81689 L .56205 .75443 L F
.289 .061 .384 r
.56749 .72157 m .56549 .72284 L p .56205 .75443 L F P
0 g
s
.435 .183 .432 r
.56434 .73016 m .55821 .72586 L .55797 .72771 L F
.445 .203 .451 r
.56549 .72284 m .57891 .61622 L .57563 .61767 L p F P
0 g
s
.445 .203 .451 r
.56549 .72284 m .57563 .61767 L .56648 .69491 L F
.497 .246 .464 r
.57263 .61932 m .5617 .7172 L p .55821 .72586 L F P
0 g
s
.497 .246 .464 r
.57263 .61932 m .55821 .72586 L .56471 .66299 L F
.445 .203 .451 r
.56583 .62201 m .55578 .72687 L .55821 .72586 L p F P
0 g
s
.445 .203 .451 r
.56471 .66299 m .56583 .62201 L .55821 .72586 L F
.56573 .65319 m .56583 .62201 L .56471 .66299 L F
.542 .283 .473 r
.55578 .72687 m .56211 .62302 L .55483 .70669 L F
.497 .246 .464 r
.56573 .65319 m .55301 .72758 L .55483 .70669 L F
.57263 .61932 m .56471 .66299 L .56573 .65319 L F
.56471 .66299 m .55301 .72758 L .56573 .65319 L F
.383 .151 .434 r
.56305 .72385 m .56083 .725 L p .56556 .70266 L F P
0 g
s
.445 .203 .451 r
.56556 .70266 m .56573 .65319 L .56305 .72385 L F
.56573 .65319 m .56471 .66299 L .56305 .72385 L F
.56549 .72284 m .5691 .62056 L .56573 .65319 L F
.56305 .72385 m .56549 .72284 L p .56556 .70266 L F P
0 g
s
.306 .087 .409 r
.56648 .71497 m .56549 .72284 L .56749 .72157 L p F P
0 g
s
.435 .183 .432 r
.56305 .72385 m .55821 .72586 L p .56232 .72875 L F P
0 g
s
.435 .183 .432 r
.56434 .73016 m .56305 .72385 L .56232 .72875 L F
.56434 .73016 m .56549 .72284 L .56305 .72385 L p F P
0 g
s
.37 .128 .412 r
.56305 .72385 m .56749 .72157 L p .55158 .80084 L F P
0 g
s
.37 .128 .412 r
.56749 .72157 m .56972 .72041 L p .56828 .7268 L F P
0 g
s
.37 .128 .412 r
.56828 .7268 m .55158 .80084 L .56749 .72157 L F
.306 .087 .409 r
.57891 .61622 m .56648 .71497 L p .56749 .72157 L F P
0 g
s
.383 .151 .434 r
.58462 .61273 m .56972 .72041 L .56749 .72157 L p F P
0 g
s
.383 .151 .434 r
.58462 .61273 m .56749 .72157 L .57591 .6576 L F
.306 .087 .409 r
.57723 .64762 m .57891 .61622 L .56749 .72157 L F
.383 .151 .434 r
.57723 .64762 m .56305 .72385 L .56556 .70266 L F
.58462 .61273 m .57591 .6576 L .57723 .64762 L F
.57591 .6576 m .56305 .72385 L .57723 .64762 L F
.306 .087 .409 r
.5816 .61439 m .57891 .61622 L p .57723 .64762 L F P
0 g
s
.383 .151 .434 r
.58462 .61273 m .57139 .67516 L .57164 .67176 L F
.303 .083 .405 r
.59135 .52128 m .57891 .61622 L .5816 .61439 L p F P
0 g
s
.383 .151 .434 r
.57563 .61767 m .5816 .61439 L p .57164 .67176 L F P
0 g
s
.383 .151 .434 r
.5816 .61439 m .58462 .61273 L p .57164 .67176 L F P
0 g
s
.381 .147 .43 r
.59844 .51672 m .58462 .61273 L .5816 .61439 L p F P
0 g
s
.303 .083 .405 r
.59086 .54684 m .59135 .52128 L .5816 .61439 L F
.381 .147 .43 r
.5816 .61439 m .57563 .61767 L p .58967 .55551 L F P
0 g
s
.381 .147 .43 r
.59844 .51672 m .5816 .61439 L .58967 .55551 L F
.59086 .54684 m .57563 .61767 L .57811 .59754 L F
.59844 .51672 m .58967 .55551 L .59086 .54684 L F
.58967 .55551 m .57563 .61767 L .59086 .54684 L F
.303 .083 .405 r
.59469 .51889 m .59135 .52128 L p .59086 .54684 L F P
0 g
s
.381 .147 .43 r
.58727 .52319 m .59844 .51672 L p .57811 .59754 L F P
0 g
s
.205 .003 .369 r
.58462 .61273 m .59844 .51672 L .60137 .51411 L p F P
0 g
s
.303 .083 .405 r
.58968 .6089 m .60474 .5117 L .60137 .51411 L p F P
0 g
s
.303 .083 .405 r
.58968 .6089 m .60137 .51411 L .59113 .58281 L F
.205 .003 .369 r
.59004 .59017 m .58462 .61273 L .60137 .51411 L F
.303 .083 .405 r
.59004 .59017 m .59469 .51889 L .59086 .54684 L F
.58968 .6089 m .59113 .58281 L .59004 .59017 L F
.59113 .58281 m .59469 .51889 L .59004 .59017 L F
.205 .003 .369 r
.58697 .61074 m .58462 .61273 L p .59004 .59017 L F P
0 g
s
.303 .083 .405 r
.5816 .61439 m .58697 .61074 L p .59056 .56285 L F P
0 g
s
.303 .083 .405 r
.58697 .61074 m .58968 .6089 L p .5902 .58162 L F P
0 g
s
.303 .083 .405 r
.5902 .58162 m .59056 .56285 L .58697 .61074 L F
.087 0 .201 r
.53553 .86811 m .55332 .81488 L .55439 .81407 L p F P
0 g
s
.211 0 .263 r
.53631 .8676 m .55525 .81439 L p .55415 .81478 L F P
0 g
s
.211 0 .263 r
.53631 .8676 m .55415 .81478 L .5386 .85997 L F
.55525 .81439 m .55563 .81333 L .55439 .81407 L p F P
0 g
s
.087 0 .201 r
.53779 .86233 m .53553 .86811 L .55439 .81407 L F
.187 0 .344 r
.55733 .7977 m .55332 .81488 L .57146 .71903 L F
.289 .061 .384 r
.55563 .81333 m .57206 .72525 L p .57056 .72404 L F P
0 g
s
.289 .061 .384 r
.55563 .81333 m .57056 .72404 L .55846 .79142 L F
.55563 .81333 m .55846 .79142 L .55733 .7977 L F
.187 0 .344 r
.55439 .81407 m .55332 .81488 L p .55733 .7977 L F P
0 g
s
.187 0 .344 r
.56972 .72041 m .57146 .71903 L p .55354 .81375 L F P
0 g
s
.187 0 .344 r
.55332 .81488 m .55352 .81375 L p .55354 .81375 L F P
0 g
s
.187 0 .344 r
.55352 .81375 m .56972 .72041 L p .55354 .81375 L F P
0 g
s
.289 .061 .384 r
.55194 .81555 m .55563 .81333 L p .56205 .75443 L F P
0 g
s
.211 0 .263 r
.55439 .81407 m .55194 .81555 L p .55415 .81478 L F P
0 g
s
.211 0 .263 r
.55525 .81439 m .55439 .81407 L .55415 .81478 L F
.53779 .86233 m .55194 .81555 L .54359 .84168 L F
.53631 .8676 m .5386 .85997 L .53779 .86233 L F
.5386 .85997 m .55194 .81555 L .53779 .86233 L F
.087 0 .201 r
.53589 .86784 m .53553 .86811 L p .53779 .86233 L F P
0 g
s
.211 0 .263 r
.53506 .86833 m .53631 .8676 L p .54359 .84168 L F P
0 g
s
0 0 .115 r
.55563 .81333 m .53631 .8676 L .53661 .86732 L p F P
0 g
s
.087 0 .201 r
.5576 .81165 m .53698 .86705 L .53661 .86732 L p F P
0 g
s
.087 0 .201 r
.5576 .81165 m .53661 .86732 L .54466 .84516 L F
0 0 .115 r
.54666 .83964 m .55563 .81333 L .53661 .86732 L F
.087 0 .201 r
.54666 .83964 m .53589 .86784 L .53779 .86233 L F
.5576 .81165 m .54466 .84516 L .54666 .83964 L F
.54466 .84516 m .53589 .86784 L .54666 .83964 L F
.55653 .81246 m .5576 .81165 L p .55718 .81273 L F P
0 g
s
0 0 .115 r
.55653 .81246 m .55563 .81333 L p .54666 .83964 L F P
0 g
s
.087 0 .201 r
.55718 .81273 m .53779 .86233 L .55653 .81246 L F
.187 0 .344 r
.57666 .71487 m .5576 .81165 L .55653 .81246 L p F P
0 g
s
0 0 .204 r
.57666 .71487 m .57782 .71331 L p .55786 .81051 L F P
0 g
s
0 0 .204 r
.56167 .79398 m .55786 .81051 L .57782 .71331 L F
.5576 .81165 m .55783 .81049 L p .55786 .81051 L F P
0 g
s
0 0 .204 r
.55783 .81049 m .57666 .71487 L p .55786 .81051 L F P
0 g
s
.187 0 .344 r
.57666 .71487 m .55653 .81246 L .56669 .75929 L F
.054 0 .287 r
.57346 .71775 m .55584 .81218 L p .55653 .81246 L F P
0 g
s
.054 0 .287 r
.56848 .74993 m .57346 .71775 L .55653 .81246 L F
.187 0 .344 r
.56848 .74993 m .55439 .81407 L .55733 .7977 L F
.57666 .71487 m .56669 .75929 L .56848 .74993 L F
.56669 .75929 m .55439 .81407 L .56848 .74993 L F
.054 0 .287 r
.57492 .71627 m .57346 .71775 L p .56848 .74993 L F P
0 g
s
.289 .061 .384 r
.57206 .72525 m .57346 .71775 L .57146 .71903 L p F P
0 g
s
.208 .008 .374 r
.56972 .72041 m .57082 .71247 L p .57088 .71306 L F P
0 g
s
.306 .087 .409 r
.57346 .71775 m .58968 .6089 L .58697 .61074 L p F P
0 g
s
.306 .087 .409 r
.57346 .71775 m .58697 .61074 L .57568 .68954 L F
.208 .008 .374 r
.57455 .69744 m .56972 .72041 L .58697 .61074 L F
.58462 .61273 m .58697 .61074 L p .57088 .71306 L F P
0 g
s
.208 .008 .374 r
.57082 .71247 m .58462 .61273 L p .57088 .71306 L F P
0 g
s
.306 .087 .409 r
.57455 .69744 m .5816 .61439 L .57723 .64762 L F
.57346 .71775 m .57568 .68954 L .57455 .69744 L F
.57568 .68954 m .5816 .61439 L .57455 .69744 L F
.208 .008 .374 r
.57146 .71903 m .56972 .72041 L p .57455 .69744 L F P
0 g
s
.306 .087 .409 r
.56749 .72157 m .57346 .71775 L p .57723 .64762 L F P
0 g
s
.082 0 .323 r
.57465 .70972 m .57346 .71775 L .57492 .71627 L p F P
0 g
s
.289 .061 .384 r
.57146 .71903 m .56749 .72157 L p .57056 .72404 L F P
0 g
s
.289 .061 .384 r
.57206 .72525 m .57146 .71903 L .57056 .72404 L F
.187 0 .344 r
.57146 .71903 m .57492 .71627 L p .55733 .7977 L F P
0 g
s
.187 0 .344 r
.57492 .71627 m .57666 .71487 L p .57512 .72146 L F P
0 g
s
.187 0 .344 r
.57512 .72146 m .55733 .7977 L .57492 .71627 L F
.082 0 .323 r
.58968 .6089 m .57465 .70972 L p .57492 .71627 L F P
0 g
s
.208 .008 .374 r
.59403 .60476 m .57666 .71487 L .57492 .71627 L p F P
0 g
s
.208 .008 .374 r
.59403 .60476 m .57492 .71627 L .58491 .65094 L F
.082 0 .323 r
.58646 .64075 m .58968 .6089 L .57492 .71627 L F
.208 .008 .374 r
.58646 .64075 m .57146 .71903 L .57455 .69744 L F
.59403 .60476 m .58491 .65094 L .58646 .64075 L F
.58491 .65094 m .57146 .71903 L .58646 .64075 L F
.082 0 .323 r
.59166 .60677 m .58968 .6089 L p .58646 .64075 L F P
0 g
s
.208 .008 .374 r
.59403 .60476 m .5805 .66912 L .58088 .66567 L F
.077 0 .317 r
.60474 .5117 m .58968 .6089 L .59166 .60677 L p F P
0 g
s
.208 .008 .374 r
.58697 .61074 m .59166 .60677 L p .58088 .66567 L F P
0 g
s
.208 .008 .374 r
.59166 .60677 m .59403 .60476 L p .58088 .66567 L F P
0 g
s
.205 .003 .369 r
.61017 .50627 m .59403 .60476 L .59166 .60677 L p F P
0 g
s
.077 0 .317 r
.60266 .53757 m .60474 .5117 L .59166 .60677 L F
.205 .003 .369 r
.59166 .60677 m .58697 .61074 L p .60125 .54645 L F P
0 g
s
.205 .003 .369 r
.61017 .50627 m .59166 .60677 L .60125 .54645 L F
.60266 .53757 m .58697 .61074 L .59004 .59017 L F
.61017 .50627 m .60125 .54645 L .60266 .53757 L F
.60125 .54645 m .58697 .61074 L .60266 .53757 L F
.077 0 .317 r
.60722 .5089 m .60474 .5117 L p .60266 .53757 L F P
0 g
s
.205 .003 .369 r
.60137 .51411 m .61017 .50627 L p .59004 .59017 L F P
0 g
s
.077 0 .317 r
.59761 .60036 m .61467 .50048 L .61217 .50331 L p F P
0 g
s
.077 0 .317 r
.59761 .60036 m .61217 .50331 L .6004 .57386 L F
0 0 .241 r
.59914 .58141 m .59403 .60476 L .61217 .50331 L F
.077 0 .317 r
.59914 .58141 m .60722 .5089 L .60266 .53757 L F
.59761 .60036 m .6004 .57386 L .59914 .58141 L F
.6004 .57386 m .60722 .5089 L .59914 .58141 L F
0 0 .241 r
.59562 .60251 m .59403 .60476 L p .59914 .58141 L F P
0 g
s
.077 0 .317 r
.59166 .60677 m .59562 .60251 L p .60136 .55376 L F P
0 g
s
.077 0 .317 r
.59562 .60251 m .59761 .60036 L p .59983 .57276 L F P
0 g
s
.077 0 .317 r
.59983 .57276 m .60136 .55376 L .59562 .60251 L F
.054 0 .287 r
.55943 .80874 m .57771 .71952 L .57679 .71845 L F
.55921 .80988 m .55945 .8087 L p .55943 .80874 L F P
0 g
s
.054 0 .287 r
.55945 .8087 m .57771 .71952 L p .55943 .80874 L F P
0 g
s
.054 0 .287 r
.55921 .80988 m .57679 .71845 L .56295 .78755 L F
.55921 .80988 m .57492 .71627 L .56848 .74993 L F
.55831 .81074 m .55921 .80988 L p .56167 .79398 L F P
0 g
s
0 0 .115 r
.53751 .86647 m .55878 .81099 L p .55803 .81148 L F P
0 g
s
0 0 0 r
.53698 .86705 m .55719 .81274 L p .558 .81157 L F P
0 g
s
0 0 0 r
.53937 .86102 m .53698 .86705 L .558 .81157 L F
.55719 .81274 m .5576 .81165 L .55831 .81074 L p F P
0 g
s
0 0 .115 r
.53751 .86647 m .55803 .81148 L .5403 .85856 L F
.55878 .81099 m .55921 .80988 L .55831 .81074 L p F P
0 g
s
0 0 .204 r
.56069 .80683 m .56044 .80802 L .55972 .80893 L p F P
0 g
s
0 0 0 r
.55972 .80893 m .56044 .80802 L p .55978 .80898 L F P
0 g
s
0 0 0 r
.55978 .80898 m .55961 .80922 L .55972 .80893 L F
.55961 .80922 m .558 .81157 L .55972 .80893 L F
.5488 .8373 m .55972 .80893 L .55881 .81093 L F
.55972 .80893 m .55921 .80988 L p .55881 .81093 L F P
0 g
s
0 0 .115 r
.55878 .81099 m .55831 .81074 L .55803 .81148 L F
.53937 .86102 m .55653 .81246 L .54666 .83964 L F
.53751 .86647 m .5403 .85856 L .53937 .86102 L F
.5403 .85856 m .55653 .81246 L .53937 .86102 L F
0 0 0 r
.53721 .86675 m .53698 .86705 L p .53937 .86102 L F P
0 g
s
0 0 .115 r
.53661 .86732 m .53751 .86647 L p .54666 .83964 L F P
0 g
s
0 0 0 r
.55921 .80988 m .53751 .86647 L .53769 .86616 L p F P
0 g
s
0 0 0 r
.56044 .80802 m .53792 .86586 L .53769 .86616 L p F P
0 g
s
0 0 0 r
.56044 .80802 m .53769 .86616 L .54658 .84306 L F
.5488 .8373 m .55921 .80988 L .53769 .86616 L F
.56044 .80802 m .53721 .86675 L .53937 .86102 L F
.56044 .80802 m .53937 .86102 L .558 .81157 L F
.58131 .70863 m .58184 .70696 L p .56069 .80685 L F P
0 g
s
0 0 0 r
.56438 .78985 m .56069 .80685 L .58184 .70696 L F
.56069 .80683 m .58131 .70863 L p .56069 .80685 L F P
0 g
s
0 0 .204 r
.58131 .70863 m .56069 .80683 L p .55972 .80893 L F P
0 g
s
0 0 .204 r
.58131 .70863 m .55972 .80893 L .571 .75439 L F
0 0 .087 r
.57929 .71182 m .55945 .8087 L p .55991 .80805 L F P
0 g
s
0 0 .087 r
.57299 .74478 m .57929 .71182 L .55991 .80805 L F
0 0 .204 r
.57299 .74478 m .55831 .81074 L .56167 .79398 L F
.58131 .70863 m .571 .75439 L .57299 .74478 L F
.571 .75439 m .55831 .81074 L .57299 .74478 L F
0 0 .087 r
.58014 .7102 m .57929 .71182 L p .57299 .74478 L F P
0 g
s
.054 0 .287 r
.57771 .71952 m .57929 .71182 L .57782 .71331 L p F P
0 g
s
0 0 .248 r
.57666 .71487 m .57794 .70676 L p .57793 .70735 L F P
0 g
s
.082 0 .323 r
.57929 .71182 m .59761 .60036 L .59562 .60251 L p F P
0 g
s
.082 0 .323 r
.57929 .71182 m .59562 .60251 L .58267 .68316 L F
0 0 .248 r
.58137 .69124 m .57666 .71487 L .59562 .60251 L F
.59403 .60476 m .59562 .60251 L p .57793 .70735 L F P
0 g
s
0 0 .248 r
.57794 .70676 m .59403 .60476 L p .57793 .70735 L F P
0 g
s
.082 0 .323 r
.58137 .69124 m .59166 .60677 L .58646 .64075 L F
.57929 .71182 m .58267 .68316 L .58137 .69124 L F
.58267 .68316 m .59166 .60677 L .58137 .69124 L F
0 0 .248 r
.57782 .71331 m .57666 .71487 L p .58137 .69124 L F P
0 g
s
.082 0 .323 r
.57492 .71627 m .57929 .71182 L p .58646 .64075 L F P
0 g
s
0 0 .141 r
.58064 .70362 m .57929 .71182 L .58014 .7102 L p F P
0 g
s
.054 0 .287 r
.57782 .71331 m .57492 .71627 L p .57679 .71845 L F P
0 g
s
.054 0 .287 r
.57771 .71952 m .57782 .71331 L .57679 .71845 L F
0 0 .204 r
.57782 .71331 m .58014 .7102 L p .56167 .79398 L F P
0 g
s
0 0 .204 r
.58014 .7102 m .58131 .70863 L p .57975 .71542 L F P
0 g
s
0 0 .204 r
.57975 .71542 m .56167 .79398 L .58014 .7102 L F
0 0 .141 r
.59761 .60036 m .58064 .70362 L p .58014 .7102 L F P
0 g
s
0 0 .248 r
.60039 .59574 m .58131 .70863 L .58014 .7102 L p F P
0 g
s
0 0 .248 r
.60039 .59574 m .58014 .7102 L .59126 .64331 L F
0 0 .141 r
.593 .63286 m .59761 .60036 L .58014 .7102 L F
0 0 .248 r
.593 .63286 m .57782 .71331 L .58137 .69124 L F
.60039 .59574 m .59126 .64331 L .593 .63286 L F
.59126 .64331 m .57782 .71331 L .593 .63286 L F
0 0 .141 r
.59879 .59801 m .59761 .60036 L p .593 .63286 L F P
0 g
s
0 0 .248 r
.60039 .59574 m .58717 .66209 L .58767 .65858 L F
0 0 .132 r
.61467 .50048 m .59761 .60036 L .59879 .59801 L p F P
0 g
s
0 0 .248 r
.59562 .60251 m .59879 .59801 L p .58767 .65858 L F P
0 g
s
0 0 .248 r
.59879 .59801 m .60039 .59574 L p .58767 .65858 L F P
0 g
s
0 0 .241 r
.61817 .49441 m .60039 .59574 L .59879 .59801 L p F P
0 g
s
0 0 .132 r
.61106 .5269 m .61467 .50048 L .59879 .59801 L F
0 0 .241 r
.59879 .59801 m .59562 .60251 L p .60948 .53604 L F P
0 g
s
0 0 .241 r
.61817 .49441 m .59879 .59801 L .60948 .53604 L F
.61106 .5269 m .59562 .60251 L .59914 .58141 L F
.61817 .49441 m .60948 .53604 L .61106 .5269 L F
.60948 .53604 m .59562 .60251 L .61106 .5269 L F
0 0 .132 r
.61615 .4974 m .61467 .50048 L p .61106 .5269 L F P
0 g
s
0 0 .241 r
.61817 .49441 m .61317 .51725 L .61261 .50946 L F
.61615 .4974 m .61817 .49441 L p .61261 .50946 L F P
0 g
s
.521 .89 .971 r
.61081 .57375 m .60526 .57118 L .61722 .56786 L p F P
0 g
s
0 0 0 r
.60039 .59574 m .61817 .49441 L .61912 .49123 L p F P
0 g
s
0 0 .132 r
.60232 .59096 m .62062 .48811 L .61912 .49123 L p F P
0 g
s
0 0 .132 r
.60232 .59096 m .61912 .49123 L .60632 .56387 L F
0 0 0 r
.60495 .57163 m .60039 .59574 L .61912 .49123 L F
0 0 .241 r
.61317 .51725 m .59914 .58141 L .61217 .50331 L F
0 0 .132 r
.60495 .57163 m .61615 .4974 L .61106 .5269 L F
.60232 .59096 m .60632 .56387 L .60495 .57163 L F
.60632 .56387 m .61615 .4974 L .60495 .57163 L F
0 0 0 r
.60113 .59332 m .60039 .59574 L p .60495 .57163 L F P
0 g
s
0 0 .132 r
.59879 .59801 m .60113 .59332 L p .6088 .54343 L F P
0 g
s
0 0 .132 r
.60113 .59332 m .60232 .59096 L p .60616 .56281 L F P
0 g
s
0 0 .132 r
.60616 .56281 m .6088 .54343 L .60113 .59332 L F
0 0 .087 r
.56127 .8061 m .58102 .71325 L p .58073 .71224 L F P
0 g
s
0 0 .087 r
.56127 .8061 m .58073 .71224 L .56577 .78325 L F
.58102 .71325 m .5827 .70532 L .58184 .70696 L p F P
0 g
s
0 0 0 r
.58131 .70863 m .58272 .70032 L p .58264 .70092 L F P
0 g
s
0 0 .141 r
.5827 .70532 m .60113 .59332 L .58709 .67607 L F
0 0 0 r
.58568 .68435 m .58131 .70863 L .60113 .59332 L F
.60039 .59574 m .60113 .59332 L p .58264 .70092 L F P
0 g
s
0 0 0 r
.58272 .70032 m .60039 .59574 L p .58264 .70092 L F P
0 g
s
0 0 .141 r
.58568 .68435 m .59879 .59801 L .593 .63286 L F
.5827 .70532 m .58709 .67607 L .58568 .68435 L F
.58709 .67607 m .59879 .59801 L .58568 .68435 L F
.5827 .70532 m .60232 .59096 L .60113 .59332 L p F P
0 g
s
0 0 0 r
.58184 .70696 m .58131 .70863 L p .58568 .68435 L F P
0 g
s
0 0 .141 r
.58014 .7102 m .5827 .70532 L p .593 .63286 L F P
0 g
s
0 0 .087 r
.58184 .70696 m .58014 .7102 L p .58073 .71224 L F P
0 g
s
0 0 .087 r
.58102 .71325 m .58184 .70696 L .58073 .71224 L F
.56127 .8061 m .58014 .7102 L .57299 .74478 L F
0 0 0 r
.58184 .70696 m .5829 .70362 L p .56438 .78985 L F P
0 g
s
0 0 .087 r
.56127 .8061 m .56438 .78985 L .56081 .80675 L F
.785 .743 .221 r
.5827 .70532 m .56153 .8049 L p .56138 .80512 L F P
0 g
s
.785 .743 .221 r
.57535 .73922 m .5827 .70532 L .56138 .80512 L F
0 0 0 r
.56075 .80705 m .56044 .80802 L p .56438 .78985 L F P
0 g
s
0 0 0 r
.56044 .80802 m .56069 .80683 L p .56069 .80685 L F P
0 g
s
0 0 .087 r
.55972 .80893 m .56127 .8061 L p .55945 .8087 L F P
0 g
s
0 0 0 r
.58344 .70194 m .56196 .80293 L p .56075 .80705 L F P
0 g
s
0 0 0 r
.56196 .80293 m .5617 .80415 L .56138 .80512 L p F P
0 g
s
0 0 0 r
.56138 .80512 m .56075 .80705 L p .56196 .80293 L F P
0 g
s
0 0 0 r
.57535 .73922 m .56075 .80705 L .56438 .78985 L F
.58344 .70194 m .57326 .7491 L .57535 .73922 L F
.57326 .7491 m .56075 .80705 L .57535 .73922 L F
.5829 .70362 m .58184 .70696 L p .59465 .63502 L F P
0 g
s
.752 .701 .162 r
.60232 .59096 m .58414 .69691 L p .5829 .70362 L F P
0 g
s
.752 .701 .162 r
.59649 .62429 m .60232 .59096 L .5829 .70362 L F
0 0 0 r
.59649 .62429 m .58184 .70696 L .58568 .68435 L F
.60336 .58606 m .59465 .63502 L .59649 .62429 L F
.59465 .63502 m .58184 .70696 L .59649 .62429 L F
.59107 .65438 m .58568 .68435 L .60113 .59332 L F
.752 .701 .162 r
.60261 .5885 m .60232 .59096 L p .59649 .62429 L F P
0 g
s
0 0 0 r
.60336 .58606 m .59107 .65438 L .59167 .65078 L F
.60113 .59332 m .60261 .5885 L p .59167 .65078 L F P
0 g
s
.758 .708 .172 r
.62062 .48811 m .60232 .59096 L .60261 .5885 L p F P
0 g
s
0 0 0 r
.60261 .5885 m .60336 .58606 L p .59167 .65078 L F P
0 g
s
0 0 0 r
.60336 .58606 m .60261 .5885 L p .61372 .52728 L F P
0 g
s
0 0 0 r
.60261 .5885 m .60113 .59332 L p .61395 .5247 L F P
0 g
s
.758 .708 .172 r
.61562 .51529 m .62062 .48811 L .60261 .5885 L F
0 0 0 r
.62199 .48166 m .60261 .5885 L .61395 .5247 L F
.61562 .51529 m .60113 .59332 L .60495 .57163 L F
.62199 .48166 m .61395 .5247 L .61562 .51529 L F
.61395 .5247 m .60113 .59332 L .61562 .51529 L F
.758 .708 .172 r
.62103 .48487 m .62062 .48811 L p .61562 .51529 L F P
0 g
s
0 0 0 r
.61912 .49123 m .62199 .48166 L p .60495 .57163 L F P
0 g
s
0 0 0 r
.62103 .48487 m .61912 .49123 L p .62289 .47576 L F P
0 g
s
0 0 0 r
.63227 .43722 m .62103 .48487 L .62289 .47576 L F
.758 .708 .172 r
.60858 .55328 m .61849 .49728 L .62103 .48487 L F
0 0 .132 r
.61912 .49123 m .61615 .4974 L p .60632 .56387 L F P
0 g
s
.921 .905 .504 r
.639 .4087 m .64005 .40066 L p .64103 .40118 L F P
0 g
s
.921 .905 .504 r
.64351 .39192 m .65224 .37804 L .639 .4087 L F
.798 .85 .395 r
.65061 .38183 m .63666 .41659 L .65224 .37804 L F
.65669 .36776 m .64067 .4074 L .65405 .37671 L F
.65224 .37804 m .64067 .4074 L .65669 .36776 L F
.65572 .37143 m .65405 .37671 L .65458 .37549 L F
.65782 .3639 m .65405 .37671 L .65572 .37143 L F
0 0 0 r
.63848 .41272 m .64193 .40451 L .64067 .4074 L F
.63848 .41272 m .65458 .37549 L .64193 .40451 L F
.63666 .41659 m .63848 .41272 L p .64067 .4074 L F P
0 g
s
.841 .943 .889 r
.65458 .37549 m .65573 .3759 L .65345 .37956 L F
.852 .919 .876 r
.65458 .37549 m .65318 .38017 L p .65648 .37619 L F P
0 g
s
.852 .919 .876 r
.65885 .37334 m .65664 .37445 L .65648 .37619 L F
.65664 .37445 m .65458 .37549 L .65648 .37619 L F
.841 .943 .889 r
.65458 .37549 m .65675 .37089 L p .65885 .37334 L F P
0 g
s
0 0 0 r
.63848 .41272 m .65675 .37089 L .65458 .37549 L p F P
0 g
s
.921 .905 .504 r
.65675 .37089 m .63848 .41272 L .639 .4087 L p F P
0 g
s
.798 .85 .395 r
.65458 .37549 m .6574 .36611 L p .65685 .36738 L F P
0 g
s
.921 .905 .504 r
.65224 .37804 m .65675 .37089 L .639 .4087 L F
.811 .77 .26 r
.639 .4087 m .63848 .41272 L p .6374 .41551 L F P
0 g
s
.798 .85 .395 r
.64019 .40471 m .639 .4087 L p .64174 .40218 L F P
0 g
s
.798 .85 .395 r
.65883 .36136 m .64019 .40471 L p .64174 .40218 L F P
0 g
s
.811 .77 .26 r
.64005 .40066 m .639 .4087 L p .63871 .40816 L F P
0 g
s
.938 .833 .388 r
.64019 .40471 m .64005 .40066 L p .63912 .40647 L F P
0 g
s
.798 .85 .395 r
.65883 .36136 m .639 .4087 L .65061 .38183 L F
0 0 0 r
.64019 .40471 m .61912 .49123 L .62297 .47484 L F
.63666 .41659 m .64019 .40471 L p .63762 .41519 L F P
0 g
s
.811 .77 .26 r
.6374 .41551 m .63871 .40816 L .639 .4087 L F
0 0 0 r
.62199 .48166 m .62103 .48487 L p .62488 .46877 L F P
0 g
s
0 0 0 r
.64019 .40471 m .62199 .48166 L p .62488 .46877 L F P
0 g
s
0 0 .049 r
.62327 .47314 m .62825 .44504 L .61615 .4974 L F
.938 .833 .388 r
.64005 .40066 m .63976 .39256 L p .63908 .40016 L F P
0 g
s
0 0 0 r
.64019 .40471 m .62103 .48487 L .63227 .43722 L F
.938 .833 .388 r
.63908 .40016 m .63842 .40762 L .64005 .40066 L F
0 0 0 r
.63433 .4285 m .62297 .47484 L .63509 .42326 L F
0 0 .049 r
.63666 .41659 m .63598 .41804 L p .63099 .44074 L F P
0 g
s
0 0 .049 r
.63598 .41804 m .63306 .42423 L p .63099 .44074 L F P
0 g
s
0 0 .049 r
.62434 .46904 m .63099 .44074 L .63306 .42423 L F
0 0 0 r
.63762 .41519 m .63431 .42868 L .63666 .41659 L F
.811 .77 .26 r
.62681 .45717 m .64005 .40066 L .6374 .41551 L F
.938 .833 .388 r
.63842 .40762 m .63776 .41498 L .64005 .40066 L F
0 0 0 r
.63389 .43039 m .62297 .47484 L .63433 .4285 L F
0 0 .049 r
.62297 .47484 m .63306 .42423 L .62825 .44504 L F
.62434 .46904 m .63306 .42423 L .62297 .47484 L F
.811 .77 .26 r
.62103 .48487 m .62184 .4784 L p .63389 .43039 L F P
0 g
s
.811 .77 .26 r
.62583 .46135 m .63389 .43039 L .62184 .4784 L F
.992 .84 .474 r
.62464 .44583 m .63456 .41517 L .62153 .47189 L F
.62153 .47189 m .62009 .46541 L p .62315 .45833 L F P
0 g
s
0 0 .132 r
.6088 .54343 m .61106 .5269 L .59879 .59801 L F
0 0 .241 r
.61217 .50331 m .61615 .4974 L p .61261 .50946 L F P
0 g
s
.992 .84 .474 r
.62404 .44767 m .63631 .39264 L .63914 .39526 L F
.938 .833 .388 r
.63914 .39526 m .62708 .45601 L .63821 .40848 L F
.63456 .41517 m .62583 .46135 L .63914 .39526 L F
.811 .77 .26 r
.62583 .46135 m .6374 .41551 L .63389 .43039 L F
.62681 .45717 m .6374 .41551 L .62583 .46135 L F
.938 .833 .388 r
.62583 .46135 m .62199 .48166 L .62708 .45601 L F
.62583 .46135 m .62708 .45601 L .63914 .39526 L F
.62153 .47189 m .62199 .48166 L p .62632 .45874 L F P
0 g
s
.811 .77 .26 r
.62225 .47513 m .62681 .45717 L .62583 .46135 L F
.999 .817 .526 r
.63812 .38449 m .63515 .37655 L p .63357 .38395 L F P
0 g
s
.96 .802 .641 r
.63515 .37655 m .62867 .36494 L p .64819 .34144 L F P
0 g
s
.981 .841 .631 r
.63812 .36013 m .63364 .37253 L .63515 .37655 L p F P
0 g
s
.981 .841 .631 r
.63515 .37655 m .63812 .38449 L p .63812 .36854 L F P
0 g
s
.981 .841 .631 r
.63812 .36013 m .63515 .37655 L .63812 .36854 L F
.991 .879 .612 r
.63812 .38449 m .64088 .37996 L .64045 .38477 L F
.64088 .37996 m .65322 .35969 L .63976 .39256 L F
.64226 .37395 m .65322 .35969 L .63812 .38449 L F
.96 .802 .641 r
.63475 .35762 m .65307 .32829 L .64819 .34144 L F
.63606 .35384 m .65307 .32829 L .63475 .35762 L F
.63606 .35384 m .64775 .32019 L .65307 .32829 L F
.64507 .31611 m .65328 .32773 L .65307 .32829 L F
.981 .841 .631 r
.65156 .32292 m .63812 .36013 L p .63851 .3675 L F P
0 g
s
.981 .841 .631 r
.64819 .34144 m .63851 .3675 L .63961 .38846 L F
.65156 .32292 m .63851 .3675 L .64819 .34144 L F
.64226 .37395 m .64371 .37025 L .65328 .32773 L F
.65666 .33723 m .65328 .32773 L p .65288 .32949 L F P
0 g
s
.96 .802 .641 r
.65328 .32773 m .65574 .33235 L p .65307 .32829 L F P
0 g
s
.981 .841 .631 r
.63812 .38449 m .63961 .38846 L p .63812 .36013 L F P
0 g
s
.981 .841 .631 r
.65288 .32949 m .64371 .37025 L .65666 .33723 L F
.96 .802 .641 r
.65574 .33235 m .6373 .38041 L .63515 .37655 L p F P
0 g
s
.96 .802 .641 r
.64819 .34144 m .65574 .33235 L .63515 .37655 L F
.992 .84 .474 r
.6349 .39133 m .6373 .38041 L .63812 .38449 L p F P
0 g
s
.992 .84 .474 r
.63812 .38449 m .63976 .39256 L p .63813 .39215 L F P
0 g
s
.992 .84 .474 r
.6349 .39133 m .63812 .38449 L .63813 .39215 L F
.6349 .39133 m .63976 .39256 L .63914 .39526 L F
.938 .833 .388 r
.63976 .39256 m .63961 .38846 L p .63914 .39526 L F P
0 g
s
.938 .833 .388 r
.63914 .39526 m .63776 .41498 L .63976 .39256 L F
.992 .84 .474 r
.63976 .39256 m .64057 .39659 L p .63914 .39526 L F P
0 g
s
.992 .84 .474 r
.63456 .41517 m .63914 .39526 L .64057 .39659 L F
.62404 .44767 m .63914 .39526 L .63456 .41517 L F
.938 .833 .388 r
.63456 .41517 m .62153 .47189 L .62632 .45874 L F
.63961 .38846 m .62153 .47189 L .63456 .41517 L F
.63961 .38846 m .62137 .46859 L .62153 .47189 L p F P
0 g
s
.911 .794 .315 r
.62038 .47846 m .60716 .56127 L .61849 .49728 L F
.61606 .50326 m .60716 .56127 L .62038 .47846 L F
.077 0 .317 r
.61217 .50331 m .60722 .5089 L p .6004 .57386 L F P
0 g
s
1 .803 .484 r
.61431 .47881 m .6056 .5508 L .62009 .46541 L F
.61226 .49137 m .6056 .5508 L .61431 .47881 L F
.169 0 .324 r
.60722 .5089 m .60137 .51411 L p .61668 .46478 L F P
0 g
s
.929 .711 .586 r
.60771 .41644 m .61693 .36326 L .62471 .36437 L F
.873 .65 .596 r
.59362 .41641 m .60652 .37326 L .59667 .43626 L F
.59177 .41206 m .60652 .37326 L .58908 .4316 L F
.901 .679 .592 r
.59863 .39752 m .59328 .43366 L .59667 .43626 L p F P
0 g
s
.901 .679 .592 r
.59667 .43626 m .60339 .4414 L p .60189 .42758 L F P
0 g
s
.901 .679 .592 r
.59863 .39752 m .59667 .43626 L .60189 .42758 L F
.571 .292 .454 r
.56785 .46786 m .57352 .46663 L p .56602 .48628 L F P
0 g
s
.53 .257 .446 r
.57867 .46465 m .56785 .46786 L p .57233 .51573 L F P
0 g
s
.482 .217 .435 r
.57867 .46465 m .58894 .4607 L p .5834 .46563 L F P
0 g
s
.482 .162 .347 r
.56785 .46786 m .57867 .46465 L p .56893 .46262 L F P
0 g
s
.424 .11 .327 r
.58894 .4607 m .57867 .46465 L p .59518 .43986 L F P
0 g
s
.849 .614 .583 r
.57873 .44873 m .57922 .52367 L .58908 .4316 L F
.57749 .46221 m .57922 .52367 L .57873 .44873 L F
.532 .206 .361 r
.57438 .43615 m .58095 .4347 L p .57431 .43651 L F P
0 g
s
.482 .162 .347 r
.58667 .43332 m .58691 .43237 L .58053 .43474 L F
.821 .598 .601 r
.5716 .42398 m .57613 .4088 L .57741 .41407 L F
.58069 .42749 m .5716 .42398 L p .57741 .41407 L F P
0 g
s
.53 .257 .446 r
.57233 .51573 m .56785 .46786 L .56602 .48628 L F
.445 .203 .451 r
.57563 .61767 m .5691 .62056 L p .56648 .69491 L F P
0 g
s
.445 .203 .451 r
.5691 .62056 m .56583 .62201 L p .56573 .65319 L F P
0 g
s
.497 .246 .464 r
.56211 .62302 m .5691 .62056 L p .56028 .67995 L F P
0 g
s
.497 .246 .464 r
.56573 .65319 m .56028 .67995 L .5691 .62056 L F
.444 .2 .448 r
.58727 .52319 m .57918 .52696 L p .57899 .59035 L F P
0 g
s
.496 .243 .461 r
.5691 .62056 m .56211 .62302 L p .57532 .56283 L F P
0 g
s
.275 .042 .367 r
.59469 .51889 m .60137 .51411 L p .60263 .47622 L F P
0 g
s
.267 0 .261 r
.60737 .45077 m .59854 .45606 L p .61551 .4288 L F P
0 g
s
.988 .772 .524 r
.61387 .45287 m .61753 .45904 L p .61423 .47419 L F P
0 g
s
.988 .772 .524 r
.60157 .53226 m .61387 .45287 L .61423 .47419 L F
.963 .737 .548 r
.61387 .45287 m .60914 .44696 L p .60157 .53226 L F P
0 g
s
.963 .737 .548 r
.60432 .4802 m .60026 .54072 L .60914 .44696 L F
.988 .772 .524 r
.60026 .54072 m .61753 .45904 L .61226 .49137 L F
.60157 .53226 m .61753 .45904 L .60026 .54072 L F
.077 0 .317 r
.60136 .55376 m .60266 .53757 L .59166 .60677 L F
.983 .817 .418 r
.60291 .57867 m .6017 .57377 L p .61039 .53204 L F P
0 g
s
.983 .817 .418 r
.61039 .53204 m .61436 .51297 L .60291 .57867 L F
.758 .708 .172 r
.6125 .53228 m .61562 .51529 L .60261 .5885 L F
.60261 .5885 m .60321 .5836 L p .6125 .53228 L F P
0 g
s
1 .803 .484 r
.62009 .46541 m .61753 .45904 L p .61431 .47881 L F P
0 g
s
.929 .711 .586 r
.60668 .42239 m .62471 .36437 L .62066 .38588 L F
.60771 .41644 m .62471 .36437 L .60668 .42239 L F
.267 0 .261 r
.61492 .41963 m .60964 .42324 L .60998 .42224 L F
.958 .746 .575 r
.62066 .38588 m .61759 .43447 L .62526 .36145 L F
.929 .711 .586 r
.62526 .36145 m .62867 .36494 L p .62471 .36437 L F P
0 g
s
.929 .711 .586 r
.61305 .36271 m .62526 .36145 L .62471 .36437 L F
.958 .746 .575 r
.61986 .39012 m .61396 .42139 L .61551 .44477 L F
.62066 .38588 m .61551 .44477 L .61759 .43447 L F
.61986 .39012 m .61551 .44477 L .62066 .38588 L F
.901 .679 .592 r
.60643 .34478 m .59863 .39752 L p .60339 .4414 L F P
0 g
s
.901 .679 .592 r
.60643 .34478 m .60339 .4414 L .60668 .42239 L F
.929 .711 .586 r
.60048 .43859 m .62066 .38588 L .61339 .4244 L F
.60914 .44696 m .60339 .4414 L p .61339 .4244 L F P
0 g
s
.929 .711 .586 r
.60339 .4414 m .60048 .43859 L p .61339 .4244 L F P
0 g
s
.935 .703 .563 r
.59134 .53152 m .60339 .4414 L .60619 .46729 L F
.958 .746 .575 r
.61313 .40887 m .60675 .44398 L .60914 .44696 L p F P
0 g
s
.958 .746 .575 r
.60914 .44696 m .61387 .45287 L p .61364 .43901 L F P
0 g
s
.958 .746 .575 r
.61313 .40887 m .60914 .44696 L .61364 .43901 L F
.935 .703 .563 r
.60619 .46729 m .60482 .4546 L .60838 .4522 L F
.60339 .4414 m .60914 .44696 L p .60482 .4546 L F P
0 g
s
.963 .737 .548 r
.60026 .54072 m .60157 .53226 L .60914 .44696 L F
.935 .703 .563 r
.60914 .44696 m .61202 .44975 L p .60838 .4522 L F P
0 g
s
.935 .703 .563 r
.60482 .4546 m .60914 .44696 L .60838 .4522 L F
.303 .083 .405 r
.60137 .51411 m .59469 .51889 L p .59113 .58281 L F P
0 g
s
.963 .737 .548 r
.60432 .4802 m .5966 .56432 L .60026 .54072 L F
.935 .703 .563 r
.59134 .53152 m .60619 .46729 L .60432 .4802 L F
.963 .737 .548 r
.60283 .49047 m .5966 .56432 L .60432 .4802 L F
.59276 .55987 m .5966 .56432 L p .60087 .51375 L F P
0 g
s
.963 .737 .548 r
.60283 .49047 m .59276 .55987 L .60087 .51375 L F
.208 .008 .374 r
.5805 .66912 m .57455 .69744 L .58697 .61074 L F
.306 .087 .409 r
.58697 .61074 m .5816 .61439 L p .57568 .68954 L F P
0 g
s
.383 .151 .434 r
.56749 .72157 m .56305 .72385 L p .57591 .6576 L F P
0 g
s
.988 .772 .524 r
.59959 .56897 m .5966 .56432 L p .60687 .51648 L F P
0 g
s
.082 0 .323 r
.59562 .60251 m .59166 .60677 L p .58267 .68316 L F P
0 g
s
.208 .008 .374 r
.57492 .71627 m .57146 .71903 L p .58491 .65094 L F P
0 g
s
0 0 .141 r
.60113 .59332 m .59879 .59801 L p .58709 .67607 L F P
0 g
s
0 0 .248 r
.58014 .7102 m .57782 .71331 L p .59126 .64331 L F P
0 g
s
0 0 .248 r
.58717 .66209 m .58137 .69124 L .59562 .60251 L F
.911 .794 .315 r
.60291 .57867 m .60321 .5836 L p .61085 .53521 L F P
0 g
s
.911 .794 .315 r
.61436 .51297 m .60291 .57867 L .61085 .53521 L F
.907 .789 .307 r
.60321 .5836 m .60291 .57867 L p .59357 .63743 L F P
0 g
s
.907 .789 .307 r
.59672 .61545 m .59045 .65627 L .60291 .57867 L F
1 .801 .479 r
.6017 .57377 m .59959 .56897 L p .58741 .66102 L F P
0 g
s
.907 .789 .307 r
.59045 .65627 m .58726 .67706 L .60291 .57867 L F
.58726 .67706 m .58752 .67554 L .60291 .57867 L F
.752 .701 .162 r
.58726 .67706 m .60261 .5885 L .59649 .62429 L F
.907 .789 .307 r
.59357 .63743 m .58752 .67554 L .60321 .5836 L F
1 .801 .479 r
.58857 .64847 m .58599 .66972 L .59959 .56897 L F
.58599 .66972 m .58741 .66102 L .59959 .56897 L F
.982 .814 .412 r
.58599 .66972 m .60291 .57867 L .59672 .61545 L F
.988 .771 .52 r
.58049 .69019 m .57825 .687 L p .59186 .61804 L F P
0 g
s
.988 .771 .52 r
.58189 .66268 m .59364 .60674 L .57825 .687 L F
1 .801 .479 r
.59364 .60674 m .58209 .69348 L .58599 .66972 L F
.59186 .61804 m .58209 .69348 L .59364 .60674 L F
.964 .736 .545 r
.5966 .56432 m .59276 .55987 L p .58322 .65376 L F P
0 g
s
.964 .736 .545 r
.58734 .59857 m .58189 .66268 L .59276 .55987 L F
.58189 .66268 m .58322 .65376 L .59276 .55987 L F
.935 .702 .56 r
.57537 .68395 m .57191 .6811 L p .58616 .60696 L F P
0 g
s
.935 .702 .56 r
.57277 .67447 m .58616 .60696 L .57191 .6811 L F
.877 .641 .579 r
.58269 .55183 m .57658 .54834 L p .58666 .50205 L F P
0 g
s
.877 .641 .579 r
.58666 .50205 m .59128 .48083 L .58269 .55183 L F
.906 .67 .57 r
.57724 .59844 m .57191 .6811 L .57316 .67139 L F
.57669 .60318 m .57191 .6811 L .57724 .59844 L F
.445 .203 .451 r
.55821 .72586 m .56305 .72385 L p .56471 .66299 L F P
0 g
s
.877 .64 .576 r
.56789 .67846 m .56336 .67608 L p .57807 .59136 L F P
0 g
s
.497 .246 .464 r
.55821 .72586 m .55301 .72758 L p .56471 .66299 L F P
0 g
s
.877 .64 .576 r
.56598 .65081 m .57807 .59136 L .56336 .67608 L F
.823 .589 .585 r
.56984 .54526 m .56256 .54264 L p .57234 .48997 L F P
0 g
s
.542 .283 .473 r
.56211 .62302 m .55473 .62502 L p .55479 .67406 L F P
0 g
s
.542 .283 .473 r
.55483 .70669 m .56211 .62302 L .55479 .67406 L F
.541 .281 .47 r
.56391 .60322 m .56303 .59464 L .56211 .62302 L F
.497 .246 .464 r
.56028 .67995 m .55483 .70669 L .56211 .62302 L F
.541 .281 .47 r
.55473 .62502 m .56211 .62302 L p .5611 .57581 L F P
0 g
s
.541 .281 .47 r
.56303 .59464 m .5611 .57581 L .56211 .62302 L F
.849 .613 .581 r
.55838 .67398 m .56336 .67608 L p .56519 .59749 L F P
0 g
s
.542 .283 .473 r
.55483 .70669 m .55473 .62502 L .5525 .65721 L F
.55317 .72567 m .5525 .65721 L .54791 .72325 L F
.55483 .70669 m .5525 .65721 L .55317 .72567 L F
.54522 .72202 m .54475 .72968 L .54751 .72897 L p F P
0 g
s
.581 .316 .479 r
.54751 .72897 m .54178 .73004 L p .55183 .66688 L F P
0 g
s
.823 .588 .583 r
.55838 .67398 m .553 .6722 L p .56626 .58547 L F P
0 g
s
.823 .588 .583 r
.55489 .64658 m .56626 .58547 L .553 .6722 L F
.616 .345 .484 r
.54705 .62655 m .53913 .62759 L p .54322 .7018 L F P
0 g
s
.581 .316 .479 r
.54767 .68329 m .54283 .70937 L .54705 .62655 L F
.615 .343 .481 r
.53913 .62759 m .54705 .62655 L p .54126 .56287 L F P
0 g
s
.615 .343 .481 r
.54808 .60698 m .54126 .56287 L .54705 .62655 L F
.647 .369 .484 r
.54214 .53614 m .54714 .53578 L p .5416 .55247 L F P
0 g
s
.615 .343 .481 r
.55191 .53478 m .54214 .53614 L p .5416 .55247 L F P
0 g
s
.571 .292 .454 r
.56141 .53278 m .55191 .53478 L p .56312 .51554 L F P
0 g
s
.571 .292 .454 r
.56602 .48628 m .55294 .52057 L .56785 .46786 L F
.55294 .52057 m .55331 .51555 L .56785 .46786 L F
.641 .351 .462 r
.55095 .47155 m .54395 .49592 L .54421 .49018 L F
.608 .323 .459 r
.54504 .47198 m .53923 .47282 L p .54421 .49018 L F P
0 g
s
.608 .323 .459 r
.54421 .49018 m .53923 .47282 L .54395 .49592 L F
.641 .351 .462 r
.53327 .47285 m .54504 .47198 L p .53243 .52274 L F P
0 g
s
.641 .351 .462 r
.54504 .47198 m .55095 .47155 L p .54421 .49018 L F P
0 g
s
.641 .351 .462 r
.54421 .49018 m .53243 .52274 L .54504 .47198 L F
.608 .323 .459 r
.55294 .52057 m .54421 .49018 L .55191 .53478 L F
.54421 .49018 m .54395 .49592 L .55191 .53478 L F
.5566 .47032 m .54504 .47198 L p .55294 .52057 L F P
0 g
s
.608 .323 .459 r
.55294 .52057 m .54504 .47198 L .54421 .49018 L F
.641 .351 .462 r
.54421 .49018 m .5322 .53684 L .53243 .52274 L F
.54395 .49592 m .5322 .53684 L .54421 .49018 L F
.571 .292 .454 r
.5566 .47032 m .56785 .46786 L p .55331 .51555 L F P
0 g
s
.772 .543 .588 r
.55481 .54051 m .54671 .53889 L p .55537 .47757 L F P
0 g
s
.772 .543 .588 r
.54779 .51357 m .55537 .47757 L .54671 .53889 L F
.647 .369 .484 r
.54214 .53614 m .5416 .55247 L .53698 .54479 L F
.5322 .53684 m .54214 .53614 L p .53698 .54479 L F P
0 g
s
.614 .277 .376 r
.54504 .47198 m .53327 .47285 L p .54552 .46686 L F P
0 g
s
.614 .277 .376 r
.54715 .44965 m .53352 .46593 L .54794 .44135 L F
.53352 .46593 m .5336 .46361 L .54794 .44135 L F
.54794 .44135 m .53433 .44306 L .54797 .441 L F
.53433 .44306 m .53433 .44294 L .54797 .441 L F
.54114 .44197 m .53433 .44294 L .53436 .44203 L F
.54794 .44135 m .5336 .46361 L .53433 .44306 L F
.092 .65 .744 r
.54797 .441 m .53436 .44203 L p .53642 .44191 L F P
0 g
s
.614 .277 .376 r
.53436 .44203 m .54797 .441 L p .54114 .44197 L F P
0 g
s
.796 .575 .601 r
.56836 .33732 m .57356 .40403 L .58056 .33263 L F
.772 .553 .602 r
.56836 .33732 m .56267 .33187 L .56884 .33114 L F
.55688 .32632 m .569 .32904 L p .56267 .33187 L F P
0 g
s
.772 .553 .602 r
.56267 .33187 m .569 .32904 L .56884 .33114 L F
.796 .575 .601 r
.56698 .35539 m .57356 .40403 L .56836 .33732 L F
.772 .553 .602 r
.55292 .39874 m .55688 .32632 L .56836 .33732 L F
.55292 .39874 m .56836 .33732 L .56698 .35539 L F
.769 .578 .641 r
.569 .32904 m .55688 .32632 L p .5736 .29228 L F P
0 g
s
.847 .623 .599 r
.59104 .34013 m .59262 .40595 L .60017 .35123 L F
.873 .65 .596 r
.58908 .4316 m .59362 .41641 L .59456 .42252 L F
.847 .623 .599 r
.58834 .36291 m .59328 .43366 L .59104 .34013 L F
.821 .598 .601 r
.57356 .40403 m .58834 .36291 L .5716 .42398 L F
.847 .623 .599 r
.59104 .34013 m .60467 .3567 L .59141 .33703 L F
.836 .645 .644 r
.60426 .32981 m .60522 .32562 L .60239 .28091 L F
.60239 .28091 m .61943 .29208 L .60252 .28026 L F
.813 .621 .643 r
.60743 .28495 m .60219 .28197 L .60887 .28293 L F
.60219 .28197 m .59603 .27847 L .60243 .28069 L F
.60219 .28197 m .60243 .28069 L .60887 .28293 L F
.58984 .27495 m .60252 .28026 L p .59603 .27847 L F P
0 g
s
.813 .621 .643 r
.60252 .28026 m .60887 .28293 L p .59603 .27847 L F P
0 g
s
.836 .645 .644 r
.60252 .28026 m .59662 .27712 L p .60239 .28091 L F P
0 g
s
.813 .621 .643 r
.58416 .32629 m .5984 .3013 L .59141 .33703 L F
.58262 .31981 m .58984 .27495 L .60219 .28197 L F
.58262 .31981 m .60219 .28197 L .59939 .29624 L F
.836 .645 .644 r
.59141 .33703 m .60643 .34478 L p .60468 .3327 L F P
0 g
s
.836 .645 .644 r
.59939 .29624 m .59141 .33703 L .60468 .3327 L F
.796 .575 .601 r
.56194 .42113 m .5716 .42398 L p .5678 .41079 L F P
0 g
s
.796 .575 .601 r
.5638 .39688 m .56194 .42113 L .5678 .41079 L F
.723 .511 .603 r
.54137 .41753 m .53072 .41684 L p .5363 .40524 L F P
0 g
s
.672 .376 .463 r
.53252 .51776 m .53327 .47285 L .5227 .47802 L F
.53327 .47285 m .52144 .47291 L p .5227 .47802 L F P
0 g
s
.649 .307 .378 r
.53352 .46593 m .52069 .44244 L .52089 .4507 L F
.5336 .46361 m .52069 .44244 L .53352 .46593 L F
.53436 .44203 m .52068 .4421 L p .53433 .44294 L F P
0 g
s
.649 .307 .378 r
.5336 .46361 m .53433 .44306 L .52069 .44244 L F
.52144 .47291 m .53327 .47285 L p .52089 .4507 L F P
0 g
s
.649 .307 .378 r
.53352 .46593 m .52089 .4507 L .53327 .47285 L F
.575 .244 .371 r
.54504 .47198 m .5566 .47032 L p .54689 .4524 L F P
0 g
s
.482 .162 .347 r
.57256 .445 m .5681 .43805 L .56785 .46786 L F
.575 .244 .371 r
.56784 .43945 m .56121 .43997 L .56119 .44008 L F
.482 .162 .347 r
.57438 .43615 m .5681 .43805 L p .57431 .43651 L F P
0 g
s
.532 .206 .361 r
.57431 .43651 m .55465 .44187 L .57438 .43615 L F
.575 .244 .371 r
.55767 .4633 m .56119 .44008 L .54794 .44135 L F
.55767 .4633 m .54794 .44135 L .54715 .44965 L F
.56119 .44008 m .54797 .441 L .54794 .44135 L F
.56121 .43997 m .54797 .441 L .56119 .44008 L F
.56135 .43904 m .54797 .441 L p .5546 .44048 L F P
0 g
s
.747 .522 .589 r
.54118 .42497 m .54779 .51357 L .5509 .44061 L F
.54048 .45302 m .54779 .51357 L .54118 .42497 L F
.682 .333 .377 r
.52144 .47291 m .50966 .47217 L p .52089 .4507 L F P
0 g
s
.682 .333 .377 r
.52089 .4507 m .50966 .47217 L .50907 .46522 L F
.52069 .44244 m .50888 .46289 L .50714 .44226 L F
.697 .48 .589 r
.52025 .43863 m .53003 .51187 L .53072 .41684 L F
.677 .394 .485 r
.52242 .56358 m .51717 .53692 L .52298 .62817 L F
.706 .417 .484 r
.52242 .56358 m .51434 .60821 L .5222 .5369 L F
.51434 .60821 m .51085 .62747 L .51414 .60124 L F
.51434 .60821 m .51414 .60124 L .5222 .5369 L F
.702 .4 .463 r
.51224 .53629 m .50723 .53598 L p .51167 .52215 L F P
0 g
s
.734 .44 .482 r
.50243 .53503 m .49749 .53439 L p .50376 .56184 L F P
0 g
s
.299 .739 .965 r
.49987 .57813 m .48936 .57743 L .48987 .57683 L F
.695 .707 .857 r
.49204 .56608 m .49008 .57615 L .46463 .57336 L F
.49204 .56608 m .46463 .57336 L .46579 .5699 L F
.299 .739 .965 r
.5027 .57832 m .48923 .57757 L .48936 .57743 L F
.733 .623 .736 r
.47406 .53328 m .49555 .53603 L p .47091 .5504 L F P
0 g
s
.695 .707 .857 r
.5028 .57755 m .5027 .57832 L .48997 .57673 L p F P
0 g
s
.299 .739 .965 r
.5027 .57832 m .50138 .58078 L p .4878 .57924 L F P
0 g
s
.299 .739 .965 r
.5027 .57832 m .4878 .57924 L .48923 .57757 L F
.733 .623 .736 r
.49488 .5423 m .46918 .55982 L .47049 .55271 L F
.49464 .54446 m .46918 .55982 L .49488 .5423 L F
.49464 .54446 m .49268 .56279 L .47019 .55921 L F
.49268 .56279 m .46918 .55982 L p .47019 .55921 L F P
0 g
s
.309 0 0 r
.50105 .58138 m .50086 .5811 L p .49929 .58093 L F P
0 g
s
.299 .739 .965 r
.50138 .58078 m .50105 .58138 L .48742 .57968 L p F P
0 g
s
.789 .484 .472 r
.50297 .62626 m .49749 .53439 L .49287 .53313 L p F P
0 g
s
.762 .462 .478 r
.49534 .62455 m .48806 .53217 L .49287 .53313 L p F P
0 g
s
.762 .462 .478 r
.49739 .59861 m .49534 .62455 L .49287 .53313 L F
.789 .484 .472 r
.50297 .62626 m .49287 .53313 L .49788 .60563 L F
.706 .417 .484 r
.51491 .62771 m .51085 .62747 L p .51434 .60821 L F P
0 g
s
.686 .699 .856 r
.5027 .57832 m .5028 .57755 L p .50343 .57758 L F P
0 g
s
.762 .462 .478 r
.50723 .53598 m .51085 .62747 L .50697 .62674 L p F P
0 g
s
.734 .44 .482 r
.49749 .53439 m .50297 .62626 L .50697 .62674 L p F P
0 g
s
.734 .44 .482 r
.50417 .57016 m .49749 .53439 L .50697 .62674 L F
.762 .462 .478 r
.50723 .53598 m .50697 .62674 L .50376 .56184 L F
.734 .44 .482 r
.51434 .60821 m .49749 .53439 L .51491 .62771 L F
.762 .462 .478 r
.49923 .62529 m .49534 .62455 L p .49788 .60563 L F P
0 g
s
.762 .462 .478 r
.50376 .56184 m .49788 .60563 L .50243 .53503 L F
.49788 .60563 m .49534 .62455 L .49739 .59861 L F
.49788 .60563 m .49739 .59861 L .50243 .53503 L F
.319 .763 .963 r
.48923 .57757 m .47701 .57595 L .48919 .57762 L F
.47701 .57595 m .47424 .57828 L p .4878 .57924 L F P
0 g
s
.319 .763 .963 r
.48919 .57762 m .47701 .57595 L .4878 .57924 L F
.48936 .57743 m .48987 .57683 L .47964 .57627 L F
.47424 .57828 m .47356 .57885 L .48742 .57968 L p F P
0 g
s
.789 .484 .472 r
.47904 .52934 m .48804 .62238 L .49179 .62335 L p F P
0 g
s
.789 .484 .472 r
.48678 .56614 m .47904 .52934 L .49179 .62335 L F
.817 .506 .463 r
.48806 .53217 m .49534 .62455 L .49179 .62335 L p F P
0 g
s
.817 .506 .463 r
.48806 .53217 m .49179 .62335 L .48605 .55773 L F
.789 .484 .472 r
.49788 .60563 m .48605 .55773 L .49923 .62529 L F
.48605 .55773 m .47904 .52934 L .48678 .56614 L F
.48605 .55773 m .48678 .56614 L .49923 .62529 L F
.846 .529 .451 r
.48804 .62238 m .47904 .52934 L .47493 .52749 L p F P
0 g
s
.846 .529 .451 r
.48804 .62238 m .47493 .52749 L .48264 .60104 L F
.817 .506 .463 r
.48367 .53061 m .48806 .53217 L p .48605 .55773 L F P
0 g
s
.759 .446 .455 r
.49287 .53313 m .48806 .53217 L p .49152 .51884 L F P
0 g
s
.789 .484 .472 r
.49287 .53313 m .47904 .52934 L p .49788 .60563 L F P
0 g
s
.699 .711 .858 r
.47701 .57595 m .47508 .57491 L .46711 .57388 L F
.747 .636 .738 r
.47406 .53328 m .45307 .52911 L p .47238 .54242 L F P
0 g
s
.817 .506 .463 r
.48116 .61976 m .47052 .52591 L .47493 .52749 L p F P
0 g
s
.817 .506 .463 r
.47493 .52749 m .48367 .53061 L p .48189 .59392 L F P
0 g
s
.817 .506 .463 r
.48189 .59392 m .48116 .61976 L .47493 .52749 L F
.48473 .62096 m .48116 .61976 L p .48264 .60104 L F P
0 g
s
.817 .506 .463 r
.48605 .55773 m .48331 .5925 L .48367 .53061 L F
.48331 .5925 m .48116 .61976 L .48243 .57478 L F
.48331 .5925 m .48243 .57478 L .48367 .53061 L F
.816 .496 .448 r
.50321 .72865 m .50396 .75974 L .50077 .72964 L F
.788 .474 .458 r
.50057 .72781 m .49778 .72713 L p .50396 .75974 L F P
0 g
s
.846 .53 .454 r
.49778 .72713 m .49706 .71939 L p .4969 .72 L F P
0 g
s
.818 .508 .466 r
.48116 .61976 m .48473 .62096 L p .49213 .71829 L F P
0 g
s
.818 .508 .466 r
.49267 .72531 m .49182 .71751 L p .49213 .71829 L F P
0 g
s
.818 .508 .466 r
.49182 .71751 m .48116 .61976 L p .49213 .71829 L F P
0 g
s
.845 .518 .435 r
.49862 .73431 m .49778 .72713 L .49531 .72614 L p F P
0 g
s
.816 .496 .448 r
.496 .73159 m .49366 .73254 L .49531 .72614 L F
.818 .508 .466 r
.4932 .70515 m .49267 .72531 L .48473 .62096 L F
.816 .496 .448 r
.49366 .73254 m .49267 .72531 L .49531 .72614 L p F P
0 g
s
.846 .53 .454 r
.49778 .72713 m .48473 .62096 L .4932 .70515 L F
.48804 .62238 m .48473 .62096 L p .4969 .72 L F P
0 g
s
.846 .53 .454 r
.49706 .71939 m .48804 .62238 L p .4969 .72 L F P
0 g
s
.818 .508 .466 r
.49534 .62455 m .50321 .72865 L .50057 .72781 L p F P
0 g
s
.818 .508 .466 r
.49534 .62455 m .50057 .72781 L .49451 .65571 L F
.79 .486 .474 r
.48804 .62238 m .49706 .71939 L p .50009 .72207 L F P
0 g
s
.79 .486 .474 r
.49451 .65571 m .48804 .62238 L .50009 .72207 L F
.49179 .62335 m .48804 .62238 L p .49451 .65571 L F P
0 g
s
.846 .529 .451 r
.48473 .62096 m .48804 .62238 L p .48264 .60104 L F P
0 g
s
.818 .508 .466 r
.48473 .62096 m .49179 .62335 L p .4932 .70515 L F P
0 g
s
.818 .508 .466 r
.49179 .62335 m .49534 .62455 L p .49451 .65571 L F P
0 g
s
.818 .508 .466 r
.49451 .65571 m .4932 .70515 L .49179 .62335 L F
.816 .496 .448 r
.50057 .72781 m .50321 .72865 L p .50125 .72945 L F P
0 g
s
.845 .518 .435 r
.49862 .73431 m .49531 .72614 L .496 .73159 L F
.816 .496 .448 r
.50125 .72945 m .50077 .72964 L .50057 .72781 L F
.788 .474 .458 r
.49778 .72713 m .5084 .81771 L p .51027 .81921 L F P
0 g
s
.788 .474 .458 r
.5084 .81771 m .50853 .81881 L .51027 .81921 L p F P
0 g
s
.845 .518 .435 r
.50837 .81772 m .49862 .73431 L .496 .73159 L F
.50853 .81881 m .5084 .81771 L p .50837 .81772 L F P
0 g
s
.845 .518 .435 r
.5084 .81771 m .49862 .73431 L p .50837 .81772 L F P
0 g
s
.805 .439 .365 r
.51027 .81921 m .51191 .8197 L p .51205 .82064 L F P
0 g
s
.805 .439 .365 r
.51205 .82064 m .51549 .8441 L .51027 .81921 L F
.76 .453 .465 r
.50321 .72865 m .50611 .72916 L p .51194 .8187 L F P
0 g
s
.76 .453 .465 r
.51241 .80431 m .51194 .8187 L .50611 .72916 L F
.51191 .8197 m .51181 .8186 L p .51194 .8187 L F P
0 g
s
.76 .453 .465 r
.51181 .8186 m .50321 .72865 L p .51194 .8187 L F P
0 g
s
.788 .474 .458 r
.51372 .82 m .51545 .82039 L p .51526 .81936 L F P
0 g
s
.788 .474 .458 r
.51526 .81936 m .51241 .80431 L .51372 .82 L F
.776 .419 .38 r
.5226 .86992 m .51559 .82136 L p .51383 .82065 L F P
0 g
s
.747 .398 .391 r
.52139 .86969 m .5121 .82067 L p .51384 .82073 L F P
0 g
s
.747 .398 .391 r
.52116 .86468 m .52139 .86969 L .51384 .82073 L F
.5121 .82067 m .51191 .8197 L .51372 .82 L p F P
0 g
s
.776 .419 .38 r
.5226 .86992 m .51383 .82065 L .52079 .86248 L F
.51559 .82136 m .51545 .82039 L .51372 .82 L p F P
0 g
s
.776 .419 .38 r
.51559 .82136 m .51372 .82 L .51383 .82065 L F
.788 .474 .458 r
.51545 .82039 m .50941 .73692 L p .50651 .73393 L F P
0 g
s
.788 .474 .458 r
.51545 .82039 m .50651 .73393 L .5119 .79831 L F
.50396 .75974 m .49778 .72713 L .51027 .81921 L F
.845 .518 .435 r
.50853 .81881 m .496 .73159 L .50498 .80234 L F
.507 .81823 m .50853 .81881 L p .50498 .80234 L F P
0 g
s
.816 .496 .448 r
.50321 .72865 m .51191 .8197 L .507 .81823 L p F P
0 g
s
.833 .458 .343 r
.52024 .8694 m .50876 .8198 L p .50719 .81898 L F P
0 g
s
.833 .458 .343 r
.52024 .8694 m .50719 .81898 L .51841 .86398 L F
.776 .419 .38 r
.51027 .81921 m .50853 .81881 L p .51549 .8441 L F P
0 g
s
.747 .398 .391 r
.52201 .86979 m .52139 .86969 L p .52116 .86468 L F P
0 g
s
.805 .439 .365 r
.51191 .8197 m .52139 .86969 L .52083 .86953 L p F P
0 g
s
.776 .419 .38 r
.50853 .81881 m .52024 .8694 L .52083 .86953 L p F P
0 g
s
.776 .419 .38 r
.51655 .84917 m .50853 .81881 L .52083 .86953 L F
.805 .439 .365 r
.51191 .8197 m .52083 .86953 L .51549 .8441 L F
.776 .419 .38 r
.52116 .86468 m .50853 .81881 L .52201 .86979 L F
.805 .439 .365 r
.51971 .86921 m .51915 .86905 L p .51841 .86398 L F P
0 g
s
.805 .439 .365 r
.51841 .86398 m .51915 .86905 L .51785 .86173 L F
.833 .458 .343 r
.50876 .8198 m .50853 .81881 L .507 .81823 L p F P
0 g
s
.805 .439 .365 r
.51915 .86905 m .50562 .81874 L p .50716 .8189 L F P
0 g
s
.833 .458 .343 r
.50876 .8198 m .507 .81823 L .50719 .81898 L F
.805 .439 .365 r
.51027 .81921 m .51785 .86173 L .50716 .8189 L F
.51785 .86173 m .51915 .86905 L .50716 .8189 L F
.816 .496 .448 r
.507 .81823 m .50535 .81774 L p .50533 .81675 L F P
0 g
s
.805 .439 .365 r
.50562 .81874 m .50535 .81774 L .507 .81823 L p F P
0 g
s
.805 .439 .365 r
.507 .81823 m .51027 .81921 L p .50562 .81874 L F P
0 g
s
.816 .496 .448 r
.50535 .81774 m .49366 .73254 L p .496 .73159 L F P
0 g
s
.816 .496 .448 r
.50425 .79657 m .50535 .81774 L .496 .73159 L F
.50396 .75974 m .50535 .81774 L .50077 .72964 L F
.845 .518 .435 r
.50224 .81538 m .50241 .8165 L .50395 .81708 L p F P
0 g
s
.833 .458 .343 r
.50395 .81708 m .50241 .8165 L p .5037 .81717 L F P
0 g
s
.861 .475 .313 r
.50395 .81708 m .50535 .81774 L p .50558 .8187 L F P
0 g
s
.833 .458 .343 r
.50402 .81734 m .50395 .81708 L .5037 .81717 L F
.861 .475 .313 r
.50535 .81774 m .51915 .86905 L .51868 .86883 L p F P
0 g
s
.833 .458 .343 r
.50241 .8165 m .51815 .86864 L .51868 .86883 L p F P
0 g
s
.833 .458 .343 r
.51272 .8479 m .50241 .8165 L .51868 .86883 L F
.861 .475 .313 r
.50535 .81774 m .51868 .86883 L .51124 .84269 L F
.833 .458 .343 r
.51841 .86398 m .50241 .8165 L .51971 .86921 L F
.885 .489 .271 r
.51815 .86864 m .50241 .8165 L .50115 .81577 L p F P
0 g
s
.885 .489 .271 r
.51815 .86864 m .50115 .81577 L .51603 .863 L F
.861 .475 .313 r
.50558 .8187 m .51124 .84269 L .50395 .81708 L F
.833 .458 .343 r
.51841 .86398 m .50719 .81898 L .50241 .8165 L F
.861 .475 .313 r
.51124 .84269 m .51603 .863 L .50395 .81708 L F
.51603 .863 m .51725 .86818 L .5153 .86069 L F
.51603 .863 m .5153 .86069 L .50395 .81708 L F
.51773 .8684 m .51725 .86818 L p .51603 .863 L F P
0 g
s
.861 .475 .313 r
.51725 .86818 m .50009 .81615 L p .50395 .81708 L F P
0 g
s
.861 .475 .313 r
.50009 .81615 m .49975 .81511 L .50115 .81577 L p F P
0 g
s
.874 .541 .416 r
.49852 .79959 m .50111 .81549 L .49975 .81511 L F
.903 .563 .389 r
.50115 .81577 m .50241 .8165 L p .49852 .79959 L F P
0 g
s
.903 .563 .389 r
.50241 .8165 m .50224 .81538 L p .50216 .81541 L F P
0 g
s
.845 .518 .435 r
.48793 .72319 m .50224 .81538 L p .50395 .81708 L F P
0 g
s
.845 .518 .435 r
.49646 .76568 m .48793 .72319 L .50395 .81708 L F
.874 .541 .416 r
.50395 .81708 m .49975 .81511 L p .5052 .81663 L F P
0 g
s
.874 .541 .416 r
.49975 .81511 m .48362 .7208 L .48589 .72193 L p F P
0 g
s
.903 .563 .389 r
.48793 .72319 m .48589 .72193 L p .50216 .81541 L F P
0 g
s
.903 .563 .389 r
.50216 .81541 m .48589 .72193 L .49852 .79959 L F
.50224 .81538 m .48793 .72319 L p .50216 .81541 L F P
0 g
s
.874 .541 .416 r
.49267 .72531 m .5052 .81663 L p .50383 .81625 L F P
0 g
s
.874 .541 .416 r
.49267 .72531 m .50383 .81625 L .49514 .75665 L F
.816 .496 .448 r
.50498 .80234 m .507 .81823 L .50533 .81675 L F
.845 .518 .435 r
.50498 .80234 m .49514 .75665 L .507 .81823 L F
.49514 .75665 m .48793 .72319 L .49646 .76568 L F
.49514 .75665 m .49646 .76568 L .507 .81823 L F
.874 .541 .416 r
.4904 .72418 m .49267 .72531 L p .49514 .75665 L F P
0 g
s
.79 .486 .474 r
.49706 .71939 m .49778 .72713 L .50057 .72781 L p F P
0 g
s
.762 .464 .48 r
.50321 .72865 m .50263 .72096 L p .50294 .7217 L F P
0 g
s
.762 .464 .48 r
.50474 .70841 m .50321 .72865 L .49923 .62529 L F
.50611 .72916 m .50321 .72865 L p .50474 .70841 L F P
0 g
s
.79 .486 .474 r
.50057 .72781 m .50611 .72916 L p .49706 .71939 L F P
0 g
s
.79 .486 .474 r
.50611 .72916 m .5089 .72984 L p .50599 .72727 L F P
0 g
s
.79 .486 .474 r
.50599 .72727 m .49706 .71939 L .50611 .72916 L F
.5089 .72984 m .50474 .70841 L .50599 .72727 L F
.762 .464 .48 r
.49534 .62455 m .49923 .62529 L p .50294 .7217 L F P
0 g
s
.762 .464 .48 r
.50263 .72096 m .49534 .62455 L p .50294 .7217 L F P
0 g
s
.79 .486 .474 r
.5089 .72984 m .50297 .62626 L .49179 .62335 L p F P
0 g
s
.79 .486 .474 r
.5089 .72984 m .49179 .62335 L .49451 .65571 L F
.762 .464 .48 r
.51085 .62747 m .51449 .72306 L p .51188 .73018 L F P
0 g
s
.762 .464 .48 r
.51449 .72306 m .51478 .73069 L .51188 .73018 L p F P
0 g
s
.76 .453 .465 r
.51907 .81981 m .51912 .82089 L .51731 .82059 L p F P
0 g
s
.747 .398 .391 r
.51912 .82089 m .52385 .87009 L .52323 .86999 L p F P
0 g
s
.776 .419 .38 r
.52201 .86979 m .5226 .86992 L p .52116 .86468 L F P
0 g
s
.776 .419 .38 r
.5226 .86992 m .51027 .81921 L .51549 .8441 L F
.747 .398 .391 r
.51912 .82089 m .52323 .86999 L .52084 .84999 L F
.718 .376 .398 r
.51545 .82039 m .5226 .86992 L .52323 .86999 L p F P
0 g
s
.747 .398 .391 r
.51912 .82089 m .52084 .84999 L .52024 .84502 L F
.688 .353 .402 r
.52385 .87009 m .51912 .82089 L .52101 .82099 L p F P
0 g
s
.688 .353 .402 r
.52414 .86507 m .52385 .87009 L .52101 .82099 L F
.718 .376 .398 r
.52024 .84502 m .51545 .82039 L .52323 .86999 L F
.52024 .84502 m .51731 .82059 L .51564 .82134 L F
.51731 .82059 m .51545 .82039 L p .51564 .82134 L F P
0 g
s
.816 .496 .448 r
.50321 .72865 m .507 .81823 L .50498 .80234 L F
.788 .474 .458 r
.51526 .81936 m .50057 .72781 L .50396 .75974 L F
.51545 .82039 m .51528 .81934 L .51526 .81936 L F
.51528 .81934 m .50057 .72781 L .51526 .81936 L F
.76 .453 .465 r
.51478 .73069 m .51907 .81981 L p .51731 .82059 L F P
0 g
s
.76 .453 .465 r
.51478 .73069 m .51731 .82059 L .5143 .77054 L F
.732 .43 .469 r
.5089 .72984 m .51537 .81931 L p .51726 .81978 L F P
0 g
s
.732 .43 .469 r
.51378 .76175 m .5089 .72984 L .51726 .81978 L F
.76 .453 .465 r
.51378 .76175 m .51372 .82 L .51241 .80431 L F
.51478 .73069 m .5143 .77054 L .51378 .76175 L F
.5143 .77054 m .51372 .82 L .51378 .76175 L F
.747 .398 .391 r
.5177 .82085 m .51384 .82073 L .51731 .82059 L F
.51912 .82089 m .52116 .86468 L .51384 .82073 L F
.718 .376 .398 r
.52513 .87019 m .52291 .82215 L p .52105 .82163 L F P
0 g
s
.718 .376 .398 r
.52513 .87019 m .52105 .82163 L .52399 .86291 L F
.52414 .86507 m .51731 .82059 L .52024 .84502 L F
.52513 .87019 m .52399 .86291 L .52414 .86507 L F
.52399 .86291 m .51731 .82059 L .52414 .86507 L F
.5245 .87012 m .52513 .87019 L p .52414 .86507 L F P
0 g
s
.657 .328 .404 r
.52286 .82119 m .52513 .87019 L .52578 .87018 L p F P
0 g
s
.688 .353 .402 r
.52665 .82128 m .52643 .87022 L .52578 .87018 L p F P
0 g
s
.688 .353 .402 r
.52665 .82128 m .52578 .87018 L .52537 .85034 L F
.657 .328 .404 r
.52527 .84541 m .52286 .82119 L .52578 .87018 L F
.688 .353 .402 r
.52527 .84541 m .5245 .87012 L .52414 .86507 L F
.52665 .82128 m .52537 .85034 L .52527 .84541 L F
.52537 .85034 m .5245 .87012 L .52527 .84541 L F
.657 .328 .404 r
.52476 .82118 m .52286 .82119 L p .52527 .84541 L F P
0 g
s
.718 .376 .398 r
.52291 .82215 m .52286 .82119 L .52101 .82099 L p F P
0 g
s
.704 .408 .472 r
.52045 .80542 m .51912 .82089 L .51781 .73085 L F
.747 .398 .391 r
.51731 .82059 m .51912 .82089 L p .5177 .82085 L F P
0 g
s
.732 .43 .469 r
.52286 .82119 m .52045 .80542 L .521 .82072 L F
.52101 .82099 m .52286 .82119 L p .521 .82072 L F P
0 g
s
.704 .408 .472 r
.51478 .73069 m .51781 .73085 L p .5191 .81983 L F P
0 g
s
.704 .408 .472 r
.51907 .81981 m .51478 .73069 L p .5191 .81983 L F P
0 g
s
.732 .43 .469 r
.51378 .76175 m .51188 .73018 L .50981 .73582 L F
.51188 .73018 m .5089 .72984 L p .50981 .73582 L F P
0 g
s
.788 .474 .458 r
.50941 .73692 m .5089 .72984 L .50611 .72916 L p F P
0 g
s
.788 .474 .458 r
.50611 .72916 m .50057 .72781 L p .50941 .73692 L F P
0 g
s
.735 .442 .484 r
.50846 .72218 m .5089 .72984 L .51188 .73018 L p F P
0 g
s
.76 .453 .465 r
.50611 .72916 m .51188 .73018 L p .51241 .80431 L F P
0 g
s
.76 .453 .465 r
.51188 .73018 m .51478 .73069 L p .51459 .73651 L F P
0 g
s
.76 .453 .465 r
.51459 .73651 m .51241 .80431 L .51188 .73018 L F
.762 .464 .48 r
.51085 .62747 m .51188 .73018 L .50894 .66839 L F
.735 .442 .484 r
.50297 .62626 m .50846 .72218 L p .51161 .72448 L F P
0 g
s
.735 .442 .484 r
.50849 .65877 m .50297 .62626 L .51161 .72448 L F
.762 .464 .48 r
.50849 .65877 m .50611 .72916 L .50474 .70841 L F
.51085 .62747 m .50894 .66839 L .50849 .65877 L F
.50894 .66839 m .50611 .72916 L .50849 .65877 L F
.732 .43 .469 r
.52286 .82119 m .52095 .73823 L p .51188 .73018 L F P
0 g
s
.732 .43 .469 r
.52095 .73823 m .52078 .73119 L .51781 .73085 L p F P
0 g
s
.707 .419 .486 r
.51478 .73069 m .51449 .72306 L p .51479 .72376 L F P
0 g
s
.707 .419 .486 r
.51723 .71024 m .51478 .73069 L .51491 .62771 L F
.735 .442 .484 r
.52078 .73119 m .51723 .71024 L .51775 .72897 L F
.51781 .73085 m .52078 .73119 L p .51775 .72897 L F P
0 g
s
.707 .419 .486 r
.51085 .62747 m .51491 .62771 L p .51479 .72376 L F P
0 g
s
.707 .419 .486 r
.51449 .72306 m .51085 .62747 L p .51479 .72376 L F P
0 g
s
.735 .442 .484 r
.50697 .62674 m .50297 .62626 L p .50849 .65877 L F P
0 g
s
.789 .484 .472 r
.49923 .62529 m .50297 .62626 L p .49788 .60563 L F P
0 g
s
.762 .464 .48 r
.49923 .62529 m .51085 .62747 L p .50474 .70841 L F P
0 g
s
.735 .442 .484 r
.52078 .73119 m .5189 .62819 L .50697 .62674 L p F P
0 g
s
.735 .442 .484 r
.52078 .73119 m .50697 .62674 L .50849 .65877 L F
.707 .419 .486 r
.52686 .72373 m .52685 .73134 L .52382 .73118 L p F P
0 g
s
.704 .408 .472 r
.52685 .73134 m .52665 .82128 L .52476 .82118 L p F P
0 g
s
.732 .43 .469 r
.52045 .80542 m .51188 .73018 L .51378 .76175 L F
.52286 .82119 m .52024 .79946 L .52045 .80542 L F
.52024 .79946 m .51188 .73018 L .52045 .80542 L F
.704 .408 .472 r
.52685 .73134 m .52476 .82118 L .52424 .77135 L F
.52101 .82099 m .51912 .82089 L p .52045 .80542 L F P
0 g
s
.718 .376 .398 r
.52101 .82099 m .51731 .82059 L p .52105 .82163 L F P
0 g
s
.718 .376 .398 r
.52291 .82215 m .52101 .82099 L .52105 .82163 L F
.688 .353 .402 r
.52101 .82099 m .52476 .82118 L p .52414 .86507 L F P
0 g
s
.688 .353 .402 r
.52476 .82118 m .52665 .82128 L p .5266 .82221 L F P
0 g
s
.688 .353 .402 r
.5266 .82221 m .52414 .86507 L .52476 .82118 L F
.675 .384 .472 r
.52078 .73119 m .52284 .82011 L p .52476 .82118 L F P
0 g
s
.675 .384 .472 r
.52284 .82011 m .52286 .82119 L .52476 .82118 L p F P
0 g
s
.644 .359 .471 r
.52853 .82116 m .52665 .82128 L p .52854 .82089 L F P
0 g
s
.611 .331 .469 r
.53588 .73077 m .53291 .73114 L p .53523 .73229 L F P
0 g
s
.616 .345 .484 r
.53516 .62811 m .53291 .73114 L .53588 .73077 L p F P
0 g
s
.644 .359 .471 r
.52665 .82128 m .52684 .73837 L p .53588 .73077 L F P
0 g
s
.644 .359 .471 r
.52684 .73837 m .52685 .73134 L .52987 .73115 L p F P
0 g
s
.678 .396 .487 r
.52987 .73115 m .53291 .73114 L p .53217 .72568 L F P
0 g
s
.707 .419 .486 r
.52703 .62841 m .52686 .72373 L p .52378 .72615 L F P
0 g
s
.707 .419 .486 r
.52703 .62841 m .52378 .72615 L .52332 .66964 L F
.678 .396 .487 r
.5189 .62819 m .52064 .72358 L p .52382 .73118 L F P
0 g
s
.678 .396 .487 r
.52064 .72358 m .52078 .73119 L .52382 .73118 L p F P
0 g
s
.675 .384 .472 r
.52424 .77135 m .52078 .73119 L .52476 .82118 L F
.52415 .7626 m .52382 .73118 L .52142 .73708 L F
.52382 .73118 m .52078 .73119 L p .52142 .73708 L F P
0 g
s
.707 .419 .486 r
.51781 .73085 m .51478 .73069 L p .51723 .71024 L F P
0 g
s
.732 .43 .469 r
.51781 .73085 m .51188 .73018 L p .52095 .73823 L F P
0 g
s
.704 .408 .472 r
.52685 .73134 m .52424 .77135 L .52415 .7626 L F
.644 .359 .471 r
.53462 .76225 m .52665 .82128 L .53588 .73077 L F
.675 .384 .472 r
.52877 .80562 m .52415 .7626 L .52853 .82116 L F
.52415 .7626 m .52078 .73119 L .52424 .77135 L F
.52415 .7626 m .52424 .77135 L .52853 .82116 L F
.704 .408 .472 r
.52635 .7372 m .52415 .7626 L .52382 .73118 L F
.52415 .7626 m .52045 .80542 L .52382 .73118 L F
.51781 .73085 m .52382 .73118 L p .52045 .80542 L F P
0 g
s
.704 .408 .472 r
.52382 .73118 m .52685 .73134 L p .52635 .7372 L F P
0 g
s
.678 .396 .487 r
.52332 .66964 m .5189 .62819 L .52382 .73118 L F
.707 .419 .486 r
.52703 .62841 m .52332 .66964 L .52324 .66006 L F
.678 .396 .487 r
.53217 .72568 m .53011 .71056 L .52987 .73115 L F
.707 .419 .486 r
.52298 .62817 m .52703 .62841 L p .52324 .66006 L F P
0 g
s
.678 .396 .487 r
.53291 .73114 m .53516 .62811 L .53108 .62813 L p F P
0 g
s
.648 .371 .486 r
.52685 .73134 m .52703 .62841 L .53108 .62813 L p F P
0 g
s
.648 .371 .486 r
.5302 .70304 m .52685 .73134 L .53108 .62813 L F
.647 .369 .484 r
.53108 .62813 m .52703 .62841 L p .53132 .60866 L F P
0 g
s
.678 .396 .487 r
.53108 .62813 m .52298 .62817 L p .5302 .70304 L F P
0 g
s
.678 .396 .487 r
.53291 .73114 m .53108 .62813 L .5302 .70304 L F
.616 .345 .484 r
.53782 .66913 m .53516 .62811 L .53588 .73077 L F
.53913 .62759 m .53516 .62811 L p .53813 .65954 L F P
0 g
s
.581 .316 .479 r
.54178 .73004 m .5389 .73058 L p .54283 .70937 L F P
0 g
s
.616 .345 .484 r
.54283 .70937 m .53516 .62811 L .54178 .73004 L F
.648 .371 .486 r
.53108 .62813 m .53913 .62759 L p .5302 .70304 L F P
0 g
s
.648 .371 .486 r
.53011 .71056 m .52685 .73134 L .5302 .70304 L F
.678 .396 .487 r
.53011 .71056 m .52298 .62817 L .52324 .66006 L F
.53291 .73114 m .5302 .70304 L .53011 .71056 L F
.5302 .70304 m .52298 .62817 L .53011 .71056 L F
.648 .371 .486 r
.53813 .65954 m .53011 .71056 L .53913 .62759 L F
.53011 .71056 m .5302 .70304 L .53913 .62759 L F
.53588 .73077 m .52987 .73115 L p .53813 .65954 L F P
0 g
s
.648 .371 .486 r
.52987 .73115 m .52685 .73134 L p .53011 .71056 L F P
0 g
s
.648 .371 .486 r
.53813 .65954 m .52987 .73115 L .53011 .71056 L F
.678 .396 .487 r
.53011 .71056 m .52324 .66006 L .52987 .73115 L F
.52324 .66006 m .5189 .62819 L .52332 .66964 L F
.52324 .66006 m .52332 .66964 L .52987 .73115 L F
.52298 .62817 m .5189 .62819 L p .52324 .66006 L F P
0 g
s
.734 .44 .482 r
.51491 .62771 m .5189 .62819 L p .51434 .60821 L F P
0 g
s
.707 .419 .486 r
.51491 .62771 m .52298 .62817 L p .51723 .71024 L F P
0 g
s
.707 .419 .486 r
.52324 .66006 m .51723 .71024 L .52298 .62817 L F
.52324 .66006 m .51781 .73085 L .51723 .71024 L F
.52332 .66964 m .51781 .73085 L .52324 .66006 L F
.52382 .73118 m .51781 .73085 L p .52686 .72373 L F P
0 g
s
.678 .396 .487 r
.52382 .73118 m .52987 .73115 L p .52332 .66964 L F P
0 g
s
.707 .419 .486 r
.52332 .66964 m .52378 .72615 L .51781 .73085 L F
.644 .359 .471 r
.52987 .73115 m .53588 .73077 L p .52684 .73837 L F P
0 g
s
.675 .384 .472 r
.52476 .82118 m .52853 .82116 L p .52424 .77135 L F P
0 g
s
.704 .408 .472 r
.52415 .7626 m .52101 .82099 L .52045 .80542 L F
.52424 .77135 m .52101 .82099 L .52415 .7626 L F
.52476 .82118 m .52101 .82099 L p .52424 .77135 L F P
0 g
s
.675 .384 .472 r
.52877 .80562 m .52382 .73118 L .52415 .7626 L F
.52987 .73115 m .52382 .73118 L p .52877 .80562 L F P
0 g
s
.735 .442 .484 r
.51188 .73018 m .51781 .73085 L p .50846 .72218 L F P
0 g
s
.735 .442 .484 r
.51775 .72897 m .50846 .72218 L .51781 .73085 L F
.51775 .72897 m .50849 .65877 L .51161 .72448 L F
.51723 .71024 m .50849 .65877 L .51775 .72897 L F
.704 .408 .472 r
.51912 .82089 m .51907 .81981 L p .5191 .81983 L F P
0 g
s
.732 .43 .469 r
.51731 .82059 m .52101 .82099 L p .51537 .81931 L F P
0 g
s
.732 .43 .469 r
.521 .82072 m .51537 .81931 L .52101 .82099 L F
.657 .328 .404 r
.52772 .87018 m .53043 .82116 L .52853 .82116 L p F P
0 g
s
.657 .328 .404 r
.52772 .87018 m .52853 .82116 L .52729 .86298 L F
.623 .3 .402 r
.52643 .87022 m .52665 .82223 L p .52851 .82188 L F P
0 g
s
.623 .3 .402 r
.52729 .863 m .52643 .87022 L .52851 .82188 L F
.657 .328 .404 r
.52772 .87018 m .52729 .86298 L .52723 .86514 L F
.587 .269 .397 r
.53027 .86488 m .53034 .84525 L .52962 .86996 L F
.53034 .84525 m .53043 .82116 L .52995 .8502 L F
.53034 .84525 m .52995 .8502 L .52962 .86996 L F
.623 .3 .402 r
.53034 .84525 m .52723 .86514 L .53226 .82118 L F
.52723 .86514 m .52643 .87022 L .52729 .863 L F
.52723 .86514 m .52729 .863 L .53226 .82118 L F
.52708 .87018 m .52643 .87022 L p .52723 .86514 L F P
0 g
s
.657 .328 .404 r
.52578 .87018 m .52708 .87018 L p .52527 .84541 L F P
0 g
s
.657 .328 .404 r
.52708 .87018 m .52772 .87018 L p .52723 .86514 L F P
0 g
s
.657 .328 .404 r
.52723 .86514 m .52527 .84541 L .52708 .87018 L F
.52723 .86514 m .52476 .82118 L .52527 .84541 L F
.52729 .86298 m .52476 .82118 L .52723 .86514 L F
.623 .3 .402 r
.53226 .82118 m .52729 .863 L .52851 .82188 L F
.52836 .87011 m .52708 .87018 L p .53034 .84525 L F P
0 g
s
.623 .3 .402 r
.53034 .84525 m .52708 .87018 L .52723 .86514 L F
.52853 .82116 m .53228 .82094 L p .52665 .82223 L F P
0 g
s
.623 .3 .402 r
.53226 .82118 m .52665 .82223 L .53228 .82094 L F
.52665 .82223 m .52665 .82128 L .52853 .82116 L p F P
0 g
s
.657 .328 .404 r
.52853 .82116 m .52476 .82118 L p .52729 .86298 L F P
0 g
s
.688 .353 .402 r
.52578 .87018 m .5245 .87012 L p .52537 .85034 L F P
0 g
s
.688 .353 .402 r
.5245 .87012 m .52385 .87009 L p .52414 .86507 L F P
0 g
s
.718 .376 .398 r
.52399 .86291 m .52105 .82163 L .51731 .82059 L F
.732 .43 .469 r
.521 .82072 m .51378 .76175 L .51726 .81978 L F
.52045 .80542 m .51378 .76175 L .521 .82072 L F
.51537 .81931 m .51545 .82039 L .51731 .82059 L p F P
0 g
s
.747 .398 .391 r
.51372 .82 m .51731 .82059 L p .51384 .82073 L F P
0 g
s
.718 .376 .398 r
.52323 .86999 m .5245 .87012 L p .52024 .84502 L F P
0 g
s
.718 .376 .398 r
.52414 .86507 m .52024 .84502 L .5245 .87012 L F
.747 .398 .391 r
.52024 .84502 m .52201 .86979 L .52116 .86468 L F
.52084 .84999 m .52201 .86979 L .52024 .84502 L F
.52323 .86999 m .52201 .86979 L p .52084 .84999 L F P
0 g
s
.76 .453 .465 r
.51731 .82059 m .51372 .82 L p .5143 .77054 L F P
0 g
s
.762 .464 .48 r
.51188 .73018 m .50611 .72916 L p .50894 .66839 L F P
0 g
s
.846 .53 .454 r
.49531 .72614 m .49778 .72713 L p .4932 .70515 L F P
0 g
s
.818 .508 .466 r
.50057 .72781 m .49531 .72614 L p .49451 .65571 L F P
0 g
s
.818 .508 .466 r
.49531 .72614 m .49267 .72531 L p .4932 .70515 L F P
0 g
s
.818 .508 .466 r
.49451 .65571 m .49531 .72614 L .4932 .70515 L F
.846 .53 .454 r
.47478 .61672 m .48793 .72319 L .4904 .72418 L p F P
0 g
s
.846 .53 .454 r
.48307 .66088 m .47478 .61672 L .4904 .72418 L F
.876 .553 .437 r
.49182 .71751 m .49267 .72531 L .4904 .72418 L p F P
0 g
s
.845 .518 .435 r
.49531 .72614 m .4904 .72418 L p .496 .73159 L F P
0 g
s
.845 .518 .435 r
.4904 .72418 m .48793 .72319 L p .49013 .72548 L F P
0 g
s
.845 .518 .435 r
.496 .73159 m .4904 .72418 L .49013 .72548 L F
.876 .553 .437 r
.48116 .61976 m .49182 .71751 L p .4904 .72418 L F P
0 g
s
.876 .553 .437 r
.48116 .61976 m .4904 .72418 L .48192 .65101 L F
.846 .53 .454 r
.4932 .70515 m .48192 .65101 L .49531 .72614 L F
.48192 .65101 m .47478 .61672 L .48307 .66088 L F
.48192 .65101 m .48307 .66088 L .49531 .72614 L F
.905 .577 .414 r
.48793 .72319 m .47478 .61672 L .47204 .61492 L p F P
0 g
s
.905 .577 .414 r
.48793 .72319 m .47204 .61492 L .48313 .70058 L F
.876 .553 .437 r
.47812 .61814 m .48116 .61976 L p .48192 .65101 L F P
0 g
s
.846 .53 .454 r
.48756 .67809 m .4874 .67471 L .47478 .61672 L F
.747 .636 .738 r
.47049 .55271 m .47216 .54362 L .45219 .53245 L F
.875 .552 .434 r
.47052 .52591 m .48116 .61976 L .47812 .61814 L p F P
0 g
s
.846 .53 .454 r
.48473 .62096 m .47812 .61814 L p .4874 .67471 L F P
0 g
s
.846 .53 .454 r
.47812 .61814 m .47478 .61672 L p .4874 .67471 L F P
0 g
s
.875 .552 .434 r
.47204 .61492 m .46897 .61329 L p .4693 .59461 L F P
0 g
s
.286 .717 .968 r
.46832 .57744 m .46138 .57556 L .46308 .57669 L F
.747 .636 .738 r
.47049 .55271 m .45219 .53245 L .45146 .53526 L F
.286 .717 .968 r
.47356 .57885 m .46832 .57744 L .46308 .57669 L F
.905 .575 .41 r
.47478 .61672 m .45919 .51958 L .4693 .59461 L F
.876 .553 .437 r
.48362 .7208 m .46897 .61329 L .47204 .61492 L p F P
0 g
s
.905 .575 .41 r
.47204 .61492 m .47478 .61672 L p .4693 .59461 L F P
0 g
s
.875 .552 .434 r
.4693 .59461 m .46897 .61329 L .45919 .51958 L F
.905 .575 .41 r
.4693 .59461 m .46679 .58449 L .47204 .61492 L F
.299 .739 .965 r
.46169 .57536 m .44652 .57457 L .46457 .57355 L F
.44652 .57457 m .45176 .57194 L .46457 .57355 L p F P
0 g
s
.875 .552 .434 r
.46897 .61329 m .45538 .51745 L .45919 .51958 L p F P
0 g
s
.905 .575 .41 r
.47478 .61672 m .46261 .52194 L .45919 .51958 L p F P
0 g
s
.846 .529 .451 r
.46261 .52194 m .47478 .61672 L .47812 .61814 L p F P
0 g
s
.846 .529 .451 r
.4711 .55997 m .46261 .52194 L .47812 .61814 L F
.47007 .55141 m .46261 .52194 L .4711 .55997 L F
.875 .552 .434 r
.47007 .55141 m .47812 .61814 L .46979 .56737 L F
.47052 .52591 m .47812 .61814 L .47007 .55141 L F
.846 .529 .451 r
.48264 .60104 m .47007 .55141 L .48473 .62096 L F
.47007 .55141 m .4711 .55997 L .48473 .62096 L F
.47812 .61814 m .48473 .62096 L p .4711 .55997 L F P
0 g
s
.875 .552 .434 r
.46674 .5238 m .47052 .52591 L p .47007 .55141 L F P
0 g
s
.816 .49 .437 r
.47493 .52749 m .47052 .52591 L p .47284 .51292 L F P
0 g
s
.846 .529 .451 r
.47493 .52749 m .46261 .52194 L p .48264 .60104 L F P
0 g
s
.875 .552 .434 r
.45919 .51958 m .46674 .5238 L p .4693 .59461 L F P
0 g
s
.875 .552 .434 r
.47007 .55141 m .4693 .59461 L .46674 .5238 L F
.876 .553 .437 r
.47204 .61492 m .47812 .61814 L p .48061 .66465 L F P
0 g
s
.876 .553 .437 r
.48212 .69277 m .48362 .7208 L .47204 .61492 L F
.48589 .72193 m .48362 .7208 L p .48313 .70058 L F P
0 g
s
.876 .553 .437 r
.48192 .65101 m .48362 .7208 L .47812 .61814 L F
.905 .577 .414 r
.46379 .60951 m .47861 .71016 L p .48184 .71943 L F P
0 g
s
.905 .577 .414 r
.47861 .71016 m .47979 .71817 L .48184 .71943 L p F P
0 g
s
.93 .583 .352 r
.48184 .71943 m .48362 .7208 L p .48439 .72677 L F P
0 g
s
.93 .583 .352 r
.48439 .72677 m .48772 .75262 L .48184 .71943 L F
.874 .541 .416 r
.49852 .79959 m .49975 .81511 L .48589 .72193 L F
.905 .577 .414 r
.47272 .65492 m .46379 .60951 L .48184 .71943 L F
.933 .599 .381 r
.46897 .61329 m .48362 .7208 L .48184 .71943 L p F P
0 g
s
.905 .577 .414 r
.4713 .64486 m .46379 .60951 L .47272 .65492 L F
.903 .563 .389 r
.48184 .71943 m .47979 .71817 L p .48772 .75262 L F P
0 g
s
.885 .489 .271 r
.49738 .81357 m .51645 .86768 L .51688 .86792 L p F P
0 g
s
.885 .489 .271 r
.50951 .84625 m .49738 .81357 L .51688 .86792 L F
.903 .498 .213 r
.49975 .81511 m .51725 .86818 L .51688 .86792 L p F P
0 g
s
.885 .489 .271 r
.50767 .84086 m .49738 .81357 L .50951 .84625 L F
.905 .495 .132 r
.51645 .86768 m .49738 .81357 L .49646 .81272 L p F P
0 g
s
.905 .495 .132 r
.51645 .86768 m .49646 .81272 L .51412 .8618 L F
.903 .498 .213 r
.49975 .81511 m .51688 .86792 L .50767 .84086 L F
.50005 .8161 m .50767 .84086 L .49865 .81431 L F
.49865 .81431 m .49975 .81511 L p .50005 .8161 L F P
0 g
s
.861 .475 .313 r
.50115 .81577 m .50395 .81708 L p .50009 .81615 L F P
0 g
s
.885 .489 .271 r
.50115 .81577 m .49865 .81431 L p .51603 .863 L F P
0 g
s
.885 .489 .271 r
.49865 .81431 m .49738 .81357 L p .49778 .81463 L F P
0 g
s
.885 .489 .271 r
.51603 .863 m .49865 .81431 L .49778 .81463 L F
.93 .583 .352 r
.48362 .7208 m .49955 .81398 L p .49865 .81431 L F P
0 g
s
.93 .583 .352 r
.49955 .81398 m .49975 .81511 L .49865 .81431 L p F P
0 g
s
.903 .498 .213 r
.50767 .84086 m .51412 .8618 L .49865 .81431 L F
.51412 .8618 m .51576 .86714 L .51326 .8594 L F
.51412 .8618 m .51326 .8594 L .49865 .81431 L F
.51614 .8674 m .51576 .86714 L p .51412 .8618 L F P
0 g
s
.903 .498 .213 r
.51576 .86714 m .49575 .813 L p .49865 .81431 L F P
0 g
s
.903 .498 .213 r
.49575 .813 m .49535 .81192 L .49646 .81272 L p F P
0 g
s
.93 .583 .352 r
.49646 .81272 m .49535 .81192 L p .49333 .79618 L F P
0 g
s
.93 .583 .352 r
.49535 .81192 m .47797 .72291 L p .47924 .72177 L F P
0 g
s
.949 .599 .299 r
.47979 .71817 m .47828 .7167 L p .49712 .81245 L F P
0 g
s
.949 .599 .299 r
.49712 .81245 m .47828 .7167 L .49333 .79618 L F
.49717 .81243 m .47979 .71817 L p .49712 .81245 L F P
0 g
s
.903 .563 .389 r
.47979 .71817 m .49717 .81243 L p .49865 .81431 L F P
0 g
s
.903 .563 .389 r
.48935 .76185 m .47979 .71817 L .49865 .81431 L F
.93 .583 .352 r
.48362 .7208 m .49865 .81431 L .48772 .75262 L F
.903 .563 .389 r
.49852 .79959 m .47979 .71817 L .50115 .81577 L F
.93 .583 .352 r
.48184 .71943 m .49213 .78985 L .47924 .72177 L F
.49213 .78985 m .49535 .81192 L .47924 .72177 L F
.47797 .72291 m .47649 .71533 L .47828 .7167 L p F P
0 g
s
.954 .618 .333 r
.47979 .71817 m .47861 .71016 L p .47858 .71075 L F P
0 g
s
.954 .618 .333 r
.47979 .71817 m .46174 .6074 L .47499 .69492 L F
.933 .599 .381 r
.47828 .7167 m .47649 .71533 L p .47499 .69492 L F P
0 g
s
.933 .599 .381 r
.47649 .71533 m .45931 .60541 L .46174 .6074 L p F P
0 g
s
.933 .599 .381 r
.47378 .68694 m .47649 .71533 L .46174 .6074 L F
.954 .618 .333 r
.46379 .60951 m .46174 .6074 L p .47858 .71075 L F P
0 g
s
.954 .618 .333 r
.47861 .71016 m .46379 .60951 L p .47858 .71075 L F P
0 g
s
.933 .599 .381 r
.46897 .61329 m .48184 .71943 L .4713 .64486 L F
.46656 .61132 m .46897 .61329 L p .4713 .64486 L F P
0 g
s
.905 .577 .414 r
.47722 .67274 m .47691 .66933 L .46379 .60951 L F
.286 .717 .968 r
.46138 .57556 m .46069 .576 L .46308 .57669 L F
.46308 .57669 m .46069 .576 L .46045 .57614 L F
.932 .597 .376 r
.45538 .51745 m .46897 .61329 L .46656 .61132 L p F P
0 g
s
.905 .577 .414 r
.47204 .61492 m .46656 .61132 L p .47691 .66933 L F P
0 g
s
.905 .577 .414 r
.46656 .61132 m .46379 .60951 L p .47691 .66933 L F P
0 g
s
.932 .597 .376 r
.46174 .6074 m .45931 .60541 L p .45847 .58661 L F P
0 g
s
.299 .739 .965 r
.46138 .57556 m .45767 .57583 L .45292 .57499 L F
.46071 .57598 m .45767 .57583 L .46138 .57556 L F
.46069 .576 m .46045 .57614 L .45767 .57583 L F
.771 .626 .699 r
.45307 .52911 m .43275 .52357 L p .43867 .51919 L F P
0 g
s
.299 .739 .965 r
.45292 .57499 m .45767 .57583 L .44652 .57457 L F
.954 .615 .328 r
.46379 .60951 m .44638 .50973 L .45847 .58661 L F
.96 .624 .257 r
.44335 .50713 m .44526 .52543 L .4442 .52192 L F
.282 .698 .971 r
.45176 .57194 m .44755 .57405 L p .43452 .57079 L F P
0 g
s
.282 .698 .971 r
.45176 .57194 m .43452 .57079 L .43796 .56943 L F
.954 .615 .328 r
.43868 .50139 m .45559 .60105 L .45765 .60318 L p F P
0 g
s
.954 .615 .328 r
.44755 .54219 m .43868 .50139 L .45765 .60318 L F
.932 .597 .376 r
.45931 .60541 m .44335 .50713 L .44638 .50973 L p F P
0 g
s
.954 .615 .328 r
.46379 .60951 m .44894 .5125 L .44638 .50973 L p F P
0 g
s
.905 .575 .41 r
.44894 .5125 m .46379 .60951 L .46656 .61132 L p F P
0 g
s
.905 .575 .41 r
.45782 .55187 m .44894 .5125 L .46656 .61132 L F
.45653 .54312 m .44894 .5125 L .45782 .55187 L F
.932 .597 .376 r
.45653 .54312 m .46656 .61132 L .45725 .55918 L F
.45538 .51745 m .46656 .61132 L .45653 .54312 L F
.905 .575 .41 r
.46679 .58449 m .45653 .54312 L .47204 .61492 L F
.45653 .54312 m .45782 .55187 L .47204 .61492 L F
.46656 .61132 m .47204 .61492 L p .45782 .55187 L F P
0 g
s
.932 .597 .376 r
.45238 .51487 m .45538 .51745 L p .45653 .54312 L F P
0 g
s
.874 .533 .402 r
.45919 .51958 m .45538 .51745 L p .45646 .50462 L F P
0 g
s
.905 .575 .41 r
.45919 .51958 m .44894 .5125 L p .4693 .59461 L F P
0 g
s
.932 .597 .376 r
.44638 .50973 m .45238 .51487 L p .45847 .58661 L F P
0 g
s
.932 .597 .376 r
.45653 .54312 m .45847 .58661 L .45238 .51487 L F
.45847 .58661 m .45931 .60541 L .44638 .50973 L F
.954 .615 .328 r
.46174 .6074 m .46379 .60951 L p .45847 .58661 L F P
0 g
s
.954 .615 .328 r
.45847 .58661 m .45604 .57612 L .46174 .6074 L F
.44607 .5332 m .43868 .50139 L .44755 .54219 L F
.96 .624 .257 r
.44335 .50713 m .45931 .60541 L .45765 .60318 L p F P
0 g
s
.931 .611 .154 r
.45559 .60105 m .43868 .50139 L .4371 .49832 L p F P
0 g
s
.931 .611 .154 r
.45559 .60105 m .4371 .49832 L .45068 .57737 L F
.954 .615 .328 r
.44126 .50419 m .43868 .50139 L p .44607 .5332 L F P
0 g
s
.282 .698 .971 r
.44889 .57139 m .43826 .56931 L .43949 .56882 L F
.76 .65 .741 r
.4462 .55534 m .42395 .54936 L p .44639 .5546 L F P
0 g
s
.96 .624 .257 r
.4442 .52192 m .45015 .57433 L .4371 .49832 L F
.45015 .57433 m .45267 .59646 L .4371 .49832 L F
.45434 .59871 m .45267 .59646 L p .45068 .57737 L F P
0 g
s
.96 .624 .257 r
.44607 .5332 m .44977 .56866 L .4442 .52192 L F
.44977 .56866 m .45267 .59646 L .44875 .56198 L F
.44977 .56866 m .44875 .56198 L .4442 .52192 L F
.95 .603 .221 r
.47649 .71533 m .48204 .74782 L .47566 .71574 L F
.949 .599 .299 r
.47528 .71378 m .47376 .7123 L p .48204 .74782 L F P
0 g
s
.934 .617 .162 r
.47376 .7123 m .47242 .70411 L p .47246 .7047 L F P
0 g
s
.961 .628 .263 r
.45267 .59646 m .45434 .59871 L p .47047 .70172 L F P
0 g
s
.961 .628 .263 r
.47163 .70912 m .47023 .70083 L p .47047 .70172 L F P
0 g
s
.961 .628 .263 r
.47023 .70083 m .45267 .59646 L p .47047 .70172 L F P
0 g
s
.913 .583 .111 r
.47532 .71999 m .47376 .7123 L .47285 .71068 L p F P
0 g
s
.95 .603 .221 r
.47405 .71653 m .47326 .71692 L .47285 .71068 L F
.961 .628 .263 r
.46916 .68839 m .47163 .70912 L .45434 .59871 L F
.95 .603 .221 r
.47326 .71692 m .47163 .70912 L .47285 .71068 L p F P
0 g
s
.934 .617 .162 r
.47376 .7123 m .45434 .59871 L .46916 .68839 L F
.45559 .60105 m .45434 .59871 L p .47246 .7047 L F P
0 g
s
.934 .617 .162 r
.47242 .70411 m .45559 .60105 L p .47246 .7047 L F P
0 g
s
.961 .628 .263 r
.45931 .60541 m .47649 .71533 L .47528 .71378 L p F P
0 g
s
.961 .628 .263 r
.45931 .60541 m .47528 .71378 L .46312 .63751 L F
.954 .618 .333 r
.45559 .60105 m .47242 .70411 L p .47442 .7084 L F P
0 g
s
.954 .618 .333 r
.46476 .64781 m .45559 .60105 L .47442 .7084 L F
.45765 .60318 m .45559 .60105 L p .46312 .63751 L F P
0 g
s
.931 .611 .154 r
.45434 .59871 m .45559 .60105 L p .45068 .57737 L F P
0 g
s
.933 .599 .381 r
.4713 .64486 m .47499 .69492 L .46656 .61132 L F
.47499 .69492 m .47649 .71533 L .47378 .68694 L F
.47499 .69492 m .47378 .68694 L .46656 .61132 L F
.954 .618 .333 r
.47499 .69492 m .45559 .60105 L .47828 .7167 L F
.961 .628 .263 r
.45434 .59871 m .45765 .60318 L p .46916 .68839 L F P
0 g
s
.961 .628 .263 r
.45765 .60318 m .45931 .60541 L p .46312 .63751 L F P
0 g
s
.961 .628 .263 r
.46312 .63751 m .46916 .68839 L .45765 .60318 L F
.954 .618 .333 r
.47828 .7167 m .46476 .64781 L .47442 .7084 L F
.47242 .70411 m .47376 .7123 L .47528 .71378 L p F P
0 g
s
.954 .618 .333 r
.47528 .71378 m .47828 .7167 L p .47242 .70411 L F P
0 g
s
.913 .583 .111 r
.47532 .71999 m .47285 .71068 L .47405 .71653 L F
.49343 .80899 m .47532 .71999 L .47405 .71653 L F
.49368 .81016 m .49344 .80898 L p .49343 .80899 L F P
0 g
s
.913 .583 .111 r
.49344 .80898 m .47532 .71999 L p .49343 .80899 L F P
0 g
s
.905 .495 .132 r
.49368 .81016 m .5152 .86656 L .51551 .86684 L p F P
0 g
s
.905 .495 .132 r
.50707 .8443 m .49368 .81016 L .51551 .86684 L F
.876 .472 .022 r
.49535 .81192 m .51576 .86714 L .51551 .86684 L p F P
0 g
s
.905 .495 .132 r
.50497 .83868 m .49368 .81016 L .50707 .8443 L F
.792 .414 0 r
.5152 .86656 m .49368 .81016 L .49313 .80922 L p F P
0 g
s
.792 .414 0 r
.5152 .86656 m .49313 .80922 L .51278 .86042 L F
.876 .472 .022 r
.49535 .81192 m .51551 .86684 L .50497 .83868 L F
.49572 .81295 m .50497 .83868 L .49461 .81101 L F
.49461 .81101 m .49535 .81192 L p .49572 .81295 L F P
0 g
s
.949 .599 .299 r
.49646 .81272 m .49738 .81357 L p .49333 .79618 L F P
0 g
s
.903 .498 .213 r
.49646 .81272 m .49865 .81431 L p .49575 .813 L F P
0 g
s
.93 .583 .352 r
.48772 .75262 m .49535 .81192 L .48184 .71943 L F
.905 .495 .132 r
.49646 .81272 m .49461 .81101 L p .51412 .8618 L F P
0 g
s
.905 .495 .132 r
.49461 .81101 m .49368 .81016 L p .49411 .81126 L F P
0 g
s
.905 .495 .132 r
.51412 .8618 m .49461 .81101 L .49411 .81126 L F
.949 .599 .299 r
.47376 .7123 m .49344 .80898 L p .49461 .81101 L F P
0 g
s
.949 .599 .299 r
.48393 .75728 m .47376 .7123 L .49461 .81101 L F
.913 .583 .111 r
.49368 .81016 m .47405 .71653 L .48964 .79227 L F
.95 .603 .221 r
.47649 .71533 m .49513 .81076 L p .49444 .81014 L F P
0 g
s
.95 .603 .221 r
.47649 .71533 m .49444 .81014 L .48204 .74782 L F
.949 .599 .299 r
.49333 .79618 m .48204 .74782 L .49646 .81272 L F
.48204 .74782 m .47376 .7123 L .48393 .75728 L F
.48204 .74782 m .48393 .75728 L .49646 .81272 L F
.95 .603 .221 r
.48964 .79227 m .49307 .80892 L .49238 .80831 L F
.913 .583 .111 r
.49313 .80922 m .49368 .81016 L p .48964 .79227 L F P
0 g
s
.949 .599 .299 r
.49344 .80898 m .49368 .81016 L .49461 .81101 L p F P
0 g
s
.95 .603 .221 r
.49461 .81101 m .49238 .80831 L p .49513 .81076 L F P
0 g
s
.95 .603 .221 r
.49238 .80831 m .47326 .71692 L p .47405 .71653 L F P
0 g
s
.95 .603 .221 r
.48837 .78611 m .49238 .80831 L .47405 .71653 L F
.48204 .74782 m .49238 .80831 L .47566 .71574 L F
.913 .583 .111 r
.47012 .70583 m .49122 .8052 L p .49203 .80734 L F P
0 g
s
.913 .583 .111 r
.49122 .8052 m .49148 .8064 L .49203 .80734 L p F P
0 g
s
.913 .583 .111 r
.48044 .75219 m .47012 .70583 L .49203 .80734 L F
.811 .52 0 r
.49213 .80712 m .49238 .80831 L .49203 .80734 L p F P
0 g
s
.876 .472 .022 r
.50497 .83868 m .51278 .86042 L .49461 .81101 L F
.51278 .86042 m .51477 .86596 L .51182 .85792 L F
.51278 .86042 m .51182 .85792 L .49461 .81101 L F
.51477 .86596 m .49282 .80944 L p .49342 .80996 L F P
0 g
s
.876 .472 .022 r
.49461 .81101 m .51182 .85792 L .49342 .80996 L F
.51182 .85792 m .51477 .86596 L .49342 .80996 L F
.49282 .80944 m .49238 .80831 L .49313 .80922 L p F P
0 g
s
.876 .472 .022 r
.49313 .80922 m .49461 .81101 L p .49282 .80944 L F P
0 g
s
0 0 .273 r
.4928 .80939 m .50325 .83626 L .49203 .80734 L F
.876 .472 .022 r
.51502 .86625 m .51477 .86596 L p .51278 .86042 L F P
0 g
s
.792 .414 0 r
.51466 .86564 m .51502 .86625 L p .50553 .84212 L F P
0 g
s
.792 .414 0 r
.51278 .86042 m .50325 .83626 L .51502 .86625 L F
0 0 .273 r
.49238 .80831 m .51477 .86596 L .51466 .86564 L p F P
0 g
s
0 0 .273 r
.49238 .80831 m .51466 .86564 L .50325 .83626 L F
.792 .414 0 r
.50325 .83626 m .49148 .8064 L .50553 .84212 L F
.50325 .83626 m .50553 .84212 L .51502 .86625 L F
.49313 .80922 m .49203 .80734 L p .51278 .86042 L F P
0 g
s
0 0 .273 r
.49203 .80734 m .49238 .80831 L p .4928 .80939 L F P
0 g
s
.792 .414 0 r
.51278 .86042 m .49203 .80734 L .49193 .80755 L F
.811 .52 0 r
.47163 .70912 m .49213 .80712 L p .49203 .80734 L F P
0 g
s
.913 .583 .111 r
.4784 .74247 m .47012 .70583 L .48044 .75219 L F
.811 .52 0 r
.49203 .80734 m .49133 .80542 L p .4784 .74247 L F P
0 g
s
.811 .52 0 r
.47163 .70912 m .49203 .80734 L .4784 .74247 L F
.913 .583 .111 r
.48964 .79227 m .4784 .74247 L .49313 .80922 L F
.4784 .74247 m .48044 .75219 L .49313 .80922 L F
.49217 .80758 m .49313 .80922 L p .4927 .8073 L F P
0 g
s
.913 .583 .111 r
.4927 .8073 m .48044 .75219 L .49217 .80758 L F
.49203 .80734 m .49217 .80758 L p .48044 .75219 L F P
0 g
s
.95 .603 .221 r
.48204 .74782 m .49444 .81014 L .49307 .80892 L F
.48204 .74782 m .49307 .80892 L .48964 .79227 L F
.811 .52 0 r
.47104 .70746 m .47163 .70912 L p .4784 .74247 L F P
0 g
s
.934 .617 .162 r
.47285 .71068 m .47376 .7123 L p .46916 .68839 L F P
0 g
s
.961 .628 .263 r
.47528 .71378 m .47285 .71068 L p .46312 .63751 L F P
0 g
s
.961 .628 .263 r
.47285 .71068 m .47163 .70912 L p .46916 .68839 L F P
0 g
s
.961 .628 .263 r
.46312 .63751 m .47285 .71068 L .46916 .68839 L F
.934 .617 .162 r
.45059 .5917 m .47012 .70583 L .47104 .70746 L p F P
0 g
s
.934 .617 .162 r
.4596 .63986 m .45059 .5917 L .47104 .70746 L F
.846 .565 .026 r
.47023 .70083 m .47163 .70912 L .47104 .70746 L p F P
0 g
s
.913 .583 .111 r
.47285 .71068 m .47104 .70746 L p .47405 .71653 L F P
0 g
s
.913 .583 .111 r
.47104 .70746 m .47012 .70583 L p .4712 .70875 L F P
0 g
s
.913 .583 .111 r
.47405 .71653 m .47104 .70746 L .4712 .70875 L F
.846 .565 .026 r
.45267 .59646 m .47023 .70083 L p .47104 .70746 L F P
0 g
s
.846 .565 .026 r
.45267 .59646 m .47104 .70746 L .45781 .62929 L F
.934 .617 .162 r
.46916 .68839 m .45781 .62929 L .47285 .71068 L F
.45781 .62929 m .45059 .5917 L .4596 .63986 L F
.45781 .62929 m .4596 .63986 L .47285 .71068 L F
.913 .583 .111 r
.48964 .79227 m .47405 .71653 L .47012 .70583 L F
0 0 .193 r
.47012 .70583 m .46987 .70414 L p .49123 .8052 L F P
0 g
s
0 0 .193 r
.49122 .8052 m .47012 .70583 L p .49123 .8052 L F P
0 g
s
0 0 .193 r
.49148 .8064 m .46987 .70414 L .48764 .78802 L F
.811 .52 0 r
.49098 .80445 m .47098 .71049 L p .471 .7095 L F P
0 g
s
.811 .52 0 r
.47104 .70746 m .48623 .78135 L .471 .7095 L F
.48623 .78135 m .49098 .80445 L .471 .7095 L F
.846 .565 .026 r
.45185 .59405 m .45267 .59646 L p .45781 .62929 L F P
0 g
s
.96 .624 .257 r
.45267 .59646 m .435 .49536 L .4371 .49832 L p F P
0 g
s
.934 .617 .162 r
.4635 .65889 m .46296 .65534 L .45059 .5917 L F
.841 .558 .016 r
.435 .49536 m .45267 .59646 L .45185 .59405 L p F P
0 g
s
.934 .617 .162 r
.45434 .59871 m .45185 .59405 L p .46296 .65534 L F P
0 g
s
.934 .617 .162 r
.45185 .59405 m .45059 .5917 L p .46296 .65534 L F P
0 g
s
.931 .611 .154 r
.45059 .5917 m .45185 .59405 L p .44067 .53388 L F P
0 g
s
0 0 .134 r
.45059 .5917 m .45021 .58925 L p .46112 .65312 L F P
0 g
s
0 0 .134 r
.46879 .69804 m .45059 .5917 L .46112 .65312 L F
.328 0 0 r
.44652 .57457 m .4459 .57423 L p .44447 .57387 L F P
0 g
s
.282 .698 .971 r
.44755 .57405 m .44652 .57457 L .43362 .57114 L p F P
0 g
s
.931 .611 .154 r
.43236 .48909 m .45059 .5917 L p .44067 .53388 L F P
0 g
s
.841 .558 .016 r
.435 .49536 m .45185 .59405 L .4392 .52207 L F
.931 .611 .154 r
.45185 .59405 m .45434 .59871 L p .44082 .53132 L F P
0 g
s
.931 .611 .154 r
.44082 .53132 m .43236 .48909 L .45185 .59405 L F
.45068 .57737 m .4392 .52207 L .45434 .59871 L F
.4392 .52207 m .43236 .48909 L .44082 .53132 L F
.4392 .52207 m .44082 .53132 L .45434 .59871 L F
.841 .558 .016 r
.43395 .49219 m .435 .49536 L p .4392 .52207 L F P
0 g
s
.931 .611 .154 r
.4371 .49832 m .43236 .48909 L p .45068 .57737 L F P
0 g
s
.841 .558 .016 r
.43185 .48586 m .43395 .49219 L p .44492 .55943 L F P
0 g
s
.782 .489 0 r
.42303 .44562 m .42933 .47249 L .43185 .48586 L F
.43395 .49219 m .43185 .48586 L p .42933 .47249 L F P
0 g
s
.782 .489 0 r
.4169 .41946 m .41636 .41843 L .41602 .41724 L F
.417 .41991 m .41636 .41843 L .4169 .41946 L F
.417 .41991 m .41806 .42443 L .41636 .41843 L F
0 0 .234 r
.42792 .46919 m .41554 .41672 L .41321 .40425 L F
.42792 .46919 m .41321 .40425 L .41784 .42398 L F
0 0 .368 r
.41429 .40884 m .42696 .45554 L .41271 .39381 L F
0 0 .234 r
.41554 .41672 m .41266 .40191 L .41321 .40425 L F
0 0 .368 r
.41476 .41329 m .41784 .42398 L .41429 .40884 L F
.41784 .42398 m .42696 .45554 L .41429 .40884 L F
0 0 .488 r
.41394 .40993 m .41457 .41393 L p .41075 .40306 L F P
0 g
s
0 0 .488 r
.41075 .40306 m .40984 .40046 L .41092 .40296 L F
.41075 .40306 m .41092 .40296 L .41394 .40993 L F
.71 .337 0 r
.40371 .3871 m .4032 .38592 L .40121 .38202 L F
0 0 .372 r
.39938 .37849 m .4086 .39759 L .39616 .36885 L F
.40367 .38835 m .41264 .40595 L .39938 .37849 L F
0 0 .488 r
.41457 .41393 m .39561 .36757 L .40984 .40046 L F
.71 .337 0 r
.40367 .38835 m .39639 .37233 L .40526 .39198 L F
.40367 .38835 m .39888 .37736 L .39639 .37233 L F
0 0 .372 r
.39882 .37721 m .39921 .37812 L .39742 .37287 L F
.71 .337 0 r
.39868 .3769 m .39639 .37233 L p .39888 .37736 L F P
0 g
s
0 0 .488 r
.41457 .41393 m .39639 .37233 L p .39616 .36892 L F P
0 g
s
.782 .489 0 r
.43079 .48266 m .41264 .40595 L .41394 .40993 L p F P
0 g
s
0 0 .488 r
.41266 .40191 m .41394 .40993 L p .4096 .39469 L F P
0 g
s
0 0 .368 r
.41307 .40366 m .41429 .40884 L .41351 .40139 L F
.41271 .39381 m .41266 .40191 L p .41351 .40139 L F P
0 g
s
0 0 .368 r
.41266 .40191 m .41264 .40595 L p .41351 .40139 L F P
0 g
s
0 0 .368 r
.41784 .42398 m .43085 .4794 L .42644 .45375 L F
.43085 .4794 m .43096 .47289 L p .42855 .46605 L F P
0 g
s
.841 .558 .016 r
.4392 .52207 m .44631 .56729 L .43395 .49219 L F
0 0 .144 r
.45059 .5917 m .43236 .48909 L p .43515 .5044 L F P
0 g
s
0 0 .144 r
.45059 .5917 m .43515 .5044 L .44631 .56729 L F
.841 .558 .016 r
.44631 .56729 m .44938 .58682 L .44492 .55943 L F
.44631 .56729 m .44492 .55943 L .43395 .49219 L F
0 0 .144 r
.44631 .56729 m .43515 .5044 L .43899 .52553 L F
.841 .558 .016 r
.4392 .52207 m .45185 .59405 L .44183 .53878 L F
.44183 .53878 m .44283 .54433 L .44766 .57391 L F
.44283 .54433 m .45185 .59405 L .44766 .57391 L F
.45185 .59405 m .45021 .58925 L p .44766 .57391 L F P
0 g
s
.841 .558 .016 r
.44183 .53878 m .45021 .58925 L .44491 .55837 L F
.928 .573 .332 r
.44638 .50973 m .44335 .50713 L p .4431 .49427 L F P
0 g
s
.945 .587 .274 r
.44126 .50419 m .44638 .50973 L p .42986 .45298 L F P
0 g
s
.945 .587 .274 r
.4431 .49427 m .42986 .45298 L .44638 .50973 L F
.942 .587 .19 r
.44126 .50419 m .4371 .49832 L p .43129 .45938 L F P
0 g
s
.024 .026 .519 r
.4322 .4664 m .43456 .46001 L p .43107 .45272 L F P
0 g
s
.96 .624 .257 r
.45765 .60318 m .45434 .59871 L p .44607 .5332 L F P
0 g
s
.96 .624 .257 r
.44607 .5332 m .45434 .59871 L .45068 .57737 L F
.4371 .49832 m .44126 .50419 L p .4442 .52192 L F P
0 g
s
.88 .465 .218 r
.44175 .43793 m .43454 .41816 L .42829 .41327 L F
.265 .183 .573 r
.43803 .4538 m .44258 .44785 L p .43815 .43995 L F P
0 g
s
.903 .554 .373 r
.45238 .51487 m .45919 .51958 L p .44254 .46544 L F P
0 g
s
.903 .554 .373 r
.45646 .50462 m .44254 .46544 L .45919 .51958 L F
.928 .573 .332 r
.45238 .51487 m .44638 .50973 L p .44377 .47162 L F P
0 g
s
.845 .511 .422 r
.45886 .47584 m .45082 .45453 L .46674 .5238 L F
.45573 .45682 m .45082 .45453 L p .45598 .45833 L F P
0 g
s
.845 .511 .422 r
.45671 .46279 m .45598 .45833 L .45082 .45453 L F
.874 .533 .402 r
.44675 .45162 m .45573 .45682 L p .45646 .50462 L F P
0 g
s
.859 .454 .268 r
.44768 .43254 m .45573 .45682 L .44467 .44591 L F
.832 .439 .305 r
.45573 .45682 m .46546 .46136 L p .44867 .43553 L F P
0 g
s
.832 .439 .305 r
.44489 .42413 m .45037 .42631 L .44464 .42338 L F
.4633 .45399 m .45614 .42946 L .44499 .42443 L F
.4633 .45399 m .44499 .42443 L .44768 .43254 L F
.45614 .42946 m .45585 .42848 L .45037 .42631 L F
.45585 .42848 m .44456 .42313 L p .45037 .42631 L F P
0 g
s
.804 .421 .331 r
.46812 .43396 m .46263 .45167 L .45585 .42848 L F
.413 .282 .592 r
.44815 .44223 m .4547 .43702 L p .44954 .4284 L F P
0 g
s
.874 .533 .402 r
.45886 .47584 m .45646 .50462 L .45573 .45682 L F
.45886 .47584 m .45919 .51958 L .45646 .50462 L F
.45984 .48183 m .45919 .51958 L .45886 .47584 L F
.845 .511 .422 r
.46106 .46208 m .45573 .45682 L .45598 .45833 L F
.45671 .46279 m .46106 .46208 L .45598 .45833 L F
.874 .533 .402 r
.46674 .5238 m .45919 .51958 L p .45984 .48183 L F P
0 g
s
.845 .511 .422 r
.46546 .46136 m .45573 .45682 L p .46106 .46208 L F P
0 g
s
.804 .421 .331 r
.46794 .43324 m .46812 .43396 L .46201 .43123 L F
.45585 .42848 m .46788 .433 L p .46201 .43123 L F P
0 g
s
.804 .421 .331 r
.46788 .433 m .47391 .43527 L p .46201 .43123 L F P
0 g
s
.512 .351 .599 r
.46215 .43228 m .47041 .42808 L p .46476 .41866 L F P
0 g
s
.787 .468 .447 r
.47806 .48375 m .47033 .46363 L .48367 .53061 L F
.47583 .46519 m .47033 .46363 L p .47601 .46667 L F P
0 g
s
.787 .468 .447 r
.47653 .47101 m .47601 .46667 L .47033 .46363 L F
.816 .49 .437 r
.46546 .46136 m .47583 .46519 L p .47284 .51292 L F P
0 g
s
.816 .49 .437 r
.47806 .48375 m .47284 .51292 L .47583 .46519 L F
.47806 .48375 m .47493 .52749 L .47284 .51292 L F
.47876 .48961 m .47493 .52749 L .47806 .48375 L F
.48367 .53061 m .47493 .52749 L p .47876 .48961 L F P
0 g
s
.774 .402 .35 r
.48072 .43771 m .46788 .433 L .46797 .43337 L F
.4807 .43759 m .46788 .433 L .48072 .43771 L F
0 .523 .778 r
.49361 .4394 m .48051 .43665 L p .48178 .437 L F P
0 g
s
.744 .38 .363 r
.48051 .43665 m .49361 .4394 L p .48715 .4385 L F P
0 g
s
.617 .427 .602 r
.48733 .40144 m .49407 .33501 L .49513 .35317 L F
.586 .404 .601 r
.48651 .39906 m .48309 .41125 L .48895 .42152 L F
.47938 .42448 m .48895 .42152 L p .48309 .41125 L F P
0 g
s
.787 .468 .447 r
.48367 .53061 m .49287 .53313 L p .47806 .48375 L F P
0 g
s
.787 .468 .447 r
.49152 .51884 m .47806 .48375 L .49287 .53313 L F
.744 .38 .363 r
.49485 .44811 m .4858 .46353 L .48534 .46119 L F
.714 .358 .372 r
.50907 .46522 m .50714 .44226 L .49366 .43975 L F
.646 .449 .602 r
.5079 .39491 m .50363 .40658 L .50919 .4118 L F
.499 .41925 m .5094 .4177 L p .50363 .40658 L F P
0 g
s
.698 .491 .603 r
.51882 .3269 m .53092 .39649 L .53151 .33306 L F
.51913 .35038 m .53092 .39649 L .51882 .3269 L F
.747 .532 .602 r
.55688 .32632 m .54436 .32451 L p .55332 .39158 L F P
0 g
s
.796 .575 .601 r
.56698 .35539 m .5638 .39688 L .5716 .42398 L F
.56698 .35539 m .5716 .42398 L .57356 .40403 L F
.58056 .33263 m .569 .32904 L p .56836 .33732 L F P
0 g
s
.772 .553 .602 r
.56194 .42113 m .55182 .41897 L p .55598 .40313 L F P
0 g
s
.673 .47 .603 r
.5094 .4177 m .51222 .40084 L .51441 .40536 L F
.52002 .41689 m .5094 .4177 L p .51441 .40536 L F P
0 g
s
.67 .458 .589 r
.5094 .4177 m .52002 .41689 L p .51832 .4349 L F P
0 g
s
.67 .458 .589 r
.51182 .50346 m .5094 .4177 L .51832 .4349 L F
.714 .358 .372 r
.50907 .46522 m .49366 .43975 L .49485 .44811 L F
.50907 .46522 m .49485 .44811 L .50966 .47217 L F
.49485 .44811 m .49525 .45089 L .50966 .47217 L F
.49805 .47062 m .50966 .47217 L p .49525 .45089 L F P
0 g
s
.643 .437 .589 r
.49999 .44088 m .51207 .51256 L .5094 .4177 L F
.50061 .45461 m .51207 .51256 L .49999 .44088 L F
.613 .414 .588 r
.49462 .51201 m .48895 .42152 L .49999 .44088 L F
.58 .389 .587 r
.48895 .42152 m .47938 .42448 L p .49484 .51561 L F P
0 g
s
.544 .362 .585 r
.48107 .44586 m .47583 .43712 L .47981 .42999 L F
.47041 .42808 m .47938 .42448 L p .47583 .43712 L F P
0 g
s
.787 .468 .447 r
.48673 .46829 m .47583 .46519 L p .4816 .46966 L F P
0 g
s
.58 .389 .587 r
.48214 .45943 m .49484 .51561 L .47938 .42448 L F
.544 .362 .585 r
.47938 .42448 m .4839 .42266 L p .47981 .42999 L F P
0 g
s
.544 .362 .585 r
.47583 .43712 m .47938 .42448 L .47981 .42999 L F
.787 .468 .447 r
.4816 .46966 m .47583 .46519 L .47601 .46667 L F
.47653 .47101 m .4816 .46966 L .47601 .46667 L F
.544 .362 .585 r
.4792 .52085 m .47041 .42808 L .48267 .44852 L F
.586 .404 .601 r
.47276 .35935 m .47938 .42448 L .48651 .39906 L F
.47276 .35935 m .48733 .40144 L .4701 .33325 L F
.552 .379 .6 r
.47551 .33097 m .4839 .42266 L .47938 .42448 L p F P
0 g
s
.512 .351 .599 r
.46716 .4061 m .46476 .41866 L .47041 .42808 L F
.46716 .4061 m .47041 .42808 L .468 .40835 L F
.552 .379 .6 r
.47938 .42448 m .46591 .42989 L p .47276 .35935 L F P
0 g
s
.552 .379 .6 r
.47276 .35935 m .47551 .33097 L .47938 .42448 L F
.468 .40835 m .47042 .33637 L .47276 .35935 L F
.46725 .40218 m .47042 .33637 L .468 .40835 L F
.46725 .40218 m .4605 .34691 L .47042 .33637 L F
.512 .351 .599 r
.44992 .34576 m .468 .40835 L .46038 .3459 L F
.467 .319 .596 r
.44067 .349 m .44954 .34305 L p .45164 .41777 L F P
0 g
s
.467 .319 .596 r
.45164 .41777 m .44954 .34305 L .45314 .36857 L F
.501 .379 .645 r
.44067 .349 m .43829 .3401 L .44398 .34159 L F
.44954 .34305 m .44067 .349 L p .44398 .34159 L F P
0 g
s
.512 .351 .599 r
.45314 .36857 m .468 .40835 L .44992 .34576 L F
.467 .319 .596 r
.46215 .43228 m .4547 .43702 L p .45671 .42327 L F P
0 g
s
.455 .298 .578 r
.4547 .43702 m .46215 .43228 L p .45966 .44529 L F P
0 g
s
.503 .332 .582 r
.46294 .43948 m .4792 .52085 L .47242 .44929 L F
.845 .511 .422 r
.46674 .5238 m .47493 .52749 L p .45886 .47584 L F P
0 g
s
.845 .511 .422 r
.47284 .51292 m .45886 .47584 L .47493 .52749 L F
.455 .298 .578 r
.46592 .528 m .4547 .43702 L .46445 .45329 L F
.46592 .528 m .46445 .45329 L .46592 .46663 L F
.503 .332 .582 r
.46592 .46663 m .4792 .52085 L .46294 .43948 L F
.47041 .42808 m .46215 .43228 L p .47242 .44929 L F P
0 g
s
.503 .332 .582 r
.46294 .43948 m .47242 .44929 L .46215 .43228 L F
.455 .298 .578 r
.46591 .45573 m .46445 .45329 L .46591 .42989 L F
.46445 .45329 m .45966 .44529 L .46274 .43769 L F
.46445 .45329 m .46274 .43769 L .46591 .42989 L F
.46215 .43228 m .46591 .42989 L p .46274 .43769 L F P
0 g
s
.455 .298 .578 r
.45966 .44529 m .46215 .43228 L .46274 .43769 L F
.876 .553 .437 r
.48061 .66465 m .48212 .69277 L .47204 .61492 L F
.875 .552 .434 r
.47812 .61814 m .47204 .61492 L p .46979 .56737 L F P
0 g
s
.875 .552 .434 r
.46979 .56737 m .47204 .61492 L .46945 .58609 L F
.397 .257 .571 r
.45094 .46277 m .46592 .528 L .4547 .43702 L F
.327 .208 .561 r
.45513 .53328 m .44258 .44785 L .45094 .46277 L F
.238 .147 .545 r
.44258 .44785 m .43803 .4538 L p .45563 .53669 L F P
0 g
s
.123 .069 .519 r
.44116 .47381 m .43791 .46702 L .43884 .45895 L F
.43456 .46001 m .43803 .4538 L p .43791 .46702 L F P
0 g
s
.238 .147 .545 r
.44315 .48652 m .45563 .53669 L .43803 .4538 L F
.123 .069 .519 r
.43803 .4538 m .43978 .45066 L p .43884 .45895 L F P
0 g
s
.123 .069 .519 r
.43791 .46702 m .43803 .4538 L .43884 .45895 L F
.96 .624 .257 r
.44335 .50713 m .45765 .60318 L .44607 .5332 L F
.44126 .50419 m .44335 .50713 L p .4442 .52192 L F P
0 g
s
.954 .615 .328 r
.44638 .50973 m .44126 .50419 L p .45847 .58661 L F P
0 g
s
.96 .624 .257 r
.44526 .52543 m .44607 .5332 L .4442 .52192 L F
.954 .615 .328 r
.45847 .58661 m .44126 .50419 L .44607 .5332 L F
.45604 .57612 m .44607 .5332 L .46174 .6074 L F
.44607 .5332 m .44755 .54219 L .46174 .6074 L F
.123 .069 .519 r
.44878 .54646 m .43456 .46001 L .44215 .47588 L F
.88 .465 .218 r
.43412 .417 m .42465 .41014 L p .43449 .41803 L F P
0 g
s
.265 .183 .573 r
.4258 .39393 m .43803 .4538 L .43826 .42718 L F
.347 .238 .585 r
.42628 .36256 m .43289 .35553 L p .43901 .42918 L F P
0 g
s
.413 .282 .592 r
.43426 .36331 m .45164 .41777 L .44067 .349 L F
.43725 .3803 m .45164 .41777 L .43426 .36331 L F
.347 .238 .585 r
.43901 .42918 m .43289 .35553 L .43725 .3803 L F
.263 .236 .64 r
.41743 .3699 m .41803 .36179 L .42092 .37001 L F
.41279 .36693 m .40824 .33397 L .41685 .37776 L F
.342 .282 .645 r
.4002 .32435 m .41824 .37373 L .42628 .36256 L p F P
0 g
s
.405 .32 .646 r
.42561 .36049 m .42353 .35411 L .42826 .35483 L F
.43289 .35553 m .42628 .36256 L p .42826 .35483 L F P
0 g
s
.342 .282 .645 r
.4002 .32435 m .42628 .36256 L .42254 .35107 L F
.405 .32 .646 r
.42628 .36256 m .42298 .36608 L p .42826 .35483 L F P
0 g
s
.405 .32 .646 r
.42262 .35397 m .42156 .31743 L .43289 .35553 L F
.42298 .36608 m .41962 .32886 L .42212 .33685 L F
.41962 .32886 m .4173 .30312 L .42212 .33685 L F
.42212 .33685 m .4173 .30312 L .42156 .31743 L F
.457 .351 .646 r
.42156 .31743 m .43744 .33691 L .41728 .30306 L F
.42616 .29467 m .41712 .30252 L p .42659 .2963 L F P
0 g
s
.405 .32 .646 r
.40643 .31748 m .41712 .30252 L .4173 .30312 L F
.554 .539 .792 r
.41712 .30252 m .40948 .31097 L p .40754 .30882 L F P
0 g
s
.457 .351 .646 r
.41712 .30252 m .41261 .30645 L p .42659 .2963 L F P
0 g
s
.405 .32 .646 r
.41712 .30252 m .421 .29825 L p .4173 .30312 L F P
0 g
s
.457 .351 .646 r
.42156 .31743 m .44067 .349 L .43744 .33691 L F
.41261 .30645 m .42296 .32215 L .42156 .31743 L F
.42296 .32215 m .44067 .349 L .42156 .31743 L F
.41261 .30645 m .429 .3588 L .43289 .35553 L p F P
0 g
s
.457 .351 .646 r
.43289 .35553 m .44067 .349 L p .42296 .32215 L F P
0 g
s
.457 .351 .646 r
.41261 .30645 m .43289 .35553 L .42296 .32215 L F
.405 .32 .646 r
.42156 .31743 m .421 .29825 L .43289 .35553 L F
.342 .282 .645 r
.42628 .36256 m .429 .3588 L p .42254 .35107 L F P
0 g
s
.405 .32 .646 r
.42298 .36608 m .42262 .35397 L .42353 .35411 L F
.42298 .36608 m .42353 .35411 L .42561 .36049 L F
.265 .183 .573 r
.43112 .37032 m .429 .3588 L .42628 .36256 L p F P
0 g
s
.265 .183 .573 r
.42628 .36256 m .42092 .37001 L p .42435 .37011 L F P
0 g
s
.265 .183 .573 r
.42435 .37011 m .43112 .37032 L .42628 .36256 L F
.413 .282 .592 r
.43324 .3575 m .43426 .36331 L .43744 .35622 L F
.44067 .349 m .43289 .35553 L p .43744 .35622 L F P
0 g
s
.413 .282 .592 r
.43289 .35553 m .429 .3588 L p .43744 .35622 L F P
0 g
s
.347 .238 .585 r
.44815 .44223 m .44258 .44785 L p .4412 .43033 L F P
0 g
s
.347 .238 .585 r
.4412 .43033 m .43725 .3803 L .44815 .44223 L F
.327 .208 .561 r
.45094 .46277 m .44683 .45544 L .44887 .44752 L F
.44258 .44785 m .44815 .44223 L p .44683 .45544 L F P
0 g
s
.397 .257 .571 r
.4547 .43702 m .44815 .44223 L p .45279 .45015 L F P
0 g
s
.327 .208 .561 r
.44683 .45544 m .44815 .44223 L .44887 .44752 L F
.397 .257 .571 r
.44815 .44223 m .44487 .44484 L p .44887 .44752 L F P
0 g
s
.397 .257 .571 r
.44887 .44752 m .45279 .45015 L .44815 .44223 L F
.44887 .44752 m .45094 .46277 L .45279 .45015 L F
.45272 .47582 m .46592 .528 L .45094 .46277 L F
.46364 .55632 m .46893 .5524 L p .45878 .50701 L F P
0 g
s
.397 .257 .571 r
.45413 .48621 m .46364 .55632 L .45878 .50701 L F
.932 .597 .376 r
.46656 .61132 m .46174 .6074 L p .45725 .55918 L F P
0 g
s
.932 .597 .376 r
.45725 .55918 m .46174 .6074 L .45809 .57803 L F
.954 .618 .333 r
.46174 .6074 m .45765 .60318 L p .46906 .66625 L F P
0 g
s
.954 .618 .333 r
.46906 .66625 m .45765 .60318 L .46312 .63751 L F
.954 .615 .328 r
.45765 .60318 m .46174 .6074 L p .44755 .54219 L F P
0 g
s
0 0 .403 r
.43096 .47289 m .4322 .4664 L p .43327 .47946 L F P
0 g
s
0 0 .403 r
.44508 .5536 m .43096 .47289 L .43551 .48583 L F
0 0 .234 r
.43085 .4794 m .43236 .48909 L p .42735 .46664 L F P
0 g
s
0 0 .144 r
.43327 .49339 m .43304 .49215 L .43171 .48425 L F
0 0 .292 r
.43096 .47289 m .43085 .4794 L p .43431 .49202 L F P
0 g
s
0 0 .144 r
.43327 .49339 m .43171 .48425 L .43199 .48585 L F
.43185 .48586 m .43085 .4794 L p .43304 .49215 L F P
0 g
s
0 0 .144 r
.43304 .49215 m .43085 .4794 L .43171 .48425 L F
.782 .489 0 r
.43185 .48586 m .43079 .48266 L p .42792 .46919 L F P
0 g
s
0 0 .292 r
.43085 .4794 m .43079 .48266 L p .43199 .48585 L F P
0 g
s
0 0 .292 r
.43199 .48585 m .43431 .49202 L .43085 .4794 L F
0 0 .144 r
.43085 .4794 m .43034 .47613 L p .43171 .48425 L F P
0 g
s
0 0 .144 r
.43199 .48585 m .43171 .48425 L .43034 .47613 L F
0 0 .292 r
.43199 .48585 m .44565 .55683 L .43431 .49202 L F
0 0 .144 r
.43515 .5044 m .43185 .48586 L .43327 .49339 L F
0 0 .292 r
.43631 .51022 m .44565 .55683 L .43199 .48585 L F
0 0 .144 r
.43899 .52553 m .43515 .5044 L .43199 .48585 L F
.43631 .51022 m .43199 .48585 L .43034 .47613 L F
.43899 .52553 m .43199 .48585 L .43631 .51022 L F
.43236 .48909 m .43185 .48586 L p .43515 .5044 L F P
0 g
s
.841 .558 .016 r
.44938 .58682 m .43079 .48266 L .43185 .48586 L p F P
0 g
s
.841 .558 .016 r
.44492 .55943 m .44938 .58682 L .43185 .48586 L F
0 0 .144 r
.45021 .58925 m .45059 .5917 L p .44631 .56729 L F P
0 g
s
.841 .558 .016 r
.45021 .58925 m .44938 .58682 L p .44631 .56729 L F P
0 g
s
.841 .558 .016 r
.44491 .55837 m .45021 .58925 L .44631 .56729 L F
0 0 .403 r
.44565 .55683 m .43551 .48583 L .43762 .49818 L F
0 0 .292 r
.44946 .58435 m .4496 .57942 L p .44088 .53402 L F P
0 g
s
0 0 .292 r
.43631 .51022 m .44946 .58435 L .44088 .53402 L F
0 0 .134 r
.47012 .70583 m .45021 .58925 L .46596 .68129 L F
.46869 .69744 m .45059 .5917 L p .46879 .69804 L F P
0 g
s
.846 .565 .026 r
.46927 .70247 m .44938 .58682 L .45021 .58925 L p F P
0 g
s
.846 .565 .026 r
.45021 .58925 m .45185 .59405 L p .46453 .67292 L F P
0 g
s
.846 .565 .026 r
.46453 .67292 m .46927 .70247 L .45021 .58925 L F
.47104 .70746 m .46987 .70414 L p .45781 .62929 L F P
0 g
s
.846 .565 .026 r
.45781 .62929 m .46987 .70414 L .46596 .68129 L F
.45781 .62929 m .46596 .68129 L .45185 .59405 L F
.46596 .68129 m .46927 .70247 L .46453 .67292 L F
.46596 .68129 m .46453 .67292 L .45185 .59405 L F
.934 .617 .162 r
.47104 .70746 m .47285 .71068 L p .4596 .63986 L F P
0 g
s
0 0 .475 r
.45065 .57452 m .4526 .5697 L p .44347 .52736 L F P
0 g
s
0 0 .475 r
.4393 .50801 m .45065 .57452 L .44347 .52736 L F
0 0 .284 r
.4496 .57942 m .44946 .58435 L p .45859 .6349 L F P
0 g
s
0 0 .284 r
.45859 .6349 m .4641 .66536 L .4496 .57942 L F
0 0 .396 r
.4496 .57942 m .45065 .57452 L p .4641 .66536 L F P
0 g
s
0 0 .396 r
.46555 .67394 m .45065 .57452 L .46259 .65294 L F
0 0 .284 r
.45564 .62056 m .46555 .67394 L .44946 .58435 L F
.46555 .67394 m .4641 .66536 L .44946 .58435 L F
0 0 .134 r
.46935 .70076 m .46987 .70414 L p .4575 .63141 L F P
0 g
s
0 0 .134 r
.46987 .70414 m .47012 .70583 L p .46596 .68129 L F P
0 g
s
0 0 .284 r
.46935 .70076 m .4695 .69737 L p .45564 .62056 L F P
0 g
s
.934 .617 .162 r
.46916 .68839 m .45434 .59871 L .4635 .65889 L F
.119 .064 .515 r
.4526 .5697 m .45544 .56502 L p .46242 .62311 L F P
0 g
s
.119 .064 .515 r
.4666 .65789 m .4526 .5697 L .46242 .62311 L F
.238 .147 .545 r
.45544 .56502 m .45913 .56054 L p .44865 .51201 L F P
0 g
s
.932 .597 .376 r
.45809 .57803 m .46174 .6074 L .45847 .58661 L F
.324 .205 .558 r
.45913 .56054 m .46364 .55632 L p .46884 .61548 L F P
0 g
s
.933 .599 .381 r
.46174 .6074 m .46656 .61132 L p .47106 .65846 L F P
0 g
s
.954 .618 .333 r
.47828 .7167 m .47979 .71817 L p .47499 .69492 L F P
0 g
s
.933 .599 .381 r
.48184 .71943 m .47828 .7167 L p .4713 .64486 L F P
0 g
s
.933 .599 .381 r
.4713 .64486 m .47828 .7167 L .47499 .69492 L F
.905 .577 .414 r
.48313 .70058 m .4713 .64486 L .48589 .72193 L F
.4713 .64486 m .47272 .65492 L .48589 .72193 L F
.324 .205 .558 r
.47194 .65087 m .45913 .56054 L .46884 .61548 L F
.453 .295 .576 r
.46893 .5524 m .47492 .54885 L p .47805 .6088 L F P
0 g
s
.453 .295 .576 r
.47992 .64464 m .46893 .5524 L .47805 .6088 L F
.503 .332 .582 r
.47492 .54885 m .48156 .54571 L p .47131 .49391 L F P
0 g
s
.613 .414 .588 r
.49484 .51561 m .49999 .44088 L .50061 .45461 L F
.762 .462 .478 r
.49287 .53313 m .50243 .53503 L p .49739 .59861 L F P
0 g
s
.759 .446 .455 r
.50243 .53503 m .49287 .53313 L p .49968 .49465 L F P
0 g
s
.58 .389 .587 r
.48875 .54301 m .49642 .5408 L p .48707 .48752 L F P
0 g
s
.58 .389 .587 r
.48214 .45943 m .48875 .54301 L .48707 .48752 L F
.817 .506 .463 r
.49179 .62335 m .48473 .62096 L p .48605 .55773 L F P
0 g
s
.817 .506 .463 r
.48605 .55773 m .48473 .62096 L .48264 .60104 L F
.789 .484 .472 r
.49179 .62335 m .49923 .62529 L p .48678 .56614 L F P
0 g
s
.543 .36 .583 r
.48156 .54571 m .48875 .54301 L p .49016 .63952 L F P
0 g
s
.762 .462 .478 r
.50697 .62674 m .49923 .62529 L p .50376 .56184 L F P
0 g
s
.762 .462 .478 r
.50376 .56184 m .49923 .62529 L .49788 .60563 L F
.643 .437 .589 r
.5094 .4177 m .499 .41925 L p .49999 .44088 L F P
0 g
s
.762 .462 .478 r
.50243 .53503 m .50723 .53598 L p .50376 .56184 L F P
0 g
s
.734 .44 .482 r
.51224 .53629 m .50243 .53503 L p .51434 .60821 L F P
0 g
s
.734 .44 .482 r
.51434 .60821 m .50243 .53503 L .50376 .56184 L F
.731 .423 .46 r
.50243 .53503 m .51224 .53629 L p .49929 .48889 L F P
0 g
s
.731 .423 .46 r
.51167 .52215 m .49929 .48889 L .51224 .53629 L F
.67 .458 .589 r
.51207 .51256 m .52002 .41689 L .52039 .45243 L F
.706 .417 .484 r
.51224 .53629 m .5222 .5369 L p .51414 .60124 L F P
0 g
s
.702 .4 .463 r
.5222 .5369 m .51224 .53629 L p .52172 .49678 L F P
0 g
s
.643 .437 .589 r
.50447 .5391 m .51279 .53794 L p .50482 .4834 L F P
0 g
s
.643 .437 .589 r
.50061 .45461 m .50447 .5391 L .50482 .4834 L F
.58 .387 .585 r
.49642 .5408 m .48875 .54301 L p .49715 .60102 L F P
0 g
s
.58 .387 .585 r
.49715 .60102 m .50218 .63578 L .49642 .5408 L F
.612 .412 .586 r
.49642 .5408 m .50447 .5391 L p .50218 .63578 L F P
0 g
s
.734 .44 .482 r
.50697 .62674 m .51491 .62771 L p .50417 .57016 L F P
0 g
s
.612 .412 .586 r
.50275 .64522 m .50447 .5391 L .50394 .62321 L F
.58 .387 .585 r
.49185 .58345 m .50275 .64522 L .48875 .54301 L F
.50275 .64522 m .50218 .63578 L .48875 .54301 L F
.543 .36 .583 r
.49129 .6268 m .48875 .54301 L .49185 .58345 L F
.49101 .64885 m .48875 .54301 L .49129 .6268 L F
.502 .33 .58 r
.47914 .58869 m .49101 .64885 L .47492 .54885 L F
.49101 .64885 m .49016 .63952 L .47492 .54885 L F
.453 .295 .576 r
.48038 .63186 m .47492 .54885 L .47914 .58869 L F
.48101 .65382 m .47492 .54885 L .48038 .63186 L F
.875 .552 .434 r
.46945 .58609 m .47204 .61492 L .4693 .59461 L F
.396 .254 .569 r
.46877 .59538 m .48101 .65382 L .46364 .55632 L F
.48101 .65382 m .47992 .64464 L .46364 .55632 L F
.324 .205 .558 r
.47172 .63812 m .46364 .55632 L .46877 .59538 L F
.905 .577 .414 r
.48184 .71943 m .48589 .72193 L p .47272 .65492 L F P
0 g
s
.324 .205 .558 r
.47322 .65987 m .46364 .55632 L .47172 .63812 L F
.235 .143 .542 r
.4612 .60319 m .47322 .65987 L .45544 .56502 L F
.47322 .65987 m .47194 .65087 L .45544 .56502 L F
.119 .064 .515 r
.4657 .64526 m .45544 .56502 L .4612 .60319 L F
.468 .66669 m .45544 .56502 L .4657 .64526 L F
0 0 .47 r
.45677 .61172 m .468 .66669 L .45065 .57452 L F
.468 .66669 m .4666 .65789 L .45065 .57452 L F
0 0 .396 r
.47032 .694 m .4695 .69737 L p .45861 .62286 L F P
0 g
s
0 0 .396 r
.46555 .67394 m .45677 .61172 L .4695 .69737 L F
.45677 .61172 m .45861 .62286 L .4695 .69737 L F
.4641 .66536 m .45065 .57452 L .46555 .67394 L F
0 0 .47 r
.4526 .5697 m .45065 .57452 L p .4666 .65789 L F P
0 g
s
0 0 .396 r
.45065 .57452 m .45118 .57204 L p .46259 .65294 L F P
0 g
s
0 0 .475 r
.43762 .49818 m .4526 .5697 L .44658 .53695 L F
.4393 .50801 m .4526 .5697 L .43762 .49818 L F
0 0 .403 r
.44407 .54533 m .43762 .49818 L .4496 .57942 L F
0 0 .475 r
.43456 .46001 m .4322 .4664 L p .44878 .54646 L F P
0 g
s
0 0 .475 r
.43762 .49818 m .44878 .54646 L .4322 .4664 L F
0 0 .403 r
.43762 .49818 m .43282 .46312 L .4393 .50801 L F
.43762 .49818 m .4393 .50801 L .4496 .57942 L F
.44508 .5536 m .43551 .48583 L .44565 .55683 L F
.4362 .48777 m .43327 .47946 L .43282 .46312 L F
.4322 .4664 m .43282 .46312 L p .43327 .47946 L F P
0 g
s
.024 .026 .519 r
.41927 .40873 m .4322 .4664 L .43003 .4401 L F
.41573 .39295 m .41979 .4059 L .4161 .3879 L F
.41979 .4059 m .42973 .43757 L .4161 .3879 L F
.4161 .3879 m .42973 .43757 L .41685 .37776 L F
.41927 .40873 m .43068 .44199 L .41573 .39295 L F
.16 .114 .553 r
.43803 .4538 m .43456 .46001 L p .4258 .39393 L F P
0 g
s
.16 .114 .553 r
.43068 .44199 m .4258 .39393 L .43456 .46001 L F
.43068 .44199 m .42092 .37001 L .4258 .39393 L F
.42931 .43562 m .42092 .37001 L .43068 .44199 L F
.024 .026 .519 r
.43068 .44199 m .43575 .45678 L .42973 .43757 L F
.43068 .44199 m .42973 .43757 L .41573 .39295 L F
.43003 .4401 m .43107 .45272 L .43456 .46001 L F
.43003 .4401 m .43456 .46001 L .43068 .44199 L F
.16 .114 .553 r
.43456 .46001 m .43282 .46312 L p .43068 .44199 L F P
0 g
s
.024 .026 .519 r
.41411 .38573 m .41274 .38971 L p .41452 .38756 L F P
0 g
s
.024 .026 .519 r
.41452 .38756 m .41629 .38543 L .41411 .38573 L F
.036 .105 .606 r
.41271 .39381 m .40964 .38634 L .4119 .38603 L F
0 .012 .564 r
.39405 .36283 m .41271 .39381 L .40854 .38366 L F
.036 .105 .606 r
.40921 .3864 m .40074 .3519 L .41411 .38573 L F
.40707 .3801 m .394 .34836 L .39601 .34042 L F
.394 .34836 m .39553 .33871 L p .39601 .34042 L F P
0 g
s
0 .012 .564 r
.39405 .36283 m .41266 .40191 L .41032 .38983 L F
.036 .105 .606 r
.41202 .39785 m .39553 .33871 L .40074 .3519 L F
.164 .179 .629 r
.39398 .34346 m .41274 .38971 L .41411 .38573 L p F P
0 g
s
.164 .179 .629 r
.41411 .38573 m .41824 .37373 L p .40074 .3519 L F P
0 g
s
.164 .179 .629 r
.39398 .34346 m .41411 .38573 L .40074 .3519 L F
.39574 .33924 m .41142 .36327 L .39925 .33082 L F
.40074 .3519 m .41824 .37373 L .39574 .33924 L F
.39553 .33871 m .39398 .34346 L p .40101 .32657 L F P
0 g
s
.036 .105 .606 r
.40074 .3519 m .3963 .33381 L .41411 .38573 L F
0 0 .462 r
.41482 .38163 m .43282 .46312 L .4322 .4664 L p F P
0 g
s
0 0 .462 r
.4322 .4664 m .43096 .47289 L p .42089 .41596 L F P
0 g
s
0 0 .462 r
.42089 .41596 m .41482 .38163 L .4322 .4664 L F
.42696 .45554 m .41482 .38163 L .43096 .47289 L F
.42696 .45554 m .41271 .39381 L .41573 .39295 L F
.42696 .45554 m .41573 .39295 L .41927 .40873 L F
.024 .026 .519 r
.41274 .38971 m .4322 .4664 L .41927 .40873 L F
0 0 .475 r
.4322 .4664 m .43102 .46959 L p .43762 .49818 L F P
0 g
s
0 0 .475 r
.43102 .46959 m .4393 .50801 L .43762 .49818 L F
0 0 .403 r
.44254 .5305 m .4393 .50801 L .45065 .57452 L F
.4393 .50801 m .43282 .46312 L .45065 .57452 L F
.43282 .46312 m .45118 .57204 L .45065 .57452 L p F P
0 g
s
0 0 .403 r
.45065 .57452 m .4496 .57942 L p .44254 .5305 L F P
0 g
s
0 0 .47 r
.44967 .57693 m .46958 .69566 L .47032 .694 L p F P
0 g
s
.933 .599 .381 r
.47106 .65846 m .47378 .68694 L .46174 .6074 L F
.954 .618 .333 r
.47499 .69492 m .46174 .6074 L .46906 .66625 L F
.119 .064 .515 r
.47394 .68748 m .4718 .69069 L p .46293 .61461 L F P
0 g
s
.235 .143 .542 r
.47394 .68748 m .4767 .68441 L p .4612 .60319 L F P
0 g
s
.905 .577 .414 r
.48313 .70058 m .47204 .61492 L .47722 .67274 L F
.324 .205 .558 r
.48007 .68152 m .4767 .68441 L p .4703 .60706 L F P
0 g
s
.905 .577 .414 r
.48589 .72193 m .48793 .72319 L p .48313 .70058 L F P
0 g
s
.876 .553 .437 r
.4904 .72418 m .48589 .72193 L p .48192 .65101 L F P
0 g
s
.876 .553 .437 r
.48192 .65101 m .48589 .72193 L .48313 .70058 L F
.846 .53 .454 r
.4904 .72418 m .49531 .72614 L p .48307 .66088 L F P
0 g
s
.396 .254 .569 r
.48007 .68152 m .48399 .67885 L p .46877 .59538 L F P
0 g
s
.846 .53 .454 r
.4932 .70515 m .48473 .62096 L .48756 .67809 L F
.453 .295 .576 r
.48844 .67643 m .48399 .67885 L p .4804 .6006 L F P
0 g
s
.502 .33 .58 r
.48844 .67643 m .49334 .67428 L p .47914 .58869 L F P
0 g
s
.79 .486 .474 r
.50599 .72727 m .49451 .65571 L .50009 .72207 L F
.50474 .70841 m .49451 .65571 L .50599 .72727 L F
.543 .36 .583 r
.49865 .67245 m .49334 .67428 L p .49277 .59554 L F P
0 g
s
.58 .387 .585 r
.49865 .67245 m .50431 .67095 L p .49185 .58345 L F P
0 g
s
.706 .417 .484 r
.52298 .62817 m .51491 .62771 L p .52242 .56358 L F P
0 g
s
.706 .417 .484 r
.52242 .56358 m .51491 .62771 L .51434 .60821 L F
.67 .458 .589 r
.51182 .50346 m .52002 .41689 L .51207 .51256 L F
.697 .48 .589 r
.51464 .41692 m .51869 .44189 L .52025 .43863 L F
.52008 .4225 m .52025 .43863 L .52539 .42794 L F
.51464 .41692 m .52025 .43863 L .52008 .4225 L F
.53072 .41684 m .52002 .41689 L p .52539 .42794 L F P
0 g
s
.697 .48 .589 r
.52002 .41689 m .51464 .41692 L p .52008 .4225 L F P
0 g
s
.697 .48 .589 r
.52008 .4225 m .52539 .42794 L .52002 .41689 L F
.67 .458 .589 r
.51371 .50077 m .52039 .45243 L .51279 .53794 L F
.697 .48 .589 r
.52039 .45243 m .53003 .51187 L .52025 .43863 L F
.673 .47 .603 r
.50867 .39741 m .50638 .33413 L .51882 .3269 L F
.698 .491 .603 r
.52435 .32367 m .51877 .3237 L p .52138 .3254 L F P
0 g
s
.747 .532 .602 r
.5435 .35114 m .55292 .39874 L .54436 .32451 L F
.55292 .39874 m .55332 .39158 L .54436 .32451 L F
.723 .511 .603 r
.53092 .39649 m .5316 .32363 L .54409 .33288 L F
.53092 .39649 m .54409 .33288 L .5435 .35114 L F
.5478 .33563 m .54409 .33288 L .55077 .32495 L F
.54409 .33288 m .53789 .32829 L .54429 .32663 L F
.54409 .33288 m .54429 .32663 L .55077 .32495 L F
.791 .599 .642 r
.58207 .32319 m .57545 .32615 L .58056 .33263 L F
.569 .32904 m .58056 .33263 L p .57545 .32615 L F P
0 g
s
.821 .598 .601 r
.574 .34273 m .57508 .3304 L .58056 .33263 L p F P
0 g
s
.821 .598 .601 r
.58056 .33263 m .59141 .33703 L p .58554 .33895 L F P
0 g
s
.821 .598 .601 r
.574 .34273 m .58056 .33263 L .58554 .33895 L F
.772 .553 .602 r
.55292 .39874 m .57508 .3304 L .55182 .41897 L F
.747 .532 .602 r
.5435 .35114 m .54216 .39305 L .55707 .41969 L F
.54137 .41753 m .55182 .41897 L p .54216 .39305 L F P
0 g
s
.747 .532 .602 r
.55182 .41897 m .55707 .41969 L p .54216 .39305 L F P
0 g
s
.747 .522 .589 r
.55182 .41897 m .54137 .41753 L p .5509 .44061 L F P
0 g
s
.722 .501 .589 r
.53072 .41684 m .54137 .41753 L p .53903 .43525 L F P
0 g
s
.706 .417 .484 r
.5222 .5369 m .5272 .5372 L p .52242 .56358 L F P
0 g
s
.677 .394 .485 r
.5322 .53684 m .5222 .5369 L p .53132 .60866 L F P
0 g
s
.722 .501 .589 r
.53003 .51187 m .54137 .41753 L .54048 .45302 L F
.67 .458 .589 r
.52039 .45243 m .52051 .4634 L .51279 .53794 L F
.52128 .53734 m .51279 .53794 L p .51808 .48689 L F P
0 g
s
.67 .458 .589 r
.51808 .48689 m .52051 .4634 L .52128 .53734 L F
.722 .501 .589 r
.53835 .53782 m .52984 .5373 L p .53694 .48707 L F P
0 g
s
.722 .501 .589 r
.53694 .48707 m .54021 .46397 L .53835 .53782 L F
.647 .369 .484 r
.53913 .62759 m .53108 .62813 L p .54099 .57117 L F P
0 g
s
.772 .542 .587 r
.5473 .67074 m .54133 .66965 L p .55176 .59337 L F P
0 g
s
.797 .564 .585 r
.5473 .67074 m .553 .6722 L p .55196 .59002 L F P
0 g
s
.797 .564 .585 r
.553 .6722 m .55365 .67236 L p .55351 .66536 L F P
0 g
s
.797 .564 .585 r
.55196 .59002 m .553 .6722 L .55351 .66536 L F
.55365 .67236 m .55587 .67293 L p .55407 .62454 L F P
0 g
s
.772 .542 .587 r
.54239 .64381 m .55246 .58121 L .54133 .66965 L F
.797 .564 .585 r
.55246 .58121 m .55365 .67236 L .55407 .62454 L F
.55196 .59002 m .55365 .67236 L .55246 .58121 L F
.56256 .54264 m .55481 .54051 L p .55489 .64658 L F P
0 g
s
.747 .521 .587 r
.54671 .53889 m .53835 .53782 L p .54278 .63432 L F P
0 g
s
.747 .521 .587 r
.53736 .5788 m .54069 .62188 L .53835 .53782 L F
.54069 .62188 m .54239 .64381 L .53835 .53782 L F
.54239 .64381 m .54278 .63432 L .53835 .53782 L F
.677 .394 .485 r
.52298 .62817 m .53108 .62813 L p .52242 .56358 L F P
0 g
s
.677 .394 .485 r
.53132 .60866 m .52242 .56358 L .53108 .62813 L F
.53132 .60866 m .5222 .5369 L .52242 .56358 L F
.722 .499 .588 r
.52984 .5373 m .53835 .53782 L p .52916 .63311 L F P
0 g
s
.747 .522 .589 r
.53835 .53782 m .54671 .53889 L p .54226 .48759 L F P
0 g
s
.722 .499 .588 r
.53835 .53782 m .54263 .53808 L p .53736 .5788 L F P
0 g
s
.722 .499 .588 r
.53188 .62109 m .53835 .53782 L .53736 .5788 L F
.52909 .64263 m .53835 .53782 L .53188 .62109 L F
.696 .478 .588 r
.5266 .62095 m .52909 .64263 L .52128 .53734 L F
.52909 .64263 m .52916 .63311 L .52128 .53734 L F
.642 .435 .587 r
.51279 .53794 m .50447 .5391 L p .5113 .59822 L F P
0 g
s
.642 .435 .587 r
.5113 .59822 m .5154 .6336 L .51279 .53794 L F
.67 .457 .588 r
.51279 .53794 m .52128 .53734 L p .5154 .6336 L F P
0 g
s
.67 .457 .588 r
.51566 .64311 m .52128 .53734 L .5217 .57837 L F
.642 .435 .587 r
.50627 .57995 m .51566 .64311 L .50447 .5391 L F
.51566 .64311 m .5154 .6336 L .50447 .5391 L F
.612 .412 .586 r
.51024 .66979 m .50431 .67095 L p .50681 .59216 L F P
0 g
s
.612 .412 .586 r
.50275 .64522 m .50627 .57995 L .50431 .67095 L F
.50627 .57995 m .50681 .59216 L .50431 .67095 L F
.50218 .63578 m .50447 .5391 L .50275 .64522 L F
.50447 .5391 m .50852 .53825 L p .50394 .62321 L F P
0 g
s
.613 .414 .588 r
.50447 .5391 m .49642 .5408 L p .50111 .46552 L F P
0 g
s
.642 .435 .587 r
.50029 .53969 m .50716 .67019 L .51024 .66979 L p F P
0 g
s
.696 .478 .588 r
.52261 .66859 m .52891 .66856 L p .52182 .59063 L F P
0 g
s
.696 .478 .588 r
.5217 .57837 m .52891 .66856 L .52909 .64263 L F
.52182 .59063 m .52891 .66856 L .5217 .57837 L F
.52984 .5373 m .52128 .53734 L p .52916 .63311 L F P
0 g
s
.67 .457 .588 r
.51566 .64311 m .5217 .57837 L .51636 .669 L F
.696 .478 .588 r
.5217 .57837 m .5266 .62095 L .52128 .53734 L F
.697 .48 .589 r
.51464 .41692 m .51698 .53736 L .52128 .53734 L p F P
0 g
s
.697 .48 .589 r
.52128 .53734 m .52984 .5373 L p .52345 .48668 L F P
0 g
s
.697 .48 .589 r
.51464 .41692 m .52128 .53734 L .52345 .48668 L F
.67 .457 .588 r
.5217 .57837 m .52556 .53703 L .52182 .59063 L F
.5217 .57837 m .52182 .59063 L .51636 .669 L F
.5154 .6336 m .52128 .53734 L .51566 .64311 L F
.696 .478 .588 r
.52128 .53734 m .51698 .53736 L p .5217 .57837 L F P
0 g
s
.696 .478 .588 r
.51698 .53736 m .52182 .59063 L .5217 .57837 L F
.67 .457 .588 r
.52556 .53703 m .52576 .66839 L .52261 .66859 L p F P
0 g
s
.67 .457 .588 r
.52261 .66859 m .51636 .669 L p .52182 .59063 L F P
0 g
s
.67 .457 .588 r
.52182 .59063 m .52556 .53703 L .52261 .66859 L F
.642 .435 .587 r
.51024 .66979 m .51636 .669 L p .50627 .57995 L F P
0 g
s
.642 .435 .587 r
.50627 .57995 m .51636 .669 L .51566 .64311 L F
.67 .457 .588 r
.51636 .669 m .51322 .66921 L p .51566 .64311 L F P
0 g
s
.642 .435 .587 r
.51636 .669 m .51945 .66861 L p .51566 .64311 L F P
0 g
s
.642 .435 .587 r
.50029 .53969 m .51024 .66979 L .50627 .57995 L F
.612 .412 .586 r
.50627 .57995 m .50852 .53825 L .50681 .59216 L F
.67 .457 .588 r
.51322 .66921 m .5154 .6336 L .51566 .64311 L F
.642 .435 .587 r
.51566 .64311 m .51945 .66861 L .5154 .6336 L F
.5154 .6336 m .51945 .66861 L .51279 .53794 L F
.67 .457 .588 r
.51322 .66921 m .50852 .53825 L .51279 .53794 L p F P
0 g
s
.67 .457 .588 r
.51322 .66921 m .51279 .53794 L .5154 .6336 L F
.52128 .53734 m .52556 .53703 L p .5217 .57837 L F P
0 g
s
.696 .478 .588 r
.51698 .53736 m .51945 .66861 L .52261 .66859 L p F P
0 g
s
.696 .478 .588 r
.51698 .53736 m .52261 .66859 L .52182 .59063 L F
.722 .499 .588 r
.53517 .66892 m .52891 .66856 L p .53736 .5788 L F P
0 g
s
.722 .499 .588 r
.52909 .64263 m .53736 .5788 L .52891 .66856 L F
.696 .478 .588 r
.52891 .66856 m .53208 .66855 L p .52909 .64263 L F P
0 g
s
.722 .499 .588 r
.52891 .66856 m .52576 .66839 L p .52909 .64263 L F P
0 g
s
.722 .499 .588 r
.52576 .66839 m .52916 .63311 L .52909 .64263 L F
.52916 .63311 m .53835 .53782 L .52909 .64263 L F
.696 .478 .588 r
.52909 .64263 m .53208 .66855 L .52916 .63311 L F
.747 .521 .587 r
.53415 .53727 m .53208 .66855 L .53517 .66892 L p F P
0 g
s
.772 .542 .587 r
.54239 .64381 m .55481 .54051 L .55246 .58121 L F
.616 .345 .484 r
.53588 .73077 m .54178 .73004 L p .53782 .66913 L F P
0 g
s
.747 .521 .587 r
.53517 .66892 m .54133 .66965 L p .53736 .5788 L F P
0 g
s
.747 .521 .587 r
.53736 .5788 m .54133 .66965 L .54239 .64381 L F
.772 .542 .587 r
.53832 .66909 m .54278 .63432 L .54239 .64381 L F
.54278 .63432 m .55481 .54051 L .54239 .64381 L F
.55246 .58121 m .55176 .59337 L .54133 .66965 L F
.747 .521 .587 r
.54133 .66965 m .54442 .67001 L p .54239 .64381 L F P
0 g
s
.747 .521 .587 r
.53415 .53727 m .53517 .66892 L .53736 .5788 L F
.696 .478 .588 r
.53208 .66855 m .53415 .53727 L .52984 .5373 L p F P
0 g
s
.696 .478 .588 r
.52916 .63311 m .53208 .66855 L .52984 .5373 L F
.722 .499 .588 r
.52576 .66839 m .52556 .53703 L .52984 .5373 L p F P
0 g
s
.722 .499 .588 r
.52576 .66839 m .52984 .5373 L .52916 .63311 L F
.747 .522 .589 r
.54021 .46397 m .53835 .53782 L .54226 .48759 L F
.772 .542 .587 r
.53832 .66909 m .54263 .53808 L .54671 .53889 L p F P
0 g
s
.772 .542 .587 r
.54671 .53889 m .55481 .54051 L p .54278 .63432 L F P
0 g
s
.772 .542 .587 r
.53832 .66909 m .54671 .53889 L .54278 .63432 L F
.747 .521 .587 r
.54239 .64381 m .54442 .67001 L .54278 .63432 L F
.53835 .53782 m .53415 .53727 L p .53736 .5788 L F P
0 g
s
.722 .499 .588 r
.54263 .53808 m .53832 .66909 L .53517 .66892 L p F P
0 g
s
.722 .499 .588 r
.53736 .5788 m .54263 .53808 L .53517 .66892 L F
.797 .564 .585 r
.55481 .54051 m .55091 .53943 L p .55246 .58121 L F P
0 g
s
.797 .564 .585 r
.55246 .58121 m .55489 .64658 L .55481 .54051 L F
.772 .543 .588 r
.55182 .41897 m .56194 .42113 L p .55632 .43104 L F P
0 g
s
.575 .244 .371 r
.56121 .43997 m .56135 .43904 L .5546 .44048 L F
.772 .543 .588 r
.54809 .50656 m .55079 .44323 L .56145 .42943 L F
.722 .501 .589 r
.53009 .50275 m .54137 .41753 L .53003 .51187 L F
.697 .48 .589 r
.51464 .41692 m .52984 .5373 L .53003 .51187 L F
.722 .501 .589 r
.52556 .53703 m .53072 .41684 L .53903 .43525 L F
.747 .522 .589 r
.54048 .45302 m .54671 .53889 L .54779 .51357 L F
.722 .501 .589 r
.53003 .51187 m .54048 .45302 L .52984 .5373 L F
.54048 .45302 m .54021 .46397 L .52984 .5373 L F
.747 .522 .589 r
.53611 .41681 m .54021 .46397 L .54048 .45302 L F
.54021 .46397 m .54671 .53889 L .54048 .45302 L F
.54137 .41753 m .53611 .41681 L p .54118 .42497 L F P
0 g
s
.747 .522 .589 r
.54118 .42497 m .5509 .44061 L .54137 .41753 L F
.722 .501 .589 r
.54048 .45302 m .54672 .41788 L .54021 .46397 L F
.532 .206 .361 r
.57256 .445 m .55767 .4633 L .57431 .43651 L F
.55767 .4633 m .55803 .46093 L .57431 .43651 L F
.57431 .43651 m .55803 .46093 L .56119 .44008 L F
.56785 .46786 m .5566 .47032 L p .57256 .445 L F P
0 g
s
.532 .206 .361 r
.57256 .445 m .5566 .47032 L .55767 .4633 L F
.772 .543 .588 r
.54263 .53808 m .56145 .42943 L .55984 .45634 L F
.54563 .4499 m .56194 .42113 L .56145 .42943 L F
.797 .566 .587 r
.55481 .54051 m .56256 .54264 L p .55984 .45634 L F P
0 g
s
.823 .589 .585 r
.56447 .51758 m .57749 .46221 L .56256 .54264 L F
.797 .566 .587 r
.56256 .54264 m .56644 .54371 L p .56447 .51758 L F P
0 g
s
.797 .566 .587 r
.55984 .45634 m .56256 .54264 L .56447 .51758 L F
.482 .162 .347 r
.58691 .43237 m .57438 .43615 L p .58053 .43474 L F P
0 g
s
.823 .589 .585 r
.56447 .51758 m .5716 .42398 L .57873 .44873 L F
.849 .614 .583 r
.58018 .43296 m .57873 .44873 L .58382 .44031 L F
.58908 .4316 m .58069 .42749 L p .58382 .44031 L F P
0 g
s
.849 .614 .583 r
.58018 .43296 m .58382 .44031 L .58069 .42749 L F
.821 .598 .601 r
.57356 .40403 m .57965 .34186 L .59104 .34013 L F
.57356 .40403 m .59104 .34013 L .58834 .36291 L F
.59141 .33703 m .59685 .33924 L p .574 .34273 L F P
0 g
s
.821 .598 .601 r
.58834 .36291 m .58738 .37103 L .5716 .42398 L F
.57613 .4088 m .58738 .37103 L .58069 .42749 L F
.847 .623 .599 r
.58635 .33443 m .57645 .42541 L .58069 .42749 L p F P
0 g
s
.847 .623 .599 r
.58069 .42749 m .58908 .4316 L p .58351 .40366 L F P
0 g
s
.877 .641 .579 r
.58212 .46048 m .58524 .42925 L .58908 .4316 L p F P
0 g
s
.354 .047 .299 r
.6011 .44848 m .59606 .43693 L .60043 .45048 L F
.877 .641 .579 r
.58908 .4316 m .59667 .43626 L p .59167 .44459 L F P
0 g
s
.877 .641 .579 r
.58212 .46048 m .58908 .4316 L .59167 .44459 L F
.847 .623 .599 r
.58834 .36291 m .58351 .40366 L .59328 .43366 L F
.58908 .4316 m .59328 .43366 L p .58351 .40366 L F P
0 g
s
.847 .623 .599 r
.58635 .33443 m .58069 .42749 L .58834 .36291 L F
.821 .598 .601 r
.58834 .36291 m .59104 .34013 L .59685 .33924 L F
.823 .589 .585 r
.57979 .45241 m .57873 .44873 L .58524 .42925 L F
.5716 .42398 m .58069 .42749 L p .57873 .44873 L F P
0 g
s
.823 .589 .585 r
.58069 .42749 m .58524 .42925 L p .57873 .44873 L F P
0 g
s
.849 .614 .583 r
.58069 .42749 m .57645 .42541 L p .58018 .43296 L F P
0 g
s
.849 .614 .583 r
.57645 .42541 m .57718 .45129 L .57873 .44873 L F
.57645 .42541 m .57873 .44873 L .58018 .43296 L F
.823 .589 .585 r
.57749 .46221 m .57873 .44873 L .57979 .45241 L F
.56447 .51758 m .57873 .44873 L .57749 .46221 L F
.772 .543 .588 r
.55537 .47757 m .55984 .45634 L .55481 .54051 L F
.797 .566 .587 r
.56066 .44267 m .56447 .51758 L .5716 .42398 L F
.55984 .45634 m .56447 .51758 L .56066 .44267 L F
.56161 .42668 m .56066 .44267 L .56603 .43349 L F
.5716 .42398 m .56194 .42113 L p .56603 .43349 L F P
0 g
s
.797 .566 .587 r
.56194 .42113 m .55707 .41969 L p .56603 .43349 L F P
0 g
s
.772 .543 .588 r
.55984 .45634 m .56702 .42221 L .55481 .54051 L F
.797 .566 .587 r
.55902 .44546 m .55984 .45634 L .56066 .44267 L F
.823 .589 .585 r
.55888 .54132 m .5716 .42398 L .56447 .51758 L F
.797 .566 .587 r
.55707 .41969 m .55091 .53943 L .55481 .54051 L p F P
0 g
s
.797 .566 .587 r
.55707 .41969 m .55481 .54051 L .55984 .45634 L F
.772 .543 .588 r
.56194 .42113 m .56702 .42221 L p .56145 .42943 L F P
0 g
s
.772 .542 .587 r
.55481 .54051 m .55888 .54132 L p .55246 .58121 L F P
0 g
s
.772 .542 .587 r
.55246 .58121 m .55888 .54132 L .55176 .59337 L F
.797 .564 .585 r
.55091 .53943 m .55196 .59002 L .55246 .58121 L F
.823 .588 .583 r
.55029 .6713 m .55888 .54132 L .56256 .54264 L p F P
0 g
s
.849 .613 .581 r
.56626 .58547 m .56336 .67608 L .56598 .65081 L F
.823 .588 .583 r
.56256 .54264 m .56984 .54526 L p .55489 .64658 L F P
0 g
s
.823 .588 .583 r
.55489 .64658 m .56984 .54526 L .56626 .58547 L F
.849 .613 .581 r
.56644 .54371 m .56519 .59749 L .56626 .58547 L F
.56519 .59749 m .56336 .67608 L .56626 .58547 L F
.57658 .54834 m .56984 .54526 L p .56802 .60552 L F P
0 g
s
.849 .613 .581 r
.56984 .54526 m .56644 .54371 L p .56607 .62878 L F P
0 g
s
.906 .67 .57 r
.57807 .59136 m .57316 .67139 L .57611 .63438 L F
.877 .64 .576 r
.57658 .54834 m .58269 .55183 L p .56598 .65081 L F P
0 g
s
.877 .64 .576 r
.56598 .65081 m .58269 .55183 L .57807 .59136 L F
.906 .67 .57 r
.57996 .54989 m .57724 .59844 L .57807 .59136 L F
.57724 .59844 m .57316 .67139 L .57807 .59136 L F
.58811 .5557 m .57996 .54989 L p .57512 .65627 L F P
0 g
s
.303 .083 .405 r
.59056 .56285 m .59086 .54684 L .5816 .61439 L F
.935 .703 .563 r
.59276 .55987 m .58811 .5557 L p .5982 .51096 L F P
0 g
s
.383 .151 .434 r
.57139 .67516 m .56556 .70266 L .57563 .61767 L F
.906 .67 .57 r
.57996 .54989 m .56689 .66783 L p .57191 .6811 L F P
0 g
s
.906 .67 .57 r
.56689 .66783 m .56586 .67713 L .56789 .67846 L p F P
0 g
s
.906 .67 .57 r
.56789 .67846 m .57191 .6811 L p .56689 .66783 L F P
0 g
s
.37 .128 .412 r
.54781 .81756 m .54797 .81645 L p .54799 .81646 L F P
0 g
s
.435 .183 .432 r
.54924 .81661 m .55401 .75808 L .5463 .81724 L F
.55158 .80084 m .55401 .75808 L .54924 .81661 L F
.54619 .81807 m .54919 .81689 L p .54481 .81755 L F P
0 g
s
.435 .183 .432 r
.54924 .81661 m .54481 .81755 L .54919 .81689 L F
.54481 .81755 m .54468 .81866 L .54619 .81807 L p F P
0 g
s
.489 .229 .446 r
.54619 .81807 m .54295 .81907 L p .55284 .76705 L F P
0 g
s
.435 .183 .432 r
.55797 .72771 m .55821 .72586 L .55753 .72754 L F
.489 .229 .446 r
.55401 .75808 m .54469 .80328 L .55821 .72586 L F
.37 .128 .412 r
.55194 .81555 m .54919 .81689 L p .56054 .76357 L F P
0 g
s
.935 .702 .56 r
.57925 .63675 m .58734 .59857 L .57151 .68077 L F
.58734 .59857 m .58616 .60696 L .57151 .68077 L F
.877 .641 .579 r
.58184 .51318 m .59255 .47031 L .57658 .54834 L F
.59255 .47031 m .59128 .48083 L .57658 .54834 L F
.57922 .52367 m .58655 .45519 L .5957 .44428 L F
.905 .671 .573 r
.60339 .4414 m .59667 .43626 L p .59869 .44937 L F P
0 g
s
.905 .671 .573 r
.5957 .44428 m .59223 .52483 L .6003 .46448 L F
.935 .703 .563 r
.59134 .53152 m .61202 .44975 L .58811 .5557 L F
.905 .671 .573 r
.59255 .47031 m .59082 .55763 L .5957 .44428 L F
.877 .641 .579 r
.58212 .46048 m .59667 .43626 L .5957 .44428 L F
.905 .671 .573 r
.59667 .43626 m .59328 .43366 L p .5957 .44428 L F P
0 g
s
.905 .671 .573 r
.5957 .44428 m .60251 .47419 L .59667 .43626 L F
.877 .641 .579 r
.59667 .43626 m .60048 .43859 L p .5957 .44428 L F P
0 g
s
.877 .641 .579 r
.59255 .47031 m .5957 .44428 L .60048 .43859 L F
.57922 .52367 m .5957 .44428 L .59255 .47031 L F
.905 .671 .573 r
.59255 .47031 m .58811 .5557 L .59134 .53152 L F
.59328 .43366 m .59128 .48083 L .59255 .47031 L F
.59128 .48083 m .58811 .5557 L .59255 .47031 L F
.59328 .43366 m .57996 .54989 L .58269 .55183 L p F P
0 g
s
.905 .671 .573 r
.58269 .55183 m .58811 .5557 L p .59128 .48083 L F P
0 g
s
.905 .671 .573 r
.59328 .43366 m .58269 .55183 L .59128 .48083 L F
.877 .641 .579 r
.59255 .47031 m .60048 .43859 L .59128 .48083 L F
.906 .67 .57 r
.57611 .63438 m .57316 .67139 L .57512 .65627 L F
.935 .702 .56 r
.57016 .67966 m .58576 .55359 L .59276 .55987 L p F P
0 g
s
.935 .702 .56 r
.59276 .55987 m .59509 .56197 L p .58734 .59857 L F P
0 g
s
.935 .702 .56 r
.57016 .67966 m .59276 .55987 L .58734 .59857 L F
.964 .736 .545 r
.59082 .55763 m .57516 .67329 L p .57621 .67796 L F P
0 g
s
.964 .736 .545 r
.58572 .61015 m .57621 .67796 L .57825 .687 L F
.59082 .55763 m .57621 .67796 L .58572 .61015 L F
.57516 .67329 m .57393 .68242 L .57537 .68395 L p F P
0 g
s
.964 .736 .545 r
.57537 .68395 m .57825 .687 L p .57516 .67329 L F P
0 g
s
.289 .061 .384 r
.55733 .7977 m .56749 .72157 L .56205 .75443 L F
.55846 .79142 m .56749 .72157 L .55733 .7977 L F
.55846 .79142 m .57056 .72404 L .56749 .72157 L F
.054 0 .287 r
.55584 .81218 m .55563 .81333 L .55653 .81246 L p F P
0 g
s
.187 0 .344 r
.55653 .81246 m .55439 .81407 L p .56669 .75929 L F P
0 g
s
1 .801 .479 r
.58049 .69019 m .58209 .69348 L p .59186 .61804 L F P
0 g
s
.054 0 .287 r
.56295 .78755 m .57679 .71845 L .57492 .71627 L F
0 0 .204 r
.55831 .81074 m .5576 .81165 L p .56167 .79398 L F P
0 g
s
.054 0 .287 r
.55653 .81246 m .55831 .81074 L p .56848 .74993 L F P
0 g
s
.054 0 .287 r
.56167 .79398 m .56848 .74993 L .55831 .81074 L F
.907 .789 .307 r
.58303 .69685 m .5833 .70024 L p .59672 .61545 L F P
0 g
s
.752 .701 .162 r
.58414 .69691 m .5827 .70532 L .5829 .70362 L p F P
0 g
s
.752 .701 .162 r
.5829 .70362 m .5833 .70024 L p .59649 .62429 L F P
0 g
s
.907 .789 .307 r
.59672 .61545 m .5833 .70024 L .58726 .67706 L F
.752 .701 .162 r
.5833 .70024 m .5835 .69854 L p .58726 .67706 L F P
0 g
s
.752 .701 .162 r
.58726 .67706 m .59649 .62429 L .5833 .70024 L F
0 0 0 r
.60336 .58606 m .58344 .70194 L .5829 .70362 L p F P
0 g
s
0 0 0 r
.60336 .58606 m .5829 .70362 L .59465 .63502 L F
.907 .789 .307 r
.58726 .67706 m .5833 .70024 L .58445 .69536 L F
.5833 .70024 m .58344 .70194 L p .58445 .69536 L F P
0 g
s
0 0 .087 r
.56577 .78325 m .58073 .71224 L .58014 .7102 L F
.56081 .80675 m .57299 .74478 L .55991 .80805 L F
.56438 .78985 m .57299 .74478 L .56081 .80675 L F
.785 .743 .221 r
.56675 .77873 m .58215 .70569 L .5829 .70362 L F
0 0 0 r
.57535 .73922 m .56438 .78985 L .5829 .70362 L F
.925 .817 .356 r
.5833 .70024 m .58303 .69685 L p .56532 .7855 L F P
0 g
s
.982 .814 .412 r
.58303 .69685 m .58209 .69348 L p .58497 .68991 L F P
0 g
s
.988 .832 .45 r
.58209 .69348 m .58303 .69685 L p .56584 .77418 L F P
0 g
s
.988 .832 .45 r
.56444 .78113 m .58303 .69685 L .57544 .73348 L F
1 .812 .509 r
.57321 .72785 m .56444 .78113 L .58049 .69019 L F
.56444 .78113 m .56584 .77418 L .58049 .69019 L F
.986 .779 .544 r
.55978 .79737 m .55836 .79553 L p .5712 .73829 L F P
0 g
s
.986 .779 .544 r
.56177 .77696 m .57321 .72785 L .55836 .79553 L F
.57321 .72785 m .5712 .73829 L .55836 .79553 L F
1 .812 .509 r
.58049 .69019 m .56584 .77418 L .58097 .69909 L F
.58209 .69348 m .58049 .69019 L p .58119 .70342 L F P
0 g
s
.961 .743 .564 r
.57825 .687 m .57537 .68395 L p .56307 .76983 L F P
0 g
s
.961 .743 .564 r
.56876 .72259 m .56177 .77696 L .57537 .68395 L F
.56177 .77696 m .56307 .76983 L .57537 .68395 L F
.932 .709 .577 r
.55657 .79379 m .55441 .79215 L p .56693 .73329 L F P
0 g
s
.932 .709 .577 r
.5574 .77317 m .56876 .72259 L .55441 .79215 L F
.56876 .72259 m .56693 .73329 L .55441 .79215 L F
.903 .676 .585 r
.57191 .6811 m .56789 .67846 L p .55855 .76588 L F P
0 g
s
.903 .676 .585 r
.56227 .71796 m .5574 .77317 L .56789 .67846 L F
.5574 .77317 m .55855 .76588 L .56789 .67846 L F
.875 .647 .589 r
.55192 .79064 m .54912 .78928 L p .56227 .71796 L F P
0 g
s
.875 .647 .589 r
.55155 .76995 m .56227 .71796 L .54912 .78928 L F
.435 .183 .432 r
.55821 .72586 m .55578 .72687 L p .55753 .72754 L F P
0 g
s
.535 .268 .456 r
.55301 .72758 m .54751 .72897 L p .55491 .73405 L F P
0 g
s
.489 .229 .446 r
.55301 .72758 m .55821 .72586 L p .54469 .80328 L F P
0 g
s
.535 .268 .456 r
.54469 .80328 m .54473 .76073 L .54295 .81907 L F
.848 .62 .593 r
.54604 .78809 m .54912 .78928 L p .55283 .72531 L F P
0 g
s
.489 .229 .446 r
.54133 .81957 m .54144 .81848 L p .54155 .81852 L F P
0 g
s
.575 .301 .464 r
.53953 .81989 m .53596 .82051 L p .54144 .81848 L F P
0 g
s
.535 .268 .456 r
.53953 .81989 m .54295 .81907 L p .54473 .76073 L F P
0 g
s
.822 .595 .595 r
.54604 .78809 m .54273 .78707 L p .55403 .71418 L F P
0 g
s
.822 .595 .595 r
.54448 .76746 m .55403 .71418 L .54273 .78707 L F
.575 .301 .464 r
.54735 .7308 m .53697 .80489 L .54144 .73538 L F
.54473 .76073 m .53697 .80489 L .54735 .7308 L F
.54735 .7308 m .54144 .73538 L .54751 .72897 L F
.54178 .73004 m .54751 .72897 L p .54144 .73538 L F P
0 g
s
.611 .331 .469 r
.54148 .7348 m .53588 .73077 L .54144 .73538 L F
.54178 .73004 m .53588 .73077 L p .54148 .7348 L F P
0 g
s
.797 .571 .596 r
.53921 .78624 m .54273 .78707 L p .54366 .72272 L F P
0 g
s
.575 .301 .464 r
.53596 .82051 m .53417 .82083 L p .53697 .80489 L F P
0 g
s
.611 .331 .469 r
.53228 .82094 m .53596 .82051 L p .53462 .76225 L F P
0 g
s
.611 .331 .469 r
.53697 .80489 m .53462 .76225 L .53596 .82051 L F
.644 .359 .471 r
.53462 .76225 m .53231 .82013 L .52854 .82089 L F
.772 .549 .597 r
.53921 .78624 m .53554 .78561 L p .54445 .71146 L F P
0 g
s
.772 .549 .597 r
.53653 .76583 m .54445 .71146 L .53554 .78561 L F
.644 .359 .471 r
.53462 .76225 m .52854 .82089 L .52877 .80562 L F
.747 .528 .597 r
.53176 .7852 m .53554 .78561 L p .53364 .72126 L F P
0 g
s
.723 .507 .597 r
.53176 .7852 m .52791 .785 L p .53397 .70992 L F P
0 g
s
.723 .507 .597 r
.52808 .76514 m .53397 .70992 L .52791 .785 L F
.645 .444 .597 r
.51636 .669 m .51024 .66979 L p .51955 .76542 L F P
0 g
s
.788 .474 .458 r
.5119 .79831 m .50651 .73393 L .50057 .72781 L F
.584 .398 .596 r
.50431 .67095 m .49865 .67245 L p .51134 .76666 L F P
0 g
s
.816 .496 .448 r
.50077 .72964 m .496 .73159 L .50057 .72781 L F
.49531 .72614 m .50057 .72781 L p .496 .73159 L F P
0 g
s
.816 .496 .448 r
.50077 .72964 m .50425 .79657 L .496 .73159 L F
.508 .343 .592 r
.49334 .67428 m .48844 .67643 L p .50386 .7688 L F P
0 g
s
.845 .518 .435 r
.50498 .80234 m .496 .73159 L .48793 .72319 L F
.874 .541 .416 r
.48589 .72193 m .4904 .72418 L p .49852 .79959 L F P
0 g
s
.874 .541 .416 r
.49514 .75665 m .49852 .79959 L .4904 .72418 L F
.49514 .75665 m .50383 .81625 L .50111 .81549 L F
.49514 .75665 m .50111 .81549 L .49852 .79959 L F
.5052 .81663 m .50535 .81774 L .50395 .81708 L p F P
0 g
s
.845 .518 .435 r
.50395 .81708 m .507 .81823 L p .49646 .76568 L F P
0 g
s
.406 .271 .584 r
.48399 .67885 m .48007 .68152 L p .49747 .77173 L F P
0 g
s
.93 .583 .352 r
.48094 .71875 m .48184 .71943 L p .48118 .72003 L F P
0 g
s
.93 .583 .352 r
.48118 .72003 m .47797 .72291 L .48094 .71875 L F
.47828 .7167 m .48094 .71875 L p .47797 .72291 L F P
0 g
s
.949 .599 .299 r
.49738 .81357 m .49717 .81243 L p .49712 .81245 L F P
0 g
s
.903 .563 .389 r
.49717 .81243 m .49738 .81357 L .49865 .81431 L p F P
0 g
s
.93 .583 .352 r
.49865 .81431 m .49646 .81272 L p .48772 .75262 L F P
0 g
s
.93 .583 .352 r
.48772 .75262 m .49646 .81272 L .49333 .79618 L F
.903 .563 .389 r
.49865 .81431 m .50115 .81577 L p .48935 .76185 L F P
0 g
s
.903 .563 .389 r
.48589 .72193 m .48184 .71943 L p .49852 .79959 L F P
0 g
s
.903 .563 .389 r
.49852 .79959 m .48184 .71943 L .48772 .75262 L F
.338 .225 .575 r
.4767 .68441 m .48007 .68152 L p .49122 .76809 L F P
0 g
s
.252 .167 .562 r
.4767 .68441 m .47394 .68748 L p .49247 .77529 L F P
0 g
s
0 0 .47 r
.47032 .694 m .4718 .69069 L p .45677 .61172 L F P
0 g
s
.95 .603 .221 r
.49513 .81076 m .49535 .81192 L .49461 .81101 L p F P
0 g
s
.949 .599 .299 r
.49461 .81101 m .49646 .81272 L p .48393 .75728 L F P
0 g
s
.95 .603 .221 r
.47583 .71565 m .47566 .71574 L .47528 .71378 L F
.47566 .71574 m .47405 .71653 L .47528 .71378 L F
.47285 .71068 m .47528 .71378 L p .47405 .71653 L F P
0 g
s
.95 .603 .221 r
.47528 .71378 m .47649 .71533 L p .47583 .71565 L F P
0 g
s
.95 .603 .221 r
.47566 .71574 m .48837 .78611 L .47405 .71653 L F
.949 .599 .299 r
.47828 .7167 m .47528 .71378 L p .49333 .79618 L F P
0 g
s
.949 .599 .299 r
.49333 .79618 m .47528 .71378 L .48204 .74782 L F
0 .001 .501 r
.4718 .69069 m .47032 .694 L p .48908 .77933 L F P
0 g
s
.811 .52 0 r
.46987 .70414 m .47104 .70746 L p .471 .7095 L F P
0 g
s
.811 .52 0 r
.471 .7095 m .47098 .71049 L .46987 .70414 L F
.4784 .74247 m .49133 .80542 L .48764 .78802 L F
.4784 .74247 m .49098 .80445 L .47104 .70746 L F
0 0 .193 r
.49104 .80347 m .49133 .80542 L p .47907 .74679 L F P
0 g
s
0 0 .193 r
.49133 .80542 m .49148 .8064 L p .48764 .78802 L F P
0 g
s
0 0 .335 r
.47696 .7368 m .49085 .80255 L .4911 .8012 L F
.47696 .7368 m .4911 .8012 L .48745 .78364 L F
0 0 .193 r
.48764 .78802 m .47696 .7368 L .49133 .80542 L F
0 0 .437 r
.4695 .69737 m .47032 .694 L p .48602 .77679 L F P
0 g
s
0 0 .437 r
.48745 .78364 m .47032 .694 L .47783 .73107 L F
.48602 .77679 m .47032 .694 L .48745 .78364 L F
0 .001 .501 r
.47783 .73107 m .48908 .77933 L .47032 .694 L F
0 0 .437 r
.4917 .79956 m .49116 .80151 L p .47991 .74135 L F P
0 g
s
0 .001 .501 r
.4917 .79956 m .49265 .79765 L p .47783 .73107 L F P
0 g
s
0 .001 .501 r
.47783 .73107 m .49265 .79765 L .48908 .77933 L F
.252 .167 .562 r
.48099 .72557 m .49247 .77529 L .47394 .68748 L F
.338 .225 .575 r
.49247 .77529 m .48007 .68152 L .48631 .72054 L F
.252 .167 .562 r
.49399 .79581 m .49572 .79405 L p .48099 .72557 L F P
0 g
s
.252 .167 .562 r
.48099 .72557 m .49572 .79405 L .49247 .77529 L F
.338 .225 .575 r
.49467 .79488 m .49122 .76809 L .49247 .77529 L F
.49122 .76809 m .48007 .68152 L .49247 .77529 L F
.406 .271 .584 r
.48631 .72054 m .49747 .77173 L .48007 .68152 L F
.49781 .7924 m .50025 .79087 L p .48631 .72054 L F P
0 g
s
.406 .271 .584 r
.48631 .72054 m .50025 .79087 L .49747 .77173 L F
.508 .343 .592 r
.49356 .71624 m .50386 .7688 L .48844 .67643 L F
.503 .78948 m .50603 .78826 L p .49356 .71624 L F P
0 g
s
.76 .453 .465 r
.51372 .82 m .51191 .8197 L p .51241 .80431 L F P
0 g
s
.788 .474 .458 r
.51027 .81921 m .51372 .82 L p .50396 .75974 L F P
0 g
s
.508 .343 .592 r
.49356 .71624 m .50603 .78826 L .50386 .7688 L F
.584 .398 .596 r
.50241 .71289 m .51134 .76666 L .49865 .67245 L F
.788 .474 .458 r
.51241 .80431 m .50396 .75974 L .51372 .82 L F
.584 .398 .596 r
.50931 .78721 m .51279 .78635 L p .50241 .71289 L F P
0 g
s
.584 .398 .596 r
.50241 .71289 m .51279 .78635 L .51134 .76666 L F
.645 .444 .597 r
.51242 .71066 m .51955 .76542 L .51024 .66979 L F
.51643 .7857 m .5202 .78525 L p .51242 .71066 L F P
0 g
s
.645 .444 .597 r
.51242 .71066 m .5202 .78525 L .51955 .76542 L F
.698 .486 .598 r
.52404 .78501 m .52791 .785 L p .52312 .70965 L F P
0 g
s
.698 .486 .598 r
.52791 .785 m .52985 .78499 L p .52808 .76514 L F P
0 g
s
.698 .486 .598 r
.52312 .70965 m .52791 .785 L .52808 .76514 L F
.52891 .66856 m .52261 .66859 L p .52808 .76514 L F P
0 g
s
.698 .486 .598 r
.52312 .70965 m .52808 .76514 L .52261 .66859 L F
.672 .465 .597 r
.52576 .66839 m .52597 .7849 L .52404 .78501 L p F P
0 g
s
.615 .422 .597 r
.51643 .7857 m .51279 .78635 L p .51242 .71066 L F P
0 g
s
.615 .422 .597 r
.51279 .78635 m .51096 .78668 L p .51098 .78539 L F P
0 g
s
.615 .422 .597 r
.51098 .78539 m .51242 .71066 L .51279 .78635 L F
.548 .372 .594 r
.50931 .78721 m .50603 .78826 L p .50241 .71289 L F P
0 g
s
.548 .372 .594 r
.50603 .78826 m .50438 .78878 L p .50435 .7875 L F P
0 g
s
.548 .372 .594 r
.50435 .7875 m .50241 .71289 L .50603 .78826 L F
.461 .31 .589 r
.503 .78948 m .50025 .79087 L p .49356 .71624 L F P
0 g
s
.461 .31 .589 r
.50025 .79087 m .49887 .79156 L p .49878 .79028 L F P
0 g
s
.461 .31 .589 r
.49878 .79028 m .49356 .71624 L .50025 .79087 L F
.338 .225 .575 r
.49781 .7924 m .49572 .79405 L p .48631 .72054 L F P
0 g
s
.338 .225 .575 r
.49572 .79405 m .49467 .79488 L p .49453 .79362 L F P
0 g
s
.338 .225 .575 r
.49453 .79362 m .48631 .72054 L .49572 .79405 L F
.143 .095 .539 r
.49399 .79581 m .49265 .79765 L p .48099 .72557 L F P
0 g
s
.143 .095 .539 r
.49265 .79765 m .49197 .79858 L p .49178 .79734 L F P
0 g
s
.143 .095 .539 r
.49178 .79734 m .48099 .72557 L .49265 .79765 L F
.905 .495 .132 r
.51614 .8674 m .51645 .86768 L p .51412 .8618 L F P
0 g
s
.903 .498 .213 r
.51688 .86792 m .51614 .8674 L p .50767 .84086 L F P
0 g
s
.903 .498 .213 r
.50767 .84086 m .51614 .8674 L .51412 .8618 L F
.885 .489 .271 r
.51603 .863 m .50767 .84086 L .51773 .8684 L F
.50767 .84086 m .50951 .84625 L .51773 .8684 L F
.51688 .86792 m .51773 .8684 L p .50951 .84625 L F P
0 g
s
0 0 .335 r
.49104 .80347 m .49116 .80151 L p .49085 .80255 L F P
0 g
s
.876 .472 .022 r
.51551 .86684 m .51502 .86625 L p .50497 .83868 L F P
0 g
s
.792 .414 0 r
.51502 .86625 m .5152 .86656 L p .51278 .86042 L F P
0 g
s
.876 .472 .022 r
.50497 .83868 m .51502 .86625 L .51278 .86042 L F
.905 .495 .132 r
.51412 .8618 m .50497 .83868 L .51614 .8674 L F
.50497 .83868 m .50707 .8443 L .51614 .8674 L F
.51551 .86684 m .51614 .8674 L p .50707 .8443 L F P
0 g
s
0 .047 .571 r
.49116 .80151 m .4917 .79956 L p .51101 .85467 L F P
0 g
s
0 0 .193 r
.47696 .7368 m .47907 .74679 L .49133 .80542 L F
0 0 .411 r
.49133 .80542 m .49104 .80347 L p .51207 .85893 L F P
0 g
s
0 0 .511 r
.49116 .80151 m .49104 .80347 L p .51203 .8574 L F P
0 g
s
0 0 .411 r
.51207 .85893 m .49104 .80347 L .50261 .8337 L F
.811 .52 0 r
.48764 .78802 m .49133 .80542 L .49076 .80339 L F
.49133 .80542 m .49098 .80445 L p .49076 .80339 L F P
0 g
s
0 0 .511 r
.49104 .80347 m .49098 .80445 L p .50261 .8337 L F P
0 g
s
0 0 .511 r
.50261 .8337 m .51203 .8574 L .49104 .80347 L F
0 0 .411 r
.50261 .8337 m .49104 .80347 L .49135 .80369 L F
0 .047 .571 r
.51203 .8574 m .4917 .79956 L .50307 .83114 L F
0 0 .273 r
.50325 .83626 m .51207 .85893 L .49203 .80734 L F
0 0 .411 r
.51207 .85893 m .50261 .8337 L .51443 .86501 L F
0 0 .273 r
.51207 .85893 m .51431 .8647 L .51106 .85632 L F
.51207 .85893 m .51106 .85632 L .49203 .80734 L F
0 0 .411 r
.51434 .86438 m .51443 .86501 L p .50261 .8337 L F P
0 g
s
.792 .414 0 r
.49148 .8064 m .51447 .86533 L .51466 .86564 L p F P
0 g
s
.792 .414 0 r
.50553 .84212 m .49148 .8064 L .51466 .86564 L F
0 0 .411 r
.51443 .86501 m .51447 .86533 L p .51207 .85893 L F P
0 g
s
0 0 .511 r
.49098 .80445 m .51431 .8647 L .51434 .86438 L p F P
0 g
s
0 0 .511 r
.51434 .86438 m .51439 .86374 L p .50495 .83983 L F P
0 g
s
0 0 .511 r
.49098 .80445 m .51434 .86438 L .50495 .83983 L F
.49098 .80445 m .51439 .86374 L .51203 .8574 L F
0 0 .411 r
.4909 .80248 m .5143 .86406 L .51434 .86438 L p F P
0 g
s
0 0 .411 r
.50261 .8337 m .4909 .80248 L .51434 .86438 L F
0 .047 .571 r
.5143 .86406 m .51101 .85467 L .51203 .8574 L F
.51101 .85467 m .4917 .79956 L .51203 .8574 L F
.223 .202 .623 r
.49265 .79765 m .49399 .79581 L p .51265 .85589 L F P
0 g
s
.885 .489 .271 r
.51773 .8684 m .51815 .86864 L p .51603 .863 L F P
0 g
s
.861 .475 .313 r
.51868 .86883 m .51773 .8684 L p .51124 .84269 L F P
0 g
s
.861 .475 .313 r
.51124 .84269 m .51773 .8684 L .51603 .863 L F
.833 .458 .343 r
.50719 .81898 m .50395 .81708 L .50402 .81734 L F
.507 .81823 m .50395 .81708 L p .50719 .81898 L F P
0 g
s
.382 .298 .636 r
.49572 .79405 m .49781 .7924 L p .51391 .85449 L F P
0 g
s
.833 .458 .343 r
.51971 .86921 m .52024 .8694 L p .51841 .86398 L F P
0 g
s
.805 .439 .365 r
.51549 .8441 m .51971 .86921 L .51841 .86398 L F
.51549 .8441 m .51841 .86398 L .51027 .81921 L F
.51841 .86398 m .51785 .86173 L .51027 .81921 L F
.488 .364 .638 r
.50025 .79087 m .503 .78948 L p .51577 .85326 L F P
0 g
s
.747 .398 .391 r
.51384 .82073 m .5121 .82067 L .51372 .82 L F
.776 .419 .38 r
.51372 .82 m .51027 .81921 L p .51383 .82065 L F P
0 g
s
.776 .419 .38 r
.52079 .86248 m .51383 .82065 L .51027 .81921 L F
.565 .415 .637 r
.50603 .78826 m .50931 .78721 L p .51811 .85225 L F P
0 g
s
.626 .458 .635 r
.51279 .78635 m .51643 .7857 L p .52085 .85151 L F P
0 g
s
.678 .497 .635 r
.5202 .78525 m .52404 .78501 L p .52385 .85109 L F P
0 g
s
.644 .359 .471 r
.53228 .82094 m .52853 .82116 L p .53231 .82022 L F P
0 g
s
.623 .3 .402 r
.53228 .82094 m .53417 .82083 L p .53226 .82118 L F P
0 g
s
.587 .269 .397 r
.53027 .86488 m .53587 .82124 L .53226 .82118 L F
.53027 .86488 m .53226 .82118 L .53034 .84525 L F
.53587 .82124 m .53228 .82094 L .53226 .82118 L F
.53596 .82051 m .53228 .82094 L p .53587 .82124 L F P
0 g
s
.587 .269 .397 r
.52836 .87011 m .52962 .86996 L p .52995 .8502 L F P
0 g
s
.587 .269 .397 r
.53767 .82127 m .53596 .82051 L .53587 .82124 L F
.547 .235 .39 r
.53596 .82051 m .53953 .81989 L p .53588 .82116 L F P
0 g
s
.502 .195 .378 r
.53953 .81989 m .53781 .8203 L p .53771 .82123 L F P
0 g
s
.547 .235 .39 r
.53953 .81989 m .53055 .8627 L .53588 .82116 L F
.53523 .84455 m .53027 .86488 L .53953 .81989 L F
.53027 .86488 m .53055 .8627 L .53953 .81989 L F
.449 .148 .361 r
.532 .86949 m .53145 .86965 L p .53313 .86431 L F P
0 g
s
.502 .195 .378 r
.53084 .86976 m .532 .86949 L p .53523 .84455 L F P
0 g
s
.502 .195 .378 r
.53313 .86431 m .53523 .84455 L .532 .86949 L F
.449 .148 .361 r
.53972 .84334 m .532 .86949 L .53313 .86431 L F
.875 .647 .589 r
.56336 .67608 m .56789 .67846 L p .55155 .76995 L F P
0 g
s
.875 .647 .589 r
.56789 .67846 m .57016 .67966 L p .56227 .71796 L F P
0 g
s
.875 .647 .589 r
.55155 .76995 m .56789 .67846 L .56227 .71796 L F
.903 .676 .585 r
.56586 .67713 m .55084 .78855 L p .55206 .78965 L F P
0 g
s
.903 .676 .585 r
.56227 .71796 m .55206 .78965 L .55566 .79291 L F
.56586 .67713 m .55206 .78965 L .56227 .71796 L F
.55084 .78855 m .55066 .78988 L .55192 .79064 L p F P
0 g
s
.961 .743 .564 r
.55657 .79379 m .55836 .79553 L p .56876 .72259 L F P
0 g
s
.961 .743 .564 r
.55836 .79553 m .55926 .79641 L p .55943 .79516 L F P
0 g
s
.961 .743 .564 r
.56876 .72259 m .55836 .79553 L .55943 .79516 L F
0 0 .087 r
.55945 .8087 m .55921 .80988 L .55972 .80893 L p F P
0 g
s
0 0 .204 r
.55972 .80893 m .55831 .81074 L p .571 .75439 L F P
0 g
s
1 .812 .509 r
.55978 .79737 m .56079 .79926 L p .57321 .72785 L F P
0 g
s
.925 .817 .356 r
.57544 .73348 m .56532 .7855 L .58303 .69685 L F
.5614 .80121 m .5616 .80316 L p .57544 .73348 L F P
0 g
s
.925 .817 .356 r
.57544 .73348 m .5616 .80316 L .56532 .7855 L F
.785 .743 .221 r
.56138 .80512 m .5616 .80316 L p .57535 .73922 L F P
0 g
s
.785 .743 .221 r
.5616 .80316 m .56171 .80218 L p .56194 .8011 L F P
0 g
s
.785 .743 .221 r
.56194 .8011 m .57535 .73922 L .5616 .80316 L F
.988 .832 .45 r
.5614 .80121 m .56079 .79926 L p .57333 .74365 L F P
0 g
s
0 0 0 r
.53769 .86616 m .53721 .86675 L p .54658 .84306 L F P
0 g
s
0 0 0 r
.55831 .81074 m .55972 .80893 L p .558 .81157 L F P
0 g
s
0 0 0 r
.558 .81157 m .55719 .81274 L .55831 .81074 L F
0 0 .115 r
.55831 .81074 m .55653 .81246 L p .55803 .81148 L F P
0 g
s
0 0 .115 r
.5403 .85856 m .55803 .81148 L .55653 .81246 L F
.963 .897 .524 r
.56129 .80152 m .54067 .85805 L .56125 .80407 L F
.54989 .83222 m .54067 .85805 L .56129 .80152 L F
.087 0 .201 r
.53661 .86732 m .53589 .86784 L p .54466 .84516 L F P
0 g
s
.087 0 .201 r
.55439 .81407 m .55653 .81246 L p .53779 .86233 L F P
0 g
s
.992 .882 .579 r
.56079 .79926 m .5614 .80121 L p .54132 .85373 L F P
0 g
s
.211 0 .263 r
.5386 .85997 m .55415 .81478 L .55194 .81555 L F
.989 .847 .609 r
.56079 .79926 m .55978 .79737 L p .54032 .85652 L F P
0 g
s
.308 .023 .307 r
.53506 .86833 m .53413 .86877 L p .54189 .84699 L F P
0 g
s
.946 .77 .632 r
.55836 .79553 m .55657 .79379 L p .53931 .85507 L F P
0 g
s
.386 .092 .338 r
.53634 .86116 m .549 .81757 L .54619 .81807 L F
.308 .023 .307 r
.53413 .86877 m .53366 .86899 L p .53568 .86345 L F P
0 g
s
.386 .092 .338 r
.53311 .86916 m .53413 .86877 L p .53972 .84334 L F P
0 g
s
.386 .092 .338 r
.53568 .86345 m .53972 .84334 L .53413 .86877 L F
.893 .702 .637 r
.55441 .79215 m .55192 .79064 L p .53769 .85376 L F P
0 g
s
.893 .702 .637 r
.54347 .82529 m .53769 .85376 L .55192 .79064 L F
.903 .676 .585 r
.55192 .79064 m .55441 .79215 L p .55084 .78855 L F P
0 g
s
.842 .645 .637 r
.54912 .78928 m .54604 .78809 L p .5362 .84957 L F P
0 g
s
.842 .645 .637 r
.53953 .82362 m .53554 .85264 L .54604 .78809 L F
.53554 .85264 m .5362 .84957 L .54604 .78809 L F
.449 .148 .361 r
.5384 .84849 m .532 .86949 L .53972 .84334 L F
.53311 .86916 m .532 .86949 L p .5384 .84849 L F P
0 g
s
.867 .672 .637 r
.53496 .86023 m .53401 .8598 L p .54177 .83229 L F P
0 g
s
.867 .672 .637 r
.53554 .85264 m .54347 .82529 L .53401 .8598 L F
.893 .702 .637 r
.53496 .86023 m .5358 .86072 L p .54347 .82529 L F P
0 g
s
.893 .702 .637 r
.54347 .82529 m .5358 .86072 L .53769 .85376 L F
.946 .77 .632 r
.5466 .82735 m .53931 .85507 L .55657 .79379 L F
.53654 .86124 m .53716 .86181 L p .5466 .82735 L F P
0 g
s
.946 .77 .632 r
.5466 .82735 m .53716 .86181 L .53931 .85507 L F
.989 .847 .609 r
.54877 .8297 m .54032 .85652 L .55978 .79737 L F
.992 .882 .579 r
.54032 .85652 m .5614 .80121 L .54989 .83222 L F
.989 .847 .609 r
.53764 .8624 m .538 .86301 L p .54877 .8297 L F P
0 g
s
.989 .847 .609 r
.54877 .8297 m .538 .86301 L .54032 .85652 L F
.992 .882 .579 r
.53789 .8627 m .54132 .85373 L .54032 .85652 L F
.54132 .85373 m .5614 .80121 L .54032 .85652 L F
.53821 .86364 m .53789 .8627 L p .54989 .83222 L F P
0 g
s
.989 .847 .609 r
.538 .86301 m .53818 .86332 L p .54032 .85652 L F P
0 g
s
.97 .808 .625 r
.56049 .79829 m .53789 .8627 L .53764 .8624 L p F P
0 g
s
.97 .808 .625 r
.53764 .8624 m .53691 .86151 L p .54877 .8297 L F P
0 g
s
.97 .808 .625 r
.54877 .8297 m .56049 .79829 L .53764 .8624 L F
.53931 .85507 m .55967 .79769 L .54877 .8297 L F
.54023 .85219 m .55967 .79769 L .53931 .85507 L F
.54023 .85219 m .55805 .79652 L .55967 .79769 L F
.55836 .79553 m .56049 .79829 L p .55724 .79593 L F P
0 g
s
.989 .847 .609 r
.55926 .79641 m .53747 .86209 L .53764 .8624 L p F P
0 g
s
.989 .847 .609 r
.55926 .79641 m .53764 .8624 L .54877 .8297 L F
.946 .77 .632 r
.53716 .86181 m .53747 .86209 L p .53931 .85507 L F P
0 g
s
.97 .808 .625 r
.53691 .86151 m .54023 .85219 L .53931 .85507 L F
.919 .734 .636 r
.55765 .79461 m .53691 .86151 L .53654 .86124 L p F P
0 g
s
.919 .734 .636 r
.53654 .86124 m .53543 .86045 L p .5466 .82735 L F P
0 g
s
.919 .734 .636 r
.5466 .82735 m .55765 .79461 L .53654 .86124 L F
.53769 .85376 m .55647 .79413 L .5466 .82735 L F
.5385 .85078 m .55647 .79413 L .53769 .85376 L F
.5385 .85078 m .55414 .79317 L .55647 .79413 L F
.55441 .79215 m .55765 .79461 L p .55297 .7927 L F P
0 g
s
.946 .77 .632 r
.55566 .79291 m .53623 .86096 L .53654 .86124 L p F P
0 g
s
.946 .77 .632 r
.55566 .79291 m .53654 .86124 L .5466 .82735 L F
.893 .702 .637 r
.5358 .86072 m .53623 .86096 L p .53769 .85376 L F P
0 g
s
.919 .734 .636 r
.53543 .86045 m .5385 .85078 L .53769 .85376 L F
.867 .672 .637 r
.54347 .82529 m .55333 .79133 L .54177 .83229 L F
.54347 .82529 m .54177 .83229 L .53401 .8598 L F
.54912 .78928 m .55333 .79133 L p .53554 .85264 L F P
0 g
s
.893 .702 .637 r
.55066 .78988 m .53453 .85999 L .53496 .86023 L p F P
0 g
s
.893 .702 .637 r
.55066 .78988 m .53496 .86023 L .54347 .82529 L F
.818 .621 .636 r
.53297 .85941 m .53184 .85908 L p .53821 .83079 L F P
0 g
s
.818 .621 .636 r
.53295 .85179 m .53953 .82362 L .53184 .85908 L F
.53953 .82362 m .53821 .83079 L .53184 .85908 L F
.794 .598 .636 r
.54273 .78707 m .53921 .78624 L p .53342 .84865 L F P
0 g
s
.794 .598 .636 r
.53495 .82241 m .53295 .85179 L .53921 .78624 L F
.53295 .85179 m .53342 .84865 L .53921 .78624 L F
.771 .576 .635 r
.53066 .85882 m .52942 .85862 L p .53409 .82971 L F P
0 g
s
.771 .576 .635 r
.53004 .85123 m .53495 .82241 L .52942 .85862 L F
.53495 .82241 m .53409 .82971 L .52942 .85862 L F
.748 .556 .635 r
.53554 .78561 m .53176 .7852 L p .53031 .84805 L F P
0 g
s
.748 .556 .635 r
.52996 .82173 m .53004 .85123 L .53176 .7852 L F
.53004 .85123 m .53031 .84805 L .53176 .7852 L F
.725 .536 .635 r
.52815 .85849 m .52685 .85842 L p .5296 .8291 L F P
0 g
s
.725 .536 .635 r
.52696 .85099 m .52996 .82173 L .52685 .85842 L F
.52996 .82173 m .5296 .8291 L .52685 .85842 L F
.702 .517 .634 r
.52791 .785 m .52404 .78501 L p .52701 .84779 L F P
0 g
s
.702 .517 .634 r
.52479 .82161 m .52696 .85099 L .52404 .78501 L F
.52696 .85099 m .52701 .84779 L .52404 .78501 L F
.678 .497 .635 r
.52385 .85109 m .52404 .78501 L .52479 .82161 L F
.672 .465 .597 r
.52404 .78501 m .5202 .78525 L p .52312 .70965 L F P
0 g
s
.678 .497 .635 r
.52555 .85843 m .52426 .8585 L p .52479 .82161 L F P
0 g
s
.678 .497 .635 r
.52385 .85109 m .52479 .82161 L .52426 .8585 L F
.626 .458 .635 r
.52085 .85151 m .51643 .7857 L .5197 .82206 L F
.52299 .85865 m .52176 .85886 L p .5197 .82206 L F P
0 g
s
.626 .458 .635 r
.52085 .85151 m .5197 .82206 L .52176 .85886 L F
.565 .415 .637 r
.51811 .85225 m .50931 .78721 L .51493 .82305 L F
.52058 .85913 m .51948 .85947 L p .51493 .82305 L F P
0 g
s
.776 .419 .38 r
.52083 .86953 m .52201 .86979 L p .51655 .84917 L F P
0 g
s
.565 .415 .637 r
.51811 .85225 m .51493 .82305 L .51948 .85947 L F
.488 .364 .638 r
.51577 .85326 m .503 .78948 L .51069 .82453 L F
.805 .439 .365 r
.52083 .86953 m .51971 .86921 L p .51549 .8441 L F P
0 g
s
.488 .364 .638 r
.51845 .85986 m .51752 .8603 L p .51069 .82453 L F P
0 g
s
.488 .364 .638 r
.51577 .85326 m .51069 .82453 L .51752 .8603 L F
.382 .298 .636 r
.51391 .85449 m .49781 .7924 L .50721 .82644 L F
.833 .458 .343 r
.51868 .86883 m .51971 .86921 L p .51272 .8479 L F P
0 g
s
.382 .298 .636 r
.51669 .8608 m .51597 .86133 L p .50721 .82644 L F P
0 g
s
.382 .298 .636 r
.51391 .85449 m .50721 .82644 L .51597 .86133 L F
.223 .202 .623 r
.51265 .85589 m .49399 .79581 L .50463 .82867 L F
.51538 .8619 m .51492 .86249 L p .50463 .82867 L F P
0 g
s
.223 .202 .623 r
.51265 .85589 m .50463 .82867 L .51492 .86249 L F
.109 .134 .605 r
.51459 .86311 m .51508 .86218 L p .50307 .83114 L F P
0 g
s
.109 .134 .605 r
.50307 .83114 m .51265 .85589 L .49181 .79988 L F
.51265 .85589 m .51168 .85308 L .49181 .79988 L F
.49181 .79988 m .51168 .85308 L .49298 .79862 L F
.49265 .79765 m .49123 .80052 L p .49356 .79799 L F P
0 g
s
0 .047 .571 r
.49197 .79858 m .51468 .86279 L .51459 .86311 L p F P
0 g
s
0 .047 .571 r
.51459 .86311 m .5143 .86406 L p .50307 .83114 L F P
0 g
s
0 .047 .571 r
.50307 .83114 m .49197 .79858 L .51459 .86311 L F
.109 .134 .605 r
.49123 .80052 m .51442 .86342 L .51459 .86311 L p F P
0 g
s
.109 .134 .605 r
.49123 .80052 m .51459 .86311 L .50307 .83114 L F
.223 .202 .623 r
.51492 .86249 m .51468 .86279 L p .51265 .85589 L F P
0 g
s
.109 .134 .605 r
.51265 .85589 m .51508 .86218 L .51168 .85308 L F
.312 .255 .632 r
.49312 .79669 m .51508 .86218 L .51538 .8619 L p F P
0 g
s
.312 .255 .632 r
.51538 .8619 m .51627 .86104 L p .50463 .82867 L F P
0 g
s
.312 .255 .632 r
.49312 .79669 m .51538 .8619 L .50463 .82867 L F
.50463 .82867 m .51391 .85449 L .4941 .79614 L F
.51391 .85449 m .51304 .85157 L .4941 .79614 L F
.4941 .79614 m .51304 .85157 L .49602 .79505 L F
.49572 .79405 m .49312 .79669 L p .49698 .79451 L F P
0 g
s
.223 .202 .623 r
.49467 .79488 m .51561 .8616 L .51538 .8619 L p F P
0 g
s
.223 .202 .623 r
.50463 .82867 m .49467 .79488 L .51538 .8619 L F
.382 .298 .636 r
.51597 .86133 m .51561 .8616 L p .51391 .85449 L F P
0 g
s
.312 .255 .632 r
.51391 .85449 m .51627 .86104 L .51304 .85157 L F
.44 .334 .637 r
.49659 .79316 m .51627 .86104 L .51669 .8608 L p F P
0 g
s
.44 .334 .637 r
.51669 .8608 m .51793 .86006 L p .50721 .82644 L F P
0 g
s
.44 .334 .637 r
.49659 .79316 m .51669 .8608 L .50721 .82644 L F
.50721 .82644 m .51577 .85326 L .49791 .79274 L F
.51577 .85326 m .51502 .85025 L .49791 .79274 L F
.49791 .79274 m .51502 .85025 L .50051 .7919 L F
.50025 .79087 m .49659 .79316 L p .5018 .79148 L F P
0 g
s
.382 .298 .636 r
.49887 .79156 m .51705 .86053 L .51669 .8608 L p F P
0 g
s
.382 .298 .636 r
.50721 .82644 m .49887 .79156 L .51669 .8608 L F
.488 .364 .638 r
.51752 .8603 m .51705 .86053 L p .51577 .85326 L F P
0 g
s
.44 .334 .637 r
.51577 .85326 m .51793 .86006 L .51502 .85025 L F
.529 .391 .637 r
.50148 .7901 m .51793 .86006 L .51845 .85986 L p F P
0 g
s
.529 .391 .637 r
.51845 .85986 m .51999 .85927 L p .51069 .82453 L F P
0 g
s
.529 .391 .637 r
.50148 .7901 m .51845 .85986 L .51069 .82453 L F
.51069 .82453 m .51811 .85225 L .50308 .78983 L F
.51811 .85225 m .51753 .84917 L .50308 .78983 L F
.50308 .78983 m .51753 .84917 L .50623 .78932 L F
.50603 .78826 m .50148 .7901 L p .5078 .78906 L F P
0 g
s
.488 .364 .638 r
.50438 .78878 m .51892 .85964 L .51845 .85986 L p F P
0 g
s
.488 .364 .638 r
.51069 .82453 m .50438 .78878 L .51845 .85986 L F
.565 .415 .637 r
.51948 .85947 m .51892 .85964 L p .51811 .85225 L F P
0 g
s
.529 .391 .637 r
.51811 .85225 m .51999 .85927 L .51753 .84917 L F
.597 .437 .636 r
.50756 .78764 m .51999 .85927 L .52058 .85913 L p F P
0 g
s
.597 .437 .636 r
.52058 .85913 m .52235 .85872 L p .51493 .82305 L F P
0 g
s
.597 .437 .636 r
.50756 .78764 m .52058 .85913 L .51493 .82305 L F
.51493 .82305 m .52085 .85151 L .50936 .78757 L F
.52085 .85151 m .52046 .84838 L .50936 .78757 L F
.50936 .78757 m .52046 .84838 L .51292 .78744 L F
.51279 .78635 m .50756 .78764 L p .5147 .78737 L F P
0 g
s
.565 .415 .637 r
.51096 .78668 m .52114 .85896 L .52058 .85913 L p F P
0 g
s
.565 .415 .637 r
.51493 .82305 m .51096 .78668 L .52058 .85913 L F
.626 .458 .635 r
.52176 .85886 m .52114 .85896 L p .52085 .85151 L F P
0 g
s
.597 .437 .636 r
.52085 .85151 m .52235 .85872 L .52046 .84838 L F
.653 .478 .635 r
.51454 .78592 m .52235 .85872 L .52299 .85865 L p F P
0 g
s
.653 .478 .635 r
.52299 .85865 m .5249 .85843 L p .5197 .82206 L F P
0 g
s
.653 .478 .635 r
.51454 .78592 m .52299 .85865 L .5197 .82206 L F
.5197 .82206 m .52385 .85109 L .51647 .78606 L F
.52385 .85109 m .52367 .84792 L .51647 .78606 L F
.51647 .78606 m .52367 .84792 L .52026 .78634 L F
.5202 .78525 m .51454 .78592 L p .52215 .78648 L F P
0 g
s
.626 .458 .635 r
.51827 .78537 m .52361 .85854 L .52299 .85865 L p F P
0 g
s
.626 .458 .635 r
.5197 .82206 m .51827 .78537 L .52299 .85865 L F
.678 .497 .635 r
.52426 .8585 m .52361 .85854 L p .52385 .85109 L F P
0 g
s
.653 .478 .635 r
.52385 .85109 m .5249 .85843 L .52367 .84792 L F
.702 .517 .634 r
.5221 .78502 m .5249 .85843 L .52555 .85843 L p F P
0 g
s
.702 .517 .634 r
.52555 .85843 m .52751 .85842 L p .52479 .82161 L F P
0 g
s
.702 .517 .634 r
.5221 .78502 m .52555 .85843 L .52479 .82161 L F
.678 .497 .635 r
.52597 .7849 m .5262 .85839 L .52555 .85843 L p F P
0 g
s
.678 .497 .635 r
.52479 .82161 m .52597 .7849 L .52555 .85843 L F
.725 .536 .635 r
.5262 .85839 m .52597 .7849 L .52791 .785 L p F P
0 g
s
.725 .536 .635 r
.52791 .785 m .53369 .7853 L p .52696 .85099 L F P
0 g
s
.725 .536 .635 r
.5262 .85839 m .52791 .785 L .52696 .85099 L F
.702 .517 .634 r
.52696 .85099 m .52751 .85842 L .52701 .84779 L F
.748 .556 .635 r
.52985 .78499 m .52751 .85842 L .52815 .85849 L p F P
0 g
s
.748 .556 .635 r
.52815 .85849 m .53006 .85869 L p .52996 .82173 L F P
0 g
s
.748 .556 .635 r
.52985 .78499 m .52815 .85849 L .52996 .82173 L F
.725 .536 .635 r
.52996 .82173 m .53369 .7853 L .5296 .8291 L F
.771 .576 .635 r
.5288 .85852 m .53369 .7853 L .53554 .78561 L p F P
0 g
s
.771 .576 .635 r
.53554 .78561 m .54106 .78655 L p .53004 .85123 L F P
0 g
s
.771 .576 .635 r
.5288 .85852 m .53554 .78561 L .53004 .85123 L F
.748 .556 .635 r
.53004 .85123 m .53006 .85869 L .53031 .84805 L F
.794 .598 .636 r
.53744 .78582 m .53006 .85869 L .53066 .85882 L p F P
0 g
s
.794 .598 .636 r
.53066 .85882 m .53244 .85922 L p .53495 .82241 L F P
0 g
s
.794 .598 .636 r
.53744 .78582 m .53066 .85882 L .53495 .82241 L F
.771 .576 .635 r
.53495 .82241 m .54106 .78655 L .53409 .82971 L F
.818 .621 .636 r
.53128 .85892 m .54106 .78655 L .54273 .78707 L p F P
0 g
s
.818 .621 .636 r
.54273 .78707 m .54771 .7886 L p .53295 .85179 L F P
0 g
s
.818 .621 .636 r
.53128 .85892 m .54273 .78707 L .53295 .85179 L F
.794 .598 .636 r
.53295 .85179 m .53244 .85922 L .53342 .84865 L F
.842 .645 .637 r
.54449 .78748 m .53244 .85922 L .53297 .85941 L p F P
0 g
s
.842 .645 .637 r
.53297 .85941 m .53453 .85999 L p .53953 .82362 L F P
0 g
s
.842 .645 .637 r
.54449 .78748 m .53297 .85941 L .53953 .82362 L F
.818 .621 .636 r
.53953 .82362 m .54771 .7886 L .53821 .83079 L F
.867 .672 .637 r
.53353 .85958 m .54771 .7886 L .54912 .78928 L p F P
0 g
s
.867 .672 .637 r
.53353 .85958 m .54912 .78928 L .53554 .85264 L F
.842 .645 .637 r
.53554 .85264 m .53453 .85999 L .5362 .84957 L F
.893 .702 .637 r
.55192 .79064 m .55066 .78988 L p .54347 .82529 L F P
0 g
s
.867 .672 .637 r
.53543 .86045 m .53496 .86023 L p .55295 .79266 L F P
0 g
s
.867 .672 .637 r
.54177 .83229 m .55295 .79266 L .53496 .86023 L F
.919 .734 .636 r
.53543 .86045 m .55297 .7927 L p .55414 .79317 L F P
0 g
s
.919 .734 .636 r
.53543 .86045 m .55414 .79317 L .5385 .85078 L F
.893 .702 .637 r
.53623 .86096 m .55566 .79291 L .55441 .79215 L p F P
0 g
s
.893 .702 .637 r
.53769 .85376 m .53623 .86096 L .55441 .79215 L F
.946 .77 .632 r
.55657 .79379 m .55566 .79291 L p .5466 .82735 L F P
0 g
s
.919 .734 .636 r
.5466 .82735 m .55647 .79413 L .55765 .79461 L F
.97 .808 .625 r
.53691 .86151 m .55724 .79593 L p .55805 .79652 L F P
0 g
s
.97 .808 .625 r
.53691 .86151 m .55805 .79652 L .54023 .85219 L F
.946 .77 .632 r
.53747 .86209 m .55926 .79641 L .55836 .79553 L p F P
0 g
s
.946 .77 .632 r
.53931 .85507 m .53747 .86209 L .55836 .79553 L F
.989 .847 .609 r
.55978 .79737 m .55926 .79641 L p .54877 .8297 L F P
0 g
s
.97 .808 .625 r
.54877 .8297 m .55967 .79769 L .56049 .79829 L F
.989 .847 .609 r
.53818 .86332 m .5613 .80022 L .56079 .79926 L p F P
0 g
s
.989 .847 .609 r
.54032 .85652 m .53818 .86332 L .56079 .79926 L F
.992 .882 .579 r
.53789 .8627 m .56049 .79829 L .56079 .79926 L p F P
0 g
s
.992 .882 .579 r
.53789 .8627 m .56079 .79926 L .54132 .85373 L F
.718 .785 .3 r
.53792 .86586 m .56044 .80802 L .56075 .80705 L p F P
0 g
s
.718 .785 .3 r
.54035 .85957 m .53792 .86586 L .56075 .80705 L F
0 0 0 r
.5382 .86524 m .56082 .80727 L p .56045 .80782 L F P
0 g
s
0 0 0 r
.54134 .857 m .56045 .80782 L .55972 .80893 L F
.5382 .86524 m .56045 .80782 L .54134 .857 L F
.56075 .80705 m .55972 .80893 L p .56082 .80727 L F P
0 g
s
0 0 0 r
.5382 .86524 m .55972 .80893 L .5488 .8373 L F
.878 .873 .432 r
.5616 .80316 m .56138 .80512 L p .54169 .85537 L F P
0 g
s
.718 .785 .3 r
.56075 .80705 m .56138 .80512 L p .54035 .85957 L F P
0 g
s
0 0 0 r
.53769 .86616 m .53803 .86555 L p .5488 .8373 L F P
0 g
s
0 0 0 r
.54035 .85957 m .5488 .8373 L .53803 .86555 L F
.878 .873 .432 r
.54067 .85805 m .56138 .80512 L .54989 .83479 L F
.963 .897 .524 r
.5613 .80022 m .53818 .86332 L .53829 .86428 L p F P
0 g
s
.963 .897 .524 r
.5613 .80022 m .53829 .86428 L .54067 .85805 L F
.878 .873 .432 r
.53832 .86396 m .54169 .85537 L .54067 .85805 L F
.54169 .85537 m .56138 .80512 L .54067 .85805 L F
.718 .785 .3 r
.56124 .80533 m .54989 .83479 L .56138 .80512 L F
.54989 .83479 m .54035 .85957 L .56138 .80512 L F
.54989 .83479 m .53803 .86555 L .54035 .85957 L F
.54756 .84081 m .53803 .86555 L .54989 .83479 L F
.53823 .86492 m .53803 .86555 L p .54756 .84081 L F P
0 g
s
.718 .785 .3 r
.53803 .86555 m .53792 .86586 L p .54035 .85957 L F P
0 g
s
0 0 0 r
.53803 .86555 m .5382 .86524 L p .54035 .85957 L F P
0 g
s
.878 .873 .432 r
.56127 .8061 m .5382 .86524 L .53823 .86492 L p F P
0 g
s
.878 .873 .432 r
.53823 .86492 m .53832 .86396 L p .54989 .83479 L F P
0 g
s
.878 .873 .432 r
.54989 .83479 m .56127 .8061 L .53823 .86492 L F
.963 .897 .524 r
.53829 .86428 m .53833 .8646 L p .54067 .85805 L F P
0 g
s
.878 .873 .432 r
.54989 .83479 m .56138 .80512 L .56083 .80721 L F
.718 .785 .3 r
.5617 .80415 m .54756 .84081 L .54989 .83479 L F
.5617 .80415 m .53833 .8646 L .53823 .86492 L p F P
0 g
s
.718 .785 .3 r
.5617 .80415 m .53823 .86492 L .54756 .84081 L F
.963 .897 .524 r
.5616 .80316 m .5614 .80121 L p .56124 .80534 L F P
0 g
s
.963 .897 .524 r
.56129 .80152 m .56124 .80534 L .5614 .80121 L F
.992 .882 .579 r
.5614 .80121 m .56171 .80218 L p .54989 .83222 L F P
0 g
s
.963 .897 .524 r
.5614 .80121 m .5613 .80022 L p .56129 .80152 L F P
0 g
s
.963 .897 .524 r
.5613 .80022 m .54989 .83222 L .56129 .80152 L F
.992 .882 .579 r
.56171 .80218 m .53832 .86396 L .53821 .86364 L p F P
0 g
s
.992 .882 .579 r
.54989 .83222 m .56171 .80218 L .53821 .86364 L F
.878 .873 .432 r
.53832 .86396 m .56171 .80218 L .5616 .80316 L p F P
0 g
s
.878 .873 .432 r
.53832 .86396 m .5616 .80316 L .54169 .85537 L F
.963 .897 .524 r
.53833 .8646 m .56124 .80534 L p .56125 .80407 L F P
0 g
s
.963 .897 .524 r
.54067 .85805 m .53833 .8646 L .56125 .80407 L F
.56124 .80534 m .5617 .80415 L .5616 .80316 L p F P
0 g
s
.925 .817 .356 r
.5616 .80316 m .5617 .80415 L p .56532 .7855 L F P
0 g
s
.785 .743 .221 r
.56532 .7855 m .5829 .70362 L .57535 .73922 L F
.56171 .80218 m .56675 .77873 L .56532 .7855 L F
.56675 .77873 m .5829 .70362 L .56532 .7855 L F
.988 .832 .45 r
.5835 .69854 m .56171 .80218 L .5614 .80121 L p F P
0 g
s
.988 .832 .45 r
.57333 .74365 m .5835 .69854 L .5614 .80121 L F
.56444 .78113 m .5835 .69854 L .56079 .79926 L F
.56584 .77418 m .58303 .69685 L .56444 .78113 L F
.925 .817 .356 r
.5829 .69514 m .5613 .80022 L .5614 .80121 L p F P
0 g
s
.925 .817 .356 r
.5829 .69514 m .5614 .80121 L .57544 .73348 L F
1 .812 .509 r
.56079 .79926 m .5613 .80022 L p .56444 .78113 L F P
0 g
s
1 .812 .509 r
.57321 .72785 m .56079 .79926 L .56444 .78113 L F
.988 .832 .45 r
.56079 .79926 m .56049 .79829 L p .56444 .78113 L F P
0 g
s
.97 .808 .625 r
.55724 .79593 m .55765 .79461 L .55836 .79553 L p F P
0 g
s
.919 .734 .636 r
.55297 .7927 m .55333 .79133 L .55441 .79215 L p F P
0 g
s
.903 .676 .585 r
.55441 .79215 m .55566 .79291 L p .5547 .79204 L F P
0 g
s
.903 .676 .585 r
.55084 .78855 m .55441 .79215 L .5547 .79204 L F
.867 .672 .637 r
.55333 .79133 m .55297 .7927 L p .55295 .79266 L F P
0 g
s
.867 .672 .637 r
.55297 .7927 m .53543 .86045 L p .55295 .79266 L F P
0 g
s
.842 .645 .637 r
.53453 .85999 m .55066 .78988 L .54912 .78928 L p F P
0 g
s
.842 .645 .637 r
.5362 .84957 m .53453 .85999 L .54912 .78928 L F
.867 .672 .637 r
.53401 .8598 m .53353 .85958 L p .53554 .85264 L F P
0 g
s
.818 .621 .636 r
.54771 .7886 m .53353 .85958 L .53297 .85941 L p F P
0 g
s
.818 .621 .636 r
.53821 .83079 m .54771 .7886 L .53297 .85941 L F
.842 .645 .637 r
.54604 .78809 m .54449 .78748 L p .53953 .82362 L F P
0 g
s
.794 .598 .636 r
.53244 .85922 m .54449 .78748 L .54273 .78707 L p F P
0 g
s
.794 .598 .636 r
.53342 .84865 m .53244 .85922 L .54273 .78707 L F
.818 .621 .636 r
.53184 .85908 m .53128 .85892 L p .53295 .85179 L F P
0 g
s
.771 .576 .635 r
.54106 .78655 m .53128 .85892 L .53066 .85882 L p F P
0 g
s
.771 .576 .635 r
.53409 .82971 m .54106 .78655 L .53066 .85882 L F
.794 .598 .636 r
.53921 .78624 m .53744 .78582 L p .53495 .82241 L F P
0 g
s
.748 .556 .635 r
.53006 .85869 m .53744 .78582 L .53554 .78561 L p F P
0 g
s
.748 .556 .635 r
.53031 .84805 m .53006 .85869 L .53554 .78561 L F
.771 .576 .635 r
.52942 .85862 m .5288 .85852 L p .53004 .85123 L F P
0 g
s
.725 .536 .635 r
.53369 .7853 m .5288 .85852 L .52815 .85849 L p F P
0 g
s
.725 .536 .635 r
.5296 .8291 m .53369 .7853 L .52815 .85849 L F
.748 .556 .635 r
.53176 .7852 m .52985 .78499 L p .52996 .82173 L F P
0 g
s
.702 .517 .634 r
.52751 .85842 m .52985 .78499 L .52791 .785 L p F P
0 g
s
.702 .517 .634 r
.52701 .84779 m .52751 .85842 L .52791 .785 L F
.725 .536 .635 r
.52685 .85842 m .5262 .85839 L p .52696 .85099 L F P
0 g
s
.678 .497 .635 r
.52404 .78501 m .52597 .7849 L p .52479 .82161 L F P
0 g
s
.702 .517 .634 r
.52404 .78501 m .5221 .78502 L p .52479 .82161 L F P
0 g
s
.653 .478 .635 r
.5249 .85843 m .52215 .78648 L p .52026 .78634 L F P
0 g
s
.653 .478 .635 r
.52367 .84792 m .5249 .85843 L .52026 .78634 L F
.678 .497 .635 r
.52361 .85854 m .51827 .78537 L .5202 .78525 L p F P
0 g
s
.678 .497 .635 r
.52361 .85854 m .5202 .78525 L .52385 .85109 L F
.626 .458 .635 r
.51643 .7857 m .51827 .78537 L p .5197 .82206 L F P
0 g
s
.653 .478 .635 r
.51454 .78592 m .5197 .82206 L .51647 .78606 L F
.597 .437 .636 r
.52235 .85872 m .5147 .78737 L p .51292 .78744 L F P
0 g
s
.597 .437 .636 r
.52046 .84838 m .52235 .85872 L .51292 .78744 L F
.626 .458 .635 r
.52114 .85896 m .51096 .78668 L .51279 .78635 L p F P
0 g
s
.626 .458 .635 r
.52114 .85896 m .51279 .78635 L .52085 .85151 L F
.565 .415 .637 r
.50931 .78721 m .51096 .78668 L p .51493 .82305 L F P
0 g
s
.597 .437 .636 r
.50756 .78764 m .51493 .82305 L .50936 .78757 L F
.529 .391 .637 r
.51999 .85927 m .5078 .78906 L p .50623 .78932 L F P
0 g
s
.529 .391 .637 r
.51753 .84917 m .51999 .85927 L .50623 .78932 L F
.565 .415 .637 r
.51892 .85964 m .50438 .78878 L .50603 .78826 L p F P
0 g
s
.565 .415 .637 r
.51892 .85964 m .50603 .78826 L .51811 .85225 L F
.488 .364 .638 r
.503 .78948 m .50438 .78878 L p .51069 .82453 L F P
0 g
s
.529 .391 .637 r
.50148 .7901 m .51069 .82453 L .50308 .78983 L F
.44 .334 .637 r
.51793 .86006 m .5018 .79148 L p .50051 .7919 L F P
0 g
s
.44 .334 .637 r
.51502 .85025 m .51793 .86006 L .50051 .7919 L F
.488 .364 .638 r
.51705 .86053 m .49887 .79156 L .50025 .79087 L p F P
0 g
s
.488 .364 .638 r
.51705 .86053 m .50025 .79087 L .51577 .85326 L F
.382 .298 .636 r
.49781 .7924 m .49887 .79156 L p .50721 .82644 L F P
0 g
s
.44 .334 .637 r
.49659 .79316 m .50721 .82644 L .49791 .79274 L F
.312 .255 .632 r
.51627 .86104 m .49698 .79451 L p .49602 .79505 L F P
0 g
s
.312 .255 .632 r
.51304 .85157 m .51627 .86104 L .49602 .79505 L F
.382 .298 .636 r
.51561 .8616 m .49467 .79488 L .49572 .79405 L p F P
0 g
s
.382 .298 .636 r
.51561 .8616 m .49572 .79405 L .51391 .85449 L F
.223 .202 .623 r
.49399 .79581 m .49467 .79488 L p .50463 .82867 L F P
0 g
s
.312 .255 .632 r
.49312 .79669 m .50463 .82867 L .4941 .79614 L F
.109 .134 .605 r
.51508 .86218 m .49356 .79799 L p .49298 .79862 L F P
0 g
s
.109 .134 .605 r
.51168 .85308 m .51508 .86218 L .49298 .79862 L F
.223 .202 .623 r
.51468 .86279 m .49197 .79858 L .49265 .79765 L p F P
0 g
s
.223 .202 .623 r
.51468 .86279 m .49265 .79765 L .51265 .85589 L F
0 0 .511 r
.51439 .86374 m .51442 .86342 L p .51203 .8574 L F P
0 g
s
0 0 .511 r
.51442 .86342 m .49123 .80052 L .49116 .80151 L p F P
0 g
s
0 0 .511 r
.51203 .8574 m .51442 .86342 L .49116 .80151 L F
0 .047 .571 r
.5143 .86406 m .4909 .80248 L .49116 .80151 L p F P
0 g
s
0 .047 .571 r
.5143 .86406 m .49116 .80151 L .51101 .85467 L F
.4917 .79956 m .49197 .79858 L p .50307 .83114 L F P
0 g
s
.109 .134 .605 r
.49123 .80052 m .50307 .83114 L .49181 .79988 L F
.49356 .79799 m .49312 .79669 L .49265 .79765 L p F P
0 g
s
.312 .255 .632 r
.49698 .79451 m .49659 .79316 L .49572 .79405 L p F P
0 g
s
.44 .334 .637 r
.5018 .79148 m .50148 .7901 L .50025 .79087 L p F P
0 g
s
.529 .391 .637 r
.5078 .78906 m .50756 .78764 L .50603 .78826 L p F P
0 g
s
.597 .437 .636 r
.5147 .78737 m .51454 .78592 L .51279 .78635 L p F P
0 g
s
.653 .478 .635 r
.52215 .78648 m .5221 .78502 L .5202 .78525 L p F P
0 g
s
.672 .465 .597 r
.5202 .78525 m .51827 .78537 L p .51835 .78408 L F P
0 g
s
.672 .465 .597 r
.51835 .78408 m .52312 .70965 L .5202 .78525 L F
.52312 .70965 m .52576 .66839 L .52404 .78501 L F
.51955 .76542 m .52261 .66859 L .52312 .70965 L F
.51929 .75781 m .52261 .66859 L .51955 .76542 L F
.51636 .669 m .52261 .66859 L p .51929 .75781 L F P
0 g
s
.698 .486 .598 r
.52261 .66859 m .51945 .66861 L p .52312 .70965 L F P
0 g
s
.723 .507 .597 r
.52597 .7849 m .52576 .66839 L .52891 .66856 L p F P
0 g
s
.747 .528 .597 r
.53397 .70992 m .53554 .78561 L .53653 .76583 L F
.723 .507 .597 r
.52891 .66856 m .53517 .66892 L p .52808 .76514 L F P
0 g
s
.723 .507 .597 r
.52808 .76514 m .53517 .66892 L .53397 .70992 L F
.747 .528 .597 r
.53208 .66855 m .53364 .72126 L .53397 .70992 L F
.53364 .72126 m .53554 .78561 L .53397 .70992 L F
.54133 .66965 m .53208 .66855 L p .53653 .76583 L F P
0 g
s
.723 .507 .597 r
.53517 .66892 m .53832 .66909 L p .53397 .70992 L F P
0 g
s
.723 .507 .597 r
.52597 .7849 m .52891 .66856 L .52808 .76514 L F
.645 .444 .597 r
.5202 .78525 m .5221 .78502 L p .51955 .76542 L F P
0 g
s
.672 .465 .597 r
.51827 .78537 m .51929 .75781 L .51955 .76542 L F
.615 .422 .597 r
.51322 .66921 m .51827 .78537 L .51643 .7857 L p F P
0 g
s
.615 .422 .597 r
.51242 .71066 m .51322 .66921 L .51643 .7857 L F
.51134 .76666 m .51024 .66979 L .51242 .71066 L F
.51079 .7591 m .51024 .66979 L .51134 .76666 L F
.50431 .67095 m .51024 .66979 L p .51079 .7591 L F P
0 g
s
.645 .444 .597 r
.50716 .67019 m .51454 .78592 L .51643 .7857 L p F P
0 g
s
.645 .444 .597 r
.50716 .67019 m .51643 .7857 L .51242 .71066 L F
.584 .398 .596 r
.51279 .78635 m .51454 .78592 L p .51134 .76666 L F P
0 g
s
.615 .422 .597 r
.51096 .78668 m .51079 .7591 L .51134 .76666 L F
.548 .372 .594 r
.50133 .67152 m .51096 .78668 L .50931 .78721 L p F P
0 g
s
.548 .372 .594 r
.50241 .71289 m .50133 .67152 L .50931 .78721 L F
.50386 .7688 m .49865 .67245 L .50241 .71289 L F
.50303 .76133 m .49865 .67245 L .50386 .7688 L F
.49334 .67428 m .49865 .67245 L p .50303 .76133 L F P
0 g
s
.584 .398 .596 r
.49581 .6732 m .50756 .78764 L .50931 .78721 L p F P
0 g
s
.584 .398 .596 r
.49581 .6732 m .50931 .78721 L .50241 .71289 L F
.508 .343 .592 r
.50603 .78826 m .50756 .78764 L p .50386 .7688 L F P
0 g
s
.548 .372 .594 r
.50438 .78878 m .50303 .76133 L .50386 .7688 L F
.461 .31 .589 r
.49067 .67521 m .50438 .78878 L .503 .78948 L p F P
0 g
s
.461 .31 .589 r
.49356 .71624 m .49067 .67521 L .503 .78948 L F
.49747 .77173 m .48844 .67643 L .49356 .71624 L F
.49641 .76437 m .48844 .67643 L .49747 .77173 L F
.48399 .67885 m .48844 .67643 L p .49641 .76437 L F P
0 g
s
.508 .343 .592 r
.48597 .6775 m .50148 .7901 L .503 .78948 L p F P
0 g
s
.508 .343 .592 r
.48597 .6775 m .503 .78948 L .49356 .71624 L F
.406 .271 .584 r
.50025 .79087 m .50148 .7901 L p .49747 .77173 L F P
0 g
s
.461 .31 .589 r
.49887 .79156 m .49641 .76437 L .49747 .77173 L F
.338 .225 .575 r
.48176 .68007 m .49887 .79156 L .49781 .7924 L p F P
0 g
s
.338 .225 .575 r
.48631 .72054 m .48176 .68007 L .49781 .7924 L F
.406 .271 .584 r
.4781 .68286 m .49659 .79316 L .49781 .7924 L p F P
0 g
s
.406 .271 .584 r
.4781 .68286 m .49781 .7924 L .48631 .72054 L F
.252 .167 .562 r
.49572 .79405 m .49659 .79316 L p .49247 .77529 L F P
0 g
s
.143 .095 .539 r
.47502 .68586 m .49467 .79488 L .49399 .79581 L p F P
0 g
s
.143 .095 .539 r
.48099 .72557 m .47502 .68586 L .49399 .79581 L F
.48908 .77933 m .47394 .68748 L .48099 .72557 L F
.48771 .7723 m .47394 .68748 L .48908 .77933 L F
.4718 .69069 m .47394 .68748 L p .48771 .7723 L F P
0 g
s
.252 .167 .562 r
.47255 .68902 m .49312 .79669 L .49399 .79581 L p F P
0 g
s
.252 .167 .562 r
.47255 .68902 m .49399 .79581 L .48099 .72557 L F
0 .001 .501 r
.49265 .79765 m .49312 .79669 L p .48908 .77933 L F P
0 g
s
.143 .095 .539 r
.49197 .79858 m .48771 .7723 L .48908 .77933 L F
0 0 .437 r
.48745 .78364 m .47073 .69229 L .49116 .80151 L F
0 .001 .501 r
.46958 .69566 m .49123 .80052 L .4917 .79956 L p F P
0 g
s
0 .001 .501 r
.46958 .69566 m .4917 .79956 L .47783 .73107 L F
0 0 .437 r
.47073 .69229 m .49197 .79858 L .4917 .79956 L p F P
0 g
s
0 0 .437 r
.47991 .74135 m .47073 .69229 L .4917 .79956 L F
0 0 .335 r
.49085 .80255 m .49116 .80151 L .4911 .8012 L F
0 0 .437 r
.49116 .80151 m .4909 .80248 L p .48745 .78364 L F P
0 g
s
0 0 .335 r
.49116 .80151 m .49123 .80052 L p .4911 .8012 L F P
0 g
s
0 0 .335 r
.49123 .80052 m .46958 .69566 L .4695 .69737 L p F P
0 g
s
0 0 .284 r
.45564 .62056 m .4695 .69737 L .46555 .67394 L F
0 0 .134 r
.46596 .68129 m .44907 .58188 L .46987 .70414 L F
0 0 .335 r
.4695 .69737 m .46935 .70076 L p .48745 .78364 L F P
0 g
s
.811 .52 0 r
.47098 .71049 m .46927 .70247 L .46987 .70414 L p F P
0 g
s
0 0 .134 r
.47012 .70583 m .46869 .69744 L p .46879 .69804 L F P
0 g
s
.846 .565 .026 r
.46987 .70414 m .46927 .70247 L p .46596 .68129 L F P
0 g
s
0 0 .193 r
.46987 .70414 m .46935 .70076 L p .48764 .78802 L F P
0 g
s
0 0 .335 r
.47696 .7368 m .48745 .78364 L .46935 .70076 L F
0 0 .193 r
.46935 .70076 m .46909 .69906 L p .47696 .7368 L F P
0 g
s
0 0 .193 r
.48764 .78802 m .46935 .70076 L .47696 .7368 L F
0 0 .335 r
.47072 .70891 m .47696 .7368 L .46935 .70076 L F
.46935 .70076 m .46927 .70247 L p .47072 .70891 L F P
0 g
s
0 0 .335 r
.48745 .78364 m .49123 .80052 L .4695 .69737 L F
0 0 .437 r
.4909 .80248 m .48602 .77679 L .48745 .78364 L F
0 0 .193 r
.47696 .7368 m .46909 .69906 L .47907 .74679 L F
0 0 .335 r
.49072 .80323 m .49104 .80347 L .49085 .80255 L F
0 0 .437 r
.4909 .80248 m .46909 .69906 L .4695 .69737 L p F P
0 g
s
0 0 .437 r
.4909 .80248 m .4695 .69737 L .48602 .77679 L F
0 0 .335 r
.48745 .78364 m .4911 .8012 L .49123 .80052 L F
.46927 .70247 m .49072 .80323 L p .49085 .80255 L F P
0 g
s
0 0 .335 r
.46927 .70247 m .49085 .80255 L .47696 .7368 L F
0 0 .193 r
.46909 .69906 m .4909 .80248 L .49104 .80347 L p F P
0 g
s
0 0 .193 r
.47907 .74679 m .46909 .69906 L .49104 .80347 L F
0 .001 .501 r
.47032 .694 m .46958 .69566 L p .47783 .73107 L F P
0 g
s
0 0 .437 r
.47032 .694 m .47073 .69229 L p .47783 .73107 L F P
0 g
s
.143 .095 .539 r
.49197 .79858 m .47073 .69229 L .4718 .69069 L p F P
0 g
s
.143 .095 .539 r
.49197 .79858 m .4718 .69069 L .48771 .7723 L F
0 .001 .501 r
.49312 .79669 m .47255 .68902 L .4718 .69069 L p F P
0 g
s
0 .001 .501 r
.48908 .77933 m .49312 .79669 L .4718 .69069 L F
.252 .167 .562 r
.47394 .68748 m .47255 .68902 L p .48099 .72557 L F P
0 g
s
.143 .095 .539 r
.47394 .68748 m .47502 .68586 L p .48099 .72557 L F P
0 g
s
.252 .167 .562 r
.49659 .79316 m .4781 .68286 L .4767 .68441 L p F P
0 g
s
.252 .167 .562 r
.49247 .77529 m .49659 .79316 L .4767 .68441 L F
.338 .225 .575 r
.49467 .79488 m .47502 .68586 L .4767 .68441 L p F P
0 g
s
.338 .225 .575 r
.49467 .79488 m .4767 .68441 L .49122 .76809 L F
.406 .271 .584 r
.48007 .68152 m .4781 .68286 L p .48631 .72054 L F P
0 g
s
.338 .225 .575 r
.48007 .68152 m .48176 .68007 L p .48631 .72054 L F P
0 g
s
.461 .31 .589 r
.49887 .79156 m .48176 .68007 L .48399 .67885 L p F P
0 g
s
.461 .31 .589 r
.49887 .79156 m .48399 .67885 L .49641 .76437 L F
.406 .271 .584 r
.50148 .7901 m .48597 .6775 L .48399 .67885 L p F P
0 g
s
.406 .271 .584 r
.49747 .77173 m .50148 .7901 L .48399 .67885 L F
.508 .343 .592 r
.48844 .67643 m .48597 .6775 L p .49356 .71624 L F P
0 g
s
.461 .31 .589 r
.48844 .67643 m .49067 .67521 L p .49356 .71624 L F P
0 g
s
.548 .372 .594 r
.50438 .78878 m .49067 .67521 L .49334 .67428 L p F P
0 g
s
.548 .372 .594 r
.50438 .78878 m .49334 .67428 L .50303 .76133 L F
.508 .343 .592 r
.50756 .78764 m .49581 .6732 L .49334 .67428 L p F P
0 g
s
.508 .343 .592 r
.50386 .7688 m .50756 .78764 L .49334 .67428 L F
.584 .398 .596 r
.49865 .67245 m .49581 .6732 L p .50241 .71289 L F P
0 g
s
.548 .372 .594 r
.49865 .67245 m .50133 .67152 L p .50241 .71289 L F P
0 g
s
.615 .422 .597 r
.51096 .78668 m .50133 .67152 L .50431 .67095 L p F P
0 g
s
.615 .422 .597 r
.51096 .78668 m .50431 .67095 L .51079 .7591 L F
.584 .398 .596 r
.51454 .78592 m .50716 .67019 L .50431 .67095 L p F P
0 g
s
.584 .398 .596 r
.51134 .76666 m .51454 .78592 L .50431 .67095 L F
.645 .444 .597 r
.51024 .66979 m .50716 .67019 L p .51242 .71066 L F P
0 g
s
.615 .422 .597 r
.51024 .66979 m .51322 .66921 L p .51242 .71066 L F P
0 g
s
.672 .465 .597 r
.51827 .78537 m .51322 .66921 L .51636 .669 L p F P
0 g
s
.672 .465 .597 r
.51827 .78537 m .51636 .669 L .51929 .75781 L F
.645 .444 .597 r
.5221 .78502 m .51945 .66861 L .51636 .669 L p F P
0 g
s
.645 .444 .597 r
.51955 .76542 m .5221 .78502 L .51636 .669 L F
.698 .486 .598 r
.51945 .66861 m .5221 .78502 L .52404 .78501 L p F P
0 g
s
.698 .486 .598 r
.51945 .66861 m .52404 .78501 L .52312 .70965 L F
.672 .465 .597 r
.52261 .66859 m .52576 .66839 L p .52312 .70965 L F P
0 g
s
.723 .507 .597 r
.52791 .785 m .52597 .7849 L p .52808 .76514 L F P
0 g
s
.698 .486 .598 r
.52985 .78499 m .53208 .66855 L .52891 .66856 L p F P
0 g
s
.698 .486 .598 r
.52808 .76514 m .52985 .78499 L .52891 .66856 L F
.723 .507 .597 r
.53832 .66909 m .53369 .7853 L .53176 .7852 L p F P
0 g
s
.723 .507 .597 r
.53397 .70992 m .53832 .66909 L .53176 .7852 L F
.747 .528 .597 r
.53208 .66855 m .52985 .78499 L .53176 .7852 L p F P
0 g
s
.747 .528 .597 r
.53208 .66855 m .53176 .7852 L .53364 .72126 L F
.53554 .78561 m .53744 .78582 L p .53653 .76583 L F P
0 g
s
.772 .549 .597 r
.53369 .7853 m .53832 .66909 L .54133 .66965 L p F P
0 g
s
.797 .571 .596 r
.54445 .71146 m .54273 .78707 L .54448 .76746 L F
.772 .549 .597 r
.54133 .66965 m .5473 .67074 L p .53653 .76583 L F P
0 g
s
.772 .549 .597 r
.53653 .76583 m .5473 .67074 L .54445 .71146 L F
.797 .571 .596 r
.54442 .67001 m .54366 .72272 L .54445 .71146 L F
.54366 .72272 m .54273 .78707 L .54445 .71146 L F
.553 .6722 m .54442 .67001 L p .54448 .76746 L F P
0 g
s
.772 .549 .597 r
.5473 .67074 m .55029 .6713 L p .54445 .71146 L F P
0 g
s
.772 .549 .597 r
.53369 .7853 m .54133 .66965 L .53653 .76583 L F
.53554 .78561 m .53369 .7853 L p .53653 .76583 L F P
0 g
s
.747 .528 .597 r
.53744 .78582 m .54442 .67001 L .54133 .66965 L p F P
0 g
s
.747 .528 .597 r
.53653 .76583 m .53744 .78582 L .54133 .66965 L F
.772 .549 .597 r
.55029 .6713 m .54106 .78655 L .53921 .78624 L p F P
0 g
s
.772 .549 .597 r
.54445 .71146 m .55029 .6713 L .53921 .78624 L F
.797 .571 .596 r
.54442 .67001 m .53744 .78582 L .53921 .78624 L p F P
0 g
s
.797 .571 .596 r
.54442 .67001 m .53921 .78624 L .54366 .72272 L F
.54273 .78707 m .54449 .78748 L p .54448 .76746 L F P
0 g
s
.822 .595 .595 r
.54106 .78655 m .55029 .6713 L .553 .6722 L p F P
0 g
s
.848 .62 .593 r
.55403 .71418 m .54912 .78928 L .55155 .76995 L F
.822 .595 .595 r
.553 .6722 m .55838 .67398 L p .54448 .76746 L F P
0 g
s
.822 .595 .595 r
.54448 .76746 m .55838 .67398 L .55403 .71418 L F
.848 .62 .593 r
.55587 .67293 m .55283 .72531 L .55403 .71418 L F
.55283 .72531 m .54912 .78928 L .55403 .71418 L F
.56336 .67608 m .55587 .67293 L p .55155 .76995 L F P
0 g
s
.822 .595 .595 r
.55838 .67398 m .56108 .67488 L p .55403 .71418 L F P
0 g
s
.822 .595 .595 r
.54106 .78655 m .553 .6722 L .54448 .76746 L F
.54273 .78707 m .54106 .78655 L p .54448 .76746 L F P
0 g
s
.797 .571 .596 r
.54449 .78748 m .55587 .67293 L .553 .6722 L p F P
0 g
s
.797 .571 .596 r
.54448 .76746 m .54449 .78748 L .553 .6722 L F
.822 .595 .595 r
.56108 .67488 m .54771 .7886 L .54604 .78809 L p F P
0 g
s
.822 .595 .595 r
.55403 .71418 m .56108 .67488 L .54604 .78809 L F
.848 .62 .593 r
.55587 .67293 m .54449 .78748 L .54604 .78809 L p F P
0 g
s
.848 .62 .593 r
.55587 .67293 m .54604 .78809 L .55283 .72531 L F
.54912 .78928 m .55066 .78988 L p .55155 .76995 L F P
0 g
s
.875 .647 .589 r
.54771 .7886 m .56108 .67488 L .56336 .67608 L p F P
0 g
s
.875 .647 .589 r
.54771 .7886 m .56336 .67608 L .55155 .76995 L F
.54912 .78928 m .54771 .7886 L p .55155 .76995 L F P
0 g
s
.848 .62 .593 r
.55066 .78988 m .56586 .67713 L .56336 .67608 L p F P
0 g
s
.848 .62 .593 r
.55155 .76995 m .55066 .78988 L .56336 .67608 L F
.932 .709 .577 r
.55333 .79133 m .57016 .67966 L .57191 .6811 L p F P
0 g
s
.932 .709 .577 r
.57191 .6811 m .57711 .68539 L p .5574 .77317 L F P
0 g
s
.932 .709 .577 r
.55333 .79133 m .57191 .6811 L .5574 .77317 L F
.903 .676 .585 r
.5574 .77317 m .55566 .79291 L .55855 .76588 L F
.961 .743 .564 r
.57393 .68242 m .55566 .79291 L .55657 .79379 L p F P
0 g
s
.961 .743 .564 r
.57393 .68242 m .55657 .79379 L .56876 .72259 L F
.932 .709 .577 r
.56876 .72259 m .57711 .68539 L .56693 .73329 L F
.986 .779 .544 r
.55765 .79461 m .57711 .68539 L .57825 .687 L p F P
0 g
s
.986 .779 .544 r
.57825 .687 m .58162 .69178 L p .56177 .77696 L F P
0 g
s
.986 .779 .544 r
.55765 .79461 m .57825 .687 L .56177 .77696 L F
.961 .743 .564 r
.56177 .77696 m .55926 .79641 L .56307 .76983 L F
1 .812 .509 r
.57969 .68852 m .55926 .79641 L .55978 .79737 L p F P
0 g
s
1 .812 .509 r
.57969 .68852 m .55978 .79737 L .57321 .72785 L F
.986 .779 .544 r
.57321 .72785 m .58162 .69178 L .5712 .73829 L F
.988 .832 .45 r
.56049 .79829 m .56584 .77418 L .56444 .78113 L F
1 .812 .509 r
.56444 .78113 m .5613 .80022 L .56584 .77418 L F
.5613 .80022 m .58119 .70342 L p .58097 .69909 L F P
0 g
s
1 .812 .509 r
.56584 .77418 m .5613 .80022 L .58097 .69909 L F
.988 .832 .45 r
.56049 .79829 m .58162 .69178 L .58209 .69348 L p F P
0 g
s
.988 .832 .45 r
.56049 .79829 m .58209 .69348 L .56584 .77418 L F
.58303 .69685 m .5835 .69854 L p .57544 .73348 L F P
0 g
s
.925 .817 .356 r
.58149 .70235 m .57544 .73348 L .58303 .69685 L F
.58303 .69685 m .5829 .69514 L p .58149 .70235 L F P
0 g
s
.982 .814 .412 r
.60351 .58112 m .58497 .68991 L p .58209 .69348 L F P
0 g
s
.982 .814 .412 r
.58497 .68991 m .5835 .69854 L .58303 .69685 L p F P
0 g
s
.785 .743 .221 r
.5833 .70024 m .5829 .70362 L p .58179 .7067 L F P
0 g
s
.785 .743 .221 r
.5829 .70362 m .5827 .70532 L p .57535 .73922 L F P
0 g
s
0 0 0 r
.58192 .70895 m .57535 .73922 L .5829 .70362 L F
.5829 .70362 m .58344 .70194 L p .58192 .70895 L F P
0 g
s
.925 .817 .356 r
.5617 .80415 m .58344 .70194 L .5833 .70024 L p F P
0 g
s
.925 .817 .356 r
.56532 .7855 m .5617 .80415 L .5833 .70024 L F
.785 .743 .221 r
.56171 .80218 m .58179 .7067 L p .58215 .70569 L F P
0 g
s
.785 .743 .221 r
.56171 .80218 m .58215 .70569 L .56675 .77873 L F
.58179 .7067 m .5835 .69854 L .5833 .70024 L p F P
0 g
s
1 .812 .509 r
.58119 .70342 m .5829 .69514 L .58209 .69348 L p F P
0 g
s
1 .812 .509 r
.58049 .69019 m .57969 .68852 L p .57321 .72785 L F P
0 g
s
.986 .779 .544 r
.58162 .69178 m .56049 .79829 L .55978 .79737 L p F P
0 g
s
.986 .779 .544 r
.5712 .73829 m .58162 .69178 L .55978 .79737 L F
.55836 .79553 m .55765 .79461 L p .56177 .77696 L F P
0 g
s
.961 .743 .564 r
.55926 .79641 m .57969 .68852 L .57825 .687 L p F P
0 g
s
.961 .743 .564 r
.56307 .76983 m .55926 .79641 L .57825 .687 L F
.57537 .68395 m .57393 .68242 L p .56876 .72259 L F P
0 g
s
.932 .709 .577 r
.55765 .79461 m .55657 .79379 L p .57555 .69274 L F P
0 g
s
.932 .709 .577 r
.56693 .73329 m .57555 .69274 L .55657 .79379 L F
.57711 .68539 m .57558 .69402 L p .57555 .69274 L F P
0 g
s
.932 .709 .577 r
.57558 .69402 m .55765 .79461 L p .57555 .69274 L F P
0 g
s
.932 .709 .577 r
.55441 .79215 m .55333 .79133 L p .5574 .77317 L F P
0 g
s
.903 .676 .585 r
.55566 .79291 m .57393 .68242 L .57191 .6811 L p F P
0 g
s
.903 .676 .585 r
.55855 .76588 m .55566 .79291 L .57191 .6811 L F
.56789 .67846 m .56586 .67713 L p .56227 .71796 L F P
0 g
s
.875 .647 .589 r
.55333 .79133 m .55192 .79064 L p .56868 .68686 L F P
0 g
s
.875 .647 .589 r
.56227 .71796 m .56868 .68686 L .55192 .79064 L F
.57016 .67966 m .56883 .68849 L p .56868 .68686 L F P
0 g
s
.875 .647 .589 r
.56883 .68849 m .55333 .79133 L p .56868 .68686 L F P
0 g
s
.964 .736 .545 r
.58637 .60551 m .57825 .687 L .57967 .67749 L F
.58572 .61015 m .57825 .687 L .58637 .60551 L F
.59082 .55763 m .57967 .67749 L .58372 .64105 L F
.935 .702 .56 r
.58734 .59857 m .59509 .56197 L .58616 .60696 L F
.964 .736 .545 r
.59082 .55763 m .58572 .61015 L .58637 .60551 L F
.58372 .64105 m .57967 .67749 L .58189 .66268 L F
.935 .703 .563 r
.61202 .44975 m .59509 .56197 L .59276 .55987 L p F P
0 g
s
.935 .703 .563 r
.5982 .51096 m .61202 .44975 L .59276 .55987 L F
.58811 .5557 m .58576 .55359 L p .59134 .53152 L F P
0 g
s
.905 .671 .573 r
.58811 .5557 m .59082 .55763 L p .59134 .53152 L F P
0 g
s
.877 .64 .576 r
.58269 .55183 m .58576 .55359 L p .57807 .59136 L F P
0 g
s
.849 .613 .581 r
.56607 .62878 m .56586 .67713 L .56984 .54526 L F
.823 .589 .585 r
.57234 .48997 m .57749 .46221 L .56984 .54526 L F
.849 .614 .583 r
.57645 .42541 m .56644 .54371 L .57658 .54834 L p F P
0 g
s
.877 .641 .579 r
.57922 .52367 m .58184 .51318 L .57658 .54834 L F
.849 .614 .583 r
.57658 .54834 m .57996 .54989 L p .57922 .52367 L F P
0 g
s
.849 .614 .583 r
.57645 .42541 m .57658 .54834 L .57922 .52367 L F
.877 .641 .579 r
.57658 .54834 m .5735 .54658 L p .57922 .52367 L F P
0 g
s
.823 .588 .583 r
.56984 .54526 m .5735 .54658 L p .56626 .58547 L F P
0 g
s
.823 .588 .583 r
.55029 .6713 m .56256 .54264 L .55489 .64658 L F
.797 .564 .585 r
.55091 .53943 m .54442 .67001 L .5473 .67074 L p F P
0 g
s
.797 .564 .585 r
.55091 .53943 m .5473 .67074 L .55196 .59002 L F
.772 .542 .587 r
.55888 .54132 m .55029 .6713 L .5473 .67074 L p F P
0 g
s
.772 .542 .587 r
.55176 .59337 m .55888 .54132 L .5473 .67074 L F
.54133 .66965 m .53832 .66909 L p .54239 .64381 L F P
0 g
s
.747 .521 .587 r
.54442 .67001 m .55091 .53943 L .54671 .53889 L p F P
0 g
s
.747 .521 .587 r
.54278 .63432 m .54442 .67001 L .54671 .53889 L F
.722 .501 .589 r
.52556 .53703 m .53009 .50275 L .53003 .51187 L F
.697 .48 .589 r
.52984 .5373 m .53415 .53727 L p .53003 .51187 L F P
0 g
s
.772 .543 .588 r
.54563 .4499 m .54672 .41788 L .55182 .41897 L p F P
0 g
s
.772 .543 .588 r
.54563 .4499 m .55182 .41897 L .55632 .43104 L F
.723 .511 .603 r
.53163 .39393 m .55077 .32495 L .54137 .41753 L F
.5316 .32363 m .54436 .32451 L p .53789 .32829 L F P
0 g
s
.723 .511 .603 r
.54436 .32451 m .55077 .32495 L p .53789 .32829 L F P
0 g
s
.702 .521 .64 r
.51784 .28095 m .51877 .3237 L .52911 .3159 L F
.51784 .28095 m .5316 .32363 L .5318 .31041 L F
.725 .54 .64 r
.52518 .32319 m .54659 .28187 L .54487 .3148 L F
.54436 .32451 m .5316 .32363 L p .54487 .3148 L F P
0 g
s
.725 .54 .64 r
.5316 .32363 m .52518 .32319 L p .54487 .3148 L F P
0 g
s
.698 .491 .603 r
.53779 .33611 m .53805 .32359 L .5316 .32363 L p F P
0 g
s
.698 .491 .603 r
.5316 .32363 m .52435 .32367 L p .52736 .32645 L F P
0 g
s
.698 .491 .603 r
.52736 .32645 m .53779 .33611 L .5316 .32363 L F
.747 .532 .602 r
.53805 .32359 m .53611 .41681 L .54137 .41753 L p F P
0 g
s
.747 .532 .602 r
.53805 .32359 m .54137 .41753 L .5435 .35114 L F
.723 .511 .603 r
.5435 .35114 m .54409 .33288 L .5478 .33563 L F
.698 .491 .603 r
.52138 .3254 m .53152 .33202 L .52435 .32367 L F
.53152 .33202 m .53154 .33032 L .52435 .32367 L F
.723 .511 .603 r
.53072 .41684 m .53163 .39393 L .5363 .40524 L F
.53092 .39649 m .53163 .39393 L .53072 .41684 L F
.698 .491 .603 r
.51913 .35038 m .51965 .38909 L .53611 .41681 L F
.673 .47 .603 r
.51222 .40084 m .51924 .35875 L .52002 .41689 L F
.50867 .39741 m .51913 .35038 L .5094 .4177 L F
.51913 .35038 m .51924 .35875 L .5094 .4177 L F
.698 .491 .603 r
.5137 .37907 m .51464 .41692 L .52002 .41689 L p F P
0 g
s
.698 .491 .603 r
.52002 .41689 m .53072 .41684 L p .51969 .39237 L F P
0 g
s
.698 .491 .603 r
.5137 .37907 m .52002 .41689 L .51969 .39237 L F
.673 .47 .603 r
.50024 .33771 m .51877 .3237 L .51882 .3269 L F
.698 .491 .603 r
.51877 .3237 m .51232 .32374 L p .51882 .3269 L F P
0 g
s
.698 .491 .603 r
.51882 .3269 m .53779 .33611 L .51877 .3237 L F
.673 .47 .603 r
.51877 .3237 m .52518 .32319 L p .51882 .3269 L F P
0 g
s
.673 .47 .603 r
.51913 .35038 m .52518 .32319 L .51924 .35875 L F
.698 .491 .603 r
.53072 .41684 m .53611 .41681 L p .5137 .37907 L F P
0 g
s
.723 .511 .603 r
.52537 .41649 m .5316 .32363 L .53092 .39649 L F
.698 .491 .603 r
.53152 .33202 m .53779 .33611 L .53154 .33032 L F
.673 .47 .603 r
.51913 .35038 m .51882 .3269 L .52518 .32319 L F
.50867 .39741 m .51882 .3269 L .51913 .35038 L F
.698 .491 .603 r
.51232 .32374 m .5137 .37907 L p .51965 .38909 L F P
0 g
s
.698 .491 .603 r
.51232 .32374 m .51965 .38909 L .51913 .35038 L F
.722 .501 .589 r
.52556 .53703 m .52537 .41649 L .53072 .41684 L p F P
0 g
s
.67 .458 .589 r
.52039 .45243 m .52537 .41649 L .52051 .4634 L F
.52537 .41649 m .52556 .53703 L .52128 .53734 L p F P
0 g
s
.67 .458 .589 r
.52051 .4634 m .52537 .41649 L .52128 .53734 L F
.642 .435 .587 r
.51945 .66861 m .51698 .53736 L .51279 .53794 L p F P
0 g
s
.643 .437 .589 r
.50061 .45461 m .51279 .53794 L .51207 .51256 L F
.67 .458 .589 r
.51279 .53794 m .50852 .53825 L p .51371 .50077 L F P
0 g
s
.612 .412 .586 r
.50852 .53825 m .51322 .66921 L .51024 .66979 L p F P
0 g
s
.612 .412 .586 r
.50681 .59216 m .50852 .53825 L .51024 .66979 L F
.642 .435 .587 r
.50447 .5391 m .50029 .53969 L p .50627 .57995 L F P
0 g
s
.58 .387 .585 r
.50431 .67095 m .50716 .67019 L p .50275 .64522 L F P
0 g
s
.58 .387 .585 r
.49185 .58345 m .50431 .67095 L .50275 .64522 L F
.612 .412 .586 r
.50431 .67095 m .50133 .67152 L p .50275 .64522 L F P
0 g
s
.543 .36 .583 r
.49101 .64885 m .49238 .54165 L .49334 .67428 L F
.49016 .63952 m .48875 .54301 L .49101 .64885 L F
.58 .389 .587 r
.48214 .45943 m .49642 .5408 L .49484 .51561 L F
.544 .362 .585 r
.4839 .42266 m .49238 .54165 L .48875 .54301 L p F P
0 g
s
.544 .362 .585 r
.48875 .54301 m .48156 .54571 L p .48254 .49402 L F P
0 g
s
.544 .362 .585 r
.48254 .49402 m .4839 .42266 L .48875 .54301 L F
.58 .387 .585 r
.48491 .54412 m .49581 .6732 L .49865 .67245 L p F P
0 g
s
.58 .387 .585 r
.48491 .54412 m .49865 .67245 L .49185 .58345 L F
.543 .36 .583 r
.49238 .54165 m .50133 .67152 L .49865 .67245 L p F P
0 g
s
.543 .36 .583 r
.49277 .59554 m .49238 .54165 L .49865 .67245 L F
.502 .33 .58 r
.49334 .67428 m .49581 .6732 L p .49101 .64885 L F P
0 g
s
.502 .33 .58 r
.47914 .58869 m .49334 .67428 L .49101 .64885 L F
.543 .36 .583 r
.49334 .67428 m .49067 .67521 L p .49101 .64885 L F P
0 g
s
.502 .33 .58 r
.48156 .54571 m .47492 .54885 L p .49016 .63952 L F P
0 g
s
.453 .295 .576 r
.48101 .65382 m .47795 .54706 L .48399 .67885 L F
.47992 .64464 m .47492 .54885 L .48101 .65382 L F
.503 .332 .582 r
.46592 .46663 m .47492 .54885 L .47131 .49391 L F
.46592 .46663 m .48156 .54571 L .4792 .52085 L F
.455 .298 .578 r
.46591 .42989 m .47795 .54706 L .47492 .54885 L p F P
0 g
s
.455 .298 .578 r
.47492 .54885 m .46893 .5524 L p .46592 .48944 L F P
0 g
s
.455 .298 .578 r
.46592 .528 m .46592 .48944 L .46893 .5524 L F
.397 .257 .571 r
.46893 .5524 m .4716 .55043 L p .46592 .528 L F P
0 g
s
.397 .257 .571 r
.46332 .51774 m .46893 .5524 L .46592 .528 L F
.327 .208 .561 r
.46364 .55632 m .45913 .56054 L p .45272 .47582 L F P
0 g
s
.238 .147 .545 r
.45317 .52681 m .45913 .56054 L .45563 .53669 L F
.44315 .48652 m .45913 .56054 L .45317 .52681 L F
.327 .208 .561 r
.45913 .56054 m .45687 .56266 L p .45563 .53669 L F P
0 g
s
.327 .208 .561 r
.45563 .53669 m .45272 .47582 L .45913 .56054 L F
.238 .147 .545 r
.45913 .56054 m .461 .55828 L p .45563 .53669 L F P
0 g
s
.327 .208 .561 r
.45687 .56266 m .45094 .46277 L .45272 .47582 L F
.397 .257 .571 r
.45272 .47582 m .46893 .5524 L .46332 .51774 L F
.44487 .44484 m .45413 .48621 L .45272 .47582 L F
.45413 .48621 m .46893 .5524 L .45272 .47582 L F
.455 .298 .578 r
.46893 .5524 m .46592 .55419 L p .46592 .528 L F P
0 g
s
.455 .298 .578 r
.46592 .48944 m .46591 .42989 L .47492 .54885 L F
.502 .33 .58 r
.4716 .55043 m .48597 .6775 L .48844 .67643 L p F P
0 g
s
.502 .33 .58 r
.4716 .55043 m .48844 .67643 L .47914 .58869 L F
.453 .295 .576 r
.47795 .54706 m .49067 .67521 L .48844 .67643 L p F P
0 g
s
.453 .295 .576 r
.4804 .6006 m .47795 .54706 L .48844 .67643 L F
.396 .254 .569 r
.48399 .67885 m .48597 .6775 L p .48101 .65382 L F P
0 g
s
.396 .254 .569 r
.46877 .59538 m .48399 .67885 L .48101 .65382 L F
.453 .295 .576 r
.48399 .67885 m .48176 .68007 L p .48101 .65382 L F P
0 g
s
.396 .254 .569 r
.46893 .5524 m .46364 .55632 L p .47992 .64464 L F P
0 g
s
.324 .205 .558 r
.47322 .65987 m .46592 .55419 L .4767 .68441 L F
.47194 .65087 m .46364 .55632 L .47322 .65987 L F
.396 .254 .569 r
.461 .55828 m .4781 .68286 L .48007 .68152 L p F P
0 g
s
.396 .254 .569 r
.461 .55828 m .48007 .68152 L .46877 .59538 L F
.324 .205 .558 r
.46592 .55419 m .48176 .68007 L .48007 .68152 L p F P
0 g
s
.324 .205 .558 r
.4703 .60706 m .46592 .55419 L .48007 .68152 L F
.235 .143 .542 r
.4767 .68441 m .4781 .68286 L p .47322 .65987 L F P
0 g
s
.235 .143 .542 r
.4612 .60319 m .4767 .68441 L .47322 .65987 L F
.324 .205 .558 r
.4767 .68441 m .47502 .68586 L p .47322 .65987 L F P
0 g
s
.235 .143 .542 r
.45913 .56054 m .45544 .56502 L p .47194 .65087 L F P
0 g
s
.119 .064 .515 r
.468 .66669 m .45687 .56266 L .4718 .69069 L F
.4666 .65789 m .45544 .56502 L .468 .66669 L F
.238 .147 .545 r
.44315 .48652 m .45544 .56502 L .44865 .51201 L F
.123 .069 .519 r
.43978 .45066 m .45687 .56266 L .4526 .5697 L p F P
0 g
s
0 0 .475 r
.44658 .53695 m .4526 .5697 L .44878 .54646 L F
.123 .069 .519 r
.4526 .5697 m .45118 .57204 L p .44878 .54646 L F P
0 g
s
.123 .069 .519 r
.44878 .54646 m .43978 .45066 L .4526 .5697 L F
0 0 .475 r
.4526 .5697 m .45359 .56726 L p .44878 .54646 L F P
0 g
s
.235 .143 .542 r
.45359 .56726 m .47255 .68902 L .47394 .68748 L p F P
0 g
s
.235 .143 .542 r
.45359 .56726 m .47394 .68748 L .4612 .60319 L F
.119 .064 .515 r
.45687 .56266 m .47502 .68586 L .47394 .68748 L p F P
0 g
s
.119 .064 .515 r
.46293 .61461 m .45687 .56266 L .47394 .68748 L F
0 0 .47 r
.45677 .61172 m .4718 .69069 L .468 .66669 L F
.119 .064 .515 r
.4718 .69069 m .47073 .69229 L p .468 .66669 L F P
0 g
s
0 0 .47 r
.4718 .69069 m .47255 .68902 L p .468 .66669 L F P
0 g
s
0 0 .47 r
.44967 .57693 m .47032 .694 L .45677 .61172 L F
0 0 .396 r
.45677 .61172 m .45118 .57204 L .45861 .62286 L F
.119 .064 .515 r
.47073 .69229 m .4666 .65789 L .468 .66669 L F
0 0 .47 r
.468 .66669 m .47255 .68902 L .4666 .65789 L F
.324 .205 .558 r
.47502 .68586 m .47194 .65087 L .47322 .65987 L F
.235 .143 .542 r
.47322 .65987 m .4781 .68286 L .47194 .65087 L F
.453 .295 .576 r
.48176 .68007 m .47992 .64464 L .48101 .65382 L F
.396 .254 .569 r
.48101 .65382 m .48597 .6775 L .47992 .64464 L F
.543 .36 .583 r
.49067 .67521 m .49016 .63952 L .49101 .64885 L F
.502 .33 .58 r
.49101 .64885 m .49581 .6732 L .49016 .63952 L F
.612 .412 .586 r
.50133 .67152 m .50218 .63578 L .50275 .64522 L F
.58 .387 .585 r
.50275 .64522 m .50716 .67019 L .50218 .63578 L F
.50218 .63578 m .50716 .67019 L .49642 .5408 L F
.612 .412 .586 r
.50133 .67152 m .49238 .54165 L .49642 .5408 L p F P
0 g
s
.612 .412 .586 r
.50133 .67152 m .49642 .5408 L .50218 .63578 L F
.67 .458 .589 r
.50852 .53825 m .51182 .50346 L .51207 .51256 L F
.643 .437 .589 r
.51279 .53794 m .51698 .53736 L p .51207 .51256 L F P
0 g
s
.613 .414 .588 r
.50406 .41811 m .50852 .53825 L .50447 .5391 L p F P
0 g
s
.613 .414 .588 r
.50111 .46552 m .50406 .41811 L .50447 .5391 L F
.49597 .50366 m .50406 .41811 L .49642 .5408 L F
.49462 .51201 m .49999 .44088 L .49484 .51561 L F
.49999 .44088 m .49456 .43137 L .49925 .42483 L F
.48895 .42152 m .499 .41925 L p .49456 .43137 L F P
0 g
s
.613 .414 .588 r
.499 .41925 m .50406 .41811 L p .49456 .43137 L F P
0 g
s
.646 .449 .602 r
.49513 .35317 m .499 .41925 L .5079 .39491 L F
.50604 .32472 m .49358 .32668 L p .49407 .33501 L F P
0 g
s
.655 .484 .641 r
.49358 .32668 m .50604 .32472 L p .49944 .32094 L F P
0 g
s
.617 .427 .602 r
.49965 .32524 m .50406 .41811 L .499 .41925 L p F P
0 g
s
.586 .404 .601 r
.48651 .39906 m .48895 .42152 L .48733 .40144 L F
.617 .427 .602 r
.499 .41925 m .4839 .42266 L p .49513 .35317 L F P
0 g
s
.617 .427 .602 r
.49513 .35317 m .49965 .32524 L .499 .41925 L F
.48694 .39651 m .49407 .33501 L .48733 .40144 L F
.49407 .33501 m .48785 .33229 L .49371 .32879 L F
.48155 .32953 m .49358 .32668 L p .48785 .33229 L F P
0 g
s
.617 .427 .602 r
.49358 .32668 m .49965 .32524 L p .48785 .33229 L F P
0 g
s
.679 .503 .64 r
.50527 .31155 m .52498 .26356 L .50604 .32472 L F
.655 .484 .641 r
.48954 .28436 m .49358 .32668 L .50663 .3139 L F
.63 .465 .641 r
.47985 .31658 m .48802 .26844 L .48954 .28436 L F
.47927 .3122 m .48802 .26844 L .47985 .31658 L F
.47927 .3122 m .47413 .27319 L .48802 .26844 L F
.655 .484 .641 r
.48199 .2713 m .50527 .31155 L .50256 .26541 L F
.50256 .26541 m .48796 .26777 L p .48813 .26954 L F P
0 g
s
.63 .465 .641 r
.49506 .26603 m .49965 .32524 L .49358 .32668 L p F P
0 g
s
.602 .446 .642 r
.4632 .29191 m .4701 .33325 L .47822 .3227 L F
.4632 .29191 m .48155 .32953 L .47985 .31658 L F
.63 .465 .641 r
.49358 .32668 m .47551 .33097 L p .48954 .28436 L F P
0 g
s
.63 .465 .641 r
.48954 .28436 m .49506 .26603 L .49358 .32668 L F
.47388 .27122 m .48796 .26777 L p .48101 .27038 L F P
0 g
s
.63 .465 .641 r
.4672 .27556 m .47388 .27122 L .48101 .27038 L F
.48796 .26777 m .49506 .26603 L p .4672 .27556 L F P
0 g
s
.655 .484 .641 r
.48063 .26895 m .49358 .32668 L .48954 .28436 L F
.646 .449 .602 r
.48732 .32766 m .499 .41925 L .49513 .35317 L F
.643 .437 .589 r
.49377 .42003 m .50029 .53969 L .50447 .5391 L p F P
0 g
s
.643 .437 .589 r
.49377 .42003 m .50447 .5391 L .50061 .45461 L F
.58 .387 .585 r
.50716 .67019 m .50029 .53969 L .49642 .5408 L p F P
0 g
s
.613 .414 .588 r
.49642 .5408 m .49238 .54165 L p .49597 .50366 L F P
0 g
s
.543 .36 .583 r
.48875 .54301 m .49238 .54165 L p .49185 .58345 L F P
0 g
s
.58 .387 .585 r
.48875 .54301 m .48491 .54412 L p .49185 .58345 L F P
0 g
s
.502 .33 .58 r
.49581 .6732 m .48491 .54412 L .48156 .54571 L p F P
0 g
s
.502 .33 .58 r
.49016 .63952 m .49581 .6732 L .48156 .54571 L F
.543 .36 .583 r
.49067 .67521 m .47795 .54706 L .48156 .54571 L p F P
0 g
s
.543 .36 .583 r
.49067 .67521 m .48156 .54571 L .49016 .63952 L F
.613 .414 .588 r
.49238 .54165 m .49462 .51201 L .49484 .51561 L F
.58 .389 .587 r
.49642 .5408 m .50029 .53969 L p .49484 .51561 L F P
0 g
s
.453 .295 .576 r
.47492 .54885 m .47795 .54706 L p .47914 .58869 L F P
0 g
s
.502 .33 .58 r
.47492 .54885 m .4716 .55043 L p .47914 .58869 L F P
0 g
s
.396 .254 .569 r
.48597 .6775 m .4716 .55043 L .46893 .5524 L p F P
0 g
s
.396 .254 .569 r
.47992 .64464 m .48597 .6775 L .46893 .5524 L F
.453 .295 .576 r
.48176 .68007 m .46893 .5524 L .47992 .64464 L F
.324 .205 .558 r
.46364 .55632 m .46592 .55419 L p .46877 .59538 L F P
0 g
s
.396 .254 .569 r
.46364 .55632 m .461 .55828 L p .46877 .59538 L F P
0 g
s
.235 .143 .542 r
.4781 .68286 m .461 .55828 L .45913 .56054 L p F P
0 g
s
.235 .143 .542 r
.47194 .65087 m .4781 .68286 L .45913 .56054 L F
.324 .205 .558 r
.47502 .68586 m .45913 .56054 L .47194 .65087 L F
.119 .064 .515 r
.45544 .56502 m .45687 .56266 L p .4612 .60319 L F P
0 g
s
.235 .143 .542 r
.45544 .56502 m .45359 .56726 L p .4612 .60319 L F P
0 g
s
0 0 .47 r
.47255 .68902 m .45359 .56726 L .4526 .5697 L p F P
0 g
s
0 0 .47 r
.4666 .65789 m .47255 .68902 L .4526 .5697 L F
.119 .064 .515 r
.47073 .69229 m .4526 .5697 L .4666 .65789 L F
0 0 .396 r
.45118 .57204 m .47073 .69229 L .47032 .694 L p F P
0 g
s
0 0 .396 r
.45861 .62286 m .45118 .57204 L .47032 .694 L F
0 0 .47 r
.45065 .57452 m .44967 .57693 L p .45677 .61172 L F P
0 g
s
0 0 .284 r
.4695 .69737 m .46958 .69566 L p .46555 .67394 L F P
0 g
s
0 0 .396 r
.4695 .69737 m .46909 .69906 L p .46555 .67394 L F P
0 g
s
0 0 .284 r
.44938 .58682 m .46927 .70247 L .46935 .70076 L p F P
0 g
s
0 0 .134 r
.46081 .65099 m .46019 .64735 L .45506 .61714 L F
.46081 .65099 m .45506 .61714 L .45564 .62056 L F
.45021 .58925 m .44946 .58435 L p .46019 .64735 L F P
0 g
s
0 0 .134 r
.44946 .58435 m .44907 .58188 L p .46019 .64735 L F P
0 g
s
0 0 .134 r
.46596 .68129 m .45021 .58925 L .46081 .65099 L F
0 0 .284 r
.44938 .58682 m .46935 .70076 L .45564 .62056 L F
0 0 .134 r
.44907 .58188 m .46909 .69906 L .46935 .70076 L p F P
0 g
s
0 0 .134 r
.4575 .63141 m .44907 .58188 L .46935 .70076 L F
0 0 .396 r
.46909 .69906 m .4641 .66536 L .46555 .67394 L F
0 0 .284 r
.46555 .67394 m .46958 .69566 L .4641 .66536 L F
.4641 .66536 m .46958 .69566 L .4496 .57942 L F
0 0 .396 r
.46909 .69906 m .44907 .58188 L .4496 .57942 L p F P
0 g
s
0 0 .396 r
.46909 .69906 m .4496 .57942 L .4641 .66536 L F
0 0 .284 r
.46958 .69566 m .44967 .57693 L .4496 .57942 L p F P
0 g
s
0 0 .292 r
.43631 .51022 m .4496 .57942 L .44565 .55683 L F
0 0 .403 r
.4496 .57942 m .44907 .58188 L p .44407 .54533 L F P
0 g
s
0 0 .144 r
.43034 .47613 m .44907 .58188 L .45021 .58925 L p F P
0 g
s
0 0 .144 r
.44631 .56729 m .43034 .47613 L .45021 .58925 L F
0 0 .284 r
.44946 .58435 m .44938 .58682 L p .45564 .62056 L F P
0 g
s
0 0 .134 r
.45564 .62056 m .45506 .61714 L .44907 .58188 L F
0 0 .403 r
.44907 .58188 m .44508 .5536 L .44565 .55683 L F
0 0 .292 r
.4496 .57942 m .44967 .57693 L p .44565 .55683 L F P
0 g
s
0 0 .292 r
.43079 .48266 m .44938 .58682 L .44946 .58435 L p F P
0 g
s
0 0 .292 r
.43079 .48266 m .44946 .58435 L .43631 .51022 L F
.43079 .48266 m .43631 .51022 L .43199 .48585 L F
0 0 .234 r
.42735 .46664 m .41784 .42398 L .43085 .4794 L F
0 0 .292 r
.44967 .57693 m .43102 .46959 L .43096 .47289 L p F P
0 g
s
0 0 .292 r
.44565 .55683 m .44967 .57693 L .43096 .47289 L F
0 0 .403 r
.44907 .58188 m .43096 .47289 L .44508 .5536 L F
.43762 .49818 m .43551 .48583 L .4362 .48777 L F
0 0 .475 r
.43102 .46959 m .44967 .57693 L .45065 .57452 L p F P
0 g
s
0 0 .475 r
.43102 .46959 m .45065 .57452 L .4393 .50801 L F
.119 .064 .515 r
.47073 .69229 m .45118 .57204 L .4526 .5697 L p F P
0 g
s
.324 .205 .558 r
.47502 .68586 m .45687 .56266 L .45913 .56054 L p F P
0 g
s
.327 .208 .561 r
.45097 .43939 m .46592 .55419 L .46364 .55632 L p F P
0 g
s
.327 .208 .561 r
.45272 .47582 m .45097 .43939 L .46364 .55632 L F
.44815 .44223 m .45097 .43939 L p .44887 .44752 L F P
0 g
s
.397 .257 .571 r
.44487 .44484 m .45038 .46661 L .45094 .46277 L F
.44487 .44484 m .45094 .46277 L .44887 .44752 L F
.347 .238 .585 r
.43901 .42918 m .43725 .3803 L .44258 .44785 L F
.265 .183 .573 r
.44487 .44484 m .43112 .37032 L p .42793 .37117 L F P
0 g
s
.265 .183 .573 r
.4215 .37286 m .43789 .42335 L .42793 .37117 L F
.43789 .42335 m .44487 .44484 L .42793 .37117 L F
.43826 .42718 m .43815 .43995 L .44258 .44785 L F
.43826 .42718 m .44258 .44785 L .43901 .42918 L F
.347 .238 .585 r
.44258 .44785 m .43978 .45066 L p .43901 .42918 L F P
0 g
s
.413 .282 .592 r
.429 .3588 m .44815 .44223 L .45082 .41565 L F
.347 .238 .585 r
.43623 .35197 m .45097 .43939 L .44815 .44223 L p F P
0 g
s
.347 .238 .585 r
.43725 .3803 m .43623 .35197 L .44815 .44223 L F
.413 .282 .592 r
.429 .3588 m .43236 .36756 L .43426 .36331 L F
.429 .3588 m .43426 .36331 L .43324 .3575 L F
.405 .32 .646 r
.421 .29825 m .43623 .35197 L .43289 .35553 L p F P
0 g
s
.347 .238 .585 r
.43289 .35553 m .43623 .35197 L p .43725 .3803 L F P
0 g
s
.413 .282 .592 r
.43236 .36756 m .43725 .3803 L .43426 .36331 L F
.265 .183 .573 r
.4258 .39393 m .44487 .44484 L .4215 .37286 L F
.16 .114 .553 r
.41685 .37776 m .42092 .37001 L p .42931 .43562 L F P
0 g
s
.265 .183 .573 r
.42092 .37001 m .41824 .37373 L p .43112 .37032 L F P
0 g
s
.16 .114 .553 r
.42298 .36608 m .43978 .45066 L .43803 .4538 L p F P
0 g
s
.16 .114 .553 r
.4258 .39393 m .42298 .36608 L .43803 .4538 L F
.265 .183 .573 r
.41824 .37373 m .43803 .4538 L .4258 .39393 L F
0 0 .475 r
.45359 .56726 m .43575 .45678 L .43456 .46001 L p F P
0 g
s
0 0 .475 r
.44878 .54646 m .45359 .56726 L .43456 .46001 L F
.123 .069 .519 r
.45118 .57204 m .43456 .46001 L .44878 .54646 L F
.238 .147 .545 r
.43575 .45678 m .45359 .56726 L .45544 .56502 L p F P
0 g
s
.238 .147 .545 r
.43575 .45678 m .45544 .56502 L .44315 .48652 L F
.43803 .4538 m .43575 .45678 L p .44315 .48652 L F P
0 g
s
.123 .069 .519 r
.44215 .47588 m .44116 .47381 L .43978 .45066 L F
.44116 .47381 m .43884 .45895 L .43978 .45066 L F
.238 .147 .545 r
.461 .55828 m .44487 .44484 L .44258 .44785 L p F P
0 g
s
.238 .147 .545 r
.45563 .53669 m .461 .55828 L .44258 .44785 L F
.327 .208 .561 r
.45687 .56266 m .44258 .44785 L .45513 .53328 L F
.397 .257 .571 r
.45038 .46661 m .45272 .47582 L .45094 .46277 L F
.327 .208 .561 r
.45272 .47582 m .45094 .46277 L .4522 .46501 L F
.4522 .46501 m .45094 .46277 L .45097 .43939 L F
.45094 .46277 m .44887 .44752 L .45097 .43939 L F
.397 .257 .571 r
.44487 .44484 m .461 .55828 L .46364 .55632 L p F P
0 g
s
.397 .257 .571 r
.44487 .44484 m .46364 .55632 L .45413 .48621 L F
.453 .295 .576 r
.48176 .68007 m .46592 .55419 L .46893 .5524 L p F P
0 g
s
.544 .362 .585 r
.4792 .52085 m .4839 .42266 L .48156 .54571 L F
.503 .332 .582 r
.48156 .54571 m .48491 .54412 L p .4792 .52085 L F P
0 g
s
.544 .362 .585 r
.48156 .54571 m .47795 .54706 L p .4792 .52085 L F P
0 g
s
.503 .332 .582 r
.45801 .43438 m .4716 .55043 L .47492 .54885 L p F P
0 g
s
.503 .332 .582 r
.45801 .43438 m .47492 .54885 L .46592 .46663 L F
.46215 .43228 m .45801 .43438 L p .46294 .43948 L F P
0 g
s
.503 .332 .582 r
.45801 .43438 m .46592 .46663 L .46294 .43948 L F
.455 .298 .578 r
.46592 .46663 m .46445 .45329 L .46591 .45573 L F
.46592 .55419 m .4547 .43702 L .46592 .528 L F
.397 .257 .571 r
.46592 .528 m .4716 .55043 L .4547 .43702 L F
.4716 .55043 m .45801 .43438 L .4547 .43702 L p F P
0 g
s
.467 .319 .596 r
.4547 .43702 m .45458 .41974 L .45671 .42327 L F
.512 .351 .599 r
.45314 .36857 m .46215 .43228 L .46716 .4061 L F
.467 .319 .596 r
.45458 .41974 m .45428 .37658 L .46215 .43228 L F
.512 .351 .599 r
.45939 .33778 m .44954 .34305 L p .46038 .3459 L F P
0 g
s
.467 .319 .596 r
.45164 .41777 m .45314 .36857 L .4547 .43702 L F
.512 .351 .599 r
.44992 .34576 m .46038 .3459 L .44954 .34305 L F
.501 .379 .645 r
.43721 .33981 m .44016 .30314 L .44954 .34305 L F
.539 .403 .644 r
.44114 .33197 m .4446 .34569 L .44954 .34305 L p F P
0 g
s
.539 .403 .644 r
.44954 .34305 m .45939 .33778 L p .4474 .33396 L F P
0 g
s
.539 .403 .644 r
.44114 .33197 m .44954 .34305 L .4474 .33396 L F
.572 .425 .643 r
.46681 .27295 m .47551 .33097 L .45939 .33778 L p F P
0 g
s
.501 .379 .645 r
.42616 .29467 m .43648 .28752 L p .43152 .29192 L F P
0 g
s
.501 .379 .645 r
.42168 .30066 m .42616 .29467 L .43152 .29192 L F
.574 .545 .784 r
.405 .28726 m .42616 .29467 L .42268 .28962 L F
.532 .533 .801 r
.38977 .30669 m .40948 .31097 L .40545 .30652 L F
.481 .523 .823 r
.38131 .32769 m .39863 .32918 L .39428 .3254 L F
.38305 .32904 m .39863 .32918 L .38131 .32769 L F
.507 .527 .812 r
.39512 .32891 m .38977 .30669 L .40329 .31989 L F
.39428 .3254 m .38456 .3016 L .38977 .30669 L F
.39275 .32407 m .38456 .3016 L .39428 .3254 L F
.833 .899 .886 r
.37929 .30876 m .37836 .31272 L .38105 .30678 L F
.822 .919 .902 r
.37929 .31239 m .37667 .31777 L p .37836 .31272 L F P
0 g
s
.507 .527 .812 r
.37709 .31811 m .37667 .31777 L .37929 .31239 L p F P
0 g
s
.833 .899 .886 r
.37836 .31272 m .37734 .31703 L .37898 .3125 L F
.37836 .31272 m .37898 .3125 L .38105 .30678 L F
.822 .919 .902 r
.37667 .31777 m .37611 .31675 L .37836 .31272 L F
.833 .899 .886 r
.37929 .31239 m .38105 .30678 L p .37898 .3125 L F P
0 g
s
.452 .519 .836 r
.37667 .31777 m .37709 .31811 L p .377 .31848 L F P
0 g
s
.833 .899 .886 r
.37488 .32384 m .37929 .31239 L .37898 .3125 L F
.532 .533 .801 r
.38105 .30678 m .38162 .30686 L .38167 .30677 L F
.481 .523 .823 r
.38146 .30715 m .38105 .30678 L .37929 .31239 L p F P
0 g
s
.822 .919 .902 r
.37929 .31239 m .37836 .31272 L .38146 .30715 L F
.38456 .3016 m .37929 .31239 L p .38146 .30715 L F P
0 g
s
.481 .523 .823 r
.4002 .32435 m .38146 .30715 L p .37929 .31239 L F P
0 g
s
.532 .533 .801 r
.38105 .30678 m .4002 .32435 L .40329 .31989 L p F P
0 g
s
.532 .533 .801 r
.38105 .30678 m .40329 .31989 L .39143 .30831 L F
.822 .919 .902 r
.37611 .31675 m .37461 .31403 L .37836 .31272 L F
.37667 .31777 m .35773 .32497 L p .35862 .31962 L F P
0 g
s
.822 .919 .902 r
.35773 .32497 m .35569 .32574 L .35862 .31962 L p F P
0 g
s
.93 .949 .78 r
.35465 .32671 m .35569 .32574 L .35481 .33218 L p F P
0 g
s
.93 .949 .78 r
.35481 .33218 m .35308 .34486 L p .35465 .32671 L F P
0 g
s
.91 .979 .779 r
.35862 .31962 m .36056 .31325 L p .35938 .31511 L F P
0 g
s
.822 .919 .902 r
.37667 .31777 m .35862 .31962 L .37297 .3146 L F
.833 .899 .886 r
.36254 .31262 m .36056 .31325 L .35862 .31962 L p F P
0 g
s
.91 .979 .779 r
.35365 .32417 m .35862 .31962 L .35938 .31511 L F
.532 .533 .801 r
.39143 .30831 m .40948 .31097 L .38977 .30669 L F
.38466 .30169 m .40545 .30652 L .39187 .29152 L F
.38105 .30678 m .38977 .30669 L .38466 .30169 L F
.38977 .30669 m .40545 .30652 L .38466 .30169 L F
.39159 .29121 m .38105 .30678 L p .39187 .29152 L F P
0 g
s
.554 .539 .792 r
.39159 .29121 m .40032 .28136 L p .39187 .29152 L F P
0 g
s
.574 .545 .784 r
.405 .28726 m .42268 .28962 L .40032 .28136 L F
.594 .552 .778 r
.43648 .28752 m .42616 .29467 L p .42448 .29223 L F P
0 g
s
.574 .545 .784 r
.40642 .28905 m .42616 .29467 L .405 .28726 L F
.594 .552 .778 r
.42198 .29322 m .42642 .27044 L .43648 .28752 L F
.574 .545 .784 r
.42268 .28962 m .43073 .29069 L .42146 .28785 L F
.42268 .28962 m .42146 .28785 L .40032 .28136 L F
.594 .552 .778 r
.421 .29825 m .42198 .29322 L .42448 .29223 L F
.42616 .29467 m .421 .29825 L p .42448 .29223 L F P
0 g
s
.554 .539 .792 r
.40032 .28136 m .40475 .27637 L p .40041 .28148 L F P
0 g
s
.554 .539 .792 r
.39187 .29152 m .40032 .28136 L .40041 .28148 L F
.40565 .31519 m .40123 .28675 L .40209 .28687 L F
.40123 .28675 m .40041 .28148 L .40209 .28687 L F
.40209 .28687 m .40041 .28148 L .4016 .28297 L F
.40565 .31519 m .40128 .28046 L .40477 .27715 L F
.778 .949 .931 r
.40032 .28136 m .39159 .29121 L p .39951 .28149 L F P
0 g
s
.574 .545 .784 r
.39585 .28603 m .405 .28726 L .40032 .28136 L F
.532 .533 .801 r
.39187 .29152 m .39552 .28638 L .39159 .29121 L F
.554 .539 .792 r
.38762 .29653 m .39159 .29121 L .39187 .29152 L F
.507 .527 .812 r
.38977 .30669 m .38723 .29612 L .40329 .31989 L F
.38723 .29612 m .40565 .31519 L .40329 .31989 L p F P
0 g
s
.554 .539 .792 r
.38762 .29653 m .38723 .29612 L .39159 .29121 L p F P
0 g
s
.507 .527 .812 r
.38456 .3016 m .38723 .29612 L p .38741 .29688 L F P
0 g
s
.804 .936 .917 r
.36056 .31325 m .38456 .3016 L .39027 .29214 L F
.36056 .31325 m .39159 .29121 L .38724 .29218 L F
.866 .995 .765 r
.35783 .32104 m .34914 .32073 L .36375 .308 L F
.35569 .32574 m .35535 .32547 L .35783 .32104 L F
.35535 .32547 m .34914 .32073 L .35783 .32104 L F
.833 .899 .886 r
.38105 .30678 m .36254 .31262 L p .35862 .31962 L F P
0 g
s
.833 .899 .886 r
.35862 .31962 m .35481 .33218 L p .37297 .3146 L F P
0 g
s
.833 .899 .886 r
.37297 .3146 m .38105 .30678 L .35862 .31962 L F
.822 .919 .902 r
.37667 .31777 m .37297 .3146 L .37461 .31403 L F
.833 .899 .886 r
.36062 .32977 m .38105 .30678 L .35481 .33218 L F
.822 .919 .902 r
.37461 .31403 m .3645 .30735 L .37004 .30576 L F
.37297 .3146 m .3645 .30735 L .37461 .31403 L F
.866 .995 .765 r
.3645 .30735 m .35862 .31962 L p .36375 .308 L F P
0 g
s
.866 .995 .765 r
.35862 .31962 m .35569 .32574 L p .35837 .31986 L F P
0 g
s
.866 .995 .765 r
.35837 .31986 m .36375 .308 L .35862 .31962 L F
.91 .979 .779 r
.33877 .34769 m .35862 .31962 L .35365 .32417 L F
.35481 .33218 m .35862 .31962 L p .33877 .34769 L F P
0 g
s
.833 .899 .886 r
.36062 .32977 m .37734 .31703 L .37836 .31272 L F
.37461 .31403 m .37836 .31272 L .37929 .30876 L F
.36062 .32977 m .37836 .31272 L .37461 .31403 L F
.822 .919 .902 r
.35862 .31962 m .3645 .30735 L p .37297 .3146 L F P
0 g
s
.822 .919 .902 r
.37836 .31272 m .37004 .30576 L .38456 .3016 L F
.37461 .31403 m .37004 .30576 L .37836 .31272 L F
.532 .533 .801 r
.38167 .30677 m .39143 .30831 L .38977 .30669 L F
.38162 .30686 m .39143 .30831 L .38167 .30677 L F
.554 .539 .792 r
.40554 .31014 m .405 .28726 L .41712 .30252 L F
.574 .545 .784 r
.39585 .28603 m .40642 .28905 L .405 .28726 L F
.4153 .30023 m .41712 .30252 L .42076 .29743 L F
.554 .539 .792 r
.405 .28726 m .40475 .27637 L .41712 .30252 L F
.501 .379 .645 r
.43635 .33282 m .42665 .2965 L .43663 .28815 L F
.43623 .35197 m .43663 .28815 L .44016 .30314 L F
.539 .403 .644 r
.44797 .28116 m .43648 .28752 L p .43687 .28918 L F P
0 g
s
.501 .379 .645 r
.43648 .28752 m .4417 .2839 L p .43663 .28815 L F P
0 g
s
.501 .379 .645 r
.42168 .30066 m .43648 .28752 L .43663 .28815 L F
.539 .403 .644 r
.43073 .29069 m .44114 .33197 L p .44712 .33278 L F P
0 g
s
.539 .403 .644 r
.441 .30672 m .44712 .33278 L .4587 .33435 L F
.43073 .29069 m .44712 .33278 L .441 .30672 L F
.43073 .29069 m .4587 .33435 L .45685 .32519 L F
.572 .425 .643 r
.45685 .32519 m .46681 .27295 L .45939 .33778 L F
.539 .403 .644 r
.45939 .33778 m .46436 .33512 L p .44114 .33197 L F P
0 g
s
.572 .425 .643 r
.45939 .33778 m .45402 .34005 L p .45685 .32519 L F P
0 g
s
.539 .403 .644 r
.45685 .32519 m .4587 .33435 L .46436 .33512 L F
.43216 .29259 m .45685 .32519 L .44797 .28116 L F
.501 .379 .645 r
.44016 .30314 m .4417 .2839 L .44954 .34305 L F
.552 .379 .6 r
.45561 .3521 m .45402 .34005 L .45939 .33778 L p F P
0 g
s
.552 .379 .6 r
.45939 .33778 m .4701 .33325 L p .4652 .33963 L F P
0 g
s
.552 .379 .6 r
.45561 .3521 m .45939 .33778 L .4652 .33963 L F
.467 .319 .596 r
.45314 .36857 m .45402 .34005 L .45428 .37658 L F
.45314 .36857 m .45428 .37658 L .4547 .43702 L F
.512 .351 .599 r
.44954 .34305 m .4446 .34569 L p .44992 .34576 L F P
0 g
s
.512 .351 .599 r
.4446 .34569 m .46215 .43228 L .45314 .36857 L F
.467 .319 .596 r
.45428 .37658 m .45402 .34005 L .46215 .43228 L F
.45402 .34005 m .46591 .42989 L .46215 .43228 L p F P
0 g
s
.413 .282 .592 r
.45082 .41565 m .44954 .4284 L .4547 .43702 L F
.45082 .41565 m .4547 .43702 L .45164 .41777 L F
.467 .319 .596 r
.4547 .43702 m .45097 .43939 L p .45164 .41777 L F P
0 g
s
.413 .282 .592 r
.45164 .41777 m .45801 .43438 L .44067 .349 L F
.45801 .43438 m .4446 .34569 L .44067 .349 L p F P
0 g
s
.512 .351 .599 r
.4446 .34569 m .45314 .36857 L .44992 .34576 L F
.467 .319 .596 r
.44954 .34305 m .45402 .34005 L p .45314 .36857 L F P
0 g
s
.552 .379 .6 r
.4701 .33325 m .47551 .33097 L p .45561 .3521 L F P
0 g
s
.586 .404 .601 r
.46436 .33512 m .47938 .42448 L .47276 .35935 L F
.503 .332 .582 r
.48491 .54412 m .47458 .42596 L .47041 .42808 L p F P
0 g
s
.503 .332 .582 r
.4792 .52085 m .48491 .54412 L .47041 .42808 L F
.544 .362 .585 r
.47795 .54706 m .47041 .42808 L .4792 .52085 L F
.58 .389 .587 r
.47458 .42596 m .48491 .54412 L .48875 .54301 L p F P
0 g
s
.58 .389 .587 r
.47458 .42596 m .48875 .54301 L .48214 .45943 L F
.47938 .42448 m .47458 .42596 L p .48214 .45943 L F P
0 g
s
.544 .362 .585 r
.48267 .44852 m .48107 .44586 L .4839 .42266 L F
.48107 .44586 m .47981 .42999 L .4839 .42266 L F
.58 .389 .587 r
.50029 .53969 m .49377 .42003 L .48895 .42152 L p F P
0 g
s
.58 .389 .587 r
.49484 .51561 m .50029 .53969 L .48895 .42152 L F
.613 .414 .588 r
.49238 .54165 m .48895 .42152 L .49462 .51201 L F
.50061 .45461 m .49999 .44088 L .50164 .44378 L F
.643 .437 .589 r
.49377 .42003 m .49858 .44434 L .49999 .44088 L F
.499 .41925 m .49377 .42003 L p .49999 .44088 L F P
0 g
s
.643 .437 .589 r
.49858 .44434 m .50061 .45461 L .49999 .44088 L F
.613 .414 .588 r
.50164 .44378 m .49999 .44088 L .50406 .41811 L F
.49999 .44088 m .49925 .42483 L .50406 .41811 L F
.67 .458 .589 r
.50852 .53825 m .5094 .4177 L .51182 .50346 L F
.643 .437 .589 r
.51207 .51256 m .51698 .53736 L .5094 .4177 L F
.51698 .53736 m .51464 .41692 L .5094 .4177 L p F P
0 g
s
.722 .501 .589 r
.54137 .41753 m .54672 .41788 L p .54048 .45302 L F P
0 g
s
.747 .522 .589 r
.53611 .41681 m .53415 .53727 L .53835 .53782 L p F P
0 g
s
.747 .522 .589 r
.53611 .41681 m .53835 .53782 L .54021 .46397 L F
.54671 .53889 m .55091 .53943 L p .54779 .51357 L F P
0 g
s
.772 .543 .588 r
.54263 .53808 m .54563 .4499 L p .55079 .44323 L F P
0 g
s
.772 .543 .588 r
.54263 .53808 m .55079 .44323 L .54809 .50656 L F
.55984 .45634 m .56145 .42943 L .56702 .42221 L F
.797 .566 .587 r
.55707 .41969 m .55902 .44546 L .56066 .44267 L F
.55707 .41969 m .56066 .44267 L .56161 .42668 L F
.772 .553 .602 r
.57508 .3304 m .56702 .42221 L .56194 .42113 L p F P
0 g
s
.772 .553 .602 r
.55598 .40313 m .57508 .3304 L .56194 .42113 L F
.55182 .41897 m .54672 .41788 L p .55292 .39874 L F P
0 g
s
.747 .532 .602 r
.55292 .39874 m .55707 .41969 L .55332 .39158 L F
.698 .491 .603 r
.51232 .32374 m .51913 .35038 L .51882 .3269 L F
.673 .47 .603 r
.51924 .35875 m .52518 .32319 L .52002 .41689 L F
.52518 .32319 m .52537 .41649 L .52002 .41689 L p F P
0 g
s
.646 .449 .602 r
.5094 .4177 m .51464 .41692 L p .50919 .4118 L F P
0 g
s
.646 .449 .602 r
.50363 .40658 m .5094 .4177 L .50919 .4118 L F
.5079 .39491 m .50919 .4118 L .50867 .39741 L F
.673 .47 .603 r
.5094 .4177 m .50406 .41811 L p .50867 .39741 L F P
0 g
s
.673 .47 .603 r
.50406 .41811 m .50024 .33771 L p .50638 .33413 L F P
0 g
s
.673 .47 .603 r
.50406 .41811 m .50638 .33413 L .50867 .39741 L F
.646 .449 .602 r
.50867 .39741 m .50919 .4118 L .51464 .41692 L F
.67 .458 .589 r
.50852 .53825 m .50406 .41811 L .5094 .4177 L p F P
0 g
s
.646 .449 .602 r
.48732 .32766 m .49377 .42003 L .499 .41925 L p F P
0 g
s
.613 .414 .588 r
.49238 .54165 m .4839 .42266 L .48895 .42152 L p F P
0 g
s
.617 .427 .602 r
.4839 .42266 m .48694 .39651 L .48733 .40144 L F
.586 .404 .601 r
.48895 .42152 m .49377 .42003 L p .48733 .40144 L F P
0 g
s
.586 .404 .601 r
.46436 .33512 m .47458 .42596 L .47938 .42448 L p F P
0 g
s
.544 .362 .585 r
.47795 .54706 m .46591 .42989 L .47041 .42808 L p F P
0 g
s
.512 .351 .599 r
.47041 .42808 m .47458 .42596 L p .468 .40835 L F P
0 g
s
.552 .379 .6 r
.46591 .42989 m .46725 .40218 L .468 .40835 L F
.512 .351 .599 r
.4446 .34569 m .45801 .43438 L .46215 .43228 L p F P
0 g
s
.455 .298 .578 r
.46592 .55419 m .45097 .43939 L .4547 .43702 L p F P
0 g
s
.413 .282 .592 r
.4547 .43702 m .45801 .43438 L p .45164 .41777 L F P
0 g
s
.467 .319 .596 r
.45097 .43939 m .43623 .35197 L .44067 .349 L p F P
0 g
s
.467 .319 .596 r
.45097 .43939 m .44067 .349 L .45164 .41777 L F
.413 .282 .592 r
.429 .3588 m .44487 .44484 L .44815 .44223 L p F P
0 g
s
.327 .208 .561 r
.45687 .56266 m .43978 .45066 L .44258 .44785 L p F P
0 g
s
.265 .183 .573 r
.44258 .44785 m .44487 .44484 L p .43901 .42918 L F P
0 g
s
.347 .238 .585 r
.43978 .45066 m .42298 .36608 L .42628 .36256 L p F P
0 g
s
.347 .238 .585 r
.43978 .45066 m .42628 .36256 L .43901 .42918 L F
.265 .183 .573 r
.41824 .37373 m .43575 .45678 L .43803 .4538 L p F P
0 g
s
.123 .069 .519 r
.45118 .57204 m .43282 .46312 L .43456 .46001 L p F P
0 g
s
.024 .026 .519 r
.43456 .46001 m .43575 .45678 L p .43068 .44199 L F P
0 g
s
.16 .114 .553 r
.43282 .46312 m .42931 .43562 L .43068 .44199 L F
.024 .026 .519 r
.41274 .38971 m .43102 .46959 L .4322 .4664 L p F P
0 g
s
0 0 .403 r
.44907 .58188 m .43034 .47613 L .43096 .47289 L p F P
0 g
s
0 0 .368 r
.42644 .45375 m .42855 .46605 L .43096 .47289 L F
.43096 .47289 m .43102 .46959 L p .42696 .45554 L F P
0 g
s
0 0 .368 r
.42644 .45375 m .43096 .47289 L .42696 .45554 L F
0 0 .462 r
.43096 .47289 m .43034 .47613 L p .42696 .45554 L F P
0 g
s
0 0 .234 r
.41202 .39785 m .43034 .47613 L .43085 .4794 L p F P
0 g
s
0 0 .234 r
.41784 .42398 m .41202 .39785 L .43085 .4794 L F
0 0 .368 r
.41264 .40595 m .41476 .41329 L .41429 .40884 L F
.41264 .40595 m .41429 .40884 L .41307 .40366 L F
0 0 .234 r
.41266 .40191 m .41202 .39785 L p .41321 .40425 L F P
0 g
s
0 0 .234 r
.41784 .42398 m .41321 .40425 L .41202 .39785 L F
0 0 .368 r
.41264 .40595 m .43085 .4794 L .41784 .42398 L F
.41264 .40595 m .43079 .48266 L .43085 .4794 L p F P
0 g
s
0 0 .335 r
.49072 .80323 m .49098 .80445 L .49104 .80347 L p F P
0 g
s
0 0 .411 r
.49104 .80347 m .4909 .80248 L p .49135 .80369 L F P
0 g
s
0 0 .273 r
.51431 .8647 m .49144 .80564 L p .49164 .8062 L F P
0 g
s
0 0 .273 r
.49203 .80734 m .51106 .85632 L .49164 .8062 L F
.51106 .85632 m .51431 .8647 L .49164 .8062 L F
.49144 .80564 m .49098 .80445 L .49133 .80542 L p F P
0 g
s
0 0 .273 r
.49133 .80542 m .49203 .80734 L p .49144 .80564 L F P
0 g
s
0 0 .193 r
.49148 .8064 m .49122 .8052 L p .49123 .8052 L F P
0 g
s
.792 .414 0 r
.49203 .80734 m .49148 .8064 L p .49193 .80755 L F P
0 g
s
0 0 .411 r
.51447 .86533 m .49193 .80756 L p .49133 .80542 L F P
0 g
s
0 0 .411 r
.49193 .80756 m .49148 .8064 L .49133 .80542 L p F P
0 g
s
0 0 .273 r
.51466 .86564 m .51443 .86501 L p .50325 .83626 L F P
0 g
s
0 0 .273 r
.50325 .83626 m .51443 .86501 L .51207 .85893 L F
0 0 .411 r
.51447 .86533 m .49133 .80542 L .51207 .85893 L F
0 0 .273 r
.51443 .86501 m .51431 .8647 L p .51207 .85893 L F P
0 g
s
.697 .48 .589 r
.51869 .44189 m .52039 .45243 L .52025 .43863 L F
.67 .458 .589 r
.52002 .41689 m .52537 .41649 L p .52039 .45243 L F P
0 g
s
.747 .522 .589 r
.53611 .41681 m .54048 .45302 L .54118 .42497 L F
.722 .501 .589 r
.54672 .41788 m .54263 .53808 L .53835 .53782 L p F P
0 g
s
.722 .501 .589 r
.54021 .46397 m .54672 .41788 L .53835 .53782 L F
.52984 .5373 m .52556 .53703 L p .53003 .51187 L F P
0 g
s
.697 .48 .589 r
.53003 .51187 m .53415 .53727 L .53072 .41684 L F
.53415 .53727 m .53611 .41681 L .53072 .41684 L p F P
0 g
s
.723 .511 .603 r
.53072 .41684 m .52537 .41649 L p .53092 .39649 L F P
0 g
s
.698 .491 .603 r
.53611 .41681 m .53779 .33611 L p .53151 .33306 L F P
0 g
s
.698 .491 .603 r
.53092 .39649 m .53611 .41681 L .53151 .33306 L F
.823 .589 .585 r
.55888 .54132 m .56702 .42221 L .5716 .42398 L p F P
0 g
s
.796 .575 .601 r
.5716 .42398 m .57645 .42541 L p .57356 .40403 L F P
0 g
s
.821 .598 .601 r
.56702 .42221 m .574 .34273 L p .57965 .34186 L F P
0 g
s
.821 .598 .601 r
.56702 .42221 m .57965 .34186 L .57356 .40403 L F
.813 .621 .643 r
.58262 .31981 m .60887 .28293 L .58056 .33263 L F
.836 .645 .644 r
.59662 .27712 m .58635 .33443 L .59141 .33703 L p F P
0 g
s
.836 .645 .644 r
.59662 .27712 m .59141 .33703 L .59939 .29624 L F
.813 .621 .643 r
.59939 .29624 m .60219 .28197 L .60743 .28495 L F
.821 .598 .601 r
.58834 .36291 m .59685 .33924 L .58738 .37103 L F
.847 .623 .599 r
.59141 .33703 m .58635 .33443 L p .59104 .34013 L F P
0 g
s
.796 .575 .601 r
.56317 .32723 m .55707 .41969 L .56194 .42113 L p F P
0 g
s
.796 .575 .601 r
.56317 .32723 m .56194 .42113 L .56698 .35539 L F
.772 .553 .602 r
.56698 .35539 m .56836 .33732 L .57177 .3406 L F
.54672 .41788 m .55688 .32632 L .55292 .39874 L F
.747 .532 .602 r
.55707 .41969 m .56317 .32723 L .55688 .32632 L p F P
0 g
s
.747 .532 .602 r
.55332 .39158 m .55707 .41969 L .55688 .32632 L F
.796 .575 .601 r
.56317 .32723 m .56472 .33873 L .56836 .33732 L F
.569 .32904 m .56317 .32723 L p .56836 .33732 L F P
0 g
s
.772 .553 .602 r
.569 .32904 m .57508 .3304 L p .56884 .33114 L F P
0 g
s
.772 .553 .602 r
.57177 .3406 m .56836 .33732 L .57508 .3304 L F
.56836 .33732 m .56884 .33114 L .57508 .3304 L F
.796 .575 .601 r
.56472 .33873 m .56698 .35539 L .56836 .33732 L F
.747 .532 .602 r
.54436 .32451 m .53805 .32359 L p .5435 .35114 L F P
0 g
s
.723 .511 .603 r
.55077 .32495 m .54672 .41788 L .54137 .41753 L p F P
0 g
s
.772 .543 .588 r
.54671 .53889 m .54263 .53808 L p .54779 .51357 L F P
0 g
s
.747 .522 .589 r
.55091 .53943 m .55707 .41969 L .55182 .41897 L p F P
0 g
s
.747 .522 .589 r
.54779 .51357 m .55091 .53943 L .55182 .41897 L F
.772 .543 .588 r
.56702 .42221 m .55888 .54132 L .55481 .54051 L p F P
0 g
s
.823 .588 .583 r
.553 .6722 m .55029 .6713 L p .55489 .64658 L F P
0 g
s
.797 .564 .585 r
.55587 .67293 m .56644 .54371 L .56256 .54264 L p F P
0 g
s
.797 .564 .585 r
.55489 .64658 m .55587 .67293 L .56256 .54264 L F
.823 .588 .583 r
.5735 .54658 m .56108 .67488 L .55838 .67398 L p F P
0 g
s
.823 .588 .583 r
.56626 .58547 m .5735 .54658 L .55838 .67398 L F
.849 .613 .581 r
.56644 .54371 m .55587 .67293 L .55838 .67398 L p F P
0 g
s
.849 .613 .581 r
.56644 .54371 m .55838 .67398 L .56519 .59749 L F
.56336 .67608 m .56586 .67713 L p .56598 .65081 L F P
0 g
s
.849 .613 .581 r
.56802 .60552 m .56694 .64153 L .57658 .54834 L F
.877 .64 .576 r
.56108 .67488 m .5735 .54658 L .57658 .54834 L p F P
0 g
s
.877 .64 .576 r
.56108 .67488 m .57658 .54834 L .56598 .65081 L F
.56336 .67608 m .56108 .67488 L p .56598 .65081 L F P
0 g
s
.849 .613 .581 r
.56694 .64153 m .56586 .67713 L .57658 .54834 L F
.877 .64 .576 r
.58576 .55359 m .57016 .67966 L .56789 .67846 L p F P
0 g
s
.877 .64 .576 r
.57807 .59136 m .58576 .55359 L .56789 .67846 L F
.906 .67 .57 r
.57996 .54989 m .57669 .60318 L .57724 .59844 L F
.935 .702 .56 r
.57512 .65627 m .57925 .63675 L .57316 .67139 L F
.906 .67 .57 r
.57191 .6811 m .57393 .68242 L p .57512 .65627 L F P
0 g
s
.935 .702 .56 r
.57151 .68077 m .57016 .67966 L p .57512 .65627 L F P
0 g
s
.935 .702 .56 r
.57512 .65627 m .57316 .67139 L .57151 .68077 L F
.57191 .6811 m .57151 .68077 L p .57277 .67447 L F P
0 g
s
.906 .67 .57 r
.57393 .68242 m .59082 .55763 L .58811 .5557 L p F P
0 g
s
.906 .67 .57 r
.57512 .65627 m .57393 .68242 L .58811 .5557 L F
.988 .771 .52 r
.59364 .60674 m .59186 .61804 L .57825 .687 L F
.964 .736 .545 r
.57825 .687 m .57969 .68852 L p .58189 .66268 L F P
0 g
s
.988 .771 .52 r
.58189 .66268 m .59959 .56897 L .59364 .60674 L F
.57711 .68539 m .58322 .65376 L .58189 .66268 L F
.58322 .65376 m .59959 .56897 L .58189 .66268 L F
.57711 .68539 m .59509 .56197 L .5966 .56432 L p F P
0 g
s
.988 .771 .52 r
.5966 .56432 m .59959 .56897 L p .58322 .65376 L F P
0 g
s
.988 .771 .52 r
.57711 .68539 m .5966 .56432 L .58322 .65376 L F
.964 .736 .545 r
.58189 .66268 m .57969 .68852 L .58322 .65376 L F
1 .801 .479 r
.59959 .56897 m .59853 .56654 L p .59364 .60674 L F P
0 g
s
1 .801 .479 r
.59364 .60674 m .58857 .64847 L .59959 .56897 L F
.988 .772 .524 r
.60687 .51648 m .61226 .49137 L .59959 .56897 L F
.60026 .54072 m .61226 .49137 L .5966 .56432 L F
.999 .817 .526 r
.62854 .40749 m .62219 .43726 L .62009 .46541 L F
.61753 .45904 m .62009 .46541 L p .62219 .43726 L F P
0 g
s
.983 .783 .557 r
.61753 .45904 m .61387 .45287 L p .63012 .40009 L F P
0 g
s
.958 .746 .575 r
.61313 .40887 m .61387 .45287 L .61551 .44477 L F
.983 .783 .557 r
.61387 .45287 m .61202 .44975 L p .61759 .43447 L F P
0 g
s
.983 .783 .557 r
.61759 .43447 m .63012 .40009 L .61387 .45287 L F
.958 .746 .575 r
.61387 .45287 m .61624 .45582 L p .61551 .44477 L F P
0 g
s
.983 .783 .557 r
.61759 .43447 m .63357 .38395 L .63012 .40009 L F
.6185 .42996 m .63357 .38395 L .61759 .43447 L F
.63085 .36884 m .63515 .37655 L p .63357 .38395 L F P
0 g
s
.999 .817 .526 r
.63364 .37253 m .62009 .46541 L .62404 .44767 L F
.983 .783 .557 r
.6373 .38041 m .61937 .46213 L .61753 .45904 L p F P
0 g
s
.983 .783 .557 r
.63012 .40009 m .6373 .38041 L .61753 .45904 L F
.999 .817 .526 r
.62333 .4219 m .61624 .45582 L .61753 .45904 L p F P
0 g
s
.999 .817 .526 r
.62333 .4219 m .61753 .45904 L .62219 .43726 L F
1 .803 .484 r
.61624 .45582 m .59853 .56654 L .6017 .57377 L p F P
0 g
s
.983 .817 .418 r
.6056 .5508 m .61606 .50326 L .6017 .57377 L F
.911 .794 .315 r
.61606 .50326 m .60321 .5836 L .60716 .56127 L F
.61436 .51297 m .60321 .5836 L .61606 .50326 L F
.62184 .4784 m .62153 .47189 L p .61849 .49728 L F P
0 g
s
.983 .817 .418 r
.62009 .46541 m .62153 .47189 L p .61852 .4865 L F P
0 g
s
1 .803 .484 r
.61624 .45582 m .6017 .57377 L .6056 .5508 L F
.983 .817 .418 r
.60109 .5713 m .62153 .47189 L .61606 .50326 L F
.911 .794 .315 r
.62153 .47189 m .62137 .46859 L p .61849 .49728 L F P
0 g
s
.983 .817 .418 r
.61606 .50326 m .62225 .47513 L .61436 .51297 L F
.61606 .50326 m .61436 .51297 L .6017 .57377 L F
.911 .794 .315 r
.62137 .46859 m .61436 .51297 L .61606 .50326 L F
1 .803 .484 r
.6017 .57377 m .60275 .57618 L p .6056 .5508 L F P
0 g
s
.983 .817 .418 r
.60699 .54257 m .62009 .46541 L .61852 .4865 L F
.60109 .5713 m .62009 .46541 L .60699 .54257 L F
.988 .771 .52 r
.59959 .56897 m .60109 .5713 L p .59364 .60674 L F P
0 g
s
.988 .771 .52 r
.59364 .60674 m .60109 .5713 L .59186 .61804 L F
1 .801 .479 r
.59853 .56654 m .59186 .61804 L .59364 .60674 L F
.59853 .56654 m .57969 .68852 L .58049 .69019 L p F P
0 g
s
1 .801 .479 r
.59853 .56654 m .58049 .69019 L .59186 .61804 L F
.988 .771 .52 r
.60109 .5713 m .58162 .69178 L .58049 .69019 L p F P
0 g
s
.988 .771 .52 r
.59186 .61804 m .60109 .5713 L .58049 .69019 L F
.982 .814 .412 r
.58162 .69178 m .58741 .66102 L .58599 .66972 L F
.58741 .66102 m .60291 .57867 L .58599 .66972 L F
.58362 .68419 m .59561 .62205 L .58209 .69348 L F
.59561 .62205 m .59487 .62647 L .58209 .69348 L F
.58599 .66972 m .58962 .65135 L .58362 .68419 L F
.58962 .65135 m .60351 .58112 L .58362 .68419 L F
1 .801 .479 r
.58209 .69348 m .5829 .69514 L p .58599 .66972 L F P
0 g
s
1 .801 .479 r
.58599 .66972 m .5829 .69514 L .58741 .66102 L F
.982 .814 .412 r
.58162 .69178 m .60109 .5713 L .6017 .57377 L p F P
0 g
s
.982 .814 .412 r
.6017 .57377 m .60291 .57867 L p .58741 .66102 L F P
0 g
s
.982 .814 .412 r
.58162 .69178 m .6017 .57377 L .58741 .66102 L F
.60291 .57867 m .60351 .58112 L p .59672 .61545 L F P
0 g
s
.907 .789 .307 r
.60275 .57618 m .5829 .69514 L .58303 .69685 L p F P
0 g
s
.907 .789 .307 r
.60275 .57618 m .58303 .69685 L .59672 .61545 L F
.752 .701 .162 r
.5835 .69854 m .58871 .66857 L .58726 .67706 L F
.58871 .66857 m .60261 .5885 L .58726 .67706 L F
.60321 .5836 m .60261 .5885 L p .58871 .66857 L F P
0 g
s
.907 .789 .307 r
.58752 .67554 m .58673 .68048 L .60321 .5836 L F
.58726 .67706 m .58673 .68048 L .58752 .67554 L F
.752 .701 .162 r
.5835 .69854 m .60351 .58112 L .60321 .5836 L p F P
0 g
s
.752 .701 .162 r
.5835 .69854 m .60321 .5836 L .58871 .66857 L F
.907 .789 .307 r
.60291 .57867 m .60275 .57618 L p .59672 .61545 L F P
0 g
s
.982 .814 .412 r
.59561 .62205 m .60351 .58112 L .59487 .62647 L F
1 .801 .479 r
.5829 .69514 m .60275 .57618 L .6017 .57377 L p F P
0 g
s
1 .801 .479 r
.58741 .66102 m .5829 .69514 L .6017 .57377 L F
.982 .814 .412 r
.58209 .69348 m .58162 .69178 L p .58599 .66972 L F P
0 g
s
.988 .771 .52 r
.57825 .687 m .57711 .68539 L p .58189 .66268 L F P
0 g
s
.964 .736 .545 r
.57969 .68852 m .59853 .56654 L .5966 .56432 L p F P
0 g
s
.964 .736 .545 r
.58322 .65376 m .57969 .68852 L .5966 .56432 L F
.59276 .55987 m .59082 .55763 L p .58734 .59857 L F P
0 g
s
.935 .702 .56 r
.59509 .56197 m .57711 .68539 L .57537 .68395 L p F P
0 g
s
.935 .702 .56 r
.58616 .60696 m .59509 .56197 L .57537 .68395 L F
.963 .737 .548 r
.60675 .44398 m .60283 .49047 L .60432 .4802 L F
.60675 .44398 m .59082 .55763 L .59276 .55987 L p F P
0 g
s
.963 .737 .548 r
.60675 .44398 m .59276 .55987 L .60283 .49047 L F
.935 .703 .563 r
.60661 .47114 m .60619 .46729 L .61202 .44975 L F
.60619 .46729 m .60838 .4522 L .61202 .44975 L F
.905 .671 .573 r
.60251 .47419 m .60675 .44398 L .60339 .4414 L p F P
0 g
s
.905 .671 .573 r
.59869 .44937 m .60251 .47419 L .60339 .4414 L F
.929 .711 .586 r
.62867 .36494 m .61202 .44975 L .60914 .44696 L p F P
0 g
s
.929 .711 .586 r
.62066 .38588 m .62867 .36494 L .60914 .44696 L F
.958 .746 .575 r
.62244 .35772 m .61986 .39012 L .62066 .38588 L F
.62244 .35772 m .61313 .40887 L p .61396 .42139 L F P
0 g
s
.958 .746 .575 r
.62244 .35772 m .61396 .42139 L .61986 .39012 L F
.61759 .43447 m .61551 .44477 L .61624 .45582 L F
.983 .783 .557 r
.61202 .44975 m .6185 .42996 L .61759 .43447 L F
.999 .817 .526 r
.63364 .37253 m .62333 .4219 L p .62219 .43726 L F P
0 g
s
.999 .817 .526 r
.63364 .37253 m .62219 .43726 L .62854 .40749 L F
.983 .817 .418 r
.60109 .5713 m .61937 .46213 L .62009 .46541 L p F P
0 g
s
.983 .817 .418 r
.62153 .47189 m .62225 .47513 L p .61606 .50326 L F P
0 g
s
.911 .794 .315 r
.62137 .46859 m .60275 .57618 L .60291 .57867 L p F P
0 g
s
.911 .794 .315 r
.62137 .46859 m .60291 .57867 L .61436 .51297 L F
.758 .708 .172 r
.60321 .5836 m .60351 .58112 L p .60716 .56127 L F P
0 g
s
.758 .708 .172 r
.60716 .56127 m .6125 .53228 L .60321 .5836 L F
.911 .794 .315 r
.60321 .5836 m .60336 .58606 L p .60716 .56127 L F P
0 g
s
.907 .789 .307 r
.60336 .58606 m .60321 .5836 L p .58673 .68048 L F P
0 g
s
.988 .772 .524 r
.5966 .56432 m .59509 .56197 L p .60026 .54072 L F P
0 g
s
.963 .737 .548 r
.5966 .56432 m .59853 .56654 L p .60026 .54072 L F P
0 g
s
.963 .737 .548 r
.60026 .54072 m .59853 .56654 L .60157 .53226 L F
.988 .772 .524 r
.59509 .56197 m .60157 .53226 L .60026 .54072 L F
.59509 .56197 m .61387 .45287 L .60157 .53226 L F
.963 .737 .548 r
.59853 .56654 m .61624 .45582 L .61387 .45287 L p F P
0 g
s
.963 .737 .548 r
.60157 .53226 m .59853 .56654 L .61387 .45287 L F
.60914 .44696 m .60675 .44398 L p .60432 .4802 L F P
0 g
s
.935 .703 .563 r
.60432 .4802 m .60619 .46729 L .60661 .47114 L F
.58576 .55359 m .60339 .4414 L .59134 .53152 L F
.905 .671 .573 r
.59082 .55763 m .60251 .47419 L p .6003 .46448 L F P
0 g
s
.905 .671 .573 r
.59223 .52483 m .59082 .55763 L .6003 .46448 L F
.59328 .43366 m .59255 .47031 L .5957 .44428 L F
.877 .641 .579 r
.60048 .43859 m .58576 .55359 L .58269 .55183 L p F P
0 g
s
.877 .641 .579 r
.59128 .48083 m .60048 .43859 L .58269 .55183 L F
.849 .613 .581 r
.56586 .67713 m .57996 .54989 L .57658 .54834 L p F P
0 g
s
.823 .589 .585 r
.56256 .54264 m .55888 .54132 L p .56447 .51758 L F P
0 g
s
.797 .566 .587 r
.56447 .51758 m .56644 .54371 L .5716 .42398 L F
.56644 .54371 m .57645 .42541 L .5716 .42398 L p F P
0 g
s
.823 .589 .585 r
.58524 .42925 m .5735 .54658 L .56984 .54526 L p F P
0 g
s
.823 .589 .585 r
.57749 .46221 m .58524 .42925 L .56984 .54526 L F
.849 .614 .583 r
.57718 .45129 m .57749 .46221 L .57873 .44873 L F
.57922 .52367 m .57996 .54989 L .58908 .4316 L F
.877 .641 .579 r
.5735 .54658 m .58212 .46048 L p .58655 .45519 L F P
0 g
s
.877 .641 .579 r
.5735 .54658 m .58655 .45519 L .57922 .52367 L F
.935 .703 .563 r
.58576 .55359 m .60048 .43859 L .60339 .4414 L p F P
0 g
s
.901 .679 .592 r
.60339 .4414 m .60675 .44398 L p .60668 .42239 L F P
0 g
s
.929 .711 .586 r
.60048 .43859 m .60771 .41644 L .60668 .42239 L F
.988 .772 .524 r
.59509 .56197 m .61202 .44975 L .61387 .45287 L p F P
0 g
s
.988 .772 .524 r
.61753 .45904 m .61937 .46213 L p .61226 .49137 L F P
0 g
s
1 .803 .484 r
.61624 .45582 m .61344 .48082 L .61431 .47881 L F
.61753 .45904 m .61624 .45582 L p .61431 .47881 L F P
0 g
s
1 .803 .484 r
.61344 .48082 m .61226 .49137 L .61431 .47881 L F
.988 .772 .524 r
.61937 .46213 m .60109 .5713 L .59959 .56897 L p F P
0 g
s
.988 .772 .524 r
.61226 .49137 m .61937 .46213 L .59959 .56897 L F
.911 .794 .315 r
.62137 .46859 m .61606 .50326 L .62038 .47846 L F
.983 .817 .418 r
.62225 .47513 m .60351 .58112 L .60291 .57867 L p F P
0 g
s
.983 .817 .418 r
.61436 .51297 m .62225 .47513 L .60291 .57867 L F
.6017 .57377 m .60109 .5713 L p .6056 .5508 L F P
0 g
s
1 .803 .484 r
.6056 .5508 m .60275 .57618 L .62009 .46541 L F
.60275 .57618 m .62137 .46859 L .62009 .46541 L p F P
0 g
s
.992 .84 .474 r
.62009 .46541 m .62464 .44583 L .62315 .45833 L F
.62009 .46541 m .61937 .46213 L p .62404 .44767 L F P
0 g
s
.992 .84 .474 r
.62404 .44767 m .62464 .44583 L .62009 .46541 L F
.999 .817 .526 r
.62009 .46541 m .62137 .46859 L p .62404 .44767 L F P
0 g
s
.811 .77 .26 r
.62184 .4784 m .62225 .47513 L p .62583 .46135 L F P
0 g
s
0 0 0 r
.63431 .42868 m .63389 .43039 L .63433 .4285 L F
.63438 .42828 m .63431 .42868 L .63433 .4285 L F
.938 .833 .388 r
.62199 .48166 m .63776 .41498 L p .63821 .40848 L F P
0 g
s
.938 .833 .388 r
.62708 .45601 m .62199 .48166 L .63821 .40848 L F
.63961 .38846 m .63456 .41517 L .63914 .39526 L F
.992 .84 .474 r
.63456 .41517 m .64057 .39659 L .62153 .47189 L F
.811 .77 .26 r
.62225 .47513 m .64005 .40066 L .62681 .45717 L F
.992 .84 .474 r
.64057 .39659 m .62225 .47513 L .62153 .47189 L p F P
0 g
s
.758 .708 .172 r
.61728 .50323 m .6218 .47765 L p .62184 .4784 L F P
0 g
s
.758 .708 .172 r
.6218 .47765 m .62225 .47513 L p .62184 .4784 L F P
0 g
s
.758 .708 .172 r
.62184 .4784 m .62103 .48487 L p .61849 .49728 L F P
0 g
s
.758 .708 .172 r
.61728 .50323 m .62184 .4784 L .61849 .49728 L F
.60351 .58112 m .62103 .48487 L .61562 .51529 L F
.911 .794 .315 r
.62199 .48166 m .62184 .4784 L p .61894 .49531 L F P
0 g
s
0 0 0 r
.62199 .48166 m .60336 .58606 L p .61372 .52728 L F P
0 g
s
.911 .794 .315 r
.60336 .58606 m .62199 .48166 L p .61894 .49531 L F P
0 g
s
.938 .833 .388 r
.63776 .41498 m .64019 .40471 L p .63912 .40647 L F P
0 g
s
.921 .905 .504 r
.64057 .39659 m .64351 .39192 L .64103 .40118 L F
.64005 .40066 m .64057 .39659 L p .64103 .40118 L F P
0 g
s
.911 .794 .315 r
.60716 .56127 m .60336 .58606 L .62184 .4784 L F
.758 .708 .172 r
.60351 .58112 m .61728 .50323 L p .61849 .49728 L F P
0 g
s
.758 .708 .172 r
.60351 .58112 m .61849 .49728 L .60858 .55328 L F
.907 .789 .307 r
.58344 .70194 m .60336 .58606 L p .58673 .68048 L F P
0 g
s
0 0 0 r
.56082 .80727 m .56127 .8061 L .56075 .80705 L p F P
0 g
s
.878 .873 .432 r
.56138 .80512 m .56127 .8061 L p .56083 .80721 L F P
0 g
s
.718 .785 .3 r
.56138 .80512 m .5617 .80415 L p .56124 .80533 L F P
0 g
s
.785 .743 .221 r
.56153 .8049 m .56127 .8061 L .56138 .80512 L p F P
0 g
s
.849 .614 .583 r
.57996 .54989 m .59328 .43366 L .58908 .4316 L p F P
0 g
s
.847 .623 .599 r
.59328 .43366 m .60467 .3567 L p .60017 .35123 L F P
0 g
s
.847 .623 .599 r
.59262 .40595 m .59328 .43366 L .60017 .35123 L F
.873 .65 .596 r
.58908 .4316 m .58524 .42925 L p .59177 .41206 L F P
0 g
s
.873 .65 .596 r
.615 .35097 m .60048 .43859 L .59667 .43626 L p F P
0 g
s
.873 .65 .596 r
.60652 .37326 m .615 .35097 L .59667 .43626 L F
.61047 .34804 m .615 .35097 L p .60652 .37326 L F P
0 g
s
.901 .679 .592 r
.60643 .34478 m .60652 .37326 L .61005 .35072 L F
.873 .65 .596 r
.58524 .42925 m .59685 .33924 L .60142 .3422 L p F P
0 g
s
.873 .65 .596 r
.58524 .42925 m .60142 .3422 L .59177 .41206 L F
.847 .623 .599 r
.60031 .35023 m .60467 .3567 L .60142 .3422 L F
.60467 .3567 m .60643 .34478 L .60142 .3422 L p F P
0 g
s
.929 .711 .586 r
.60048 .43859 m .61305 .36271 L p .61693 .36326 L F P
0 g
s
.929 .711 .586 r
.60048 .43859 m .61693 .36326 L .60771 .41644 L F
.901 .679 .592 r
.60675 .44398 m .62244 .35772 L .61845 .35449 L p F P
0 g
s
.901 .679 .592 r
.60668 .42239 m .60675 .44398 L .61845 .35449 L F
.958 .746 .575 r
.62526 .36145 m .62244 .35772 L p .62066 .38588 L F P
0 g
s
.929 .711 .586 r
.62066 .38588 m .62471 .36437 L .62867 .36494 L F
.958 .746 .575 r
.61624 .45582 m .63364 .37253 L .63085 .36884 L p F P
0 g
s
.958 .746 .575 r
.61759 .43447 m .61624 .45582 L .63085 .36884 L F
.983 .783 .557 r
.61202 .44975 m .63085 .36884 L .6185 .42996 L F
.63012 .40009 m .63357 .38395 L .63438 .38842 L F
.999 .817 .526 r
.63364 .37253 m .63221 .38378 L .63357 .38395 L F
.63515 .37655 m .63364 .37253 L p .63357 .38395 L F P
0 g
s
.999 .817 .526 r
.63221 .38378 m .63012 .40009 L .63357 .38395 L F
.983 .783 .557 r
.63438 .38842 m .63357 .38395 L .6373 .38041 L F
.63515 .37655 m .6373 .38041 L p .63357 .38395 L F P
0 g
s
.992 .84 .474 r
.61937 .46213 m .6349 .39133 L p .63631 .39264 L F P
0 g
s
.992 .84 .474 r
.61937 .46213 m .63631 .39264 L .62404 .44767 L F
.999 .817 .526 r
.62404 .44767 m .62137 .46859 L .63812 .38449 L F
.62137 .46859 m .63961 .38846 L .63812 .38449 L p F P
0 g
s
.981 .841 .631 r
.64226 .37395 m .63961 .38846 L .64371 .37025 L F
.991 .879 .612 r
.63812 .38449 m .6373 .38041 L p .64226 .37395 L F P
0 g
s
.991 .879 .612 r
.65322 .35969 m .65937 .35168 L .63976 .39256 L F
.978 .906 .573 r
.65834 .34197 m .65155 .36375 L .65322 .35969 L F
.798 .85 .395 r
.65883 .36136 m .65061 .38183 L .65224 .37804 L F
.811 .77 .26 r
.62225 .47513 m .64057 .39659 L .64005 .40066 L p F P
0 g
s
.978 .906 .573 r
.65834 .34197 m .63961 .38846 L .63976 .39256 L p F P
0 g
s
.978 .906 .573 r
.65834 .34197 m .63976 .39256 L .65155 .36375 L F
.991 .879 .612 r
.65322 .35969 m .65791 .34824 L .65843 .3529 L F
.921 .905 .504 r
.64057 .39659 m .64552 .38771 L .64421 .39081 L F
.978 .906 .573 r
.64005 .40066 m .64019 .40471 L p .64421 .39081 L F P
0 g
s
.978 .906 .573 r
.64421 .39081 m .64019 .40471 L .64568 .38735 L F
.921 .905 .504 r
.64057 .39659 m .65871 .35653 L .64552 .38771 L F
.65224 .37804 m .65685 .36738 L .65606 .37197 L F
.798 .85 .395 r
.65782 .3639 m .65224 .37804 L .65669 .36776 L F
.65883 .36136 m .65782 .3639 L .65685 .36738 L F
.6574 .36611 m .65883 .36136 L p .65685 .36738 L F P
0 g
s
.921 .905 .504 r
.6574 .36611 m .65675 .37089 L p .65726 .36643 L F P
0 g
s
.921 .905 .504 r
.65606 .37197 m .65685 .36738 L .65675 .37089 L F
.65685 .36738 m .65726 .36643 L .65675 .37089 L F
.983 .783 .557 r
.61202 .44975 m .62867 .36494 L .63085 .36884 L p F P
0 g
s
.935 .764 .645 r
.63085 .36884 m .63364 .37253 L p .63475 .35762 L F P
0 g
s
.96 .802 .641 r
.62867 .36494 m .63606 .35384 L .63475 .35762 L F
.91 .73 .646 r
.64585 .31382 m .62867 .36494 L .62526 .36145 L p F P
0 g
s
.91 .73 .646 r
.63574 .32881 m .64585 .31382 L .62526 .36145 L F
.935 .764 .645 r
.63864 .30515 m .62244 .35772 L .62526 .36145 L p F P
0 g
s
.935 .764 .645 r
.63864 .30515 m .62526 .36145 L .63722 .3242 L F
.91 .73 .646 r
.64454 .31539 m .6414 .31119 L .64585 .31382 L F
.6419 .30964 m .64585 .31382 L p .6414 .31119 L F P
0 g
s
.96 .802 .641 r
.62867 .36494 m .64507 .31611 L p .64775 .32019 L F P
0 g
s
.96 .802 .641 r
.62867 .36494 m .64775 .32019 L .63606 .35384 L F
.935 .764 .645 r
.63475 .35762 m .63364 .37253 L .63612 .35368 L F
.63364 .37253 m .65156 .32292 L .64834 .3185 L p F P
0 g
s
.935 .764 .645 r
.63612 .35368 m .63364 .37253 L .64834 .3185 L F
.96 .802 .641 r
.64507 .31611 m .64834 .3185 L .64782 .32 L F
.91 .73 .646 r
.63722 .3242 m .6414 .31119 L .64454 .31539 L F
.935 .764 .645 r
.6419 .30964 m .63864 .30515 L p .63722 .3242 L F P
0 g
s
.885 .699 .646 r
.62191 .34265 m .62244 .35772 L .62313 .33848 L F
.91 .73 .646 r
.615 .35097 m .634 .30128 L .62191 .34265 L F
.615 .35097 m .63 .29704 L .634 .30128 L p F P
0 g
s
.806 .733 .783 r
.63458 .26627 m .62004 .2896 L .62473 .29352 L p F P
0 g
s
.806 .733 .783 r
.634 .30128 m .63864 .30515 L p .63773 .29647 L F P
0 g
s
.817 .752 .791 r
.63773 .29647 m .65952 .28976 L .65468 .29522 L F
.63 .29704 m .63901 .29482 L .63773 .29647 L F
.63901 .29482 m .65952 .28976 L .63773 .29647 L F
.63 .29704 m .64567 .27544 L p .65032 .28025 L F P
0 g
s
.817 .752 .791 r
.63901 .29482 m .65032 .28025 L .65952 .28976 L F
.63 .29704 m .65032 .28025 L .63901 .29482 L F
.806 .733 .783 r
.63773 .29647 m .63864 .30515 L .63904 .29479 L F
.817 .752 .791 r
.65058 .27991 m .66412 .29452 L p .64567 .27544 L F P
0 g
s
.311 .573 .933 r
.6837 .2993 m .6818 .29883 L p .68155 .29844 L F P
0 g
s
.828 .772 .8 r
.65589 .28443 m .65574 .28512 L .65581 .2852 L F
.806 .733 .783 r
.65552 .28487 m .65589 .28443 L .65058 .27991 L p F P
0 g
s
.282 .584 .944 r
.65058 .27991 m .65589 .28443 L p .65462 .28052 L F P
0 g
s
.311 .573 .933 r
.65058 .27991 m .65199 .28073 L .65552 .28487 L F
.65961 .28966 m .65058 .27991 L p .65552 .28487 L F P
0 g
s
.806 .733 .783 r
.63864 .30515 m .65552 .28487 L p .65058 .27991 L F P
0 g
s
.828 .772 .8 r
.65589 .28443 m .64147 .30174 L p .64382 .30747 L F P
0 g
s
.828 .772 .8 r
.65589 .28443 m .64382 .30747 L .65311 .29699 L F
.34 .563 .919 r
.67383 .28873 m .65961 .28966 L .67167 .29225 L F
.67309 .28795 m .65961 .28966 L .67383 .28873 L F
.828 .772 .8 r
.65961 .28966 m .65589 .28443 L p .65468 .29522 L F P
0 g
s
.311 .573 .933 r
.66154 .27679 m .66321 .27698 L .66839 .28262 L p F P
0 g
s
.282 .584 .944 r
.67262 .28746 m .67441 .28778 L .66839 .28262 L p F P
0 g
s
0 .198 .722 r
.694 .30385 m .67533 .28854 L p .67923 .29427 L F P
0 g
s
0 .145 .657 r
.67869 .29382 m .69342 .30618 L .67918 .29435 L F
.6931 .30588 m .69342 .30618 L .67869 .29382 L F
.282 .584 .944 r
.65589 .28443 m .67262 .28746 L p .66724 .28245 L F P
0 g
s
.282 .584 .944 r
.65603 .28074 m .65589 .28443 L .66724 .28245 L F
.311 .573 .933 r
.64601 .27497 m .66154 .27679 L p .66839 .28262 L F P
0 g
s
.311 .573 .933 r
.64601 .27497 m .66839 .28262 L .65462 .28052 L F
.256 .598 .951 r
.62172 .25847 m .63422 .25815 L p .64255 .26288 L F P
0 g
s
.256 .598 .951 r
.62172 .25847 m .64255 .26288 L .63117 .26269 L F
.235 .614 .955 r
.63458 .26627 m .6487 .26697 L p .6272 .25454 L F P
0 g
s
.235 .614 .955 r
.6487 .26697 m .65022 .26704 L .64255 .26288 L p F P
0 g
s
.235 .614 .955 r
.64255 .26288 m .6272 .25454 L p .6487 .26697 L F P
0 g
s
.235 .614 .955 r
.62366 .25477 m .63458 .26627 L .6272 .25454 L F
.282 .584 .944 r
.64933 .2674 m .63564 .26632 L .6407 .27092 L F
.6487 .26697 m .63564 .26632 L p .64933 .2674 L F P
0 g
s
.282 .584 .944 r
.65022 .26704 m .6407 .27092 L .64778 .27154 L F
.65674 .27263 m .65633 .27228 L p .65661 .27255 L F P
0 g
s
.282 .584 .944 r
.65661 .27255 m .67262 .28746 L .65674 .27263 L F
.66839 .28262 m .65674 .27263 L p .67262 .28746 L F P
0 g
s
0 .145 .657 r
.66321 .27698 m .67269 .28614 L .66842 .28265 L F
0 .198 .722 r
.694 .30385 m .67923 .29427 L .6914 .30445 L F
0 .092 .568 r
.67412 .28751 m .66978 .28381 L .67441 .28778 L F
0 .145 .657 r
.68144 .29171 m .68724 .29805 L p .66483 .27854 L F P
0 g
s
0 .092 .568 r
.67269 .28614 m .66978 .28381 L .67412 .28751 L F
0 .198 .722 r
.67533 .28854 m .67441 .28778 L .6786 .29375 L p F P
0 g
s
.34 .563 .919 r
.67441 .28778 m .67309 .28795 L .67383 .28873 L F
.311 .573 .933 r
.67167 .29225 m .6837 .2993 L .65961 .28966 L F
.66412 .29452 m .65961 .28966 L p .68155 .29844 L F P
0 g
s
.311 .573 .933 r
.6818 .29883 m .66412 .29452 L p .68155 .29844 L F P
0 g
s
.34 .563 .919 r
.67441 .28778 m .67167 .29225 L .67335 .29262 L F
.256 .598 .951 r
.65509 .27218 m .65909 .27514 L p .6518 .27189 L F P
0 g
s
.282 .584 .944 r
.6518 .27189 m .65589 .28443 L .65633 .27228 L F
.311 .573 .933 r
.65462 .28052 m .67335 .29262 L .65058 .27991 L F
.67335 .29262 m .6837 .2993 L .67167 .29225 L F
.67335 .29262 m .67167 .29225 L .65058 .27991 L F
.67335 .29262 m .6786 .29375 L .68099 .29755 L F
.6786 .29375 m .6837 .2993 L p .68099 .29755 L F P
0 g
s
.34 .563 .919 r
.68686 .3055 m .6786 .29375 L p .67146 .30122 L F P
0 g
s
.34 .563 .919 r
.6786 .29375 m .67441 .28778 L p .67335 .29262 L F P
0 g
s
.34 .563 .919 r
.67335 .29262 m .67146 .30122 L .6786 .29375 L F
.67335 .29262 m .66694 .29997 L .67146 .30122 L F
.67167 .29225 m .66694 .29997 L .67335 .29262 L F
.311 .573 .933 r
.65462 .28052 m .6786 .29375 L .67335 .29262 L F
.66839 .28262 m .6786 .29375 L p .65462 .28052 L F P
0 g
s
0 .145 .657 r
.67909 .29428 m .6786 .29375 L p .67918 .29435 L F P
0 g
s
0 .198 .722 r
.67533 .28854 m .6786 .29375 L .67923 .29427 L F
0 .145 .657 r
.66839 .28262 m .66321 .27698 L p .66842 .28265 L F P
0 g
s
.509 0 0 r
.66407 .27767 m .66321 .27698 L .65633 .27228 L p F P
0 g
s
0 .092 .568 r
.65633 .27228 m .66839 .28262 L p .65687 .27272 L F P
0 g
s
.282 .584 .944 r
.65633 .27228 m .65603 .28074 L .66724 .28245 L F
.794 .715 .776 r
.63996 .27086 m .64601 .27497 L p .64528 .27512 L F P
0 g
s
.817 .752 .791 r
.64567 .27544 m .64601 .27497 L .65058 .27991 L p F P
0 g
s
.282 .584 .944 r
.65022 .26704 m .64567 .27544 L .65057 .27937 L F
.65022 .26704 m .65058 .27991 L .65462 .28052 L F
.65633 .27228 m .65022 .26704 L p .6518 .27189 L F P
0 g
s
.509 0 0 r
.65633 .27228 m .64255 .26288 L p .65687 .27272 L F P
0 g
s
.509 0 0 r
.65687 .27272 m .66407 .27767 L .65633 .27228 L F
0 .092 .568 r
.65099 .26767 m .65633 .27228 L .65687 .27272 L F
.66839 .28262 m .67441 .28778 L p .66861 .28281 L F P
0 g
s
0 .145 .657 r
.67198 .28546 m .68724 .29805 L .67269 .28614 L F
.66483 .27854 m .68724 .29805 L .67198 .28546 L F
.509 0 0 r
.66738 .28129 m .6678 .2816 L .65687 .27272 L F
.6678 .2816 m .68144 .29171 L .65872 .27416 L F
.6678 .2816 m .65872 .27416 L .65687 .27272 L F
0 .092 .568 r
.65694 .27278 m .66839 .28262 L .66861 .28281 L F
.65687 .27272 m .66839 .28262 L .65694 .27278 L F
.66782 .28165 m .66962 .28362 L .66891 .28254 L F
.66746 .28136 m .65694 .27278 L .66861 .28281 L F
.256 .598 .951 r
.64255 .26288 m .65509 .27218 L p .63117 .26269 L F P
0 g
s
.256 .598 .951 r
.63117 .26269 m .65509 .27218 L .6518 .27189 L F
.559 0 0 r
.63593 .26217 m .62768 .25496 L .64273 .26303 L F
.63621 .26241 m .64273 .26303 L .64356 .26371 L F
.77 .682 .766 r
.62096 .25874 m .62172 .25847 L .62132 .25893 L F
.235 .614 .955 r
.6243 .25544 m .6144 .25535 L .62851 .26264 L F
.6243 .25544 m .62851 .26264 L .63117 .26269 L F
.22 .632 .955 r
.6022 .24874 m .62366 .25477 L .60026 .24905 L F
.62366 .25477 m .62275 .25482 L .60026 .24905 L F
.58 .003 0 r
.61123 .24812 m .63621 .26241 L .61062 .24753 L F
.63621 .26241 m .63593 .26217 L .61062 .24753 L F
.578 .007 0 r
.59858 .24835 m .61062 .24753 L .61123 .24812 L F
.22 .632 .955 r
.60026 .24905 m .62275 .25482 L .6144 .25535 L F
.58 .003 0 r
.61308 .2499 m .63706 .26316 L .61128 .24817 L F
.214 .653 .952 r
.5991 .24869 m .59219 .24655 L .59977 .24913 L F
.757 .667 .763 r
.59091 .27215 m .58356 .27138 L .58984 .27495 L F
.77 .682 .766 r
.58343 .27227 m .59219 .24655 L p .59977 .24913 L F P
0 g
s
.22 .632 .955 r
.59989 .24911 m .60026 .24905 L .60736 .25222 L F
.578 .007 0 r
.59914 .24899 m .61123 .24812 L .61308 .2499 L F
.744 .654 .76 r
.58343 .27227 m .57632 .27062 L p .59204 .2465 L F P
0 g
s
.744 .654 .76 r
.59219 .24655 m .58343 .27227 L p .59204 .2465 L F P
0 g
s
.578 .007 0 r
.59858 .24835 m .61123 .24812 L .59914 .24899 L F
.531 0 0 r
.55715 .24092 m .57383 .23716 L .5753 .23935 L F
.55682 .2401 m .57383 .23716 L .55715 .24092 L F
.55682 .2401 m .5545 .2345 L .57383 .23716 L F
.55438 .23421 m .57383 .23716 L p .5545 .2345 L F P
0 g
s
.491 0 0 r
.55438 .23421 m .53454 .23279 L p .55451 .23454 L F P
0 g
s
.491 0 0 r
.53455 .23289 m .55451 .23454 L .53454 .23279 L F
.381 0 0 r
.49478 .23457 m .51356 .23869 L .51453 .23319 L F
.442 0 0 r
.51458 .23291 m .53454 .23279 L p .51452 .23322 L F P
0 g
s
.442 0 0 r
.51452 .23322 m .53454 .23279 L .53455 .23289 L F
.51342 .23949 m .53461 .23337 L .53479 .23485 L F
.346 .804 .939 r
.49478 .23457 m .5026 .23628 L p .49791 .23718 L F P
0 g
s
.464 .875 .948 r
.46365 .24422 m .47543 .23775 L .47723 .23857 L F
.308 0 0 r
.47099 .24398 m .47519 .23809 L .49473 .23468 L F
.47085 .24418 m .49473 .23468 L .49451 .23517 L F
.528 .905 .953 r
.45678 .24239 m .4391 .24842 L p .46295 .24403 L F P
0 g
s
.112 0 0 r
.43129 .25577 m .43869 .24881 L .45667 .24251 L F
.43129 .25577 m .45667 .24251 L .45617 .24305 L F
.645 .577 .763 r
.47138 .2632 m .48063 .26895 L .46566 .24475 L F
.219 0 0 r
.45464 .24474 m .47041 .24479 L .45678 .24239 L F
.47041 .24479 m .47102 .24393 L .45678 .24239 L F
.45678 .24239 m .47102 .24393 L .47522 .23805 L F
0 0 0 r
.4217 .25653 m .43129 .25577 L .42245 .25589 L F
.402 .84 .943 r
.4759 .23796 m .49488 .23465 L p .47543 .23775 L F P
0 g
s
.402 .84 .943 r
.49478 .23457 m .47543 .23775 L p .49488 .23465 L F P
0 g
s
.219 0 0 r
.47543 .23775 m .45678 .24239 L p .47522 .23805 L F P
0 g
s
.381 0 0 r
.49381 .23668 m .51342 .23949 L .49478 .23457 L F
.51342 .23949 m .51356 .23869 L .49478 .23457 L F
.51458 .23291 m .49478 .23457 L p .51453 .23319 L F P
0 g
s
.308 0 0 r
.47543 .23775 m .49478 .23457 L p .47519 .23809 L F P
0 g
s
.308 0 0 r
.49478 .23457 m .50454 .23297 L p .49473 .23468 L F P
0 g
s
.308 0 0 r
.47519 .23809 m .49478 .23457 L .49473 .23468 L F
.47099 .24398 m .49473 .23468 L .47085 .24418 L F
.661 .586 .76 r
.48197 .24086 m .48194 .24071 L .48361 .24042 L F
.645 .577 .763 r
.47101 .26951 m .46668 .27206 L .47388 .27122 L F
.661 .586 .76 r
.46681 .27295 m .45769 .24734 L p .46579 .24518 L F P
0 g
s
.661 .586 .76 r
.46681 .27295 m .46579 .24518 L .47203 .26528 L F
.308 0 0 r
.47041 .24479 m .4967 .23433 L .50272 .2336 L F
.112 0 0 r
.45464 .24474 m .45849 .24187 L .46384 .24026 L F
.43055 .25647 m .45613 .24311 L .45464 .24474 L F
.45613 .24311 m .45849 .24187 L .45464 .24474 L F
.43129 .25577 m .45617 .24305 L .43055 .25647 L F
.45617 .24305 m .45849 .24187 L .45613 .24311 L F
.45617 .24305 m .45613 .24311 L .43055 .25647 L F
.219 0 0 r
.45464 .24474 m .4685 .24747 L .47041 .24479 L F
.112 0 0 r
.4391 .24842 m .46572 .23934 L p .43869 .24881 L F P
0 g
s
0 0 0 r
.4391 .24842 m .42261 .25575 L p .43869 .24881 L F P
0 g
s
.591 .93 .955 r
.41574 .25943 m .41436 .25941 L .42261 .25575 L p F P
0 g
s
0 0 0 r
.42245 .25589 m .43869 .24881 L .42261 .25575 L F
.513 .854 .586 r
.39999 .26851 m .38309 .28217 L .37639 .28815 L p F P
0 g
s
.513 .854 .586 r
.38861 .27822 m .39999 .26851 L .37639 .28815 L F
0 0 0 r
.40752 .26425 m .42261 .25575 L p .40696 .26472 L F P
0 g
s
0 0 0 r
.40696 .26472 m .42261 .25575 L .42245 .25589 L F
.39698 .27295 m .4217 .25653 L .39598 .27377 L F
.4217 .25653 m .42164 .25658 L .39598 .27377 L F
.39598 .27377 m .42164 .25658 L .41943 .25849 L F
.43129 .25577 m .43153 .25554 L .42245 .25589 L F
.39698 .27295 m .40696 .26472 L .42245 .25589 L F
.4217 .25653 m .42245 .25589 L .42401 .255 L F
.39698 .27295 m .42245 .25589 L .4217 .25653 L F
.65 .947 .955 r
.41301 .2641 m .42254 .26384 L .43426 .25692 L F
.744 .956 .942 r
.40691 .27256 m .40992 .27227 L .41346 .26892 L F
.701 .956 .95 r
.40691 .27256 m .41168 .26414 L .41068 .2722 L F
.41168 .26414 m .41301 .2641 L .41068 .2722 L F
.612 .56 .772 r
.41592 .26755 m .42766 .27254 L .42642 .27044 L F
.41592 .26755 m .43073 .29069 L .43648 .28752 L p F P
0 g
s
.612 .56 .772 r
.41592 .26755 m .43648 .28752 L .42766 .27254 L F
.701 .956 .95 r
.41083 .27166 m .41301 .2641 L .42254 .26384 L F
0 0 0 r
.40864 .26779 m .4273 .25952 L p .41943 .25849 L F P
0 g
s
.219 0 0 r
.45389 .24556 m .4685 .24747 L .45464 .24474 L F
.645 .577 .763 r
.44321 .25297 m .45307 .25718 L .4502 .25001 L F
.629 .568 .767 r
.45098 .25196 m .45025 .25015 L .4517 .24948 L F
.219 0 0 r
.44735 .25271 m .4685 .24747 L p .45389 .24556 L F P
0 g
s
.645 .577 .763 r
.44321 .25297 m .45394 .25935 L .45307 .25718 L F
.45378 .27795 m .46049 .2757 L p .44321 .25297 L F P
0 g
s
.645 .577 .763 r
.44321 .25297 m .46049 .2757 L .45394 .25935 L F
.591 .93 .955 r
.43554 .25639 m .43585 .25609 L .44053 .2541 L F
.44053 .2541 m .4427 .25319 L .43576 .25641 L F
.645 .577 .763 r
.4427 .25319 m .45378 .27795 L p .44321 .25297 L F P
0 g
s
.612 .56 .772 r
.45378 .27795 m .4427 .25319 L p .43576 .25641 L F P
0 g
s
.612 .56 .772 r
.44523 .2756 m .45378 .27795 L .43576 .25641 L F
.112 0 0 r
.46572 .23934 m .45748 .24927 L .44735 .25271 L p F P
0 g
s
.112 0 0 r
.44735 .25271 m .4273 .25952 L p .45469 .24513 L F P
0 g
s
.112 0 0 r
.45469 .24513 m .46572 .23934 L .44735 .25271 L F
.676 .595 .758 r
.50143 .25709 m .50991 .26422 L .49882 .23794 L F
.381 0 0 r
.49049 .24387 m .51298 .24199 L p .49381 .23668 L F P
0 g
s
.491 0 0 r
.53479 .23485 m .55715 .24092 L .53461 .23337 L F
.561 0 0 r
.56621 .23568 m .5753 .23935 L .57199 .2368 L F
.77 .682 .766 r
.58343 .27227 m .59977 .24913 L .59285 .26712 L F
.757 .667 .763 r
.59963 .2495 m .60736 .25222 L .59977 .24913 L F
.782 .698 .771 r
.60785 .25243 m .59849 .27301 L .60381 .27757 L F
.60785 .25243 m .60381 .27757 L .61008 .26441 L F
.757 .667 .763 r
.59662 .27712 m .60736 .25222 L p .59961 .24954 L F P
0 g
s
.782 .698 .771 r
.60736 .25222 m .59662 .27712 L p .60785 .25243 L F P
0 g
s
.782 .698 .771 r
.60785 .25243 m .61109 .2623 L .6144 .25535 L F
.58 .003 0 r
.63706 .26316 m .63621 .26241 L .61123 .24812 L F
.214 .653 .952 r
.61829 .25045 m .61944 .25032 L .61049 .24741 L p F P
0 g
s
.256 .598 .951 r
.63422 .25815 m .63556 .25811 L .64255 .26288 L p F P
0 g
s
.509 0 0 r
.66891 .28254 m .68144 .29171 L .66738 .28129 L F
0 .092 .568 r
.66782 .28165 m .66861 .28281 L .66962 .28362 L F
.6668 .28052 m .66746 .28136 L .66782 .28165 L F
.66746 .28136 m .66861 .28281 L .66782 .28165 L F
.559 0 0 r
.6272 .25454 m .64255 .26288 L p .62768 .25496 L F P
0 g
s
.509 0 0 r
.6461 .26583 m .66891 .28254 L .64255 .26288 L F
.66891 .28254 m .66738 .28129 L .64255 .26288 L F
.64255 .26288 m .66738 .28129 L .65687 .27272 L F
.559 0 0 r
.64255 .26288 m .65022 .26704 L p .64273 .26303 L F P
0 g
s
.559 0 0 r
.62768 .25496 m .64255 .26288 L .64273 .26303 L F
.6461 .26583 m .64423 .26383 L .64952 .26684 L F
.63706 .26316 m .64363 .26378 L .6461 .26583 L F
.64363 .26378 m .64423 .26383 L .6461 .26583 L F
0 .092 .568 r
.66891 .28254 m .66962 .28362 L .67269 .28614 L F
.509 0 0 r
.67368 .28642 m .68144 .29171 L p .66891 .28254 L F P
0 g
s
0 .092 .568 r
.67441 .28778 m .694 .30385 L .68724 .29805 L p F P
0 g
s
0 .141 .653 r
.68724 .29805 m .68144 .29171 L p .6915 .30153 L F P
0 g
s
0 .088 .564 r
.68724 .29805 m .694 .30385 L p .69174 .30177 L F P
0 g
s
0 .141 .653 r
.68144 .29171 m .70018 .30697 L p .70221 .31011 L F P
0 g
s
0 .141 .653 r
.68144 .29171 m .70661 .31402 L .6917 .30173 L F
0 .088 .564 r
.6917 .30173 m .68724 .29805 L .69174 .30177 L F
.68667 .29709 m .68724 .29805 L .6917 .30173 L F
.514 0 0 r
.68667 .29709 m .68745 .29766 L .67368 .28642 L F
.68745 .29766 m .70018 .30697 L .67368 .28642 L F
0 .088 .564 r
.68388 .29452 m .6851 .2958 L .68667 .29709 L F
.6851 .2958 m .68724 .29805 L .68667 .29709 L F
0 .092 .568 r
.68724 .29805 m .67368 .28642 L p .67282 .28627 L F P
0 g
s
0 .092 .568 r
.66886 .28249 m .67282 .28627 L .67368 .28642 L F
.67282 .28627 m .67441 .28778 L .68724 .29805 L F
0 .088 .564 r
.67368 .28642 m .68724 .29805 L p .6851 .2958 L F P
0 g
s
0 .088 .564 r
.68504 .29574 m .67368 .28642 L .6851 .2958 L F
0 .198 .722 r
.694 .30385 m .6914 .30445 L .69316 .30593 L F
0 .145 .657 r
.69868 .31054 m .70438 .31677 L p .69316 .30593 L F P
0 g
s
0 .198 .722 r
.69098 .31135 m .71246 .33028 L .70788 .32372 L p F P
0 g
s
0 .198 .722 r
.69333 .31111 m .69098 .31135 L .70788 .32372 L F
0 .246 .76 r
.69107 .30888 m .70788 .32372 L .69166 .30966 L F
0 .145 .657 r
.69316 .30593 m .69342 .30618 L .6931 .30588 L F
0 .246 .76 r
.6837 .2993 m .70788 .32372 L .69107 .30888 L F
0 .198 .722 r
.69316 .30593 m .69098 .31135 L .69868 .31054 L F
.052 .287 .777 r
.71246 .33028 m .69199 .31224 L p .69386 .31841 L F P
0 g
s
.052 .287 .777 r
.71246 .33028 m .69386 .31841 L .70883 .33199 L F
0 .246 .76 r
.71478 .33739 m .71821 .3442 L p .70883 .33199 L F P
0 g
s
.052 .287 .777 r
.69935 .33647 m .7216 .35835 L .71478 .33739 L p F P
0 g
s
.052 .287 .777 r
.71478 .33739 m .71246 .33028 L p .70883 .33199 L F P
0 g
s
.052 .287 .777 r
.70883 .33199 m .69935 .33647 L .71478 .33739 L F
0 .246 .76 r
.70788 .32372 m .71478 .33739 L p .69166 .30966 L F P
0 g
s
0 .246 .76 r
.69166 .30966 m .71478 .33739 L .70883 .33199 L F
0 .198 .722 r
.70788 .32372 m .69868 .31054 L p .69333 .31111 L F P
0 g
s
0 .198 .722 r
.69868 .31054 m .694 .30385 L p .69316 .30593 L F P
0 g
s
0 .092 .568 r
.66962 .28362 m .66978 .28381 L .67269 .28614 L F
.66962 .28362 m .66861 .28281 L .66978 .28381 L F
0 .145 .657 r
.67269 .28614 m .69316 .30593 L .66842 .28265 L F
.69316 .30593 m .6931 .30588 L .66842 .28265 L F
.68724 .29805 m .69868 .31054 L p .67269 .28614 L F P
0 g
s
0 .145 .657 r
.67269 .28614 m .69868 .31054 L .69316 .30593 L F
0 .246 .76 r
.6837 .2993 m .69166 .30966 L .68711 .30571 L F
0 .198 .722 r
.69316 .30593 m .68686 .3055 L .69166 .30966 L F
.6914 .30445 m .68686 .3055 L .69316 .30593 L F
0 .194 .719 r
.69868 .31054 m .70788 .32372 L p .71186 .32164 L F P
0 g
s
0 .194 .719 r
.71197 .32158 m .69868 .31054 L .71186 .32164 L F
.71412 .32046 m .69868 .31054 L .71197 .32158 L F
0 .141 .653 r
.69868 .31054 m .68724 .29805 L p .71366 .32316 L F P
0 g
s
0 .141 .653 r
.6915 .30153 m .71366 .32316 L .68724 .29805 L F
0 .145 .657 r
.6786 .29375 m .66839 .28262 L p .67869 .29382 L F P
0 g
s
0 .145 .657 r
.66842 .28265 m .67869 .29382 L .66839 .28262 L F
.66842 .28265 m .6931 .30588 L .67869 .29382 L F
.509 0 0 r
.6461 .26583 m .67368 .28642 L .66891 .28254 L F
.64734 .26686 m .67368 .28642 L .6461 .26583 L F
.65814 .27583 m .67368 .28642 L p .64734 .26686 L F P
0 g
s
0 .145 .657 r
.66321 .27698 m .66407 .27767 L p .66483 .27854 L F P
0 g
s
0 .145 .657 r
.66407 .27767 m .68144 .29171 L p .66483 .27854 L F P
0 g
s
.509 0 0 r
.68144 .29171 m .66407 .27767 L p .65687 .27272 L F P
0 g
s
0 .092 .568 r
.65099 .26767 m .65687 .27272 L .65694 .27278 L F
.6668 .28052 m .65099 .26767 L p .65694 .27278 L F P
0 g
s
0 .092 .568 r
.6668 .28052 m .65694 .27278 L .66746 .28136 L F
.65099 .26767 m .65022 .26704 L .65633 .27228 L p F P
0 g
s
.559 0 0 r
.65022 .26704 m .6668 .28052 L .65814 .27583 L p F P
0 g
s
.235 .614 .955 r
.63117 .26269 m .62851 .26264 L .63365 .2653 L F
.282 .584 .944 r
.63564 .26632 m .63996 .27086 L .64567 .27544 L F
.256 .598 .951 r
.62851 .26264 m .6518 .27189 L .63996 .27086 L F
.63117 .26269 m .6518 .27189 L .62851 .26264 L F
.578 .007 0 r
.59262 .24158 m .61049 .24741 L p .59293 .24194 L F P
0 g
s
.578 .007 0 r
.59293 .24194 m .61049 .24741 L .61062 .24753 L F
.62188 .25838 m .60162 .2518 L p .61399 .25078 L F P
0 g
s
.578 .007 0 r
.59914 .24899 m .61308 .2499 L .60162 .2518 L F
.61308 .2499 m .61399 .25078 L .60162 .2518 L F
.58 .003 0 r
.60204 .2438 m .64081 .26643 L .63706 .26316 L F
.6272 .25454 m .61049 .24741 L p .62763 .25491 L F P
0 g
s
.22 .632 .955 r
.63556 .25811 m .63422 .25815 L p .63367 .25786 L F P
0 g
s
.58 .003 0 r
.61062 .24753 m .63625 .25869 L .61049 .24741 L F
.63706 .26316 m .61123 .24812 L .61128 .24817 L F
.61062 .24753 m .63593 .26217 L .62768 .25496 L F
.578 .007 0 r
.61308 .2499 m .61944 .25032 L .61399 .25078 L F
.58 .003 0 r
.60204 .2438 m .61231 .25431 L .62188 .25838 L p F P
0 g
s
.58 .003 0 r
.62188 .25838 m .64081 .26643 L p .61399 .25078 L F P
0 g
s
.58 .003 0 r
.60204 .2438 m .62188 .25838 L .61399 .25078 L F
.559 0 0 r
.65814 .27583 m .64081 .26643 L p .64641 .26592 L F P
0 g
s
.559 0 0 r
.63706 .26316 m .64641 .26592 L .64081 .26643 L F
.58 .003 0 r
.64081 .26643 m .65026 .27046 L p .63706 .26316 L F P
0 g
s
.559 0 0 r
.64081 .26643 m .63202 .26167 L p .63706 .26316 L F P
0 g
s
.282 .584 .944 r
.65022 .26704 m .6487 .26697 L p .64933 .2674 L F P
0 g
s
.559 0 0 r
.64641 .26592 m .65022 .26704 L .65814 .27583 L F
.514 0 0 r
.69154 .30109 m .70018 .30697 L p .68667 .29709 L F P
0 g
s
.184 .468 .889 r
.73409 .32802 m .71412 .32046 L .71928 .32789 L p F P
0 g
s
0 .088 .564 r
.694 .30385 m .7079 .31532 L p .69445 .30367 L F P
0 g
s
0 .088 .564 r
.68619 .29665 m .694 .30385 L .69445 .30367 L F
.69154 .30109 m .68388 .29452 L p .7079 .31532 L F P
0 g
s
0 .194 .719 r
.71412 .32046 m .71366 .32316 L .71764 .32651 L F
0 .141 .653 r
.71366 .32316 m .71782 .32667 L .72558 .33479 L F
0 .194 .719 r
.71928 .32789 m .71412 .32046 L p .71764 .32651 L F P
0 g
s
0 .141 .653 r
.71928 .32789 m .72558 .33479 L p .71782 .32667 L F P
0 g
s
0 .194 .719 r
.71764 .32651 m .72766 .34374 L .71928 .32789 L F
0 .141 .653 r
.70258 .3107 m .71928 .32789 L .71782 .32667 L F
.6917 .30173 m .70258 .3107 L .71782 .32667 L F
.6917 .30173 m .71782 .32667 L .71366 .32316 L F
0 .194 .719 r
.71764 .32651 m .71284 .32804 L .72439 .33811 L F
.71366 .32316 m .71284 .32804 L .71764 .32651 L F
.24 .471 .88 r
.72942 .3425 m .72558 .33479 L p .73437 .34477 L F P
0 g
s
.184 .468 .889 r
.71928 .32789 m .73446 .34976 L p .73435 .34341 L F P
0 g
s
.124 .465 .891 r
.73419 .33396 m .74659 .3438 L .71928 .32789 L F
.184 .468 .889 r
.73409 .32802 m .71928 .32789 L .73419 .33396 L F
.61 .728 .929 r
.7188 .31315 m .7093 .30666 L p .7346 .30537 L F P
0 g
s
.124 .465 .891 r
.70018 .30697 m .7188 .31315 L .72585 .32093 L p F P
0 g
s
.064 .462 .885 r
.71412 .32046 m .73323 .3277 L p .72524 .3207 L F P
0 g
s
.064 .462 .885 r
.71108 .31562 m .71412 .32046 L .72524 .3207 L F
.124 .465 .891 r
.70018 .30697 m .72585 .32093 L .71263 .31618 L F
.006 .459 .868 r
.7188 .31315 m .70018 .30697 L p .69761 .30299 L F P
0 g
s
.006 .459 .868 r
.7045 .30515 m .7188 .31315 L .69761 .30299 L F
.124 .465 .891 r
.70018 .30697 m .71263 .31618 L .71108 .31562 L F
.064 .462 .885 r
.70661 .31402 m .71412 .32046 L p .71108 .31562 L F P
0 g
s
.124 .465 .891 r
.70018 .30697 m .71402 .31796 L .7163 .32226 L F
.70661 .31402 m .70018 .30697 L p .7163 .32226 L F P
0 g
s
.514 0 0 r
.70018 .30697 m .68144 .29171 L .67368 .28642 L p F P
0 g
s
.064 .462 .885 r
.70088 .2994 m .69154 .30109 L .70295 .30467 L F
.006 .459 .868 r
.69154 .30109 m .6959 .30034 L .69761 .30299 L F
.70018 .30697 m .69154 .30109 L p .69761 .30299 L F P
0 g
s
.064 .462 .885 r
.70088 .2994 m .68388 .29452 L .69154 .30109 L p F P
0 g
s
0 .141 .653 r
.70018 .30697 m .70661 .31402 L p .70221 .31011 L F P
0 g
s
.064 .462 .885 r
.69154 .30109 m .70661 .31402 L p .70295 .30467 L F P
0 g
s
.064 .462 .885 r
.70088 .2994 m .70295 .30467 L .7045 .30515 L F
.70088 .2994 m .7045 .30515 L .70911 .3066 L F
.006 .459 .868 r
.7093 .30666 m .7188 .31315 L p .7045 .30515 L F P
0 g
s
.064 .462 .885 r
.7093 .30666 m .70088 .2994 L p .71489 .31165 L F P
0 g
s
.064 .462 .885 r
.71489 .31165 m .73323 .3277 L .71734 .31373 L F
.71489 .31165 m .71734 .31373 L .7093 .30666 L F
.61 .728 .929 r
.7204 .30161 m .7346 .30537 L .7093 .30666 L F
.73583 .30636 m .7188 .31315 L p .7346 .30537 L F P
0 g
s
.78 .747 .823 r
.73564 .28807 m .72717 .29805 L .7385 .30852 L F
.753 .705 .807 r
.65731 .25972 m .68288 .27096 L .6572 .25996 L F
.612 .734 .932 r
.67056 .26527 m .66111 .27344 L p .67135 .28012 L F P
0 g
s
.612 .734 .932 r
.67056 .26527 m .67135 .28012 L .67877 .27451 L F
.559 0 0 r
.63621 .26241 m .64423 .26383 L .63706 .26316 L F
.63593 .26217 m .64273 .26303 L .63621 .26241 L F
.509 0 0 r
.63556 .25811 m .64734 .26686 L .6461 .26583 L F
.63556 .25811 m .65026 .27046 L .65814 .27583 L p F P
0 g
s
.509 0 0 r
.63556 .25811 m .65814 .27583 L .64734 .26686 L F
.58 .003 0 r
.63706 .26316 m .65026 .27046 L .63621 .26241 L F
.559 0 0 r
.63202 .26167 m .63621 .26241 L .63706 .26316 L F
.58 .003 0 r
.63621 .26241 m .65026 .27046 L .63593 .26217 L F
.65026 .27046 m .63625 .25869 L p .62768 .25496 L F P
0 g
s
.58 .003 0 r
.63593 .26217 m .65026 .27046 L .62768 .25496 L F
.559 0 0 r
.64356 .26371 m .64273 .26303 L .64423 .26383 L F
.509 0 0 r
.63736 .25942 m .6461 .26583 L .64255 .26288 L F
.64255 .26288 m .63556 .25811 L p .63736 .25942 L F P
0 g
s
.559 0 0 r
.64952 .26684 m .64423 .26383 L .65022 .26704 L F
.806 .733 .783 r
.63466 .26705 m .63572 .27717 L .63996 .27086 L F
0 .088 .564 r
.68388 .29452 m .68619 .29665 L .69445 .30367 L F
.282 .584 .944 r
.64778 .27154 m .6407 .27092 L .64567 .27544 L F
.77 .682 .766 r
.61109 .2623 m .62096 .25874 L .60252 .28026 L F
.62096 .25874 m .62132 .25893 L .60252 .28026 L F
.794 .715 .776 r
.63572 .27717 m .63996 .27086 L .64528 .27512 L F
.60887 .28293 m .62145 .25899 L p .62785 .26263 L F P
0 g
s
.77 .682 .766 r
.60887 .28293 m .60252 .28026 L p .62132 .25893 L F P
0 g
s
.77 .682 .766 r
.62145 .25899 m .60887 .28293 L p .62132 .25893 L F P
0 g
s
.782 .698 .771 r
.61726 .28113 m .62004 .2896 L .62785 .26263 L F
.794 .715 .776 r
.60887 .28293 m .62785 .26263 L .61834 .27925 L F
.583 .007 0 r
.62552 .26192 m .63119 .26744 L .65484 .27882 L F
.63119 .26744 m .63365 .26983 L .64291 .27308 L F
.581 .011 0 r
.6139 .26216 m .62458 .26101 L .63365 .26983 L F
.583 .007 0 r
.64985 .27594 m .65484 .27882 L .65299 .27719 L F
.64985 .27594 m .65299 .27719 L .65101 .27544 L F
.581 .011 0 r
.60839 .25956 m .62458 .26101 L .61093 .26248 L F
.731 .641 .758 r
.56767 .24059 m .57613 .24207 L .56775 .2402 L F
.757 .667 .763 r
.57668 .2422 m .58197 .25147 L .58254 .24365 L F
.531 0 0 r
.5803 .2468 m .55821 .24347 L p .57582 .24012 L F P
0 g
s
.744 .654 .76 r
.58197 .25147 m .58416 .24405 L .59164 .24638 L F
.757 .667 .763 r
.58254 .24365 m .58197 .25147 L .58411 .2442 L F
.59207 .26915 m .59662 .27712 L .59961 .24954 L F
.564 .004 0 r
.60162 .2518 m .5803 .2468 L p .60839 .25956 L F P
0 g
s
.564 .004 0 r
.58184 .24912 m .60839 .25956 L .5803 .2468 L F
.26 .734 .938 r
.5335 .23635 m .53353 .23623 L .54219 .23694 L F
.731 .641 .758 r
.54007 .26404 m .54746 .26515 L p .54235 .23695 L F P
0 g
s
.731 .641 .758 r
.54219 .23694 m .54007 .26404 L p .54235 .23695 L F P
0 g
s
.491 0 0 r
.53566 .24186 m .55821 .24347 L p .53488 .23557 L F P
0 g
s
.491 0 0 r
.53479 .23485 m .55821 .24347 L .55743 .241 L F
.442 0 0 r
.51342 .23949 m .53479 .23485 L .51298 .24199 L F
.53479 .23485 m .53488 .23557 L .51298 .24199 L F
.51352 .23892 m .53461 .23337 L .51342 .23949 L F
.51352 .23892 m .51452 .23322 L .53455 .23289 L F
.51352 .23892 m .53455 .23289 L .53461 .23337 L F
.491 0 0 r
.52455 .23207 m .53488 .23557 L .53479 .23485 L F
.53488 .23557 m .55821 .24347 L .53479 .23485 L F
.55715 .24092 m .55691 .24034 L .53461 .23337 L F
.55691 .24034 m .55683 .24015 L .53455 .23289 L F
.298 .768 .937 r
.54435 .23308 m .54458 .23273 L .53454 .23279 L p F P
0 g
s
.442 0 0 r
.53479 .23485 m .54458 .23273 L .53488 .23557 L F
.54458 .23273 m .54707 .24179 L .53566 .24186 L p F P
0 g
s
.718 .628 .757 r
.52498 .26356 m .53348 .23639 L .53273 .25788 L F
.442 0 0 r
.53566 .24186 m .51298 .24199 L p .53488 .23557 L F P
0 g
s
.442 0 0 r
.53488 .23557 m .54458 .23273 L .53566 .24186 L F
.491 0 0 r
.52455 .23207 m .52431 .24105 L .53566 .24186 L p F P
0 g
s
.491 0 0 r
.52455 .23207 m .53566 .24186 L .53488 .23557 L F
.531 0 0 r
.55715 .24092 m .5753 .23935 L .55821 .24347 L F
.214 .653 .952 r
.58454 .24394 m .58416 .24405 L .59219 .24655 L F
.561 0 0 r
.5803 .2468 m .60162 .2518 L p .5753 .23935 L F P
0 g
s
.561 0 0 r
.60162 .2518 m .61231 .25431 L p .59944 .24911 L F P
0 g
s
.561 0 0 r
.5753 .23935 m .60162 .2518 L .59944 .24911 L F
.534 0 0 r
.55821 .24347 m .5803 .2468 L p .56074 .24966 L F P
0 g
s
.494 0 0 r
.55821 .24347 m .53566 .24186 L p .56109 .25052 L F P
0 g
s
.384 0 0 r
.51298 .24199 m .49049 .24387 L p .51177 .24891 L F P
0 g
s
.308 0 0 r
.49049 .24387 m .4685 .24747 L p .49422 .23712 L F P
0 g
s
.223 0 0 r
.4685 .24747 m .44735 .25271 L p .46393 .25396 L F P
0 g
s
.311 0 0 r
.4685 .24747 m .49049 .24387 L p .46393 .25396 L F P
0 g
s
.311 0 0 r
.4633 .25485 m .49049 .24387 L .48947 .24611 L F
.744 .956 .942 r
.38727 .28348 m .40992 .27227 L .40691 .27256 L F
.594 .552 .778 r
.4417 .2839 m .43648 .28752 L p .42871 .26019 L F P
0 g
s
.594 .552 .778 r
.42882 .26012 m .4417 .2839 L p .42871 .26019 L F P
0 g
s
.574 .545 .784 r
.43073 .29069 m .41624 .26805 L p .41068 .2722 L F P
0 g
s
.612 .56 .772 r
.41667 .26776 m .42642 .27044 L .42254 .26384 L F
.116 0 0 r
.41844 .26794 m .44735 .25271 L .44511 .25519 L F
0 0 0 r
.41943 .25849 m .4273 .25952 L .43055 .25647 L F
.112 0 0 r
.43055 .25647 m .46572 .23934 L .4273 .25952 L F
0 0 0 r
.41943 .25849 m .43675 .25534 L .4217 .25653 L F
.43024 .25144 m .41727 .26293 L .40864 .26779 L p F P
0 g
s
0 0 0 r
.37639 .28815 m .3916 .27738 L p .39001 .27708 L F P
0 g
s
0 0 0 r
.39001 .27708 m .3916 .27738 L .39598 .27377 L F
.39598 .27377 m .42024 .25796 L .3916 .27738 L F
.39931 .27193 m .41365 .26 L p .40696 .26472 L F P
0 g
s
0 0 0 r
.39382 .27398 m .39731 .27268 L .40696 .26472 L F
.39731 .27268 m .39931 .27193 L .40696 .26472 L F
.40864 .26779 m .3916 .27738 L p .42024 .25796 L F P
0 g
s
0 0 0 r
.3916 .27738 m .38309 .28217 L p .39598 .27377 L F P
0 g
s
0 0 0 r
.42024 .25796 m .43024 .25144 L .40864 .26779 L F
.4273 .25952 m .40864 .26779 L p .41844 .26794 L F P
0 g
s
0 0 0 r
.37639 .28815 m .3688 .29352 L p .37222 .29156 L F P
0 g
s
.509 .851 .581 r
.35824 .30301 m .34358 .3161 L p .34996 .31062 L F P
0 g
s
.509 .851 .581 r
.34996 .31062 m .37077 .29275 L .35824 .30301 L F
.633 .964 .872 r
.3498 .30898 m .35405 .30435 L .35597 .30373 L F
0 0 0 r
.3688 .29352 m .3498 .30898 L .35824 .30301 L p F P
0 g
s
.665 .938 .667 r
.36319 .29992 m .35214 .31253 L p .34898 .31153 L F P
0 g
s
.509 .851 .581 r
.34893 .31169 m .37222 .29156 L .34358 .3161 L F
0 0 0 r
.3688 .29352 m .35824 .30301 L .37222 .29156 L F
.509 .851 .581 r
.37222 .29156 m .38309 .28217 L .37077 .29275 L F
.37222 .29156 m .37077 .29275 L .34358 .3161 L F
.36319 .29992 m .38309 .28217 L p .34893 .31169 L F P
0 g
s
0 0 0 r
.37222 .29156 m .35824 .30301 L .37861 .28818 L F
.667 .94 .671 r
.38228 .28429 m .37241 .29552 L p .38169 .28477 L F P
0 g
s
0 0 0 r
.37222 .29156 m .37861 .28818 L .37967 .2873 L F
.509 .851 .581 r
.36569 .29636 m .35824 .30301 L p .36259 .29936 L F P
0 g
s
.509 .851 .581 r
.38309 .28217 m .36569 .29636 L p .36259 .29936 L F P
0 g
s
.509 .851 .581 r
.37077 .29275 m .38309 .28217 L .35824 .30301 L F
0 0 0 r
.3916 .27738 m .40864 .26779 L p .38111 .2861 L F P
0 g
s
0 0 0 r
.37967 .2873 m .40864 .26779 L .40533 .27067 L F
.38111 .2861 m .40864 .26779 L .37967 .2873 L F
.40533 .27067 m .41844 .26794 L .40864 .26779 L F
.554 .539 .792 r
.40475 .27637 m .421 .29825 L .41712 .30252 L p F P
0 g
s
.554 .539 .792 r
.40477 .27715 m .40128 .28046 L .40475 .27637 L F
.778 .949 .931 r
.39951 .28149 m .40356 .27652 L .40032 .28136 L F
.39414 .28782 m .40356 .27652 L .39552 .28638 L F
.744 .956 .942 r
.38727 .28348 m .40032 .28136 L .40992 .27227 L F
0 0 0 r
.39422 .28033 m .37519 .29103 L p .382 .28648 L F P
0 g
s
0 0 0 r
.382 .28648 m .40418 .27167 L .39422 .28033 L F
.574 .545 .784 r
.42146 .28785 m .43073 .29069 L .41068 .2722 L F
.594 .552 .778 r
.421 .29825 m .4051 .27684 L p .41092 .27256 L F P
0 g
s
.594 .552 .778 r
.421 .29825 m .41092 .27256 L .42268 .28962 L F
.223 0 0 r
.44511 .25519 m .4633 .25485 L .44735 .25271 L F
.4633 .25485 m .46393 .25396 L .44735 .25271 L F
.44511 .25519 m .43759 .2635 L .45781 .2571 L F
.116 0 0 r
.41512 .27111 m .44433 .25605 L .43963 .26125 L F
.223 0 0 r
.45781 .2571 m .45034 .25946 L .46134 .25763 L F
.43759 .2635 m .46134 .25763 L p .45034 .25946 L F P
0 g
s
.384 0 0 r
.48947 .24611 m .51177 .24891 L .49049 .24387 L F
.311 0 0 r
.46134 .25763 m .48911 .24688 L .48697 .25158 L F
.494 0 0 r
.53593 .24404 m .56109 .25052 L .53566 .24186 L F
.444 0 0 r
.51132 .25151 m .53602 .24479 L .53658 .24938 L F
.53682 .25136 m .51132 .25151 L p .5241 .25043 L F P
0 g
s
.494 0 0 r
.53593 .24404 m .53658 .24938 L .56217 .25317 L F
.534 0 0 r
.56189 .25248 m .58184 .24912 L .58559 .25479 L F
.56109 .25052 m .58184 .24912 L .56189 .25248 L F
.58699 .25689 m .56217 .25317 L p .57403 .25399 L F P
0 g
s
.534 0 0 r
.57403 .25399 m .58559 .25479 L .58699 .25689 L F
.564 .004 0 r
.59843 .25565 m .58559 .25479 L .61093 .26248 L F
.581 .011 0 r
.61093 .26248 m .6139 .26216 L .6212 .26499 L F
.63365 .26983 m .61093 .26248 L p .6212 .26499 L F P
0 g
s
.564 .004 0 r
.61093 .26248 m .6215 .26472 L p .60839 .25956 L F P
0 g
s
.235 .614 .955 r
.62851 .26264 m .62145 .25899 L .62802 .26263 L F
.581 .011 0 r
.60839 .25956 m .62188 .25838 L .62458 .26101 L F
.60757 .25863 m .62188 .25838 L .60839 .25956 L F
.60162 .2518 m .62188 .25838 L p .60716 .25863 L F P
0 g
s
.564 .004 0 r
.62292 .26528 m .61231 .25431 L .60162 .2518 L p F P
0 g
s
.564 .004 0 r
.60839 .25956 m .62292 .26528 L .60162 .2518 L F
.583 .007 0 r
.62292 .26528 m .63365 .26983 L p .6299 .2671 L F P
0 g
s
.583 .007 0 r
.61231 .25431 m .62292 .26528 L p .6299 .2671 L F P
0 g
s
0 .475 .738 r
.62292 .26528 m .61093 .26248 L p .61771 .26392 L F P
0 g
s
0 .475 .738 r
.62846 .26619 m .62292 .26528 L p .61771 .26392 L F P
0 g
s
.564 .004 0 r
.5749 .25407 m .58699 .25689 L p .58559 .25479 L F P
0 g
s
.564 .004 0 r
.58699 .25689 m .61093 .26248 L p .59813 .2586 L F P
0 g
s
.564 .004 0 r
.58559 .25479 m .58699 .25689 L .59813 .2586 L F
.494 0 0 r
.53593 .24404 m .56217 .25317 L .56109 .25052 L F
.534 0 0 r
.56217 .25317 m .54965 .25129 L p .58559 .25479 L F P
0 g
s
.534 0 0 r
.54965 .25129 m .5803 .2468 L .58184 .24912 L F
.564 .004 0 r
.56954 .24428 m .5749 .25407 L p .58559 .25479 L F P
0 g
s
.564 .004 0 r
.58184 .24912 m .58559 .25479 L .59843 .25565 L F
.56954 .24428 m .58559 .25479 L .58184 .24912 L F
.534 0 0 r
.58184 .24912 m .5803 .2468 L .58202 .24911 L F
.59138 .24848 m .59944 .25876 L .58699 .25689 L p F P
0 g
s
.534 0 0 r
.58184 .24912 m .59138 .24848 L .58699 .25689 L F
0 .475 .738 r
.5749 .25407 m .58854 .25709 L .58783 .257 L F
.58699 .25689 m .5749 .25407 L p .58783 .257 L F P
0 g
s
0 .496 .712 r
.58699 .25689 m .59944 .25876 L p .58783 .257 L F P
0 g
s
.564 .004 0 r
.59843 .25565 m .61093 .26248 L .60839 .25956 L F
.581 .011 0 r
.59944 .25876 m .60839 .25956 L .60899 .26025 L F
.61093 .26248 m .59944 .25876 L p .60899 .26025 L F P
0 g
s
.581 .011 0 r
.59944 .25876 m .60757 .25863 L .60839 .25956 L F
.59944 .25876 m .59138 .24848 L .60162 .2518 L p F P
0 g
s
.581 .011 0 r
.59944 .25876 m .60162 .2518 L .60716 .25863 L F
0 .496 .712 r
.59944 .25876 m .60365 .25931 L p .58927 .25718 L F P
0 g
s
0 .475 .738 r
.5749 .25407 m .58026 .2546 L p .59315 .25763 L F P
0 g
s
0 .475 .738 r
.5749 .25407 m .59368 .25773 L .58854 .25709 L F
.494 0 0 r
.56217 .25317 m .5749 .25407 L p .56109 .25052 L F P
0 g
s
0 .496 .712 r
.5794 .25572 m .58699 .25689 L .58783 .257 L F
.534 0 0 r
.54965 .25129 m .56109 .25052 L .56134 .25114 L F
.54965 .25129 m .56134 .25114 L .56189 .25248 L F
.061 0 0 r
.5777 .25435 m .5749 .25407 L .56217 .25317 L p F P
0 g
s
0 .496 .712 r
.5637 .25333 m .57548 .25514 L .5794 .25572 L F
.061 0 0 r
.56352 .25331 m .5777 .25435 L .56217 .25317 L F
0 .496 .712 r
.56352 .25331 m .57548 .25514 L .5637 .25333 L F
.551 .2514 m .54965 .25129 L .56217 .25317 L p F P
0 g
s
0 .496 .712 r
.56217 .25317 m .58699 .25689 L p .56352 .25331 L F P
0 g
s
0 .496 .712 r
.551 .2514 m .56217 .25317 L .56352 .25331 L F
.061 0 0 r
.58026 .2546 m .5777 .25435 L p .5637 .25333 L F P
0 g
s
.061 0 0 r
.56243 .25324 m .56384 .25335 L .5637 .25333 L F
.56384 .25335 m .58026 .2546 L .5637 .25333 L F
.53697 .25139 m .5637 .25333 L .53682 .25136 L F
.5637 .25333 m .5777 .25435 L .56352 .25331 L F
.5637 .25333 m .56352 .25331 L .53682 .25136 L F
0 .496 .712 r
.55223 .2515 m .551 .2514 L p .5637 .25333 L F P
0 g
s
0 .496 .712 r
.5649 .25346 m .5637 .25333 L .58783 .257 L F
.061 0 0 r
.55596 .2528 m .56505 .25348 L .56243 .25324 L F
.56505 .25348 m .58026 .2546 L .56384 .25335 L F
.56505 .25348 m .56384 .25335 L .56243 .25324 L F
0 .496 .712 r
.56505 .25348 m .58783 .257 L .58854 .25709 L F
.55223 .2515 m .5649 .25346 L .56505 .25348 L F
.5649 .25346 m .58783 .257 L .56505 .25348 L F
.55223 .2515 m .5637 .25333 L .5649 .25346 L F
.494 0 0 r
.53682 .25136 m .56217 .25317 L p .54923 .25125 L F P
0 g
s
.494 0 0 r
.53658 .24938 m .53682 .25136 L .54923 .25125 L F
.061 0 0 r
.56217 .25317 m .53682 .25136 L p .54993 .25232 L F P
0 g
s
.061 0 0 r
.53697 .25139 m .55596 .2528 L .56243 .25324 L F
0 0 0 r
.51132 .25151 m .48604 .25361 L p .48818 .25347 L F P
0 g
s
.444 0 0 r
.51177 .24891 m .54707 .24179 L .51132 .25151 L F
.384 0 0 r
.48947 .24611 m .48604 .25361 L .51167 .24952 L F
.51177 .24891 m .51167 .24952 L .51387 .24917 L F
.48947 .24611 m .51167 .24952 L .51177 .24891 L F
.444 0 0 r
.51177 .24891 m .53566 .24186 L .53593 .24404 L F
.4985 .25159 m .51192 .24807 L .51177 .24891 L F
.51192 .24807 m .53566 .24186 L .51177 .24891 L F
.311 0 0 r
.49945 .24863 m .4985 .25159 L .48604 .25361 L p F P
0 g
s
.311 0 0 r
.48604 .25361 m .46134 .25763 L p .47429 .25457 L F P
0 g
s
.311 0 0 r
.47429 .25457 m .49945 .24863 L .48604 .25361 L F
0 0 0 r
.48604 .25361 m .47334 .25467 L p .48501 .25372 L F P
0 g
s
.311 0 0 r
.4633 .25485 m .50157 .24206 L .46134 .25763 L F
.46393 .25396 m .49049 .24387 L .4633 .25485 L F
.384 0 0 r
.47919 .24482 m .47334 .25467 L .48604 .25361 L p F P
0 g
s
.384 0 0 r
.47919 .24482 m .48604 .25361 L .48947 .24611 L F
.13 .676 .716 r
.48604 .25361 m .4985 .25159 L p .48567 .25365 L F P
0 g
s
.13 .676 .716 r
.47271 .25574 m .48604 .25361 L .48567 .25365 L F
.223 0 0 r
.46134 .25763 m .47334 .25467 L p .4633 .25485 L F P
0 g
s
.223 .742 .744 r
.47029 .25498 m .47334 .25467 L .46134 .25763 L p F P
0 g
s
.223 0 0 r
.44511 .25519 m .46134 .25763 L .4633 .25485 L F
.311 0 0 r
.46134 .25763 m .44896 .25965 L p .4633 .25485 L F P
0 g
s
.13 .676 .716 r
.44896 .25965 m .46134 .25763 L p .4589 .25795 L F P
0 g
s
.223 .742 .744 r
.44803 .26078 m .4589 .25795 L .46134 .25763 L F
.4589 .25795 m .47029 .25498 L .46134 .25763 L F
.116 0 0 r
.4516 .25643 m .44896 .25965 L p .4433 .26062 L F P
0 g
s
.116 0 0 r
.42749 .26613 m .4516 .25643 L .43759 .2635 L F
.45748 .24927 m .4516 .25643 L p .43963 .26125 L F P
0 g
s
.311 0 0 r
.44896 .25965 m .46393 .25396 L .4633 .25485 L F
.44896 .25965 m .45748 .24927 L .4685 .24747 L p F P
0 g
s
.311 0 0 r
.44896 .25965 m .4685 .24747 L .46393 .25396 L F
.13 .676 .716 r
.44045 .26078 m .44896 .25965 L p .4589 .25795 L F P
0 g
s
.223 .742 .744 r
.4675 .25526 m .47029 .25498 L p .45858 .25799 L F P
0 g
s
.223 .742 .744 r
.45612 .2583 m .4675 .25526 L .45858 .25799 L F
.13 .676 .716 r
.44045 .26078 m .4589 .25795 L .45612 .2583 L F
.116 0 0 r
.44896 .25965 m .43759 .2635 L p .4433 .26062 L F P
0 g
s
.116 0 0 r
.41844 .26794 m .45748 .24927 L .41512 .27111 L F
.41951 .26693 m .44735 .25271 L .41844 .26794 L F
0 0 0 r
.40533 .27067 m .39422 .28033 L .41766 .26869 L F
.40533 .27067 m .41766 .26869 L .41844 .26794 L F
.116 0 0 r
.40388 .27491 m .41727 .26293 L .4273 .25952 L p F P
0 g
s
.116 0 0 r
.4273 .25952 m .44735 .25271 L p .41951 .26693 L F P
0 g
s
.116 0 0 r
.40388 .27491 m .4273 .25952 L .41951 .26693 L F
0 0 0 r
.41844 .26794 m .41766 .26869 L .41968 .26769 L F
.223 0 0 r
.4257 .26643 m .43758 .26338 L p .43675 .25534 L F P
0 g
s
.223 .742 .744 r
.43759 .2635 m .4257 .26643 L p .43637 .26369 L F P
0 g
s
.116 0 0 r
.43759 .2635 m .41512 .27111 L p .42749 .26613 L F P
0 g
s
0 0 0 r
.41968 .26769 m .41766 .26869 L .4257 .26643 L F
.41512 .27111 m .4257 .26643 L p .41766 .26869 L F P
0 g
s
0 0 0 r
.41844 .26794 m .4257 .26643 L .4273 .25952 L F
.433 .872 .815 r
.41993 .26741 m .4257 .26643 L .41512 .27111 L p F P
0 g
s
0 0 0 r
.41766 .26869 m .40605 .27446 L .41512 .27111 L F
.116 0 0 r
.41512 .27111 m .40682 .2735 L p .41844 .26794 L F P
0 g
s
0 0 0 r
.37967 .2873 m .38927 .28108 L .37519 .29103 L F
.38927 .28108 m .41727 .26293 L .39149 .28014 L F
.38927 .28108 m .39149 .28014 L .37519 .29103 L F
.326 .809 .779 r
.40388 .27491 m .41512 .27111 L p .40807 .27314 L F P
0 g
s
0 0 0 r
.39931 .27193 m .39422 .28033 L .40533 .27067 L F
.41727 .26293 m .40388 .27491 L .39422 .28033 L p F P
0 g
s
0 0 0 r
.40418 .27167 m .41727 .26293 L .39422 .28033 L F
.116 0 0 r
.40388 .27491 m .41951 .26693 L .41844 .26794 L F
.326 .809 .779 r
.3969 .27637 m .40388 .27491 L p .40807 .27314 L F P
0 g
s
.326 .809 .779 r
.41512 .27111 m .43759 .2635 L p .4245 .26764 L F P
0 g
s
.433 .872 .815 r
.41097 .27192 m .41993 .26741 L .41512 .27111 L F
.326 .809 .779 r
.41097 .27192 m .41512 .27111 L .4245 .26764 L F
.3969 .27637 m .41512 .27111 L .41097 .27192 L F
0 0 0 r
.39422 .28033 m .41512 .27111 L p .40605 .27446 L F P
0 g
s
.433 .872 .815 r
.40242 .27621 m .41097 .27192 L .41512 .27111 L F
0 0 0 r
.38379 .28494 m .39422 .28033 L p .3954 .2784 L F P
0 g
s
0 0 0 r
.39931 .27193 m .3886 .28091 L p .3954 .2784 L F P
0 g
s
0 0 0 r
.3886 .28091 m .38379 .28494 L p .3954 .2784 L F P
0 g
s
0 0 0 r
.38379 .28494 m .39931 .27193 L .3916 .27738 L p F P
0 g
s
0 0 0 r
.3916 .27738 m .37639 .28815 L p .38111 .2861 L F P
0 g
s
0 0 0 r
.38111 .2861 m .38379 .28494 L .3916 .27738 L F
.38309 .28217 m .3916 .27738 L p .38285 .28379 L F P
0 g
s
0 0 0 r
.37222 .29156 m .38379 .28494 L .37639 .28815 L F
.36569 .29636 m .37924 .28531 L p .38285 .28379 L F P
0 g
s
0 0 0 r
.37924 .28531 m .38309 .28217 L p .38285 .28379 L F P
0 g
s
0 0 0 r
.36569 .29636 m .3916 .27738 L .38111 .2861 L F
.326 .809 .779 r
.39052 .27771 m .3969 .27637 L p .41042 .27203 L F P
0 g
s
0 0 0 r
.3916 .27738 m .39931 .27193 L p .39598 .27377 L F P
0 g
s
.326 .809 .779 r
.39052 .27771 m .41042 .27203 L .40673 .27275 L F
.433 .872 .815 r
.41467 .26831 m .41993 .26741 L p .41042 .27203 L F P
0 g
s
.326 .809 .779 r
.39052 .27771 m .40673 .27275 L .40625 .27284 L F
.223 0 0 r
.43675 .25534 m .43759 .2635 L .44511 .25519 L F
.326 .809 .779 r
.43759 .2635 m .44896 .25965 L p .43637 .26369 L F P
0 g
s
.326 .809 .779 r
.3969 .27637 m .41097 .27192 L .41042 .27203 L F
.433 .872 .815 r
.39422 .28033 m .38379 .28494 L p .39242 .28076 L F P
0 g
s
.538 .925 .847 r
.39089 .28112 m .39262 .28071 L .40388 .27491 L F
.39422 .28033 m .40388 .27491 L p .39262 .28071 L F P
0 g
s
.633 .964 .872 r
.36888 .29277 m .37571 .28696 L .36961 .29256 L F
.538 .925 .847 r
.34838 .30143 m .36569 .29636 L p .36961 .29256 L F P
0 g
s
.633 .964 .872 r
.36833 .28881 m .37571 .28696 L p .36888 .29277 L F P
0 g
s
.633 .964 .872 r
.36392 .29414 m .36833 .28881 L .36888 .29277 L F
.538 .925 .847 r
.34838 .30143 m .36961 .29256 L .36327 .29431 L F
.713 .985 .887 r
.35824 .30301 m .36569 .29636 L p .35405 .30435 L F P
0 g
s
.713 .985 .887 r
.36569 .29636 m .34838 .30143 L .34019 .30877 L p F P
0 g
s
.775 .989 .892 r
.33091 .31536 m .3498 .30898 L .34358 .3161 L p F P
0 g
s
.775 .989 .892 r
.32936 .32129 m .33091 .31536 L .34358 .3161 L F
.633 .964 .872 r
.35824 .30301 m .3498 .30898 L p .35597 .30373 L F P
0 g
s
.713 .985 .887 r
.3161 .33039 m .33628 .32261 L .34358 .3161 L p F P
0 g
s
.713 .985 .887 r
.35405 .30435 m .36569 .29636 L .34019 .30877 L F
.538 .925 .847 r
.35885 .29553 m .34838 .30143 L p .36327 .29431 L F P
0 g
s
.633 .964 .872 r
.3498 .30898 m .33091 .31536 L .34019 .30877 L p F P
0 g
s
.637 .612 .808 r
.36274 .26844 m .38279 .24551 L .36591 .2736 L F
0 0 0 r
.39001 .27708 m .39931 .27193 L .39382 .27398 L F
.38309 .28217 m .39698 .27295 L .39598 .27377 L F
.39382 .27398 m .40696 .26472 L .39403 .27382 L F
.40696 .26472 m .40703 .26466 L .39403 .27382 L F
.744 .956 .942 r
.40153 .26841 m .39999 .26851 L .39403 .27382 L p F P
0 g
s
.513 .854 .586 r
.39001 .27708 m .39403 .27382 L .39829 .26997 L F
.39403 .27382 m .39999 .26851 L p .39829 .26997 L F P
0 g
s
.65 .947 .955 r
.39999 .26851 m .402 .26809 L .40274 .26757 L F
.39999 .26851 m .40153 .26841 L p .402 .26809 L F P
0 g
s
0 0 0 r
.38309 .28217 m .39919 .26915 L p .40696 .26472 L F P
0 g
s
0 0 0 r
.38309 .28217 m .40696 .26472 L .39698 .27295 L F
.68 .788 .932 r
.37965 .28054 m .37756 .28205 L .39052 .27771 L F
.673 .787 .935 r
.36833 .28881 m .35416 .27975 L p .3665 .27402 L F P
0 g
s
.673 .787 .935 r
.36833 .28881 m .3665 .27402 L .37659 .28134 L F
.633 .964 .872 r
.36756 .28964 m .34974 .3021 L .36833 .28881 L F
.35885 .29553 m .36833 .28881 L p .34974 .3021 L F P
0 g
s
.633 .964 .872 r
.3498 .30898 m .34019 .30877 L .36756 .28964 L F
.36568 .29169 m .36833 .28881 L .36617 .29141 L F
.36568 .29169 m .36617 .29141 L .35597 .30373 L F
.35405 .30435 m .36568 .29169 L .35597 .30373 L F
.68 .788 .932 r
.37986 .28371 m .39052 .27771 L p .37756 .28205 L F P
0 g
s
.538 .925 .847 r
.40388 .27491 m .39052 .27771 L .37986 .28371 L p F P
0 g
s
.433 .872 .815 r
.38379 .28494 m .36833 .28881 L .37986 .28371 L p F P
0 g
s
.538 .925 .847 r
.38974 .28139 m .40388 .27491 L .37986 .28371 L F
.433 .872 .815 r
.38379 .28494 m .37986 .28371 L .39089 .28112 L F
0 0 0 r
.37861 .28818 m .36851 .29553 L .37519 .29103 L F
.35824 .30301 m .37519 .29103 L p .36851 .29553 L F P
0 g
s
.538 .925 .847 r
.37519 .29103 m .39422 .28033 L p .38211 .28636 L F P
0 g
s
0 0 0 r
.37519 .29103 m .36569 .29636 L p .37298 .29163 L F P
0 g
s
0 0 0 r
.37887 .28796 m .37791 .28844 L p .37967 .2873 L F P
0 g
s
0 0 0 r
.38037 .2869 m .37861 .28818 L .38379 .28494 L F
.37519 .29103 m .38379 .28494 L p .37861 .28818 L F P
0 g
s
0 0 0 r
.36569 .29636 m .38111 .2861 L .37967 .2873 L F
.37967 .2873 m .37861 .28818 L .38037 .2869 L F
.633 .964 .872 r
.37571 .28696 m .38379 .28494 L .37519 .29103 L p F P
0 g
s
.633 .964 .872 r
.36961 .29256 m .37571 .28696 L .37519 .29103 L F
.538 .925 .847 r
.36961 .29256 m .37519 .29103 L .38211 .28636 L F
.36569 .29636 m .37519 .29103 L p .36961 .29256 L F P
0 g
s
.633 .964 .872 r
.37519 .29103 m .35824 .30301 L p .36961 .29256 L F P
0 g
s
.538 .925 .847 r
.36327 .29431 m .40388 .27491 L .35885 .29553 L F
.666 .785 .937 r
.39052 .27771 m .40296 .27349 L p .38044 .2667 L F P
0 g
s
.326 .809 .779 r
.40296 .27349 m .39052 .27771 L p .40625 .27284 L F P
0 g
s
.433 .872 .815 r
.39089 .28112 m .38027 .28361 L .40308 .27347 L F
.40625 .27284 m .40308 .27347 L .41467 .26831 L F
.39089 .28112 m .40308 .27347 L .40625 .27284 L F
.40296 .27349 m .41467 .26831 L p .38027 .28361 L F P
0 g
s
.433 .872 .815 r
.41042 .27203 m .41993 .26741 L .41097 .27192 L F
.223 .742 .744 r
.4257 .26643 m .43533 .26386 L .43637 .26369 L F
.433 .872 .815 r
.40625 .27284 m .41467 .26831 L .41042 .27203 L F
.116 0 0 r
.44433 .25605 m .45748 .24927 L .43963 .26125 L F
0 0 0 r
.4257 .26643 m .43675 .25534 L .4273 .25952 L p F P
0 g
s
.223 .742 .744 r
.4257 .26643 m .41467 .26831 L .42785 .26505 L p F P
0 g
s
.326 .809 .779 r
.43455 .26398 m .44896 .25965 L .42785 .26505 L F
.223 .742 .744 r
.4257 .26643 m .42785 .26505 L .43533 .26386 L F
.326 .809 .779 r
.40625 .27284 m .44896 .25965 L .40296 .27349 L F
.43533 .26386 m .43637 .26369 L .44896 .25965 L F
.223 .742 .744 r
.45419 .25855 m .4675 .25526 L p .45612 .2583 L F P
0 g
s
.223 .742 .744 r
.43637 .26369 m .47029 .25498 L .43759 .2635 L F
0 0 0 r
.47334 .25467 m .48159 .25409 L .48501 .25372 L F
.384 0 0 r
.51167 .24952 m .49899 .25155 L .51132 .25151 L F
.48604 .25361 m .51132 .25151 L p .49899 .25155 L F P
0 g
s
.013 0 0 r
.4985 .25159 m .51132 .25151 L p .49804 .25171 L F P
0 g
s
.013 0 0 r
.51132 .25151 m .53682 .25136 L p .52403 .25148 L F P
0 g
s
.13 .676 .716 r
.4554 .25836 m .4985 .25159 L .48159 .25409 L F
.45612 .2583 m .4985 .25159 L .45419 .25855 L F
.47504 .25535 m .47271 .25574 L .48567 .25365 L F
.47504 .25535 m .48567 .25365 L .48554 .25367 L F
.46134 .25763 m .48604 .25361 L p .47271 .25574 L F P
0 g
s
.13 .676 .716 r
.46551 .25681 m .4589 .25795 L .4985 .25159 L F
0 0 0 r
.48159 .25409 m .50966 .25175 L p .48501 .25372 L F P
0 g
s
.013 0 0 r
.51075 .25159 m .51132 .25151 L .52403 .25148 L F
.51017 .25168 m .51069 .2516 L .53697 .25139 L F
0 0 0 r
.48818 .25347 m .51011 .25169 L .51132 .25151 L F
.013 0 0 r
.53682 .25136 m .54965 .25129 L p .53697 .25139 L F P
0 g
s
.013 0 0 r
.49804 .25171 m .53682 .25136 L .53697 .25139 L F
.51011 .25169 m .53697 .25139 L .53709 .25141 L F
.51017 .25168 m .53697 .25139 L .51011 .25169 L F
.53798 .25159 m .51319 .25173 L p .53722 .25144 L F P
0 g
s
0 .496 .712 r
.56535 .25351 m .58558 .25663 L .58989 .25726 L F
.56505 .25348 m .58558 .25663 L .56535 .25351 L F
.061 0 0 r
.56613 .25359 m .58026 .2546 L p .56505 .25348 L F P
0 g
s
0 .496 .712 r
.55223 .2515 m .58989 .25726 L .59349 .2577 L F
.59368 .25773 m .56613 .25359 L p .59349 .2577 L F P
0 g
s
0 .496 .712 r
.56613 .25359 m .55223 .2515 L p .59349 .2577 L F P
0 g
s
.494 0 0 r
.5749 .25407 m .56954 .24428 L .55821 .24347 L p F P
0 g
s
.494 0 0 r
.56109 .25052 m .5749 .25407 L .55821 .24347 L F
.633 .765 .942 r
.58026 .2546 m .56613 .25359 L p .56676 .25142 L F P
0 g
s
.061 0 0 r
.53798 .25159 m .56613 .25359 L p .56508 .25351 L F P
0 g
s
.061 0 0 r
.53709 .25141 m .53798 .25159 L .56508 .25351 L F
.013 0 0 r
.54832 .2513 m .54965 .25129 L .54836 .2513 L F
.061 0 0 r
.53709 .25141 m .56613 .25359 L .56505 .25348 L F
.53709 .25141 m .55596 .2528 L .53697 .25139 L F
.013 0 0 r
.54832 .2513 m .54836 .2513 L .51319 .25173 L F
0 0 0 r
.48501 .25372 m .50966 .25175 L .51011 .25169 L F
.13 .676 .716 r
.49542 .25184 m .48159 .25409 L p .48206 .25402 L F P
0 g
s
.13 .676 .716 r
.4985 .25159 m .49542 .25184 L p .48206 .25402 L F P
0 g
s
.13 .676 .716 r
.48554 .25367 m .48567 .25365 L .4985 .25159 L F
.013 0 0 r
.49542 .25184 m .53607 .25145 L .51333 .25173 L F
.49542 .25184 m .54832 .2513 L .53607 .25145 L F
0 0 0 r
.51011 .25169 m .52381 .25058 L .51132 .25151 L F
.013 0 0 r
.49763 .25181 m .51017 .25168 L .51011 .25169 L F
.49763 .25181 m .49804 .25171 L .51069 .2516 L F
.49763 .25181 m .51069 .2516 L .51017 .25168 L F
0 0 0 r
.50966 .25175 m .52381 .25058 L p .51011 .25169 L F P
0 g
s
.013 0 0 r
.49804 .25171 m .51132 .25151 L .51075 .25159 L F
.444 0 0 r
.51132 .25151 m .5104 .25152 L p .51137 .2512 L F P
0 g
s
.444 0 0 r
.5104 .25152 m .4985 .25159 L p .51137 .2512 L F P
0 g
s
.444 0 0 r
.4985 .25159 m .51177 .24891 L .51137 .2512 L F
0 0 0 r
.52381 .25058 m .52406 .25045 L .51132 .25151 L p F P
0 g
s
.384 0 0 r
.51387 .24917 m .51167 .24952 L .52406 .25045 L F
.51132 .25151 m .52406 .25045 L p .51167 .24952 L F P
0 g
s
.444 0 0 r
.51298 .24199 m .53566 .24186 L p .51192 .24807 L F P
0 g
s
.384 0 0 r
.52406 .25045 m .52431 .24105 L .51298 .24199 L p F P
0 g
s
.384 0 0 r
.51177 .24891 m .52406 .25045 L .51298 .24199 L F
.645 .775 .942 r
.52375 .24722 m .52381 .25058 L .50966 .25175 L p F P
0 g
s
.013 0 0 r
.50966 .25175 m .49542 .25184 L p .51333 .25173 L F P
0 g
s
.013 0 0 r
.49542 .25184 m .49555 .25183 L p .49763 .25181 L F P
0 g
s
.013 0 0 r
.49555 .25183 m .4985 .25159 L p .49763 .25181 L F P
0 g
s
.444 0 0 r
.4985 .25159 m .50157 .24206 L .51298 .24199 L p F P
0 g
s
.444 0 0 r
.4985 .25159 m .51298 .24199 L .51192 .24807 L F
.639 .77 .942 r
.49542 .25184 m .50966 .25175 L p .5094 .24956 L F P
0 g
s
.311 0 0 r
.50157 .24206 m .49945 .24863 L p .48697 .25158 L F P
0 g
s
.639 .77 .942 r
.49468 .24851 m .49542 .25184 L p .5094 .24956 L F P
0 g
s
.223 0 0 r
.4633 .25485 m .47334 .25467 L .46393 .25396 L F
.47334 .25467 m .47919 .24482 L .4685 .24747 L p F P
0 g
s
.223 0 0 r
.46441 .254 m .47334 .25467 L .4685 .24747 L F
.645 .775 .942 r
.4675 .25526 m .48058 .25102 L .48133 .25328 L F
.311 0 0 r
.48911 .24688 m .50157 .24206 L .48697 .25158 L F
.652 .779 .941 r
.48159 .25409 m .49542 .25184 L p .48058 .25102 L F P
0 g
s
.645 .775 .942 r
.50936 .24927 m .52375 .24722 L .5094 .24956 L F
.5094 .24956 m .52375 .24722 L .50966 .25175 L F
.061 0 0 r
.52406 .25045 m .53798 .25159 L .53709 .25141 L F
.52406 .25045 m .53709 .25141 L .53697 .25139 L F
.013 0 0 r
.53709 .25141 m .53697 .25139 L .54965 .25129 L F
0 .496 .712 r
.551 .2514 m .56352 .25331 L .5637 .25333 L F
.013 0 0 r
.54965 .25129 m .55223 .2515 L .53798 .25159 L p F P
0 g
s
.013 0 0 r
.53722 .25144 m .54965 .25129 L .53798 .25159 L F
.444 0 0 r
.54707 .24179 m .54965 .25129 L .53682 .25136 L p F P
0 g
s
.639 .77 .942 r
.53798 .25159 m .55223 .2515 L p .53805 .25076 L F P
0 g
s
.061 0 0 r
.52406 .25045 m .52381 .25058 L .53798 .25159 L p F P
0 g
s
.061 0 0 r
.53682 .25136 m .52406 .25045 L p .53697 .25139 L F P
0 g
s
.444 0 0 r
.5241 .25043 m .53658 .24938 L .53682 .25136 L F
.494 0 0 r
.52431 .24105 m .52406 .25045 L .53682 .25136 L p F P
0 g
s
.494 0 0 r
.52431 .24105 m .53682 .25136 L .53593 .24404 L F
.444 0 0 r
.53602 .24479 m .54707 .24179 L .53682 .25136 L F
.633 .765 .942 r
.52381 .25058 m .53825 .24845 L .53804 .25086 L F
.381 0 0 r
.51298 .24199 m .52431 .24105 L p .51342 .23949 L F P
0 g
s
.381 0 0 r
.51342 .23949 m .52431 .24105 L .51356 .23869 L F
.52431 .24105 m .52454 .23249 L p .51453 .23319 L F P
0 g
s
.381 0 0 r
.51356 .23869 m .52431 .24105 L .51453 .23319 L F
.645 .775 .942 r
.50936 .24927 m .52265 .23786 L .52375 .24722 L F
.491 0 0 r
.52629 .23254 m .53479 .23485 L .53254 .23273 L F
.53479 .23485 m .53461 .23337 L .53254 .23273 L F
.442 0 0 r
.53454 .23279 m .54458 .23273 L p .53455 .23289 L F P
0 g
s
.442 0 0 r
.5044 .23339 m .51458 .23291 L .51452 .23322 L F
.381 0 0 r
.51453 .23319 m .52454 .23249 L .51458 .23291 L F
.491 0 0 r
.53454 .23279 m .52455 .23207 L p .53455 .23289 L F P
0 g
s
.442 0 0 r
.53479 .23485 m .53656 .23286 L .54292 .23309 L F
.53461 .23337 m .53656 .23286 L .53479 .23485 L F
.531 0 0 r
.54707 .24179 m .54469 .23315 L p .5545 .2345 L F P
0 g
s
.491 0 0 r
.53254 .23273 m .53461 .23337 L .53455 .23289 L F
.442 0 0 r
.53461 .23337 m .53455 .23289 L .53656 .23286 L F
.381 0 0 r
.49381 .23668 m .51298 .24199 L .51342 .23949 L F
.442 0 0 r
.50157 .24206 m .5044 .23339 L p .51452 .23322 L F P
0 g
s
.442 0 0 r
.50157 .24206 m .51452 .23322 L .51352 .23892 L F
.54292 .23309 m .53656 .23286 L .54458 .23273 L F
.381 0 0 r
.52454 .23249 m .52455 .23207 L .51458 .23291 L p F P
0 g
s
.442 0 0 r
.5044 .23339 m .50454 .23297 L .51458 .23291 L p F P
0 g
s
.491 0 0 r
.52455 .23207 m .52629 .23254 L .53254 .23273 L F
.561 0 0 r
.59262 .24158 m .56435 .23493 L p .59293 .24194 L F P
0 g
s
.561 0 0 r
.5753 .23935 m .59914 .24899 L .57425 .23778 L F
.59914 .24899 m .59858 .24835 L .57425 .23778 L F
.57425 .23778 m .59858 .24835 L .57391 .23727 L F
.59858 .24835 m .59839 .24813 L .57391 .23727 L F
.57391 .23727 m .59839 .24813 L .59293 .24194 L F
.233 .704 .942 r
.58288 .23892 m .58359 .23864 L .57383 .23716 L p F P
0 g
s
.531 0 0 r
.5753 .23935 m .58359 .23864 L .57582 .24012 L F
.5753 .23935 m .57582 .24012 L .55821 .24347 L F
.561 0 0 r
.57448 .23902 m .5803 .2468 L .5753 .23935 L F
.56435 .23493 m .56954 .24428 L .5803 .2468 L p F P
0 g
s
.561 0 0 r
.56435 .23493 m .5803 .2468 L .57448 .23902 L F
.578 .007 0 r
.58396 .2391 m .59262 .24158 L .59293 .24194 L F
.561 0 0 r
.5753 .23935 m .57425 .23778 L .57199 .2368 L F
.531 0 0 r
.58359 .23864 m .59138 .24848 L .5803 .2468 L p F P
0 g
s
.531 0 0 r
.57582 .24012 m .58359 .23864 L .5803 .2468 L F
.54469 .23315 m .55438 .23421 L .5545 .2345 L F
.491 0 0 r
.55451 .23454 m .56459 .23537 L .55438 .23421 L F
.578 .007 0 r
.59138 .24848 m .58396 .2391 L p .59293 .24194 L F P
0 g
s
.531 0 0 r
.5753 .23935 m .57383 .23716 L .58219 .23876 L F
.561 0 0 r
.57199 .2368 m .57425 .23778 L .57391 .23727 L F
.531 0 0 r
.54707 .24179 m .5545 .2345 L .55682 .2401 L F
.491 0 0 r
.56954 .24428 m .56459 .23537 L p .55451 .23454 L F P
0 g
s
.491 0 0 r
.55683 .24015 m .56954 .24428 L .55451 .23454 L F
.26 .734 .938 r
.56435 .23493 m .56388 .23525 L p .56313 .23517 L F P
0 g
s
.491 0 0 r
.56459 .23537 m .56435 .23493 L .55438 .23421 L p F P
0 g
s
.531 0 0 r
.54469 .23315 m .54458 .23273 L .55438 .23421 L p F P
0 g
s
.531 0 0 r
.57383 .23716 m .58359 .23864 L p .58219 .23876 L F P
0 g
s
.561 0 0 r
.56435 .23493 m .56621 .23568 L .57199 .2368 L F
.578 .007 0 r
.58396 .2391 m .58359 .23864 L .59262 .24158 L p F P
0 g
s
.627 .759 .941 r
.5572 .2391 m .56895 .24394 L .56998 .24039 L F
.494 0 0 r
.53566 .24186 m .52431 .24105 L p .53593 .24404 L F P
0 g
s
.633 .765 .942 r
.52381 .25058 m .52358 .23782 L p .53907 .23874 L F P
0 g
s
.444 0 0 r
.53566 .24186 m .54707 .24179 L p .53593 .24404 L F P
0 g
s
.633 .765 .942 r
.52381 .25058 m .53907 .23874 L .53833 .24743 L F
.534 0 0 r
.56017 .24975 m .55821 .24347 L .56074 .24966 L F
.491 0 0 r
.55821 .24347 m .56954 .24428 L p .55743 .241 L F P
0 g
s
.534 0 0 r
.54965 .25129 m .54707 .24179 L .55821 .24347 L p F P
0 g
s
.534 0 0 r
.54965 .25129 m .55821 .24347 L .56017 .24975 L F
.491 0 0 r
.55715 .24092 m .56954 .24428 L .55691 .24034 L F
.531 0 0 r
.55821 .24347 m .54707 .24179 L p .55715 .24092 L F P
0 g
s
.491 0 0 r
.55691 .24034 m .56954 .24428 L .55683 .24015 L F
.633 .765 .942 r
.56895 .24394 m .56993 .24058 L .57304 .24077 L F
.58 .003 0 r
.61049 .24741 m .60204 .2438 L p .61062 .24753 L F P
0 g
s
.58 .003 0 r
.60392 .24484 m .61308 .2499 L .6089 .24679 L F
.218 .677 .947 r
.60204 .2438 m .6011 .24401 L p .60043 .24382 L F P
0 g
s
.561 0 0 r
.61231 .25431 m .60252 .24429 L p .59293 .24194 L F P
0 g
s
.58 .003 0 r
.60204 .2438 m .60392 .24484 L .6089 .24679 L F
.732 .681 .801 r
.61488 .24795 m .63352 .24011 L .62958 .25094 L F
.602 .24451 m .63491 .2363 L .61488 .24795 L F
.743 .693 .803 r
.63491 .2363 m .64324 .25588 L .65567 .25951 L F
.63352 .24011 m .64324 .25588 L .63491 .2363 L F
.63567 .23422 m .65681 .26078 L .6594 .25534 L F
.561 0 0 r
.59293 .24194 m .60252 .24429 L .59262 .24158 L F
.60252 .24429 m .60204 .2438 L .59262 .24158 L p F P
0 g
s
.732 .681 .801 r
.60167 .23916 m .63567 .23422 L .60018 .24496 L F
.63567 .23422 m .63491 .2363 L .60018 .24496 L F
.793 .704 .767 r
.7038 .23164 m .69654 .24745 L .72068 .26369 L F
.70491 .22923 m .72068 .26369 L .72414 .25738 L F
.778 .686 .762 r
.67037 .23083 m .70491 .22923 L .66781 .23769 L F
.70491 .22923 m .7038 .23164 L .66781 .23769 L F
.66781 .23769 m .7038 .23164 L .69654 .24745 L F
.75 .654 .755 r
.60666 .2194 m .64428 .20589 L .63878 .2251 L F
.60793 .21308 m .64428 .20589 L .60666 .2194 L F
.561 0 0 r
.59839 .24813 m .61231 .25431 L .59293 .24194 L F
.578 .007 0 r
.59138 .24848 m .59293 .24194 L .59858 .24835 L F
.743 .693 .803 r
.63352 .24011 m .62958 .25094 L .64324 .25588 L F
.559 0 0 r
.62003 .25085 m .6272 .25454 L .62768 .25496 L F
.58 .003 0 r
.62763 .25491 m .63625 .25869 L .6272 .25454 L F
.559 0 0 r
.63202 .26167 m .62003 .25085 L p .62768 .25496 L F P
0 g
s
.58 .003 0 r
.63625 .25869 m .63556 .25811 L .6272 .25454 L p F P
0 g
s
.559 0 0 r
.62003 .25085 m .61944 .25032 L .6272 .25454 L p F P
0 g
s
.618 .747 .938 r
.62638 .25103 m .62684 .25506 L .62914 .25197 L F
.61732 .24861 m .62684 .25506 L .62638 .25103 L F
.578 .007 0 r
.61049 .24741 m .61944 .25032 L p .61062 .24753 L F P
0 g
s
.58 .003 0 r
.61128 .24817 m .61123 .24812 L .6089 .24679 L F
.561 0 0 r
.59914 .24899 m .61231 .25431 L .59858 .24835 L F
.59858 .24835 m .61231 .25431 L .59839 .24813 L F
.578 .007 0 r
.61308 .2499 m .61239 .24809 L .61836 .25025 L F
.61123 .24812 m .61239 .24809 L .61308 .2499 L F
.58 .003 0 r
.61308 .2499 m .61128 .24817 L .6089 .24679 L F
.578 .007 0 r
.61123 .24812 m .61062 .24753 L .61239 .24809 L F
.58 .003 0 r
.6089 .24679 m .61123 .24812 L .61062 .24753 L F
.578 .007 0 r
.61836 .25025 m .61239 .24809 L .61944 .25032 L F
.627 .759 .941 r
.60749 .2598 m .61488 .24795 L p .59994 .24544 L F P
0 g
s
.534 0 0 r
.5803 .2468 m .59138 .24848 L p .58202 .24911 L F P
0 g
s
.578 .007 0 r
.60162 .2518 m .59138 .24848 L p .59914 .24899 L F P
0 g
s
.578 .007 0 r
.59138 .24848 m .59858 .24835 L .59914 .24899 L F
.622 .753 .94 r
.58026 .2546 m .58519 .24224 L p .59991 .2455 L F P
0 g
s
.622 .753 .94 r
.58026 .2546 m .59991 .2455 L .5952 .25474 L F
.627 .759 .941 r
.59572 .25371 m .60749 .2598 L .59994 .24544 L F
.59994 .24544 m .61488 .24795 L .60018 .24496 L F
.732 .681 .801 r
.63491 .2363 m .63352 .24011 L .61488 .24795 L F
.743 .693 .803 r
.62958 .25094 m .62927 .2518 L .64324 .25588 L F
.732 .681 .801 r
.64435 .25395 m .64382 .25522 L .62927 .2518 L p F P
0 g
s
.622 .753 .94 r
.62914 .25197 m .62927 .2518 L .63208 .25262 L F
.618 .747 .938 r
.62638 .25103 m .62914 .25197 L .62927 .2518 L F
.732 .681 .801 r
.61488 .24795 m .62958 .25094 L .62927 .2518 L F
.583 .007 0 r
.61231 .25431 m .62552 .26192 L .62458 .26101 L F
.61231 .25431 m .63365 .26983 L .62552 .26192 L F
.235 .614 .955 r
.61944 .25032 m .61829 .25045 L p .61899 .25077 L F P
0 g
s
.578 .007 0 r
.61399 .25078 m .61944 .25032 L .62188 .25838 L F
.563 0 0 r
.65191 .27624 m .66184 .27892 L .67421 .28929 L F
.65101 .27544 m .66184 .27892 L .65191 .27624 L F
.583 .007 0 r
.64081 .26643 m .61231 .25431 L p .65101 .27544 L F P
0 g
s
.583 .007 0 r
.62458 .26101 m .64985 .27594 L .65101 .27544 L F
.62552 .26192 m .64985 .27594 L .62458 .26101 L F
.514 0 0 r
.66184 .27892 m .69154 .30109 L .68667 .29709 L F
.563 0 0 r
.64501 .27351 m .63202 .26167 L .65814 .27583 L p F P
0 g
s
.563 0 0 r
.64501 .27351 m .65814 .27583 L .66184 .27892 L F
.514 0 0 r
.65026 .27046 m .66312 .28 L .66184 .27892 L F
.66312 .28 m .69154 .30109 L .66184 .27892 L F
.67368 .28642 m .65026 .27046 L p .68667 .29709 L F P
0 g
s
.563 0 0 r
.65814 .27583 m .6668 .28052 L p .66184 .27892 L F P
0 g
s
.583 .007 0 r
.66542 .28331 m .65026 .27046 L .64081 .26643 L p F P
0 g
s
.583 .007 0 r
.65101 .27544 m .66542 .28331 L .64081 .26643 L F
.563 0 0 r
.64998 .27511 m .65101 .27544 L .65191 .27624 L F
.618 .747 .938 r
.61532 .24725 m .60749 .2598 L .62023 .26393 L p F P
0 g
s
0 .496 .712 r
.58854 .25709 m .59944 .25876 L .58927 .25718 L F
0 .463 .772 r
.60749 .2598 m .60365 .25931 L p .61452 .26304 L F P
0 g
s
0 .463 .772 r
.60749 .2598 m .61452 .26304 L .61689 .26341 L F
0 .496 .712 r
.58854 .25709 m .58783 .257 L .59944 .25876 L F
0 .475 .738 r
.61452 .26304 m .62846 .26619 L .6141 .26297 L F
0 .463 .772 r
.60365 .25931 m .59944 .25876 L .61093 .26248 L p F P
0 g
s
0 .463 .772 r
.60365 .25931 m .61093 .26248 L .6141 .26297 L F
0 .475 .738 r
.60032 .25988 m .6141 .26297 L .61093 .26248 L F
.6141 .26297 m .62846 .26619 L .61093 .26248 L F
0 .463 .772 r
.61093 .26248 m .63365 .26983 L p .6141 .26297 L F P
0 g
s
0 .463 .772 r
.60749 .2598 m .61689 .26341 L .61771 .26354 L F
.581 .011 0 r
.64501 .27351 m .63365 .26983 L p .63327 .26795 L F P
0 g
s
.581 .011 0 r
.63202 .26167 m .64099 .26984 L p .63327 .26795 L F P
0 g
s
.581 .011 0 r
.64099 .26984 m .64501 .27351 L p .63327 .26795 L F P
0 g
s
0 .463 .772 r
.63365 .26983 m .64501 .27351 L p .63512 .27011 L F P
0 g
s
.583 .007 0 r
.63365 .26983 m .65484 .27882 L p .64291 .27308 L F P
0 g
s
.563 0 0 r
.65484 .27882 m .65191 .27624 L .66296 .28271 L F
.67421 .28929 m .65484 .27882 L p .66296 .28271 L F P
0 g
s
.583 .007 0 r
.65484 .27882 m .66133 .28107 L p .65101 .27544 L F P
0 g
s
.514 0 0 r
.67556 .28923 m .67421 .28929 L .68486 .29614 L F
.66312 .28 m .67086 .28649 L .67556 .28923 L F
.67086 .28649 m .67421 .28929 L .67556 .28923 L F
0 .092 .568 r
.67368 .28642 m .6668 .28052 L p .66886 .28249 L F P
0 g
s
0 .092 .568 r
.6668 .28052 m .66782 .28165 L .66891 .28254 L F
0 .088 .564 r
.68388 .29452 m .6668 .28052 L .67368 .28642 L p F P
0 g
s
0 .088 .564 r
.68388 .29452 m .67368 .28642 L .68504 .29574 L F
.563 0 0 r
.6668 .28052 m .68388 .29452 L .67421 .28929 L p F P
0 g
s
0 .457 .842 r
.67793 .2903 m .67555 .28966 L .68388 .29452 L F
.67421 .28929 m .68388 .29452 L p .67555 .28966 L F P
0 g
s
.563 0 0 r
.66184 .27892 m .6668 .28052 L .67421 .28929 L F
.514 0 0 r
.67354 .28883 m .67421 .28929 L p .66278 .27975 L F P
0 g
s
.514 0 0 r
.66278 .27975 m .67421 .28929 L .66312 .28 L F
.65026 .27046 m .66542 .28331 L .67354 .28883 L p F P
0 g
s
.514 0 0 r
.65026 .27046 m .67354 .28883 L .66278 .27975 L F
.006 .459 .868 r
.67421 .28929 m .66542 .28331 L p .67555 .28966 L F P
0 g
s
0 .457 .842 r
.66707 .2847 m .67421 .28929 L .67555 .28966 L F
.006 .459 .868 r
.67555 .28966 m .68573 .29604 L .67421 .28929 L F
0 .458 .808 r
.67332 .28524 m .66542 .28331 L p .66199 .2813 L F P
0 g
s
0 .458 .808 r
.65961 .27991 m .67332 .28524 L .65484 .27882 L F
.563 0 0 r
.64501 .27351 m .64998 .27511 L .65191 .27624 L F
.65484 .27882 m .64501 .27351 L p .65191 .27624 L F P
0 g
s
0 .457 .842 r
.65797 .27615 m .64501 .27351 L .65484 .27882 L p F P
0 g
s
0 .458 .808 r
.68052 .287 m .67332 .28524 L p .66024 .28006 L F P
0 g
s
0 .458 .808 r
.66449 .28103 m .68052 .287 L .66024 .28006 L F
.006 .459 .868 r
.66542 .28331 m .67793 .2903 L .67555 .28966 L F
0 .458 .808 r
.66542 .28331 m .65484 .27882 L p .66199 .2813 L F P
0 g
s
0 .458 .808 r
.66504 .28116 m .68052 .287 L .66449 .28103 L F
0 .457 .842 r
.65797 .27615 m .65484 .27882 L .66504 .28116 L F
.581 .011 0 r
.62458 .26101 m .63202 .26167 L .63365 .26983 L F
0 .458 .808 r
.63365 .26983 m .62292 .26528 L p .63512 .27011 L F P
0 g
s
0 .458 .808 r
.63512 .27011 m .67332 .28524 L .63365 .26983 L F
.62292 .26528 m .63637 .27035 L .63512 .27011 L F
0 .463 .772 r
.63402 .26949 m .62793 .26764 L .63512 .27011 L F
.63637 .27035 m .63512 .27011 L .64501 .27351 L F
.63402 .26949 m .63512 .27011 L .63637 .27035 L F
.006 .459 .868 r
.66542 .28331 m .68052 .287 L .69022 .29362 L p F P
0 g
s
0 .457 .842 r
.68388 .29452 m .70088 .2994 L .69022 .29362 L p F P
0 g
s
0 .457 .842 r
.67921 .29065 m .68388 .29452 L .69022 .29362 L F
.006 .459 .868 r
.67921 .29065 m .69022 .29362 L .70811 .30602 L F
.66542 .28331 m .69022 .29362 L .67921 .29065 L F
0 .457 .842 r
.66883 .28203 m .65797 .27615 L p .66504 .28116 L F P
0 g
s
0 .458 .808 r
.62292 .26528 m .63352 .26703 L .64539 .27207 L p F P
0 g
s
.612 .734 .932 r
.66111 .27344 m .65797 .27615 L .66883 .28203 L p F P
0 g
s
0 .458 .808 r
.6782 .28612 m .65696 .27703 L .68052 .287 L F
.66883 .28203 m .68052 .287 L p .65696 .27703 L F P
0 g
s
0 .463 .772 r
.64501 .27351 m .65797 .27615 L .64539 .27207 L p F P
0 g
s
0 .463 .772 r
.63637 .27035 m .64501 .27351 L .64539 .27207 L F
0 .458 .808 r
.63637 .27035 m .64539 .27207 L .6782 .28612 L F
.62292 .26528 m .64539 .27207 L .63637 .27035 L F
0 .475 .738 r
.63352 .26703 m .62846 .26619 L p .61452 .26304 L F P
0 g
s
0 .475 .738 r
.61689 .26341 m .63352 .26703 L .61452 .26304 L F
0 .463 .772 r
.60365 .25931 m .6141 .26297 L .61452 .26304 L F
0 .475 .738 r
.59468 .2585 m .61734 .26348 L .59718 .25912 L F
.61734 .26348 m .63352 .26703 L .61689 .26341 L F
.61734 .26348 m .61689 .26341 L .59718 .25912 L F
.61771 .26354 m .62014 .26391 L .63352 .26703 L F
0 .463 .772 r
.62023 .26393 m .60749 .2598 L p .61771 .26354 L F P
0 g
s
0 .496 .712 r
.60749 .2598 m .59368 .25773 L p .58989 .25726 L F P
0 g
s
0 .496 .712 r
.60365 .25931 m .60749 .2598 L p .58558 .25663 L F P
0 g
s
0 .475 .738 r
.62023 .26393 m .63352 .26703 L p .59349 .2577 L F P
0 g
s
0 .475 .738 r
.58854 .25709 m .63352 .26703 L .58783 .257 L F
0 .463 .772 r
.64539 .27207 m .62023 .26393 L p .63637 .27035 L F P
0 g
s
0 .463 .772 r
.61771 .26354 m .63637 .27035 L .62023 .26393 L F
.61 .728 .929 r
.68052 .287 m .69436 .27777 L p .70574 .28451 L F P
0 g
s
.61 .728 .929 r
.68052 .287 m .70574 .28451 L .69385 .29149 L F
.69022 .29362 m .68052 .287 L p .69385 .29149 L F P
0 g
s
.75 .654 .755 r
.63799 .22784 m .60647 .22033 L p .63869 .22541 L F P
0 g
s
.764 .67 .758 r
.63799 .22784 m .66781 .23769 L p .64354 .20847 L F P
0 g
s
.75 .654 .755 r
.63869 .22541 m .65495 .22797 L .63799 .22784 L F
.60666 .2194 m .65495 .22797 L .60647 .22033 L F
.72 .626 .752 r
.57371 .21531 m .54021 .21288 L p .57639 .1925 L F P
0 g
s
.711 .66 .797 r
.54085 .23745 m .57239 .22417 L .57012 .23948 L F
.735 .639 .753 r
.57607 .19519 m .574 .21279 L .60647 .22033 L F
.722 .67 .799 r
.57271 .22199 m .57012 .2395 L .60047 .24383 L F
.60167 .23916 m .60047 .24383 L .61243 .24554 L F
.57271 .22199 m .60047 .24383 L .60167 .23916 L F
.735 .639 .753 r
.57371 .21531 m .60647 .22033 L p .55746 .20894 L F P
0 g
s
.722 .67 .799 r
.60647 .22033 m .57371 .21531 L p .60217 .23716 L F P
0 g
s
.732 .681 .801 r
.60647 .22033 m .63799 .22784 L p .60167 .23916 L F P
0 g
s
.743 .693 .803 r
.66781 .23769 m .63799 .22784 L p .6594 .25534 L F P
0 g
s
.743 .693 .803 r
.63567 .23422 m .6594 .25534 L .63799 .22784 L F
.732 .681 .801 r
.63799 .22784 m .65376 .23159 L p .63567 .23422 L F P
0 g
s
.732 .681 .801 r
.60167 .23916 m .63799 .22784 L .63567 .23422 L F
.743 .693 .803 r
.63799 .22784 m .62288 .22284 L p .63567 .23422 L F P
0 g
s
.722 .67 .799 r
.57271 .22199 m .61532 .24725 L .57371 .21531 L F
.732 .681 .801 r
.58548 .24151 m .59052 .21653 L .60647 .22033 L p F P
0 g
s
.732 .681 .801 r
.58548 .24151 m .60647 .22033 L .60167 .23916 L F
.711 .66 .797 r
.53937 .23222 m .59052 .21653 L .53911 .23818 L F
.688 .641 .798 r
.476 .2334 m .47371 .21966 L .50657 .21436 L F
.308 0 0 r
.46533 .2398 m .47543 .23775 L .47519 .23809 L F
.45748 .24927 m .46533 .2398 L p .47519 .23809 L F P
0 g
s
.308 0 0 r
.46533 .2398 m .46572 .23934 L .47543 .23775 L p F P
0 g
s
.219 0 0 r
.44744 .24471 m .45389 .24556 L .45464 .24474 L F
.44744 .24471 m .43675 .25534 L .44735 .25271 L p F P
0 g
s
.219 0 0 r
.44744 .24471 m .44735 .25271 L .45389 .24556 L F
.44866 .24472 m .45464 .24474 L .45678 .24239 L F
.112 0 0 r
.45617 .24305 m .45667 .24251 L .45849 .24187 L F
.308 0 0 r
.47012 .24489 m .50454 .23297 L .4685 .24747 L F
.47085 .24418 m .4967 .23433 L .47041 .24479 L F
.219 0 0 r
.47919 .24482 m .48458 .23584 L p .47522 .23805 L F P
0 g
s
.219 0 0 r
.47102 .24393 m .47919 .24482 L .47522 .23805 L F
.308 0 0 r
.45748 .24927 m .47519 .23809 L .47099 .24398 L F
.112 0 0 r
.46384 .24026 m .45849 .24187 L .46572 .23934 L F
.219 0 0 r
.45678 .24239 m .44744 .24471 L p .44866 .24472 L F P
0 g
s
.591 .93 .955 r
.4391 .24842 m .44744 .24471 L p .44606 .2458 L F P
0 g
s
0 0 0 r
.44694 .24521 m .44744 .24471 L .4391 .24842 L p F P
0 g
s
.676 .633 .799 r
.44229 .22786 m .44698 .24499 L .47711 .24005 L F
.44698 .24499 m .44722 .24587 L .46213 .24297 L F
.44698 .24499 m .46213 .24297 L .47711 .24005 L F
.7 .65 .797 r
.5069 .21982 m .50799 .23746 L .53916 .23702 L F
.50799 .23746 m .50805 .23837 L .52358 .23782 L F
.50799 .23746 m .52358 .23782 L .55149 .23685 L F
.442 0 0 r
.51298 .24199 m .50157 .24206 L p .51342 .23949 L F P
0 g
s
.442 0 0 r
.50157 .24206 m .51352 .23892 L .51342 .23949 L F
.645 .775 .942 r
.50848 .24196 m .50807 .23855 L .52356 .23707 L F
.531 0 0 r
.54707 .24179 m .55682 .2401 L .55715 .24092 L F
.639 .77 .942 r
.55223 .2515 m .5546 .23884 L p .53907 .23874 L F P
0 g
s
.639 .77 .942 r
.53833 .24743 m .55223 .2515 L .53907 .23874 L F
.633 .765 .942 r
.52381 .25058 m .53833 .24743 L .53825 .24845 L F
.645 .775 .942 r
.52358 .23782 m .52375 .24722 L p .52265 .23786 L F P
0 g
s
.645 .775 .942 r
.50858 .24282 m .52356 .23707 L .50936 .24927 L F
.311 0 0 r
.49049 .24387 m .50157 .24206 L p .48947 .24611 L F P
0 g
s
.308 0 0 r
.50454 .23297 m .50157 .24206 L .49049 .24387 L p F P
0 g
s
.308 0 0 r
.49422 .23712 m .50454 .23297 L .49049 .24387 L F
.381 0 0 r
.48484 .2354 m .49049 .24387 L .49381 .23668 L F
.639 .77 .942 r
.49352 .23916 m .49468 .24851 L .50936 .24927 L F
.7 .65 .797 r
.50657 .21436 m .53944 .23055 L .54004 .21667 L F
.711 .66 .797 r
.54021 .21288 m .59052 .21653 L p .53937 .23222 L F P
0 g
s
.7 .65 .797 r
.5069 .21982 m .55474 .23809 L .50657 .21436 L F
.689 .6 .752 r
.47308 .21591 m .5055 .19282 L .50636 .21054 L F
.47211 .20857 m .50536 .19012 L .47308 .21591 L F
.704 .613 .752 r
.50536 .19012 m .54021 .21288 L .54046 .20547 L F
.5055 .19282 m .54021 .21288 L .50536 .19012 L F
.72 .626 .752 r
.54046 .20547 m .57639 .1925 L .54021 .21288 L F
.704 .613 .752 r
.54128 .18162 m .50496 .18185 L p .54055 .20293 L F P
0 g
s
.72 .626 .752 r
.54128 .18162 m .57736 .18428 L p .54046 .20547 L F P
0 g
s
.72 .626 .752 r
.54046 .20547 m .57736 .18428 L .57639 .1925 L F
.735 .639 .753 r
.61263 .18977 m .55955 .18151 L p .60793 .21308 L F P
0 g
s
.72 .626 .752 r
.57736 .18428 m .59547 .18562 L p .57639 .1925 L F P
0 g
s
.735 .639 .753 r
.57639 .1925 m .60647 .22033 L .60793 .21308 L F
.55955 .18151 m .57607 .19519 L .57639 .1925 L F
.57607 .19519 m .60647 .22033 L .57639 .1925 L F
.704 .613 .752 r
.50536 .19012 m .55717 .21278 L .50496 .18185 L F
.5055 .19282 m .50636 .21054 L .54021 .21288 L F
.72 .626 .752 r
.52333 .21165 m .5231 .18028 L .54128 .18162 L p F P
0 g
s
.72 .626 .752 r
.52333 .21165 m .54128 .18162 L .54046 .20547 L F
.704 .613 .752 r
.55717 .21278 m .55955 .18151 L .54128 .18162 L p F P
0 g
s
.704 .613 .752 r
.54055 .20293 m .55717 .21278 L .54128 .18162 L F
.672 .589 .753 r
.43565 .19893 m .47308 .21591 L .47211 .20857 L F
.46898 .18495 m .4339 .19086 L p .47211 .20857 L F P
0 g
s
.672 .589 .753 r
.43565 .19893 m .47211 .20857 L .4339 .19086 L F
.655 .577 .756 r
.40028 .19947 m .45092 .1865 L p .40711 .22215 L F P
0 g
s
.655 .577 .756 r
.40711 .22215 m .43565 .19893 L .40923 .2292 L F
.43565 .19893 m .43622 .20156 L .40923 .2292 L F
.40923 .2292 m .43622 .20156 L .43996 .21885 L F
.637 .567 .759 r
.42417 .22403 m .41634 .19382 L .40028 .19947 L p F P
0 g
s
.637 .567 .759 r
.40028 .19947 m .3686 .21061 L p .40638 .21973 L F P
0 g
s
.637 .567 .759 r
.40638 .21973 m .42417 .22403 L .40028 .19947 L F
.37156 .21823 m .42417 .22403 L .3686 .21061 L F
.655 .577 .756 r
.3936 .23314 m .38347 .20377 L .40028 .19947 L p F P
0 g
s
.655 .577 .756 r
.3936 .23314 m .40028 .19947 L .40711 .22215 L F
.672 .589 .753 r
.4339 .19086 m .41634 .19382 L p .43565 .19893 L F P
0 g
s
.655 .577 .756 r
.43565 .19893 m .45092 .1865 L .43622 .20156 L F
.689 .6 .752 r
.45631 .21734 m .45092 .1865 L .46898 .18495 L p F P
0 g
s
.689 .6 .752 r
.46898 .18495 m .50496 .18185 L p .47177 .20606 L F P
0 g
s
.689 .6 .752 r
.45631 .21734 m .46898 .18495 L .47177 .20606 L F
.45631 .21734 m .50496 .18185 L .50536 .19012 L F
.50536 .19012 m .5055 .19282 L .47308 .21591 L F
.672 .589 .753 r
.48953 .21318 m .48669 .18196 L .46898 .18495 L p F P
0 g
s
.672 .589 .753 r
.47211 .20857 m .48953 .21318 L .46898 .18495 L F
.704 .613 .752 r
.50496 .18185 m .48669 .18196 L p .50536 .19012 L F P
0 g
s
.689 .6 .752 r
.50496 .18185 m .5231 .18028 L p .50536 .19012 L F P
0 g
s
.689 .6 .752 r
.50536 .19012 m .5231 .18028 L .5055 .19282 L F
.704 .613 .752 r
.48669 .18196 m .5055 .19282 L .50536 .19012 L F
.48669 .18196 m .48919 .20936 L p .50636 .21054 L F P
0 g
s
.704 .613 .752 r
.48669 .18196 m .50636 .21054 L .5055 .19282 L F
.689 .6 .752 r
.5231 .18028 m .5233 .20781 L p .50636 .21054 L F P
0 g
s
.689 .6 .752 r
.5055 .19282 m .5231 .18028 L .50636 .21054 L F
.704 .613 .752 r
.50649 .21308 m .54021 .21288 L p .50636 .21054 L F P
0 g
s
.689 .6 .752 r
.50649 .21308 m .47308 .21591 L p .50636 .21054 L F P
0 g
s
.704 .613 .752 r
.48919 .20936 m .50649 .21308 L .50636 .21054 L F
.689 .6 .752 r
.50636 .21054 m .5233 .20781 L .50649 .21308 L F
.7 .65 .797 r
.54021 .21288 m .50649 .21308 L p .55668 .21782 L F P
0 g
s
.688 .641 .798 r
.47308 .21591 m .50649 .21308 L p .47364 .21925 L F P
0 g
s
.663 .625 .801 r
.41562 .24585 m .4106 .23277 L .44084 .22256 L F
.651 .618 .804 r
.38279 .24551 m .41805 .25219 L .41622 .24742 L F
.623 .606 .812 r
.33182 .27148 m .34246 .28587 L .36529 .27259 L F
.33182 .27148 m .36529 .27259 L .36274 .26844 L F
.35248 .25174 m .32777 .26599 L p .36165 .26667 L F P
0 g
s
.623 .606 .812 r
.33182 .27148 m .36274 .26844 L .32777 .26599 L F
.637 .612 .808 r
.36274 .26844 m .37976 .23941 L .38279 .24551 L F
.36165 .26667 m .37976 .23941 L .36274 .26844 L F
.623 .606 .812 r
.36274 .26844 m .37755 .26699 L .36165 .26667 L F
.36274 .26844 m .36165 .26667 L .32777 .26599 L F
.637 .612 .808 r
.35333 .27921 m .36165 .26667 L .36274 .26844 L F
.598 .547 .768 r
.32777 .26599 m .35248 .25174 L p .31681 .24658 L F P
0 g
s
.598 .547 .768 r
.35248 .25174 m .36504 .2445 L p .35972 .24473 L F P
0 g
s
.618 .557 .763 r
.37156 .21823 m .37252 .22072 L .35248 .25174 L F
.598 .547 .768 r
.31681 .24658 m .35248 .25174 L .34936 .24518 L F
.33934 .22407 m .31287 .2396 L p .34829 .24293 L F P
0 g
s
.618 .557 .763 r
.33934 .22407 m .38347 .20377 L p .34936 .24518 L F P
0 g
s
.598 .547 .768 r
.31681 .24658 m .36504 .2445 L .31287 .2396 L F
.618 .557 .763 r
.33888 .25789 m .32476 .23077 L .33934 .22407 L p F P
0 g
s
.618 .557 .763 r
.33888 .25789 m .33934 .22407 L .34936 .24518 L F
.598 .547 .768 r
.34936 .24518 m .35248 .25174 L .35972 .24473 L F
.637 .612 .808 r
.35333 .27921 m .34176 .26213 L p .35248 .25174 L F P
0 g
s
.637 .612 .808 r
.34176 .26213 m .33888 .25789 L .35248 .25174 L p F P
0 g
s
.637 .612 .808 r
.35248 .25174 m .37976 .23941 L p .36165 .26667 L F P
0 g
s
.637 .612 .808 r
.35333 .27921 m .35248 .25174 L .36165 .26667 L F
.623 .606 .812 r
.36274 .26844 m .36529 .27259 L .3744 .2673 L F
.651 .618 .804 r
.37269 .24494 m .38335 .24664 L .38279 .24551 L F
.38335 .24664 m .41805 .25219 L .38279 .24551 L F
.663 .625 .801 r
.41622 .24742 m .44084 .22256 L .44229 .22786 L F
.618 .557 .763 r
.37976 .23941 m .35248 .25174 L p .39236 .22954 L F P
0 g
s
.651 .618 .804 r
.40923 .2292 m .36504 .2445 L p .41622 .24742 L F P
0 g
s
.663 .625 .801 r
.40395 .25664 m .41562 .24585 L .41622 .24742 L F
.41562 .24585 m .44084 .22256 L .41622 .24742 L F
.655 .577 .756 r
.4405 .22132 m .40923 .2292 L p .45565 .21356 L F P
0 g
s
.676 .633 .799 r
.47308 .21591 m .4405 .22132 L p .47628 .23505 L F P
0 g
s
.663 .625 .801 r
.40923 .2292 m .4405 .22132 L p .39566 .23782 L F P
0 g
s
.663 .625 .801 r
.39566 .23782 m .4405 .22132 L .44084 .22256 L F
.676 .633 .799 r
.4405 .22132 m .42417 .22403 L p .44229 .22786 L F P
0 g
s
.676 .633 .799 r
.44229 .22786 m .47628 .23505 L .4405 .22132 L F
.663 .625 .801 r
.4405 .22132 m .45631 .21734 L p .44084 .22256 L F P
0 g
s
.219 0 0 r
.47522 .23805 m .48458 .23584 L .47543 .23775 L F
.48458 .23584 m .48484 .2354 L .47543 .23775 L p F P
0 g
s
.676 .633 .799 r
.44229 .22786 m .47711 .24005 L .47628 .23505 L F
.663 .625 .801 r
.45631 .21734 m .46181 .24224 L .44722 .24587 L p F P
0 g
s
.639 .77 .942 r
.49259 .23921 m .49468 .24851 L p .49352 .23916 L F P
0 g
s
.381 0 0 r
.48484 .2354 m .47919 .24482 L .49049 .24387 L p F P
0 g
s
.381 0 0 r
.48636 .23562 m .49381 .23668 L .49478 .23457 L F
.308 0 0 r
.49451 .23517 m .49473 .23468 L .4967 .23433 L F
.381 0 0 r
.49478 .23457 m .48484 .2354 L p .48636 .23562 L F P
0 g
s
.308 0 0 r
.50272 .2336 m .4967 .23433 L .50454 .23297 L F
.223 0 0 r
.46393 .25396 m .46441 .254 L .4685 .24747 L F
.308 0 0 r
.4685 .24747 m .45748 .24927 L p .47012 .24489 L F P
0 g
s
.308 0 0 r
.45748 .24927 m .47085 .24418 L .47041 .24479 L F
.219 0 0 r
.4685 .24747 m .47919 .24482 L p .47041 .24479 L F P
0 g
s
.308 0 0 r
.45748 .24927 m .47099 .24398 L .47085 .24418 L F
.219 0 0 r
.47041 .24479 m .47919 .24482 L .47102 .24393 L F
.645 .775 .942 r
.4675 .25526 m .46213 .24297 L p .47744 .2415 L F P
0 g
s
.384 0 0 r
.48926 .24608 m .48947 .24611 L .49049 .24387 L F
.49049 .24387 m .47919 .24482 L p .48926 .24608 L F P
0 g
s
.652 .779 .941 r
.49542 .25184 m .49259 .23921 L p .47744 .2415 L F P
0 g
s
.652 .779 .941 r
.48058 .25102 m .49542 .25184 L .47744 .2415 L F
.688 .641 .798 r
.47711 .24005 m .5069 .21982 L .50799 .23746 L F
.49259 .23921 m .50799 .23746 L .50805 .23837 L F
.47711 .24005 m .50799 .23746 L .49259 .23921 L F
.639 .77 .942 r
.49243 .23846 m .49751 .23957 L .50807 .23855 L F
.50281 .24072 m .50848 .24196 L .50807 .23855 L F
.49243 .23846 m .50936 .24927 L .50848 .24196 L F
.645 .775 .942 r
.48025 .25001 m .47744 .2415 L .50807 .23855 L F
.4675 .25526 m .47744 .2415 L .48025 .25001 L F
0 0 0 r
.43869 .24881 m .44694 .24521 L .4391 .24842 L F
.43675 .25534 m .44694 .24521 L p .43869 .24881 L F P
0 g
s
0 0 0 r
.40864 .26779 m .39931 .27193 L p .40521 .2707 L F P
0 g
s
0 0 0 r
.41436 .25941 m .39931 .27193 L .40864 .26779 L p F P
0 g
s
0 0 0 r
.41436 .25941 m .40864 .26779 L .41943 .25849 L F
.39919 .26915 m .40752 .26425 L .40696 .26472 L F
.40696 .26472 m .41365 .26 L .40703 .26466 L F
.40703 .26466 m .41365 .26 L .40752 .26425 L F
.41365 .26 m .41436 .25941 L .40752 .26425 L p F P
0 g
s
0 0 0 r
.39919 .26915 m .39999 .26851 L .40752 .26425 L p F P
0 g
s
.673 .787 .935 r
.40102 .27166 m .40227 .25814 L .41148 .2657 L F
.39522 .26619 m .40227 .25814 L .40102 .27166 L F
0 0 0 r
.40864 .26779 m .41727 .26293 L p .40533 .27067 L F P
0 g
s
.673 .787 .935 r
.41467 .26831 m .40296 .27349 L p .41148 .2657 L F P
0 g
s
0 0 0 r
.40521 .2707 m .40533 .27067 L .40864 .26779 L F
.673 .787 .935 r
.40102 .27166 m .41148 .2657 L .40296 .27349 L F
.666 .785 .937 r
.38044 .2667 m .40296 .27349 L .39431 .26533 L F
.68 .788 .932 r
.37659 .28134 m .37756 .28205 L .37965 .28054 L F
.666 .785 .937 r
.37827 .26759 m .39052 .27771 L p .38044 .2667 L F P
0 g
s
.68 .788 .932 r
.39052 .27771 m .37827 .26759 L p .3665 .27402 L F P
0 g
s
.687 .789 .928 r
.34725 .289 m .34525 .28523 L .35227 .28091 L F
.623 .606 .812 r
.34246 .28587 m .34301 .28661 L .35416 .27975 L F
.34246 .28587 m .35416 .27975 L .3744 .2673 L F
.687 .789 .928 r
.35333 .27921 m .36833 .28881 L .35885 .29553 L p F P
0 g
s
.609 .601 .818 r
.33254 .29355 m .33557 .27654 L .34246 .28587 L F
.32326 .29971 m .33888 .25789 L .33254 .29355 L F
.68 .788 .932 r
.33417 .29247 m .35885 .29553 L .34766 .28923 L F
.609 .601 .818 r
.33254 .29355 m .35255 .27806 L .34301 .28661 L F
.68 .788 .932 r
.3316 .29309 m .33304 .29322 L .33417 .29247 L F
.33304 .29322 m .35885 .29553 L .33417 .29247 L F
.609 .601 .818 r
.35255 .27806 m .35333 .27921 L .34301 .28661 L p F P
0 g
s
.687 .789 .928 r
.34725 .289 m .35333 .27921 L .35885 .29553 L F
.673 .787 .935 r
.37986 .28371 m .36833 .28881 L p .37659 .28134 L F P
0 g
s
.68 .788 .932 r
.34725 .289 m .37756 .28205 L .37659 .28134 L F
.3316 .29309 m .34766 .28923 L .34725 .289 L F
.34766 .28923 m .37756 .28205 L .34725 .289 L F
.34838 .30143 m .35885 .29553 L p .33304 .29322 L F P
0 g
s
.68 .788 .932 r
.33254 .29355 m .34838 .30143 L p .33304 .29322 L F P
0 g
s
.68 .788 .932 r
.3316 .29309 m .34725 .289 L .34323 .28674 L F
.687 .789 .928 r
.31364 .30878 m .32272 .30116 L .32337 .30144 L F
.693 .788 .924 r
.32345 .30148 m .33254 .29355 L .32272 .30116 L F
.687 .789 .928 r
.34301 .28661 m .35333 .27921 L p .34323 .28674 L F P
0 g
s
.673 .787 .935 r
.35416 .27975 m .36591 .2736 L .3665 .27402 L F
.68 .788 .932 r
.36591 .2736 m .3316 .29309 L p .37827 .26759 L F P
0 g
s
.687 .789 .928 r
.31364 .30878 m .34301 .28661 L .34323 .28674 L F
.698 .787 .92 r
.31031 .31867 m .30695 .31536 L .31222 .31018 L F
.578 .594 .832 r
.29769 .32519 m .29356 .30549 L .30462 .31637 L F
.29097 .33243 m .29356 .30549 L .29769 .32519 L F
.693 .788 .924 r
.30374 .31866 m .30553 .31709 L .30527 .31701 L F
.594 .597 .825 r
.292 .30395 m .30462 .31637 L .32194 .30027 L F
.30462 .31637 m .30527 .31701 L .31364 .30878 L F
.609 .601 .818 r
.31875 .29661 m .33888 .25789 L .32272 .30116 L F
.594 .597 .825 r
.30462 .31637 m .31364 .30878 L .32887 .29384 L F
.698 .787 .92 r
.30527 .31701 m .31263 .30839 L p .30553 .31709 L F P
0 g
s
.713 .985 .887 r
.3161 .33039 m .34358 .3161 L .33106 .32067 L F
.3241 .32321 m .3161 .33039 L p .32936 .32129 L F P
0 g
s
.713 .985 .887 r
.3161 .33039 m .35824 .30301 L .35405 .30435 L F
.698 .787 .92 r
.31263 .30839 m .33091 .31536 L .3241 .32321 L p F P
0 g
s
.703 .785 .915 r
.31073 .33863 m .3161 .33039 L p .30607 .33752 L F P
0 g
s
.82 .98 .888 r
.33628 .32261 m .3161 .33039 L .31073 .33863 L p F P
0 g
s
.775 .989 .892 r
.32526 .33705 m .30409 .34629 L .31073 .33863 L p F P
0 g
s
.82 .98 .888 r
.32656 .33208 m .33628 .32261 L .31073 .33863 L F
.775 .989 .892 r
.31073 .33863 m .3241 .32321 L p .3249 .33276 L F P
0 g
s
.775 .989 .892 r
.32526 .33705 m .31073 .33863 L .3249 .33276 L F
.32656 .33208 m .3241 .32321 L .32936 .32129 L F
.32526 .33705 m .3249 .33276 L .32656 .33208 L F
.3249 .33276 m .3241 .32321 L .32656 .33208 L F
.82 .98 .888 r
.33135 .33009 m .33628 .32261 L p .32656 .33208 L F P
0 g
s
.509 .851 .581 r
.34358 .3161 m .33628 .32261 L p .34893 .31169 L F P
0 g
s
.775 .989 .892 r
.34358 .3161 m .32526 .33705 L p .32936 .32129 L F P
0 g
s
.85 .962 .878 r
.30409 .34629 m .32526 .33705 L .32166 .34479 L p F P
0 g
s
.82 .98 .888 r
.29498 .36283 m .31684 .3521 L .32166 .34479 L p F P
0 g
s
.82 .98 .888 r
.29498 .36283 m .32166 .34479 L .30787 .35122 L F
.85 .962 .878 r
.306 .3521 m .30409 .34629 L .32166 .34479 L F
.82 .98 .888 r
.306 .3521 m .33135 .33009 L .32656 .33208 L F
.29498 .36283 m .30787 .35122 L .306 .3521 L F
.30787 .35122 m .33135 .33009 L .306 .3521 L F
.85 .962 .878 r
.30021 .3548 m .30409 .34629 L p .306 .3521 L F P
0 g
s
.82 .98 .888 r
.29663 .36122 m .32656 .33208 L .31132 .33839 L F
.30575 .34662 m .31132 .33839 L .31073 .33863 L F
.29663 .36122 m .31132 .33839 L .30575 .34662 L F
.31073 .33863 m .29498 .36283 L p .29663 .36122 L F P
0 g
s
.711 .78 .906 r
.28599 .37097 m .29498 .36283 L .27229 .36989 L F
.707 .783 .911 r
.2888 .37977 m .27229 .36989 L .28761 .3711 L F
.716 .772 .896 r
.28108 .40586 m .28555 .3969 L .27985 .40594 L F
.711 .78 .906 r
.26407 .39753 m .28555 .3969 L .28788 .38847 L p F P
0 g
s
.711 .78 .906 r
.26407 .39753 m .28788 .38847 L .27221 .38838 L F
.714 .776 .901 r
.28108 .40586 m .26565 .40687 L .2668 .38835 L F
.27221 .38838 m .2668 .38835 L .26739 .37886 L F
.28108 .40586 m .2668 .38835 L .27221 .38838 L F
.85 .962 .878 r
.31107 .36754 m .2888 .37977 L .29258 .37149 L p F P
0 g
s
.867 .938 .865 r
.31684 .3521 m .29498 .36283 L .29258 .37149 L p F P
0 g
s
.85 .962 .878 r
.31107 .36754 m .29258 .37149 L .3077 .36359 L F
.867 .938 .865 r
.30947 .36266 m .31684 .3521 L .29258 .37149 L F
.85 .962 .878 r
.30947 .36266 m .30021 .3548 L .306 .3521 L F
.31107 .36754 m .3077 .36359 L .30947 .36266 L F
.3077 .36359 m .30021 .3548 L .30947 .36266 L F
.867 .938 .865 r
.31458 .35999 m .31684 .3521 L p .30947 .36266 L F P
0 g
s
.85 .962 .878 r
.31107 .36754 m .306 .3521 L .31432 .34822 L F
.91 .979 .778 r
.33895 .33239 m .31684 .3521 L .31458 .35999 L p F P
0 g
s
.85 .962 .878 r
.32166 .34479 m .31458 .35999 L p .31432 .34822 L F P
0 g
s
.85 .962 .878 r
.31458 .35999 m .31107 .36754 L p .31432 .34822 L F P
0 g
s
.93 .949 .779 r
.31014 .37548 m .31107 .36754 L p .31628 .36952 L F P
0 g
s
.93 .949 .779 r
.31598 .36941 m .31107 .36754 L .33271 .35355 L F
.875 .91 .85 r
.2888 .37977 m .31107 .36754 L .31014 .37548 L p F P
0 g
s
.91 .979 .778 r
.30794 .38318 m .31485 .37186 L .31471 .36554 L F
.31014 .37548 m .30794 .38318 L p .31471 .36554 L F P
0 g
s
.867 .938 .865 r
.28555 .3969 m .30794 .38318 L .31014 .37548 L p F P
0 g
s
.875 .91 .85 r
.29389 .38497 m .2888 .37977 L .31014 .37548 L F
.867 .938 .865 r
.31014 .37548 m .31458 .35999 L p .29583 .38384 L F P
0 g
s
.867 .938 .865 r
.28555 .3969 m .31014 .37548 L .29583 .38384 L F
.29389 .38497 m .31458 .35999 L .30947 .36266 L F
.28555 .3969 m .29583 .38384 L .29389 .38497 L F
.29583 .38384 m .31458 .35999 L .29389 .38497 L F
.875 .91 .85 r
.28788 .38847 m .2888 .37977 L p .29389 .38497 L F P
0 g
s
.867 .938 .865 r
.28555 .3969 m .30947 .36266 L .29321 .37116 L F
.29258 .37149 m .28788 .38847 L p .29321 .37116 L F P
0 g
s
.867 .938 .865 r
.28788 .38847 m .28555 .3969 L p .29321 .37116 L F P
0 g
s
.876 .882 .836 r
.30794 .38318 m .28555 .3969 L .28609 .40554 L p F P
0 g
s
.875 .91 .85 r
.30743 .39882 m .2852 .414 L .28609 .40554 L p F P
0 g
s
.876 .882 .836 r
.30315 .39444 m .30794 .38318 L .28609 .40554 L F
.875 .91 .85 r
.28609 .40554 m .28788 .38847 L p .30136 .39561 L F P
0 g
s
.875 .91 .85 r
.30743 .39882 m .28609 .40554 L .30136 .39561 L F
.30315 .39444 m .28788 .38847 L .29389 .38497 L F
.30743 .39882 m .30136 .39561 L .30315 .39444 L F
.30136 .39561 m .28788 .38847 L .30315 .39444 L F
.876 .882 .836 r
.30833 .39108 m .30794 .38318 L p .30315 .39444 L F P
0 g
s
.875 .91 .85 r
.31014 .37548 m .30743 .39882 L p .30198 .39325 L F P
0 g
s
.873 .854 .821 r
.2852 .414 m .30743 .39882 L .3091 .40658 L p F P
0 g
s
.876 .882 .836 r
.28767 .43087 m .30948 .41428 L .3091 .40658 L p F P
0 g
s
.876 .882 .836 r
.28767 .43087 m .3091 .40658 L .29497 .41681 L F
.873 .854 .821 r
.29306 .41819 m .2852 .414 L .3091 .40658 L F
.876 .882 .836 r
.29306 .41819 m .30833 .39108 L .30315 .39444 L F
.28767 .43087 m .29497 .41681 L .29306 .41819 L F
.29497 .41681 m .30833 .39108 L .29306 .41819 L F
.873 .854 .821 r
.28714 .42247 m .2852 .414 L p .29306 .41819 L F P
0 g
s
.876 .882 .836 r
.28847 .42897 m .30315 .39444 L .28672 .40513 L F
.28693 .41383 m .28672 .40513 L .28609 .40554 L F
.28847 .42897 m .28672 .40513 L .28693 .41383 L F
.28609 .40554 m .28767 .43087 L p .28847 .42897 L F P
0 g
s
.718 .763 .887 r
.28647 .43808 m .28757 .43979 L .28767 .43087 L F
.29095 .43908 m .28767 .43087 L p .28757 .43979 L F P
0 g
s
.866 .828 .808 r
.30948 .41428 m .28767 .43087 L .29095 .43908 L p F P
0 g
s
.873 .854 .821 r
.31401 .42937 m .29285 .44733 L .29095 .43908 L p F P
0 g
s
.866 .828 .808 r
.30566 .42723 m .30948 .41428 L .29095 .43908 L F
.873 .854 .821 r
.29095 .43908 m .28714 .42247 L p .30566 .42723 L F P
0 g
s
.873 .854 .821 r
.31401 .42937 m .29095 .43908 L .30566 .42723 L F
.866 .828 .808 r
.29773 .45409 m .30566 .42723 L .29095 .43908 L F
.29095 .43908 m .29741 .45519 L p .29773 .45409 L F P
0 g
s
.718 .767 .892 r
.29095 .43908 m .28748 .43647 L .28735 .43111 L F
.714 .776 .901 r
.28609 .40554 m .2852 .414 L p .28108 .40586 L F P
0 g
s
.716 .772 .896 r
.26679 .43446 m .28767 .43087 L .28555 .3969 L p F P
0 g
s
.718 .767 .892 r
.28714 .42247 m .29095 .43908 L p .28735 .43111 L F P
0 g
s
.718 .767 .892 r
.28748 .43647 m .27173 .42457 L .28714 .42247 L F
.873 .854 .821 r
.31401 .42937 m .30566 .42723 L .30739 .42584 L F
.866 .828 .808 r
.30296 .45019 m .30739 .42584 L .29741 .45519 L F
.30739 .42584 m .30948 .41428 L .30566 .42723 L F
.30739 .42584 m .30566 .42723 L .29741 .45519 L F
.873 .854 .821 r
.30739 .42584 m .28714 .42247 L .29306 .41819 L F
.30566 .42723 m .28714 .42247 L .30739 .42584 L F
.31238 .42181 m .31401 .42937 L p .30739 .42584 L F P
0 g
s
.866 .828 .808 r
.31808 .4366 m .31238 .42181 L p .30296 .45019 L F P
0 g
s
.866 .828 .808 r
.31238 .42181 m .30948 .41428 L p .30739 .42584 L F P
0 g
s
.866 .828 .808 r
.30296 .45019 m .31238 .42181 L .30739 .42584 L F
.873 .854 .821 r
.3091 .40658 m .31238 .42181 L p .29306 .41819 L F P
0 g
s
.873 .854 .821 r
.30739 .42584 m .29306 .41819 L .31238 .42181 L F
.876 .882 .836 r
.3091 .40658 m .30833 .39108 L p .29497 .41681 L F P
0 g
s
.714 .776 .901 r
.28609 .40554 m .28359 .40244 L .28523 .3971 L F
.28788 .38847 m .28609 .40554 L p .28523 .3971 L F P
0 g
s
.714 .776 .901 r
.28359 .40244 m .27221 .38838 L .28788 .38847 L F
.875 .91 .85 r
.30198 .39325 m .29389 .38497 L .31014 .37548 L F
.91 .979 .778 r
.31458 .35999 m .31014 .37548 L p .31471 .36554 L F P
0 g
s
.91 .979 .778 r
.33172 .34424 m .33895 .33239 L .31458 .35999 L F
.785 .985 .728 r
.32756 .33962 m .35214 .31253 L .34735 .31657 L F
.32694 .34034 m .32773 .33947 L .32756 .33962 L F
.32773 .33947 m .35214 .31253 L .32756 .33962 L F
.865 .995 .763 r
.33172 .34424 m .32166 .34479 L .32756 .33962 L F
.33362 .34636 m .32994 .34588 L .33172 .34424 L F
.32994 .34588 m .32166 .34479 L .33172 .34424 L F
.91 .979 .779 r
.33271 .35355 m .33065 .36053 L p .33877 .34769 L F P
0 g
s
.93 .949 .779 r
.33271 .35355 m .33091 .36769 L p .31645 .36935 L F P
0 g
s
.93 .949 .779 r
.31645 .36935 m .31598 .36941 L .33271 .35355 L F
.91 .979 .778 r
.31483 .37093 m .33172 .34424 L .31458 .35999 L F
.31485 .37186 m .31628 .36952 L .31483 .37093 L F
.93 .949 .779 r
.3257 .37309 m .31598 .36941 L .33091 .36769 L F
.91 .979 .778 r
.31628 .36952 m .33172 .34424 L .31483 .37093 L F
.85 .962 .878 r
.3077 .36359 m .29258 .37149 L .30051 .35515 L F
.29258 .37149 m .30021 .3548 L p .30051 .35515 L F P
0 g
s
.714 .776 .901 r
.27221 .38838 m .26823 .38051 L .28788 .38847 L F
.26823 .38051 m .26848 .37937 L .28788 .38847 L F
.707 .783 .911 r
.29258 .37149 m .2888 .37977 L p .28761 .3711 L F P
0 g
s
.711 .78 .906 r
.27221 .38838 m .28435 .38845 L .29498 .36283 L F
.28788 .38847 m .29258 .37149 L p .28435 .38845 L F P
0 g
s
.711 .78 .906 r
.29258 .37149 m .29498 .36283 L p .28435 .38845 L F P
0 g
s
.711 .78 .906 r
.27221 .38838 m .29498 .36283 L .2668 .38835 L F
.707 .783 .911 r
.30021 .3548 m .29258 .37149 L p .29123 .36806 L F P
0 g
s
.707 .783 .911 r
.29123 .36806 m .28506 .35245 L .30021 .3548 L F
.82 .98 .888 r
.32166 .34479 m .33135 .33009 L p .30787 .35122 L F P
0 g
s
.698 .787 .92 r
.30409 .34629 m .31031 .31867 L .321 .32219 L F
.3241 .32321 m .31073 .33863 L p .321 .32219 L F P
0 g
s
.698 .787 .92 r
.31073 .33863 m .30409 .34629 L p .321 .32219 L F P
0 g
s
.698 .787 .92 r
.31031 .31867 m .31263 .30839 L .3241 .32321 L F
.687 .789 .928 r
.33091 .31536 m .32345 .30148 L .3361 .30699 L F
.693 .788 .924 r
.30553 .31709 m .3361 .30699 L .32345 .30148 L F
.578 .594 .832 r
.29769 .32519 m .30462 .31637 L .30527 .31701 L F
.693 .788 .924 r
.2966 .32488 m .31031 .31867 L .30553 .31709 L F
.31031 .31867 m .3361 .30699 L .30553 .31709 L F
.30553 .31709 m .32345 .30148 L .30527 .31701 L F
.698 .787 .92 r
.2848 .34251 m .29083 .3339 L .29157 .33408 L F
.703 .785 .915 r
.29166 .3341 m .29769 .32519 L .29083 .3339 L F
.698 .787 .92 r
.2848 .34251 m .30527 .31701 L .30553 .31709 L F
.562 .591 .841 r
.26499 .34082 m .28995 .33315 L .28632 .33006 L F
.544 .589 .85 r
.27117 .36838 m .26411 .32679 L .27509 .3605 L F
.594 .597 .825 r
.292 .30395 m .32194 .30027 L .31875 .29661 L F
.609 .601 .818 r
.31875 .29661 m .32944 .26826 L .33182 .27148 L F
.594 .597 .825 r
.292 .30395 m .3316 .29309 L .2872 .29922 L F
.578 .594 .832 r
.28632 .33006 m .29507 .28981 L .29083 .3339 L F
.562 .591 .841 r
.27882 .35107 m .2848 .34251 L .29441 .32598 L F
.544 .589 .85 r
.27509 .3605 m .27882 .35107 L .27953 .35159 L F
.27882 .35107 m .28261 .34145 L .27953 .35159 L F
.703 .785 .915 r
.27953 .35159 m .27392 .36037 L p .27863 .35339 L F P
0 g
s
.703 .785 .915 r
.27863 .35339 m .27982 .35164 L .27953 .35159 L F
.544 .589 .85 r
.28261 .34145 m .28367 .34229 L .27953 .35159 L p F P
0 g
s
.698 .787 .92 r
.30409 .34629 m .30454 .33716 L .30607 .33752 L F
.707 .783 .911 r
.28506 .35245 m .27982 .35164 L .28367 .34229 L F
.28506 .35245 m .28391 .34405 L .30021 .3548 L F
.2848 .34251 m .30409 .34629 L p .28391 .34405 L F P
0 g
s
.703 .785 .915 r
.27982 .35164 m .30607 .33752 L .29166 .3341 L F
.27392 .36037 m .28506 .35245 L .27982 .35164 L F
.28506 .35245 m .30607 .33752 L .27982 .35164 L F
.707 .783 .911 r
.28761 .3711 m .27229 .36989 L .27982 .35164 L F
.28761 .3711 m .27982 .35164 L .28506 .35245 L F
.544 .589 .85 r
.27953 .35159 m .27141 .36982 L p .27509 .3605 L F P
0 g
s
.707 .783 .911 r
.27141 .36982 m .27953 .35159 L p .27229 .36989 L F P
0 g
s
.707 .783 .911 r
.27953 .35159 m .28367 .34229 L p .27982 .35164 L F P
0 g
s
.707 .783 .911 r
.27229 .36989 m .27953 .35159 L .27982 .35164 L F
.703 .785 .915 r
.29083 .3339 m .27953 .35159 L p .29166 .3341 L F P
0 g
s
.703 .785 .915 r
.27982 .35164 m .29166 .3341 L .27953 .35159 L F
.698 .787 .92 r
.29083 .3339 m .30527 .31701 L p .29157 .33408 L F P
0 g
s
.578 .594 .832 r
.30527 .31701 m .29083 .3339 L p .29769 .32519 L F P
0 g
s
.693 .788 .924 r
.32272 .30116 m .30527 .31701 L p .32345 .30148 L F P
0 g
s
.693 .788 .924 r
.30527 .31701 m .2966 .32488 L p .30374 .31866 L F P
0 g
s
.687 .789 .928 r
.32272 .30116 m .34301 .28661 L p .32337 .30144 L F P
0 g
s
.609 .601 .818 r
.34301 .28661 m .32272 .30116 L p .33254 .29355 L F P
0 g
s
.687 .789 .928 r
.34019 .30877 m .33091 .31536 L p .3361 .30699 L F P
0 g
s
.693 .788 .924 r
.31031 .31867 m .321 .32219 L .33924 .30836 L F
.3361 .30699 m .33924 .30836 L .34838 .30143 L F
.31031 .31867 m .33924 .30836 L .3361 .30699 L F
.34019 .30877 m .34838 .30143 L p .321 .32219 L F P
0 g
s
.687 .789 .928 r
.35885 .29553 m .34019 .30877 L p .34725 .289 L F P
0 g
s
.687 .789 .928 r
.3361 .30699 m .34725 .289 L .34019 .30877 L F
.68 .788 .932 r
.34766 .28923 m .35885 .29553 L .37756 .28205 L F
.34323 .28674 m .37553 .28057 L .3665 .27402 L F
.37553 .28057 m .39052 .27771 L .3665 .27402 L F
.637 .612 .808 r
.37827 .26759 m .39074 .26152 L .39115 .26234 L F
.666 .785 .937 r
.39115 .26234 m .37755 .26699 L p .38855 .2634 L F P
0 g
s
.666 .785 .937 r
.38855 .2634 m .39131 .2625 L .39115 .26234 L F
.37755 .26699 m .39431 .26533 L .39131 .2625 L F
.637 .612 .808 r
.39115 .26234 m .36591 .2736 L p .37827 .26759 L F P
0 g
s
.673 .787 .935 r
.36591 .2736 m .40395 .25664 L p .3665 .27402 L F P
0 g
s
.68 .788 .932 r
.34725 .289 m .39052 .27771 L .34323 .28674 L F
.673 .787 .935 r
.37659 .28134 m .39431 .26533 L .37986 .28371 L F
.39431 .26533 m .40227 .25814 L .39522 .26619 L F
.39431 .26533 m .39522 .26619 L .37986 .28371 L F
.37659 .28134 m .3665 .27402 L .40395 .25664 L F
0 0 0 r
.41522 .25926 m .41943 .25849 L .42082 .2566 L F
.42261 .25575 m .41436 .25941 L p .42245 .25589 L F P
0 g
s
0 0 0 r
.41436 .25941 m .41522 .25926 L .42082 .2566 L F
.659 .782 .94 r
.41467 .26831 m .40454 .25729 L p .41877 .25355 L F P
0 g
s
.112 0 0 r
.4273 .25952 m .41727 .26293 L p .43055 .25647 L F P
0 g
s
0 0 0 r
.41943 .25849 m .4217 .25653 L .42082 .2566 L F
.112 0 0 r
.41727 .26293 m .43129 .25577 L .43055 .25647 L F
.41727 .26293 m .42964 .25198 L p .43869 .24881 L F P
0 g
s
.112 0 0 r
.41727 .26293 m .43869 .24881 L .43129 .25577 L F
0 0 0 r
.42082 .2566 m .4217 .25653 L .42245 .25589 L F
.41943 .25849 m .42401 .255 L .4284 .25264 L F
.42164 .25658 m .42401 .255 L .41943 .25849 L F
.659 .782 .94 r
.41467 .26831 m .41877 .25355 L .42509 .26156 L F
.223 0 0 r
.44735 .25271 m .43675 .25534 L p .44494 .25519 L F P
0 g
s
0 0 0 r
.4273 .25952 m .43675 .25534 L p .43055 .25647 L F P
0 g
s
0 0 0 r
.42261 .25575 m .43024 .25144 L p .42245 .25589 L F P
0 g
s
0 0 0 r
.4217 .25653 m .42401 .255 L .42164 .25658 L F
.112 0 0 r
.42964 .25198 m .4391 .24842 L .43869 .24881 L F
0 0 0 r
.43129 .25577 m .43675 .25534 L .43153 .25554 L F
.43153 .25554 m .43675 .25534 L .43869 .24881 L F
.112 0 0 r
.42964 .25198 m .43024 .25144 L .4391 .24842 L p F P
0 g
s
0 0 0 r
.4284 .25264 m .42401 .255 L .43024 .25144 L F
.666 .785 .937 r
.44045 .26078 m .43263 .24903 L p .41877 .25355 L F P
0 g
s
.673 .787 .935 r
.40454 .25729 m .41467 .26831 L p .40227 .25814 L F P
0 g
s
.666 .785 .937 r
.39131 .2625 m .42491 .26133 L .41877 .25355 L F
.42491 .26133 m .44045 .26078 L .41877 .25355 L F
.659 .782 .94 r
.41467 .26831 m .42509 .26156 L .42563 .26225 L F
.666 .785 .937 r
.39431 .26533 m .42563 .26225 L .39131 .2625 L F
.42563 .26225 m .44045 .26078 L .42491 .26133 L F
.42563 .26225 m .42491 .26133 L .39131 .2625 L F
.659 .782 .94 r
.46181 .24224 m .4675 .25526 L .45419 .25855 L p F P
0 g
s
.116 0 0 r
.44735 .25271 m .45748 .24927 L p .44511 .25519 L F P
0 g
s
.659 .782 .94 r
.4497 .25038 m .46181 .24224 L .45419 .25855 L F
.42785 .26505 m .41467 .26831 L p .42563 .26225 L F P
0 g
s
.666 .785 .937 r
.39431 .26533 m .40296 .27349 L .42889 .26193 L F
.223 0 0 r
.44494 .25519 m .44511 .25519 L .44735 .25271 L F
.652 .779 .941 r
.44045 .26078 m .45419 .25855 L p .43456 .24861 L F P
0 g
s
.645 .775 .942 r
.4675 .25526 m .50807 .23855 L .50848 .24196 L F
.639 .77 .942 r
.49468 .24851 m .5094 .24956 L .50936 .24927 L F
0 0 0 r
.47334 .25467 m .4675 .25526 L .48159 .25409 L p F P
0 g
s
.645 .775 .942 r
.48159 .25409 m .4675 .25526 L p .50936 .24927 L F P
0 g
s
.652 .779 .941 r
.45419 .25855 m .48159 .25409 L p .4497 .25038 L F P
0 g
s
.652 .779 .941 r
.43456 .24861 m .45419 .25855 L .4497 .25038 L F
.43263 .24903 m .44045 .26078 L p .43456 .24861 L F P
0 g
s
.659 .782 .94 r
.44909 .24927 m .46181 .24224 L .4497 .25038 L F
.652 .779 .941 r
.44909 .24927 m .48159 .25409 L .48058 .25102 L F
.663 .625 .801 r
.41805 .25219 m .45631 .21734 L .44755 .24483 L F
.43263 .24903 m .44755 .24483 L .44722 .24587 L F
.41805 .25219 m .44755 .24483 L .43263 .24903 L F
.652 .779 .941 r
.43217 .24834 m .4497 .25038 L .44909 .24927 L F
.4497 .25038 m .48159 .25409 L .44909 .24927 L F
.659 .782 .94 r
.44909 .24927 m .45022 .24529 L .4596 .24346 L F
.652 .779 .941 r
.43217 .24834 m .44909 .24927 L .44732 .24605 L F
.659 .782 .94 r
.42563 .26225 m .44781 .24694 L .44909 .24927 L F
.44781 .24694 m .45022 .24529 L .44909 .24927 L F
.666 .785 .937 r
.40296 .27349 m .44045 .26078 L p .42889 .26193 L F P
0 g
s
.659 .782 .94 r
.42563 .26225 m .44909 .24927 L .42785 .26505 L F
.44909 .24927 m .4497 .25038 L .42785 .26505 L F
.42509 .26156 m .45022 .24529 L .42563 .26225 L F
.42509 .26156 m .41877 .25355 L .45022 .24529 L F
.652 .779 .941 r
.47742 .24143 m .49259 .23921 L .47726 .24094 L F
.645 .775 .942 r
.46213 .24297 m .47726 .24094 L .47744 .2415 L F
.652 .779 .941 r
.44722 .24587 m .43217 .24834 L p .44732 .24605 L F P
0 g
s
.666 .785 .937 r
.41873 .25349 m .43263 .24903 L .41838 .25305 L F
.41877 .25355 m .43263 .24903 L .41873 .25349 L F
.659 .782 .94 r
.41838 .25305 m .46181 .24224 L p .41877 .25355 L F P
0 g
s
.659 .782 .94 r
.40454 .25729 m .41838 .25305 L .41877 .25355 L F
.666 .785 .937 r
.39131 .2625 m .41877 .25355 L .39115 .26234 L F
.41877 .25355 m .41873 .25349 L .39115 .26234 L F
.652 .779 .941 r
.44732 .24605 m .49259 .23921 L .44722 .24587 L F
.639 .77 .942 r
.50805 .23837 m .49243 .23846 L p .50807 .23855 L F P
0 g
s
.645 .775 .942 r
.47726 .24094 m .52356 .23707 L p .47744 .2415 L F P
0 g
s
.652 .779 .941 r
.47726 .24094 m .44722 .24587 L p .47742 .24143 L F P
0 g
s
.652 .779 .941 r
.44732 .24605 m .48058 .25102 L .47744 .2415 L F
.44909 .24927 m .48058 .25102 L .44732 .24605 L F
.13 .676 .716 r
.45419 .25855 m .44045 .26078 L p .45612 .2583 L F P
0 g
s
.326 .809 .779 r
.44896 .25965 m .44045 .26078 L .42785 .26505 L p F P
0 g
s
.659 .782 .94 r
.45419 .25855 m .42785 .26505 L p .4497 .25038 L F P
0 g
s
.666 .785 .937 r
.41838 .25305 m .39115 .26234 L p .41873 .25349 L F P
0 g
s
.673 .787 .935 r
.40296 .27349 m .37986 .28371 L p .40102 .27166 L F P
0 g
s
.673 .787 .935 r
.37986 .28371 m .39522 .26619 L .40102 .27166 L F
.651 .618 .804 r
.39115 .26234 m .41838 .25305 L p .41805 .25219 L F P
0 g
s
.663 .625 .801 r
.44722 .24587 m .40395 .25664 L p .40654 .25469 L F P
0 g
s
.666 .785 .937 r
.43263 .24903 m .43217 .24834 L .41838 .25305 L p F P
0 g
s
.663 .625 .801 r
.40654 .25469 m .41622 .24742 L .41805 .25219 L F
.41622 .24742 m .45631 .21734 L .41805 .25219 L F
.651 .618 .804 r
.42878 .24814 m .41805 .25219 L .43217 .24834 L F
.41838 .25305 m .43217 .24834 L p .41805 .25219 L F P
0 g
s
.676 .633 .799 r
.44722 .24587 m .47726 .24094 L p .47711 .24005 L F P
0 g
s
.688 .641 .798 r
.50805 .23837 m .46181 .24224 L p .46487 .24072 L F P
0 g
s
.652 .779 .941 r
.49259 .23921 m .49243 .23846 L .47726 .24094 L p F P
0 g
s
.688 .641 .798 r
.46487 .24072 m .47628 .23505 L .47711 .24005 L F
.47628 .23505 m .5069 .21982 L .47711 .24005 L F
.676 .633 .799 r
.489 .23774 m .47711 .24005 L .49243 .23846 L F
.47726 .24094 m .49243 .23846 L p .47711 .24005 L F P
0 g
s
.652 .779 .941 r
.43217 .24834 m .43263 .24903 L p .43456 .24861 L F P
0 g
s
.651 .618 .804 r
.43217 .24834 m .42417 .22403 L .40923 .2292 L p F P
0 g
s
.651 .618 .804 r
.41622 .24742 m .43217 .24834 L .40923 .2292 L F
.637 .612 .808 r
.37976 .23941 m .3936 .23314 L p .38279 .24551 L F P
0 g
s
.688 .641 .798 r
.45741 .2223 m .47308 .21591 L .47364 .21925 L F
.45741 .2223 m .50649 .21308 L .50657 .21436 L F
.47628 .23505 m .50657 .21436 L .5069 .21982 L F
.46181 .24224 m .476 .2334 L .47628 .23505 L F
.476 .2334 m .50657 .21436 L .47628 .23505 L F
.676 .633 .799 r
.49243 .23846 m .48953 .21318 L .47308 .21591 L p F P
0 g
s
.676 .633 .799 r
.47628 .23505 m .49243 .23846 L .47308 .21591 L F
.7 .65 .797 r
.50649 .21308 m .48953 .21318 L p .50657 .21436 L F P
0 g
s
.7 .65 .797 r
.50657 .21436 m .55668 .21782 L .50649 .21308 L F
.688 .641 .798 r
.50649 .21308 m .52333 .21165 L p .50657 .21436 L F P
0 g
s
.7 .65 .797 r
.5069 .21982 m .53916 .23702 L .53937 .23222 L F
.711 .66 .797 r
.52356 .23707 m .52333 .21165 L .54021 .21288 L p F P
0 g
s
.711 .66 .797 r
.52356 .23707 m .54021 .21288 L .53937 .23222 L F
.7 .65 .797 r
.55474 .23809 m .55668 .21782 L p .54004 .21667 L F P
0 g
s
.7 .65 .797 r
.53944 .23055 m .55474 .23809 L .54004 .21667 L F
.48953 .21318 m .5069 .21982 L .50657 .21436 L F
.688 .641 .798 r
.5069 .21982 m .52333 .21165 L .50805 .23837 L F
.639 .77 .942 r
.49243 .23846 m .49259 .23921 L p .49352 .23916 L F P
0 g
s
.688 .641 .798 r
.52333 .21165 m .52356 .23707 L .50805 .23837 L p F P
0 g
s
.645 .775 .942 r
.48058 .25102 m .50848 .24196 L .48133 .25328 L F
.50848 .24196 m .52356 .23707 L .50858 .24282 L F
.50848 .24196 m .50858 .24282 L .48133 .25328 L F
.639 .77 .942 r
.53907 .23868 m .5546 .23884 L .53911 .23818 L F
.633 .765 .942 r
.52358 .23782 m .53911 .23818 L .53907 .23874 L F
.639 .77 .942 r
.50807 .23855 m .5546 .23884 L .50805 .23837 L F
.722 .67 .799 r
.57012 .2395 m .56998 .24039 L .58519 .24224 L F
.57012 .2395 m .58519 .24224 L .61243 .24554 L F
.711 .66 .797 r
.5546 .23884 m .57073 .23952 L .56998 .24039 L F
.54085 .23745 m .57073 .23952 L .5546 .23884 L F
.627 .759 .941 r
.55474 .23809 m .55223 .2515 L .56613 .25359 L p F P
0 g
s
.627 .759 .941 r
.55474 .23809 m .56613 .25359 L .56895 .24394 L F
.564 .004 0 r
.5803 .2468 m .56954 .24428 L p .58184 .24912 L F P
0 g
s
.633 .765 .942 r
.58548 .24151 m .58026 .2546 L p .54801 .24702 L F P
0 g
s
0 .475 .738 r
.58026 .2546 m .59368 .25773 L p .59315 .25763 L F P
0 g
s
.627 .759 .941 r
.59368 .25773 m .60749 .2598 L p .5952 .25474 L F P
0 g
s
.581 .011 0 r
.62188 .25838 m .63202 .26167 L p .62458 .26101 L F P
0 g
s
.578 .007 0 r
.61944 .25032 m .63202 .26167 L .62188 .25838 L p F P
0 g
s
.618 .747 .938 r
.61532 .24725 m .62023 .26393 L .62684 .25506 L F
.633 .765 .942 r
.56998 .24039 m .58548 .24151 L p .56993 .24058 L F P
0 g
s
.633 .765 .942 r
.56895 .24394 m .57304 .24077 L .58262 .24193 L F
.627 .759 .941 r
.56895 .24394 m .60749 .2598 L .56998 .24039 L F
.622 .753 .94 r
.62023 .26393 m .59368 .25773 L p .62684 .25506 L F P
0 g
s
.622 .753 .94 r
.59368 .25773 m .58026 .2546 L p .5952 .25474 L F P
0 g
s
.622 .753 .94 r
.5952 .25474 m .62684 .25506 L .59368 .25773 L F
.627 .759 .941 r
.56613 .25359 m .59368 .25773 L p .56895 .24394 L F P
0 g
s
.627 .759 .941 r
.56895 .24394 m .59368 .25773 L .5952 .25474 L F
.633 .765 .942 r
.53911 .23818 m .56998 .24039 L p .53907 .23874 L F P
0 g
s
.633 .765 .942 r
.53907 .23874 m .56998 .24039 L .56993 .24058 L F
.639 .77 .942 r
.53911 .23818 m .50805 .23837 L p .53907 .23868 L F P
0 g
s
.639 .77 .942 r
.50848 .24196 m .53825 .24845 L .50807 .23855 L F
.53825 .24845 m .55223 .2515 L .53833 .24743 L F
.53825 .24845 m .53833 .24743 L .50807 .23855 L F
.633 .765 .942 r
.53798 .25159 m .52381 .25058 L p .53804 .25086 L F P
0 g
s
.639 .77 .942 r
.53825 .24845 m .53805 .25076 L .55223 .2515 L F
0 .496 .712 r
.55223 .2515 m .56505 .25348 L .56535 .25351 L F
.633 .765 .942 r
.53804 .25086 m .56676 .25142 L .53798 .25159 L F
.53825 .24845 m .56993 .24058 L .56895 .24394 L F
.53833 .24743 m .56993 .24058 L .53825 .24845 L F
.639 .77 .942 r
.50807 .23855 m .53833 .24743 L .53907 .23874 L F
.645 .775 .942 r
.46213 .24297 m .46181 .24224 L .47726 .24094 L p F P
0 g
s
.688 .641 .798 r
.5069 .21982 m .50657 .21436 L .50991 .21382 L F
.51624 .21518 m .50991 .21382 L .52333 .21165 L F
.5069 .21982 m .50991 .21382 L .51624 .21518 L F
.704 .613 .752 r
.48919 .20936 m .48953 .21318 L .50649 .21308 L p F P
0 g
s
.704 .613 .752 r
.54021 .21288 m .55717 .21278 L p .54046 .20547 L F P
0 g
s
.72 .626 .752 r
.52913 .20956 m .54046 .20547 L .54021 .21288 L F
.54021 .21288 m .52333 .21165 L p .52913 .20956 L F P
0 g
s
.7 .65 .797 r
.55668 .21782 m .55717 .21278 L .54021 .21288 L p F P
0 g
s
.735 .639 .753 r
.55955 .18151 m .55746 .20894 L p .574 .21279 L F P
0 g
s
.735 .639 .753 r
.55955 .18151 m .574 .21279 L .57607 .19519 L F
.72 .626 .752 r
.59547 .18562 m .59052 .21653 L .57371 .21531 L p F P
0 g
s
.72 .626 .752 r
.57639 .1925 m .59547 .18562 L .57371 .21531 L F
.75 .654 .755 r
.59052 .21653 m .59547 .18562 L .64654 .19798 L p F P
0 g
s
.764 .67 .758 r
.67859 .20874 m .64654 .19798 L p .67124 .22847 L F P
0 g
s
.764 .67 .758 r
.64428 .20589 m .67037 .23083 L .64654 .19798 L F
.778 .686 .762 r
.67859 .20874 m .7083 .22186 L p .67037 .23083 L F P
0 g
s
.807 .723 .773 r
.72414 .25738 m .75491 .26083 L .72068 .26369 L F
.73527 .23709 m .75917 .25416 L p .72414 .25738 L F P
0 g
s
.807 .723 .773 r
.72414 .25738 m .75917 .25416 L .75491 .26083 L F
.833 .766 .788 r
.76646 .29085 m .79188 .29847 L .76232 .29648 L F
.846 .79 .797 r
.79188 .29847 m .79096 .33392 L .79551 .32904 L F
.833 .766 .788 r
.77973 .27277 m .79674 .29262 L p .76646 .29085 L F P
0 g
s
.833 .766 .788 r
.76646 .29085 m .79674 .29262 L .79188 .29847 L F
.846 .79 .797 r
.78992 .282 m .79029 .30038 L .79188 .29847 L F
.79029 .30038 m .79096 .33392 L .79188 .29847 L F
.81008 .3134 m .78992 .282 L p .79551 .32904 L F P
0 g
s
.833 .766 .788 r
.79674 .29262 m .80517 .30246 L p .79188 .29847 L F P
0 g
s
.82 .744 .78 r
.77189 .30498 m .78992 .282 L .77973 .27277 L p F P
0 g
s
.82 .744 .78 r
.77973 .27277 m .74869 .24467 L p .76646 .29085 L F P
0 g
s
.82 .744 .78 r
.76646 .29085 m .77189 .30498 L .77973 .27277 L F
.75491 .26083 m .76232 .29648 L .76646 .29085 L F
.75351 .263 m .76232 .29648 L .75491 .26083 L F
.75351 .263 m .74435 .27731 L .76232 .29648 L F
.833 .766 .788 r
.75415 .28716 m .77104 .26264 L .77973 .27277 L p F P
0 g
s
.833 .766 .788 r
.75415 .28716 m .77973 .27277 L .76646 .29085 L F
.807 .723 .773 r
.75917 .25416 m .77104 .26264 L p .75491 .26083 L F P
0 g
s
.82 .744 .78 r
.74869 .24467 m .75351 .263 L .75491 .26083 L F
.793 .704 .767 r
.73321 .27064 m .74869 .24467 L .73527 .23709 L p F P
0 g
s
.793 .704 .767 r
.73527 .23709 m .7083 .22186 L p .72533 .25521 L F P
0 g
s
.793 .704 .767 r
.72533 .25521 m .73321 .27064 L .73527 .23709 L F
.70491 .22923 m .73321 .27064 L .7083 .22186 L F
.7038 .23164 m .72068 .26369 L .70491 .22923 L F
.807 .723 .773 r
.7093 .25571 m .7231 .2284 L .73527 .23709 L p F P
0 g
s
.807 .723 .773 r
.7093 .25571 m .73527 .23709 L .72414 .25738 L F
.778 .686 .762 r
.7083 .22186 m .7231 .2284 L p .70491 .22923 L F P
0 g
s
.778 .686 .762 r
.67037 .23083 m .7083 .22186 L .70491 .22923 L F
.793 .704 .767 r
.7083 .22186 m .69458 .21411 L p .70491 .22923 L F P
0 g
s
.764 .67 .758 r
.67037 .23083 m .6827 .24262 L .67124 .22847 L F
.67037 .23083 m .67124 .22847 L .64654 .19798 L F
.64428 .20589 m .66781 .23769 L .67853 .23863 L F
.64354 .20847 m .66781 .23769 L .64428 .20589 L F
.778 .686 .762 r
.65376 .23159 m .6635 .20208 L .67859 .20874 L p F P
0 g
s
.778 .686 .762 r
.65376 .23159 m .67859 .20874 L .67037 .23083 L F
.75 .654 .755 r
.64654 .19798 m .6635 .20208 L p .64428 .20589 L F P
0 g
s
.75 .654 .755 r
.59052 .21653 m .64654 .19798 L .64428 .20589 L F
.764 .67 .758 r
.6303 .19252 m .64354 .20847 L .64428 .20589 L F
.6303 .19252 m .62288 .22284 L .63799 .22784 L p F P
0 g
s
.764 .67 .758 r
.6303 .19252 m .63799 .22784 L .64354 .20847 L F
.66781 .23769 m .6827 .24262 L p .67853 .23863 L F P
0 g
s
.743 .693 .803 r
.63491 .2363 m .65681 .26078 L .63567 .23422 L F
.753 .705 .807 r
.64382 .25522 m .65178 .2363 L p .6955 .24972 L F P
0 g
s
.753 .705 .807 r
.65178 .2363 m .65376 .23159 L .66781 .23769 L p F P
0 g
s
.753 .705 .807 r
.66781 .23769 m .6955 .24972 L p .65178 .2363 L F P
0 g
s
.753 .705 .807 r
.64382 .25522 m .6955 .24972 L .69201 .25558 L F
.762 .718 .812 r
.68673 .24822 m .67122 .26405 L .68294 .27086 L F
.69033 .25841 m .68294 .27086 L .69779 .27949 L F
.68673 .24822 m .68294 .27086 L .69033 .25841 L F
.69484 .25083 m .71025 .27822 L .71844 .2668 L F
.69201 .25558 m .70927 .27959 L .69484 .25083 L F
.771 .732 .817 r
.70927 .27959 m .74304 .27936 L .73864 .28454 L F
.71048 .27791 m .74304 .27936 L .70927 .27959 L F
.762 .718 .812 r
.70927 .27959 m .71736 .29086 L .71025 .27822 L F
.70927 .27959 m .71025 .27822 L .69484 .25083 L F
.68673 .24822 m .69779 .27949 L .70548 .28336 L F
.68673 .24822 m .70594 .28423 L .70927 .27959 L F
.771 .732 .817 r
.69518 .27722 m .71048 .27791 L .70927 .27959 L F
.793 .704 .767 r
.6955 .24972 m .72068 .26369 L p .69654 .24745 L F P
0 g
s
.778 .686 .762 r
.6955 .24972 m .66781 .23769 L p .69654 .24745 L F P
0 g
s
.793 .704 .767 r
.68415 .23912 m .6955 .24972 L .69654 .24745 L F
.778 .686 .762 r
.69654 .24745 m .71099 .25236 L .6955 .24972 L F
.771 .732 .817 r
.72068 .26369 m .74304 .27936 L p .71048 .27791 L F P
0 g
s
.762 .718 .812 r
.72068 .26369 m .6827 .24262 L p .73006 .27466 L F P
0 g
s
.753 .705 .807 r
.6955 .24972 m .7093 .25571 L p .69201 .25558 L F P
0 g
s
.762 .718 .812 r
.67122 .26405 m .67056 .26527 L .68241 .27175 L p F P
0 g
s
.615 .74 .935 r
.68052 .287 m .66883 .28203 L p .69379 .27747 L F P
0 g
s
.615 .74 .935 r
.69436 .27777 m .68052 .287 L p .69379 .27747 L F P
0 g
s
.762 .718 .812 r
.67122 .26405 m .68241 .27175 L .69436 .27777 L F
.615 .74 .935 r
.67877 .27451 m .69235 .27675 L .66883 .28203 L F
.762 .718 .812 r
.67122 .26405 m .69436 .27777 L .69779 .27949 L F
.615 .74 .935 r
.69235 .27675 m .69518 .27722 L .69379 .27747 L F
.69235 .27675 m .69379 .27747 L .66883 .28203 L F
.609 .721 .925 r
.71815 .29261 m .72189 .30093 L .7265 .29883 L F
.615 .74 .935 r
.68134 .27256 m .68222 .27189 L .68482 .27296 L F
.67877 .27451 m .68482 .27296 L .69235 .27675 L F
.63352 .26703 m .64872 .26879 L .64806 .26943 L F
.618 .747 .938 r
.64806 .26943 m .64727 .27022 L .65024 .27091 L F
.612 .734 .932 r
.66111 .27344 m .66883 .28203 L .67106 .28034 L F
.618 .747 .938 r
.65024 .27091 m .64727 .27022 L .65797 .27615 L F
.64727 .27022 m .64586 .27161 L .65797 .27615 L F
.615 .74 .935 r
.64539 .27207 m .63352 .26703 L p .64806 .26943 L F P
0 g
s
.618 .747 .938 r
.64539 .27207 m .65797 .27615 L p .63367 .26705 L F P
0 g
s
.618 .747 .938 r
.65797 .27615 m .66986 .26588 L p .65633 .26126 L F P
0 g
s
.618 .747 .938 r
.64894 .26857 m .65797 .27615 L .65633 .26126 L F
.612 .734 .932 r
.69022 .29362 m .70088 .2994 L p .66111 .27344 L F P
0 g
s
.559 0 0 r
.63202 .26167 m .62768 .25496 L .63593 .26217 L F
.622 .753 .94 r
.62684 .25506 m .62914 .25197 L .64382 .25522 L F
.615 .74 .935 r
.63352 .26703 m .64324 .25588 L p .65633 .26126 L F P
0 g
s
.615 .74 .935 r
.63352 .26703 m .65633 .26126 L .64894 .26857 L F
.63352 .26703 m .64894 .26857 L .64872 .26879 L F
.622 .753 .94 r
.63522 .25759 m .64089 .25519 L .63787 .26003 L F
.559 0 0 r
.63202 .26167 m .63593 .26217 L .63621 .26241 L F
.622 .753 .94 r
.63522 .25759 m .63787 .26003 L .63352 .26703 L F
.63352 .26703 m .62023 .26393 L p .63522 .25759 L F P
0 g
s
.622 .753 .94 r
.62684 .25506 m .64089 .25519 L .62023 .26393 L F
.64324 .25588 m .63352 .26703 L p .64089 .25519 L F P
0 g
s
.618 .747 .938 r
.62684 .25506 m .64806 .26943 L .62914 .25197 L F
.64806 .26943 m .65797 .27615 L .64894 .26857 L F
.64806 .26943 m .64894 .26857 L .62914 .25197 L F
.615 .74 .935 r
.68134 .27256 m .68482 .27296 L .67877 .27451 L F
.612 .734 .932 r
.67199 .26687 m .67877 .27451 L .67989 .27057 L F
.67877 .27451 m .69385 .29149 L .68126 .27262 L F
.67877 .27451 m .68126 .27262 L .67989 .27057 L F
.68241 .27175 m .67056 .26527 L p .68222 .27189 L F P
0 g
s
.618 .747 .938 r
.62914 .25197 m .65633 .26126 L .62927 .2518 L F
.65633 .26126 m .66986 .26588 L .65638 .2612 L F
.612 .734 .932 r
.69385 .29149 m .69474 .29096 L .67989 .27057 L F
.67989 .27057 m .69474 .29096 L .70509 .28489 L F
.615 .74 .935 r
.65633 .26126 m .68241 .27175 L .68222 .27189 L F
.64324 .25588 m .65638 .2612 L .65633 .26126 L F
.65638 .2612 m .68241 .27175 L .65633 .26126 L F
.64324 .25588 m .65681 .26078 L .65638 .2612 L F
.618 .747 .938 r
.65681 .26078 m .62927 .2518 L p .65638 .2612 L F P
0 g
s
.618 .747 .938 r
.65638 .2612 m .66986 .26588 L .65681 .26078 L F
.65633 .26126 m .65638 .2612 L .62927 .2518 L F
.615 .74 .935 r
.65681 .26078 m .68241 .27175 L p .65638 .2612 L F P
0 g
s
.615 .74 .935 r
.68241 .27175 m .69518 .27722 L p .68222 .27189 L F P
0 g
s
.615 .74 .935 r
.64872 .26879 m .68222 .27189 L .68134 .27256 L F
.64894 .26857 m .68222 .27189 L .64872 .26879 L F
.66883 .28203 m .64539 .27207 L p .67877 .27451 L F P
0 g
s
.615 .74 .935 r
.64806 .26943 m .67877 .27451 L .64539 .27207 L F
.618 .747 .938 r
.64727 .27022 m .63367 .26705 L .64586 .27161 L F
.62684 .25506 m .62023 .26393 L .64727 .27022 L F
.62684 .25506 m .64727 .27022 L .64806 .26943 L F
.615 .74 .935 r
.64806 .26943 m .68134 .27256 L .67877 .27451 L F
.64872 .26879 m .68134 .27256 L .64806 .26943 L F
.612 .734 .932 r
.70574 .28451 m .68241 .27175 L p .71644 .29134 L F P
0 g
s
.612 .734 .932 r
.68222 .27189 m .71644 .29134 L .68241 .27175 L F
.771 .732 .817 r
.70574 .28451 m .70728 .28451 L .71644 .29134 L F
.7265 .29883 m .70574 .28451 L p .71644 .29134 L F P
0 g
s
.762 .718 .812 r
.70574 .28451 m .71736 .29086 L p .70594 .28423 L F P
0 g
s
.762 .718 .812 r
.69779 .27949 m .70574 .28451 L .70594 .28423 L F
.69436 .27777 m .70574 .28451 L .69779 .27949 L F
.68241 .27175 m .70574 .28451 L p .69436 .27777 L F P
0 g
s
.615 .74 .935 r
.69518 .27722 m .69436 .27777 L p .69379 .27747 L F P
0 g
s
.612 .734 .932 r
.67106 .28034 m .66883 .28203 L .68074 .28705 L F
.66883 .28203 m .69022 .29362 L p .68074 .28705 L F P
0 g
s
0 .458 .808 r
.64539 .27207 m .66883 .28203 L p .65696 .27703 L F P
0 g
s
.618 .747 .938 r
.62023 .26393 m .64539 .27207 L p .63367 .26705 L F P
0 g
s
0 .457 .842 r
.69022 .29362 m .66883 .28203 L p .67921 .29065 L F P
0 g
s
0 .457 .842 r
.67793 .2903 m .68388 .29452 L .67921 .29065 L F
.006 .459 .868 r
.67793 .2903 m .7093 .30666 L .7045 .30515 L F
.66542 .28331 m .67921 .29065 L .67793 .2903 L F
.67921 .29065 m .7093 .30666 L .67793 .2903 L F
0 .457 .842 r
.66504 .28116 m .67793 .2903 L .66883 .28203 L F
.67793 .2903 m .67921 .29065 L .66883 .28203 L F
.66504 .28116 m .65484 .27882 L .6763 .28915 L F
0 .458 .808 r
.63637 .27035 m .66504 .28116 L .63512 .27011 L F
.66504 .28116 m .66449 .28103 L .63512 .27011 L F
.63512 .27011 m .66449 .28103 L .66024 .28006 L F
.64642 .27479 m .65961 .27991 L .65484 .27882 L F
.006 .459 .868 r
.67555 .28966 m .68131 .29219 L .68573 .29604 L F
.67793 .2903 m .68131 .29219 L .67555 .28966 L F
0 .457 .842 r
.6763 .28915 m .66707 .2847 L .67555 .28966 L F
.6763 .28915 m .67555 .28966 L .67793 .2903 L F
.65484 .27882 m .67421 .28929 L p .66707 .2847 L F P
0 g
s
.514 0 0 r
.67421 .28929 m .69154 .30109 L p .68486 .29614 L F P
0 g
s
0 .458 .808 r
.65484 .27882 m .63365 .26983 L p .64642 .27479 L F P
0 g
s
0 .463 .772 r
.61452 .26304 m .63365 .26983 L .63512 .27011 L F
.6141 .26297 m .63365 .26983 L .61452 .26304 L F
0 .475 .738 r
.59718 .25912 m .61689 .26341 L .61452 .26304 L F
.58783 .257 m .59468 .2585 L .59718 .25912 L F
0 .463 .772 r
.61771 .26354 m .62793 .26764 L .63402 .26949 L F
.61689 .26341 m .62793 .26764 L .61771 .26354 L F
0 .475 .738 r
.58854 .25709 m .59349 .2577 L .62014 .26391 L F
.58854 .25709 m .62014 .26391 L .61771 .26354 L F
.59368 .25773 m .62023 .26393 L p .59349 .2577 L F P
0 g
s
.622 .753 .94 r
.5952 .25474 m .59991 .2455 L .62914 .25197 L F
.5952 .25474 m .62914 .25197 L .62684 .25506 L F
.59991 .2455 m .62927 .2518 L .62914 .25197 L F
.618 .747 .938 r
.62927 .2518 m .61532 .24725 L p .62638 .25103 L F P
0 g
s
.732 .681 .801 r
.62927 .2518 m .60018 .24496 L p .61488 .24795 L F P
0 g
s
.732 .681 .801 r
.62958 .25094 m .64435 .25395 L .62927 .2518 L F
.743 .693 .803 r
.61573 .24594 m .62927 .2518 L .62958 .25094 L F
.61573 .24594 m .61532 .24725 L .62927 .2518 L p F P
0 g
s
.743 .693 .803 r
.62927 .2518 m .65681 .26078 L p .64324 .25588 L F P
0 g
s
.622 .753 .94 r
.60018 .24496 m .62927 .2518 L p .59991 .2455 L F P
0 g
s
.622 .753 .94 r
.62927 .2518 m .64382 .25522 L p .63208 .25262 L F P
0 g
s
.622 .753 .94 r
.58519 .24224 m .60018 .24496 L .59991 .2455 L F
.627 .759 .941 r
.60018 .24496 m .56998 .24039 L p .59994 .24544 L F P
0 g
s
.627 .759 .941 r
.56998 .24039 m .59572 .25371 L .59994 .24544 L F
.732 .681 .801 r
.60018 .24496 m .602 .24451 L .61488 .24795 L F
.722 .67 .799 r
.56998 .24039 m .61532 .24725 L p .61243 .24554 L F P
0 g
s
.622 .753 .94 r
.58519 .24224 m .58548 .24151 L .60018 .24496 L p F P
0 g
s
.722 .67 .799 r
.55717 .21278 m .56998 .24039 L .57271 .22199 L F
.711 .66 .797 r
.57012 .23948 m .58698 .22051 L .57073 .23952 L F
.58698 .22051 m .59052 .21653 L .58707 .22054 L F
.58698 .22051 m .58707 .22054 L .57073 .23952 L F
.735 .639 .753 r
.55746 .20894 m .55717 .21278 L .57371 .21531 L p F P
0 g
s
.735 .639 .753 r
.60647 .22033 m .62288 .22284 L p .60793 .21308 L F P
0 g
s
.75 .654 .755 r
.60647 .22033 m .59052 .21653 L p .60666 .2194 L F P
0 g
s
.75 .654 .755 r
.59052 .21653 m .60793 .21308 L .60666 .2194 L F
.735 .639 .753 r
.62288 .22284 m .6303 .19252 L .61263 .18977 L p F P
0 g
s
.735 .639 .753 r
.60793 .21308 m .62288 .22284 L .61263 .18977 L F
.778 .686 .762 r
.6594 .23133 m .67037 .23083 L .66781 .23769 L F
.764 .67 .758 r
.6827 .24262 m .69458 .21411 L .67859 .20874 L p F P
0 g
s
.764 .67 .758 r
.67124 .22847 m .6827 .24262 L .67859 .20874 L F
.793 .704 .767 r
.69458 .21411 m .7038 .23164 L .70491 .22923 L F
.778 .686 .762 r
.70491 .22923 m .7231 .2284 L .7038 .23164 L F
.7231 .2284 m .71099 .25236 L p .69654 .24745 L F P
0 g
s
.778 .686 .762 r
.7038 .23164 m .7231 .2284 L .69654 .24745 L F
.793 .704 .767 r
.69458 .21411 m .68415 .23912 L p .69654 .24745 L F P
0 g
s
.793 .704 .767 r
.69458 .21411 m .69654 .24745 L .7038 .23164 L F
.764 .67 .758 r
.64654 .19798 m .6303 .19252 L p .64428 .20589 L F P
0 g
s
.75 .654 .755 r
.6635 .20208 m .65495 .22797 L p .63878 .2251 L F P
0 g
s
.75 .654 .755 r
.64428 .20589 m .6635 .20208 L .63878 .2251 L F
.65495 .22797 m .65376 .23159 L .63799 .22784 L p F P
0 g
s
.743 .693 .803 r
.62841 .22776 m .63491 .2363 L .63567 .23422 L F
.62288 .22284 m .62727 .22775 L .62841 .22776 L F
.62727 .22775 m .63491 .2363 L .62841 .22776 L F
.732 .681 .801 r
.63567 .23422 m .65376 .23159 L .63491 .2363 L F
.63491 .2363 m .65376 .23159 L .63352 .24011 L F
.743 .693 .803 r
.62288 .22284 m .63352 .24011 L .63491 .2363 L F
.62288 .22284 m .61573 .24594 L p .62958 .25094 L F P
0 g
s
.743 .693 .803 r
.62288 .22284 m .62958 .25094 L .63352 .24011 L F
.732 .681 .801 r
.65376 .23159 m .64435 .25395 L p .62958 .25094 L F P
0 g
s
.732 .681 .801 r
.63352 .24011 m .65376 .23159 L .62958 .25094 L F
.618 .747 .938 r
.61532 .24725 m .61732 .24861 L .62638 .25103 L F
.633 .765 .942 r
.58262 .24193 m .57304 .24077 L .58548 .24151 L F
.722 .67 .799 r
.55717 .21278 m .55474 .23809 L .56998 .24039 L p F P
0 g
s
.627 .759 .941 r
.61488 .24795 m .61532 .24725 L .60018 .24496 L p F P
0 g
s
.732 .681 .801 r
.60018 .24496 m .58548 .24151 L p .60167 .23916 L F P
0 g
s
.722 .67 .799 r
.61532 .24725 m .62288 .22284 L .60647 .22033 L p F P
0 g
s
.722 .67 .799 r
.60217 .23716 m .61532 .24725 L .60647 .22033 L F
.57371 .21531 m .55717 .21278 L p .57271 .22199 L F P
0 g
s
.711 .66 .797 r
.57239 .22417 m .59052 .21653 L .57012 .23948 L F
.56998 .24039 m .53911 .23818 L p .54085 .23745 L F P
0 g
s
.639 .77 .942 r
.5546 .23884 m .55474 .23809 L .53911 .23818 L p F P
0 g
s
.639 .77 .942 r
.50848 .24196 m .50936 .24927 L .53805 .25076 L F
.50848 .24196 m .53805 .25076 L .53825 .24845 L F
.633 .765 .942 r
.53833 .24743 m .53907 .23874 L .56993 .24058 L F
.627 .759 .941 r
.56998 .24039 m .55474 .23809 L p .5572 .2391 L F P
0 g
s
.711 .66 .797 r
.59052 .21653 m .58548 .24151 L .56998 .24039 L p F P
0 g
s
.7 .65 .797 r
.50805 .23837 m .55474 .23809 L p .55149 .23685 L F P
0 g
s
.711 .66 .797 r
.53911 .23818 m .52356 .23707 L p .53937 .23222 L F P
0 g
s
.7 .65 .797 r
.53937 .23222 m .53916 .23702 L .55149 .23685 L F
.633 .765 .942 r
.52358 .23782 m .52356 .23707 L .53911 .23818 L p F P
0 g
s
.645 .775 .942 r
.52356 .23707 m .52358 .23782 L p .52265 .23786 L F P
0 g
s
.633 .765 .942 r
.53804 .25086 m .54801 .24702 L .56676 .25142 L F
.53825 .24845 m .54801 .24702 L .53804 .25086 L F
.639 .77 .942 r
.50936 .24927 m .53798 .25159 L .53805 .25076 L F
.5094 .24956 m .53798 .25159 L .50936 .24927 L F
.645 .775 .942 r
.48133 .25328 m .50858 .24282 L .50936 .24927 L F
.50936 .24927 m .5094 .24956 L .48159 .25409 L F
.49538 .25184 m .5094 .24956 L .50966 .25175 L F
.013 0 0 r
.51319 .25173 m .50966 .25175 L p .51333 .25173 L F P
0 g
s
.639 .77 .942 r
.50966 .25175 m .53798 .25159 L p .5094 .24956 L F P
0 g
s
0 0 0 r
.48501 .25372 m .48818 .25347 L .48604 .25361 L F
.645 .775 .942 r
.50966 .25175 m .48159 .25409 L p .49538 .25184 L F P
0 g
s
.061 0 0 r
.54993 .25232 m .56352 .25331 L .56217 .25317 L F
.633 .765 .942 r
.56613 .25359 m .53798 .25159 L p .55227 .25151 L F P
0 g
s
.633 .765 .942 r
.55227 .25151 m .56676 .25142 L .56613 .25359 L F
.13 .676 .716 r
.48159 .25409 m .45419 .25855 L p .4554 .25836 L F P
0 g
s
.223 .742 .744 r
.42785 .26505 m .45419 .25855 L p .43533 .26386 L F P
0 g
s
.223 .742 .744 r
.43533 .26386 m .45419 .25855 L .45612 .2583 L F
.326 .809 .779 r
.42785 .26505 m .40296 .27349 L p .43455 .26398 L F P
0 g
s
.433 .872 .815 r
.37986 .28371 m .40296 .27349 L p .38027 .28361 L F P
0 g
s
.538 .925 .847 r
.36008 .29497 m .38974 .28139 L .37986 .28371 L F
.37986 .28371 m .35885 .29553 L p .36008 .29497 L F P
0 g
s
.68 .788 .932 r
.35885 .29553 m .37986 .28371 L p .37756 .28205 L F P
0 g
s
.623 .606 .812 r
.34301 .28661 m .37755 .26699 L p .3744 .2673 L F P
0 g
s
.673 .787 .935 r
.35416 .27975 m .35333 .27921 L .36591 .2736 L p F P
0 g
s
.609 .601 .818 r
.33888 .25789 m .35255 .27806 L p .34246 .28587 L F P
0 g
s
.609 .601 .818 r
.33557 .27654 m .33888 .25789 L .34246 .28587 L F
.32272 .30116 m .32326 .29971 L .33254 .29355 L F
.68 .788 .932 r
.3316 .29309 m .33254 .29355 L p .33304 .29322 L F P
0 g
s
.633 .964 .872 r
.34019 .30877 m .35885 .29553 L p .34974 .3021 L F P
0 g
s
.775 .989 .892 r
.3241 .32321 m .33091 .31536 L p .32936 .32129 L F P
0 g
s
.693 .788 .924 r
.3241 .32321 m .34019 .30877 L p .321 .32219 L F P
0 g
s
.713 .985 .887 r
.34358 .3161 m .35824 .30301 L p .33106 .32067 L F P
0 g
s
.713 .985 .887 r
.34019 .30877 m .3241 .32321 L p .35405 .30435 L F P
0 g
s
.713 .985 .887 r
.32936 .32129 m .35405 .30435 L .3241 .32321 L F
.633 .964 .872 r
.35597 .30373 m .36888 .29277 L .35824 .30301 L F
.538 .925 .847 r
.36327 .29431 m .36961 .29256 L .37222 .29004 L F
.633 .964 .872 r
.35597 .30373 m .36392 .29414 L .36888 .29277 L F
.36888 .29277 m .36961 .29256 L .35824 .30301 L F
.433 .872 .815 r
.39242 .28076 m .40625 .27284 L .41042 .27203 L F
.38379 .28494 m .39089 .28112 L .39242 .28076 L F
.39089 .28112 m .40625 .27284 L .39242 .28076 L F
.538 .925 .847 r
.36961 .29256 m .39422 .28033 L .39262 .28071 L F
.37222 .29004 m .36961 .29256 L .39262 .28071 L F
.37222 .29004 m .39262 .28071 L .39089 .28112 L F
.433 .872 .815 r
.39242 .28076 m .41042 .27203 L .39422 .28033 L F
.41042 .27203 m .41097 .27192 L .39422 .28033 L F
.326 .809 .779 r
.41042 .27203 m .43759 .2635 L .43637 .26369 L F
.41097 .27192 m .43759 .2635 L .41042 .27203 L F
.223 .742 .744 r
.43637 .26369 m .45612 .2583 L .45858 .25799 L F
.43533 .26386 m .45612 .2583 L .43637 .26369 L F
.326 .809 .779 r
.40625 .27284 m .43637 .26369 L .43533 .26386 L F
.40673 .27275 m .43637 .26369 L .40625 .27284 L F
.40673 .27275 m .41042 .27203 L .43637 .26369 L F
.13 .676 .716 r
.45612 .2583 m .4589 .25795 L .46551 .25681 L F
0 .496 .712 r
.57548 .25514 m .58699 .25689 L .5794 .25572 L F
.58558 .25663 m .58854 .25709 L .58927 .25718 L F
0 .463 .772 r
.61689 .26341 m .61452 .26304 L .62793 .26764 L F
0 .475 .738 r
.58783 .257 m .61452 .26304 L .58699 .25689 L F
.61452 .26304 m .6141 .26297 L .58699 .25689 L F
.61093 .26248 m .58699 .25689 L p .60032 .25988 L F P
0 g
s
.223 .742 .744 r
.46134 .25763 m .43759 .2635 L p .44803 .26078 L F P
0 g
s
.13 .676 .716 r
.4589 .25795 m .46134 .25763 L .47504 .25535 L F
.433 .872 .815 r
.41512 .27111 m .39422 .28033 L p .40242 .27621 L F P
0 g
s
.006 .459 .868 r
.69154 .30109 m .67421 .28929 L p .68573 .29604 L F P
0 g
s
.618 .747 .938 r
.62914 .25197 m .64894 .26857 L .65633 .26126 L F
.615 .74 .935 r
.64894 .26857 m .65633 .26126 L .68222 .27189 L F
.612 .734 .932 r
.67877 .27451 m .67135 .28012 L .70088 .2994 L F
.006 .459 .868 r
.69022 .29362 m .7093 .30666 L p .70811 .30602 L F P
0 g
s
.61 .728 .929 r
.69385 .29149 m .73425 .30509 L .69022 .29362 L F
.78 .747 .823 r
.71822 .28977 m .7265 .29883 L .73583 .30636 L F
.61 .728 .929 r
.72189 .30093 m .7265 .29883 L .73425 .30509 L F
.73425 .30509 m .7346 .30537 L .69022 .29362 L F
.609 .716 .921 r
.7188 .31315 m .74446 .3145 L .73021 .31942 L F
.609 .721 .925 r
.74446 .3145 m .7265 .29883 L p .75231 .3226 L F P
0 g
s
.787 .762 .831 r
.75943 .33125 m .74446 .3145 L p .7459 .31482 L F P
0 g
s
.794 .779 .839 r
.77331 .31914 m .772 .3483 L .77594 .34531 L F
.787 .762 .831 r
.74868 .31024 m .78628 .32382 L .74446 .3145 L F
.78 .747 .823 r
.74446 .3145 m .75338 .32228 L p .7385 .30852 L F P
0 g
s
.78 .747 .823 r
.71822 .28977 m .73583 .30636 L .7385 .30852 L F
.73583 .30636 m .74446 .3145 L .7385 .30852 L F
.61 .728 .929 r
.7265 .29883 m .73683 .30596 L p .73425 .30509 L F P
0 g
s
.61 .728 .929 r
.73425 .30509 m .73683 .30596 L .7346 .30537 L F
.78 .747 .823 r
.71822 .28977 m .71736 .29086 L .7265 .29883 L p F P
0 g
s
.78 .747 .823 r
.7265 .29883 m .74446 .3145 L p .73583 .30636 L F P
0 g
s
.609 .716 .921 r
.72585 .32093 m .7188 .31315 L p .73021 .31942 L F P
0 g
s
.609 .721 .925 r
.72189 .30093 m .71213 .30537 L .73409 .32802 L F
.72585 .32093 m .73409 .32802 L p .71213 .30537 L F P
0 g
s
.609 .716 .921 r
.72585 .32093 m .73123 .32337 L .73437 .32813 L F
.064 .462 .885 r
.73323 .3277 m .73409 .32802 L .72585 .32093 L p F P
0 g
s
.064 .462 .885 r
.72585 .32093 m .7093 .30666 L p .71734 .31373 L F P
0 g
s
.064 .462 .885 r
.71734 .31373 m .73323 .3277 L .72585 .32093 L F
.184 .468 .889 r
.7341 .32892 m .73419 .33396 L .73912 .33597 L F
.124 .465 .891 r
.7397 .33621 m .74659 .3438 L p .73419 .33396 L F P
0 g
s
.184 .468 .889 r
.73409 .32802 m .7341 .32892 L .74327 .3418 L F
.7397 .33621 m .73409 .32802 L p .75528 .35981 L F P
0 g
s
.609 .716 .921 r
.7397 .33621 m .72585 .32093 L p .73437 .32813 L F P
0 g
s
.064 .462 .885 r
.7045 .30515 m .70661 .31402 L .71108 .31562 L F
.70295 .30467 m .70661 .31402 L .7045 .30515 L F
.124 .465 .891 r
.71108 .31562 m .7397 .33621 L .73419 .33396 L F
.71263 .31618 m .7397 .33621 L .71108 .31562 L F
.006 .459 .868 r
.6959 .30034 m .7045 .30515 L .69761 .30299 L F
.064 .462 .885 r
.70911 .3066 m .71108 .31562 L .72524 .3207 L F
.7045 .30515 m .71108 .31562 L .70911 .3066 L F
.124 .465 .891 r
.71263 .31618 m .72585 .32093 L .73863 .33542 L F
.61 .728 .929 r
.7093 .30666 m .69022 .29362 L p .69631 .29523 L F P
0 g
s
.61 .728 .929 r
.69631 .29523 m .7204 .30161 L .7093 .30666 L F
.609 .721 .925 r
.72189 .30093 m .73021 .31942 L .7265 .29883 L F
.7093 .30666 m .72585 .32093 L p .71213 .30537 L F P
0 g
s
.124 .465 .891 r
.72585 .32093 m .7397 .33621 L p .73863 .33542 L F P
0 g
s
.184 .468 .889 r
.73419 .33396 m .71928 .32789 L .73435 .34341 L F
0 .088 .564 r
.7079 .31532 m .71412 .32046 L .69154 .30109 L p F P
0 g
s
0 .141 .653 r
.70661 .31402 m .71928 .32789 L p .70258 .3107 L F P
0 g
s
.124 .465 .891 r
.71928 .32789 m .70661 .31402 L p .7163 .32226 L F P
0 g
s
.006 .459 .868 r
.68131 .29219 m .6959 .30034 L .69154 .30109 L F
0 .145 .657 r
.67869 .29382 m .67918 .29435 L .6786 .29375 L F
0 .198 .722 r
.6786 .29375 m .68686 .3055 L p .67923 .29427 L F P
0 g
s
0 .246 .76 r
.68686 .3055 m .6837 .2993 L p .68643 .30443 L F P
0 g
s
0 .198 .722 r
.6914 .30445 m .67923 .29427 L .68686 .3055 L F
.311 .573 .933 r
.65199 .28073 m .67167 .29225 L .65961 .28966 L F
.817 .752 .791 r
.65468 .29522 m .65952 .28976 L .66412 .29452 L F
.828 .772 .8 r
.65311 .29699 m .64834 .3185 L .65468 .29522 L F
.817 .752 .791 r
.65468 .29522 m .66412 .29452 L .6534 .29667 L F
.6635 .29465 m .66412 .29452 L .66364 .29482 L F
.34 .563 .919 r
.67167 .29225 m .65961 .28966 L .66726 .29946 L F
.828 .772 .8 r
.65581 .2852 m .65311 .29699 L .65468 .29522 L F
.65574 .28512 m .65311 .29699 L .65581 .2852 L F
.96 .802 .641 r
.64507 .31611 m .64585 .31382 L .64834 .3185 L p F P
0 g
s
.885 .699 .646 r
.62313 .33848 m .62244 .35772 L .634 .30128 L F
.91 .73 .646 r
.61845 .35449 m .615 .35097 L p .62191 .34265 L F P
0 g
s
.836 .645 .644 r
.60426 .32981 m .60643 .34478 L .60522 .32562 L F
.86 .671 .645 r
.59685 .33924 m .6142 .28649 L .60426 .32981 L F
.665 .938 .667 r
.33135 .33009 m .34358 .3161 L p .34735 .31657 L F P
0 g
s
.665 .938 .667 r
.34735 .31657 m .34358 .3161 L .34893 .31169 L F
.785 .985 .728 r
.33135 .33009 m .32166 .34479 L p .34569 .31797 L F P
0 g
s
.91 .979 .778 r
.33685 .33953 m .33895 .33239 L p .33172 .34424 L F P
0 g
s
.865 .995 .763 r
.34334 .32579 m .33362 .34636 L p .32756 .33962 L F P
0 g
s
.91 .979 .778 r
.33271 .35355 m .33685 .33953 L p .31628 .36952 L F P
0 g
s
.91 .979 .778 r
.31628 .36952 m .33685 .33953 L .33172 .34424 L F
.865 .995 .763 r
.31458 .35999 m .32166 .34479 L p .32994 .34588 L F P
0 g
s
.785 .985 .728 r
.34334 .32579 m .35214 .31253 L p .32773 .33947 L F P
0 g
s
.666 .785 .937 r
.37755 .26699 m .37827 .26759 L p .38044 .2667 L F P
0 g
s
.687 .789 .928 r
.35227 .28091 m .34525 .28523 L .35333 .27921 L F
.3361 .30699 m .32345 .30148 L .34323 .28674 L F
.3361 .30699 m .34323 .28674 L .34725 .289 L F
.693 .788 .924 r
.33254 .29355 m .3316 .29309 L .32272 .30116 L p F P
0 g
s
.594 .597 .825 r
.30527 .31701 m .3316 .29309 L p .32887 .29384 L F P
0 g
s
.609 .601 .818 r
.32272 .30116 m .31263 .30839 L p .31875 .29661 L F P
0 g
s
.594 .597 .825 r
.31875 .29661 m .32194 .30027 L .32887 .29384 L F
.687 .789 .928 r
.31364 .30878 m .31263 .30839 L .32272 .30116 L p F P
0 g
s
.698 .787 .92 r
.31222 .31018 m .30695 .31536 L .31263 .30839 L F
.30607 .33752 m .30553 .31709 L .31031 .31867 L F
.30454 .33716 m .30553 .31709 L .30607 .33752 L F
.703 .785 .915 r
.30021 .3548 m .31073 .33863 L p .28506 .35245 L F P
0 g
s
.703 .785 .915 r
.28506 .35245 m .31073 .33863 L .30607 .33752 L F
.698 .787 .92 r
.30454 .33716 m .29166 .3341 L .30553 .31709 L F
.693 .788 .924 r
.2966 .32488 m .29769 .32519 L p .29896 .32381 L F P
0 g
s
.578 .594 .832 r
.29083 .3339 m .29097 .33243 L .29769 .32519 L F
.703 .785 .915 r
.29769 .32519 m .2966 .32488 L .29083 .3339 L p F P
0 g
s
.707 .783 .911 r
.26858 .37891 m .27141 .36982 L .27229 .36989 L F
.714 .776 .901 r
.2665 .38835 m .26739 .37886 L p .26687 .38716 L F P
0 g
s
.711 .78 .906 r
.2668 .38835 m .27229 .36989 L .2665 .38835 L F
.27229 .36989 m .2722 .36989 L .2665 .38835 L F
.27141 .36982 m .2665 .38835 L p .2722 .36989 L F P
0 g
s
.544 .589 .85 r
.27141 .36982 m .27117 .36838 L .27509 .3605 L F
.26662 .36673 m .26411 .32679 L .27141 .36982 L F
.526 .589 .86 r
.2665 .38835 m .27392 .36037 L p .27237 .36172 L F P
0 g
s
.707 .783 .911 r
.26858 .37891 m .26739 .37886 L .27141 .36982 L p F P
0 g
s
.711 .78 .906 r
.2665 .38835 m .26407 .39753 L p .2668 .38835 L F P
0 g
s
.714 .776 .901 r
.26476 .40693 m .2665 .38835 L p .26565 .40687 L F P
0 g
s
.714 .776 .901 r
.26565 .40687 m .2665 .38835 L .2668 .38835 L F
.718 .767 .892 r
.28613 .44009 m .26612 .42534 L .27173 .42457 L F
.29285 .44733 m .28447 .44044 L .28613 .44009 L F
.28447 .44044 m .26612 .42534 L .28613 .44009 L F
.442 .598 .91 r
.26392 .45674 m .277 .46062 L .26957 .44305 L F
.277 .46062 m .27767 .46082 L .27375 .45203 L F
.464 .594 .897 r
.26586 .44172 m .25143 .41917 L .27047 .44337 L F
.25143 .41917 m .25315 .4199 L .27047 .44337 L F
.442 .598 .91 r
.277 .46062 m .27375 .45203 L .26659 .43601 L F
.719 .757 .883 r
.28293 .45932 m .27262 .4523 L .29741 .45519 L F
.718 .763 .887 r
.28154 .46773 m .28293 .45932 L .27861 .4625 L F
.28293 .45932 m .27933 .46035 L .27861 .4625 L F
.27933 .46035 m .27922 .46038 L .27861 .4625 L F
.719 .757 .883 r
.27767 .46082 m .27262 .4523 L p .28293 .45932 L F P
0 g
s
.718 .763 .887 r
.27861 .4625 m .28496 .44034 L .27132 .44319 L F
.28124 .46948 m .29741 .45519 L .28293 .45932 L F
.718 .752 .879 r
.30164 .47027 m .30324 .47177 L .30061 .46319 L F
.719 .757 .883 r
.3108 .4783 m .29349 .4854 L p .28757 .47753 L F P
0 g
s
.719 .757 .883 r
.3108 .4783 m .28757 .47753 L .30041 .47282 L F
.718 .752 .879 r
.30061 .46319 m .28232 .46913 L p .28835 .47724 L F P
0 g
s
.719 .757 .883 r
.3108 .4783 m .30041 .47282 L .30193 .47226 L F
.718 .747 .875 r
.30621 .49048 m .29436 .48645 L .31764 .48525 L F
.718 .752 .879 r
.30614 .50116 m .31764 .48525 L .30468 .49118 L F
.716 .741 .