(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     60128,       1450]*)
(*NotebookOutlinePosition[     61265,       1491]*)
(*  CellTagsIndexPosition[     61146,       1483]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "The ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Routines"
}], "Subsection",
  CellTags->"c:6"],

Cell[TextData[{
  "This file contains the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " routines used in the text of the book \"The parabolic reflector antenna \
in Radio Astronomy and Communication\" by Jacob W.M. Baars. They have been \
used to obtain numerical and graphical results throughout the book. They are \
numbered ",
  StyleBox["Mat.x.y",
    FontColor->RGBColor[0, 0, 1]],
  " in the text, where x = chapter number and y= running number, and they are \
identified by the same number in the first line of the expressions in this \
file.\n\nThe routines have been written and tested with ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  5.2. on a Macintosh computer. Some of the routines, in particular those \
with integration of a Bessel function multiplied by a Cos or Sin function, \
produces warning messages, mostly of a style \"Integrand ...is not numerical \
at ...\". However, the calculation is carried through and the results appear \
to be correct.\n\nThese routine, when loaded into ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ", can be adapted to the input parameters desired by the reader to produce \
numerical results for his own cases. "
}], "Text"],

Cell[CellGroupData[{

Cell["Chapter 2 - Geometry of reflector antennas", "Subsubsection"],

Cell[BoxData[{
    StyleBox[\(Mat  .2  .1 - ALMA\ antenna\ geometry;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(dp = 12.0; 
    f = 4.8; m = 20. ; 
    ds = 0.75;\), "\[IndentingNewLine]", \(\[CapitalPsi]\_0 = 
      2\ ArcTan[dp/\((4\ f)\)]\ \((180/\[Pi])\)\), "\n", \(\[CapitalPhi]\_0 = 
      2\ ArcTan[
          dp/\((4\ m\ f)\)] \((180/\[Pi])\)\), "\n", \(e = \((m + 1)\)/\((m - 
            1)\)\), "\n", \(m = \((e + 1)\)/\((e - 1)\)\), "\n", \(fc = \((ds/
            2)\)\ \((Cot[\[CapitalPsi]\_0\ \[Pi]/180] + 
            Cot[\[CapitalPhi]\_0\ \[Pi]/180])\)\), "\n", \(l = 
      fc \((e - 1)\)/2\ e\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326],
  CellTags->"i:1"],

Cell[BoxData[{
    StyleBox[\(Mat  .2  .2 - lateral\ defocus\ pathlength\ error;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(f = 
      4.8; \[Chi] = 0; \[Delta] = 
      0.001;\), "\[IndentingNewLine]", \(dl = \((\[Delta]\ r\ /
                f)\)/\((1 + \((r/\((2\ f)\))\)^2)\);\), \
"\[IndentingNewLine]", \(Plot[1000\ dl, {r, 0, 6}, \ 
      PlotRange \[Rule] {0, 1}, Frame \[Rule] True, \ 
      GridLines \[Rule] \ Automatic, 
      FrameLabel \[Rule] {\ "\<Radius (m)\>", "\<Pathlength (mm)\>"}]\)}], \
"Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326],
  CellTags->"i:1"],

Cell[BoxData[{
    StyleBox[\(Mat  .2  .3 - \ Exact\ vs\ approx\ \ path\ error;\),
      FontColor->RGBColor[0, 0, 1]], "\n", \(f = 4.8; \[Delta] = 
      0.003;\), "\n", \(\[Rho]d = 
      Sqrt[\((r - \[Delta])\)^2 + \((f - 
                r^2/\((4\ f)\))\)^2]; \ \((defocus)\);\), "\n", \(\[Rho]o = 
      Sqrt[r^2 + \((f - 
                r^2/\((4\ f)\))\)^2]; \ \ \ \ \ \ \ \ \ \ \ \ \((in\ \
focus)\);\), "\n", \(dl = \((\[Delta]\ r\ /
              f)\)/\((1 + \((r/\((2\ f)\))\)^2)\); \ \ \ \ \ \ \ \ \ \ \ \ \ \
\ \ \ \ \ \((Eq  .2  .23)\);\), "\n", \(Plot[{10^6 \((dl - \ \((\[Rho]o - \
\[Rho]d)\))\)}, {r, 0, 6}, \ PlotRange \[Rule] {0, 1}, Frame \[Rule] True, \ 
      GridLines \[Rule] \ Automatic, 
      FrameLabel \[Rule] {\ "\<Radius (m)\>", "\<Pathlength \
(\[Mu]m)\>"}]\)}], "Input",
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .2  .4 - Axial\ defocus\ \ approximation\ comparison;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(f = 
      4.8; \ \[Delta] =  .001;\), "\n", 
    RowBox[{\(dl = \(-1000\)\ \((Sqrt[
                  r\^2 + \((f - r\^2\/\(4\ f\) + \[Delta])\)\^2] - \((f + 
                    r\^2\/\(4\ f\) + \[Delta])\))\);\), " "}], "\n", 
    RowBox[{\(dm = 
          1000\ \[Delta]\ 2\ \((r\/\(2\ f\))\)\^2/\((1 + \((r\/\(2\ \
f\))\)\^2)\);\), "                                    "}], "\n", 
    RowBox[{\(db = 1422\ \[Delta]\ r\^2\/\(4\ f\^2\); 
      db1 = 1000\ \[Delta]\ r\^2\/\(4\ f\^2\);\), 
      "                                                                       \
   "}], "\n", \(Plot[{\ dl, \ db, dm, db1}, {r, 0, 6}, Frame -> True, \ 
      GridLines -> Automatic, 
      PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 
              0]}, {Dashing[{0.05, 0.05}], 
            RGBColor[0, 0, 1]}, {RGBColor[1, 0, 1]}}, 
      FrameLabel -> {"\<aperture radius (m)\>", "\<pathlength diff. (mm)\>"}]\
\), "\n", \(Plot[1000\ {\ dm - dl}, {r, 0, 6}, Frame -> True, \ 
      GridLines -> Automatic, 
      FrameLabel -> {"\<aperture radius (m)\>", "\<pathlength diff. \
(\[Mu]m)\>"}]\)}], "Input",
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  Background->GrayLevel[0.833326],
  CellTags->"i:1"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 3. Electromagnetic theory of the reflector antenna", \
"Subsubsection",
  CellTags->"c:10"],

Cell[BoxData[{
    StyleBox[\(Mat  .3  .1 - \ "\<Lambda function\>"\ beam;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(<< 
      Graphics`SurfaceOfRevolution`\), "\[IndentingNewLine]", \(t =. ; 
    u =. ;\), "\[IndentingNewLine]", \(ff = 
      Integrate[\((2/\((1 + 
                  t)\))\) \((2\ r\ \((1 - \((1 - t)\) r^2)\))\)\ BesselJ[0, 
            u\ r], {r, 0, 1}]\), "\[IndentingNewLine]", \(Plot[
      Evaluate[Table[ff, {t, 0, 1}], {u, \(-20\), 20}, PlotRange \[Rule] All, 
        Frame \[Rule] True, GridLines -> Automatic, 
        FrameLabel \[Rule] {"\<angular coordinate u\>", "\<farfield amplitude\
\>"}, PlotStyle \[Rule] {{RGBColor[0, 0, 1]}, {RGBColor[1, 0, 
                0]}}]]\), "\n", \(SurfaceOfRevolution[
      2\ BesselJ[1, u]/u, {u, \(-10\), 10}, 
      BoxRatios -> {1, 1, 1}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{19, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .3  .2 - Contour\ plot\ of\ Lambda\ func;\),
      FontColor->RGBColor[0, 0, 
      1]], "\[IndentingNewLine]", \(u = \((x^2 + 
              y^2)\)^0.5;\), "\[IndentingNewLine]", \(j1 = \((2\ \ BesselJ[1, 
                  u]/u)\)^2;\), "\[IndentingNewLine]", \(ContourPlot[
      Evaluate[j1, {x, \(-10\), 10}, {y, \(-10\), 10}, 
        ContourLines \[Rule] False]]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{19, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .3  .3 - \ Integrated\ beam\ power;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(Plot[
      1 - BesselJ[0, u]^2 - BesselJ[1, u]^2, {u, 0, 12}, \ 
      PlotRange \[Rule] {0, 1}, Frame \[Rule] True, 
      GridLines \[Rule] Automatic\ , \ 
      FrameLabel \[Rule] {"\<angular coordinate u\>", "\<integrated \
power\>"}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{19, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .3  .4 - \ Fresnel\ region\ patterns;\),
      FontColor->RGBColor[0, 0, 1]], "\n", \(\[Lambda] = 0.003; 
    k = 2\ \[Pi]/\[Lambda]; R = 300; 
    u =. ;\), "\n", \(fc = 
        NIntegrate[\ 
          r\ BesselJ[0, u\ r]\ Cos[\(k\ r^2\)\/\(2\ R\)], {r, 0, 
            1}];\), "\n", \(fs = 
        NIntegrate[\ 
          r\ BesselJ[0, u\ r]\ Sin[\(k\ r^2\)\/\(2\ R\)], {r, 0, 
            1}];\), "\n", \(fn = {fc, fs, 
          4\ \((fc^2 + fs^2)\)};\), "\n", \(Plot[
      Evaluate[fn, {u, 0, 30}, \ PlotRange -> All, Frame \[Rule] True, 
        GridLines \[Rule] Automatic, 
        FrameLabel \[Rule] {"\<angular coordinate\>", "\<nearfield level\>"}, 
        PlotStyle -> {{RGBColor[0, 0, 1]}, {RGBColor[1, 0, 0]}, {RGBColor[0, 
                1, 0]}}]]\), "\[IndentingNewLine]", \(SurfaceOfRevolution[
      12 \((fc^2 + fs^2)\), {u, 0, 12}, 
      BoxRatios \[Rule] {1, 1, 1}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{19, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .3  .5 - Fresnel\ region\ Axial\ power;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(\[Lambda] = 2; 
    k = 2\ \[Pi]/\[Lambda];\), "\[IndentingNewLine]", \(Plot[\ 
      1 - Cos[k/\((2\ R)\)], {R,  .01, 1}, 
      Frame -> True, \[IndentingNewLine]GridLines -> Automatic, 
      PlotRange \[Rule] All, 
      FrameLabel -> {"\<Distance R\>", "\<Axial Level\>"}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{19, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .3  .6 - \ Fourier - transform\ example;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(x =. ; 
    u =. ;\), "\[IndentingNewLine]", \(FourierTransform[\((Sign[1 - x] + 
            Sign[1 + x])\)\ \((1 -  .25\ x^2)\), x, 
      u]\), "\[IndentingNewLine]", \(SurfaceOfRevolution[%, {\ u, \(-10\), 
        10}, BoxRatios \[Rule] {1, 1, 1}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{19, Inherited}, {Inherited, Inherited}},
  Background->GrayLevel[0.833326]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 4. Antenna characteristics in practical applications", \
"Subsubsection"],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .1\  - \ free\ Space\ taper\ vs\ f/d - ratio;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(t = 
          20\ Log[10, \((1 + \((1/\((4\ fr)\))\)^2)\)]\ ;\)], "\
\[IndentingNewLine]", 
    StyleBox[\(Plot[t, {fr, 0.25, 2}, Frame \[Rule] True, 
        GridLines \[Rule] Automatic, 
        FrameLabel \[Rule] {"\<f/d\>", "\<free space taper (dB)\>"}]\)]}], \
"Input",
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .2\  - \ taper\  - \ \ decibel\ equivalent;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(Plot[20\ Log[10, \[Tau]], {\[Tau], 0, 1}, 
        GridLines -> Automatic, \ Frame \[Rule] True, 
        PlotRange \[Rule] {\(-35\), 0}, 
        FrameLabel \[Rule] {"\<edge taper\>", "\<taper in dB\>"}]\)]}], \
"Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .3\  - \ illumination\ functions;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(ig = Exp[\(-1.3816\)\ r\^2];\)], "\[IndentingNewLine]", 
    StyleBox[\(ip = 1 - \((1 - 0.251)\) r\^2;\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[{ig, ip}, {r, 0, 1.2}, Frame -> True, 
        GridLines -> Automatic, FrameLabel -> {Radius, Illum . \ Function}, 
        PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 1]}}]\)]}], "Input",\

  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .4\  - \ illumination\ efficiency;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(jg = \((2 \((1 - Exp[\((T\ \
Log[10]/20)\)])\)\^2)\)/\((\((\(-T\)\ Log[10]/20)\) \((1 - 
                    Exp[\((T\ Log[10]/10)\)])\))\);\)], "\[IndentingNewLine]",
   
    StyleBox[\(jp = \(3 \((1 + 10\^\((T/20)\))\)\^2\)\/\(4 \((1 + \
10\^\((T/20)\) + 10\^\((T/10)\))\)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[{jg, jp}, {T, 0, \(-30\)}, Frame -> True, 
        GridLines -> Automatic, 
        PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 1]}}, 
        FrameLabel -> {"\<Taper in dB\>", "\<Illum. Efficiency\>"}]\)]}], \
"Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .5\  - \ farfield\ pattern\ parameters;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[Tau] =. ; 
      g = \((4\/\(1 + \[Tau]\)\ \((\ \[Tau]\ BesselJ[1, u]/u\  + 2\ \((1 - \
\[Tau])\)\ BesselJ[2, u]/u\^2)\))\)\^2;\)], "\[IndentingNewLine]", 
    StyleBox[\(Table[
        FindRoot[g \[Equal]  .5, {u, 1.5}], {\[Tau], 1, 
          0, \(- .2\)}]\)], "\[IndentingNewLine]", 
    StyleBox[\(Table[
        FindMaximum[10\ Log[10, g], {u, 5.19}], {\[Tau], 1, 
          0, \(- .2\)}]\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[Table[10\ Log[10, g], {\[Tau], 1, 0, \(- .2\)}]], {u, 0, 
          10}, Frame -> True, GridLines -> Automatic, 
        FrameLabel -> {"\<u\>", "\<Gain (dB)\>"}, 
        PlotRange \[Rule] {\(-30\), 0}, 
        PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 
                0]}, {RGBColor[0, 0, 1]}, {RGBColor[1, 1, 0]}, {RGBColor[1, 
                0, 1]}, {RGBColor[0, 1, 1]}}]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .6\  - \ beamwidth\ factor;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(da = {1.61634, 1.64895, 1.69239, 1.75311, 1.84397, 
            1.99442};\)], "\n", 
    StyleBox[\(dat = \((2/\[Pi])\)\ da;\)], "\[IndentingNewLine]", 
    StyleBox[\(data = {{1, dat[\([1]\)]}, { .8, dat[\([2]\)]}, { .6, 
              dat[\([3]\)]}, { .4, dat[\([4]\)]}, { .2, dat[\([5]\)]}, {0, 
              dat[\([6]\)]}};\)], "\n", 
    StyleBox[\(fsl3 = Fit[data, {1, x, x^2, x^3}, x]\)], "\n", 
    StyleBox[\(psl = 
        ListPlot[data, PlotStyle \[Rule] PointSize[0.015]]\)], "\n", 
    StyleBox[\(pfsl = 
        Plot[fsl3, {x, 0, 1}, DisplayFunction \[Rule] Identity]\)], "\n", 
    StyleBox[\(Show[{psl, pfsl}, PlotRange \[Rule] {1, 1.3}, 
        Frame \[Rule] True, GridLines \[Rule] Automatic, 
        FrameLabel \[Rule] {"\<taper\>", "\<factor b\>"}]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .7\  - \ sidelobe\ level\ vs\ taper;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(data = {{0, \(-24.6392\)}, { .2, \(-23.4225\)}, { .4, \
\(-21.4776\)}, { .6, \(-19.8295\)}, { .8, \(-18.555\)}, {1, \(-17.57\)}};\)], \
"\[IndentingNewLine]", 
    StyleBox[\(fsl3 = Fit[data, {1, x, x^2, x^3}, x]\)], "\n", 
    StyleBox[\(fsl1 = Fit[data, {1, x}, x]\)], "\[IndentingNewLine]", 
    StyleBox[\(psl = 
        ListPlot[data, 
          PlotStyle \[Rule] PointSize[0.015]]\)], "\[IndentingNewLine]", 
    StyleBox[\(pfsl = 
        Plot[{fsl1, fsl3}, {x, 0, 1}, 
          PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 0]}}, 
          DisplayFunction \[Rule] Identity]\)], "\[IndentingNewLine]", 
    StyleBox[\(Show[{psl, pfsl}, PlotRange \[Rule] {\(-25\), \(-17\)}, 
        Frame \[Rule] True, GridLines \[Rule] Automatic, 
        FrameLabel \[Rule] {"\<taper\>", "\<sidelobe (dB)\>"}]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .8\  - \ axial\ defocus\ gain\ function;\),
      FontColor->RGBColor[0, 0, 
      1]], "\[IndentingNewLine]", \(\[Tau] =. ;\), "\n", \(fc = 
        Integrate[\((2/\((1 + \[Tau])\))\) \((1 - \((1 - \[Tau])\) z)\) 
            Cos[b\ z], {z, 0, 1}];\), "\n", \(fs = 
        Integrate[\((2/\((1 + \[Tau])\))\) \((1 - \((1 - \[Tau])\) z)\) 
            Sin[b\ z], {z, 0, 1}];\), "\n", \(ga = 
        fc\^2 + fs\^2\ ;\), "\n", \(TrigExpand[ga];\), "\n", \(gas = 
      FullSimplify[%]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .9\  - \ axial\ defocus\ approximations;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[Delta] =. ; f = 0.8; \[Lambda] = 0.003; 
      k = 2\ \[Pi]\ /\[Lambda];\)], "\[IndentingNewLine]", 
    StyleBox[\(glc = 
          NIntegrate[
            2  Cos[k\ \((Sqrt[
                        r\^2 + \((f - r\^2\/\(4\ f\) + \[Delta])\)\^2] - \((f \
+ r\^2\/\(4\ f\) + \[Delta])\))\)]\ \ r, {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(gls = 
          NIntegrate[
            2\ Sin[k \((\ 
                    Sqrt[r\^2 + \((f - r\^2\/\(4\ f\) + \[Delta])\)\^2] - \
\((f + r\^2\/\(4\ f\) + \[Delta])\))\)]\ \ r, {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(gbc = 
          NIntegrate[
            2\ Cos[k\ \[Delta]\ 2\ \((r\/\(2\ f\))\)\^2/\((1 + \((r\/\(2\ \
f\))\)\^2)\)]\ r, {r, 0, 1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(gbs = 
          NIntegrate[
            2\ Sin[k\ \[Delta]\ 2\ \((r\/\(2\ f\))\)\^2/\((1 + \((r\/\(2\ \
f\))\)\^2)\)]\ r, {r, 0, 1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(gl = \((glc^2 + gls^2)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(gb = \((gbc^2 + gbs^2)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(gs = \((Sin[
                  1.7649\ \[Delta]/\[Lambda]]/\((1.7649  \
\[Delta]/\[Lambda])\))\)^2;\)], "\[IndentingNewLine]", 
    StyleBox[\(gp = 
          1 - \((\((k\ \[Delta]\ 0.5618)\)^2)\)/12;\)], "\[IndentingNewLine]",
   
    StyleBox[\(Plot[{gp, gl, gb, gs}, {\[Delta], 0,  .015}, 
        PlotRange \[Rule] {0, 1}, Frame -> True, GridLines -> Automatic, 
        FrameLabel -> {"\<Axial defocus (m)\>", "\<Relative Gain\>"}, 
        PlotStyle \[Rule] {{RGBColor[0, 1, 1]}, {RGBColor[1, 0, 
                0]}, {Dashing[{ .05, 0.05}], 
              RGBColor[0, 1, 0]}, {RGBColor[0, 0, 1]}}]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .10\  - \ axial\ defocus\ gain\ plots;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(gax = \(1\/\(b\^4\ \((1 + \[Tau])\)\^2\)\) \((4\ \((2 + b\^2 - 
                    4\ \[Tau] + \((2 + b\^2)\)\ \[Tau]\^2 - 
                    2\ \((1 + \[Tau]\ \((\(-2\) + b\^2 + \[Tau])\))\)\ Cos[
                        b] - 2\ b\ \((\(-1\) + \[Tau])\)\^2\ Sin[
                        b])\))\);\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[Table[gax, {\[Tau], 0, 1,  .25}], {b, 0, 20}, 
          PlotRange \[Rule] {0, 1}, GridLines \[Rule] Automatic, 
          Frame \[Rule] True, 
          FrameLabel \[Rule] {"\<defocus-\[Beta]\>", "\<gain\>"}, 
          PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 
                  0]}, {RGBColor[0, 1, 1]}, {RGBColor[1, 0, 1]}, {RGBColor[0, 
                  0, 1]}}]]\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[Table[10\ Log[10, gax], {\[Tau], 0, 1,  .25}], {b, 0, 20}, 
          PlotRange \[Rule] {\(-30\), 0}, GridLines \[Rule] Automatic, 
          Frame \[Rule] True, 
          FrameLabel \[Rule] {"\<defocus-\[Beta]\>", "\<gain (dB)\>"}, 
          PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 
                  0]}, {RGBColor[0, 1, 1]}, {RGBColor[1, 0, 1]}, {RGBColor[0, 
                  0, 1]}}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .11\  - \ axial\ defocus\ beam\ patterns;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[Delta] =. ; \[Lambda] = 0.003; k = 2\ \[Pi]\ /\[Lambda]; 
      fr = 1;\)], "\[IndentingNewLine]", 
    StyleBox[\(fac = 
          Integrate[\ 
            BesselJ[0, u\ r]\ Cos[0.5618\ k\ \[Delta]\ r\^2]\ r\ , {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(fas = 
          Integrate[
            BesselJ[0, u\ r]\ Sin[0.5618\ k\ \[Delta]\ r\^2]\ r, {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(ga = 4\ \((fac^2 + fas^2)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[
          Table[10\ Log[10, ga], {\[Delta], 0,  .005,  .001}], {u, 0, 10}, 
          PlotRange -> {\(-40\), 0}, Frame -> True, GridLines -> Automatic, 
          FrameLabel -> {"\<angle u\>", "\<gain (dB)\>"}, 
          PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 0]}, {RGBColor[
                  0, 0, 1]}, {RGBColor[1, 1, 0]}, {RGBColor[1, 0, 
                  1]}, {RGBColor[0, 1, 1]}}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .12\  - \ axial\ defocus\ beam\ patterns\  - \ 
          tapered\ illumination;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[Delta] =. ; \[Lambda] = 0.003; k = 2\ \[Pi]\ /\[Lambda]; 
      fr = 1 - 0.75\ r^2;\)], "\[IndentingNewLine]", 
    StyleBox[\(fac = 
          Integrate[
            1.6\ fr\ BesselJ[0, u\ r]\ Cos[
                0.5618\ k\ \[Delta]\ r\^2]\ r\ , {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(fas = 
          Integrate[
            1.6\ fr\ BesselJ[0, u\ r]\ Sin[0.5618\ k\ \[Delta]\ r\^2]\ r, {r, 
              0, 1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(ga = 4\ \((fac^2 + fas^2)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[
          Table[10\ Log[10, ga], {\[Delta], 0,  .005,  .001}], {u, 0, 10}, 
          PlotRange -> {\(-40\), 0}, Frame -> True, GridLines -> Automatic, 
          FrameLabel -> {"\<angle u\>", "\<gain (dB)\>"}, 
          PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 0]}, {RGBColor[
                  0, 0, 1]}, {RGBColor[1, 1, 0]}, {RGBColor[1, 0, 
                  1]}, {RGBColor[0, 1, 1]}}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .13\  - \ lateral\ defocus\ beam\ patterns\  - \ 
          uniform\ illumination;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[CapitalXi] = 1.6; d = 12; \[Lambda] = 0.003; 
      k = 2\ \[Pi]/\[Lambda];\)], "\[IndentingNewLine]", 
    StyleBox[\(fl0 = 
          NIntegrate[
            2\ r*BesselJ[0, 
                r\ \((u - \(2\ k\ 0\)\/\(\[CapitalXi] \((1 + \((\(\(r\)\(\ \)\
\)\/\[CapitalXi])\)\^2)\)\))\)]\ \ , {r, 0, 1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(fl1 = 
          NIntegrate[
            2\ r*BesselJ[0, 
                r\ \((u - \(2\ k\  .001\)\/\(\[CapitalXi] \((1 + \((\(\(r\)\(\
\ \)\)\/\[CapitalXi])\)\^2)\)\))\)]\ \ , {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(fl2 = 
          NIntegrate[
            2\ r*BesselJ[0, 
                r\ \((u - \(2\ k\  .002\)\/\(\[CapitalXi] \((1 + \((\(\(r\)\(\
\ \)\)\/\[CapitalXi])\)\^2)\)\))\)]\ \ , {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(fl3 = 
          NIntegrate[
            2\ r*BesselJ[0, 
                r\ \((u - \(2\ k\  .003\)\/\(\[CapitalXi] \((1 + \((\(\(r\)\(\
\ \)\)\/\[CapitalXi])\)\^2)\)\))\)]\ \ , {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(fl = {fl0^2, fl1^2, fl2^2, fl3^2};\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[10\ Log[10, fl], {u, \(-10\), 20}, 
          PlotRange -> {\(-30\), 0}, Frame -> True, GridLines -> Automatic, 
          PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 0]}, {RGBColor[
                  0, 0, 1]}, {RGBColor[1, 0, 1]}}, 
          FrameLabel -> {"\<angle u\>", "\<Gain (dB)\>"}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .14\  - \ off - axis\ beam\ plot;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[Lambda] = 0.003; 
      k = 2\ \[Pi]/\[Lambda]; \[CapitalXi] = 1.6;\)], "\n", 
    StyleBox[\(i1 = 
          NIntegrate[
            2  r*BesselJ[
                0, \((\((x - \(2\ k\ 0.003\)\/\(\[CapitalXi] \((1 + \((r\/\
\[CapitalXi])\)\^2)\)\))\)\^\(\(2\)\(\ \)\) + y\^2)\)\^ .5\ r]\ , {r, 0, 
              1}];\)], "\n", 
    StyleBox[\(ContourPlot[
        Evaluate[i1^2, {x, \(-5\), 15}, {y, \(-10\), 10}, 
          ContourLines -> False, DisplayFunction \[Rule] Identity]]\)], "\n", 
  
    StyleBox[\(Plot3D[i1\^2, {x, \(-5\), 20}, {y, \(-10\), 10}, 
        BoxRatios \[Rule] {1, 1, 1}, PlotRange \[Rule] All, 
        DisplayFunction \[Rule] Identity]\)], "\n", 
    StyleBox[\(Show[GraphicsArray[{%, %%}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .15\  - \ lateral\ defocus\ beam\ patterns\  - \ 
          tapered\ illumination;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[CapitalXi] = 1.6; d = 12; \[Lambda] = 0.003; 
      k = 2\ \[Pi]/\[Lambda]; \ 
      fr = 2\ r\ \((1 -  .75\ r^2)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(fl0 = 
          NIntegrate[
            fr*BesselJ[0, 
                r\ \((u - \(2\ k\ 0\)\/\(\[CapitalXi] \((1 + \((\(\(r\)\(\ \)\
\)\/\[CapitalXi])\)\^2)\)\))\)]\ \ , {r, 0, 1}];\)], "\n", 
    StyleBox[\(fl1 = 
          NIntegrate[
            fr*BesselJ[0, 
                r\ \((u - \(2\ k\ 0.001\)\/\(\[CapitalXi] \((1 + \((\(\(r\)\(\
\ \)\)\/\[CapitalXi])\)\^2)\)\))\)]\ \ , {r, 0, 1}];\)], "\n", 
    StyleBox[\(fl2 = 
          NIntegrate[
            fr*BesselJ[0, 
                r\ \((u - \(2\ k\ 0.002\)\/\(\[CapitalXi] \((1 + \((\(\(r\)\(\
\ \)\)\/\[CapitalXi])\)\^2)\)\))\)]\ \ , {r, 0, 1}];\)], "\n", 
    StyleBox[\(fl3 = 
          NIntegrate[
            fr*BesselJ[0, 
                r\ \((u - \(2\ k\ 0.003\)\/\(\[CapitalXi] \((1 + \((\(\(r\)\(\
\ \)\)\/\[CapitalXi])\)\^2)\)\))\)]\ \ , {r, 0, 
              1}];\)], "\[IndentingNewLine]", 
    StyleBox[\(FindMaximum[
        10\ Log[10, 2.56\ fl0^2], {u, \(-5\)}]\)], "\[IndentingNewLine]", 
    StyleBox[\(FindMaximum[2.56\ fl0^2, {u, 0}]\)], "\[IndentingNewLine]", 
    StyleBox[\(similar\ expressions\ for\ the\ other\ beams;\)], "\
\[IndentingNewLine]", 
    StyleBox[\(fl = {fl0^2, fl1^2, fl2^2, fl3^2};\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[10\ Log[10, 2.56\ \ fl], {u, \(-10\), 15}, 
          PlotRange -> {\(-30\), 0}, Frame -> True, GridLines -> Automatic, 
          PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 0]}, {RGBColor[
                  0, 0, 1]}, {RGBColor[1, 0, 1]}}, 
          FrameLabel -> {"\<angle u\>", "\<Gain (dB)\>"}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .16\  - \ Beam - D  eviation - Factor; \),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(f =. ; \[Tau] =. ;\),
      FontSize->12], "\[IndentingNewLine]", \(Plot[
      Evaluate[Table[
          Integrate[\(\((1 - \((1 - \[Tau])\)\ r\^2)\)\ r\^3\)\/\(1 + \
\((r\/\(4  f\))\)\^2\), {r, 0, 1}]/
            Integrate[\((1 - \((1 - \[Tau])\)\ r\^2)\)\ r\^3, {r, 0, 
                1}], {\[Tau], 0, 1,  .25}], {f, 0.25, 1}, Frame \[Rule] True, 
        GridLines \[Rule] Automatic, 
        FrameLabel \[Rule] {focal\ ratio, BeamDeviationFactor}, 
        PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                1]}, {RGBColor[1, 1, 1]}, {RGBColor[1, 1, 1]}, {RGBColor[0, 
                1, 0]}}]]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .17\  - \ BDF\ vs\ taper;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(t =. ; 
    f =. ;\), "\[IndentingNewLine]", \(n1 = \[Integral]\_0\%1\(\(\((1 - \((1 \
- 10\^\(\(-t\)/20\))\) 
                        r\^2)\)\ r\^3\)\/\(1 + \((r\/\(4\ f\))\)\^2\)\) \
\[DifferentialD]r;\), "\n", \(d1 = \[Integral]\_0\%1\((1 - \((1 - 
                      10\^\(\(-t\)/20\))\) 
                  r\^2)\)\ \(r\^3\) \[DifferentialD]r;\), "\n", \(BDF = 
        n1/d1;\), "\n", \(Plot[
      Evaluate[Table[BDF, {f,  .35,  .5,  .05}], {t, 0, 30}, Frame -> True, 
        GridLines \[Rule] Automatic, 
        FrameLabel \[Rule] {"\<taper (dB)\>", "\<BDF\>"}, 
        PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 0]}, {RGBColor[0, 
                0, 1]}, {RGBColor[1, 0, 1]}}]]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[
    RowBox[{
      StyleBox[\(Mat  .4  .18\  - BDF\ vs\ f/d\ and\ taper\),
        FontColor->RGBColor[0, 0, 1]], 
      StyleBox[";",
        FontColor->RGBColor[0, 0, 1]], 
      StyleBox[" ",
        FontColor->RGBColor[0, 0, 1]], 
      StyleBox[\(Plot3D[
          Evaluate[BDF, {f,  .25, 1}, {t, 0, 30}, 
            ViewPoint \[Rule] {\(-2\), \(-2\), 0}, 
            BoxRatios \[Rule] {1, 1,  .75}, 
            AxesLabel \[Rule] {"\<f/D-ratio\>", "\<Taper(dB)\>", "\<BDF\>"}, 
            Mesh \[Rule] True]]\)]}]], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        StyleBox[\(Mat  .4  .19\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["Blocking",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["input",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["parameters",
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox[";",
        FontColor->RGBColor[0, 0, 1]]}], "\[IndentingNewLine]", 
    StyleBox[\(Rp = 6.0; \ Rs = 0.375; \ Rq = 4.11; \ 
      F = 4.8;\)], "\[IndentingNewLine]", 
    StyleBox[\(Wl = 0.06; \ 
      n = 4; \ \[Alpha] = 42.89\ \[Pi]/180;\)], "\[IndentingNewLine]", 
    StyleBox[\(\[CapitalPsi]\_0 = 
        2\ ArcTan[Rp/\((2\ \ F)\)]\)], "\[IndentingNewLine]", 
    StyleBox[\(\[Psi] = 2\ ArcTan[Rq/\((2\ \ F)\)]\)], "\[IndentingNewLine]", 
  
    StyleBox[\(\[Tau] = 
        0.75; \ \ \ \((this\ gives\ 12\ dB\ edge\ taper)\);\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        StyleBox[\(Mat  .4  .20\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["blocking",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["formulae",
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox[";",
        FontColor->RGBColor[0, 0, 1]]}], "\[IndentingNewLine]", 
    StyleBox[\(Ar = \[Pi]\ Rp\^2\)], "\[IndentingNewLine]", 
    StyleBox[\(As = \[Pi]\ Rs\^2\)], "\[IndentingNewLine]", 
    StyleBox[\(Abp\_u = n\ Wl \((Rq - Rs)\)\)], "\[IndentingNewLine]", 
    StyleBox[\(Abp\_t = \(\(n\ Wl\ \((1 - \[Tau])\)\)\/\(3\ Rp\^2\)\) \
\((Rq\^3 - Rs\^3)\)\)], "\[IndentingNewLine]", 
    StyleBox[\(AB = 
        Rq \((1 - Tan[\[Alpha]]/Tan[\[Psi]])\)\)], "\[IndentingNewLine]", 
    StyleBox[\(Abs\_u = \(\(n\ Wl\)\/AB\) \((\(Rp\^2 - Rq\^2\)\/2 - \((Rp - 
                    Rq)\) F\ Tan[\[Alpha]] + \(Tan[\[Alpha]]\/\(12\ F\)\) \
\((Rp\^3 - Rq\^3)\))\)\)], "\[IndentingNewLine]", 
    StyleBox[\(Abs\_t = \(\(n\ Wl\ \((1 - \[Tau])\)\)\/\(AB\ Rp\^2\)\) \
\((\((Rp\^4 - Rq\^4)\)\/4 - 
              F\ Tan[\[Alpha]] \((Rp\^3 - Rq\^3)\)\/3 + \(Tan[\[Alpha]]\/\(20\
\ F\)\) \((Rp\^5 - Rq\^5)\))\)\)], "\[IndentingNewLine]", 
    StyleBox[\(Abs\_a = \((n\ Wl/2)\)\ \((Rp - 
              Rq)\) \((1 + \
\(Rp\/Sin[\[CapitalPsi]\_0]\)/\((\(Sin[\[Alpha]]\/Sin[\[CapitalPsi]\_0 - \
\[Alpha]]\) \((Rq\^2\/\(4\ F\) + Rq\/Tan[\[Alpha]] - F)\))\))\)\)]}], "Input",\

  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        StyleBox[\(Mat  .4  .21\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["blocking",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["final",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["calculation",
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox[";",
        FontColor->RGBColor[0, 0, 1]]}], "\[IndentingNewLine]", 
    StyleBox[\(Ab = \ As + Abp\_u + Abs\_u\)], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[\(BlPer = 100\ %/Ar\)], 
      StyleBox["\[IndentingNewLine]"]}], "\[IndentingNewLine]", 
    StyleBox[\(Ab\_a = As + Abp\_u + Abs\_a\)], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[\(BlPer = 100\ %/Ar\)], 
      StyleBox["\[IndentingNewLine]"]}], "\[IndentingNewLine]", 
    StyleBox[\(Ab\_t = Ab - Abp\_t - Abs\_t\)], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[\(BlPer\_t = 100\ %/Ar\)], 
      StyleBox["\[IndentingNewLine]"]}], "\[IndentingNewLine]", 
    StyleBox[\(Ab\_ta = Ab\_a - Abp\_t - Abs\_t\)], "\[IndentingNewLine]", 
    StyleBox[\(BlPer\_at = 100  %/Ar\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .22\  - \ Beam\ of\ annular\ \ apertures;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(fu = 2\ BesselJ[1, u]/u;\)], "\[IndentingNewLine]", 
    StyleBox[\(fb = 
          Integrate[
            2\ BesselJ[0, u\ r]\ r, \ {r, 0.2, 1}];\)], "\[IndentingNewLine]",
   
    StyleBox[\(fl = 
          Integrate[
            2\ BesselJ[0, u\ r]\ r, {r, 0.95, 1}];\)], "\[IndentingNewLine]", 
  
    StyleBox[\(Plot[Evaluate[{fu^2, fb^2, 100\ fl^2}], \ {u, 0, 15}, \ 
        PlotRange \[Rule] All, Frame \[Rule] True, 
        FrameLabel \[Rule] {"\<angle u\>", "\<Power (dB)\>"}, 
        PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 1]}, {RGBColor[0, 
                1, 0]}}]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .23\  - \ full\ "\<Ruze\>"\ formula;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[Lambda] =. ; \(c\^*\) = 0.1; \[Eta]\_A0 = 
        0.72;\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[
          Table[\((Exp[\(-\((\(4\ \[Pi]\ \
\[Epsilon]\)\/\(100*\[Lambda]\))\)\^2\)] + 
                1\/\[Eta]\_A0\ \((\(c\^*\))\)\^2\ \((1 - 
                      Exp[\(-\((\(4\ \[Pi]\ \
\[Epsilon]\)\/\(100*\[Lambda]\))\)\^2\)])\))\), {\[Epsilon], 2, 5, 
              1}]], {\[Lambda],  .3, 3}, 
        FrameLabel -> {"\<\[Lambda] in mm\>", "\<surface eff.\>"}, 
        Frame -> True, GridLines -> Automatic, 
        PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                1]}, {RGBColor[0, 1, 0]}, {RGBColor[0, 1, 1]}}]\)]}], "Input",\

  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .24\  - \ "\<Ruze\>"\ efficiency\ vs\ error;\),
      FontColor->RGBColor[0, 0, 
      1]], "\[IndentingNewLine]", \(\[Lambda] =. ; \[Epsilon] =. ;\), "\
\[IndentingNewLine]", \(Plot[
      Evaluate[Table[
          Exp[\(-\((\(4*\[Pi]*\[Epsilon]\)\/\(1000*\[Lambda]\))\)\^2\)], {\
\[Lambda],  .4, 2,  .4}]], {\[Epsilon], 0, 100}, 
      FrameLabel -> {"\<\[Epsilon] in micron\>", "\<surface eff.\>"}, 
      Frame -> True, GridLines -> Automatic, 
      PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 1]}, {RGBColor[
              0, 1, 0]}, {RGBColor[1, 1, 0]}, {RGBColor[0, 1, 
              1]}}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .25\  - \ the\ "\<Ruze\>"\ surface\ error\ formula;\),
      
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(Plot[
      Exp[\(-\((4\ \[Pi]\ \[Delta])\)^2\)], {\[Delta], 0, 0.1}, 
      Frame \[Rule] True, GridLines \[Rule] Automatic, 
      FrameLabel \[Rule] {"\<\[Epsilon]/\[Lambda]\>", "\<surface \
eff.\>"}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        StyleBox[\(Mat  .4  .26\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["error",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["pattern",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["level",
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox[";",
        FontColor->RGBColor[0, 0, 1]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[\(Plot[
          Evaluate[
            Table[10\ Log[10, 
                  1.4*\(c\^*\)\^2*\((Exp[\((4\ \[Pi]\ \[Delta])\)\^2]\  - 
                        1)\)], {\(c\^*\), 0.05, 0.25, 
                0.05}]], {\[Delta],  .01, 0.1}, Frame -> True, 
          GridLines -> Automatic, 
          FrameLabel -> {"\<\[Epsilon]/\[Lambda]\>", "\<error pattern \
level\>"}, 
          PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 1]}, {RGBColor[
                  0, 1, 0]}, {RGBColor[1, 1, 0]}, {RGBColor[0, 1, 1]}}]\)], 
      StyleBox["  "]}]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .4  .27\  - \ relative\ power\ in\ error\ pattern;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        1.1 \((Exp[\((4\ \[Pi]\ \[Delta])\)\^2] - 1)\), {\[Delta], 0,  .05}, 
        GridLines -> Automatic, Frame -> True, 
        FrameLabel -> {"\<\[Epsilon]/\[Lambda]\>", "\<Power ratio\>"}]\)]}], \
"Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(Mat  .4  .28\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["dropped",
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox["\[IndentingNewLine]",
        FontSize->12]}]], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{7, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        StyleBox[\(Mat  .4  .29\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["beam",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["with",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["astigmatism",
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox[";",
        FontColor->RGBColor[0, 0, 1]]}], "\[IndentingNewLine]", 
    StyleBox[\(\[Alpha] =  .5; \[Phi] =. ;\)], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[\(Plot[
          Evaluate[
            Table[10 
                 Log[10, \((2\ BesselJ[1, u]/
                              u - \((\[Alpha]^2/\((2\ u)\))\)\ \((BesselJ[1, 
                                    u]/3 - BesselJ[3, u]/2 + 
                                BesselJ[5, 
                                    u]\ \((Cos[4\ \[Phi]] + 
                                      1/6)\))\))\)^2 + \ \((\[Alpha]\ 4\ Cos[
                            2\ \[Phi]]\ BesselJ[3, u]/u)\)^2], {\[Phi], 0, 
                2\ \[Pi]/8, \[Pi]/8}], {u, 0, 8}, \ 
            PlotRange \[Rule] {\(-30\), 0}, Frame -> True, 
            GridLines -> Automatic, 
            FrameLabel \[Rule] {"\<angle u\>", \ "\<power level (dB)\>"}, 
            PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                    1]}, {RGBColor[0, 1, 0]}}]]\)], 
      StyleBox[" "]}], "\[IndentingNewLine]", 
    StyleBox[\(Show[{%}, PlotRange -> {{1.5, 1.65}, {\(-3.4\), \(-2.6\)}}, 
        FrameLabel \[Rule] {"\<angle u\>", \ "\<power level (dB)\>"}]\)]}], \
"Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{8, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 5. Measurement of antenna parameters", "Subsubsection"],

Cell[BoxData[{
    StyleBox[\(Mat  .5  .1\  - \ ext . \ source\ correction\ factors;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(kd = \((x/1.2)\)^2/\((1 - Exp[\(-\((x/1.2)\)^2\)])\); 
      kg = 1 + x^2;\)], "\[IndentingNewLine]", 
    StyleBox[\(\[Theta]g = Sqrt[1 + x^2]; \[Theta]d = 
        Sqrt[1 + \((Log[2]/2)\)\ x^2];\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[{kg, kd, \[Theta]g, \[Theta]d}, {x, 0, 1}, 
          PlotRange \[Rule] All, GridLines \[Rule] Automatic, 
          Frame \[Rule] True, 
          FrameLabel \[Rule] {"\<source size/beam width\>", \
"\<Corr.Factor\>"}, 
          PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 
                  0]}, {Dashing[{ .05,  .05}], 
                RGBColor[0, 0, 1]}, {Dashing[{ .05,  .05}], 
                RGBColor[1, 0, 1]}}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{3, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        StyleBox[\(Mat  .5  .2\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\(convolution\ with\ straight\ edge\ of\ gauss\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\(and\ lambda\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["beams",
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox[";",
        FontColor->RGBColor[0, 0, 1]]}], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[" "], 
      StyleBox[\(\[Theta] = 4; x =. ; u =. ;\)]}], "\[IndentingNewLine]", 
    StyleBox[\(con = 
          Integrate[\ 
            Exp[\(-\((\((x - u)\)/\(( .6006\ \[Theta])\))\)^2\)] 
              UnitStep[u], {u, \(-50\), 50}];\)], "\n", 
    StyleBox[\(cov = 
          Integrate[\ 
            2\ BesselJ[1, \((x - u)\)]/\ \((x - u)\)\ UnitStep[
                u], {u, \(-50\), 50}];\)], "\[IndentingNewLine]", 
    StyleBox[\(din = D[con, x];\)], "\n", 
    StyleBox[\(div = D[cov, x];\)], "\[IndentingNewLine]", 
    StyleBox[\(cv = 
        Plot[{con, cov}, {x, \(-10\), 10}, DisplayFunction \[Rule] Identity, 
          GridLines -> Automatic, Frame -> True, 
          PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                  1]}}]\)], "\[IndentingNewLine]", 
    StyleBox[\(di = 
        Plot[{din, div}, {x, \(-10\), 10}, PlotRange \[Rule] All, 
          GridLines -> Automatic, Frame -> True, 
          PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 1]}}, 
          DisplayFunction \[Rule] Identity]\)], "\[IndentingNewLine]", 
    StyleBox[\(Show[GraphicsArray[{cv, di}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{3, Inherited}, {Inherited, Inherited}},
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    RowBox[{
      RowBox[{
        StyleBox[\(Mat  .5  .3\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["Gaussian",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[\(and\ Lambda\),
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["-",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox[" ",
          FontColor->RGBColor[0, 0, 1]], 
        StyleBox["beam",
          FontColor->RGBColor[0, 0, 1]]}], 
      StyleBox[";",
        FontColor->RGBColor[0, 0, 1]]}], "\[IndentingNewLine]", 
    StyleBox[\(\[Tau] = 0.25; u = 1.82\ x; 
      gl = \((2\/\(1 + \[Tau]\)\ \((2\ \[Tau]\ BesselJ[1, u]/u\  + 4\ \((1 - \
\[Tau])\)\ BesselJ[2, u]/u\^2)\))\)\^2;\)], "\[IndentingNewLine]", 
    StyleBox[\(gg = Exp[\(-\((x^2/\((0.6006\ 2)\)^2)\)\)];\)], "\n", 
    StyleBox[\(pi = 
        Plot[Evaluate[{gl, gg}, {x, 0, 3}, DisplayFunction \[Rule] Identity, 
            GridLines -> Automatic, Frame -> True, 
            FrameLabel -> {"\<ang. coor.\>", "\<level (lin)\>"}, \ 
            PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                    1]}}]]\)], "\[IndentingNewLine]", 
    StyleBox[\(pl = 
        Plot[Evaluate[10\ Log[10, {gl, gg}], {x, 0, 3}, 
            PlotRange -> {\(-50\), 0}, DisplayFunction \[Rule] Identity, 
            GridLines -> Automatic, Frame -> True, 
            FrameLabel -> {"\<ang. coor.\>", "\<level (dB)\>"}, 
            PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                    1]}}]]\)], "\[IndentingNewLine]", 
    StyleBox[\(Show[GraphicsArray[{pi, pl}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{3, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .5  .4  a - data - preparation - fit;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    RowBox[{
      StyleBox[\(datl = {3.5, 2.75, 2.1, 1.3, 1.13,  .87};\)], 
      StyleBox[" "]}], "\[IndentingNewLine]", 
    StyleBox[\(di = 1/%^2;\)], "\n", 
    RowBox[{\(datf = { .53,  .5,  .45,  .27,  .21,  .1};\), 
      " "}], "\n", \(dl = 
        Log[%];\), "\[IndentingNewLine]", \(dat = {{di[\([\)\(1\)\(]\)], 
            dl[\([\)\(1\)\(]\)]}, {di[\([\)\(2\)\(]\)], 
            dl[\([\)\(2\)\(]\)]}, {di[\([\)\(3\)\(]\)], 
            dl[\([\)\(3\)\(]\)]}, {di[\([\)\(4\)\(]\)], 
            dl[\([\)\(4\)\(]\)]}, {di[\([\)\(5\)\(]\)], 
            dl[\([\)\(5\)\(]\)]}, {di[\([\)\(6\)\(]\)], 
            dl[\([\)\(6\)\(]\)]}};\), "\n", \(fd = 
      Fit[dat, {1, x}, x]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{3, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .5  .4  b\  - \ plot\ of\ error\ calculation;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", \(\[Epsilon] = 
      Sqrt[1.35212]/\((4\ \[Pi])\)\), "\n", \(\[Eta]A0 = 
      Exp[\(- .51\)]\), "\n", \(lpd = 
      ListPlot[dat, PlotStyle \[Rule] PointSize[0.015]]\), "\n", \(pfd = 
      Plot[fd, {x, 0, 1.5}]\), "\n", \(Show[{pfd, lpd}, Frame \[Rule] True, 
      GridLines \[Rule] Automatic, 
      FrameLabel \[Rule] {\*"\"\<1/\!\(\[Lambda]\^2\)\>\"", \*"\"\<Log \!\(\
\[Eta]\_A\)\>\""}]\)}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{3, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .5  .6\  - \ Radio\ spectrum\ of\ Cassiopeia\ A;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(<< Graphics`\)], "\[IndentingNewLine]", 
    StyleBox[\(S\[Nu]\ in\ Jy; \[Nu]\ in\ GHz;\)], "\n", 
    StyleBox[\(\[Nu] =. ; t = AD - 1965; 
      d = t\ \((0.97 - 0.3\ Log[10, \[Nu]])\)/100;\)], "\n", 
    StyleBox[\(S\[Nu] = \((1 - 
                d)\)*10^\((\((5.88 - 
                    0.792\ \ Log[10, 1000\ \[Nu]])\))\);\)], "\n", 
    StyleBox[\(fl = 
        Table[S\[Nu], {\[Nu], 1, 31, 10}, {AD, 1965, 2010, 15}]\)], "\n", 
    StyleBox[\(data = {{1, fl[\([1, 4]\)]}, {11, fl[\([2, 4]\)]}, {21, 
              fl[\([3, 4]\)]}};\)], "\n", 
    StyleBox[\(Fit[Log[10, data], {1, x}, x]\)], "\[IndentingNewLine]", 
    StyleBox[\(LogLogPlot[
        Evaluate[Table[S\[Nu], {AD, 1965, 2010, 15}], {\[Nu],  .3, 30}, 
          Frame \[Rule] True, GridLines -> Automatic, 
          FrameLabel \[Rule] {"\<Frequency (GHz)\>", "\<Flux density \
(Jy)\>"}, 
          PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 
                  0]}, {RGBColor[0, 0, 1]}, {RGBColor[1, 0, 
                  1]}}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{3, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .5  .5\  - \ simulation\ of\ pointing\ measurement;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(data = {{\(-2\), 7.4}, {\(-1\), 8. }, {0, 8}, {1, 7.1}, {2, 
              5}};\)], "\n", 
    StyleBox[\(ld = 
        ListPlot[data, PlotStyle \[Rule] PointSize[0.02]]\)], "\n", 
    StyleBox[\(fd = Fit[data, {1, x, x^2}, x]\)], "\n", 
    StyleBox[\(FindMaximum[fd, {x, 0}]\)], "\n", 
    StyleBox[\(pf = 
        Plot[fd, {x, \(-3\), 3}, DisplayFunction \[Rule] Identity]\)], "\n", 
    StyleBox[\(Show[ld, pf]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{3, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Chapter 6. Miscellaneous subjects", "Subsubsection"],

Cell[BoxData[{
    StyleBox[\(Mat  .6  .1\  - \ near\ field\ path\ length\ error;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(Clear[\[Delta]f]; R = 315; 
      f = 4.80; \[Delta]f =  .096;\)], "\[IndentingNewLine]", 
    StyleBox[\(\[Lambda] = 0.003; 
      k = 2\ \[Pi]/\[Lambda];\)], "\[IndentingNewLine]", 
    StyleBox[\(dp = 
          c^2/\((2\ R)\) - c^4/\((8\ R^3)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(dc = \((c^2 + \((f - 
                        c^2\/\(4\ f\) + \[Delta]f)\)^2)\)^0.5 - \((f + 
                c^2\/\(4\ f\) + \[Delta]f)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(php = Cos[k\ dp]; phc = Cos[k\ dc];\)], "\[IndentingNewLine]", 
  
    StyleBox[\(Plot[{php, phc}, {c, 0, 6}, PlotRange \[Rule] All, 
        Frame \[Rule] True, GridLines \[Rule] Automatic, 
        FrameLabel \[Rule] {"\<Radius in m\>", "\<Phase\>"}, 
        PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 
                1]}}]\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[php - phc, {c, 0, 6}, GridLines \[Rule] Automatic, 
        FrameLabel \[Rule] {"\<Radius in m\>", "\<Phase-Diff\>"}, 
        Frame \[Rule] True]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .6  .2\  - \ path\ length\ and\ defocus;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(Clear[\[Delta]f]; R = 315; f = 4.80; \[Lambda] = 0.003; 
      k = 2\ \[Pi]/\[Lambda];\)], "\[IndentingNewLine]", 
    StyleBox[\(dp = 
          c^2/\((2\ R)\) - c^4/\((8\ R^3)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(dc = \((c^2 + \((f - 
                        c^2\/\(4\ f\) + \[Delta]f)\)^2)\)^0.5 - \((f + 
                c^2\/\(4\ f\) + \[Delta]f)\);\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[
          Table[\ 1000 \((dp + dc)\), {\[Delta]f, 0.080, 0.096, 0.016}], {c, 
            0, 6}, PlotRange \[Rule] All, Frame \[Rule] True, 
          GridLines \[Rule] Automatic, 
          PlotStyle -> {{RGBColor[1, 0, 0]}, {RGBColor[0, 0, 1]}}, 
          FrameLabel \[Rule] {"\<Radius in m\>", "\<Path-Diff.in \
mm\>"}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .6  .3\  - \ atmospheric\ phase\ vs\ altitude;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[Lambda] = 0.003; k = 2\ \[Pi]/\[Lambda]; 
      h0 = 3200; \[Rho] =. ; 
      cc = 4.2\ 10^\(-14\)\ h^\((\(-1\)/3)\)\ Exp[\(-h\)/
              h0];\)], "\[IndentingNewLine]", 
    StyleBox[\(ph = 
          Sqrt[2.91\ k^2\ \[Rho]^\((5/3)\)\ Integrate[
                cc, {h, ht, \[Infinity]}]];\)], "\[IndentingNewLine]", 
    StyleBox[\(Plot[
        Evaluate[Table[ph, {\[Rho], 100, 1600, 500}], {ht, 0, 4000}, 
          Frame \[Rule] True, GridLines \[Rule] Automatic, 
          FrameLabel \[Rule] {"\<Altitude in m\>", "\<Phase in rad\>"}, 
          PlotStyle \[Rule] {{RGBColor[1, 0, 0]}, {RGBColor[0, 1, 
                  0]}, {RGBColor[0, 0, 1]}, {RGBColor[1, 0, 
                  1]}}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]],

Cell[BoxData[{
    StyleBox[\(Mat  .6  .4\  - \ 
          relative\ \ atmospheric\ amplitude\ fluctuation;\),
      FontColor->RGBColor[0, 0, 1]], "\[IndentingNewLine]", 
    StyleBox[\(\[Lambda] =. ; k = 2\ \[Pi]/\((\[Lambda]/1000)\); 
      h0 = 3200;\)], "\n", 
    StyleBox[\(cc = 
          4.2\ 10^\(-14\)\ h^\((\(-1\)/3)\)\ Exp[\(-h\)/h0];\)], "\n", 
    StyleBox[\(am2 = 
          0.56\ k^\((7/6)\)\ Integrate[
              cc*h^\((5/6)\)\ , {h, el, \[Infinity]}];\)], "\n", 
    StyleBox[\(dT = Exp[2\ Sqrt[am2]];\)], "\n", 
    StyleBox[\(Plot[
        Evaluate[Table[dT - 1, {el, 0, 4000, 2000}], {\[Lambda], 0.5, 10}, 
          Frame \[Rule] True, GridLines \[Rule] Automatic, 
          FrameLabel \[Rule] {"\<Wavelength (mm)\>", "\<Rel. Power Fluc.\>"}, 
          PlotStyle \[Rule] {{RGBColor[0, 0, 1]}, {RGBColor[1, 0, 
                  0]}, {RGBColor[0, 1, 0]}}]]\)]}], "Input",
  PageWidth->PaperWidth,
  CellFrame->True,
  CellMargins->{{6, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left,
  TextJustification->1,
  Background->GrayLevel[0.833326]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Macintosh",
ScreenRectangle->{{0, 1680}, {0, 987}},
WindowToolbars->{"RulerBar", "EditBar"},
WindowSize->{520, 740},
WindowMargins->{{Automatic, 340}, {Automatic, 10}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "c:6"->{
    Cell[1776, 53, 128, 6, 38, "Subsection",
      CellTags->"c:6"]},
  "i:1"->{
    Cell[3218, 91, 849, 18, 155, "Input",
      CellTags->"i:1"],
    Cell[4070, 111, 742, 17, 123, "Input",
      CellTags->"i:1"],
    Cell[5732, 149, 1389, 26, 386, "Input",
      CellTags->"i:1"]},
  "c:10"->{
    Cell[7158, 180, 105, 2, 28, "Subsubsection",
      CellTags->"c:10"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"c:6", 60751, 1466},
  {"i:1", 60832, 1469},
  {"c:10", 61046, 1476}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 128, 6, 38, "Subsection",
  CellTags->"c:6"],
Cell[1907, 61, 1216, 24, 262, "Text"],

Cell[CellGroupData[{
Cell[3148, 89, 67, 0, 28, "Subsubsection"],
Cell[3218, 91, 849, 18, 155, "Input",
  CellTags->"i:1"],
Cell[4070, 111, 742, 17, 123, "Input",
  CellTags->"i:1"],
Cell[4815, 130, 914, 17, 155, "Input"],
Cell[5732, 149, 1389, 26, 386, "Input",
  CellTags->"i:1"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7158, 180, 105, 2, 28, "Subsubsection",
  CellTags->"c:10"],
Cell[7266, 184, 1032, 20, 219, "Input"],
Cell[8301, 206, 602, 13, 107, "Input"],
Cell[8906, 221, 573, 13, 107, "Input"],
Cell[9482, 236, 1125, 24, 272, "Input"],
Cell[10610, 262, 615, 13, 107, "Input"],
Cell[11228, 277, 544, 10, 123, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11809, 292, 87, 1, 28, "Subsubsection"],
Cell[11899, 295, 550, 12, 107, "Input"],
Cell[12452, 309, 566, 13, 91, "Input"],
Cell[13021, 324, 683, 14, 145, "Input"],
Cell[13707, 340, 888, 19, 185, "Input"],
Cell[14598, 361, 1210, 25, 239, "Input"],
Cell[15811, 388, 1115, 22, 203, "Input"],
Cell[16929, 412, 1167, 23, 219, "Input"],
Cell[18099, 437, 719, 15, 141, "Input"],
Cell[18821, 454, 2072, 44, 481, "Input"],
Cell[20896, 500, 1581, 29, 329, "Input"],
Cell[22480, 531, 1302, 27, 266, "Input"],
Cell[23785, 560, 1386, 29, 282, "Input"],
Cell[25174, 591, 1894, 41, 468, "Input"],
Cell[27071, 634, 1071, 24, 237, "Input"],
Cell[28145, 660, 2124, 45, 516, "Input"],
Cell[30272, 707, 978, 20, 250, "Input"],
Cell[31253, 729, 1026, 20, 245, "Input"],
Cell[32282, 751, 730, 19, 107, "Input"],
Cell[33015, 772, 1400, 38, 123, "Input"],
Cell[34418, 812, 1874, 43, 346, "Input"],
Cell[36295, 857, 1622, 42, 219, "Input"],
Cell[37920, 901, 949, 22, 171, "Input"],
Cell[38872, 925, 1026, 23, 221, "Input"],
Cell[39901, 950, 845, 18, 178, "Input"],
Cell[40749, 970, 563, 13, 91, "Input"],
Cell[41315, 985, 1504, 41, 185, "Input"],
Cell[42822, 1028, 567, 13, 99, "Input"],
Cell[43392, 1043, 638, 20, 59, "Input"],
Cell[44033, 1065, 2068, 50, 331, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[46138, 1120, 69, 0, 28, "Subsubsection"],
Cell[46210, 1122, 1059, 22, 171, "Input"],
Cell[47272, 1146, 2146, 52, 315, "Input"],
Cell[49421, 1200, 2033, 48, 303, "Input"],
Cell[51457, 1250, 1020, 22, 171, "Input"],
Cell[52480, 1274, 736, 15, 146, "Input"],
Cell[53219, 1291, 1375, 28, 235, "Input"],
Cell[54597, 1321, 778, 17, 139, "Input"]
}, Open  ]],

Cell[CellGroupData[{
Cell[55412, 1343, 58, 0, 28, "Subsubsection"],
Cell[55473, 1345, 1365, 27, 254, "Input"],
Cell[56841, 1374, 1108, 23, 206, "Input"],
Cell[57952, 1399, 1062, 22, 171, "Input"],
Cell[59017, 1423, 1083, 23, 187, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

