/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HelpViewer
extends JFrame
implements HyperlinkListener,
ActionListener {
    private JEditorPane htmlPane;
    private URL initialURL;
    private String viewerTitle;

    public HelpViewer(URL initialURL, String viewerTitle) {
        super(viewerTitle);
        this.initialURL = initialURL;
        try {
            this.htmlPane = new JEditorPane(initialURL);
            this.htmlPane.setEditable(false);
            this.htmlPane.addHyperlinkListener(this);
            JScrollPane scrollPane = new JScrollPane(this.htmlPane);
            this.getContentPane().add((Component)scrollPane, "Center");
        }
        catch (IOException ioe) {
            this.warnUser("Can't build HTML pane for " + initialURL + ": " + ioe);
        }
        Dimension screenSize = this.getToolkit().getScreenSize();
        int width = screenSize.width * 8 / 10;
        int height = screenSize.height * 8 / 10;
        this.setBounds(width / 8, height / 8, width, height);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent event) {
        URL url = this.initialURL;
        try {
            this.htmlPane.setPage(new URL(url.toString()));
        }
        catch (IOException ioe) {
            this.warnUser("Can't follow link to " + url + ": " + ioe);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            try {
                this.htmlPane.setPage(event.getURL());
            }
            catch (IOException ioe) {
                this.warnUser("Cannot follow link to " + event.getURL().toExternalForm() + ": " + ioe);
            }
        }
    }

    private void warnUser(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }
}

