package guiDomain;
import dataServerDomain.*;
import guiDomain.*;
import graphicsDomain.*;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class ConnectDialog extends JDialog
{
    private JTextField serverField;
    private JTextField portField;
    private JButton okButton;
    private JButton cancelButton;

    private String server;
    private int port;
    private boolean okPressed;

    /** @param mode Is this dialog modal? */
    public ConnectDialog(JFrame parent, String title, boolean mode)
    {
        super( parent, title, mode );

        Container mainPane = getContentPane();
        mainPane.setLayout( new BorderLayout() );

        // data panel
        JPanel dataPanel = new JPanel();
        dataPanel.setLayout( new GridLayout( 2, 2 ) );
        serverField = new JTextField( "localhost" );
        portField = new JTextField( "8000" );
        dataPanel.add( new JLabel( "Server" ) );
        dataPanel.add( serverField );
        dataPanel.add( new JLabel( "Port" ) );
        dataPanel.add( portField );
        mainPane.add( dataPanel, BorderLayout.CENTER );

	// button panel
        JPanel buttonPanel = new JPanel();
        okButton = new JButton( "Ok" );
        okButton.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent event )
            {
                if ( validateFields() )
                {
                    okPressed = true;
                    setVisible( false );
                }
            }

        }
        );
        cancelButton = new JButton( "Cancel" );
        cancelButton.addActionListener( new ActionListener()
        {
            public void actionPerformed( ActionEvent event )
            {
                setVisible( false );
            }

        }
        );
        buttonPanel.add( okButton );
        buttonPanel.add( cancelButton );
        mainPane.add( buttonPanel, BorderLayout.SOUTH );

        setBounds( 200, 200, 300, 200 );
    }

    /** Make the dialog visible and set okPressed to "false"*/
    public boolean showDialog()
    {
        okPressed=false;
        this.setVisible(true);
        return okPressed;
    }

    /** Checks the server and port fields for valid input
        @return "true" if fields are valid, "false" otherwise */
    private boolean validateFields()
    {
        String porttmp;
        try
        {
            server = serverField.getText();
            porttmp = portField.getText();

        }
        catch ( NullPointerException e )
        {
            JOptionPane.showMessageDialog( this,
            "Error retrieving data from fields",
            "Invalid Entry",
            JOptionPane.ERROR_MESSAGE );
            return false;
        }

        try
        {
            port = Integer.parseInt( porttmp );
        }
        catch ( NumberFormatException e )
        {
            JOptionPane.showMessageDialog( this,
            "Invalid Port Number",
            "Invalid Entry",
            JOptionPane.ERROR_MESSAGE );
            return false;
        }

        if ( port <= 0 || port >= 65536 )
        {
            JOptionPane.showMessageDialog( this,
            "Invalid Port Number",
            "Invalid Entry",
            JOptionPane.ERROR_MESSAGE );
            return false;
        }

        return true;
    }

    // get and set methods
    /** @return The server and port separated by a colon */
    public String getServer()
    {
        return server + ":" + port;
    }
}
