package graphicsDomain;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;

//Encaplulates methods for drawing a centered message. Used to display error
//messages in Graph panels
public class DrawCentredMessage extends GraphDecorator
{
    String message;

    public DrawCentredMessage(GraphMediator med) { super(med);}

    public void drawThis(Graphics2D g2)
    {
        //Set appearance as defined in GraphOptionsInGraphics instance
        g2.setColor(med.getGraphOptions().selectColor(
            med.getGraphOptions().getTitleColor()));
        g2.setStroke(med.getGraphOptions().getTitleStroke());

        g2.setFont(med.getGraphOptions().getTitleFont());

        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = med.getGraphOptions().getTitleFont().
            getStringBounds(message, context);
        double stringWidth = bounds.getWidth();
        double stringHeight = bounds.getHeight();

        //Draw Centered message
        int xp = (int) ( (med.getXSize() - stringWidth) / 2.0);
        int yp = (int) (med.getYSize() / 2. +
                        (med.getBorderSize() - stringHeight) / 2.0);
        g2.drawString(message, xp, yp);
    }

    public void setMessage(String message)
    {
        this.message = message;
    }
    public String toString()
    {
        return "DrawCentredMessage";
    }

}
