package graphicsDomain;

import java.awt.*;

//Encapsulates methods for drawing a zoom box
public class DrawZoomBox  extends GraphDecorator
{
    //Pixel coordinates of the zoom box rectangle
    private int startX, endX, startY, endY;

    //Zooming flag
    private boolean isZooming = false;

    public DrawZoomBox(GraphMediator med) { super(med);}

    //Accessor methods
    public void setStartX(int startX)
    {
        this.startX = startX;
    }
    public void setEndX(int endX)
    {
        this.endX = endX;
    }
    public void setStartY(int startY)
    {
        this.startY = startY;
    }
    public void setEndY(int endY)
    {
        this.endY = endY;
    }
    public void setZooming(boolean isZooming)
    {
        this.isZooming = isZooming;
    }

    //Draw implementation
    public void drawThis(Graphics2D g2)
    {
        //If not zooming, no zoom box is drawn
        if(!isZooming) return;
        //Otherwise draw the zoom box
        g2.setStroke(med.getGraphOptions().getLineStroke());
        g2.drawRect(startX, startY, endX - startX, endY - startY);
    }
    public String toString()
    {
        return "DrawZoomBox";
    }

}
