package dataServerDomain;
import sharedDataInterfaces.GraphDataInterface;

/** Holds plot data, labels, title and shot number*/
public class GraphData implements GraphDataInterface
{
    private double[] x={},y={};
    private String xLabel=" ",yLabel=" ",title=" ";
    private boolean isGraphData=false,isDataError=false;

    public GraphData(){}

    public void initialise(double[] xv, double[] yv, String xt, String yt,
                     String tit, int shot, boolean dataError)
    {
	    x = xv;
	    y = yv;
	    xLabel = xt;
	    yLabel = yt;
	    title=tit;
	    isGraphData=true;
	    isDataError=dataError;
	    if (isDataError) isGraphData=false;
    }

    /** Return length of y data array*/
    public int getLength()
    {
     	return y.length;
    }

    /** Returns the smallest x axis data point*/
    public double getMinX()
    {
        double minX = x[0];
	for (int i=1; i<x.length; i++)
	{
	    if (x[i]<minX) minX=x[i];
	}
	return minX;
    }

    /** Returns the largest x axis data point*/
    public double getMaxX()
    {
        double maxX = x[0];
	for (int i=1; i<x.length; i++)
	{
	    if (x[i]>maxX) maxX=x[i];
	}
	return maxX;
    }

    /** Returns the smallest y axis data point*/
    public double getMinY()
    {
        double minY = y[0];
	for (int i=1; i<y.length; i++)
	{
	    if (y[i]<minY) minY=y[i];
	}
	return minY;
    }

    /** Returns the largest y axis data point*/
    public double getMaxY()
    {
        double maxY = y[0];
	for (int i=1; i<y.length; i++)
	{
	    if (y[i]>maxY) maxY=y[i];
	}
	return maxY;
    }

    // other get methods
    public double[] getX(){ return x;}
    public double[] getY(){ return y;}
    public String getXLabel(){ return xLabel;}
    public String getYLabel(){ return yLabel;}
    public String getTitle(){ return title;}
    public boolean getIsGraphData(){ return isGraphData;}
    public boolean getIsDataError(){ return isDataError;}
}
