package graphicsDomain;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;

public class DrawCentredMessage
{
    public DrawCentredMessage() {}

    public void draw(GraphMetrics metrics,  Graphics2D g2)
    {
 	g2.setColor(metrics.getGraphOptions().selectColor(
            metrics.getGraphOptions().getTitleColor()));
	g2.setStroke(metrics.getGraphOptions().getTitleStroke());

        g2.setFont(metrics.getGraphOptions().getTitleFont());

	String message = metrics.getMessage();

        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = metrics.getGraphOptions().getTitleFont().
                                 getStringBounds(message, context);
        double stringWidth = bounds.getWidth();
        double stringHeight = bounds.getHeight();

        int xp = (int)((metrics.getXSize() - stringWidth)/2.0);
        int yp = (int)(metrics.getYSize()/2. +
                     (metrics.getBorderSize() - stringHeight)/2.0);
        g2.drawString(message, xp, yp);
    }
}
