package guiDomain;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.lang.*;

/**    A dialog frame which allows a user to alter a GraphOptions object*/
public class GraphOptionsDialog extends JDialog
{
    private GraphOptions options;
    private GuiFacade parentGui;

    private ColorItemPanel titlePanel;
    private ColorItemPanel graphPanel;
    private ColorItemPanel linePanel;

    // border options
    private JRadioButton defaultBorderButton = new JRadioButton("Default");
    private JRadioButton zeroBorderButton = new JRadioButton("Zero");

    // tick number options
    private JRadioButton flexibleNumberButton = new JRadioButton("Flexible");
    private JRadioButton niceNumberButton = new JRadioButton("Nice");

    /**    The constructor receives handles to the owner frame
           and the GraphOptions object*/
    public GraphOptionsDialog(JFrame owner, GraphOptions go)
    {
        super(owner,"eScope Graph Options",true);
	parentGui = (GuiFacade) owner;
	setBounds(10,100,350,400);

	JPanel mainPanel = new JPanel();
	JPanel colorPanel = new JPanel();
        JPanel buttonPanel = new JPanel();

	options = go;
 	colorPanel.setLayout(new GridLayout(3,1));

	titlePanel = new ColorItemPanel("Graph Title",GraphOptions.colorNames);
	graphPanel = new ColorItemPanel("Background",GraphOptions.colorNames);
	linePanel = new ColorItemPanel("Plot Line",GraphOptions.colorNames);

	colorPanel.add(titlePanel);
	colorPanel.add(graphPanel);
	colorPanel.add(linePanel);

	setOptions();
	colorPanel.setBorder(new LineBorder(Color.black));

	JPanel plotPanel = new JPanel();
	plotPanel.setLayout(new GridLayout(2,1));

	JPanel borderPanel = new JPanel();
	borderPanel.setLayout(new FlowLayout());
	borderPanel.add(new JLabel("Graph Border"));
	ButtonGroup bg = new ButtonGroup();
	bg.add(defaultBorderButton);
	bg.add(zeroBorderButton);
        borderPanel.add(defaultBorderButton);
        borderPanel.add(zeroBorderButton);
	plotPanel.add(borderPanel);

	JPanel tickNumberPanel = new JPanel();
	tickNumberPanel.setLayout(new FlowLayout());
	tickNumberPanel.add(new JLabel("Tick Numbers"));
	bg = new ButtonGroup();
	bg.add(niceNumberButton);
	bg.add(flexibleNumberButton);
        tickNumberPanel.add(niceNumberButton);
        tickNumberPanel.add(flexibleNumberButton);
	plotPanel.add(tickNumberPanel);

	plotPanel.setBorder(new LineBorder(Color.black));

        JButton okButton = new JButton(new OKAction("OK"));
        JButton applyButton = new JButton(new ApplyAction("Apply"));
	JButton cancelButton = new JButton(new CancelAction("Cancel"));

        buttonPanel.add(okButton);
        buttonPanel.add(applyButton);
	buttonPanel.add(cancelButton);

	buttonPanel.setBorder(new LineBorder(Color.black));

	mainPanel.setLayout(new BorderLayout());
	mainPanel.add(colorPanel,BorderLayout.NORTH);
        mainPanel.add(plotPanel,BorderLayout.CENTER);
	mainPanel.add(buttonPanel,BorderLayout.SOUTH);

	getContentPane().add(mainPanel);
        setModal(false);
        pack();
    }

    /**    Updates the GUI display after options selected */
    public void setOptions()
    {
        titlePanel.setSelected(options.getTitleColor());
	graphPanel.setSelected(options.getGraphColor());
	linePanel.setSelected(options.getLineColor());
	if (options.getDefaultBorder())
	{   defaultBorderButton.setSelected(true);}
	else
	{   zeroBorderButton.setSelected(true);}

        if (options.getNiceNumbers())
	{   niceNumberButton.setSelected(true);}
	else
	{   flexibleNumberButton.setSelected(true);}
    }

    /**    Updates the GraphOptions object following user selection */
    public void updateOptions()
    {
        options.setTitleColor(titlePanel.getSelected());
	options.setGraphColor(graphPanel.getSelected());
	options.setLineColor(linePanel.getSelected());

	if (defaultBorderButton.isSelected())
	{    options.setDefaultBorder(true);}
	else
	{    options.setDefaultBorder(false);}

	if (niceNumberButton.isSelected())
	{   options.setNiceNumbers(true);}
	else
	{   options.setNiceNumbers(false);}
    }

    /**    Inner class which handles the OK button action */
    private class OKAction extends AbstractAction
    {
        public OKAction(String s)
        {
            super(s);
        }

        public void actionPerformed(ActionEvent event)
        {
            updateOptions();
            setVisible(false);
        }
    }
    /**    Inner class which handles the Apply button action */
    private class ApplyAction extends AbstractAction
    {
        public ApplyAction(String s)
        {
            super(s);
        }

        public void actionPerformed(ActionEvent event)
        {
            updateOptions();
	    parentGui.applyGraphOptions();
        }
    }

    /**    Inner class which handles the Cancel button action */
    private class CancelAction extends AbstractAction
    {
        public CancelAction(String s)
	{
	    super(s);
	}

	public void actionPerformed(ActionEvent event)
	{
	    setVisible(false);
	}
    }
}

