package graphicsDomain;

import java.awt.*;
import java.awt.geom.*;

//Encapsulates methods for drawing a crosshair centered on the waveform at the given X position
public class DrawCrossHair  extends GraphDecorator
{
    public DrawCrossHair(GraphMediator med) { super(med);}


    //Draw the crosshair
    public void drawThis(Graphics2D g2)
    {
	int closestGraphIdx = med.getClosestWave(); //closest waveform index
        Point[] points = med.getPixelArray
                   (med.getGraphDataArr()[closestGraphIdx].getX(), 
                    med.getGraphDataArr()[closestGraphIdx].getY());
        int xSize = med.getXSize();
        int ySize = med.getYSize();
	int currX = med.getCurrX();
 
        /* Draw cursor */
        // First find index of closest x data point
        // find closest data value from xScaled
        int minIdx = 0;
        double minDist = Math.abs(currX - points[0].x);
        double currDist = minDist;
        for (int i = 1; i < points.length; i++)
        {
            currDist = Math.abs(currX - points[i].x);
            if (currDist < minDist)
            {
                minDist = currDist;
                minIdx = i;
            }
        }
        // set xData to xVals at minimum distance
        double xdata = med.getXValue(points[minIdx].x);
        double ydata = med.getYValue(points[minIdx].y);

        //Notify listener of the update
        med.getGraphicsFacade().graphPointUpdated(xdata, ydata, true);
        // draw large cursor marker on graph
        g2.setStroke(med.getGraphOptions().getLineStroke());
        //Set the color of the crosshair equald to the color of the selected waveform
        g2.setColor(med.getGraphOptions().selectColor(med.getGraphOptions().getLineColor(closestGraphIdx)));
        Line2D xLine = new Line2D.Float(0, points[minIdx].y,
                                        xSize, points[minIdx].y);
        Line2D yLine = new Line2D.Float(points[minIdx].x, ySize,
                                        points[minIdx].x, 0);
        g2.draw(xLine);
        g2.draw(yLine);
    }
    public String toString()
    {
        return "DrawCrossHair";
    }

}
