package graphicsDomain;
import sharedDataInterfaces.GraphOptionsInterface;

import java.awt.*;

/** Adapted class. Adds various graph parameters to those returned from
    the GraphOptionsDialog.*/
public class GraphOptionsInGraphics
{
    private GraphOptionsInterface graphOptions;
    private int sigFigs,titleFontHeight,
            axisFontHeight,tickFontHeight,tickPix;
    private double textFac;
    private Font titleFont, axisFont, tickFont;
    private double maxNormalRange=10; // (Do not use sci notation inside
    private double minNormalRange=1;  //   of normal range for ticks)

    private BasicStroke lineStroke,axisStroke,titleStroke;

    public GraphOptionsInGraphics(GraphOptionsInterface options)
    {
	graphOptions = options;

        sigFigs = 3;
        titleFontHeight = 12;
        axisFontHeight = 10;
        tickFontHeight = 10;
        textFac = 0.8; // (ascent+leading)/(text-height)
        tickPix = 4; // number of pixels for tick length

        titleFont = new Font(null, Font.PLAIN, titleFontHeight);
        axisFont = new Font(null, Font.PLAIN, axisFontHeight);
        tickFont = new Font(null, Font.PLAIN, tickFontHeight);

        // stroke for waveform
        float strokeWidth = 1.0f;
        float[] solid = {12.0f,0.0f};    // Solid line style
        float[] dashed = {1.0f,5.0f};    // Dashed line style
        lineStroke = new BasicStroke( strokeWidth, BasicStroke.CAP_SQUARE,
                        BasicStroke.JOIN_MITER, 1.0f,
                        solid, 0.0f );
	// stroke for axes and ticks
        strokeWidth = 0.25f;
        axisStroke = new BasicStroke( strokeWidth, BasicStroke.CAP_SQUARE,
                        BasicStroke.JOIN_MITER, 1.0f,
                        dashed, 0.0f );
	titleStroke = axisStroke;
    }

    public void updateOptions(GraphOptionsInterface opt)
    {   graphOptions=opt;}


    public void setTickPix(int tp)
    {   tickPix = tp;}

    public int getSigFigs(){ return sigFigs;}
    public int getTitleFontHeight(){ return titleFontHeight;}
    public int getAxisFontHeight(){ return axisFontHeight;}
    public int getTickFontHeight(){ return tickFontHeight;}
    public int getTickPix(){ return tickPix;}
    public double getTextFac(){ return textFac;}
    public Font getTitleFont(){ return titleFont;}
    public Font getAxisFont(){ return axisFont;}
    public Font getTickFont(){ return tickFont;}

    public BasicStroke getLineStroke() { return lineStroke;}
    public BasicStroke getAxisStroke() { return axisStroke;}
    public BasicStroke getTitleStroke() { return titleStroke;}

    public double getMaxNormalRange()
    {
	return maxNormalRange;
    }

    public double getMinNormalRange()
    {
	return minNormalRange;
    }

    // methods delegated to GraphOptions
    public int getTitleColor()
    {   return graphOptions.getTitleColor();}

    public int getGraphColor()
    {   return graphOptions.getGraphColor();}


    public int getLineColor(int idx)
    {   return graphOptions.getLineColor(idx);}

    public int getLineColor()
    {   return getLineColor(0);}

    public Color selectColor(int i)
    {   return graphOptions.selectColor(i);}


   public Color getTickLineColor()
   {
       return Color.GRAY;
   }



    public String selectColorName(int i)
    {   return graphOptions.selectColorName(i);}

    public boolean getDefaultBorder() {return graphOptions.getDefaultBorder();}
    public boolean getNiceNumbers() {return graphOptions.getNiceNumbers();}
    public int getDisplayMode() {return graphOptions.getDisplayMode();}
    public int getZOOM() { return graphOptions.ZOOM_MODE;}
    public int getCROSSHAIR() { return graphOptions.CROSSHAIR_MODE;}
    public int getGRAB() { return graphOptions.GRAB_MODE;}
}
