package graphicsDomain;
import java.awt.*;

//Implementation of the decorator pattern
public abstract class GraphDecorator
{
    private GraphDecorator decorator=null; //decoration chain component
    protected GraphMediator med;

    public GraphDecorator(GraphMediator m) { this.med =m;}

    public void setDecorator(GraphDecorator decorator)
    {
        this.decorator = decorator;
    }

    //Draw component first, then draw this decoration
    public void draw(Graphics2D g2d)
    {

        if (decorator != null) decorator.draw(g2d);
        drawThis(g2d);
    }

    abstract public void drawThis(Graphics2D g2d);
}
