package guiDomain;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.border.*;
import java.lang.*;

import sharedDataInterfaces.*;

/**    A dialog frame which allows a user to alter a GraphOptions object*/
public class GraphOptionsDialog
    extends JDialog
{
    private GraphOptions options;
    private GuiFacade parentGui;

    private ColorItemPanel titlePanel;
    private ColorItemPanel graphPanel;
    private ColorItemPanel linePanel1;
    private ColorItemPanel linePanel2;
    private ColorItemPanel linePanel3;

    // border options
    private JRadioButton defaultBorderButton = new JRadioButton("Default");
    private JRadioButton zeroBorderButton = new JRadioButton("Zero");

    // tick number options
    private JRadioButton flexibleNumberButton = new JRadioButton("Flexible");
    private JRadioButton niceNumberButton = new JRadioButton("Nice");

    // display mode buttons
    private JRadioButton zoomButton = new JRadioButton("Zoom");
    private JRadioButton crossHairButton = new JRadioButton("CrossHair");
    private JRadioButton grabButton = new JRadioButton("Grab");

    /**    The constructor receives handles to the owner frame
           and the GraphOptions object*/
    public GraphOptionsDialog(JFrame owner, GraphOptions go)
    {
        super(owner, "eScope Graph Options", true);
        parentGui = (GuiFacade) owner;
        setBounds(10, 100, 350, 400);

        JPanel mainPanel = new JPanel();
	JPanel subPanel = new JPanel();
        JPanel colorPanel = new JPanel();
        JPanel plotPanel = new JPanel();
        JPanel mousePanel = new JPanel();
        JPanel buttonPanel = new JPanel();

        options = go;

	mainPanel.setLayout(new BorderLayout());
	subPanel.setLayout(new GridLayout(3, 1));
        colorPanel.setLayout(new GridLayout(5, 1));
        plotPanel.setLayout(new GridLayout(2, 1));
        mousePanel.setLayout(new GridLayout(2, 1));
	buttonPanel.setLayout(new BorderLayout());

        titlePanel = new ColorItemPanel("Graph Title", GraphOptions.colorNames);
        graphPanel = new ColorItemPanel("Background", GraphOptions.colorNames);
        linePanel1 = new ColorItemPanel("Plot Line 1", GraphOptions.colorNames);
        linePanel2 = new ColorItemPanel("Plot Line 2", GraphOptions.colorNames);
        linePanel3 = new ColorItemPanel("Plot Line 3", GraphOptions.colorNames);

        colorPanel.add(titlePanel);
        colorPanel.add(graphPanel);
        colorPanel.add(linePanel1);
        colorPanel.add(linePanel2);
        colorPanel.add(linePanel3);

        setOptions();
        colorPanel.setBorder(new LineBorder(Color.black));

	//plotPanel

        JPanel borderPanel = new JPanel();
        borderPanel.setLayout(new FlowLayout());
        borderPanel.add(new JLabel("Graph Border"));
        ButtonGroup bg = new ButtonGroup();
        bg.add(defaultBorderButton);
        bg.add(zeroBorderButton);
        borderPanel.add(defaultBorderButton);
        borderPanel.add(zeroBorderButton);
        plotPanel.add(borderPanel);

        JPanel tickNumberPanel = new JPanel();
        tickNumberPanel.setLayout(new FlowLayout());
        tickNumberPanel.add(new JLabel("Tick Numbers"));
        bg = new ButtonGroup();
        bg.add(niceNumberButton);
        bg.add(flexibleNumberButton);
        tickNumberPanel.add(niceNumberButton);
        tickNumberPanel.add(flexibleNumberButton);
        plotPanel.add(tickNumberPanel);
        plotPanel.setBorder(new LineBorder(Color.black));

	// mouse options panel
        JPanel displayModePanel = new JPanel();
        displayModePanel.setLayout(new FlowLayout());
        displayModePanel.add(new JLabel("Mouse mode: "));
        bg = new ButtonGroup();
        bg.add(crossHairButton);
        bg.add(zoomButton);
        bg.add(grabButton);
        displayModePanel.add(crossHairButton);
        displayModePanel.add(zoomButton);
        displayModePanel.add(grabButton);
        mousePanel.add(displayModePanel);

	JPanel infoPanel = new JPanel();
	JLabel mouseInfo = new JLabel("(Double click for default view)");
	infoPanel.add(mouseInfo);

	mousePanel.add(infoPanel);
        mousePanel.setBorder(new LineBorder(Color.black));

	// button panel
        JButton okButton = new JButton(new OKAction("OK"));
        JButton applyButton = new JButton(new ApplyAction("Apply"));
        JButton cancelButton = new JButton(new CancelAction("Cancel"));

	JPanel buttons = new JPanel();

        buttons.add(okButton);
        buttons.add(applyButton);
        buttons.add(cancelButton);
	buttonPanel.add(buttons,"South");

        buttonPanel.setBorder(new LineBorder(Color.black));

        subPanel.add(colorPanel);
        subPanel.add(plotPanel);
	subPanel.add(mousePanel);

	mainPanel.add(subPanel,"North");

        mainPanel.add(buttonPanel,"South");


        getContentPane().add(mainPanel);
        setModal(false);
        pack();
    }

    /**    Updates the GUI display after options selected */
    public void setOptions()
    {
        titlePanel.setSelected(options.getTitleColor());
        graphPanel.setSelected(options.getGraphColor());
        linePanel1.setSelected(options.getLineColor(0));
        linePanel2.setSelected(options.getLineColor(1));
        linePanel3.setSelected(options.getLineColor(2));
        if (options.getDefaultBorder())
        {
            defaultBorderButton.setSelected(true);
        }
        else
        {
            zeroBorderButton.setSelected(true);
        }

        if (options.getNiceNumbers())
        {
            niceNumberButton.setSelected(true);
        }
        else
        {
            flexibleNumberButton.setSelected(true);
        }
        switch(options.getDisplayMode())
        {
            case GraphOptionsInterface.ZOOM_MODE:
                zoomButton.setSelected(true);
                break;
            case GraphOptionsInterface.CROSSHAIR_MODE:
                crossHairButton.setSelected(true);
                break;
            case GraphOptionsInterface.GRAB_MODE:
                grabButton.setSelected(true);
                break;
        }

    }

    /**    Updates the GraphOptions object following user selection */
    public void updateOptions()
    {
        options.setTitleColor(titlePanel.getSelected());
        options.setGraphColor(graphPanel.getSelected());
        options.setLineColor(linePanel1.getSelected(), 0);
        options.setLineColor(linePanel2.getSelected(), 1);
        options.setLineColor(linePanel3.getSelected(),2);

        if (defaultBorderButton.isSelected())
        {
            options.setDefaultBorder(true);
        }
        else
        {
            options.setDefaultBorder(false);
        }

        if (niceNumberButton.isSelected())
        {
            options.setNiceNumbers(true);
        }
        else
        {
            options.setNiceNumbers(false);
        }
        if(zoomButton.isSelected())
            options.setDisplayMode(GraphOptionsInterface.ZOOM_MODE);
        if(crossHairButton.isSelected())
            options.setDisplayMode(GraphOptionsInterface.CROSSHAIR_MODE);
        if(grabButton.isSelected())
           options.setDisplayMode(GraphOptionsInterface.GRAB_MODE);
    }

    /**    Inner class which handles the OK button action */
    private class OKAction
        extends AbstractAction
    {
        public OKAction(String s)
        {
            super(s);
        }

        public void actionPerformed(ActionEvent event)
        {
            updateOptions();
            setVisible(false);
        }
    }

    /**    Inner class which handles the Apply button action */
    private class ApplyAction
        extends AbstractAction
    {
        public ApplyAction(String s)
        {
            super(s);
        }

        public void actionPerformed(ActionEvent event)
        {
            updateOptions();
            parentGui.applyGraphOptions();
        }
    }

    /**    Inner class which handles the Cancel button action */
    private class CancelAction
        extends AbstractAction
    {
        public CancelAction(String s)
        {
            super(s);
        }

        public void actionPerformed(ActionEvent event)
        {
            setVisible(false);
        }
    }
}

