package graphicsDomain;

import java.awt.*;
import java.awt.geom.*;
import java.awt.font.*;

public class DrawLabels  extends GraphDecorator
{
    public DrawLabels(GraphMediator med) { super(med);}

    public void drawThis(Graphics2D g2)
    {
	g2.setColor(med.getGraphOptions().selectColor(
            med.getGraphOptions().getTitleColor()));
	g2.setStroke(med.getGraphOptions().getTitleStroke());

	int xSize = med.getXSize();
	int ySize = med.getYSize();
	int borderSize = med.getBorderSize();
	double textFac = med.getGraphOptions().getTextFac();


        // Graph Title
	Font titleFont=med.getGraphOptions().getTitleFont();
        g2.setFont(titleFont);//find size of label
	String title = med.getGraphData().getTitle();
        FontRenderContext context = g2.getFontRenderContext();
        Rectangle2D bounds = titleFont.getStringBounds(title, context);
        double stringWidth = bounds.getWidth();
        double stringHeight = bounds.getHeight();

        int xp = (int)((xSize - stringWidth)/2.0);
        int yp = (int)((borderSize - stringHeight)/2.0 + textFac*stringHeight);
	if (borderSize<stringHeight)
	    yp = (int)(textFac*stringHeight);
        g2.drawString(title, xp, yp);

	Font axisFont = med.getGraphOptions().getAxisFont();
        g2.setFont(axisFont);
        /* Draw X-axis label */
        context = g2.getFontRenderContext();
	String xLabel = med.getGraphData().getFullXLabel();
        bounds =
	   axisFont.getStringBounds(xLabel, context);
        stringWidth = bounds.getWidth();
        stringHeight = bounds.getHeight();

        xp = (int)((xSize  - stringWidth)/2.0);
        yp = (int)(ySize - 1.25*stringHeight + textFac*stringHeight);
        g2.drawString(xLabel, xp, yp);

        /* Draw Y-axis label */
	String yLabel = med.getGraphData().getFullYLabel();
        bounds = axisFont.getStringBounds(yLabel, context);
        stringWidth = bounds.getWidth();
        stringHeight = bounds.getHeight();

        xp = (int)(stringHeight*0.5+ stringHeight*textFac);
        yp = (int)(ySize - (ySize - stringWidth)/2.0);
        // rotate graphics context; draw the message; rotate back
        g2.rotate(-90.0*Math.PI/180.,xp,yp);
        g2.drawString(yLabel, xp, yp);
        g2.rotate(+90.0*Math.PI/180.,xp,yp);
    }

    public String toString()
    {
        return "DrawLabels";
    }
}
