package graphicsDomain;

import java.awt.*;
import java.awt.geom.Line2D;

public class DrawWaveform extends GraphDecorator
{
    private int nWave; // index of this dataset

    public DrawWaveform(GraphMediator med, int nw) 
    { 
	super(med);
	nWave = nw;
    }
   
    
    public void drawThis(Graphics2D g2)
    {
            Point[] points = med.getPixelArray(
                             med.getGraphDataArr()[nWave].getX(), 
                             med.getGraphDataArr()[nWave].getY());
            g2.setStroke(med.getGraphOptions().getLineStroke());
            g2.setColor(med.getGraphOptions().selectColor(
                med.getGraphOptions().getLineColor(nWave)));

            int xSize = med.getXSize();
            for (int i = 0; i < points.length - 1; i++)
            {
                if (points[i + 1].x < 0 || points[i].x > xSize)
                continue;
                Line2D line = new Line2D.Float(points[i].x, points[i].y,
                                       points[i + 1].x, points[i + 1].y);
                g2.draw(line);

            }
    }
    public String toString()
    {
        return "DrawWaveform";
    }

}

