import javax.swing.tree.DefaultMutableTreeNode;

/**
Stores tree node data retrieved from the MDSPlus server
Extends DefaultMutableTreeNode to store the node type and
overrides toString for node rendering
*/

public class MDSTreeNode extends DefaultMutableTreeNode
{
    public static final int TYPE_TOP    = 0;
    public static final int TYPE_MEMBER = 1;
    public static final int TYPE_CHILD  = 2;

    private String name;
    private int type;

    /**
    Creates a new tree node with no child or member nodes
    @param _name The name of this node
    @param _type The type of this node (top, member or child)
    */
    public MDSTreeNode(String _name, int _type)
    {
	super();
        name = _name;
        type = _type;
    }

    public MDSTreeNode()
    {
        super();
    }

    public String getName()
    {
        return name;
    }

    public int getType()
    {
        return type;
    }

    /**
    The name of this node, with a ':' if node is a member, or a '.' if node is a child
    @return A text representation of this node
    */
    public String toString()
    {
        if ( type == TYPE_MEMBER )
        {
            return ":" + name;

        }
        else if ( type == TYPE_CHILD )
        {
            return "." + name;

        }
        else
	{ //top node
            return name;
        }
    }
}

